var N = null;var searchIndex = {};
searchIndex["aho_corasick"]={"doc":"An implementation of the Aho-Corasick string search algorithm.","items":[[3,"Match","aho_corasick","Records a match in the search text.",N,N],[12,"pati","","The pattern index.",0,N],[12,"start","","The starting byte offset of the match in the search text.",0,N],[12,"end","","The ending byte offset of the match in the search text.",0,N],[3,"Matches","","An iterator of non-overlapping matches for in-memory text.",N,N],[12,"aut","","",1,N],[12,"text","","",1,N],[12,"texti","","",1,N],[12,"si","","",1,N],[12,"_m","","",1,N],[3,"MatchesOverlapping","","An iterator of overlapping matches for in-memory text.",N,N],[12,"aut","","",2,N],[12,"text","","",2,N],[12,"texti","","",2,N],[12,"si","","",2,N],[12,"outi","","",2,N],[12,"_m","","",2,N],[3,"StreamMatches","","An iterator of non-overlapping matches for streaming text.",N,N],[12,"aut","","",3,N],[12,"buf","","",3,N],[12,"texti","","",3,N],[12,"si","","",3,N],[12,"_m","","",3,N],[3,"StreamMatchesOverlapping","","An iterator of overlapping matches for streaming text.",N,N],[12,"aut","","",4,N],[12,"buf","","",4,N],[12,"texti","","",4,N],[12,"si","","",4,N],[12,"outi","","",4,N],[12,"_m","","",4,N],[3,"FullAcAutomaton","","A complete Aho-Corasick automaton.",N,N],[12,"pats","","",5,N],[12,"trans","","",5,N],[12,"out","","",5,N],[12,"start_bytes","","",5,N],[3,"AcAutomaton","","An Aho-Corasick finite automaton.",N,N],[12,"pats","","",6,N],[12,"states","","",6,N],[12,"start_bytes","","",6,N],[3,"State","","",N,N],[12,"out","","",7,N],[12,"fail","","",7,N],[12,"goto","","",7,N],[12,"depth","","",7,N],[3,"AllBytesIter","","",N,N],[12,"0","","",8,N],[3,"Dense","","State transitions that can be stored either sparsely or densely.",N,N],[12,"0","","",9,N],[3,"Sparse","","State transitions that are always sparse.",N,N],[12,"0","","",10,N],[4,"DenseChoice","","",N,N],[13,"Sparse","","",11,N],[13,"Dense","","",11,N],[5,"vec_bytes","","",N,[[],["usize"]]],[5,"usize_bytes","","",N,[[],["usize"]]],[0,"autiter","","",N,N],[3,"Match","aho_corasick::autiter","Records a match in the search text.",N,N],[12,"pati","","The pattern index.",0,N],[12,"start","","The starting byte offset of the match in the search text.",0,N],[12,"end","","The ending byte offset of the match in the search text.",0,N],[3,"Matches","","An iterator of non-overlapping matches for in-memory text.",N,N],[12,"aut","","",1,N],[12,"text","","",1,N],[12,"texti","","",1,N],[12,"si","","",1,N],[12,"_m","","",1,N],[3,"StreamMatches","","An iterator of non-overlapping matches for streaming text.",N,N],[12,"aut","","",3,N],[12,"buf","","",3,N],[12,"texti","","",3,N],[12,"si","","",3,N],[12,"_m","","",3,N],[3,"MatchesOverlapping","","An iterator of overlapping matches for in-memory text.",N,N],[12,"aut","","",2,N],[12,"text","","",2,N],[12,"texti","","",2,N],[12,"si","","",2,N],[12,"outi","","",2,N],[12,"_m","","",2,N],[3,"StreamMatchesOverlapping","","An iterator of overlapping matches for streaming text.",N,N],[12,"aut","","",4,N],[12,"buf","","",4,N],[12,"texti","","",4,N],[12,"si","","",4,N],[12,"outi","","",4,N],[12,"_m","","",4,N],[5,"step_to_match","","",N,N],[5,"skip_to_match","","",N,N],[5,"skip1","","",N,N],[5,"skip2","","",N,N],[5,"skip3","","",N,N],[8,"Automaton","","An abstraction over automatons and their corresponding iterators. The type parameter `P` is the type of the pattern that was used to construct this Automaton.",N,N],[10,"next_state","","Return the next state given the current state and next character.",12,[[["self"],["stateidx"],["u8"]],["stateidx"]]],[10,"has_match","","Return true if and only if the given state and current pattern index indicate a match.",12,[[["self"],["stateidx"],["usize"]],["bool"]]],[10,"get_match","","Build a match given the current state, pattern index and input index.",12,[[["self"],["stateidx"],["usize"],["usize"]],["match"]]],[10,"start_bytes","","Return the set of bytes that have transitions in the root state.",12,N],[10,"patterns","","Returns all of the patterns matched by this automaton.",12,N],[10,"pattern","","Returns the pattern indexed at `i`.",12,[[["self"],["usize"]],["p"]]],[11,"len","","Return the number of patterns in the automaton.",12,[[["self"]],["usize"]]],[11,"is_empty","","Returns true if the automaton has no patterns.",12,[[["self"]],["bool"]]],[11,"find","","Returns an iterator of non-overlapping matches in `s`.",12,[[["self"],["q"]],["matches"]]],[11,"find_overlapping","","Returns an iterator of overlapping matches in `s`.",12,[[["self"],["q"]],["matchesoverlapping"]]],[11,"stream_find","","Returns an iterator of non-overlapping matches in the given reader.",12,[[["self"],["r"]],["streammatches"]]],[11,"stream_find_overlapping","","Returns an iterator of overlapping matches in the given reader.",12,[[["self"],["r"]],["streammatchesoverlapping"]]],[11,"clone","aho_corasick","",0,[[["self"]],["match"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"hash","","",0,N],[11,"eq","","",0,[[["self"],["match"]],["bool"]]],[11,"ne","","",0,[[["self"],["match"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",0,N],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"next","","",1,[[["self"]],["option",["match"]]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"next","","",3,[[["self"]],["option",["result"]]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"next","","",2,[[["self"]],["option",["match"]]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"next","","",4,[[["self"]],["option",["result"]]]],[0,"full","","",N,N],[3,"FullAcAutomaton","aho_corasick::full","A complete Aho-Corasick automaton.",N,N],[12,"pats","","",5,N],[12,"trans","","",5,N],[12,"out","","",5,N],[12,"start_bytes","","",5,N],[11,"clone","aho_corasick","",5,[[["self"]],["fullacautomaton"]]],[11,"new","","Build a new expanded Aho-Corasick automaton from an existing Aho-Corasick automaton.",5,[[["acautomaton"]],["fullacautomaton"]]],[11,"memory_usage","","",5,[[["self"]],["usize"]]],[11,"heap_bytes","","",5,[[["self"]],["usize"]]],[11,"set","","",5,[[["self"],["stateidx"],["u8"],["stateidx"]]]],[11,"num_states","","",5,[[["self"]],["usize"]]],[11,"next_state","","",5,[[["self"],["stateidx"],["u8"]],["stateidx"]]],[11,"get_match","","",5,[[["self"],["stateidx"],["usize"],["usize"]],["match"]]],[11,"has_match","","",5,[[["self"],["stateidx"],["usize"]],["bool"]]],[11,"start_bytes","","",5,N],[11,"patterns","","",5,N],[11,"pattern","","",5,[[["self"],["usize"]],["p"]]],[11,"build_matrix","","",5,[[["self"],["acautomaton"]]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[6,"StateIdx","","The integer type used for the state index.",N,N],[17,"FAIL_STATE","","",N,N],[17,"ROOT_STATE","","",N,N],[17,"DENSE_DEPTH_THRESHOLD","","",N,N],[8,"Automaton","","An abstraction over automatons and their corresponding iterators. The type parameter `P` is the type of the pattern that was used to construct this Automaton.",N,N],[10,"next_state","","Return the next state given the current state and next character.",12,[[["self"],["stateidx"],["u8"]],["stateidx"]]],[10,"has_match","","Return true if and only if the given state and current pattern index indicate a match.",12,[[["self"],["stateidx"],["usize"]],["bool"]]],[10,"get_match","","Build a match given the current state, pattern index and input index.",12,[[["self"],["stateidx"],["usize"],["usize"]],["match"]]],[10,"start_bytes","","Return the set of bytes that have transitions in the root state.",12,N],[10,"patterns","","Returns all of the patterns matched by this automaton.",12,N],[10,"pattern","","Returns the pattern indexed at `i`.",12,[[["self"],["usize"]],["p"]]],[11,"len","aho_corasick::autiter","Return the number of patterns in the automaton.",12,[[["self"]],["usize"]]],[11,"is_empty","","Returns true if the automaton has no patterns.",12,[[["self"]],["bool"]]],[11,"find","","Returns an iterator of non-overlapping matches in `s`.",12,[[["self"],["q"]],["matches"]]],[11,"find_overlapping","","Returns an iterator of overlapping matches in `s`.",12,[[["self"],["q"]],["matchesoverlapping"]]],[11,"stream_find","","Returns an iterator of non-overlapping matches in the given reader.",12,[[["self"],["r"]],["streammatches"]]],[11,"stream_find_overlapping","","Returns an iterator of overlapping matches in the given reader.",12,[[["self"],["r"]],["streammatchesoverlapping"]]],[8,"Transitions","aho_corasick","An abstraction over state transition strategies.",N,N],[10,"new","","Return a new state at the given depth.",13,[[["u32"]],["self"]]],[10,"goto","","Return the next state index given the next character.",13,[[["self"],["u8"]],["stateidx"]]],[10,"set_goto","","Set the next state index for the character given.",13,[[["self"],["u8"],["stateidx"]]]],[10,"heap_bytes","","The memory use in bytes (on the heap) of this set of transitions.",13,[[["self"]],["usize"]]],[11,"clone","","",6,[[["self"]],["acautomaton"]]],[11,"clone","","",7,[[["self"]],["state"]]],[11,"new","","Create a new automaton from an iterator of patterns.",6,[[["i"]],["acautomaton",["dense"]]]],[11,"with_transitions","","Create a new automaton from an iterator of patterns.",6,[[["i"]],["acautomaton"]]],[11,"into_full","","Build out the entire automaton into a single matrix.",6,[[["self"]],["fullacautomaton"]]],[11,"num_states","","",6,[[["self"]],["usize"]]],[11,"heap_bytes","","",6,[[["self"]],["usize"]]],[11,"memoized_next_state","","",6,[[["self"],["fullacautomaton"],["stateidx"],["u8"]],["stateidx"]]],[11,"next_state","","",6,[[["self"],["stateidx"],["u8"]],["stateidx"]]],[11,"get_match","","",6,[[["self"],["stateidx"],["usize"],["usize"]],["match"]]],[11,"has_match","","",6,[[["self"],["stateidx"],["usize"]],["bool"]]],[11,"start_bytes","","",6,N],[11,"patterns","","",6,N],[11,"pattern","","",6,[[["self"],["usize"]],["p"]]],[11,"next","","",8,[[["self"]],["option"]]],[11,"new","","",8,[[],["allbytesiter"]]],[11,"build","","",6,[[["self"],["vec"]],["acautomaton"]]],[11,"fill","","",6,[[["self"]],["acautomaton"]]],[11,"add_state","","",6,[[["self"],["state"]],["stateidx"]]],[11,"new","","",7,[[["u32"]],["state"]]],[11,"goto","","",7,[[["self"],["u8"]],["stateidx"]]],[11,"set_goto","","",7,[[["self"],["u8"],["stateidx"]]]],[11,"heap_bytes","","",7,[[["self"]],["usize"]]],[11,"clone","","",9,[[["self"]],["dense"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"clone","","",11,[[["self"]],["densechoice"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"new","","",9,[[["u32"]],["dense"]]],[11,"goto","","",9,[[["self"],["u8"]],["stateidx"]]],[11,"set_goto","","",9,[[["self"],["u8"],["stateidx"]]]],[11,"heap_bytes","","",9,[[["self"]],["usize"]]],[11,"clone","","",10,[[["self"]],["sparse"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"new","","",10,[[["u32"]],["sparse"]]],[11,"goto","","",10,[[["self"],["u8"]],["stateidx"]]],[11,"set_goto","","",10,[[["self"],["u8"],["stateidx"]]]],[11,"heap_bytes","","",10,[[["self"]],["usize"]]],[11,"from_iter","","Create an automaton from an iterator of strings.",6,[[["t"]],["acautomaton"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"debug","","",7,[[["self"],["bool"]],["string"]]],[11,"goto_string","","",7,[[["self"],["bool"]],["string"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"dot","","",6,[[["self"]],["string"]]]],"paths":[[3,"Match"],[3,"Matches"],[3,"MatchesOverlapping"],[3,"StreamMatches"],[3,"StreamMatchesOverlapping"],[3,"FullAcAutomaton"],[3,"AcAutomaton"],[3,"State"],[3,"AllBytesIter"],[3,"Dense"],[3,"Sparse"],[4,"DenseChoice"],[8,"Automaton"],[8,"Transitions"]]};
searchIndex["arena"]={"doc":"The arena, a fast but limited type of allocator.","items":[[3,"TypedArena","arena","An arena that can hold objects of only one type.",N,N],[12,"ptr","","A pointer to the next object to be allocated.",0,N],[12,"end","","A pointer to the end of the allocated area. When this pointer is reached, a new chunk is allocated.",0,N],[12,"chunks","","A vector of arena chunks.",0,N],[12,"_own","","Marker indicating that dropping the arena causes its owned instances of `T` to be dropped.",0,N],[3,"TypedArenaChunk","","",N,N],[12,"storage","","The raw storage for the arena chunk.",1,N],[3,"DroplessArena","","",N,N],[12,"ptr","","A pointer to the next object to be allocated.",2,N],[12,"end","","A pointer to the end of the allocated area. When this pointer is reached, a new chunk is allocated.",2,N],[12,"chunks","","A vector of arena chunks.",2,N],[3,"SyncTypedArena","","",N,N],[12,"lock","","",3,N],[3,"SyncDroplessArena","","",N,N],[12,"lock","","",4,N],[17,"PAGE","","",N,N],[11,"new","","",1,[[["usize"]],["typedarenachunk"]]],[11,"destroy","","Destroys this arena chunk.",1,[[["self"],["usize"]]]],[11,"start","","",1,N],[11,"end","","",1,N],[11,"new","","Creates a new `TypedArena`.",0,[[],["typedarena"]]],[11,"alloc","","Allocates an object in the `TypedArena`, returning a reference to it.",0,[[["self"],["t"]],["t"]]],[11,"alloc_slice","","Allocates a slice of objects that are copied into the `TypedArena`, returning a mutable reference to it. Will panic if passed a zero-sized types.",0,N],[11,"grow","","Grows the arena.",0,[[["self"],["usize"]]]],[11,"clear","","Clears the arena. Deallocates all but the longest chunk which may be reused.",0,[[["self"]]]],[11,"clear_last_chunk","","",0,[[["self"],["typedarenachunk"]]]],[11,"drop","","",0,[[["self"]]]],[11,"new","","",2,[[],["droplessarena"]]],[11,"in_arena","","",2,N],[11,"align","","",2,[[["self"],["usize"]]]],[11,"grow","","",2,[[["self"],["usize"]]]],[11,"alloc_raw","","",2,N],[11,"alloc","","",2,[[["self"],["t"]],["t"]]],[11,"alloc_slice","","Allocates a slice of objects that are copied into the `DroplessArena`, returning a mutable reference to it. Will panic if passed a zero-sized type.",2,N],[11,"new","","",3,[[],["synctypedarena"]]],[11,"alloc","","",3,[[["self"],["t"]],["t"]]],[11,"alloc_slice","","",3,N],[11,"clear","","",3,[[["self"]]]],[11,"new","","",4,[[],["syncdroplessarena"]]],[11,"in_arena","","",4,N],[11,"alloc_raw","","",4,N],[11,"alloc","","",4,[[["self"],["t"]],["t"]]],[11,"alloc_slice","","",4,N]],"paths":[[3,"TypedArena"],[3,"TypedArenaChunk"],[3,"DroplessArena"],[3,"SyncTypedArena"],[3,"SyncDroplessArena"]]};
searchIndex["bitflags"]={"doc":"A typesafe bitmask flag generator useful for sets of C-style bitmask flags. It can be used for creating typesafe wrappers around C APIs.","items":[[0,"example_generated","bitflags","This module shows an example of code generated by the macro. IT MUST NOT BE USED OUTSIDE THIS CRATE.",N,N],[3,"Flags","bitflags::example_generated","This is the same `Flags` struct defined in the crate level example. Note that this struct is just for documentation purposes only, it must not be used outside this crate.",N,N],[12,"bits","","",0,N],[17,"FLAG_A","","",N,N],[17,"FLAG_B","","",N,N],[17,"FLAG_C","","",N,N],[17,"FLAG_ABC","","",N,N],[11,"eq","","",0,[[["self"],["flags"]],["bool"]]],[11,"ne","","",0,[[["self"],["flags"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",0,N],[11,"clone","","",0,[[["self"]],["flags"]]],[11,"partial_cmp","","",0,[[["self"],["flags"]],["option",["ordering"]]]],[11,"lt","","",0,[[["self"],["flags"]],["bool"]]],[11,"le","","",0,[[["self"],["flags"]],["bool"]]],[11,"gt","","",0,[[["self"],["flags"]],["bool"]]],[11,"ge","","",0,[[["self"],["flags"]],["bool"]]],[11,"cmp","","",0,[[["self"],["flags"]],["ordering"]]],[11,"hash","","",0,N],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"empty","","Returns an empty set of flags.",0,[[],["flags"]]],[11,"all","","Returns the set containing all flags.",0,[[],["flags"]]],[11,"bits","","Returns the raw value of the flags currently stored.",0,[[["self"]],["u32"]]],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",0,[[["u32"]],["option",["flags"]]]],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",0,[[["u32"]],["flags"]]],[11,"is_empty","","Returns `true` if no flags are currently stored.",0,[[["self"]],["bool"]]],[11,"is_all","","Returns `true` if all flags are currently set.",0,[[["self"]],["bool"]]],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",0,[[["self"],["flags"]],["bool"]]],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",0,[[["self"],["flags"]],["bool"]]],[11,"insert","","Inserts the specified flags in-place.",0,[[["self"],["flags"]]]],[11,"remove","","Removes the specified flags in-place.",0,[[["self"],["flags"]]]],[11,"toggle","","Toggles the specified flags in-place.",0,[[["self"],["flags"]]]],[11,"set","","Inserts or removes the specified flags depending on the passed value.",0,[[["self"],["flags"],["bool"]]]],[11,"bitor","","Returns the union of the two sets of flags.",0,[[["self"],["flags"]],["flags"]]],[11,"bitor_assign","","Adds the set of flags.",0,[[["self"],["flags"]]]],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",0,[[["self"],["flags"]],["flags"]]],[11,"bitxor_assign","","Toggles the set of flags.",0,[[["self"],["flags"]]]],[11,"bitand","","Returns the intersection between the two sets of flags.",0,[[["self"],["flags"]],["flags"]]],[11,"bitand_assign","","Disables all flags disabled in the set.",0,[[["self"],["flags"]]]],[11,"sub","","Returns the set difference of the two sets of flags.",0,[[["self"],["flags"]],["flags"]]],[11,"sub_assign","","Disables all flags enabled in the set.",0,[[["self"],["flags"]]]],[11,"not","","Returns the complement of this set of flags.",0,[[["self"]],["flags"]]],[11,"extend","","",0,[[["self"],["t"]]]],[11,"from_iter","","",0,[[["t"]],["flags"]]],[14,"bitflags","bitflags","The macro used to generate the flag structure.",N,N],[14,"__impl_bitflags","","",N,N]],"paths":[[3,"Flags"]]};
searchIndex["fmt_macros"]={"doc":"Macro support for format strings","items":[[3,"Argument","fmt_macros","Representation of an argument specification.",N,N],[12,"position","","Where to find this argument",0,N],[12,"format","","How to format the argument",0,N],[3,"FormatSpec","","Specification for the formatting of an argument in the format string.",N,N],[12,"fill","","Optionally specified character to fill alignment with",1,N],[12,"align","","Optionally specified alignment",1,N],[12,"flags","","Packed version of various flags provided",1,N],[12,"precision","","The integer precision to use",1,N],[12,"width","","The string width requested for the resulting format",1,N],[12,"ty","","The descriptor string representing the name of the format desired for this argument, this can be empty or any number of characters, although it is required to be one word.",1,N],[3,"ParseError","","",N,N],[12,"description","","",2,N],[12,"note","","",2,N],[12,"label","","",2,N],[12,"start","","",2,N],[12,"end","","",2,N],[3,"Parser","","The parser structure for interpreting the input format string. This is modeled as an iterator over `Piece` structures to form a stream of tokens being output.",N,N],[12,"input","","",3,N],[12,"cur","","",3,N],[12,"errors","","Error messages accumulated during parsing",3,N],[12,"curarg","","Current position of implicit positional argument pointer",3,N],[12,"style","","`Some(raw count)` when the string is \"raw\", used to position spans correctly",3,N],[12,"seen_newlines","","How many newlines have been seen in the string so far, to adjust the error spans",3,N],[12,"arg_places","","Start and end byte offset of every successfuly parsed argument",3,N],[4,"Piece","","A piece is a portion of the format string which represents the next part to emit. These are emitted as a stream by the `Parser` class.",N,N],[13,"String","","A literal string which should directly be emitted",4,N],[13,"NextArgument","","This describes that formatting should process the next argument (as specified inside) for emission.",4,N],[4,"Position","","Enum describing where an argument for a format can be located.",N,N],[13,"ArgumentImplicitlyIs","","The argument is implied to be located at an index",5,N],[13,"ArgumentIs","","The argument is located at a specific index given in the format",5,N],[13,"ArgumentNamed","","The argument has a name.",5,N],[4,"Alignment","","Enum of alignments which are supported.",N,N],[13,"AlignLeft","","The value will be aligned to the left.",6,N],[13,"AlignRight","","The value will be aligned to the right.",6,N],[13,"AlignCenter","","The value will be aligned in the center.",6,N],[13,"AlignUnknown","","The value will take on a default alignment.",6,N],[4,"Flag","","Various flags which can be applied to format strings. The meaning of these flags is defined by the formatters themselves.",N,N],[13,"FlagSignPlus","","A `+` will be used to denote positive numbers.",7,N],[13,"FlagSignMinus","","A `-` will be used to denote negative numbers. This is the default.",7,N],[13,"FlagAlternate","","An alternate form will be used for the value. In the case of numbers, this means that the number will be prefixed with the supplied string.",7,N],[13,"FlagSignAwareZeroPad","","For numbers, this means that the number will be padded with zeroes, and the sign (`+` or `-`) will precede them.",7,N],[13,"FlagDebugLowerHex","","For Debug / `?`, format integers in lower-case hexadecimal.",7,N],[13,"FlagDebugUpperHex","","For Debug / `?`, format integers in upper-case hexadecimal.",7,N],[4,"Count","","A count is used for the precision and width parameters of an integer, and can reference either an argument or a literal integer.",N,N],[13,"CountIs","","The count is specified explicitly.",8,N],[13,"CountIsName","","The count is specified by the argument with the given name.",8,N],[13,"CountIsParam","","The count is specified by the argument at the given index.",8,N],[13,"CountImplied","","The count is implied and cannot be explicitly specified.",8,N],[11,"clone","","",4,[[["self"]],["piece"]]],[11,"eq","","",4,[[["self"],["piece"]],["bool"]]],[11,"ne","","",4,[[["self"],["piece"]],["bool"]]],[11,"clone","","",0,[[["self"]],["argument"]]],[11,"eq","","",0,[[["self"],["argument"]],["bool"]]],[11,"ne","","",0,[[["self"],["argument"]],["bool"]]],[11,"clone","","",1,[[["self"]],["formatspec"]]],[11,"eq","","",1,[[["self"],["formatspec"]],["bool"]]],[11,"ne","","",1,[[["self"],["formatspec"]],["bool"]]],[11,"clone","","",5,[[["self"]],["position"]]],[11,"eq","","",5,[[["self"],["position"]],["bool"]]],[11,"ne","","",5,[[["self"],["position"]],["bool"]]],[11,"clone","","",6,[[["self"]],["alignment"]]],[11,"eq","","",6,[[["self"],["alignment"]],["bool"]]],[11,"clone","","",7,[[["self"]],["flag"]]],[11,"eq","","",7,[[["self"],["flag"]],["bool"]]],[11,"clone","","",8,[[["self"]],["count"]]],[11,"eq","","",8,[[["self"],["count"]],["bool"]]],[11,"ne","","",8,[[["self"],["count"]],["bool"]]],[11,"next","","",3,[[["self"]],["option",["piece"]]]],[11,"new","","Creates a new parser for the given format string",3,[[["str"],["option",["usize"]]],["parser"]]],[11,"err","","Notifies of an error. The message doesn't actually need to be of type String, but I think it does when this eventually uses conditions so it might as well start using it now.",3,[[["self"],["s1"],["s2"],["usize"],["usize"]]]],[11,"err_with_note","","Notifies of an error. The message doesn't actually need to be of type String, but I think it does when this eventually uses conditions so it might as well start using it now.",3,[[["self"],["s1"],["s2"],["s3"],["usize"],["usize"]]]],[11,"consume","","Optionally consumes the specified character. If the character is not at the current position, then the current iterator isn't moved and false is returned, otherwise the character is consumed and true is returned.",3,[[["self"],["char"]],["bool"]]],[11,"must_consume","","Forces consumption of the specified character. If the character is not found, an error is emitted.",3,[[["self"],["char"]],["option",["usize"]]]],[11,"ws","","Consumes all whitespace characters until the first non-whitespace character",3,[[["self"]]]],[11,"string","","Parses all of a string which is to be considered a \"raw literal\" in a format string. This is everything outside of the braces.",3,[[["self"],["usize"]],["str"]]],[11,"argument","","Parses an Argument structure, or what's contained within braces inside the format string",3,[[["self"]],["argument"]]],[11,"position","","Parses a positional argument for a format. This could either be an integer index of an argument, a named argument, or a blank string. Returns `Some(parsed_position)` if the position is not implicitly consuming a macro argument, `None` if it's the case.",3,[[["self"]],["option",["position"]]]],[11,"format","","Parses a format specifier at the current position, returning all of the relevant information in the FormatSpec struct.",3,[[["self"]],["formatspec"]]],[11,"count","","Parses a Count parameter at the current position. This does not check for 'CountIsNextParam' because that is only used in precision, not width.",3,[[["self"]],["count"]]],[11,"word","","Parses a word starting at the current position. A word is considered to be an alphabetic character followed by any number of alphanumeric characters.",3,[[["self"]],["str"]]],[11,"integer","","Optionally parses an integer at the current position. This doesn't deal with overflow at all, it's just accumulating digits.",3,[[["self"]],["option",["usize"]]]]],"paths":[[3,"Argument"],[3,"FormatSpec"],[3,"ParseError"],[3,"Parser"],[4,"Piece"],[4,"Position"],[4,"Alignment"],[4,"Flag"],[4,"Count"]]};
searchIndex["graphviz"]={"doc":"Generate files suitable for use with Graphviz","items":[[3,"Id","graphviz","`Id` is a Graphviz `ID`.",N,N],[12,"name","","",0,N],[4,"LabelText","","The text for a graphviz label on a node or edge.",N,N],[13,"LabelStr","","This kind of label preserves the text directly as is.",1,N],[13,"EscStr","","This kind of label uses the graphviz label escString type: http://www.graphviz.org/content/attrs#kescString",1,N],[13,"HtmlStr","","This uses a graphviz [HTML string label][html]. The string is printed exactly as given, but between `<` and `>`. No escaping is performed.",1,N],[4,"Style","","The style for a node or edge. See http://www.graphviz.org/doc/info/attrs.html#k:style for descriptions. Note that some of these are not valid for edges.",N,N],[13,"None","","",2,N],[13,"Solid","","",2,N],[13,"Dashed","","",2,N],[13,"Dotted","","",2,N],[13,"Bold","","",2,N],[13,"Rounded","","",2,N],[13,"Diagonals","","",2,N],[13,"Filled","","",2,N],[13,"Striped","","",2,N],[13,"Wedged","","",2,N],[4,"RenderOption","","",N,N],[13,"NoEdgeLabels","","",3,N],[13,"NoNodeLabels","","",3,N],[13,"NoEdgeStyles","","",3,N],[13,"NoNodeStyles","","",3,N],[5,"escape_html","","Escape tags in such a way that it is suitable for inclusion in a Graphviz HTML label.",N,[[["str"]],["string"]]],[5,"default_options","","Returns vec holding all the default render options.",N,[[],["vec",["renderoption"]]]],[5,"render","","Renders directed graph `g` into the writer `w` in DOT syntax. (Simple wrapper around `render_opts` that passes a default set of options.)",N,[[["g"],["w"]],["result"]]],[5,"render_opts","","Renders directed graph `g` into the writer `w` in DOT syntax. (Main entry point for the library.)",N,N],[6,"Nodes","","",N,N],[6,"Edges","","",N,N],[8,"Labeller","","Each instance of a type that implements `Label<C>` maps to a unique identifier with respect to `C`, which is used to identify it in the generated .dot file. They can also provide more elaborate (and non-unique) label text that is used in the graphviz rendered output. The graph instance is responsible for providing the DOT compatible identifiers for the nodes and (optionally) rendered labels for the nodes and edges, as well as an identifier for the graph itself.",N,N],[16,"Node","","",4,N],[16,"Edge","","",4,N],[10,"graph_id","","Must return a DOT compatible identifier naming the graph.",4,[[["self"]],["id"]]],[10,"node_id","","Maps `n` to a unique identifier with respect to `self`. The implementor is responsible for ensuring that the returned name is a valid DOT identifier.",4,N],[11,"node_shape","","Maps `n` to one of the [graphviz `shape` names][1]. If `None` is returned, no `shape` attribute is specified.",4,N],[11,"node_label","","Maps `n` to a label that will be used in the rendered output. The label need not be unique, and may be the empty string; the default is just the output from `node_id`.",4,N],[11,"edge_label","","Maps `e` to a label that will be used in the rendered output. The label need not be unique, and may be the empty string; the default is in fact the empty string.",4,N],[11,"node_style","","Maps `n` to a style that will be used in the rendered output.",4,N],[11,"edge_style","","Maps `e` to a style that will be used in the rendered output.",4,N],[8,"GraphWalk","","GraphWalk is an abstraction over a directed graph = (nodes,edges) made up of node handles `N` and edge handles `E`, where each `E` can be mapped to its source and target nodes.",N,N],[16,"Node","","",5,N],[16,"Edge","","",5,N],[10,"nodes","","Returns all the nodes in this graph.",5,[[["self"]],["nodes"]]],[10,"edges","","Returns all of the edges in this graph.",5,[[["self"]],["edges"]]],[10,"source","","The source node for `edge`.",5,N],[10,"target","","The target node for `edge`.",5,N],[8,"IntoCow","","",N,N],[10,"into_cow","","",6,[[["self"]],["cow"]]],[11,"clone","","",2,[[["self"]],["style"]]],[11,"eq","","",2,[[["self"],["style"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",2,N],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"as_slice","","",2,[[["self"]],["str"]]],[11,"new","","Creates an `Id` named `name`.",0,[[["name"]],["result",["id"]]]],[11,"as_slice","","",0,[[["self"]],["str"]]],[11,"name","","",0,[[["self"]],["cow",["str"]]]],[11,"label","","",1,[[["s"]],["labeltext"]]],[11,"escaped","","",1,[[["s"]],["labeltext"]]],[11,"html","","",1,[[["s"]],["labeltext"]]],[11,"escape_char","","",1,[[["char"],["f"]]]],[11,"escape_str","","",1,[[["str"]],["string"]]],[11,"to_dot_string","","Renders text as string suitable for a label in a .dot file. This includes quotes or suitable delimiters.",1,[[["self"]],["string"]]],[11,"pre_escaped_content","","Decomposes content into string suitable for making EscStr that yields same content as self.  The result obeys the law render(`lt`) == render(`EscStr(lt.pre_escaped_content())`) for all `lt: LabelText`.",1,[[["self"]],["cow",["str"]]]],[11,"prefix_line","","Puts `prefix` on a line above this label, with a blank line separator.",1,[[["self"],["labeltext"]],["labeltext"]]],[11,"suffix_line","","Puts `suffix` on a line below this label, with a blank line separator.",1,[[["self"],["labeltext"]],["labeltext"]]],[11,"clone","","",3,[[["self"]],["renderoption"]]],[11,"eq","","",3,[[["self"],["renderoption"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",3,N],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]]],"paths":[[3,"Id"],[4,"LabelText"],[4,"Style"],[4,"RenderOption"],[8,"Labeller"],[8,"GraphWalk"],[8,"IntoCow"]]};
searchIndex["lazy_static"]={"doc":"A macro for declaring lazily evaluated statics.","items":[[5,"initialize","lazy_static","Takes a shared reference to a lazy static and initializes it if it has not been already.",N,[[["t"]]]],[0,"lazy","","",N,N],[17,"ONCE_INIT","lazy_static::lazy","Initialization value for static [`Once`] values.",N,N],[3,"Lazy","","",N,N],[12,"0","","",0,N],[12,"1","","",0,N],[11,"get","","",0,[[["self"],["f"]],["t"]]],[8,"LazyStatic","lazy_static","Support trait for enabling a few common operation on lazy static values.",N,N],[10,"initialize","","",1,[[["self"]]]],[14,"__lazy_static_create","","",N,N],[14,"__lazy_static_internal","","",N,N],[14,"lazy_static","","",N,N]],"paths":[[3,"Lazy"],[8,"LazyStatic"]]};
searchIndex["libc"]={"doc":"Crate docs","items":[[3,"group","libc","",N,N],[12,"gr_name","","",0,N],[12,"gr_passwd","","",0,N],[12,"gr_gid","","",0,N],[12,"gr_mem","","",0,N],[3,"utimbuf","","",N,N],[12,"actime","","",1,N],[12,"modtime","","",1,N],[3,"timeval","","",N,N],[12,"tv_sec","","",2,N],[12,"tv_usec","","",2,N],[3,"timespec","","",N,N],[12,"tv_sec","","",3,N],[12,"tv_nsec","","",3,N],[3,"rlimit","","",N,N],[12,"rlim_cur","","",4,N],[12,"rlim_max","","",4,N],[3,"rusage","","",N,N],[12,"ru_utime","","",5,N],[12,"ru_stime","","",5,N],[12,"ru_maxrss","","",5,N],[12,"ru_ixrss","","",5,N],[12,"ru_idrss","","",5,N],[12,"ru_isrss","","",5,N],[12,"ru_minflt","","",5,N],[12,"ru_majflt","","",5,N],[12,"ru_nswap","","",5,N],[12,"ru_inblock","","",5,N],[12,"ru_oublock","","",5,N],[12,"ru_msgsnd","","",5,N],[12,"ru_msgrcv","","",5,N],[12,"ru_nsignals","","",5,N],[12,"ru_nvcsw","","",5,N],[12,"ru_nivcsw","","",5,N],[3,"in_addr","","",N,N],[12,"s_addr","","",6,N],[3,"in6_addr","","",N,N],[12,"s6_addr","","",7,N],[12,"__align","","",7,N],[3,"ip_mreq","","",N,N],[12,"imr_multiaddr","","",8,N],[12,"imr_interface","","",8,N],[3,"ipv6_mreq","","",N,N],[12,"ipv6mr_multiaddr","","",9,N],[12,"ipv6mr_interface","","",9,N],[3,"hostent","","",N,N],[12,"h_name","","",10,N],[12,"h_aliases","","",10,N],[12,"h_addrtype","","",10,N],[12,"h_length","","",10,N],[12,"h_addr_list","","",10,N],[3,"iovec","","",N,N],[12,"iov_base","","",11,N],[12,"iov_len","","",11,N],[3,"pollfd","","",N,N],[12,"fd","","",12,N],[12,"events","","",12,N],[12,"revents","","",12,N],[3,"winsize","","",N,N],[12,"ws_row","","",13,N],[12,"ws_col","","",13,N],[12,"ws_xpixel","","",13,N],[12,"ws_ypixel","","",13,N],[3,"linger","","",N,N],[12,"l_onoff","","",14,N],[12,"l_linger","","",14,N],[3,"sigval","","",N,N],[12,"sival_ptr","","",15,N],[3,"itimerval","","",N,N],[12,"it_interval","","",16,N],[12,"it_value","","",16,N],[3,"tms","","",N,N],[12,"tms_utime","","",17,N],[12,"tms_stime","","",17,N],[12,"tms_cutime","","",17,N],[12,"tms_cstime","","",17,N],[3,"servent","","",N,N],[12,"s_name","","",18,N],[12,"s_aliases","","",18,N],[12,"s_port","","",18,N],[12,"s_proto","","",18,N],[3,"protoent","","",N,N],[12,"p_name","","",19,N],[12,"p_aliases","","",19,N],[12,"p_proto","","",19,N],[3,"sockaddr","","",N,N],[12,"sa_family","","",20,N],[12,"sa_data","","",20,N],[3,"sockaddr_in","","",N,N],[12,"sin_family","","",21,N],[12,"sin_port","","",21,N],[12,"sin_addr","","",21,N],[12,"sin_zero","","",21,N],[3,"sockaddr_in6","","",N,N],[12,"sin6_family","","",22,N],[12,"sin6_port","","",22,N],[12,"sin6_flowinfo","","",22,N],[12,"sin6_addr","","",22,N],[12,"sin6_scope_id","","",22,N],[3,"sockaddr_un","","",N,N],[12,"sun_family","","",23,N],[12,"sun_path","","",23,N],[3,"sockaddr_storage","","",N,N],[12,"ss_family","","",24,N],[12,"__ss_align","","",24,N],[12,"__ss_pad2","","",24,N],[3,"addrinfo","","",N,N],[12,"ai_flags","","",25,N],[12,"ai_family","","",25,N],[12,"ai_socktype","","",25,N],[12,"ai_protocol","","",25,N],[12,"ai_addrlen","","",25,N],[12,"ai_addr","","",25,N],[12,"ai_canonname","","",25,N],[12,"ai_next","","",25,N],[3,"sockaddr_nl","","",N,N],[12,"nl_family","","",26,N],[12,"nl_pad","","",26,N],[12,"nl_pid","","",26,N],[12,"nl_groups","","",26,N],[3,"sockaddr_ll","","",N,N],[12,"sll_family","","",27,N],[12,"sll_protocol","","",27,N],[12,"sll_ifindex","","",27,N],[12,"sll_hatype","","",27,N],[12,"sll_pkttype","","",27,N],[12,"sll_halen","","",27,N],[12,"sll_addr","","",27,N],[3,"fd_set","","",N,N],[12,"fds_bits","","",28,N],[3,"tm","","",N,N],[12,"tm_sec","","",29,N],[12,"tm_min","","",29,N],[12,"tm_hour","","",29,N],[12,"tm_mday","","",29,N],[12,"tm_mon","","",29,N],[12,"tm_year","","",29,N],[12,"tm_wday","","",29,N],[12,"tm_yday","","",29,N],[12,"tm_isdst","","",29,N],[12,"tm_gmtoff","","",29,N],[12,"tm_zone","","",29,N],[3,"sched_param","","",N,N],[12,"sched_priority","","",30,N],[3,"Dl_info","","",N,N],[12,"dli_fname","","",31,N],[12,"dli_fbase","","",31,N],[12,"dli_sname","","",31,N],[12,"dli_saddr","","",31,N],[3,"epoll_event","","",N,N],[12,"events","","",32,N],[12,"u64","","",32,N],[3,"utsname","","",N,N],[12,"sysname","","",33,N],[12,"nodename","","",33,N],[12,"release","","",33,N],[12,"version","","",33,N],[12,"machine","","",33,N],[12,"domainname","","",33,N],[3,"lconv","","",N,N],[12,"decimal_point","","",34,N],[12,"thousands_sep","","",34,N],[12,"grouping","","",34,N],[12,"int_curr_symbol","","",34,N],[12,"currency_symbol","","",34,N],[12,"mon_decimal_point","","",34,N],[12,"mon_thousands_sep","","",34,N],[12,"mon_grouping","","",34,N],[12,"positive_sign","","",34,N],[12,"negative_sign","","",34,N],[12,"int_frac_digits","","",34,N],[12,"frac_digits","","",34,N],[12,"p_cs_precedes","","",34,N],[12,"p_sep_by_space","","",34,N],[12,"n_cs_precedes","","",34,N],[12,"n_sep_by_space","","",34,N],[12,"p_sign_posn","","",34,N],[12,"n_sign_posn","","",34,N],[12,"int_p_cs_precedes","","",34,N],[12,"int_p_sep_by_space","","",34,N],[12,"int_n_cs_precedes","","",34,N],[12,"int_n_sep_by_space","","",34,N],[12,"int_p_sign_posn","","",34,N],[12,"int_n_sign_posn","","",34,N],[3,"sigevent","","",N,N],[12,"sigev_value","","",35,N],[12,"sigev_signo","","",35,N],[12,"sigev_notify","","",35,N],[12,"sigev_notify_thread_id","","",35,N],[12,"__unused1","","",35,N],[3,"in_pktinfo","","",N,N],[12,"ipi_ifindex","","",36,N],[12,"ipi_spec_dst","","",36,N],[12,"ipi_addr","","",36,N],[3,"ifaddrs","","",N,N],[12,"ifa_next","","",37,N],[12,"ifa_name","","",37,N],[12,"ifa_flags","","",37,N],[12,"ifa_addr","","",37,N],[12,"ifa_netmask","","",37,N],[12,"ifa_ifu","","",37,N],[12,"ifa_data","","",37,N],[3,"in6_rtmsg","","",N,N],[12,"rtmsg_dst","","",38,N],[12,"rtmsg_src","","",38,N],[12,"rtmsg_gateway","","",38,N],[12,"rtmsg_type","","",38,N],[12,"rtmsg_dst_len","","",38,N],[12,"rtmsg_src_len","","",38,N],[12,"rtmsg_metric","","",38,N],[12,"rtmsg_info","","",38,N],[12,"rtmsg_flags","","",38,N],[12,"rtmsg_ifindex","","",38,N],[3,"arpreq","","",N,N],[12,"arp_pa","","",39,N],[12,"arp_ha","","",39,N],[12,"arp_flags","","",39,N],[12,"arp_netmask","","",39,N],[12,"arp_dev","","",39,N],[3,"arpreq_old","","",N,N],[12,"arp_pa","","",40,N],[12,"arp_ha","","",40,N],[12,"arp_flags","","",40,N],[12,"arp_netmask","","",40,N],[3,"arphdr","","",N,N],[12,"ar_hrd","","",41,N],[12,"ar_pro","","",41,N],[12,"ar_hln","","",41,N],[12,"ar_pln","","",41,N],[12,"ar_op","","",41,N],[3,"dirent","","",N,N],[12,"d_ino","","",42,N],[12,"d_off","","",42,N],[12,"d_reclen","","",42,N],[12,"d_type","","",42,N],[12,"d_name","","",42,N],[3,"dirent64","","",N,N],[12,"d_ino","","",43,N],[12,"d_off","","",43,N],[12,"d_reclen","","",43,N],[12,"d_type","","",43,N],[12,"d_name","","",43,N],[3,"rlimit64","","",N,N],[12,"rlim_cur","","",44,N],[12,"rlim_max","","",44,N],[3,"glob_t","","",N,N],[12,"gl_pathc","","",45,N],[12,"gl_pathv","","",45,N],[12,"gl_offs","","",45,N],[12,"gl_flags","","",45,N],[12,"__unused1","","",45,N],[12,"__unused2","","",45,N],[12,"__unused3","","",45,N],[12,"__unused4","","",45,N],[12,"__unused5","","",45,N],[3,"pthread_mutex_t","","",N,N],[12,"__align","","",46,N],[12,"size","","",46,N],[3,"pthread_rwlock_t","","",N,N],[12,"__align","","",47,N],[12,"size","","",47,N],[3,"pthread_mutexattr_t","","",N,N],[12,"__align","","",48,N],[12,"size","","",48,N],[3,"pthread_rwlockattr_t","","",N,N],[12,"__align","","",49,N],[12,"size","","",49,N],[3,"pthread_cond_t","","",N,N],[12,"__align","","",50,N],[12,"size","","",50,N],[3,"pthread_condattr_t","","",N,N],[12,"__align","","",51,N],[12,"size","","",51,N],[3,"passwd","","",N,N],[12,"pw_name","","",52,N],[12,"pw_passwd","","",52,N],[12,"pw_uid","","",52,N],[12,"pw_gid","","",52,N],[12,"pw_gecos","","",52,N],[12,"pw_dir","","",52,N],[12,"pw_shell","","",52,N],[3,"spwd","","",N,N],[12,"sp_namp","","",53,N],[12,"sp_pwdp","","",53,N],[12,"sp_lstchg","","",53,N],[12,"sp_min","","",53,N],[12,"sp_max","","",53,N],[12,"sp_warn","","",53,N],[12,"sp_inact","","",53,N],[12,"sp_expire","","",53,N],[12,"sp_flag","","",53,N],[3,"dqblk","","",N,N],[12,"dqb_bhardlimit","","",54,N],[12,"dqb_bsoftlimit","","",54,N],[12,"dqb_curspace","","",54,N],[12,"dqb_ihardlimit","","",54,N],[12,"dqb_isoftlimit","","",54,N],[12,"dqb_curinodes","","",54,N],[12,"dqb_btime","","",54,N],[12,"dqb_itime","","",54,N],[12,"dqb_valid","","",54,N],[3,"signalfd_siginfo","","",N,N],[12,"ssi_signo","","",55,N],[12,"ssi_errno","","",55,N],[12,"ssi_code","","",55,N],[12,"ssi_pid","","",55,N],[12,"ssi_uid","","",55,N],[12,"ssi_fd","","",55,N],[12,"ssi_tid","","",55,N],[12,"ssi_band","","",55,N],[12,"ssi_overrun","","",55,N],[12,"ssi_trapno","","",55,N],[12,"ssi_status","","",55,N],[12,"ssi_int","","",55,N],[12,"ssi_ptr","","",55,N],[12,"ssi_utime","","",55,N],[12,"ssi_stime","","",55,N],[12,"ssi_addr","","",55,N],[12,"_pad","","",55,N],[3,"itimerspec","","",N,N],[12,"it_interval","","",56,N],[12,"it_value","","",56,N],[3,"fsid_t","","",N,N],[12,"__val","","",57,N],[3,"mq_attr","","",N,N],[12,"mq_flags","","",58,N],[12,"mq_maxmsg","","",58,N],[12,"mq_msgsize","","",58,N],[12,"mq_curmsgs","","",58,N],[12,"pad","","",58,N],[3,"packet_mreq","","",N,N],[12,"mr_ifindex","","",59,N],[12,"mr_type","","",59,N],[12,"mr_alen","","",59,N],[12,"mr_address","","",59,N],[3,"cpu_set_t","","",N,N],[12,"bits","","",60,N],[3,"if_nameindex","","",N,N],[12,"if_index","","",61,N],[12,"if_name","","",61,N],[3,"msginfo","","",N,N],[12,"msgpool","","",62,N],[12,"msgmap","","",62,N],[12,"msgmax","","",62,N],[12,"msgmnb","","",62,N],[12,"msgmni","","",62,N],[12,"msgssz","","",62,N],[12,"msgtql","","",62,N],[12,"msgseg","","",62,N],[3,"mmsghdr","","",N,N],[12,"msg_hdr","","",63,N],[12,"msg_len","","",63,N],[3,"sembuf","","",N,N],[12,"sem_num","","",64,N],[12,"sem_op","","",64,N],[12,"sem_flg","","",64,N],[3,"input_event","","",N,N],[12,"time","","",65,N],[12,"type_","","",65,N],[12,"code","","",65,N],[12,"value","","",65,N],[3,"input_id","","",N,N],[12,"bustype","","",66,N],[12,"vendor","","",66,N],[12,"product","","",66,N],[12,"version","","",66,N],[3,"input_absinfo","","",N,N],[12,"value","","",67,N],[12,"minimum","","",67,N],[12,"maximum","","",67,N],[12,"fuzz","","",67,N],[12,"flat","","",67,N],[12,"resolution","","",67,N],[3,"input_keymap_entry","","",N,N],[12,"flags","","",68,N],[12,"len","","",68,N],[12,"index","","",68,N],[12,"keycode","","",68,N],[12,"scancode","","",68,N],[3,"input_mask","","",N,N],[12,"type_","","",69,N],[12,"codes_size","","",69,N],[12,"codes_ptr","","",69,N],[3,"ff_replay","","",N,N],[12,"length","","",70,N],[12,"delay","","",70,N],[3,"ff_trigger","","",N,N],[12,"button","","",71,N],[12,"interval","","",71,N],[3,"ff_envelope","","",N,N],[12,"attack_length","","",72,N],[12,"attack_level","","",72,N],[12,"fade_length","","",72,N],[12,"fade_level","","",72,N],[3,"ff_constant_effect","","",N,N],[12,"level","","",73,N],[12,"envelope","","",73,N],[3,"ff_ramp_effect","","",N,N],[12,"start_level","","",74,N],[12,"end_level","","",74,N],[12,"envelope","","",74,N],[3,"ff_condition_effect","","",N,N],[12,"right_saturation","","",75,N],[12,"left_saturation","","",75,N],[12,"right_coeff","","",75,N],[12,"left_coeff","","",75,N],[12,"deadband","","",75,N],[12,"center","","",75,N],[3,"ff_periodic_effect","","",N,N],[12,"waveform","","",76,N],[12,"period","","",76,N],[12,"magnitude","","",76,N],[12,"offset","","",76,N],[12,"phase","","",76,N],[12,"envelope","","",76,N],[12,"custom_len","","",76,N],[12,"custom_data","","",76,N],[3,"ff_rumble_effect","","",N,N],[12,"strong_magnitude","","",77,N],[12,"weak_magnitude","","",77,N],[3,"ff_effect","","",N,N],[12,"type_","","",78,N],[12,"id","","",78,N],[12,"direction","","",78,N],[12,"trigger","","",78,N],[12,"replay","","",78,N],[12,"u","","",78,N],[3,"dl_phdr_info","","",N,N],[12,"dlpi_addr","","",79,N],[12,"dlpi_name","","",79,N],[12,"dlpi_phdr","","",79,N],[12,"dlpi_phnum","","",79,N],[12,"dlpi_adds","","",79,N],[12,"dlpi_subs","","",79,N],[12,"dlpi_tls_modid","","",79,N],[12,"dlpi_tls_data","","",79,N],[3,"Elf32_Phdr","","",N,N],[12,"p_type","","",80,N],[12,"p_offset","","",80,N],[12,"p_vaddr","","",80,N],[12,"p_paddr","","",80,N],[12,"p_filesz","","",80,N],[12,"p_memsz","","",80,N],[12,"p_flags","","",80,N],[12,"p_align","","",80,N],[3,"Elf64_Phdr","","",N,N],[12,"p_type","","",81,N],[12,"p_flags","","",81,N],[12,"p_offset","","",81,N],[12,"p_vaddr","","",81,N],[12,"p_paddr","","",81,N],[12,"p_filesz","","",81,N],[12,"p_memsz","","",81,N],[12,"p_align","","",81,N],[3,"ucred","","",N,N],[12,"pid","","",82,N],[12,"uid","","",82,N],[12,"gid","","",82,N],[3,"mntent","","",N,N],[12,"mnt_fsname","","",83,N],[12,"mnt_dir","","",83,N],[12,"mnt_type","","",83,N],[12,"mnt_opts","","",83,N],[12,"mnt_freq","","",83,N],[12,"mnt_passno","","",83,N],[3,"posix_spawn_file_actions_t","","",N,N],[12,"__allocated","","",84,N],[12,"__used","","",84,N],[12,"__actions","","",84,N],[12,"__pad","","",84,N],[3,"posix_spawnattr_t","","",N,N],[12,"__flags","","",85,N],[12,"__pgrp","","",85,N],[12,"__sd","","",85,N],[12,"__ss","","",85,N],[12,"__sp","","",85,N],[12,"__policy","","",85,N],[12,"__pad","","",85,N],[3,"genlmsghdr","","",N,N],[12,"cmd","","",86,N],[12,"version","","",86,N],[12,"reserved","","",86,N],[3,"in6_pktinfo","","",N,N],[12,"ipi6_addr","","",87,N],[12,"ipi6_ifindex","","",87,N],[3,"arpd_request","","",N,N],[12,"req","","",88,N],[12,"ip","","",88,N],[12,"dev","","",88,N],[12,"stamp","","",88,N],[12,"updated","","",88,N],[12,"ha","","",88,N],[3,"aiocb","","",N,N],[12,"aio_fildes","","",89,N],[12,"aio_lio_opcode","","",89,N],[12,"aio_reqprio","","",89,N],[12,"aio_buf","","",89,N],[12,"aio_nbytes","","",89,N],[12,"aio_sigevent","","",89,N],[12,"__next_prio","","",89,N],[12,"__abs_prio","","",89,N],[12,"__policy","","",89,N],[12,"__error_code","","",89,N],[12,"__return_value","","",89,N],[12,"aio_offset","","",89,N],[12,"__glibc_reserved","","",89,N],[3,"__exit_status","","",N,N],[12,"e_termination","","",90,N],[12,"e_exit","","",90,N],[3,"__timeval","","",N,N],[12,"tv_sec","","",91,N],[12,"tv_usec","","",91,N],[3,"utmpx","","",N,N],[12,"ut_type","","",92,N],[12,"ut_pid","","",92,N],[12,"ut_line","","",92,N],[12,"ut_id","","",92,N],[12,"ut_user","","",92,N],[12,"ut_host","","",92,N],[12,"ut_exit","","",92,N],[12,"ut_session","","",92,N],[12,"ut_tv","","",92,N],[12,"ut_addr_v6","","",92,N],[12,"__glibc_reserved","","",92,N],[3,"sigaction","","",N,N],[12,"sa_sigaction","","",93,N],[12,"sa_mask","","",93,N],[12,"sa_flags","","",93,N],[12,"sa_restorer","","",93,N],[3,"stack_t","","",N,N],[12,"ss_sp","","",94,N],[12,"ss_flags","","",94,N],[12,"ss_size","","",94,N],[3,"siginfo_t","","",N,N],[12,"si_signo","","",95,N],[12,"si_errno","","",95,N],[12,"si_code","","",95,N],[12,"_pad","","",95,N],[12,"_align","","",95,N],[3,"glob64_t","","",N,N],[12,"gl_pathc","","",96,N],[12,"gl_pathv","","",96,N],[12,"gl_offs","","",96,N],[12,"gl_flags","","",96,N],[12,"__unused1","","",96,N],[12,"__unused2","","",96,N],[12,"__unused3","","",96,N],[12,"__unused4","","",96,N],[12,"__unused5","","",96,N],[3,"statfs","","",N,N],[12,"f_type","","",97,N],[12,"f_bsize","","",97,N],[12,"f_blocks","","",97,N],[12,"f_bfree","","",97,N],[12,"f_bavail","","",97,N],[12,"f_files","","",97,N],[12,"f_ffree","","",97,N],[12,"f_fsid","","",97,N],[12,"f_namelen","","",97,N],[12,"f_frsize","","",97,N],[12,"f_spare","","",97,N],[3,"msghdr","","",N,N],[12,"msg_name","","",98,N],[12,"msg_namelen","","",98,N],[12,"msg_iov","","",98,N],[12,"msg_iovlen","","",98,N],[12,"msg_control","","",98,N],[12,"msg_controllen","","",98,N],[12,"msg_flags","","",98,N],[3,"cmsghdr","","",N,N],[12,"cmsg_len","","",99,N],[12,"cmsg_level","","",99,N],[12,"cmsg_type","","",99,N],[3,"termios","","",N,N],[12,"c_iflag","","",100,N],[12,"c_oflag","","",100,N],[12,"c_cflag","","",100,N],[12,"c_lflag","","",100,N],[12,"c_line","","",100,N],[12,"c_cc","","",100,N],[12,"c_ispeed","","",100,N],[12,"c_ospeed","","",100,N],[3,"flock","","",N,N],[12,"l_type","","",101,N],[12,"l_whence","","",101,N],[12,"l_start","","",101,N],[12,"l_len","","",101,N],[12,"l_pid","","",101,N],[3,"sem_t","","",N,N],[12,"__size","","",102,N],[12,"__align","","",102,N],[3,"mallinfo","","",N,N],[12,"arena","","",103,N],[12,"ordblks","","",103,N],[12,"smblks","","",103,N],[12,"hblks","","",103,N],[12,"hblkhd","","",103,N],[12,"usmblks","","",103,N],[12,"fsmblks","","",103,N],[12,"uordblks","","",103,N],[12,"fordblks","","",103,N],[12,"keepcost","","",103,N],[3,"nlmsghdr","","",N,N],[12,"nlmsg_len","","",104,N],[12,"nlmsg_type","","",104,N],[12,"nlmsg_flags","","",104,N],[12,"nlmsg_seq","","",104,N],[12,"nlmsg_pid","","",104,N],[3,"nlmsgerr","","",N,N],[12,"error","","",105,N],[12,"msg","","",105,N],[3,"nl_pktinfo","","",N,N],[12,"group","","",106,N],[3,"nl_mmap_req","","",N,N],[12,"nm_block_size","","",107,N],[12,"nm_block_nr","","",107,N],[12,"nm_frame_size","","",107,N],[12,"nm_frame_nr","","",107,N],[3,"nl_mmap_hdr","","",N,N],[12,"nm_status","","",108,N],[12,"nm_len","","",108,N],[12,"nm_group","","",108,N],[12,"nm_pid","","",108,N],[12,"nm_uid","","",108,N],[12,"nm_gid","","",108,N],[3,"nlattr","","",N,N],[12,"nla_len","","",109,N],[12,"nla_type","","",109,N],[3,"rtentry","","",N,N],[12,"rt_pad1","","",110,N],[12,"rt_dst","","",110,N],[12,"rt_gateway","","",110,N],[12,"rt_genmask","","",110,N],[12,"rt_flags","","",110,N],[12,"rt_pad2","","",110,N],[12,"rt_pad3","","",110,N],[12,"rt_tos","","",110,N],[12,"rt_class","","",110,N],[12,"rt_pad4","","",110,N],[12,"rt_metric","","",110,N],[12,"rt_dev","","",110,N],[12,"rt_mtu","","",110,N],[12,"rt_window","","",110,N],[12,"rt_irtt","","",110,N],[3,"sigset_t","","",N,N],[12,"__val","","",111,N],[3,"sysinfo","","",N,N],[12,"uptime","","",112,N],[12,"loads","","",112,N],[12,"totalram","","",112,N],[12,"freeram","","",112,N],[12,"sharedram","","",112,N],[12,"bufferram","","",112,N],[12,"totalswap","","",112,N],[12,"freeswap","","",112,N],[12,"procs","","",112,N],[12,"pad","","",112,N],[12,"totalhigh","","",112,N],[12,"freehigh","","",112,N],[12,"mem_unit","","",112,N],[12,"_f","","",112,N],[3,"msqid_ds","","",N,N],[12,"msg_perm","","",113,N],[12,"msg_stime","","",113,N],[12,"msg_rtime","","",113,N],[12,"msg_ctime","","",113,N],[12,"__msg_cbytes","","",113,N],[12,"msg_qnum","","",113,N],[12,"msg_qbytes","","",113,N],[12,"msg_lspid","","",113,N],[12,"msg_lrpid","","",113,N],[12,"__glibc_reserved4","","",113,N],[12,"__glibc_reserved5","","",113,N],[3,"stat","","",N,N],[12,"st_dev","","",114,N],[12,"st_ino","","",114,N],[12,"st_nlink","","",114,N],[12,"st_mode","","",114,N],[12,"st_uid","","",114,N],[12,"st_gid","","",114,N],[12,"__pad0","","",114,N],[12,"st_rdev","","",114,N],[12,"st_size","","",114,N],[12,"st_blksize","","",114,N],[12,"st_blocks","","",114,N],[12,"st_atime","","",114,N],[12,"st_atime_nsec","","",114,N],[12,"st_mtime","","",114,N],[12,"st_mtime_nsec","","",114,N],[12,"st_ctime","","",114,N],[12,"st_ctime_nsec","","",114,N],[12,"__unused","","",114,N],[3,"stat64","","",N,N],[12,"st_dev","","",115,N],[12,"st_ino","","",115,N],[12,"st_nlink","","",115,N],[12,"st_mode","","",115,N],[12,"st_uid","","",115,N],[12,"st_gid","","",115,N],[12,"__pad0","","",115,N],[12,"st_rdev","","",115,N],[12,"st_size","","",115,N],[12,"st_blksize","","",115,N],[12,"st_blocks","","",115,N],[12,"st_atime","","",115,N],[12,"st_atime_nsec","","",115,N],[12,"st_mtime","","",115,N],[12,"st_mtime_nsec","","",115,N],[12,"st_ctime","","",115,N],[12,"st_ctime_nsec","","",115,N],[12,"__reserved","","",115,N],[3,"statfs64","","",N,N],[12,"f_type","","",116,N],[12,"f_bsize","","",116,N],[12,"f_blocks","","",116,N],[12,"f_bfree","","",116,N],[12,"f_bavail","","",116,N],[12,"f_files","","",116,N],[12,"f_ffree","","",116,N],[12,"f_fsid","","",116,N],[12,"f_namelen","","",116,N],[12,"f_frsize","","",116,N],[12,"f_flags","","",116,N],[12,"f_spare","","",116,N],[3,"statvfs64","","",N,N],[12,"f_bsize","","",117,N],[12,"f_frsize","","",117,N],[12,"f_blocks","","",117,N],[12,"f_bfree","","",117,N],[12,"f_bavail","","",117,N],[12,"f_files","","",117,N],[12,"f_ffree","","",117,N],[12,"f_favail","","",117,N],[12,"f_fsid","","",117,N],[12,"f_flag","","",117,N],[12,"f_namemax","","",117,N],[12,"__f_spare","","",117,N],[3,"pthread_attr_t","","",N,N],[12,"__size","","",118,N],[3,"_libc_fpxreg","","",N,N],[12,"significand","","",119,N],[12,"exponent","","",119,N],[12,"__private","","",119,N],[3,"_libc_xmmreg","","",N,N],[12,"element","","",120,N],[3,"_libc_fpstate","","",N,N],[12,"cwd","","",121,N],[12,"swd","","",121,N],[12,"ftw","","",121,N],[12,"fop","","",121,N],[12,"rip","","",121,N],[12,"rdp","","",121,N],[12,"mxcsr","","",121,N],[12,"mxcr_mask","","",121,N],[12,"_st","","",121,N],[12,"_xmm","","",121,N],[12,"__private","","",121,N],[3,"user_fpregs_struct","","",N,N],[12,"cwd","","",122,N],[12,"swd","","",122,N],[12,"ftw","","",122,N],[12,"fop","","",122,N],[12,"rip","","",122,N],[12,"rdp","","",122,N],[12,"mxcsr","","",122,N],[12,"mxcr_mask","","",122,N],[12,"st_space","","",122,N],[12,"xmm_space","","",122,N],[12,"padding","","",122,N],[3,"user_regs_struct","","",N,N],[12,"r15","","",123,N],[12,"r14","","",123,N],[12,"r13","","",123,N],[12,"r12","","",123,N],[12,"rbp","","",123,N],[12,"rbx","","",123,N],[12,"r11","","",123,N],[12,"r10","","",123,N],[12,"r9","","",123,N],[12,"r8","","",123,N],[12,"rax","","",123,N],[12,"rcx","","",123,N],[12,"rdx","","",123,N],[12,"rsi","","",123,N],[12,"rdi","","",123,N],[12,"orig_rax","","",123,N],[12,"rip","","",123,N],[12,"cs","","",123,N],[12,"eflags","","",123,N],[12,"rsp","","",123,N],[12,"ss","","",123,N],[12,"fs_base","","",123,N],[12,"gs_base","","",123,N],[12,"ds","","",123,N],[12,"es","","",123,N],[12,"fs","","",123,N],[12,"gs","","",123,N],[3,"user","","",N,N],[12,"regs","","",124,N],[12,"u_fpvalid","","",124,N],[12,"i387","","",124,N],[12,"u_tsize","","",124,N],[12,"u_dsize","","",124,N],[12,"u_ssize","","",124,N],[12,"start_code","","",124,N],[12,"start_stack","","",124,N],[12,"signal","","",124,N],[12,"__reserved","","",124,N],[12,"u_ar0","","",124,N],[12,"u_fpstate","","",124,N],[12,"magic","","",124,N],[12,"u_comm","","",124,N],[12,"u_debugreg","","",124,N],[3,"mcontext_t","","",N,N],[12,"gregs","","",125,N],[12,"fpregs","","",125,N],[12,"__private","","",125,N],[3,"ucontext_t","","",N,N],[12,"uc_flags","","",126,N],[12,"uc_link","","",126,N],[12,"uc_stack","","",126,N],[12,"uc_mcontext","","",126,N],[12,"uc_sigmask","","",126,N],[12,"__private","","",126,N],[3,"ipc_perm","","",N,N],[12,"__key","","",127,N],[12,"uid","","",127,N],[12,"gid","","",127,N],[12,"cuid","","",127,N],[12,"cgid","","",127,N],[12,"mode","","",127,N],[12,"__pad1","","",127,N],[12,"__seq","","",127,N],[12,"__pad2","","",127,N],[12,"__unused1","","",127,N],[12,"__unused2","","",127,N],[3,"shmid_ds","","",N,N],[12,"shm_perm","","",128,N],[12,"shm_segsz","","",128,N],[12,"shm_atime","","",128,N],[12,"shm_dtime","","",128,N],[12,"shm_ctime","","",128,N],[12,"shm_cpid","","",128,N],[12,"shm_lpid","","",128,N],[12,"shm_nattch","","",128,N],[12,"__unused4","","",128,N],[12,"__unused5","","",128,N],[3,"termios2","","",N,N],[12,"c_iflag","","",129,N],[12,"c_oflag","","",129,N],[12,"c_cflag","","",129,N],[12,"c_lflag","","",129,N],[12,"c_line","","",129,N],[12,"c_cc","","",129,N],[12,"c_ispeed","","",129,N],[12,"c_ospeed","","",129,N],[3,"statvfs","","",N,N],[12,"f_bsize","","",130,N],[12,"f_frsize","","",130,N],[12,"f_blocks","","",130,N],[12,"f_bfree","","",130,N],[12,"f_bavail","","",130,N],[12,"f_files","","",130,N],[12,"f_ffree","","",130,N],[12,"f_favail","","",130,N],[12,"f_fsid","","",130,N],[12,"f_flag","","",130,N],[12,"f_namemax","","",130,N],[12,"__f_spare","","",130,N],[4,"c_void","","",N,N],[13,"__variant1","","",131,N],[13,"__variant2","","",131,N],[4,"FILE","","",N,N],[4,"fpos_t","","",N,N],[4,"DIR","","",N,N],[4,"locale_t","","",N,N],[4,"timezone","","",N,N],[4,"fpos64_t","","",N,N],[5,"FD_CLR","","",N,N],[5,"FD_ISSET","","",N,N],[5,"FD_SET","","",N,N],[5,"FD_ZERO","","",N,N],[5,"WIFSTOPPED","","",N,[[["c_int"]],["bool"]]],[5,"WSTOPSIG","","",N,[[["c_int"]],["c_int"]]],[5,"WIFCONTINUED","","",N,[[["c_int"]],["bool"]]],[5,"WIFSIGNALED","","",N,[[["c_int"]],["bool"]]],[5,"WTERMSIG","","",N,[[["c_int"]],["c_int"]]],[5,"WIFEXITED","","",N,[[["c_int"]],["bool"]]],[5,"WEXITSTATUS","","",N,[[["c_int"]],["c_int"]]],[5,"WCOREDUMP","","",N,[[["c_int"]],["bool"]]],[5,"QCMD","","",N,[[["c_int"],["c_int"]],["c_int"]]],[5,"IPOPT_COPIED","","",N,[[["u8"]],["u8"]]],[5,"IPOPT_CLASS","","",N,[[["u8"]],["u8"]]],[5,"IPOPT_NUMBER","","",N,[[["u8"]],["u8"]]],[5,"CPU_ZERO","","",N,N],[5,"CPU_SET","","",N,N],[5,"CPU_CLR","","",N,N],[5,"CPU_ISSET","","",N,[[["usize"],["cpu_set_t"]],["bool"]]],[5,"CPU_EQUAL","","",N,[[["cpu_set_t"],["cpu_set_t"]],["bool"]]],[5,"major","","",N,[[["dev_t"]],["c_uint"]]],[5,"minor","","",N,[[["dev_t"]],["c_uint"]]],[5,"makedev","","",N,[[["c_uint"],["c_uint"]],["dev_t"]]],[5,"IPTOS_TOS","","",N,[[["u8"]],["u8"]]],[5,"IPTOS_PREC","","",N,[[["u8"]],["u8"]]],[5,"RT_TOS","","",N,[[["u8"]],["u8"]]],[5,"RT_ADDRCLASS","","",N,[[["u32"]],["u32"]]],[5,"RT_LOCALADDR","","",N,[[["u32"]],["bool"]]],[5,"NLA_ALIGN","","",N,[[["c_int"]],["c_int"]]],[5,"isalnum","","",N,N],[5,"isalpha","","",N,N],[5,"iscntrl","","",N,N],[5,"isdigit","","",N,N],[5,"isgraph","","",N,N],[5,"islower","","",N,N],[5,"isprint","","",N,N],[5,"ispunct","","",N,N],[5,"isspace","","",N,N],[5,"isupper","","",N,N],[5,"isxdigit","","",N,N],[5,"tolower","","",N,N],[5,"toupper","","",N,N],[5,"fopen","","",N,N],[5,"freopen","","",N,N],[5,"fflush","","",N,N],[5,"fclose","","",N,N],[5,"remove","","",N,N],[5,"rename","","",N,N],[5,"tmpfile","","",N,N],[5,"setvbuf","","",N,N],[5,"setbuf","","",N,N],[5,"getchar","","",N,N],[5,"putchar","","",N,N],[5,"fgetc","","",N,N],[5,"fgets","","",N,N],[5,"fputc","","",N,N],[5,"fputs","","",N,N],[5,"puts","","",N,N],[5,"ungetc","","",N,N],[5,"fread","","",N,N],[5,"fwrite","","",N,N],[5,"fseek","","",N,N],[5,"ftell","","",N,N],[5,"rewind","","",N,N],[5,"fgetpos","","",N,N],[5,"fsetpos","","",N,N],[5,"feof","","",N,N],[5,"ferror","","",N,N],[5,"perror","","",N,N],[5,"atoi","","",N,N],[5,"strtod","","",N,N],[5,"strtol","","",N,N],[5,"strtoul","","",N,N],[5,"calloc","","",N,N],[5,"malloc","","",N,N],[5,"realloc","","",N,N],[5,"free","","",N,N],[5,"abort","","",N,N],[5,"exit","","",N,N],[5,"_exit","","",N,N],[5,"atexit","","",N,N],[5,"system","","",N,N],[5,"getenv","","",N,N],[5,"strcpy","","",N,N],[5,"strncpy","","",N,N],[5,"strcat","","",N,N],[5,"strncat","","",N,N],[5,"strcmp","","",N,N],[5,"strncmp","","",N,N],[5,"strcoll","","",N,N],[5,"strchr","","",N,N],[5,"strrchr","","",N,N],[5,"strspn","","",N,N],[5,"strcspn","","",N,N],[5,"strdup","","",N,N],[5,"strpbrk","","",N,N],[5,"strstr","","",N,N],[5,"strlen","","",N,N],[5,"strnlen","","",N,N],[5,"strerror","","",N,N],[5,"strtok","","",N,N],[5,"strxfrm","","",N,N],[5,"wcslen","","",N,N],[5,"wcstombs","","",N,N],[5,"memchr","","",N,N],[5,"memcmp","","",N,N],[5,"memcpy","","",N,N],[5,"memmove","","",N,N],[5,"memset","","",N,N],[5,"abs","","",N,N],[5,"atof","","",N,N],[5,"labs","","",N,N],[5,"rand","","",N,N],[5,"srand","","",N,N],[5,"getpwnam","","",N,N],[5,"getpwuid","","",N,N],[5,"fprintf","","",N,N],[5,"printf","","",N,N],[5,"snprintf","","",N,N],[5,"sprintf","","",N,N],[5,"fscanf","","",N,N],[5,"scanf","","",N,N],[5,"sscanf","","",N,N],[5,"getchar_unlocked","","",N,N],[5,"putchar_unlocked","","",N,N],[5,"socket","","",N,N],[5,"connect","","",N,N],[5,"listen","","",N,N],[5,"accept","","",N,N],[5,"getpeername","","",N,N],[5,"getsockname","","",N,N],[5,"setsockopt","","",N,N],[5,"socketpair","","",N,N],[5,"sendto","","",N,N],[5,"shutdown","","",N,N],[5,"chmod","","",N,N],[5,"fchmod","","",N,N],[5,"fstat","","",N,N],[5,"mkdir","","",N,N],[5,"stat","","",N,N],[5,"pclose","","",N,N],[5,"fdopen","","",N,N],[5,"fileno","","",N,N],[5,"open","","",N,N],[5,"creat","","",N,N],[5,"fcntl","","",N,N],[5,"opendir","","",N,N],[5,"fdopendir","","",N,N],[5,"readdir","","",N,N],[5,"readdir_r","","",N,N],[5,"closedir","","",N,N],[5,"rewinddir","","",N,N],[5,"openat","","",N,N],[5,"fchmodat","","",N,N],[5,"fchown","","",N,N],[5,"fchownat","","",N,N],[5,"fstatat","","",N,N],[5,"linkat","","",N,N],[5,"mkdirat","","",N,N],[5,"readlinkat","","",N,N],[5,"renameat","","",N,N],[5,"symlinkat","","",N,N],[5,"unlinkat","","",N,N],[5,"access","","",N,N],[5,"alarm","","",N,N],[5,"chdir","","",N,N],[5,"fchdir","","",N,N],[5,"chown","","",N,N],[5,"lchown","","",N,N],[5,"close","","",N,N],[5,"dup","","",N,N],[5,"dup2","","",N,N],[5,"execl","","",N,N],[5,"execle","","",N,N],[5,"execlp","","",N,N],[5,"execv","","",N,N],[5,"execve","","",N,N],[5,"execvp","","",N,N],[5,"fork","","",N,N],[5,"fpathconf","","",N,N],[5,"getcwd","","",N,N],[5,"getegid","","",N,N],[5,"geteuid","","",N,N],[5,"getgid","","",N,N],[5,"getgroups","","",N,N],[5,"getlogin","","",N,N],[5,"getopt","","",N,N],[5,"getpgid","","",N,N],[5,"getpgrp","","",N,N],[5,"getpid","","",N,N],[5,"getppid","","",N,N],[5,"getuid","","",N,N],[5,"isatty","","",N,N],[5,"link","","",N,N],[5,"lseek","","",N,N],[5,"pathconf","","",N,N],[5,"pause","","",N,N],[5,"pipe","","",N,N],[5,"posix_memalign","","",N,N],[5,"read","","",N,N],[5,"rmdir","","",N,N],[5,"seteuid","","",N,N],[5,"setgid","","",N,N],[5,"setpgid","","",N,N],[5,"setsid","","",N,N],[5,"setuid","","",N,N],[5,"sleep","","",N,N],[5,"nanosleep","","",N,N],[5,"tcgetpgrp","","",N,N],[5,"tcsetpgrp","","",N,N],[5,"ttyname","","",N,N],[5,"unlink","","",N,N],[5,"wait","","",N,N],[5,"waitpid","","",N,N],[5,"write","","",N,N],[5,"pread","","",N,N],[5,"pwrite","","",N,N],[5,"umask","","",N,N],[5,"utime","","",N,N],[5,"kill","","",N,N],[5,"killpg","","",N,N],[5,"mlock","","",N,N],[5,"munlock","","",N,N],[5,"mlockall","","",N,N],[5,"munlockall","","",N,N],[5,"mmap","","",N,N],[5,"munmap","","",N,N],[5,"if_nametoindex","","",N,N],[5,"if_indextoname","","",N,N],[5,"lstat","","",N,N],[5,"fsync","","",N,N],[5,"setenv","","",N,N],[5,"unsetenv","","",N,N],[5,"symlink","","",N,N],[5,"ftruncate","","",N,N],[5,"signal","","",N,N],[5,"getrlimit","","",N,N],[5,"setrlimit","","",N,N],[5,"getrusage","","",N,N],[5,"realpath","","",N,N],[5,"flock","","",N,N],[5,"gettimeofday","","",N,N],[5,"times","","",N,N],[5,"pthread_self","","",N,N],[5,"pthread_join","","",N,N],[5,"pthread_exit","","",N,N],[5,"pthread_attr_init","","",N,N],[5,"pthread_attr_destroy","","",N,N],[5,"pthread_attr_setstacksize","","",N,N],[5,"pthread_attr_setdetachstate","","",N,N],[5,"pthread_detach","","",N,N],[5,"sched_yield","","",N,N],[5,"pthread_key_create","","",N,N],[5,"pthread_key_delete","","",N,N],[5,"pthread_getspecific","","",N,N],[5,"pthread_setspecific","","",N,N],[5,"pthread_mutex_init","","",N,N],[5,"pthread_mutex_destroy","","",N,N],[5,"pthread_mutex_lock","","",N,N],[5,"pthread_mutex_trylock","","",N,N],[5,"pthread_mutex_unlock","","",N,N],[5,"pthread_mutexattr_init","","",N,N],[5,"pthread_mutexattr_destroy","","",N,N],[5,"pthread_mutexattr_settype","","",N,N],[5,"pthread_cond_init","","",N,N],[5,"pthread_cond_wait","","",N,N],[5,"pthread_cond_timedwait","","",N,N],[5,"pthread_cond_signal","","",N,N],[5,"pthread_cond_broadcast","","",N,N],[5,"pthread_cond_destroy","","",N,N],[5,"pthread_condattr_init","","",N,N],[5,"pthread_condattr_destroy","","",N,N],[5,"pthread_rwlock_init","","",N,N],[5,"pthread_rwlock_destroy","","",N,N],[5,"pthread_rwlock_rdlock","","",N,N],[5,"pthread_rwlock_tryrdlock","","",N,N],[5,"pthread_rwlock_wrlock","","",N,N],[5,"pthread_rwlock_trywrlock","","",N,N],[5,"pthread_rwlock_unlock","","",N,N],[5,"pthread_rwlockattr_init","","",N,N],[5,"pthread_rwlockattr_destroy","","",N,N],[5,"strerror_r","","",N,N],[5,"getsockopt","","",N,N],[5,"raise","","",N,N],[5,"sigaction","","",N,N],[5,"utimes","","",N,N],[5,"dlopen","","",N,N],[5,"dlerror","","",N,N],[5,"dlsym","","",N,N],[5,"dlclose","","",N,N],[5,"dladdr","","",N,N],[5,"getaddrinfo","","",N,N],[5,"freeaddrinfo","","",N,N],[5,"gai_strerror","","",N,N],[5,"res_init","","",N,N],[5,"gmtime_r","","",N,N],[5,"localtime_r","","",N,N],[5,"mktime","","",N,N],[5,"time","","",N,N],[5,"gmtime","","",N,N],[5,"localtime","","",N,N],[5,"difftime","","",N,N],[5,"mknod","","",N,N],[5,"uname","","",N,N],[5,"gethostname","","",N,N],[5,"getservbyname","","",N,N],[5,"getprotobyname","","",N,N],[5,"getprotobynumber","","",N,N],[5,"chroot","","",N,N],[5,"usleep","","",N,N],[5,"send","","",N,N],[5,"recv","","",N,N],[5,"putenv","","",N,N],[5,"poll","","",N,N],[5,"select","","",N,N],[5,"setlocale","","",N,N],[5,"localeconv","","",N,N],[5,"sem_destroy","","",N,N],[5,"sem_wait","","",N,N],[5,"sem_trywait","","",N,N],[5,"sem_post","","",N,N],[5,"sem_init","","",N,N],[5,"statvfs","","",N,N],[5,"fstatvfs","","",N,N],[5,"readlink","","",N,N],[5,"sigemptyset","","",N,N],[5,"sigaddset","","",N,N],[5,"sigfillset","","",N,N],[5,"sigdelset","","",N,N],[5,"sigismember","","",N,N],[5,"sigprocmask","","",N,N],[5,"sigpending","","",N,N],[5,"timegm","","",N,N],[5,"getsid","","",N,N],[5,"sysconf","","",N,N],[5,"mkfifo","","",N,N],[5,"pselect","","",N,N],[5,"fseeko","","",N,N],[5,"ftello","","",N,N],[5,"tcdrain","","",N,N],[5,"cfgetispeed","","",N,N],[5,"cfgetospeed","","",N,N],[5,"cfmakeraw","","",N,N],[5,"cfsetispeed","","",N,N],[5,"cfsetospeed","","",N,N],[5,"cfsetspeed","","",N,N],[5,"tcgetattr","","",N,N],[5,"tcsetattr","","",N,N],[5,"tcflow","","",N,N],[5,"tcflush","","",N,N],[5,"tcgetsid","","",N,N],[5,"tcsendbreak","","",N,N],[5,"mkstemp","","",N,N],[5,"mkdtemp","","",N,N],[5,"tmpnam","","",N,N],[5,"openlog","","",N,N],[5,"closelog","","",N,N],[5,"setlogmask","","",N,N],[5,"syslog","","",N,N],[5,"nice","","",N,N],[5,"grantpt","","",N,N],[5,"posix_openpt","","",N,N],[5,"ptsname","","",N,N],[5,"unlockpt","","",N,N],[5,"fdatasync","","",N,N],[5,"mincore","","",N,N],[5,"clock_getres","","",N,N],[5,"clock_gettime","","",N,N],[5,"clock_settime","","",N,N],[5,"dirfd","","",N,N],[5,"pthread_getattr_np","","",N,N],[5,"pthread_attr_getstack","","",N,N],[5,"memalign","","",N,N],[5,"setgroups","","",N,N],[5,"pipe2","","",N,N],[5,"statfs","","",N,N],[5,"statfs64","","",N,N],[5,"fstatfs","","",N,N],[5,"fstatfs64","","",N,N],[5,"statvfs64","","",N,N],[5,"fstatvfs64","","",N,N],[5,"memrchr","","",N,N],[5,"posix_fadvise","","",N,N],[5,"futimens","","",N,N],[5,"utimensat","","",N,N],[5,"duplocale","","",N,N],[5,"freelocale","","",N,N],[5,"newlocale","","",N,N],[5,"uselocale","","",N,N],[5,"creat64","","",N,N],[5,"fstat64","","",N,N],[5,"fstatat64","","",N,N],[5,"ftruncate64","","",N,N],[5,"getrlimit64","","",N,N],[5,"lseek64","","",N,N],[5,"lstat64","","",N,N],[5,"mmap64","","",N,N],[5,"open64","","",N,N],[5,"openat64","","",N,N],[5,"pread64","","",N,N],[5,"preadv64","","",N,N],[5,"pwrite64","","",N,N],[5,"pwritev64","","",N,N],[5,"readdir64","","",N,N],[5,"readdir64_r","","",N,N],[5,"setrlimit64","","",N,N],[5,"stat64","","",N,N],[5,"truncate64","","",N,N],[5,"mknodat","","",N,N],[5,"pthread_condattr_getclock","","",N,N],[5,"pthread_condattr_setclock","","",N,N],[5,"pthread_condattr_setpshared","","",N,N],[5,"accept4","","",N,N],[5,"pthread_mutexattr_setpshared","","",N,N],[5,"pthread_rwlockattr_getpshared","","",N,N],[5,"pthread_rwlockattr_setpshared","","",N,N],[5,"ptsname_r","","",N,N],[5,"clearenv","","",N,N],[5,"waitid","","",N,N],[5,"setreuid","","",N,N],[5,"setregid","","",N,N],[5,"getresuid","","",N,N],[5,"getresgid","","",N,N],[5,"acct","","",N,N],[5,"brk","","",N,N],[5,"sbrk","","",N,N],[5,"vfork","","",N,N],[5,"setresgid","","",N,N],[5,"setresuid","","",N,N],[5,"wait4","","",N,N],[5,"openpty","","",N,N],[5,"execvpe","","",N,N],[5,"fexecve","","",N,N],[5,"getifaddrs","","",N,N],[5,"freeifaddrs","","",N,N],[5,"bind","","",N,N],[5,"writev","","",N,N],[5,"readv","","",N,N],[5,"sendmsg","","",N,N],[5,"recvmsg","","",N,N],[5,"aio_read","","",N,N],[5,"aio_write","","",N,N],[5,"aio_fsync","","",N,N],[5,"aio_error","","",N,N],[5,"aio_return","","",N,N],[5,"aio_suspend","","",N,N],[5,"aio_cancel","","",N,N],[5,"lio_listio","","",N,N],[5,"lutimes","","",N,N],[5,"setpwent","","",N,N],[5,"endpwent","","",N,N],[5,"getpwent","","",N,N],[5,"setgrent","","",N,N],[5,"endgrent","","",N,N],[5,"getgrent","","",N,N],[5,"setspent","","",N,N],[5,"endspent","","",N,N],[5,"getspent","","",N,N],[5,"getspnam","","",N,N],[5,"shm_open","","",N,N],[5,"shmget","","",N,N],[5,"shmat","","",N,N],[5,"shmdt","","",N,N],[5,"shmctl","","",N,N],[5,"ftok","","",N,N],[5,"semget","","",N,N],[5,"semop","","",N,N],[5,"semctl","","",N,N],[5,"msgctl","","",N,N],[5,"msgget","","",N,N],[5,"msgrcv","","",N,N],[5,"msgsnd","","",N,N],[5,"mprotect","","",N,N],[5,"__errno_location","","",N,N],[5,"fopen64","","",N,N],[5,"freopen64","","",N,N],[5,"tmpfile64","","",N,N],[5,"fgetpos64","","",N,N],[5,"fsetpos64","","",N,N],[5,"fseeko64","","",N,N],[5,"ftello64","","",N,N],[5,"fallocate","","",N,N],[5,"posix_fallocate","","",N,N],[5,"readahead","","",N,N],[5,"getxattr","","",N,N],[5,"lgetxattr","","",N,N],[5,"fgetxattr","","",N,N],[5,"setxattr","","",N,N],[5,"lsetxattr","","",N,N],[5,"fsetxattr","","",N,N],[5,"listxattr","","",N,N],[5,"llistxattr","","",N,N],[5,"flistxattr","","",N,N],[5,"removexattr","","",N,N],[5,"lremovexattr","","",N,N],[5,"fremovexattr","","",N,N],[5,"signalfd","","",N,N],[5,"timerfd_create","","",N,N],[5,"timerfd_gettime","","",N,N],[5,"timerfd_settime","","",N,N],[5,"pwritev","","",N,N],[5,"preadv","","",N,N],[5,"quotactl","","",N,N],[5,"mq_open","","",N,N],[5,"mq_close","","",N,N],[5,"mq_unlink","","",N,N],[5,"mq_receive","","",N,N],[5,"mq_send","","",N,N],[5,"mq_getattr","","",N,N],[5,"mq_setattr","","",N,N],[5,"epoll_pwait","","",N,N],[5,"dup3","","",N,N],[5,"mkostemp","","",N,N],[5,"mkostemps","","",N,N],[5,"sigtimedwait","","",N,N],[5,"sigwaitinfo","","",N,N],[5,"nl_langinfo_l","","",N,N],[5,"getnameinfo","","",N,N],[5,"pthread_setschedprio","","",N,N],[5,"prlimit","","",N,N],[5,"prlimit64","","",N,N],[5,"getloadavg","","",N,N],[5,"process_vm_readv","","",N,N],[5,"process_vm_writev","","",N,N],[5,"reboot","","",N,N],[5,"setfsgid","","",N,N],[5,"setfsuid","","",N,N],[5,"mkfifoat","","",N,N],[5,"if_nameindex","","",N,N],[5,"if_freenameindex","","",N,N],[5,"sync_file_range","","",N,N],[5,"mremap","","",N,N],[5,"glob","","",N,N],[5,"globfree","","",N,N],[5,"posix_madvise","","",N,N],[5,"shm_unlink","","",N,N],[5,"seekdir","","",N,N],[5,"telldir","","",N,N],[5,"madvise","","",N,N],[5,"msync","","",N,N],[5,"remap_file_pages","","",N,N],[5,"recvfrom","","",N,N],[5,"mkstemps","","",N,N],[5,"futimes","","",N,N],[5,"nl_langinfo","","",N,N],[5,"getdomainname","","",N,N],[5,"setdomainname","","",N,N],[5,"vhangup","","",N,N],[5,"sendmmsg","","",N,N],[5,"recvmmsg","","",N,N],[5,"sync","","",N,N],[5,"syscall","","",N,N],[5,"sched_getaffinity","","",N,N],[5,"sched_setaffinity","","",N,N],[5,"epoll_create","","",N,N],[5,"epoll_create1","","",N,N],[5,"epoll_wait","","",N,N],[5,"epoll_ctl","","",N,N],[5,"pthread_getschedparam","","",N,N],[5,"unshare","","",N,N],[5,"umount","","",N,N],[5,"sched_get_priority_max","","",N,N],[5,"tee","","",N,N],[5,"settimeofday","","",N,N],[5,"splice","","",N,N],[5,"eventfd","","",N,N],[5,"sched_rr_get_interval","","",N,N],[5,"sem_timedwait","","",N,N],[5,"sem_getvalue","","",N,N],[5,"sched_setparam","","",N,N],[5,"setns","","",N,N],[5,"swapoff","","",N,N],[5,"vmsplice","","",N,N],[5,"mount","","",N,N],[5,"personality","","",N,N],[5,"prctl","","",N,N],[5,"sched_getparam","","",N,N],[5,"ppoll","","",N,N],[5,"pthread_mutex_timedlock","","",N,N],[5,"clone","","",N,N],[5,"sched_getscheduler","","",N,N],[5,"clock_nanosleep","","",N,N],[5,"pthread_attr_getguardsize","","",N,N],[5,"sethostname","","",N,N],[5,"sched_get_priority_min","","",N,N],[5,"pthread_condattr_getpshared","","",N,N],[5,"sysinfo","","",N,N],[5,"umount2","","",N,N],[5,"pthread_setschedparam","","",N,N],[5,"swapon","","",N,N],[5,"sched_setscheduler","","",N,N],[5,"sendfile","","",N,N],[5,"sigsuspend","","",N,N],[5,"getgrgid_r","","",N,N],[5,"sigaltstack","","",N,N],[5,"sem_close","","",N,N],[5,"getdtablesize","","",N,N],[5,"getgrnam_r","","",N,N],[5,"initgroups","","",N,N],[5,"pthread_sigmask","","",N,N],[5,"sem_open","","",N,N],[5,"getgrnam","","",N,N],[5,"pthread_cancel","","",N,N],[5,"pthread_kill","","",N,N],[5,"sem_unlink","","",N,N],[5,"daemon","","",N,N],[5,"getpwnam_r","","",N,N],[5,"getpwuid_r","","",N,N],[5,"sigwait","","",N,N],[5,"pthread_atfork","","",N,N],[5,"getgrgid","","",N,N],[5,"getgrouplist","","",N,N],[5,"pthread_mutexattr_getpshared","","",N,N],[5,"popen","","",N,N],[5,"faccessat","","",N,N],[5,"pthread_create","","",N,N],[5,"dl_iterate_phdr","","",N,N],[5,"setmntent","","",N,N],[5,"getmntent","","",N,N],[5,"addmntent","","",N,N],[5,"endmntent","","",N,N],[5,"hasmntopt","","",N,N],[5,"posix_spawn","","",N,N],[5,"posix_spawnp","","",N,N],[5,"posix_spawnattr_init","","",N,N],[5,"posix_spawnattr_destroy","","",N,N],[5,"posix_spawnattr_getsigdefault","","",N,N],[5,"posix_spawnattr_setsigdefault","","",N,N],[5,"posix_spawnattr_getsigmask","","",N,N],[5,"posix_spawnattr_setsigmask","","",N,N],[5,"posix_spawnattr_getflags","","",N,N],[5,"posix_spawnattr_setflags","","",N,N],[5,"posix_spawnattr_getpgroup","","",N,N],[5,"posix_spawnattr_setpgroup","","",N,N],[5,"posix_spawnattr_getschedpolicy","","",N,N],[5,"posix_spawnattr_setschedpolicy","","",N,N],[5,"posix_spawnattr_getschedparam","","",N,N],[5,"posix_spawnattr_setschedparam","","",N,N],[5,"posix_spawn_file_actions_init","","",N,N],[5,"posix_spawn_file_actions_destroy","","",N,N],[5,"posix_spawn_file_actions_addopen","","",N,N],[5,"posix_spawn_file_actions_addclose","","",N,N],[5,"posix_spawn_file_actions_adddup2","","",N,N],[5,"fread_unlocked","","",N,N],[5,"utmpxname","","",N,N],[5,"getutxent","","",N,N],[5,"getutxid","","",N,N],[5,"getutxline","","",N,N],[5,"pututxline","","",N,N],[5,"setutxent","","",N,N],[5,"endutxent","","",N,N],[5,"getpt","","",N,N],[5,"ioctl","","",N,N],[5,"backtrace","","",N,N],[5,"glob64","","",N,N],[5,"globfree64","","",N,N],[5,"ptrace","","",N,N],[5,"pthread_attr_getaffinity_np","","",N,N],[5,"pthread_attr_setaffinity_np","","",N,N],[5,"getpriority","","",N,N],[5,"setpriority","","",N,N],[5,"pthread_getaffinity_np","","",N,N],[5,"pthread_setaffinity_np","","",N,N],[5,"pthread_rwlockattr_getkind_np","","",N,N],[5,"pthread_rwlockattr_setkind_np","","",N,N],[5,"sched_getcpu","","",N,N],[5,"mallinfo","","",N,N],[5,"malloc_usable_size","","",N,N],[5,"getauxval","","",N,N],[5,"getpwent_r","","",N,N],[5,"getgrent_r","","",N,N],[5,"getcontext","","",N,N],[5,"setcontext","","",N,N],[5,"makecontext","","",N,N],[5,"swapcontext","","",N,N],[5,"iopl","","",N,N],[5,"ioperm","","",N,N],[5,"sysctl","","",N,N],[0,"macros","","",N,N],[0,"dox","","",N,N],[0,"imp","libc::dox","",N,N],[4,"Option","libc::dox::imp","The `Option` type. See the module level documentation for more.",N,N],[13,"None","","No value",132,N],[13,"Some","","Some value `T`",132,N],[8,"Clone","","A common trait for the ability to explicitly duplicate an object.",N,N],[10,"clone","","Returns a copy of the value.",133,[[["self"]],["self"]]],[11,"clone_from","","Performs copy-assignment from `source`.",133,N],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",N,N],[0,"mem","","Basic functions for dealing with memory.",N,N],[5,"forget","libc::dox::imp::mem","Leaks a value: takes ownership and \"forgets\" about the value without running its destructor.",N,N],[5,"size_of","","Returns the size of a type in bytes.",N,[[],["usize"]]],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",N,[[["t"]],["usize"]]],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",N,[[],["usize"]]],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",N,[[["t"]],["usize"]]],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",N,[[],["usize"]]],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",N,[[["t"]],["usize"]]],[5,"needs_drop","","Returns whether dropping values of type `T` matters.",N,[[],["bool"]]],[5,"zeroed","","Creates a value whose bytes are all zero.",N,[[],["t"]]],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",N,[[],["t"]]],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",N,N],[5,"replace","","Moves `src` into the referenced `dest`, returning the previous `dest` value.",N,[[["t"],["t"]],["t"]]],[5,"drop","","Disposes of a value.",N,N],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",N,[[["t"]],["u"]]],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",N,N],[12,"0","","",134,N],[12,"1","","",134,N],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",N,[[["t"]],["discriminant"]]],[3,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling `T`’s destructor.",N,N],[12,"value","","",135,N],[3,"PinMut","","A pinned reference.",N,N],[12,"inner","","",136,N],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",N,[[["t"]],["u"]]],[0,"unix","libc","Definitions found commonly among almost all Unix derivatives",N,N],[3,"group","libc::unix","",N,N],[12,"gr_name","","",0,N],[12,"gr_passwd","","",0,N],[12,"gr_gid","","",0,N],[12,"gr_mem","","",0,N],[3,"utimbuf","","",N,N],[12,"actime","","",1,N],[12,"modtime","","",1,N],[3,"timeval","","",N,N],[12,"tv_sec","","",2,N],[12,"tv_usec","","",2,N],[3,"timespec","","",N,N],[12,"tv_sec","","",3,N],[12,"tv_nsec","","",3,N],[3,"rlimit","","",N,N],[12,"rlim_cur","","",4,N],[12,"rlim_max","","",4,N],[3,"rusage","","",N,N],[12,"ru_utime","","",5,N],[12,"ru_stime","","",5,N],[12,"ru_maxrss","","",5,N],[12,"ru_ixrss","","",5,N],[12,"ru_idrss","","",5,N],[12,"ru_isrss","","",5,N],[12,"ru_minflt","","",5,N],[12,"ru_majflt","","",5,N],[12,"ru_nswap","","",5,N],[12,"ru_inblock","","",5,N],[12,"ru_oublock","","",5,N],[12,"ru_msgsnd","","",5,N],[12,"ru_msgrcv","","",5,N],[12,"ru_nsignals","","",5,N],[12,"ru_nvcsw","","",5,N],[12,"ru_nivcsw","","",5,N],[3,"in_addr","","",N,N],[12,"s_addr","","",6,N],[3,"in6_addr","","",N,N],[12,"s6_addr","","",7,N],[12,"__align","","",7,N],[3,"ip_mreq","","",N,N],[12,"imr_multiaddr","","",8,N],[12,"imr_interface","","",8,N],[3,"ipv6_mreq","","",N,N],[12,"ipv6mr_multiaddr","","",9,N],[12,"ipv6mr_interface","","",9,N],[3,"hostent","","",N,N],[12,"h_name","","",10,N],[12,"h_aliases","","",10,N],[12,"h_addrtype","","",10,N],[12,"h_length","","",10,N],[12,"h_addr_list","","",10,N],[3,"iovec","","",N,N],[12,"iov_base","","",11,N],[12,"iov_len","","",11,N],[3,"pollfd","","",N,N],[12,"fd","","",12,N],[12,"events","","",12,N],[12,"revents","","",12,N],[3,"winsize","","",N,N],[12,"ws_row","","",13,N],[12,"ws_col","","",13,N],[12,"ws_xpixel","","",13,N],[12,"ws_ypixel","","",13,N],[3,"linger","","",N,N],[12,"l_onoff","","",14,N],[12,"l_linger","","",14,N],[3,"sigval","","",N,N],[12,"sival_ptr","","",15,N],[3,"itimerval","","",N,N],[12,"it_interval","","",16,N],[12,"it_value","","",16,N],[3,"tms","","",N,N],[12,"tms_utime","","",17,N],[12,"tms_stime","","",17,N],[12,"tms_cutime","","",17,N],[12,"tms_cstime","","",17,N],[3,"servent","","",N,N],[12,"s_name","","",18,N],[12,"s_aliases","","",18,N],[12,"s_port","","",18,N],[12,"s_proto","","",18,N],[3,"protoent","","",N,N],[12,"p_name","","",19,N],[12,"p_aliases","","",19,N],[12,"p_proto","","",19,N],[4,"DIR","","",N,N],[4,"locale_t","","",N,N],[5,"getpwnam","","",N,N],[5,"getpwuid","","",N,N],[5,"fprintf","","",N,N],[5,"printf","","",N,N],[5,"snprintf","","",N,N],[5,"sprintf","","",N,N],[5,"fscanf","","",N,N],[5,"scanf","","",N,N],[5,"sscanf","","",N,N],[5,"getchar_unlocked","","",N,N],[5,"putchar_unlocked","","",N,N],[5,"socket","","",N,N],[5,"connect","","",N,N],[5,"listen","","",N,N],[5,"accept","","",N,N],[5,"getpeername","","",N,N],[5,"getsockname","","",N,N],[5,"setsockopt","","",N,N],[5,"socketpair","","",N,N],[5,"sendto","","",N,N],[5,"shutdown","","",N,N],[5,"chmod","","",N,N],[5,"fchmod","","",N,N],[5,"fstat","","",N,N],[5,"mkdir","","",N,N],[5,"stat","","",N,N],[5,"pclose","","",N,N],[5,"fdopen","","",N,N],[5,"fileno","","",N,N],[5,"open","","",N,N],[5,"creat","","",N,N],[5,"fcntl","","",N,N],[5,"opendir","","",N,N],[5,"fdopendir","","",N,N],[5,"readdir","","",N,N],[5,"readdir_r","","",N,N],[5,"closedir","","",N,N],[5,"rewinddir","","",N,N],[5,"openat","","",N,N],[5,"fchmodat","","",N,N],[5,"fchown","","",N,N],[5,"fchownat","","",N,N],[5,"fstatat","","",N,N],[5,"linkat","","",N,N],[5,"mkdirat","","",N,N],[5,"readlinkat","","",N,N],[5,"renameat","","",N,N],[5,"symlinkat","","",N,N],[5,"unlinkat","","",N,N],[5,"access","","",N,N],[5,"alarm","","",N,N],[5,"chdir","","",N,N],[5,"fchdir","","",N,N],[5,"chown","","",N,N],[5,"lchown","","",N,N],[5,"close","","",N,N],[5,"dup","","",N,N],[5,"dup2","","",N,N],[5,"execl","","",N,N],[5,"execle","","",N,N],[5,"execlp","","",N,N],[5,"execv","","",N,N],[5,"execve","","",N,N],[5,"execvp","","",N,N],[5,"fork","","",N,N],[5,"fpathconf","","",N,N],[5,"getcwd","","",N,N],[5,"getegid","","",N,N],[5,"geteuid","","",N,N],[5,"getgid","","",N,N],[5,"getgroups","","",N,N],[5,"getlogin","","",N,N],[5,"getopt","","",N,N],[5,"getpgid","","",N,N],[5,"getpgrp","","",N,N],[5,"getpid","","",N,N],[5,"getppid","","",N,N],[5,"getuid","","",N,N],[5,"isatty","","",N,N],[5,"link","","",N,N],[5,"lseek","","",N,N],[5,"pathconf","","",N,N],[5,"pause","","",N,N],[5,"pipe","","",N,N],[5,"posix_memalign","","",N,N],[5,"read","","",N,N],[5,"rmdir","","",N,N],[5,"seteuid","","",N,N],[5,"setgid","","",N,N],[5,"setpgid","","",N,N],[5,"setsid","","",N,N],[5,"setuid","","",N,N],[5,"sleep","","",N,N],[5,"nanosleep","","",N,N],[5,"tcgetpgrp","","",N,N],[5,"tcsetpgrp","","",N,N],[5,"ttyname","","",N,N],[5,"unlink","","",N,N],[5,"wait","","",N,N],[5,"waitpid","","",N,N],[5,"write","","",N,N],[5,"pread","","",N,N],[5,"pwrite","","",N,N],[5,"umask","","",N,N],[5,"utime","","",N,N],[5,"kill","","",N,N],[5,"killpg","","",N,N],[5,"mlock","","",N,N],[5,"munlock","","",N,N],[5,"mlockall","","",N,N],[5,"munlockall","","",N,N],[5,"mmap","","",N,N],[5,"munmap","","",N,N],[5,"if_nametoindex","","",N,N],[5,"if_indextoname","","",N,N],[5,"lstat","","",N,N],[5,"fsync","","",N,N],[5,"setenv","","",N,N],[5,"unsetenv","","",N,N],[5,"symlink","","",N,N],[5,"ftruncate","","",N,N],[5,"signal","","",N,N],[5,"getrlimit","","",N,N],[5,"setrlimit","","",N,N],[5,"getrusage","","",N,N],[5,"realpath","","",N,N],[5,"flock","","",N,N],[5,"gettimeofday","","",N,N],[5,"times","","",N,N],[5,"pthread_self","","",N,N],[5,"pthread_join","","",N,N],[5,"pthread_exit","","",N,N],[5,"pthread_attr_init","","",N,N],[5,"pthread_attr_destroy","","",N,N],[5,"pthread_attr_setstacksize","","",N,N],[5,"pthread_attr_setdetachstate","","",N,N],[5,"pthread_detach","","",N,N],[5,"sched_yield","","",N,N],[5,"pthread_key_create","","",N,N],[5,"pthread_key_delete","","",N,N],[5,"pthread_getspecific","","",N,N],[5,"pthread_setspecific","","",N,N],[5,"pthread_mutex_init","","",N,N],[5,"pthread_mutex_destroy","","",N,N],[5,"pthread_mutex_lock","","",N,N],[5,"pthread_mutex_trylock","","",N,N],[5,"pthread_mutex_unlock","","",N,N],[5,"pthread_mutexattr_init","","",N,N],[5,"pthread_mutexattr_destroy","","",N,N],[5,"pthread_mutexattr_settype","","",N,N],[5,"pthread_cond_init","","",N,N],[5,"pthread_cond_wait","","",N,N],[5,"pthread_cond_timedwait","","",N,N],[5,"pthread_cond_signal","","",N,N],[5,"pthread_cond_broadcast","","",N,N],[5,"pthread_cond_destroy","","",N,N],[5,"pthread_condattr_init","","",N,N],[5,"pthread_condattr_destroy","","",N,N],[5,"pthread_rwlock_init","","",N,N],[5,"pthread_rwlock_destroy","","",N,N],[5,"pthread_rwlock_rdlock","","",N,N],[5,"pthread_rwlock_tryrdlock","","",N,N],[5,"pthread_rwlock_wrlock","","",N,N],[5,"pthread_rwlock_trywrlock","","",N,N],[5,"pthread_rwlock_unlock","","",N,N],[5,"pthread_rwlockattr_init","","",N,N],[5,"pthread_rwlockattr_destroy","","",N,N],[5,"strerror_r","","",N,N],[5,"getsockopt","","",N,N],[5,"raise","","",N,N],[5,"sigaction","","",N,N],[5,"utimes","","",N,N],[5,"dlopen","","",N,N],[5,"dlerror","","",N,N],[5,"dlsym","","",N,N],[5,"dlclose","","",N,N],[5,"dladdr","","",N,N],[5,"getaddrinfo","","",N,N],[5,"freeaddrinfo","","",N,N],[5,"gai_strerror","","",N,N],[5,"res_init","","",N,N],[5,"gmtime_r","","",N,N],[5,"localtime_r","","",N,N],[5,"mktime","","",N,N],[5,"time","","",N,N],[5,"gmtime","","",N,N],[5,"localtime","","",N,N],[5,"difftime","","",N,N],[5,"mknod","","",N,N],[5,"uname","","",N,N],[5,"gethostname","","",N,N],[5,"getservbyname","","",N,N],[5,"getprotobyname","","",N,N],[5,"getprotobynumber","","",N,N],[5,"chroot","","",N,N],[5,"usleep","","",N,N],[5,"send","","",N,N],[5,"recv","","",N,N],[5,"putenv","","",N,N],[5,"poll","","",N,N],[5,"select","","",N,N],[5,"setlocale","","",N,N],[5,"localeconv","","",N,N],[5,"sem_destroy","","",N,N],[5,"sem_wait","","",N,N],[5,"sem_trywait","","",N,N],[5,"sem_post","","",N,N],[5,"sem_init","","",N,N],[5,"statvfs","","",N,N],[5,"fstatvfs","","",N,N],[5,"readlink","","",N,N],[5,"sigemptyset","","",N,N],[5,"sigaddset","","",N,N],[5,"sigfillset","","",N,N],[5,"sigdelset","","",N,N],[5,"sigismember","","",N,N],[5,"sigprocmask","","",N,N],[5,"sigpending","","",N,N],[5,"timegm","","",N,N],[5,"getsid","","",N,N],[5,"sysconf","","",N,N],[5,"mkfifo","","",N,N],[5,"pselect","","",N,N],[5,"fseeko","","",N,N],[5,"ftello","","",N,N],[5,"tcdrain","","",N,N],[5,"cfgetispeed","","",N,N],[5,"cfgetospeed","","",N,N],[5,"cfmakeraw","","",N,N],[5,"cfsetispeed","","",N,N],[5,"cfsetospeed","","",N,N],[5,"cfsetspeed","","",N,N],[5,"tcgetattr","","",N,N],[5,"tcsetattr","","",N,N],[5,"tcflow","","",N,N],[5,"tcflush","","",N,N],[5,"tcgetsid","","",N,N],[5,"tcsendbreak","","",N,N],[5,"mkstemp","","",N,N],[5,"mkdtemp","","",N,N],[5,"tmpnam","","",N,N],[5,"openlog","","",N,N],[5,"closelog","","",N,N],[5,"setlogmask","","",N,N],[5,"syslog","","",N,N],[5,"nice","","",N,N],[5,"grantpt","","",N,N],[5,"posix_openpt","","",N,N],[5,"ptsname","","",N,N],[5,"unlockpt","","",N,N],[0,"notbsd","","",N,N],[3,"sockaddr","libc::unix::notbsd","",N,N],[12,"sa_family","","",20,N],[12,"sa_data","","",20,N],[3,"sockaddr_in","","",N,N],[12,"sin_family","","",21,N],[12,"sin_port","","",21,N],[12,"sin_addr","","",21,N],[12,"sin_zero","","",21,N],[3,"sockaddr_in6","","",N,N],[12,"sin6_family","","",22,N],[12,"sin6_port","","",22,N],[12,"sin6_flowinfo","","",22,N],[12,"sin6_addr","","",22,N],[12,"sin6_scope_id","","",22,N],[3,"sockaddr_un","","",N,N],[12,"sun_family","","",23,N],[12,"sun_path","","",23,N],[3,"sockaddr_storage","","",N,N],[12,"ss_family","","",24,N],[12,"__ss_align","","",24,N],[12,"__ss_pad2","","",24,N],[3,"addrinfo","","",N,N],[12,"ai_flags","","",25,N],[12,"ai_family","","",25,N],[12,"ai_socktype","","",25,N],[12,"ai_protocol","","",25,N],[12,"ai_addrlen","","",25,N],[12,"ai_addr","","",25,N],[12,"ai_canonname","","",25,N],[12,"ai_next","","",25,N],[3,"sockaddr_nl","","",N,N],[12,"nl_family","","",26,N],[12,"nl_pad","","",26,N],[12,"nl_pid","","",26,N],[12,"nl_groups","","",26,N],[3,"sockaddr_ll","","",N,N],[12,"sll_family","","",27,N],[12,"sll_protocol","","",27,N],[12,"sll_ifindex","","",27,N],[12,"sll_hatype","","",27,N],[12,"sll_pkttype","","",27,N],[12,"sll_halen","","",27,N],[12,"sll_addr","","",27,N],[3,"fd_set","","",N,N],[12,"fds_bits","","",28,N],[3,"tm","","",N,N],[12,"tm_sec","","",29,N],[12,"tm_min","","",29,N],[12,"tm_hour","","",29,N],[12,"tm_mday","","",29,N],[12,"tm_mon","","",29,N],[12,"tm_year","","",29,N],[12,"tm_wday","","",29,N],[12,"tm_yday","","",29,N],[12,"tm_isdst","","",29,N],[12,"tm_gmtoff","","",29,N],[12,"tm_zone","","",29,N],[3,"sched_param","","",N,N],[12,"sched_priority","","",30,N],[3,"Dl_info","","",N,N],[12,"dli_fname","","",31,N],[12,"dli_fbase","","",31,N],[12,"dli_sname","","",31,N],[12,"dli_saddr","","",31,N],[3,"epoll_event","","",N,N],[12,"events","","",32,N],[12,"u64","","",32,N],[3,"utsname","","",N,N],[12,"sysname","","",33,N],[12,"nodename","","",33,N],[12,"release","","",33,N],[12,"version","","",33,N],[12,"machine","","",33,N],[12,"domainname","","",33,N],[3,"lconv","","",N,N],[12,"decimal_point","","",34,N],[12,"thousands_sep","","",34,N],[12,"grouping","","",34,N],[12,"int_curr_symbol","","",34,N],[12,"currency_symbol","","",34,N],[12,"mon_decimal_point","","",34,N],[12,"mon_thousands_sep","","",34,N],[12,"mon_grouping","","",34,N],[12,"positive_sign","","",34,N],[12,"negative_sign","","",34,N],[12,"int_frac_digits","","",34,N],[12,"frac_digits","","",34,N],[12,"p_cs_precedes","","",34,N],[12,"p_sep_by_space","","",34,N],[12,"n_cs_precedes","","",34,N],[12,"n_sep_by_space","","",34,N],[12,"p_sign_posn","","",34,N],[12,"n_sign_posn","","",34,N],[12,"int_p_cs_precedes","","",34,N],[12,"int_p_sep_by_space","","",34,N],[12,"int_n_cs_precedes","","",34,N],[12,"int_n_sep_by_space","","",34,N],[12,"int_p_sign_posn","","",34,N],[12,"int_n_sign_posn","","",34,N],[3,"sigevent","","",N,N],[12,"sigev_value","","",35,N],[12,"sigev_signo","","",35,N],[12,"sigev_notify","","",35,N],[12,"sigev_notify_thread_id","","",35,N],[12,"__unused1","","",35,N],[3,"in_pktinfo","","",N,N],[12,"ipi_ifindex","","",36,N],[12,"ipi_spec_dst","","",36,N],[12,"ipi_addr","","",36,N],[3,"ifaddrs","","",N,N],[12,"ifa_next","","",37,N],[12,"ifa_name","","",37,N],[12,"ifa_flags","","",37,N],[12,"ifa_addr","","",37,N],[12,"ifa_netmask","","",37,N],[12,"ifa_ifu","","",37,N],[12,"ifa_data","","",37,N],[3,"in6_rtmsg","","",N,N],[12,"rtmsg_dst","","",38,N],[12,"rtmsg_src","","",38,N],[12,"rtmsg_gateway","","",38,N],[12,"rtmsg_type","","",38,N],[12,"rtmsg_dst_len","","",38,N],[12,"rtmsg_src_len","","",38,N],[12,"rtmsg_metric","","",38,N],[12,"rtmsg_info","","",38,N],[12,"rtmsg_flags","","",38,N],[12,"rtmsg_ifindex","","",38,N],[3,"arpreq","","",N,N],[12,"arp_pa","","",39,N],[12,"arp_ha","","",39,N],[12,"arp_flags","","",39,N],[12,"arp_netmask","","",39,N],[12,"arp_dev","","",39,N],[3,"arpreq_old","","",N,N],[12,"arp_pa","","",40,N],[12,"arp_ha","","",40,N],[12,"arp_flags","","",40,N],[12,"arp_netmask","","",40,N],[3,"arphdr","","",N,N],[12,"ar_hrd","","",41,N],[12,"ar_pro","","",41,N],[12,"ar_hln","","",41,N],[12,"ar_pln","","",41,N],[12,"ar_op","","",41,N],[4,"timezone","","",N,N],[5,"FD_CLR","","",N,N],[5,"FD_ISSET","","",N,N],[5,"FD_SET","","",N,N],[5,"FD_ZERO","","",N,N],[5,"WIFSTOPPED","","",N,[[["c_int"]],["bool"]]],[5,"WSTOPSIG","","",N,[[["c_int"]],["c_int"]]],[5,"WIFCONTINUED","","",N,[[["c_int"]],["bool"]]],[5,"WIFSIGNALED","","",N,[[["c_int"]],["bool"]]],[5,"WTERMSIG","","",N,[[["c_int"]],["c_int"]]],[5,"WIFEXITED","","",N,[[["c_int"]],["bool"]]],[5,"WEXITSTATUS","","",N,[[["c_int"]],["c_int"]]],[5,"WCOREDUMP","","",N,[[["c_int"]],["bool"]]],[5,"QCMD","","",N,[[["c_int"],["c_int"]],["c_int"]]],[5,"IPOPT_COPIED","","",N,[[["u8"]],["u8"]]],[5,"IPOPT_CLASS","","",N,[[["u8"]],["u8"]]],[5,"IPOPT_NUMBER","","",N,[[["u8"]],["u8"]]],[5,"fdatasync","","",N,N],[5,"mincore","","",N,N],[5,"clock_getres","","",N,N],[5,"clock_gettime","","",N,N],[5,"clock_settime","","",N,N],[5,"dirfd","","",N,N],[5,"pthread_getattr_np","","",N,N],[5,"pthread_attr_getstack","","",N,N],[5,"memalign","","",N,N],[5,"setgroups","","",N,N],[5,"pipe2","","",N,N],[5,"statfs","","",N,N],[5,"statfs64","","",N,N],[5,"fstatfs","","",N,N],[5,"fstatfs64","","",N,N],[5,"statvfs64","","",N,N],[5,"fstatvfs64","","",N,N],[5,"memrchr","","",N,N],[5,"posix_fadvise","","",N,N],[5,"futimens","","",N,N],[5,"utimensat","","",N,N],[5,"duplocale","","",N,N],[5,"freelocale","","",N,N],[5,"newlocale","","",N,N],[5,"uselocale","","",N,N],[5,"creat64","","",N,N],[5,"fstat64","","",N,N],[5,"fstatat64","","",N,N],[5,"ftruncate64","","",N,N],[5,"getrlimit64","","",N,N],[5,"lseek64","","",N,N],[5,"lstat64","","",N,N],[5,"mmap64","","",N,N],[5,"open64","","",N,N],[5,"openat64","","",N,N],[5,"pread64","","",N,N],[5,"preadv64","","",N,N],[5,"pwrite64","","",N,N],[5,"pwritev64","","",N,N],[5,"readdir64","","",N,N],[5,"readdir64_r","","",N,N],[5,"setrlimit64","","",N,N],[5,"stat64","","",N,N],[5,"truncate64","","",N,N],[5,"mknodat","","",N,N],[5,"pthread_condattr_getclock","","",N,N],[5,"pthread_condattr_setclock","","",N,N],[5,"pthread_condattr_setpshared","","",N,N],[5,"accept4","","",N,N],[5,"pthread_mutexattr_setpshared","","",N,N],[5,"pthread_rwlockattr_getpshared","","",N,N],[5,"pthread_rwlockattr_setpshared","","",N,N],[5,"ptsname_r","","",N,N],[5,"clearenv","","",N,N],[5,"waitid","","",N,N],[5,"setreuid","","",N,N],[5,"setregid","","",N,N],[5,"getresuid","","",N,N],[5,"getresgid","","",N,N],[5,"acct","","",N,N],[5,"brk","","",N,N],[5,"sbrk","","",N,N],[5,"vfork","","",N,N],[5,"setresgid","","",N,N],[5,"setresuid","","",N,N],[5,"wait4","","",N,N],[5,"openpty","","",N,N],[5,"execvpe","","",N,N],[5,"fexecve","","",N,N],[5,"getifaddrs","","",N,N],[5,"freeifaddrs","","",N,N],[5,"bind","","",N,N],[5,"writev","","",N,N],[5,"readv","","",N,N],[5,"sendmsg","","",N,N],[5,"recvmsg","","",N,N],[0,"linux","","Linux-specific definitions for linux-like values",N,N],[3,"dirent","libc::unix::notbsd::linux","",N,N],[12,"d_ino","","",42,N],[12,"d_off","","",42,N],[12,"d_reclen","","",42,N],[12,"d_type","","",42,N],[12,"d_name","","",42,N],[3,"dirent64","","",N,N],[12,"d_ino","","",43,N],[12,"d_off","","",43,N],[12,"d_reclen","","",43,N],[12,"d_type","","",43,N],[12,"d_name","","",43,N],[3,"rlimit64","","",N,N],[12,"rlim_cur","","",44,N],[12,"rlim_max","","",44,N],[3,"glob_t","","",N,N],[12,"gl_pathc","","",45,N],[12,"gl_pathv","","",45,N],[12,"gl_offs","","",45,N],[12,"gl_flags","","",45,N],[12,"__unused1","","",45,N],[12,"__unused2","","",45,N],[12,"__unused3","","",45,N],[12,"__unused4","","",45,N],[12,"__unused5","","",45,N],[3,"pthread_mutex_t","","",N,N],[12,"__align","","",46,N],[12,"size","","",46,N],[3,"pthread_rwlock_t","","",N,N],[12,"__align","","",47,N],[12,"size","","",47,N],[3,"pthread_mutexattr_t","","",N,N],[12,"__align","","",48,N],[12,"size","","",48,N],[3,"pthread_rwlockattr_t","","",N,N],[12,"__align","","",49,N],[12,"size","","",49,N],[3,"pthread_cond_t","","",N,N],[12,"__align","","",50,N],[12,"size","","",50,N],[3,"pthread_condattr_t","","",N,N],[12,"__align","","",51,N],[12,"size","","",51,N],[3,"passwd","","",N,N],[12,"pw_name","","",52,N],[12,"pw_passwd","","",52,N],[12,"pw_uid","","",52,N],[12,"pw_gid","","",52,N],[12,"pw_gecos","","",52,N],[12,"pw_dir","","",52,N],[12,"pw_shell","","",52,N],[3,"spwd","","",N,N],[12,"sp_namp","","",53,N],[12,"sp_pwdp","","",53,N],[12,"sp_lstchg","","",53,N],[12,"sp_min","","",53,N],[12,"sp_max","","",53,N],[12,"sp_warn","","",53,N],[12,"sp_inact","","",53,N],[12,"sp_expire","","",53,N],[12,"sp_flag","","",53,N],[3,"dqblk","","",N,N],[12,"dqb_bhardlimit","","",54,N],[12,"dqb_bsoftlimit","","",54,N],[12,"dqb_curspace","","",54,N],[12,"dqb_ihardlimit","","",54,N],[12,"dqb_isoftlimit","","",54,N],[12,"dqb_curinodes","","",54,N],[12,"dqb_btime","","",54,N],[12,"dqb_itime","","",54,N],[12,"dqb_valid","","",54,N],[3,"signalfd_siginfo","","",N,N],[12,"ssi_signo","","",55,N],[12,"ssi_errno","","",55,N],[12,"ssi_code","","",55,N],[12,"ssi_pid","","",55,N],[12,"ssi_uid","","",55,N],[12,"ssi_fd","","",55,N],[12,"ssi_tid","","",55,N],[12,"ssi_band","","",55,N],[12,"ssi_overrun","","",55,N],[12,"ssi_trapno","","",55,N],[12,"ssi_status","","",55,N],[12,"ssi_int","","",55,N],[12,"ssi_ptr","","",55,N],[12,"ssi_utime","","",55,N],[12,"ssi_stime","","",55,N],[12,"ssi_addr","","",55,N],[12,"_pad","","",55,N],[3,"itimerspec","","",N,N],[12,"it_interval","","",56,N],[12,"it_value","","",56,N],[3,"fsid_t","","",N,N],[12,"__val","","",57,N],[3,"mq_attr","","",N,N],[12,"mq_flags","","",58,N],[12,"mq_maxmsg","","",58,N],[12,"mq_msgsize","","",58,N],[12,"mq_curmsgs","","",58,N],[12,"pad","","",58,N],[3,"packet_mreq","","",N,N],[12,"mr_ifindex","","",59,N],[12,"mr_type","","",59,N],[12,"mr_alen","","",59,N],[12,"mr_address","","",59,N],[3,"cpu_set_t","","",N,N],[12,"bits","","",60,N],[3,"if_nameindex","","",N,N],[12,"if_index","","",61,N],[12,"if_name","","",61,N],[3,"msginfo","","",N,N],[12,"msgpool","","",62,N],[12,"msgmap","","",62,N],[12,"msgmax","","",62,N],[12,"msgmnb","","",62,N],[12,"msgmni","","",62,N],[12,"msgssz","","",62,N],[12,"msgtql","","",62,N],[12,"msgseg","","",62,N],[3,"mmsghdr","","",N,N],[12,"msg_hdr","","",63,N],[12,"msg_len","","",63,N],[3,"sembuf","","",N,N],[12,"sem_num","","",64,N],[12,"sem_op","","",64,N],[12,"sem_flg","","",64,N],[3,"input_event","","",N,N],[12,"time","","",65,N],[12,"type_","","",65,N],[12,"code","","",65,N],[12,"value","","",65,N],[3,"input_id","","",N,N],[12,"bustype","","",66,N],[12,"vendor","","",66,N],[12,"product","","",66,N],[12,"version","","",66,N],[3,"input_absinfo","","",N,N],[12,"value","","",67,N],[12,"minimum","","",67,N],[12,"maximum","","",67,N],[12,"fuzz","","",67,N],[12,"flat","","",67,N],[12,"resolution","","",67,N],[3,"input_keymap_entry","","",N,N],[12,"flags","","",68,N],[12,"len","","",68,N],[12,"index","","",68,N],[12,"keycode","","",68,N],[12,"scancode","","",68,N],[3,"input_mask","","",N,N],[12,"type_","","",69,N],[12,"codes_size","","",69,N],[12,"codes_ptr","","",69,N],[3,"ff_replay","","",N,N],[12,"length","","",70,N],[12,"delay","","",70,N],[3,"ff_trigger","","",N,N],[12,"button","","",71,N],[12,"interval","","",71,N],[3,"ff_envelope","","",N,N],[12,"attack_length","","",72,N],[12,"attack_level","","",72,N],[12,"fade_length","","",72,N],[12,"fade_level","","",72,N],[3,"ff_constant_effect","","",N,N],[12,"level","","",73,N],[12,"envelope","","",73,N],[3,"ff_ramp_effect","","",N,N],[12,"start_level","","",74,N],[12,"end_level","","",74,N],[12,"envelope","","",74,N],[3,"ff_condition_effect","","",N,N],[12,"right_saturation","","",75,N],[12,"left_saturation","","",75,N],[12,"right_coeff","","",75,N],[12,"left_coeff","","",75,N],[12,"deadband","","",75,N],[12,"center","","",75,N],[3,"ff_periodic_effect","","",N,N],[12,"waveform","","",76,N],[12,"period","","",76,N],[12,"magnitude","","",76,N],[12,"offset","","",76,N],[12,"phase","","",76,N],[12,"envelope","","",76,N],[12,"custom_len","","",76,N],[12,"custom_data","","",76,N],[3,"ff_rumble_effect","","",N,N],[12,"strong_magnitude","","",77,N],[12,"weak_magnitude","","",77,N],[3,"ff_effect","","",N,N],[12,"type_","","",78,N],[12,"id","","",78,N],[12,"direction","","",78,N],[12,"trigger","","",78,N],[12,"replay","","",78,N],[12,"u","","",78,N],[3,"dl_phdr_info","","",N,N],[12,"dlpi_addr","","",79,N],[12,"dlpi_name","","",79,N],[12,"dlpi_phdr","","",79,N],[12,"dlpi_phnum","","",79,N],[12,"dlpi_adds","","",79,N],[12,"dlpi_subs","","",79,N],[12,"dlpi_tls_modid","","",79,N],[12,"dlpi_tls_data","","",79,N],[3,"Elf32_Phdr","","",N,N],[12,"p_type","","",80,N],[12,"p_offset","","",80,N],[12,"p_vaddr","","",80,N],[12,"p_paddr","","",80,N],[12,"p_filesz","","",80,N],[12,"p_memsz","","",80,N],[12,"p_flags","","",80,N],[12,"p_align","","",80,N],[3,"Elf64_Phdr","","",N,N],[12,"p_type","","",81,N],[12,"p_flags","","",81,N],[12,"p_offset","","",81,N],[12,"p_vaddr","","",81,N],[12,"p_paddr","","",81,N],[12,"p_filesz","","",81,N],[12,"p_memsz","","",81,N],[12,"p_align","","",81,N],[3,"ucred","","",N,N],[12,"pid","","",82,N],[12,"uid","","",82,N],[12,"gid","","",82,N],[3,"mntent","","",N,N],[12,"mnt_fsname","","",83,N],[12,"mnt_dir","","",83,N],[12,"mnt_type","","",83,N],[12,"mnt_opts","","",83,N],[12,"mnt_freq","","",83,N],[12,"mnt_passno","","",83,N],[3,"posix_spawn_file_actions_t","","",N,N],[12,"__allocated","","",84,N],[12,"__used","","",84,N],[12,"__actions","","",84,N],[12,"__pad","","",84,N],[3,"posix_spawnattr_t","","",N,N],[12,"__flags","","",85,N],[12,"__pgrp","","",85,N],[12,"__sd","","",85,N],[12,"__ss","","",85,N],[12,"__sp","","",85,N],[12,"__policy","","",85,N],[12,"__pad","","",85,N],[3,"genlmsghdr","","",N,N],[12,"cmd","","",86,N],[12,"version","","",86,N],[12,"reserved","","",86,N],[3,"in6_pktinfo","","",N,N],[12,"ipi6_addr","","",87,N],[12,"ipi6_ifindex","","",87,N],[3,"arpd_request","","",N,N],[12,"req","","",88,N],[12,"ip","","",88,N],[12,"dev","","",88,N],[12,"stamp","","",88,N],[12,"updated","","",88,N],[12,"ha","","",88,N],[4,"fpos64_t","","",N,N],[5,"CPU_ZERO","","",N,N],[5,"CPU_SET","","",N,N],[5,"CPU_CLR","","",N,N],[5,"CPU_ISSET","","",N,[[["usize"],["cpu_set_t"]],["bool"]]],[5,"CPU_EQUAL","","",N,[[["cpu_set_t"],["cpu_set_t"]],["bool"]]],[5,"major","","",N,[[["dev_t"]],["c_uint"]]],[5,"minor","","",N,[[["dev_t"]],["c_uint"]]],[5,"makedev","","",N,[[["c_uint"],["c_uint"]],["dev_t"]]],[5,"IPTOS_TOS","","",N,[[["u8"]],["u8"]]],[5,"IPTOS_PREC","","",N,[[["u8"]],["u8"]]],[5,"RT_TOS","","",N,[[["u8"]],["u8"]]],[5,"RT_ADDRCLASS","","",N,[[["u32"]],["u32"]]],[5,"RT_LOCALADDR","","",N,[[["u32"]],["bool"]]],[5,"aio_read","","",N,N],[5,"aio_write","","",N,N],[5,"aio_fsync","","",N,N],[5,"aio_error","","",N,N],[5,"aio_return","","",N,N],[5,"aio_suspend","","",N,N],[5,"aio_cancel","","",N,N],[5,"lio_listio","","",N,N],[5,"lutimes","","",N,N],[5,"setpwent","","",N,N],[5,"endpwent","","",N,N],[5,"getpwent","","",N,N],[5,"setgrent","","",N,N],[5,"endgrent","","",N,N],[5,"getgrent","","",N,N],[5,"setspent","","",N,N],[5,"endspent","","",N,N],[5,"getspent","","",N,N],[5,"getspnam","","",N,N],[5,"shm_open","","",N,N],[5,"shmget","","",N,N],[5,"shmat","","",N,N],[5,"shmdt","","",N,N],[5,"shmctl","","",N,N],[5,"ftok","","",N,N],[5,"semget","","",N,N],[5,"semop","","",N,N],[5,"semctl","","",N,N],[5,"msgctl","","",N,N],[5,"msgget","","",N,N],[5,"msgrcv","","",N,N],[5,"msgsnd","","",N,N],[5,"mprotect","","",N,N],[5,"__errno_location","","",N,N],[5,"fopen64","","",N,N],[5,"freopen64","","",N,N],[5,"tmpfile64","","",N,N],[5,"fgetpos64","","",N,N],[5,"fsetpos64","","",N,N],[5,"fseeko64","","",N,N],[5,"ftello64","","",N,N],[5,"fallocate","","",N,N],[5,"posix_fallocate","","",N,N],[5,"readahead","","",N,N],[5,"getxattr","","",N,N],[5,"lgetxattr","","",N,N],[5,"fgetxattr","","",N,N],[5,"setxattr","","",N,N],[5,"lsetxattr","","",N,N],[5,"fsetxattr","","",N,N],[5,"listxattr","","",N,N],[5,"llistxattr","","",N,N],[5,"flistxattr","","",N,N],[5,"removexattr","","",N,N],[5,"lremovexattr","","",N,N],[5,"fremovexattr","","",N,N],[5,"signalfd","","",N,N],[5,"timerfd_create","","",N,N],[5,"timerfd_gettime","","",N,N],[5,"timerfd_settime","","",N,N],[5,"pwritev","","",N,N],[5,"preadv","","",N,N],[5,"quotactl","","",N,N],[5,"mq_open","","",N,N],[5,"mq_close","","",N,N],[5,"mq_unlink","","",N,N],[5,"mq_receive","","",N,N],[5,"mq_send","","",N,N],[5,"mq_getattr","","",N,N],[5,"mq_setattr","","",N,N],[5,"epoll_pwait","","",N,N],[5,"dup3","","",N,N],[5,"mkostemp","","",N,N],[5,"mkostemps","","",N,N],[5,"sigtimedwait","","",N,N],[5,"sigwaitinfo","","",N,N],[5,"nl_langinfo_l","","",N,N],[5,"getnameinfo","","",N,N],[5,"pthread_setschedprio","","",N,N],[5,"prlimit","","",N,N],[5,"prlimit64","","",N,N],[5,"getloadavg","","",N,N],[5,"process_vm_readv","","",N,N],[5,"process_vm_writev","","",N,N],[5,"reboot","","",N,N],[5,"setfsgid","","",N,N],[5,"setfsuid","","",N,N],[5,"mkfifoat","","",N,N],[5,"if_nameindex","","",N,N],[5,"if_freenameindex","","",N,N],[5,"sync_file_range","","",N,N],[5,"mremap","","",N,N],[5,"glob","","",N,N],[5,"globfree","","",N,N],[5,"posix_madvise","","",N,N],[5,"shm_unlink","","",N,N],[5,"seekdir","","",N,N],[5,"telldir","","",N,N],[5,"madvise","","",N,N],[5,"msync","","",N,N],[5,"remap_file_pages","","",N,N],[5,"recvfrom","","",N,N],[5,"mkstemps","","",N,N],[5,"futimes","","",N,N],[5,"nl_langinfo","","",N,N],[5,"getdomainname","","",N,N],[5,"setdomainname","","",N,N],[5,"vhangup","","",N,N],[5,"sendmmsg","","",N,N],[5,"recvmmsg","","",N,N],[5,"sync","","",N,N],[5,"syscall","","",N,N],[5,"sched_getaffinity","","",N,N],[5,"sched_setaffinity","","",N,N],[5,"epoll_create","","",N,N],[5,"epoll_create1","","",N,N],[5,"epoll_wait","","",N,N],[5,"epoll_ctl","","",N,N],[5,"pthread_getschedparam","","",N,N],[5,"unshare","","",N,N],[5,"umount","","",N,N],[5,"sched_get_priority_max","","",N,N],[5,"tee","","",N,N],[5,"settimeofday","","",N,N],[5,"splice","","",N,N],[5,"eventfd","","",N,N],[5,"sched_rr_get_interval","","",N,N],[5,"sem_timedwait","","",N,N],[5,"sem_getvalue","","",N,N],[5,"sched_setparam","","",N,N],[5,"setns","","",N,N],[5,"swapoff","","",N,N],[5,"vmsplice","","",N,N],[5,"mount","","",N,N],[5,"personality","","",N,N],[5,"prctl","","",N,N],[5,"sched_getparam","","",N,N],[5,"ppoll","","",N,N],[5,"pthread_mutex_timedlock","","",N,N],[5,"clone","","",N,N],[5,"sched_getscheduler","","",N,N],[5,"clock_nanosleep","","",N,N],[5,"pthread_attr_getguardsize","","",N,N],[5,"sethostname","","",N,N],[5,"sched_get_priority_min","","",N,N],[5,"pthread_condattr_getpshared","","",N,N],[5,"sysinfo","","",N,N],[5,"umount2","","",N,N],[5,"pthread_setschedparam","","",N,N],[5,"swapon","","",N,N],[5,"sched_setscheduler","","",N,N],[5,"sendfile","","",N,N],[5,"sigsuspend","","",N,N],[5,"getgrgid_r","","",N,N],[5,"sigaltstack","","",N,N],[5,"sem_close","","",N,N],[5,"getdtablesize","","",N,N],[5,"getgrnam_r","","",N,N],[5,"initgroups","","",N,N],[5,"pthread_sigmask","","",N,N],[5,"sem_open","","",N,N],[5,"getgrnam","","",N,N],[5,"pthread_cancel","","",N,N],[5,"pthread_kill","","",N,N],[5,"sem_unlink","","",N,N],[5,"daemon","","",N,N],[5,"getpwnam_r","","",N,N],[5,"getpwuid_r","","",N,N],[5,"sigwait","","",N,N],[5,"pthread_atfork","","",N,N],[5,"getgrgid","","",N,N],[5,"getgrouplist","","",N,N],[5,"pthread_mutexattr_getpshared","","",N,N],[5,"popen","","",N,N],[5,"faccessat","","",N,N],[5,"pthread_create","","",N,N],[5,"dl_iterate_phdr","","",N,N],[5,"setmntent","","",N,N],[5,"getmntent","","",N,N],[5,"addmntent","","",N,N],[5,"endmntent","","",N,N],[5,"hasmntopt","","",N,N],[5,"posix_spawn","","",N,N],[5,"posix_spawnp","","",N,N],[5,"posix_spawnattr_init","","",N,N],[5,"posix_spawnattr_destroy","","",N,N],[5,"posix_spawnattr_getsigdefault","","",N,N],[5,"posix_spawnattr_setsigdefault","","",N,N],[5,"posix_spawnattr_getsigmask","","",N,N],[5,"posix_spawnattr_setsigmask","","",N,N],[5,"posix_spawnattr_getflags","","",N,N],[5,"posix_spawnattr_setflags","","",N,N],[5,"posix_spawnattr_getpgroup","","",N,N],[5,"posix_spawnattr_setpgroup","","",N,N],[5,"posix_spawnattr_getschedpolicy","","",N,N],[5,"posix_spawnattr_setschedpolicy","","",N,N],[5,"posix_spawnattr_getschedparam","","",N,N],[5,"posix_spawnattr_setschedparam","","",N,N],[5,"posix_spawn_file_actions_init","","",N,N],[5,"posix_spawn_file_actions_destroy","","",N,N],[5,"posix_spawn_file_actions_addopen","","",N,N],[5,"posix_spawn_file_actions_addclose","","",N,N],[5,"posix_spawn_file_actions_adddup2","","",N,N],[5,"fread_unlocked","","",N,N],[0,"other","","",N,N],[3,"aiocb","libc::unix::notbsd::linux::other","",N,N],[12,"aio_fildes","","",89,N],[12,"aio_lio_opcode","","",89,N],[12,"aio_reqprio","","",89,N],[12,"aio_buf","","",89,N],[12,"aio_nbytes","","",89,N],[12,"aio_sigevent","","",89,N],[12,"__next_prio","","",89,N],[12,"__abs_prio","","",89,N],[12,"__policy","","",89,N],[12,"__error_code","","",89,N],[12,"__return_value","","",89,N],[12,"aio_offset","","",89,N],[12,"__glibc_reserved","","",89,N],[3,"__exit_status","","",N,N],[12,"e_termination","","",90,N],[12,"e_exit","","",90,N],[3,"__timeval","","",N,N],[12,"tv_sec","","",91,N],[12,"tv_usec","","",91,N],[3,"utmpx","","",N,N],[12,"ut_type","","",92,N],[12,"ut_pid","","",92,N],[12,"ut_line","","",92,N],[12,"ut_id","","",92,N],[12,"ut_user","","",92,N],[12,"ut_host","","",92,N],[12,"ut_exit","","",92,N],[12,"ut_session","","",92,N],[12,"ut_tv","","",92,N],[12,"ut_addr_v6","","",92,N],[12,"__glibc_reserved","","",92,N],[3,"sigaction","","",N,N],[12,"sa_sigaction","","",93,N],[12,"sa_mask","","",93,N],[12,"sa_flags","","",93,N],[12,"sa_restorer","","",93,N],[3,"stack_t","","",N,N],[12,"ss_sp","","",94,N],[12,"ss_flags","","",94,N],[12,"ss_size","","",94,N],[3,"siginfo_t","","",N,N],[12,"si_signo","","",95,N],[12,"si_errno","","",95,N],[12,"si_code","","",95,N],[12,"_pad","","",95,N],[12,"_align","","",95,N],[3,"glob64_t","","",N,N],[12,"gl_pathc","","",96,N],[12,"gl_pathv","","",96,N],[12,"gl_offs","","",96,N],[12,"gl_flags","","",96,N],[12,"__unused1","","",96,N],[12,"__unused2","","",96,N],[12,"__unused3","","",96,N],[12,"__unused4","","",96,N],[12,"__unused5","","",96,N],[3,"statfs","","",N,N],[12,"f_type","","",97,N],[12,"f_bsize","","",97,N],[12,"f_blocks","","",97,N],[12,"f_bfree","","",97,N],[12,"f_bavail","","",97,N],[12,"f_files","","",97,N],[12,"f_ffree","","",97,N],[12,"f_fsid","","",97,N],[12,"f_namelen","","",97,N],[12,"f_frsize","","",97,N],[12,"f_spare","","",97,N],[3,"msghdr","","",N,N],[12,"msg_name","","",98,N],[12,"msg_namelen","","",98,N],[12,"msg_iov","","",98,N],[12,"msg_iovlen","","",98,N],[12,"msg_control","","",98,N],[12,"msg_controllen","","",98,N],[12,"msg_flags","","",98,N],[3,"cmsghdr","","",N,N],[12,"cmsg_len","","",99,N],[12,"cmsg_level","","",99,N],[12,"cmsg_type","","",99,N],[3,"termios","","",N,N],[12,"c_iflag","","",100,N],[12,"c_oflag","","",100,N],[12,"c_cflag","","",100,N],[12,"c_lflag","","",100,N],[12,"c_line","","",100,N],[12,"c_cc","","",100,N],[12,"c_ispeed","","",100,N],[12,"c_ospeed","","",100,N],[3,"flock","","",N,N],[12,"l_type","","",101,N],[12,"l_whence","","",101,N],[12,"l_start","","",101,N],[12,"l_len","","",101,N],[12,"l_pid","","",101,N],[3,"sem_t","","",N,N],[12,"__size","","",102,N],[12,"__align","","",102,N],[3,"mallinfo","","",N,N],[12,"arena","","",103,N],[12,"ordblks","","",103,N],[12,"smblks","","",103,N],[12,"hblks","","",103,N],[12,"hblkhd","","",103,N],[12,"usmblks","","",103,N],[12,"fsmblks","","",103,N],[12,"uordblks","","",103,N],[12,"fordblks","","",103,N],[12,"keepcost","","",103,N],[3,"nlmsghdr","","",N,N],[12,"nlmsg_len","","",104,N],[12,"nlmsg_type","","",104,N],[12,"nlmsg_flags","","",104,N],[12,"nlmsg_seq","","",104,N],[12,"nlmsg_pid","","",104,N],[3,"nlmsgerr","","",N,N],[12,"error","","",105,N],[12,"msg","","",105,N],[3,"nl_pktinfo","","",N,N],[12,"group","","",106,N],[3,"nl_mmap_req","","",N,N],[12,"nm_block_size","","",107,N],[12,"nm_block_nr","","",107,N],[12,"nm_frame_size","","",107,N],[12,"nm_frame_nr","","",107,N],[3,"nl_mmap_hdr","","",N,N],[12,"nm_status","","",108,N],[12,"nm_len","","",108,N],[12,"nm_group","","",108,N],[12,"nm_pid","","",108,N],[12,"nm_uid","","",108,N],[12,"nm_gid","","",108,N],[3,"nlattr","","",N,N],[12,"nla_len","","",109,N],[12,"nla_type","","",109,N],[3,"rtentry","","",N,N],[12,"rt_pad1","","",110,N],[12,"rt_dst","","",110,N],[12,"rt_gateway","","",110,N],[12,"rt_genmask","","",110,N],[12,"rt_flags","","",110,N],[12,"rt_pad2","","",110,N],[12,"rt_pad3","","",110,N],[12,"rt_tos","","",110,N],[12,"rt_class","","",110,N],[12,"rt_pad4","","",110,N],[12,"rt_metric","","",110,N],[12,"rt_dev","","",110,N],[12,"rt_mtu","","",110,N],[12,"rt_window","","",110,N],[12,"rt_irtt","","",110,N],[5,"NLA_ALIGN","","",N,[[["c_int"]],["c_int"]]],[5,"utmpxname","","",N,N],[5,"getutxent","","",N,N],[5,"getutxid","","",N,N],[5,"getutxline","","",N,N],[5,"pututxline","","",N,N],[5,"setutxent","","",N,N],[5,"endutxent","","",N,N],[5,"getpt","","",N,N],[5,"ioctl","","",N,N],[5,"backtrace","","",N,N],[5,"glob64","","",N,N],[5,"globfree64","","",N,N],[5,"ptrace","","",N,N],[5,"pthread_attr_getaffinity_np","","",N,N],[5,"pthread_attr_setaffinity_np","","",N,N],[5,"getpriority","","",N,N],[5,"setpriority","","",N,N],[5,"pthread_getaffinity_np","","",N,N],[5,"pthread_setaffinity_np","","",N,N],[5,"pthread_rwlockattr_getkind_np","","",N,N],[5,"pthread_rwlockattr_setkind_np","","",N,N],[5,"sched_getcpu","","",N,N],[5,"mallinfo","","",N,N],[5,"malloc_usable_size","","",N,N],[5,"getauxval","","",N,N],[5,"getpwent_r","","",N,N],[5,"getgrent_r","","",N,N],[0,"b64","","64-bit specific definitions for linux-like values",N,N],[3,"sigset_t","libc::unix::notbsd::linux::other::b64","",N,N],[12,"__val","","",111,N],[3,"sysinfo","","",N,N],[12,"uptime","","",112,N],[12,"loads","","",112,N],[12,"totalram","","",112,N],[12,"freeram","","",112,N],[12,"sharedram","","",112,N],[12,"bufferram","","",112,N],[12,"totalswap","","",112,N],[12,"freeswap","","",112,N],[12,"procs","","",112,N],[12,"pad","","",112,N],[12,"totalhigh","","",112,N],[12,"freehigh","","",112,N],[12,"mem_unit","","",112,N],[12,"_f","","",112,N],[3,"msqid_ds","","",N,N],[12,"msg_perm","","",113,N],[12,"msg_stime","","",113,N],[12,"msg_rtime","","",113,N],[12,"msg_ctime","","",113,N],[12,"__msg_cbytes","","",113,N],[12,"msg_qnum","","",113,N],[12,"msg_qbytes","","",113,N],[12,"msg_lspid","","",113,N],[12,"msg_lrpid","","",113,N],[12,"__glibc_reserved4","","",113,N],[12,"__glibc_reserved5","","",113,N],[0,"x86_64","","x86_64-specific definitions for 64-bit linux-like values",N,N],[3,"stat","libc::unix::notbsd::linux::other::b64::x86_64","",N,N],[12,"st_dev","","",114,N],[12,"st_ino","","",114,N],[12,"st_nlink","","",114,N],[12,"st_mode","","",114,N],[12,"st_uid","","",114,N],[12,"st_gid","","",114,N],[12,"__pad0","","",114,N],[12,"st_rdev","","",114,N],[12,"st_size","","",114,N],[12,"st_blksize","","",114,N],[12,"st_blocks","","",114,N],[12,"st_atime","","",114,N],[12,"st_atime_nsec","","",114,N],[12,"st_mtime","","",114,N],[12,"st_mtime_nsec","","",114,N],[12,"st_ctime","","",114,N],[12,"st_ctime_nsec","","",114,N],[12,"__unused","","",114,N],[3,"stat64","","",N,N],[12,"st_dev","","",115,N],[12,"st_ino","","",115,N],[12,"st_nlink","","",115,N],[12,"st_mode","","",115,N],[12,"st_uid","","",115,N],[12,"st_gid","","",115,N],[12,"__pad0","","",115,N],[12,"st_rdev","","",115,N],[12,"st_size","","",115,N],[12,"st_blksize","","",115,N],[12,"st_blocks","","",115,N],[12,"st_atime","","",115,N],[12,"st_atime_nsec","","",115,N],[12,"st_mtime","","",115,N],[12,"st_mtime_nsec","","",115,N],[12,"st_ctime","","",115,N],[12,"st_ctime_nsec","","",115,N],[12,"__reserved","","",115,N],[3,"statfs64","","",N,N],[12,"f_type","","",116,N],[12,"f_bsize","","",116,N],[12,"f_blocks","","",116,N],[12,"f_bfree","","",116,N],[12,"f_bavail","","",116,N],[12,"f_files","","",116,N],[12,"f_ffree","","",116,N],[12,"f_fsid","","",116,N],[12,"f_namelen","","",116,N],[12,"f_frsize","","",116,N],[12,"f_flags","","",116,N],[12,"f_spare","","",116,N],[3,"statvfs64","","",N,N],[12,"f_bsize","","",117,N],[12,"f_frsize","","",117,N],[12,"f_blocks","","",117,N],[12,"f_bfree","","",117,N],[12,"f_bavail","","",117,N],[12,"f_files","","",117,N],[12,"f_ffree","","",117,N],[12,"f_favail","","",117,N],[12,"f_fsid","","",117,N],[12,"f_flag","","",117,N],[12,"f_namemax","","",117,N],[12,"__f_spare","","",117,N],[3,"pthread_attr_t","","",N,N],[12,"__size","","",118,N],[3,"_libc_fpxreg","","",N,N],[12,"significand","","",119,N],[12,"exponent","","",119,N],[12,"__private","","",119,N],[3,"_libc_xmmreg","","",N,N],[12,"element","","",120,N],[3,"_libc_fpstate","","",N,N],[12,"cwd","","",121,N],[12,"swd","","",121,N],[12,"ftw","","",121,N],[12,"fop","","",121,N],[12,"rip","","",121,N],[12,"rdp","","",121,N],[12,"mxcsr","","",121,N],[12,"mxcr_mask","","",121,N],[12,"_st","","",121,N],[12,"_xmm","","",121,N],[12,"__private","","",121,N],[3,"user_fpregs_struct","","",N,N],[12,"cwd","","",122,N],[12,"swd","","",122,N],[12,"ftw","","",122,N],[12,"fop","","",122,N],[12,"rip","","",122,N],[12,"rdp","","",122,N],[12,"mxcsr","","",122,N],[12,"mxcr_mask","","",122,N],[12,"st_space","","",122,N],[12,"xmm_space","","",122,N],[12,"padding","","",122,N],[3,"user_regs_struct","","",N,N],[12,"r15","","",123,N],[12,"r14","","",123,N],[12,"r13","","",123,N],[12,"r12","","",123,N],[12,"rbp","","",123,N],[12,"rbx","","",123,N],[12,"r11","","",123,N],[12,"r10","","",123,N],[12,"r9","","",123,N],[12,"r8","","",123,N],[12,"rax","","",123,N],[12,"rcx","","",123,N],[12,"rdx","","",123,N],[12,"rsi","","",123,N],[12,"rdi","","",123,N],[12,"orig_rax","","",123,N],[12,"rip","","",123,N],[12,"cs","","",123,N],[12,"eflags","","",123,N],[12,"rsp","","",123,N],[12,"ss","","",123,N],[12,"fs_base","","",123,N],[12,"gs_base","","",123,N],[12,"ds","","",123,N],[12,"es","","",123,N],[12,"fs","","",123,N],[12,"gs","","",123,N],[3,"user","","",N,N],[12,"regs","","",124,N],[12,"u_fpvalid","","",124,N],[12,"i387","","",124,N],[12,"u_tsize","","",124,N],[12,"u_dsize","","",124,N],[12,"u_ssize","","",124,N],[12,"start_code","","",124,N],[12,"start_stack","","",124,N],[12,"signal","","",124,N],[12,"__reserved","","",124,N],[12,"u_ar0","","",124,N],[12,"u_fpstate","","",124,N],[12,"magic","","",124,N],[12,"u_comm","","",124,N],[12,"u_debugreg","","",124,N],[3,"mcontext_t","","",N,N],[12,"gregs","","",125,N],[12,"fpregs","","",125,N],[12,"__private","","",125,N],[3,"ucontext_t","","",N,N],[12,"uc_flags","","",126,N],[12,"uc_link","","",126,N],[12,"uc_stack","","",126,N],[12,"uc_mcontext","","",126,N],[12,"uc_sigmask","","",126,N],[12,"__private","","",126,N],[3,"ipc_perm","","",N,N],[12,"__key","","",127,N],[12,"uid","","",127,N],[12,"gid","","",127,N],[12,"cuid","","",127,N],[12,"cgid","","",127,N],[12,"mode","","",127,N],[12,"__pad1","","",127,N],[12,"__seq","","",127,N],[12,"__pad2","","",127,N],[12,"__unused1","","",127,N],[12,"__unused2","","",127,N],[3,"shmid_ds","","",N,N],[12,"shm_perm","","",128,N],[12,"shm_segsz","","",128,N],[12,"shm_atime","","",128,N],[12,"shm_dtime","","",128,N],[12,"shm_ctime","","",128,N],[12,"shm_cpid","","",128,N],[12,"shm_lpid","","",128,N],[12,"shm_nattch","","",128,N],[12,"__unused4","","",128,N],[12,"__unused5","","",128,N],[3,"termios2","","",N,N],[12,"c_iflag","","",129,N],[12,"c_oflag","","",129,N],[12,"c_cflag","","",129,N],[12,"c_lflag","","",129,N],[12,"c_line","","",129,N],[12,"c_cc","","",129,N],[12,"c_ispeed","","",129,N],[12,"c_ospeed","","",129,N],[5,"getcontext","","",N,N],[5,"setcontext","","",N,N],[5,"makecontext","","",N,N],[5,"swapcontext","","",N,N],[5,"iopl","","",N,N],[5,"ioperm","","",N,N],[6,"c_char","","",N,N],[6,"wchar_t","","",N,N],[6,"nlink_t","","",N,N],[6,"blksize_t","","",N,N],[6,"greg_t","","",N,N],[6,"suseconds_t","","",N,N],[6,"__u64","","",N,N],[17,"TIOCGSOFTCAR","","",N,N],[17,"TIOCSSOFTCAR","","",N,N],[17,"RLIMIT_NOFILE","","",N,N],[17,"RLIMIT_NPROC","","",N,N],[17,"O_APPEND","","",N,N],[17,"O_CREAT","","",N,N],[17,"O_EXCL","","",N,N],[17,"O_NOCTTY","","",N,N],[17,"O_NONBLOCK","","",N,N],[17,"O_SYNC","","",N,N],[17,"O_RSYNC","","",N,N],[17,"O_DSYNC","","",N,N],[17,"O_FSYNC","","",N,N],[17,"O_NOATIME","","",N,N],[17,"O_PATH","","",N,N],[17,"O_TMPFILE","","",N,N],[17,"MAP_GROWSDOWN","","",N,N],[17,"EDEADLK","","",N,N],[17,"ENAMETOOLONG","","",N,N],[17,"ENOLCK","","",N,N],[17,"ENOSYS","","",N,N],[17,"ENOTEMPTY","","",N,N],[17,"ELOOP","","",N,N],[17,"ENOMSG","","",N,N],[17,"EIDRM","","",N,N],[17,"ECHRNG","","",N,N],[17,"EL2NSYNC","","",N,N],[17,"EL3HLT","","",N,N],[17,"EL3RST","","",N,N],[17,"ELNRNG","","",N,N],[17,"EUNATCH","","",N,N],[17,"ENOCSI","","",N,N],[17,"EL2HLT","","",N,N],[17,"EBADE","","",N,N],[17,"EBADR","","",N,N],[17,"EXFULL","","",N,N],[17,"ENOANO","","",N,N],[17,"EBADRQC","","",N,N],[17,"EBADSLT","","",N,N],[17,"EMULTIHOP","","",N,N],[17,"EOVERFLOW","","",N,N],[17,"ENOTUNIQ","","",N,N],[17,"EBADFD","","",N,N],[17,"EBADMSG","","",N,N],[17,"EREMCHG","","",N,N],[17,"ELIBACC","","",N,N],[17,"ELIBBAD","","",N,N],[17,"ELIBSCN","","",N,N],[17,"ELIBMAX","","",N,N],[17,"ELIBEXEC","","",N,N],[17,"EILSEQ","","",N,N],[17,"ERESTART","","",N,N],[17,"ESTRPIPE","","",N,N],[17,"EUSERS","","",N,N],[17,"ENOTSOCK","","",N,N],[17,"EDESTADDRREQ","","",N,N],[17,"EMSGSIZE","","",N,N],[17,"EPROTOTYPE","","",N,N],[17,"ENOPROTOOPT","","",N,N],[17,"EPROTONOSUPPORT","","",N,N],[17,"ESOCKTNOSUPPORT","","",N,N],[17,"EOPNOTSUPP","","",N,N],[17,"EPFNOSUPPORT","","",N,N],[17,"EAFNOSUPPORT","","",N,N],[17,"EADDRINUSE","","",N,N],[17,"EADDRNOTAVAIL","","",N,N],[17,"ENETDOWN","","",N,N],[17,"ENETUNREACH","","",N,N],[17,"ENETRESET","","",N,N],[17,"ECONNABORTED","","",N,N],[17,"ECONNRESET","","",N,N],[17,"ENOBUFS","","",N,N],[17,"EISCONN","","",N,N],[17,"ENOTCONN","","",N,N],[17,"ESHUTDOWN","","",N,N],[17,"ETOOMANYREFS","","",N,N],[17,"ETIMEDOUT","","",N,N],[17,"ECONNREFUSED","","",N,N],[17,"EHOSTDOWN","","",N,N],[17,"EHOSTUNREACH","","",N,N],[17,"EALREADY","","",N,N],[17,"EINPROGRESS","","",N,N],[17,"ESTALE","","",N,N],[17,"EDQUOT","","",N,N],[17,"ENOMEDIUM","","",N,N],[17,"EMEDIUMTYPE","","",N,N],[17,"ECANCELED","","",N,N],[17,"ENOKEY","","",N,N],[17,"EKEYEXPIRED","","",N,N],[17,"EKEYREVOKED","","",N,N],[17,"EKEYREJECTED","","",N,N],[17,"EOWNERDEAD","","",N,N],[17,"ENOTRECOVERABLE","","",N,N],[17,"EHWPOISON","","",N,N],[17,"ERFKILL","","",N,N],[17,"SOL_SOCKET","","",N,N],[17,"SO_REUSEADDR","","",N,N],[17,"SO_TYPE","","",N,N],[17,"SO_ERROR","","",N,N],[17,"SO_DONTROUTE","","",N,N],[17,"SO_BROADCAST","","",N,N],[17,"SO_SNDBUF","","",N,N],[17,"SO_RCVBUF","","",N,N],[17,"SO_SNDBUFFORCE","","",N,N],[17,"SO_RCVBUFFORCE","","",N,N],[17,"SO_KEEPALIVE","","",N,N],[17,"SO_OOBINLINE","","",N,N],[17,"SO_NO_CHECK","","",N,N],[17,"SO_PRIORITY","","",N,N],[17,"SO_LINGER","","",N,N],[17,"SO_BSDCOMPAT","","",N,N],[17,"SO_REUSEPORT","","",N,N],[17,"SO_PASSCRED","","",N,N],[17,"SO_PEERCRED","","",N,N],[17,"SO_RCVLOWAT","","",N,N],[17,"SO_SNDLOWAT","","",N,N],[17,"SO_RCVTIMEO","","",N,N],[17,"SO_SNDTIMEO","","",N,N],[17,"SO_SECURITY_AUTHENTICATION","","",N,N],[17,"SO_SECURITY_ENCRYPTION_TRANSPORT","","",N,N],[17,"SO_SECURITY_ENCRYPTION_NETWORK","","",N,N],[17,"SO_BINDTODEVICE","","",N,N],[17,"SO_ATTACH_FILTER","","",N,N],[17,"SO_DETACH_FILTER","","",N,N],[17,"SO_GET_FILTER","","",N,N],[17,"SO_PEERNAME","","",N,N],[17,"SO_TIMESTAMP","","",N,N],[17,"SO_ACCEPTCONN","","",N,N],[17,"SO_PEERSEC","","",N,N],[17,"SO_PASSSEC","","",N,N],[17,"SO_TIMESTAMPNS","","",N,N],[17,"SCM_TIMESTAMPNS","","",N,N],[17,"SO_MARK","","",N,N],[17,"SO_TIMESTAMPING","","",N,N],[17,"SCM_TIMESTAMPING","","",N,N],[17,"SO_PROTOCOL","","",N,N],[17,"SO_DOMAIN","","",N,N],[17,"SO_RXQ_OVFL","","",N,N],[17,"SO_WIFI_STATUS","","",N,N],[17,"SCM_WIFI_STATUS","","",N,N],[17,"SO_PEEK_OFF","","",N,N],[17,"SO_NOFCS","","",N,N],[17,"SO_LOCK_FILTER","","",N,N],[17,"SO_SELECT_ERR_QUEUE","","",N,N],[17,"SO_BUSY_POLL","","",N,N],[17,"SO_MAX_PACING_RATE","","",N,N],[17,"SO_BPF_EXTENSIONS","","",N,N],[17,"SO_INCOMING_CPU","","",N,N],[17,"SO_ATTACH_BPF","","",N,N],[17,"SO_DETACH_BPF","","",N,N],[17,"SA_ONSTACK","","",N,N],[17,"SA_SIGINFO","","",N,N],[17,"SA_NOCLDWAIT","","",N,N],[17,"SIGCHLD","","",N,N],[17,"SIGBUS","","",N,N],[17,"SIGUSR1","","",N,N],[17,"SIGUSR2","","",N,N],[17,"SIGCONT","","",N,N],[17,"SIGSTOP","","",N,N],[17,"SIGTSTP","","",N,N],[17,"SIGURG","","",N,N],[17,"SIGIO","","",N,N],[17,"SIGSYS","","",N,N],[17,"SIGSTKFLT","","",N,N],[17,"SIGUNUSED","","",N,N],[17,"SIGPOLL","","",N,N],[17,"SIGPWR","","",N,N],[17,"SIG_SETMASK","","",N,N],[17,"SIG_BLOCK","","",N,N],[17,"SIG_UNBLOCK","","",N,N],[17,"POLLWRNORM","","",N,N],[17,"POLLWRBAND","","",N,N],[17,"O_ASYNC","","",N,N],[17,"O_NDELAY","","",N,N],[17,"PTRACE_DETACH","","",N,N],[17,"EFD_NONBLOCK","","",N,N],[17,"F_GETLK","","",N,N],[17,"F_GETOWN","","",N,N],[17,"F_SETOWN","","",N,N],[17,"F_SETLK","","",N,N],[17,"F_SETLKW","","",N,N],[17,"F_RDLCK","","",N,N],[17,"F_WRLCK","","",N,N],[17,"F_UNLCK","","",N,N],[17,"SFD_NONBLOCK","","",N,N],[17,"TIOCEXCL","","",N,N],[17,"TIOCNXCL","","",N,N],[17,"TIOCSCTTY","","",N,N],[17,"TIOCSTI","","",N,N],[17,"TIOCMGET","","",N,N],[17,"TIOCMBIS","","",N,N],[17,"TIOCMBIC","","",N,N],[17,"TIOCMSET","","",N,N],[17,"TIOCCONS","","",N,N],[17,"SFD_CLOEXEC","","",N,N],[17,"NCCS","","",N,N],[17,"O_TRUNC","","",N,N],[17,"O_CLOEXEC","","",N,N],[17,"EBFONT","","",N,N],[17,"ENOSTR","","",N,N],[17,"ENODATA","","",N,N],[17,"ETIME","","",N,N],[17,"ENOSR","","",N,N],[17,"ENONET","","",N,N],[17,"ENOPKG","","",N,N],[17,"EREMOTE","","",N,N],[17,"ENOLINK","","",N,N],[17,"EADV","","",N,N],[17,"ESRMNT","","",N,N],[17,"ECOMM","","",N,N],[17,"EPROTO","","",N,N],[17,"EDOTDOT","","",N,N],[17,"SA_NODEFER","","",N,N],[17,"SA_RESETHAND","","",N,N],[17,"SA_RESTART","","",N,N],[17,"SA_NOCLDSTOP","","",N,N],[17,"EPOLL_CLOEXEC","","",N,N],[17,"EFD_CLOEXEC","","",N,N],[17,"__SIZEOF_PTHREAD_CONDATTR_T","","",N,N],[17,"__SIZEOF_PTHREAD_MUTEXATTR_T","","",N,N],[17,"O_DIRECT","","",N,N],[17,"O_DIRECTORY","","",N,N],[17,"O_NOFOLLOW","","",N,N],[17,"MAP_LOCKED","","",N,N],[17,"MAP_NORESERVE","","",N,N],[17,"MAP_32BIT","","",N,N],[17,"EDEADLOCK","","",N,N],[17,"FIOCLEX","","",N,N],[17,"FIONBIO","","",N,N],[17,"PTRACE_GETFPREGS","","",N,N],[17,"PTRACE_SETFPREGS","","",N,N],[17,"PTRACE_GETFPXREGS","","",N,N],[17,"PTRACE_SETFPXREGS","","",N,N],[17,"PTRACE_GETREGS","","",N,N],[17,"PTRACE_SETREGS","","",N,N],[17,"PTRACE_PEEKSIGINFO_SHARED","","",N,N],[17,"MCL_CURRENT","","",N,N],[17,"MCL_FUTURE","","",N,N],[17,"SIGSTKSZ","","",N,N],[17,"MINSIGSTKSZ","","",N,N],[17,"CBAUD","","",N,N],[17,"TAB1","","",N,N],[17,"TAB2","","",N,N],[17,"TAB3","","",N,N],[17,"CR1","","",N,N],[17,"CR2","","",N,N],[17,"CR3","","",N,N],[17,"FF1","","",N,N],[17,"BS1","","",N,N],[17,"VT1","","",N,N],[17,"VWERASE","","",N,N],[17,"VREPRINT","","",N,N],[17,"VSUSP","","",N,N],[17,"VSTART","","",N,N],[17,"VSTOP","","",N,N],[17,"VDISCARD","","",N,N],[17,"VTIME","","",N,N],[17,"IXON","","",N,N],[17,"IXOFF","","",N,N],[17,"ONLCR","","",N,N],[17,"CSIZE","","",N,N],[17,"CS6","","",N,N],[17,"CS7","","",N,N],[17,"CS8","","",N,N],[17,"CSTOPB","","",N,N],[17,"CREAD","","",N,N],[17,"PARENB","","",N,N],[17,"PARODD","","",N,N],[17,"HUPCL","","",N,N],[17,"CLOCAL","","",N,N],[17,"ECHOKE","","",N,N],[17,"ECHOE","","",N,N],[17,"ECHOK","","",N,N],[17,"ECHONL","","",N,N],[17,"ECHOPRT","","",N,N],[17,"ECHOCTL","","",N,N],[17,"ISIG","","",N,N],[17,"ICANON","","",N,N],[17,"PENDIN","","",N,N],[17,"NOFLSH","","",N,N],[17,"CIBAUD","","",N,N],[17,"CBAUDEX","","",N,N],[17,"VSWTC","","",N,N],[17,"OLCUC","","",N,N],[17,"NLDLY","","",N,N],[17,"CRDLY","","",N,N],[17,"TABDLY","","",N,N],[17,"BSDLY","","",N,N],[17,"FFDLY","","",N,N],[17,"VTDLY","","",N,N],[17,"XTABS","","",N,N],[17,"B0","","",N,N],[17,"B50","","",N,N],[17,"B75","","",N,N],[17,"B110","","",N,N],[17,"B134","","",N,N],[17,"B150","","",N,N],[17,"B200","","",N,N],[17,"B300","","",N,N],[17,"B600","","",N,N],[17,"B1200","","",N,N],[17,"B1800","","",N,N],[17,"B2400","","",N,N],[17,"B4800","","",N,N],[17,"B9600","","",N,N],[17,"B19200","","",N,N],[17,"B38400","","",N,N],[17,"EXTA","","",N,N],[17,"EXTB","","",N,N],[17,"BOTHER","","",N,N],[17,"B57600","","",N,N],[17,"B115200","","",N,N],[17,"B230400","","",N,N],[17,"B460800","","",N,N],[17,"B500000","","",N,N],[17,"B576000","","",N,N],[17,"B921600","","",N,N],[17,"B1000000","","",N,N],[17,"B1152000","","",N,N],[17,"B1500000","","",N,N],[17,"B2000000","","",N,N],[17,"B2500000","","",N,N],[17,"B3000000","","",N,N],[17,"B3500000","","",N,N],[17,"B4000000","","",N,N],[17,"VEOL","","",N,N],[17,"VEOL2","","",N,N],[17,"VMIN","","",N,N],[17,"IEXTEN","","",N,N],[17,"TOSTOP","","",N,N],[17,"FLUSHO","","",N,N],[17,"EXTPROC","","",N,N],[17,"TCGETS","","",N,N],[17,"TCSETS","","",N,N],[17,"TCSETSW","","",N,N],[17,"TCSETSF","","",N,N],[17,"TCGETA","","",N,N],[17,"TCSETA","","",N,N],[17,"TCSETAW","","",N,N],[17,"TCSETAF","","",N,N],[17,"TCSBRK","","",N,N],[17,"TCXONC","","",N,N],[17,"TCFLSH","","",N,N],[17,"TIOCINQ","","",N,N],[17,"TIOCGPGRP","","",N,N],[17,"TIOCSPGRP","","",N,N],[17,"TIOCOUTQ","","",N,N],[17,"TIOCGWINSZ","","",N,N],[17,"TIOCSWINSZ","","",N,N],[17,"FIONREAD","","",N,N],[17,"R15","","",N,N],[17,"R14","","",N,N],[17,"R13","","",N,N],[17,"R12","","",N,N],[17,"RBP","","",N,N],[17,"RBX","","",N,N],[17,"R11","","",N,N],[17,"R10","","",N,N],[17,"R9","","",N,N],[17,"R8","","",N,N],[17,"RAX","","",N,N],[17,"RCX","","",N,N],[17,"RDX","","",N,N],[17,"RSI","","",N,N],[17,"RDI","","",N,N],[17,"ORIG_RAX","","",N,N],[17,"RIP","","",N,N],[17,"CS","","",N,N],[17,"EFLAGS","","",N,N],[17,"RSP","","",N,N],[17,"SS","","",N,N],[17,"FS_BASE","","",N,N],[17,"GS_BASE","","",N,N],[17,"DS","","",N,N],[17,"ES","","",N,N],[17,"FS","","",N,N],[17,"GS","","",N,N],[11,"clone","libc","",114,[[["self"]],["stat"]]],[11,"clone","","",115,[[["self"]],["stat64"]]],[11,"clone","","",116,[[["self"]],["statfs64"]]],[11,"clone","","",117,[[["self"]],["statvfs64"]]],[11,"clone","","",118,[[["self"]],["pthread_attr_t"]]],[11,"clone","","",119,[[["self"]],["_libc_fpxreg"]]],[11,"clone","","",120,[[["self"]],["_libc_xmmreg"]]],[11,"clone","","",121,[[["self"]],["_libc_fpstate"]]],[11,"clone","","",122,[[["self"]],["user_fpregs_struct"]]],[11,"clone","","",123,[[["self"]],["user_regs_struct"]]],[11,"clone","","",124,[[["self"]],["user"]]],[11,"clone","","",125,[[["self"]],["mcontext_t"]]],[11,"clone","","",126,[[["self"]],["ucontext_t"]]],[11,"clone","","",127,[[["self"]],["ipc_perm"]]],[11,"clone","","",128,[[["self"]],["shmid_ds"]]],[11,"clone","","",129,[[["self"]],["termios2"]]],[0,"not_x32","libc::unix::notbsd::linux::other::b64","",N,N],[3,"statvfs","libc::unix::notbsd::linux::other::b64::not_x32","",N,N],[12,"f_bsize","","",130,N],[12,"f_frsize","","",130,N],[12,"f_blocks","","",130,N],[12,"f_bfree","","",130,N],[12,"f_bavail","","",130,N],[12,"f_files","","",130,N],[12,"f_ffree","","",130,N],[12,"f_favail","","",130,N],[12,"f_fsid","","",130,N],[12,"f_flag","","",130,N],[12,"f_namemax","","",130,N],[12,"__f_spare","","",130,N],[5,"sysctl","","",N,N],[6,"c_long","","",N,N],[6,"c_ulong","","",N,N],[17,"__SIZEOF_PTHREAD_MUTEX_T","","",N,N],[17,"__SIZEOF_PTHREAD_RWLOCK_T","","",N,N],[17,"PTHREAD_RECURSIVE_MUTEX_INITIALIZER_NP","","",N,N],[17,"PTHREAD_ERRORCHECK_MUTEX_INITIALIZER_NP","","",N,N],[17,"PTHREAD_ADAPTIVE_MUTEX_INITIALIZER_NP","","",N,N],[17,"SYS_read","","",N,N],[17,"SYS_write","","",N,N],[17,"SYS_open","","",N,N],[17,"SYS_close","","",N,N],[17,"SYS_stat","","",N,N],[17,"SYS_fstat","","",N,N],[17,"SYS_lstat","","",N,N],[17,"SYS_poll","","",N,N],[17,"SYS_lseek","","",N,N],[17,"SYS_mmap","","",N,N],[17,"SYS_mprotect","","",N,N],[17,"SYS_munmap","","",N,N],[17,"SYS_brk","","",N,N],[17,"SYS_rt_sigaction","","",N,N],[17,"SYS_rt_sigprocmask","","",N,N],[17,"SYS_rt_sigreturn","","",N,N],[17,"SYS_ioctl","","",N,N],[17,"SYS_pread64","","",N,N],[17,"SYS_pwrite64","","",N,N],[17,"SYS_readv","","",N,N],[17,"SYS_writev","","",N,N],[17,"SYS_access","","",N,N],[17,"SYS_pipe","","",N,N],[17,"SYS_select","","",N,N],[17,"SYS_sched_yield","","",N,N],[17,"SYS_mremap","","",N,N],[17,"SYS_msync","","",N,N],[17,"SYS_mincore","","",N,N],[17,"SYS_madvise","","",N,N],[17,"SYS_shmget","","",N,N],[17,"SYS_shmat","","",N,N],[17,"SYS_shmctl","","",N,N],[17,"SYS_dup","","",N,N],[17,"SYS_dup2","","",N,N],[17,"SYS_pause","","",N,N],[17,"SYS_nanosleep","","",N,N],[17,"SYS_getitimer","","",N,N],[17,"SYS_alarm","","",N,N],[17,"SYS_setitimer","","",N,N],[17,"SYS_getpid","","",N,N],[17,"SYS_sendfile","","",N,N],[17,"SYS_socket","","",N,N],[17,"SYS_connect","","",N,N],[17,"SYS_accept","","",N,N],[17,"SYS_sendto","","",N,N],[17,"SYS_recvfrom","","",N,N],[17,"SYS_sendmsg","","",N,N],[17,"SYS_recvmsg","","",N,N],[17,"SYS_shutdown","","",N,N],[17,"SYS_bind","","",N,N],[17,"SYS_listen","","",N,N],[17,"SYS_getsockname","","",N,N],[17,"SYS_getpeername","","",N,N],[17,"SYS_socketpair","","",N,N],[17,"SYS_setsockopt","","",N,N],[17,"SYS_getsockopt","","",N,N],[17,"SYS_clone","","",N,N],[17,"SYS_fork","","",N,N],[17,"SYS_vfork","","",N,N],[17,"SYS_execve","","",N,N],[17,"SYS_exit","","",N,N],[17,"SYS_wait4","","",N,N],[17,"SYS_kill","","",N,N],[17,"SYS_uname","","",N,N],[17,"SYS_semget","","",N,N],[17,"SYS_semop","","",N,N],[17,"SYS_semctl","","",N,N],[17,"SYS_shmdt","","",N,N],[17,"SYS_msgget","","",N,N],[17,"SYS_msgsnd","","",N,N],[17,"SYS_msgrcv","","",N,N],[17,"SYS_msgctl","","",N,N],[17,"SYS_fcntl","","",N,N],[17,"SYS_flock","","",N,N],[17,"SYS_fsync","","",N,N],[17,"SYS_fdatasync","","",N,N],[17,"SYS_truncate","","",N,N],[17,"SYS_ftruncate","","",N,N],[17,"SYS_getdents","","",N,N],[17,"SYS_getcwd","","",N,N],[17,"SYS_chdir","","",N,N],[17,"SYS_fchdir","","",N,N],[17,"SYS_rename","","",N,N],[17,"SYS_mkdir","","",N,N],[17,"SYS_rmdir","","",N,N],[17,"SYS_creat","","",N,N],[17,"SYS_link","","",N,N],[17,"SYS_unlink","","",N,N],[17,"SYS_symlink","","",N,N],[17,"SYS_readlink","","",N,N],[17,"SYS_chmod","","",N,N],[17,"SYS_fchmod","","",N,N],[17,"SYS_chown","","",N,N],[17,"SYS_fchown","","",N,N],[17,"SYS_lchown","","",N,N],[17,"SYS_umask","","",N,N],[17,"SYS_gettimeofday","","",N,N],[17,"SYS_getrlimit","","",N,N],[17,"SYS_getrusage","","",N,N],[17,"SYS_sysinfo","","",N,N],[17,"SYS_times","","",N,N],[17,"SYS_ptrace","","",N,N],[17,"SYS_getuid","","",N,N],[17,"SYS_syslog","","",N,N],[17,"SYS_getgid","","",N,N],[17,"SYS_setuid","","",N,N],[17,"SYS_setgid","","",N,N],[17,"SYS_geteuid","","",N,N],[17,"SYS_getegid","","",N,N],[17,"SYS_setpgid","","",N,N],[17,"SYS_getppid","","",N,N],[17,"SYS_getpgrp","","",N,N],[17,"SYS_setsid","","",N,N],[17,"SYS_setreuid","","",N,N],[17,"SYS_setregid","","",N,N],[17,"SYS_getgroups","","",N,N],[17,"SYS_setgroups","","",N,N],[17,"SYS_setresuid","","",N,N],[17,"SYS_getresuid","","",N,N],[17,"SYS_setresgid","","",N,N],[17,"SYS_getresgid","","",N,N],[17,"SYS_getpgid","","",N,N],[17,"SYS_setfsuid","","",N,N],[17,"SYS_setfsgid","","",N,N],[17,"SYS_getsid","","",N,N],[17,"SYS_capget","","",N,N],[17,"SYS_capset","","",N,N],[17,"SYS_rt_sigpending","","",N,N],[17,"SYS_rt_sigtimedwait","","",N,N],[17,"SYS_rt_sigqueueinfo","","",N,N],[17,"SYS_rt_sigsuspend","","",N,N],[17,"SYS_sigaltstack","","",N,N],[17,"SYS_utime","","",N,N],[17,"SYS_mknod","","",N,N],[17,"SYS_uselib","","",N,N],[17,"SYS_personality","","",N,N],[17,"SYS_ustat","","",N,N],[17,"SYS_statfs","","",N,N],[17,"SYS_fstatfs","","",N,N],[17,"SYS_sysfs","","",N,N],[17,"SYS_getpriority","","",N,N],[17,"SYS_setpriority","","",N,N],[17,"SYS_sched_setparam","","",N,N],[17,"SYS_sched_getparam","","",N,N],[17,"SYS_sched_setscheduler","","",N,N],[17,"SYS_sched_getscheduler","","",N,N],[17,"SYS_sched_get_priority_max","","",N,N],[17,"SYS_sched_get_priority_min","","",N,N],[17,"SYS_sched_rr_get_interval","","",N,N],[17,"SYS_mlock","","",N,N],[17,"SYS_munlock","","",N,N],[17,"SYS_mlockall","","",N,N],[17,"SYS_munlockall","","",N,N],[17,"SYS_vhangup","","",N,N],[17,"SYS_modify_ldt","","",N,N],[17,"SYS_pivot_root","","",N,N],[17,"SYS__sysctl","","",N,N],[17,"SYS_prctl","","",N,N],[17,"SYS_arch_prctl","","",N,N],[17,"SYS_adjtimex","","",N,N],[17,"SYS_setrlimit","","",N,N],[17,"SYS_chroot","","",N,N],[17,"SYS_sync","","",N,N],[17,"SYS_acct","","",N,N],[17,"SYS_settimeofday","","",N,N],[17,"SYS_mount","","",N,N],[17,"SYS_umount2","","",N,N],[17,"SYS_swapon","","",N,N],[17,"SYS_swapoff","","",N,N],[17,"SYS_reboot","","",N,N],[17,"SYS_sethostname","","",N,N],[17,"SYS_setdomainname","","",N,N],[17,"SYS_iopl","","",N,N],[17,"SYS_ioperm","","",N,N],[17,"SYS_create_module","","",N,N],[17,"SYS_init_module","","",N,N],[17,"SYS_delete_module","","",N,N],[17,"SYS_get_kernel_syms","","",N,N],[17,"SYS_query_module","","",N,N],[17,"SYS_quotactl","","",N,N],[17,"SYS_nfsservctl","","",N,N],[17,"SYS_getpmsg","","",N,N],[17,"SYS_putpmsg","","",N,N],[17,"SYS_afs_syscall","","",N,N],[17,"SYS_tuxcall","","",N,N],[17,"SYS_security","","",N,N],[17,"SYS_gettid","","",N,N],[17,"SYS_readahead","","",N,N],[17,"SYS_setxattr","","",N,N],[17,"SYS_lsetxattr","","",N,N],[17,"SYS_fsetxattr","","",N,N],[17,"SYS_getxattr","","",N,N],[17,"SYS_lgetxattr","","",N,N],[17,"SYS_fgetxattr","","",N,N],[17,"SYS_listxattr","","",N,N],[17,"SYS_llistxattr","","",N,N],[17,"SYS_flistxattr","","",N,N],[17,"SYS_removexattr","","",N,N],[17,"SYS_lremovexattr","","",N,N],[17,"SYS_fremovexattr","","",N,N],[17,"SYS_tkill","","",N,N],[17,"SYS_time","","",N,N],[17,"SYS_futex","","",N,N],[17,"SYS_sched_setaffinity","","",N,N],[17,"SYS_sched_getaffinity","","",N,N],[17,"SYS_set_thread_area","","",N,N],[17,"SYS_io_setup","","",N,N],[17,"SYS_io_destroy","","",N,N],[17,"SYS_io_getevents","","",N,N],[17,"SYS_io_submit","","",N,N],[17,"SYS_io_cancel","","",N,N],[17,"SYS_get_thread_area","","",N,N],[17,"SYS_lookup_dcookie","","",N,N],[17,"SYS_epoll_create","","",N,N],[17,"SYS_epoll_ctl_old","","",N,N],[17,"SYS_epoll_wait_old","","",N,N],[17,"SYS_remap_file_pages","","",N,N],[17,"SYS_getdents64","","",N,N],[17,"SYS_set_tid_address","","",N,N],[17,"SYS_restart_syscall","","",N,N],[17,"SYS_semtimedop","","",N,N],[17,"SYS_fadvise64","","",N,N],[17,"SYS_timer_create","","",N,N],[17,"SYS_timer_settime","","",N,N],[17,"SYS_timer_gettime","","",N,N],[17,"SYS_timer_getoverrun","","",N,N],[17,"SYS_timer_delete","","",N,N],[17,"SYS_clock_settime","","",N,N],[17,"SYS_clock_gettime","","",N,N],[17,"SYS_clock_getres","","",N,N],[17,"SYS_clock_nanosleep","","",N,N],[17,"SYS_exit_group","","",N,N],[17,"SYS_epoll_wait","","",N,N],[17,"SYS_epoll_ctl","","",N,N],[17,"SYS_tgkill","","",N,N],[17,"SYS_utimes","","",N,N],[17,"SYS_vserver","","",N,N],[17,"SYS_mbind","","",N,N],[17,"SYS_set_mempolicy","","",N,N],[17,"SYS_get_mempolicy","","",N,N],[17,"SYS_mq_open","","",N,N],[17,"SYS_mq_unlink","","",N,N],[17,"SYS_mq_timedsend","","",N,N],[17,"SYS_mq_timedreceive","","",N,N],[17,"SYS_mq_notify","","",N,N],[17,"SYS_mq_getsetattr","","",N,N],[17,"SYS_kexec_load","","",N,N],[17,"SYS_waitid","","",N,N],[17,"SYS_add_key","","",N,N],[17,"SYS_request_key","","",N,N],[17,"SYS_keyctl","","",N,N],[17,"SYS_ioprio_set","","",N,N],[17,"SYS_ioprio_get","","",N,N],[17,"SYS_inotify_init","","",N,N],[17,"SYS_inotify_add_watch","","",N,N],[17,"SYS_inotify_rm_watch","","",N,N],[17,"SYS_migrate_pages","","",N,N],[17,"SYS_openat","","",N,N],[17,"SYS_mkdirat","","",N,N],[17,"SYS_mknodat","","",N,N],[17,"SYS_fchownat","","",N,N],[17,"SYS_futimesat","","",N,N],[17,"SYS_newfstatat","","",N,N],[17,"SYS_unlinkat","","",N,N],[17,"SYS_renameat","","",N,N],[17,"SYS_linkat","","",N,N],[17,"SYS_symlinkat","","",N,N],[17,"SYS_readlinkat","","",N,N],[17,"SYS_fchmodat","","",N,N],[17,"SYS_faccessat","","",N,N],[17,"SYS_pselect6","","",N,N],[17,"SYS_ppoll","","",N,N],[17,"SYS_unshare","","",N,N],[17,"SYS_set_robust_list","","",N,N],[17,"SYS_get_robust_list","","",N,N],[17,"SYS_splice","","",N,N],[17,"SYS_tee","","",N,N],[17,"SYS_sync_file_range","","",N,N],[17,"SYS_vmsplice","","",N,N],[17,"SYS_move_pages","","",N,N],[17,"SYS_utimensat","","",N,N],[17,"SYS_epoll_pwait","","",N,N],[17,"SYS_signalfd","","",N,N],[17,"SYS_timerfd_create","","",N,N],[17,"SYS_eventfd","","",N,N],[17,"SYS_fallocate","","",N,N],[17,"SYS_timerfd_settime","","",N,N],[17,"SYS_timerfd_gettime","","",N,N],[17,"SYS_accept4","","",N,N],[17,"SYS_signalfd4","","",N,N],[17,"SYS_eventfd2","","",N,N],[17,"SYS_epoll_create1","","",N,N],[17,"SYS_dup3","","",N,N],[17,"SYS_pipe2","","",N,N],[17,"SYS_inotify_init1","","",N,N],[17,"SYS_preadv","","",N,N],[17,"SYS_pwritev","","",N,N],[17,"SYS_rt_tgsigqueueinfo","","",N,N],[17,"SYS_perf_event_open","","",N,N],[17,"SYS_recvmmsg","","",N,N],[17,"SYS_fanotify_init","","",N,N],[17,"SYS_fanotify_mark","","",N,N],[17,"SYS_prlimit64","","",N,N],[17,"SYS_name_to_handle_at","","",N,N],[17,"SYS_open_by_handle_at","","",N,N],[17,"SYS_clock_adjtime","","",N,N],[17,"SYS_syncfs","","",N,N],[17,"SYS_sendmmsg","","",N,N],[17,"SYS_setns","","",N,N],[17,"SYS_getcpu","","",N,N],[17,"SYS_process_vm_readv","","",N,N],[17,"SYS_process_vm_writev","","",N,N],[17,"SYS_kcmp","","",N,N],[17,"SYS_finit_module","","",N,N],[17,"SYS_sched_setattr","","",N,N],[17,"SYS_sched_getattr","","",N,N],[17,"SYS_renameat2","","",N,N],[17,"SYS_seccomp","","",N,N],[17,"SYS_getrandom","","",N,N],[17,"SYS_memfd_create","","",N,N],[17,"SYS_kexec_file_load","","",N,N],[17,"SYS_bpf","","",N,N],[17,"SYS_execveat","","",N,N],[17,"SYS_userfaultfd","","",N,N],[17,"SYS_membarrier","","",N,N],[17,"SYS_mlock2","","",N,N],[17,"SYS_copy_file_range","","",N,N],[17,"SYS_preadv2","","",N,N],[17,"SYS_pwritev2","","",N,N],[17,"SYS_pkey_mprotect","","",N,N],[17,"SYS_pkey_alloc","","",N,N],[17,"SYS_pkey_free","","",N,N],[11,"clone","libc","",130,[[["self"]],["statvfs"]]],[6,"clock_t","libc::unix::notbsd::linux::other::b64","",N,N],[6,"time_t","","",N,N],[6,"ino_t","","",N,N],[6,"off_t","","",N,N],[6,"blkcnt_t","","",N,N],[6,"__fsword_t","","",N,N],[6,"shmatt_t","","",N,N],[6,"msgqnum_t","","",N,N],[6,"msglen_t","","",N,N],[6,"fsblkcnt_t","","",N,N],[6,"fsfilcnt_t","","",N,N],[6,"rlim_t","","",N,N],[17,"__SIZEOF_PTHREAD_RWLOCKATTR_T","","",N,N],[17,"O_LARGEFILE","","",N,N],[11,"clone","libc","",111,[[["self"]],["sigset_t"]]],[11,"clone","","",112,[[["self"]],["sysinfo"]]],[11,"clone","","",113,[[["self"]],["msqid_ds"]]],[6,"__priority_which_t","libc::unix::notbsd::linux::other","",N,N],[17,"__UT_LINESIZE","","",N,N],[17,"__UT_NAMESIZE","","",N,N],[17,"__UT_HOSTSIZE","","",N,N],[17,"EMPTY","","",N,N],[17,"RUN_LVL","","",N,N],[17,"BOOT_TIME","","",N,N],[17,"NEW_TIME","","",N,N],[17,"OLD_TIME","","",N,N],[17,"INIT_PROCESS","","",N,N],[17,"LOGIN_PROCESS","","",N,N],[17,"USER_PROCESS","","",N,N],[17,"DEAD_PROCESS","","",N,N],[17,"ACCOUNTING","","",N,N],[17,"RLIMIT_RSS","","",N,N],[17,"RLIMIT_AS","","",N,N],[17,"RLIMIT_MEMLOCK","","",N,N],[17,"RLIM_INFINITY","","",N,N],[17,"RLIMIT_RTTIME","","",N,N],[17,"RLIMIT_NLIMITS","","",N,N],[17,"SOCK_NONBLOCK","","",N,N],[17,"SOL_RXRPC","","",N,N],[17,"SOL_PPPOL2TP","","",N,N],[17,"SOL_BLUETOOTH","","",N,N],[17,"SOL_PNPIPE","","",N,N],[17,"SOL_RDS","","",N,N],[17,"SOL_IUCV","","",N,N],[17,"SOL_CAIF","","",N,N],[17,"SOL_ALG","","",N,N],[17,"SOL_NFC","","",N,N],[17,"MSG_TRYHARD","","",N,N],[17,"LC_PAPER","","",N,N],[17,"LC_NAME","","",N,N],[17,"LC_ADDRESS","","",N,N],[17,"LC_TELEPHONE","","",N,N],[17,"LC_MEASUREMENT","","",N,N],[17,"LC_IDENTIFICATION","","",N,N],[17,"LC_PAPER_MASK","","",N,N],[17,"LC_NAME_MASK","","",N,N],[17,"LC_ADDRESS_MASK","","",N,N],[17,"LC_TELEPHONE_MASK","","",N,N],[17,"LC_MEASUREMENT_MASK","","",N,N],[17,"LC_IDENTIFICATION_MASK","","",N,N],[17,"LC_ALL_MASK","","",N,N],[17,"MAP_ANON","","",N,N],[17,"MAP_ANONYMOUS","","",N,N],[17,"MAP_DENYWRITE","","",N,N],[17,"MAP_EXECUTABLE","","",N,N],[17,"MAP_POPULATE","","",N,N],[17,"MAP_NONBLOCK","","",N,N],[17,"MAP_STACK","","",N,N],[17,"ENOTSUP","","",N,N],[17,"EUCLEAN","","",N,N],[17,"ENOTNAM","","",N,N],[17,"ENAVAIL","","",N,N],[17,"EISNAM","","",N,N],[17,"EREMOTEIO","","",N,N],[17,"SOCK_STREAM","","",N,N],[17,"SOCK_DGRAM","","",N,N],[17,"SOCK_SEQPACKET","","",N,N],[17,"SOCK_DCCP","","",N,N],[17,"SOCK_PACKET","","",N,N],[17,"TCP_COOKIE_TRANSACTIONS","","",N,N],[17,"TCP_THIN_LINEAR_TIMEOUTS","","",N,N],[17,"TCP_THIN_DUPACK","","",N,N],[17,"TCP_USER_TIMEOUT","","",N,N],[17,"TCP_REPAIR","","",N,N],[17,"TCP_REPAIR_QUEUE","","",N,N],[17,"TCP_QUEUE_SEQ","","",N,N],[17,"TCP_REPAIR_OPTIONS","","",N,N],[17,"TCP_FASTOPEN","","",N,N],[17,"TCP_TIMESTAMP","","",N,N],[17,"DCCP_SOCKOPT_PACKET_SIZE","","",N,N],[17,"DCCP_SOCKOPT_SERVICE","","",N,N],[17,"DCCP_SOCKOPT_CHANGE_L","","",N,N],[17,"DCCP_SOCKOPT_CHANGE_R","","",N,N],[17,"DCCP_SOCKOPT_GET_CUR_MPS","","",N,N],[17,"DCCP_SOCKOPT_SERVER_TIMEWAIT","","",N,N],[17,"DCCP_SOCKOPT_SEND_CSCOV","","",N,N],[17,"DCCP_SOCKOPT_RECV_CSCOV","","",N,N],[17,"DCCP_SOCKOPT_AVAILABLE_CCIDS","","",N,N],[17,"DCCP_SOCKOPT_CCID","","",N,N],[17,"DCCP_SOCKOPT_TX_CCID","","",N,N],[17,"DCCP_SOCKOPT_RX_CCID","","",N,N],[17,"DCCP_SOCKOPT_QPOLICY_ID","","",N,N],[17,"DCCP_SOCKOPT_QPOLICY_TXQLEN","","",N,N],[17,"DCCP_SOCKOPT_CCID_RX_INFO","","",N,N],[17,"DCCP_SOCKOPT_CCID_TX_INFO","","",N,N],[17,"DCCP_SERVICE_LIST_MAX_LEN","","maximum number of services provided on the same listening port",N,N],[17,"SIGTTIN","","",N,N],[17,"SIGTTOU","","",N,N],[17,"SIGXCPU","","",N,N],[17,"SIGXFSZ","","",N,N],[17,"SIGVTALRM","","",N,N],[17,"SIGPROF","","",N,N],[17,"SIGWINCH","","",N,N],[17,"SIGEV_THREAD_ID","","",N,N],[17,"BUFSIZ","","",N,N],[17,"TMP_MAX","","",N,N],[17,"FOPEN_MAX","","",N,N],[17,"POSIX_FADV_DONTNEED","","",N,N],[17,"POSIX_FADV_NOREUSE","","",N,N],[17,"POSIX_MADV_DONTNEED","","",N,N],[17,"_SC_EQUIV_CLASS_MAX","","",N,N],[17,"_SC_CHARCLASS_NAME_MAX","","",N,N],[17,"_SC_PII","","",N,N],[17,"_SC_PII_XTI","","",N,N],[17,"_SC_PII_SOCKET","","",N,N],[17,"_SC_PII_INTERNET","","",N,N],[17,"_SC_PII_OSI","","",N,N],[17,"_SC_POLL","","",N,N],[17,"_SC_SELECT","","",N,N],[17,"_SC_PII_INTERNET_STREAM","","",N,N],[17,"_SC_PII_INTERNET_DGRAM","","",N,N],[17,"_SC_PII_OSI_COTS","","",N,N],[17,"_SC_PII_OSI_CLTS","","",N,N],[17,"_SC_PII_OSI_M","","",N,N],[17,"_SC_T_IOV_MAX","","",N,N],[17,"_SC_2_C_VERSION","","",N,N],[17,"_SC_CHAR_BIT","","",N,N],[17,"_SC_CHAR_MAX","","",N,N],[17,"_SC_CHAR_MIN","","",N,N],[17,"_SC_INT_MAX","","",N,N],[17,"_SC_INT_MIN","","",N,N],[17,"_SC_LONG_BIT","","",N,N],[17,"_SC_WORD_BIT","","",N,N],[17,"_SC_MB_LEN_MAX","","",N,N],[17,"_SC_SSIZE_MAX","","",N,N],[17,"_SC_SCHAR_MAX","","",N,N],[17,"_SC_SCHAR_MIN","","",N,N],[17,"_SC_SHRT_MAX","","",N,N],[17,"_SC_SHRT_MIN","","",N,N],[17,"_SC_UCHAR_MAX","","",N,N],[17,"_SC_UINT_MAX","","",N,N],[17,"_SC_ULONG_MAX","","",N,N],[17,"_SC_USHRT_MAX","","",N,N],[17,"_SC_NL_ARGMAX","","",N,N],[17,"_SC_NL_LANGMAX","","",N,N],[17,"_SC_NL_MSGMAX","","",N,N],[17,"_SC_NL_NMAX","","",N,N],[17,"_SC_NL_SETMAX","","",N,N],[17,"_SC_NL_TEXTMAX","","",N,N],[17,"_SC_BASE","","",N,N],[17,"_SC_C_LANG_SUPPORT","","",N,N],[17,"_SC_C_LANG_SUPPORT_R","","",N,N],[17,"_SC_DEVICE_IO","","",N,N],[17,"_SC_DEVICE_SPECIFIC","","",N,N],[17,"_SC_DEVICE_SPECIFIC_R","","",N,N],[17,"_SC_FD_MGMT","","",N,N],[17,"_SC_FIFO","","",N,N],[17,"_SC_PIPE","","",N,N],[17,"_SC_FILE_ATTRIBUTES","","",N,N],[17,"_SC_FILE_LOCKING","","",N,N],[17,"_SC_FILE_SYSTEM","","",N,N],[17,"_SC_MULTI_PROCESS","","",N,N],[17,"_SC_SINGLE_PROCESS","","",N,N],[17,"_SC_NETWORKING","","",N,N],[17,"_SC_REGEX_VERSION","","",N,N],[17,"_SC_SIGNALS","","",N,N],[17,"_SC_SYSTEM_DATABASE","","",N,N],[17,"_SC_SYSTEM_DATABASE_R","","",N,N],[17,"_SC_USER_GROUPS","","",N,N],[17,"_SC_USER_GROUPS_R","","",N,N],[17,"_SC_LEVEL1_ICACHE_SIZE","","",N,N],[17,"_SC_LEVEL1_ICACHE_ASSOC","","",N,N],[17,"_SC_LEVEL1_ICACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL1_DCACHE_SIZE","","",N,N],[17,"_SC_LEVEL1_DCACHE_ASSOC","","",N,N],[17,"_SC_LEVEL1_DCACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL2_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL2_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL2_CACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL3_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL3_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL3_CACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL4_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL4_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL4_CACHE_LINESIZE","","",N,N],[17,"O_ACCMODE","","",N,N],[17,"ST_RELATIME","","",N,N],[17,"NI_MAXHOST","","",N,N],[17,"ADFS_SUPER_MAGIC","","",N,N],[17,"AFFS_SUPER_MAGIC","","",N,N],[17,"CODA_SUPER_MAGIC","","",N,N],[17,"CRAMFS_MAGIC","","",N,N],[17,"EFS_SUPER_MAGIC","","",N,N],[17,"EXT2_SUPER_MAGIC","","",N,N],[17,"EXT3_SUPER_MAGIC","","",N,N],[17,"EXT4_SUPER_MAGIC","","",N,N],[17,"HPFS_SUPER_MAGIC","","",N,N],[17,"HUGETLBFS_MAGIC","","",N,N],[17,"ISOFS_SUPER_MAGIC","","",N,N],[17,"JFFS2_SUPER_MAGIC","","",N,N],[17,"MINIX_SUPER_MAGIC","","",N,N],[17,"MINIX_SUPER_MAGIC2","","",N,N],[17,"MINIX2_SUPER_MAGIC","","",N,N],[17,"MINIX2_SUPER_MAGIC2","","",N,N],[17,"MSDOS_SUPER_MAGIC","","",N,N],[17,"NCP_SUPER_MAGIC","","",N,N],[17,"NFS_SUPER_MAGIC","","",N,N],[17,"OPENPROM_SUPER_MAGIC","","",N,N],[17,"PROC_SUPER_MAGIC","","",N,N],[17,"QNX4_SUPER_MAGIC","","",N,N],[17,"REISERFS_SUPER_MAGIC","","",N,N],[17,"SMB_SUPER_MAGIC","","",N,N],[17,"TMPFS_MAGIC","","",N,N],[17,"USBDEVICE_SUPER_MAGIC","","",N,N],[17,"VEOF","","",N,N],[17,"CPU_SETSIZE","","",N,N],[17,"PTRACE_TRACEME","","",N,N],[17,"PTRACE_PEEKTEXT","","",N,N],[17,"PTRACE_PEEKDATA","","",N,N],[17,"PTRACE_PEEKUSER","","",N,N],[17,"PTRACE_POKETEXT","","",N,N],[17,"PTRACE_POKEDATA","","",N,N],[17,"PTRACE_POKEUSER","","",N,N],[17,"PTRACE_CONT","","",N,N],[17,"PTRACE_KILL","","",N,N],[17,"PTRACE_SINGLESTEP","","",N,N],[17,"PTRACE_ATTACH","","",N,N],[17,"PTRACE_SYSCALL","","",N,N],[17,"PTRACE_SETOPTIONS","","",N,N],[17,"PTRACE_GETEVENTMSG","","",N,N],[17,"PTRACE_GETSIGINFO","","",N,N],[17,"PTRACE_SETSIGINFO","","",N,N],[17,"PTRACE_GETREGSET","","",N,N],[17,"PTRACE_SETREGSET","","",N,N],[17,"PTRACE_SEIZE","","",N,N],[17,"PTRACE_INTERRUPT","","",N,N],[17,"PTRACE_LISTEN","","",N,N],[17,"PTRACE_PEEKSIGINFO","","",N,N],[17,"EPOLLWAKEUP","","",N,N],[17,"MAP_HUGETLB","","",N,N],[17,"SEEK_DATA","","",N,N],[17,"SEEK_HOLE","","",N,N],[17,"TCSANOW","","",N,N],[17,"TCSADRAIN","","",N,N],[17,"TCSAFLUSH","","",N,N],[17,"TIOCLINUX","","",N,N],[17,"TIOCGSERIAL","","",N,N],[17,"RTLD_DEEPBIND","","",N,N],[17,"RTLD_GLOBAL","","",N,N],[17,"RTLD_NOLOAD","","",N,N],[17,"LINUX_REBOOT_MAGIC1","","",N,N],[17,"LINUX_REBOOT_MAGIC2","","",N,N],[17,"LINUX_REBOOT_MAGIC2A","","",N,N],[17,"LINUX_REBOOT_MAGIC2B","","",N,N],[17,"LINUX_REBOOT_MAGIC2C","","",N,N],[17,"LINUX_REBOOT_CMD_RESTART","","",N,N],[17,"LINUX_REBOOT_CMD_HALT","","",N,N],[17,"LINUX_REBOOT_CMD_CAD_ON","","",N,N],[17,"LINUX_REBOOT_CMD_CAD_OFF","","",N,N],[17,"LINUX_REBOOT_CMD_POWER_OFF","","",N,N],[17,"LINUX_REBOOT_CMD_RESTART2","","",N,N],[17,"LINUX_REBOOT_CMD_SW_SUSPEND","","",N,N],[17,"LINUX_REBOOT_CMD_KEXEC","","",N,N],[17,"NETLINK_ROUTE","","",N,N],[17,"NETLINK_UNUSED","","",N,N],[17,"NETLINK_USERSOCK","","",N,N],[17,"NETLINK_FIREWALL","","",N,N],[17,"NETLINK_SOCK_DIAG","","",N,N],[17,"NETLINK_NFLOG","","",N,N],[17,"NETLINK_XFRM","","",N,N],[17,"NETLINK_SELINUX","","",N,N],[17,"NETLINK_ISCSI","","",N,N],[17,"NETLINK_AUDIT","","",N,N],[17,"NETLINK_FIB_LOOKUP","","",N,N],[17,"NETLINK_CONNECTOR","","",N,N],[17,"NETLINK_NETFILTER","","",N,N],[17,"NETLINK_IP6_FW","","",N,N],[17,"NETLINK_DNRTMSG","","",N,N],[17,"NETLINK_KOBJECT_UEVENT","","",N,N],[17,"NETLINK_GENERIC","","",N,N],[17,"NETLINK_SCSITRANSPORT","","",N,N],[17,"NETLINK_ECRYPTFS","","",N,N],[17,"NETLINK_RDMA","","",N,N],[17,"NETLINK_CRYPTO","","",N,N],[17,"NETLINK_INET_DIAG","","",N,N],[17,"MAX_LINKS","","",N,N],[17,"NLM_F_REQUEST","","",N,N],[17,"NLM_F_MULTI","","",N,N],[17,"NLM_F_ACK","","",N,N],[17,"NLM_F_ECHO","","",N,N],[17,"NLM_F_DUMP_INTR","","",N,N],[17,"NLM_F_DUMP_FILTERED","","",N,N],[17,"NLM_F_ROOT","","",N,N],[17,"NLM_F_MATCH","","",N,N],[17,"NLM_F_ATOMIC","","",N,N],[17,"NLM_F_DUMP","","",N,N],[17,"NLM_F_REPLACE","","",N,N],[17,"NLM_F_EXCL","","",N,N],[17,"NLM_F_CREATE","","",N,N],[17,"NLM_F_APPEND","","",N,N],[17,"NETLINK_ADD_MEMBERSHIP","","",N,N],[17,"NETLINK_DROP_MEMBERSHIP","","",N,N],[17,"NETLINK_PKTINFO","","",N,N],[17,"NETLINK_BROADCAST_ERROR","","",N,N],[17,"NETLINK_NO_ENOBUFS","","",N,N],[17,"NETLINK_RX_RING","","",N,N],[17,"NETLINK_TX_RING","","",N,N],[17,"NETLINK_LISTEN_ALL_NSID","","",N,N],[17,"NETLINK_LIST_MEMBERSHIPS","","",N,N],[17,"NETLINK_CAP_ACK","","",N,N],[17,"NLA_F_NESTED","","",N,N],[17,"NLA_F_NET_BYTEORDER","","",N,N],[17,"NLA_TYPE_MASK","","",N,N],[17,"NLA_ALIGNTO","","",N,N],[17,"GENL_UNS_ADMIN_PERM","","",N,N],[17,"GENL_ID_VFS_DQUOT","","",N,N],[17,"GENL_ID_PMCRAID","","",N,N],[17,"TIOCM_LE","","",N,N],[17,"TIOCM_DTR","","",N,N],[17,"TIOCM_RTS","","",N,N],[17,"TIOCM_ST","","",N,N],[17,"TIOCM_SR","","",N,N],[17,"TIOCM_CTS","","",N,N],[17,"TIOCM_CAR","","",N,N],[17,"TIOCM_RNG","","",N,N],[17,"TIOCM_DSR","","",N,N],[17,"TIOCM_CD","","",N,N],[17,"TIOCM_RI","","",N,N],[17,"NF_NETDEV_INGRESS","","",N,N],[17,"NF_NETDEV_NUMHOOKS","","",N,N],[17,"NFPROTO_INET","","",N,N],[17,"NFPROTO_NETDEV","","",N,N],[17,"NFT_TABLE_MAXNAMELEN","","",N,N],[17,"NFT_CHAIN_MAXNAMELEN","","",N,N],[17,"NFT_SET_MAXNAMELEN","","",N,N],[17,"NFT_OBJ_MAXNAMELEN","","",N,N],[17,"NFT_USERDATA_MAXLEN","","",N,N],[17,"NFT_REG_VERDICT","","",N,N],[17,"NFT_REG_1","","",N,N],[17,"NFT_REG_2","","",N,N],[17,"NFT_REG_3","","",N,N],[17,"NFT_REG_4","","",N,N],[17,"__NFT_REG_MAX","","",N,N],[17,"NFT_REG32_00","","",N,N],[17,"NFT_REG32_01","","",N,N],[17,"NFT_REG32_02","","",N,N],[17,"NFT_REG32_03","","",N,N],[17,"NFT_REG32_04","","",N,N],[17,"NFT_REG32_05","","",N,N],[17,"NFT_REG32_06","","",N,N],[17,"NFT_REG32_07","","",N,N],[17,"NFT_REG32_08","","",N,N],[17,"NFT_REG32_09","","",N,N],[17,"NFT_REG32_10","","",N,N],[17,"NFT_REG32_11","","",N,N],[17,"NFT_REG32_12","","",N,N],[17,"NFT_REG32_13","","",N,N],[17,"NFT_REG32_14","","",N,N],[17,"NFT_REG32_15","","",N,N],[17,"NFT_REG_SIZE","","",N,N],[17,"NFT_REG32_SIZE","","",N,N],[17,"NFT_CONTINUE","","",N,N],[17,"NFT_BREAK","","",N,N],[17,"NFT_JUMP","","",N,N],[17,"NFT_GOTO","","",N,N],[17,"NFT_RETURN","","",N,N],[17,"NFT_MSG_NEWTABLE","","",N,N],[17,"NFT_MSG_GETTABLE","","",N,N],[17,"NFT_MSG_DELTABLE","","",N,N],[17,"NFT_MSG_NEWCHAIN","","",N,N],[17,"NFT_MSG_GETCHAIN","","",N,N],[17,"NFT_MSG_DELCHAIN","","",N,N],[17,"NFT_MSG_NEWRULE","","",N,N],[17,"NFT_MSG_GETRULE","","",N,N],[17,"NFT_MSG_DELRULE","","",N,N],[17,"NFT_MSG_NEWSET","","",N,N],[17,"NFT_MSG_GETSET","","",N,N],[17,"NFT_MSG_DELSET","","",N,N],[17,"NFT_MSG_NEWSETELEM","","",N,N],[17,"NFT_MSG_GETSETELEM","","",N,N],[17,"NFT_MSG_DELSETELEM","","",N,N],[17,"NFT_MSG_NEWGEN","","",N,N],[17,"NFT_MSG_GETGEN","","",N,N],[17,"NFT_MSG_TRACE","","",N,N],[17,"NFT_MSG_NEWOBJ","","",N,N],[17,"NFT_MSG_GETOBJ","","",N,N],[17,"NFT_MSG_DELOBJ","","",N,N],[17,"NFT_MSG_GETOBJ_RESET","","",N,N],[17,"NFT_MSG_MAX","","",N,N],[17,"NFT_SET_ANONYMOUS","","",N,N],[17,"NFT_SET_CONSTANT","","",N,N],[17,"NFT_SET_INTERVAL","","",N,N],[17,"NFT_SET_MAP","","",N,N],[17,"NFT_SET_TIMEOUT","","",N,N],[17,"NFT_SET_EVAL","","",N,N],[17,"NFT_SET_POL_PERFORMANCE","","",N,N],[17,"NFT_SET_POL_MEMORY","","",N,N],[17,"NFT_SET_ELEM_INTERVAL_END","","",N,N],[17,"NFT_DATA_VALUE","","",N,N],[17,"NFT_DATA_VERDICT","","",N,N],[17,"NFT_DATA_RESERVED_MASK","","",N,N],[17,"NFT_DATA_VALUE_MAXLEN","","",N,N],[17,"NFT_BYTEORDER_NTOH","","",N,N],[17,"NFT_BYTEORDER_HTON","","",N,N],[17,"NFT_CMP_EQ","","",N,N],[17,"NFT_CMP_NEQ","","",N,N],[17,"NFT_CMP_LT","","",N,N],[17,"NFT_CMP_LTE","","",N,N],[17,"NFT_CMP_GT","","",N,N],[17,"NFT_CMP_GTE","","",N,N],[17,"NFT_RANGE_EQ","","",N,N],[17,"NFT_RANGE_NEQ","","",N,N],[17,"NFT_LOOKUP_F_INV","","",N,N],[17,"NFT_DYNSET_OP_ADD","","",N,N],[17,"NFT_DYNSET_OP_UPDATE","","",N,N],[17,"NFT_DYNSET_F_INV","","",N,N],[17,"NFT_PAYLOAD_LL_HEADER","","",N,N],[17,"NFT_PAYLOAD_NETWORK_HEADER","","",N,N],[17,"NFT_PAYLOAD_TRANSPORT_HEADER","","",N,N],[17,"NFT_PAYLOAD_CSUM_NONE","","",N,N],[17,"NFT_PAYLOAD_CSUM_INET","","",N,N],[17,"NFT_META_LEN","","",N,N],[17,"NFT_META_PROTOCOL","","",N,N],[17,"NFT_META_PRIORITY","","",N,N],[17,"NFT_META_MARK","","",N,N],[17,"NFT_META_IIF","","",N,N],[17,"NFT_META_OIF","","",N,N],[17,"NFT_META_IIFNAME","","",N,N],[17,"NFT_META_OIFNAME","","",N,N],[17,"NFT_META_IIFTYPE","","",N,N],[17,"NFT_META_OIFTYPE","","",N,N],[17,"NFT_META_SKUID","","",N,N],[17,"NFT_META_SKGID","","",N,N],[17,"NFT_META_NFTRACE","","",N,N],[17,"NFT_META_RTCLASSID","","",N,N],[17,"NFT_META_SECMARK","","",N,N],[17,"NFT_META_NFPROTO","","",N,N],[17,"NFT_META_L4PROTO","","",N,N],[17,"NFT_META_BRI_IIFNAME","","",N,N],[17,"NFT_META_BRI_OIFNAME","","",N,N],[17,"NFT_META_PKTTYPE","","",N,N],[17,"NFT_META_CPU","","",N,N],[17,"NFT_META_IIFGROUP","","",N,N],[17,"NFT_META_OIFGROUP","","",N,N],[17,"NFT_META_CGROUP","","",N,N],[17,"NFT_META_PRANDOM","","",N,N],[17,"NFT_CT_STATE","","",N,N],[17,"NFT_CT_DIRECTION","","",N,N],[17,"NFT_CT_STATUS","","",N,N],[17,"NFT_CT_MARK","","",N,N],[17,"NFT_CT_SECMARK","","",N,N],[17,"NFT_CT_EXPIRATION","","",N,N],[17,"NFT_CT_HELPER","","",N,N],[17,"NFT_CT_L3PROTOCOL","","",N,N],[17,"NFT_CT_SRC","","",N,N],[17,"NFT_CT_DST","","",N,N],[17,"NFT_CT_PROTOCOL","","",N,N],[17,"NFT_CT_PROTO_SRC","","",N,N],[17,"NFT_CT_PROTO_DST","","",N,N],[17,"NFT_CT_LABELS","","",N,N],[17,"NFT_CT_PKTS","","",N,N],[17,"NFT_CT_BYTES","","",N,N],[17,"NFT_LIMIT_PKTS","","",N,N],[17,"NFT_LIMIT_PKT_BYTES","","",N,N],[17,"NFT_LIMIT_F_INV","","",N,N],[17,"NFT_QUEUE_FLAG_BYPASS","","",N,N],[17,"NFT_QUEUE_FLAG_CPU_FANOUT","","",N,N],[17,"NFT_QUEUE_FLAG_MASK","","",N,N],[17,"NFT_QUOTA_F_INV","","",N,N],[17,"NFT_REJECT_ICMP_UNREACH","","",N,N],[17,"NFT_REJECT_TCP_RST","","",N,N],[17,"NFT_REJECT_ICMPX_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_NO_ROUTE","","",N,N],[17,"NFT_REJECT_ICMPX_PORT_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_HOST_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_ADMIN_PROHIBITED","","",N,N],[17,"NFT_NAT_SNAT","","",N,N],[17,"NFT_NAT_DNAT","","",N,N],[17,"NFT_TRACETYPE_UNSPEC","","",N,N],[17,"NFT_TRACETYPE_POLICY","","",N,N],[17,"NFT_TRACETYPE_RETURN","","",N,N],[17,"NFT_TRACETYPE_RULE","","",N,N],[17,"NFT_NG_INCREMENTAL","","",N,N],[17,"NFT_NG_RANDOM","","",N,N],[17,"AF_MAX","","",N,N],[17,"PF_MAX","","",N,N],[17,"PTHREAD_STACK_MIN","","",N,N],[17,"PTHREAD_MUTEX_ADAPTIVE_NP","","",N,N],[11,"clone","libc","",89,[[["self"]],["aiocb"]]],[11,"clone","","",90,[[["self"]],["__exit_status"]]],[11,"clone","","",91,[[["self"]],["__timeval"]]],[11,"clone","","",92,[[["self"]],["utmpx"]]],[11,"clone","","",93,[[["self"]],["sigaction"]]],[11,"clone","","",94,[[["self"]],["stack_t"]]],[11,"clone","","",95,[[["self"]],["siginfo_t"]]],[11,"clone","","",96,[[["self"]],["glob64_t"]]],[11,"clone","","",97,[[["self"]],["statfs"]]],[11,"clone","","",98,[[["self"]],["msghdr"]]],[11,"clone","","",99,[[["self"]],["cmsghdr"]]],[11,"clone","","",100,[[["self"]],["termios"]]],[11,"clone","","",101,[[["self"]],["flock"]]],[11,"clone","","",102,[[["self"]],["sem_t"]]],[11,"clone","","",103,[[["self"]],["mallinfo"]]],[11,"clone","","",104,[[["self"]],["nlmsghdr"]]],[11,"clone","","",105,[[["self"]],["nlmsgerr"]]],[11,"clone","","",106,[[["self"]],["nl_pktinfo"]]],[11,"clone","","",107,[[["self"]],["nl_mmap_req"]]],[11,"clone","","",108,[[["self"]],["nl_mmap_hdr"]]],[11,"clone","","",109,[[["self"]],["nlattr"]]],[11,"clone","","",110,[[["self"]],["rtentry"]]],[6,"useconds_t","libc::unix::notbsd::linux","",N,N],[6,"dev_t","","",N,N],[6,"socklen_t","","",N,N],[6,"pthread_t","","",N,N],[6,"mode_t","","",N,N],[6,"ino64_t","","",N,N],[6,"off64_t","","",N,N],[6,"blkcnt64_t","","",N,N],[6,"rlim64_t","","",N,N],[6,"mqd_t","","",N,N],[6,"nfds_t","","",N,N],[6,"nl_item","","",N,N],[6,"idtype_t","","",N,N],[6,"loff_t","","",N,N],[6,"__u8","","",N,N],[6,"__u16","","",N,N],[6,"__s16","","",N,N],[6,"__u32","","",N,N],[6,"__s32","","",N,N],[6,"Elf32_Half","","",N,N],[6,"Elf32_Word","","",N,N],[6,"Elf32_Off","","",N,N],[6,"Elf32_Addr","","",N,N],[6,"Elf64_Half","","",N,N],[6,"Elf64_Word","","",N,N],[6,"Elf64_Off","","",N,N],[6,"Elf64_Addr","","",N,N],[6,"Elf64_Xword","","",N,N],[17,"ABDAY_1","","",N,N],[17,"ABDAY_2","","",N,N],[17,"ABDAY_3","","",N,N],[17,"ABDAY_4","","",N,N],[17,"ABDAY_5","","",N,N],[17,"ABDAY_6","","",N,N],[17,"ABDAY_7","","",N,N],[17,"DAY_1","","",N,N],[17,"DAY_2","","",N,N],[17,"DAY_3","","",N,N],[17,"DAY_4","","",N,N],[17,"DAY_5","","",N,N],[17,"DAY_6","","",N,N],[17,"DAY_7","","",N,N],[17,"ABMON_1","","",N,N],[17,"ABMON_2","","",N,N],[17,"ABMON_3","","",N,N],[17,"ABMON_4","","",N,N],[17,"ABMON_5","","",N,N],[17,"ABMON_6","","",N,N],[17,"ABMON_7","","",N,N],[17,"ABMON_8","","",N,N],[17,"ABMON_9","","",N,N],[17,"ABMON_10","","",N,N],[17,"ABMON_11","","",N,N],[17,"ABMON_12","","",N,N],[17,"MON_1","","",N,N],[17,"MON_2","","",N,N],[17,"MON_3","","",N,N],[17,"MON_4","","",N,N],[17,"MON_5","","",N,N],[17,"MON_6","","",N,N],[17,"MON_7","","",N,N],[17,"MON_8","","",N,N],[17,"MON_9","","",N,N],[17,"MON_10","","",N,N],[17,"MON_11","","",N,N],[17,"MON_12","","",N,N],[17,"AM_STR","","",N,N],[17,"PM_STR","","",N,N],[17,"D_T_FMT","","",N,N],[17,"D_FMT","","",N,N],[17,"T_FMT","","",N,N],[17,"T_FMT_AMPM","","",N,N],[17,"ERA","","",N,N],[17,"ERA_D_FMT","","",N,N],[17,"ALT_DIGITS","","",N,N],[17,"ERA_D_T_FMT","","",N,N],[17,"ERA_T_FMT","","",N,N],[17,"CODESET","","",N,N],[17,"CRNCYSTR","","",N,N],[17,"RUSAGE_THREAD","","",N,N],[17,"RUSAGE_CHILDREN","","",N,N],[17,"RADIXCHAR","","",N,N],[17,"THOUSEP","","",N,N],[17,"YESEXPR","","",N,N],[17,"NOEXPR","","",N,N],[17,"YESSTR","","",N,N],[17,"NOSTR","","",N,N],[17,"FILENAME_MAX","","",N,N],[17,"L_tmpnam","","",N,N],[17,"_PC_LINK_MAX","","",N,N],[17,"_PC_MAX_CANON","","",N,N],[17,"_PC_MAX_INPUT","","",N,N],[17,"_PC_NAME_MAX","","",N,N],[17,"_PC_PATH_MAX","","",N,N],[17,"_PC_PIPE_BUF","","",N,N],[17,"_PC_CHOWN_RESTRICTED","","",N,N],[17,"_PC_NO_TRUNC","","",N,N],[17,"_PC_VDISABLE","","",N,N],[17,"_PC_SYNC_IO","","",N,N],[17,"_PC_ASYNC_IO","","",N,N],[17,"_PC_PRIO_IO","","",N,N],[17,"_PC_SOCK_MAXBUF","","",N,N],[17,"_PC_FILESIZEBITS","","",N,N],[17,"_PC_REC_INCR_XFER_SIZE","","",N,N],[17,"_PC_REC_MAX_XFER_SIZE","","",N,N],[17,"_PC_REC_MIN_XFER_SIZE","","",N,N],[17,"_PC_REC_XFER_ALIGN","","",N,N],[17,"_PC_ALLOC_SIZE_MIN","","",N,N],[17,"_PC_SYMLINK_MAX","","",N,N],[17,"_PC_2_SYMLINKS","","",N,N],[17,"_SC_ARG_MAX","","",N,N],[17,"_SC_CHILD_MAX","","",N,N],[17,"_SC_CLK_TCK","","",N,N],[17,"_SC_NGROUPS_MAX","","",N,N],[17,"_SC_OPEN_MAX","","",N,N],[17,"_SC_STREAM_MAX","","",N,N],[17,"_SC_TZNAME_MAX","","",N,N],[17,"_SC_JOB_CONTROL","","",N,N],[17,"_SC_SAVED_IDS","","",N,N],[17,"_SC_REALTIME_SIGNALS","","",N,N],[17,"_SC_PRIORITY_SCHEDULING","","",N,N],[17,"_SC_TIMERS","","",N,N],[17,"_SC_ASYNCHRONOUS_IO","","",N,N],[17,"_SC_PRIORITIZED_IO","","",N,N],[17,"_SC_SYNCHRONIZED_IO","","",N,N],[17,"_SC_FSYNC","","",N,N],[17,"_SC_MAPPED_FILES","","",N,N],[17,"_SC_MEMLOCK","","",N,N],[17,"_SC_MEMLOCK_RANGE","","",N,N],[17,"_SC_MEMORY_PROTECTION","","",N,N],[17,"_SC_MESSAGE_PASSING","","",N,N],[17,"_SC_SEMAPHORES","","",N,N],[17,"_SC_SHARED_MEMORY_OBJECTS","","",N,N],[17,"_SC_AIO_LISTIO_MAX","","",N,N],[17,"_SC_AIO_MAX","","",N,N],[17,"_SC_AIO_PRIO_DELTA_MAX","","",N,N],[17,"_SC_DELAYTIMER_MAX","","",N,N],[17,"_SC_MQ_OPEN_MAX","","",N,N],[17,"_SC_MQ_PRIO_MAX","","",N,N],[17,"_SC_VERSION","","",N,N],[17,"_SC_PAGESIZE","","",N,N],[17,"_SC_PAGE_SIZE","","",N,N],[17,"_SC_RTSIG_MAX","","",N,N],[17,"_SC_SEM_NSEMS_MAX","","",N,N],[17,"_SC_SEM_VALUE_MAX","","",N,N],[17,"_SC_SIGQUEUE_MAX","","",N,N],[17,"_SC_TIMER_MAX","","",N,N],[17,"_SC_BC_BASE_MAX","","",N,N],[17,"_SC_BC_DIM_MAX","","",N,N],[17,"_SC_BC_SCALE_MAX","","",N,N],[17,"_SC_BC_STRING_MAX","","",N,N],[17,"_SC_COLL_WEIGHTS_MAX","","",N,N],[17,"_SC_EXPR_NEST_MAX","","",N,N],[17,"_SC_LINE_MAX","","",N,N],[17,"_SC_RE_DUP_MAX","","",N,N],[17,"_SC_2_VERSION","","",N,N],[17,"_SC_2_C_BIND","","",N,N],[17,"_SC_2_C_DEV","","",N,N],[17,"_SC_2_FORT_DEV","","",N,N],[17,"_SC_2_FORT_RUN","","",N,N],[17,"_SC_2_SW_DEV","","",N,N],[17,"_SC_2_LOCALEDEF","","",N,N],[17,"_SC_UIO_MAXIOV","","",N,N],[17,"_SC_IOV_MAX","","",N,N],[17,"_SC_THREADS","","",N,N],[17,"_SC_THREAD_SAFE_FUNCTIONS","","",N,N],[17,"_SC_GETGR_R_SIZE_MAX","","",N,N],[17,"_SC_GETPW_R_SIZE_MAX","","",N,N],[17,"_SC_LOGIN_NAME_MAX","","",N,N],[17,"_SC_TTY_NAME_MAX","","",N,N],[17,"_SC_THREAD_DESTRUCTOR_ITERATIONS","","",N,N],[17,"_SC_THREAD_KEYS_MAX","","",N,N],[17,"_SC_THREAD_STACK_MIN","","",N,N],[17,"_SC_THREAD_THREADS_MAX","","",N,N],[17,"_SC_THREAD_ATTR_STACKADDR","","",N,N],[17,"_SC_THREAD_ATTR_STACKSIZE","","",N,N],[17,"_SC_THREAD_PRIORITY_SCHEDULING","","",N,N],[17,"_SC_THREAD_PRIO_INHERIT","","",N,N],[17,"_SC_THREAD_PRIO_PROTECT","","",N,N],[17,"_SC_THREAD_PROCESS_SHARED","","",N,N],[17,"_SC_NPROCESSORS_CONF","","",N,N],[17,"_SC_NPROCESSORS_ONLN","","",N,N],[17,"_SC_PHYS_PAGES","","",N,N],[17,"_SC_AVPHYS_PAGES","","",N,N],[17,"_SC_ATEXIT_MAX","","",N,N],[17,"_SC_PASS_MAX","","",N,N],[17,"_SC_XOPEN_VERSION","","",N,N],[17,"_SC_XOPEN_XCU_VERSION","","",N,N],[17,"_SC_XOPEN_UNIX","","",N,N],[17,"_SC_XOPEN_CRYPT","","",N,N],[17,"_SC_XOPEN_ENH_I18N","","",N,N],[17,"_SC_XOPEN_SHM","","",N,N],[17,"_SC_2_CHAR_TERM","","",N,N],[17,"_SC_2_UPE","","",N,N],[17,"_SC_XOPEN_XPG2","","",N,N],[17,"_SC_XOPEN_XPG3","","",N,N],[17,"_SC_XOPEN_XPG4","","",N,N],[17,"_SC_NZERO","","",N,N],[17,"_SC_XBS5_ILP32_OFF32","","",N,N],[17,"_SC_XBS5_ILP32_OFFBIG","","",N,N],[17,"_SC_XBS5_LP64_OFF64","","",N,N],[17,"_SC_XBS5_LPBIG_OFFBIG","","",N,N],[17,"_SC_XOPEN_LEGACY","","",N,N],[17,"_SC_XOPEN_REALTIME","","",N,N],[17,"_SC_XOPEN_REALTIME_THREADS","","",N,N],[17,"_SC_ADVISORY_INFO","","",N,N],[17,"_SC_BARRIERS","","",N,N],[17,"_SC_CLOCK_SELECTION","","",N,N],[17,"_SC_CPUTIME","","",N,N],[17,"_SC_THREAD_CPUTIME","","",N,N],[17,"_SC_MONOTONIC_CLOCK","","",N,N],[17,"_SC_READER_WRITER_LOCKS","","",N,N],[17,"_SC_SPIN_LOCKS","","",N,N],[17,"_SC_REGEXP","","",N,N],[17,"_SC_SHELL","","",N,N],[17,"_SC_SPAWN","","",N,N],[17,"_SC_SPORADIC_SERVER","","",N,N],[17,"_SC_THREAD_SPORADIC_SERVER","","",N,N],[17,"_SC_TIMEOUTS","","",N,N],[17,"_SC_TYPED_MEMORY_OBJECTS","","",N,N],[17,"_SC_2_PBS","","",N,N],[17,"_SC_2_PBS_ACCOUNTING","","",N,N],[17,"_SC_2_PBS_LOCATE","","",N,N],[17,"_SC_2_PBS_MESSAGE","","",N,N],[17,"_SC_2_PBS_TRACK","","",N,N],[17,"_SC_SYMLOOP_MAX","","",N,N],[17,"_SC_STREAMS","","",N,N],[17,"_SC_2_PBS_CHECKPOINT","","",N,N],[17,"_SC_V6_ILP32_OFF32","","",N,N],[17,"_SC_V6_ILP32_OFFBIG","","",N,N],[17,"_SC_V6_LP64_OFF64","","",N,N],[17,"_SC_V6_LPBIG_OFFBIG","","",N,N],[17,"_SC_HOST_NAME_MAX","","",N,N],[17,"_SC_TRACE","","",N,N],[17,"_SC_TRACE_EVENT_FILTER","","",N,N],[17,"_SC_TRACE_INHERIT","","",N,N],[17,"_SC_TRACE_LOG","","",N,N],[17,"_SC_IPV6","","",N,N],[17,"_SC_RAW_SOCKETS","","",N,N],[17,"_SC_V7_ILP32_OFF32","","",N,N],[17,"_SC_V7_ILP32_OFFBIG","","",N,N],[17,"_SC_V7_LP64_OFF64","","",N,N],[17,"_SC_V7_LPBIG_OFFBIG","","",N,N],[17,"_SC_SS_REPL_MAX","","",N,N],[17,"_SC_TRACE_EVENT_NAME_MAX","","",N,N],[17,"_SC_TRACE_NAME_MAX","","",N,N],[17,"_SC_TRACE_SYS_MAX","","",N,N],[17,"_SC_TRACE_USER_EVENT_MAX","","",N,N],[17,"_SC_XOPEN_STREAMS","","",N,N],[17,"_SC_THREAD_ROBUST_PRIO_INHERIT","","",N,N],[17,"_SC_THREAD_ROBUST_PRIO_PROTECT","","",N,N],[17,"RLIM_SAVED_MAX","","",N,N],[17,"RLIM_SAVED_CUR","","",N,N],[17,"GLOB_ERR","","",N,N],[17,"GLOB_MARK","","",N,N],[17,"GLOB_NOSORT","","",N,N],[17,"GLOB_DOOFFS","","",N,N],[17,"GLOB_NOCHECK","","",N,N],[17,"GLOB_APPEND","","",N,N],[17,"GLOB_NOESCAPE","","",N,N],[17,"GLOB_NOSPACE","","",N,N],[17,"GLOB_ABORTED","","",N,N],[17,"GLOB_NOMATCH","","",N,N],[17,"POSIX_MADV_NORMAL","","",N,N],[17,"POSIX_MADV_RANDOM","","",N,N],[17,"POSIX_MADV_SEQUENTIAL","","",N,N],[17,"POSIX_MADV_WILLNEED","","",N,N],[17,"S_IEXEC","","",N,N],[17,"S_IWRITE","","",N,N],[17,"S_IREAD","","",N,N],[17,"F_LOCK","","",N,N],[17,"F_TEST","","",N,N],[17,"F_TLOCK","","",N,N],[17,"F_ULOCK","","",N,N],[17,"IFF_LOWER_UP","","",N,N],[17,"IFF_DORMANT","","",N,N],[17,"IFF_ECHO","","",N,N],[17,"IFF_TUN","","",N,N],[17,"IFF_TAP","","",N,N],[17,"IFF_NO_PI","","",N,N],[17,"TUN_READQ_SIZE","","",N,N],[17,"TUN_TUN_DEV","","",N,N],[17,"TUN_TAP_DEV","","",N,N],[17,"TUN_TYPE_MASK","","",N,N],[17,"IFF_ONE_QUEUE","","",N,N],[17,"IFF_VNET_HDR","","",N,N],[17,"IFF_TUN_EXCL","","",N,N],[17,"IFF_MULTI_QUEUE","","",N,N],[17,"IFF_ATTACH_QUEUE","","",N,N],[17,"IFF_DETACH_QUEUE","","",N,N],[17,"IFF_PERSIST","","",N,N],[17,"IFF_NOFILTER","","",N,N],[17,"ST_RDONLY","","",N,N],[17,"ST_NOSUID","","",N,N],[17,"ST_NODEV","","",N,N],[17,"ST_NOEXEC","","",N,N],[17,"ST_SYNCHRONOUS","","",N,N],[17,"ST_MANDLOCK","","",N,N],[17,"ST_WRITE","","",N,N],[17,"ST_APPEND","","",N,N],[17,"ST_IMMUTABLE","","",N,N],[17,"ST_NOATIME","","",N,N],[17,"ST_NODIRATIME","","",N,N],[17,"RTLD_NEXT","","",N,N],[17,"RTLD_DEFAULT","","",N,N],[17,"RTLD_NODELETE","","",N,N],[17,"RTLD_NOW","","",N,N],[17,"TCP_MD5SIG","","",N,N],[17,"PTHREAD_MUTEX_INITIALIZER","","",N,N],[17,"PTHREAD_COND_INITIALIZER","","",N,N],[17,"PTHREAD_RWLOCK_INITIALIZER","","",N,N],[17,"PTHREAD_MUTEX_NORMAL","","",N,N],[17,"PTHREAD_MUTEX_RECURSIVE","","",N,N],[17,"PTHREAD_MUTEX_ERRORCHECK","","",N,N],[17,"PTHREAD_MUTEX_DEFAULT","","",N,N],[17,"PTHREAD_PROCESS_PRIVATE","","",N,N],[17,"PTHREAD_PROCESS_SHARED","","",N,N],[17,"__SIZEOF_PTHREAD_COND_T","","",N,N],[17,"RENAME_NOREPLACE","","",N,N],[17,"RENAME_EXCHANGE","","",N,N],[17,"RENAME_WHITEOUT","","",N,N],[17,"SCHED_OTHER","","",N,N],[17,"SCHED_FIFO","","",N,N],[17,"SCHED_RR","","",N,N],[17,"SCHED_BATCH","","",N,N],[17,"SCHED_IDLE","","",N,N],[17,"IPPROTO_HOPOPTS","","Hop-by-hop option header",N,N],[17,"IPPROTO_IGMP","","group mgmt protocol",N,N],[17,"IPPROTO_IPIP","","for compatibility",N,N],[17,"IPPROTO_EGP","","exterior gateway protocol",N,N],[17,"IPPROTO_PUP","","pup",N,N],[17,"IPPROTO_IDP","","xns idp",N,N],[17,"IPPROTO_TP","","tp-4 w/ class negotiation",N,N],[17,"IPPROTO_DCCP","","DCCP",N,N],[17,"IPPROTO_ROUTING","","IP6 routing header",N,N],[17,"IPPROTO_FRAGMENT","","IP6 fragmentation header",N,N],[17,"IPPROTO_RSVP","","resource reservation",N,N],[17,"IPPROTO_GRE","","General Routing Encap.",N,N],[17,"IPPROTO_ESP","","IP6 Encap Sec. Payload",N,N],[17,"IPPROTO_AH","","IP6 Auth Header",N,N],[17,"IPPROTO_NONE","","IP6 no next header",N,N],[17,"IPPROTO_DSTOPTS","","IP6 destination option",N,N],[17,"IPPROTO_MTP","","",N,N],[17,"IPPROTO_BEETPH","","",N,N],[17,"IPPROTO_ENCAP","","encapsulation header",N,N],[17,"IPPROTO_PIM","","Protocol indep. multicast",N,N],[17,"IPPROTO_COMP","","IP Payload Comp. Protocol",N,N],[17,"IPPROTO_SCTP","","SCTP",N,N],[17,"IPPROTO_MH","","",N,N],[17,"IPPROTO_UDPLITE","","",N,N],[17,"IPPROTO_MPLS","","",N,N],[17,"IPPROTO_RAW","","raw IP packet",N,N],[17,"IPPROTO_MAX","","",N,N],[17,"AF_IB","","",N,N],[17,"AF_MPLS","","",N,N],[17,"AF_NFC","","",N,N],[17,"AF_VSOCK","","",N,N],[17,"PF_IB","","",N,N],[17,"PF_MPLS","","",N,N],[17,"PF_NFC","","",N,N],[17,"PF_VSOCK","","",N,N],[17,"IPC_PRIVATE","","",N,N],[17,"IPC_CREAT","","",N,N],[17,"IPC_EXCL","","",N,N],[17,"IPC_NOWAIT","","",N,N],[17,"IPC_RMID","","",N,N],[17,"IPC_SET","","",N,N],[17,"IPC_STAT","","",N,N],[17,"IPC_INFO","","",N,N],[17,"MSG_STAT","","",N,N],[17,"MSG_INFO","","",N,N],[17,"MSG_NOERROR","","",N,N],[17,"MSG_EXCEPT","","",N,N],[17,"MSG_COPY","","",N,N],[17,"SHM_R","","",N,N],[17,"SHM_W","","",N,N],[17,"SHM_RDONLY","","",N,N],[17,"SHM_RND","","",N,N],[17,"SHM_REMAP","","",N,N],[17,"SHM_EXEC","","",N,N],[17,"SHM_LOCK","","",N,N],[17,"SHM_UNLOCK","","",N,N],[17,"SHM_HUGETLB","","",N,N],[17,"SHM_NORESERVE","","",N,N],[17,"EPOLLRDHUP","","",N,N],[17,"EPOLLEXCLUSIVE","","",N,N],[17,"EPOLLONESHOT","","",N,N],[17,"QFMT_VFS_OLD","","",N,N],[17,"QFMT_VFS_V0","","",N,N],[17,"QFMT_VFS_V1","","",N,N],[17,"EFD_SEMAPHORE","","",N,N],[17,"LOG_NFACILITIES","","",N,N],[17,"SEM_FAILED","","",N,N],[17,"RB_AUTOBOOT","","",N,N],[17,"RB_HALT_SYSTEM","","",N,N],[17,"RB_ENABLE_CAD","","",N,N],[17,"RB_DISABLE_CAD","","",N,N],[17,"RB_POWER_OFF","","",N,N],[17,"RB_SW_SUSPEND","","",N,N],[17,"RB_KEXEC","","",N,N],[17,"AI_PASSIVE","","",N,N],[17,"AI_CANONNAME","","",N,N],[17,"AI_NUMERICHOST","","",N,N],[17,"AI_V4MAPPED","","",N,N],[17,"AI_ALL","","",N,N],[17,"AI_ADDRCONFIG","","",N,N],[17,"AI_NUMERICSERV","","",N,N],[17,"EAI_BADFLAGS","","",N,N],[17,"EAI_NONAME","","",N,N],[17,"EAI_AGAIN","","",N,N],[17,"EAI_FAIL","","",N,N],[17,"EAI_NODATA","","",N,N],[17,"EAI_FAMILY","","",N,N],[17,"EAI_SOCKTYPE","","",N,N],[17,"EAI_SERVICE","","",N,N],[17,"EAI_MEMORY","","",N,N],[17,"EAI_SYSTEM","","",N,N],[17,"EAI_OVERFLOW","","",N,N],[17,"NI_NUMERICHOST","","",N,N],[17,"NI_NUMERICSERV","","",N,N],[17,"NI_NOFQDN","","",N,N],[17,"NI_NAMEREQD","","",N,N],[17,"NI_DGRAM","","",N,N],[17,"SYNC_FILE_RANGE_WAIT_BEFORE","","",N,N],[17,"SYNC_FILE_RANGE_WRITE","","",N,N],[17,"SYNC_FILE_RANGE_WAIT_AFTER","","",N,N],[17,"AIO_CANCELED","","",N,N],[17,"AIO_NOTCANCELED","","",N,N],[17,"AIO_ALLDONE","","",N,N],[17,"LIO_READ","","",N,N],[17,"LIO_WRITE","","",N,N],[17,"LIO_NOP","","",N,N],[17,"LIO_WAIT","","",N,N],[17,"LIO_NOWAIT","","",N,N],[17,"MREMAP_MAYMOVE","","",N,N],[17,"MREMAP_FIXED","","",N,N],[17,"PR_SET_PDEATHSIG","","",N,N],[17,"PR_GET_PDEATHSIG","","",N,N],[17,"PR_GET_DUMPABLE","","",N,N],[17,"PR_SET_DUMPABLE","","",N,N],[17,"PR_GET_UNALIGN","","",N,N],[17,"PR_SET_UNALIGN","","",N,N],[17,"PR_UNALIGN_NOPRINT","","",N,N],[17,"PR_UNALIGN_SIGBUS","","",N,N],[17,"PR_GET_KEEPCAPS","","",N,N],[17,"PR_SET_KEEPCAPS","","",N,N],[17,"PR_GET_FPEMU","","",N,N],[17,"PR_SET_FPEMU","","",N,N],[17,"PR_FPEMU_NOPRINT","","",N,N],[17,"PR_FPEMU_SIGFPE","","",N,N],[17,"PR_GET_FPEXC","","",N,N],[17,"PR_SET_FPEXC","","",N,N],[17,"PR_FP_EXC_SW_ENABLE","","",N,N],[17,"PR_FP_EXC_DIV","","",N,N],[17,"PR_FP_EXC_OVF","","",N,N],[17,"PR_FP_EXC_UND","","",N,N],[17,"PR_FP_EXC_RES","","",N,N],[17,"PR_FP_EXC_INV","","",N,N],[17,"PR_FP_EXC_DISABLED","","",N,N],[17,"PR_FP_EXC_NONRECOV","","",N,N],[17,"PR_FP_EXC_ASYNC","","",N,N],[17,"PR_FP_EXC_PRECISE","","",N,N],[17,"PR_GET_TIMING","","",N,N],[17,"PR_SET_TIMING","","",N,N],[17,"PR_TIMING_STATISTICAL","","",N,N],[17,"PR_TIMING_TIMESTAMP","","",N,N],[17,"PR_SET_NAME","","",N,N],[17,"PR_GET_NAME","","",N,N],[17,"PR_GET_ENDIAN","","",N,N],[17,"PR_SET_ENDIAN","","",N,N],[17,"PR_ENDIAN_BIG","","",N,N],[17,"PR_ENDIAN_LITTLE","","",N,N],[17,"PR_ENDIAN_PPC_LITTLE","","",N,N],[17,"PR_GET_SECCOMP","","",N,N],[17,"PR_SET_SECCOMP","","",N,N],[17,"PR_CAPBSET_READ","","",N,N],[17,"PR_CAPBSET_DROP","","",N,N],[17,"PR_GET_TSC","","",N,N],[17,"PR_SET_TSC","","",N,N],[17,"PR_TSC_ENABLE","","",N,N],[17,"PR_TSC_SIGSEGV","","",N,N],[17,"PR_GET_SECUREBITS","","",N,N],[17,"PR_SET_SECUREBITS","","",N,N],[17,"PR_SET_TIMERSLACK","","",N,N],[17,"PR_GET_TIMERSLACK","","",N,N],[17,"PR_TASK_PERF_EVENTS_DISABLE","","",N,N],[17,"PR_TASK_PERF_EVENTS_ENABLE","","",N,N],[17,"PR_MCE_KILL","","",N,N],[17,"PR_MCE_KILL_CLEAR","","",N,N],[17,"PR_MCE_KILL_SET","","",N,N],[17,"PR_MCE_KILL_LATE","","",N,N],[17,"PR_MCE_KILL_EARLY","","",N,N],[17,"PR_MCE_KILL_DEFAULT","","",N,N],[17,"PR_MCE_KILL_GET","","",N,N],[17,"PR_SET_MM","","",N,N],[17,"PR_SET_MM_START_CODE","","",N,N],[17,"PR_SET_MM_END_CODE","","",N,N],[17,"PR_SET_MM_START_DATA","","",N,N],[17,"PR_SET_MM_END_DATA","","",N,N],[17,"PR_SET_MM_START_STACK","","",N,N],[17,"PR_SET_MM_START_BRK","","",N,N],[17,"PR_SET_MM_BRK","","",N,N],[17,"PR_SET_MM_ARG_START","","",N,N],[17,"PR_SET_MM_ARG_END","","",N,N],[17,"PR_SET_MM_ENV_START","","",N,N],[17,"PR_SET_MM_ENV_END","","",N,N],[17,"PR_SET_MM_AUXV","","",N,N],[17,"PR_SET_MM_EXE_FILE","","",N,N],[17,"PR_SET_MM_MAP","","",N,N],[17,"PR_SET_MM_MAP_SIZE","","",N,N],[17,"PR_SET_PTRACER","","",N,N],[17,"PR_SET_CHILD_SUBREAPER","","",N,N],[17,"PR_GET_CHILD_SUBREAPER","","",N,N],[17,"PR_SET_NO_NEW_PRIVS","","",N,N],[17,"PR_GET_NO_NEW_PRIVS","","",N,N],[17,"PR_GET_TID_ADDRESS","","",N,N],[17,"PR_SET_THP_DISABLE","","",N,N],[17,"PR_GET_THP_DISABLE","","",N,N],[17,"PR_MPX_ENABLE_MANAGEMENT","","",N,N],[17,"PR_MPX_DISABLE_MANAGEMENT","","",N,N],[17,"PR_SET_FP_MODE","","",N,N],[17,"PR_GET_FP_MODE","","",N,N],[17,"PR_FP_MODE_FR","","",N,N],[17,"PR_FP_MODE_FRE","","",N,N],[17,"PR_CAP_AMBIENT","","",N,N],[17,"PR_CAP_AMBIENT_IS_SET","","",N,N],[17,"PR_CAP_AMBIENT_RAISE","","",N,N],[17,"PR_CAP_AMBIENT_LOWER","","",N,N],[17,"PR_CAP_AMBIENT_CLEAR_ALL","","",N,N],[17,"GRND_NONBLOCK","","",N,N],[17,"GRND_RANDOM","","",N,N],[17,"SECCOMP_MODE_DISABLED","","",N,N],[17,"SECCOMP_MODE_STRICT","","",N,N],[17,"SECCOMP_MODE_FILTER","","",N,N],[17,"ITIMER_REAL","","",N,N],[17,"ITIMER_VIRTUAL","","",N,N],[17,"ITIMER_PROF","","",N,N],[17,"TFD_CLOEXEC","","",N,N],[17,"TFD_NONBLOCK","","",N,N],[17,"TFD_TIMER_ABSTIME","","",N,N],[17,"XATTR_CREATE","","",N,N],[17,"XATTR_REPLACE","","",N,N],[17,"_POSIX_VDISABLE","","",N,N],[17,"FALLOC_FL_KEEP_SIZE","","",N,N],[17,"FALLOC_FL_PUNCH_HOLE","","",N,N],[17,"FALLOC_FL_COLLAPSE_RANGE","","",N,N],[17,"FALLOC_FL_ZERO_RANGE","","",N,N],[17,"FALLOC_FL_INSERT_RANGE","","",N,N],[17,"FALLOC_FL_UNSHARE_RANGE","","",N,N],[17,"ENOATTR","","",N,N],[17,"SO_ORIGINAL_DST","","",N,N],[17,"IUTF8","","",N,N],[17,"CMSPAR","","",N,N],[17,"MFD_CLOEXEC","","",N,N],[17,"MFD_ALLOW_SEALING","","",N,N],[17,"PT_NULL","","",N,N],[17,"PT_LOAD","","",N,N],[17,"PT_DYNAMIC","","",N,N],[17,"PT_INTERP","","",N,N],[17,"PT_NOTE","","",N,N],[17,"PT_SHLIB","","",N,N],[17,"PT_PHDR","","",N,N],[17,"PT_TLS","","",N,N],[17,"PT_NUM","","",N,N],[17,"PT_LOOS","","",N,N],[17,"PT_GNU_EH_FRAME","","",N,N],[17,"PT_GNU_STACK","","",N,N],[17,"PT_GNU_RELRO","","",N,N],[17,"ETH_ALEN","","",N,N],[17,"ETH_HLEN","","",N,N],[17,"ETH_ZLEN","","",N,N],[17,"ETH_DATA_LEN","","",N,N],[17,"ETH_FRAME_LEN","","",N,N],[17,"ETH_FCS_LEN","","",N,N],[17,"ETH_P_LOOP","","",N,N],[17,"ETH_P_PUP","","",N,N],[17,"ETH_P_PUPAT","","",N,N],[17,"ETH_P_IP","","",N,N],[17,"ETH_P_X25","","",N,N],[17,"ETH_P_ARP","","",N,N],[17,"ETH_P_BPQ","","",N,N],[17,"ETH_P_IEEEPUP","","",N,N],[17,"ETH_P_IEEEPUPAT","","",N,N],[17,"ETH_P_BATMAN","","",N,N],[17,"ETH_P_DEC","","",N,N],[17,"ETH_P_DNA_DL","","",N,N],[17,"ETH_P_DNA_RC","","",N,N],[17,"ETH_P_DNA_RT","","",N,N],[17,"ETH_P_LAT","","",N,N],[17,"ETH_P_DIAG","","",N,N],[17,"ETH_P_CUST","","",N,N],[17,"ETH_P_SCA","","",N,N],[17,"ETH_P_TEB","","",N,N],[17,"ETH_P_RARP","","",N,N],[17,"ETH_P_ATALK","","",N,N],[17,"ETH_P_AARP","","",N,N],[17,"ETH_P_8021Q","","",N,N],[17,"ETH_P_IPX","","",N,N],[17,"ETH_P_IPV6","","",N,N],[17,"ETH_P_PAUSE","","",N,N],[17,"ETH_P_SLOW","","",N,N],[17,"ETH_P_WCCP","","",N,N],[17,"ETH_P_MPLS_UC","","",N,N],[17,"ETH_P_MPLS_MC","","",N,N],[17,"ETH_P_ATMMPOA","","",N,N],[17,"ETH_P_PPP_DISC","","",N,N],[17,"ETH_P_PPP_SES","","",N,N],[17,"ETH_P_LINK_CTL","","",N,N],[17,"ETH_P_ATMFATE","","",N,N],[17,"ETH_P_PAE","","",N,N],[17,"ETH_P_AOE","","",N,N],[17,"ETH_P_8021AD","","",N,N],[17,"ETH_P_802_EX1","","",N,N],[17,"ETH_P_TIPC","","",N,N],[17,"ETH_P_MACSEC","","",N,N],[17,"ETH_P_8021AH","","",N,N],[17,"ETH_P_MVRP","","",N,N],[17,"ETH_P_1588","","",N,N],[17,"ETH_P_PRP","","",N,N],[17,"ETH_P_FCOE","","",N,N],[17,"ETH_P_TDLS","","",N,N],[17,"ETH_P_FIP","","",N,N],[17,"ETH_P_80221","","",N,N],[17,"ETH_P_LOOPBACK","","",N,N],[17,"ETH_P_QINQ1","","",N,N],[17,"ETH_P_QINQ2","","",N,N],[17,"ETH_P_QINQ3","","",N,N],[17,"ETH_P_EDSA","","",N,N],[17,"ETH_P_AF_IUCV","","",N,N],[17,"ETH_P_802_3_MIN","","",N,N],[17,"ETH_P_802_3","","",N,N],[17,"ETH_P_AX25","","",N,N],[17,"ETH_P_ALL","","",N,N],[17,"ETH_P_802_2","","",N,N],[17,"ETH_P_SNAP","","",N,N],[17,"ETH_P_DDCMP","","",N,N],[17,"ETH_P_WAN_PPP","","",N,N],[17,"ETH_P_PPP_MP","","",N,N],[17,"ETH_P_LOCALTALK","","",N,N],[17,"ETH_P_CANFD","","",N,N],[17,"ETH_P_PPPTALK","","",N,N],[17,"ETH_P_TR_802_2","","",N,N],[17,"ETH_P_MOBITEX","","",N,N],[17,"ETH_P_CONTROL","","",N,N],[17,"ETH_P_IRDA","","",N,N],[17,"ETH_P_ECONET","","",N,N],[17,"ETH_P_HDLC","","",N,N],[17,"ETH_P_ARCNET","","",N,N],[17,"ETH_P_DSA","","",N,N],[17,"ETH_P_TRAILER","","",N,N],[17,"ETH_P_PHONET","","",N,N],[17,"ETH_P_IEEE802154","","",N,N],[17,"ETH_P_CAIF","","",N,N],[17,"POSIX_SPAWN_RESETIDS","","",N,N],[17,"POSIX_SPAWN_SETPGROUP","","",N,N],[17,"POSIX_SPAWN_SETSIGDEF","","",N,N],[17,"POSIX_SPAWN_SETSIGMASK","","",N,N],[17,"POSIX_SPAWN_SETSCHEDPARAM","","",N,N],[17,"POSIX_SPAWN_SETSCHEDULER","","",N,N],[17,"NLMSG_NOOP","","",N,N],[17,"NLMSG_ERROR","","",N,N],[17,"NLMSG_DONE","","",N,N],[17,"NLMSG_OVERRUN","","",N,N],[17,"NLMSG_MIN_TYPE","","",N,N],[17,"GENL_NAMSIZ","","",N,N],[17,"GENL_MIN_ID","","",N,N],[17,"GENL_MAX_ID","","",N,N],[17,"GENL_ADMIN_PERM","","",N,N],[17,"GENL_CMD_CAP_DO","","",N,N],[17,"GENL_CMD_CAP_DUMP","","",N,N],[17,"GENL_CMD_CAP_HASPOL","","",N,N],[17,"GENL_ID_CTRL","","",N,N],[17,"CTRL_CMD_UNSPEC","","",N,N],[17,"CTRL_CMD_NEWFAMILY","","",N,N],[17,"CTRL_CMD_DELFAMILY","","",N,N],[17,"CTRL_CMD_GETFAMILY","","",N,N],[17,"CTRL_CMD_NEWOPS","","",N,N],[17,"CTRL_CMD_DELOPS","","",N,N],[17,"CTRL_CMD_GETOPS","","",N,N],[17,"CTRL_CMD_NEWMCAST_GRP","","",N,N],[17,"CTRL_CMD_DELMCAST_GRP","","",N,N],[17,"CTRL_CMD_GETMCAST_GRP","","",N,N],[17,"CTRL_ATTR_UNSPEC","","",N,N],[17,"CTRL_ATTR_FAMILY_ID","","",N,N],[17,"CTRL_ATTR_FAMILY_NAME","","",N,N],[17,"CTRL_ATTR_VERSION","","",N,N],[17,"CTRL_ATTR_HDRSIZE","","",N,N],[17,"CTRL_ATTR_MAXATTR","","",N,N],[17,"CTRL_ATTR_OPS","","",N,N],[17,"CTRL_ATTR_MCAST_GROUPS","","",N,N],[17,"CTRL_ATTR_OP_UNSPEC","","",N,N],[17,"CTRL_ATTR_OP_ID","","",N,N],[17,"CTRL_ATTR_OP_FLAGS","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_UNSPEC","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_NAME","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_ID","","",N,N],[17,"PACKET_ADD_MEMBERSHIP","","",N,N],[17,"PACKET_DROP_MEMBERSHIP","","",N,N],[17,"PACKET_MR_MULTICAST","","",N,N],[17,"PACKET_MR_PROMISC","","",N,N],[17,"PACKET_MR_ALLMULTI","","",N,N],[17,"PACKET_MR_UNICAST","","",N,N],[17,"NF_DROP","","",N,N],[17,"NF_ACCEPT","","",N,N],[17,"NF_STOLEN","","",N,N],[17,"NF_QUEUE","","",N,N],[17,"NF_REPEAT","","",N,N],[17,"NF_STOP","","",N,N],[17,"NF_MAX_VERDICT","","",N,N],[17,"NF_VERDICT_MASK","","",N,N],[17,"NF_VERDICT_FLAG_QUEUE_BYPASS","","",N,N],[17,"NF_VERDICT_QMASK","","",N,N],[17,"NF_VERDICT_QBITS","","",N,N],[17,"NF_VERDICT_BITS","","",N,N],[17,"NF_INET_PRE_ROUTING","","",N,N],[17,"NF_INET_LOCAL_IN","","",N,N],[17,"NF_INET_FORWARD","","",N,N],[17,"NF_INET_LOCAL_OUT","","",N,N],[17,"NF_INET_POST_ROUTING","","",N,N],[17,"NF_INET_NUMHOOKS","","",N,N],[17,"NFPROTO_UNSPEC","","",N,N],[17,"NFPROTO_IPV4","","",N,N],[17,"NFPROTO_ARP","","",N,N],[17,"NFPROTO_BRIDGE","","",N,N],[17,"NFPROTO_IPV6","","",N,N],[17,"NFPROTO_DECNET","","",N,N],[17,"NFPROTO_NUMPROTO","","",N,N],[17,"NF_IP_PRE_ROUTING","","",N,N],[17,"NF_IP_LOCAL_IN","","",N,N],[17,"NF_IP_FORWARD","","",N,N],[17,"NF_IP_LOCAL_OUT","","",N,N],[17,"NF_IP_POST_ROUTING","","",N,N],[17,"NF_IP_NUMHOOKS","","",N,N],[17,"NF_IP_PRI_FIRST","","",N,N],[17,"NF_IP_PRI_CONNTRACK_DEFRAG","","",N,N],[17,"NF_IP_PRI_RAW","","",N,N],[17,"NF_IP_PRI_SELINUX_FIRST","","",N,N],[17,"NF_IP_PRI_CONNTRACK","","",N,N],[17,"NF_IP_PRI_MANGLE","","",N,N],[17,"NF_IP_PRI_NAT_DST","","",N,N],[17,"NF_IP_PRI_FILTER","","",N,N],[17,"NF_IP_PRI_SECURITY","","",N,N],[17,"NF_IP_PRI_NAT_SRC","","",N,N],[17,"NF_IP_PRI_SELINUX_LAST","","",N,N],[17,"NF_IP_PRI_CONNTRACK_HELPER","","",N,N],[17,"NF_IP_PRI_CONNTRACK_CONFIRM","","",N,N],[17,"NF_IP_PRI_LAST","","",N,N],[17,"NF_IP6_PRE_ROUTING","","",N,N],[17,"NF_IP6_LOCAL_IN","","",N,N],[17,"NF_IP6_FORWARD","","",N,N],[17,"NF_IP6_LOCAL_OUT","","",N,N],[17,"NF_IP6_POST_ROUTING","","",N,N],[17,"NF_IP6_NUMHOOKS","","",N,N],[17,"NF_IP6_PRI_FIRST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK_DEFRAG","","",N,N],[17,"NF_IP6_PRI_RAW","","",N,N],[17,"NF_IP6_PRI_SELINUX_FIRST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK","","",N,N],[17,"NF_IP6_PRI_MANGLE","","",N,N],[17,"NF_IP6_PRI_NAT_DST","","",N,N],[17,"NF_IP6_PRI_FILTER","","",N,N],[17,"NF_IP6_PRI_SECURITY","","",N,N],[17,"NF_IP6_PRI_NAT_SRC","","",N,N],[17,"NF_IP6_PRI_SELINUX_LAST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK_HELPER","","",N,N],[17,"NF_IP6_PRI_LAST","","",N,N],[17,"SIOCADDRT","","",N,N],[17,"SIOCDELRT","","",N,N],[17,"SIOCGIFNAME","","",N,N],[17,"SIOCSIFLINK","","",N,N],[17,"SIOCGIFCONF","","",N,N],[17,"SIOCGIFFLAGS","","",N,N],[17,"SIOCSIFFLAGS","","",N,N],[17,"SIOCGIFADDR","","",N,N],[17,"SIOCSIFADDR","","",N,N],[17,"SIOCGIFDSTADDR","","",N,N],[17,"SIOCSIFDSTADDR","","",N,N],[17,"SIOCGIFBRDADDR","","",N,N],[17,"SIOCSIFBRDADDR","","",N,N],[17,"SIOCGIFNETMASK","","",N,N],[17,"SIOCSIFNETMASK","","",N,N],[17,"SIOCGIFMETRIC","","",N,N],[17,"SIOCSIFMETRIC","","",N,N],[17,"SIOCGIFMEM","","",N,N],[17,"SIOCSIFMEM","","",N,N],[17,"SIOCGIFMTU","","",N,N],[17,"SIOCSIFMTU","","",N,N],[17,"SIOCSIFHWADDR","","",N,N],[17,"SIOCGIFENCAP","","",N,N],[17,"SIOCSIFENCAP","","",N,N],[17,"SIOCGIFHWADDR","","",N,N],[17,"SIOCGIFSLAVE","","",N,N],[17,"SIOCSIFSLAVE","","",N,N],[17,"SIOCADDMULTI","","",N,N],[17,"SIOCDELMULTI","","",N,N],[17,"SIOCDARP","","",N,N],[17,"SIOCGARP","","",N,N],[17,"SIOCSARP","","",N,N],[17,"SIOCDRARP","","",N,N],[17,"SIOCGRARP","","",N,N],[17,"SIOCSRARP","","",N,N],[17,"SIOCGIFMAP","","",N,N],[17,"SIOCSIFMAP","","",N,N],[17,"IPTOS_TOS_MASK","","",N,N],[17,"IPTOS_PREC_MASK","","",N,N],[17,"RTF_UP","","",N,N],[17,"RTF_GATEWAY","","",N,N],[17,"RTF_HOST","","",N,N],[17,"RTF_REINSTATE","","",N,N],[17,"RTF_DYNAMIC","","",N,N],[17,"RTF_MODIFIED","","",N,N],[17,"RTF_MTU","","",N,N],[17,"RTF_MSS","","",N,N],[17,"RTF_WINDOW","","",N,N],[17,"RTF_IRTT","","",N,N],[17,"RTF_REJECT","","",N,N],[17,"RTF_STATIC","","",N,N],[17,"RTF_XRESOLVE","","",N,N],[17,"RTF_NOFORWARD","","",N,N],[17,"RTF_THROW","","",N,N],[17,"RTF_NOPMTUDISC","","",N,N],[17,"RTF_DEFAULT","","",N,N],[17,"RTF_ALLONLINK","","",N,N],[17,"RTF_ADDRCONF","","",N,N],[17,"RTF_LINKRT","","",N,N],[17,"RTF_NONEXTHOP","","",N,N],[17,"RTF_CACHE","","",N,N],[17,"RTF_FLOW","","",N,N],[17,"RTF_POLICY","","",N,N],[17,"RTCF_VALVE","","",N,N],[17,"RTCF_MASQ","","",N,N],[17,"RTCF_NAT","","",N,N],[17,"RTCF_DOREDIRECT","","",N,N],[17,"RTCF_LOG","","",N,N],[17,"RTCF_DIRECTSRC","","",N,N],[17,"RTF_LOCAL","","",N,N],[17,"RTF_INTERFACE","","",N,N],[17,"RTF_MULTICAST","","",N,N],[17,"RTF_BROADCAST","","",N,N],[17,"RTF_NAT","","",N,N],[17,"RTF_ADDRCLASSMASK","","",N,N],[17,"RT_CLASS_UNSPEC","","",N,N],[17,"RT_CLASS_DEFAULT","","",N,N],[17,"RT_CLASS_MAIN","","",N,N],[17,"RT_CLASS_LOCAL","","",N,N],[17,"RT_CLASS_MAX","","",N,N],[17,"RTMSG_OVERRUN","","",N,N],[17,"RTMSG_NEWDEVICE","","",N,N],[17,"RTMSG_DELDEVICE","","",N,N],[17,"RTMSG_NEWROUTE","","",N,N],[17,"RTMSG_DELROUTE","","",N,N],[17,"RTMSG_NEWRULE","","",N,N],[17,"RTMSG_DELRULE","","",N,N],[17,"RTMSG_CONTROL","","",N,N],[17,"RTMSG_AR_FAILED","","",N,N],[17,"MAX_ADDR_LEN","","",N,N],[17,"ARPD_UPDATE","","",N,N],[17,"ARPD_LOOKUP","","",N,N],[17,"ARPD_FLUSH","","",N,N],[17,"ATF_MAGIC","","",N,N],[17,"MODULE_INIT_IGNORE_MODVERSIONS","","",N,N],[17,"MODULE_INIT_IGNORE_VERMAGIC","","",N,N],[11,"clone","libc","",42,[[["self"]],["dirent"]]],[11,"clone","","",43,[[["self"]],["dirent64"]]],[11,"clone","","",44,[[["self"]],["rlimit64"]]],[11,"clone","","",45,[[["self"]],["glob_t"]]],[11,"clone","","",46,[[["self"]],["pthread_mutex_t"]]],[11,"clone","","",47,[[["self"]],["pthread_rwlock_t"]]],[11,"clone","","",48,[[["self"]],["pthread_mutexattr_t"]]],[11,"clone","","",49,[[["self"]],["pthread_rwlockattr_t"]]],[11,"clone","","",50,[[["self"]],["pthread_cond_t"]]],[11,"clone","","",51,[[["self"]],["pthread_condattr_t"]]],[11,"clone","","",52,[[["self"]],["passwd"]]],[11,"clone","","",53,[[["self"]],["spwd"]]],[11,"clone","","",54,[[["self"]],["dqblk"]]],[11,"clone","","",55,[[["self"]],["signalfd_siginfo"]]],[11,"clone","","",56,[[["self"]],["itimerspec"]]],[11,"clone","","",57,[[["self"]],["fsid_t"]]],[11,"clone","","",58,[[["self"]],["mq_attr"]]],[11,"clone","","",59,[[["self"]],["packet_mreq"]]],[11,"clone","","",60,[[["self"]],["cpu_set_t"]]],[11,"clone","","",61,[[["self"]],["if_nameindex"]]],[11,"clone","","",62,[[["self"]],["msginfo"]]],[11,"clone","","",63,[[["self"]],["mmsghdr"]]],[11,"clone","","",64,[[["self"]],["sembuf"]]],[11,"clone","","",65,[[["self"]],["input_event"]]],[11,"clone","","",66,[[["self"]],["input_id"]]],[11,"clone","","",67,[[["self"]],["input_absinfo"]]],[11,"clone","","",68,[[["self"]],["input_keymap_entry"]]],[11,"clone","","",69,[[["self"]],["input_mask"]]],[11,"clone","","",70,[[["self"]],["ff_replay"]]],[11,"clone","","",71,[[["self"]],["ff_trigger"]]],[11,"clone","","",72,[[["self"]],["ff_envelope"]]],[11,"clone","","",73,[[["self"]],["ff_constant_effect"]]],[11,"clone","","",74,[[["self"]],["ff_ramp_effect"]]],[11,"clone","","",75,[[["self"]],["ff_condition_effect"]]],[11,"clone","","",76,[[["self"]],["ff_periodic_effect"]]],[11,"clone","","",77,[[["self"]],["ff_rumble_effect"]]],[11,"clone","","",78,[[["self"]],["ff_effect"]]],[11,"clone","","",79,[[["self"]],["dl_phdr_info"]]],[11,"clone","","",80,[[["self"]],["elf32_phdr"]]],[11,"clone","","",81,[[["self"]],["elf64_phdr"]]],[11,"clone","","",82,[[["self"]],["ucred"]]],[11,"clone","","",83,[[["self"]],["mntent"]]],[11,"clone","","",84,[[["self"]],["posix_spawn_file_actions_t"]]],[11,"clone","","",85,[[["self"]],["posix_spawnattr_t"]]],[11,"clone","","",86,[[["self"]],["genlmsghdr"]]],[11,"clone","","",87,[[["self"]],["in6_pktinfo"]]],[11,"clone","","",88,[[["self"]],["arpd_request"]]],[6,"sa_family_t","libc::unix::notbsd","",N,N],[6,"pthread_key_t","","",N,N],[6,"speed_t","","",N,N],[6,"tcflag_t","","",N,N],[6,"clockid_t","","",N,N],[6,"key_t","","",N,N],[6,"id_t","","",N,N],[17,"ULONG_SIZE","","",N,N],[17,"EXIT_FAILURE","","",N,N],[17,"EXIT_SUCCESS","","",N,N],[17,"RAND_MAX","","",N,N],[17,"EOF","","",N,N],[17,"SEEK_SET","","",N,N],[17,"SEEK_CUR","","",N,N],[17,"SEEK_END","","",N,N],[17,"_IOFBF","","",N,N],[17,"_IONBF","","",N,N],[17,"_IOLBF","","",N,N],[17,"F_DUPFD","","",N,N],[17,"F_GETFD","","",N,N],[17,"F_SETFD","","",N,N],[17,"F_GETFL","","",N,N],[17,"F_SETFL","","",N,N],[17,"F_SETLEASE","","",N,N],[17,"F_GETLEASE","","",N,N],[17,"F_NOTIFY","","",N,N],[17,"F_CANCELLK","","",N,N],[17,"F_DUPFD_CLOEXEC","","",N,N],[17,"F_SETPIPE_SZ","","",N,N],[17,"F_GETPIPE_SZ","","",N,N],[17,"F_ADD_SEALS","","",N,N],[17,"F_GET_SEALS","","",N,N],[17,"F_SEAL_SEAL","","",N,N],[17,"F_SEAL_SHRINK","","",N,N],[17,"F_SEAL_GROW","","",N,N],[17,"F_SEAL_WRITE","","",N,N],[17,"SIGTRAP","","",N,N],[17,"PTHREAD_CREATE_JOINABLE","","",N,N],[17,"PTHREAD_CREATE_DETACHED","","",N,N],[17,"CLOCK_REALTIME","","",N,N],[17,"CLOCK_MONOTONIC","","",N,N],[17,"CLOCK_PROCESS_CPUTIME_ID","","",N,N],[17,"CLOCK_THREAD_CPUTIME_ID","","",N,N],[17,"CLOCK_MONOTONIC_RAW","","",N,N],[17,"CLOCK_REALTIME_COARSE","","",N,N],[17,"CLOCK_MONOTONIC_COARSE","","",N,N],[17,"CLOCK_BOOTTIME","","",N,N],[17,"CLOCK_REALTIME_ALARM","","",N,N],[17,"CLOCK_BOOTTIME_ALARM","","",N,N],[17,"TIMER_ABSTIME","","",N,N],[17,"RLIMIT_CPU","","",N,N],[17,"RLIMIT_FSIZE","","",N,N],[17,"RLIMIT_DATA","","",N,N],[17,"RLIMIT_STACK","","",N,N],[17,"RLIMIT_CORE","","",N,N],[17,"RLIMIT_LOCKS","","",N,N],[17,"RLIMIT_SIGPENDING","","",N,N],[17,"RLIMIT_MSGQUEUE","","",N,N],[17,"RLIMIT_NICE","","",N,N],[17,"RLIMIT_RTPRIO","","",N,N],[17,"RUSAGE_SELF","","",N,N],[17,"O_RDONLY","","",N,N],[17,"O_WRONLY","","",N,N],[17,"O_RDWR","","",N,N],[17,"SOCK_CLOEXEC","","",N,N],[17,"S_IFIFO","","",N,N],[17,"S_IFCHR","","",N,N],[17,"S_IFBLK","","",N,N],[17,"S_IFDIR","","",N,N],[17,"S_IFREG","","",N,N],[17,"S_IFLNK","","",N,N],[17,"S_IFSOCK","","",N,N],[17,"S_IFMT","","",N,N],[17,"S_IRWXU","","",N,N],[17,"S_IXUSR","","",N,N],[17,"S_IWUSR","","",N,N],[17,"S_IRUSR","","",N,N],[17,"S_IRWXG","","",N,N],[17,"S_IXGRP","","",N,N],[17,"S_IWGRP","","",N,N],[17,"S_IRGRP","","",N,N],[17,"S_IRWXO","","",N,N],[17,"S_IXOTH","","",N,N],[17,"S_IWOTH","","",N,N],[17,"S_IROTH","","",N,N],[17,"F_OK","","",N,N],[17,"R_OK","","",N,N],[17,"W_OK","","",N,N],[17,"X_OK","","",N,N],[17,"STDIN_FILENO","","",N,N],[17,"STDOUT_FILENO","","",N,N],[17,"STDERR_FILENO","","",N,N],[17,"SIGHUP","","",N,N],[17,"SIGINT","","",N,N],[17,"SIGQUIT","","",N,N],[17,"SIGILL","","",N,N],[17,"SIGABRT","","",N,N],[17,"SIGFPE","","",N,N],[17,"SIGKILL","","",N,N],[17,"SIGSEGV","","",N,N],[17,"SIGPIPE","","",N,N],[17,"SIGALRM","","",N,N],[17,"SIGTERM","","",N,N],[17,"PROT_NONE","","",N,N],[17,"PROT_READ","","",N,N],[17,"PROT_WRITE","","",N,N],[17,"PROT_EXEC","","",N,N],[17,"LC_CTYPE","","",N,N],[17,"LC_NUMERIC","","",N,N],[17,"LC_TIME","","",N,N],[17,"LC_COLLATE","","",N,N],[17,"LC_MONETARY","","",N,N],[17,"LC_MESSAGES","","",N,N],[17,"LC_ALL","","",N,N],[17,"LC_CTYPE_MASK","","",N,N],[17,"LC_NUMERIC_MASK","","",N,N],[17,"LC_TIME_MASK","","",N,N],[17,"LC_COLLATE_MASK","","",N,N],[17,"LC_MONETARY_MASK","","",N,N],[17,"LC_MESSAGES_MASK","","",N,N],[17,"MAP_FILE","","",N,N],[17,"MAP_SHARED","","",N,N],[17,"MAP_PRIVATE","","",N,N],[17,"MAP_FIXED","","",N,N],[17,"MAP_FAILED","","",N,N],[17,"MS_ASYNC","","",N,N],[17,"MS_INVALIDATE","","",N,N],[17,"MS_SYNC","","",N,N],[17,"MS_RDONLY","","",N,N],[17,"MS_NOSUID","","",N,N],[17,"MS_NODEV","","",N,N],[17,"MS_NOEXEC","","",N,N],[17,"MS_SYNCHRONOUS","","",N,N],[17,"MS_REMOUNT","","",N,N],[17,"MS_MANDLOCK","","",N,N],[17,"MS_DIRSYNC","","",N,N],[17,"MS_NOATIME","","",N,N],[17,"MS_NODIRATIME","","",N,N],[17,"MS_BIND","","",N,N],[17,"MS_MOVE","","",N,N],[17,"MS_REC","","",N,N],[17,"MS_SILENT","","",N,N],[17,"MS_POSIXACL","","",N,N],[17,"MS_UNBINDABLE","","",N,N],[17,"MS_PRIVATE","","",N,N],[17,"MS_SLAVE","","",N,N],[17,"MS_SHARED","","",N,N],[17,"MS_RELATIME","","",N,N],[17,"MS_KERNMOUNT","","",N,N],[17,"MS_I_VERSION","","",N,N],[17,"MS_STRICTATIME","","",N,N],[17,"MS_ACTIVE","","",N,N],[17,"MS_NOUSER","","",N,N],[17,"MS_MGC_VAL","","",N,N],[17,"MS_MGC_MSK","","",N,N],[17,"MS_RMT_MASK","","",N,N],[17,"EPERM","","",N,N],[17,"ENOENT","","",N,N],[17,"ESRCH","","",N,N],[17,"EINTR","","",N,N],[17,"EIO","","",N,N],[17,"ENXIO","","",N,N],[17,"E2BIG","","",N,N],[17,"ENOEXEC","","",N,N],[17,"EBADF","","",N,N],[17,"ECHILD","","",N,N],[17,"EAGAIN","","",N,N],[17,"ENOMEM","","",N,N],[17,"EACCES","","",N,N],[17,"EFAULT","","",N,N],[17,"ENOTBLK","","",N,N],[17,"EBUSY","","",N,N],[17,"EEXIST","","",N,N],[17,"EXDEV","","",N,N],[17,"ENODEV","","",N,N],[17,"ENOTDIR","","",N,N],[17,"EISDIR","","",N,N],[17,"EINVAL","","",N,N],[17,"ENFILE","","",N,N],[17,"EMFILE","","",N,N],[17,"ENOTTY","","",N,N],[17,"ETXTBSY","","",N,N],[17,"EFBIG","","",N,N],[17,"ENOSPC","","",N,N],[17,"ESPIPE","","",N,N],[17,"EROFS","","",N,N],[17,"EMLINK","","",N,N],[17,"EPIPE","","",N,N],[17,"EDOM","","",N,N],[17,"ERANGE","","",N,N],[17,"EWOULDBLOCK","","",N,N],[17,"SCM_RIGHTS","","",N,N],[17,"SCM_CREDENTIALS","","",N,N],[17,"PROT_GROWSDOWN","","",N,N],[17,"PROT_GROWSUP","","",N,N],[17,"MAP_TYPE","","",N,N],[17,"MADV_NORMAL","","",N,N],[17,"MADV_RANDOM","","",N,N],[17,"MADV_SEQUENTIAL","","",N,N],[17,"MADV_WILLNEED","","",N,N],[17,"MADV_DONTNEED","","",N,N],[17,"MADV_FREE","","",N,N],[17,"MADV_REMOVE","","",N,N],[17,"MADV_DONTFORK","","",N,N],[17,"MADV_DOFORK","","",N,N],[17,"MADV_MERGEABLE","","",N,N],[17,"MADV_UNMERGEABLE","","",N,N],[17,"MADV_HUGEPAGE","","",N,N],[17,"MADV_NOHUGEPAGE","","",N,N],[17,"MADV_DONTDUMP","","",N,N],[17,"MADV_DODUMP","","",N,N],[17,"MADV_HWPOISON","","",N,N],[17,"MADV_SOFT_OFFLINE","","",N,N],[17,"IFF_UP","","",N,N],[17,"IFF_BROADCAST","","",N,N],[17,"IFF_DEBUG","","",N,N],[17,"IFF_LOOPBACK","","",N,N],[17,"IFF_POINTOPOINT","","",N,N],[17,"IFF_NOTRAILERS","","",N,N],[17,"IFF_RUNNING","","",N,N],[17,"IFF_NOARP","","",N,N],[17,"IFF_PROMISC","","",N,N],[17,"IFF_ALLMULTI","","",N,N],[17,"IFF_MASTER","","",N,N],[17,"IFF_SLAVE","","",N,N],[17,"IFF_MULTICAST","","",N,N],[17,"IFF_PORTSEL","","",N,N],[17,"IFF_AUTOMEDIA","","",N,N],[17,"IFF_DYNAMIC","","",N,N],[17,"SOL_IP","","",N,N],[17,"SOL_TCP","","",N,N],[17,"SOL_UDP","","",N,N],[17,"SOL_IPV6","","",N,N],[17,"SOL_ICMPV6","","",N,N],[17,"SOL_RAW","","",N,N],[17,"SOL_DECNET","","",N,N],[17,"SOL_X25","","",N,N],[17,"SOL_PACKET","","",N,N],[17,"SOL_ATM","","",N,N],[17,"SOL_AAL","","",N,N],[17,"SOL_IRDA","","",N,N],[17,"SOL_NETBEUI","","",N,N],[17,"SOL_LLC","","",N,N],[17,"SOL_DCCP","","",N,N],[17,"SOL_NETLINK","","",N,N],[17,"SOL_TIPC","","",N,N],[17,"AF_UNSPEC","","",N,N],[17,"AF_UNIX","","",N,N],[17,"AF_LOCAL","","",N,N],[17,"AF_INET","","",N,N],[17,"AF_AX25","","",N,N],[17,"AF_IPX","","",N,N],[17,"AF_APPLETALK","","",N,N],[17,"AF_NETROM","","",N,N],[17,"AF_BRIDGE","","",N,N],[17,"AF_ATMPVC","","",N,N],[17,"AF_X25","","",N,N],[17,"AF_INET6","","",N,N],[17,"AF_ROSE","","",N,N],[17,"AF_DECnet","","",N,N],[17,"AF_NETBEUI","","",N,N],[17,"AF_SECURITY","","",N,N],[17,"AF_KEY","","",N,N],[17,"AF_NETLINK","","",N,N],[17,"AF_ROUTE","","",N,N],[17,"AF_PACKET","","",N,N],[17,"AF_ASH","","",N,N],[17,"AF_ECONET","","",N,N],[17,"AF_ATMSVC","","",N,N],[17,"AF_RDS","","",N,N],[17,"AF_SNA","","",N,N],[17,"AF_IRDA","","",N,N],[17,"AF_PPPOX","","",N,N],[17,"AF_WANPIPE","","",N,N],[17,"AF_LLC","","",N,N],[17,"AF_CAN","","",N,N],[17,"AF_TIPC","","",N,N],[17,"AF_BLUETOOTH","","",N,N],[17,"AF_IUCV","","",N,N],[17,"AF_RXRPC","","",N,N],[17,"AF_ISDN","","",N,N],[17,"AF_PHONET","","",N,N],[17,"AF_IEEE802154","","",N,N],[17,"AF_CAIF","","",N,N],[17,"AF_ALG","","",N,N],[17,"PF_UNSPEC","","",N,N],[17,"PF_UNIX","","",N,N],[17,"PF_LOCAL","","",N,N],[17,"PF_INET","","",N,N],[17,"PF_AX25","","",N,N],[17,"PF_IPX","","",N,N],[17,"PF_APPLETALK","","",N,N],[17,"PF_NETROM","","",N,N],[17,"PF_BRIDGE","","",N,N],[17,"PF_ATMPVC","","",N,N],[17,"PF_X25","","",N,N],[17,"PF_INET6","","",N,N],[17,"PF_ROSE","","",N,N],[17,"PF_DECnet","","",N,N],[17,"PF_NETBEUI","","",N,N],[17,"PF_SECURITY","","",N,N],[17,"PF_KEY","","",N,N],[17,"PF_NETLINK","","",N,N],[17,"PF_ROUTE","","",N,N],[17,"PF_PACKET","","",N,N],[17,"PF_ASH","","",N,N],[17,"PF_ECONET","","",N,N],[17,"PF_ATMSVC","","",N,N],[17,"PF_RDS","","",N,N],[17,"PF_SNA","","",N,N],[17,"PF_IRDA","","",N,N],[17,"PF_PPPOX","","",N,N],[17,"PF_WANPIPE","","",N,N],[17,"PF_LLC","","",N,N],[17,"PF_CAN","","",N,N],[17,"PF_TIPC","","",N,N],[17,"PF_BLUETOOTH","","",N,N],[17,"PF_IUCV","","",N,N],[17,"PF_RXRPC","","",N,N],[17,"PF_ISDN","","",N,N],[17,"PF_PHONET","","",N,N],[17,"PF_IEEE802154","","",N,N],[17,"PF_CAIF","","",N,N],[17,"PF_ALG","","",N,N],[17,"SOMAXCONN","","",N,N],[17,"MSG_OOB","","",N,N],[17,"MSG_PEEK","","",N,N],[17,"MSG_DONTROUTE","","",N,N],[17,"MSG_CTRUNC","","",N,N],[17,"MSG_TRUNC","","",N,N],[17,"MSG_DONTWAIT","","",N,N],[17,"MSG_EOR","","",N,N],[17,"MSG_WAITALL","","",N,N],[17,"MSG_FIN","","",N,N],[17,"MSG_SYN","","",N,N],[17,"MSG_CONFIRM","","",N,N],[17,"MSG_RST","","",N,N],[17,"MSG_ERRQUEUE","","",N,N],[17,"MSG_NOSIGNAL","","",N,N],[17,"MSG_MORE","","",N,N],[17,"MSG_WAITFORONE","","",N,N],[17,"MSG_FASTOPEN","","",N,N],[17,"MSG_CMSG_CLOEXEC","","",N,N],[17,"SCM_TIMESTAMP","","",N,N],[17,"SOCK_RAW","","",N,N],[17,"SOCK_RDM","","",N,N],[17,"IP_MULTICAST_IF","","",N,N],[17,"IP_MULTICAST_TTL","","",N,N],[17,"IP_MULTICAST_LOOP","","",N,N],[17,"IP_TTL","","",N,N],[17,"IP_HDRINCL","","",N,N],[17,"IP_PKTINFO","","",N,N],[17,"IP_ADD_MEMBERSHIP","","",N,N],[17,"IP_DROP_MEMBERSHIP","","",N,N],[17,"IP_TRANSPARENT","","",N,N],[17,"IPV6_UNICAST_HOPS","","",N,N],[17,"IPV6_MULTICAST_IF","","",N,N],[17,"IPV6_MULTICAST_HOPS","","",N,N],[17,"IPV6_MULTICAST_LOOP","","",N,N],[17,"IPV6_ADD_MEMBERSHIP","","",N,N],[17,"IPV6_DROP_MEMBERSHIP","","",N,N],[17,"IPV6_V6ONLY","","",N,N],[17,"IPV6_RECVPKTINFO","","",N,N],[17,"IPV6_PKTINFO","","",N,N],[17,"TCP_NODELAY","","",N,N],[17,"TCP_MAXSEG","","",N,N],[17,"TCP_CORK","","",N,N],[17,"TCP_KEEPIDLE","","",N,N],[17,"TCP_KEEPINTVL","","",N,N],[17,"TCP_KEEPCNT","","",N,N],[17,"TCP_SYNCNT","","",N,N],[17,"TCP_LINGER2","","",N,N],[17,"TCP_DEFER_ACCEPT","","",N,N],[17,"TCP_WINDOW_CLAMP","","",N,N],[17,"TCP_INFO","","",N,N],[17,"TCP_QUICKACK","","",N,N],[17,"TCP_CONGESTION","","",N,N],[17,"SO_DEBUG","","",N,N],[17,"SHUT_RD","","",N,N],[17,"SHUT_WR","","",N,N],[17,"SHUT_RDWR","","",N,N],[17,"LOCK_SH","","",N,N],[17,"LOCK_EX","","",N,N],[17,"LOCK_NB","","",N,N],[17,"LOCK_UN","","",N,N],[17,"SS_ONSTACK","","",N,N],[17,"SS_DISABLE","","",N,N],[17,"PATH_MAX","","",N,N],[17,"FD_SETSIZE","","",N,N],[17,"EPOLLIN","","",N,N],[17,"EPOLLPRI","","",N,N],[17,"EPOLLOUT","","",N,N],[17,"EPOLLRDNORM","","",N,N],[17,"EPOLLRDBAND","","",N,N],[17,"EPOLLWRNORM","","",N,N],[17,"EPOLLWRBAND","","",N,N],[17,"EPOLLMSG","","",N,N],[17,"EPOLLERR","","",N,N],[17,"EPOLLHUP","","",N,N],[17,"EPOLLET","","",N,N],[17,"EPOLL_CTL_ADD","","",N,N],[17,"EPOLL_CTL_MOD","","",N,N],[17,"EPOLL_CTL_DEL","","",N,N],[17,"MNT_DETACH","","",N,N],[17,"MNT_EXPIRE","","",N,N],[17,"Q_GETFMT","","",N,N],[17,"Q_GETINFO","","",N,N],[17,"Q_SETINFO","","",N,N],[17,"QIF_BLIMITS","","",N,N],[17,"QIF_SPACE","","",N,N],[17,"QIF_ILIMITS","","",N,N],[17,"QIF_INODES","","",N,N],[17,"QIF_BTIME","","",N,N],[17,"QIF_ITIME","","",N,N],[17,"QIF_LIMITS","","",N,N],[17,"QIF_USAGE","","",N,N],[17,"QIF_TIMES","","",N,N],[17,"QIF_ALL","","",N,N],[17,"MNT_FORCE","","",N,N],[17,"Q_SYNC","","",N,N],[17,"Q_QUOTAON","","",N,N],[17,"Q_QUOTAOFF","","",N,N],[17,"Q_GETQUOTA","","",N,N],[17,"Q_SETQUOTA","","",N,N],[17,"TCIOFF","","",N,N],[17,"TCION","","",N,N],[17,"TCOOFF","","",N,N],[17,"TCOON","","",N,N],[17,"TCIFLUSH","","",N,N],[17,"TCOFLUSH","","",N,N],[17,"TCIOFLUSH","","",N,N],[17,"NL0","","",N,N],[17,"NL1","","",N,N],[17,"TAB0","","",N,N],[17,"CR0","","",N,N],[17,"FF0","","",N,N],[17,"BS0","","",N,N],[17,"VT0","","",N,N],[17,"VERASE","","",N,N],[17,"VKILL","","",N,N],[17,"VINTR","","",N,N],[17,"VQUIT","","",N,N],[17,"VLNEXT","","",N,N],[17,"IGNBRK","","",N,N],[17,"BRKINT","","",N,N],[17,"IGNPAR","","",N,N],[17,"PARMRK","","",N,N],[17,"INPCK","","",N,N],[17,"ISTRIP","","",N,N],[17,"INLCR","","",N,N],[17,"IGNCR","","",N,N],[17,"ICRNL","","",N,N],[17,"IXANY","","",N,N],[17,"IMAXBEL","","",N,N],[17,"OPOST","","",N,N],[17,"CS5","","",N,N],[17,"CRTSCTS","","",N,N],[17,"ECHO","","",N,N],[17,"OCRNL","","",N,N],[17,"ONOCR","","",N,N],[17,"ONLRET","","",N,N],[17,"OFILL","","",N,N],[17,"OFDEL","","",N,N],[17,"CLONE_VM","","",N,N],[17,"CLONE_FS","","",N,N],[17,"CLONE_FILES","","",N,N],[17,"CLONE_SIGHAND","","",N,N],[17,"CLONE_PTRACE","","",N,N],[17,"CLONE_VFORK","","",N,N],[17,"CLONE_PARENT","","",N,N],[17,"CLONE_THREAD","","",N,N],[17,"CLONE_NEWNS","","",N,N],[17,"CLONE_SYSVSEM","","",N,N],[17,"CLONE_SETTLS","","",N,N],[17,"CLONE_PARENT_SETTID","","",N,N],[17,"CLONE_CHILD_CLEARTID","","",N,N],[17,"CLONE_DETACHED","","",N,N],[17,"CLONE_UNTRACED","","",N,N],[17,"CLONE_CHILD_SETTID","","",N,N],[17,"CLONE_NEWUTS","","",N,N],[17,"CLONE_NEWIPC","","",N,N],[17,"CLONE_NEWUSER","","",N,N],[17,"CLONE_NEWPID","","",N,N],[17,"CLONE_NEWNET","","",N,N],[17,"CLONE_IO","","",N,N],[17,"CLONE_NEWCGROUP","","",N,N],[17,"WNOHANG","","",N,N],[17,"WUNTRACED","","",N,N],[17,"WSTOPPED","","",N,N],[17,"WEXITED","","",N,N],[17,"WCONTINUED","","",N,N],[17,"WNOWAIT","","",N,N],[17,"PTRACE_O_TRACESYSGOOD","","",N,N],[17,"PTRACE_O_TRACEFORK","","",N,N],[17,"PTRACE_O_TRACEVFORK","","",N,N],[17,"PTRACE_O_TRACECLONE","","",N,N],[17,"PTRACE_O_TRACEEXEC","","",N,N],[17,"PTRACE_O_TRACEVFORKDONE","","",N,N],[17,"PTRACE_O_TRACEEXIT","","",N,N],[17,"PTRACE_O_TRACESECCOMP","","",N,N],[17,"PTRACE_O_EXITKILL","","",N,N],[17,"PTRACE_O_SUSPEND_SECCOMP","","",N,N],[17,"PTRACE_O_MASK","","",N,N],[17,"PTRACE_EVENT_FORK","","",N,N],[17,"PTRACE_EVENT_VFORK","","",N,N],[17,"PTRACE_EVENT_CLONE","","",N,N],[17,"PTRACE_EVENT_EXEC","","",N,N],[17,"PTRACE_EVENT_VFORK_DONE","","",N,N],[17,"PTRACE_EVENT_EXIT","","",N,N],[17,"PTRACE_EVENT_SECCOMP","","",N,N],[17,"__WNOTHREAD","","",N,N],[17,"__WALL","","",N,N],[17,"__WCLONE","","",N,N],[17,"SPLICE_F_MOVE","","",N,N],[17,"SPLICE_F_NONBLOCK","","",N,N],[17,"SPLICE_F_MORE","","",N,N],[17,"SPLICE_F_GIFT","","",N,N],[17,"RTLD_LOCAL","","",N,N],[17,"RTLD_LAZY","","",N,N],[17,"POSIX_FADV_NORMAL","","",N,N],[17,"POSIX_FADV_RANDOM","","",N,N],[17,"POSIX_FADV_SEQUENTIAL","","",N,N],[17,"POSIX_FADV_WILLNEED","","",N,N],[17,"AT_FDCWD","","",N,N],[17,"AT_SYMLINK_NOFOLLOW","","",N,N],[17,"AT_REMOVEDIR","","",N,N],[17,"AT_SYMLINK_FOLLOW","","",N,N],[17,"AT_NO_AUTOMOUNT","","",N,N],[17,"AT_EMPTY_PATH","","",N,N],[17,"LOG_CRON","","",N,N],[17,"LOG_AUTHPRIV","","",N,N],[17,"LOG_FTP","","",N,N],[17,"LOG_PERROR","","",N,N],[17,"PIPE_BUF","","",N,N],[17,"SI_LOAD_SHIFT","","",N,N],[17,"SIGEV_SIGNAL","","",N,N],[17,"SIGEV_NONE","","",N,N],[17,"SIGEV_THREAD","","",N,N],[17,"P_ALL","","",N,N],[17,"P_PID","","",N,N],[17,"P_PGID","","",N,N],[17,"UTIME_OMIT","","",N,N],[17,"UTIME_NOW","","",N,N],[17,"POLLIN","","",N,N],[17,"POLLPRI","","",N,N],[17,"POLLOUT","","",N,N],[17,"POLLERR","","",N,N],[17,"POLLHUP","","",N,N],[17,"POLLNVAL","","",N,N],[17,"POLLRDNORM","","",N,N],[17,"POLLRDBAND","","",N,N],[17,"IPTOS_LOWDELAY","","",N,N],[17,"IPTOS_THROUGHPUT","","",N,N],[17,"IPTOS_RELIABILITY","","",N,N],[17,"IPTOS_MINCOST","","",N,N],[17,"IPTOS_PREC_NETCONTROL","","",N,N],[17,"IPTOS_PREC_INTERNETCONTROL","","",N,N],[17,"IPTOS_PREC_CRITIC_ECP","","",N,N],[17,"IPTOS_PREC_FLASHOVERRIDE","","",N,N],[17,"IPTOS_PREC_FLASH","","",N,N],[17,"IPTOS_PREC_IMMEDIATE","","",N,N],[17,"IPTOS_PREC_PRIORITY","","",N,N],[17,"IPTOS_PREC_ROUTINE","","",N,N],[17,"IPOPT_COPY","","",N,N],[17,"IPOPT_CLASS_MASK","","",N,N],[17,"IPOPT_NUMBER_MASK","","",N,N],[17,"IPOPT_CONTROL","","",N,N],[17,"IPOPT_RESERVED1","","",N,N],[17,"IPOPT_MEASUREMENT","","",N,N],[17,"IPOPT_RESERVED2","","",N,N],[17,"IPOPT_END","","",N,N],[17,"IPOPT_NOOP","","",N,N],[17,"IPOPT_SEC","","",N,N],[17,"IPOPT_LSRR","","",N,N],[17,"IPOPT_TIMESTAMP","","",N,N],[17,"IPOPT_RR","","",N,N],[17,"IPOPT_SID","","",N,N],[17,"IPOPT_SSRR","","",N,N],[17,"IPOPT_RA","","",N,N],[17,"IPVERSION","","",N,N],[17,"MAXTTL","","",N,N],[17,"IPDEFTTL","","",N,N],[17,"IPOPT_OPTVAL","","",N,N],[17,"IPOPT_OLEN","","",N,N],[17,"IPOPT_OFFSET","","",N,N],[17,"IPOPT_MINOFF","","",N,N],[17,"MAX_IPOPTLEN","","",N,N],[17,"IPOPT_NOP","","",N,N],[17,"IPOPT_EOL","","",N,N],[17,"IPOPT_TS","","",N,N],[17,"IPOPT_TS_TSONLY","","",N,N],[17,"IPOPT_TS_TSANDADDR","","",N,N],[17,"IPOPT_TS_PRESPEC","","",N,N],[17,"ARPOP_RREQUEST","","",N,N],[17,"ARPOP_RREPLY","","",N,N],[17,"ARPOP_InREQUEST","","",N,N],[17,"ARPOP_InREPLY","","",N,N],[17,"ARPOP_NAK","","",N,N],[17,"ATF_NETMASK","","",N,N],[17,"ATF_DONTPUB","","",N,N],[17,"ARPHRD_NETROM","","",N,N],[17,"ARPHRD_ETHER","","",N,N],[17,"ARPHRD_EETHER","","",N,N],[17,"ARPHRD_AX25","","",N,N],[17,"ARPHRD_PRONET","","",N,N],[17,"ARPHRD_CHAOS","","",N,N],[17,"ARPHRD_IEEE802","","",N,N],[17,"ARPHRD_ARCNET","","",N,N],[17,"ARPHRD_APPLETLK","","",N,N],[17,"ARPHRD_DLCI","","",N,N],[17,"ARPHRD_ATM","","",N,N],[17,"ARPHRD_METRICOM","","",N,N],[17,"ARPHRD_IEEE1394","","",N,N],[17,"ARPHRD_EUI64","","",N,N],[17,"ARPHRD_INFINIBAND","","",N,N],[17,"ARPHRD_SLIP","","",N,N],[17,"ARPHRD_CSLIP","","",N,N],[17,"ARPHRD_SLIP6","","",N,N],[17,"ARPHRD_CSLIP6","","",N,N],[17,"ARPHRD_RSRVD","","",N,N],[17,"ARPHRD_ADAPT","","",N,N],[17,"ARPHRD_ROSE","","",N,N],[17,"ARPHRD_X25","","",N,N],[17,"ARPHRD_HWX25","","",N,N],[17,"ARPHRD_PPP","","",N,N],[17,"ARPHRD_CISCO","","",N,N],[17,"ARPHRD_HDLC","","",N,N],[17,"ARPHRD_LAPB","","",N,N],[17,"ARPHRD_DDCMP","","",N,N],[17,"ARPHRD_RAWHDLC","","",N,N],[17,"ARPHRD_TUNNEL","","",N,N],[17,"ARPHRD_TUNNEL6","","",N,N],[17,"ARPHRD_FRAD","","",N,N],[17,"ARPHRD_SKIP","","",N,N],[17,"ARPHRD_LOOPBACK","","",N,N],[17,"ARPHRD_LOCALTLK","","",N,N],[17,"ARPHRD_FDDI","","",N,N],[17,"ARPHRD_BIF","","",N,N],[17,"ARPHRD_SIT","","",N,N],[17,"ARPHRD_IPDDP","","",N,N],[17,"ARPHRD_IPGRE","","",N,N],[17,"ARPHRD_PIMREG","","",N,N],[17,"ARPHRD_HIPPI","","",N,N],[17,"ARPHRD_ASH","","",N,N],[17,"ARPHRD_ECONET","","",N,N],[17,"ARPHRD_IRDA","","",N,N],[17,"ARPHRD_FCPP","","",N,N],[17,"ARPHRD_FCAL","","",N,N],[17,"ARPHRD_FCPL","","",N,N],[17,"ARPHRD_FCFABRIC","","",N,N],[17,"ARPHRD_IEEE802_TR","","",N,N],[17,"ARPHRD_IEEE80211","","",N,N],[17,"ARPHRD_IEEE80211_PRISM","","",N,N],[17,"ARPHRD_IEEE80211_RADIOTAP","","",N,N],[17,"ARPHRD_IEEE802154","","",N,N],[17,"ARPHRD_VOID","","",N,N],[17,"ARPHRD_NONE","","",N,N],[11,"clone","libc","",20,[[["self"]],["sockaddr"]]],[11,"clone","","",21,[[["self"]],["sockaddr_in"]]],[11,"clone","","",22,[[["self"]],["sockaddr_in6"]]],[11,"clone","","",23,[[["self"]],["sockaddr_un"]]],[11,"clone","","",24,[[["self"]],["sockaddr_storage"]]],[11,"clone","","",25,[[["self"]],["addrinfo"]]],[11,"clone","","",26,[[["self"]],["sockaddr_nl"]]],[11,"clone","","",27,[[["self"]],["sockaddr_ll"]]],[11,"clone","","",28,[[["self"]],["fd_set"]]],[11,"clone","","",29,[[["self"]],["tm"]]],[11,"clone","","",30,[[["self"]],["sched_param"]]],[11,"clone","","",31,[[["self"]],["dl_info"]]],[11,"clone","","",32,[[["self"]],["epoll_event"]]],[11,"clone","","",33,[[["self"]],["utsname"]]],[11,"clone","","",34,[[["self"]],["lconv"]]],[11,"clone","","",35,[[["self"]],["sigevent"]]],[11,"clone","","",36,[[["self"]],["in_pktinfo"]]],[11,"clone","","",37,[[["self"]],["ifaddrs"]]],[11,"clone","","",38,[[["self"]],["in6_rtmsg"]]],[11,"clone","","",39,[[["self"]],["arpreq"]]],[11,"clone","","",40,[[["self"]],["arpreq_old"]]],[11,"clone","","",41,[[["self"]],["arphdr"]]],[6,"pid_t","libc::unix","",N,N],[6,"uid_t","","",N,N],[6,"gid_t","","",N,N],[6,"in_addr_t","","",N,N],[6,"in_port_t","","",N,N],[6,"sighandler_t","","",N,N],[6,"cc_t","","",N,N],[17,"SIG_DFL","","",N,N],[17,"SIG_IGN","","",N,N],[17,"SIG_ERR","","",N,N],[17,"DT_UNKNOWN","","",N,N],[17,"DT_FIFO","","",N,N],[17,"DT_CHR","","",N,N],[17,"DT_DIR","","",N,N],[17,"DT_BLK","","",N,N],[17,"DT_REG","","",N,N],[17,"DT_LNK","","",N,N],[17,"DT_SOCK","","",N,N],[17,"FD_CLOEXEC","","",N,N],[17,"USRQUOTA","","",N,N],[17,"GRPQUOTA","","",N,N],[17,"SIGIOT","","",N,N],[17,"S_ISUID","","",N,N],[17,"S_ISGID","","",N,N],[17,"S_ISVTX","","",N,N],[17,"IF_NAMESIZE","","",N,N],[17,"IFNAMSIZ","","",N,N],[17,"LOG_EMERG","","",N,N],[17,"LOG_ALERT","","",N,N],[17,"LOG_CRIT","","",N,N],[17,"LOG_ERR","","",N,N],[17,"LOG_WARNING","","",N,N],[17,"LOG_NOTICE","","",N,N],[17,"LOG_INFO","","",N,N],[17,"LOG_DEBUG","","",N,N],[17,"LOG_KERN","","",N,N],[17,"LOG_USER","","",N,N],[17,"LOG_MAIL","","",N,N],[17,"LOG_DAEMON","","",N,N],[17,"LOG_AUTH","","",N,N],[17,"LOG_SYSLOG","","",N,N],[17,"LOG_LPR","","",N,N],[17,"LOG_NEWS","","",N,N],[17,"LOG_UUCP","","",N,N],[17,"LOG_LOCAL0","","",N,N],[17,"LOG_LOCAL1","","",N,N],[17,"LOG_LOCAL2","","",N,N],[17,"LOG_LOCAL3","","",N,N],[17,"LOG_LOCAL4","","",N,N],[17,"LOG_LOCAL5","","",N,N],[17,"LOG_LOCAL6","","",N,N],[17,"LOG_LOCAL7","","",N,N],[17,"LOG_PID","","",N,N],[17,"LOG_CONS","","",N,N],[17,"LOG_ODELAY","","",N,N],[17,"LOG_NDELAY","","",N,N],[17,"LOG_NOWAIT","","",N,N],[17,"LOG_PRIMASK","","",N,N],[17,"LOG_FACMASK","","",N,N],[17,"PRIO_PROCESS","","",N,N],[17,"PRIO_PGRP","","",N,N],[17,"PRIO_USER","","",N,N],[17,"PRIO_MIN","","",N,N],[17,"PRIO_MAX","","",N,N],[17,"IPPROTO_ICMP","","",N,N],[17,"IPPROTO_ICMPV6","","",N,N],[17,"IPPROTO_TCP","","",N,N],[17,"IPPROTO_UDP","","",N,N],[17,"IPPROTO_IP","","",N,N],[17,"IPPROTO_IPV6","","",N,N],[17,"INADDR_LOOPBACK","","",N,N],[17,"INADDR_ANY","","",N,N],[17,"INADDR_BROADCAST","","",N,N],[17,"INADDR_NONE","","",N,N],[17,"ARPOP_REQUEST","","",N,N],[17,"ARPOP_REPLY","","",N,N],[17,"ATF_COM","","",N,N],[17,"ATF_PERM","","",N,N],[17,"ATF_PUBL","","",N,N],[17,"ATF_USETRAILERS","","",N,N],[11,"clone","libc","",0,[[["self"]],["group"]]],[11,"clone","","",1,[[["self"]],["utimbuf"]]],[11,"clone","","",2,[[["self"]],["timeval"]]],[11,"clone","","",3,[[["self"]],["timespec"]]],[11,"clone","","",4,[[["self"]],["rlimit"]]],[11,"clone","","",5,[[["self"]],["rusage"]]],[11,"clone","","",6,[[["self"]],["in_addr"]]],[11,"clone","","",7,[[["self"]],["in6_addr"]]],[11,"clone","","",8,[[["self"]],["ip_mreq"]]],[11,"clone","","",9,[[["self"]],["ipv6_mreq"]]],[11,"clone","","",10,[[["self"]],["hostent"]]],[11,"clone","","",11,[[["self"]],["iovec"]]],[11,"clone","","",12,[[["self"]],["pollfd"]]],[11,"clone","","",13,[[["self"]],["winsize"]]],[11,"clone","","",14,[[["self"]],["linger"]]],[11,"clone","","",15,[[["self"]],["sigval"]]],[11,"clone","","",16,[[["self"]],["itimerval"]]],[11,"clone","","",17,[[["self"]],["tms"]]],[11,"clone","","",18,[[["self"]],["servent"]]],[11,"clone","","",19,[[["self"]],["protoent"]]],[6,"int8_t","","",N,N],[6,"int16_t","","",N,N],[6,"int32_t","","",N,N],[6,"int64_t","","",N,N],[6,"uint8_t","","",N,N],[6,"uint16_t","","",N,N],[6,"uint32_t","","",N,N],[6,"uint64_t","","",N,N],[6,"c_schar","","",N,N],[6,"c_uchar","","",N,N],[6,"c_short","","",N,N],[6,"c_ushort","","",N,N],[6,"c_int","","",N,N],[6,"c_uint","","",N,N],[6,"c_float","","",N,N],[6,"c_double","","",N,N],[6,"c_longlong","","",N,N],[6,"c_ulonglong","","",N,N],[6,"intmax_t","","",N,N],[6,"uintmax_t","","",N,N],[6,"size_t","","",N,N],[6,"ptrdiff_t","","",N,N],[6,"intptr_t","","",N,N],[6,"uintptr_t","","",N,N],[6,"ssize_t","","",N,N],[6,"pid_t","","",N,N],[6,"uid_t","","",N,N],[6,"gid_t","","",N,N],[6,"in_addr_t","","",N,N],[6,"in_port_t","","",N,N],[6,"sighandler_t","","",N,N],[6,"cc_t","","",N,N],[6,"sa_family_t","","",N,N],[6,"pthread_key_t","","",N,N],[6,"speed_t","","",N,N],[6,"tcflag_t","","",N,N],[6,"clockid_t","","",N,N],[6,"key_t","","",N,N],[6,"id_t","","",N,N],[6,"useconds_t","","",N,N],[6,"dev_t","","",N,N],[6,"socklen_t","","",N,N],[6,"pthread_t","","",N,N],[6,"mode_t","","",N,N],[6,"ino64_t","","",N,N],[6,"off64_t","","",N,N],[6,"blkcnt64_t","","",N,N],[6,"rlim64_t","","",N,N],[6,"mqd_t","","",N,N],[6,"nfds_t","","",N,N],[6,"nl_item","","",N,N],[6,"idtype_t","","",N,N],[6,"loff_t","","",N,N],[6,"__u8","","",N,N],[6,"__u16","","",N,N],[6,"__s16","","",N,N],[6,"__u32","","",N,N],[6,"__s32","","",N,N],[6,"Elf32_Half","","",N,N],[6,"Elf32_Word","","",N,N],[6,"Elf32_Off","","",N,N],[6,"Elf32_Addr","","",N,N],[6,"Elf64_Half","","",N,N],[6,"Elf64_Word","","",N,N],[6,"Elf64_Off","","",N,N],[6,"Elf64_Addr","","",N,N],[6,"Elf64_Xword","","",N,N],[6,"__priority_which_t","","",N,N],[6,"clock_t","","",N,N],[6,"time_t","","",N,N],[6,"ino_t","","",N,N],[6,"off_t","","",N,N],[6,"blkcnt_t","","",N,N],[6,"__fsword_t","","",N,N],[6,"shmatt_t","","",N,N],[6,"msgqnum_t","","",N,N],[6,"msglen_t","","",N,N],[6,"fsblkcnt_t","","",N,N],[6,"fsfilcnt_t","","",N,N],[6,"rlim_t","","",N,N],[6,"c_char","","",N,N],[6,"wchar_t","","",N,N],[6,"nlink_t","","",N,N],[6,"blksize_t","","",N,N],[6,"greg_t","","",N,N],[6,"suseconds_t","","",N,N],[6,"__u64","","",N,N],[6,"c_long","","",N,N],[6,"c_ulong","","",N,N],[17,"INT_MIN","","",N,N],[17,"INT_MAX","","",N,N],[17,"SIG_DFL","","",N,N],[17,"SIG_IGN","","",N,N],[17,"SIG_ERR","","",N,N],[17,"DT_UNKNOWN","","",N,N],[17,"DT_FIFO","","",N,N],[17,"DT_CHR","","",N,N],[17,"DT_DIR","","",N,N],[17,"DT_BLK","","",N,N],[17,"DT_REG","","",N,N],[17,"DT_LNK","","",N,N],[17,"DT_SOCK","","",N,N],[17,"FD_CLOEXEC","","",N,N],[17,"USRQUOTA","","",N,N],[17,"GRPQUOTA","","",N,N],[17,"SIGIOT","","",N,N],[17,"S_ISUID","","",N,N],[17,"S_ISGID","","",N,N],[17,"S_ISVTX","","",N,N],[17,"IF_NAMESIZE","","",N,N],[17,"IFNAMSIZ","","",N,N],[17,"LOG_EMERG","","",N,N],[17,"LOG_ALERT","","",N,N],[17,"LOG_CRIT","","",N,N],[17,"LOG_ERR","","",N,N],[17,"LOG_WARNING","","",N,N],[17,"LOG_NOTICE","","",N,N],[17,"LOG_INFO","","",N,N],[17,"LOG_DEBUG","","",N,N],[17,"LOG_KERN","","",N,N],[17,"LOG_USER","","",N,N],[17,"LOG_MAIL","","",N,N],[17,"LOG_DAEMON","","",N,N],[17,"LOG_AUTH","","",N,N],[17,"LOG_SYSLOG","","",N,N],[17,"LOG_LPR","","",N,N],[17,"LOG_NEWS","","",N,N],[17,"LOG_UUCP","","",N,N],[17,"LOG_LOCAL0","","",N,N],[17,"LOG_LOCAL1","","",N,N],[17,"LOG_LOCAL2","","",N,N],[17,"LOG_LOCAL3","","",N,N],[17,"LOG_LOCAL4","","",N,N],[17,"LOG_LOCAL5","","",N,N],[17,"LOG_LOCAL6","","",N,N],[17,"LOG_LOCAL7","","",N,N],[17,"LOG_PID","","",N,N],[17,"LOG_CONS","","",N,N],[17,"LOG_ODELAY","","",N,N],[17,"LOG_NDELAY","","",N,N],[17,"LOG_NOWAIT","","",N,N],[17,"LOG_PRIMASK","","",N,N],[17,"LOG_FACMASK","","",N,N],[17,"PRIO_PROCESS","","",N,N],[17,"PRIO_PGRP","","",N,N],[17,"PRIO_USER","","",N,N],[17,"PRIO_MIN","","",N,N],[17,"PRIO_MAX","","",N,N],[17,"IPPROTO_ICMP","","",N,N],[17,"IPPROTO_ICMPV6","","",N,N],[17,"IPPROTO_TCP","","",N,N],[17,"IPPROTO_UDP","","",N,N],[17,"IPPROTO_IP","","",N,N],[17,"IPPROTO_IPV6","","",N,N],[17,"INADDR_LOOPBACK","","",N,N],[17,"INADDR_ANY","","",N,N],[17,"INADDR_BROADCAST","","",N,N],[17,"INADDR_NONE","","",N,N],[17,"ARPOP_REQUEST","","",N,N],[17,"ARPOP_REPLY","","",N,N],[17,"ATF_COM","","",N,N],[17,"ATF_PERM","","",N,N],[17,"ATF_PUBL","","",N,N],[17,"ATF_USETRAILERS","","",N,N],[17,"EXIT_FAILURE","","",N,N],[17,"EXIT_SUCCESS","","",N,N],[17,"RAND_MAX","","",N,N],[17,"EOF","","",N,N],[17,"SEEK_SET","","",N,N],[17,"SEEK_CUR","","",N,N],[17,"SEEK_END","","",N,N],[17,"_IOFBF","","",N,N],[17,"_IONBF","","",N,N],[17,"_IOLBF","","",N,N],[17,"F_DUPFD","","",N,N],[17,"F_GETFD","","",N,N],[17,"F_SETFD","","",N,N],[17,"F_GETFL","","",N,N],[17,"F_SETFL","","",N,N],[17,"F_SETLEASE","","",N,N],[17,"F_GETLEASE","","",N,N],[17,"F_NOTIFY","","",N,N],[17,"F_CANCELLK","","",N,N],[17,"F_DUPFD_CLOEXEC","","",N,N],[17,"F_SETPIPE_SZ","","",N,N],[17,"F_GETPIPE_SZ","","",N,N],[17,"F_ADD_SEALS","","",N,N],[17,"F_GET_SEALS","","",N,N],[17,"F_SEAL_SEAL","","",N,N],[17,"F_SEAL_SHRINK","","",N,N],[17,"F_SEAL_GROW","","",N,N],[17,"F_SEAL_WRITE","","",N,N],[17,"SIGTRAP","","",N,N],[17,"PTHREAD_CREATE_JOINABLE","","",N,N],[17,"PTHREAD_CREATE_DETACHED","","",N,N],[17,"CLOCK_REALTIME","","",N,N],[17,"CLOCK_MONOTONIC","","",N,N],[17,"CLOCK_PROCESS_CPUTIME_ID","","",N,N],[17,"CLOCK_THREAD_CPUTIME_ID","","",N,N],[17,"CLOCK_MONOTONIC_RAW","","",N,N],[17,"CLOCK_REALTIME_COARSE","","",N,N],[17,"CLOCK_MONOTONIC_COARSE","","",N,N],[17,"CLOCK_BOOTTIME","","",N,N],[17,"CLOCK_REALTIME_ALARM","","",N,N],[17,"CLOCK_BOOTTIME_ALARM","","",N,N],[17,"TIMER_ABSTIME","","",N,N],[17,"RLIMIT_CPU","","",N,N],[17,"RLIMIT_FSIZE","","",N,N],[17,"RLIMIT_DATA","","",N,N],[17,"RLIMIT_STACK","","",N,N],[17,"RLIMIT_CORE","","",N,N],[17,"RLIMIT_LOCKS","","",N,N],[17,"RLIMIT_SIGPENDING","","",N,N],[17,"RLIMIT_MSGQUEUE","","",N,N],[17,"RLIMIT_NICE","","",N,N],[17,"RLIMIT_RTPRIO","","",N,N],[17,"RUSAGE_SELF","","",N,N],[17,"O_RDONLY","","",N,N],[17,"O_WRONLY","","",N,N],[17,"O_RDWR","","",N,N],[17,"SOCK_CLOEXEC","","",N,N],[17,"S_IFIFO","","",N,N],[17,"S_IFCHR","","",N,N],[17,"S_IFBLK","","",N,N],[17,"S_IFDIR","","",N,N],[17,"S_IFREG","","",N,N],[17,"S_IFLNK","","",N,N],[17,"S_IFSOCK","","",N,N],[17,"S_IFMT","","",N,N],[17,"S_IRWXU","","",N,N],[17,"S_IXUSR","","",N,N],[17,"S_IWUSR","","",N,N],[17,"S_IRUSR","","",N,N],[17,"S_IRWXG","","",N,N],[17,"S_IXGRP","","",N,N],[17,"S_IWGRP","","",N,N],[17,"S_IRGRP","","",N,N],[17,"S_IRWXO","","",N,N],[17,"S_IXOTH","","",N,N],[17,"S_IWOTH","","",N,N],[17,"S_IROTH","","",N,N],[17,"F_OK","","",N,N],[17,"R_OK","","",N,N],[17,"W_OK","","",N,N],[17,"X_OK","","",N,N],[17,"STDIN_FILENO","","",N,N],[17,"STDOUT_FILENO","","",N,N],[17,"STDERR_FILENO","","",N,N],[17,"SIGHUP","","",N,N],[17,"SIGINT","","",N,N],[17,"SIGQUIT","","",N,N],[17,"SIGILL","","",N,N],[17,"SIGABRT","","",N,N],[17,"SIGFPE","","",N,N],[17,"SIGKILL","","",N,N],[17,"SIGSEGV","","",N,N],[17,"SIGPIPE","","",N,N],[17,"SIGALRM","","",N,N],[17,"SIGTERM","","",N,N],[17,"PROT_NONE","","",N,N],[17,"PROT_READ","","",N,N],[17,"PROT_WRITE","","",N,N],[17,"PROT_EXEC","","",N,N],[17,"LC_CTYPE","","",N,N],[17,"LC_NUMERIC","","",N,N],[17,"LC_TIME","","",N,N],[17,"LC_COLLATE","","",N,N],[17,"LC_MONETARY","","",N,N],[17,"LC_MESSAGES","","",N,N],[17,"LC_ALL","","",N,N],[17,"LC_CTYPE_MASK","","",N,N],[17,"LC_NUMERIC_MASK","","",N,N],[17,"LC_TIME_MASK","","",N,N],[17,"LC_COLLATE_MASK","","",N,N],[17,"LC_MONETARY_MASK","","",N,N],[17,"LC_MESSAGES_MASK","","",N,N],[17,"MAP_FILE","","",N,N],[17,"MAP_SHARED","","",N,N],[17,"MAP_PRIVATE","","",N,N],[17,"MAP_FIXED","","",N,N],[17,"MAP_FAILED","","",N,N],[17,"MS_ASYNC","","",N,N],[17,"MS_INVALIDATE","","",N,N],[17,"MS_SYNC","","",N,N],[17,"MS_RDONLY","","",N,N],[17,"MS_NOSUID","","",N,N],[17,"MS_NODEV","","",N,N],[17,"MS_NOEXEC","","",N,N],[17,"MS_SYNCHRONOUS","","",N,N],[17,"MS_REMOUNT","","",N,N],[17,"MS_MANDLOCK","","",N,N],[17,"MS_DIRSYNC","","",N,N],[17,"MS_NOATIME","","",N,N],[17,"MS_NODIRATIME","","",N,N],[17,"MS_BIND","","",N,N],[17,"MS_MOVE","","",N,N],[17,"MS_REC","","",N,N],[17,"MS_SILENT","","",N,N],[17,"MS_POSIXACL","","",N,N],[17,"MS_UNBINDABLE","","",N,N],[17,"MS_PRIVATE","","",N,N],[17,"MS_SLAVE","","",N,N],[17,"MS_SHARED","","",N,N],[17,"MS_RELATIME","","",N,N],[17,"MS_KERNMOUNT","","",N,N],[17,"MS_I_VERSION","","",N,N],[17,"MS_STRICTATIME","","",N,N],[17,"MS_ACTIVE","","",N,N],[17,"MS_NOUSER","","",N,N],[17,"MS_MGC_VAL","","",N,N],[17,"MS_MGC_MSK","","",N,N],[17,"MS_RMT_MASK","","",N,N],[17,"EPERM","","",N,N],[17,"ENOENT","","",N,N],[17,"ESRCH","","",N,N],[17,"EINTR","","",N,N],[17,"EIO","","",N,N],[17,"ENXIO","","",N,N],[17,"E2BIG","","",N,N],[17,"ENOEXEC","","",N,N],[17,"EBADF","","",N,N],[17,"ECHILD","","",N,N],[17,"EAGAIN","","",N,N],[17,"ENOMEM","","",N,N],[17,"EACCES","","",N,N],[17,"EFAULT","","",N,N],[17,"ENOTBLK","","",N,N],[17,"EBUSY","","",N,N],[17,"EEXIST","","",N,N],[17,"EXDEV","","",N,N],[17,"ENODEV","","",N,N],[17,"ENOTDIR","","",N,N],[17,"EISDIR","","",N,N],[17,"EINVAL","","",N,N],[17,"ENFILE","","",N,N],[17,"EMFILE","","",N,N],[17,"ENOTTY","","",N,N],[17,"ETXTBSY","","",N,N],[17,"EFBIG","","",N,N],[17,"ENOSPC","","",N,N],[17,"ESPIPE","","",N,N],[17,"EROFS","","",N,N],[17,"EMLINK","","",N,N],[17,"EPIPE","","",N,N],[17,"EDOM","","",N,N],[17,"ERANGE","","",N,N],[17,"EWOULDBLOCK","","",N,N],[17,"SCM_RIGHTS","","",N,N],[17,"SCM_CREDENTIALS","","",N,N],[17,"PROT_GROWSDOWN","","",N,N],[17,"PROT_GROWSUP","","",N,N],[17,"MAP_TYPE","","",N,N],[17,"MADV_NORMAL","","",N,N],[17,"MADV_RANDOM","","",N,N],[17,"MADV_SEQUENTIAL","","",N,N],[17,"MADV_WILLNEED","","",N,N],[17,"MADV_DONTNEED","","",N,N],[17,"MADV_FREE","","",N,N],[17,"MADV_REMOVE","","",N,N],[17,"MADV_DONTFORK","","",N,N],[17,"MADV_DOFORK","","",N,N],[17,"MADV_MERGEABLE","","",N,N],[17,"MADV_UNMERGEABLE","","",N,N],[17,"MADV_HUGEPAGE","","",N,N],[17,"MADV_NOHUGEPAGE","","",N,N],[17,"MADV_DONTDUMP","","",N,N],[17,"MADV_DODUMP","","",N,N],[17,"MADV_HWPOISON","","",N,N],[17,"MADV_SOFT_OFFLINE","","",N,N],[17,"IFF_UP","","",N,N],[17,"IFF_BROADCAST","","",N,N],[17,"IFF_DEBUG","","",N,N],[17,"IFF_LOOPBACK","","",N,N],[17,"IFF_POINTOPOINT","","",N,N],[17,"IFF_NOTRAILERS","","",N,N],[17,"IFF_RUNNING","","",N,N],[17,"IFF_NOARP","","",N,N],[17,"IFF_PROMISC","","",N,N],[17,"IFF_ALLMULTI","","",N,N],[17,"IFF_MASTER","","",N,N],[17,"IFF_SLAVE","","",N,N],[17,"IFF_MULTICAST","","",N,N],[17,"IFF_PORTSEL","","",N,N],[17,"IFF_AUTOMEDIA","","",N,N],[17,"IFF_DYNAMIC","","",N,N],[17,"SOL_IP","","",N,N],[17,"SOL_TCP","","",N,N],[17,"SOL_UDP","","",N,N],[17,"SOL_IPV6","","",N,N],[17,"SOL_ICMPV6","","",N,N],[17,"SOL_RAW","","",N,N],[17,"SOL_DECNET","","",N,N],[17,"SOL_X25","","",N,N],[17,"SOL_PACKET","","",N,N],[17,"SOL_ATM","","",N,N],[17,"SOL_AAL","","",N,N],[17,"SOL_IRDA","","",N,N],[17,"SOL_NETBEUI","","",N,N],[17,"SOL_LLC","","",N,N],[17,"SOL_DCCP","","",N,N],[17,"SOL_NETLINK","","",N,N],[17,"SOL_TIPC","","",N,N],[17,"AF_UNSPEC","","",N,N],[17,"AF_UNIX","","",N,N],[17,"AF_LOCAL","","",N,N],[17,"AF_INET","","",N,N],[17,"AF_AX25","","",N,N],[17,"AF_IPX","","",N,N],[17,"AF_APPLETALK","","",N,N],[17,"AF_NETROM","","",N,N],[17,"AF_BRIDGE","","",N,N],[17,"AF_ATMPVC","","",N,N],[17,"AF_X25","","",N,N],[17,"AF_INET6","","",N,N],[17,"AF_ROSE","","",N,N],[17,"AF_DECnet","","",N,N],[17,"AF_NETBEUI","","",N,N],[17,"AF_SECURITY","","",N,N],[17,"AF_KEY","","",N,N],[17,"AF_NETLINK","","",N,N],[17,"AF_ROUTE","","",N,N],[17,"AF_PACKET","","",N,N],[17,"AF_ASH","","",N,N],[17,"AF_ECONET","","",N,N],[17,"AF_ATMSVC","","",N,N],[17,"AF_RDS","","",N,N],[17,"AF_SNA","","",N,N],[17,"AF_IRDA","","",N,N],[17,"AF_PPPOX","","",N,N],[17,"AF_WANPIPE","","",N,N],[17,"AF_LLC","","",N,N],[17,"AF_CAN","","",N,N],[17,"AF_TIPC","","",N,N],[17,"AF_BLUETOOTH","","",N,N],[17,"AF_IUCV","","",N,N],[17,"AF_RXRPC","","",N,N],[17,"AF_ISDN","","",N,N],[17,"AF_PHONET","","",N,N],[17,"AF_IEEE802154","","",N,N],[17,"AF_CAIF","","",N,N],[17,"AF_ALG","","",N,N],[17,"PF_UNSPEC","","",N,N],[17,"PF_UNIX","","",N,N],[17,"PF_LOCAL","","",N,N],[17,"PF_INET","","",N,N],[17,"PF_AX25","","",N,N],[17,"PF_IPX","","",N,N],[17,"PF_APPLETALK","","",N,N],[17,"PF_NETROM","","",N,N],[17,"PF_BRIDGE","","",N,N],[17,"PF_ATMPVC","","",N,N],[17,"PF_X25","","",N,N],[17,"PF_INET6","","",N,N],[17,"PF_ROSE","","",N,N],[17,"PF_DECnet","","",N,N],[17,"PF_NETBEUI","","",N,N],[17,"PF_SECURITY","","",N,N],[17,"PF_KEY","","",N,N],[17,"PF_NETLINK","","",N,N],[17,"PF_ROUTE","","",N,N],[17,"PF_PACKET","","",N,N],[17,"PF_ASH","","",N,N],[17,"PF_ECONET","","",N,N],[17,"PF_ATMSVC","","",N,N],[17,"PF_RDS","","",N,N],[17,"PF_SNA","","",N,N],[17,"PF_IRDA","","",N,N],[17,"PF_PPPOX","","",N,N],[17,"PF_WANPIPE","","",N,N],[17,"PF_LLC","","",N,N],[17,"PF_CAN","","",N,N],[17,"PF_TIPC","","",N,N],[17,"PF_BLUETOOTH","","",N,N],[17,"PF_IUCV","","",N,N],[17,"PF_RXRPC","","",N,N],[17,"PF_ISDN","","",N,N],[17,"PF_PHONET","","",N,N],[17,"PF_IEEE802154","","",N,N],[17,"PF_CAIF","","",N,N],[17,"PF_ALG","","",N,N],[17,"SOMAXCONN","","",N,N],[17,"MSG_OOB","","",N,N],[17,"MSG_PEEK","","",N,N],[17,"MSG_DONTROUTE","","",N,N],[17,"MSG_CTRUNC","","",N,N],[17,"MSG_TRUNC","","",N,N],[17,"MSG_DONTWAIT","","",N,N],[17,"MSG_EOR","","",N,N],[17,"MSG_WAITALL","","",N,N],[17,"MSG_FIN","","",N,N],[17,"MSG_SYN","","",N,N],[17,"MSG_CONFIRM","","",N,N],[17,"MSG_RST","","",N,N],[17,"MSG_ERRQUEUE","","",N,N],[17,"MSG_NOSIGNAL","","",N,N],[17,"MSG_MORE","","",N,N],[17,"MSG_WAITFORONE","","",N,N],[17,"MSG_FASTOPEN","","",N,N],[17,"MSG_CMSG_CLOEXEC","","",N,N],[17,"SCM_TIMESTAMP","","",N,N],[17,"SOCK_RAW","","",N,N],[17,"SOCK_RDM","","",N,N],[17,"IP_MULTICAST_IF","","",N,N],[17,"IP_MULTICAST_TTL","","",N,N],[17,"IP_MULTICAST_LOOP","","",N,N],[17,"IP_TTL","","",N,N],[17,"IP_HDRINCL","","",N,N],[17,"IP_PKTINFO","","",N,N],[17,"IP_ADD_MEMBERSHIP","","",N,N],[17,"IP_DROP_MEMBERSHIP","","",N,N],[17,"IP_TRANSPARENT","","",N,N],[17,"IPV6_UNICAST_HOPS","","",N,N],[17,"IPV6_MULTICAST_IF","","",N,N],[17,"IPV6_MULTICAST_HOPS","","",N,N],[17,"IPV6_MULTICAST_LOOP","","",N,N],[17,"IPV6_ADD_MEMBERSHIP","","",N,N],[17,"IPV6_DROP_MEMBERSHIP","","",N,N],[17,"IPV6_V6ONLY","","",N,N],[17,"IPV6_RECVPKTINFO","","",N,N],[17,"IPV6_PKTINFO","","",N,N],[17,"TCP_NODELAY","","",N,N],[17,"TCP_MAXSEG","","",N,N],[17,"TCP_CORK","","",N,N],[17,"TCP_KEEPIDLE","","",N,N],[17,"TCP_KEEPINTVL","","",N,N],[17,"TCP_KEEPCNT","","",N,N],[17,"TCP_SYNCNT","","",N,N],[17,"TCP_LINGER2","","",N,N],[17,"TCP_DEFER_ACCEPT","","",N,N],[17,"TCP_WINDOW_CLAMP","","",N,N],[17,"TCP_INFO","","",N,N],[17,"TCP_QUICKACK","","",N,N],[17,"TCP_CONGESTION","","",N,N],[17,"SO_DEBUG","","",N,N],[17,"SHUT_RD","","",N,N],[17,"SHUT_WR","","",N,N],[17,"SHUT_RDWR","","",N,N],[17,"LOCK_SH","","",N,N],[17,"LOCK_EX","","",N,N],[17,"LOCK_NB","","",N,N],[17,"LOCK_UN","","",N,N],[17,"SS_ONSTACK","","",N,N],[17,"SS_DISABLE","","",N,N],[17,"PATH_MAX","","",N,N],[17,"FD_SETSIZE","","",N,N],[17,"EPOLLIN","","",N,N],[17,"EPOLLPRI","","",N,N],[17,"EPOLLOUT","","",N,N],[17,"EPOLLRDNORM","","",N,N],[17,"EPOLLRDBAND","","",N,N],[17,"EPOLLWRNORM","","",N,N],[17,"EPOLLWRBAND","","",N,N],[17,"EPOLLMSG","","",N,N],[17,"EPOLLERR","","",N,N],[17,"EPOLLHUP","","",N,N],[17,"EPOLLET","","",N,N],[17,"EPOLL_CTL_ADD","","",N,N],[17,"EPOLL_CTL_MOD","","",N,N],[17,"EPOLL_CTL_DEL","","",N,N],[17,"MNT_DETACH","","",N,N],[17,"MNT_EXPIRE","","",N,N],[17,"Q_GETFMT","","",N,N],[17,"Q_GETINFO","","",N,N],[17,"Q_SETINFO","","",N,N],[17,"QIF_BLIMITS","","",N,N],[17,"QIF_SPACE","","",N,N],[17,"QIF_ILIMITS","","",N,N],[17,"QIF_INODES","","",N,N],[17,"QIF_BTIME","","",N,N],[17,"QIF_ITIME","","",N,N],[17,"QIF_LIMITS","","",N,N],[17,"QIF_USAGE","","",N,N],[17,"QIF_TIMES","","",N,N],[17,"QIF_ALL","","",N,N],[17,"MNT_FORCE","","",N,N],[17,"Q_SYNC","","",N,N],[17,"Q_QUOTAON","","",N,N],[17,"Q_QUOTAOFF","","",N,N],[17,"Q_GETQUOTA","","",N,N],[17,"Q_SETQUOTA","","",N,N],[17,"TCIOFF","","",N,N],[17,"TCION","","",N,N],[17,"TCOOFF","","",N,N],[17,"TCOON","","",N,N],[17,"TCIFLUSH","","",N,N],[17,"TCOFLUSH","","",N,N],[17,"TCIOFLUSH","","",N,N],[17,"NL0","","",N,N],[17,"NL1","","",N,N],[17,"TAB0","","",N,N],[17,"CR0","","",N,N],[17,"FF0","","",N,N],[17,"BS0","","",N,N],[17,"VT0","","",N,N],[17,"VERASE","","",N,N],[17,"VKILL","","",N,N],[17,"VINTR","","",N,N],[17,"VQUIT","","",N,N],[17,"VLNEXT","","",N,N],[17,"IGNBRK","","",N,N],[17,"BRKINT","","",N,N],[17,"IGNPAR","","",N,N],[17,"PARMRK","","",N,N],[17,"INPCK","","",N,N],[17,"ISTRIP","","",N,N],[17,"INLCR","","",N,N],[17,"IGNCR","","",N,N],[17,"ICRNL","","",N,N],[17,"IXANY","","",N,N],[17,"IMAXBEL","","",N,N],[17,"OPOST","","",N,N],[17,"CS5","","",N,N],[17,"CRTSCTS","","",N,N],[17,"ECHO","","",N,N],[17,"OCRNL","","",N,N],[17,"ONOCR","","",N,N],[17,"ONLRET","","",N,N],[17,"OFILL","","",N,N],[17,"OFDEL","","",N,N],[17,"CLONE_VM","","",N,N],[17,"CLONE_FS","","",N,N],[17,"CLONE_FILES","","",N,N],[17,"CLONE_SIGHAND","","",N,N],[17,"CLONE_PTRACE","","",N,N],[17,"CLONE_VFORK","","",N,N],[17,"CLONE_PARENT","","",N,N],[17,"CLONE_THREAD","","",N,N],[17,"CLONE_NEWNS","","",N,N],[17,"CLONE_SYSVSEM","","",N,N],[17,"CLONE_SETTLS","","",N,N],[17,"CLONE_PARENT_SETTID","","",N,N],[17,"CLONE_CHILD_CLEARTID","","",N,N],[17,"CLONE_DETACHED","","",N,N],[17,"CLONE_UNTRACED","","",N,N],[17,"CLONE_CHILD_SETTID","","",N,N],[17,"CLONE_NEWUTS","","",N,N],[17,"CLONE_NEWIPC","","",N,N],[17,"CLONE_NEWUSER","","",N,N],[17,"CLONE_NEWPID","","",N,N],[17,"CLONE_NEWNET","","",N,N],[17,"CLONE_IO","","",N,N],[17,"CLONE_NEWCGROUP","","",N,N],[17,"WNOHANG","","",N,N],[17,"WUNTRACED","","",N,N],[17,"WSTOPPED","","",N,N],[17,"WEXITED","","",N,N],[17,"WCONTINUED","","",N,N],[17,"WNOWAIT","","",N,N],[17,"PTRACE_O_TRACESYSGOOD","","",N,N],[17,"PTRACE_O_TRACEFORK","","",N,N],[17,"PTRACE_O_TRACEVFORK","","",N,N],[17,"PTRACE_O_TRACECLONE","","",N,N],[17,"PTRACE_O_TRACEEXEC","","",N,N],[17,"PTRACE_O_TRACEVFORKDONE","","",N,N],[17,"PTRACE_O_TRACEEXIT","","",N,N],[17,"PTRACE_O_TRACESECCOMP","","",N,N],[17,"PTRACE_O_EXITKILL","","",N,N],[17,"PTRACE_O_SUSPEND_SECCOMP","","",N,N],[17,"PTRACE_O_MASK","","",N,N],[17,"PTRACE_EVENT_FORK","","",N,N],[17,"PTRACE_EVENT_VFORK","","",N,N],[17,"PTRACE_EVENT_CLONE","","",N,N],[17,"PTRACE_EVENT_EXEC","","",N,N],[17,"PTRACE_EVENT_VFORK_DONE","","",N,N],[17,"PTRACE_EVENT_EXIT","","",N,N],[17,"PTRACE_EVENT_SECCOMP","","",N,N],[17,"__WNOTHREAD","","",N,N],[17,"__WALL","","",N,N],[17,"__WCLONE","","",N,N],[17,"SPLICE_F_MOVE","","",N,N],[17,"SPLICE_F_NONBLOCK","","",N,N],[17,"SPLICE_F_MORE","","",N,N],[17,"SPLICE_F_GIFT","","",N,N],[17,"RTLD_LOCAL","","",N,N],[17,"RTLD_LAZY","","",N,N],[17,"POSIX_FADV_NORMAL","","",N,N],[17,"POSIX_FADV_RANDOM","","",N,N],[17,"POSIX_FADV_SEQUENTIAL","","",N,N],[17,"POSIX_FADV_WILLNEED","","",N,N],[17,"AT_FDCWD","","",N,N],[17,"AT_SYMLINK_NOFOLLOW","","",N,N],[17,"AT_REMOVEDIR","","",N,N],[17,"AT_SYMLINK_FOLLOW","","",N,N],[17,"AT_NO_AUTOMOUNT","","",N,N],[17,"AT_EMPTY_PATH","","",N,N],[17,"LOG_CRON","","",N,N],[17,"LOG_AUTHPRIV","","",N,N],[17,"LOG_FTP","","",N,N],[17,"LOG_PERROR","","",N,N],[17,"PIPE_BUF","","",N,N],[17,"SI_LOAD_SHIFT","","",N,N],[17,"SIGEV_SIGNAL","","",N,N],[17,"SIGEV_NONE","","",N,N],[17,"SIGEV_THREAD","","",N,N],[17,"P_ALL","","",N,N],[17,"P_PID","","",N,N],[17,"P_PGID","","",N,N],[17,"UTIME_OMIT","","",N,N],[17,"UTIME_NOW","","",N,N],[17,"POLLIN","","",N,N],[17,"POLLPRI","","",N,N],[17,"POLLOUT","","",N,N],[17,"POLLERR","","",N,N],[17,"POLLHUP","","",N,N],[17,"POLLNVAL","","",N,N],[17,"POLLRDNORM","","",N,N],[17,"POLLRDBAND","","",N,N],[17,"IPTOS_LOWDELAY","","",N,N],[17,"IPTOS_THROUGHPUT","","",N,N],[17,"IPTOS_RELIABILITY","","",N,N],[17,"IPTOS_MINCOST","","",N,N],[17,"IPTOS_PREC_NETCONTROL","","",N,N],[17,"IPTOS_PREC_INTERNETCONTROL","","",N,N],[17,"IPTOS_PREC_CRITIC_ECP","","",N,N],[17,"IPTOS_PREC_FLASHOVERRIDE","","",N,N],[17,"IPTOS_PREC_FLASH","","",N,N],[17,"IPTOS_PREC_IMMEDIATE","","",N,N],[17,"IPTOS_PREC_PRIORITY","","",N,N],[17,"IPTOS_PREC_ROUTINE","","",N,N],[17,"IPOPT_COPY","","",N,N],[17,"IPOPT_CLASS_MASK","","",N,N],[17,"IPOPT_NUMBER_MASK","","",N,N],[17,"IPOPT_CONTROL","","",N,N],[17,"IPOPT_RESERVED1","","",N,N],[17,"IPOPT_MEASUREMENT","","",N,N],[17,"IPOPT_RESERVED2","","",N,N],[17,"IPOPT_END","","",N,N],[17,"IPOPT_NOOP","","",N,N],[17,"IPOPT_SEC","","",N,N],[17,"IPOPT_LSRR","","",N,N],[17,"IPOPT_TIMESTAMP","","",N,N],[17,"IPOPT_RR","","",N,N],[17,"IPOPT_SID","","",N,N],[17,"IPOPT_SSRR","","",N,N],[17,"IPOPT_RA","","",N,N],[17,"IPVERSION","","",N,N],[17,"MAXTTL","","",N,N],[17,"IPDEFTTL","","",N,N],[17,"IPOPT_OPTVAL","","",N,N],[17,"IPOPT_OLEN","","",N,N],[17,"IPOPT_OFFSET","","",N,N],[17,"IPOPT_MINOFF","","",N,N],[17,"MAX_IPOPTLEN","","",N,N],[17,"IPOPT_NOP","","",N,N],[17,"IPOPT_EOL","","",N,N],[17,"IPOPT_TS","","",N,N],[17,"IPOPT_TS_TSONLY","","",N,N],[17,"IPOPT_TS_TSANDADDR","","",N,N],[17,"IPOPT_TS_PRESPEC","","",N,N],[17,"ARPOP_RREQUEST","","",N,N],[17,"ARPOP_RREPLY","","",N,N],[17,"ARPOP_InREQUEST","","",N,N],[17,"ARPOP_InREPLY","","",N,N],[17,"ARPOP_NAK","","",N,N],[17,"ATF_NETMASK","","",N,N],[17,"ATF_DONTPUB","","",N,N],[17,"ARPHRD_NETROM","","",N,N],[17,"ARPHRD_ETHER","","",N,N],[17,"ARPHRD_EETHER","","",N,N],[17,"ARPHRD_AX25","","",N,N],[17,"ARPHRD_PRONET","","",N,N],[17,"ARPHRD_CHAOS","","",N,N],[17,"ARPHRD_IEEE802","","",N,N],[17,"ARPHRD_ARCNET","","",N,N],[17,"ARPHRD_APPLETLK","","",N,N],[17,"ARPHRD_DLCI","","",N,N],[17,"ARPHRD_ATM","","",N,N],[17,"ARPHRD_METRICOM","","",N,N],[17,"ARPHRD_IEEE1394","","",N,N],[17,"ARPHRD_EUI64","","",N,N],[17,"ARPHRD_INFINIBAND","","",N,N],[17,"ARPHRD_SLIP","","",N,N],[17,"ARPHRD_CSLIP","","",N,N],[17,"ARPHRD_SLIP6","","",N,N],[17,"ARPHRD_CSLIP6","","",N,N],[17,"ARPHRD_RSRVD","","",N,N],[17,"ARPHRD_ADAPT","","",N,N],[17,"ARPHRD_ROSE","","",N,N],[17,"ARPHRD_X25","","",N,N],[17,"ARPHRD_HWX25","","",N,N],[17,"ARPHRD_PPP","","",N,N],[17,"ARPHRD_CISCO","","",N,N],[17,"ARPHRD_HDLC","","",N,N],[17,"ARPHRD_LAPB","","",N,N],[17,"ARPHRD_DDCMP","","",N,N],[17,"ARPHRD_RAWHDLC","","",N,N],[17,"ARPHRD_TUNNEL","","",N,N],[17,"ARPHRD_TUNNEL6","","",N,N],[17,"ARPHRD_FRAD","","",N,N],[17,"ARPHRD_SKIP","","",N,N],[17,"ARPHRD_LOOPBACK","","",N,N],[17,"ARPHRD_LOCALTLK","","",N,N],[17,"ARPHRD_FDDI","","",N,N],[17,"ARPHRD_BIF","","",N,N],[17,"ARPHRD_SIT","","",N,N],[17,"ARPHRD_IPDDP","","",N,N],[17,"ARPHRD_IPGRE","","",N,N],[17,"ARPHRD_PIMREG","","",N,N],[17,"ARPHRD_HIPPI","","",N,N],[17,"ARPHRD_ASH","","",N,N],[17,"ARPHRD_ECONET","","",N,N],[17,"ARPHRD_IRDA","","",N,N],[17,"ARPHRD_FCPP","","",N,N],[17,"ARPHRD_FCAL","","",N,N],[17,"ARPHRD_FCPL","","",N,N],[17,"ARPHRD_FCFABRIC","","",N,N],[17,"ARPHRD_IEEE802_TR","","",N,N],[17,"ARPHRD_IEEE80211","","",N,N],[17,"ARPHRD_IEEE80211_PRISM","","",N,N],[17,"ARPHRD_IEEE80211_RADIOTAP","","",N,N],[17,"ARPHRD_IEEE802154","","",N,N],[17,"ARPHRD_VOID","","",N,N],[17,"ARPHRD_NONE","","",N,N],[17,"ABDAY_1","","",N,N],[17,"ABDAY_2","","",N,N],[17,"ABDAY_3","","",N,N],[17,"ABDAY_4","","",N,N],[17,"ABDAY_5","","",N,N],[17,"ABDAY_6","","",N,N],[17,"ABDAY_7","","",N,N],[17,"DAY_1","","",N,N],[17,"DAY_2","","",N,N],[17,"DAY_3","","",N,N],[17,"DAY_4","","",N,N],[17,"DAY_5","","",N,N],[17,"DAY_6","","",N,N],[17,"DAY_7","","",N,N],[17,"ABMON_1","","",N,N],[17,"ABMON_2","","",N,N],[17,"ABMON_3","","",N,N],[17,"ABMON_4","","",N,N],[17,"ABMON_5","","",N,N],[17,"ABMON_6","","",N,N],[17,"ABMON_7","","",N,N],[17,"ABMON_8","","",N,N],[17,"ABMON_9","","",N,N],[17,"ABMON_10","","",N,N],[17,"ABMON_11","","",N,N],[17,"ABMON_12","","",N,N],[17,"MON_1","","",N,N],[17,"MON_2","","",N,N],[17,"MON_3","","",N,N],[17,"MON_4","","",N,N],[17,"MON_5","","",N,N],[17,"MON_6","","",N,N],[17,"MON_7","","",N,N],[17,"MON_8","","",N,N],[17,"MON_9","","",N,N],[17,"MON_10","","",N,N],[17,"MON_11","","",N,N],[17,"MON_12","","",N,N],[17,"AM_STR","","",N,N],[17,"PM_STR","","",N,N],[17,"D_T_FMT","","",N,N],[17,"D_FMT","","",N,N],[17,"T_FMT","","",N,N],[17,"T_FMT_AMPM","","",N,N],[17,"ERA","","",N,N],[17,"ERA_D_FMT","","",N,N],[17,"ALT_DIGITS","","",N,N],[17,"ERA_D_T_FMT","","",N,N],[17,"ERA_T_FMT","","",N,N],[17,"CODESET","","",N,N],[17,"CRNCYSTR","","",N,N],[17,"RUSAGE_THREAD","","",N,N],[17,"RUSAGE_CHILDREN","","",N,N],[17,"RADIXCHAR","","",N,N],[17,"THOUSEP","","",N,N],[17,"YESEXPR","","",N,N],[17,"NOEXPR","","",N,N],[17,"YESSTR","","",N,N],[17,"NOSTR","","",N,N],[17,"FILENAME_MAX","","",N,N],[17,"L_tmpnam","","",N,N],[17,"_PC_LINK_MAX","","",N,N],[17,"_PC_MAX_CANON","","",N,N],[17,"_PC_MAX_INPUT","","",N,N],[17,"_PC_NAME_MAX","","",N,N],[17,"_PC_PATH_MAX","","",N,N],[17,"_PC_PIPE_BUF","","",N,N],[17,"_PC_CHOWN_RESTRICTED","","",N,N],[17,"_PC_NO_TRUNC","","",N,N],[17,"_PC_VDISABLE","","",N,N],[17,"_PC_SYNC_IO","","",N,N],[17,"_PC_ASYNC_IO","","",N,N],[17,"_PC_PRIO_IO","","",N,N],[17,"_PC_SOCK_MAXBUF","","",N,N],[17,"_PC_FILESIZEBITS","","",N,N],[17,"_PC_REC_INCR_XFER_SIZE","","",N,N],[17,"_PC_REC_MAX_XFER_SIZE","","",N,N],[17,"_PC_REC_MIN_XFER_SIZE","","",N,N],[17,"_PC_REC_XFER_ALIGN","","",N,N],[17,"_PC_ALLOC_SIZE_MIN","","",N,N],[17,"_PC_SYMLINK_MAX","","",N,N],[17,"_PC_2_SYMLINKS","","",N,N],[17,"_SC_ARG_MAX","","",N,N],[17,"_SC_CHILD_MAX","","",N,N],[17,"_SC_CLK_TCK","","",N,N],[17,"_SC_NGROUPS_MAX","","",N,N],[17,"_SC_OPEN_MAX","","",N,N],[17,"_SC_STREAM_MAX","","",N,N],[17,"_SC_TZNAME_MAX","","",N,N],[17,"_SC_JOB_CONTROL","","",N,N],[17,"_SC_SAVED_IDS","","",N,N],[17,"_SC_REALTIME_SIGNALS","","",N,N],[17,"_SC_PRIORITY_SCHEDULING","","",N,N],[17,"_SC_TIMERS","","",N,N],[17,"_SC_ASYNCHRONOUS_IO","","",N,N],[17,"_SC_PRIORITIZED_IO","","",N,N],[17,"_SC_SYNCHRONIZED_IO","","",N,N],[17,"_SC_FSYNC","","",N,N],[17,"_SC_MAPPED_FILES","","",N,N],[17,"_SC_MEMLOCK","","",N,N],[17,"_SC_MEMLOCK_RANGE","","",N,N],[17,"_SC_MEMORY_PROTECTION","","",N,N],[17,"_SC_MESSAGE_PASSING","","",N,N],[17,"_SC_SEMAPHORES","","",N,N],[17,"_SC_SHARED_MEMORY_OBJECTS","","",N,N],[17,"_SC_AIO_LISTIO_MAX","","",N,N],[17,"_SC_AIO_MAX","","",N,N],[17,"_SC_AIO_PRIO_DELTA_MAX","","",N,N],[17,"_SC_DELAYTIMER_MAX","","",N,N],[17,"_SC_MQ_OPEN_MAX","","",N,N],[17,"_SC_MQ_PRIO_MAX","","",N,N],[17,"_SC_VERSION","","",N,N],[17,"_SC_PAGESIZE","","",N,N],[17,"_SC_PAGE_SIZE","","",N,N],[17,"_SC_RTSIG_MAX","","",N,N],[17,"_SC_SEM_NSEMS_MAX","","",N,N],[17,"_SC_SEM_VALUE_MAX","","",N,N],[17,"_SC_SIGQUEUE_MAX","","",N,N],[17,"_SC_TIMER_MAX","","",N,N],[17,"_SC_BC_BASE_MAX","","",N,N],[17,"_SC_BC_DIM_MAX","","",N,N],[17,"_SC_BC_SCALE_MAX","","",N,N],[17,"_SC_BC_STRING_MAX","","",N,N],[17,"_SC_COLL_WEIGHTS_MAX","","",N,N],[17,"_SC_EXPR_NEST_MAX","","",N,N],[17,"_SC_LINE_MAX","","",N,N],[17,"_SC_RE_DUP_MAX","","",N,N],[17,"_SC_2_VERSION","","",N,N],[17,"_SC_2_C_BIND","","",N,N],[17,"_SC_2_C_DEV","","",N,N],[17,"_SC_2_FORT_DEV","","",N,N],[17,"_SC_2_FORT_RUN","","",N,N],[17,"_SC_2_SW_DEV","","",N,N],[17,"_SC_2_LOCALEDEF","","",N,N],[17,"_SC_UIO_MAXIOV","","",N,N],[17,"_SC_IOV_MAX","","",N,N],[17,"_SC_THREADS","","",N,N],[17,"_SC_THREAD_SAFE_FUNCTIONS","","",N,N],[17,"_SC_GETGR_R_SIZE_MAX","","",N,N],[17,"_SC_GETPW_R_SIZE_MAX","","",N,N],[17,"_SC_LOGIN_NAME_MAX","","",N,N],[17,"_SC_TTY_NAME_MAX","","",N,N],[17,"_SC_THREAD_DESTRUCTOR_ITERATIONS","","",N,N],[17,"_SC_THREAD_KEYS_MAX","","",N,N],[17,"_SC_THREAD_STACK_MIN","","",N,N],[17,"_SC_THREAD_THREADS_MAX","","",N,N],[17,"_SC_THREAD_ATTR_STACKADDR","","",N,N],[17,"_SC_THREAD_ATTR_STACKSIZE","","",N,N],[17,"_SC_THREAD_PRIORITY_SCHEDULING","","",N,N],[17,"_SC_THREAD_PRIO_INHERIT","","",N,N],[17,"_SC_THREAD_PRIO_PROTECT","","",N,N],[17,"_SC_THREAD_PROCESS_SHARED","","",N,N],[17,"_SC_NPROCESSORS_CONF","","",N,N],[17,"_SC_NPROCESSORS_ONLN","","",N,N],[17,"_SC_PHYS_PAGES","","",N,N],[17,"_SC_AVPHYS_PAGES","","",N,N],[17,"_SC_ATEXIT_MAX","","",N,N],[17,"_SC_PASS_MAX","","",N,N],[17,"_SC_XOPEN_VERSION","","",N,N],[17,"_SC_XOPEN_XCU_VERSION","","",N,N],[17,"_SC_XOPEN_UNIX","","",N,N],[17,"_SC_XOPEN_CRYPT","","",N,N],[17,"_SC_XOPEN_ENH_I18N","","",N,N],[17,"_SC_XOPEN_SHM","","",N,N],[17,"_SC_2_CHAR_TERM","","",N,N],[17,"_SC_2_UPE","","",N,N],[17,"_SC_XOPEN_XPG2","","",N,N],[17,"_SC_XOPEN_XPG3","","",N,N],[17,"_SC_XOPEN_XPG4","","",N,N],[17,"_SC_NZERO","","",N,N],[17,"_SC_XBS5_ILP32_OFF32","","",N,N],[17,"_SC_XBS5_ILP32_OFFBIG","","",N,N],[17,"_SC_XBS5_LP64_OFF64","","",N,N],[17,"_SC_XBS5_LPBIG_OFFBIG","","",N,N],[17,"_SC_XOPEN_LEGACY","","",N,N],[17,"_SC_XOPEN_REALTIME","","",N,N],[17,"_SC_XOPEN_REALTIME_THREADS","","",N,N],[17,"_SC_ADVISORY_INFO","","",N,N],[17,"_SC_BARRIERS","","",N,N],[17,"_SC_CLOCK_SELECTION","","",N,N],[17,"_SC_CPUTIME","","",N,N],[17,"_SC_THREAD_CPUTIME","","",N,N],[17,"_SC_MONOTONIC_CLOCK","","",N,N],[17,"_SC_READER_WRITER_LOCKS","","",N,N],[17,"_SC_SPIN_LOCKS","","",N,N],[17,"_SC_REGEXP","","",N,N],[17,"_SC_SHELL","","",N,N],[17,"_SC_SPAWN","","",N,N],[17,"_SC_SPORADIC_SERVER","","",N,N],[17,"_SC_THREAD_SPORADIC_SERVER","","",N,N],[17,"_SC_TIMEOUTS","","",N,N],[17,"_SC_TYPED_MEMORY_OBJECTS","","",N,N],[17,"_SC_2_PBS","","",N,N],[17,"_SC_2_PBS_ACCOUNTING","","",N,N],[17,"_SC_2_PBS_LOCATE","","",N,N],[17,"_SC_2_PBS_MESSAGE","","",N,N],[17,"_SC_2_PBS_TRACK","","",N,N],[17,"_SC_SYMLOOP_MAX","","",N,N],[17,"_SC_STREAMS","","",N,N],[17,"_SC_2_PBS_CHECKPOINT","","",N,N],[17,"_SC_V6_ILP32_OFF32","","",N,N],[17,"_SC_V6_ILP32_OFFBIG","","",N,N],[17,"_SC_V6_LP64_OFF64","","",N,N],[17,"_SC_V6_LPBIG_OFFBIG","","",N,N],[17,"_SC_HOST_NAME_MAX","","",N,N],[17,"_SC_TRACE","","",N,N],[17,"_SC_TRACE_EVENT_FILTER","","",N,N],[17,"_SC_TRACE_INHERIT","","",N,N],[17,"_SC_TRACE_LOG","","",N,N],[17,"_SC_IPV6","","",N,N],[17,"_SC_RAW_SOCKETS","","",N,N],[17,"_SC_V7_ILP32_OFF32","","",N,N],[17,"_SC_V7_ILP32_OFFBIG","","",N,N],[17,"_SC_V7_LP64_OFF64","","",N,N],[17,"_SC_V7_LPBIG_OFFBIG","","",N,N],[17,"_SC_SS_REPL_MAX","","",N,N],[17,"_SC_TRACE_EVENT_NAME_MAX","","",N,N],[17,"_SC_TRACE_NAME_MAX","","",N,N],[17,"_SC_TRACE_SYS_MAX","","",N,N],[17,"_SC_TRACE_USER_EVENT_MAX","","",N,N],[17,"_SC_XOPEN_STREAMS","","",N,N],[17,"_SC_THREAD_ROBUST_PRIO_INHERIT","","",N,N],[17,"_SC_THREAD_ROBUST_PRIO_PROTECT","","",N,N],[17,"RLIM_SAVED_MAX","","",N,N],[17,"RLIM_SAVED_CUR","","",N,N],[17,"GLOB_ERR","","",N,N],[17,"GLOB_MARK","","",N,N],[17,"GLOB_NOSORT","","",N,N],[17,"GLOB_DOOFFS","","",N,N],[17,"GLOB_NOCHECK","","",N,N],[17,"GLOB_APPEND","","",N,N],[17,"GLOB_NOESCAPE","","",N,N],[17,"GLOB_NOSPACE","","",N,N],[17,"GLOB_ABORTED","","",N,N],[17,"GLOB_NOMATCH","","",N,N],[17,"POSIX_MADV_NORMAL","","",N,N],[17,"POSIX_MADV_RANDOM","","",N,N],[17,"POSIX_MADV_SEQUENTIAL","","",N,N],[17,"POSIX_MADV_WILLNEED","","",N,N],[17,"S_IEXEC","","",N,N],[17,"S_IWRITE","","",N,N],[17,"S_IREAD","","",N,N],[17,"F_LOCK","","",N,N],[17,"F_TEST","","",N,N],[17,"F_TLOCK","","",N,N],[17,"F_ULOCK","","",N,N],[17,"IFF_LOWER_UP","","",N,N],[17,"IFF_DORMANT","","",N,N],[17,"IFF_ECHO","","",N,N],[17,"IFF_TUN","","",N,N],[17,"IFF_TAP","","",N,N],[17,"IFF_NO_PI","","",N,N],[17,"TUN_READQ_SIZE","","",N,N],[17,"TUN_TUN_DEV","","",N,N],[17,"TUN_TAP_DEV","","",N,N],[17,"TUN_TYPE_MASK","","",N,N],[17,"IFF_ONE_QUEUE","","",N,N],[17,"IFF_VNET_HDR","","",N,N],[17,"IFF_TUN_EXCL","","",N,N],[17,"IFF_MULTI_QUEUE","","",N,N],[17,"IFF_ATTACH_QUEUE","","",N,N],[17,"IFF_DETACH_QUEUE","","",N,N],[17,"IFF_PERSIST","","",N,N],[17,"IFF_NOFILTER","","",N,N],[17,"ST_RDONLY","","",N,N],[17,"ST_NOSUID","","",N,N],[17,"ST_NODEV","","",N,N],[17,"ST_NOEXEC","","",N,N],[17,"ST_SYNCHRONOUS","","",N,N],[17,"ST_MANDLOCK","","",N,N],[17,"ST_WRITE","","",N,N],[17,"ST_APPEND","","",N,N],[17,"ST_IMMUTABLE","","",N,N],[17,"ST_NOATIME","","",N,N],[17,"ST_NODIRATIME","","",N,N],[17,"RTLD_NEXT","","",N,N],[17,"RTLD_DEFAULT","","",N,N],[17,"RTLD_NODELETE","","",N,N],[17,"RTLD_NOW","","",N,N],[17,"TCP_MD5SIG","","",N,N],[17,"PTHREAD_MUTEX_INITIALIZER","","",N,N],[17,"PTHREAD_COND_INITIALIZER","","",N,N],[17,"PTHREAD_RWLOCK_INITIALIZER","","",N,N],[17,"PTHREAD_MUTEX_NORMAL","","",N,N],[17,"PTHREAD_MUTEX_RECURSIVE","","",N,N],[17,"PTHREAD_MUTEX_ERRORCHECK","","",N,N],[17,"PTHREAD_MUTEX_DEFAULT","","",N,N],[17,"PTHREAD_PROCESS_PRIVATE","","",N,N],[17,"PTHREAD_PROCESS_SHARED","","",N,N],[17,"__SIZEOF_PTHREAD_COND_T","","",N,N],[17,"RENAME_NOREPLACE","","",N,N],[17,"RENAME_EXCHANGE","","",N,N],[17,"RENAME_WHITEOUT","","",N,N],[17,"SCHED_OTHER","","",N,N],[17,"SCHED_FIFO","","",N,N],[17,"SCHED_RR","","",N,N],[17,"SCHED_BATCH","","",N,N],[17,"SCHED_IDLE","","",N,N],[17,"IPPROTO_HOPOPTS","","Hop-by-hop option header",N,N],[17,"IPPROTO_IGMP","","group mgmt protocol",N,N],[17,"IPPROTO_IPIP","","for compatibility",N,N],[17,"IPPROTO_EGP","","exterior gateway protocol",N,N],[17,"IPPROTO_PUP","","pup",N,N],[17,"IPPROTO_IDP","","xns idp",N,N],[17,"IPPROTO_TP","","tp-4 w/ class negotiation",N,N],[17,"IPPROTO_DCCP","","DCCP",N,N],[17,"IPPROTO_ROUTING","","IP6 routing header",N,N],[17,"IPPROTO_FRAGMENT","","IP6 fragmentation header",N,N],[17,"IPPROTO_RSVP","","resource reservation",N,N],[17,"IPPROTO_GRE","","General Routing Encap.",N,N],[17,"IPPROTO_ESP","","IP6 Encap Sec. Payload",N,N],[17,"IPPROTO_AH","","IP6 Auth Header",N,N],[17,"IPPROTO_NONE","","IP6 no next header",N,N],[17,"IPPROTO_DSTOPTS","","IP6 destination option",N,N],[17,"IPPROTO_MTP","","",N,N],[17,"IPPROTO_BEETPH","","",N,N],[17,"IPPROTO_ENCAP","","encapsulation header",N,N],[17,"IPPROTO_PIM","","Protocol indep. multicast",N,N],[17,"IPPROTO_COMP","","IP Payload Comp. Protocol",N,N],[17,"IPPROTO_SCTP","","SCTP",N,N],[17,"IPPROTO_MH","","",N,N],[17,"IPPROTO_UDPLITE","","",N,N],[17,"IPPROTO_MPLS","","",N,N],[17,"IPPROTO_RAW","","raw IP packet",N,N],[17,"IPPROTO_MAX","","",N,N],[17,"AF_IB","","",N,N],[17,"AF_MPLS","","",N,N],[17,"AF_NFC","","",N,N],[17,"AF_VSOCK","","",N,N],[17,"PF_IB","","",N,N],[17,"PF_MPLS","","",N,N],[17,"PF_NFC","","",N,N],[17,"PF_VSOCK","","",N,N],[17,"IPC_PRIVATE","","",N,N],[17,"IPC_CREAT","","",N,N],[17,"IPC_EXCL","","",N,N],[17,"IPC_NOWAIT","","",N,N],[17,"IPC_RMID","","",N,N],[17,"IPC_SET","","",N,N],[17,"IPC_STAT","","",N,N],[17,"IPC_INFO","","",N,N],[17,"MSG_STAT","","",N,N],[17,"MSG_INFO","","",N,N],[17,"MSG_NOERROR","","",N,N],[17,"MSG_EXCEPT","","",N,N],[17,"MSG_COPY","","",N,N],[17,"SHM_R","","",N,N],[17,"SHM_W","","",N,N],[17,"SHM_RDONLY","","",N,N],[17,"SHM_RND","","",N,N],[17,"SHM_REMAP","","",N,N],[17,"SHM_EXEC","","",N,N],[17,"SHM_LOCK","","",N,N],[17,"SHM_UNLOCK","","",N,N],[17,"SHM_HUGETLB","","",N,N],[17,"SHM_NORESERVE","","",N,N],[17,"EPOLLRDHUP","","",N,N],[17,"EPOLLEXCLUSIVE","","",N,N],[17,"EPOLLONESHOT","","",N,N],[17,"QFMT_VFS_OLD","","",N,N],[17,"QFMT_VFS_V0","","",N,N],[17,"QFMT_VFS_V1","","",N,N],[17,"EFD_SEMAPHORE","","",N,N],[17,"LOG_NFACILITIES","","",N,N],[17,"SEM_FAILED","","",N,N],[17,"RB_AUTOBOOT","","",N,N],[17,"RB_HALT_SYSTEM","","",N,N],[17,"RB_ENABLE_CAD","","",N,N],[17,"RB_DISABLE_CAD","","",N,N],[17,"RB_POWER_OFF","","",N,N],[17,"RB_SW_SUSPEND","","",N,N],[17,"RB_KEXEC","","",N,N],[17,"AI_PASSIVE","","",N,N],[17,"AI_CANONNAME","","",N,N],[17,"AI_NUMERICHOST","","",N,N],[17,"AI_V4MAPPED","","",N,N],[17,"AI_ALL","","",N,N],[17,"AI_ADDRCONFIG","","",N,N],[17,"AI_NUMERICSERV","","",N,N],[17,"EAI_BADFLAGS","","",N,N],[17,"EAI_NONAME","","",N,N],[17,"EAI_AGAIN","","",N,N],[17,"EAI_FAIL","","",N,N],[17,"EAI_NODATA","","",N,N],[17,"EAI_FAMILY","","",N,N],[17,"EAI_SOCKTYPE","","",N,N],[17,"EAI_SERVICE","","",N,N],[17,"EAI_MEMORY","","",N,N],[17,"EAI_SYSTEM","","",N,N],[17,"EAI_OVERFLOW","","",N,N],[17,"NI_NUMERICHOST","","",N,N],[17,"NI_NUMERICSERV","","",N,N],[17,"NI_NOFQDN","","",N,N],[17,"NI_NAMEREQD","","",N,N],[17,"NI_DGRAM","","",N,N],[17,"SYNC_FILE_RANGE_WAIT_BEFORE","","",N,N],[17,"SYNC_FILE_RANGE_WRITE","","",N,N],[17,"SYNC_FILE_RANGE_WAIT_AFTER","","",N,N],[17,"AIO_CANCELED","","",N,N],[17,"AIO_NOTCANCELED","","",N,N],[17,"AIO_ALLDONE","","",N,N],[17,"LIO_READ","","",N,N],[17,"LIO_WRITE","","",N,N],[17,"LIO_NOP","","",N,N],[17,"LIO_WAIT","","",N,N],[17,"LIO_NOWAIT","","",N,N],[17,"MREMAP_MAYMOVE","","",N,N],[17,"MREMAP_FIXED","","",N,N],[17,"PR_SET_PDEATHSIG","","",N,N],[17,"PR_GET_PDEATHSIG","","",N,N],[17,"PR_GET_DUMPABLE","","",N,N],[17,"PR_SET_DUMPABLE","","",N,N],[17,"PR_GET_UNALIGN","","",N,N],[17,"PR_SET_UNALIGN","","",N,N],[17,"PR_UNALIGN_NOPRINT","","",N,N],[17,"PR_UNALIGN_SIGBUS","","",N,N],[17,"PR_GET_KEEPCAPS","","",N,N],[17,"PR_SET_KEEPCAPS","","",N,N],[17,"PR_GET_FPEMU","","",N,N],[17,"PR_SET_FPEMU","","",N,N],[17,"PR_FPEMU_NOPRINT","","",N,N],[17,"PR_FPEMU_SIGFPE","","",N,N],[17,"PR_GET_FPEXC","","",N,N],[17,"PR_SET_FPEXC","","",N,N],[17,"PR_FP_EXC_SW_ENABLE","","",N,N],[17,"PR_FP_EXC_DIV","","",N,N],[17,"PR_FP_EXC_OVF","","",N,N],[17,"PR_FP_EXC_UND","","",N,N],[17,"PR_FP_EXC_RES","","",N,N],[17,"PR_FP_EXC_INV","","",N,N],[17,"PR_FP_EXC_DISABLED","","",N,N],[17,"PR_FP_EXC_NONRECOV","","",N,N],[17,"PR_FP_EXC_ASYNC","","",N,N],[17,"PR_FP_EXC_PRECISE","","",N,N],[17,"PR_GET_TIMING","","",N,N],[17,"PR_SET_TIMING","","",N,N],[17,"PR_TIMING_STATISTICAL","","",N,N],[17,"PR_TIMING_TIMESTAMP","","",N,N],[17,"PR_SET_NAME","","",N,N],[17,"PR_GET_NAME","","",N,N],[17,"PR_GET_ENDIAN","","",N,N],[17,"PR_SET_ENDIAN","","",N,N],[17,"PR_ENDIAN_BIG","","",N,N],[17,"PR_ENDIAN_LITTLE","","",N,N],[17,"PR_ENDIAN_PPC_LITTLE","","",N,N],[17,"PR_GET_SECCOMP","","",N,N],[17,"PR_SET_SECCOMP","","",N,N],[17,"PR_CAPBSET_READ","","",N,N],[17,"PR_CAPBSET_DROP","","",N,N],[17,"PR_GET_TSC","","",N,N],[17,"PR_SET_TSC","","",N,N],[17,"PR_TSC_ENABLE","","",N,N],[17,"PR_TSC_SIGSEGV","","",N,N],[17,"PR_GET_SECUREBITS","","",N,N],[17,"PR_SET_SECUREBITS","","",N,N],[17,"PR_SET_TIMERSLACK","","",N,N],[17,"PR_GET_TIMERSLACK","","",N,N],[17,"PR_TASK_PERF_EVENTS_DISABLE","","",N,N],[17,"PR_TASK_PERF_EVENTS_ENABLE","","",N,N],[17,"PR_MCE_KILL","","",N,N],[17,"PR_MCE_KILL_CLEAR","","",N,N],[17,"PR_MCE_KILL_SET","","",N,N],[17,"PR_MCE_KILL_LATE","","",N,N],[17,"PR_MCE_KILL_EARLY","","",N,N],[17,"PR_MCE_KILL_DEFAULT","","",N,N],[17,"PR_MCE_KILL_GET","","",N,N],[17,"PR_SET_MM","","",N,N],[17,"PR_SET_MM_START_CODE","","",N,N],[17,"PR_SET_MM_END_CODE","","",N,N],[17,"PR_SET_MM_START_DATA","","",N,N],[17,"PR_SET_MM_END_DATA","","",N,N],[17,"PR_SET_MM_START_STACK","","",N,N],[17,"PR_SET_MM_START_BRK","","",N,N],[17,"PR_SET_MM_BRK","","",N,N],[17,"PR_SET_MM_ARG_START","","",N,N],[17,"PR_SET_MM_ARG_END","","",N,N],[17,"PR_SET_MM_ENV_START","","",N,N],[17,"PR_SET_MM_ENV_END","","",N,N],[17,"PR_SET_MM_AUXV","","",N,N],[17,"PR_SET_MM_EXE_FILE","","",N,N],[17,"PR_SET_MM_MAP","","",N,N],[17,"PR_SET_MM_MAP_SIZE","","",N,N],[17,"PR_SET_PTRACER","","",N,N],[17,"PR_SET_CHILD_SUBREAPER","","",N,N],[17,"PR_GET_CHILD_SUBREAPER","","",N,N],[17,"PR_SET_NO_NEW_PRIVS","","",N,N],[17,"PR_GET_NO_NEW_PRIVS","","",N,N],[17,"PR_GET_TID_ADDRESS","","",N,N],[17,"PR_SET_THP_DISABLE","","",N,N],[17,"PR_GET_THP_DISABLE","","",N,N],[17,"PR_MPX_ENABLE_MANAGEMENT","","",N,N],[17,"PR_MPX_DISABLE_MANAGEMENT","","",N,N],[17,"PR_SET_FP_MODE","","",N,N],[17,"PR_GET_FP_MODE","","",N,N],[17,"PR_FP_MODE_FR","","",N,N],[17,"PR_FP_MODE_FRE","","",N,N],[17,"PR_CAP_AMBIENT","","",N,N],[17,"PR_CAP_AMBIENT_IS_SET","","",N,N],[17,"PR_CAP_AMBIENT_RAISE","","",N,N],[17,"PR_CAP_AMBIENT_LOWER","","",N,N],[17,"PR_CAP_AMBIENT_CLEAR_ALL","","",N,N],[17,"GRND_NONBLOCK","","",N,N],[17,"GRND_RANDOM","","",N,N],[17,"SECCOMP_MODE_DISABLED","","",N,N],[17,"SECCOMP_MODE_STRICT","","",N,N],[17,"SECCOMP_MODE_FILTER","","",N,N],[17,"ITIMER_REAL","","",N,N],[17,"ITIMER_VIRTUAL","","",N,N],[17,"ITIMER_PROF","","",N,N],[17,"TFD_CLOEXEC","","",N,N],[17,"TFD_NONBLOCK","","",N,N],[17,"TFD_TIMER_ABSTIME","","",N,N],[17,"XATTR_CREATE","","",N,N],[17,"XATTR_REPLACE","","",N,N],[17,"_POSIX_VDISABLE","","",N,N],[17,"FALLOC_FL_KEEP_SIZE","","",N,N],[17,"FALLOC_FL_PUNCH_HOLE","","",N,N],[17,"FALLOC_FL_COLLAPSE_RANGE","","",N,N],[17,"FALLOC_FL_ZERO_RANGE","","",N,N],[17,"FALLOC_FL_INSERT_RANGE","","",N,N],[17,"FALLOC_FL_UNSHARE_RANGE","","",N,N],[17,"ENOATTR","","",N,N],[17,"SO_ORIGINAL_DST","","",N,N],[17,"IUTF8","","",N,N],[17,"CMSPAR","","",N,N],[17,"MFD_CLOEXEC","","",N,N],[17,"MFD_ALLOW_SEALING","","",N,N],[17,"PT_NULL","","",N,N],[17,"PT_LOAD","","",N,N],[17,"PT_DYNAMIC","","",N,N],[17,"PT_INTERP","","",N,N],[17,"PT_NOTE","","",N,N],[17,"PT_SHLIB","","",N,N],[17,"PT_PHDR","","",N,N],[17,"PT_TLS","","",N,N],[17,"PT_NUM","","",N,N],[17,"PT_LOOS","","",N,N],[17,"PT_GNU_EH_FRAME","","",N,N],[17,"PT_GNU_STACK","","",N,N],[17,"PT_GNU_RELRO","","",N,N],[17,"ETH_ALEN","","",N,N],[17,"ETH_HLEN","","",N,N],[17,"ETH_ZLEN","","",N,N],[17,"ETH_DATA_LEN","","",N,N],[17,"ETH_FRAME_LEN","","",N,N],[17,"ETH_FCS_LEN","","",N,N],[17,"ETH_P_LOOP","","",N,N],[17,"ETH_P_PUP","","",N,N],[17,"ETH_P_PUPAT","","",N,N],[17,"ETH_P_IP","","",N,N],[17,"ETH_P_X25","","",N,N],[17,"ETH_P_ARP","","",N,N],[17,"ETH_P_BPQ","","",N,N],[17,"ETH_P_IEEEPUP","","",N,N],[17,"ETH_P_IEEEPUPAT","","",N,N],[17,"ETH_P_BATMAN","","",N,N],[17,"ETH_P_DEC","","",N,N],[17,"ETH_P_DNA_DL","","",N,N],[17,"ETH_P_DNA_RC","","",N,N],[17,"ETH_P_DNA_RT","","",N,N],[17,"ETH_P_LAT","","",N,N],[17,"ETH_P_DIAG","","",N,N],[17,"ETH_P_CUST","","",N,N],[17,"ETH_P_SCA","","",N,N],[17,"ETH_P_TEB","","",N,N],[17,"ETH_P_RARP","","",N,N],[17,"ETH_P_ATALK","","",N,N],[17,"ETH_P_AARP","","",N,N],[17,"ETH_P_8021Q","","",N,N],[17,"ETH_P_IPX","","",N,N],[17,"ETH_P_IPV6","","",N,N],[17,"ETH_P_PAUSE","","",N,N],[17,"ETH_P_SLOW","","",N,N],[17,"ETH_P_WCCP","","",N,N],[17,"ETH_P_MPLS_UC","","",N,N],[17,"ETH_P_MPLS_MC","","",N,N],[17,"ETH_P_ATMMPOA","","",N,N],[17,"ETH_P_PPP_DISC","","",N,N],[17,"ETH_P_PPP_SES","","",N,N],[17,"ETH_P_LINK_CTL","","",N,N],[17,"ETH_P_ATMFATE","","",N,N],[17,"ETH_P_PAE","","",N,N],[17,"ETH_P_AOE","","",N,N],[17,"ETH_P_8021AD","","",N,N],[17,"ETH_P_802_EX1","","",N,N],[17,"ETH_P_TIPC","","",N,N],[17,"ETH_P_MACSEC","","",N,N],[17,"ETH_P_8021AH","","",N,N],[17,"ETH_P_MVRP","","",N,N],[17,"ETH_P_1588","","",N,N],[17,"ETH_P_PRP","","",N,N],[17,"ETH_P_FCOE","","",N,N],[17,"ETH_P_TDLS","","",N,N],[17,"ETH_P_FIP","","",N,N],[17,"ETH_P_80221","","",N,N],[17,"ETH_P_LOOPBACK","","",N,N],[17,"ETH_P_QINQ1","","",N,N],[17,"ETH_P_QINQ2","","",N,N],[17,"ETH_P_QINQ3","","",N,N],[17,"ETH_P_EDSA","","",N,N],[17,"ETH_P_AF_IUCV","","",N,N],[17,"ETH_P_802_3_MIN","","",N,N],[17,"ETH_P_802_3","","",N,N],[17,"ETH_P_AX25","","",N,N],[17,"ETH_P_ALL","","",N,N],[17,"ETH_P_802_2","","",N,N],[17,"ETH_P_SNAP","","",N,N],[17,"ETH_P_DDCMP","","",N,N],[17,"ETH_P_WAN_PPP","","",N,N],[17,"ETH_P_PPP_MP","","",N,N],[17,"ETH_P_LOCALTALK","","",N,N],[17,"ETH_P_CANFD","","",N,N],[17,"ETH_P_PPPTALK","","",N,N],[17,"ETH_P_TR_802_2","","",N,N],[17,"ETH_P_MOBITEX","","",N,N],[17,"ETH_P_CONTROL","","",N,N],[17,"ETH_P_IRDA","","",N,N],[17,"ETH_P_ECONET","","",N,N],[17,"ETH_P_HDLC","","",N,N],[17,"ETH_P_ARCNET","","",N,N],[17,"ETH_P_DSA","","",N,N],[17,"ETH_P_TRAILER","","",N,N],[17,"ETH_P_PHONET","","",N,N],[17,"ETH_P_IEEE802154","","",N,N],[17,"ETH_P_CAIF","","",N,N],[17,"POSIX_SPAWN_RESETIDS","","",N,N],[17,"POSIX_SPAWN_SETPGROUP","","",N,N],[17,"POSIX_SPAWN_SETSIGDEF","","",N,N],[17,"POSIX_SPAWN_SETSIGMASK","","",N,N],[17,"POSIX_SPAWN_SETSCHEDPARAM","","",N,N],[17,"POSIX_SPAWN_SETSCHEDULER","","",N,N],[17,"NLMSG_NOOP","","",N,N],[17,"NLMSG_ERROR","","",N,N],[17,"NLMSG_DONE","","",N,N],[17,"NLMSG_OVERRUN","","",N,N],[17,"NLMSG_MIN_TYPE","","",N,N],[17,"GENL_NAMSIZ","","",N,N],[17,"GENL_MIN_ID","","",N,N],[17,"GENL_MAX_ID","","",N,N],[17,"GENL_ADMIN_PERM","","",N,N],[17,"GENL_CMD_CAP_DO","","",N,N],[17,"GENL_CMD_CAP_DUMP","","",N,N],[17,"GENL_CMD_CAP_HASPOL","","",N,N],[17,"GENL_ID_CTRL","","",N,N],[17,"CTRL_CMD_UNSPEC","","",N,N],[17,"CTRL_CMD_NEWFAMILY","","",N,N],[17,"CTRL_CMD_DELFAMILY","","",N,N],[17,"CTRL_CMD_GETFAMILY","","",N,N],[17,"CTRL_CMD_NEWOPS","","",N,N],[17,"CTRL_CMD_DELOPS","","",N,N],[17,"CTRL_CMD_GETOPS","","",N,N],[17,"CTRL_CMD_NEWMCAST_GRP","","",N,N],[17,"CTRL_CMD_DELMCAST_GRP","","",N,N],[17,"CTRL_CMD_GETMCAST_GRP","","",N,N],[17,"CTRL_ATTR_UNSPEC","","",N,N],[17,"CTRL_ATTR_FAMILY_ID","","",N,N],[17,"CTRL_ATTR_FAMILY_NAME","","",N,N],[17,"CTRL_ATTR_VERSION","","",N,N],[17,"CTRL_ATTR_HDRSIZE","","",N,N],[17,"CTRL_ATTR_MAXATTR","","",N,N],[17,"CTRL_ATTR_OPS","","",N,N],[17,"CTRL_ATTR_MCAST_GROUPS","","",N,N],[17,"CTRL_ATTR_OP_UNSPEC","","",N,N],[17,"CTRL_ATTR_OP_ID","","",N,N],[17,"CTRL_ATTR_OP_FLAGS","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_UNSPEC","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_NAME","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_ID","","",N,N],[17,"PACKET_ADD_MEMBERSHIP","","",N,N],[17,"PACKET_DROP_MEMBERSHIP","","",N,N],[17,"PACKET_MR_MULTICAST","","",N,N],[17,"PACKET_MR_PROMISC","","",N,N],[17,"PACKET_MR_ALLMULTI","","",N,N],[17,"PACKET_MR_UNICAST","","",N,N],[17,"NF_DROP","","",N,N],[17,"NF_ACCEPT","","",N,N],[17,"NF_STOLEN","","",N,N],[17,"NF_QUEUE","","",N,N],[17,"NF_REPEAT","","",N,N],[17,"NF_STOP","","",N,N],[17,"NF_MAX_VERDICT","","",N,N],[17,"NF_VERDICT_MASK","","",N,N],[17,"NF_VERDICT_FLAG_QUEUE_BYPASS","","",N,N],[17,"NF_VERDICT_QMASK","","",N,N],[17,"NF_VERDICT_QBITS","","",N,N],[17,"NF_VERDICT_BITS","","",N,N],[17,"NF_INET_PRE_ROUTING","","",N,N],[17,"NF_INET_LOCAL_IN","","",N,N],[17,"NF_INET_FORWARD","","",N,N],[17,"NF_INET_LOCAL_OUT","","",N,N],[17,"NF_INET_POST_ROUTING","","",N,N],[17,"NF_INET_NUMHOOKS","","",N,N],[17,"NFPROTO_UNSPEC","","",N,N],[17,"NFPROTO_IPV4","","",N,N],[17,"NFPROTO_ARP","","",N,N],[17,"NFPROTO_BRIDGE","","",N,N],[17,"NFPROTO_IPV6","","",N,N],[17,"NFPROTO_DECNET","","",N,N],[17,"NFPROTO_NUMPROTO","","",N,N],[17,"NF_IP_PRE_ROUTING","","",N,N],[17,"NF_IP_LOCAL_IN","","",N,N],[17,"NF_IP_FORWARD","","",N,N],[17,"NF_IP_LOCAL_OUT","","",N,N],[17,"NF_IP_POST_ROUTING","","",N,N],[17,"NF_IP_NUMHOOKS","","",N,N],[17,"NF_IP_PRI_FIRST","","",N,N],[17,"NF_IP_PRI_CONNTRACK_DEFRAG","","",N,N],[17,"NF_IP_PRI_RAW","","",N,N],[17,"NF_IP_PRI_SELINUX_FIRST","","",N,N],[17,"NF_IP_PRI_CONNTRACK","","",N,N],[17,"NF_IP_PRI_MANGLE","","",N,N],[17,"NF_IP_PRI_NAT_DST","","",N,N],[17,"NF_IP_PRI_FILTER","","",N,N],[17,"NF_IP_PRI_SECURITY","","",N,N],[17,"NF_IP_PRI_NAT_SRC","","",N,N],[17,"NF_IP_PRI_SELINUX_LAST","","",N,N],[17,"NF_IP_PRI_CONNTRACK_HELPER","","",N,N],[17,"NF_IP_PRI_CONNTRACK_CONFIRM","","",N,N],[17,"NF_IP_PRI_LAST","","",N,N],[17,"NF_IP6_PRE_ROUTING","","",N,N],[17,"NF_IP6_LOCAL_IN","","",N,N],[17,"NF_IP6_FORWARD","","",N,N],[17,"NF_IP6_LOCAL_OUT","","",N,N],[17,"NF_IP6_POST_ROUTING","","",N,N],[17,"NF_IP6_NUMHOOKS","","",N,N],[17,"NF_IP6_PRI_FIRST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK_DEFRAG","","",N,N],[17,"NF_IP6_PRI_RAW","","",N,N],[17,"NF_IP6_PRI_SELINUX_FIRST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK","","",N,N],[17,"NF_IP6_PRI_MANGLE","","",N,N],[17,"NF_IP6_PRI_NAT_DST","","",N,N],[17,"NF_IP6_PRI_FILTER","","",N,N],[17,"NF_IP6_PRI_SECURITY","","",N,N],[17,"NF_IP6_PRI_NAT_SRC","","",N,N],[17,"NF_IP6_PRI_SELINUX_LAST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK_HELPER","","",N,N],[17,"NF_IP6_PRI_LAST","","",N,N],[17,"SIOCADDRT","","",N,N],[17,"SIOCDELRT","","",N,N],[17,"SIOCGIFNAME","","",N,N],[17,"SIOCSIFLINK","","",N,N],[17,"SIOCGIFCONF","","",N,N],[17,"SIOCGIFFLAGS","","",N,N],[17,"SIOCSIFFLAGS","","",N,N],[17,"SIOCGIFADDR","","",N,N],[17,"SIOCSIFADDR","","",N,N],[17,"SIOCGIFDSTADDR","","",N,N],[17,"SIOCSIFDSTADDR","","",N,N],[17,"SIOCGIFBRDADDR","","",N,N],[17,"SIOCSIFBRDADDR","","",N,N],[17,"SIOCGIFNETMASK","","",N,N],[17,"SIOCSIFNETMASK","","",N,N],[17,"SIOCGIFMETRIC","","",N,N],[17,"SIOCSIFMETRIC","","",N,N],[17,"SIOCGIFMEM","","",N,N],[17,"SIOCSIFMEM","","",N,N],[17,"SIOCGIFMTU","","",N,N],[17,"SIOCSIFMTU","","",N,N],[17,"SIOCSIFHWADDR","","",N,N],[17,"SIOCGIFENCAP","","",N,N],[17,"SIOCSIFENCAP","","",N,N],[17,"SIOCGIFHWADDR","","",N,N],[17,"SIOCGIFSLAVE","","",N,N],[17,"SIOCSIFSLAVE","","",N,N],[17,"SIOCADDMULTI","","",N,N],[17,"SIOCDELMULTI","","",N,N],[17,"SIOCDARP","","",N,N],[17,"SIOCGARP","","",N,N],[17,"SIOCSARP","","",N,N],[17,"SIOCDRARP","","",N,N],[17,"SIOCGRARP","","",N,N],[17,"SIOCSRARP","","",N,N],[17,"SIOCGIFMAP","","",N,N],[17,"SIOCSIFMAP","","",N,N],[17,"IPTOS_TOS_MASK","","",N,N],[17,"IPTOS_PREC_MASK","","",N,N],[17,"RTF_UP","","",N,N],[17,"RTF_GATEWAY","","",N,N],[17,"RTF_HOST","","",N,N],[17,"RTF_REINSTATE","","",N,N],[17,"RTF_DYNAMIC","","",N,N],[17,"RTF_MODIFIED","","",N,N],[17,"RTF_MTU","","",N,N],[17,"RTF_MSS","","",N,N],[17,"RTF_WINDOW","","",N,N],[17,"RTF_IRTT","","",N,N],[17,"RTF_REJECT","","",N,N],[17,"RTF_STATIC","","",N,N],[17,"RTF_XRESOLVE","","",N,N],[17,"RTF_NOFORWARD","","",N,N],[17,"RTF_THROW","","",N,N],[17,"RTF_NOPMTUDISC","","",N,N],[17,"RTF_DEFAULT","","",N,N],[17,"RTF_ALLONLINK","","",N,N],[17,"RTF_ADDRCONF","","",N,N],[17,"RTF_LINKRT","","",N,N],[17,"RTF_NONEXTHOP","","",N,N],[17,"RTF_CACHE","","",N,N],[17,"RTF_FLOW","","",N,N],[17,"RTF_POLICY","","",N,N],[17,"RTCF_VALVE","","",N,N],[17,"RTCF_MASQ","","",N,N],[17,"RTCF_NAT","","",N,N],[17,"RTCF_DOREDIRECT","","",N,N],[17,"RTCF_LOG","","",N,N],[17,"RTCF_DIRECTSRC","","",N,N],[17,"RTF_LOCAL","","",N,N],[17,"RTF_INTERFACE","","",N,N],[17,"RTF_MULTICAST","","",N,N],[17,"RTF_BROADCAST","","",N,N],[17,"RTF_NAT","","",N,N],[17,"RTF_ADDRCLASSMASK","","",N,N],[17,"RT_CLASS_UNSPEC","","",N,N],[17,"RT_CLASS_DEFAULT","","",N,N],[17,"RT_CLASS_MAIN","","",N,N],[17,"RT_CLASS_LOCAL","","",N,N],[17,"RT_CLASS_MAX","","",N,N],[17,"RTMSG_OVERRUN","","",N,N],[17,"RTMSG_NEWDEVICE","","",N,N],[17,"RTMSG_DELDEVICE","","",N,N],[17,"RTMSG_NEWROUTE","","",N,N],[17,"RTMSG_DELROUTE","","",N,N],[17,"RTMSG_NEWRULE","","",N,N],[17,"RTMSG_DELRULE","","",N,N],[17,"RTMSG_CONTROL","","",N,N],[17,"RTMSG_AR_FAILED","","",N,N],[17,"MAX_ADDR_LEN","","",N,N],[17,"ARPD_UPDATE","","",N,N],[17,"ARPD_LOOKUP","","",N,N],[17,"ARPD_FLUSH","","",N,N],[17,"ATF_MAGIC","","",N,N],[17,"MODULE_INIT_IGNORE_MODVERSIONS","","",N,N],[17,"MODULE_INIT_IGNORE_VERMAGIC","","",N,N],[17,"__UT_LINESIZE","","",N,N],[17,"__UT_NAMESIZE","","",N,N],[17,"__UT_HOSTSIZE","","",N,N],[17,"EMPTY","","",N,N],[17,"RUN_LVL","","",N,N],[17,"BOOT_TIME","","",N,N],[17,"NEW_TIME","","",N,N],[17,"OLD_TIME","","",N,N],[17,"INIT_PROCESS","","",N,N],[17,"LOGIN_PROCESS","","",N,N],[17,"USER_PROCESS","","",N,N],[17,"DEAD_PROCESS","","",N,N],[17,"ACCOUNTING","","",N,N],[17,"RLIMIT_RSS","","",N,N],[17,"RLIMIT_AS","","",N,N],[17,"RLIMIT_MEMLOCK","","",N,N],[17,"RLIM_INFINITY","","",N,N],[17,"RLIMIT_RTTIME","","",N,N],[17,"RLIMIT_NLIMITS","","",N,N],[17,"SOCK_NONBLOCK","","",N,N],[17,"SOL_RXRPC","","",N,N],[17,"SOL_PPPOL2TP","","",N,N],[17,"SOL_BLUETOOTH","","",N,N],[17,"SOL_PNPIPE","","",N,N],[17,"SOL_RDS","","",N,N],[17,"SOL_IUCV","","",N,N],[17,"SOL_CAIF","","",N,N],[17,"SOL_ALG","","",N,N],[17,"SOL_NFC","","",N,N],[17,"MSG_TRYHARD","","",N,N],[17,"LC_PAPER","","",N,N],[17,"LC_NAME","","",N,N],[17,"LC_ADDRESS","","",N,N],[17,"LC_TELEPHONE","","",N,N],[17,"LC_MEASUREMENT","","",N,N],[17,"LC_IDENTIFICATION","","",N,N],[17,"LC_PAPER_MASK","","",N,N],[17,"LC_NAME_MASK","","",N,N],[17,"LC_ADDRESS_MASK","","",N,N],[17,"LC_TELEPHONE_MASK","","",N,N],[17,"LC_MEASUREMENT_MASK","","",N,N],[17,"LC_IDENTIFICATION_MASK","","",N,N],[17,"LC_ALL_MASK","","",N,N],[17,"MAP_ANON","","",N,N],[17,"MAP_ANONYMOUS","","",N,N],[17,"MAP_DENYWRITE","","",N,N],[17,"MAP_EXECUTABLE","","",N,N],[17,"MAP_POPULATE","","",N,N],[17,"MAP_NONBLOCK","","",N,N],[17,"MAP_STACK","","",N,N],[17,"ENOTSUP","","",N,N],[17,"EUCLEAN","","",N,N],[17,"ENOTNAM","","",N,N],[17,"ENAVAIL","","",N,N],[17,"EISNAM","","",N,N],[17,"EREMOTEIO","","",N,N],[17,"SOCK_STREAM","","",N,N],[17,"SOCK_DGRAM","","",N,N],[17,"SOCK_SEQPACKET","","",N,N],[17,"SOCK_DCCP","","",N,N],[17,"SOCK_PACKET","","",N,N],[17,"TCP_COOKIE_TRANSACTIONS","","",N,N],[17,"TCP_THIN_LINEAR_TIMEOUTS","","",N,N],[17,"TCP_THIN_DUPACK","","",N,N],[17,"TCP_USER_TIMEOUT","","",N,N],[17,"TCP_REPAIR","","",N,N],[17,"TCP_REPAIR_QUEUE","","",N,N],[17,"TCP_QUEUE_SEQ","","",N,N],[17,"TCP_REPAIR_OPTIONS","","",N,N],[17,"TCP_FASTOPEN","","",N,N],[17,"TCP_TIMESTAMP","","",N,N],[17,"DCCP_SOCKOPT_PACKET_SIZE","","",N,N],[17,"DCCP_SOCKOPT_SERVICE","","",N,N],[17,"DCCP_SOCKOPT_CHANGE_L","","",N,N],[17,"DCCP_SOCKOPT_CHANGE_R","","",N,N],[17,"DCCP_SOCKOPT_GET_CUR_MPS","","",N,N],[17,"DCCP_SOCKOPT_SERVER_TIMEWAIT","","",N,N],[17,"DCCP_SOCKOPT_SEND_CSCOV","","",N,N],[17,"DCCP_SOCKOPT_RECV_CSCOV","","",N,N],[17,"DCCP_SOCKOPT_AVAILABLE_CCIDS","","",N,N],[17,"DCCP_SOCKOPT_CCID","","",N,N],[17,"DCCP_SOCKOPT_TX_CCID","","",N,N],[17,"DCCP_SOCKOPT_RX_CCID","","",N,N],[17,"DCCP_SOCKOPT_QPOLICY_ID","","",N,N],[17,"DCCP_SOCKOPT_QPOLICY_TXQLEN","","",N,N],[17,"DCCP_SOCKOPT_CCID_RX_INFO","","",N,N],[17,"DCCP_SOCKOPT_CCID_TX_INFO","","",N,N],[17,"DCCP_SERVICE_LIST_MAX_LEN","","maximum number of services provided on the same listening port",N,N],[17,"SIGTTIN","","",N,N],[17,"SIGTTOU","","",N,N],[17,"SIGXCPU","","",N,N],[17,"SIGXFSZ","","",N,N],[17,"SIGVTALRM","","",N,N],[17,"SIGPROF","","",N,N],[17,"SIGWINCH","","",N,N],[17,"SIGEV_THREAD_ID","","",N,N],[17,"BUFSIZ","","",N,N],[17,"TMP_MAX","","",N,N],[17,"FOPEN_MAX","","",N,N],[17,"POSIX_FADV_DONTNEED","","",N,N],[17,"POSIX_FADV_NOREUSE","","",N,N],[17,"POSIX_MADV_DONTNEED","","",N,N],[17,"_SC_EQUIV_CLASS_MAX","","",N,N],[17,"_SC_CHARCLASS_NAME_MAX","","",N,N],[17,"_SC_PII","","",N,N],[17,"_SC_PII_XTI","","",N,N],[17,"_SC_PII_SOCKET","","",N,N],[17,"_SC_PII_INTERNET","","",N,N],[17,"_SC_PII_OSI","","",N,N],[17,"_SC_POLL","","",N,N],[17,"_SC_SELECT","","",N,N],[17,"_SC_PII_INTERNET_STREAM","","",N,N],[17,"_SC_PII_INTERNET_DGRAM","","",N,N],[17,"_SC_PII_OSI_COTS","","",N,N],[17,"_SC_PII_OSI_CLTS","","",N,N],[17,"_SC_PII_OSI_M","","",N,N],[17,"_SC_T_IOV_MAX","","",N,N],[17,"_SC_2_C_VERSION","","",N,N],[17,"_SC_CHAR_BIT","","",N,N],[17,"_SC_CHAR_MAX","","",N,N],[17,"_SC_CHAR_MIN","","",N,N],[17,"_SC_INT_MAX","","",N,N],[17,"_SC_INT_MIN","","",N,N],[17,"_SC_LONG_BIT","","",N,N],[17,"_SC_WORD_BIT","","",N,N],[17,"_SC_MB_LEN_MAX","","",N,N],[17,"_SC_SSIZE_MAX","","",N,N],[17,"_SC_SCHAR_MAX","","",N,N],[17,"_SC_SCHAR_MIN","","",N,N],[17,"_SC_SHRT_MAX","","",N,N],[17,"_SC_SHRT_MIN","","",N,N],[17,"_SC_UCHAR_MAX","","",N,N],[17,"_SC_UINT_MAX","","",N,N],[17,"_SC_ULONG_MAX","","",N,N],[17,"_SC_USHRT_MAX","","",N,N],[17,"_SC_NL_ARGMAX","","",N,N],[17,"_SC_NL_LANGMAX","","",N,N],[17,"_SC_NL_MSGMAX","","",N,N],[17,"_SC_NL_NMAX","","",N,N],[17,"_SC_NL_SETMAX","","",N,N],[17,"_SC_NL_TEXTMAX","","",N,N],[17,"_SC_BASE","","",N,N],[17,"_SC_C_LANG_SUPPORT","","",N,N],[17,"_SC_C_LANG_SUPPORT_R","","",N,N],[17,"_SC_DEVICE_IO","","",N,N],[17,"_SC_DEVICE_SPECIFIC","","",N,N],[17,"_SC_DEVICE_SPECIFIC_R","","",N,N],[17,"_SC_FD_MGMT","","",N,N],[17,"_SC_FIFO","","",N,N],[17,"_SC_PIPE","","",N,N],[17,"_SC_FILE_ATTRIBUTES","","",N,N],[17,"_SC_FILE_LOCKING","","",N,N],[17,"_SC_FILE_SYSTEM","","",N,N],[17,"_SC_MULTI_PROCESS","","",N,N],[17,"_SC_SINGLE_PROCESS","","",N,N],[17,"_SC_NETWORKING","","",N,N],[17,"_SC_REGEX_VERSION","","",N,N],[17,"_SC_SIGNALS","","",N,N],[17,"_SC_SYSTEM_DATABASE","","",N,N],[17,"_SC_SYSTEM_DATABASE_R","","",N,N],[17,"_SC_USER_GROUPS","","",N,N],[17,"_SC_USER_GROUPS_R","","",N,N],[17,"_SC_LEVEL1_ICACHE_SIZE","","",N,N],[17,"_SC_LEVEL1_ICACHE_ASSOC","","",N,N],[17,"_SC_LEVEL1_ICACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL1_DCACHE_SIZE","","",N,N],[17,"_SC_LEVEL1_DCACHE_ASSOC","","",N,N],[17,"_SC_LEVEL1_DCACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL2_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL2_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL2_CACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL3_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL3_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL3_CACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL4_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL4_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL4_CACHE_LINESIZE","","",N,N],[17,"O_ACCMODE","","",N,N],[17,"ST_RELATIME","","",N,N],[17,"NI_MAXHOST","","",N,N],[17,"ADFS_SUPER_MAGIC","","",N,N],[17,"AFFS_SUPER_MAGIC","","",N,N],[17,"CODA_SUPER_MAGIC","","",N,N],[17,"CRAMFS_MAGIC","","",N,N],[17,"EFS_SUPER_MAGIC","","",N,N],[17,"EXT2_SUPER_MAGIC","","",N,N],[17,"EXT3_SUPER_MAGIC","","",N,N],[17,"EXT4_SUPER_MAGIC","","",N,N],[17,"HPFS_SUPER_MAGIC","","",N,N],[17,"HUGETLBFS_MAGIC","","",N,N],[17,"ISOFS_SUPER_MAGIC","","",N,N],[17,"JFFS2_SUPER_MAGIC","","",N,N],[17,"MINIX_SUPER_MAGIC","","",N,N],[17,"MINIX_SUPER_MAGIC2","","",N,N],[17,"MINIX2_SUPER_MAGIC","","",N,N],[17,"MINIX2_SUPER_MAGIC2","","",N,N],[17,"MSDOS_SUPER_MAGIC","","",N,N],[17,"NCP_SUPER_MAGIC","","",N,N],[17,"NFS_SUPER_MAGIC","","",N,N],[17,"OPENPROM_SUPER_MAGIC","","",N,N],[17,"PROC_SUPER_MAGIC","","",N,N],[17,"QNX4_SUPER_MAGIC","","",N,N],[17,"REISERFS_SUPER_MAGIC","","",N,N],[17,"SMB_SUPER_MAGIC","","",N,N],[17,"TMPFS_MAGIC","","",N,N],[17,"USBDEVICE_SUPER_MAGIC","","",N,N],[17,"VEOF","","",N,N],[17,"CPU_SETSIZE","","",N,N],[17,"PTRACE_TRACEME","","",N,N],[17,"PTRACE_PEEKTEXT","","",N,N],[17,"PTRACE_PEEKDATA","","",N,N],[17,"PTRACE_PEEKUSER","","",N,N],[17,"PTRACE_POKETEXT","","",N,N],[17,"PTRACE_POKEDATA","","",N,N],[17,"PTRACE_POKEUSER","","",N,N],[17,"PTRACE_CONT","","",N,N],[17,"PTRACE_KILL","","",N,N],[17,"PTRACE_SINGLESTEP","","",N,N],[17,"PTRACE_ATTACH","","",N,N],[17,"PTRACE_SYSCALL","","",N,N],[17,"PTRACE_SETOPTIONS","","",N,N],[17,"PTRACE_GETEVENTMSG","","",N,N],[17,"PTRACE_GETSIGINFO","","",N,N],[17,"PTRACE_SETSIGINFO","","",N,N],[17,"PTRACE_GETREGSET","","",N,N],[17,"PTRACE_SETREGSET","","",N,N],[17,"PTRACE_SEIZE","","",N,N],[17,"PTRACE_INTERRUPT","","",N,N],[17,"PTRACE_LISTEN","","",N,N],[17,"PTRACE_PEEKSIGINFO","","",N,N],[17,"EPOLLWAKEUP","","",N,N],[17,"MAP_HUGETLB","","",N,N],[17,"SEEK_DATA","","",N,N],[17,"SEEK_HOLE","","",N,N],[17,"TCSANOW","","",N,N],[17,"TCSADRAIN","","",N,N],[17,"TCSAFLUSH","","",N,N],[17,"TIOCLINUX","","",N,N],[17,"TIOCGSERIAL","","",N,N],[17,"RTLD_DEEPBIND","","",N,N],[17,"RTLD_GLOBAL","","",N,N],[17,"RTLD_NOLOAD","","",N,N],[17,"LINUX_REBOOT_MAGIC1","","",N,N],[17,"LINUX_REBOOT_MAGIC2","","",N,N],[17,"LINUX_REBOOT_MAGIC2A","","",N,N],[17,"LINUX_REBOOT_MAGIC2B","","",N,N],[17,"LINUX_REBOOT_MAGIC2C","","",N,N],[17,"LINUX_REBOOT_CMD_RESTART","","",N,N],[17,"LINUX_REBOOT_CMD_HALT","","",N,N],[17,"LINUX_REBOOT_CMD_CAD_ON","","",N,N],[17,"LINUX_REBOOT_CMD_CAD_OFF","","",N,N],[17,"LINUX_REBOOT_CMD_POWER_OFF","","",N,N],[17,"LINUX_REBOOT_CMD_RESTART2","","",N,N],[17,"LINUX_REBOOT_CMD_SW_SUSPEND","","",N,N],[17,"LINUX_REBOOT_CMD_KEXEC","","",N,N],[17,"NETLINK_ROUTE","","",N,N],[17,"NETLINK_UNUSED","","",N,N],[17,"NETLINK_USERSOCK","","",N,N],[17,"NETLINK_FIREWALL","","",N,N],[17,"NETLINK_SOCK_DIAG","","",N,N],[17,"NETLINK_NFLOG","","",N,N],[17,"NETLINK_XFRM","","",N,N],[17,"NETLINK_SELINUX","","",N,N],[17,"NETLINK_ISCSI","","",N,N],[17,"NETLINK_AUDIT","","",N,N],[17,"NETLINK_FIB_LOOKUP","","",N,N],[17,"NETLINK_CONNECTOR","","",N,N],[17,"NETLINK_NETFILTER","","",N,N],[17,"NETLINK_IP6_FW","","",N,N],[17,"NETLINK_DNRTMSG","","",N,N],[17,"NETLINK_KOBJECT_UEVENT","","",N,N],[17,"NETLINK_GENERIC","","",N,N],[17,"NETLINK_SCSITRANSPORT","","",N,N],[17,"NETLINK_ECRYPTFS","","",N,N],[17,"NETLINK_RDMA","","",N,N],[17,"NETLINK_CRYPTO","","",N,N],[17,"NETLINK_INET_DIAG","","",N,N],[17,"MAX_LINKS","","",N,N],[17,"NLM_F_REQUEST","","",N,N],[17,"NLM_F_MULTI","","",N,N],[17,"NLM_F_ACK","","",N,N],[17,"NLM_F_ECHO","","",N,N],[17,"NLM_F_DUMP_INTR","","",N,N],[17,"NLM_F_DUMP_FILTERED","","",N,N],[17,"NLM_F_ROOT","","",N,N],[17,"NLM_F_MATCH","","",N,N],[17,"NLM_F_ATOMIC","","",N,N],[17,"NLM_F_DUMP","","",N,N],[17,"NLM_F_REPLACE","","",N,N],[17,"NLM_F_EXCL","","",N,N],[17,"NLM_F_CREATE","","",N,N],[17,"NLM_F_APPEND","","",N,N],[17,"NETLINK_ADD_MEMBERSHIP","","",N,N],[17,"NETLINK_DROP_MEMBERSHIP","","",N,N],[17,"NETLINK_PKTINFO","","",N,N],[17,"NETLINK_BROADCAST_ERROR","","",N,N],[17,"NETLINK_NO_ENOBUFS","","",N,N],[17,"NETLINK_RX_RING","","",N,N],[17,"NETLINK_TX_RING","","",N,N],[17,"NETLINK_LISTEN_ALL_NSID","","",N,N],[17,"NETLINK_LIST_MEMBERSHIPS","","",N,N],[17,"NETLINK_CAP_ACK","","",N,N],[17,"NLA_F_NESTED","","",N,N],[17,"NLA_F_NET_BYTEORDER","","",N,N],[17,"NLA_TYPE_MASK","","",N,N],[17,"NLA_ALIGNTO","","",N,N],[17,"GENL_UNS_ADMIN_PERM","","",N,N],[17,"GENL_ID_VFS_DQUOT","","",N,N],[17,"GENL_ID_PMCRAID","","",N,N],[17,"TIOCM_LE","","",N,N],[17,"TIOCM_DTR","","",N,N],[17,"TIOCM_RTS","","",N,N],[17,"TIOCM_ST","","",N,N],[17,"TIOCM_SR","","",N,N],[17,"TIOCM_CTS","","",N,N],[17,"TIOCM_CAR","","",N,N],[17,"TIOCM_RNG","","",N,N],[17,"TIOCM_DSR","","",N,N],[17,"TIOCM_CD","","",N,N],[17,"TIOCM_RI","","",N,N],[17,"NF_NETDEV_INGRESS","","",N,N],[17,"NF_NETDEV_NUMHOOKS","","",N,N],[17,"NFPROTO_INET","","",N,N],[17,"NFPROTO_NETDEV","","",N,N],[17,"NFT_TABLE_MAXNAMELEN","","",N,N],[17,"NFT_CHAIN_MAXNAMELEN","","",N,N],[17,"NFT_SET_MAXNAMELEN","","",N,N],[17,"NFT_OBJ_MAXNAMELEN","","",N,N],[17,"NFT_USERDATA_MAXLEN","","",N,N],[17,"NFT_REG_VERDICT","","",N,N],[17,"NFT_REG_1","","",N,N],[17,"NFT_REG_2","","",N,N],[17,"NFT_REG_3","","",N,N],[17,"NFT_REG_4","","",N,N],[17,"__NFT_REG_MAX","","",N,N],[17,"NFT_REG32_00","","",N,N],[17,"NFT_REG32_01","","",N,N],[17,"NFT_REG32_02","","",N,N],[17,"NFT_REG32_03","","",N,N],[17,"NFT_REG32_04","","",N,N],[17,"NFT_REG32_05","","",N,N],[17,"NFT_REG32_06","","",N,N],[17,"NFT_REG32_07","","",N,N],[17,"NFT_REG32_08","","",N,N],[17,"NFT_REG32_09","","",N,N],[17,"NFT_REG32_10","","",N,N],[17,"NFT_REG32_11","","",N,N],[17,"NFT_REG32_12","","",N,N],[17,"NFT_REG32_13","","",N,N],[17,"NFT_REG32_14","","",N,N],[17,"NFT_REG32_15","","",N,N],[17,"NFT_REG_SIZE","","",N,N],[17,"NFT_REG32_SIZE","","",N,N],[17,"NFT_CONTINUE","","",N,N],[17,"NFT_BREAK","","",N,N],[17,"NFT_JUMP","","",N,N],[17,"NFT_GOTO","","",N,N],[17,"NFT_RETURN","","",N,N],[17,"NFT_MSG_NEWTABLE","","",N,N],[17,"NFT_MSG_GETTABLE","","",N,N],[17,"NFT_MSG_DELTABLE","","",N,N],[17,"NFT_MSG_NEWCHAIN","","",N,N],[17,"NFT_MSG_GETCHAIN","","",N,N],[17,"NFT_MSG_DELCHAIN","","",N,N],[17,"NFT_MSG_NEWRULE","","",N,N],[17,"NFT_MSG_GETRULE","","",N,N],[17,"NFT_MSG_DELRULE","","",N,N],[17,"NFT_MSG_NEWSET","","",N,N],[17,"NFT_MSG_GETSET","","",N,N],[17,"NFT_MSG_DELSET","","",N,N],[17,"NFT_MSG_NEWSETELEM","","",N,N],[17,"NFT_MSG_GETSETELEM","","",N,N],[17,"NFT_MSG_DELSETELEM","","",N,N],[17,"NFT_MSG_NEWGEN","","",N,N],[17,"NFT_MSG_GETGEN","","",N,N],[17,"NFT_MSG_TRACE","","",N,N],[17,"NFT_MSG_NEWOBJ","","",N,N],[17,"NFT_MSG_GETOBJ","","",N,N],[17,"NFT_MSG_DELOBJ","","",N,N],[17,"NFT_MSG_GETOBJ_RESET","","",N,N],[17,"NFT_MSG_MAX","","",N,N],[17,"NFT_SET_ANONYMOUS","","",N,N],[17,"NFT_SET_CONSTANT","","",N,N],[17,"NFT_SET_INTERVAL","","",N,N],[17,"NFT_SET_MAP","","",N,N],[17,"NFT_SET_TIMEOUT","","",N,N],[17,"NFT_SET_EVAL","","",N,N],[17,"NFT_SET_POL_PERFORMANCE","","",N,N],[17,"NFT_SET_POL_MEMORY","","",N,N],[17,"NFT_SET_ELEM_INTERVAL_END","","",N,N],[17,"NFT_DATA_VALUE","","",N,N],[17,"NFT_DATA_VERDICT","","",N,N],[17,"NFT_DATA_RESERVED_MASK","","",N,N],[17,"NFT_DATA_VALUE_MAXLEN","","",N,N],[17,"NFT_BYTEORDER_NTOH","","",N,N],[17,"NFT_BYTEORDER_HTON","","",N,N],[17,"NFT_CMP_EQ","","",N,N],[17,"NFT_CMP_NEQ","","",N,N],[17,"NFT_CMP_LT","","",N,N],[17,"NFT_CMP_LTE","","",N,N],[17,"NFT_CMP_GT","","",N,N],[17,"NFT_CMP_GTE","","",N,N],[17,"NFT_RANGE_EQ","","",N,N],[17,"NFT_RANGE_NEQ","","",N,N],[17,"NFT_LOOKUP_F_INV","","",N,N],[17,"NFT_DYNSET_OP_ADD","","",N,N],[17,"NFT_DYNSET_OP_UPDATE","","",N,N],[17,"NFT_DYNSET_F_INV","","",N,N],[17,"NFT_PAYLOAD_LL_HEADER","","",N,N],[17,"NFT_PAYLOAD_NETWORK_HEADER","","",N,N],[17,"NFT_PAYLOAD_TRANSPORT_HEADER","","",N,N],[17,"NFT_PAYLOAD_CSUM_NONE","","",N,N],[17,"NFT_PAYLOAD_CSUM_INET","","",N,N],[17,"NFT_META_LEN","","",N,N],[17,"NFT_META_PROTOCOL","","",N,N],[17,"NFT_META_PRIORITY","","",N,N],[17,"NFT_META_MARK","","",N,N],[17,"NFT_META_IIF","","",N,N],[17,"NFT_META_OIF","","",N,N],[17,"NFT_META_IIFNAME","","",N,N],[17,"NFT_META_OIFNAME","","",N,N],[17,"NFT_META_IIFTYPE","","",N,N],[17,"NFT_META_OIFTYPE","","",N,N],[17,"NFT_META_SKUID","","",N,N],[17,"NFT_META_SKGID","","",N,N],[17,"NFT_META_NFTRACE","","",N,N],[17,"NFT_META_RTCLASSID","","",N,N],[17,"NFT_META_SECMARK","","",N,N],[17,"NFT_META_NFPROTO","","",N,N],[17,"NFT_META_L4PROTO","","",N,N],[17,"NFT_META_BRI_IIFNAME","","",N,N],[17,"NFT_META_BRI_OIFNAME","","",N,N],[17,"NFT_META_PKTTYPE","","",N,N],[17,"NFT_META_CPU","","",N,N],[17,"NFT_META_IIFGROUP","","",N,N],[17,"NFT_META_OIFGROUP","","",N,N],[17,"NFT_META_CGROUP","","",N,N],[17,"NFT_META_PRANDOM","","",N,N],[17,"NFT_CT_STATE","","",N,N],[17,"NFT_CT_DIRECTION","","",N,N],[17,"NFT_CT_STATUS","","",N,N],[17,"NFT_CT_MARK","","",N,N],[17,"NFT_CT_SECMARK","","",N,N],[17,"NFT_CT_EXPIRATION","","",N,N],[17,"NFT_CT_HELPER","","",N,N],[17,"NFT_CT_L3PROTOCOL","","",N,N],[17,"NFT_CT_SRC","","",N,N],[17,"NFT_CT_DST","","",N,N],[17,"NFT_CT_PROTOCOL","","",N,N],[17,"NFT_CT_PROTO_SRC","","",N,N],[17,"NFT_CT_PROTO_DST","","",N,N],[17,"NFT_CT_LABELS","","",N,N],[17,"NFT_CT_PKTS","","",N,N],[17,"NFT_CT_BYTES","","",N,N],[17,"NFT_LIMIT_PKTS","","",N,N],[17,"NFT_LIMIT_PKT_BYTES","","",N,N],[17,"NFT_LIMIT_F_INV","","",N,N],[17,"NFT_QUEUE_FLAG_BYPASS","","",N,N],[17,"NFT_QUEUE_FLAG_CPU_FANOUT","","",N,N],[17,"NFT_QUEUE_FLAG_MASK","","",N,N],[17,"NFT_QUOTA_F_INV","","",N,N],[17,"NFT_REJECT_ICMP_UNREACH","","",N,N],[17,"NFT_REJECT_TCP_RST","","",N,N],[17,"NFT_REJECT_ICMPX_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_NO_ROUTE","","",N,N],[17,"NFT_REJECT_ICMPX_PORT_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_HOST_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_ADMIN_PROHIBITED","","",N,N],[17,"NFT_NAT_SNAT","","",N,N],[17,"NFT_NAT_DNAT","","",N,N],[17,"NFT_TRACETYPE_UNSPEC","","",N,N],[17,"NFT_TRACETYPE_POLICY","","",N,N],[17,"NFT_TRACETYPE_RETURN","","",N,N],[17,"NFT_TRACETYPE_RULE","","",N,N],[17,"NFT_NG_INCREMENTAL","","",N,N],[17,"NFT_NG_RANDOM","","",N,N],[17,"AF_MAX","","",N,N],[17,"PF_MAX","","",N,N],[17,"PTHREAD_STACK_MIN","","",N,N],[17,"PTHREAD_MUTEX_ADAPTIVE_NP","","",N,N],[17,"__SIZEOF_PTHREAD_RWLOCKATTR_T","","",N,N],[17,"O_LARGEFILE","","",N,N],[17,"TIOCGSOFTCAR","","",N,N],[17,"TIOCSSOFTCAR","","",N,N],[17,"RLIMIT_NOFILE","","",N,N],[17,"RLIMIT_NPROC","","",N,N],[17,"O_APPEND","","",N,N],[17,"O_CREAT","","",N,N],[17,"O_EXCL","","",N,N],[17,"O_NOCTTY","","",N,N],[17,"O_NONBLOCK","","",N,N],[17,"O_SYNC","","",N,N],[17,"O_RSYNC","","",N,N],[17,"O_DSYNC","","",N,N],[17,"O_FSYNC","","",N,N],[17,"O_NOATIME","","",N,N],[17,"O_PATH","","",N,N],[17,"O_TMPFILE","","",N,N],[17,"MAP_GROWSDOWN","","",N,N],[17,"EDEADLK","","",N,N],[17,"ENAMETOOLONG","","",N,N],[17,"ENOLCK","","",N,N],[17,"ENOSYS","","",N,N],[17,"ENOTEMPTY","","",N,N],[17,"ELOOP","","",N,N],[17,"ENOMSG","","",N,N],[17,"EIDRM","","",N,N],[17,"ECHRNG","","",N,N],[17,"EL2NSYNC","","",N,N],[17,"EL3HLT","","",N,N],[17,"EL3RST","","",N,N],[17,"ELNRNG","","",N,N],[17,"EUNATCH","","",N,N],[17,"ENOCSI","","",N,N],[17,"EL2HLT","","",N,N],[17,"EBADE","","",N,N],[17,"EBADR","","",N,N],[17,"EXFULL","","",N,N],[17,"ENOANO","","",N,N],[17,"EBADRQC","","",N,N],[17,"EBADSLT","","",N,N],[17,"EMULTIHOP","","",N,N],[17,"EOVERFLOW","","",N,N],[17,"ENOTUNIQ","","",N,N],[17,"EBADFD","","",N,N],[17,"EBADMSG","","",N,N],[17,"EREMCHG","","",N,N],[17,"ELIBACC","","",N,N],[17,"ELIBBAD","","",N,N],[17,"ELIBSCN","","",N,N],[17,"ELIBMAX","","",N,N],[17,"ELIBEXEC","","",N,N],[17,"EILSEQ","","",N,N],[17,"ERESTART","","",N,N],[17,"ESTRPIPE","","",N,N],[17,"EUSERS","","",N,N],[17,"ENOTSOCK","","",N,N],[17,"EDESTADDRREQ","","",N,N],[17,"EMSGSIZE","","",N,N],[17,"EPROTOTYPE","","",N,N],[17,"ENOPROTOOPT","","",N,N],[17,"EPROTONOSUPPORT","","",N,N],[17,"ESOCKTNOSUPPORT","","",N,N],[17,"EOPNOTSUPP","","",N,N],[17,"EPFNOSUPPORT","","",N,N],[17,"EAFNOSUPPORT","","",N,N],[17,"EADDRINUSE","","",N,N],[17,"EADDRNOTAVAIL","","",N,N],[17,"ENETDOWN","","",N,N],[17,"ENETUNREACH","","",N,N],[17,"ENETRESET","","",N,N],[17,"ECONNABORTED","","",N,N],[17,"ECONNRESET","","",N,N],[17,"ENOBUFS","","",N,N],[17,"EISCONN","","",N,N],[17,"ENOTCONN","","",N,N],[17,"ESHUTDOWN","","",N,N],[17,"ETOOMANYREFS","","",N,N],[17,"ETIMEDOUT","","",N,N],[17,"ECONNREFUSED","","",N,N],[17,"EHOSTDOWN","","",N,N],[17,"EHOSTUNREACH","","",N,N],[17,"EALREADY","","",N,N],[17,"EINPROGRESS","","",N,N],[17,"ESTALE","","",N,N],[17,"EDQUOT","","",N,N],[17,"ENOMEDIUM","","",N,N],[17,"EMEDIUMTYPE","","",N,N],[17,"ECANCELED","","",N,N],[17,"ENOKEY","","",N,N],[17,"EKEYEXPIRED","","",N,N],[17,"EKEYREVOKED","","",N,N],[17,"EKEYREJECTED","","",N,N],[17,"EOWNERDEAD","","",N,N],[17,"ENOTRECOVERABLE","","",N,N],[17,"EHWPOISON","","",N,N],[17,"ERFKILL","","",N,N],[17,"SOL_SOCKET","","",N,N],[17,"SO_REUSEADDR","","",N,N],[17,"SO_TYPE","","",N,N],[17,"SO_ERROR","","",N,N],[17,"SO_DONTROUTE","","",N,N],[17,"SO_BROADCAST","","",N,N],[17,"SO_SNDBUF","","",N,N],[17,"SO_RCVBUF","","",N,N],[17,"SO_SNDBUFFORCE","","",N,N],[17,"SO_RCVBUFFORCE","","",N,N],[17,"SO_KEEPALIVE","","",N,N],[17,"SO_OOBINLINE","","",N,N],[17,"SO_NO_CHECK","","",N,N],[17,"SO_PRIORITY","","",N,N],[17,"SO_LINGER","","",N,N],[17,"SO_BSDCOMPAT","","",N,N],[17,"SO_REUSEPORT","","",N,N],[17,"SO_PASSCRED","","",N,N],[17,"SO_PEERCRED","","",N,N],[17,"SO_RCVLOWAT","","",N,N],[17,"SO_SNDLOWAT","","",N,N],[17,"SO_RCVTIMEO","","",N,N],[17,"SO_SNDTIMEO","","",N,N],[17,"SO_SECURITY_AUTHENTICATION","","",N,N],[17,"SO_SECURITY_ENCRYPTION_TRANSPORT","","",N,N],[17,"SO_SECURITY_ENCRYPTION_NETWORK","","",N,N],[17,"SO_BINDTODEVICE","","",N,N],[17,"SO_ATTACH_FILTER","","",N,N],[17,"SO_DETACH_FILTER","","",N,N],[17,"SO_GET_FILTER","","",N,N],[17,"SO_PEERNAME","","",N,N],[17,"SO_TIMESTAMP","","",N,N],[17,"SO_ACCEPTCONN","","",N,N],[17,"SO_PEERSEC","","",N,N],[17,"SO_PASSSEC","","",N,N],[17,"SO_TIMESTAMPNS","","",N,N],[17,"SCM_TIMESTAMPNS","","",N,N],[17,"SO_MARK","","",N,N],[17,"SO_TIMESTAMPING","","",N,N],[17,"SCM_TIMESTAMPING","","",N,N],[17,"SO_PROTOCOL","","",N,N],[17,"SO_DOMAIN","","",N,N],[17,"SO_RXQ_OVFL","","",N,N],[17,"SO_WIFI_STATUS","","",N,N],[17,"SCM_WIFI_STATUS","","",N,N],[17,"SO_PEEK_OFF","","",N,N],[17,"SO_NOFCS","","",N,N],[17,"SO_LOCK_FILTER","","",N,N],[17,"SO_SELECT_ERR_QUEUE","","",N,N],[17,"SO_BUSY_POLL","","",N,N],[17,"SO_MAX_PACING_RATE","","",N,N],[17,"SO_BPF_EXTENSIONS","","",N,N],[17,"SO_INCOMING_CPU","","",N,N],[17,"SO_ATTACH_BPF","","",N,N],[17,"SO_DETACH_BPF","","",N,N],[17,"SA_ONSTACK","","",N,N],[17,"SA_SIGINFO","","",N,N],[17,"SA_NOCLDWAIT","","",N,N],[17,"SIGCHLD","","",N,N],[17,"SIGBUS","","",N,N],[17,"SIGUSR1","","",N,N],[17,"SIGUSR2","","",N,N],[17,"SIGCONT","","",N,N],[17,"SIGSTOP","","",N,N],[17,"SIGTSTP","","",N,N],[17,"SIGURG","","",N,N],[17,"SIGIO","","",N,N],[17,"SIGSYS","","",N,N],[17,"SIGSTKFLT","","",N,N],[17,"SIGUNUSED","","",N,N],[17,"SIGPOLL","","",N,N],[17,"SIGPWR","","",N,N],[17,"SIG_SETMASK","","",N,N],[17,"SIG_BLOCK","","",N,N],[17,"SIG_UNBLOCK","","",N,N],[17,"POLLWRNORM","","",N,N],[17,"POLLWRBAND","","",N,N],[17,"O_ASYNC","","",N,N],[17,"O_NDELAY","","",N,N],[17,"PTRACE_DETACH","","",N,N],[17,"EFD_NONBLOCK","","",N,N],[17,"F_GETLK","","",N,N],[17,"F_GETOWN","","",N,N],[17,"F_SETOWN","","",N,N],[17,"F_SETLK","","",N,N],[17,"F_SETLKW","","",N,N],[17,"F_RDLCK","","",N,N],[17,"F_WRLCK","","",N,N],[17,"F_UNLCK","","",N,N],[17,"SFD_NONBLOCK","","",N,N],[17,"TIOCEXCL","","",N,N],[17,"TIOCNXCL","","",N,N],[17,"TIOCSCTTY","","",N,N],[17,"TIOCSTI","","",N,N],[17,"TIOCMGET","","",N,N],[17,"TIOCMBIS","","",N,N],[17,"TIOCMBIC","","",N,N],[17,"TIOCMSET","","",N,N],[17,"TIOCCONS","","",N,N],[17,"SFD_CLOEXEC","","",N,N],[17,"NCCS","","",N,N],[17,"O_TRUNC","","",N,N],[17,"O_CLOEXEC","","",N,N],[17,"EBFONT","","",N,N],[17,"ENOSTR","","",N,N],[17,"ENODATA","","",N,N],[17,"ETIME","","",N,N],[17,"ENOSR","","",N,N],[17,"ENONET","","",N,N],[17,"ENOPKG","","",N,N],[17,"EREMOTE","","",N,N],[17,"ENOLINK","","",N,N],[17,"EADV","","",N,N],[17,"ESRMNT","","",N,N],[17,"ECOMM","","",N,N],[17,"EPROTO","","",N,N],[17,"EDOTDOT","","",N,N],[17,"SA_NODEFER","","",N,N],[17,"SA_RESETHAND","","",N,N],[17,"SA_RESTART","","",N,N],[17,"SA_NOCLDSTOP","","",N,N],[17,"EPOLL_CLOEXEC","","",N,N],[17,"EFD_CLOEXEC","","",N,N],[17,"__SIZEOF_PTHREAD_CONDATTR_T","","",N,N],[17,"__SIZEOF_PTHREAD_MUTEXATTR_T","","",N,N],[17,"O_DIRECT","","",N,N],[17,"O_DIRECTORY","","",N,N],[17,"O_NOFOLLOW","","",N,N],[17,"MAP_LOCKED","","",N,N],[17,"MAP_NORESERVE","","",N,N],[17,"MAP_32BIT","","",N,N],[17,"EDEADLOCK","","",N,N],[17,"FIOCLEX","","",N,N],[17,"FIONBIO","","",N,N],[17,"PTRACE_GETFPREGS","","",N,N],[17,"PTRACE_SETFPREGS","","",N,N],[17,"PTRACE_GETFPXREGS","","",N,N],[17,"PTRACE_SETFPXREGS","","",N,N],[17,"PTRACE_GETREGS","","",N,N],[17,"PTRACE_SETREGS","","",N,N],[17,"PTRACE_PEEKSIGINFO_SHARED","","",N,N],[17,"MCL_CURRENT","","",N,N],[17,"MCL_FUTURE","","",N,N],[17,"SIGSTKSZ","","",N,N],[17,"MINSIGSTKSZ","","",N,N],[17,"CBAUD","","",N,N],[17,"TAB1","","",N,N],[17,"TAB2","","",N,N],[17,"TAB3","","",N,N],[17,"CR1","","",N,N],[17,"CR2","","",N,N],[17,"CR3","","",N,N],[17,"FF1","","",N,N],[17,"BS1","","",N,N],[17,"VT1","","",N,N],[17,"VWERASE","","",N,N],[17,"VREPRINT","","",N,N],[17,"VSUSP","","",N,N],[17,"VSTART","","",N,N],[17,"VSTOP","","",N,N],[17,"VDISCARD","","",N,N],[17,"VTIME","","",N,N],[17,"IXON","","",N,N],[17,"IXOFF","","",N,N],[17,"ONLCR","","",N,N],[17,"CSIZE","","",N,N],[17,"CS6","","",N,N],[17,"CS7","","",N,N],[17,"CS8","","",N,N],[17,"CSTOPB","","",N,N],[17,"CREAD","","",N,N],[17,"PARENB","","",N,N],[17,"PARODD","","",N,N],[17,"HUPCL","","",N,N],[17,"CLOCAL","","",N,N],[17,"ECHOKE","","",N,N],[17,"ECHOE","","",N,N],[17,"ECHOK","","",N,N],[17,"ECHONL","","",N,N],[17,"ECHOPRT","","",N,N],[17,"ECHOCTL","","",N,N],[17,"ISIG","","",N,N],[17,"ICANON","","",N,N],[17,"PENDIN","","",N,N],[17,"NOFLSH","","",N,N],[17,"CIBAUD","","",N,N],[17,"CBAUDEX","","",N,N],[17,"VSWTC","","",N,N],[17,"OLCUC","","",N,N],[17,"NLDLY","","",N,N],[17,"CRDLY","","",N,N],[17,"TABDLY","","",N,N],[17,"BSDLY","","",N,N],[17,"FFDLY","","",N,N],[17,"VTDLY","","",N,N],[17,"XTABS","","",N,N],[17,"B0","","",N,N],[17,"B50","","",N,N],[17,"B75","","",N,N],[17,"B110","","",N,N],[17,"B134","","",N,N],[17,"B150","","",N,N],[17,"B200","","",N,N],[17,"B300","","",N,N],[17,"B600","","",N,N],[17,"B1200","","",N,N],[17,"B1800","","",N,N],[17,"B2400","","",N,N],[17,"B4800","","",N,N],[17,"B9600","","",N,N],[17,"B19200","","",N,N],[17,"B38400","","",N,N],[17,"EXTA","","",N,N],[17,"EXTB","","",N,N],[17,"BOTHER","","",N,N],[17,"B57600","","",N,N],[17,"B115200","","",N,N],[17,"B230400","","",N,N],[17,"B460800","","",N,N],[17,"B500000","","",N,N],[17,"B576000","","",N,N],[17,"B921600","","",N,N],[17,"B1000000","","",N,N],[17,"B1152000","","",N,N],[17,"B1500000","","",N,N],[17,"B2000000","","",N,N],[17,"B2500000","","",N,N],[17,"B3000000","","",N,N],[17,"B3500000","","",N,N],[17,"B4000000","","",N,N],[17,"VEOL","","",N,N],[17,"VEOL2","","",N,N],[17,"VMIN","","",N,N],[17,"IEXTEN","","",N,N],[17,"TOSTOP","","",N,N],[17,"FLUSHO","","",N,N],[17,"EXTPROC","","",N,N],[17,"TCGETS","","",N,N],[17,"TCSETS","","",N,N],[17,"TCSETSW","","",N,N],[17,"TCSETSF","","",N,N],[17,"TCGETA","","",N,N],[17,"TCSETA","","",N,N],[17,"TCSETAW","","",N,N],[17,"TCSETAF","","",N,N],[17,"TCSBRK","","",N,N],[17,"TCXONC","","",N,N],[17,"TCFLSH","","",N,N],[17,"TIOCINQ","","",N,N],[17,"TIOCGPGRP","","",N,N],[17,"TIOCSPGRP","","",N,N],[17,"TIOCOUTQ","","",N,N],[17,"TIOCGWINSZ","","",N,N],[17,"TIOCSWINSZ","","",N,N],[17,"FIONREAD","","",N,N],[17,"R15","","",N,N],[17,"R14","","",N,N],[17,"R13","","",N,N],[17,"R12","","",N,N],[17,"RBP","","",N,N],[17,"RBX","","",N,N],[17,"R11","","",N,N],[17,"R10","","",N,N],[17,"R9","","",N,N],[17,"R8","","",N,N],[17,"RAX","","",N,N],[17,"RCX","","",N,N],[17,"RDX","","",N,N],[17,"RSI","","",N,N],[17,"RDI","","",N,N],[17,"ORIG_RAX","","",N,N],[17,"RIP","","",N,N],[17,"CS","","",N,N],[17,"EFLAGS","","",N,N],[17,"RSP","","",N,N],[17,"SS","","",N,N],[17,"FS_BASE","","",N,N],[17,"GS_BASE","","",N,N],[17,"DS","","",N,N],[17,"ES","","",N,N],[17,"FS","","",N,N],[17,"GS","","",N,N],[17,"__SIZEOF_PTHREAD_MUTEX_T","","",N,N],[17,"__SIZEOF_PTHREAD_RWLOCK_T","","",N,N],[17,"PTHREAD_RECURSIVE_MUTEX_INITIALIZER_NP","","",N,N],[17,"PTHREAD_ERRORCHECK_MUTEX_INITIALIZER_NP","","",N,N],[17,"PTHREAD_ADAPTIVE_MUTEX_INITIALIZER_NP","","",N,N],[17,"SYS_read","","",N,N],[17,"SYS_write","","",N,N],[17,"SYS_open","","",N,N],[17,"SYS_close","","",N,N],[17,"SYS_stat","","",N,N],[17,"SYS_fstat","","",N,N],[17,"SYS_lstat","","",N,N],[17,"SYS_poll","","",N,N],[17,"SYS_lseek","","",N,N],[17,"SYS_mmap","","",N,N],[17,"SYS_mprotect","","",N,N],[17,"SYS_munmap","","",N,N],[17,"SYS_brk","","",N,N],[17,"SYS_rt_sigaction","","",N,N],[17,"SYS_rt_sigprocmask","","",N,N],[17,"SYS_rt_sigreturn","","",N,N],[17,"SYS_ioctl","","",N,N],[17,"SYS_pread64","","",N,N],[17,"SYS_pwrite64","","",N,N],[17,"SYS_readv","","",N,N],[17,"SYS_writev","","",N,N],[17,"SYS_access","","",N,N],[17,"SYS_pipe","","",N,N],[17,"SYS_select","","",N,N],[17,"SYS_sched_yield","","",N,N],[17,"SYS_mremap","","",N,N],[17,"SYS_msync","","",N,N],[17,"SYS_mincore","","",N,N],[17,"SYS_madvise","","",N,N],[17,"SYS_shmget","","",N,N],[17,"SYS_shmat","","",N,N],[17,"SYS_shmctl","","",N,N],[17,"SYS_dup","","",N,N],[17,"SYS_dup2","","",N,N],[17,"SYS_pause","","",N,N],[17,"SYS_nanosleep","","",N,N],[17,"SYS_getitimer","","",N,N],[17,"SYS_alarm","","",N,N],[17,"SYS_setitimer","","",N,N],[17,"SYS_getpid","","",N,N],[17,"SYS_sendfile","","",N,N],[17,"SYS_socket","","",N,N],[17,"SYS_connect","","",N,N],[17,"SYS_accept","","",N,N],[17,"SYS_sendto","","",N,N],[17,"SYS_recvfrom","","",N,N],[17,"SYS_sendmsg","","",N,N],[17,"SYS_recvmsg","","",N,N],[17,"SYS_shutdown","","",N,N],[17,"SYS_bind","","",N,N],[17,"SYS_listen","","",N,N],[17,"SYS_getsockname","","",N,N],[17,"SYS_getpeername","","",N,N],[17,"SYS_socketpair","","",N,N],[17,"SYS_setsockopt","","",N,N],[17,"SYS_getsockopt","","",N,N],[17,"SYS_clone","","",N,N],[17,"SYS_fork","","",N,N],[17,"SYS_vfork","","",N,N],[17,"SYS_execve","","",N,N],[17,"SYS_exit","","",N,N],[17,"SYS_wait4","","",N,N],[17,"SYS_kill","","",N,N],[17,"SYS_uname","","",N,N],[17,"SYS_semget","","",N,N],[17,"SYS_semop","","",N,N],[17,"SYS_semctl","","",N,N],[17,"SYS_shmdt","","",N,N],[17,"SYS_msgget","","",N,N],[17,"SYS_msgsnd","","",N,N],[17,"SYS_msgrcv","","",N,N],[17,"SYS_msgctl","","",N,N],[17,"SYS_fcntl","","",N,N],[17,"SYS_flock","","",N,N],[17,"SYS_fsync","","",N,N],[17,"SYS_fdatasync","","",N,N],[17,"SYS_truncate","","",N,N],[17,"SYS_ftruncate","","",N,N],[17,"SYS_getdents","","",N,N],[17,"SYS_getcwd","","",N,N],[17,"SYS_chdir","","",N,N],[17,"SYS_fchdir","","",N,N],[17,"SYS_rename","","",N,N],[17,"SYS_mkdir","","",N,N],[17,"SYS_rmdir","","",N,N],[17,"SYS_creat","","",N,N],[17,"SYS_link","","",N,N],[17,"SYS_unlink","","",N,N],[17,"SYS_symlink","","",N,N],[17,"SYS_readlink","","",N,N],[17,"SYS_chmod","","",N,N],[17,"SYS_fchmod","","",N,N],[17,"SYS_chown","","",N,N],[17,"SYS_fchown","","",N,N],[17,"SYS_lchown","","",N,N],[17,"SYS_umask","","",N,N],[17,"SYS_gettimeofday","","",N,N],[17,"SYS_getrlimit","","",N,N],[17,"SYS_getrusage","","",N,N],[17,"SYS_sysinfo","","",N,N],[17,"SYS_times","","",N,N],[17,"SYS_ptrace","","",N,N],[17,"SYS_getuid","","",N,N],[17,"SYS_syslog","","",N,N],[17,"SYS_getgid","","",N,N],[17,"SYS_setuid","","",N,N],[17,"SYS_setgid","","",N,N],[17,"SYS_geteuid","","",N,N],[17,"SYS_getegid","","",N,N],[17,"SYS_setpgid","","",N,N],[17,"SYS_getppid","","",N,N],[17,"SYS_getpgrp","","",N,N],[17,"SYS_setsid","","",N,N],[17,"SYS_setreuid","","",N,N],[17,"SYS_setregid","","",N,N],[17,"SYS_getgroups","","",N,N],[17,"SYS_setgroups","","",N,N],[17,"SYS_setresuid","","",N,N],[17,"SYS_getresuid","","",N,N],[17,"SYS_setresgid","","",N,N],[17,"SYS_getresgid","","",N,N],[17,"SYS_getpgid","","",N,N],[17,"SYS_setfsuid","","",N,N],[17,"SYS_setfsgid","","",N,N],[17,"SYS_getsid","","",N,N],[17,"SYS_capget","","",N,N],[17,"SYS_capset","","",N,N],[17,"SYS_rt_sigpending","","",N,N],[17,"SYS_rt_sigtimedwait","","",N,N],[17,"SYS_rt_sigqueueinfo","","",N,N],[17,"SYS_rt_sigsuspend","","",N,N],[17,"SYS_sigaltstack","","",N,N],[17,"SYS_utime","","",N,N],[17,"SYS_mknod","","",N,N],[17,"SYS_uselib","","",N,N],[17,"SYS_personality","","",N,N],[17,"SYS_ustat","","",N,N],[17,"SYS_statfs","","",N,N],[17,"SYS_fstatfs","","",N,N],[17,"SYS_sysfs","","",N,N],[17,"SYS_getpriority","","",N,N],[17,"SYS_setpriority","","",N,N],[17,"SYS_sched_setparam","","",N,N],[17,"SYS_sched_getparam","","",N,N],[17,"SYS_sched_setscheduler","","",N,N],[17,"SYS_sched_getscheduler","","",N,N],[17,"SYS_sched_get_priority_max","","",N,N],[17,"SYS_sched_get_priority_min","","",N,N],[17,"SYS_sched_rr_get_interval","","",N,N],[17,"SYS_mlock","","",N,N],[17,"SYS_munlock","","",N,N],[17,"SYS_mlockall","","",N,N],[17,"SYS_munlockall","","",N,N],[17,"SYS_vhangup","","",N,N],[17,"SYS_modify_ldt","","",N,N],[17,"SYS_pivot_root","","",N,N],[17,"SYS__sysctl","","",N,N],[17,"SYS_prctl","","",N,N],[17,"SYS_arch_prctl","","",N,N],[17,"SYS_adjtimex","","",N,N],[17,"SYS_setrlimit","","",N,N],[17,"SYS_chroot","","",N,N],[17,"SYS_sync","","",N,N],[17,"SYS_acct","","",N,N],[17,"SYS_settimeofday","","",N,N],[17,"SYS_mount","","",N,N],[17,"SYS_umount2","","",N,N],[17,"SYS_swapon","","",N,N],[17,"SYS_swapoff","","",N,N],[17,"SYS_reboot","","",N,N],[17,"SYS_sethostname","","",N,N],[17,"SYS_setdomainname","","",N,N],[17,"SYS_iopl","","",N,N],[17,"SYS_ioperm","","",N,N],[17,"SYS_create_module","","",N,N],[17,"SYS_init_module","","",N,N],[17,"SYS_delete_module","","",N,N],[17,"SYS_get_kernel_syms","","",N,N],[17,"SYS_query_module","","",N,N],[17,"SYS_quotactl","","",N,N],[17,"SYS_nfsservctl","","",N,N],[17,"SYS_getpmsg","","",N,N],[17,"SYS_putpmsg","","",N,N],[17,"SYS_afs_syscall","","",N,N],[17,"SYS_tuxcall","","",N,N],[17,"SYS_security","","",N,N],[17,"SYS_gettid","","",N,N],[17,"SYS_readahead","","",N,N],[17,"SYS_setxattr","","",N,N],[17,"SYS_lsetxattr","","",N,N],[17,"SYS_fsetxattr","","",N,N],[17,"SYS_getxattr","","",N,N],[17,"SYS_lgetxattr","","",N,N],[17,"SYS_fgetxattr","","",N,N],[17,"SYS_listxattr","","",N,N],[17,"SYS_llistxattr","","",N,N],[17,"SYS_flistxattr","","",N,N],[17,"SYS_removexattr","","",N,N],[17,"SYS_lremovexattr","","",N,N],[17,"SYS_fremovexattr","","",N,N],[17,"SYS_tkill","","",N,N],[17,"SYS_time","","",N,N],[17,"SYS_futex","","",N,N],[17,"SYS_sched_setaffinity","","",N,N],[17,"SYS_sched_getaffinity","","",N,N],[17,"SYS_set_thread_area","","",N,N],[17,"SYS_io_setup","","",N,N],[17,"SYS_io_destroy","","",N,N],[17,"SYS_io_getevents","","",N,N],[17,"SYS_io_submit","","",N,N],[17,"SYS_io_cancel","","",N,N],[17,"SYS_get_thread_area","","",N,N],[17,"SYS_lookup_dcookie","","",N,N],[17,"SYS_epoll_create","","",N,N],[17,"SYS_epoll_ctl_old","","",N,N],[17,"SYS_epoll_wait_old","","",N,N],[17,"SYS_remap_file_pages","","",N,N],[17,"SYS_getdents64","","",N,N],[17,"SYS_set_tid_address","","",N,N],[17,"SYS_restart_syscall","","",N,N],[17,"SYS_semtimedop","","",N,N],[17,"SYS_fadvise64","","",N,N],[17,"SYS_timer_create","","",N,N],[17,"SYS_timer_settime","","",N,N],[17,"SYS_timer_gettime","","",N,N],[17,"SYS_timer_getoverrun","","",N,N],[17,"SYS_timer_delete","","",N,N],[17,"SYS_clock_settime","","",N,N],[17,"SYS_clock_gettime","","",N,N],[17,"SYS_clock_getres","","",N,N],[17,"SYS_clock_nanosleep","","",N,N],[17,"SYS_exit_group","","",N,N],[17,"SYS_epoll_wait","","",N,N],[17,"SYS_epoll_ctl","","",N,N],[17,"SYS_tgkill","","",N,N],[17,"SYS_utimes","","",N,N],[17,"SYS_vserver","","",N,N],[17,"SYS_mbind","","",N,N],[17,"SYS_set_mempolicy","","",N,N],[17,"SYS_get_mempolicy","","",N,N],[17,"SYS_mq_open","","",N,N],[17,"SYS_mq_unlink","","",N,N],[17,"SYS_mq_timedsend","","",N,N],[17,"SYS_mq_timedreceive","","",N,N],[17,"SYS_mq_notify","","",N,N],[17,"SYS_mq_getsetattr","","",N,N],[17,"SYS_kexec_load","","",N,N],[17,"SYS_waitid","","",N,N],[17,"SYS_add_key","","",N,N],[17,"SYS_request_key","","",N,N],[17,"SYS_keyctl","","",N,N],[17,"SYS_ioprio_set","","",N,N],[17,"SYS_ioprio_get","","",N,N],[17,"SYS_inotify_init","","",N,N],[17,"SYS_inotify_add_watch","","",N,N],[17,"SYS_inotify_rm_watch","","",N,N],[17,"SYS_migrate_pages","","",N,N],[17,"SYS_openat","","",N,N],[17,"SYS_mkdirat","","",N,N],[17,"SYS_mknodat","","",N,N],[17,"SYS_fchownat","","",N,N],[17,"SYS_futimesat","","",N,N],[17,"SYS_newfstatat","","",N,N],[17,"SYS_unlinkat","","",N,N],[17,"SYS_renameat","","",N,N],[17,"SYS_linkat","","",N,N],[17,"SYS_symlinkat","","",N,N],[17,"SYS_readlinkat","","",N,N],[17,"SYS_fchmodat","","",N,N],[17,"SYS_faccessat","","",N,N],[17,"SYS_pselect6","","",N,N],[17,"SYS_ppoll","","",N,N],[17,"SYS_unshare","","",N,N],[17,"SYS_set_robust_list","","",N,N],[17,"SYS_get_robust_list","","",N,N],[17,"SYS_splice","","",N,N],[17,"SYS_tee","","",N,N],[17,"SYS_sync_file_range","","",N,N],[17,"SYS_vmsplice","","",N,N],[17,"SYS_move_pages","","",N,N],[17,"SYS_utimensat","","",N,N],[17,"SYS_epoll_pwait","","",N,N],[17,"SYS_signalfd","","",N,N],[17,"SYS_timerfd_create","","",N,N],[17,"SYS_eventfd","","",N,N],[17,"SYS_fallocate","","",N,N],[17,"SYS_timerfd_settime","","",N,N],[17,"SYS_timerfd_gettime","","",N,N],[17,"SYS_accept4","","",N,N],[17,"SYS_signalfd4","","",N,N],[17,"SYS_eventfd2","","",N,N],[17,"SYS_epoll_create1","","",N,N],[17,"SYS_dup3","","",N,N],[17,"SYS_pipe2","","",N,N],[17,"SYS_inotify_init1","","",N,N],[17,"SYS_preadv","","",N,N],[17,"SYS_pwritev","","",N,N],[17,"SYS_rt_tgsigqueueinfo","","",N,N],[17,"SYS_perf_event_open","","",N,N],[17,"SYS_recvmmsg","","",N,N],[17,"SYS_fanotify_init","","",N,N],[17,"SYS_fanotify_mark","","",N,N],[17,"SYS_prlimit64","","",N,N],[17,"SYS_name_to_handle_at","","",N,N],[17,"SYS_open_by_handle_at","","",N,N],[17,"SYS_clock_adjtime","","",N,N],[17,"SYS_syncfs","","",N,N],[17,"SYS_sendmmsg","","",N,N],[17,"SYS_setns","","",N,N],[17,"SYS_getcpu","","",N,N],[17,"SYS_process_vm_readv","","",N,N],[17,"SYS_process_vm_writev","","",N,N],[17,"SYS_kcmp","","",N,N],[17,"SYS_finit_module","","",N,N],[17,"SYS_sched_setattr","","",N,N],[17,"SYS_sched_getattr","","",N,N],[17,"SYS_renameat2","","",N,N],[17,"SYS_seccomp","","",N,N],[17,"SYS_getrandom","","",N,N],[17,"SYS_memfd_create","","",N,N],[17,"SYS_kexec_file_load","","",N,N],[17,"SYS_bpf","","",N,N],[17,"SYS_execveat","","",N,N],[17,"SYS_userfaultfd","","",N,N],[17,"SYS_membarrier","","",N,N],[17,"SYS_mlock2","","",N,N],[17,"SYS_copy_file_range","","",N,N],[17,"SYS_preadv2","","",N,N],[17,"SYS_pwritev2","","",N,N],[17,"SYS_pkey_mprotect","","",N,N],[17,"SYS_pkey_alloc","","",N,N],[17,"SYS_pkey_free","","",N,N],[11,"is_some","libc::dox::imp","Returns `true` if the option is a [`Some`] value.",132,[[["self"]],["bool"]]],[11,"is_none","","Returns `true` if the option is a [`None`] value.",132,[[["self"]],["bool"]]],[11,"as_ref","","Converts from `Option<T>` to `Option<&T>`.",132,[[["self"]],["option"]]],[11,"as_mut","","Converts from `Option<T>` to `Option<&mut T>`.",132,[[["self"]],["option"]]],[11,"as_pin_mut","","Converts from `Option<T>` to `Option<PinMut<'_, T>>`",132,[[["pinmut",["option"]]],["option",["pinmut"]]]],[11,"expect","","Unwraps an option, yielding the content of a [`Some`].",132,[[["self"],["str"]],["t"]]],[11,"unwrap","","Moves the value `v` out of the `Option<T>` if it is [`Some(v)`].",132,[[["self"]],["t"]]],[11,"unwrap_or","","Returns the contained value or a default.",132,[[["self"],["t"]],["t"]]],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",132,[[["self"],["f"]],["t"]]],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function to a contained value.",132,[[["self"],["f"]],["option"]]],[11,"map_or","","Applies a function to the contained value (if any), or returns the provided default (if not).",132,[[["self"],["u"],["f"]],["u"]]],[11,"map_or_else","","Applies a function to the contained value (if any), or computes a default (if not).",132,[[["self"],["d"],["f"]],["u"]]],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err)`].",132,[[["self"],["e"]],["result"]]],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err())`].",132,[[["self"],["f"]],["result"]]],[11,"iter","","Returns an iterator over the possibly contained value.",132,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",132,[[["self"]],["itermut"]]],[11,"and","","Returns [`None`] if the option is [`None`], otherwise returns `optb`.",132,[[["self"],["option"]],["option"]]],[11,"and_then","","Returns [`None`] if the option is [`None`], otherwise calls `f` with the wrapped value and returns the result.",132,[[["self"],["f"]],["option"]]],[11,"filter","","Returns `None` if the option is `None`, otherwise calls `predicate` with the wrapped value and returns:",132,[[["self"],["p"]],["option"]]],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",132,[[["self"],["option"]],["option"]]],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and returns the result.",132,[[["self"],["f"]],["option"]]],[11,"xor","","Returns [`Some`] if exactly one of `self`, `optb` is [`Some`], otherwise returns `None`.",132,[[["self"],["option"]],["option"]]],[11,"get_or_insert","","Inserts `v` into the option if it is [`None`], then returns a mutable reference to the contained value.",132,[[["self"],["t"]],["t"]]],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is [`None`], then returns a mutable reference to the contained value.",132,[[["self"],["f"]],["t"]]],[11,"take","","Takes the value out of the option, leaving a [`None`] in its place.",132,[[["self"]],["option"]]],[11,"replace","","Replaces the actual value in the option by the value given in parameter, returning the old value if present, leaving a [`Some`] in its place without deinitializing either one.",132,[[["self"],["t"]],["option"]]],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the contents of the option.",132,[[["self"]],["option"]]],[11,"cloned","","Maps an `Option<&mut T>` to an `Option<T>` by cloning the contents of the option.",132,[[["self"]],["option"]]],[11,"unwrap_or_default","","Returns the contained value or a default",132,[[["self"]],["t"]]],[11,"transpose","","Transposes an `Option` of a `Result` into a `Result` of an `Option`.",132,[[["self"]],["result",["option"]]]],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",132,[[["self"]],["intoiter"]]],[11,"hash","libc::dox::imp::mem","",134,N],[11,"hash","libc::dox::imp","",132,N],[11,"hash","libc::dox::imp::mem","",135,N],[11,"from","libc::dox::imp","",132,[[["t"]],["option"]]],[11,"fmt","libc::dox::imp::mem","",136,[[["self"],["formatter"]],["result",["error"]]]],[11,"clone","","",134,[[["self"]],["discriminant"]]],[11,"clone","libc::dox::imp","",132,[[["self"]],["option"]]],[11,"clone","libc::dox::imp::mem","",135,[[["self"]],["manuallydrop"]]],[11,"fmt","","",136,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","libc::dox::imp","",132,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","libc::dox::imp::mem","",134,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",135,[[["self"],["formatter"]],["result",["error"]]]],[11,"partial_cmp","","",135,[[["self"],["manuallydrop"]],["option",["ordering"]]]],[11,"lt","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"le","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"gt","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"ge","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"partial_cmp","libc::dox::imp","",132,[[["self"],["option"]],["option",["ordering"]]]],[11,"lt","","",132,[[["self"],["option"]],["bool"]]],[11,"le","","",132,[[["self"],["option"]],["bool"]]],[11,"gt","","",132,[[["self"],["option"]],["bool"]]],[11,"ge","","",132,[[["self"],["option"]],["bool"]]],[11,"cmp","","",132,[[["self"],["option"]],["ordering"]]],[11,"cmp","libc::dox::imp::mem","",135,[[["self"],["manuallydrop"]],["ordering"]]],[11,"from_iter","libc::dox::imp","Takes each element in the [`Iterator`]: if it is [`None`], no further elements are taken, and the [`None`] is returned. Should no [`None`] occur, a container with the values of each `Option` is returned.",132,[[["i"]],["option"]]],[11,"assert_receiver_is_total_eq","","",132,N],[11,"assert_receiver_is_total_eq","libc::dox::imp::mem","",135,N],[11,"eq","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"ne","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"eq","","",134,[[["self"],["discriminant"]],["bool"]]],[11,"eq","libc::dox::imp","",132,[[["self"],["option"]],["bool"]]],[11,"ne","","",132,[[["self"],["option"]],["bool"]]],[11,"into_raw","libc::dox::imp::mem","",136,N],[11,"poll","","",136,N],[11,"drop","","",136,N],[11,"poll","","",136,[[["pinmut",["pinmut"]],["context"]],["poll"]]],[11,"into_result","libc::dox::imp","",132,[[["self"]],["result",["noneerror"]]]],[11,"from_ok","","",132,[[["t"]],["option"]]],[11,"from_error","","",132,[[["noneerror"]],["option"]]],[11,"default","libc::dox::imp::mem","",135,[[],["manuallydrop"]]],[11,"default","libc::dox::imp","Returns [`None`].",132,[[],["option"]]],[11,"deref_mut","libc::dox::imp::mem","",135,N],[11,"deref_mut","","",136,[[["self"]],["t"]]],[11,"deref","","",135,N],[11,"deref","","",136,[[["self"]],["t"]]],[11,"fmt","","",136,[[["self"],["formatter"]],["result",["error"]]]],[11,"new","","Wrap a value to be manually dropped.",135,[[["t"]],["manuallydrop"]]],[11,"into_inner","","Extract the value from the ManuallyDrop container.",135,[[["manuallydrop"]],["t"]]],[11,"drop","","Manually drops the contained value.",135,N],[11,"new","","Construct a new `PinMut` around a reference to some data of a type that implements `Unpin`.",136,[[["t"]],["pinmut"]]],[11,"get_mut","","Get a mutable reference to the data inside of this `PinMut`.",136,[[["pinmut"]],["t"]]],[11,"new_unchecked","","Construct a new `PinMut` around a reference to some data of a type that may or may not implement `Unpin`.",136,[[["t"]],["pinmut"]]],[11,"reborrow","","Reborrow a `PinMut` for a shorter lifetime.",136,[[["self"]],["pinmut"]]],[11,"get_mut_unchecked","","Get a mutable reference to the data inside of this `PinMut`.",136,[[["pinmut"]],["t"]]],[11,"map_unchecked","","Construct a new pin by mapping the interior value.",136,[[["pinmut"],["f"]],["pinmut"]]],[11,"set","","Assign a new value to the memory behind the pinned reference.",136,N]],"paths":[[3,"group"],[3,"utimbuf"],[3,"timeval"],[3,"timespec"],[3,"rlimit"],[3,"rusage"],[3,"in_addr"],[3,"in6_addr"],[3,"ip_mreq"],[3,"ipv6_mreq"],[3,"hostent"],[3,"iovec"],[3,"pollfd"],[3,"winsize"],[3,"linger"],[3,"sigval"],[3,"itimerval"],[3,"tms"],[3,"servent"],[3,"protoent"],[3,"sockaddr"],[3,"sockaddr_in"],[3,"sockaddr_in6"],[3,"sockaddr_un"],[3,"sockaddr_storage"],[3,"addrinfo"],[3,"sockaddr_nl"],[3,"sockaddr_ll"],[3,"fd_set"],[3,"tm"],[3,"sched_param"],[3,"Dl_info"],[3,"epoll_event"],[3,"utsname"],[3,"lconv"],[3,"sigevent"],[3,"in_pktinfo"],[3,"ifaddrs"],[3,"in6_rtmsg"],[3,"arpreq"],[3,"arpreq_old"],[3,"arphdr"],[3,"dirent"],[3,"dirent64"],[3,"rlimit64"],[3,"glob_t"],[3,"pthread_mutex_t"],[3,"pthread_rwlock_t"],[3,"pthread_mutexattr_t"],[3,"pthread_rwlockattr_t"],[3,"pthread_cond_t"],[3,"pthread_condattr_t"],[3,"passwd"],[3,"spwd"],[3,"dqblk"],[3,"signalfd_siginfo"],[3,"itimerspec"],[3,"fsid_t"],[3,"mq_attr"],[3,"packet_mreq"],[3,"cpu_set_t"],[3,"if_nameindex"],[3,"msginfo"],[3,"mmsghdr"],[3,"sembuf"],[3,"input_event"],[3,"input_id"],[3,"input_absinfo"],[3,"input_keymap_entry"],[3,"input_mask"],[3,"ff_replay"],[3,"ff_trigger"],[3,"ff_envelope"],[3,"ff_constant_effect"],[3,"ff_ramp_effect"],[3,"ff_condition_effect"],[3,"ff_periodic_effect"],[3,"ff_rumble_effect"],[3,"ff_effect"],[3,"dl_phdr_info"],[3,"Elf32_Phdr"],[3,"Elf64_Phdr"],[3,"ucred"],[3,"mntent"],[3,"posix_spawn_file_actions_t"],[3,"posix_spawnattr_t"],[3,"genlmsghdr"],[3,"in6_pktinfo"],[3,"arpd_request"],[3,"aiocb"],[3,"__exit_status"],[3,"__timeval"],[3,"utmpx"],[3,"sigaction"],[3,"stack_t"],[3,"siginfo_t"],[3,"glob64_t"],[3,"statfs"],[3,"msghdr"],[3,"cmsghdr"],[3,"termios"],[3,"flock"],[3,"sem_t"],[3,"mallinfo"],[3,"nlmsghdr"],[3,"nlmsgerr"],[3,"nl_pktinfo"],[3,"nl_mmap_req"],[3,"nl_mmap_hdr"],[3,"nlattr"],[3,"rtentry"],[3,"sigset_t"],[3,"sysinfo"],[3,"msqid_ds"],[3,"stat"],[3,"stat64"],[3,"statfs64"],[3,"statvfs64"],[3,"pthread_attr_t"],[3,"_libc_fpxreg"],[3,"_libc_xmmreg"],[3,"_libc_fpstate"],[3,"user_fpregs_struct"],[3,"user_regs_struct"],[3,"user"],[3,"mcontext_t"],[3,"ucontext_t"],[3,"ipc_perm"],[3,"shmid_ds"],[3,"termios2"],[3,"statvfs"],[4,"c_void"],[4,"Option"],[8,"Clone"],[3,"Discriminant"],[3,"ManuallyDrop"],[3,"PinMut"]]};
searchIndex["memchr"]={"doc":"This crate defines two functions, `memchr` and `memrchr`, which expose a safe interface to the corresponding functions in `libc`.","items":[[3,"Memchr","memchr","An iterator for memchr",N,N],[12,"needle","","",0,N],[12,"haystack","","",0,N],[12,"position","","",0,N],[3,"Memchr2","","An iterator for Memchr2",N,N],[12,"needle1","","",1,N],[12,"needle2","","",1,N],[12,"haystack","","",1,N],[12,"position","","",1,N],[3,"Memchr3","","An iterator for Memchr3",N,N],[12,"needle1","","",2,N],[12,"needle2","","",2,N],[12,"needle3","","",2,N],[12,"haystack","","",2,N],[12,"position","","",2,N],[5,"contains_zero_byte","","Return `true` if `x` contains any zero byte.",N,[[["usize"]],["bool"]]],[5,"repeat_byte","","",N,[[["u8"]],["usize"]]],[5,"memchr","","A safe interface to `memchr`.",N,N],[5,"memrchr","","A safe interface to `memrchr`.",N,N],[5,"memchr2","","Like `memchr`, but searches for two bytes instead of one.",N,N],[5,"memchr3","","Like `memchr`, but searches for three bytes instead of one.",N,N],[17,"LO_U64","","",N,N],[17,"HI_U64","","",N,N],[17,"LO_USIZE","","",N,N],[17,"HI_USIZE","","",N,N],[17,"USIZE_BYTES","","",N,N],[11,"new","","Creates a new iterator that yields all positions of needle in haystack.",0,N],[11,"next","","",0,[[["self"]],["option",["usize"]]]],[11,"size_hint","","",0,N],[11,"next_back","","",0,[[["self"]],["option"]]],[11,"new","","Creates a new iterator that yields all positions of needle in haystack.",1,N],[11,"next","","",1,[[["self"]],["option",["usize"]]]],[11,"size_hint","","",1,N],[11,"new","","Create a new Memchr2 that's initalized to zero with a haystack",2,N],[11,"next","","",2,[[["self"]],["option",["usize"]]]],[11,"size_hint","","",2,N]],"paths":[[3,"Memchr"],[3,"Memchr2"],[3,"Memchr3"]]};
searchIndex["minifier"]={"doc":"","items":[[0,"html","minifier","",N,N],[5,"condense_whitespace","minifier::html","",N,[[["str"]],["string"]]],[5,"condense","","",N,[[["str"]],["string"]]],[5,"clean_unneeded_tags","","",N,[[["str"]],["string"]]],[5,"remove_comments","","",N,[[["str"]],["string"]]],[5,"unquote_attributes","","",N,[[["str"]],["string"]]],[5,"minify","","Returns a minified version of the provided HTML source.",N,[[["str"]],["string"]]],[0,"js","minifier","",N,N],[4,"Keyword","minifier::js","",N,N],[13,"Break","","",0,N],[13,"Case","","",0,N],[13,"Catch","","",0,N],[13,"Const","","",0,N],[13,"Continue","","",0,N],[13,"Default","","",0,N],[13,"Do","","",0,N],[13,"Else","","",0,N],[13,"False","","",0,N],[13,"Finally","","",0,N],[13,"Function","","",0,N],[13,"For","","",0,N],[13,"If","","",0,N],[13,"In","","",0,N],[13,"InstanceOf","","",0,N],[13,"New","","",0,N],[13,"Null","","",0,N],[13,"Private","","",0,N],[13,"Protected","","",0,N],[13,"Public","","",0,N],[13,"Return","","",0,N],[13,"Switch","","",0,N],[13,"This","","",0,N],[13,"Throw","","",0,N],[13,"True","","",0,N],[13,"Try","","",0,N],[13,"Typeof","","",0,N],[13,"Static","","",0,N],[13,"Var","","",0,N],[13,"While","","",0,N],[5,"minify","","",N,[[["str"]],["string"]]],[5,"minify_and_replace_keywords","","",N,N],[0,"token","","",N,N],[3,"Tokens","minifier::js::token","",N,N],[12,"0","","",1,N],[4,"ReservedChar","","",N,N],[13,"Comma","","",2,N],[13,"OpenParenthese","","",2,N],[13,"CloseParenthese","","",2,N],[13,"OpenCurlyBrace","","",2,N],[13,"CloseCurlyBrace","","",2,N],[13,"OpenBracket","","",2,N],[13,"CloseBracket","","",2,N],[13,"Colon","","",2,N],[13,"SemiColon","","",2,N],[13,"Dot","","",2,N],[13,"Quote","","",2,N],[13,"DoubleQuote","","",2,N],[13,"ExclamationMark","","",2,N],[13,"QuestionMark","","",2,N],[13,"Slash","","",2,N],[13,"Modulo","","",2,N],[13,"Star","","",2,N],[13,"Minus","","",2,N],[13,"Plus","","",2,N],[13,"EqualSign","","",2,N],[13,"Backslash","","",2,N],[13,"Space","","",2,N],[13,"Tab","","",2,N],[13,"Backline","","",2,N],[13,"LessThan","","",2,N],[13,"SuperiorThan","","",2,N],[13,"Pipe","","",2,N],[13,"Ampersand","","",2,N],[4,"Keyword","","",N,N],[13,"Break","","",0,N],[13,"Case","","",0,N],[13,"Catch","","",0,N],[13,"Const","","",0,N],[13,"Continue","","",0,N],[13,"Default","","",0,N],[13,"Do","","",0,N],[13,"Else","","",0,N],[13,"False","","",0,N],[13,"Finally","","",0,N],[13,"Function","","",0,N],[13,"For","","",0,N],[13,"If","","",0,N],[13,"In","","",0,N],[13,"InstanceOf","","",0,N],[13,"New","","",0,N],[13,"Null","","",0,N],[13,"Private","","",0,N],[13,"Protected","","",0,N],[13,"Public","","",0,N],[13,"Return","","",0,N],[13,"Switch","","",0,N],[13,"This","","",0,N],[13,"Throw","","",0,N],[13,"True","","",0,N],[13,"Try","","",0,N],[13,"Typeof","","",0,N],[13,"Static","","",0,N],[13,"Var","","",0,N],[13,"While","","",0,N],[4,"Condition","","",N,N],[13,"And","","",3,N],[13,"Or","","",3,N],[13,"DifferentThan","","",3,N],[13,"SuperDifferentThan","","",3,N],[13,"EqualTo","","",3,N],[13,"SuperEqualTo","","",3,N],[13,"SuperiorThan","","",3,N],[13,"SuperiorOrEqualTo","","",3,N],[13,"InferiorThan","","",3,N],[13,"InferiorOrEqualTo","","",3,N],[4,"Operation","","",N,N],[13,"Addition","","",4,N],[13,"AdditionEqual","","",4,N],[13,"Subtract","","",4,N],[13,"SubtractEqual","","",4,N],[13,"Multiply","","",4,N],[13,"MultiplyEqual","","",4,N],[13,"Divide","","",4,N],[13,"DivideEqual","","",4,N],[13,"Modulo","","",4,N],[13,"ModuloEqual","","",4,N],[13,"Equal","","",4,N],[4,"Token","","",N,N],[13,"Keyword","","",5,N],[13,"Char","","",5,N],[13,"String","","",5,N],[13,"Comment","","",5,N],[13,"License","","",5,N],[13,"Other","","",5,N],[13,"Regex","","",5,N],[12,"regex","minifier::js::token::Token","",5,N],[12,"is_global","","",5,N],[12,"is_interactive","","",5,N],[13,"Condition","minifier::js::token","",5,N],[13,"Operation","","",5,N],[5,"get_required","","",N,[[["token"]],["option",["char"]]]],[5,"get_line_comment","","",N,[[["str"],["peekable"],["usize"]],["option",["token"]]]],[5,"get_regex","","",N,[[["str"],["peekable"],["usize"]],["option",["token"]]]],[5,"get_comment","","",N,[[["str"],["peekable"],["usize"]],["option",["token"]]]],[5,"get_string","","",N,[[["str"],["peekable"],["usize"],["reservedchar"]],["option",["token"]]]],[5,"first_useful","","",N,N],[5,"fill_other","","",N,[[["str"],["vec"],["usize"],["usize"]]]],[5,"tokenize","","",N,[[["str"]],["tokens"]]],[5,"clean_tokens","","",N,[[["tokens"]]]],[8,"MyTryFrom","","",N,N],[16,"Error","","",6,N],[10,"try_from","","",6,[[["t"]],["result"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"eq","","",2,[[["self"],["reservedchar"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",2,N],[11,"clone","","",2,[[["self"]],["reservedchar"]]],[11,"is_useless","","",2,[[["self"]],["bool"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",2,[[["char"]],["result",["reservedchar"]]]],[11,"fmt","minifier::js","",0,[[["self"],["formatter"]],["result"]]],[11,"eq","","",0,[[["self"],["keyword"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",0,N],[11,"clone","","",0,[[["self"]],["keyword"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",0,[[["str"]],["result",["keyword"]]]],[11,"fmt","minifier::js::token","",3,[[["self"],["formatter"]],["result"]]],[11,"eq","","",3,[[["self"],["condition"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",3,N],[11,"clone","","",3,[[["self"]],["condition"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",3,[[["reservedchar"]],["result",["condition"]]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"eq","","",4,[[["self"],["operation"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",4,N],[11,"clone","","",4,[[["self"]],["operation"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",4,[[["reservedchar"]],["result",["operation"]]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"eq","","",5,[[["self"],["token"]],["bool"]]],[11,"ne","","",5,[[["self"],["token"]],["bool"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"is_comment","","",5,[[["self"]],["bool"]]],[11,"get_char","","",5,[[["self"]],["option",["reservedchar"]]]],[11,"is_char","","",5,[[["self"],["reservedchar"]],["bool"]]],[11,"is_operation","","",5,[[["self"],["operation"]],["bool"]]],[11,"is_condition","","",5,[[["self"],["condition"]],["bool"]]],[11,"is_other","","",5,[[["self"]],["bool"]]],[11,"is_white_character","","",5,[[["self"]],["bool"]]],[11,"get_keyword","","",5,[[["self"]],["option",["keyword"]]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"eq","","",1,[[["self"],["tokens"]],["bool"]]],[11,"ne","","",1,[[["self"],["tokens"]],["bool"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[0,"js","minifier::js","",N,N],[5,"minify","minifier::js::js","",N,[[["str"]],["string"]]],[5,"minify_and_replace_keywords","","",N,N],[0,"css","minifier","",N,N],[5,"minify","minifier::css","",N,[[["str"]],["result",["string","str"]]]],[0,"token","","",N,N],[3,"Tokens","minifier::css::token","",N,N],[12,"0","","",7,N],[4,"ReservedChar","","",N,N],[13,"Comma","","",8,N],[13,"SuperiorThan","","",8,N],[13,"OpenParenthese","","",8,N],[13,"CloseParenthese","","",8,N],[13,"OpenCurlyBrace","","",8,N],[13,"CloseCurlyBrace","","",8,N],[13,"OpenBracket","","",8,N],[13,"CloseBracket","","",8,N],[13,"Colon","","",8,N],[13,"SemiColon","","",8,N],[13,"Slash","","",8,N],[13,"Plus","","",8,N],[13,"EqualSign","","",8,N],[13,"Space","","",8,N],[13,"Tab","","",8,N],[13,"Backline","","",8,N],[13,"Star","","",8,N],[13,"Quote","","",8,N],[13,"DoubleQuote","","",8,N],[13,"Pipe","","",8,N],[13,"Tilde","","",8,N],[13,"Dollar","","",8,N],[13,"Circumflex","","",8,N],[4,"SelectorElement","","",N,N],[13,"PseudoClass","","",9,N],[13,"Class","","",9,N],[13,"Id","","",9,N],[13,"Tag","","",9,N],[13,"Media","","",9,N],[4,"SelectorOperator","","",N,N],[13,"OneAttributeEquals","","`~=`",10,N],[13,"EqualsOrStartsWithFollowedByDash","","`|=`",10,N],[13,"EndsWith","","`$=`",10,N],[13,"FirstStartsWith","","`^=`",10,N],[13,"Contains","","`*=`",10,N],[4,"Token","","",N,N],[13,"Comment","","Comment.",11,N],[13,"License","","Comment starting with `/**`.",11,N],[13,"Char","","",11,N],[13,"Other","","",11,N],[13,"SelectorElement","","",11,N],[13,"String","","",11,N],[13,"SelectorOperator","","",11,N],[5,"get_line_comment","","",N,[[["str"],["peekable"],["usize"]],["option",["token"]]]],[5,"get_comment","","",N,[[["str"],["peekable"],["usize"]],["option",["token"]]]],[5,"get_string","","",N,[[["str"],["peekable"],["usize"],["reservedchar"]],["option",["token"]]]],[5,"fill_other","","",N,[[["str"],["vec"],["usize"],["usize"],["isize"],["bool"],["bool"]]]],[5,"tokenize","","",N,[[["str"]],["result",["tokens","str"]]]],[5,"clean_tokens","","",N,[[["vec",["token"]]],["vec",["token"]]]],[8,"MyTryFrom","","",N,N],[16,"Error","","",12,N],[10,"try_from","","",12,[[["t"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"eq","","",8,[[["self"],["reservedchar"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",8,N],[11,"clone","","",8,[[["self"]],["reservedchar"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",8,[[["char"]],["result",["reservedchar"]]]],[11,"is_useless","","",8,[[["self"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",9,N],[11,"eq","","",9,[[["self"],["selectorelement"]],["bool"]]],[11,"ne","","",9,[[["self"],["selectorelement"]],["bool"]]],[11,"clone","","",9,[[["self"]],["selectorelement"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",9,[[["str"]],["result",["selectorelement"]]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",10,N],[11,"eq","","",10,[[["self"],["selectoroperator"]],["bool"]]],[11,"clone","","",10,[[["self"]],["selectoroperator"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",11,N],[11,"eq","","",11,[[["self"],["token"]],["bool"]]],[11,"ne","","",11,[[["self"],["token"]],["bool"]]],[11,"clone","","",11,[[["self"]],["token"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"is_comment","","",11,[[["self"]],["bool"]]],[11,"is_char","","",11,[[["self"]],["bool"]]],[11,"get_char","","",11,[[["self"]],["option",["reservedchar"]]]],[11,"is_useless","","",11,[[["self"]],["bool"]]],[11,"is_media","","",11,[[["self"],["str"]],["bool"]]],[11,"is_a_media","","",11,[[["self"]],["bool"]]],[11,"is_a_license","","",11,[[["self"]],["bool"]]],[11,"eq","","",11,[[["self"],["reservedchar"]],["bool"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"eq","","",7,[[["self"],["tokens"]],["bool"]]],[11,"ne","","",7,[[["self"],["tokens"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",7,N],[11,"clone","","",7,[[["self"]],["tokens"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[0,"css","minifier::css","",N,N],[5,"minify","minifier::css::css","",N,[[["str"]],["result",["string","str"]]]]],"paths":[[4,"Keyword"],[3,"Tokens"],[4,"ReservedChar"],[4,"Condition"],[4,"Operation"],[4,"Token"],[8,"MyTryFrom"],[3,"Tokens"],[4,"ReservedChar"],[4,"SelectorElement"],[4,"SelectorOperator"],[4,"Token"],[8,"MyTryFrom"]]};
searchIndex["proc_macro"]={"doc":"A support library for macro authors when defining new macros.","items":[[3,"Diagnostic","proc_macro","A structure representing a diagnostic message and associated children messages.",N,N],[12,"level","","",0,N],[12,"message","","",0,N],[12,"span","","",0,N],[12,"children","","",0,N],[3,"TokenStream","","The main type provided by this crate, representing an abstract stream of tokens, or, more specifically, a sequence of token trees. The type provide interfaces for iterating over those token trees and, conversely, collecting a number of token trees into one stream.",N,N],[12,"0","","",1,N],[3,"LexError","","Error returned from `TokenStream::from_str`.",N,N],[12,"_inner","","",2,N],[3,"Span","","A region of source code, along with macro expansion information.",N,N],[12,"0","","",3,N],[3,"LineColumn","","A line-column pair representing the start or end of a `Span`.",N,N],[12,"line","","The 1-indexed line in the source file on which the span starts or ends (inclusive).",4,N],[12,"column","","The 0-indexed column (in UTF-8 characters) in the source file on which the span starts or ends (inclusive).",4,N],[3,"SourceFile","","The source file of a given `Span`.",N,N],[12,"filemap","","",5,N],[3,"Group","","A delimited token stream.",N,N],[12,"delimiter","","",6,N],[12,"stream","","",6,N],[12,"span","","",6,N],[3,"Punct","","An `Punct` is an single punctuation character like `+`, `-` or `#`.",N,N],[12,"ch","","",7,N],[12,"spacing","","",7,N],[12,"span","","",7,N],[3,"Ident","","An identifier (`ident`).",N,N],[12,"sym","","",8,N],[12,"span","","",8,N],[12,"is_raw","","",8,N],[3,"Literal","","A literal string (`\"hello\"`), byte string (`b\"hello\"`), character (`'a'`), byte character (`b'a'`), an integer or floating point number with or without a suffix (`1`, `1u8`, `2.3`, `2.3f32`). Boolean literals like `true` and `false` do not belong here, they are `Ident`s.",N,N],[12,"lit","","",9,N],[12,"suffix","","",9,N],[12,"span","","",9,N],[4,"Level","","An enum representing a diagnostic level.",N,N],[13,"Error","","An error.",10,N],[13,"Warning","","A warning.",10,N],[13,"Note","","A note.",10,N],[13,"Help","","A help message.",10,N],[13,"__Nonexhaustive","","",10,N],[4,"TokenTree","","A single token or a delimited sequence of token trees (e.g. `[1, (), ..]`).",N,N],[13,"Group","","A token stream surrounded by bracket delimiters.",11,N],[13,"Ident","","An identifier.",11,N],[13,"Punct","","A single punctuation character (`+`, `,`, `$`, etc.).",11,N],[13,"Literal","","A literal character (`'a'`), string (`\"hello\"`), number (`2.3`), etc.",11,N],[4,"Delimiter","","Describes how a sequence of token trees is delimited.",N,N],[13,"Parenthesis","","`( ... )`",12,N],[13,"Brace","","`{ ... }`",12,N],[13,"Bracket","","`[ ... ]`",12,N],[13,"None","","`Ø ... Ø` An implicit delimiter, that may, for example, appear around tokens coming from a \"macro variable\" `$var`. It is important to preserve operator priorities in cases like `$var * 3` where `$var` is `1 + 2`. Implicit delimiters may not survive roundtrip of a token stream through a string.",12,N],[4,"Spacing","","Whether an `Punct` is followed immediately by another `Punct` or followed by another token or whitespace.",N,N],[13,"Alone","","E.g. `+` is `Alone` in `+ =`, `+ident` or `+()`.",13,N],[13,"Joint","","E.g. `+` is `Joint` in `+=` or `'#`. Additionally, single quote `'` can join with identifiers to form lifetimes `'ident`.",13,N],[5,"quote","","Quote a `TokenStream` into a `TokenStream`. This is the actual `quote!()` proc macro.",N,[[["tokenstream"]],["tokenstream"]]],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to implement a custom quoter.",N,[[["span"]],["tokenstream"]]],[5,"parse_to_lex_err","","",N,[[["diagnosticbuilder"]],["lexerror"]]],[0,"rustc","","",N,N],[11,"new_maybe_raw","","",8,[[["str"],["span"],["bool"]],["ident"]]],[11,"from_internal","","",12,[[["delimtoken"]],["delimiter"]]],[11,"to_internal","","",12,[[["self"]],["delimtoken"]]],[11,"from_internal","","",11,[[["tokenstream"],["vec"]],["tokentree"]]],[11,"to_internal","","",11,[[["self"]],["tokenstream"]]],[11,"to_internal","","",10,[[["self"]],["level"]]],[0,"diagnostic","","",N,N],[3,"Diagnostic","proc_macro::diagnostic","A structure representing a diagnostic message and associated children messages.",N,N],[12,"level","","",0,N],[12,"message","","",0,N],[12,"span","","",0,N],[12,"children","","",0,N],[4,"Level","","An enum representing a diagnostic level.",N,N],[13,"Error","","An error.",10,N],[13,"Warning","","A warning.",10,N],[13,"Note","","A note.",10,N],[13,"Help","","A help message.",10,N],[13,"__Nonexhaustive","","",10,N],[11,"clone","proc_macro","",10,[[["self"]],["level"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"clone","","",0,[[["self"]],["diagnostic"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new diagnostic with the given `level` and `message`.",0,[[["level"],["t"]],["diagnostic"]]],[11,"spanned","","Create a new diagnostic with the given `level` and `message` pointing to the given `span`.",0,[[["span"],["level"],["t"]],["diagnostic"]]],[11,"span_error","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,[[["self"],["span"],["t"]],["diagnostic"]]],[11,"error","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,[[["self"],["t"]],["diagnostic"]]],[11,"span_warning","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,[[["self"],["span"],["t"]],["diagnostic"]]],[11,"warning","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,[[["self"],["t"]],["diagnostic"]]],[11,"span_note","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,[[["self"],["span"],["t"]],["diagnostic"]]],[11,"note","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,[[["self"],["t"]],["diagnostic"]]],[11,"span_help","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,[[["self"],["span"],["t"]],["diagnostic"]]],[11,"help","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,[[["self"],["t"]],["diagnostic"]]],[11,"level","","Returns the diagnostic `level` for `self`.",0,[[["self"]],["level"]]],[11,"emit","","Emit the diagnostic.",0,[[["self"]]]],[0,"token_stream","","Public implementation details for the `TokenStream` type, such as iterators.",N,N],[3,"IntoIter","proc_macro::token_stream","An iterator over `TokenStream`'s `TokenTree`s. The iteration is \"shallow\", e.g. the iterator doesn't recurse into delimited groups, and returns whole groups as token trees.",N,N],[12,"cursor","","",14,N],[12,"stack","","",14,N],[11,"clone","","",14,[[["self"]],["intoiter"]]],[11,"next","","",14,[[["self"]],["option",["tokentree"]]]],[11,"into_iter","proc_macro","",1,[[["self"]],["intoiter"]]],[0,"quote","","Quasiquoter This file contains the implementation internals of the quasiquoter provided by `quote!`. This quasiquoter uses macros 2.0 hygiene to reliably access items from `proc_macro`, to build a `proc_macro::TokenStream`.",N,N],[5,"quote","proc_macro::quote","Quote a `TokenStream` into a `TokenStream`. This is the actual `quote!()` proc macro.",N,[[["tokenstream"]],["tokenstream"]]],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to implement a custom quoter.",N,[[["span"]],["tokenstream"]]],[0,"__internal","proc_macro","Permanently unstable internal implementation details of this crate. This should not be used.",N,N],[3,"ProcMacroData","proc_macro::__internal","",N,N],[12,"def_site","","",15,N],[12,"call_site","","",15,N],[3,"ProcMacroSess","","",N,N],[12,"parse_sess","","",16,N],[12,"data","","",16,N],[5,"lookup_char_pos","","",N,[[["bytepos"]],["loc"]]],[5,"new_token_stream","","",N,[[["p",["item"]]],["tokenstream"]]],[5,"token_stream_wrap","","",N,[[["tokenstream"]],["tokenstream"]]],[5,"token_stream_parse_items","","",N,[[["tokenstream"]],["result",["vec","lexerror"]]]],[5,"token_stream_inner","","",N,[[["tokenstream"]],["tokenstream"]]],[5,"set_sess","","",N,[[["extctxt"],["f"]],["r"]]],[5,"in_sess","","",N,[[],["bool"]]],[5,"with_sess","","",N,[[["f"]],["r"]]],[17,"CURRENT_SESS","","",N,N],[8,"Registry","","",N,N],[10,"register_custom_derive","","",17,N],[10,"register_attr_proc_macro","","",17,N],[10,"register_bang_proc_macro","","",17,N],[11,"clone","","",15,[[["self"]],["procmacrodata"]]],[11,"clone","","",16,[[["self"]],["procmacrosess"]]],[11,"clone","proc_macro","",1,[[["self"]],["tokenstream"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"new","","Returns an empty `TokenStream` containing no token trees.",1,[[],["tokenstream"]]],[11,"is_empty","","Checks if this `TokenStream` is empty.",1,[[["self"]],["bool"]]],[11,"from_str","","",1,[[["str"]],["result",["tokenstream","lexerror"]]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"from","","",1,[[["tokentree"]],["tokenstream"]]],[11,"from_iter","","",1,[[["i"]],["self"]]],[11,"from_iter","","",1,[[["i"]],["self"]]],[11,"clone","","",3,[[["self"]],["span"]]],[11,"def_site","","A span that resolves at the macro definition site.",3,[[],["span"]]],[11,"call_site","","The span of the invocation of the current procedural macro. Identifiers created with this span will be resolved as if they were written directly at the macro call location (call-site hygiene) and other code at the macro call site will be able to refer to them as well.",3,[[],["span"]]],[11,"source_file","","The original source file into which this span points.",3,[[["self"]],["sourcefile"]]],[11,"parent","","The `Span` for the tokens in the previous macro expansion from which `self` was generated from, if any.",3,[[["self"]],["option",["span"]]]],[11,"source","","The span for the origin source code that `self` was generated from. If this `Span` wasn't generated from other macro expansions then the return value is the same as `*self`.",3,[[["self"]],["span"]]],[11,"start","","Get the starting line/column in the source file for this span.",3,[[["self"]],["linecolumn"]]],[11,"end","","Get the ending line/column in the source file for this span.",3,[[["self"]],["linecolumn"]]],[11,"join","","Create a new span encompassing `self` and `other`.",3,[[["self"],["span"]],["option",["span"]]]],[11,"resolved_at","","Creates a new span with the same line/column information as `self` but that resolves symbols as though it were at `other`.",3,[[["self"],["span"]],["span"]]],[11,"located_at","","Creates a new span with the same name resolution behavior as `self` but with the line/column information of `other`.",3,[[["self"],["span"]],["span"]]],[11,"eq","","Compares to spans to see if they're equal.",3,[[["self"],["span"]],["bool"]]],[11,"error","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,[[["self"],["t"]],["diagnostic"]]],[11,"warning","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,[[["self"],["t"]],["diagnostic"]]],[11,"note","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,[[["self"],["t"]],["diagnostic"]]],[11,"help","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,[[["self"],["t"]],["diagnostic"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"clone","","",4,[[["self"]],["linecolumn"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"eq","","",4,[[["self"],["linecolumn"]],["bool"]]],[11,"ne","","",4,[[["self"],["linecolumn"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",4,N],[11,"clone","","",5,[[["self"]],["sourcefile"]]],[11,"path","","Get the path to this source file.",5,[[["self"]],["pathbuf"]]],[11,"is_real","","Returns `true` if this source file is a real source file, and not generated by an external macro's expansion.",5,[[["self"]],["bool"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"eq","","",5,[[["self"],["self"]],["bool"]]],[11,"clone","","",11,[[["self"]],["tokentree"]]],[11,"span","","Returns the span of this tree, delegating to the `span` method of the contained token or a delimited stream.",11,[[["self"]],["span"]]],[11,"set_span","","Configures the span for only this token.",11,[[["self"],["span"]]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"from","","",11,[[["group"]],["tokentree"]]],[11,"from","","",11,[[["ident"]],["tokentree"]]],[11,"from","","",11,[[["punct"]],["tokentree"]]],[11,"from","","",11,[[["literal"]],["tokentree"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"clone","","",6,[[["self"]],["group"]]],[11,"clone","","",12,[[["self"]],["delimiter"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"eq","","",12,[[["self"],["delimiter"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",12,N],[11,"new","","Creates a new `Group` with the given delimiter and token stream.",6,[[["delimiter"],["tokenstream"]],["group"]]],[11,"delimiter","","Returns the delimiter of this `Group`",6,[[["self"]],["delimiter"]]],[11,"stream","","Returns the `TokenStream` of tokens that are delimited in this `Group`.",6,[[["self"]],["tokenstream"]]],[11,"span","","Returns the span for the delimiters of this token stream, spanning the entire `Group`.",6,[[["self"]],["span"]]],[11,"set_span","","Configures the span for this `Group`'s delimiters, but not its internal tokens.",6,[[["self"],["span"]]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"clone","","",7,[[["self"]],["punct"]]],[11,"clone","","",13,[[["self"]],["spacing"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"eq","","",13,[[["self"],["spacing"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",13,N],[11,"new","","Creates a new `Punct` from the given character and spacing. The `ch` argument must be a valid punctuation character permitted by the language, otherwise the function will panic.",7,[[["char"],["spacing"]],["punct"]]],[11,"as_char","","Returns the value of this punctuation character as `char`.",7,[[["self"]],["char"]]],[11,"spacing","","Returns the spacing of this punctuation character, indicating whether it's immediately followed by another `Punct` in the token stream, so they can potentially be combined into a multicharacter operator (`Joint`), or it's followed by some other token or whitespace (`Alone`) so the operator has certainly ended.",7,[[["self"]],["spacing"]]],[11,"span","","Returns the span for this punctuation character.",7,[[["self"]],["span"]]],[11,"set_span","","Configure the span for this punctuation character.",7,[[["self"],["span"]]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"clone","","",8,[[["self"]],["ident"]]],[11,"is_valid","","",8,[[["str"]],["bool"]]],[11,"new","","Creates a new `Ident` with the given `string` as well as the specified `span`. The `string` argument must be a valid identifier permitted by the language, otherwise the function will panic.",8,[[["str"],["span"]],["ident"]]],[11,"new_raw","","Same as `Ident::new`, but creates a raw identifier (`r#ident`).",8,[[["str"],["span"]],["ident"]]],[11,"span","","Returns the span of this `Ident`, encompassing the entire string returned by `as_str`.",8,[[["self"]],["span"]]],[11,"set_span","","Configures the span of this `Ident`, possibly changing its hygiene context.",8,[[["self"],["span"]]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"clone","","",9,[[["self"]],["literal"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"u8_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["u8"]],["literal"]]],[11,"u16_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["u16"]],["literal"]]],[11,"u32_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["u32"]],["literal"]]],[11,"u64_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["u64"]],["literal"]]],[11,"u128_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["u128"]],["literal"]]],[11,"usize_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["usize"]],["literal"]]],[11,"i8_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["i8"]],["literal"]]],[11,"i16_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["i16"]],["literal"]]],[11,"i32_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["i32"]],["literal"]]],[11,"i64_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["i64"]],["literal"]]],[11,"i128_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["i128"]],["literal"]]],[11,"isize_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["isize"]],["literal"]]],[11,"u8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["u8"]],["literal"]]],[11,"u16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["u16"]],["literal"]]],[11,"u32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["u32"]],["literal"]]],[11,"u64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["u64"]],["literal"]]],[11,"u128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["u128"]],["literal"]]],[11,"usize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["usize"]],["literal"]]],[11,"i8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["i8"]],["literal"]]],[11,"i16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["i16"]],["literal"]]],[11,"i32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["i32"]],["literal"]]],[11,"i64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["i64"]],["literal"]]],[11,"i128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["i128"]],["literal"]]],[11,"isize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["isize"]],["literal"]]],[11,"f32_unsuffixed","","Creates a new unsuffixed floating-point literal.",9,[[["f32"]],["literal"]]],[11,"f32_suffixed","","Creates a new suffixed floating-point literal.",9,[[["f32"]],["literal"]]],[11,"f64_unsuffixed","","Creates a new unsuffixed floating-point literal.",9,[[["f64"]],["literal"]]],[11,"f64_suffixed","","Creates a new suffixed floating-point literal.",9,[[["f64"]],["literal"]]],[11,"string","","String literal.",9,[[["str"]],["literal"]]],[11,"character","","Character literal.",9,[[["char"]],["literal"]]],[11,"byte_string","","Byte string literal.",9,N],[11,"span","","Returns the span encompassing this literal.",9,[[["self"]],["span"]]],[11,"set_span","","Configures the span associated for this literal.",9,[[["self"],["span"]]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[14,"quote","","`quote!(..)` accepts arbitrary tokens and expands into a `TokenStream` describing the input. For example, `quote!(a + b)` will produce a expression, that, when evaluated, constructs the `TokenStream` `[Ident(\"a\"), Punct('+', Alone), Ident(\"b\")]`.",N,N]],"paths":[[3,"Diagnostic"],[3,"TokenStream"],[3,"LexError"],[3,"Span"],[3,"LineColumn"],[3,"SourceFile"],[3,"Group"],[3,"Punct"],[3,"Ident"],[3,"Literal"],[4,"Level"],[4,"TokenTree"],[4,"Delimiter"],[4,"Spacing"],[3,"IntoIter"],[3,"ProcMacroData"],[3,"ProcMacroSess"],[8,"Registry"]]};
searchIndex["pulldown_cmark"]={"doc":"Pull parser for commonmark.","items":[[3,"Parser","pulldown_cmark","",N,N],[12,"inner","","",0,N],[12,"loose_lists","","",0,N],[12,"loose_stack","","",0,N],[3,"Options","","",N,N],[12,"bits","","",1,N],[4,"Alignment","","",N,N],[13,"None","","",2,N],[13,"Left","","",2,N],[13,"Center","","",2,N],[13,"Right","","",2,N],[4,"Event","","",N,N],[13,"Start","","",3,N],[13,"End","","",3,N],[13,"Text","","",3,N],[13,"Html","","",3,N],[13,"InlineHtml","","",3,N],[13,"FootnoteReference","","",3,N],[13,"SoftBreak","","",3,N],[13,"HardBreak","","",3,N],[4,"Tag","","",N,N],[13,"Paragraph","","",4,N],[13,"Rule","","",4,N],[13,"Header","","A heading. The field indicates the level of the heading.",4,N],[13,"BlockQuote","","",4,N],[13,"CodeBlock","","",4,N],[13,"List","","A list. If the list is ordered the field indicates the number of the first item.",4,N],[13,"Item","","",4,N],[13,"FootnoteDefinition","","",4,N],[13,"Table","","",4,N],[13,"TableHead","","",4,N],[13,"TableRow","","",4,N],[13,"TableCell","","",4,N],[13,"Emphasis","","",4,N],[13,"Strong","","",4,N],[13,"Code","","",4,N],[13,"Link","","A link. The first field is the destination URL, the second is a title",4,N],[13,"Image","","An image. The first field is the destination URL, the second is a title",4,N],[0,"html","","HTML renderer that takes an iterator of events as input.",N,N],[3,"Ctx","pulldown_cmark::html","",N,N],[12,"iter","","",5,N],[12,"buf","","",5,N],[12,"table_state","","",5,N],[12,"table_alignments","","",5,N],[12,"table_cell_index","","",5,N],[4,"TableState","","",N,N],[13,"Head","","",6,N],[13,"Body","","",6,N],[5,"push_html","","Iterate over an `Iterator` of `Event`s, generate HTML for each `Event`, and push it to a `String`.",N,[[["string"],["i"]]]],[11,"fresh_line","","",5,[[["self"]]]],[11,"run","","",5,[[["self"]]]],[11,"start_tag","","",5,[[["self"],["tag"],["hashmap"]]]],[11,"end_tag","","",5,[[["self"],["tag"]]]],[11,"raw_text","","",5,[[["self"],["hashmap"]]]],[0,"passes","pulldown_cmark","Main public pull parse interface, running two passes over input.",N,N],[3,"Parser","pulldown_cmark::passes","",N,N],[12,"inner","","",0,N],[12,"loose_lists","","",0,N],[12,"loose_stack","","",0,N],[11,"new","pulldown_cmark","",0,[[["str"]],["parser"]]],[11,"new_ext","","",0,[[["str"],["options"]],["parser"]]],[11,"new_with_broken_link_callback","","In case the parser encounters any potential links that have a broken reference (e.g `[foo]` when there is no `[foo]:` entry at the bottom) the provided callback will be called with the reference name, and the returned pair will be used as the link name and title if not None.",0,[[["str"],["options"],["option",["fn"]]],["parser"]]],[11,"get_offset","","",0,[[["self"]],["usize"]]],[11,"next","","",0,[[["self"]],["option",["event"]]]],[0,"parse","","Raw parser, for doing a single pass over input.",N,N],[3,"RawParser","pulldown_cmark::parse","",N,N],[12,"text","","",7,N],[12,"off","","",7,N],[12,"opts","","",7,N],[12,"active_tab","","",7,N],[12,"state","","",7,N],[12,"stack","","",7,N],[12,"leading_space","","",7,N],[12,"containers","","",7,N],[12,"last_line_was_empty","","",7,N],[12,"broken_link_callback","","In case we have a broken link/image reference, we can call this callback with the reference name (both normalized and not normalized) and use the link/title pair returned instead",7,N],[12,"fence_char","","",7,N],[12,"fence_count","","",7,N],[12,"fence_indent","","",7,N],[12,"loose_lists","","",7,N],[12,"links","","",7,N],[3,"ParseInfo","","",N,N],[12,"loose_lists","","",8,N],[12,"links","","",8,N],[3,"Options","","",N,N],[12,"bits","","",1,N],[4,"State","","",N,N],[13,"StartBlock","","",9,N],[13,"InContainers","","",9,N],[13,"Inline","","",9,N],[13,"TableHead","","",9,N],[13,"TableBody","","",9,N],[13,"TableRow","","",9,N],[13,"CodeLineStart","","",9,N],[13,"Code","","",9,N],[13,"InlineCode","","",9,N],[13,"Literal","","",9,N],[4,"Container","","",N,N],[13,"BlockQuote","","",10,N],[13,"List","","",10,N],[13,"ListItem","","",10,N],[13,"FootnoteDefinition","","",10,N],[4,"Tag","","",N,N],[13,"Paragraph","","",4,N],[13,"Rule","","",4,N],[13,"Header","","A heading. The field indicates the level of the heading.",4,N],[13,"BlockQuote","","",4,N],[13,"CodeBlock","","",4,N],[13,"List","","A list. If the list is ordered the field indicates the number of the first item.",4,N],[13,"Item","","",4,N],[13,"FootnoteDefinition","","",4,N],[13,"Table","","",4,N],[13,"TableHead","","",4,N],[13,"TableRow","","",4,N],[13,"TableCell","","",4,N],[13,"Emphasis","","",4,N],[13,"Strong","","",4,N],[13,"Code","","",4,N],[13,"Link","","A link. The first field is the destination URL, the second is a title",4,N],[13,"Image","","An image. The first field is the destination URL, the second is a title",4,N],[4,"Event","","",N,N],[13,"Start","","",3,N],[13,"End","","",3,N],[13,"Text","","",3,N],[13,"Html","","",3,N],[13,"InlineHtml","","",3,N],[13,"FootnoteReference","","",3,N],[13,"SoftBreak","","",3,N],[13,"HardBreak","","",3,N],[4,"Alignment","","",N,N],[13,"None","","",2,N],[13,"Left","","",2,N],[13,"Center","","",2,N],[13,"Right","","",2,N],[17,"OPTION_FIRST_PASS","","",N,N],[17,"OPTION_ENABLE_TABLES","","",N,N],[17,"OPTION_ENABLE_FOOTNOTES","","",N,N],[17,"MAX_LINK_NEST","","",N,N],[11,"eq","","",9,[[["self"],["state"]],["bool"]]],[11,"ne","","",9,[[["self"],["state"]],["bool"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"clone","","",10,[[["self"]],["container"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"eq","","",10,[[["self"],["container"]],["bool"]]],[11,"ne","","",10,[[["self"],["container"]],["bool"]]],[11,"clone","pulldown_cmark","",4,[[["self"]],["tag"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"eq","","",4,[[["self"],["tag"]],["bool"]]],[11,"ne","","",4,[[["self"],["tag"]],["bool"]]],[11,"clone","","",3,[[["self"]],["event"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"eq","","",3,[[["self"],["event"]],["bool"]]],[11,"ne","","",3,[[["self"],["event"]],["bool"]]],[11,"clone","","",2,[[["self"]],["alignment"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"eq","","",2,[[["self"],["alignment"]],["bool"]]],[11,"eq","","",1,[[["self"],["options"]],["bool"]]],[11,"ne","","",1,[[["self"],["options"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",1,N],[11,"clone","","",1,[[["self"]],["options"]]],[11,"partial_cmp","","",1,[[["self"],["options"]],["option",["ordering"]]]],[11,"lt","","",1,[[["self"],["options"]],["bool"]]],[11,"le","","",1,[[["self"],["options"]],["bool"]]],[11,"gt","","",1,[[["self"],["options"]],["bool"]]],[11,"ge","","",1,[[["self"],["options"]],["bool"]]],[11,"cmp","","",1,[[["self"],["options"]],["ordering"]]],[11,"hash","","",1,N],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"empty","","Returns an empty set of flags.",1,[[],["options"]]],[11,"all","","Returns the set containing all flags.",1,[[],["options"]]],[11,"bits","","Returns the raw value of the flags currently stored.",1,[[["self"]],["u32"]]],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",1,[[["u32"]],["option",["options"]]]],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",1,[[["u32"]],["options"]]],[11,"is_empty","","Returns `true` if no flags are currently stored.",1,[[["self"]],["bool"]]],[11,"is_all","","Returns `true` if all flags are currently set.",1,[[["self"]],["bool"]]],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",1,[[["self"],["options"]],["bool"]]],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",1,[[["self"],["options"]],["bool"]]],[11,"insert","","Inserts the specified flags in-place.",1,[[["self"],["options"]]]],[11,"remove","","Removes the specified flags in-place.",1,[[["self"],["options"]]]],[11,"toggle","","Toggles the specified flags in-place.",1,[[["self"],["options"]]]],[11,"set","","Inserts or removes the specified flags depending on the passed value.",1,[[["self"],["options"],["bool"]]]],[11,"bitor","","Returns the union of the two sets of flags.",1,[[["self"],["options"]],["options"]]],[11,"bitor_assign","","Adds the set of flags.",1,[[["self"],["options"]]]],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",1,[[["self"],["options"]],["options"]]],[11,"bitxor_assign","","Toggles the set of flags.",1,[[["self"],["options"]]]],[11,"bitand","","Returns the intersection between the two sets of flags.",1,[[["self"],["options"]],["options"]]],[11,"bitand_assign","","Disables all flags disabled in the set.",1,[[["self"],["options"]]]],[11,"sub","","Returns the set difference of the two sets of flags.",1,[[["self"],["options"]],["options"]]],[11,"sub_assign","","Disables all flags enabled in the set.",1,[[["self"],["options"]]]],[11,"not","","Returns the complement of this set of flags.",1,[[["self"]],["options"]]],[11,"extend","","",1,[[["self"],["t"]]]],[11,"from_iter","","",1,[[["t"]],["options"]]],[11,"new_with_links_and_callback","pulldown_cmark::parse","",7,[[["str"],["options"],["hashmap",["string"]],["option",["fn"]]],["rawparser"]]],[11,"new_with_links","","",7,[[["str"],["options"],["hashmap",["string"]]],["rawparser"]]],[11,"new","","",7,[[["str"],["options"]],["rawparser"]]],[11,"get_offset","","",7,[[["self"]],["usize"]]],[11,"get_info","","",7,[[["self"]],["parseinfo"]]],[11,"init_active","","",7,[[["self"]]]],[11,"limit","","",7,[[["self"]],["usize"]]],[11,"start","","",7,[[["self"],["tag"],["usize"],["usize"]],["event"]]],[11,"end","","",7,[[["self"]],["event"]]],[11,"skip_leading_whitespace","","",7,[[["self"]]]],[11,"skip_blank_lines","","",7,[[["self"]]]],[11,"scan_containers","","",7,N],[11,"scan_empty_lines","","",7,N],[11,"scan_whitespace_inline","","",7,[[["self"],["str"]],["usize"]]],[11,"at_list","","",7,[[["self"],["usize"]],["option",["usize"]]]],[11,"start_block","","",7,[[["self"]],["option",["event"]]]],[11,"start_paragraph","","",7,[[["self"]],["event"]]],[11,"start_table_head","","",7,[[["self"]],["event"]]],[11,"start_table_body","","",7,[[["self"]],["event"]]],[11,"start_hrule","","",7,[[["self"]],["event"]]],[11,"start_atx_header","","",7,[[["self"],["i32"]],["event"]]],[11,"start_indented_code","","",7,[[["self"]],["event"]]],[11,"start_listitem","","",7,[[["self"],["usize"],["u8"],["usize"],["usize"]],["event"]]],[11,"start_code_fence","","",7,[[["self"],["usize"],["u8"],["usize"]],["event"]]],[11,"next_code_line_start","","",7,[[["self"]],["event"]]],[11,"next_code","","",7,[[["self"]],["event"]]],[11,"is_code_block_end","","",7,[[["self"],["usize"],["usize"]],["bool"]]],[11,"scan_html_block_tag","","",7,N],[11,"is_html_block","","",7,[[["self"],["str"]],["bool"]]],[11,"get_html_tag","","",7,[[["self"]],["option",["str"]]]],[11,"do_html_block","","",7,[[["self"]],["event"]]],[11,"try_link_reference_definition","","",7,[[["self"],["str"]],["bool"]]],[11,"normalize_link_ref","","",7,[[["self"],["str"]],["string"]]],[11,"is_inline_block_end","","",7,[[["self"],["str"],["usize"]],["bool"]]],[11,"next_table_cell","","",7,[[["self"]],["event"]]],[11,"next_inline","","",7,[[["self"]],["event"]]],[11,"active_char","","",7,[[["self"],["u8"]],["option",["event"]]]],[11,"char_null","","",7,[[["self"]],["event"]]],[11,"char_tab","","",7,[[["self"]],["event"]]],[11,"char_backslash","","",7,[[["self"]],["option",["event"]]]],[11,"char_entity","","",7,[[["self"]],["option",["event"]]]],[11,"char_emphasis","","",7,[[["self"]],["option",["event"]]]],[11,"scan_link_label","","",7,N],[11,"scan_link_title","","",7,N],[11,"char_link","","",7,[[["self"]],["option",["event"]]]],[11,"parse_link","","",7,[[["self"],["str"],["bool"]],["option"]]],[11,"contains_link","","",7,[[["self"],["str"]],["bool"]]],[11,"parse_footnote_definition","","",7,[[["self"],["str"]],["option"]]],[11,"char_link_footnote","","",7,[[["self"]],["option",["event"]]]],[11,"parse_footnote","","",7,[[["self"],["str"]],["option"]]],[11,"scan_footnote_label","","",7,N],[11,"char_lt","","",7,[[["self"]],["option",["event"]]]],[11,"scan_autolink_or_html","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_inline_html","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_html_tag","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_attribute_value","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_html_comment","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_processing_instruction","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_declaration","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_cdata","","",7,[[["self"],["str"]],["usize"]]],[11,"inline_html_event","","",7,[[["self"],["usize"]],["event"]]],[11,"next_literal","","",7,[[["self"]],["event"]]],[11,"scan_inline_code","","",7,N],[11,"char_backtick","","",7,[[["self"]],["option",["event"]]]],[11,"next_inline_code","","",7,[[["self"]],["event"]]],[11,"next","","",7,[[["self"]],["option",["event"]]]],[0,"scanners","pulldown_cmark","Scanners for fragments of CommonMark syntax",N,N],[5,"is_ascii_whitespace","pulldown_cmark::scanners","",N,[[["u8"]],["bool"]]],[5,"is_ascii_whitespace_no_nl","","",N,[[["u8"]],["bool"]]],[5,"is_ascii_alpha","","",N,[[["u8"]],["bool"]]],[5,"is_ascii_upper","","",N,[[["u8"]],["bool"]]],[5,"is_ascii_alphanumeric","","",N,[[["u8"]],["bool"]]],[5,"is_hexdigit","","",N,[[["u8"]],["bool"]]],[5,"is_digit","","",N,[[["u8"]],["bool"]]],[5,"scan_ch","","",N,[[["str"],["u8"]],["usize"]]],[5,"scan_while","","",N,[[["str"],["f"]],["usize"]]],[5,"scan_ch_repeat","","",N,[[["str"],["u8"]],["usize"]]],[5,"scan_whitespace_no_nl","","",N,[[["str"]],["usize"]]],[5,"scan_eol","","",N,N],[5,"scan_trailing_whitespace","","",N,[[["str"]],["usize"]]],[5,"scan_codepoint","","",N,[[["str"]],["option",["char"]]]],[5,"scan_trailing_codepoint","","",N,[[["str"]],["option",["char"]]]],[5,"scan_blank_line","","",N,[[["str"]],["usize"]]],[5,"scan_nextline","","",N,[[["str"]],["usize"]]],[5,"count_tab","","",N,N],[5,"scan_leading_space","","",N,N],[5,"calc_indent","","",N,N],[5,"scan_hrule","","",N,[[["str"]],["usize"]]],[5,"scan_atx_header","","",N,N],[5,"scan_setext_header","","",N,N],[5,"scan_table_head","","",N,N],[5,"scan_code_fence","","",N,N],[5,"scan_backticks","","",N,[[["str"]],["usize"]]],[5,"scan_blockquote_start","","",N,[[["str"]],["usize"]]],[5,"scan_listitem","","",N,N],[5,"compute_open_close","","",N,N],[5,"cow_from_codepoint_str","","",N,[[["str"],["u32"]],["cow",["str"]]]],[5,"scan_entity","","",N,N],[5,"scan_link_dest","","",N,[[["str"]],["option"]]],[5,"scan_autolink","","",N,[[["str"]],["option"]]],[5,"scan_uri","","",N,[[["str"]],["usize"]]],[5,"scan_email","","",N,[[["str"]],["usize"]]],[5,"scan_attribute_name","","",N,[[["str"]],["usize"]]],[5,"is_escaped","","",N,[[["str"],["usize"]],["bool"]]],[5,"unescape","","",N,[[["str"]],["cow",["str"]]]],[5,"is_html_tag","","",N,[[["str"]],["bool"]]],[5,"spaces","","",N,[[["usize"]],["cow",["str"]]]],[17,"HTML_TAGS","","",N,N],[17,"URI_SCHEMES","","",N,N],[0,"entities","pulldown_cmark","Expansions of HTML5 entities",N,N],[5,"get_entity","pulldown_cmark::entities","",N,[[["str"]],["option",["str"]]]],[17,"ENTITIES","","",N,N],[17,"ENTITY_VALUES","","",N,N],[0,"escape","pulldown_cmark","Utility functions for HTML escaping",N,N],[5,"escape_href","pulldown_cmark::escape","",N,[[["string"],["str"]]]],[5,"escape_html","","",N,[[["string"],["str"],["bool"]]]],[7,"HREF_SAFE","","",N,N],[7,"HEX_CHARS","","",N,N],[7,"HTML_ESCAPE_TABLE","","",N,N],[7,"HTML_ESCAPES","","",N,N],[0,"puncttable","pulldown_cmark","CommonMark punctuation set based on spec and Unicode properties.",N,N],[5,"is_ascii_punctuation","pulldown_cmark::puncttable","",N,[[["u8"]],["bool"]]],[5,"is_punctuation","","",N,[[["char"]],["bool"]]],[17,"PUNCT_MASKS_ASCII","","",N,N],[17,"PUNCT_TAB","","",N,N],[17,"PUNCT_MASKS","","",N,N],[0,"utils","pulldown_cmark","Utilities for manipulating strings.",N,N],[5,"ascii_tolower","pulldown_cmark::utils","",N,[[["u8"]],["u8"]]],[5,"strcasecmp","","",N,[[["str"],["str"]],["ordering"]]],[5,"cow_append","","",N,[[["cow",["str"]],["cow",["str"]]],["cow",["str"]]]],[17,"OPTION_ENABLE_TABLES","pulldown_cmark","",N,N],[17,"OPTION_ENABLE_FOOTNOTES","","",N,N]],"paths":[[3,"Parser"],[3,"Options"],[4,"Alignment"],[4,"Event"],[4,"Tag"],[3,"Ctx"],[4,"TableState"],[3,"RawParser"],[3,"ParseInfo"],[4,"State"],[4,"Container"]]};
searchIndex["rand"]={"doc":"Utilities for random number generation","items":[[3,"IsaacRng","rand","A random number generator that uses the ISAAC algorithm[1].",N,N],[12,"cnt","","",0,N],[12,"rsl","","",0,N],[12,"mem","","",0,N],[12,"a","","",0,N],[12,"b","","",0,N],[12,"c","","",0,N],[3,"Isaac64Rng","","A random number generator that uses ISAAC-64[1], the 64-bit variant of the ISAAC algorithm.",N,N],[12,"cnt","","",1,N],[12,"rsl","","",1,N],[12,"mem","","",1,N],[12,"a","","",1,N],[12,"b","","",1,N],[12,"c","","",1,N],[3,"ChaChaRng","","A random number generator that uses the ChaCha20 algorithm [1].",N,N],[12,"buffer","","",2,N],[12,"state","","",2,N],[12,"index","","",2,N],[3,"XorShiftRng","","An Xorshift[1] random number generator.",N,N],[12,"x","","",3,N],[12,"y","","",3,N],[12,"z","","",3,N],[12,"w","","",3,N],[3,"Generator","","Iterator which will generate a stream of random items.",N,N],[12,"rng","","",4,N],[12,"_marker","","",4,N],[3,"AsciiGenerator","","Iterator which will continuously generate random ascii characters.",N,N],[12,"rng","","",5,N],[3,"Open01","","A wrapper for generating floating point numbers uniformly in the open interval `(0,1)` (not including either endpoint).",N,N],[12,"0","","",6,N],[3,"Closed01","","A wrapper for generating floating point numbers uniformly in the closed interval `[0,1]` (including both endpoints).",N,N],[12,"0","","",7,N],[3,"StdRng","","The standard RNG. This is designed to be efficient on the current platform.",N,N],[12,"rng","","",8,N],[3,"ThreadRngReseeder","","Controls how the thread-local RNG is reseeded.",N,N],[3,"ThreadRng","","The thread-local RNG.",N,N],[12,"rng","","",9,N],[5,"weak_rng","","Create a weak random number generator with a default algorithm and seed.",N,[[],["xorshiftrng"]]],[5,"thread_rng","","Retrieve the lazily-initialized thread-local random number generator, seeded by the system. Intended to be used in method chaining style, e.g. `thread_rng().gen::<i32>()`.",N,[[],["threadrng"]]],[5,"random","","Generates a random value using the thread-local random number generator.",N,[[],["t"]]],[5,"sample","","DEPRECATED: use `seq::sample_iter` instead.",N,[[["r"],["i"],["usize"]],["vec"]]],[0,"distributions","","Sampling from random distributions.",N,N],[3,"RandSample","rand::distributions","A wrapper for generating types that implement `Rand` via the `Sample` & `IndependentSample` traits.",N,N],[12,"_marker","","",10,N],[3,"Weighted","","A value with a particular weight for use with `WeightedChoice`.",N,N],[12,"weight","","The numerical weight of this item",11,N],[12,"item","","The actual item which is being weighted",11,N],[3,"WeightedChoice","","A distribution that selects from a finite collection of weighted items.",N,N],[12,"items","","",12,N],[12,"weight_range","","",12,N],[5,"ziggurat","","Sample a random number using the Ziggurat method (specifically the ZIGNOR variant from Doornik 2005). Most of the arguments are directly from the paper:",N,N],[0,"range","","Generating numbers between two others.",N,N],[3,"Range","rand::distributions::range","Sample values uniformly between two bounds.",N,N],[12,"low","","",13,N],[12,"range","","",13,N],[12,"accept_zone","","",13,N],[8,"SampleRange","","The helper trait for types that have a sensible way to sample uniformly between two values. This should not be used directly, and is only to facilitate `Range`.",N,N],[10,"construct_range","","Construct the `Range` object that `sample_range` requires. This should not ever be called directly, only via `Range::new`, which will check that `low < high`, so this function doesn't have to repeat the check.",14,[[["self"],["self"]],["range"]]],[10,"sample_range","","Sample a value from the given `Range` with the given `Rng` as a source of randomness.",14,[[["range"],["r"]],["self"]]],[11,"clone","","",13,[[["self"]],["range"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `Range` instance that samples uniformly from `[low, high)`. Panics if `low >= high`.",13,[[["x"],["x"]],["range"]]],[11,"sample","","",13,[[["self"],["r"]],["sup"]]],[11,"ind_sample","","",13,[[["self"],["r"]],["sup"]]],[0,"gamma","rand::distributions","The Gamma and derived distributions.",N,N],[3,"Gamma","rand::distributions::gamma","The Gamma distribution `Gamma(shape, scale)` distribution.",N,N],[12,"repr","","",15,N],[3,"GammaSmallShape","","Gamma distribution where the shape parameter is less than 1.",N,N],[12,"inv_shape","","",16,N],[12,"large_shape","","",16,N],[3,"GammaLargeShape","","Gamma distribution where the shape parameter is larger than 1.",N,N],[12,"scale","","",17,N],[12,"c","","",17,N],[12,"d","","",17,N],[3,"ChiSquared","","The chi-squared distribution `χ²(k)`, where `k` is the degrees of freedom.",N,N],[12,"repr","","",18,N],[3,"FisherF","","The Fisher F distribution `F(m, n)`.",N,N],[12,"numer","","",19,N],[12,"denom","","",19,N],[12,"dof_ratio","","",19,N],[3,"StudentT","","The Student t distribution, `t(nu)`, where `nu` is the degrees of freedom.",N,N],[12,"chi","","",20,N],[12,"dof","","",20,N],[4,"GammaRepr","","",N,N],[13,"Large","","",21,N],[13,"One","","",21,N],[13,"Small","","",21,N],[4,"ChiSquaredRepr","","",N,N],[13,"DoFExactlyOne","","",22,N],[13,"DoFAnythingElse","","",22,N],[11,"clone","","",15,[[["self"]],["gamma"]]],[11,"fmt","","",15,[[["self"],["formatter"]],["result"]]],[11,"clone","","",21,[[["self"]],["gammarepr"]]],[11,"fmt","","",21,[[["self"],["formatter"]],["result"]]],[11,"clone","","",16,[[["self"]],["gammasmallshape"]]],[11,"fmt","","",16,[[["self"],["formatter"]],["result"]]],[11,"clone","","",17,[[["self"]],["gammalargeshape"]]],[11,"fmt","","",17,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct an object representing the `Gamma(shape, scale)` distribution.",15,[[["f64"],["f64"]],["gamma"]]],[11,"new_raw","","",16,[[["f64"],["f64"]],["gammasmallshape"]]],[11,"new_raw","","",17,[[["f64"],["f64"]],["gammalargeshape"]]],[11,"sample","","",15,[[["self"],["r"]],["f64"]]],[11,"sample","","",16,[[["self"],["r"]],["f64"]]],[11,"sample","","",17,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",15,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",16,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",17,[[["self"],["r"]],["f64"]]],[11,"clone","","",18,[[["self"]],["chisquared"]]],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"clone","","",22,[[["self"]],["chisquaredrepr"]]],[11,"fmt","","",22,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new chi-squared distribution with degrees-of-freedom `k`. Panics if `k < 0`.",18,[[["f64"]],["chisquared"]]],[11,"sample","","",18,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",18,[[["self"],["r"]],["f64"]]],[11,"clone","","",19,[[["self"]],["fisherf"]]],[11,"fmt","","",19,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `FisherF` distribution, with the given parameter. Panics if either `m` or `n` are not positive.",19,[[["f64"],["f64"]],["fisherf"]]],[11,"sample","","",19,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",19,[[["self"],["r"]],["f64"]]],[11,"clone","","",20,[[["self"]],["studentt"]]],[11,"fmt","","",20,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new Student t distribution with `n` degrees of freedom. Panics if `n <= 0`.",20,[[["f64"]],["studentt"]]],[11,"sample","","",20,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",20,[[["self"],["r"]],["f64"]]],[0,"normal","rand::distributions","The normal and derived distributions.",N,N],[3,"StandardNormal","rand::distributions::normal","A wrapper around an `f64` to generate N(0, 1) random numbers (a.k.a.  a standard normal, or Gaussian).",N,N],[12,"0","","",23,N],[3,"Normal","","The normal distribution `N(mean, std_dev**2)`.",N,N],[12,"mean","","",24,N],[12,"std_dev","","",24,N],[3,"LogNormal","","The log-normal distribution `ln N(mean, std_dev**2)`.",N,N],[12,"norm","","",25,N],[11,"clone","","",23,[[["self"]],["standardnormal"]]],[11,"fmt","","",23,[[["self"],["formatter"]],["result"]]],[11,"rand","","",23,[[["r"]],["standardnormal"]]],[11,"clone","","",24,[[["self"]],["normal"]]],[11,"fmt","","",24,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new `Normal` distribution with the given mean and standard deviation.",24,[[["f64"],["f64"]],["normal"]]],[11,"sample","","",24,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",24,[[["self"],["r"]],["f64"]]],[11,"clone","","",25,[[["self"]],["lognormal"]]],[11,"fmt","","",25,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new `LogNormal` distribution with the given mean and standard deviation.",25,[[["f64"],["f64"]],["lognormal"]]],[11,"sample","","",25,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",25,[[["self"],["r"]],["f64"]]],[0,"exponential","rand::distributions","The exponential distribution.",N,N],[3,"Exp1","rand::distributions::exponential","A wrapper around an `f64` to generate Exp(1) random numbers.",N,N],[12,"0","","",26,N],[3,"Exp","","The exponential distribution `Exp(lambda)`.",N,N],[12,"lambda_inverse","","`lambda` stored as `1/lambda`, since this is what we scale by.",27,N],[11,"clone","","",26,[[["self"]],["exp1"]]],[11,"fmt","","",26,[[["self"],["formatter"]],["result"]]],[11,"rand","","",26,[[["r"]],["exp1"]]],[11,"clone","","",27,[[["self"]],["exp"]]],[11,"fmt","","",27,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new `Exp` with the given shape parameter `lambda`. Panics if `lambda <= 0`.",27,[[["f64"]],["exp"]]],[11,"sample","","",27,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",27,[[["self"],["r"]],["f64"]]],[0,"ziggurat_tables","rand::distributions","",N,N],[6,"ZigTable","rand::distributions::ziggurat_tables","",N,N],[7,"ZIG_NORM_X","","",N,N],[7,"ZIG_NORM_F","","",N,N],[7,"ZIG_EXP_X","","",N,N],[7,"ZIG_EXP_F","","",N,N],[17,"ZIG_NORM_R","","",N,N],[17,"ZIG_EXP_R","","",N,N],[8,"Sample","rand::distributions","Types that can be used to create a random instance of `Support`.",N,N],[10,"sample","","Generate a random value of `Support`, using `rng` as the source of randomness.",28,[[["self"],["r"]],["support"]]],[8,"IndependentSample","","`Sample`s that do not require keeping track of state.",N,N],[10,"ind_sample","","Generate a random value.",29,[[["self"],["r"]],["support"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"clone","","",10,[[["self"]],["self"]]],[11,"sample","","",10,[[["self"],["r"]],["sup"]]],[11,"ind_sample","","",10,[[["self"],["r"]],["sup"]]],[11,"new","","",10,[[],["randsample"]]],[11,"clone","","",11,[[["self"]],["weighted"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `WeightedChoice`.",12,N],[11,"sample","","",12,[[["self"],["r"]],["t"]]],[11,"ind_sample","","",12,[[["self"],["r"]],["t"]]],[0,"jitter","rand","Non-physical true random number generator based on timing jitter.",N,N],[3,"JitterRng","rand::jitter","A true random number generator based on jitter in the CPU execution time, and jitter in memory access time.",N,N],[12,"data","","",30,N],[12,"rounds","","",30,N],[12,"timer","","",30,N],[12,"prev_time","","",30,N],[12,"last_delta","","",30,N],[12,"last_delta2","","",30,N],[12,"mem_prev_index","","",30,N],[12,"mem","","",30,N],[12,"data_remaining","","",30,N],[4,"TimerError","","An error that can occur when `test_timer` fails.",N,N],[13,"NoTimer","","No timer available.",31,N],[13,"CoarseTimer","","Timer too coarse to use as an entropy source.",31,N],[13,"NotMonotonic","","Timer is not monotonically increasing.",31,N],[13,"TinyVariantions","","Variations of deltas of time too small.",31,N],[13,"TooManyStuck","","Too many stuck results (indicating no added entropy).",31,N],[13,"__Nonexhaustive","","",31,N],[5,"black_box","","",N,[[["t"]],["t"]]],[0,"platform","","",N,N],[5,"get_nstime","rand::jitter::platform","",N,[[],["u64"]]],[7,"JITTER_ROUNDS","rand::jitter","",N,N],[17,"MEMORY_BLOCKS","","",N,N],[17,"MEMORY_BLOCKSIZE","","",N,N],[17,"MEMORY_SIZE","","",N,N],[11,"fmt","","",30,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",31,[[["self"],["formatter"]],["result"]]],[11,"clone","","",31,[[["self"]],["timererror"]]],[11,"eq","","",31,[[["self"],["timererror"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",31,N],[11,"description","","",31,[[["self"]],["str"]]],[11,"fmt","","",31,[[["self"],["formatter"]],["result"]]],[11,"description","","",31,[[["self"]],["str"]]],[11,"new","","Create a new `JitterRng`. Makes use of `std::time` for a timer.",30,[[],["result",["jitterrng","timererror"]]]],[11,"new_with_timer","","Create a new `JitterRng`. A custom timer can be supplied, making it possible to use `JitterRng` in `no_std` environments.",30,N],[11,"set_rounds","","Configures how many rounds are used to generate each 64-bit value. This must be greater than zero, and has a big impact on performance and output quality.",30,[[["self"],["u32"]]]],[11,"random_loop_cnt","","",30,[[["self"],["u32"]],["u32"]]],[11,"lfsr_time","","",30,[[["self"],["u64"],["bool"]]]],[11,"memaccess","","",30,[[["self"],["bool"]]]],[11,"stuck","","",30,[[["self"],["i64"]],["bool"]]],[11,"measure_jitter","","",30,[[["self"]],["option"]]],[11,"stir_pool","","",30,[[["self"]]]],[11,"gen_entropy","","",30,[[["self"]],["u64"]]],[11,"test_timer","","Basic quality tests on the timer, by measuring CPU timing jitter a few hundred times.",30,[[["self"]],["result",["u32","timererror"]]]],[11,"timer_stats","","Statistical test: return the timer delta of one normal run of the `JitterEntropy` entropy collector.",30,[[["self"],["bool"]],["i64"]]],[11,"next_u32","","",30,[[["self"]],["u32"]]],[11,"next_u64","","",30,[[["self"]],["u64"]]],[11,"fill_bytes","","",30,N],[0,"os","rand","Interfaces to the operating system provided random number generators.",N,N],[3,"OsRng","rand::os","A random number generator that retrieves randomness straight from the operating system. Platform sources:",N,N],[12,"0","","",32,N],[5,"next_u32","","",N,[[["fnmut"]],["u32"]]],[5,"next_u64","","",N,[[["fnmut"]],["u64"]]],[0,"imp","","",N,N],[3,"OsRng","rand::os::imp","",N,N],[12,"inner","","",33,N],[4,"OsRngInner","","",N,N],[13,"OsGetrandomRng","","",34,N],[13,"OsReadRng","","",34,N],[5,"getrandom","","",N,N],[5,"getrandom_fill_bytes","","",N,N],[5,"is_getrandom_available","","",N,[[],["bool"]]],[11,"new","","",33,[[],["result",["osrng"]]]],[11,"next_u32","","",33,[[["self"]],["u32"]]],[11,"next_u64","","",33,[[["self"]],["u64"]]],[11,"fill_bytes","","",33,N],[11,"new","rand::os","Create a new `OsRng`.",32,[[],["result",["osrng"]]]],[11,"next_u32","","",32,[[["self"]],["u32"]]],[11,"next_u64","","",32,[[["self"]],["u64"]]],[11,"fill_bytes","","",32,N],[11,"fmt","","",32,[[["self"],["formatter"]],["result"]]],[0,"read","rand","A wrapper around any Read to treat it as an RNG.",N,N],[3,"ReadRng","rand::read","An RNG that reads random bytes straight from a `Read`. This will work best with an infinite reader, but this is not required.",N,N],[12,"reader","","",35,N],[5,"fill","","",N,N],[11,"fmt","","",35,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `ReadRng` from a `Read`.",35,[[["r"]],["readrng"]]],[11,"next_u32","","",35,[[["self"]],["u32"]]],[11,"next_u64","","",35,[[["self"]],["u64"]]],[11,"fill_bytes","","",35,N],[0,"reseeding","rand","A wrapper around another RNG that reseeds it after it generates a certain number of random bytes.",N,N],[3,"ReseedingRng","rand::reseeding","A wrapper around any RNG which reseeds the underlying RNG after it has generated a certain number of random bytes.",N,N],[12,"rng","","",36,N],[12,"generation_threshold","","",36,N],[12,"bytes_generated","","",36,N],[12,"reseeder","","Controls the behaviour when reseeding the RNG.",36,N],[3,"ReseedWithDefault","","Reseed an RNG using a `Default` instance. This reseeds by replacing the RNG with the result of a `Default::default` call.",N,N],[17,"DEFAULT_GENERATION_THRESHOLD","","How many bytes of entropy the underling RNG is allowed to generate before it is reseeded",N,N],[8,"Reseeder","","Something that can be used to reseed an RNG via `ReseedingRng`.",N,N],[10,"reseed","","Reseed the given RNG.",37,[[["self"],["r"]]]],[11,"fmt","","",36,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `ReseedingRng` with the given parameters.",36,[[["r"],["u64"],["rsdr"]],["reseedingrng"]]],[11,"reseed_if_necessary","","Reseed the internal RNG if the number of bytes that have been generated exceed the threshold.",36,[[["self"]]]],[11,"next_u32","","",36,[[["self"]],["u32"]]],[11,"next_u64","","",36,[[["self"]],["u64"]]],[11,"fill_bytes","","",36,N],[11,"reseed","","",36,N],[11,"from_seed","","Create a new `ReseedingRng` from the given reseeder and seed. This uses a default value for `generation_threshold`.",36,N],[11,"clone","","",38,[[["self"]],["reseedwithdefault"]]],[11,"fmt","","",38,[[["self"],["formatter"]],["result"]]],[11,"reseed","","",38,[[["self"],["r"]]]],[11,"default","","",38,[[],["reseedwithdefault"]]],[0,"seq","rand","Functions for randomly accessing and sampling sequences.",N,N],[5,"sample_iter","rand::seq","Randomly sample `amount` elements from a finite iterator.",N,[[["r"],["i"],["usize"]],["result",["vec","vec"]]]],[5,"sample_slice","","Randomly sample exactly `amount` values from `slice`.",N,N],[5,"sample_slice_ref","","Randomly sample exactly `amount` references from `slice`.",N,N],[5,"sample_indices","","Randomly sample exactly `amount` indices from `0..length`.",N,[[["r"],["usize"],["usize"]],["vec",["usize"]]]],[5,"sample_indices_inplace","","Sample an amount of indices using an inplace partial fisher yates method.",N,[[["r"],["usize"],["usize"]],["vec",["usize"]]]],[5,"sample_indices_cache","","This method performs a partial fisher-yates on a range of indices using a HashMap as a cache to record potential collisions.",N,[[["r"],["usize"],["usize"]],["vec",["usize"]]]],[0,"chacha","rand","The ChaCha random number generator.",N,N],[3,"ChaChaRng","rand::chacha","A random number generator that uses the ChaCha20 algorithm [1].",N,N],[12,"buffer","","",2,N],[12,"state","","",2,N],[12,"index","","",2,N],[0,"isaac","rand","The ISAAC random number generator.",N,N],[3,"IsaacRng","rand::isaac","A random number generator that uses the ISAAC algorithm[1].",N,N],[12,"cnt","","",0,N],[12,"rsl","","",0,N],[12,"mem","","",0,N],[12,"a","","",0,N],[12,"b","","",0,N],[12,"c","","",0,N],[3,"Isaac64Rng","","A random number generator that uses ISAAC-64[1], the 64-bit variant of the ISAAC algorithm.",N,N],[12,"cnt","","",1,N],[12,"rsl","","",1,N],[12,"mem","","",1,N],[12,"a","","",1,N],[12,"b","","",1,N],[12,"c","","",1,N],[0,"rand_impls","rand","The implementations of `Rand` for the built-in types.",N,N],[0,"f64_rand_impls","rand::rand_impls","",N,N],[17,"SCALE","rand::rand_impls::f64_rand_impls","",N,N],[11,"rand","rand","",6,[[["r"]],["open01",["f64"]]]],[11,"rand","","",7,[[["r"]],["closed01",["f64"]]]],[0,"f32_rand_impls","rand::rand_impls","",N,N],[17,"SCALE","rand::rand_impls::f32_rand_impls","",N,N],[11,"rand","rand","",6,[[["r"]],["open01",["f32"]]]],[11,"rand","","",7,[[["r"]],["closed01",["f32"]]]],[0,"prng","","Pseudo random number generators are algorithms to produce apparently random numbers deterministically, and usually fairly quickly.",N,N],[0,"chacha","rand::prng","The ChaCha random number generator.",N,N],[3,"ChaChaRng","rand::prng::chacha","A random number generator that uses the ChaCha20 algorithm [1].",N,N],[12,"buffer","","",2,N],[12,"state","","",2,N],[12,"index","","",2,N],[5,"core","","",N,N],[6,"w32","","",N,N],[7,"EMPTY","","",N,N],[17,"KEY_WORDS","","",N,N],[17,"STATE_WORDS","","",N,N],[17,"CHACHA_ROUNDS","","",N,N],[11,"clone","rand","",2,[[["self"]],["chacharng"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"new_unseeded","","Create an ChaCha random number generator using the default fixed key of 8 zero words.",2,[[],["chacharng"]]],[11,"set_counter","","Sets the internal 128-bit ChaCha counter to a user-provided value. This permits jumping arbitrarily ahead (or backwards) in the pseudorandom stream.",2,[[["self"],["u64"],["u64"]]]],[11,"init","","Initializes `self.state` with the appropriate key and constants",2,N],[11,"update","","Refill the internal output buffer (`self.buffer`)",2,[[["self"]]]],[11,"next_u32","","",2,[[["self"]],["u32"]]],[11,"reseed","","",2,N],[11,"from_seed","","Create a ChaCha generator from a seed, obtained from a variable-length u32 array. Only up to 8 words are used; if less than 8 words are used, the remaining are set to zero.",2,N],[11,"rand","","",2,[[["r"]],["chacharng"]]],[0,"isaac","rand::prng","The ISAAC random number generator.",N,N],[3,"IsaacRng","rand::prng::isaac","A random number generator that uses the ISAAC algorithm[1].",N,N],[12,"cnt","","",0,N],[12,"rsl","","",0,N],[12,"mem","","",0,N],[12,"a","","",0,N],[12,"b","","",0,N],[12,"c","","",0,N],[6,"w32","","",N,N],[7,"EMPTY","","",N,N],[17,"RAND_SIZE_LEN","","",N,N],[17,"RAND_SIZE","","",N,N],[17,"RAND_SIZE_USIZE","","",N,N],[11,"new_unseeded","rand","Create an ISAAC random number generator using the default fixed seed.",0,[[],["isaacrng"]]],[11,"init","","Initialises `self`. If `use_rsl` is true, then use the current value of `rsl` as a seed, otherwise construct one algorithmically (not randomly).",0,[[["self"],["bool"]]]],[11,"isaac","","Refills the output buffer (`self.rsl`)",0,[[["self"]]]],[11,"clone","","",0,[[["self"]],["isaacrng"]]],[11,"next_u32","","",0,[[["self"]],["u32"]]],[11,"reseed","","",0,N],[11,"from_seed","","Create an ISAAC random number generator with a seed. This can be any length, although the maximum number of elements used is 256 and any more will be silently ignored. A generator constructed with a given seed will generate the same sequence of values as all other generators constructed with that seed.",0,N],[11,"rand","","",0,[[["r"]],["isaacrng"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[0,"isaac64","rand::prng","The ISAAC-64 random number generator.",N,N],[3,"Isaac64Rng","rand::prng::isaac64","A random number generator that uses ISAAC-64[1], the 64-bit variant of the ISAAC algorithm.",N,N],[12,"cnt","","",1,N],[12,"rsl","","",1,N],[12,"mem","","",1,N],[12,"a","","",1,N],[12,"b","","",1,N],[12,"c","","",1,N],[6,"w64","","",N,N],[7,"EMPTY_64","","",N,N],[17,"RAND_SIZE_64_LEN","","",N,N],[17,"RAND_SIZE_64","","",N,N],[11,"new_unseeded","rand","Create a 64-bit ISAAC random number generator using the default fixed seed.",1,[[],["isaac64rng"]]],[11,"init","","Initialises `self`. If `use_rsl` is true, then use the current value of `rsl` as a seed, otherwise construct one algorithmically (not randomly).",1,[[["self"],["bool"]]]],[11,"isaac64","","Refills the output buffer (`self.rsl`)",1,[[["self"]]]],[11,"clone","","",1,[[["self"]],["isaac64rng"]]],[11,"next_u32","","",1,[[["self"]],["u32"]]],[11,"next_u64","","",1,[[["self"]],["u64"]]],[11,"reseed","","",1,N],[11,"from_seed","","Create an ISAAC random number generator with a seed. This can be any length, although the maximum number of elements used is 256 and any more will be silently ignored. A generator constructed with a given seed will generate the same sequence of values as all other generators constructed with that seed.",1,N],[11,"rand","","",1,[[["r"]],["isaac64rng"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[0,"xorshift","rand::prng","Xorshift generators",N,N],[3,"XorShiftRng","rand::prng::xorshift","An Xorshift[1] random number generator.",N,N],[12,"x","","",3,N],[12,"y","","",3,N],[12,"z","","",3,N],[12,"w","","",3,N],[11,"clone","rand","",3,[[["self"]],["xorshiftrng"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"new_unseeded","","Creates a new XorShiftRng instance which is not seeded.",3,[[],["xorshiftrng"]]],[11,"next_u32","","",3,[[["self"]],["u32"]]],[11,"reseed","","Reseed an XorShiftRng. This will panic if `seed` is entirely 0.",3,N],[11,"from_seed","","Create a new XorShiftRng. This will panic if `seed` is entirely 0.",3,N],[11,"rand","","",3,[[["r"]],["xorshiftrng"]]],[6,"ThreadRngInner","","",N,N],[17,"THREAD_RNG_RESEED_THRESHOLD","","",N,N],[8,"Rand","","A type that can be randomly generated using an `Rng`.",N,N],[10,"rand","","Generates a random instance of this type using the specified source of randomness.",39,[[["r"]],["self"]]],[8,"Rng","","A random number generator.",N,N],[10,"next_u32","","Return the next random u32.",40,[[["self"]],["u32"]]],[11,"next_u64","","Return the next random u64.",40,[[["self"]],["u64"]]],[11,"next_f32","","Return the next random f32 selected from the half-open interval `[0, 1)`.",40,[[["self"]],["f32"]]],[11,"next_f64","","Return the next random f64 selected from the half-open interval `[0, 1)`.",40,[[["self"]],["f64"]]],[11,"fill_bytes","","Fill `dest` with random data.",40,N],[11,"gen","","Return a random value of a `Rand` type.",40,[[["self"]],["t"]]],[11,"gen_iter","","Return an iterator that will yield an infinite number of randomly generated items.",40,[[["self"]],["generator"]]],[11,"gen_range","","Generate a random value in the range [`low`, `high`).",40,[[["self"],["t"],["t"]],["t"]]],[11,"gen_weighted_bool","","Return a bool with a 1 in n chance of true",40,[[["self"],["u32"]],["bool"]]],[11,"gen_ascii_chars","","Return an iterator of random characters from the set A-Z,a-z,0-9.",40,[[["self"]],["asciigenerator"]]],[11,"choose","","Return a random element from `values`.",40,N],[11,"choose_mut","","Return a mutable pointer to a random element from `values`.",40,N],[11,"shuffle","","Shuffle a mutable slice in place.",40,N],[8,"SeedableRng","","A random number generator that can be explicitly seeded to produce the same stream of randomness multiple times.",N,N],[10,"reseed","","Reseed an RNG with the given seed.",41,[[["self"],["seed"]]]],[10,"from_seed","","Create a new RNG with the given seed.",41,[[["seed"]],["self"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"next","","",4,[[["self"]],["option"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"next","","",5,[[["self"]],["option",["char"]]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"clone","","",8,[[["self"]],["stdrng"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a randomly seeded instance of `StdRng`.",8,[[],["result",["stdrng"]]]],[11,"next_u32","","",8,[[["self"]],["u32"]]],[11,"next_u64","","",8,[[["self"]],["u64"]]],[11,"reseed","","",8,N],[11,"from_seed","","",8,N],[11,"fmt","","",42,[[["self"],["formatter"]],["result"]]],[11,"reseed","","",42,[[["self"],["stdrng"]]]],[11,"clone","","",9,[[["self"]],["threadrng"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"next_u32","","",9,[[["self"]],["u32"]]],[11,"next_u64","","",9,[[["self"]],["u64"]]],[11,"fill_bytes","","",9,N]],"paths":[[3,"IsaacRng"],[3,"Isaac64Rng"],[3,"ChaChaRng"],[3,"XorShiftRng"],[3,"Generator"],[3,"AsciiGenerator"],[3,"Open01"],[3,"Closed01"],[3,"StdRng"],[3,"ThreadRng"],[3,"RandSample"],[3,"Weighted"],[3,"WeightedChoice"],[3,"Range"],[8,"SampleRange"],[3,"Gamma"],[3,"GammaSmallShape"],[3,"GammaLargeShape"],[3,"ChiSquared"],[3,"FisherF"],[3,"StudentT"],[4,"GammaRepr"],[4,"ChiSquaredRepr"],[3,"StandardNormal"],[3,"Normal"],[3,"LogNormal"],[3,"Exp1"],[3,"Exp"],[8,"Sample"],[8,"IndependentSample"],[3,"JitterRng"],[4,"TimerError"],[3,"OsRng"],[3,"OsRng"],[4,"OsRngInner"],[3,"ReadRng"],[3,"ReseedingRng"],[8,"Reseeder"],[3,"ReseedWithDefault"],[8,"Rand"],[8,"Rng"],[8,"SeedableRng"],[3,"ThreadRngReseeder"]]};
searchIndex["regex"]={"doc":"This crate provides a library for parsing, compiling, and executing regular expressions. Its syntax is similar to Perl-style regular expressions, but lacks a few features like look around and backreferences. In exchange, all searches execute in linear time with respect to the size of the regular expression and search text.","items":[[3,"RegexBuilder","regex","A configurable builder for a regular expression.",N,N],[12,"0","","",0,N],[3,"RegexSetBuilder","","A configurable builder for a set of regular expressions.",N,N],[12,"0","","",1,N],[3,"RegexSet","","Match multiple (possibly overlapping) regular expressions in a single scan.",N,N],[12,"0","","",2,N],[3,"SetMatches","","A set of matches returned by a regex set.",N,N],[12,"matched_any","","",3,N],[12,"matches","","",3,N],[3,"SetMatchesIntoIter","","An owned iterator over the set of matches from a regex set.",N,N],[12,"0","","",4,N],[3,"SetMatchesIter","","A borrowed iterator over the set of matches from a regex set.",N,N],[12,"0","","",5,N],[3,"Locations","","Locations represents the offsets of each capturing group in a regex for a single match.",N,N],[12,"0","","",6,N],[3,"Regex","","A compiled regular expression for matching Unicode strings.",N,N],[12,"0","","",7,N],[3,"Match","","Match represents a single match of a regex in a haystack.",N,N],[12,"text","","",8,N],[12,"start","","",8,N],[12,"end","","",8,N],[3,"Captures","","Captures represents a group of captured strings for a single match.",N,N],[12,"text","","",9,N],[12,"locs","","",9,N],[12,"named_groups","","",9,N],[3,"CaptureNames","","An iterator over the names of all possible captures.",N,N],[12,"0","","",10,N],[3,"Matches","","An iterator over all non-overlapping matches for a particular string.",N,N],[12,"0","","",11,N],[3,"CaptureMatches","","An iterator that yields all non-overlapping capture groups matching a particular regular expression.",N,N],[12,"0","","",12,N],[3,"SubCaptureMatches","","An iterator that yields all capturing matches in the order in which they appear in the regex.",N,N],[12,"caps","","",13,N],[12,"it","","",13,N],[3,"ReplacerRef","","By-reference adaptor for a `Replacer`",N,N],[12,"0","","",14,N],[3,"NoExpand","","`NoExpand` indicates literal string replacement.",N,N],[12,"0","","",15,N],[3,"Split","","Yields all substrings delimited by a regular expression match.",N,N],[12,"finder","","",16,N],[12,"last","","",16,N],[3,"SplitN","","Yields at most `N` substrings delimited by a regular expression match.",N,N],[12,"splits","","",17,N],[12,"n","","",17,N],[4,"Error","","An error that occurred during parsing or compiling a regular expression.",N,N],[13,"Syntax","","A syntax error.",18,N],[13,"CompiledTooBig","","The compiled program exceeded the set size limit. The argument is the size limit imposed.",18,N],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",18,N],[5,"escape","","Escapes all regular expression meta characters in `text`.",N,[[["str"]],["string"]]],[0,"bytes","","Match regular expressions on arbitrary bytes.",N,N],[3,"RegexBuilder","regex::bytes","A configurable builder for a regular expression.",N,N],[12,"0","","",19,N],[3,"RegexSetBuilder","","A configurable builder for a set of regular expressions.",N,N],[12,"0","","",20,N],[3,"Match","","Match represents a single match of a regex in a haystack.",N,N],[12,"text","","",21,N],[12,"start","","",21,N],[12,"end","","",21,N],[3,"Regex","","A compiled regular expression for matching arbitrary bytes.",N,N],[12,"0","","",22,N],[3,"Matches","","An iterator over all non-overlapping matches for a particular string.",N,N],[12,"0","","",23,N],[3,"CaptureMatches","","An iterator that yields all non-overlapping capture groups matching a particular regular expression.",N,N],[12,"0","","",24,N],[3,"Split","","Yields all substrings delimited by a regular expression match.",N,N],[12,"finder","","",25,N],[12,"last","","",25,N],[3,"SplitN","","Yields at most `N` substrings delimited by a regular expression match.",N,N],[12,"splits","","",26,N],[12,"n","","",26,N],[3,"CaptureNames","","An iterator over the names of all possible captures.",N,N],[12,"0","","",27,N],[3,"Captures","","Captures represents a group of captured byte strings for a single match.",N,N],[12,"text","","",28,N],[12,"locs","","",28,N],[12,"named_groups","","",28,N],[3,"SubCaptureMatches","","An iterator that yields all capturing matches in the order in which they appear in the regex.",N,N],[12,"caps","","",29,N],[12,"it","","",29,N],[3,"ReplacerRef","","By-reference adaptor for a `Replacer`",N,N],[12,"0","","",30,N],[3,"NoExpand","","`NoExpand` indicates literal byte string replacement.",N,N],[12,"0","","",31,N],[3,"RegexSet","","Match multiple (possibly overlapping) regular expressions in a single scan.",N,N],[12,"0","","",32,N],[3,"SetMatches","","A set of matches returned by a regex set.",N,N],[12,"matched_any","","",33,N],[12,"matches","","",33,N],[3,"SetMatchesIntoIter","","An owned iterator over the set of matches from a regex set.",N,N],[12,"0","","",34,N],[3,"SetMatchesIter","","A borrowed iterator over the set of matches from a regex set.",N,N],[12,"0","","",35,N],[3,"Locations","","Locations represents the offsets of each capturing group in a regex for a single match.",N,N],[12,"0","","",6,N],[8,"Replacer","","Replacer describes types that can be used to replace matches in a byte string.",N,N],[10,"replace_append","","Appends text to `dst` to replace the current match.",36,[[["self"],["captures"],["vec"]]]],[11,"no_expansion","","Return a fixed unchanging replacement byte string.",36,[[["self"]],["option",["cow"]]]],[11,"by_ref","","Return a `Replacer` that borrows and wraps this `Replacer`.",36,[[["self"]],["replacerref"]]],[0,"backtrack","regex","",N,N],[3,"Bounded","regex::backtrack","A backtracking matching engine.",N,N],[12,"prog","","",37,N],[12,"input","","",37,N],[12,"matches","","",37,N],[12,"slots","","",37,N],[12,"m","","",37,N],[3,"Cache","","Shared cached state between multiple invocations of a backtracking engine in the same thread.",N,N],[12,"jobs","","",38,N],[12,"visited","","",38,N],[4,"Job","","A job is an explicit unit of stack space in the backtracking engine.",N,N],[13,"Inst","","",39,N],[12,"ip","regex::backtrack::Job","",39,N],[12,"at","","",39,N],[13,"SaveRestore","regex::backtrack","",39,N],[12,"slot","regex::backtrack::Job","",39,N],[12,"old_pos","","",39,N],[5,"should_exec","regex::backtrack","Returns true iff the given regex and input should be executed by this engine with reasonable memory usage.",N,[[["usize"],["usize"]],["bool"]]],[5,"usize_to_u32","","",N,[[["usize"]],["u32"]]],[6,"Bits","","",N,N],[17,"BIT_SIZE","","",N,N],[17,"MAX_SIZE_BYTES","","",N,N],[11,"fmt","","",37,[[["self"],["formatter"]],["result"]]],[11,"clone","","",38,[[["self"]],["cache"]]],[11,"fmt","","",38,[[["self"],["formatter"]],["result"]]],[11,"new","","Create new empty cache for the backtracking engine.",38,[[["program"]],["self"]]],[11,"clone","","",39,[[["self"]],["job"]]],[11,"fmt","","",39,[[["self"],["formatter"]],["result"]]],[11,"exec","","Execute the backtracking matching engine.",37,N],[11,"clear","","Clears the cache such that the backtracking engine can be executed on some input of fixed length.",37,[[["self"]]]],[11,"exec_","","Start backtracking at the given position in the input, but also look for literal prefixes.",37,[[["self"],["inputat"]],["bool"]]],[11,"backtrack","","The main backtracking loop starting at the given input position.",37,[[["self"],["inputat"]],["bool"]]],[11,"step","","",37,[[["self"],["usize"],["inputat"]],["bool"]]],[11,"has_visited","","",37,[[["self"],["usize"],["inputat"]],["bool"]]],[0,"utf8","regex","",N,N],[5,"next_utf8","regex::utf8","Returns the smallest possible index of the next valid UTF-8 sequence starting after `i`.",N,N],[5,"encode_utf8","","Encode the given Unicode character to `dst` as a single UTF-8 sequence.",N,N],[5,"decode_utf8","","Decode a single UTF-8 sequence into a single Unicode codepoint from `src`.",N,N],[5,"decode_last_utf8","","Like `decode_utf8`, but decodes the last UTF-8 sequence in `src` instead of the first.",N,N],[5,"is_start_byte","","",N,[[["u8"]],["bool"]]],[17,"TAG_CONT","","",N,N],[17,"TAG_TWO","","",N,N],[17,"TAG_THREE","","",N,N],[17,"TAG_FOUR","","",N,N],[0,"compile","regex","",N,N],[3,"Patch","regex::compile","",N,N],[12,"hole","","",40,N],[12,"entry","","",40,N],[3,"Compiler","","A compiler translates a regular expression AST to a sequence of instructions. The sequence of instructions represents an NFA.",N,N],[12,"insts","","",41,N],[12,"compiled","","",41,N],[12,"capture_name_idx","","",41,N],[12,"num_exprs","","",41,N],[12,"size_limit","","",41,N],[12,"suffix_cache","","",41,N],[12,"utf8_seqs","","",41,N],[12,"byte_classes","","",41,N],[3,"CompileClass","","",N,N],[12,"c","","",42,N],[12,"ranges","","",42,N],[3,"SuffixCache","","`SuffixCache` is a simple bounded hash map for caching suffix entries in UTF-8 automata. For example, consider the Unicode range \\u{0}-\\u{FFFF}. The set of byte ranges looks like this:",N,N],[12,"table","","",43,N],[12,"version","","",43,N],[3,"SuffixCacheEntry","","",N,N],[12,"key","","",44,N],[12,"pc","","",44,N],[12,"version","","",44,N],[3,"SuffixCacheKey","","",N,N],[12,"from_inst","","",45,N],[12,"start","","",45,N],[12,"end","","",45,N],[3,"ByteClassSet","","",N,N],[12,"0","","",46,N],[4,"Hole","","",N,N],[13,"None","","",47,N],[13,"One","","",47,N],[13,"Many","","",47,N],[4,"MaybeInst","","",N,N],[13,"Compiled","","",48,N],[13,"Uncompiled","","",48,N],[13,"Split","","",48,N],[13,"Split1","","",48,N],[13,"Split2","","",48,N],[4,"InstHole","","",N,N],[13,"Save","","",49,N],[12,"slot","regex::compile::InstHole","",49,N],[13,"EmptyLook","regex::compile","",49,N],[12,"look","regex::compile::InstHole","",49,N],[13,"Char","regex::compile","",49,N],[12,"c","regex::compile::InstHole","",49,N],[13,"Ranges","regex::compile","",49,N],[12,"ranges","regex::compile::InstHole","",49,N],[13,"Bytes","regex::compile","",49,N],[12,"start","regex::compile::InstHole","",49,N],[12,"end","","",49,N],[5,"u32_to_usize","regex::compile","",N,[[["u32"]],["usize"]]],[6,"Result","","",N,N],[11,"fmt","","",40,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new regular expression compiler.",41,[[],["self"]]],[11,"size_limit","","The size of the resulting program is limited by size_limit. If the program approximately exceeds the given size (in bytes), then compilation will stop and return an error.",41,[[["self"],["usize"]],["self"]]],[11,"bytes","","If bytes is true, then the program is compiled as a byte based automaton, which incorporates UTF-8 decoding into the machine. If it's false, then the automaton is Unicode scalar value based, e.g., an engine utilizing such an automaton is resposible for UTF-8 decoding.",41,[[["self"],["bool"]],["self"]]],[11,"only_utf8","","When disabled, the program compiled may match arbitrary bytes.",41,[[["self"],["bool"]],["self"]]],[11,"dfa","","When set, the machine returned is suitable for use in the DFA matching engine.",41,[[["self"],["bool"]],["self"]]],[11,"reverse","","When set, the machine returned is suitable for matching text in reverse. In particular, all concatenations are flipped.",41,[[["self"],["bool"]],["self"]]],[11,"compile","","Compile a regular expression given its AST.",41,N],[11,"compile_one","","",41,[[["self"],["hir"]],["result",["program","error"]]]],[11,"compile_many","","",41,N],[11,"compile_finish","","",41,[[["self"]],["result",["program","error"]]]],[11,"c","","Compile expr into self.insts, returning a patch on success, or an error if we run out of memory.",41,[[["self"],["hir"]],["result",["patch","error"]]]],[11,"c_capture","","",41,[[["self"],["usize"],["hir"]],["result",["patch","error"]]]],[11,"c_dotstar","","",41,[[["self"]],["result",["patch","error"]]]],[11,"c_literal","","",41,N],[11,"c_char","","",41,[[["self"],["char"]],["result",["patch","error"]]]],[11,"c_class","","",41,N],[11,"c_bytes","","",41,N],[11,"c_byte","","",41,[[["self"],["u8"]],["result",["patch","error"]]]],[11,"c_class_bytes","","",41,N],[11,"c_empty_look","","",41,[[["self"],["emptylook"]],["result",["patch","error"]]]],[11,"c_concat","","",41,[[["self"],["i"]],["result",["patch","error"]]]],[11,"c_alternate","","",41,N],[11,"c_repeat","","",41,[[["self"],["repetition"]],["result",["patch","error"]]]],[11,"c_repeat_zero_or_one","","",41,[[["self"],["hir"],["bool"]],["result",["patch","error"]]]],[11,"c_repeat_zero_or_more","","",41,[[["self"],["hir"],["bool"]],["result",["patch","error"]]]],[11,"c_repeat_one_or_more","","",41,[[["self"],["hir"],["bool"]],["result",["patch","error"]]]],[11,"c_repeat_range_min_or_more","","",41,[[["self"],["hir"],["bool"],["u32"]],["result",["patch","error"]]]],[11,"c_repeat_range","","",41,[[["self"],["hir"],["bool"],["u32"],["u32"]],["result",["patch","error"]]]],[11,"fill","","",41,[[["self"],["hole"],["usize"]]]],[11,"fill_to_next","","",41,[[["self"],["hole"]]]],[11,"fill_split","","",41,[[["self"],["hole"],["option",["usize"]],["option",["usize"]]],["hole"]]],[11,"push_compiled","","",41,[[["self"],["inst"]]]],[11,"push_hole","","",41,[[["self"],["insthole"]],["hole"]]],[11,"push_split_hole","","",41,[[["self"]],["hole"]]],[11,"check_size","","",41,[[["self"]],["result",["error"]]]],[11,"fmt","","",47,[[["self"],["formatter"]],["result"]]],[11,"clone","","",48,[[["self"]],["maybeinst"]]],[11,"fmt","","",48,[[["self"],["formatter"]],["result"]]],[11,"fill","","",48,[[["self"],["usize"]]]],[11,"fill_split","","",48,[[["self"],["usize"],["usize"]]]],[11,"half_fill_split_goto1","","",48,[[["self"],["usize"]]]],[11,"half_fill_split_goto2","","",48,[[["self"],["usize"]]]],[11,"unwrap","","",48,[[["self"]],["inst"]]],[11,"clone","","",49,[[["self"]],["insthole"]]],[11,"fmt","","",49,[[["self"],["formatter"]],["result"]]],[11,"fill","","",49,[[["self"],["usize"]],["inst"]]],[11,"compile","","",42,[[["self"]],["result",["patch","error"]]]],[11,"c_utf8_seq","","",42,[[["self"],["utf8sequence"]],["result",["patch","error"]]]],[11,"c_utf8_seq_","","",42,[[["self"],["i"]],["result",["patch","error"]]]],[11,"clone","","",44,[[["self"]],["suffixcacheentry"]]],[11,"fmt","","",44,[[["self"],["formatter"]],["result"]]],[11,"default","","",44,[[],["suffixcacheentry"]]],[11,"assert_receiver_is_total_eq","","",44,N],[11,"hash","","",44,N],[11,"eq","","",44,[[["self"],["suffixcacheentry"]],["bool"]]],[11,"ne","","",44,[[["self"],["suffixcacheentry"]],["bool"]]],[11,"clone","","",45,[[["self"]],["suffixcachekey"]]],[11,"fmt","","",45,[[["self"],["formatter"]],["result"]]],[11,"default","","",45,[[],["suffixcachekey"]]],[11,"assert_receiver_is_total_eq","","",45,N],[11,"hash","","",45,N],[11,"eq","","",45,[[["self"],["suffixcachekey"]],["bool"]]],[11,"ne","","",45,[[["self"],["suffixcachekey"]],["bool"]]],[11,"new","","",43,[[["usize"]],["self"]]],[11,"get","","",43,[[["self"],["suffixcachekey"],["usize"]],["option",["usize"]]]],[11,"clear","","",43,[[["self"]]]],[11,"hash","","",43,[[["self"],["suffixcachekey"]],["usize"]]],[11,"new","","",46,[[],["self"]]],[11,"set_range","","",46,[[["self"],["u8"],["u8"]]]],[11,"set_word_boundary","","",46,[[["self"]]]],[11,"byte_classes","","",46,[[["self"]],["vec",["u8"]]]],[0,"dfa","regex","The DFA matching engine.",N,N],[3,"Cache","regex::dfa","A reusable cache of DFA states.",N,N],[12,"inner","","Group persistent DFA related cache state together. The sparse sets listed below are used as scratch space while computing uncached states.",50,N],[12,"qcur","","qcur and qnext are ordered sets with constant time addition/membership/clearing-whole-set and linear time iteration. They are used to manage the sets of NFA states in DFA states when computing cached DFA states. In particular, the order of the NFA states matters for leftmost-first style matching. Namely, when computing a cached state, the set of NFA states stops growing as soon as the first Match instruction is observed.",50,N],[12,"qnext","","",50,N],[3,"CacheInner","","`CacheInner` is logically just a part of Cache, but groups together fields that aren't passed as function parameters throughout search. (This split is mostly an artifact of the borrow checker. It is happily paid.)",N,N],[12,"compiled","","A cache of pre-compiled DFA states, keyed by the set of NFA states and the set of empty-width flags set at the byte in the input when the state was observed.",51,N],[12,"trans","","The transition table.",51,N],[12,"states","","Our set of states. Note that `StatePtr / num_byte_classes` indexes this Vec rather than just a `StatePtr`.",51,N],[12,"start_states","","A set of cached start states, which are limited to the number of permutations of flags set just before the initial byte of input. (The index into this vec is a `EmptyFlags`.)",51,N],[12,"stack","","Stack scratch space used to follow epsilon transitions in the NFA. (This permits us to avoid recursion.)",51,N],[12,"flush_count","","The total number of times this cache has been flushed by the DFA because of space constraints.",51,N],[12,"size","","The total heap size of the DFA's cache. We use this to determine when we should flush the cache.",51,N],[3,"Transitions","","The transition table.",N,N],[12,"table","","The table.",52,N],[12,"num_byte_classes","","The stride.",52,N],[3,"Fsm","","Fsm encapsulates the actual execution of the DFA.",N,N],[12,"prog","","prog contains the NFA instruction opcodes. DFA execution uses either the `dfa` instructions or the `dfa_reverse` instructions from `exec::ExecReadOnly`. (It never uses `ExecReadOnly.nfa`, which may have Unicode opcodes that cannot be executed by the DFA.)",53,N],[12,"start","","The start state. We record it here because the pointer may change when the cache is wiped.",53,N],[12,"at","","The current position in the input.",53,N],[12,"quit_after_match","","Should we quit after seeing the first match? e.g., When the caller uses `is_match` or `shortest_match`.",53,N],[12,"last_match_si","","The last state that matched.",53,N],[12,"last_cache_flush","","The input position of the last cache flush. We use this to determine if we're thrashing in the cache too often. If so, the DFA quits so that we can fall back to the NFA algorithm.",53,N],[12,"cache","","All cached DFA information that is persisted between searches.",53,N],[3,"State","","`State` is a DFA state. It contains an ordered set of NFA states (not necessarily complete) and a smattering of flags.",N,N],[12,"data","","",54,N],[3,"InstPtrs","","",N,N],[12,"base","","",55,N],[12,"data","","",55,N],[3,"Byte","","Byte is a u8 in spirit, but a u16 in practice so that we can represent the special EOF sentinel value.",N,N],[12,"0","","",56,N],[3,"EmptyFlags","","A set of flags for zero-width assertions.",N,N],[12,"start","","",57,N],[12,"end","","",57,N],[12,"start_line","","",57,N],[12,"end_line","","",57,N],[12,"word_boundary","","",57,N],[12,"not_word_boundary","","",57,N],[3,"StateFlags","","A set of flags describing various configurations of a DFA state. This is represented by a `u8` so that it is compact.",N,N],[12,"0","","",58,N],[3,"TransitionsRow","","",N,N],[12,"0","","",59,N],[4,"Result","","The result of running the DFA.",N,N],[13,"Match","","",60,N],[13,"NoMatch","","",60,N],[13,"Quit","","",60,N],[5,"can_exec","","Return true if and only if the given program can be executed by a DFA.",N,[[["program"]],["bool"]]],[5,"push_inst_ptr","","Adds ip to data using delta encoding with respect to prev.",N,[[["vec"],["u32"],["u32"]]]],[5,"vb","","Helper function for formatting a byte as a nice-to-read escaped string.",N,[[["usize"]],["string"]]],[5,"usize_to_u32","","",N,[[["usize"]],["u32"]]],[5,"show_state_ptr","","",N,[[["u32"]],["string"]]],[5,"write_vari32","","https://developers.google.com/protocol-buffers/docs/encoding#varints",N,[[["vec"],["i32"]]]],[5,"read_vari32","","https://developers.google.com/protocol-buffers/docs/encoding#varints",N,N],[5,"write_varu32","","https://developers.google.com/protocol-buffers/docs/encoding#varints",N,[[["vec"],["u32"]]]],[5,"read_varu32","","https://developers.google.com/protocol-buffers/docs/encoding#varints",N,N],[6,"InstPtr","","`InstPtr` is a 32 bit pointer into a sequence of opcodes (i.e., it indexes an NFA state).",N,N],[6,"StatePtr","","`StatePtr` is a 32 bit pointer to the start of a row in the transition table.",N,N],[17,"STATE_UNKNOWN","","An unknown state means that the state has not been computed yet, and that the only way to progress is to compute it.",N,N],[17,"STATE_DEAD","","A dead state means that the state has been computed and it is known that once it is entered, no future match can ever occur.",N,N],[17,"STATE_QUIT","","A quit state means that the DFA came across some input that it doesn't know how to process correctly. The DFA should quit and another matching engine should be run in its place.",N,N],[17,"STATE_START","","A start state is a state that the DFA can start in.",N,N],[17,"STATE_MATCH","","A match state means that the regex has successfully matched.",N,N],[17,"STATE_MAX","","The maximum state pointer. This is useful to mask out the \"valid\" state pointer from a state with the \"start\" or \"match\" bits set.",N,N],[11,"clone","","",50,[[["self"]],["cache"]]],[11,"fmt","","",50,[[["self"],["formatter"]],["result"]]],[11,"clone","","",51,[[["self"]],["cacheinner"]]],[11,"fmt","","",51,[[["self"],["formatter"]],["result"]]],[11,"clone","","",52,[[["self"]],["transitions"]]],[11,"fmt","","",53,[[["self"],["formatter"]],["result"]]],[11,"clone","","",60,[[["self"]],["result"]]],[11,"fmt","","",60,[[["self"],["formatter"]],["result"]]],[11,"is_match","","Returns true if this result corresponds to a match.",60,[[["self"]],["bool"]]],[11,"map","","Maps the given function onto T and returns the result.",60,[[["self"],["f"]],["result"]]],[11,"set_non_match","","Sets the non-match position.",60,[[["self"],["usize"]],["result"]]],[11,"clone","","",54,[[["self"]],["state"]]],[11,"assert_receiver_is_total_eq","","",54,N],[11,"hash","","",54,N],[11,"eq","","",54,[[["self"],["state"]],["bool"]]],[11,"ne","","",54,[[["self"],["state"]],["bool"]]],[11,"next","","",55,[[["self"]],["option",["usize"]]]],[11,"flags","","",54,[[["self"]],["stateflags"]]],[11,"inst_ptrs","","",54,[[["self"]],["instptrs"]]],[11,"clone","","",56,[[["self"]],["byte"]]],[11,"fmt","","",56,[[["self"],["formatter"]],["result"]]],[11,"clone","","",57,[[["self"]],["emptyflags"]]],[11,"assert_receiver_is_total_eq","","",57,N],[11,"fmt","","",57,[[["self"],["formatter"]],["result"]]],[11,"default","","",57,[[],["emptyflags"]]],[11,"hash","","",57,N],[11,"eq","","",57,[[["self"],["emptyflags"]],["bool"]]],[11,"ne","","",57,[[["self"],["emptyflags"]],["bool"]]],[11,"clone","","",58,[[["self"]],["stateflags"]]],[11,"assert_receiver_is_total_eq","","",58,N],[11,"default","","",58,[[],["stateflags"]]],[11,"hash","","",58,N],[11,"eq","","",58,[[["self"],["stateflags"]],["bool"]]],[11,"ne","","",58,[[["self"],["stateflags"]],["bool"]]],[11,"new","","Create new empty cache for the DFA engine.",50,[[["program"]],["self"]]],[11,"reset_size","","Resets the cache size to account for fixed costs, such as the program and stack sizes.",51,[[["self"]]]],[11,"forward","","",53,N],[11,"reverse","","",53,N],[11,"forward_many","","",53,N],[11,"exec_at","","Executes the DFA on a forward NFA.",53,N],[11,"exec_at_reverse","","Executes the DFA on a reverse NFA.",53,N],[11,"next_si","","next_si transitions to the next state, where the transition input corresponds to text[i].",53,N],[11,"exec_byte","","Computes the next state given the current state and the current input byte (which may be EOF).",53,[[["self"],["sparseset"],["sparseset"],["u32"],["byte"]],["option",["u32"]]]],[11,"follow_epsilons","","Follows the epsilon transitions starting at (and including) `ip`. The resulting states are inserted into the ordered set `q`.",53,[[["self"],["u32"],["sparseset"],["emptyflags"]]]],[11,"cached_state","","Find a previously computed state matching the given set of instructions and is_match bool.",53,[[["self"],["sparseset"],["stateflags"],["option",["u32"]]],["option",["u32"]]]],[11,"cached_state_key","","Produces a key suitable for describing a state in the DFA cache.",53,[[["self"],["sparseset"],["stateflags"]],["option",["state"]]]],[11,"clear_cache_and_save","","Clears the cache, but saves and restores current_state if it is not none.",53,[[["self"],["option",["u32"]]],["bool"]]],[11,"clear_cache","","Wipes the state cache, but saves and restores the current start state.",53,[[["self"]],["bool"]]],[11,"restore_state","","Restores the given state back into the cache, and returns a pointer to it.",53,[[["self"],["state"]],["option",["u32"]]]],[11,"next_state","","Returns the next state given the current state si and current byte b. {qcur,qnext} are used as scratch space for storing ordered NFA states.",53,[[["self"],["sparseset"],["sparseset"],["u32"],["byte"]],["option",["u32"]]]],[11,"start_state","","Computes and returns the start state, where searching begins at position `at` in `text`. If the state has already been computed, then it is pulled from the cache. If the state hasn't been cached, then it is computed, cached and a pointer to it is returned.",53,[[["self"],["sparseset"],["emptyflags"],["stateflags"]],["option",["u32"]]]],[11,"start_flags","","Computes the set of starting flags for the given position in text.",53,N],[11,"start_flags_reverse","","Computes the set of starting flags for the given position in text.",53,N],[11,"state","","Returns a reference to a State given a pointer to it.",53,[[["self"],["u32"]],["state"]]],[11,"add_state","","Adds the given state to the DFA.",53,[[["self"],["state"]],["option",["u32"]]]],[11,"prefix_at","","Quickly finds the next occurrence of any literal prefixes in the regex. If there are no literal prefixes, then the current position is returned. If there are literal prefixes and one could not be found, then None is returned.",53,N],[11,"num_byte_classes","","Returns the number of byte classes required to discriminate transitions in each state.",53,[[["self"]],["usize"]]],[11,"byte_class","","Given an input byte or the special EOF sentinel, return its corresponding byte class.",53,[[["self"],["byte"]],["usize"]]],[11,"u8_class","","Like byte_class, but explicitly for u8s.",53,[[["self"],["u8"]],["usize"]]],[11,"continue_past_first_match","","Returns true if the DFA should continue searching past the first match.",53,[[["self"]],["bool"]]],[11,"has_prefix","","Returns true if there is a prefix we can quickly search for.",53,[[["self"]],["bool"]]],[11,"start_ptr","","Sets the STATE_START bit in the given state pointer if and only if we have a prefix to scan for.",53,[[["self"],["u32"]],["u32"]]],[11,"approximate_size","","Approximate size returns the approximate heap space currently used by the DFA. It is used to determine whether the DFA's state cache needs to be wiped. Namely, it is possible that for certain regexes on certain inputs, a new state could be created for every byte of input. (This is bad for memory use, so we bound it with a cache.)",53,[[["self"]],["usize"]]],[11,"new","","Create a new transition table.",52,[[["usize"]],["transitions"]]],[11,"num_states","","Returns the total number of states currently in this table.",52,[[["self"]],["usize"]]],[11,"add","","Allocates room for one additional state and returns a pointer to it.",52,[[["self"]],["option",["u32"]]]],[11,"clear","","Clears the table of all states.",52,[[["self"]]]],[11,"set_next","","Sets the transition from (si, cls) to next.",52,[[["self"],["u32"],["usize"],["u32"]]]],[11,"next","","Returns the transition corresponding to (si, cls).",52,[[["self"],["u32"],["usize"]],["u32"]]],[11,"state_heap_size","","The heap size, in bytes, of a single state in the transition table.",52,[[["self"]],["usize"]]],[11,"next_unchecked","","Like `next`, but uses unchecked access and is therefore unsafe.",52,[[["self"],["u32"],["usize"]],["u32"]]],[11,"is_match","","",58,[[["self"]],["bool"]]],[11,"set_match","","",58,[[["self"]]]],[11,"is_word","","",58,[[["self"]],["bool"]]],[11,"set_word","","",58,[[["self"]]]],[11,"has_empty","","",58,[[["self"]],["bool"]]],[11,"set_empty","","",58,[[["self"]]]],[11,"byte","","",56,[[["u8"]],["self"]]],[11,"eof","","",56,[[],["self"]]],[11,"is_eof","","",56,[[["self"]],["bool"]]],[11,"is_ascii_word","","",56,[[["self"]],["bool"]]],[11,"as_byte","","",56,[[["self"]],["option",["u8"]]]],[11,"fmt","","",54,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",52,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",59,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",58,[[["self"],["formatter"]],["result"]]],[0,"error","regex","",N,N],[4,"Error","regex::error","An error that occurred during parsing or compiling a regular expression.",N,N],[13,"Syntax","","A syntax error.",18,N],[13,"CompiledTooBig","","The compiled program exceeded the set size limit. The argument is the size limit imposed.",18,N],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",18,N],[11,"clone","regex","",18,[[["self"]],["error"]]],[11,"eq","","",18,[[["self"],["error"]],["bool"]]],[11,"ne","","",18,[[["self"],["error"]],["bool"]]],[11,"description","","",18,[[["self"]],["str"]]],[11,"cause","","",18,[[["self"]],["option",["error"]]]],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"from","","",18,[[["error"]],["error"]]],[0,"exec","","",N,N],[3,"Exec","regex::exec","`Exec` manages the execution of a regular expression.",N,N],[12,"ro","","All read only state.",61,N],[12,"cache","","Caches for the various matching engines.",61,N],[3,"ExecNoSync","","`ExecNoSync` is like `Exec`, except it embeds a reference to a cache. This means it is no longer Sync, but we can now avoid the overhead of synchronization to fetch the cache.",N,N],[12,"ro","","All read only state.",62,N],[12,"cache","","Caches for the various matching engines.",62,N],[3,"ExecNoSyncStr","","`ExecNoSyncStr` is like `ExecNoSync`, but matches on &str instead of &[u8].",N,N],[12,"0","","",63,N],[3,"ExecReadOnly","","`ExecReadOnly` comprises all read only state for a regex. Namely, all such state is determined at compile time and never changes during search.",N,N],[12,"res","","The original regular expressions given by the caller to compile.",64,N],[12,"nfa","","A compiled program that is used in the NFA simulation and backtracking. It can be byte-based or Unicode codepoint based.",64,N],[12,"dfa","","A compiled byte based program for DFA execution. This is only used if a DFA can be executed. (Currently, only word boundary assertions are not supported.) Note that this program contains an embedded `.*?` preceding the first capture group, unless the regex is anchored at the beginning.",64,N],[12,"dfa_reverse","","The same as above, except the program is reversed (and there is no preceding `.*?`). This is used by the DFA to find the starting location of matches.",64,N],[12,"suffixes","","A set of suffix literals extracted from the regex.",64,N],[12,"match_type","","match_type encodes as much upfront knowledge about how we're going to execute a search as possible.",64,N],[3,"ExecBuilder","","Facilitates the construction of an executor by exposing various knobs to control how a regex is executed and what kinds of resources it's permitted to use.",N,N],[12,"options","","",65,N],[12,"match_type","","",65,N],[12,"bytes","","",65,N],[12,"only_utf8","","",65,N],[3,"Parsed","","Parsed represents a set of parsed regular expressions and their detected literals.",N,N],[12,"exprs","","",66,N],[12,"prefixes","","",66,N],[12,"suffixes","","",66,N],[12,"bytes","","",66,N],[3,"ProgramCacheInner","","",N,N],[12,"pikevm","","",67,N],[12,"backtrack","","",67,N],[12,"dfa","","",67,N],[12,"dfa_reverse","","",67,N],[4,"MatchType","","",N,N],[13,"Literal","","A single or multiple literal search. This is only used when the regex can be decomposed into unambiguous literal search.",68,N],[13,"Dfa","","A normal DFA search.",68,N],[13,"DfaAnchoredReverse","","A reverse DFA search starting from the end of a haystack.",68,N],[13,"DfaSuffix","","A reverse DFA search with suffix literal scanning.",68,N],[13,"DfaMany","","Use the DFA on two or more regular expressions.",68,N],[13,"Nfa","","An NFA variant.",68,N],[13,"Nothing","","No match is ever possible, so don't ever try to search.",68,N],[4,"MatchLiteralType","","",N,N],[13,"Unanchored","","Match literals anywhere in text.",69,N],[13,"AnchoredStart","","Match literals only at the start of text.",69,N],[13,"AnchoredEnd","","Match literals only at the end of text.",69,N],[4,"MatchNfaType","","",N,N],[13,"Auto","","Choose between Backtrack and PikeVM.",70,N],[13,"Backtrack","","NFA bounded backtracking.",70,N],[13,"PikeVM","","The Pike VM.",70,N],[6,"ProgramCache","","`ProgramCache` maintains reusable allocations for each matching engine available to a particular program.",N,N],[11,"fmt","","",62,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",64,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a regex execution builder.",65,[[["str"]],["self"]]],[11,"new_many","","Like new, but compiles the union of the given regular expressions.",65,[[["i"]],["self"]]],[11,"new_options","","Create a regex execution builder.",65,[[["regexoptions"]],["self"]]],[11,"automatic","","Set the matching engine to be automatically determined.",65,[[["self"]],["self"]]],[11,"nfa","","Sets the matching engine to use the NFA algorithm no matter what optimizations are possible.",65,[[["self"]],["self"]]],[11,"bounded_backtracking","","Sets the matching engine to use a bounded backtracking engine no matter what optimizations are possible.",65,[[["self"]],["self"]]],[11,"bytes","","Compiles byte based programs for use with the NFA matching engines.",65,[[["self"],["bool"]],["self"]]],[11,"only_utf8","","When disabled, the program compiled may match arbitrary bytes.",65,[[["self"],["bool"]],["self"]]],[11,"unicode","","Set the Unicode flag.",65,[[["self"],["bool"]],["self"]]],[11,"parse","","Parse the current set of patterns into their AST and extract literals.",65,[[["self"]],["result",["parsed","error"]]]],[11,"build","","Build an executor that can run a regular expression.",65,[[["self"]],["result",["exec","error"]]]],[11,"slots_len","","",63,[[["self"]],["usize"]]],[11,"next_after_empty","","",63,[[["self"],["str"],["usize"]],["usize"]]],[11,"shortest_match_at","","",63,[[["self"],["str"],["usize"]],["option",["usize"]]]],[11,"is_match_at","","",63,[[["self"],["str"],["usize"]],["bool"]]],[11,"find_at","","",63,[[["self"],["str"],["usize"]],["option"]]],[11,"read_captures_at","","",63,[[["self"],["locations"],["str"],["usize"]],["option"]]],[11,"slots_len","","Returns the number of capture slots in the regular expression. (There are two slots for every capture group, corresponding to possibly empty start and end locations of the capture.)",62,[[["self"]],["usize"]]],[11,"next_after_empty","","",62,N],[11,"shortest_match_at","","Returns the end of a match location, possibly occurring before the end location of the correct leftmost-first match.",62,N],[11,"is_match_at","","Returns true if and only if the regex matches text.",62,N],[11,"find_at","","Finds the start and end location of the leftmost-first match, starting at the given location.",62,N],[11,"read_captures_at","","Finds the start and end location of the leftmost-first match and also fills in all matching capture groups.",62,N],[11,"find_literals","","Finds the leftmost-first match using only literal search.",62,N],[11,"find_dfa_forward","","Finds the leftmost-first match (start and end) using only the DFA.",62,N],[11,"find_dfa_anchored_reverse","","Finds the leftmost-first match (start and end) using only the DFA, but assumes the regex is anchored at the end and therefore starts at the end of the regex and matches in reverse.",62,N],[11,"shortest_dfa","","Finds the end of the shortest match using only the DFA.",62,N],[11,"shortest_dfa_reverse_suffix","","Finds the end of the shortest match using only the DFA by scanning for suffix literals.",62,N],[11,"exec_dfa_reverse_suffix","","Finds the end of the shortest match using only the DFA by scanning for suffix literals. It also reports the start of the match.",62,N],[11,"find_dfa_reverse_suffix","","Finds the leftmost-first match (start and end) using only the DFA by scanning for suffix literals.",62,N],[11,"match_nfa","","Executes the NFA engine to return whether there is a match or not.",62,N],[11,"match_nfa_type","","Like match_nfa, but allows specification of the type of NFA engine.",62,N],[11,"shortest_nfa","","Finds the shortest match using an NFA.",62,N],[11,"shortest_nfa_type","","Like shortest_nfa, but allows specification of the type of NFA engine.",62,N],[11,"find_nfa","","Like find, but executes an NFA engine.",62,N],[11,"captures_nfa_with_match","","Like find_nfa, but fills in captures and restricts the search space using previously found match information.",62,N],[11,"captures_nfa","","Like find_nfa, but fills in captures.",62,N],[11,"captures_nfa_type","","Like captures_nfa, but allows specification of type of NFA engine.",62,N],[11,"exec_nfa","","",62,N],[11,"exec_pikevm","","Always run the NFA algorithm.",62,N],[11,"exec_backtrack","","Always runs the NFA using bounded backtracking.",62,N],[11,"many_matches_at","","Finds which regular expressions match the given text.",62,N],[11,"is_anchor_end_match","","",62,N],[11,"capture_name_idx","","",62,[[["self"]],["arc"]]],[11,"capture_name_idx","","",63,[[["self"]],["arc"]]],[11,"searcher","","Get a searcher that isn't Sync.",61,[[["self"]],["execnosync"]]],[11,"searcher_str","","Get a searcher that isn't Sync and can match on &str.",61,[[["self"]],["execnosyncstr"]]],[11,"into_regex","","Build a Regex from this executor.",61,[[["self"]],["regex"]]],[11,"into_regex_set","","Build a RegexSet from this executor.",61,[[["self"]],["regexset"]]],[11,"into_byte_regex","","Build a Regex from this executor that can match arbitrary bytes.",61,[[["self"]],["regex"]]],[11,"into_byte_regex_set","","Build a RegexSet from this executor that can match arbitrary bytes.",61,[[["self"]],["regexset"]]],[11,"regex_strings","","The original regular expressions given by the caller that were compiled.",61,N],[11,"capture_names","","Return a slice of capture names.",61,N],[11,"capture_name_idx","","Return a reference to named groups mapping (from group name to group position).",61,[[["self"]],["arc"]]],[11,"clone","","",61,[[["self"]],["exec"]]],[11,"choose_match_type","","",64,[[["self"],["option",["matchtype"]]],["matchtype"]]],[11,"should_suffix_scan","","Returns true if the program is amenable to suffix scanning.",64,[[["self"]],["bool"]]],[11,"clone","","",68,[[["self"]],["matchtype"]]],[11,"fmt","","",68,[[["self"],["formatter"]],["result"]]],[11,"clone","","",69,[[["self"]],["matchliteraltype"]]],[11,"fmt","","",69,[[["self"],["formatter"]],["result"]]],[11,"clone","","",70,[[["self"]],["matchnfatype"]]],[11,"fmt","","",70,[[["self"],["formatter"]],["result"]]],[11,"clone","","",67,[[["self"]],["programcacheinner"]]],[11,"fmt","","",67,[[["self"],["formatter"]],["result"]]],[11,"new","","",67,[[["execreadonly"]],["self"]]],[0,"expand","regex","",N,N],[3,"CaptureRef","regex::expand","`CaptureRef` represents a reference to a capture group inside some text. The reference is either a capture group name or a number.",N,N],[12,"cap","","",71,N],[12,"end","","",71,N],[4,"Ref","","A reference to a capture group in some text.",N,N],[13,"Named","","",72,N],[13,"Number","","",72,N],[5,"expand_str","","",N,[[["captures"],["str"],["string"]]]],[5,"expand_bytes","","",N,N],[5,"find_cap_ref","","Parses a possible reference to a capture group name in the given text, starting at the beginning of `replacement`.",N,[[["t"]],["option",["captureref"]]]],[5,"is_valid_cap_letter","","Returns true if and only if the given byte is allowed in a capture name.",N,[[["u8"]],["bool"]]],[11,"clone","","",71,[[["self"]],["captureref"]]],[11,"fmt","","",71,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",71,N],[11,"eq","","",71,[[["self"],["captureref"]],["bool"]]],[11,"ne","","",71,[[["self"],["captureref"]],["bool"]]],[11,"clone","","",72,[[["self"]],["ref"]]],[11,"fmt","","",72,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",72,N],[11,"eq","","",72,[[["self"],["ref"]],["bool"]]],[11,"ne","","",72,[[["self"],["ref"]],["bool"]]],[11,"from","","",72,[[["str"]],["ref"]]],[11,"from","","",72,[[["usize"]],["ref"]]],[0,"freqs","regex","",N,N],[17,"BYTE_FREQUENCIES","regex::freqs","",N,N],[0,"input","regex","",N,N],[3,"InputAt","regex::input","Represents a location in the input.",N,N],[12,"pos","","",73,N],[12,"c","","",73,N],[12,"byte","","",73,N],[12,"len","","",73,N],[3,"CharInput","","An input reader over characters.",N,N],[12,"0","","",74,N],[3,"ByteInput","","An input reader over bytes.",N,N],[12,"text","","",75,N],[12,"only_utf8","","",75,N],[3,"Char","","An inline representation of `Option<char>`.",N,N],[12,"0","","",76,N],[8,"Input","","An abstraction over input used in the matching engines.",N,N],[10,"at","","Return an encoding of the position at byte offset `i`.",77,[[["self"],["usize"]],["inputat"]]],[10,"next_char","","Return the Unicode character occurring next to `at`.",77,[[["self"],["inputat"]],["char"]]],[10,"previous_char","","Return the Unicode character occurring previous to `at`.",77,[[["self"],["inputat"]],["char"]]],[10,"is_empty_match","","Return true if the given empty width instruction matches at the input position given.",77,[[["self"],["inputat"],["instemptylook"]],["bool"]]],[10,"prefix_at","","Scan the input for a matching prefix.",77,[[["self"],["literalsearcher"],["inputat"]],["option",["inputat"]]]],[10,"len","","The number of bytes in the input.",77,[[["self"]],["usize"]]],[11,"is_empty","","Whether the input is empty.",77,[[["self"]],["bool"]]],[10,"as_bytes","","Return the given input as a sequence of bytes.",77,N],[11,"clone","","",73,[[["self"]],["inputat"]]],[11,"fmt","","",73,[[["self"],["formatter"]],["result"]]],[11,"is_start","","Returns true iff this position is at the beginning of the input.",73,[[["self"]],["bool"]]],[11,"is_end","","Returns true iff this position is past the end of the input.",73,[[["self"]],["bool"]]],[11,"char","","Returns the character at this position.",73,[[["self"]],["char"]]],[11,"byte","","Returns the byte at this position.",73,[[["self"]],["option",["u8"]]]],[11,"len","","Returns the UTF-8 width of the character at this position.",73,[[["self"]],["usize"]]],[11,"is_empty","","Returns whether the UTF-8 width of the character at this position is zero.",73,[[["self"]],["bool"]]],[11,"pos","","Returns the byte offset of this position.",73,[[["self"]],["usize"]]],[11,"next_pos","","Returns the byte offset of the next position in the input.",73,[[["self"]],["usize"]]],[11,"clone","","",74,[[["self"]],["charinput"]]],[11,"fmt","","",74,[[["self"],["formatter"]],["result"]]],[11,"new","","Return a new character input reader for the given string.",74,N],[11,"deref","","",74,N],[11,"at","","",74,[[["self"],["usize"]],["inputat"]]],[11,"next_char","","",74,[[["self"],["inputat"]],["char"]]],[11,"previous_char","","",74,[[["self"],["inputat"]],["char"]]],[11,"is_empty_match","","",74,[[["self"],["inputat"],["instemptylook"]],["bool"]]],[11,"prefix_at","","",74,[[["self"],["literalsearcher"],["inputat"]],["option",["inputat"]]]],[11,"len","","",74,[[["self"]],["usize"]]],[11,"as_bytes","","",74,N],[11,"clone","","",75,[[["self"]],["byteinput"]]],[11,"fmt","","",75,[[["self"],["formatter"]],["result"]]],[11,"new","","Return a new byte-based input reader for the given string.",75,N],[11,"deref","","",75,N],[11,"at","","",75,[[["self"],["usize"]],["inputat"]]],[11,"next_char","","",75,[[["self"],["inputat"]],["char"]]],[11,"previous_char","","",75,[[["self"],["inputat"]],["char"]]],[11,"is_empty_match","","",75,[[["self"],["inputat"],["instemptylook"]],["bool"]]],[11,"prefix_at","","",75,[[["self"],["literalsearcher"],["inputat"]],["option",["inputat"]]]],[11,"len","","",75,[[["self"]],["usize"]]],[11,"as_bytes","","",75,N],[11,"clone","","",76,[[["self"]],["char"]]],[11,"hash","","",76,N],[11,"eq","","",76,[[["self"],["char"]],["bool"]]],[11,"ne","","",76,[[["self"],["char"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",76,N],[11,"partial_cmp","","",76,[[["self"],["char"]],["option",["ordering"]]]],[11,"lt","","",76,[[["self"],["char"]],["bool"]]],[11,"le","","",76,[[["self"],["char"]],["bool"]]],[11,"gt","","",76,[[["self"],["char"]],["bool"]]],[11,"ge","","",76,[[["self"],["char"]],["bool"]]],[11,"cmp","","",76,[[["self"],["char"]],["ordering"]]],[11,"fmt","","",76,[[["self"],["formatter"]],["result"]]],[11,"is_none","","Returns true iff the character is absent.",76,[[["self"]],["bool"]]],[11,"len_utf8","","Returns the length of the character's UTF-8 encoding.",76,[[["self"]],["usize"]]],[11,"is_word_char","","Returns true iff the character is a word character.",76,[[["self"]],["bool"]]],[11,"is_word_byte","","Returns true iff the byte is a word byte.",76,[[["self"]],["bool"]]],[11,"from","","",76,[[["char"]],["char"]]],[11,"from","","",76,[[["option",["char"]]],["char"]]],[11,"eq","","",76,[[["self"],["char"]],["bool"]]],[11,"partial_cmp","","",76,[[["self"],["char"]],["option",["ordering"]]]],[0,"literal","regex","",N,N],[3,"LiteralSearcher","regex::literal","A prefix extracted from a compiled regular expression.",N,N],[12,"complete","","",78,N],[12,"lcp","","",78,N],[12,"lcs","","",78,N],[12,"matcher","","",78,N],[3,"SingleByteSet","","",N,N],[12,"sparse","","",79,N],[12,"dense","","",79,N],[12,"complete","","",79,N],[12,"all_ascii","","",79,N],[3,"FreqyPacked","","Provides an implementation of fast subtring search using frequency analysis.",N,N],[12,"pat","","The pattern.",80,N],[12,"char_len","","The number of Unicode characters in the pattern. This is useful for determining the effective length of a pattern when deciding which optimizations to perform. A trailing incomplete UTF-8 sequence counts as one character.",80,N],[12,"rare1","","The rarest byte in the pattern, according to pre-computed frequency analysis.",80,N],[12,"rare1i","","The offset of the rarest byte in `pat`.",80,N],[12,"rare2","","The second rarest byte in the pattern, according to pre-computed frequency analysis. (This may be equivalent to the rarest byte.)",80,N],[12,"rare2i","","The offset of the second rarest byte in `pat`.",80,N],[3,"BoyerMooreSearch","","An implementation of Tuned Boyer-Moore as laid out by Andrew Hume and Daniel Sunday in \"Fast String Searching\". O(n) in the size of the input.",N,N],[12,"pattern","","The pattern we are going to look for in the haystack.",81,N],[12,"skip_table","","The skip table for the skip loop.",81,N],[12,"guard","","The guard character (least frequently occurring char).",81,N],[12,"guard_reverse_idx","","The reverse-index of the guard character in the pattern.",81,N],[12,"md2_shift","","Daniel Sunday's mini generalized delta2 shift table.",81,N],[4,"Matcher","","",N,N],[13,"Empty","","No literals. (Never advances through the input.)",82,N],[13,"Bytes","","A set of four or more single byte literals.",82,N],[13,"FreqyPacked","","A single substring, find using memchr and frequency analysis.",82,N],[13,"BoyerMoore","","A single substring, find using Boyer-Moore.",82,N],[13,"AC","","An Aho-Corasick automaton.",82,N],[13,"TeddySSSE3","","A simd accelerated multiple string matcher. Used only for a small number of small literals.",82,N],[13,"TeddyAVX2","","A simd accelerated multiple string matcher. Used only for a small number of small literals. This uses 256-bit vectors.",82,N],[4,"LiteralIter","","",N,N],[13,"Empty","","",83,N],[13,"Bytes","","",83,N],[13,"Single","","",83,N],[13,"AC","","",83,N],[13,"TeddySSSE3","","",83,N],[13,"TeddyAVX2","","",83,N],[5,"char_len_lossy","","",N,N],[5,"freq_rank","","",N,[[["u8"]],["usize"]]],[0,"teddy_avx2","","",N,N],[0,"imp","regex::literal::teddy_avx2","",N,N],[3,"Teddy","regex::literal::teddy_avx2::imp","",N,N],[12,"0","","",84,N],[3,"Match","","",N,N],[12,"pat","","",85,N],[12,"start","","",85,N],[12,"end","","",85,N],[11,"fmt","","",84,[[["self"],["formatter"]],["result"]]],[11,"clone","","",84,[[["self"]],["teddy"]]],[11,"fmt","","",85,[[["self"],["formatter"]],["result"]]],[11,"clone","","",85,[[["self"]],["match"]]],[11,"available","","",84,[[],["bool"]]],[11,"new","","",84,[[["literals"]],["option",["teddy"]]]],[11,"patterns","","",84,N],[11,"len","","",84,[[["self"]],["usize"]]],[11,"approximate_size","","",84,[[["self"]],["usize"]]],[11,"find","","",84,N],[0,"teddy_ssse3","regex::literal","",N,N],[0,"imp","regex::literal::teddy_ssse3","",N,N],[3,"Teddy","regex::literal::teddy_ssse3::imp","",N,N],[12,"0","","",86,N],[3,"Match","","",N,N],[12,"pat","","",87,N],[12,"start","","",87,N],[12,"end","","",87,N],[11,"fmt","","",86,[[["self"],["formatter"]],["result"]]],[11,"clone","","",86,[[["self"]],["teddy"]]],[11,"fmt","","",87,[[["self"],["formatter"]],["result"]]],[11,"clone","","",87,[[["self"]],["match"]]],[11,"available","","",86,[[],["bool"]]],[11,"new","","",86,[[["literals"]],["option",["teddy"]]]],[11,"patterns","","",86,N],[11,"len","","",86,[[["self"]],["usize"]]],[11,"approximate_size","","",86,[[["self"]],["usize"]]],[11,"find","","",86,N],[11,"clone","regex::literal","",78,[[["self"]],["literalsearcher"]]],[11,"fmt","","",78,[[["self"],["formatter"]],["result"]]],[11,"clone","","",82,[[["self"]],["matcher"]]],[11,"fmt","","",82,[[["self"],["formatter"]],["result"]]],[11,"empty","","Returns a matcher that never matches and never advances the input.",78,[[],["self"]]],[11,"prefixes","","Returns a matcher for literal prefixes from the given set.",78,[[["literals"]],["self"]]],[11,"suffixes","","Returns a matcher for literal suffixes from the given set.",78,[[["literals"]],["self"]]],[11,"new","","",78,[[["literals"],["matcher"]],["self"]]],[11,"complete","","Returns true if all matches comprise the entire regular expression.",78,[[["self"]],["bool"]]],[11,"find","","Find the position of a literal in `haystack` if it exists.",78,N],[11,"find_start","","Like find, except matches must start at index `0`.",78,N],[11,"find_end","","Like find, except matches must end at index `haystack.len()`.",78,N],[11,"iter","","Returns an iterator over all literals to be matched.",78,[[["self"]],["literaliter"]]],[11,"lcp","","Returns a matcher for the longest common prefix of this matcher.",78,[[["self"]],["freqypacked"]]],[11,"lcs","","Returns a matcher for the longest common suffix of this matcher.",78,[[["self"]],["freqypacked"]]],[11,"is_empty","","Returns true iff this prefix is empty.",78,[[["self"]],["bool"]]],[11,"len","","Returns the number of prefixes in this machine.",78,[[["self"]],["usize"]]],[11,"approximate_size","","Return the approximate heap usage of literals in bytes.",78,[[["self"]],["usize"]]],[11,"prefixes","","",82,[[["literals"]],["self"]]],[11,"suffixes","","",82,[[["literals"]],["self"]]],[11,"new","","",82,[[["literals"],["singlebyteset"]],["self"]]],[11,"next","","",83,[[["self"]],["option"]]],[11,"clone","","",79,[[["self"]],["singlebyteset"]]],[11,"fmt","","",79,[[["self"],["formatter"]],["result"]]],[11,"new","","",79,[[],["singlebyteset"]]],[11,"prefixes","","",79,[[["literals"]],["singlebyteset"]]],[11,"suffixes","","",79,[[["literals"]],["singlebyteset"]]],[11,"find","","Faster find that special cases certain sizes to use memchr.",79,N],[11,"_find","","Generic find that works on any sized set.",79,N],[11,"approximate_size","","",79,[[["self"]],["usize"]]],[11,"clone","","",80,[[["self"]],["freqypacked"]]],[11,"fmt","","",80,[[["self"],["formatter"]],["result"]]],[11,"new","","",80,[[["vec",["u8"]]],["freqypacked"]]],[11,"empty","","",80,[[],["freqypacked"]]],[11,"find","","",80,N],[11,"is_suffix","","",80,N],[11,"len","","",80,[[["self"]],["usize"]]],[11,"char_len","","",80,[[["self"]],["usize"]]],[11,"approximate_size","","",80,[[["self"]],["usize"]]],[11,"clone","","",81,[[["self"]],["boyermooresearch"]]],[11,"fmt","","",81,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new string searcher, performing whatever compilation steps are required.",81,[[["vec",["u8"]]],["self"]]],[11,"find","","Find the pattern in `haystack`, returning the offset of the start of the first occurrence of the pattern in `haystack`.",81,N],[11,"len","","",81,[[["self"]],["usize"]]],[11,"should_use","","The key heuristic behind which the BoyerMooreSearch lives.",81,N],[11,"check_match","","Check to see if there is a match at the given position",81,N],[11,"skip_loop","","Skip forward according to the shift table.",81,N],[11,"compile_skip_table","","Compute the ufast skip table.",81,N],[11,"select_guard","","Select the guard character based off of the precomputed frequency table.",81,N],[11,"compile_md2_shift","","If there is another occurrence of the skip char, shift to it, otherwise just shift to the next window.",81,N],[11,"approximate_size","","",81,[[["self"]],["usize"]]],[0,"pikevm","regex","",N,N],[3,"Fsm","regex::pikevm","An NFA simulation matching engine.",N,N],[12,"prog","","The sequence of opcodes (among other things) that is actually executed.",88,N],[12,"stack","","An explicit stack used for following epsilon transitions. (This is borrowed from the cache.)",88,N],[12,"input","","The input to search.",88,N],[3,"Cache","","A cached allocation that can be reused on each execution.",N,N],[12,"clist","","A pair of ordered sets for tracking NFA states.",89,N],[12,"nlist","","",89,N],[12,"stack","","An explicit stack used for following epsilon transitions.",89,N],[3,"Threads","","An ordered set of NFA states and their captures.",N,N],[12,"set","","An ordered set of opcodes (each opcode is an NFA state).",90,N],[12,"caps","","Captures for every NFA state.",90,N],[12,"slots_per_thread","","The number of capture slots stored per thread. (Every capture has two slots.)",90,N],[4,"FollowEpsilon","","A representation of an explicit stack frame when following epsilon transitions. This is used to avoid recursion.",N,N],[13,"IP","","Follow transitions at the given instruction pointer.",91,N],[13,"Capture","","Restore the capture slot with the given position in the input.",91,N],[12,"slot","regex::pikevm::FollowEpsilon","",91,N],[12,"pos","","",91,N],[11,"fmt","regex::pikevm","",88,[[["self"],["formatter"]],["result"]]],[11,"clone","","",89,[[["self"]],["cache"]]],[11,"fmt","","",89,[[["self"],["formatter"]],["result"]]],[11,"clone","","",90,[[["self"]],["threads"]]],[11,"fmt","","",90,[[["self"],["formatter"]],["result"]]],[11,"clone","","",91,[[["self"]],["followepsilon"]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new allocation used by the NFA machine to record execution and captures.",89,[[["program"]],["self"]]],[11,"exec","","Execute the NFA matching engine.",88,N],[11,"exec_","","",88,N],[11,"step","","Step through the input, one token (byte or codepoint) at a time.",88,N],[11,"add","","Follows epsilon transitions and adds them for processing to nlist, starting at and including ip.",88,N],[11,"add_step","","A helper function for add that avoids excessive pushing to the stack.",88,N],[11,"new","","",90,[[],["self"]]],[11,"resize","","",90,[[["self"],["usize"],["usize"]]]],[11,"caps","","",90,N],[0,"prog","regex","",N,N],[3,"Program","regex::prog","Program is a sequence of instructions and various facts about thos instructions.",N,N],[12,"insts","","A sequence of instructions that represents an NFA.",92,N],[12,"matches","","Pointers to each Match instruction in the sequence.",92,N],[12,"captures","","The ordered sequence of all capture groups extracted from the AST. Unnamed groups are `None`.",92,N],[12,"capture_name_idx","","Pointers to all named capture groups into `captures`.",92,N],[12,"start","","A pointer to the start instruction. This can vary depending on how the program was compiled. For example, programs for use with the DFA engine have a `.*?` inserted at the beginning of unanchored regular expressions. The actual starting point of the program is after the `.*?`.",92,N],[12,"byte_classes","","A set of equivalence classes for discriminating bytes in the compiled program.",92,N],[12,"only_utf8","","When true, this program can only match valid UTF-8.",92,N],[12,"is_bytes","","When true, this program uses byte range instructions instead of Unicode range instructions.",92,N],[12,"is_dfa","","When true, the program is compiled for DFA matching. For example, this implies `is_bytes` and also inserts a preceding `.*?` for unanchored regexes.",92,N],[12,"is_reverse","","When true, the program matches text in reverse (for use only in the DFA).",92,N],[12,"is_anchored_start","","Whether the regex must match from the start of the input.",92,N],[12,"is_anchored_end","","Whether the regex must match at the end of the input.",92,N],[12,"has_unicode_word_boundary","","Whether this program contains a Unicode word boundary instruction.",92,N],[12,"prefixes","","A possibly empty machine for very quickly matching prefix literals.",92,N],[12,"dfa_size_limit","","A limit on the size of the cache that the DFA is allowed to use while matching.",92,N],[3,"InstSave","","Representation of the Save instruction.",N,N],[12,"goto","","The next location to execute in the program.",93,N],[12,"slot","","The capture slot (there are two slots for every capture in a regex, including the zeroth capture for the entire match).",93,N],[3,"InstSplit","","Representation of the Split instruction.",N,N],[12,"goto1","","The first instruction to try. A match resulting from following goto1 has precedence over a match resulting from following goto2.",94,N],[12,"goto2","","The second instruction to try. A match resulting from following goto1 has precedence over a match resulting from following goto2.",94,N],[3,"InstEmptyLook","","Representation of the `EmptyLook` instruction.",N,N],[12,"goto","","The next location to execute in the program if this instruction succeeds.",95,N],[12,"look","","The type of zero-width assertion to check.",95,N],[3,"InstChar","","Representation of the Char instruction.",N,N],[12,"goto","","The next location to execute in the program if this instruction succeeds.",96,N],[12,"c","","The character to test.",96,N],[3,"InstRanges","","Representation of the Ranges instruction.",N,N],[12,"goto","","The next location to execute in the program if this instruction succeeds.",97,N],[12,"ranges","","The set of Unicode scalar value ranges to test.",97,N],[3,"InstBytes","","Representation of the Bytes instruction.",N,N],[12,"goto","","The next location to execute in the program if this instruction succeeds.",98,N],[12,"start","","The start (inclusive) of this byte range.",98,N],[12,"end","","The end (inclusive) of this byte range.",98,N],[4,"Inst","","Inst is an instruction code in a Regex program.",N,N],[13,"Match","","Match indicates that the program has reached a match state.",99,N],[13,"Save","","Save causes the program to save the current location of the input in the slot indicated by InstSave.",99,N],[13,"Split","","Split causes the program to diverge to one of two paths in the program, preferring goto1 in InstSplit.",99,N],[13,"EmptyLook","","EmptyLook represents a zero-width assertion in a regex program. A zero-width assertion does not consume any of the input text.",99,N],[13,"Char","","Char requires the regex program to match the character in InstChar at the current position in the input.",99,N],[13,"Ranges","","Ranges requires the regex program to match the character at the current position in the input with one of the ranges specified in InstRanges.",99,N],[13,"Bytes","","Bytes is like Ranges, except it expresses a single byte range. It is used in conjunction with Split instructions to implement multi-byte character classes.",99,N],[4,"EmptyLook","","The set of zero-width match instructions.",N,N],[13,"StartLine","","Start of line or input.",100,N],[13,"EndLine","","End of line or input.",100,N],[13,"StartText","","Start of input.",100,N],[13,"EndText","","End of input.",100,N],[13,"WordBoundary","","Word character on one side and non-word character on other.",100,N],[13,"NotWordBoundary","","Word character on both sides or non-word character on both sides.",100,N],[13,"WordBoundaryAscii","","ASCII word boundary.",100,N],[13,"NotWordBoundaryAscii","","Not ASCII word boundary.",100,N],[6,"InstPtr","","`InstPtr` represents the index of an instruction in a regex program.",N,N],[11,"clone","","",92,[[["self"]],["program"]]],[11,"new","","Creates an empty instruction sequence. Fields are given default values.",92,[[],["self"]]],[11,"skip","","If pc is an index to a no-op instruction (like Save), then return the next pc that is not a no-op instruction.",92,[[["self"],["usize"]],["usize"]]],[11,"leads_to_match","","Return true if and only if an execution engine at instruction `pc` will always lead to a match.",92,[[["self"],["usize"]],["bool"]]],[11,"needs_dotstar","","Returns true if the current configuration demands that an implicit `.*?` be prepended to the instruction sequence.",92,[[["self"]],["bool"]]],[11,"uses_bytes","","Returns true if this program uses Byte instructions instead of Char/Range instructions.",92,[[["self"]],["bool"]]],[11,"only_utf8","","Returns true if this program exclusively matches valid UTF-8 bytes.",92,[[["self"]],["bool"]]],[11,"approximate_size","","Return the approximate heap usage of this instruction sequence in bytes.",92,[[["self"]],["usize"]]],[11,"deref","","",92,N],[11,"fmt","","",92,[[["self"],["formatter"]],["result"]]],[11,"clone","","",99,[[["self"]],["inst"]]],[11,"fmt","","",99,[[["self"],["formatter"]],["result"]]],[11,"is_match","","Returns true if and only if this is a match instruction.",99,[[["self"]],["bool"]]],[11,"clone","","",93,[[["self"]],["instsave"]]],[11,"fmt","","",93,[[["self"],["formatter"]],["result"]]],[11,"clone","","",94,[[["self"]],["instsplit"]]],[11,"fmt","","",94,[[["self"],["formatter"]],["result"]]],[11,"clone","","",95,[[["self"]],["instemptylook"]]],[11,"fmt","","",95,[[["self"],["formatter"]],["result"]]],[11,"clone","","",100,[[["self"]],["emptylook"]]],[11,"fmt","","",100,[[["self"],["formatter"]],["result"]]],[11,"eq","","",100,[[["self"],["emptylook"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",100,N],[11,"clone","","",96,[[["self"]],["instchar"]]],[11,"fmt","","",96,[[["self"],["formatter"]],["result"]]],[11,"clone","","",97,[[["self"]],["instranges"]]],[11,"fmt","","",97,[[["self"],["formatter"]],["result"]]],[11,"matches","","Tests whether the given input character matches this instruction.",97,[[["self"],["char"]],["bool"]]],[11,"num_chars","","Return the number of distinct characters represented by all of the ranges.",97,[[["self"]],["usize"]]],[11,"clone","","",98,[[["self"]],["instbytes"]]],[11,"fmt","","",98,[[["self"],["formatter"]],["result"]]],[11,"matches","","Returns true if and only if the given byte is in this range.",98,[[["self"],["u8"]],["bool"]]],[0,"re_builder","regex","",N,N],[3,"RegexOptions","regex::re_builder","The set of user configurable options for compiling zero or more regexes.",N,N],[12,"pats","","",101,N],[12,"size_limit","","",101,N],[12,"dfa_size_limit","","",101,N],[12,"nest_limit","","",101,N],[12,"case_insensitive","","",101,N],[12,"multi_line","","",101,N],[12,"dot_matches_new_line","","",101,N],[12,"swap_greed","","",101,N],[12,"ignore_whitespace","","",101,N],[12,"unicode","","",101,N],[0,"bytes","","",N,N],[3,"RegexBuilder","regex::re_builder::bytes","A configurable builder for a regular expression.",N,N],[12,"0","","",19,N],[11,"new","regex::bytes","Create a new regular expression builder with the given pattern.",19,[[["str"]],["regexbuilder"]]],[11,"build","","Consume the builder and compile the regular expression.",19,[[["self"]],["result",["regex","error"]]]],[11,"case_insensitive","","Set the value for the case insensitive (`i`) flag.",19,[[["self"],["bool"]],["regexbuilder"]]],[11,"multi_line","","Set the value for the multi-line matching (`m`) flag.",19,[[["self"],["bool"]],["regexbuilder"]]],[11,"dot_matches_new_line","","Set the value for the any character (`s`) flag, where in `.` matches anything when `s` is set and matches anything except for new line when it is not set (the default).",19,[[["self"],["bool"]],["regexbuilder"]]],[11,"swap_greed","","Set the value for the greedy swap (`U`) flag.",19,[[["self"],["bool"]],["regexbuilder"]]],[11,"ignore_whitespace","","Set the value for the ignore whitespace (`x`) flag.",19,[[["self"],["bool"]],["regexbuilder"]]],[11,"unicode","","Set the value for the Unicode (`u`) flag.",19,[[["self"],["bool"]],["regexbuilder"]]],[11,"size_limit","","Set the approximate size limit of the compiled regular expression.",19,[[["self"],["usize"]],["regexbuilder"]]],[11,"dfa_size_limit","","Set the approximate size of the cache used by the DFA.",19,[[["self"],["usize"]],["regexbuilder"]]],[11,"nest_limit","","Set the nesting limit for this parser.",19,[[["self"],["u32"]],["regexbuilder"]]],[0,"unicode","regex::re_builder","",N,N],[3,"RegexBuilder","regex::re_builder::unicode","A configurable builder for a regular expression.",N,N],[12,"0","","",0,N],[11,"new","regex","Create a new regular expression builder with the given pattern.",0,[[["str"]],["regexbuilder"]]],[11,"build","","Consume the builder and compile the regular expression.",0,[[["self"]],["result",["regex","error"]]]],[11,"case_insensitive","","Set the value for the case insensitive (`i`) flag.",0,[[["self"],["bool"]],["regexbuilder"]]],[11,"multi_line","","Set the value for the multi-line matching (`m`) flag.",0,[[["self"],["bool"]],["regexbuilder"]]],[11,"dot_matches_new_line","","Set the value for the any character (`s`) flag, where in `.` matches anything when `s` is set and matches anything except for new line when it is not set (the default).",0,[[["self"],["bool"]],["regexbuilder"]]],[11,"swap_greed","","Set the value for the greedy swap (`U`) flag.",0,[[["self"],["bool"]],["regexbuilder"]]],[11,"ignore_whitespace","","Set the value for the ignore whitespace (`x`) flag.",0,[[["self"],["bool"]],["regexbuilder"]]],[11,"unicode","","Set the value for the Unicode (`u`) flag.",0,[[["self"],["bool"]],["regexbuilder"]]],[11,"size_limit","","Set the approximate size limit of the compiled regular expression.",0,[[["self"],["usize"]],["regexbuilder"]]],[11,"dfa_size_limit","","Set the approximate size of the cache used by the DFA.",0,[[["self"],["usize"]],["regexbuilder"]]],[11,"nest_limit","","Set the nesting limit for this parser.",0,[[["self"],["u32"]],["regexbuilder"]]],[0,"set_bytes","regex::re_builder","",N,N],[3,"RegexSetBuilder","regex::re_builder::set_bytes","A configurable builder for a set of regular expressions.",N,N],[12,"0","","",20,N],[11,"new","regex::bytes","Create a new regular expression builder with the given pattern.",20,[[["i"]],["regexsetbuilder"]]],[11,"build","","Consume the builder and compile the regular expressions into a set.",20,[[["self"]],["result",["regexset","error"]]]],[11,"case_insensitive","","Set the value for the case insensitive (`i`) flag.",20,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"multi_line","","Set the value for the multi-line matching (`m`) flag.",20,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"dot_matches_new_line","","Set the value for the any character (`s`) flag, where in `.` matches anything when `s` is set and matches anything except for new line when it is not set (the default).",20,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"swap_greed","","Set the value for the greedy swap (`U`) flag.",20,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"ignore_whitespace","","Set the value for the ignore whitespace (`x`) flag.",20,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"unicode","","Set the value for the Unicode (`u`) flag.",20,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"size_limit","","Set the approximate size limit of the compiled regular expression.",20,[[["self"],["usize"]],["regexsetbuilder"]]],[11,"dfa_size_limit","","Set the approximate size of the cache used by the DFA.",20,[[["self"],["usize"]],["regexsetbuilder"]]],[11,"nest_limit","","Set the nesting limit for this parser.",20,[[["self"],["u32"]],["regexsetbuilder"]]],[0,"set_unicode","regex::re_builder","",N,N],[3,"RegexSetBuilder","regex::re_builder::set_unicode","A configurable builder for a set of regular expressions.",N,N],[12,"0","","",1,N],[11,"new","regex","Create a new regular expression builder with the given pattern.",1,[[["i"]],["regexsetbuilder"]]],[11,"build","","Consume the builder and compile the regular expressions into a set.",1,[[["self"]],["result",["regexset","error"]]]],[11,"case_insensitive","","Set the value for the case insensitive (`i`) flag.",1,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"multi_line","","Set the value for the multi-line matching (`m`) flag.",1,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"dot_matches_new_line","","Set the value for the any character (`s`) flag, where in `.` matches anything when `s` is set and matches anything except for new line when it is not set (the default).",1,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"swap_greed","","Set the value for the greedy swap (`U`) flag.",1,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"ignore_whitespace","","Set the value for the ignore whitespace (`x`) flag.",1,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"unicode","","Set the value for the Unicode (`u`) flag.",1,[[["self"],["bool"]],["regexsetbuilder"]]],[11,"size_limit","","Set the approximate size limit of the compiled regular expression.",1,[[["self"],["usize"]],["regexsetbuilder"]]],[11,"dfa_size_limit","","Set the approximate size of the cache used by the DFA.",1,[[["self"],["usize"]],["regexsetbuilder"]]],[11,"nest_limit","","Set the nesting limit for this parser.",1,[[["self"],["u32"]],["regexsetbuilder"]]],[11,"clone","regex::re_builder","",101,[[["self"]],["regexoptions"]]],[11,"fmt","","",101,[[["self"],["formatter"]],["result"]]],[11,"default","","",101,[[],["self"]]],[0,"re_bytes","regex","",N,N],[3,"Match","regex::re_bytes","Match represents a single match of a regex in a haystack.",N,N],[12,"text","","",21,N],[12,"start","","",21,N],[12,"end","","",21,N],[3,"Regex","","A compiled regular expression for matching arbitrary bytes.",N,N],[12,"0","","",22,N],[3,"Matches","","An iterator over all non-overlapping matches for a particular string.",N,N],[12,"0","","",23,N],[3,"CaptureMatches","","An iterator that yields all non-overlapping capture groups matching a particular regular expression.",N,N],[12,"0","","",24,N],[3,"Split","","Yields all substrings delimited by a regular expression match.",N,N],[12,"finder","","",25,N],[12,"last","","",25,N],[3,"SplitN","","Yields at most `N` substrings delimited by a regular expression match.",N,N],[12,"splits","","",26,N],[12,"n","","",26,N],[3,"CaptureNames","","An iterator over the names of all possible captures.",N,N],[12,"0","","",27,N],[3,"Captures","","Captures represents a group of captured byte strings for a single match.",N,N],[12,"text","","",28,N],[12,"locs","","",28,N],[12,"named_groups","","",28,N],[3,"CapturesDebug","","",N,N],[12,"0","","",102,N],[3,"SubCaptureMatches","","An iterator that yields all capturing matches in the order in which they appear in the regex.",N,N],[12,"caps","","",29,N],[12,"it","","",29,N],[3,"ReplacerRef","","By-reference adaptor for a `Replacer`",N,N],[12,"0","","",30,N],[3,"NoExpand","","`NoExpand` indicates literal byte string replacement.",N,N],[12,"0","","",31,N],[8,"Replacer","","Replacer describes types that can be used to replace matches in a byte string.",N,N],[10,"replace_append","","Appends text to `dst` to replace the current match.",36,[[["self"],["captures"],["vec"]]]],[11,"no_expansion","regex::bytes","Return a fixed unchanging replacement byte string.",36,[[["self"]],["option",["cow"]]]],[11,"by_ref","","Return a `Replacer` that borrows and wraps this `Replacer`.",36,[[["self"]],["replacerref"]]],[11,"clone","","",21,[[["self"]],["match"]]],[11,"fmt","","",21,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",21,N],[11,"eq","","",21,[[["self"],["match"]],["bool"]]],[11,"ne","","",21,[[["self"],["match"]],["bool"]]],[11,"start","","Returns the starting byte offset of the match in the haystack.",21,[[["self"]],["usize"]]],[11,"end","","Returns the ending byte offset of the match in the haystack.",21,[[["self"]],["usize"]]],[11,"as_bytes","","Returns the matched text.",21,N],[11,"new","","Creates a new match from the given haystack and byte offsets.",21,N],[11,"clone","","",22,[[["self"]],["regex"]]],[11,"fmt","","Shows the original regular expression.",22,[[["self"],["formatter"]],["result"]]],[11,"fmt","","Shows the original regular expression.",22,[[["self"],["formatter"]],["result"]]],[11,"from","","",22,[[["exec"]],["regex"]]],[11,"from_str","","Attempts to parse a string into a regular expression",22,[[["str"]],["result",["regex","error"]]]],[11,"new","","Compiles a regular expression. Once compiled, it can be used repeatedly to search, split or replace text in a string.",22,[[["str"]],["result",["regex","error"]]]],[11,"is_match","","Returns true if and only if the regex matches the string given.",22,N],[11,"find","","Returns the start and end byte range of the leftmost-first match in `text`. If no match exists, then `None` is returned.",22,N],[11,"find_iter","","Returns an iterator for each successive non-overlapping match in `text`, returning the start and end byte indices with respect to `text`.",22,N],[11,"captures","","Returns the capture groups corresponding to the leftmost-first match in `text`. Capture group `0` always corresponds to the entire match. If no match is found, then `None` is returned.",22,N],[11,"captures_iter","","Returns an iterator over all the non-overlapping capture groups matched in `text`. This is operationally the same as `find_iter`, except it yields information about capturing group matches.",22,N],[11,"split","","Returns an iterator of substrings of `text` delimited by a match of the regular expression. Namely, each element of the iterator corresponds to text that isn't matched by the regular expression.",22,N],[11,"splitn","","Returns an iterator of at most `limit` substrings of `text` delimited by a match of the regular expression. (A `limit` of `0` will return no substrings.) Namely, each element of the iterator corresponds to text that isn't matched by the regular expression. The remainder of the string that is not split will be the last element in the iterator.",22,N],[11,"replace","","Replaces the leftmost-first match with the replacement provided. The replacement can be a regular byte string (where `$N` and `$name` are expanded to match capture groups) or a function that takes the matches' `Captures` and returns the replaced byte string.",22,N],[11,"replace_all","","Replaces all non-overlapping matches in `text` with the replacement provided. This is the same as calling `replacen` with `limit` set to `0`.",22,N],[11,"replacen","","Replaces at most `limit` non-overlapping matches in `text` with the replacement provided. If `limit` is 0, then all non-overlapping matches are replaced.",22,N],[11,"shortest_match","","Returns the end location of a match in the text given.",22,N],[11,"shortest_match_at","","Returns the same as shortest_match, but starts the search at the given offset.",22,N],[11,"is_match_at","","Returns the same as is_match, but starts the search at the given offset.",22,N],[11,"find_at","","Returns the same as find, but starts the search at the given offset.",22,N],[11,"read_captures_at","","Returns the same as captures, but starts the search at the given offset and populates the capture locations given.",22,N],[11,"as_str","","Returns the original string of this regex.",22,[[["self"]],["str"]]],[11,"capture_names","","Returns an iterator over the capture names.",22,[[["self"]],["capturenames"]]],[11,"captures_len","","Returns the number of captures.",22,[[["self"]],["usize"]]],[11,"locations","","Returns an empty set of locations that can be reused in multiple calls to `read_captures`.",22,[[["self"]],["locations"]]],[11,"next","","",23,[[["self"]],["option",["match"]]]],[11,"next","","",24,[[["self"]],["option",["captures"]]]],[11,"next","","",25,[[["self"]],["option"]]],[11,"next","","",26,[[["self"]],["option"]]],[11,"next","","",27,[[["self"]],["option",["option"]]]],[11,"size_hint","","",27,N],[11,"get","","Returns the match associated with the capture group at index `i`. If `i` does not correspond to a capture group, or if the capture group did not participate in the match, then `None` is returned.",28,[[["self"],["usize"]],["option",["match"]]]],[11,"name","","Returns the match for the capture group named `name`. If `name` isn't a valid capture group or didn't match anything, then `None` is returned.",28,[[["self"],["str"]],["option",["match"]]]],[11,"iter","","An iterator that yields all capturing matches in the order in which they appear in the regex. If a particular capture group didn't participate in the match, then `None` is yielded for that capture.",28,[[["self"]],["subcapturematches"]]],[11,"expand","","Expands all instances of `$name` in `replacement` to the corresponding capture group `name`, and writes them to the `dst` buffer given.",28,N],[11,"len","","Returns the number of captured groups.",28,[[["self"]],["usize"]]],[11,"fmt","","",28,[[["self"],["formatter"]],["result"]]],[11,"fmt","regex::re_bytes","",102,[[["self"],["formatter"]],["result"]]],[11,"index","regex::bytes","",28,N],[11,"index","","",28,N],[11,"next","","",29,[[["self"]],["option",["option"]]]],[11,"fmt","","",30,[[["self"],["formatter"]],["result"]]],[11,"replace_append","","",30,[[["self"],["captures"],["vec"]]]],[11,"no_expansion","","",30,[[["self"]],["option",["cow"]]]],[11,"replace_append","","",31,[[["self"],["captures"],["vec"]]]],[11,"no_expansion","","",31,[[["self"]],["option",["cow"]]]],[0,"re_set","regex","",N,N],[0,"unicode","regex::re_set","",N,N],[3,"RegexSet","regex::re_set::unicode","Match multiple (possibly overlapping) regular expressions in a single scan.",N,N],[12,"0","","",2,N],[3,"SetMatches","","A set of matches returned by a regex set.",N,N],[12,"matched_any","","",3,N],[12,"matches","","",3,N],[3,"SetMatchesIntoIter","","An owned iterator over the set of matches from a regex set.",N,N],[12,"0","","",4,N],[3,"SetMatchesIter","","A borrowed iterator over the set of matches from a regex set.",N,N],[12,"0","","",5,N],[5,"as_bytes_str","","",N,N],[5,"as_bytes_bytes","","",N,N],[11,"clone","regex","",2,[[["self"]],["regexset"]]],[11,"new","","Create a new regex set with the given regular expressions.",2,[[["i"]],["result",["regexset","error"]]]],[11,"is_match","","Returns true if and only if one of the regexes in this set matches the text given.",2,[[["self"],["str"]],["bool"]]],[11,"is_match_at","","Returns the same as is_match, but starts the search at the given offset.",2,[[["self"],["str"],["usize"]],["bool"]]],[11,"matches","","Returns the set of regular expressions that match in the given text.",2,[[["self"],["str"]],["setmatches"]]],[11,"read_matches_at","","Returns the same as matches, but starts the search at the given offset and stores the matches into the slice given.",2,N],[11,"len","","Returns the total number of regular expressions in this set.",2,[[["self"]],["usize"]]],[11,"clone","","",3,[[["self"]],["setmatches"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"matched_any","","Whether this set contains any matches.",3,[[["self"]],["bool"]]],[11,"matched","","Whether the regex at the given index matched.",3,[[["self"],["usize"]],["bool"]]],[11,"len","","The total number of regexes in the set that created these matches.",3,[[["self"]],["usize"]]],[11,"iter","","Returns an iterator over indexes in the regex that matched.",3,[[["self"]],["setmatchesiter"]]],[11,"into_iter","","",3,N],[11,"next","","",4,[[["self"]],["option",["usize"]]]],[11,"next_back","","",4,[[["self"]],["option",["usize"]]]],[11,"clone","","",5,[[["self"]],["setmatchesiter"]]],[11,"next","","",5,[[["self"]],["option",["usize"]]]],[11,"next_back","","",5,[[["self"]],["option",["usize"]]]],[11,"from","","",2,[[["exec"]],["self"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[0,"bytes","regex::re_set","",N,N],[3,"RegexSet","regex::re_set::bytes","Match multiple (possibly overlapping) regular expressions in a single scan.",N,N],[12,"0","","",32,N],[3,"SetMatches","","A set of matches returned by a regex set.",N,N],[12,"matched_any","","",33,N],[12,"matches","","",33,N],[3,"SetMatchesIntoIter","","An owned iterator over the set of matches from a regex set.",N,N],[12,"0","","",34,N],[3,"SetMatchesIter","","A borrowed iterator over the set of matches from a regex set.",N,N],[12,"0","","",35,N],[5,"as_bytes_str","","",N,N],[5,"as_bytes_bytes","","",N,N],[11,"clone","regex::bytes","",32,[[["self"]],["regexset"]]],[11,"new","","Create a new regex set with the given regular expressions.",32,[[["i"]],["result",["regexset","error"]]]],[11,"is_match","","Returns true if and only if one of the regexes in this set matches the text given.",32,N],[11,"is_match_at","","Returns the same as is_match, but starts the search at the given offset.",32,N],[11,"matches","","Returns the set of regular expressions that match in the given text.",32,N],[11,"read_matches_at","","Returns the same as matches, but starts the search at the given offset and stores the matches into the slice given.",32,N],[11,"len","","Returns the total number of regular expressions in this set.",32,[[["self"]],["usize"]]],[11,"clone","","",33,[[["self"]],["setmatches"]]],[11,"fmt","","",33,[[["self"],["formatter"]],["result"]]],[11,"matched_any","","Whether this set contains any matches.",33,[[["self"]],["bool"]]],[11,"matched","","Whether the regex at the given index matched.",33,[[["self"],["usize"]],["bool"]]],[11,"len","","The total number of regexes in the set that created these matches.",33,[[["self"]],["usize"]]],[11,"iter","","Returns an iterator over indexes in the regex that matched.",33,[[["self"]],["setmatchesiter"]]],[11,"into_iter","","",33,N],[11,"next","","",34,[[["self"]],["option",["usize"]]]],[11,"next_back","","",34,[[["self"]],["option",["usize"]]]],[11,"clone","","",35,[[["self"]],["setmatchesiter"]]],[11,"next","","",35,[[["self"]],["option",["usize"]]]],[11,"next_back","","",35,[[["self"]],["option",["usize"]]]],[11,"from","","",32,[[["exec"]],["self"]]],[11,"fmt","","",32,[[["self"],["formatter"]],["result"]]],[0,"re_trait","regex","",N,N],[3,"Locations","regex::re_trait","Locations represents the offsets of each capturing group in a regex for a single match.",N,N],[12,"0","","",6,N],[3,"SubCapturesPosIter","","An iterator over capture group positions for a particular match of a regular expression.",N,N],[12,"idx","","",103,N],[12,"locs","","",103,N],[3,"Matches","","An iterator over all non-overlapping successive leftmost-first matches.",N,N],[12,"re","","",104,N],[12,"text","","",104,N],[12,"last_end","","",104,N],[12,"last_match","","",104,N],[3,"CaptureMatches","","An iterator over all non-overlapping successive leftmost-first matches with captures.",N,N],[12,"0","","",105,N],[5,"as_slots","","This is a hack to make Locations -> &mut [Slot] be available internally without exposing it in the public API.",N,N],[6,"Slot","","Slot is a single saved capture location. Note that there are two slots for every capture in a regular expression (one slot each for the start and end of the capture).",N,N],[8,"RegularExpression","","`RegularExpression` describes types that can implement regex searching.",N,N],[16,"Text","","The type of the haystack.",106,N],[10,"slots_len","","The number of capture slots in the compiled regular expression. This is always two times the number of capture groups (two slots per group).",106,[[["self"]],["usize"]]],[11,"locations","","Allocates fresh space for all capturing groups in this regex.",106,[[["self"]],["locations"]]],[10,"next_after_empty","","Returns the position of the next character after `i`.",106,N],[10,"shortest_match_at","","Returns the location of the shortest match.",106,N],[10,"is_match_at","","Returns whether the regex matches the text given.",106,N],[10,"find_at","","Returns the leftmost-first match location if one exists.",106,N],[10,"read_captures_at","","Returns the leftmost-first match location if one exists, and also fills in any matching capture slot locations.",106,N],[11,"find_iter","","Returns an iterator over all non-overlapping successive leftmost-first matches.",106,N],[11,"captures_iter","","Returns an iterator over all non-overlapping successive leftmost-first matches with captures.",106,N],[11,"pos","regex","Returns the start and end positions of the Nth capture group. Returns `None` if `i` is not a valid capture group or if the capture group did not match anything. The positions returned are always byte indices with respect to the original string matched.",6,[[["self"],["usize"]],["option"]]],[11,"iter","","Creates an iterator of all the capture group positions in order of appearance in the regular expression. Positions are byte indices in terms of the original string matched.",6,[[["self"]],["subcapturespositer"]]],[11,"len","","Returns the total number of capturing groups.",6,[[["self"]],["usize"]]],[11,"next","regex::re_trait","",103,[[["self"]],["option",["option"]]]],[11,"text","","Return the text being searched.",104,N],[11,"regex","","Return the underlying regex.",104,[[["self"]],["r"]]],[11,"next","","",104,[[["self"]],["option"]]],[11,"text","","Return the text being searched.",105,N],[11,"regex","","Return the underlying regex.",105,[[["self"]],["r"]]],[11,"next","","",105,[[["self"]],["option",["locations"]]]],[0,"re_unicode","regex","",N,N],[3,"Match","regex::re_unicode","Match represents a single match of a regex in a haystack.",N,N],[12,"text","","",8,N],[12,"start","","",8,N],[12,"end","","",8,N],[3,"Regex","","A compiled regular expression for matching Unicode strings.",N,N],[12,"0","","",7,N],[3,"CaptureNames","","An iterator over the names of all possible captures.",N,N],[12,"0","","",10,N],[3,"Split","","Yields all substrings delimited by a regular expression match.",N,N],[12,"finder","","",16,N],[12,"last","","",16,N],[3,"SplitN","","Yields at most `N` substrings delimited by a regular expression match.",N,N],[12,"splits","","",17,N],[12,"n","","",17,N],[3,"Captures","","Captures represents a group of captured strings for a single match.",N,N],[12,"text","","",9,N],[12,"locs","","",9,N],[12,"named_groups","","",9,N],[3,"CapturesDebug","","",N,N],[12,"0","","",107,N],[3,"SubCaptureMatches","","An iterator that yields all capturing matches in the order in which they appear in the regex.",N,N],[12,"caps","","",13,N],[12,"it","","",13,N],[3,"CaptureMatches","","An iterator that yields all non-overlapping capture groups matching a particular regular expression.",N,N],[12,"0","","",12,N],[3,"Matches","","An iterator over all non-overlapping matches for a particular string.",N,N],[12,"0","","",11,N],[3,"ReplacerRef","","By-reference adaptor for a `Replacer`",N,N],[12,"0","","",14,N],[3,"NoExpand","","`NoExpand` indicates literal string replacement.",N,N],[12,"0","","",15,N],[5,"escape","","Escapes all regular expression meta characters in `text`.",N,[[["str"]],["string"]]],[8,"Replacer","","Replacer describes types that can be used to replace matches in a string.",N,N],[10,"replace_append","","Appends text to `dst` to replace the current match.",108,[[["self"],["captures"],["string"]]]],[11,"no_expansion","","Return a fixed unchanging replacement string.",108,[[["self"]],["option",["cow"]]]],[11,"by_ref","","Return a `Replacer` that borrows and wraps this `Replacer`.",108,[[["self"]],["replacerref"]]],[11,"clone","regex","",8,[[["self"]],["match"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",8,N],[11,"eq","","",8,[[["self"],["match"]],["bool"]]],[11,"ne","","",8,[[["self"],["match"]],["bool"]]],[11,"start","","Returns the starting byte offset of the match in the haystack.",8,[[["self"]],["usize"]]],[11,"end","","Returns the ending byte offset of the match in the haystack.",8,[[["self"]],["usize"]]],[11,"as_str","","Returns the matched text.",8,[[["self"]],["str"]]],[11,"new","","Creates a new match from the given haystack and byte offsets.",8,[[["str"],["usize"],["usize"]],["match"]]],[11,"clone","","",7,[[["self"]],["regex"]]],[11,"fmt","","Shows the original regular expression.",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","Shows the original regular expression.",7,[[["self"],["formatter"]],["result"]]],[11,"from","","",7,[[["exec"]],["regex"]]],[11,"from_str","","Attempts to parse a string into a regular expression",7,[[["str"]],["result",["regex","error"]]]],[11,"new","","Compiles a regular expression. Once compiled, it can be used repeatedly to search, split or replace text in a string.",7,[[["str"]],["result",["regex","error"]]]],[11,"is_match","","Returns true if and only if the regex matches the string given.",7,[[["self"],["str"]],["bool"]]],[11,"find","","Returns the start and end byte range of the leftmost-first match in `text`. If no match exists, then `None` is returned.",7,[[["self"],["str"]],["option",["match"]]]],[11,"find_iter","","Returns an iterator for each successive non-overlapping match in `text`, returning the start and end byte indices with respect to `text`.",7,[[["self"],["str"]],["matches"]]],[11,"captures","","Returns the capture groups corresponding to the leftmost-first match in `text`. Capture group `0` always corresponds to the entire match. If no match is found, then `None` is returned.",7,[[["self"],["str"]],["option",["captures"]]]],[11,"captures_iter","","Returns an iterator over all the non-overlapping capture groups matched in `text`. This is operationally the same as `find_iter`, except it yields information about capturing group matches.",7,[[["self"],["str"]],["capturematches"]]],[11,"split","","Returns an iterator of substrings of `text` delimited by a match of the regular expression. Namely, each element of the iterator corresponds to text that isn't matched by the regular expression.",7,[[["self"],["str"]],["split"]]],[11,"splitn","","Returns an iterator of at most `limit` substrings of `text` delimited by a match of the regular expression. (A `limit` of `0` will return no substrings.) Namely, each element of the iterator corresponds to text that isn't matched by the regular expression. The remainder of the string that is not split will be the last element in the iterator.",7,[[["self"],["str"],["usize"]],["splitn"]]],[11,"replace","","Replaces the leftmost-first match with the replacement provided. The replacement can be a regular string (where `$N` and `$name` are expanded to match capture groups) or a function that takes the matches' `Captures` and returns the replaced string.",7,[[["self"],["str"],["r"]],["cow",["str"]]]],[11,"replace_all","","Replaces all non-overlapping matches in `text` with the replacement provided. This is the same as calling `replacen` with `limit` set to `0`.",7,[[["self"],["str"],["r"]],["cow",["str"]]]],[11,"replacen","","Replaces at most `limit` non-overlapping matches in `text` with the replacement provided. If `limit` is 0, then all non-overlapping matches are replaced.",7,[[["self"],["str"],["usize"],["r"]],["cow",["str"]]]],[11,"shortest_match","","Returns the end location of a match in the text given.",7,[[["self"],["str"]],["option",["usize"]]]],[11,"shortest_match_at","","Returns the same as shortest_match, but starts the search at the given offset.",7,[[["self"],["str"],["usize"]],["option",["usize"]]]],[11,"is_match_at","","Returns the same as is_match, but starts the search at the given offset.",7,[[["self"],["str"],["usize"]],["bool"]]],[11,"find_at","","Returns the same as find, but starts the search at the given offset.",7,[[["self"],["str"],["usize"]],["option",["match"]]]],[11,"read_captures_at","","Returns the same as captures, but starts the search at the given offset and populates the capture locations given.",7,[[["self"],["locations"],["str"],["usize"]],["option",["match"]]]],[11,"as_str","","Returns the original string of this regex.",7,[[["self"]],["str"]]],[11,"capture_names","","Returns an iterator over the capture names.",7,[[["self"]],["capturenames"]]],[11,"captures_len","","Returns the number of captures.",7,[[["self"]],["usize"]]],[11,"locations","","Returns an empty set of locations that can be reused in multiple calls to `read_captures`.",7,[[["self"]],["locations"]]],[11,"next","","",10,[[["self"]],["option",["option"]]]],[11,"size_hint","","",10,N],[11,"next","","",16,[[["self"]],["option",["str"]]]],[11,"next","","",17,[[["self"]],["option",["str"]]]],[11,"get","","Returns the match associated with the capture group at index `i`. If `i` does not correspond to a capture group, or if the capture group did not participate in the match, then `None` is returned.",9,[[["self"],["usize"]],["option",["match"]]]],[11,"name","","Returns the match for the capture group named `name`. If `name` isn't a valid capture group or didn't match anything, then `None` is returned.",9,[[["self"],["str"]],["option",["match"]]]],[11,"iter","","An iterator that yields all capturing matches in the order in which they appear in the regex. If a particular capture group didn't participate in the match, then `None` is yielded for that capture.",9,[[["self"]],["subcapturematches"]]],[11,"expand","","Expands all instances of `$name` in `replacement` to the corresponding capture group `name`, and writes them to the `dst` buffer given.",9,[[["self"],["str"],["string"]]]],[11,"len","","Returns the number of captured groups.",9,[[["self"]],["usize"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"fmt","regex::re_unicode","",107,[[["self"],["formatter"]],["result"]]],[11,"index","regex","",9,[[["self"],["usize"]],["str"]]],[11,"index","","",9,[[["self"],["str"]],["str"]]],[11,"next","","",13,[[["self"]],["option",["option"]]]],[11,"next","","",12,[[["self"]],["option",["captures"]]]],[11,"next","","",11,[[["self"]],["option",["match"]]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"replace_append","","",14,[[["self"],["captures"],["string"]]]],[11,"no_expansion","","",14,[[["self"]],["option",["cow"]]]],[11,"replace_append","","",15,[[["self"],["captures"],["string"]]]],[11,"no_expansion","","",15,[[["self"]],["option",["cow"]]]],[0,"sparse","","",N,N],[3,"SparseSet","regex::sparse","A sparse set used for representing ordered NFA states.",N,N],[12,"dense","","Dense contains the instruction pointers in the order in which they were inserted. Accessing elements >= self.size is illegal.",109,N],[12,"sparse","","Sparse maps instruction pointers to their location in dense.",109,N],[12,"size","","The number of elements in the set.",109,N],[11,"clone","","",109,[[["self"]],["sparseset"]]],[11,"fmt","","",109,[[["self"],["formatter"]],["result"]]],[11,"new","","",109,[[["usize"]],["sparseset"]]],[11,"len","","",109,[[["self"]],["usize"]]],[11,"is_empty","","",109,[[["self"]],["bool"]]],[11,"capacity","","",109,[[["self"]],["usize"]]],[11,"insert","","",109,[[["self"],["usize"]]]],[11,"contains","","",109,[[["self"],["usize"]],["bool"]]],[11,"clear","","",109,[[["self"]]]],[11,"deref","","",109,N],[0,"internal","regex","The `internal` module exists to support suspicious activity, such as testing different matching engines and supporting the `regex-debug` CLI utility.",N,N],[3,"Compiler","regex::internal","A compiler translates a regular expression AST to a sequence of instructions. The sequence of instructions represents an NFA.",N,N],[12,"insts","","",41,N],[12,"compiled","","",41,N],[12,"capture_name_idx","","",41,N],[12,"num_exprs","","",41,N],[12,"size_limit","","",41,N],[12,"suffix_cache","","",41,N],[12,"utf8_seqs","","",41,N],[12,"byte_classes","","",41,N],[3,"Exec","","`Exec` manages the execution of a regular expression.",N,N],[12,"ro","","All read only state.",61,N],[12,"cache","","Caches for the various matching engines.",61,N],[3,"ExecBuilder","","Facilitates the construction of an executor by exposing various knobs to control how a regex is executed and what kinds of resources it's permitted to use.",N,N],[12,"options","","",65,N],[12,"match_type","","",65,N],[12,"bytes","","",65,N],[12,"only_utf8","","",65,N],[3,"Char","","An inline representation of `Option<char>`.",N,N],[12,"0","","",76,N],[3,"CharInput","","An input reader over characters.",N,N],[12,"0","","",74,N],[3,"InputAt","","Represents a location in the input.",N,N],[12,"pos","","",73,N],[12,"c","","",73,N],[12,"byte","","",73,N],[12,"len","","",73,N],[3,"LiteralSearcher","","A prefix extracted from a compiled regular expression.",N,N],[12,"complete","","",78,N],[12,"lcp","","",78,N],[12,"lcs","","",78,N],[12,"matcher","","",78,N],[3,"Program","","Program is a sequence of instructions and various facts about thos instructions.",N,N],[12,"insts","","A sequence of instructions that represents an NFA.",92,N],[12,"matches","","Pointers to each Match instruction in the sequence.",92,N],[12,"captures","","The ordered sequence of all capture groups extracted from the AST. Unnamed groups are `None`.",92,N],[12,"capture_name_idx","","Pointers to all named capture groups into `captures`.",92,N],[12,"start","","A pointer to the start instruction. This can vary depending on how the program was compiled. For example, programs for use with the DFA engine have a `.*?` inserted at the beginning of unanchored regular expressions. The actual starting point of the program is after the `.*?`.",92,N],[12,"byte_classes","","A set of equivalence classes for discriminating bytes in the compiled program.",92,N],[12,"only_utf8","","When true, this program can only match valid UTF-8.",92,N],[12,"is_bytes","","When true, this program uses byte range instructions instead of Unicode range instructions.",92,N],[12,"is_dfa","","When true, the program is compiled for DFA matching. For example, this implies `is_bytes` and also inserts a preceding `.*?` for unanchored regexes.",92,N],[12,"is_reverse","","When true, the program matches text in reverse (for use only in the DFA).",92,N],[12,"is_anchored_start","","Whether the regex must match from the start of the input.",92,N],[12,"is_anchored_end","","Whether the regex must match at the end of the input.",92,N],[12,"has_unicode_word_boundary","","Whether this program contains a Unicode word boundary instruction.",92,N],[12,"prefixes","","A possibly empty machine for very quickly matching prefix literals.",92,N],[12,"dfa_size_limit","","A limit on the size of the cache that the DFA is allowed to use while matching.",92,N],[3,"InstRanges","","Representation of the Ranges instruction.",N,N],[12,"goto","","The next location to execute in the program if this instruction succeeds.",97,N],[12,"ranges","","The set of Unicode scalar value ranges to test.",97,N],[4,"Inst","","Inst is an instruction code in a Regex program.",N,N],[13,"Match","","Match indicates that the program has reached a match state.",99,N],[13,"Save","","Save causes the program to save the current location of the input in the slot indicated by InstSave.",99,N],[13,"Split","","Split causes the program to diverge to one of two paths in the program, preferring goto1 in InstSplit.",99,N],[13,"EmptyLook","","EmptyLook represents a zero-width assertion in a regex program. A zero-width assertion does not consume any of the input text.",99,N],[13,"Char","","Char requires the regex program to match the character in InstChar at the current position in the input.",99,N],[13,"Ranges","","Ranges requires the regex program to match the character at the current position in the input with one of the ranges specified in InstRanges.",99,N],[13,"Bytes","","Bytes is like Ranges, except it expresses a single byte range. It is used in conjunction with Split instructions to implement multi-byte character classes.",99,N],[4,"EmptyLook","","The set of zero-width match instructions.",N,N],[13,"StartLine","","Start of line or input.",100,N],[13,"EndLine","","End of line or input.",100,N],[13,"StartText","","Start of input.",100,N],[13,"EndText","","End of input.",100,N],[13,"WordBoundary","","Word character on one side and non-word character on other.",100,N],[13,"NotWordBoundary","","Word character on both sides or non-word character on both sides.",100,N],[13,"WordBoundaryAscii","","ASCII word boundary.",100,N],[13,"NotWordBoundaryAscii","","Not ASCII word boundary.",100,N],[8,"Input","","An abstraction over input used in the matching engines.",N,N],[10,"at","","Return an encoding of the position at byte offset `i`.",77,[[["self"],["usize"]],["inputat"]]],[10,"next_char","","Return the Unicode character occurring next to `at`.",77,[[["self"],["inputat"]],["char"]]],[10,"previous_char","","Return the Unicode character occurring previous to `at`.",77,[[["self"],["inputat"]],["char"]]],[10,"is_empty_match","","Return true if the given empty width instruction matches at the input position given.",77,[[["self"],["inputat"],["instemptylook"]],["bool"]]],[10,"prefix_at","","Scan the input for a matching prefix.",77,[[["self"],["literalsearcher"],["inputat"]],["option",["inputat"]]]],[10,"len","","The number of bytes in the input.",77,[[["self"]],["usize"]]],[11,"is_empty","regex::input","Whether the input is empty.",77,[[["self"]],["bool"]]],[10,"as_bytes","regex::internal","Return the given input as a sequence of bytes.",77,N],[8,"Replacer","regex","Replacer describes types that can be used to replace matches in a string.",N,N],[10,"replace_append","","Appends text to `dst` to replace the current match.",108,[[["self"],["captures"],["string"]]]],[11,"no_expansion","regex::re_unicode","Return a fixed unchanging replacement string.",108,[[["self"]],["option",["cow"]]]],[11,"by_ref","","Return a `Replacer` that borrows and wraps this `Replacer`.",108,[[["self"]],["replacerref"]]]],"paths":[[3,"RegexBuilder"],[3,"RegexSetBuilder"],[3,"RegexSet"],[3,"SetMatches"],[3,"SetMatchesIntoIter"],[3,"SetMatchesIter"],[3,"Locations"],[3,"Regex"],[3,"Match"],[3,"Captures"],[3,"CaptureNames"],[3,"Matches"],[3,"CaptureMatches"],[3,"SubCaptureMatches"],[3,"ReplacerRef"],[3,"NoExpand"],[3,"Split"],[3,"SplitN"],[4,"Error"],[3,"RegexBuilder"],[3,"RegexSetBuilder"],[3,"Match"],[3,"Regex"],[3,"Matches"],[3,"CaptureMatches"],[3,"Split"],[3,"SplitN"],[3,"CaptureNames"],[3,"Captures"],[3,"SubCaptureMatches"],[3,"ReplacerRef"],[3,"NoExpand"],[3,"RegexSet"],[3,"SetMatches"],[3,"SetMatchesIntoIter"],[3,"SetMatchesIter"],[8,"Replacer"],[3,"Bounded"],[3,"Cache"],[4,"Job"],[3,"Patch"],[3,"Compiler"],[3,"CompileClass"],[3,"SuffixCache"],[3,"SuffixCacheEntry"],[3,"SuffixCacheKey"],[3,"ByteClassSet"],[4,"Hole"],[4,"MaybeInst"],[4,"InstHole"],[3,"Cache"],[3,"CacheInner"],[3,"Transitions"],[3,"Fsm"],[3,"State"],[3,"InstPtrs"],[3,"Byte"],[3,"EmptyFlags"],[3,"StateFlags"],[3,"TransitionsRow"],[4,"Result"],[3,"Exec"],[3,"ExecNoSync"],[3,"ExecNoSyncStr"],[3,"ExecReadOnly"],[3,"ExecBuilder"],[3,"Parsed"],[3,"ProgramCacheInner"],[4,"MatchType"],[4,"MatchLiteralType"],[4,"MatchNfaType"],[3,"CaptureRef"],[4,"Ref"],[3,"InputAt"],[3,"CharInput"],[3,"ByteInput"],[3,"Char"],[8,"Input"],[3,"LiteralSearcher"],[3,"SingleByteSet"],[3,"FreqyPacked"],[3,"BoyerMooreSearch"],[4,"Matcher"],[4,"LiteralIter"],[3,"Teddy"],[3,"Match"],[3,"Teddy"],[3,"Match"],[3,"Fsm"],[3,"Cache"],[3,"Threads"],[4,"FollowEpsilon"],[3,"Program"],[3,"InstSave"],[3,"InstSplit"],[3,"InstEmptyLook"],[3,"InstChar"],[3,"InstRanges"],[3,"InstBytes"],[4,"Inst"],[4,"EmptyLook"],[3,"RegexOptions"],[3,"CapturesDebug"],[3,"SubCapturesPosIter"],[3,"Matches"],[3,"CaptureMatches"],[8,"RegularExpression"],[3,"CapturesDebug"],[8,"Replacer"],[3,"SparseSet"]]};
searchIndex["regex_syntax"]={"doc":"This crate provides a robust regular expression parser.","items":[[3,"Parser","regex_syntax","A convenience parser for regular expressions.",N,N],[12,"ast","","",0,N],[12,"hir","","",0,N],[3,"ParserBuilder","","A builder for a regular expression parser.",N,N],[12,"ast","","",1,N],[12,"hir","","",1,N],[4,"Error","","This error type encompasses any error that can be returned by this crate.",N,N],[13,"Parse","","An error that occurred while translating concrete syntax into abstract syntax (AST).",2,N],[13,"Translate","","An error that occurred while translating abstract syntax into a high level intermediate representation (HIR).",2,N],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",2,N],[5,"escape","","Escapes all regular expression meta characters in `text`.",N,[[["str"]],["string"]]],[5,"escape_into","","Escapes all meta characters in `text` and writes the result into `buf`.",N,[[["str"],["string"]]]],[5,"is_meta_character","","Returns true if the give character has significance in a regex.",N,[[["char"]],["bool"]]],[5,"is_word_character","","Returns true if and only if the given character is a Unicode word character.",N,[[["char"]],["bool"]]],[5,"is_word_byte","","Returns true if and only if the given character is an ASCII word character.",N,[[["u8"]],["bool"]]],[0,"ast","","Defines an abstract syntax for regular expressions.",N,N],[3,"Error","regex_syntax::ast","An error that occurred while parsing a regular expression into an abstract syntax tree.",N,N],[12,"kind","","The kind of error.",3,N],[12,"pattern","","The original pattern that the parser generated the error from. Every span in an error is a valid range into this string.",3,N],[12,"span","","The span of this error.",3,N],[3,"Span","","Span represents the position information of a single AST item.",N,N],[12,"start","","The start byte offset.",4,N],[12,"end","","The end byte offset.",4,N],[3,"Position","","A single position in a regular expression.",N,N],[12,"offset","","The absolute offset of this position, starting at `0` from the beginning of the regular expression pattern string.",5,N],[12,"line","","The line number, starting at `1`.",5,N],[12,"column","","The approximate column number, starting at `1`.",5,N],[3,"WithComments","","An abstract syntax tree for a singular expression along with comments found.",N,N],[12,"ast","","The actual ast.",6,N],[12,"comments","","All comments found in the original regular expression.",6,N],[3,"Comment","","A comment from a regular expression with an associated span.",N,N],[12,"span","","The span of this comment, including the beginning `#` and ending `\\n`.",7,N],[12,"comment","","The comment text, starting with the first character following the `#` and ending with the last character preceding the `\\n`.",7,N],[3,"Alternation","","An alternation of regular expressions.",N,N],[12,"span","","The span of this alternation.",8,N],[12,"asts","","The alternate regular expressions.",8,N],[3,"Concat","","A concatenation of regular expressions.",N,N],[12,"span","","The span of this concatenation.",9,N],[12,"asts","","The concatenation regular expressions.",9,N],[3,"Literal","","A single literal expression.",N,N],[12,"span","","The span of this literal.",10,N],[12,"kind","","The kind of this literal.",10,N],[12,"c","","The Unicode scalar value corresponding to this literal.",10,N],[3,"ClassPerl","","A Perl character class.",N,N],[12,"span","","The span of this class.",11,N],[12,"kind","","The kind of Perl class.",11,N],[12,"negated","","Whether the class is negated or not. e.g., `\\d` is not negated but `\\D` is.",11,N],[3,"ClassAscii","","An ASCII character class.",N,N],[12,"span","","The span of this class.",12,N],[12,"kind","","The kind of ASCII class.",12,N],[12,"negated","","Whether the class is negated or not. e.g., `[[:alpha:]]` is not negated but `[[:^alpha:]]` is.",12,N],[3,"ClassUnicode","","A Unicode character class.",N,N],[12,"span","","The span of this class.",13,N],[12,"negated","","Whether this class is negated or not.",13,N],[12,"kind","","The kind of Unicode class.",13,N],[3,"ClassBracketed","","A bracketed character class, e.g., `[a-z0-9]`.",N,N],[12,"span","","The span of this class.",14,N],[12,"negated","","Whether this class is negated or not. e.g., `[a]` is not negated but `[^a]` is.",14,N],[12,"kind","","The type of this set. A set is either a normal union of things, e.g., `[abc]` or a result of applying set operations, e.g., `[\\pL--c]`.",14,N],[3,"ClassSetRange","","A single character class range in a set.",N,N],[12,"span","","The span of this range.",15,N],[12,"start","","The start of this range.",15,N],[12,"end","","The end of this range.",15,N],[3,"ClassSetUnion","","A union of items inside a character class set.",N,N],[12,"span","","The span of the items in this operation. e.g., the `a-z0-9` in `[^a-z0-9]`",16,N],[12,"items","","The sequence of items that make up this union.",16,N],[3,"ClassSetBinaryOp","","A Unicode character class set operation.",N,N],[12,"span","","The span of this operation. e.g., the `a-z--[h-p]` in `[a-z--h-p]`.",17,N],[12,"kind","","The type of this set operation.",17,N],[12,"lhs","","The left hand side of the operation.",17,N],[12,"rhs","","The right hand side of the operation.",17,N],[3,"Assertion","","A single zero-width assertion.",N,N],[12,"span","","The span of this assertion.",18,N],[12,"kind","","The assertion kind, e.g., `\\b` or `^`.",18,N],[3,"Repetition","","A repetition operation applied to a regular expression.",N,N],[12,"span","","The span of this operation.",19,N],[12,"op","","The actual operation.",19,N],[12,"greedy","","Whether this operation was applied greedily or not.",19,N],[12,"ast","","The regular expression under repetition.",19,N],[3,"RepetitionOp","","The repetition operator itself.",N,N],[12,"span","","The span of this operator. This includes things like `+`, `*?` and `{m,n}`.",20,N],[12,"kind","","The type of operation.",20,N],[3,"Group","","A grouped regular expression.",N,N],[12,"span","","The span of this group.",21,N],[12,"kind","","The kind of this group.",21,N],[12,"ast","","The regular expression in this group.",21,N],[3,"CaptureName","","A capture name.",N,N],[12,"span","","The span of this capture name.",22,N],[12,"name","","The capture name.",22,N],[12,"index","","The capture index.",22,N],[3,"SetFlags","","A group of flags that is not applied to a particular regular expression.",N,N],[12,"span","","The span of these flags, including the grouping parentheses.",23,N],[12,"flags","","The actual sequence of flags.",23,N],[3,"Flags","","A group of flags.",N,N],[12,"span","","The span of this group of flags.",24,N],[12,"items","","A sequence of flag items. Each item is either a flag or a negation operator.",24,N],[3,"FlagsItem","","A single item in a group of flags.",N,N],[12,"span","","The span of this item.",25,N],[12,"kind","","The kind of this item.",25,N],[4,"ErrorKind","","The type of an error that occurred while building an AST.",N,N],[13,"CaptureLimitExceeded","","The capturing group limit was exceeded.",26,N],[13,"ClassEscapeInvalid","","An invalid escape sequence was found in a character class set.",26,N],[13,"ClassRangeInvalid","","An invalid character class range was found. An invalid range is any range where the start is greater than the end.",26,N],[13,"ClassRangeLiteral","","An invalid range boundary was found in a character class. Range boundaries must be a single literal codepoint, but this error indicates that something else was found, such as a nested class.",26,N],[13,"ClassUnclosed","","An opening `[` was found with no corresponding closing `]`.",26,N],[13,"DecimalEmpty","","An empty decimal number was given where one was expected.",26,N],[13,"DecimalInvalid","","An invalid decimal number was given where one was expected.",26,N],[13,"EscapeHexEmpty","","A bracketed hex literal was empty.",26,N],[13,"EscapeHexInvalid","","A bracketed hex literal did not correspond to a Unicode scalar value.",26,N],[13,"EscapeHexInvalidDigit","","An invalid hexadecimal digit was found.",26,N],[13,"EscapeUnexpectedEof","","EOF was found before an escape sequence was completed.",26,N],[13,"EscapeUnrecognized","","An unrecognized escape sequence.",26,N],[13,"FlagDanglingNegation","","A dangling negation was used when setting flags, e.g., `i-`.",26,N],[13,"FlagDuplicate","","A flag was used twice, e.g., `i-i`.",26,N],[12,"original","regex_syntax::ast::ErrorKind","The position of the original flag. The error position points to the duplicate flag.",26,N],[13,"FlagRepeatedNegation","regex_syntax::ast","The negation operator was used twice, e.g., `-i-s`.",26,N],[12,"original","regex_syntax::ast::ErrorKind","The position of the original negation operator. The error position points to the duplicate negation operator.",26,N],[13,"FlagUnexpectedEof","regex_syntax::ast","Expected a flag but got EOF, e.g., `(?`.",26,N],[13,"FlagUnrecognized","","Unrecognized flag, e.g., `a`.",26,N],[13,"GroupNameDuplicate","","A duplicate capture name was found.",26,N],[12,"original","regex_syntax::ast::ErrorKind","The position of the initial occurrence of the capture name. The error position itself points to the duplicate occurrence.",26,N],[13,"GroupNameEmpty","regex_syntax::ast","A capture group name is empty, e.g., `(?P<>abc)`.",26,N],[13,"GroupNameInvalid","","An invalid character was seen for a capture group name. This includes errors where the first character is a digit (even though subsequent characters are allowed to be digits).",26,N],[13,"GroupNameUnexpectedEof","","A closing `>` could not be found for a capture group name.",26,N],[13,"GroupUnclosed","","An unclosed group, e.g., `(ab`.",26,N],[13,"GroupUnopened","","An unopened group, e.g., `ab)`.",26,N],[13,"NestLimitExceeded","","The nest limit was exceeded. The limit stored here is the limit configured in the parser.",26,N],[13,"RepetitionCountInvalid","","The range provided in a counted repetition operator is invalid. The range is invalid if the start is greater than the end.",26,N],[13,"RepetitionCountUnclosed","","An opening `{` was found with no corresponding closing `}`.",26,N],[13,"RepetitionMissing","","A repetition operator was applied to a missing sub-expression. This occurs, for example, in the regex consisting of just a `*` or even `(?i)*`. It is, however, possible to create a repetition operating on an empty sub-expression. For example, `()*` is still considered valid.",26,N],[13,"UnsupportedBackreference","","When octal support is disabled, this error is produced when an octal escape is used. The octal escape is assumed to be an invocation of a backreference, which is the common case.",26,N],[13,"UnsupportedLookAround","","When syntax similar to PCRE's look-around is used, this error is returned. Some example syntaxes that are rejected include, but are not necessarily limited to, `(?=re)`, `(?!re)`, `(?<=re)` and `(?<!re)`. Note that all of these syntaxes are otherwise invalid; this error is used to improve the user experience.",26,N],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",26,N],[4,"Ast","","An abstract syntax tree for a single regular expression.",N,N],[13,"Empty","","An empty regex that matches everything.",27,N],[13,"Flags","","A set of flags, e.g., `(?is)`.",27,N],[13,"Literal","","A single character literal, which includes escape sequences.",27,N],[13,"Dot","","The \"any character\" class.",27,N],[13,"Assertion","","A single zero-width assertion.",27,N],[13,"Class","","A single character class. This includes all forms of character classes except for `.`. e.g., `\\d`, `\\pN`, `[a-z]` and `[[:alpha:]]`.",27,N],[13,"Repetition","","A repetition operator applied to an arbitrary regular expression.",27,N],[13,"Group","","A grouped regular expression.",27,N],[13,"Alternation","","An alternation of regular expressions.",27,N],[13,"Concat","","A concatenation of regular expressions.",27,N],[4,"LiteralKind","","The kind of a single literal expression.",N,N],[13,"Verbatim","","The literal is written verbatim, e.g., `a` or `☃`.",28,N],[13,"Punctuation","","The literal is written as an escape because it is punctuation, e.g., `\\*` or `\\[`.",28,N],[13,"Octal","","The literal is written as an octal escape, e.g., `\\141`.",28,N],[13,"HexFixed","","The literal is written as a hex code with a fixed number of digits depending on the type of the escape, e.g., `\\x61` or or `\\u0061` or `\\U00000061`.",28,N],[13,"HexBrace","","The literal is written as a hex code with a bracketed number of digits. The only restriction is that the bracketed hex code must refer to a valid Unicode scalar value.",28,N],[13,"Special","","The literal is written as a specially recognized escape, e.g., `\\f` or `\\n`.",28,N],[4,"SpecialLiteralKind","","The type of a special literal.",N,N],[13,"Bell","","Bell, spelled `\\a` (`\\x07`).",29,N],[13,"FormFeed","","Form feed, spelled `\\f` (`\\x0C`).",29,N],[13,"Tab","","Tab, spelled `\\t` (`\\x09`).",29,N],[13,"LineFeed","","Line feed, spelled `\\n` (`\\x0A`).",29,N],[13,"CarriageReturn","","Carriage return, spelled `\\r` (`\\x0D`).",29,N],[13,"VerticalTab","","Vertical tab, spelled `\\v` (`\\x0B`).",29,N],[13,"Space","","Space, spelled `\\` (`\\x20`). Note that this can only appear when parsing in verbose mode.",29,N],[4,"HexLiteralKind","","The type of a Unicode hex literal.",N,N],[13,"X","","A `\\x` prefix. When used without brackets, this form is limited to two digits.",30,N],[13,"UnicodeShort","","A `\\u` prefix. When used without brackets, this form is limited to four digits.",30,N],[13,"UnicodeLong","","A `\\U` prefix. When used without brackets, this form is limited to eight digits.",30,N],[4,"Class","","A single character class expression.",N,N],[13,"Unicode","","A Unicode character class, e.g., `\\pL` or `\\p{Greek}`.",31,N],[13,"Perl","","A perl character class, e.g., `\\d` or `\\W`.",31,N],[13,"Bracketed","","A bracketed character class set, which may contain zero or more character ranges and/or zero or more nested classes. e.g., `[a-zA-Z\\pL]`.",31,N],[4,"ClassPerlKind","","The available Perl character classes.",N,N],[13,"Digit","","Decimal numbers.",32,N],[13,"Space","","Whitespace.",32,N],[13,"Word","","Word characters.",32,N],[4,"ClassAsciiKind","","The available ASCII character classes.",N,N],[13,"Alnum","","`[0-9A-Za-z]`",33,N],[13,"Alpha","","`[A-Za-z]`",33,N],[13,"Ascii","","`[\\x00-\\x7F]`",33,N],[13,"Blank","","`[ \\t]`",33,N],[13,"Cntrl","","`[\\x00-\\x1F\\x7F]`",33,N],[13,"Digit","","`[0-9]`",33,N],[13,"Graph","","`[!-~]`",33,N],[13,"Lower","","`[a-z]`",33,N],[13,"Print","","`[ -~]`",33,N],[13,"Punct","","`[!-/:-@\\[-`{-~]`",33,N],[13,"Space","","`[\\t\\n\\v\\f\\r ]`",33,N],[13,"Upper","","`[A-Z]`",33,N],[13,"Word","","`[0-9A-Za-z_]`",33,N],[13,"Xdigit","","`[0-9A-Fa-f]`",33,N],[4,"ClassUnicodeKind","","The available forms of Unicode character classes.",N,N],[13,"OneLetter","","A one letter abbreviated class, e.g., `\\pN`.",34,N],[13,"Named","","A binary property, general category or script. The string may be empty.",34,N],[13,"NamedValue","","A property name and an associated value.",34,N],[12,"op","regex_syntax::ast::ClassUnicodeKind","The type of Unicode op used to associate `name` with `value`.",34,N],[12,"name","","The property name (which may be empty).",34,N],[12,"value","","The property value (which may be empty).",34,N],[4,"ClassUnicodeOpKind","regex_syntax::ast","The type of op used in a Unicode character class.",N,N],[13,"Equal","","A property set to a specific value, e.g., `\\p{scx=Katakana}`.",35,N],[13,"Colon","","A property set to a specific value using a colon, e.g., `\\p{scx:Katakana}`.",35,N],[13,"NotEqual","","A property that isn't a particular value, e.g., `\\p{scx!=Katakana}`.",35,N],[4,"ClassSet","","A character class set.",N,N],[13,"Item","","An item, which can be a single literal, range, nested character class or a union of items.",36,N],[13,"BinaryOp","","A single binary operation (i.e., &&, -- or ~~).",36,N],[4,"ClassSetItem","","A single component of a character class set.",N,N],[13,"Empty","","An empty item.",37,N],[13,"Literal","","A single literal.",37,N],[13,"Range","","A range between two literals.",37,N],[13,"Ascii","","An ASCII character class, e.g., `[:alnum:]` or `[:punct:]`.",37,N],[13,"Unicode","","A Unicode character class, e.g., `\\pL` or `\\p{Greek}`.",37,N],[13,"Perl","","A perl character class, e.g., `\\d` or `\\W`.",37,N],[13,"Bracketed","","A bracketed character class set, which may contain zero or more character ranges and/or zero or more nested classes. e.g., `[a-zA-Z\\pL]`.",37,N],[13,"Union","","A union of items.",37,N],[4,"ClassSetBinaryOpKind","","The type of a Unicode character class set operation.",N,N],[13,"Intersection","","The intersection of two sets, e.g., `\\pN&&[a-z]`.",38,N],[13,"Difference","","The difference of two sets, e.g., `\\pN--[0-9]`.",38,N],[13,"SymmetricDifference","","The symmetric difference of two sets. The symmetric difference is the set of elements belonging to one but not both sets. e.g., `[\\pL~~[:ascii:]]`.",38,N],[4,"AssertionKind","","An assertion kind.",N,N],[13,"StartLine","","`^`",39,N],[13,"EndLine","","`$`",39,N],[13,"StartText","","`\\A`",39,N],[13,"EndText","","`\\z`",39,N],[13,"WordBoundary","","`\\b`",39,N],[13,"NotWordBoundary","","`\\B`",39,N],[4,"RepetitionKind","","The kind of a repetition operator.",N,N],[13,"ZeroOrOne","","`?`",40,N],[13,"ZeroOrMore","","`*`",40,N],[13,"OneOrMore","","`+`",40,N],[13,"Range","","`{m,n}`",40,N],[4,"RepetitionRange","","A range repetition operator.",N,N],[13,"Exactly","","`{m}`",41,N],[13,"AtLeast","","`{m,}`",41,N],[13,"Bounded","","`{m,n}`",41,N],[4,"GroupKind","","The kind of a group.",N,N],[13,"CaptureIndex","","`(a)`",42,N],[13,"CaptureName","","`(?P<name>a)`",42,N],[13,"NonCapturing","","`(?:a)` and `(?i:a)`",42,N],[4,"FlagsItemKind","","The kind of an item in a group of flags.",N,N],[13,"Negation","","A negation operator applied to all subsequent flags in the enclosing group.",43,N],[13,"Flag","","A single flag in a group.",43,N],[4,"Flag","","A single flag.",N,N],[13,"CaseInsensitive","","`i`",44,N],[13,"MultiLine","","`m`",44,N],[13,"DotMatchesNewLine","","`s`",44,N],[13,"SwapGreed","","`U`",44,N],[13,"Unicode","","`u`",44,N],[13,"IgnoreWhitespace","","`x`",44,N],[5,"visit","","Executes an implementation of `Visitor` in constant stack space.",N,[[["ast"],["v"]],["result"]]],[0,"parse","","This module provides a regular expression parser.",N,N],[3,"ParserBuilder","regex_syntax::ast::parse","A builder for a regular expression parser.",N,N],[12,"ignore_whitespace","","",45,N],[12,"nest_limit","","",45,N],[12,"octal","","",45,N],[3,"Parser","","A regular expression parser.",N,N],[12,"pos","","The current position of the parser.",46,N],[12,"capture_index","","The current capture index.",46,N],[12,"nest_limit","","The maximum number of open parens/brackets allowed. If the parser exceeds this number, then an error is returned.",46,N],[12,"octal","","Whether to support octal syntax or not. When `false`, the parser will return an error helpfully pointing out that backreferences are not supported.",46,N],[12,"initial_ignore_whitespace","","The initial setting for `ignore_whitespace` as provided by Th`ParserBuilder`. is is used when reseting the parser's state.",46,N],[12,"ignore_whitespace","","Whether whitespace should be ignored. When enabled, comments are also permitted.",46,N],[12,"comments","","A list of comments, in order of appearance.",46,N],[12,"stack_group","","A stack of grouped sub-expressions, including alternations.",46,N],[12,"stack_class","","A stack of nested character classes. This is only non-empty when parsing a class.",46,N],[12,"capture_names","","A sorted sequence of capture names. This is used to detect duplicate capture names and report an error if one is detected.",46,N],[12,"scratch","","A scratch buffer used in various places. Mostly this is used to accumulate relevant characters from parts of a pattern.",46,N],[3,"ParserI","","ParserI is the internal parser implementation.",N,N],[12,"parser","","The parser state/configuration.",47,N],[12,"pattern","","The full regular expression provided by the user.",47,N],[3,"NestLimiter","","A type that traverses a fully parsed Ast and checks whether its depth exceeds the specified nesting limit. If it does, then an error is returned.",N,N],[12,"p","","The parser that is checking the nest limit.",48,N],[12,"depth","","The current depth while walking an Ast.",48,N],[4,"Primitive","","A primitive is an expression with no sub-expressions. This includes literals, assertions and non-set character classes. This representation is used as intermediate state in the parser.",N,N],[13,"Literal","","",49,N],[13,"Assertion","","",49,N],[13,"Dot","","",49,N],[13,"Perl","","",49,N],[13,"Unicode","","",49,N],[4,"GroupState","","GroupState represents a single stack frame while parsing nested groups and alternations. Each frame records the state up to an opening parenthesis or a alternating bracket `|`.",N,N],[13,"Group","","This state is pushed whenever an opening group is found.",50,N],[12,"concat","regex_syntax::ast::parse::GroupState","The concatenation immediately preceding the opening group.",50,N],[12,"group","","The group that has been opened. Its sub-AST is always empty.",50,N],[12,"ignore_whitespace","","Whether this group has the `x` flag enabled or not.",50,N],[13,"Alternation","regex_syntax::ast::parse","This state is pushed whenever a new alternation branch is found. If an alternation branch is found and this state is at the top of the stack, then this state should be modified to include the new alternation.",50,N],[4,"ClassState","","ClassState represents a single stack frame while parsing character classes. Each frame records the state up to an intersection, difference, symmetric difference or nested class.",N,N],[13,"Open","","This state is pushed whenever an opening bracket is found.",51,N],[12,"union","regex_syntax::ast::parse::ClassState","The union of class items immediately preceding this class.",51,N],[12,"set","","The class that has been opened. Typically this just corresponds to the `[`, but it can also include `[^` since `^` indicates negation of the class.",51,N],[13,"Op","regex_syntax::ast::parse","This state is pushed when a operator is seen. When popped, the stored set becomes the left hand side of the operator.",51,N],[12,"kind","regex_syntax::ast::parse::ClassState","The type of the operation, i.e., &&, -- or ~~.",51,N],[12,"lhs","","The left-hand side of the operator.",51,N],[5,"is_hex","regex_syntax::ast::parse","Returns true if the given character is a hexadecimal digit.",N,[[["char"]],["bool"]]],[5,"is_capture_char","","Returns true if the given character is a valid in a capture group name.",N,[[["char"],["bool"]],["bool"]]],[6,"Result","","",N,N],[11,"clone","","",49,[[["self"]],["primitive"]]],[11,"fmt","","",49,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",49,N],[11,"eq","","",49,[[["self"],["primitive"]],["bool"]]],[11,"ne","","",49,[[["self"],["primitive"]],["bool"]]],[11,"span","","Return the span of this primitive.",49,[[["self"]],["span"]]],[11,"into_ast","","Convert this primitive into a proper AST.",49,[[["self"]],["ast"]]],[11,"into_class_set_item","","Convert this primitive into an item in a character class.",49,[[["self"],["parseri"]],["result",["classsetitem","error"]]]],[11,"into_class_literal","","Convert this primitive into a literal in a character class. In particular, literals are the only valid items that can appear in ranges.",49,[[["self"],["parseri"]],["result",["literal","error"]]]],[11,"clone","","",45,[[["self"]],["parserbuilder"]]],[11,"fmt","","",45,[[["self"],["formatter"]],["result"]]],[11,"default","","",45,[[],["parserbuilder"]]],[11,"new","","Create a new parser builder with a default configuration.",45,[[],["parserbuilder"]]],[11,"build","","Build a parser from this configuration with the given pattern.",45,[[["self"]],["parser"]]],[11,"nest_limit","","Set the nesting limit for this parser.",45,[[["self"],["u32"]],["parserbuilder"]]],[11,"octal","","Whether to support octal syntax or not.",45,[[["self"],["bool"]],["parserbuilder"]]],[11,"ignore_whitespace","","Enable verbose mode in the regular expression.",45,[[["self"],["bool"]],["parserbuilder"]]],[11,"clone","","",46,[[["self"]],["parser"]]],[11,"fmt","","",46,[[["self"],["formatter"]],["result"]]],[11,"clone","","",47,[[["self"]],["parseri"]]],[11,"fmt","","",47,[[["self"],["formatter"]],["result"]]],[11,"clone","","",50,[[["self"]],["groupstate"]]],[11,"fmt","","",50,[[["self"],["formatter"]],["result"]]],[11,"clone","","",51,[[["self"]],["classstate"]]],[11,"fmt","","",51,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new parser with a default configuration.",46,[[],["parser"]]],[11,"parse","","Parse the regular expression into an abstract syntax tree.",46,[[["self"],["str"]],["result",["ast","error"]]]],[11,"parse_with_comments","","Parse the regular expression and return an abstract syntax tree with all of the comments found in the pattern.",46,[[["self"],["str"]],["result",["withcomments","error"]]]],[11,"reset","","Reset the internal state of a parser.",46,[[["self"]]]],[11,"new","","Build an internal parser from a parser configuration and a pattern.",47,[[["p"],["str"]],["parseri"]]],[11,"parser","","Return a reference to the parser state.",47,[[["self"]],["parser"]]],[11,"pattern","","Return a reference to the pattern being parsed.",47,[[["self"]],["str"]]],[11,"error","","Create a new error with the given span and error type.",47,[[["self"],["span"],["errorkind"]],["error"]]],[11,"offset","","Return the current offset of the parser.",47,[[["self"]],["usize"]]],[11,"line","","Return the current line number of the parser.",47,[[["self"]],["usize"]]],[11,"column","","Return the current column of the parser.",47,[[["self"]],["usize"]]],[11,"next_capture_index","","Return the next capturing index. Each subsequent call increments the internal index.",47,[[["self"],["span"]],["result",["u32","error"]]]],[11,"add_capture_name","","Adds the given capture name to this parser. If this capture name has already been used, then an error is returned.",47,[[["self"],["capturename"]],["result",["error"]]]],[11,"ignore_whitespace","","Return whether the parser should ignore whitespace or not.",47,[[["self"]],["bool"]]],[11,"char","","Return the character at the current position of the parser.",47,[[["self"]],["char"]]],[11,"char_at","","Return the character at the given position.",47,[[["self"],["usize"]],["char"]]],[11,"bump","","Bump the parser to the next Unicode scalar value.",47,[[["self"]],["bool"]]],[11,"bump_if","","If the substring starting at the current position of the parser has the given prefix, then bump the parser to the character immediately following the prefix and return true. Otherwise, don't bump the parser and return false.",47,[[["self"],["str"]],["bool"]]],[11,"is_lookaround_prefix","","Returns true if and only if the parser is positioned at a look-around prefix. The conditions under which this returns true must always correspond to a regular expression that would otherwise be consider invalid.",47,[[["self"]],["bool"]]],[11,"bump_and_bump_space","","Bump the parser, and if the `x` flag is enabled, bump through any subsequent spaces. Return true if and only if the parser is not at EOF.",47,[[["self"]],["bool"]]],[11,"bump_space","","If the `x` flag is enabled (i.e., whitespace insensitivity with comments), then this will advance the parser through all whitespace and comments to the next non-whitespace non-comment byte.",47,[[["self"]]]],[11,"peek","","Peek at the next character in the input without advancing the parser.",47,[[["self"]],["option",["char"]]]],[11,"peek_space","","Like peek, but will ignore spaces when the parser is in whitespace insensitive mode.",47,[[["self"]],["option",["char"]]]],[11,"is_eof","","Returns true if the next call to `bump` would return false.",47,[[["self"]],["bool"]]],[11,"pos","","Return the current position of the parser, which includes the offset, line and column.",47,[[["self"]],["position"]]],[11,"span","","Create a span at the current position of the parser. Both the start and end of the span are set.",47,[[["self"]],["span"]]],[11,"span_char","","Create a span that covers the current character.",47,[[["self"]],["span"]]],[11,"push_alternate","","Parse and push a single alternation on to the parser's internal stack. If the top of the stack already has an alternation, then add to that instead of pushing a new one.",47,[[["self"],["concat"]],["result",["concat","error"]]]],[11,"push_or_add_alternation","","Pushes or adds the given branch of an alternation to the parser's internal stack of state.",47,[[["self"],["concat"]]]],[11,"push_group","","Parse and push a group AST (and its parent concatenation) on to the parser's internal stack. Return a fresh concatenation corresponding to the group's sub-AST.",47,[[["self"],["concat"]],["result",["concat","error"]]]],[11,"pop_group","","Pop a group AST from the parser's internal stack and set the group's AST to the given concatenation. Return the concatenation containing the group.",47,[[["self"],["concat"]],["result",["concat","error"]]]],[11,"pop_group_end","","Pop the last state from the parser's internal stack, if it exists, and add the given concatenation to it. There either must be no state or a single alternation item on the stack. Any other scenario produces an error.",47,[[["self"],["concat"]],["result",["ast","error"]]]],[11,"push_class_open","","Parse the opening of a character class and push the current class parsing context onto the parser's stack. This assumes that the parser is positioned at an opening `[`. The given union should correspond to the union of set items built up before seeing the `[`.",47,[[["self"],["classsetunion"]],["result",["classsetunion","error"]]]],[11,"pop_class","","Parse the end of a character class set and pop the character class parser stack. The union given corresponds to the last union built before seeing the closing `]`. The union returned corresponds to the parent character class set with the nested class added to it.",47,[[["self"],["classsetunion"]],["result",["either","error"]]]],[11,"unclosed_class_error","","Return an \"unclosed class\" error whose span points to the most recently opened class.",47,[[["self"]],["error"]]],[11,"push_class_op","","Push the current set of class items on to the class parser's stack as the left hand side of the given operator.",47,[[["self"],["classsetbinaryopkind"],["classsetunion"]],["classsetunion"]]],[11,"pop_class_op","","Pop a character class set from the character class parser stack. If the top of the stack is just an item (not an operation), then return the given set unchanged. If the top of the stack is an operation, then the given set will be used as the rhs of the operation on the top of the stack. In that case, the binary operation is returned as a set.",47,[[["self"],["classset"]],["classset"]]],[11,"parse","","Parse the regular expression into an abstract syntax tree.",47,[[["self"]],["result",["ast","error"]]]],[11,"parse_with_comments","","Parse the regular expression and return an abstract syntax tree with all of the comments found in the pattern.",47,[[["self"]],["result",["withcomments","error"]]]],[11,"parse_uncounted_repetition","","Parses an uncounted repetition operation. An uncounted repetition operator includes ?, * and +, but does not include the {m,n} syntax. The given `kind` should correspond to the operator observed by the caller.",47,[[["self"],["concat"],["repetitionkind"]],["result",["concat","error"]]]],[11,"parse_counted_repetition","","Parses a counted repetition operation. A counted repetition operator corresponds to the {m,n} syntax, and does not include the ?, * or + operators.",47,[[["self"],["concat"]],["result",["concat","error"]]]],[11,"parse_group","","Parse a group (which contains a sub-expression) or a set of flags.",47,[[["self"]],["result",["either","error"]]]],[11,"parse_capture_name","","Parses a capture group name. Assumes that the parser is positioned at the first character in the name following the opening `<` (and may possibly be EOF). This advances the parser to the first character following the closing `>`.",47,[[["self"],["u32"]],["result",["capturename","error"]]]],[11,"parse_flags","","Parse a sequence of flags starting at the current character.",47,[[["self"]],["result",["flags","error"]]]],[11,"parse_flag","","Parse the current character as a flag. Do not advance the parser.",47,[[["self"]],["result",["flag","error"]]]],[11,"parse_primitive","","Parse a primitive AST. e.g., A literal, non-set character class or assertion.",47,[[["self"]],["result",["primitive","error"]]]],[11,"parse_escape","","Parse an escape sequence as a primitive AST.",47,[[["self"]],["result",["primitive","error"]]]],[11,"parse_octal","","Parse an octal representation of a Unicode codepoint up to 3 digits long. This expects the parser to be positioned at the first octal digit and advances the parser to the first character immediately following the octal number. This also assumes that parsing octal escapes is enabled.",47,[[["self"]],["literal"]]],[11,"parse_hex","","Parse a hex representation of a Unicode codepoint. This handles both hex notations, i.e., `\\xFF` and `\\x{FFFF}`. This expects the parser to be positioned at the `x`, `u` or `U` prefix. The parser is advanced to the first character immediately following the hexadecimal literal.",47,[[["self"]],["result",["literal","error"]]]],[11,"parse_hex_digits","","Parse an N-digit hex representation of a Unicode codepoint. This expects the parser to be positioned at the first digit and will advance the parser to the first character immediately following the escape sequence.",47,[[["self"],["hexliteralkind"]],["result",["literal","error"]]]],[11,"parse_hex_brace","","Parse a hex representation of any Unicode scalar value. This expects the parser to be positioned at the opening brace `{` and will advance the parser to the first character following the closing brace `}`.",47,[[["self"],["hexliteralkind"]],["result",["literal","error"]]]],[11,"parse_decimal","","Parse a decimal number into a u32 while trimming leading and trailing whitespace.",47,[[["self"]],["result",["u32","error"]]]],[11,"parse_set_class","","Parse a standard character class consisting primarily of characters or character ranges, but can also contain nested character classes of any type (sans `.`).",47,[[["self"]],["result",["class","error"]]]],[11,"parse_set_class_range","","Parse a single primitive item in a character class set. The item to be parsed can either be one of a simple literal character, a range between two simple literal characters or a \"primitive\" character class like \\w or \\p{Greek}.",47,[[["self"]],["result",["classsetitem","error"]]]],[11,"parse_set_class_item","","Parse a single item in a character class as a primitive, where the primitive either consists of a verbatim literal or a single escape sequence.",47,[[["self"]],["result",["primitive","error"]]]],[11,"parse_set_class_open","","Parses the opening of a character class set. This includes the opening bracket along with `^` if present to indicate negation. This also starts parsing the opening set of unioned items if applicable, since there are special rules applied to certain characters in the opening of a character class. For example, `[^]]` is the class of all characters not equal to `]`. (`]` would need to be escaped in any other position.) Similarly for `-`.",47,[[["self"]],["result",["error"]]]],[11,"maybe_parse_ascii_class","","Attempt to parse an ASCII character class, e.g., `[:alnum:]`.",47,[[["self"]],["option",["classascii"]]]],[11,"parse_unicode_class","","Parse a Unicode class in either the single character notation, `\\pN` or the multi-character bracketed notation, `\\p{Greek}`. This assumes the parser is positioned at the `p` (or `P` for negation) and will advance the parser to the character immediately following the class.",47,[[["self"]],["result",["classunicode","error"]]]],[11,"parse_perl_class","","Parse a Perl character class, e.g., `\\d` or `\\W`. This assumes the parser is currently at a valid character class name and will be advanced to the character immediately following the class.",47,[[["self"]],["classperl"]]],[11,"fmt","","",48,[[["self"],["formatter"]],["result"]]],[11,"new","","",48,[[["parseri"]],["nestlimiter"]]],[11,"check","","",48,[[["self"],["ast"]],["result",["error"]]]],[11,"increment_depth","","",48,[[["self"],["span"]],["result",["error"]]]],[11,"decrement_depth","","",48,[[["self"]]]],[11,"finish","","",48,[[["self"]],["result",["error"]]]],[11,"visit_pre","","",48,[[["self"],["ast"]],["result",["error"]]]],[11,"visit_post","","",48,[[["self"],["ast"]],["result",["error"]]]],[11,"visit_class_set_item_pre","","",48,[[["self"],["classsetitem"]],["result",["error"]]]],[11,"visit_class_set_item_post","","",48,[[["self"],["classsetitem"]],["result",["error"]]]],[11,"visit_class_set_binary_op_pre","","",48,[[["self"],["classsetbinaryop"]],["result",["error"]]]],[11,"visit_class_set_binary_op_post","","",48,[[["self"],["classsetbinaryop"]],["result",["error"]]]],[0,"print","regex_syntax::ast","This module provides a regular expression printer for `Ast`.",N,N],[3,"PrinterBuilder","regex_syntax::ast::print","A builder for constructing a printer.",N,N],[12,"_priv","","",52,N],[3,"Printer","","A printer for a regular expression abstract syntax tree.",N,N],[12,"_priv","","",53,N],[3,"Writer","","",N,N],[12,"printer","","",54,N],[12,"wtr","","",54,N],[11,"clone","","",52,[[["self"]],["printerbuilder"]]],[11,"fmt","","",52,[[["self"],["formatter"]],["result"]]],[11,"default","","",52,[[],["printerbuilder"]]],[11,"new","","",52,[[],["printerbuilder"]]],[11,"build","","",52,[[["self"]],["printer"]]],[11,"fmt","","",53,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new printer.",53,[[],["printer"]]],[11,"print","","Print the given `Ast` to the given writer. The writer must implement `fmt::Write`. Typical implementations of `fmt::Write` that can be used here are a `fmt::Formatter` (which is available in `fmt::Display` implementations) or a `&mut String`.",53,[[["self"],["ast"],["w"]],["result"]]],[11,"fmt","","",54,[[["self"],["formatter"]],["result"]]],[11,"finish","","",54,[[["self"]],["result"]]],[11,"visit_pre","","",54,[[["self"],["ast"]],["result"]]],[11,"visit_post","","",54,[[["self"],["ast"]],["result"]]],[11,"visit_alternation_in","","",54,[[["self"]],["result"]]],[11,"visit_class_set_item_pre","","",54,[[["self"],["classsetitem"]],["result"]]],[11,"visit_class_set_item_post","","",54,[[["self"],["classsetitem"]],["result"]]],[11,"visit_class_set_binary_op_in","","",54,[[["self"],["classsetbinaryop"]],["result"]]],[11,"fmt_group_pre","","",54,[[["self"],["group"]],["result"]]],[11,"fmt_group_post","","",54,[[["self"],["group"]],["result"]]],[11,"fmt_repetition","","",54,[[["self"],["repetition"]],["result"]]],[11,"fmt_repetition_range","","",54,[[["self"],["repetitionrange"]],["result"]]],[11,"fmt_literal","","",54,[[["self"],["literal"]],["result"]]],[11,"fmt_assertion","","",54,[[["self"],["assertion"]],["result"]]],[11,"fmt_set_flags","","",54,[[["self"],["setflags"]],["result"]]],[11,"fmt_flags","","",54,[[["self"],["flags"]],["result"]]],[11,"fmt_class_bracketed_pre","","",54,[[["self"],["classbracketed"]],["result"]]],[11,"fmt_class_bracketed_post","","",54,[[["self"],["classbracketed"]],["result"]]],[11,"fmt_class_set_binary_op_kind","","",54,[[["self"],["classsetbinaryopkind"]],["result"]]],[11,"fmt_class_perl","","",54,[[["self"],["classperl"]],["result"]]],[11,"fmt_class_ascii","","",54,[[["self"],["classascii"]],["result"]]],[11,"fmt_class_unicode","","",54,[[["self"],["classunicode"]],["result"]]],[0,"visitor","regex_syntax::ast","",N,N],[3,"HeapVisitor","regex_syntax::ast::visitor","HeapVisitor visits every item in an `Ast` recursively using constant stack size and a heap size proportional to the size of the `Ast`.",N,N],[12,"stack","","A stack of `Ast` nodes. This is roughly analogous to the call stack used in a typical recursive visitor.",55,N],[12,"stack_class","","Similar to the `Ast` stack above, but is used only for character classes. In particular, character classes embed their own mini recursive syntax.",55,N],[4,"Frame","","Represents a single stack frame while performing structural induction over an `Ast`.",N,N],[13,"Repetition","","A stack frame allocated just before descending into a repetition operator's child node.",56,N],[13,"Group","","A stack frame allocated just before descending into a group's child node.",56,N],[13,"Concat","","The stack frame used while visiting every child node of a concatenation of expressions.",56,N],[12,"head","regex_syntax::ast::visitor::Frame","The child node we are currently visiting.",56,N],[12,"tail","","The remaining child nodes to visit (which may be empty).",56,N],[13,"Alternation","regex_syntax::ast::visitor","The stack frame used while visiting every child node of an alternation of expressions.",56,N],[12,"head","regex_syntax::ast::visitor::Frame","The child node we are currently visiting.",56,N],[12,"tail","","The remaining child nodes to visit (which may be empty).",56,N],[4,"ClassFrame","regex_syntax::ast::visitor","Represents a single stack frame while performing structural induction over a character class.",N,N],[13,"Union","","The stack frame used while visiting every child node of a union of character class items.",57,N],[12,"head","regex_syntax::ast::visitor::ClassFrame","The child node we are currently visiting.",57,N],[12,"tail","","The remaining child nodes to visit (which may be empty).",57,N],[13,"Binary","regex_syntax::ast::visitor","The stack frame used while a binary class operation.",57,N],[12,"op","regex_syntax::ast::visitor::ClassFrame","",57,N],[13,"BinaryLHS","regex_syntax::ast::visitor","A stack frame allocated just before descending into a binary operator's left hand child node.",57,N],[12,"op","regex_syntax::ast::visitor::ClassFrame","",57,N],[12,"lhs","","",57,N],[12,"rhs","","",57,N],[13,"BinaryRHS","regex_syntax::ast::visitor","A stack frame allocated just before descending into a binary operator's right hand child node.",57,N],[12,"op","regex_syntax::ast::visitor::ClassFrame","",57,N],[12,"rhs","","",57,N],[4,"ClassInduct","regex_syntax::ast::visitor","A representation of the inductive step when performing structural induction over a character class.",N,N],[13,"Item","","",58,N],[13,"BinaryOp","","",58,N],[5,"visit","","Executes an implementation of `Visitor` in constant stack space.",N,[[["ast"],["v"]],["result"]]],[8,"Visitor","","A trait for visiting an abstract syntax tree (AST) in depth first order.",N,N],[16,"Output","","The result of visiting an AST.",59,N],[16,"Err","","An error that visiting an AST might return.",59,N],[10,"finish","","All implementors of `Visitor` must provide a `finish` method, which yields the result of visiting the AST or an error.",59,[[["self"]],["result"]]],[11,"start","","This method is called before beginning traversal of the AST.",59,[[["self"]]]],[11,"visit_pre","","This method is called on an `Ast` before descending into child `Ast` nodes.",59,[[["self"],["ast"]],["result"]]],[11,"visit_post","","This method is called on an `Ast` after descending all of its child `Ast` nodes.",59,[[["self"],["ast"]],["result"]]],[11,"visit_alternation_in","","This method is called between child nodes of an `Alternation`.",59,[[["self"]],["result"]]],[11,"visit_class_set_item_pre","","This method is called on every `ClassSetItem` before descending into child nodes.",59,[[["self"],["classsetitem"]],["result"]]],[11,"visit_class_set_item_post","","This method is called on every `ClassSetItem` after descending into child nodes.",59,[[["self"],["classsetitem"]],["result"]]],[11,"visit_class_set_binary_op_pre","","This method is called on every `ClassSetBinaryOp` before descending into child nodes.",59,[[["self"],["classsetbinaryop"]],["result"]]],[11,"visit_class_set_binary_op_post","","This method is called on every `ClassSetBinaryOp` after descending into child nodes.",59,[[["self"],["classsetbinaryop"]],["result"]]],[11,"visit_class_set_binary_op_in","","This method is called between the left hand and right hand child nodes of a `ClassSetBinaryOp`.",59,[[["self"],["classsetbinaryop"]],["result"]]],[11,"new","","",55,[[],["heapvisitor"]]],[11,"visit","","",55,[[["self"],["ast"],["v"]],["result"]]],[11,"induct","","Build a stack frame for the given AST if one is needed (which occurs if and only if there are child nodes in the AST). Otherwise, return None.",55,[[["self"],["ast"],["v"]],["result",["option"]]]],[11,"pop","","Pops the given frame. If the frame has an additional inductive step, then return it, otherwise return `None`.",55,[[["self"],["frame"]],["option",["frame"]]]],[11,"visit_class","","",55,[[["self"],["classbracketed"],["v"]],["result"]]],[11,"visit_class_pre","","Call the appropriate `Visitor` methods given an inductive step.",55,[[["self"],["classinduct"],["v"]],["result"]]],[11,"visit_class_post","","Call the appropriate `Visitor` methods given an inductive step.",55,[[["self"],["classinduct"],["v"]],["result"]]],[11,"induct_class","","Build a stack frame for the given class node if one is needed (which occurs if and only if there are child nodes). Otherwise, return None.",55,[[["self"],["classinduct"]],["option",["classframe"]]]],[11,"pop_class","","Pops the given frame. If the frame has an additional inductive step, then return it, otherwise return `None`.",55,[[["self"],["classframe"]],["option",["classframe"]]]],[11,"child","","Perform the next inductive step on this frame and return the next child AST node to visit.",56,[[["self"]],["ast"]]],[11,"child","","Perform the next inductive step on this frame and return the next child class node to visit.",57,[[["self"]],["classinduct"]]],[11,"from_bracketed","","",58,[[["classbracketed"]],["classinduct"]]],[11,"from_set","","",58,[[["classset"]],["classinduct"]]],[11,"fmt","","",57,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",58,[[["self"],["formatter"]],["result"]]],[8,"Visitor","regex_syntax::ast","A trait for visiting an abstract syntax tree (AST) in depth first order.",N,N],[16,"Output","","The result of visiting an AST.",59,N],[16,"Err","","An error that visiting an AST might return.",59,N],[10,"finish","","All implementors of `Visitor` must provide a `finish` method, which yields the result of visiting the AST or an error.",59,[[["self"]],["result"]]],[11,"start","regex_syntax::ast::visitor","This method is called before beginning traversal of the AST.",59,[[["self"]]]],[11,"visit_pre","","This method is called on an `Ast` before descending into child `Ast` nodes.",59,[[["self"],["ast"]],["result"]]],[11,"visit_post","","This method is called on an `Ast` after descending all of its child `Ast` nodes.",59,[[["self"],["ast"]],["result"]]],[11,"visit_alternation_in","","This method is called between child nodes of an `Alternation`.",59,[[["self"]],["result"]]],[11,"visit_class_set_item_pre","","This method is called on every `ClassSetItem` before descending into child nodes.",59,[[["self"],["classsetitem"]],["result"]]],[11,"visit_class_set_item_post","","This method is called on every `ClassSetItem` after descending into child nodes.",59,[[["self"],["classsetitem"]],["result"]]],[11,"visit_class_set_binary_op_pre","","This method is called on every `ClassSetBinaryOp` before descending into child nodes.",59,[[["self"],["classsetbinaryop"]],["result"]]],[11,"visit_class_set_binary_op_post","","This method is called on every `ClassSetBinaryOp` after descending into child nodes.",59,[[["self"],["classsetbinaryop"]],["result"]]],[11,"visit_class_set_binary_op_in","","This method is called between the left hand and right hand child nodes of a `ClassSetBinaryOp`.",59,[[["self"],["classsetbinaryop"]],["result"]]],[11,"clone","regex_syntax::ast","",3,[[["self"]],["error"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",3,N],[11,"eq","","",3,[[["self"],["error"]],["bool"]]],[11,"ne","","",3,[[["self"],["error"]],["bool"]]],[11,"kind","","Return the type of this error.",3,[[["self"]],["errorkind"]]],[11,"pattern","","The original pattern string in which this error occurred.",3,[[["self"]],["str"]]],[11,"span","","Return the span at which this error occurred.",3,[[["self"]],["span"]]],[11,"auxiliary_span","","Return an auxiliary span. This span exists only for some errors that benefit from being able to point to two locations in the original regular expression. For example, \"duplicate\" errors will have the main error position set to the duplicate occurrence while its auxiliary span will be set to the initial occurrence.",3,[[["self"]],["option",["span"]]]],[11,"clone","","",26,[[["self"]],["errorkind"]]],[11,"fmt","","",26,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",26,N],[11,"eq","","",26,[[["self"],["errorkind"]],["bool"]]],[11,"ne","","",26,[[["self"],["errorkind"]],["bool"]]],[11,"description","","",3,[[["self"]],["str"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",26,[[["self"],["formatter"]],["result"]]],[11,"clone","","",4,[[["self"]],["span"]]],[11,"assert_receiver_is_total_eq","","",4,N],[11,"eq","","",4,[[["self"],["span"]],["bool"]]],[11,"ne","","",4,[[["self"],["span"]],["bool"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"cmp","","",4,[[["self"],["span"]],["ordering"]]],[11,"partial_cmp","","",4,[[["self"],["span"]],["option",["ordering"]]]],[11,"clone","","",5,[[["self"]],["position"]]],[11,"assert_receiver_is_total_eq","","",5,N],[11,"eq","","",5,[[["self"],["position"]],["bool"]]],[11,"ne","","",5,[[["self"],["position"]],["bool"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"cmp","","",5,[[["self"],["position"]],["ordering"]]],[11,"partial_cmp","","",5,[[["self"],["position"]],["option",["ordering"]]]],[11,"new","","Create a new span with the given positions.",4,[[["position"],["position"]],["span"]]],[11,"splat","","Create a new span using the given position as the start and end.",4,[[["position"]],["span"]]],[11,"with_start","","Create a new span by replacing the starting the position with the one given.",4,[[["self"],["position"]],["span"]]],[11,"with_end","","Create a new span by replacing the ending the position with the one given.",4,[[["self"],["position"]],["span"]]],[11,"is_one_line","","Returns true if and only if this span occurs on a single line.",4,[[["self"]],["bool"]]],[11,"is_empty","","Returns true if and only if this span is empty. That is, it points to a single position in the concrete syntax of a regular expression.",4,[[["self"]],["bool"]]],[11,"new","","Create a new position with the given information.",5,[[["usize"],["usize"],["usize"]],["position"]]],[11,"clone","","",6,[[["self"]],["withcomments"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",6,N],[11,"eq","","",6,[[["self"],["withcomments"]],["bool"]]],[11,"ne","","",6,[[["self"],["withcomments"]],["bool"]]],[11,"clone","","",7,[[["self"]],["comment"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",7,N],[11,"eq","","",7,[[["self"],["comment"]],["bool"]]],[11,"ne","","",7,[[["self"],["comment"]],["bool"]]],[11,"clone","","",27,[[["self"]],["ast"]]],[11,"fmt","","",27,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",27,N],[11,"eq","","",27,[[["self"],["ast"]],["bool"]]],[11,"ne","","",27,[[["self"],["ast"]],["bool"]]],[11,"span","","Return the span of this abstract syntax tree.",27,[[["self"]],["span"]]],[11,"is_empty","","Return true if and only if this Ast is empty.",27,[[["self"]],["bool"]]],[11,"has_subexprs","","Returns true if and only if this AST has any (including possibly empty) subexpressions.",27,[[["self"]],["bool"]]],[11,"fmt","","",27,[[["self"],["formatter"]],["result"]]],[11,"clone","","",8,[[["self"]],["alternation"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",8,N],[11,"eq","","",8,[[["self"],["alternation"]],["bool"]]],[11,"ne","","",8,[[["self"],["alternation"]],["bool"]]],[11,"into_ast","","Return this alternation as an AST.",8,[[["self"]],["ast"]]],[11,"clone","","",9,[[["self"]],["concat"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",9,N],[11,"eq","","",9,[[["self"],["concat"]],["bool"]]],[11,"ne","","",9,[[["self"],["concat"]],["bool"]]],[11,"into_ast","","Return this concatenation as an AST.",9,[[["self"]],["ast"]]],[11,"clone","","",10,[[["self"]],["literal"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",10,N],[11,"eq","","",10,[[["self"],["literal"]],["bool"]]],[11,"ne","","",10,[[["self"],["literal"]],["bool"]]],[11,"byte","","If this literal was written as a `\\x` hex escape, then this returns the corresponding byte value. Otherwise, this returns `None`.",10,[[["self"]],["option",["u8"]]]],[11,"clone","","",28,[[["self"]],["literalkind"]]],[11,"fmt","","",28,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",28,N],[11,"eq","","",28,[[["self"],["literalkind"]],["bool"]]],[11,"ne","","",28,[[["self"],["literalkind"]],["bool"]]],[11,"clone","","",29,[[["self"]],["specialliteralkind"]]],[11,"fmt","","",29,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",29,N],[11,"eq","","",29,[[["self"],["specialliteralkind"]],["bool"]]],[11,"clone","","",30,[[["self"]],["hexliteralkind"]]],[11,"fmt","","",30,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",30,N],[11,"eq","","",30,[[["self"],["hexliteralkind"]],["bool"]]],[11,"digits","","The number of digits that must be used with this literal form when used without brackets. When used with brackets, there is no restriction on the number of digits.",30,[[["self"]],["u32"]]],[11,"clone","","",31,[[["self"]],["class"]]],[11,"fmt","","",31,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",31,N],[11,"eq","","",31,[[["self"],["class"]],["bool"]]],[11,"ne","","",31,[[["self"],["class"]],["bool"]]],[11,"span","","Return the span of this character class.",31,[[["self"]],["span"]]],[11,"clone","","",11,[[["self"]],["classperl"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",11,N],[11,"eq","","",11,[[["self"],["classperl"]],["bool"]]],[11,"ne","","",11,[[["self"],["classperl"]],["bool"]]],[11,"clone","","",32,[[["self"]],["classperlkind"]]],[11,"fmt","","",32,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",32,N],[11,"eq","","",32,[[["self"],["classperlkind"]],["bool"]]],[11,"clone","","",12,[[["self"]],["classascii"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",12,N],[11,"eq","","",12,[[["self"],["classascii"]],["bool"]]],[11,"ne","","",12,[[["self"],["classascii"]],["bool"]]],[11,"clone","","",33,[[["self"]],["classasciikind"]]],[11,"fmt","","",33,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",33,N],[11,"eq","","",33,[[["self"],["classasciikind"]],["bool"]]],[11,"from_name","","Return the corresponding ClassAsciiKind variant for the given name.",33,[[["str"]],["option",["classasciikind"]]]],[11,"clone","","",13,[[["self"]],["classunicode"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",13,N],[11,"eq","","",13,[[["self"],["classunicode"]],["bool"]]],[11,"ne","","",13,[[["self"],["classunicode"]],["bool"]]],[11,"is_negated","","Returns true if this class has been negated.",13,[[["self"]],["bool"]]],[11,"clone","","",34,[[["self"]],["classunicodekind"]]],[11,"fmt","","",34,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",34,N],[11,"eq","","",34,[[["self"],["classunicodekind"]],["bool"]]],[11,"ne","","",34,[[["self"],["classunicodekind"]],["bool"]]],[11,"clone","","",35,[[["self"]],["classunicodeopkind"]]],[11,"fmt","","",35,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",35,N],[11,"eq","","",35,[[["self"],["classunicodeopkind"]],["bool"]]],[11,"is_equal","","Whether the op is an equality op or not.",35,[[["self"]],["bool"]]],[11,"clone","","",14,[[["self"]],["classbracketed"]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",14,N],[11,"eq","","",14,[[["self"],["classbracketed"]],["bool"]]],[11,"ne","","",14,[[["self"],["classbracketed"]],["bool"]]],[11,"clone","","",36,[[["self"]],["classset"]]],[11,"fmt","","",36,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",36,N],[11,"eq","","",36,[[["self"],["classset"]],["bool"]]],[11,"ne","","",36,[[["self"],["classset"]],["bool"]]],[11,"union","","Build a set from a union.",36,[[["classsetunion"]],["classset"]]],[11,"span","","Return the span of this character class set.",36,[[["self"]],["span"]]],[11,"is_empty","","Return true if and only if this class set is empty.",36,[[["self"]],["bool"]]],[11,"clone","","",37,[[["self"]],["classsetitem"]]],[11,"fmt","","",37,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",37,N],[11,"eq","","",37,[[["self"],["classsetitem"]],["bool"]]],[11,"ne","","",37,[[["self"],["classsetitem"]],["bool"]]],[11,"span","","Return the span of this character class set item.",37,[[["self"]],["span"]]],[11,"clone","","",15,[[["self"]],["classsetrange"]]],[11,"fmt","","",15,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",15,N],[11,"eq","","",15,[[["self"],["classsetrange"]],["bool"]]],[11,"ne","","",15,[[["self"],["classsetrange"]],["bool"]]],[11,"is_valid","","Returns true if and only if this character class range is valid.",15,[[["self"]],["bool"]]],[11,"clone","","",16,[[["self"]],["classsetunion"]]],[11,"fmt","","",16,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",16,N],[11,"eq","","",16,[[["self"],["classsetunion"]],["bool"]]],[11,"ne","","",16,[[["self"],["classsetunion"]],["bool"]]],[11,"push","","Push a new item in this union.",16,[[["self"],["classsetitem"]]]],[11,"into_item","","Return this union as a character class set item.",16,[[["self"]],["classsetitem"]]],[11,"clone","","",17,[[["self"]],["classsetbinaryop"]]],[11,"fmt","","",17,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",17,N],[11,"eq","","",17,[[["self"],["classsetbinaryop"]],["bool"]]],[11,"ne","","",17,[[["self"],["classsetbinaryop"]],["bool"]]],[11,"clone","","",38,[[["self"]],["classsetbinaryopkind"]]],[11,"fmt","","",38,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",38,N],[11,"eq","","",38,[[["self"],["classsetbinaryopkind"]],["bool"]]],[11,"clone","","",18,[[["self"]],["assertion"]]],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",18,N],[11,"eq","","",18,[[["self"],["assertion"]],["bool"]]],[11,"ne","","",18,[[["self"],["assertion"]],["bool"]]],[11,"clone","","",39,[[["self"]],["assertionkind"]]],[11,"fmt","","",39,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",39,N],[11,"eq","","",39,[[["self"],["assertionkind"]],["bool"]]],[11,"clone","","",19,[[["self"]],["repetition"]]],[11,"fmt","","",19,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",19,N],[11,"eq","","",19,[[["self"],["repetition"]],["bool"]]],[11,"ne","","",19,[[["self"],["repetition"]],["bool"]]],[11,"clone","","",20,[[["self"]],["repetitionop"]]],[11,"fmt","","",20,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",20,N],[11,"eq","","",20,[[["self"],["repetitionop"]],["bool"]]],[11,"ne","","",20,[[["self"],["repetitionop"]],["bool"]]],[11,"clone","","",40,[[["self"]],["repetitionkind"]]],[11,"fmt","","",40,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",40,N],[11,"eq","","",40,[[["self"],["repetitionkind"]],["bool"]]],[11,"ne","","",40,[[["self"],["repetitionkind"]],["bool"]]],[11,"clone","","",41,[[["self"]],["repetitionrange"]]],[11,"fmt","","",41,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",41,N],[11,"eq","","",41,[[["self"],["repetitionrange"]],["bool"]]],[11,"ne","","",41,[[["self"],["repetitionrange"]],["bool"]]],[11,"is_valid","","Returns true if and only if this repetition range is valid.",41,[[["self"]],["bool"]]],[11,"clone","","",21,[[["self"]],["group"]]],[11,"fmt","","",21,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",21,N],[11,"eq","","",21,[[["self"],["group"]],["bool"]]],[11,"ne","","",21,[[["self"],["group"]],["bool"]]],[11,"flags","","If this group is non-capturing, then this returns the (possibly empty) set of flags. Otherwise, `None` is returned.",21,[[["self"]],["option",["flags"]]]],[11,"is_capturing","","Returns true if and only if this group is capturing.",21,[[["self"]],["bool"]]],[11,"capture_index","","Returns the capture index of this group, if this is a capturing group.",21,[[["self"]],["option",["u32"]]]],[11,"clone","","",42,[[["self"]],["groupkind"]]],[11,"fmt","","",42,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",42,N],[11,"eq","","",42,[[["self"],["groupkind"]],["bool"]]],[11,"ne","","",42,[[["self"],["groupkind"]],["bool"]]],[11,"clone","","",22,[[["self"]],["capturename"]]],[11,"fmt","","",22,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",22,N],[11,"eq","","",22,[[["self"],["capturename"]],["bool"]]],[11,"ne","","",22,[[["self"],["capturename"]],["bool"]]],[11,"clone","","",23,[[["self"]],["setflags"]]],[11,"fmt","","",23,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",23,N],[11,"eq","","",23,[[["self"],["setflags"]],["bool"]]],[11,"ne","","",23,[[["self"],["setflags"]],["bool"]]],[11,"clone","","",24,[[["self"]],["flags"]]],[11,"fmt","","",24,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",24,N],[11,"eq","","",24,[[["self"],["flags"]],["bool"]]],[11,"ne","","",24,[[["self"],["flags"]],["bool"]]],[11,"add_item","","Add the given item to this sequence of flags.",24,[[["self"],["flagsitem"]],["option",["usize"]]]],[11,"flag_state","","Returns the state of the given flag in this set.",24,[[["self"],["flag"]],["option",["bool"]]]],[11,"clone","","",25,[[["self"]],["flagsitem"]]],[11,"fmt","","",25,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",25,N],[11,"eq","","",25,[[["self"],["flagsitem"]],["bool"]]],[11,"ne","","",25,[[["self"],["flagsitem"]],["bool"]]],[11,"clone","","",43,[[["self"]],["flagsitemkind"]]],[11,"fmt","","",43,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",43,N],[11,"eq","","",43,[[["self"],["flagsitemkind"]],["bool"]]],[11,"ne","","",43,[[["self"],["flagsitemkind"]],["bool"]]],[11,"is_negation","","Returns true if and only if this item is a negation operator.",43,[[["self"]],["bool"]]],[11,"clone","","",44,[[["self"]],["flag"]]],[11,"fmt","","",44,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",44,N],[11,"eq","","",44,[[["self"],["flag"]],["bool"]]],[11,"drop","","",27,[[["self"]]]],[11,"drop","","",36,[[["self"]]]],[0,"either","regex_syntax","",N,N],[4,"Either","regex_syntax::either","A simple binary sum type.",N,N],[13,"Left","","",60,N],[13,"Right","","",60,N],[11,"clone","","",60,[[["self"]],["either"]]],[11,"fmt","","",60,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",60,N],[11,"eq","","",60,[[["self"],["either"]],["bool"]]],[11,"ne","","",60,[[["self"],["either"]],["bool"]]],[0,"error","regex_syntax","",N,N],[3,"Formatter","regex_syntax::error","A helper type for formatting nice error messages.",N,N],[12,"pattern","","The original regex pattern in which the error occurred.",61,N],[12,"err","","The error kind. It must impl fmt::Display.",61,N],[12,"span","","The primary span of the error.",61,N],[12,"aux_span","","An auxiliary and optional span, in case the error needs to point to two locations (e.g., when reporting a duplicate capture group name).",61,N],[3,"Spans","","This type represents an arbitrary number of error spans in a way that makes it convenient to notate the regex pattern. (\"Notate\" means \"point out exactly where the error occurred in the regex pattern.\")",N,N],[12,"pattern","","The original regex pattern string.",62,N],[12,"line_number_width","","The total width that should be used for line numbers. The width is used for left padding the line numbers for alignment.",62,N],[12,"by_line","","All error spans that occur on a single line. This sequence always has length equivalent to the number of lines in `pattern`, where the index of the sequence represents a line number, starting at `0`. The spans in each line are sorted in ascending order.",62,N],[12,"multi_line","","All error spans that occur over one or more lines. That is, the start and end position of the span have different line numbers. The spans are sorted in ascending order.",62,N],[4,"Error","","This error type encompasses any error that can be returned by this crate.",N,N],[13,"Parse","","An error that occurred while translating concrete syntax into abstract syntax (AST).",2,N],[13,"Translate","","An error that occurred while translating abstract syntax into a high level intermediate representation (HIR).",2,N],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",2,N],[5,"repeat_char","","",N,[[["char"],["usize"]],["string"]]],[6,"Result","","A type alias for dealing with errors returned by this crate.",N,N],[11,"clone","regex_syntax","",2,[[["self"]],["error"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",2,N],[11,"eq","","",2,[[["self"],["error"]],["bool"]]],[11,"ne","","",2,[[["self"],["error"]],["bool"]]],[11,"from","","",2,[[["error"]],["error"]]],[11,"from","","",2,[[["error"]],["error"]]],[11,"description","","",2,[[["self"]],["str"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"fmt","regex_syntax::error","",61,[[["self"],["formatter"]],["result"]]],[11,"from","","",61,[[["error"]],["self"]]],[11,"from","","",61,[[["error"]],["self"]]],[11,"fmt","","",61,[[["self"],["formatter"]],["result"]]],[11,"from_formatter","","Build a sequence of spans from a formatter.",62,[[["formatter"]],["spans"]]],[11,"add","","Add the given span to this sequence, putting it in the right place.",62,[[["self"],["span"]]]],[11,"notate","","Notate the pattern string with carents (`^`) pointing at each span location. This only applies to spans that occur within a single line.",62,[[["self"]],["string"]]],[11,"notate_line","","Return notes for the line indexed at `i` (zero-based). If there are no spans for the given line, then `None` is returned. Otherwise, an appropriately space padded string with correctly positioned `^` is returned, accounting for line numbers.",62,[[["self"],["usize"]],["option",["string"]]]],[11,"left_pad_line_number","","Left pad the given line number with spaces such that it is aligned with other line numbers.",62,[[["self"],["usize"]],["string"]]],[11,"line_number_padding","","Return the line number padding beginning at the start of each line of the pattern.",62,[[["self"]],["usize"]]],[0,"hir","regex_syntax","Defines a high-level intermediate representation for regular expressions.",N,N],[3,"Error","regex_syntax::hir","An error that can occur while translating an `Ast` to a `Hir`.",N,N],[12,"kind","","The kind of error.",63,N],[12,"pattern","","The original pattern that the translator's Ast was parsed from. Every span in an error is a valid range into this string.",63,N],[12,"span","","The span of this error, derived from the Ast given to the translator.",63,N],[3,"Hir","","A high-level intermediate representation (HIR) for a regular expression.",N,N],[12,"kind","","The underlying HIR kind.",64,N],[12,"info","","Analysis info about this HIR, computed during construction.",64,N],[3,"ClassUnicode","","A set of characters represented by Unicode scalar values.",N,N],[12,"set","","",65,N],[3,"ClassUnicodeIter","","An iterator over all ranges in a Unicode character class.",N,N],[12,"0","","",66,N],[3,"ClassUnicodeRange","","A single range of characters represented by Unicode scalar values.",N,N],[12,"start","","",67,N],[12,"end","","",67,N],[3,"ClassBytes","","A set of characters represented by arbitrary bytes (where one byte corresponds to one character).",N,N],[12,"set","","",68,N],[3,"ClassBytesIter","","An iterator over all ranges in a byte character class.",N,N],[12,"0","","",69,N],[3,"ClassBytesRange","","A single range of characters represented by arbitrary bytes.",N,N],[12,"start","","",70,N],[12,"end","","",70,N],[3,"Group","","The high-level intermediate representation for a group.",N,N],[12,"kind","","The kind of this group. If it is a capturing group, then the kind contains the capture group index (and the name, if it is a named group).",71,N],[12,"hir","","The expression inside the capturing group, which may be empty.",71,N],[3,"Repetition","","The high-level intermediate representation of a repetition operator.",N,N],[12,"kind","","The kind of this repetition operator.",72,N],[12,"greedy","","Whether this repetition operator is greedy or not. A greedy operator will match as much as it can. A non-greedy operator will match as little as it can.",72,N],[12,"hir","","The expression being repeated.",72,N],[3,"HirInfo","","A type that documents various attributes of an HIR expression.",N,N],[12,"bools","","Represent yes/no questions by a bitfield to conserve space, since this is included in every HIR expression.",73,N],[4,"ErrorKind","","The type of an error that occurred while building an `Hir`.",N,N],[13,"UnicodeNotAllowed","","This error occurs when a Unicode feature is used when Unicode support is disabled. For example `(?-u:\\pL)` would trigger this error.",74,N],[13,"InvalidUtf8","","This error occurs when translating a pattern that could match a byte sequence that isn't UTF-8 and `allow_invalid_utf8` was disabled.",74,N],[13,"UnicodePropertyNotFound","","This occurs when an unrecognized Unicode property name could not be found.",74,N],[13,"UnicodePropertyValueNotFound","","This occurs when an unrecognized Unicode property value could not be found.",74,N],[13,"EmptyClassNotAllowed","","This occurs when the translator attempts to construct a character class that is empty.",74,N],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",74,N],[4,"HirKind","","The kind of an arbitrary `Hir` expression.",N,N],[13,"Empty","","The empty regular expression, which matches everything, including the empty string.",75,N],[13,"Literal","","A single literal character that matches exactly this character.",75,N],[13,"Class","","A single character class that matches any of the characters in the class. A class can either consist of Unicode scalar values as characters, or it can use bytes.",75,N],[13,"Anchor","","An anchor assertion. An anchor assertion match always has zero length.",75,N],[13,"WordBoundary","","A word boundary assertion, which may or may not be Unicode aware. A word boundary assertion match always has zero length.",75,N],[13,"Repetition","","A repetition operation applied to a child expression.",75,N],[13,"Group","","A possibly capturing group, which contains a child expression.",75,N],[13,"Concat","","A concatenation of expressions. A concatenation always has at least two child expressions.",75,N],[13,"Alternation","","An alternation of expressions. An alternation always has at least two child expressions.",75,N],[4,"Literal","","The high-level intermediate representation of a literal.",N,N],[13,"Unicode","","A single character represented by a Unicode scalar value.",76,N],[13,"Byte","","A single character represented by an arbitrary byte.",76,N],[4,"Class","","The high-level intermediate representation of a character class.",N,N],[13,"Unicode","","A set of characters represented by Unicode scalar values.",77,N],[13,"Bytes","","A set of characters represented by arbitrary bytes (one byte per character).",77,N],[4,"Anchor","","The high-level intermediate representation for an anchor assertion.",N,N],[13,"StartLine","","Match the beginning of a line or the beginning of text. Specifically, this matches at the starting position of the input, or at the position immediately following a `\\n` character.",78,N],[13,"EndLine","","Match the end of a line or the end of text. Specifically, this matches at the end position of the input, or at the position immediately preceding a `\\n` character.",78,N],[13,"StartText","","Match the beginning of text. Specifically, this matches at the starting position of the input.",78,N],[13,"EndText","","Match the end of text. Specifically, this matches at the ending position of the input.",78,N],[4,"WordBoundary","","The high-level intermediate representation for a word-boundary assertion.",N,N],[13,"Unicode","","Match a Unicode-aware word boundary. That is, this matches a position where the left adjacent character and right adjacent character correspond to a word and non-word or a non-word and word character.",79,N],[13,"UnicodeNegate","","Match a Unicode-aware negation of a word boundary.",79,N],[13,"Ascii","","Match an ASCII-only word boundary. That is, this matches a position where the left adjacent character and right adjacent character correspond to a word and non-word or a non-word and word character.",79,N],[13,"AsciiNegate","","Match an ASCII-only negation of a word boundary.",79,N],[4,"GroupKind","","The kind of group.",N,N],[13,"CaptureIndex","","A normal unnamed capturing group.",80,N],[13,"CaptureName","","A named capturing group.",80,N],[12,"name","regex_syntax::hir::GroupKind","The name of the group.",80,N],[12,"index","","The capture index of the group.",80,N],[13,"NonCapturing","regex_syntax::hir","A non-capturing group.",80,N],[4,"RepetitionKind","","The kind of a repetition operator.",N,N],[13,"ZeroOrOne","","Matches a sub-expression zero or one times.",81,N],[13,"ZeroOrMore","","Matches a sub-expression zero or more times.",81,N],[13,"OneOrMore","","Matches a sub-expression one or more times.",81,N],[13,"Range","","Matches a sub-expression within a bounded range of times.",81,N],[4,"RepetitionRange","","The kind of a counted repetition operator.",N,N],[13,"Exactly","","Matches a sub-expression exactly this many times.",82,N],[13,"AtLeast","","Matches a sub-expression at least this many times.",82,N],[13,"Bounded","","Matches a sub-expression at least `m` times and at most `n` times.",82,N],[5,"visit","","Executes an implementation of `Visitor` in constant stack space.",N,[[["hir"],["v"]],["result"]]],[0,"interval","","",N,N],[3,"IntervalSet","regex_syntax::hir::interval","",N,N],[12,"ranges","","",83,N],[3,"IntervalSetIter","","An iterator over intervals.",N,N],[12,"0","","",84,N],[8,"Interval","","",N,N],[16,"Bound","","",85,N],[10,"lower","","",85,N],[10,"upper","","",85,N],[10,"set_lower","","",85,N],[10,"set_upper","","",85,N],[10,"case_fold_simple","","",85,[[["self"],["vec"]]]],[11,"create","","Create a new interval.",85,N],[11,"union","","Union the given overlapping range into this range.",85,[[["self"],["self"]],["option"]]],[11,"intersect","","Intersect this range with the given range and return the result.",85,[[["self"],["self"]],["option"]]],[11,"difference","","Subtract the given range from this range and return the resulting ranges.",85,N],[11,"symmetric_difference","","Compute the symmetric difference the given range from this range. This returns the union of the two ranges minus its intersection.",85,N],[11,"is_contiguous","","Returns true if and only if the two ranges are contiguous. Two ranges are contiguous if and only if the ranges are either overlapping or adjacent.",85,[[["self"],["self"]],["bool"]]],[11,"is_intersection_empty","","Returns true if and only if the intersection of this range and the other range is empty.",85,[[["self"],["self"]],["bool"]]],[11,"is_subset","","Returns true if and only if this range is a subset of the other range.",85,[[["self"],["self"]],["bool"]]],[8,"Bound","","",N,N],[10,"min_value","","",86,[[],["self"]]],[10,"max_value","","",86,[[],["self"]]],[10,"as_u32","","",86,[[["self"]],["u32"]]],[10,"increment","","",86,[[["self"]],["self"]]],[10,"decrement","","",86,[[["self"]],["self"]]],[11,"clone","","",83,[[["self"]],["intervalset"]]],[11,"fmt","","",83,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",83,N],[11,"eq","","",83,[[["self"],["intervalset"]],["bool"]]],[11,"ne","","",83,[[["self"],["intervalset"]],["bool"]]],[11,"new","","Create a new set from a sequence of intervals. Each interval is specified as a pair of bounds, where both bounds are inclusive.",83,[[["t"]],["intervalset"]]],[11,"push","","Add a new interval to this set.",83,[[["self"],["i"]]]],[11,"iter","","Return an iterator over all intervals in this set.",83,[[["self"]],["intervalsetiter"]]],[11,"intervals","","Return an immutable slice of intervals in this set.",83,N],[11,"case_fold_simple","","Expand this interval set such that it contains all case folded characters. For example, if this class consists of the range `a-z`, then applying case folding will result in the class containing both the ranges `a-z` and `A-Z`.",83,[[["self"]]]],[11,"union","","Union this set with the given set, in place.",83,[[["self"],["intervalset"]]]],[11,"intersect","","Intersect this set with the given set, in place.",83,[[["self"],["intervalset"]]]],[11,"difference","","Subtract the given set from this set, in place.",83,[[["self"],["intervalset"]]]],[11,"symmetric_difference","","Compute the symmetric difference of the two sets, in place.",83,[[["self"],["intervalset"]]]],[11,"negate","","Negate this interval set.",83,[[["self"]]]],[11,"canonicalize","","Converts this set into a canonical ordering.",83,[[["self"]]]],[11,"is_canonical","","Returns true if and only if this class is in a canonical ordering.",83,[[["self"]],["bool"]]],[11,"fmt","","",84,[[["self"],["formatter"]],["result"]]],[11,"next","","",84,[[["self"]],["option"]]],[0,"literal","regex_syntax::hir","Provides routines for extracting literal prefixes and suffixes from an `Hir`.",N,N],[3,"Literals","regex_syntax::hir::literal","A set of literal byte strings extracted from a regular expression.",N,N],[12,"lits","","",87,N],[12,"limit_size","","",87,N],[12,"limit_class","","",87,N],[3,"Literal","","A single member of a set of literals extracted from a regular expression.",N,N],[12,"v","","",88,N],[12,"cut","","",88,N],[5,"prefixes","","",N,[[["hir"],["literals"]]]],[5,"suffixes","","",N,[[["hir"],["literals"]]]],[5,"repeat_zero_or_one_literals","","",N,[[["hir"],["literals"],["f"]]]],[5,"repeat_zero_or_more_literals","","",N,[[["hir"],["literals"],["f"]]]],[5,"repeat_one_or_more_literals","","",N,[[["hir"],["literals"],["f"]]]],[5,"repeat_range_literals","","",N,[[["hir"],["u32"],["option",["u32"]],["bool"],["literals"],["f"]]]],[5,"alternate_literals","","",N,N],[5,"position","","",N,N],[5,"escape_unicode","","",N,N],[5,"escape_bytes","","",N,N],[5,"escape_byte","","",N,[[["u8"]],["string"]]],[5,"cls_char_count","","",N,[[["classunicode"]],["usize"]]],[5,"cls_byte_count","","",N,[[["classbytes"]],["usize"]]],[11,"clone","","",87,[[["self"]],["literals"]]],[11,"assert_receiver_is_total_eq","","",87,N],[11,"eq","","",87,[[["self"],["literals"]],["bool"]]],[11,"ne","","",87,[[["self"],["literals"]],["bool"]]],[11,"clone","","",88,[[["self"]],["literal"]]],[11,"assert_receiver_is_total_eq","","",88,N],[11,"cmp","","",88,[[["self"],["literal"]],["ordering"]]],[11,"empty","","Returns a new empty set of literals using default limits.",87,[[],["literals"]]],[11,"prefixes","","Returns a set of literal prefixes extracted from the given `Hir`.",87,[[["hir"]],["literals"]]],[11,"suffixes","","Returns a set of literal suffixes extracted from the given `Hir`.",87,[[["hir"]],["literals"]]],[11,"limit_size","","Get the approximate size limit (in bytes) of this set.",87,[[["self"]],["usize"]]],[11,"set_limit_size","","Set the approximate size limit (in bytes) of this set.",87,[[["self"],["usize"]],["literals"]]],[11,"limit_class","","Get the character class size limit for this set.",87,[[["self"]],["usize"]]],[11,"set_limit_class","","Limits the size of character(or byte) classes considered.",87,[[["self"],["usize"]],["literals"]]],[11,"literals","","Returns the set of literals as a slice. Its order is unspecified.",87,N],[11,"min_len","","Returns the length of the smallest literal.",87,[[["self"]],["option",["usize"]]]],[11,"all_complete","","Returns true if all members in this set are complete.",87,[[["self"]],["bool"]]],[11,"any_complete","","Returns true if any member in this set is complete.",87,[[["self"]],["bool"]]],[11,"contains_empty","","Returns true if this set contains an empty literal.",87,[[["self"]],["bool"]]],[11,"is_empty","","Returns true if this set is empty or if all of its members is empty.",87,[[["self"]],["bool"]]],[11,"to_empty","","Returns a new empty set of literals using this set's limits.",87,[[["self"]],["literals"]]],[11,"longest_common_prefix","","Returns the longest common prefix of all members in this set.",87,N],[11,"longest_common_suffix","","Returns the longest common suffix of all members in this set.",87,N],[11,"trim_suffix","","Returns a new set of literals with the given number of bytes trimmed from the suffix of each literal.",87,[[["self"],["usize"]],["option",["literals"]]]],[11,"unambiguous_prefixes","","Returns a new set of prefixes of this set of literals that are guaranteed to be unambiguous.",87,[[["self"]],["literals"]]],[11,"unambiguous_suffixes","","Returns a new set of suffixes of this set of literals that are guaranteed to be unambiguous.",87,[[["self"]],["literals"]]],[11,"union_prefixes","","Unions the prefixes from the given expression to this set.",87,[[["self"],["hir"]],["bool"]]],[11,"union_suffixes","","Unions the suffixes from the given expression to this set.",87,[[["self"],["hir"]],["bool"]]],[11,"union","","Unions this set with another set.",87,[[["self"],["literals"]],["bool"]]],[11,"cross_product","","Extends this set with another set.",87,[[["self"],["literals"]],["bool"]]],[11,"cross_add","","Extends each literal in this set with the bytes given.",87,N],[11,"add","","Adds the given literal to this set.",87,[[["self"],["literal"]],["bool"]]],[11,"add_char_class","","Extends each literal in this set with the character class given.",87,[[["self"],["classunicode"]],["bool"]]],[11,"add_char_class_reverse","","Extends each literal in this set with the character class given, writing the bytes of each character in reverse.",87,[[["self"],["classunicode"]],["bool"]]],[11,"_add_char_class","","",87,[[["self"],["classunicode"],["bool"]],["bool"]]],[11,"add_byte_class","","Extends each literal in this set with the byte class given.",87,[[["self"],["classbytes"]],["bool"]]],[11,"cut","","Cuts every member of this set. When a member is cut, it can never be extended.",87,[[["self"]]]],[11,"reverse","","Reverses all members in place.",87,[[["self"]]]],[11,"clear","","Clears this set of all members.",87,[[["self"]]]],[11,"remove_complete","","Pops all complete literals out of this set.",87,[[["self"]],["vec",["literal"]]]],[11,"num_bytes","","Returns the total number of bytes in this set.",87,[[["self"]],["usize"]]],[11,"class_exceeds_limits","","Returns true if a character class with the given size would cause this set to exceed its limits.",87,[[["self"],["usize"]],["bool"]]],[11,"fmt","","",87,[[["self"],["formatter"]],["result"]]],[11,"new","","Returns a new complete literal with the bytes given.",88,[[["vec",["u8"]]],["literal"]]],[11,"empty","","Returns a new complete empty literal.",88,[[],["literal"]]],[11,"is_cut","","Returns true if this literal was \"cut.\"",88,[[["self"]],["bool"]]],[11,"cut","","Cuts this literal.",88,[[["self"]]]],[11,"eq","","",88,[[["self"],["literal"]],["bool"]]],[11,"partial_cmp","","",88,[[["self"],["literal"]],["option",["ordering"]]]],[11,"fmt","","",88,[[["self"],["formatter"]],["result"]]],[11,"as_ref","","",88,N],[11,"deref","","",88,[[["self"]],["vec"]]],[11,"deref_mut","","",88,[[["self"]],["vec"]]],[0,"print","regex_syntax::hir","This module provides a regular expression printer for `Hir`.",N,N],[3,"PrinterBuilder","regex_syntax::hir::print","A builder for constructing a printer.",N,N],[12,"_priv","","",89,N],[3,"Printer","","A printer for a regular expression's high-level intermediate representation.",N,N],[12,"_priv","","",90,N],[3,"Writer","","",N,N],[12,"printer","","",91,N],[12,"wtr","","",91,N],[11,"clone","","",89,[[["self"]],["printerbuilder"]]],[11,"fmt","","",89,[[["self"],["formatter"]],["result"]]],[11,"default","","",89,[[],["printerbuilder"]]],[11,"new","","",89,[[],["printerbuilder"]]],[11,"build","","",89,[[["self"]],["printer"]]],[11,"fmt","","",90,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new printer.",90,[[],["printer"]]],[11,"print","","Print the given `Ast` to the given writer. The writer must implement `fmt::Write`. Typical implementations of `fmt::Write` that can be used here are a `fmt::Formatter` (which is available in `fmt::Display` implementations) or a `&mut String`.",90,[[["self"],["hir"],["w"]],["result"]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[11,"finish","","",91,[[["self"]],["result"]]],[11,"visit_pre","","",91,[[["self"],["hir"]],["result"]]],[11,"visit_post","","",91,[[["self"],["hir"]],["result"]]],[11,"visit_alternation_in","","",91,[[["self"]],["result"]]],[11,"write_literal_char","","",91,[[["self"],["char"]],["result"]]],[11,"write_literal_byte","","",91,[[["self"],["u8"]],["result"]]],[11,"write_literal_class_byte","","",91,[[["self"],["u8"]],["result"]]],[0,"translate","regex_syntax::hir","Defines a translator that converts an `Ast` to an `Hir`.",N,N],[3,"TranslatorBuilder","regex_syntax::hir::translate","A builder for constructing an AST->HIR translator.",N,N],[12,"allow_invalid_utf8","","",92,N],[12,"flags","","",92,N],[3,"Translator","","A translator maps abstract syntax to a high level intermediate representation.",N,N],[12,"stack","","Our call stack, but on the heap.",93,N],[12,"flags","","The current flag settings.",93,N],[12,"allow_invalid_utf8","","Whether we're allowed to produce HIR that can match arbitrary bytes.",93,N],[3,"TranslatorI","","The internal implementation of a translator.",N,N],[12,"trans","","",94,N],[12,"pattern","","",94,N],[3,"Flags","","A translator's representation of a regular expression's flags at any given moment in time.",N,N],[12,"case_insensitive","","",95,N],[12,"multi_line","","",95,N],[12,"dot_matches_new_line","","",95,N],[12,"swap_greed","","",95,N],[12,"unicode","","",95,N],[4,"HirFrame","","An HirFrame is a single stack frame, represented explicitly, which is created for each item in the Ast that we traverse.",N,N],[13,"Expr","","An arbitrary HIR expression. These get pushed whenever we hit a base case in the Ast. They get popped after an inductive (i.e., recursive) step is complete.",96,N],[13,"ClassUnicode","","A Unicode character class. This frame is mutated as we descend into the Ast of a character class (which is itself its own mini recursive structure).",96,N],[13,"ClassBytes","","A byte-oriented character class. This frame is mutated as we descend into the Ast of a character class (which is itself its own mini recursive structure).",96,N],[13,"Group","","This is pushed on to the stack upon first seeing any kind of group, indicated by parentheses (including non-capturing groups). It is popped upon leaving a group.",96,N],[12,"old_flags","regex_syntax::hir::translate::HirFrame","The old active flags, if any, when this group was opened.",96,N],[13,"Concat","regex_syntax::hir::translate","This is pushed whenever a concatenation is observed. After visiting every sub-expression in the concatenation, the translator's stack is popped until it sees a Concat frame.",96,N],[13,"Alternation","","This is pushed whenever an alternation is observed. After visiting every sub-expression in the alternation, the translator's stack is popped until it sees an Alternation frame.",96,N],[5,"hir_ascii_class_bytes","","",N,[[["classasciikind"]],["classbytes"]]],[5,"ascii_class","","",N,N],[6,"Result","","",N,N],[11,"clone","","",92,[[["self"]],["translatorbuilder"]]],[11,"fmt","","",92,[[["self"],["formatter"]],["result"]]],[11,"default","","",92,[[],["translatorbuilder"]]],[11,"new","","Create a new translator builder with a default c onfiguration.",92,[[],["translatorbuilder"]]],[11,"build","","Build a translator using the current configuration.",92,[[["self"]],["translator"]]],[11,"allow_invalid_utf8","","When enabled, translation will permit the construction of a regular expression that may match invalid UTF-8.",92,[[["self"],["bool"]],["translatorbuilder"]]],[11,"case_insensitive","","Enable or disable the case insensitive flag (`i`) by default.",92,[[["self"],["bool"]],["translatorbuilder"]]],[11,"multi_line","","Enable or disable the multi-line matching flag (`m`) by default.",92,[[["self"],["bool"]],["translatorbuilder"]]],[11,"dot_matches_new_line","","Enable or disable the \"dot matches any character\" flag (`s`) by default.",92,[[["self"],["bool"]],["translatorbuilder"]]],[11,"swap_greed","","Enable or disable the \"swap greed\" flag (`U`) by default.",92,[[["self"],["bool"]],["translatorbuilder"]]],[11,"unicode","","Enable or disable the Unicode flag (`u`) by default.",92,[[["self"],["bool"]],["translatorbuilder"]]],[11,"clone","","",93,[[["self"]],["translator"]]],[11,"fmt","","",93,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new translator using the default configuration.",93,[[],["translator"]]],[11,"translate","","Translate the given abstract syntax tree (AST) into a high level intermediate representation (HIR).",93,[[["self"],["str"],["ast"]],["result",["hir","error"]]]],[11,"clone","","",96,[[["self"]],["hirframe"]]],[11,"fmt","","",96,[[["self"],["formatter"]],["result"]]],[11,"unwrap_expr","","Assert that the current stack frame is an Hir expression and return it.",96,[[["self"]],["hir"]]],[11,"unwrap_class_unicode","","Assert that the current stack frame is a Unicode class expression and return it.",96,[[["self"]],["classunicode"]]],[11,"unwrap_class_bytes","","Assert that the current stack frame is a byte class expression and return it.",96,[[["self"]],["classbytes"]]],[11,"unwrap_group","","Assert that the current stack frame is a group indicator and return its corresponding flags (the flags that were active at the time the group was entered) if they exist.",96,[[["self"]],["option",["flags"]]]],[11,"finish","","",94,[[["self"]],["result",["hir","error"]]]],[11,"visit_pre","","",94,[[["self"],["ast"]],["result",["error"]]]],[11,"visit_post","","",94,[[["self"],["ast"]],["result",["error"]]]],[11,"visit_class_set_item_pre","","",94,[[["self"],["classsetitem"]],["result",["error"]]]],[11,"visit_class_set_item_post","","",94,[[["self"],["classsetitem"]],["result",["error"]]]],[11,"visit_class_set_binary_op_pre","","",94,[[["self"],["classsetbinaryop"]],["result",["error"]]]],[11,"visit_class_set_binary_op_in","","",94,[[["self"],["classsetbinaryop"]],["result",["error"]]]],[11,"visit_class_set_binary_op_post","","",94,[[["self"],["classsetbinaryop"]],["result",["error"]]]],[11,"clone","","",94,[[["self"]],["translatori"]]],[11,"fmt","","",94,[[["self"],["formatter"]],["result"]]],[11,"new","","Build a new internal translator.",94,[[["translator"],["str"]],["translatori"]]],[11,"trans","","Return a reference to the underlying translator.",94,[[["self"]],["translator"]]],[11,"push","","Push the given frame on to the call stack.",94,[[["self"],["hirframe"]]]],[11,"pop","","Pop the top of the call stack. If the call stack is empty, return None.",94,[[["self"]],["option",["hirframe"]]]],[11,"error","","Create a new error with the given span and error type.",94,[[["self"],["span"],["errorkind"]],["error"]]],[11,"flags","","Return a copy of the active flags.",94,[[["self"]],["flags"]]],[11,"set_flags","","Set the flags of this translator from the flags set in the given AST. Then, return the old flags.",94,[[["self"],["flags"]],["flags"]]],[11,"hir_literal","","",94,[[["self"],["literal"]],["result",["hir","error"]]]],[11,"literal_to_char","","Convert an Ast literal to its scalar representation.",94,[[["self"],["literal"]],["result",["literal","error"]]]],[11,"hir_from_char","","",94,[[["self"],["span"],["char"]],["result",["hir","error"]]]],[11,"hir_from_char_case_insensitive","","",94,[[["self"],["span"],["char"]],["result",["hir","error"]]]],[11,"hir_dot","","",94,[[["self"],["span"]],["result",["hir","error"]]]],[11,"hir_assertion","","",94,[[["self"],["assertion"]],["result",["hir","error"]]]],[11,"hir_group","","",94,[[["self"],["group"],["hir"]],["hir"]]],[11,"hir_repetition","","",94,[[["self"],["repetition"],["hir"]],["hir"]]],[11,"hir_unicode_class","","",94,[[["self"],["classunicode"]],["result",["classunicode","error"]]]],[11,"hir_perl_unicode_class","","",94,[[["self"],["classperl"]],["classunicode"]]],[11,"hir_perl_byte_class","","",94,[[["self"],["classperl"]],["classbytes"]]],[11,"unicode_fold_and_negate","","",94,[[["self"],["bool"],["classunicode"]]]],[11,"bytes_fold_and_negate","","",94,[[["self"],["span"],["bool"],["classbytes"]],["result",["error"]]]],[11,"class_literal_byte","","Return a scalar byte value suitable for use as a literal in a byte character class.",94,[[["self"],["literal"]],["result",["u8","error"]]]],[11,"clone","","",95,[[["self"]],["flags"]]],[11,"fmt","","",95,[[["self"],["formatter"]],["result"]]],[11,"default","","",95,[[],["flags"]]],[11,"from_ast","","",95,[[["flags"]],["flags"]]],[11,"merge","","",95,[[["self"],["flags"]]]],[11,"case_insensitive","","",95,[[["self"]],["bool"]]],[11,"multi_line","","",95,[[["self"]],["bool"]]],[11,"dot_matches_new_line","","",95,[[["self"]],["bool"]]],[11,"swap_greed","","",95,[[["self"]],["bool"]]],[11,"unicode","","",95,[[["self"]],["bool"]]],[0,"visitor","regex_syntax::hir","",N,N],[3,"HeapVisitor","regex_syntax::hir::visitor","HeapVisitor visits every item in an `Hir` recursively using constant stack size and a heap size proportional to the size of the `Hir`.",N,N],[12,"stack","","A stack of `Hir` nodes. This is roughly analogous to the call stack used in a typical recursive visitor.",97,N],[4,"Frame","","Represents a single stack frame while performing structural induction over an `Hir`.",N,N],[13,"Repetition","","A stack frame allocated just before descending into a repetition operator's child node.",98,N],[13,"Group","","A stack frame allocated just before descending into a group's child node.",98,N],[13,"Concat","","The stack frame used while visiting every child node of a concatenation of expressions.",98,N],[12,"head","regex_syntax::hir::visitor::Frame","The child node we are currently visiting.",98,N],[12,"tail","","The remaining child nodes to visit (which may be empty).",98,N],[13,"Alternation","regex_syntax::hir::visitor","The stack frame used while visiting every child node of an alternation of expressions.",98,N],[12,"head","regex_syntax::hir::visitor::Frame","The child node we are currently visiting.",98,N],[12,"tail","","The remaining child nodes to visit (which may be empty).",98,N],[5,"visit","regex_syntax::hir::visitor","Executes an implementation of `Visitor` in constant stack space.",N,[[["hir"],["v"]],["result"]]],[8,"Visitor","","A trait for visiting the high-level IR (HIR) in depth first order.",N,N],[16,"Output","","The result of visiting an HIR.",99,N],[16,"Err","","An error that visiting an HIR might return.",99,N],[10,"finish","","All implementors of `Visitor` must provide a `finish` method, which yields the result of visiting the HIR or an error.",99,[[["self"]],["result"]]],[11,"start","","This method is called before beginning traversal of the HIR.",99,[[["self"]]]],[11,"visit_pre","","This method is called on an `Hir` before descending into child `Hir` nodes.",99,[[["self"],["hir"]],["result"]]],[11,"visit_post","","This method is called on an `Hir` after descending all of its child `Hir` nodes.",99,[[["self"],["hir"]],["result"]]],[11,"visit_alternation_in","","This method is called between child nodes of an alternation.",99,[[["self"]],["result"]]],[11,"new","","",97,[[],["heapvisitor"]]],[11,"visit","","",97,[[["self"],["hir"],["v"]],["result"]]],[11,"induct","","Build a stack frame for the given HIR if one is needed (which occurs if and only if there are child nodes in the HIR). Otherwise, return None.",97,[[["self"],["hir"]],["option",["frame"]]]],[11,"pop","","Pops the given frame. If the frame has an additional inductive step, then return it, otherwise return `None`.",97,[[["self"],["frame"]],["option",["frame"]]]],[11,"child","","Perform the next inductive step on this frame and return the next child HIR node to visit.",98,[[["self"]],["hir"]]],[8,"Visitor","regex_syntax::hir","A trait for visiting the high-level IR (HIR) in depth first order.",N,N],[16,"Output","","The result of visiting an HIR.",99,N],[16,"Err","","An error that visiting an HIR might return.",99,N],[10,"finish","","All implementors of `Visitor` must provide a `finish` method, which yields the result of visiting the HIR or an error.",99,[[["self"]],["result"]]],[11,"start","regex_syntax::hir::visitor","This method is called before beginning traversal of the HIR.",99,[[["self"]]]],[11,"visit_pre","","This method is called on an `Hir` before descending into child `Hir` nodes.",99,[[["self"],["hir"]],["result"]]],[11,"visit_post","","This method is called on an `Hir` after descending all of its child `Hir` nodes.",99,[[["self"],["hir"]],["result"]]],[11,"visit_alternation_in","","This method is called between child nodes of an alternation.",99,[[["self"]],["result"]]],[11,"clone","regex_syntax::hir","",63,[[["self"]],["error"]]],[11,"fmt","","",63,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",63,N],[11,"eq","","",63,[[["self"],["error"]],["bool"]]],[11,"ne","","",63,[[["self"],["error"]],["bool"]]],[11,"kind","","Return the type of this error.",63,[[["self"]],["errorkind"]]],[11,"pattern","","The original pattern string in which this error occurred.",63,[[["self"]],["str"]]],[11,"span","","Return the span at which this error occurred.",63,[[["self"]],["span"]]],[11,"clone","","",74,[[["self"]],["errorkind"]]],[11,"fmt","","",74,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",74,N],[11,"eq","","",74,[[["self"],["errorkind"]],["bool"]]],[11,"description","","",74,[[["self"]],["str"]]],[11,"description","","",63,[[["self"]],["str"]]],[11,"fmt","","",63,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",74,[[["self"],["formatter"]],["result"]]],[11,"clone","","",64,[[["self"]],["hir"]]],[11,"fmt","","",64,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",64,N],[11,"eq","","",64,[[["self"],["hir"]],["bool"]]],[11,"ne","","",64,[[["self"],["hir"]],["bool"]]],[11,"clone","","",75,[[["self"]],["hirkind"]]],[11,"fmt","","",75,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",75,N],[11,"eq","","",75,[[["self"],["hirkind"]],["bool"]]],[11,"ne","","",75,[[["self"],["hirkind"]],["bool"]]],[11,"kind","","Returns a reference to the underlying HIR kind.",64,[[["self"]],["hirkind"]]],[11,"into_kind","","Consumes ownership of this HIR expression and returns its underlying `HirKind`.",64,[[["self"]],["hirkind"]]],[11,"empty","","Returns an empty HIR expression.",64,[[],["hir"]]],[11,"literal","","Creates a literal HIR expression.",64,[[["literal"]],["hir"]]],[11,"class","","Creates a class HIR expression.",64,[[["class"]],["hir"]]],[11,"anchor","","Creates an anchor assertion HIR expression.",64,[[["anchor"]],["hir"]]],[11,"word_boundary","","Creates a word boundary assertion HIR expression.",64,[[["wordboundary"]],["hir"]]],[11,"repetition","","Creates a repetition HIR expression.",64,[[["repetition"]],["hir"]]],[11,"group","","Creates a group HIR expression.",64,[[["group"]],["hir"]]],[11,"concat","","Returns the concatenation of the given expressions.",64,[[["vec",["hir"]]],["hir"]]],[11,"alternation","","Returns the alternation of the given expressions.",64,[[["vec",["hir"]]],["hir"]]],[11,"dot","","Build an HIR expression for `.`.",64,[[["bool"]],["hir"]]],[11,"any","","Build an HIR expression for `(?s).`.",64,[[["bool"]],["hir"]]],[11,"is_always_utf8","","Return true if and only if this HIR will always match valid UTF-8.",64,[[["self"]],["bool"]]],[11,"is_all_assertions","","Returns true if and only if this entire HIR expression is made up of zero-width assertions.",64,[[["self"]],["bool"]]],[11,"is_anchored_start","","Return true if and only if this HIR is required to match from the beginning of text. This includes expressions like `^foo`, `^(foo|bar)`, `^foo|^bar` but not `^foo|bar`.",64,[[["self"]],["bool"]]],[11,"is_anchored_end","","Return true if and only if this HIR is required to match at the end of text. This includes expressions like `foo$`, `(foo|bar)$`, `foo$|bar$` but not `foo$|bar`.",64,[[["self"]],["bool"]]],[11,"is_any_anchored_start","","Return true if and only if this HIR contains any sub-expression that is required to match at the beginning of text. Specifically, this returns true if the `^` symbol (when multiline mode is disabled) or the `\\A` escape appear anywhere in the regex.",64,[[["self"]],["bool"]]],[11,"is_any_anchored_end","","Return true if and only if this HIR contains any sub-expression that is required to match at the end of text. Specifically, this returns true if the `$` symbol (when multiline mode is disabled) or the `\\z` escape appear anywhere in the regex.",64,[[["self"]],["bool"]]],[11,"is_match_empty","","Return true if and only if the empty string is part of the language matched by this regular expression.",64,[[["self"]],["bool"]]],[11,"is_empty","","Return true if and only if this HIR is the empty regular expression.",75,[[["self"]],["bool"]]],[11,"has_subexprs","","Returns true if and only if this kind has any (including possibly empty) subexpressions.",75,[[["self"]],["bool"]]],[11,"fmt","","",64,[[["self"],["formatter"]],["result"]]],[11,"clone","","",76,[[["self"]],["literal"]]],[11,"fmt","","",76,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",76,N],[11,"eq","","",76,[[["self"],["literal"]],["bool"]]],[11,"ne","","",76,[[["self"],["literal"]],["bool"]]],[11,"is_unicode","","Returns true if and only if this literal corresponds to a Unicode scalar value.",76,[[["self"]],["bool"]]],[11,"clone","","",77,[[["self"]],["class"]]],[11,"fmt","","",77,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",77,N],[11,"eq","","",77,[[["self"],["class"]],["bool"]]],[11,"ne","","",77,[[["self"],["class"]],["bool"]]],[11,"case_fold_simple","","Apply Unicode simple case folding to this character class, in place. The character class will be expanded to include all simple case folded character variants.",77,[[["self"]]]],[11,"negate","","Negate this character class in place.",77,[[["self"]]]],[11,"is_always_utf8","","Returns true if and only if this character class will only ever match valid UTF-8.",77,[[["self"]],["bool"]]],[11,"clone","","",65,[[["self"]],["classunicode"]]],[11,"fmt","","",65,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",65,N],[11,"eq","","",65,[[["self"],["classunicode"]],["bool"]]],[11,"ne","","",65,[[["self"],["classunicode"]],["bool"]]],[11,"new","","Create a new class from a sequence of ranges.",65,[[["i"]],["classunicode"]]],[11,"empty","","Create a new class with no ranges.",65,[[],["classunicode"]]],[11,"push","","Add a new range to this set.",65,[[["self"],["classunicoderange"]]]],[11,"iter","","Return an iterator over all ranges in this class.",65,[[["self"]],["classunicodeiter"]]],[11,"ranges","","Return the underlying ranges as a slice.",65,N],[11,"case_fold_simple","","Expand this character class such that it contains all case folded characters, according to Unicode's \"simple\" mapping. For example, if this class consists of the range `a-z`, then applying case folding will result in the class containing both the ranges `a-z` and `A-Z`.",65,[[["self"]]]],[11,"negate","","Negate this character class.",65,[[["self"]]]],[11,"union","","Union this character class with the given character class, in place.",65,[[["self"],["classunicode"]]]],[11,"intersect","","Intersect this character class with the given character class, in place.",65,[[["self"],["classunicode"]]]],[11,"difference","","Subtract the given character class from this character class, in place.",65,[[["self"],["classunicode"]]]],[11,"symmetric_difference","","Compute the symmetric difference of the given character classes, in place.",65,[[["self"],["classunicode"]]]],[11,"fmt","","",66,[[["self"],["formatter"]],["result"]]],[11,"next","","",66,[[["self"]],["option",["classunicoderange"]]]],[11,"clone","","",67,[[["self"]],["classunicoderange"]]],[11,"default","","",67,[[],["classunicoderange"]]],[11,"assert_receiver_is_total_eq","","",67,N],[11,"eq","","",67,[[["self"],["classunicoderange"]],["bool"]]],[11,"ne","","",67,[[["self"],["classunicoderange"]],["bool"]]],[11,"partial_cmp","","",67,[[["self"],["classunicoderange"]],["option",["ordering"]]]],[11,"lt","","",67,[[["self"],["classunicoderange"]],["bool"]]],[11,"le","","",67,[[["self"],["classunicoderange"]],["bool"]]],[11,"gt","","",67,[[["self"],["classunicoderange"]],["bool"]]],[11,"ge","","",67,[[["self"],["classunicoderange"]],["bool"]]],[11,"cmp","","",67,[[["self"],["classunicoderange"]],["ordering"]]],[11,"fmt","","",67,[[["self"],["formatter"]],["result"]]],[11,"lower","","",67,[[["self"]],["char"]]],[11,"upper","","",67,[[["self"]],["char"]]],[11,"set_lower","","",67,[[["self"],["char"]]]],[11,"set_upper","","",67,[[["self"],["char"]]]],[11,"case_fold_simple","","Apply simple case folding to this Unicode scalar value range.",67,[[["self"],["vec"]]]],[11,"new","","Create a new Unicode scalar value range for a character class.",67,[[["char"],["char"]],["classunicoderange"]]],[11,"start","","Return the start of this range.",67,[[["self"]],["char"]]],[11,"end","","Return the end of this range.",67,[[["self"]],["char"]]],[11,"clone","","",68,[[["self"]],["classbytes"]]],[11,"fmt","","",68,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",68,N],[11,"eq","","",68,[[["self"],["classbytes"]],["bool"]]],[11,"ne","","",68,[[["self"],["classbytes"]],["bool"]]],[11,"new","","Create a new class from a sequence of ranges.",68,[[["i"]],["classbytes"]]],[11,"empty","","Create a new class with no ranges.",68,[[],["classbytes"]]],[11,"push","","Add a new range to this set.",68,[[["self"],["classbytesrange"]]]],[11,"iter","","Return an iterator over all ranges in this class.",68,[[["self"]],["classbytesiter"]]],[11,"ranges","","Return the underlying ranges as a slice.",68,N],[11,"case_fold_simple","","Expand this character class such that it contains all case folded characters. For example, if this class consists of the range `a-z`, then applying case folding will result in the class containing both the ranges `a-z` and `A-Z`.",68,[[["self"]]]],[11,"negate","","Negate this byte class.",68,[[["self"]]]],[11,"union","","Union this byte class with the given byte class, in place.",68,[[["self"],["classbytes"]]]],[11,"intersect","","Intersect this byte class with the given byte class, in place.",68,[[["self"],["classbytes"]]]],[11,"difference","","Subtract the given byte class from this byte class, in place.",68,[[["self"],["classbytes"]]]],[11,"symmetric_difference","","Compute the symmetric difference of the given byte classes, in place.",68,[[["self"],["classbytes"]]]],[11,"is_all_ascii","","Returns true if and only if this character class will either match nothing or only ASCII bytes. Stated differently, this returns false if and only if this class contains a non-ASCII byte.",68,[[["self"]],["bool"]]],[11,"fmt","","",69,[[["self"],["formatter"]],["result"]]],[11,"next","","",69,[[["self"]],["option",["classbytesrange"]]]],[11,"clone","","",70,[[["self"]],["classbytesrange"]]],[11,"default","","",70,[[],["classbytesrange"]]],[11,"assert_receiver_is_total_eq","","",70,N],[11,"eq","","",70,[[["self"],["classbytesrange"]],["bool"]]],[11,"ne","","",70,[[["self"],["classbytesrange"]],["bool"]]],[11,"partial_cmp","","",70,[[["self"],["classbytesrange"]],["option",["ordering"]]]],[11,"lt","","",70,[[["self"],["classbytesrange"]],["bool"]]],[11,"le","","",70,[[["self"],["classbytesrange"]],["bool"]]],[11,"gt","","",70,[[["self"],["classbytesrange"]],["bool"]]],[11,"ge","","",70,[[["self"],["classbytesrange"]],["bool"]]],[11,"cmp","","",70,[[["self"],["classbytesrange"]],["ordering"]]],[11,"lower","","",70,[[["self"]],["u8"]]],[11,"upper","","",70,[[["self"]],["u8"]]],[11,"set_lower","","",70,[[["self"],["u8"]]]],[11,"set_upper","","",70,[[["self"],["u8"]]]],[11,"case_fold_simple","","Apply simple case folding to this byte range. Only ASCII case mappings (for a-z) are applied.",70,[[["self"],["vec"]]]],[11,"new","","Create a new byte range for a character class.",70,[[["u8"],["u8"]],["classbytesrange"]]],[11,"start","","Return the start of this range.",70,[[["self"]],["u8"]]],[11,"end","","Return the end of this range.",70,[[["self"]],["u8"]]],[11,"fmt","","",70,[[["self"],["formatter"]],["result"]]],[11,"clone","","",78,[[["self"]],["anchor"]]],[11,"fmt","","",78,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",78,N],[11,"eq","","",78,[[["self"],["anchor"]],["bool"]]],[11,"clone","","",79,[[["self"]],["wordboundary"]]],[11,"fmt","","",79,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",79,N],[11,"eq","","",79,[[["self"],["wordboundary"]],["bool"]]],[11,"is_negated","","Returns true if and only if this word boundary assertion is negated.",79,[[["self"]],["bool"]]],[11,"clone","","",71,[[["self"]],["group"]]],[11,"fmt","","",71,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",71,N],[11,"eq","","",71,[[["self"],["group"]],["bool"]]],[11,"ne","","",71,[[["self"],["group"]],["bool"]]],[11,"clone","","",80,[[["self"]],["groupkind"]]],[11,"fmt","","",80,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",80,N],[11,"eq","","",80,[[["self"],["groupkind"]],["bool"]]],[11,"ne","","",80,[[["self"],["groupkind"]],["bool"]]],[11,"clone","","",72,[[["self"]],["repetition"]]],[11,"fmt","","",72,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",72,N],[11,"eq","","",72,[[["self"],["repetition"]],["bool"]]],[11,"ne","","",72,[[["self"],["repetition"]],["bool"]]],[11,"is_match_empty","","Returns true if and only if this repetition operator makes it possible to match the empty string.",72,[[["self"]],["bool"]]],[11,"clone","","",81,[[["self"]],["repetitionkind"]]],[11,"fmt","","",81,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",81,N],[11,"eq","","",81,[[["self"],["repetitionkind"]],["bool"]]],[11,"ne","","",81,[[["self"],["repetitionkind"]],["bool"]]],[11,"clone","","",82,[[["self"]],["repetitionrange"]]],[11,"fmt","","",82,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",82,N],[11,"eq","","",82,[[["self"],["repetitionrange"]],["bool"]]],[11,"ne","","",82,[[["self"],["repetitionrange"]],["bool"]]],[11,"drop","","",64,[[["self"]]]],[11,"clone","","",73,[[["self"]],["hirinfo"]]],[11,"fmt","","",73,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",73,N],[11,"eq","","",73,[[["self"],["hirinfo"]],["bool"]]],[11,"ne","","",73,[[["self"],["hirinfo"]],["bool"]]],[11,"new","","",73,[[],["hirinfo"]]],[11,"is_always_utf8","","",73,[[["self"]],["bool"]]],[11,"set_always_utf8","","",73,[[["self"],["bool"]]]],[11,"is_all_assertions","","",73,[[["self"]],["bool"]]],[11,"set_all_assertions","","",73,[[["self"],["bool"]]]],[11,"is_anchored_start","","",73,[[["self"]],["bool"]]],[11,"set_anchored_start","","",73,[[["self"],["bool"]]]],[11,"is_anchored_end","","",73,[[["self"]],["bool"]]],[11,"set_anchored_end","","",73,[[["self"],["bool"]]]],[11,"is_any_anchored_start","","",73,[[["self"]],["bool"]]],[11,"set_any_anchored_start","","",73,[[["self"],["bool"]]]],[11,"is_any_anchored_end","","",73,[[["self"]],["bool"]]],[11,"set_any_anchored_end","","",73,[[["self"],["bool"]]]],[11,"is_match_empty","","",73,[[["self"]],["bool"]]],[11,"set_match_empty","","",73,[[["self"],["bool"]]]],[0,"parser","regex_syntax","",N,N],[3,"ParserBuilder","regex_syntax::parser","A builder for a regular expression parser.",N,N],[12,"ast","","",1,N],[12,"hir","","",1,N],[3,"Parser","","A convenience parser for regular expressions.",N,N],[12,"ast","","",0,N],[12,"hir","","",0,N],[11,"clone","regex_syntax","",1,[[["self"]],["parserbuilder"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"default","","",1,[[],["parserbuilder"]]],[11,"new","","Create a new parser builder with a default configuration.",1,[[],["parserbuilder"]]],[11,"build","","Build a parser from this configuration with the given pattern.",1,[[["self"]],["parser"]]],[11,"nest_limit","","Set the nesting limit for this parser.",1,[[["self"],["u32"]],["parserbuilder"]]],[11,"octal","","Whether to support octal syntax or not.",1,[[["self"],["bool"]],["parserbuilder"]]],[11,"allow_invalid_utf8","","When enabled, the parser will permit the construction of a regular expression that may match invalid UTF-8.",1,[[["self"],["bool"]],["parserbuilder"]]],[11,"ignore_whitespace","","Enable verbose mode in the regular expression.",1,[[["self"],["bool"]],["parserbuilder"]]],[11,"case_insensitive","","Enable or disable the case insensitive flag by default.",1,[[["self"],["bool"]],["parserbuilder"]]],[11,"multi_line","","Enable or disable the multi-line matching flag by default.",1,[[["self"],["bool"]],["parserbuilder"]]],[11,"dot_matches_new_line","","Enable or disable the \"dot matches any character\" flag by default.",1,[[["self"],["bool"]],["parserbuilder"]]],[11,"swap_greed","","Enable or disable the \"swap greed\" flag by default.",1,[[["self"],["bool"]],["parserbuilder"]]],[11,"unicode","","Enable or disable the Unicode flag (`u`) by default.",1,[[["self"],["bool"]],["parserbuilder"]]],[11,"clone","","",0,[[["self"]],["parser"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new parser with a default configuration.",0,[[],["parser"]]],[11,"parse","","Parse the regular expression into a high level intermediate representation.",0,[[["self"],["str"]],["result",["hir"]]]],[0,"unicode","","",N,N],[3,"SimpleFoldIter","regex_syntax::unicode","An iterator over a codepoint's simple case equivalence class.",N,N],[12,"0","","",100,N],[3,"AgeIter","","An iterator over Unicode Age sets. Each item corresponds to a set of codepoints that were added in a particular revision of Unicode. The iterator yields items in chronological order.",N,N],[12,"ages","","",101,N],[4,"Error","","An error that occurs when dealing with Unicode.",N,N],[13,"PropertyNotFound","","",102,N],[13,"PropertyValueNotFound","","",102,N],[4,"ClassQuery","","A query for finding a character class defined by Unicode. This supports either use of a property name directly, or lookup by property value. The former generally refers to Binary properties (see UTS#44, Table 8), but as a special exception (see UTS#18, Section 1.2) both general categories (an enumeration) and scripts (a catalog) are supported as if each of their possible values were a binary property.",N,N],[13,"OneLetter","","Return a class corresponding to a Unicode binary property, named by a single letter.",103,N],[13,"Binary","","Return a class corresponding to a Unicode binary property.",103,N],[13,"ByValue","","Return a class corresponding to all codepoints whose property (identified by `property_name`) corresponds to the given value (identified by `property_value`).",103,N],[12,"property_name","regex_syntax::unicode::ClassQuery","A property name.",103,N],[12,"property_value","","A property value.",103,N],[4,"CanonicalClassQuery","regex_syntax::unicode","Like ClassQuery, but its parameters have been canonicalized. This also differentiates binary properties from flattened general categories and scripts.",N,N],[13,"Binary","","The canonical binary property name.",104,N],[13,"GeneralCategory","","The canonical general category name.",104,N],[13,"Script","","The canonical script name.",104,N],[13,"ByValue","","An arbitrary association between property and value, both of which have been canonicalized.",104,N],[12,"property_name","regex_syntax::unicode::CanonicalClassQuery","The canonical property name.",104,N],[12,"property_value","","The canonical property value.",104,N],[5,"encode_utf8","regex_syntax::unicode","Encode the given Unicode character to `dst` as a single UTF-8 sequence.",N,N],[5,"simple_fold","","Return an iterator over the equivalence class of simple case mappings for the given codepoint. The equivalence class does not include the given codepoint.",N,[[["char"]],["result",["simplefolditer","option"]]]],[5,"contains_simple_case_mapping","","Returns true if and only if the given (inclusive) range contains at least one Unicode scalar value that has a non-empty non-trivial simple case mapping.",N,[[["char"],["char"]],["bool"]]],[5,"class","","Looks up a Unicode class given a query. If one doesn't exist, then `None` is returned.",N,[[["classquery"]],["result",["classunicode","error"]]]],[5,"hir_class","","Build a Unicode HIR class from a sequence of Unicode scalar value ranges.",N,N],[5,"canonical_prop","","",N,[[["str"]],["option",["str"]]]],[5,"canonical_gencat","","",N,[[["str"]],["option",["str"]]]],[5,"canonical_script","","",N,[[["str"]],["option",["str"]]]],[5,"canonical_value","","",N,[[["propertyvalues"],["str"]],["option",["str"]]]],[5,"normalize","","",N,[[["str"]],["string"]]],[5,"property_values","","",N,[[["str"]],["option",["propertyvalues"]]]],[5,"property_set","","",N,N],[5,"ages","","",N,[[["str"]],["result",["ageiter","error"]]]],[6,"Result","","",N,N],[11,"fmt","","",102,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",100,[[["self"],["formatter"]],["result"]]],[11,"next","","",100,[[["self"]],["option",["char"]]]],[11,"fmt","","",103,[[["self"],["formatter"]],["result"]]],[11,"canonicalize","","",103,[[["self"]],["result",["canonicalclassquery","error"]]]],[11,"canonical_binary","","",103,[[["self"],["str"]],["result",["canonicalclassquery","error"]]]],[11,"fmt","","",104,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",104,N],[11,"eq","","",104,[[["self"],["canonicalclassquery"]],["bool"]]],[11,"ne","","",104,[[["self"],["canonicalclassquery"]],["bool"]]],[11,"fmt","","",101,[[["self"],["formatter"]],["result"]]],[11,"next","","",101,[[["self"]],["option"]]],[0,"unicode_tables","regex_syntax","",N,N],[0,"age","regex_syntax::unicode_tables","",N,N],[17,"BY_NAME","regex_syntax::unicode_tables::age","",N,N],[17,"V10_0","","",N,N],[17,"V1_1","","",N,N],[17,"V2_0","","",N,N],[17,"V2_1","","",N,N],[17,"V3_0","","",N,N],[17,"V3_1","","",N,N],[17,"V3_2","","",N,N],[17,"V4_0","","",N,N],[17,"V4_1","","",N,N],[17,"V5_0","","",N,N],[17,"V5_1","","",N,N],[17,"V5_2","","",N,N],[17,"V6_0","","",N,N],[17,"V6_1","","",N,N],[17,"V6_2","","",N,N],[17,"V6_3","","",N,N],[17,"V7_0","","",N,N],[17,"V8_0","","",N,N],[17,"V9_0","","",N,N],[0,"case_folding_simple","regex_syntax::unicode_tables","",N,N],[17,"CASE_FOLDING_SIMPLE","regex_syntax::unicode_tables::case_folding_simple","",N,N],[0,"general_category","regex_syntax::unicode_tables","",N,N],[17,"BY_NAME","regex_syntax::unicode_tables::general_category","",N,N],[17,"CASED_LETTER","","",N,N],[17,"CLOSE_PUNCTUATION","","",N,N],[17,"CONNECTOR_PUNCTUATION","","",N,N],[17,"CONTROL","","",N,N],[17,"CURRENCY_SYMBOL","","",N,N],[17,"DASH_PUNCTUATION","","",N,N],[17,"DECIMAL_NUMBER","","",N,N],[17,"ENCLOSING_MARK","","",N,N],[17,"FINAL_PUNCTUATION","","",N,N],[17,"FORMAT","","",N,N],[17,"INITIAL_PUNCTUATION","","",N,N],[17,"LETTER","","",N,N],[17,"LETTER_NUMBER","","",N,N],[17,"LINE_SEPARATOR","","",N,N],[17,"LOWERCASE_LETTER","","",N,N],[17,"MARK","","",N,N],[17,"MATH_SYMBOL","","",N,N],[17,"MODIFIER_LETTER","","",N,N],[17,"MODIFIER_SYMBOL","","",N,N],[17,"NONSPACING_MARK","","",N,N],[17,"NUMBER","","",N,N],[17,"OPEN_PUNCTUATION","","",N,N],[17,"OTHER","","",N,N],[17,"OTHER_LETTER","","",N,N],[17,"OTHER_NUMBER","","",N,N],[17,"OTHER_PUNCTUATION","","",N,N],[17,"OTHER_SYMBOL","","",N,N],[17,"PARAGRAPH_SEPARATOR","","",N,N],[17,"PRIVATE_USE","","",N,N],[17,"PUNCTUATION","","",N,N],[17,"SEPARATOR","","",N,N],[17,"SPACE_SEPARATOR","","",N,N],[17,"SPACING_MARK","","",N,N],[17,"SYMBOL","","",N,N],[17,"TITLECASE_LETTER","","",N,N],[17,"UNASSIGNED","","",N,N],[17,"UPPERCASE_LETTER","","",N,N],[0,"perl_word","regex_syntax::unicode_tables","",N,N],[17,"PERL_WORD","regex_syntax::unicode_tables::perl_word","",N,N],[0,"property_bool","regex_syntax::unicode_tables","",N,N],[17,"BY_NAME","regex_syntax::unicode_tables::property_bool","",N,N],[17,"ASCII_HEX_DIGIT","","",N,N],[17,"ALPHABETIC","","",N,N],[17,"BIDI_CONTROL","","",N,N],[17,"CASE_IGNORABLE","","",N,N],[17,"CASED","","",N,N],[17,"CHANGES_WHEN_CASEFOLDED","","",N,N],[17,"CHANGES_WHEN_CASEMAPPED","","",N,N],[17,"CHANGES_WHEN_LOWERCASED","","",N,N],[17,"CHANGES_WHEN_TITLECASED","","",N,N],[17,"CHANGES_WHEN_UPPERCASED","","",N,N],[17,"DASH","","",N,N],[17,"DEFAULT_IGNORABLE_CODE_POINT","","",N,N],[17,"DEPRECATED","","",N,N],[17,"DIACRITIC","","",N,N],[17,"EXTENDER","","",N,N],[17,"GRAPHEME_BASE","","",N,N],[17,"GRAPHEME_EXTEND","","",N,N],[17,"GRAPHEME_LINK","","",N,N],[17,"HEX_DIGIT","","",N,N],[17,"HYPHEN","","",N,N],[17,"IDS_BINARY_OPERATOR","","",N,N],[17,"IDS_TRINARY_OPERATOR","","",N,N],[17,"ID_CONTINUE","","",N,N],[17,"ID_START","","",N,N],[17,"IDEOGRAPHIC","","",N,N],[17,"JOIN_CONTROL","","",N,N],[17,"LOGICAL_ORDER_EXCEPTION","","",N,N],[17,"LOWERCASE","","",N,N],[17,"MATH","","",N,N],[17,"NONCHARACTER_CODE_POINT","","",N,N],[17,"OTHER_ALPHABETIC","","",N,N],[17,"OTHER_DEFAULT_IGNORABLE_CODE_POINT","","",N,N],[17,"OTHER_GRAPHEME_EXTEND","","",N,N],[17,"OTHER_ID_CONTINUE","","",N,N],[17,"OTHER_ID_START","","",N,N],[17,"OTHER_LOWERCASE","","",N,N],[17,"OTHER_MATH","","",N,N],[17,"OTHER_UPPERCASE","","",N,N],[17,"PATTERN_SYNTAX","","",N,N],[17,"PATTERN_WHITE_SPACE","","",N,N],[17,"PREPENDED_CONCATENATION_MARK","","",N,N],[17,"QUOTATION_MARK","","",N,N],[17,"RADICAL","","",N,N],[17,"REGIONAL_INDICATOR","","",N,N],[17,"SENTENCE_TERMINAL","","",N,N],[17,"SOFT_DOTTED","","",N,N],[17,"TERMINAL_PUNCTUATION","","",N,N],[17,"UNIFIED_IDEOGRAPH","","",N,N],[17,"UPPERCASE","","",N,N],[17,"VARIATION_SELECTOR","","",N,N],[17,"WHITE_SPACE","","",N,N],[17,"XID_CONTINUE","","",N,N],[17,"XID_START","","",N,N],[0,"property_names","regex_syntax::unicode_tables","",N,N],[17,"PROPERTY_NAMES","regex_syntax::unicode_tables::property_names","",N,N],[0,"property_values","regex_syntax::unicode_tables","",N,N],[17,"PROPERTY_VALUES","regex_syntax::unicode_tables::property_values","",N,N],[0,"script_extension","regex_syntax::unicode_tables","",N,N],[17,"BY_NAME","regex_syntax::unicode_tables::script_extension","",N,N],[17,"ADLAM","","",N,N],[17,"AHOM","","",N,N],[17,"ANATOLIAN_HIEROGLYPHS","","",N,N],[17,"ARABIC","","",N,N],[17,"ARMENIAN","","",N,N],[17,"AVESTAN","","",N,N],[17,"BALINESE","","",N,N],[17,"BAMUM","","",N,N],[17,"BASSA_VAH","","",N,N],[17,"BATAK","","",N,N],[17,"BENGALI","","",N,N],[17,"BHAIKSUKI","","",N,N],[17,"BOPOMOFO","","",N,N],[17,"BRAHMI","","",N,N],[17,"BRAILLE","","",N,N],[17,"BUGINESE","","",N,N],[17,"BUHID","","",N,N],[17,"CANADIAN_ABORIGINAL","","",N,N],[17,"CARIAN","","",N,N],[17,"CAUCASIAN_ALBANIAN","","",N,N],[17,"CHAKMA","","",N,N],[17,"CHAM","","",N,N],[17,"CHEROKEE","","",N,N],[17,"COMMON","","",N,N],[17,"COPTIC","","",N,N],[17,"CUNEIFORM","","",N,N],[17,"CYPRIOT","","",N,N],[17,"CYRILLIC","","",N,N],[17,"DESERET","","",N,N],[17,"DEVANAGARI","","",N,N],[17,"DUPLOYAN","","",N,N],[17,"EGYPTIAN_HIEROGLYPHS","","",N,N],[17,"ELBASAN","","",N,N],[17,"ETHIOPIC","","",N,N],[17,"GEORGIAN","","",N,N],[17,"GLAGOLITIC","","",N,N],[17,"GOTHIC","","",N,N],[17,"GRANTHA","","",N,N],[17,"GREEK","","",N,N],[17,"GUJARATI","","",N,N],[17,"GURMUKHI","","",N,N],[17,"HAN","","",N,N],[17,"HANGUL","","",N,N],[17,"HANUNOO","","",N,N],[17,"HATRAN","","",N,N],[17,"HEBREW","","",N,N],[17,"HIRAGANA","","",N,N],[17,"IMPERIAL_ARAMAIC","","",N,N],[17,"INHERITED","","",N,N],[17,"INSCRIPTIONAL_PAHLAVI","","",N,N],[17,"INSCRIPTIONAL_PARTHIAN","","",N,N],[17,"JAVANESE","","",N,N],[17,"KAITHI","","",N,N],[17,"KANNADA","","",N,N],[17,"KATAKANA","","",N,N],[17,"KAYAH_LI","","",N,N],[17,"KHAROSHTHI","","",N,N],[17,"KHMER","","",N,N],[17,"KHOJKI","","",N,N],[17,"KHUDAWADI","","",N,N],[17,"LAO","","",N,N],[17,"LATIN","","",N,N],[17,"LEPCHA","","",N,N],[17,"LIMBU","","",N,N],[17,"LINEAR_A","","",N,N],[17,"LINEAR_B","","",N,N],[17,"LISU","","",N,N],[17,"LYCIAN","","",N,N],[17,"LYDIAN","","",N,N],[17,"MAHAJANI","","",N,N],[17,"MALAYALAM","","",N,N],[17,"MANDAIC","","",N,N],[17,"MANICHAEAN","","",N,N],[17,"MARCHEN","","",N,N],[17,"MASARAM_GONDI","","",N,N],[17,"MEETEI_MAYEK","","",N,N],[17,"MENDE_KIKAKUI","","",N,N],[17,"MEROITIC_CURSIVE","","",N,N],[17,"MEROITIC_HIEROGLYPHS","","",N,N],[17,"MIAO","","",N,N],[17,"MODI","","",N,N],[17,"MONGOLIAN","","",N,N],[17,"MRO","","",N,N],[17,"MULTANI","","",N,N],[17,"MYANMAR","","",N,N],[17,"NABATAEAN","","",N,N],[17,"NEW_TAI_LUE","","",N,N],[17,"NEWA","","",N,N],[17,"NKO","","",N,N],[17,"NUSHU","","",N,N],[17,"OGHAM","","",N,N],[17,"OL_CHIKI","","",N,N],[17,"OLD_HUNGARIAN","","",N,N],[17,"OLD_ITALIC","","",N,N],[17,"OLD_NORTH_ARABIAN","","",N,N],[17,"OLD_PERMIC","","",N,N],[17,"OLD_PERSIAN","","",N,N],[17,"OLD_SOUTH_ARABIAN","","",N,N],[17,"OLD_TURKIC","","",N,N],[17,"ORIYA","","",N,N],[17,"OSAGE","","",N,N],[17,"OSMANYA","","",N,N],[17,"PAHAWH_HMONG","","",N,N],[17,"PALMYRENE","","",N,N],[17,"PAU_CIN_HAU","","",N,N],[17,"PHAGS_PA","","",N,N],[17,"PHOENICIAN","","",N,N],[17,"PSALTER_PAHLAVI","","",N,N],[17,"REJANG","","",N,N],[17,"RUNIC","","",N,N],[17,"SAMARITAN","","",N,N],[17,"SAURASHTRA","","",N,N],[17,"SHARADA","","",N,N],[17,"SHAVIAN","","",N,N],[17,"SIDDHAM","","",N,N],[17,"SIGNWRITING","","",N,N],[17,"SINHALA","","",N,N],[17,"SORA_SOMPENG","","",N,N],[17,"SOYOMBO","","",N,N],[17,"SUNDANESE","","",N,N],[17,"SYLOTI_NAGRI","","",N,N],[17,"SYRIAC","","",N,N],[17,"TAGALOG","","",N,N],[17,"TAGBANWA","","",N,N],[17,"TAI_LE","","",N,N],[17,"TAI_THAM","","",N,N],[17,"TAI_VIET","","",N,N],[17,"TAKRI","","",N,N],[17,"TAMIL","","",N,N],[17,"TANGUT","","",N,N],[17,"TELUGU","","",N,N],[17,"THAANA","","",N,N],[17,"THAI","","",N,N],[17,"TIBETAN","","",N,N],[17,"TIFINAGH","","",N,N],[17,"TIRHUTA","","",N,N],[17,"UGARITIC","","",N,N],[17,"VAI","","",N,N],[17,"WARANG_CITI","","",N,N],[17,"YI","","",N,N],[17,"ZANABAZAR_SQUARE","","",N,N],[0,"script","regex_syntax::unicode_tables","",N,N],[17,"BY_NAME","regex_syntax::unicode_tables::script","",N,N],[17,"ADLAM","","",N,N],[17,"AHOM","","",N,N],[17,"ANATOLIAN_HIEROGLYPHS","","",N,N],[17,"ARABIC","","",N,N],[17,"ARMENIAN","","",N,N],[17,"AVESTAN","","",N,N],[17,"BALINESE","","",N,N],[17,"BAMUM","","",N,N],[17,"BASSA_VAH","","",N,N],[17,"BATAK","","",N,N],[17,"BENGALI","","",N,N],[17,"BHAIKSUKI","","",N,N],[17,"BOPOMOFO","","",N,N],[17,"BRAHMI","","",N,N],[17,"BRAILLE","","",N,N],[17,"BUGINESE","","",N,N],[17,"BUHID","","",N,N],[17,"CANADIAN_ABORIGINAL","","",N,N],[17,"CARIAN","","",N,N],[17,"CAUCASIAN_ALBANIAN","","",N,N],[17,"CHAKMA","","",N,N],[17,"CHAM","","",N,N],[17,"CHEROKEE","","",N,N],[17,"COMMON","","",N,N],[17,"COPTIC","","",N,N],[17,"CUNEIFORM","","",N,N],[17,"CYPRIOT","","",N,N],[17,"CYRILLIC","","",N,N],[17,"DESERET","","",N,N],[17,"DEVANAGARI","","",N,N],[17,"DUPLOYAN","","",N,N],[17,"EGYPTIAN_HIEROGLYPHS","","",N,N],[17,"ELBASAN","","",N,N],[17,"ETHIOPIC","","",N,N],[17,"GEORGIAN","","",N,N],[17,"GLAGOLITIC","","",N,N],[17,"GOTHIC","","",N,N],[17,"GRANTHA","","",N,N],[17,"GREEK","","",N,N],[17,"GUJARATI","","",N,N],[17,"GURMUKHI","","",N,N],[17,"HAN","","",N,N],[17,"HANGUL","","",N,N],[17,"HANUNOO","","",N,N],[17,"HATRAN","","",N,N],[17,"HEBREW","","",N,N],[17,"HIRAGANA","","",N,N],[17,"IMPERIAL_ARAMAIC","","",N,N],[17,"INHERITED","","",N,N],[17,"INSCRIPTIONAL_PAHLAVI","","",N,N],[17,"INSCRIPTIONAL_PARTHIAN","","",N,N],[17,"JAVANESE","","",N,N],[17,"KAITHI","","",N,N],[17,"KANNADA","","",N,N],[17,"KATAKANA","","",N,N],[17,"KAYAH_LI","","",N,N],[17,"KHAROSHTHI","","",N,N],[17,"KHMER","","",N,N],[17,"KHOJKI","","",N,N],[17,"KHUDAWADI","","",N,N],[17,"LAO","","",N,N],[17,"LATIN","","",N,N],[17,"LEPCHA","","",N,N],[17,"LIMBU","","",N,N],[17,"LINEAR_A","","",N,N],[17,"LINEAR_B","","",N,N],[17,"LISU","","",N,N],[17,"LYCIAN","","",N,N],[17,"LYDIAN","","",N,N],[17,"MAHAJANI","","",N,N],[17,"MALAYALAM","","",N,N],[17,"MANDAIC","","",N,N],[17,"MANICHAEAN","","",N,N],[17,"MARCHEN","","",N,N],[17,"MASARAM_GONDI","","",N,N],[17,"MEETEI_MAYEK","","",N,N],[17,"MENDE_KIKAKUI","","",N,N],[17,"MEROITIC_CURSIVE","","",N,N],[17,"MEROITIC_HIEROGLYPHS","","",N,N],[17,"MIAO","","",N,N],[17,"MODI","","",N,N],[17,"MONGOLIAN","","",N,N],[17,"MRO","","",N,N],[17,"MULTANI","","",N,N],[17,"MYANMAR","","",N,N],[17,"NABATAEAN","","",N,N],[17,"NEW_TAI_LUE","","",N,N],[17,"NEWA","","",N,N],[17,"NKO","","",N,N],[17,"NUSHU","","",N,N],[17,"OGHAM","","",N,N],[17,"OL_CHIKI","","",N,N],[17,"OLD_HUNGARIAN","","",N,N],[17,"OLD_ITALIC","","",N,N],[17,"OLD_NORTH_ARABIAN","","",N,N],[17,"OLD_PERMIC","","",N,N],[17,"OLD_PERSIAN","","",N,N],[17,"OLD_SOUTH_ARABIAN","","",N,N],[17,"OLD_TURKIC","","",N,N],[17,"ORIYA","","",N,N],[17,"OSAGE","","",N,N],[17,"OSMANYA","","",N,N],[17,"PAHAWH_HMONG","","",N,N],[17,"PALMYRENE","","",N,N],[17,"PAU_CIN_HAU","","",N,N],[17,"PHAGS_PA","","",N,N],[17,"PHOENICIAN","","",N,N],[17,"PSALTER_PAHLAVI","","",N,N],[17,"REJANG","","",N,N],[17,"RUNIC","","",N,N],[17,"SAMARITAN","","",N,N],[17,"SAURASHTRA","","",N,N],[17,"SHARADA","","",N,N],[17,"SHAVIAN","","",N,N],[17,"SIDDHAM","","",N,N],[17,"SIGNWRITING","","",N,N],[17,"SINHALA","","",N,N],[17,"SORA_SOMPENG","","",N,N],[17,"SOYOMBO","","",N,N],[17,"SUNDANESE","","",N,N],[17,"SYLOTI_NAGRI","","",N,N],[17,"SYRIAC","","",N,N],[17,"TAGALOG","","",N,N],[17,"TAGBANWA","","",N,N],[17,"TAI_LE","","",N,N],[17,"TAI_THAM","","",N,N],[17,"TAI_VIET","","",N,N],[17,"TAKRI","","",N,N],[17,"TAMIL","","",N,N],[17,"TANGUT","","",N,N],[17,"TELUGU","","",N,N],[17,"THAANA","","",N,N],[17,"THAI","","",N,N],[17,"TIBETAN","","",N,N],[17,"TIFINAGH","","",N,N],[17,"TIRHUTA","","",N,N],[17,"UGARITIC","","",N,N],[17,"VAI","","",N,N],[17,"WARANG_CITI","","",N,N],[17,"YI","","",N,N],[17,"ZANABAZAR_SQUARE","","",N,N],[6,"Result","regex_syntax","A type alias for dealing with errors returned by this crate.",N,N]],"paths":[[3,"Parser"],[3,"ParserBuilder"],[4,"Error"],[3,"Error"],[3,"Span"],[3,"Position"],[3,"WithComments"],[3,"Comment"],[3,"Alternation"],[3,"Concat"],[3,"Literal"],[3,"ClassPerl"],[3,"ClassAscii"],[3,"ClassUnicode"],[3,"ClassBracketed"],[3,"ClassSetRange"],[3,"ClassSetUnion"],[3,"ClassSetBinaryOp"],[3,"Assertion"],[3,"Repetition"],[3,"RepetitionOp"],[3,"Group"],[3,"CaptureName"],[3,"SetFlags"],[3,"Flags"],[3,"FlagsItem"],[4,"ErrorKind"],[4,"Ast"],[4,"LiteralKind"],[4,"SpecialLiteralKind"],[4,"HexLiteralKind"],[4,"Class"],[4,"ClassPerlKind"],[4,"ClassAsciiKind"],[4,"ClassUnicodeKind"],[4,"ClassUnicodeOpKind"],[4,"ClassSet"],[4,"ClassSetItem"],[4,"ClassSetBinaryOpKind"],[4,"AssertionKind"],[4,"RepetitionKind"],[4,"RepetitionRange"],[4,"GroupKind"],[4,"FlagsItemKind"],[4,"Flag"],[3,"ParserBuilder"],[3,"Parser"],[3,"ParserI"],[3,"NestLimiter"],[4,"Primitive"],[4,"GroupState"],[4,"ClassState"],[3,"PrinterBuilder"],[3,"Printer"],[3,"Writer"],[3,"HeapVisitor"],[4,"Frame"],[4,"ClassFrame"],[4,"ClassInduct"],[8,"Visitor"],[4,"Either"],[3,"Formatter"],[3,"Spans"],[3,"Error"],[3,"Hir"],[3,"ClassUnicode"],[3,"ClassUnicodeIter"],[3,"ClassUnicodeRange"],[3,"ClassBytes"],[3,"ClassBytesIter"],[3,"ClassBytesRange"],[3,"Group"],[3,"Repetition"],[3,"HirInfo"],[4,"ErrorKind"],[4,"HirKind"],[4,"Literal"],[4,"Class"],[4,"Anchor"],[4,"WordBoundary"],[4,"GroupKind"],[4,"RepetitionKind"],[4,"RepetitionRange"],[3,"IntervalSet"],[3,"IntervalSetIter"],[8,"Interval"],[8,"Bound"],[3,"Literals"],[3,"Literal"],[3,"PrinterBuilder"],[3,"Printer"],[3,"Writer"],[3,"TranslatorBuilder"],[3,"Translator"],[3,"TranslatorI"],[3,"Flags"],[4,"HirFrame"],[3,"HeapVisitor"],[4,"Frame"],[8,"Visitor"],[3,"SimpleFoldIter"],[3,"AgeIter"],[4,"Error"],[4,"ClassQuery"],[4,"CanonicalClassQuery"]]};
searchIndex["remove_dir_all"]={"doc":"","items":[[5,"remove_dir_all","remove_dir_all","Removes a directory at this path, after removing all its contents. Use carefully!",N,[[["p"]],["result",["error"]]]]],"paths":[]};
searchIndex["rustc"]={"doc":"The \"main crate\" of the Rust compiler. This crate contains common type definitions that are used by the other crates in the rustc \"family\". Some prominent examples (note that each of these modules has their own README with further details).","items":[[0,"macros","rustc","",N,N],[0,"diagnostics","","",N,N],[0,"__register_diagnostic_E0038","rustc::diagnostics","",N,N],[0,"__register_diagnostic_E0072","","",N,N],[0,"__register_diagnostic_E0080","","",N,N],[0,"__register_diagnostic_E0106","","",N,N],[0,"__register_diagnostic_E0119","","",N,N],[0,"__register_diagnostic_E0136","","",N,N],[0,"__register_diagnostic_E0137","","",N,N],[0,"__register_diagnostic_E0138","","",N,N],[0,"__register_diagnostic_E0139","","",N,N],[0,"__register_diagnostic_E0152","","",N,N],[0,"__register_diagnostic_E0214","","",N,N],[0,"__register_diagnostic_E0230","","",N,N],[0,"__register_diagnostic_E0231","","",N,N],[0,"__register_diagnostic_E0232","","",N,N],[0,"__register_diagnostic_E0261","","",N,N],[0,"__register_diagnostic_E0262","","",N,N],[0,"__register_diagnostic_E0263","","",N,N],[0,"__register_diagnostic_E0264","","",N,N],[0,"__register_diagnostic_E0271","","",N,N],[0,"__register_diagnostic_E0275","","",N,N],[0,"__register_diagnostic_E0276","","",N,N],[0,"__register_diagnostic_E0277","","",N,N],[0,"__register_diagnostic_E0281","","",N,N],[0,"__register_diagnostic_E0282","","",N,N],[0,"__register_diagnostic_E0283","","",N,N],[0,"__register_diagnostic_E0296","","",N,N],[0,"__register_diagnostic_E0308","","",N,N],[0,"__register_diagnostic_E0309","","",N,N],[0,"__register_diagnostic_E0310","","",N,N],[0,"__register_diagnostic_E0317","","",N,N],[0,"__register_diagnostic_E0391","","",N,N],[0,"__register_diagnostic_E0398","","",N,N],[0,"__register_diagnostic_E0452","","",N,N],[0,"__register_diagnostic_E0453","","",N,N],[0,"__register_diagnostic_E0478","","",N,N],[0,"__register_diagnostic_E0491","","",N,N],[0,"__register_diagnostic_E0496","","",N,N],[0,"__register_diagnostic_E0497","","",N,N],[0,"__register_diagnostic_E0512","","",N,N],[0,"__register_diagnostic_E0517","","",N,N],[0,"__register_diagnostic_E0518","","",N,N],[0,"__register_diagnostic_E0522","","",N,N],[0,"__register_diagnostic_E0525","","",N,N],[0,"__register_diagnostic_E0580","","",N,N],[0,"__register_diagnostic_E0562","","",N,N],[0,"__register_diagnostic_E0591","","",N,N],[0,"__register_diagnostic_E0593","","",N,N],[0,"__register_diagnostic_E0601","","",N,N],[0,"__register_diagnostic_E0602","","",N,N],[0,"__register_diagnostic_E0621","","",N,N],[0,"__register_diagnostic_E0644","","",N,N],[0,"__register_diagnostic_E0692","","",N,N],[0,"__register_diagnostic_E0700","","",N,N],[0,"__register_diagnostic_E0701","","",N,N],[0,"__register_diagnostic_E0702","","",N,N],[0,"__register_diagnostic_E0278","","",N,N],[0,"__register_diagnostic_E0279","","",N,N],[0,"__register_diagnostic_E0280","","",N,N],[0,"__register_diagnostic_E0284","","",N,N],[0,"__register_diagnostic_E0311","","",N,N],[0,"__register_diagnostic_E0312","","",N,N],[0,"__register_diagnostic_E0313","","",N,N],[0,"__register_diagnostic_E0314","","",N,N],[0,"__register_diagnostic_E0315","","",N,N],[0,"__register_diagnostic_E0316","","",N,N],[0,"__register_diagnostic_E0320","","",N,N],[0,"__register_diagnostic_E0473","","",N,N],[0,"__register_diagnostic_E0474","","",N,N],[0,"__register_diagnostic_E0475","","",N,N],[0,"__register_diagnostic_E0476","","",N,N],[0,"__register_diagnostic_E0477","","",N,N],[0,"__register_diagnostic_E0479","","",N,N],[0,"__register_diagnostic_E0480","","",N,N],[0,"__register_diagnostic_E0481","","",N,N],[0,"__register_diagnostic_E0482","","",N,N],[0,"__register_diagnostic_E0483","","",N,N],[0,"__register_diagnostic_E0484","","",N,N],[0,"__register_diagnostic_E0485","","",N,N],[0,"__register_diagnostic_E0486","","",N,N],[0,"__register_diagnostic_E0487","","",N,N],[0,"__register_diagnostic_E0488","","",N,N],[0,"__register_diagnostic_E0489","","",N,N],[0,"__register_diagnostic_E0490","","",N,N],[0,"__register_diagnostic_E0495","","",N,N],[0,"__register_diagnostic_E0566","","",N,N],[0,"__register_diagnostic_E0623","","",N,N],[0,"__register_diagnostic_E0628","","",N,N],[0,"__register_diagnostic_E0631","","",N,N],[0,"__register_diagnostic_E0637","","",N,N],[0,"__register_diagnostic_E0657","","",N,N],[0,"__register_diagnostic_E0687","","",N,N],[0,"__register_diagnostic_E0688","","",N,N],[0,"__register_diagnostic_E0697","","",N,N],[0,"__register_diagnostic_E0707","","",N,N],[0,"__register_diagnostic_E0708","","",N,N],[0,"__register_diagnostic_E0709","","",N,N],[0,"__register_diagnostic_E0710","","",N,N],[0,"cfg","rustc","Module that constructs a control-flow graph representing an item. Uses `Graph` as the underlying representation.",N,N],[3,"CFG","rustc::cfg","",N,N],[12,"owner_def_id","","",0,N],[12,"graph","","",0,N],[12,"entry","","",0,N],[12,"exit","","",0,N],[3,"CFGEdgeData","","",N,N],[12,"exiting_scopes","","",1,N],[4,"CFGNodeData","","",N,N],[13,"AST","","",2,N],[13,"Entry","","",2,N],[13,"Exit","","",2,N],[13,"Dummy","","",2,N],[13,"Unreachable","","",2,N],[0,"construct","","",N,N],[3,"CFGBuilder","rustc::cfg::construct","",N,N],[12,"tcx","","",3,N],[12,"owner_def_id","","",3,N],[12,"tables","","",3,N],[12,"graph","","",3,N],[12,"fn_exit","","",3,N],[12,"loop_scopes","","",3,N],[12,"breakable_block_scopes","","",3,N],[3,"BlockScope","","",N,N],[12,"block_expr_id","","",4,N],[12,"break_index","","",4,N],[3,"LoopScope","","",N,N],[12,"loop_id","","",5,N],[12,"continue_index","","",5,N],[12,"break_index","","",5,N],[4,"ScopeCfKind","","",N,N],[13,"Break","","",6,N],[13,"Continue","","",6,N],[5,"construct","","",N,[[["tyctxt"],["body"]],["cfg"]]],[11,"clone","","",4,[[["self"]],["blockscope"]]],[11,"clone","","",5,[[["self"]],["loopscope"]]],[11,"block","","",3,[[["self"],["block"],["cfgindex"]],["cfgindex"]]],[11,"stmt","","",3,[[["self"],["stmt"],["cfgindex"]],["cfgindex"]]],[11,"decl","","",3,[[["self"],["decl"],["cfgindex"]],["cfgindex"]]],[11,"pat","","",3,[[["self"],["pat"],["cfgindex"]],["cfgindex"]]],[11,"pats_all","","Handles case where all of the patterns must match.",3,[[["self"],["i"],["cfgindex"]],["cfgindex"]]],[11,"expr","","",3,[[["self"],["expr"],["cfgindex"]],["cfgindex"]]],[11,"call","","",3,[[["self"],["expr"],["cfgindex"],["expr"],["i"]],["cfgindex"]]],[11,"exprs","","Constructs graph for `exprs` evaluated in order",3,[[["self"],["i"],["cfgindex"]],["cfgindex"]]],[11,"opt_expr","","Constructs graph for `opt_expr` evaluated, if Some",3,[[["self"],["option"],["cfgindex"]],["cfgindex"]]],[11,"straightline","","Handles case of an expression that evaluates `subexprs` in order",3,[[["self"],["expr"],["cfgindex"],["i"]],["cfgindex"]]],[11,"match_","","",3,N],[11,"add_dummy_node","","",3,N],[11,"add_ast_node","","",3,N],[11,"add_unreachable_node","","",3,[[["self"]],["cfgindex"]]],[11,"add_node","","",3,N],[11,"add_contained_edge","","",3,[[["self"],["cfgindex"],["cfgindex"]]]],[11,"add_exiting_edge","","",3,[[["self"],["expr"],["cfgindex"],["scope"],["cfgindex"]]]],[11,"add_returning_edge","","",3,[[["self"],["expr"],["cfgindex"]]]],[11,"find_scope_edge","","",3,N],[11,"clone","","",6,[[["self"]],["scopecfkind"]]],[11,"assert_receiver_is_total_eq","","",6,N],[11,"eq","","",6,[[["self"],["scopecfkind"]],["bool"]]],[0,"graphviz","rustc::cfg","",N,N],[3,"LabelledCFG","rustc::cfg::graphviz","",N,N],[12,"tcx","","",7,N],[12,"cfg","","",7,N],[12,"name","","",7,N],[12,"labelled_edges","","`labelled_edges` controls whether we emit labels on the edges",7,N],[6,"Node","","",N,N],[6,"Edge","","",N,N],[11,"local_id_to_string","","",7,[[["self"],["itemlocalid"]],["string"]]],[11,"graph_id","","",7,[[["self"]],["id"]]],[11,"node_id","","",7,[[["self"],["node"]],["id"]]],[11,"node_label","","",7,[[["self"],["node"]],["labeltext"]]],[11,"edge_label","","",7,[[["self"],["edge"]],["labeltext"]]],[11,"nodes","","",7,[[["self"]],["nodes",["node"]]]],[11,"edges","","",7,[[["self"]],["edges",["edge"]]]],[11,"source","","",7,[[["self"],["edge"]],["node"]]],[11,"target","","",7,[[["self"],["edge"]],["node"]]],[6,"CFGIndex","rustc::cfg","",N,N],[6,"CFGGraph","","",N,N],[6,"CFGNode","","",N,N],[6,"CFGEdge","","",N,N],[11,"clone","","",2,[[["self"]],["cfgnodedata"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"eq","","",2,[[["self"],["cfgnodedata"]],["bool"]]],[11,"ne","","",2,[[["self"],["cfgnodedata"]],["bool"]]],[11,"id","","",2,[[["self"]],["itemlocalid"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"new","","",0,[[["tyctxt"],["body"]],["cfg"]]],[11,"node_is_reachable","","",0,[[["self"],["itemlocalid"]],["bool"]]],[0,"dep_graph","rustc","",N,N],[3,"DepTrackingMap","rustc::dep_graph","A DepTrackingMap offers a subset of the `Map` API and ensures that we make calls to `read` and `write` as appropriate. We key the maps with a unique type for brevity.",N,N],[12,"phantom","","",8,N],[12,"graph","","",8,N],[12,"map","","",8,N],[3,"DepNode","","",N,N],[12,"kind","","",9,N],[12,"hash","","",9,N],[3,"WorkProductId","","A \"work product\" corresponds to a `.o` (or other) file that we save in between runs. These ids do not have a DefId but rather some independent path or string that persists between runs without the need to be mapped or unmapped. (This ensures we can serialize them even in the absence of a tcx.)",N,N],[12,"hash","","",10,N],[3,"DepGraph","","",N,N],[12,"data","","",11,N],[12,"fingerprints","","",11,N],[3,"WorkProduct","","A \"work product\" is an intermediate result that we save into the incremental directory for later re-use. The primary example are the object files that we save for each partition at code generation time.",N,N],[12,"cgu_name","","",12,N],[12,"saved_files","","Saved files associated with this CGU",12,N],[3,"DepNodeIndex","","",N,N],[12,"0","","",13,N],[3,"PreviousDepGraph","","",N,N],[12,"data","","",14,N],[12,"index","","",14,N],[3,"DepGraphQuery","","",N,N],[12,"graph","","",15,N],[12,"indices","","",15,N],[3,"AssertDepGraphSafe","","A convenient override that lets you pass arbitrary state into a task. Every use should be accompanied by a comment explaining why it makes sense (or how it could be refactored away in the future).",N,N],[12,"0","","",16,N],[3,"SerializedDepGraph","","Data for use when recompiling the current crate.",N,N],[12,"nodes","","The set of all DepNodes in the graph",17,N],[12,"fingerprints","","The set of all Fingerprints in the graph. Each Fingerprint corresponds to the DepNode at the same index in the nodes vector.",17,N],[12,"edge_list_indices","","For each DepNode, stores the list of edges originating from that DepNode. Encoded as a [start, end) pair indexing into edge_list_data, which holds the actual DepNodeIndices of the target nodes.",17,N],[12,"edge_list_data","","A flattened list of all edge targets in the graph. Edge sources are implicit in edge_list_indices.",17,N],[3,"SerializedDepNodeIndex","","",N,N],[12,"0","","",18,N],[4,"DepKind","","",N,N],[13,"Null","","",19,N],[13,"Krate","","",19,N],[13,"HirBody","","",19,N],[13,"Hir","","",19,N],[13,"CrateMetadata","","",19,N],[13,"RegionScopeTree","","",19,N],[13,"Coherence","","",19,N],[13,"CoherenceInherentImplOverlapCheck","","",19,N],[13,"CoherenceCheckTrait","","",19,N],[13,"PrivacyAccessLevels","","",19,N],[13,"MirConstQualif","","",19,N],[13,"MirBuilt","","",19,N],[13,"MirConst","","",19,N],[13,"MirValidated","","",19,N],[13,"MirOptimized","","",19,N],[13,"MirShim","","",19,N],[13,"BorrowCheckKrate","","",19,N],[13,"BorrowCheck","","",19,N],[13,"MirBorrowCheck","","",19,N],[13,"UnsafetyCheckResult","","",19,N],[13,"UnsafeDeriveOnReprPacked","","",19,N],[13,"Reachability","","",19,N],[13,"MirKeys","","",19,N],[13,"CrateVariances","","",19,N],[13,"AssociatedItems","","",19,N],[13,"TypeOfItem","","",19,N],[13,"GenericsOfItem","","",19,N],[13,"PredicatesOfItem","","",19,N],[13,"ExplicitPredicatesOfItem","","",19,N],[13,"PredicatesDefinedOnItem","","",19,N],[13,"InferredOutlivesOf","","",19,N],[13,"InferredOutlivesCrate","","",19,N],[13,"SuperPredicatesOfItem","","",19,N],[13,"TraitDefOfItem","","",19,N],[13,"AdtDefOfItem","","",19,N],[13,"ImplTraitRef","","",19,N],[13,"ImplPolarity","","",19,N],[13,"FnSignature","","",19,N],[13,"CoerceUnsizedInfo","","",19,N],[13,"ItemVarianceConstraints","","",19,N],[13,"ItemVariances","","",19,N],[13,"IsConstFn","","",19,N],[13,"IsForeignItem","","",19,N],[13,"TypeParamPredicates","","",19,N],[13,"SizedConstraint","","",19,N],[13,"DtorckConstraint","","",19,N],[13,"AdtDestructor","","",19,N],[13,"AssociatedItemDefIds","","",19,N],[13,"InherentImpls","","",19,N],[13,"TypeckBodiesKrate","","",19,N],[13,"TypeckTables","","",19,N],[13,"UsedTraitImports","","",19,N],[13,"HasTypeckTables","","",19,N],[13,"ConstEval","","",19,N],[13,"CheckMatch","","",19,N],[13,"SymbolName","","",19,N],[13,"InstanceSymbolName","","",19,N],[13,"SpecializationGraph","","",19,N],[13,"ObjectSafety","","",19,N],[13,"FulfillObligation","","",19,N],[13,"VtableMethods","","",19,N],[13,"IsCopy","","",19,N],[13,"IsSized","","",19,N],[13,"IsFreeze","","",19,N],[13,"NeedsDrop","","",19,N],[13,"Layout","","",19,N],[13,"TraitImpls","","",19,N],[13,"AllLocalTraitImpls","","",19,N],[13,"TraitSelect","","",19,N],[13,"ParamEnv","","",19,N],[13,"DescribeDef","","",19,N],[13,"DefSpan","","",19,N],[13,"LookupStability","","",19,N],[13,"LookupDeprecationEntry","","",19,N],[13,"ConstIsRvaluePromotableToStatic","","",19,N],[13,"RvaluePromotableMap","","",19,N],[13,"ImplParent","","",19,N],[13,"TraitOfItem","","",19,N],[13,"IsReachableNonGeneric","","",19,N],[13,"IsUnreachableLocalDefinition","","",19,N],[13,"IsMirAvailable","","",19,N],[13,"ItemAttrs","","",19,N],[13,"CodegenFnAttrs","","",19,N],[13,"FnArgNames","","",19,N],[13,"RenderedConst","","",19,N],[13,"DylibDepFormats","","",19,N],[13,"IsPanicRuntime","","",19,N],[13,"IsCompilerBuiltins","","",19,N],[13,"HasGlobalAllocator","","",19,N],[13,"ExternCrate","","",19,N],[13,"LintLevels","","",19,N],[13,"Specializes","","",19,N],[13,"InScopeTraits","","",19,N],[13,"ModuleExports","","",19,N],[13,"IsSanitizerRuntime","","",19,N],[13,"IsProfilerRuntime","","",19,N],[13,"GetPanicStrategy","","",19,N],[13,"IsNoBuiltins","","",19,N],[13,"ImplDefaultness","","",19,N],[13,"CheckItemWellFormed","","",19,N],[13,"CheckTraitItemWellFormed","","",19,N],[13,"CheckImplItemWellFormed","","",19,N],[13,"ReachableNonGenerics","","",19,N],[13,"NativeLibraries","","",19,N],[13,"PluginRegistrarFn","","",19,N],[13,"DeriveRegistrarFn","","",19,N],[13,"CrateDisambiguator","","",19,N],[13,"CrateHash","","",19,N],[13,"OriginalCrateName","","",19,N],[13,"ExtraFileName","","",19,N],[13,"ImplementationsOfTrait","","",19,N],[13,"AllTraitImplementations","","",19,N],[13,"DllimportForeignItems","","",19,N],[13,"IsDllimportForeignItem","","",19,N],[13,"IsStaticallyIncludedForeignItem","","",19,N],[13,"NativeLibraryKind","","",19,N],[13,"LinkArgs","","",19,N],[13,"ResolveLifetimes","","",19,N],[13,"NamedRegion","","",19,N],[13,"IsLateBound","","",19,N],[13,"ObjectLifetimeDefaults","","",19,N],[13,"Visibility","","",19,N],[13,"DepKind","","",19,N],[13,"CrateName","","",19,N],[13,"ItemChildren","","",19,N],[13,"ExternModStmtCnum","","",19,N],[13,"GetLangItems","","",19,N],[13,"DefinedLangItems","","",19,N],[13,"MissingLangItems","","",19,N],[13,"VisibleParentMap","","",19,N],[13,"MissingExternCrateItem","","",19,N],[13,"UsedCrateSource","","",19,N],[13,"PostorderCnums","","",19,N],[13,"EraseRegionsTy","","",19,N],[13,"ConstValueToAllocation","","",19,N],[13,"Freevars","","",19,N],[13,"MaybeUnusedTraitImport","","",19,N],[13,"MaybeUnusedExternCrates","","",19,N],[13,"StabilityIndex","","",19,N],[13,"AllTraits","","",19,N],[13,"AllCrateNums","","",19,N],[13,"ExportedSymbols","","",19,N],[13,"CollectAndPartitionMonoItems","","",19,N],[13,"IsCodegenedItem","","",19,N],[13,"CodegenUnit","","",19,N],[13,"CompileCodegenUnit","","",19,N],[13,"OutputFilenames","","",19,N],[13,"NormalizeProjectionTy","","",19,N],[13,"NormalizeTyAfterErasingRegions","","",19,N],[13,"ImpliedOutlivesBounds","","",19,N],[13,"DropckOutlives","","",19,N],[13,"EvaluateObligation","","",19,N],[13,"TypeOpEq","","",19,N],[13,"TypeOpSubtype","","",19,N],[13,"TypeOpProvePredicate","","",19,N],[13,"TypeOpNormalizeTy","","",19,N],[13,"TypeOpNormalizePredicate","","",19,N],[13,"TypeOpNormalizePolyFnSig","","",19,N],[13,"TypeOpNormalizeFnSig","","",19,N],[13,"SubstituteNormalizeAndTestPredicates","","",19,N],[13,"TargetFeaturesWhitelist","","",19,N],[13,"InstanceDefSizeEstimate","","",19,N],[13,"Features","","",19,N],[13,"ProgramClausesFor","","",19,N],[13,"ProgramClausesForEnv","","",19,N],[13,"WasmImportModuleMap","","",19,N],[13,"ForeignModules","","",19,N],[13,"UpstreamMonomorphizations","","",19,N],[13,"UpstreamMonomorphizationsFor","","",19,N],[4,"DepConstructor","","",N,N],[13,"Null","","",20,N],[13,"Krate","","",20,N],[13,"HirBody","","",20,N],[13,"Hir","","",20,N],[13,"CrateMetadata","","",20,N],[13,"RegionScopeTree","","",20,N],[13,"Coherence","","",20,N],[13,"CoherenceInherentImplOverlapCheck","","",20,N],[13,"CoherenceCheckTrait","","",20,N],[13,"PrivacyAccessLevels","","",20,N],[13,"MirConstQualif","","",20,N],[13,"MirBuilt","","",20,N],[13,"MirConst","","",20,N],[13,"MirValidated","","",20,N],[13,"MirOptimized","","",20,N],[13,"MirShim","","",20,N],[12,"instance_def","rustc::dep_graph::DepConstructor","",20,N],[13,"BorrowCheckKrate","rustc::dep_graph","",20,N],[13,"BorrowCheck","","",20,N],[13,"MirBorrowCheck","","",20,N],[13,"UnsafetyCheckResult","","",20,N],[13,"UnsafeDeriveOnReprPacked","","",20,N],[13,"Reachability","","",20,N],[13,"MirKeys","","",20,N],[13,"CrateVariances","","",20,N],[13,"AssociatedItems","","",20,N],[13,"TypeOfItem","","",20,N],[13,"GenericsOfItem","","",20,N],[13,"PredicatesOfItem","","",20,N],[13,"ExplicitPredicatesOfItem","","",20,N],[13,"PredicatesDefinedOnItem","","",20,N],[13,"InferredOutlivesOf","","",20,N],[13,"InferredOutlivesCrate","","",20,N],[13,"SuperPredicatesOfItem","","",20,N],[13,"TraitDefOfItem","","",20,N],[13,"AdtDefOfItem","","",20,N],[13,"ImplTraitRef","","",20,N],[13,"ImplPolarity","","",20,N],[13,"FnSignature","","",20,N],[13,"CoerceUnsizedInfo","","",20,N],[13,"ItemVarianceConstraints","","",20,N],[13,"ItemVariances","","",20,N],[13,"IsConstFn","","",20,N],[13,"IsForeignItem","","",20,N],[13,"TypeParamPredicates","","",20,N],[12,"item_id","rustc::dep_graph::DepConstructor","",20,N],[12,"param_id","","",20,N],[13,"SizedConstraint","rustc::dep_graph","",20,N],[13,"DtorckConstraint","","",20,N],[13,"AdtDestructor","","",20,N],[13,"AssociatedItemDefIds","","",20,N],[13,"InherentImpls","","",20,N],[13,"TypeckBodiesKrate","","",20,N],[13,"TypeckTables","","",20,N],[13,"UsedTraitImports","","",20,N],[13,"HasTypeckTables","","",20,N],[13,"ConstEval","","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"CheckMatch","rustc::dep_graph","",20,N],[13,"SymbolName","","",20,N],[13,"InstanceSymbolName","","",20,N],[12,"instance","rustc::dep_graph::DepConstructor","",20,N],[13,"SpecializationGraph","rustc::dep_graph","",20,N],[13,"ObjectSafety","","",20,N],[13,"FulfillObligation","","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[12,"trait_ref","","",20,N],[13,"VtableMethods","rustc::dep_graph","",20,N],[12,"trait_ref","rustc::dep_graph::DepConstructor","",20,N],[13,"IsCopy","rustc::dep_graph","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"IsSized","rustc::dep_graph","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"IsFreeze","rustc::dep_graph","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"NeedsDrop","rustc::dep_graph","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"Layout","rustc::dep_graph","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"TraitImpls","rustc::dep_graph","",20,N],[13,"AllLocalTraitImpls","","",20,N],[13,"TraitSelect","","",20,N],[13,"ParamEnv","","",20,N],[13,"DescribeDef","","",20,N],[13,"DefSpan","","",20,N],[13,"LookupStability","","",20,N],[13,"LookupDeprecationEntry","","",20,N],[13,"ConstIsRvaluePromotableToStatic","","",20,N],[13,"RvaluePromotableMap","","",20,N],[13,"ImplParent","","",20,N],[13,"TraitOfItem","","",20,N],[13,"IsReachableNonGeneric","","",20,N],[13,"IsUnreachableLocalDefinition","","",20,N],[13,"IsMirAvailable","","",20,N],[13,"ItemAttrs","","",20,N],[13,"CodegenFnAttrs","","",20,N],[13,"FnArgNames","","",20,N],[13,"RenderedConst","","",20,N],[13,"DylibDepFormats","","",20,N],[13,"IsPanicRuntime","","",20,N],[13,"IsCompilerBuiltins","","",20,N],[13,"HasGlobalAllocator","","",20,N],[13,"ExternCrate","","",20,N],[13,"LintLevels","","",20,N],[13,"Specializes","","",20,N],[12,"impl1","rustc::dep_graph::DepConstructor","",20,N],[12,"impl2","","",20,N],[13,"InScopeTraits","rustc::dep_graph","",20,N],[13,"ModuleExports","","",20,N],[13,"IsSanitizerRuntime","","",20,N],[13,"IsProfilerRuntime","","",20,N],[13,"GetPanicStrategy","","",20,N],[13,"IsNoBuiltins","","",20,N],[13,"ImplDefaultness","","",20,N],[13,"CheckItemWellFormed","","",20,N],[13,"CheckTraitItemWellFormed","","",20,N],[13,"CheckImplItemWellFormed","","",20,N],[13,"ReachableNonGenerics","","",20,N],[13,"NativeLibraries","","",20,N],[13,"PluginRegistrarFn","","",20,N],[13,"DeriveRegistrarFn","","",20,N],[13,"CrateDisambiguator","","",20,N],[13,"CrateHash","","",20,N],[13,"OriginalCrateName","","",20,N],[13,"ExtraFileName","","",20,N],[13,"ImplementationsOfTrait","","",20,N],[12,"krate","rustc::dep_graph::DepConstructor","",20,N],[12,"trait_id","","",20,N],[13,"AllTraitImplementations","rustc::dep_graph","",20,N],[13,"DllimportForeignItems","","",20,N],[13,"IsDllimportForeignItem","","",20,N],[13,"IsStaticallyIncludedForeignItem","","",20,N],[13,"NativeLibraryKind","","",20,N],[13,"LinkArgs","","",20,N],[13,"ResolveLifetimes","","",20,N],[13,"NamedRegion","","",20,N],[13,"IsLateBound","","",20,N],[13,"ObjectLifetimeDefaults","","",20,N],[13,"Visibility","","",20,N],[13,"DepKind","","",20,N],[13,"CrateName","","",20,N],[13,"ItemChildren","","",20,N],[13,"ExternModStmtCnum","","",20,N],[13,"GetLangItems","","",20,N],[13,"DefinedLangItems","","",20,N],[13,"MissingLangItems","","",20,N],[13,"VisibleParentMap","","",20,N],[13,"MissingExternCrateItem","","",20,N],[13,"UsedCrateSource","","",20,N],[13,"PostorderCnums","","",20,N],[13,"EraseRegionsTy","","",20,N],[12,"ty","rustc::dep_graph::DepConstructor","",20,N],[13,"ConstValueToAllocation","rustc::dep_graph","",20,N],[12,"val","rustc::dep_graph::DepConstructor","",20,N],[13,"Freevars","rustc::dep_graph","",20,N],[13,"MaybeUnusedTraitImport","","",20,N],[13,"MaybeUnusedExternCrates","","",20,N],[13,"StabilityIndex","","",20,N],[13,"AllTraits","","",20,N],[13,"AllCrateNums","","",20,N],[13,"ExportedSymbols","","",20,N],[13,"CollectAndPartitionMonoItems","","",20,N],[13,"IsCodegenedItem","","",20,N],[13,"CodegenUnit","","",20,N],[13,"CompileCodegenUnit","","",20,N],[13,"OutputFilenames","","",20,N],[13,"NormalizeProjectionTy","","",20,N],[13,"NormalizeTyAfterErasingRegions","","",20,N],[13,"ImpliedOutlivesBounds","","",20,N],[13,"DropckOutlives","","",20,N],[13,"EvaluateObligation","","",20,N],[13,"TypeOpEq","","",20,N],[13,"TypeOpSubtype","","",20,N],[13,"TypeOpProvePredicate","","",20,N],[13,"TypeOpNormalizeTy","","",20,N],[13,"TypeOpNormalizePredicate","","",20,N],[13,"TypeOpNormalizePolyFnSig","","",20,N],[13,"TypeOpNormalizeFnSig","","",20,N],[13,"SubstituteNormalizeAndTestPredicates","","",20,N],[12,"key","rustc::dep_graph::DepConstructor","",20,N],[13,"TargetFeaturesWhitelist","rustc::dep_graph","",20,N],[13,"InstanceDefSizeEstimate","","",20,N],[12,"instance_def","rustc::dep_graph::DepConstructor","",20,N],[13,"Features","rustc::dep_graph","",20,N],[13,"ProgramClausesFor","","",20,N],[13,"ProgramClausesForEnv","","",20,N],[13,"WasmImportModuleMap","","",20,N],[13,"ForeignModules","","",20,N],[13,"UpstreamMonomorphizations","","",20,N],[13,"UpstreamMonomorphizationsFor","","",20,N],[4,"DepNodeColor","","",N,N],[13,"Red","","",21,N],[13,"Green","","",21,N],[4,"OpenTask","","",N,N],[13,"Regular","","",22,N],[13,"Anon","","",22,N],[13,"Ignore","","",22,N],[13,"EvalAlways","","",22,N],[12,"node","rustc::dep_graph::OpenTask","",22,N],[4,"WorkProductFileKind","rustc::dep_graph","",N,N],[13,"Object","","",23,N],[13,"Bytecode","","",23,N],[13,"BytecodeCompressed","","",23,N],[0,"debug","","Code for debugging the dep-graph.",N,N],[3,"DepNodeFilter","rustc::dep_graph::debug","A dep-node filter goes from a user-defined string to a query over nodes. Right now the format is like this:",N,N],[12,"text","","",24,N],[3,"EdgeFilter","","A filter like `F -> G` where `F` and `G` are valid dep-node filters. This can be used to test the source/target independently.",N,N],[12,"source","","",25,N],[12,"target","","",25,N],[11,"fmt","","",24,[[["self"],["formatter"]],["result"]]],[11,"new","","",24,[[["str"]],["self"]]],[11,"accepts_all","","True if all nodes always pass the filter.",24,[[["self"]],["bool"]]],[11,"test","","Tests whether `node` meets the filter, returning true if so.",24,[[["self"],["depnode"]],["bool"]]],[11,"new","","",25,[[["str"]],["result",["edgefilter","box"]]]],[11,"test","","",25,[[["self"],["depnode"],["depnode"]],["bool"]]],[0,"dep_node","rustc::dep_graph","This module defines the `DepNode` type which the compiler uses to represent nodes in the dependency graph. A `DepNode` consists of a `DepKind` (which specifies the kind of thing it represents, like a piece of HIR, MIR, etc) and a `Fingerprint`, a 128 bit hash value the exact meaning of which depends on the node's `DepKind`. Together, the kind and the fingerprint fully identify a dependency node, even across multiple compilation sessions. In other words, the value of the fingerprint does not depend on anything that is specific to a given compilation session, like an unpredictable interning key (e.g. NodeId, DefId, Symbol) or the numeric value of a pointer. The concept behind this could be compared to how git commit hashes uniquely identify a given commit and has a few advantages:",N,N],[3,"DepNode","rustc::dep_graph::dep_node","",N,N],[12,"kind","","",9,N],[12,"hash","","",9,N],[3,"WorkProductId","","A \"work product\" corresponds to a `.o` (or other) file that we save in between runs. These ids do not have a DefId but rather some independent path or string that persists between runs without the need to be mapped or unmapped. (This ensures we can serialize them even in the absence of a tcx.)",N,N],[12,"hash","","",10,N],[4,"DepKind","","",N,N],[13,"Null","","",19,N],[13,"Krate","","",19,N],[13,"HirBody","","",19,N],[13,"Hir","","",19,N],[13,"CrateMetadata","","",19,N],[13,"RegionScopeTree","","",19,N],[13,"Coherence","","",19,N],[13,"CoherenceInherentImplOverlapCheck","","",19,N],[13,"CoherenceCheckTrait","","",19,N],[13,"PrivacyAccessLevels","","",19,N],[13,"MirConstQualif","","",19,N],[13,"MirBuilt","","",19,N],[13,"MirConst","","",19,N],[13,"MirValidated","","",19,N],[13,"MirOptimized","","",19,N],[13,"MirShim","","",19,N],[13,"BorrowCheckKrate","","",19,N],[13,"BorrowCheck","","",19,N],[13,"MirBorrowCheck","","",19,N],[13,"UnsafetyCheckResult","","",19,N],[13,"UnsafeDeriveOnReprPacked","","",19,N],[13,"Reachability","","",19,N],[13,"MirKeys","","",19,N],[13,"CrateVariances","","",19,N],[13,"AssociatedItems","","",19,N],[13,"TypeOfItem","","",19,N],[13,"GenericsOfItem","","",19,N],[13,"PredicatesOfItem","","",19,N],[13,"ExplicitPredicatesOfItem","","",19,N],[13,"PredicatesDefinedOnItem","","",19,N],[13,"InferredOutlivesOf","","",19,N],[13,"InferredOutlivesCrate","","",19,N],[13,"SuperPredicatesOfItem","","",19,N],[13,"TraitDefOfItem","","",19,N],[13,"AdtDefOfItem","","",19,N],[13,"ImplTraitRef","","",19,N],[13,"ImplPolarity","","",19,N],[13,"FnSignature","","",19,N],[13,"CoerceUnsizedInfo","","",19,N],[13,"ItemVarianceConstraints","","",19,N],[13,"ItemVariances","","",19,N],[13,"IsConstFn","","",19,N],[13,"IsForeignItem","","",19,N],[13,"TypeParamPredicates","","",19,N],[13,"SizedConstraint","","",19,N],[13,"DtorckConstraint","","",19,N],[13,"AdtDestructor","","",19,N],[13,"AssociatedItemDefIds","","",19,N],[13,"InherentImpls","","",19,N],[13,"TypeckBodiesKrate","","",19,N],[13,"TypeckTables","","",19,N],[13,"UsedTraitImports","","",19,N],[13,"HasTypeckTables","","",19,N],[13,"ConstEval","","",19,N],[13,"CheckMatch","","",19,N],[13,"SymbolName","","",19,N],[13,"InstanceSymbolName","","",19,N],[13,"SpecializationGraph","","",19,N],[13,"ObjectSafety","","",19,N],[13,"FulfillObligation","","",19,N],[13,"VtableMethods","","",19,N],[13,"IsCopy","","",19,N],[13,"IsSized","","",19,N],[13,"IsFreeze","","",19,N],[13,"NeedsDrop","","",19,N],[13,"Layout","","",19,N],[13,"TraitImpls","","",19,N],[13,"AllLocalTraitImpls","","",19,N],[13,"TraitSelect","","",19,N],[13,"ParamEnv","","",19,N],[13,"DescribeDef","","",19,N],[13,"DefSpan","","",19,N],[13,"LookupStability","","",19,N],[13,"LookupDeprecationEntry","","",19,N],[13,"ConstIsRvaluePromotableToStatic","","",19,N],[13,"RvaluePromotableMap","","",19,N],[13,"ImplParent","","",19,N],[13,"TraitOfItem","","",19,N],[13,"IsReachableNonGeneric","","",19,N],[13,"IsUnreachableLocalDefinition","","",19,N],[13,"IsMirAvailable","","",19,N],[13,"ItemAttrs","","",19,N],[13,"CodegenFnAttrs","","",19,N],[13,"FnArgNames","","",19,N],[13,"RenderedConst","","",19,N],[13,"DylibDepFormats","","",19,N],[13,"IsPanicRuntime","","",19,N],[13,"IsCompilerBuiltins","","",19,N],[13,"HasGlobalAllocator","","",19,N],[13,"ExternCrate","","",19,N],[13,"LintLevels","","",19,N],[13,"Specializes","","",19,N],[13,"InScopeTraits","","",19,N],[13,"ModuleExports","","",19,N],[13,"IsSanitizerRuntime","","",19,N],[13,"IsProfilerRuntime","","",19,N],[13,"GetPanicStrategy","","",19,N],[13,"IsNoBuiltins","","",19,N],[13,"ImplDefaultness","","",19,N],[13,"CheckItemWellFormed","","",19,N],[13,"CheckTraitItemWellFormed","","",19,N],[13,"CheckImplItemWellFormed","","",19,N],[13,"ReachableNonGenerics","","",19,N],[13,"NativeLibraries","","",19,N],[13,"PluginRegistrarFn","","",19,N],[13,"DeriveRegistrarFn","","",19,N],[13,"CrateDisambiguator","","",19,N],[13,"CrateHash","","",19,N],[13,"OriginalCrateName","","",19,N],[13,"ExtraFileName","","",19,N],[13,"ImplementationsOfTrait","","",19,N],[13,"AllTraitImplementations","","",19,N],[13,"DllimportForeignItems","","",19,N],[13,"IsDllimportForeignItem","","",19,N],[13,"IsStaticallyIncludedForeignItem","","",19,N],[13,"NativeLibraryKind","","",19,N],[13,"LinkArgs","","",19,N],[13,"ResolveLifetimes","","",19,N],[13,"NamedRegion","","",19,N],[13,"IsLateBound","","",19,N],[13,"ObjectLifetimeDefaults","","",19,N],[13,"Visibility","","",19,N],[13,"DepKind","","",19,N],[13,"CrateName","","",19,N],[13,"ItemChildren","","",19,N],[13,"ExternModStmtCnum","","",19,N],[13,"GetLangItems","","",19,N],[13,"DefinedLangItems","","",19,N],[13,"MissingLangItems","","",19,N],[13,"VisibleParentMap","","",19,N],[13,"MissingExternCrateItem","","",19,N],[13,"UsedCrateSource","","",19,N],[13,"PostorderCnums","","",19,N],[13,"EraseRegionsTy","","",19,N],[13,"ConstValueToAllocation","","",19,N],[13,"Freevars","","",19,N],[13,"MaybeUnusedTraitImport","","",19,N],[13,"MaybeUnusedExternCrates","","",19,N],[13,"StabilityIndex","","",19,N],[13,"AllTraits","","",19,N],[13,"AllCrateNums","","",19,N],[13,"ExportedSymbols","","",19,N],[13,"CollectAndPartitionMonoItems","","",19,N],[13,"IsCodegenedItem","","",19,N],[13,"CodegenUnit","","",19,N],[13,"CompileCodegenUnit","","",19,N],[13,"OutputFilenames","","",19,N],[13,"NormalizeProjectionTy","","",19,N],[13,"NormalizeTyAfterErasingRegions","","",19,N],[13,"ImpliedOutlivesBounds","","",19,N],[13,"DropckOutlives","","",19,N],[13,"EvaluateObligation","","",19,N],[13,"TypeOpEq","","",19,N],[13,"TypeOpSubtype","","",19,N],[13,"TypeOpProvePredicate","","",19,N],[13,"TypeOpNormalizeTy","","",19,N],[13,"TypeOpNormalizePredicate","","",19,N],[13,"TypeOpNormalizePolyFnSig","","",19,N],[13,"TypeOpNormalizeFnSig","","",19,N],[13,"SubstituteNormalizeAndTestPredicates","","",19,N],[13,"TargetFeaturesWhitelist","","",19,N],[13,"InstanceDefSizeEstimate","","",19,N],[13,"Features","","",19,N],[13,"ProgramClausesFor","","",19,N],[13,"ProgramClausesForEnv","","",19,N],[13,"WasmImportModuleMap","","",19,N],[13,"ForeignModules","","",19,N],[13,"UpstreamMonomorphizations","","",19,N],[13,"UpstreamMonomorphizationsFor","","",19,N],[4,"DepConstructor","","",N,N],[13,"Null","","",20,N],[13,"Krate","","",20,N],[13,"HirBody","","",20,N],[13,"Hir","","",20,N],[13,"CrateMetadata","","",20,N],[13,"RegionScopeTree","","",20,N],[13,"Coherence","","",20,N],[13,"CoherenceInherentImplOverlapCheck","","",20,N],[13,"CoherenceCheckTrait","","",20,N],[13,"PrivacyAccessLevels","","",20,N],[13,"MirConstQualif","","",20,N],[13,"MirBuilt","","",20,N],[13,"MirConst","","",20,N],[13,"MirValidated","","",20,N],[13,"MirOptimized","","",20,N],[13,"MirShim","","",20,N],[12,"instance_def","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"BorrowCheckKrate","rustc::dep_graph::dep_node","",20,N],[13,"BorrowCheck","","",20,N],[13,"MirBorrowCheck","","",20,N],[13,"UnsafetyCheckResult","","",20,N],[13,"UnsafeDeriveOnReprPacked","","",20,N],[13,"Reachability","","",20,N],[13,"MirKeys","","",20,N],[13,"CrateVariances","","",20,N],[13,"AssociatedItems","","",20,N],[13,"TypeOfItem","","",20,N],[13,"GenericsOfItem","","",20,N],[13,"PredicatesOfItem","","",20,N],[13,"ExplicitPredicatesOfItem","","",20,N],[13,"PredicatesDefinedOnItem","","",20,N],[13,"InferredOutlivesOf","","",20,N],[13,"InferredOutlivesCrate","","",20,N],[13,"SuperPredicatesOfItem","","",20,N],[13,"TraitDefOfItem","","",20,N],[13,"AdtDefOfItem","","",20,N],[13,"ImplTraitRef","","",20,N],[13,"ImplPolarity","","",20,N],[13,"FnSignature","","",20,N],[13,"CoerceUnsizedInfo","","",20,N],[13,"ItemVarianceConstraints","","",20,N],[13,"ItemVariances","","",20,N],[13,"IsConstFn","","",20,N],[13,"IsForeignItem","","",20,N],[13,"TypeParamPredicates","","",20,N],[12,"item_id","rustc::dep_graph::dep_node::DepConstructor","",20,N],[12,"param_id","","",20,N],[13,"SizedConstraint","rustc::dep_graph::dep_node","",20,N],[13,"DtorckConstraint","","",20,N],[13,"AdtDestructor","","",20,N],[13,"AssociatedItemDefIds","","",20,N],[13,"InherentImpls","","",20,N],[13,"TypeckBodiesKrate","","",20,N],[13,"TypeckTables","","",20,N],[13,"UsedTraitImports","","",20,N],[13,"HasTypeckTables","","",20,N],[13,"ConstEval","","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"CheckMatch","rustc::dep_graph::dep_node","",20,N],[13,"SymbolName","","",20,N],[13,"InstanceSymbolName","","",20,N],[12,"instance","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"SpecializationGraph","rustc::dep_graph::dep_node","",20,N],[13,"ObjectSafety","","",20,N],[13,"FulfillObligation","","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[12,"trait_ref","","",20,N],[13,"VtableMethods","rustc::dep_graph::dep_node","",20,N],[12,"trait_ref","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"IsCopy","rustc::dep_graph::dep_node","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"IsSized","rustc::dep_graph::dep_node","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"IsFreeze","rustc::dep_graph::dep_node","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"NeedsDrop","rustc::dep_graph::dep_node","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"Layout","rustc::dep_graph::dep_node","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"TraitImpls","rustc::dep_graph::dep_node","",20,N],[13,"AllLocalTraitImpls","","",20,N],[13,"TraitSelect","","",20,N],[13,"ParamEnv","","",20,N],[13,"DescribeDef","","",20,N],[13,"DefSpan","","",20,N],[13,"LookupStability","","",20,N],[13,"LookupDeprecationEntry","","",20,N],[13,"ConstIsRvaluePromotableToStatic","","",20,N],[13,"RvaluePromotableMap","","",20,N],[13,"ImplParent","","",20,N],[13,"TraitOfItem","","",20,N],[13,"IsReachableNonGeneric","","",20,N],[13,"IsUnreachableLocalDefinition","","",20,N],[13,"IsMirAvailable","","",20,N],[13,"ItemAttrs","","",20,N],[13,"CodegenFnAttrs","","",20,N],[13,"FnArgNames","","",20,N],[13,"RenderedConst","","",20,N],[13,"DylibDepFormats","","",20,N],[13,"IsPanicRuntime","","",20,N],[13,"IsCompilerBuiltins","","",20,N],[13,"HasGlobalAllocator","","",20,N],[13,"ExternCrate","","",20,N],[13,"LintLevels","","",20,N],[13,"Specializes","","",20,N],[12,"impl1","rustc::dep_graph::dep_node::DepConstructor","",20,N],[12,"impl2","","",20,N],[13,"InScopeTraits","rustc::dep_graph::dep_node","",20,N],[13,"ModuleExports","","",20,N],[13,"IsSanitizerRuntime","","",20,N],[13,"IsProfilerRuntime","","",20,N],[13,"GetPanicStrategy","","",20,N],[13,"IsNoBuiltins","","",20,N],[13,"ImplDefaultness","","",20,N],[13,"CheckItemWellFormed","","",20,N],[13,"CheckTraitItemWellFormed","","",20,N],[13,"CheckImplItemWellFormed","","",20,N],[13,"ReachableNonGenerics","","",20,N],[13,"NativeLibraries","","",20,N],[13,"PluginRegistrarFn","","",20,N],[13,"DeriveRegistrarFn","","",20,N],[13,"CrateDisambiguator","","",20,N],[13,"CrateHash","","",20,N],[13,"OriginalCrateName","","",20,N],[13,"ExtraFileName","","",20,N],[13,"ImplementationsOfTrait","","",20,N],[12,"krate","rustc::dep_graph::dep_node::DepConstructor","",20,N],[12,"trait_id","","",20,N],[13,"AllTraitImplementations","rustc::dep_graph::dep_node","",20,N],[13,"DllimportForeignItems","","",20,N],[13,"IsDllimportForeignItem","","",20,N],[13,"IsStaticallyIncludedForeignItem","","",20,N],[13,"NativeLibraryKind","","",20,N],[13,"LinkArgs","","",20,N],[13,"ResolveLifetimes","","",20,N],[13,"NamedRegion","","",20,N],[13,"IsLateBound","","",20,N],[13,"ObjectLifetimeDefaults","","",20,N],[13,"Visibility","","",20,N],[13,"DepKind","","",20,N],[13,"CrateName","","",20,N],[13,"ItemChildren","","",20,N],[13,"ExternModStmtCnum","","",20,N],[13,"GetLangItems","","",20,N],[13,"DefinedLangItems","","",20,N],[13,"MissingLangItems","","",20,N],[13,"VisibleParentMap","","",20,N],[13,"MissingExternCrateItem","","",20,N],[13,"UsedCrateSource","","",20,N],[13,"PostorderCnums","","",20,N],[13,"EraseRegionsTy","","",20,N],[12,"ty","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"ConstValueToAllocation","rustc::dep_graph::dep_node","",20,N],[12,"val","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"Freevars","rustc::dep_graph::dep_node","",20,N],[13,"MaybeUnusedTraitImport","","",20,N],[13,"MaybeUnusedExternCrates","","",20,N],[13,"StabilityIndex","","",20,N],[13,"AllTraits","","",20,N],[13,"AllCrateNums","","",20,N],[13,"ExportedSymbols","","",20,N],[13,"CollectAndPartitionMonoItems","","",20,N],[13,"IsCodegenedItem","","",20,N],[13,"CodegenUnit","","",20,N],[13,"CompileCodegenUnit","","",20,N],[13,"OutputFilenames","","",20,N],[13,"NormalizeProjectionTy","","",20,N],[13,"NormalizeTyAfterErasingRegions","","",20,N],[13,"ImpliedOutlivesBounds","","",20,N],[13,"DropckOutlives","","",20,N],[13,"EvaluateObligation","","",20,N],[13,"TypeOpEq","","",20,N],[13,"TypeOpSubtype","","",20,N],[13,"TypeOpProvePredicate","","",20,N],[13,"TypeOpNormalizeTy","","",20,N],[13,"TypeOpNormalizePredicate","","",20,N],[13,"TypeOpNormalizePolyFnSig","","",20,N],[13,"TypeOpNormalizeFnSig","","",20,N],[13,"SubstituteNormalizeAndTestPredicates","","",20,N],[12,"key","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"TargetFeaturesWhitelist","rustc::dep_graph::dep_node","",20,N],[13,"InstanceDefSizeEstimate","","",20,N],[12,"instance_def","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"Features","rustc::dep_graph::dep_node","",20,N],[13,"ProgramClausesFor","","",20,N],[13,"ProgramClausesForEnv","","",20,N],[13,"WasmImportModuleMap","","",20,N],[13,"ForeignModules","","",20,N],[13,"UpstreamMonomorphizations","","",20,N],[13,"UpstreamMonomorphizationsFor","","",20,N],[0,"label_strs","","Contains variant => str representations for constructing DepNode groups for tests.",N,N],[17,"Null","rustc::dep_graph::dep_node::label_strs","",N,N],[17,"Krate","","",N,N],[17,"HirBody","","",N,N],[17,"Hir","","",N,N],[17,"CrateMetadata","","",N,N],[17,"RegionScopeTree","","",N,N],[17,"Coherence","","",N,N],[17,"CoherenceInherentImplOverlapCheck","","",N,N],[17,"CoherenceCheckTrait","","",N,N],[17,"PrivacyAccessLevels","","",N,N],[17,"MirConstQualif","","",N,N],[17,"MirBuilt","","",N,N],[17,"MirConst","","",N,N],[17,"MirValidated","","",N,N],[17,"MirOptimized","","",N,N],[17,"MirShim","","",N,N],[17,"BorrowCheckKrate","","",N,N],[17,"BorrowCheck","","",N,N],[17,"MirBorrowCheck","","",N,N],[17,"UnsafetyCheckResult","","",N,N],[17,"UnsafeDeriveOnReprPacked","","",N,N],[17,"Reachability","","",N,N],[17,"MirKeys","","",N,N],[17,"CrateVariances","","",N,N],[17,"AssociatedItems","","",N,N],[17,"TypeOfItem","","",N,N],[17,"GenericsOfItem","","",N,N],[17,"PredicatesOfItem","","",N,N],[17,"ExplicitPredicatesOfItem","","",N,N],[17,"PredicatesDefinedOnItem","","",N,N],[17,"InferredOutlivesOf","","",N,N],[17,"InferredOutlivesCrate","","",N,N],[17,"SuperPredicatesOfItem","","",N,N],[17,"TraitDefOfItem","","",N,N],[17,"AdtDefOfItem","","",N,N],[17,"ImplTraitRef","","",N,N],[17,"ImplPolarity","","",N,N],[17,"FnSignature","","",N,N],[17,"CoerceUnsizedInfo","","",N,N],[17,"ItemVarianceConstraints","","",N,N],[17,"ItemVariances","","",N,N],[17,"IsConstFn","","",N,N],[17,"IsForeignItem","","",N,N],[17,"TypeParamPredicates","","",N,N],[17,"SizedConstraint","","",N,N],[17,"DtorckConstraint","","",N,N],[17,"AdtDestructor","","",N,N],[17,"AssociatedItemDefIds","","",N,N],[17,"InherentImpls","","",N,N],[17,"TypeckBodiesKrate","","",N,N],[17,"TypeckTables","","",N,N],[17,"UsedTraitImports","","",N,N],[17,"HasTypeckTables","","",N,N],[17,"ConstEval","","",N,N],[17,"CheckMatch","","",N,N],[17,"SymbolName","","",N,N],[17,"InstanceSymbolName","","",N,N],[17,"SpecializationGraph","","",N,N],[17,"ObjectSafety","","",N,N],[17,"FulfillObligation","","",N,N],[17,"VtableMethods","","",N,N],[17,"IsCopy","","",N,N],[17,"IsSized","","",N,N],[17,"IsFreeze","","",N,N],[17,"NeedsDrop","","",N,N],[17,"Layout","","",N,N],[17,"TraitImpls","","",N,N],[17,"AllLocalTraitImpls","","",N,N],[17,"TraitSelect","","",N,N],[17,"ParamEnv","","",N,N],[17,"DescribeDef","","",N,N],[17,"DefSpan","","",N,N],[17,"LookupStability","","",N,N],[17,"LookupDeprecationEntry","","",N,N],[17,"ConstIsRvaluePromotableToStatic","","",N,N],[17,"RvaluePromotableMap","","",N,N],[17,"ImplParent","","",N,N],[17,"TraitOfItem","","",N,N],[17,"IsReachableNonGeneric","","",N,N],[17,"IsUnreachableLocalDefinition","","",N,N],[17,"IsMirAvailable","","",N,N],[17,"ItemAttrs","","",N,N],[17,"CodegenFnAttrs","","",N,N],[17,"FnArgNames","","",N,N],[17,"RenderedConst","","",N,N],[17,"DylibDepFormats","","",N,N],[17,"IsPanicRuntime","","",N,N],[17,"IsCompilerBuiltins","","",N,N],[17,"HasGlobalAllocator","","",N,N],[17,"ExternCrate","","",N,N],[17,"LintLevels","","",N,N],[17,"Specializes","","",N,N],[17,"InScopeTraits","","",N,N],[17,"ModuleExports","","",N,N],[17,"IsSanitizerRuntime","","",N,N],[17,"IsProfilerRuntime","","",N,N],[17,"GetPanicStrategy","","",N,N],[17,"IsNoBuiltins","","",N,N],[17,"ImplDefaultness","","",N,N],[17,"CheckItemWellFormed","","",N,N],[17,"CheckTraitItemWellFormed","","",N,N],[17,"CheckImplItemWellFormed","","",N,N],[17,"ReachableNonGenerics","","",N,N],[17,"NativeLibraries","","",N,N],[17,"PluginRegistrarFn","","",N,N],[17,"DeriveRegistrarFn","","",N,N],[17,"CrateDisambiguator","","",N,N],[17,"CrateHash","","",N,N],[17,"OriginalCrateName","","",N,N],[17,"ExtraFileName","","",N,N],[17,"ImplementationsOfTrait","","",N,N],[17,"AllTraitImplementations","","",N,N],[17,"DllimportForeignItems","","",N,N],[17,"IsDllimportForeignItem","","",N,N],[17,"IsStaticallyIncludedForeignItem","","",N,N],[17,"NativeLibraryKind","","",N,N],[17,"LinkArgs","","",N,N],[17,"ResolveLifetimes","","",N,N],[17,"NamedRegion","","",N,N],[17,"IsLateBound","","",N,N],[17,"ObjectLifetimeDefaults","","",N,N],[17,"Visibility","","",N,N],[17,"DepKind","","",N,N],[17,"CrateName","","",N,N],[17,"ItemChildren","","",N,N],[17,"ExternModStmtCnum","","",N,N],[17,"GetLangItems","","",N,N],[17,"DefinedLangItems","","",N,N],[17,"MissingLangItems","","",N,N],[17,"VisibleParentMap","","",N,N],[17,"MissingExternCrateItem","","",N,N],[17,"UsedCrateSource","","",N,N],[17,"PostorderCnums","","",N,N],[17,"EraseRegionsTy","","",N,N],[17,"ConstValueToAllocation","","",N,N],[17,"Freevars","","",N,N],[17,"MaybeUnusedTraitImport","","",N,N],[17,"MaybeUnusedExternCrates","","",N,N],[17,"StabilityIndex","","",N,N],[17,"AllTraits","","",N,N],[17,"AllCrateNums","","",N,N],[17,"ExportedSymbols","","",N,N],[17,"CollectAndPartitionMonoItems","","",N,N],[17,"IsCodegenedItem","","",N,N],[17,"CodegenUnit","","",N,N],[17,"CompileCodegenUnit","","",N,N],[17,"OutputFilenames","","",N,N],[17,"NormalizeProjectionTy","","",N,N],[17,"NormalizeTyAfterErasingRegions","","",N,N],[17,"ImpliedOutlivesBounds","","",N,N],[17,"DropckOutlives","","",N,N],[17,"EvaluateObligation","","",N,N],[17,"TypeOpEq","","",N,N],[17,"TypeOpSubtype","","",N,N],[17,"TypeOpProvePredicate","","",N,N],[17,"TypeOpNormalizeTy","","",N,N],[17,"TypeOpNormalizePredicate","","",N,N],[17,"TypeOpNormalizePolyFnSig","","",N,N],[17,"TypeOpNormalizeFnSig","","",N,N],[17,"SubstituteNormalizeAndTestPredicates","","",N,N],[17,"TargetFeaturesWhitelist","","",N,N],[17,"InstanceDefSizeEstimate","","",N,N],[17,"Features","","",N,N],[17,"ProgramClausesFor","","",N,N],[17,"ProgramClausesForEnv","","",N,N],[17,"WasmImportModuleMap","","",N,N],[17,"ForeignModules","","",N,N],[17,"UpstreamMonomorphizations","","",N,N],[17,"UpstreamMonomorphizationsFor","","",N,N],[8,"DepNodeParams","rustc::dep_graph::dep_node","",N,N],[18,"CAN_RECONSTRUCT_QUERY_KEY","","",26,N],[11,"to_fingerprint","","This method turns the parameters of a DepNodeConstructor into an opaque Fingerprint to be used in DepNode. Not all DepNodeParams support being turned into a Fingerprint (they don't need to if the corresponding DepNode is anonymous).",26,[[["self"],["tyctxt"]],["fingerprint"]]],[11,"to_debug_str","","",26,[[["self"],["tyctxt"]],["string"]]],[11,"fmt","rustc::dep_graph","",9,[[["self"],["formatter"]],["result"]]],[11,"fingerprint_needed_for_crate_hash","","",19,[[["self"]],["bool"]]],[11,"clone","","",19,[[["self"]],["depkind"]]],[11,"fmt","","",19,[[["self"],["formatter"]],["result"]]],[11,"eq","","",19,[[["self"],["depkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",19,N],[11,"partial_cmp","","",19,[[["self"],["depkind"]],["option",["ordering"]]]],[11,"cmp","","",19,[[["self"],["depkind"]],["ordering"]]],[11,"hash","","",19,N],[11,"encode","","",19,[[["self"],["__s"]],["result"]]],[11,"decode","","",19,[[["__d"]],["result",["depkind"]]]],[11,"can_reconstruct_query_key","","",19,[[["self"]],["bool"]]],[11,"is_anon","","",19,[[["self"]],["bool"]]],[11,"is_input","","",19,[[["self"]],["bool"]]],[11,"is_eval_always","","",19,[[["self"]],["bool"]]],[11,"has_params","","",19,[[["self"]],["bool"]]],[11,"clone","","",9,[[["self"]],["depnode"]]],[11,"eq","","",9,[[["self"],["depnode"]],["bool"]]],[11,"ne","","",9,[[["self"],["depnode"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",9,N],[11,"partial_cmp","","",9,[[["self"],["depnode"]],["option",["ordering"]]]],[11,"lt","","",9,[[["self"],["depnode"]],["bool"]]],[11,"le","","",9,[[["self"],["depnode"]],["bool"]]],[11,"gt","","",9,[[["self"],["depnode"]],["bool"]]],[11,"ge","","",9,[[["self"],["depnode"]],["bool"]]],[11,"cmp","","",9,[[["self"],["depnode"]],["ordering"]]],[11,"hash","","",9,N],[11,"encode","","",9,[[["self"],["__s"]],["result"]]],[11,"decode","","",9,[[["__d"]],["result",["depnode"]]]],[11,"new","","",9,[[["tyctxt"],["depconstructor"]],["depnode"]]],[11,"from_def_path_hash","","Construct a DepNode from the given DepKind and DefPathHash. This method will assert that the given DepKind actually requires a single DefId/DefPathHash parameter.",9,[[["depkind"],["defpathhash"]],["depnode"]]],[11,"new_no_params","","Create a new, parameterless DepNode. This method will assert that the DepNode corresponding to the given DepKind actually does not require any parameters.",9,[[["depkind"]],["depnode"]]],[11,"extract_def_id","","Extract the DefId corresponding to this DepNode. This will work if two conditions are met:",9,[[["self"],["tyctxt"]],["option",["defid"]]]],[11,"from_label_string","","Used in testing",9,[[["str"],["defpathhash"]],["result",["depnode"]]]],[11,"has_label_string","","Used in testing",9,[[["str"]],["bool"]]],[11,"clone","","",10,[[["self"]],["workproductid"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"eq","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"ne","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",10,N],[11,"partial_cmp","","",10,[[["self"],["workproductid"]],["option",["ordering"]]]],[11,"lt","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"le","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"gt","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"ge","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"cmp","","",10,[[["self"],["workproductid"]],["ordering"]]],[11,"hash","","",10,N],[11,"encode","","",10,[[["self"],["__s"]],["result"]]],[11,"decode","","",10,[[["__d"]],["result",["workproductid"]]]],[11,"from_cgu_name","","",10,[[["str"]],["workproductid"]]],[11,"from_fingerprint","","",10,[[["fingerprint"]],["workproductid"]]],[11,"hash_stable","","",10,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[0,"dep_tracking_map","","",N,N],[3,"DepTrackingMap","rustc::dep_graph::dep_tracking_map","A DepTrackingMap offers a subset of the `Map` API and ensures that we make calls to `read` and `write` as appropriate. We key the maps with a unique type for brevity.",N,N],[12,"phantom","","",8,N],[12,"graph","","",8,N],[12,"map","","",8,N],[8,"DepTrackingMapConfig","","",N,N],[16,"Key","","",27,N],[16,"Value","","",27,N],[10,"to_dep_kind","","",27,[[],["depkind"]]],[11,"new","rustc::dep_graph","",8,[[["depgraph"]],["deptrackingmap"]]],[0,"graph","","",N,N],[3,"DepGraph","rustc::dep_graph::graph","",N,N],[12,"data","","",11,N],[12,"fingerprints","","",11,N],[3,"DepNodeIndex","","",N,N],[12,"0","","",13,N],[3,"DepGraphData","","",N,N],[12,"current","","The new encoding of the dependency graph, optimized for red/green tracking. The `current` field is the dependency graph of only the current compilation session: We don't merge the previous dep-graph into current one anymore.",28,N],[12,"previous","","The dep-graph from the previous compilation session. It contains all nodes and edges as well as all fingerprints of nodes that have them.",28,N],[12,"colors","","",28,N],[12,"previous_work_products","","When we load, there may be `.o` files, cached mir, or other such things available to us. If we find that they are not dirty, we load the path to the file storing those work-products here into this map. We can later look for and extract that data.",28,N],[12,"dep_node_debug","","",28,N],[12,"loaded_from_cache","","",28,N],[3,"WorkProduct","","A \"work product\" is an intermediate result that we save into the incremental directory for later re-use. The primary example are the object files that we save for each partition at code generation time.",N,N],[12,"cgu_name","","",12,N],[12,"saved_files","","Saved files associated with this CGU",12,N],[3,"CurrentDepGraph","","",N,N],[12,"nodes","","",29,N],[12,"edges","","",29,N],[12,"node_to_node_index","","",29,N],[12,"forbidden_edge","","",29,N],[12,"anon_id_seed","","",29,N],[12,"total_read_count","","",29,N],[12,"total_duplicate_read_count","","",29,N],[3,"RegularOpenTask","","",N,N],[12,"node","","",30,N],[12,"reads","","",30,N],[12,"read_set","","",30,N],[3,"AnonOpenTask","","",N,N],[12,"reads","","",31,N],[12,"read_set","","",31,N],[3,"DepNodeColorMap","","",N,N],[12,"values","","",32,N],[4,"DepNodeColor","","",N,N],[13,"Red","","",21,N],[13,"Green","","",21,N],[4,"WorkProductFileKind","","",N,N],[13,"Object","","",23,N],[13,"Bytecode","","",23,N],[13,"BytecodeCompressed","","",23,N],[4,"OpenTask","","",N,N],[13,"Regular","","",22,N],[13,"Anon","","",22,N],[13,"Ignore","","",22,N],[13,"EvalAlways","","",22,N],[12,"node","rustc::dep_graph::graph::OpenTask","",22,N],[17,"COMPRESSED_NONE","rustc::dep_graph::graph","",N,N],[17,"COMPRESSED_RED","","",N,N],[17,"COMPRESSED_FIRST_GREEN","","",N,N],[11,"clone","rustc::dep_graph","",11,[[["self"]],["depgraph"]]],[11,"clone","","",13,[[["self"]],["depnodeindex"]]],[11,"eq","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"ne","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",13,N],[11,"hash","","",13,N],[11,"partial_cmp","","",13,[[["self"],["depnodeindex"]],["option",["ordering"]]]],[11,"lt","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"le","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"gt","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"ge","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"cmp","","",13,[[["self"],["depnodeindex"]],["ordering"]]],[11,"decode","","",13,[[["__d"]],["result",["depnodeindex"]]]],[11,"encode","","",13,[[["self"],["__s"]],["result"]]],[11,"new","","",13,[[["usize"]],["self"]]],[11,"index","","",13,[[["self"]],["usize"]]],[11,"steps_between","","",13,[[["self"],["self"]],["option",["usize"]]]],[11,"replace_one","","",13,[[["self"]],["self"]]],[11,"replace_zero","","",13,[[["self"]],["self"]]],[11,"add_one","","",13,[[["self"]],["self"]]],[11,"sub_one","","",13,[[["self"]],["self"]]],[11,"add_usize","","",13,[[["self"],["usize"]],["option"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[18,"INVALID","","",13,N],[11,"clone","","",21,[[["self"]],["depnodecolor"]]],[11,"fmt","","",21,[[["self"],["formatter"]],["result"]]],[11,"eq","","",21,[[["self"],["depnodecolor"]],["bool"]]],[11,"ne","","",21,[[["self"],["depnodecolor"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",21,N],[11,"hash","","",21,N],[11,"is_green","","",21,[[["self"]],["bool"]]],[11,"new","","",11,[[["previousdepgraph"],["fxhashmap",["workproductid","workproduct"]]],["depgraph"]]],[11,"new_disabled","","",11,[[],["depgraph"]]],[11,"is_fully_enabled","","True if we are actually building the full dep-graph.",11,[[["self"]],["bool"]]],[11,"query","","",11,[[["self"]],["depgraphquery"]]],[11,"assert_ignored","","",11,[[["self"]]]],[11,"with_ignore","","",11,[[["self"],["op"]],["r"]]],[11,"with_task","","Starts a new dep-graph task. Dep-graph tasks are specified using a free function (`task`) and not a closure -- this is intentional because we want to exercise tight control over what state they have access to. In particular, we want to prevent implicit 'leaks' of tracked state into the task (which could then be read without generating correct edges in the dep-graph -- see the [rustc guide] for more details on the dep-graph). To this end, the task function gets exactly two pieces of state: the context `cx` and an argument `arg`. Both of these bits of state must be of some type that implements `DepGraphSafe` and hence does not leak.",11,N],[11,"input_task","","Creates a new dep-graph input with value `input`",11,N],[11,"with_task_impl","","",11,N],[11,"with_anon_task","","Execute something within an \"anonymous\" task, that is, a task the DepNode of which is determined by the list of inputs it read from.",11,N],[11,"with_eval_always_task","","Execute something within an \"eval-always\" task which is a task",11,N],[11,"read","","",11,[[["self"],["depnode"]]]],[11,"read_index","","",11,[[["self"],["depnodeindex"]]]],[11,"dep_node_index_of","","",11,[[["self"],["depnode"]],["depnodeindex"]]],[11,"dep_node_exists","","",11,[[["self"],["depnode"]],["bool"]]],[11,"fingerprint_of","","",11,[[["self"],["depnodeindex"]],["fingerprint"]]],[11,"prev_fingerprint_of","","",11,[[["self"],["depnode"]],["option",["fingerprint"]]]],[11,"prev_dep_node_index_of","","",11,[[["self"],["depnode"]],["serializeddepnodeindex"]]],[11,"previous_work_product","","Check whether a previous work product exists for `v` and, if so, return the path that leads to it. Used to skip doing work.",11,[[["self"],["workproductid"]],["option",["workproduct"]]]],[11,"previous_work_products","","Access the map of work-products created during the cached run. Only used during saving of the dep-graph.",11,[[["self"]],["fxhashmap"]]],[11,"register_dep_node_debug_str","","",11,[[["self"],["depnode"],["f"]]]],[11,"dep_node_debug_str","","",11,[[["self"],["depnode"]],["option",["string"]]]],[11,"edge_deduplication_data","","",11,N],[11,"serialize","","",11,[[["self"]],["serializeddepgraph"]]],[11,"node_color","","",11,[[["self"],["depnode"]],["option",["depnodecolor"]]]],[11,"try_mark_green","","",11,[[["self"],["tyctxt"],["depnode"]],["option",["depnodeindex"]]]],[11,"is_green","","",11,[[["self"],["depnode"]],["bool"]]],[11,"exec_cache_promotions","","",11,[[["self"],["tyctxt"]]]],[11,"mark_loaded_from_cache","","",11,[[["self"],["depnodeindex"],["bool"]]]],[11,"was_loaded_from_cache","","",11,[[["self"],["depnode"]],["option",["bool"]]]],[11,"clone","","",12,[[["self"]],["workproduct"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"encode","","",12,[[["self"],["__s"]],["result"]]],[11,"decode","","",12,[[["__d"]],["result",["workproduct"]]]],[11,"clone","","",23,[[["self"]],["workproductfilekind"]]],[11,"fmt","","",23,[[["self"],["formatter"]],["result"]]],[11,"encode","","",23,[[["self"],["__s"]],["result"]]],[11,"decode","","",23,[[["__d"]],["result",["workproductfilekind"]]]],[11,"new","rustc::dep_graph::graph","",29,[[],["currentdepgraph"]]],[11,"complete_task","","",29,[[["self"],["depnode"],["opentask"]],["depnodeindex"]]],[11,"pop_anon_task","","",29,[[["self"],["depkind"],["opentask"]],["depnodeindex"]]],[11,"complete_eval_always_task","","",29,[[["self"],["depnode"],["opentask"]],["depnodeindex"]]],[11,"read_index","","",29,[[["self"],["depnodeindex"]]]],[11,"alloc_node","","",29,[[["self"],["depnode"],["smallvec"]],["depnodeindex"]]],[11,"new","","",32,[[["usize"]],["depnodecolormap"]]],[11,"get","","",32,[[["self"],["serializeddepnodeindex"]],["option",["depnodecolor"]]]],[11,"insert","","",32,[[["self"],["serializeddepnodeindex"],["depnodecolor"]]]],[0,"prev","rustc::dep_graph","",N,N],[3,"PreviousDepGraph","rustc::dep_graph::prev","",N,N],[12,"data","","",14,N],[12,"index","","",14,N],[11,"fmt","rustc::dep_graph","",14,[[["self"],["formatter"]],["result"]]],[11,"encode","","",14,[[["self"],["__s"]],["result"]]],[11,"decode","","",14,[[["__d"]],["result",["previousdepgraph"]]]],[11,"new","","",14,[[["serializeddepgraph"]],["previousdepgraph"]]],[11,"edges_from","","",14,[[["self"],["depnode"]],["option"]]],[11,"index_to_node","","",14,[[["self"],["serializeddepnodeindex"]],["depnode"]]],[11,"node_to_index","","",14,[[["self"],["depnode"]],["serializeddepnodeindex"]]],[11,"node_to_index_opt","","",14,[[["self"],["depnode"]],["option",["serializeddepnodeindex"]]]],[11,"fingerprint_of","","",14,[[["self"],["depnode"]],["option",["fingerprint"]]]],[11,"fingerprint_by_index","","",14,[[["self"],["serializeddepnodeindex"]],["fingerprint"]]],[11,"node_count","","",14,[[["self"]],["usize"]]],[0,"query","","",N,N],[3,"DepGraphQuery","rustc::dep_graph::query","",N,N],[12,"graph","","",15,N],[12,"indices","","",15,N],[11,"new","rustc::dep_graph","",15,N],[11,"contains_node","","",15,[[["self"],["depnode"]],["bool"]]],[11,"nodes","","",15,[[["self"]],["vec",["depnode"]]]],[11,"edges","","",15,[[["self"]],["vec"]]],[11,"reachable_nodes","","",15,[[["self"],["depnode"],["direction"]],["vec",["depnode"]]]],[11,"transitive_successors","","All nodes reachable from `node`. In other words, things that will have to be recomputed if `node` changes.",15,[[["self"],["depnode"]],["vec",["depnode"]]]],[11,"transitive_predecessors","","All nodes that can reach `node`.",15,[[["self"],["depnode"]],["vec",["depnode"]]]],[11,"immediate_successors","","Just the outgoing edges from `node`.",15,[[["self"],["depnode"]],["vec",["depnode"]]]],[0,"safe","","The `DepGraphSafe` trait",N,N],[3,"AssertDepGraphSafe","rustc::dep_graph::safe","A convenient override that lets you pass arbitrary state into a task. Every use should be accompanied by a comment explaining why it makes sense (or how it could be refactored away in the future).",N,N],[12,"0","","",16,N],[8,"DepGraphSafe","","The `DepGraphSafe` trait is used to specify what kinds of values are safe to \"leak\" into a task. The idea is that this should be only be implemented for things like the tcx as well as various id types, which will create reads in the dep-graph whenever the trait loads anything that might depend on the input program.",N,N],[0,"serialized","rustc::dep_graph","The data that we will serialize and deserialize.",N,N],[3,"SerializedDepNodeIndex","rustc::dep_graph::serialized","",N,N],[12,"0","","",18,N],[3,"SerializedDepGraph","","Data for use when recompiling the current crate.",N,N],[12,"nodes","","The set of all DepNodes in the graph",17,N],[12,"fingerprints","","The set of all Fingerprints in the graph. Each Fingerprint corresponds to the DepNode at the same index in the nodes vector.",17,N],[12,"edge_list_indices","","For each DepNode, stores the list of edges originating from that DepNode. Encoded as a [start, end) pair indexing into edge_list_data, which holds the actual DepNodeIndices of the target nodes.",17,N],[12,"edge_list_data","","A flattened list of all edge targets in the graph. Edge sources are implicit in edge_list_indices.",17,N],[11,"clone","rustc::dep_graph","",18,[[["self"]],["serializeddepnodeindex"]]],[11,"eq","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"ne","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",18,N],[11,"hash","","",18,N],[11,"partial_cmp","","",18,[[["self"],["serializeddepnodeindex"]],["option",["ordering"]]]],[11,"lt","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"le","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"gt","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"ge","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"cmp","","",18,[[["self"],["serializeddepnodeindex"]],["ordering"]]],[11,"decode","","",18,[[["__d"]],["result",["serializeddepnodeindex"]]]],[11,"encode","","",18,[[["self"],["__s"]],["result"]]],[11,"new","","",18,[[["usize"]],["self"]]],[11,"index","","",18,[[["self"]],["usize"]]],[11,"steps_between","","",18,[[["self"],["self"]],["option",["usize"]]]],[11,"replace_one","","",18,[[["self"]],["self"]]],[11,"replace_zero","","",18,[[["self"]],["self"]]],[11,"add_one","","",18,[[["self"]],["self"]]],[11,"sub_one","","",18,[[["self"]],["self"]]],[11,"add_usize","","",18,[[["self"],["usize"]],["option"]]],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",17,[[["self"],["formatter"]],["result"]]],[11,"encode","","",17,[[["self"],["__s"]],["result"]]],[11,"decode","","",17,[[["__d"]],["result",["serializeddepgraph"]]]],[11,"new","","",17,[[],["serializeddepgraph"]]],[11,"edge_targets_from","","",17,N],[0,"label_strs","","Contains variant => str representations for constructing DepNode groups for tests.",N,N],[17,"Null","rustc::dep_graph::label_strs","",N,N],[17,"Krate","","",N,N],[17,"HirBody","","",N,N],[17,"Hir","","",N,N],[17,"CrateMetadata","","",N,N],[17,"RegionScopeTree","","",N,N],[17,"Coherence","","",N,N],[17,"CoherenceInherentImplOverlapCheck","","",N,N],[17,"CoherenceCheckTrait","","",N,N],[17,"PrivacyAccessLevels","","",N,N],[17,"MirConstQualif","","",N,N],[17,"MirBuilt","","",N,N],[17,"MirConst","","",N,N],[17,"MirValidated","","",N,N],[17,"MirOptimized","","",N,N],[17,"MirShim","","",N,N],[17,"BorrowCheckKrate","","",N,N],[17,"BorrowCheck","","",N,N],[17,"MirBorrowCheck","","",N,N],[17,"UnsafetyCheckResult","","",N,N],[17,"UnsafeDeriveOnReprPacked","","",N,N],[17,"Reachability","","",N,N],[17,"MirKeys","","",N,N],[17,"CrateVariances","","",N,N],[17,"AssociatedItems","","",N,N],[17,"TypeOfItem","","",N,N],[17,"GenericsOfItem","","",N,N],[17,"PredicatesOfItem","","",N,N],[17,"ExplicitPredicatesOfItem","","",N,N],[17,"PredicatesDefinedOnItem","","",N,N],[17,"InferredOutlivesOf","","",N,N],[17,"InferredOutlivesCrate","","",N,N],[17,"SuperPredicatesOfItem","","",N,N],[17,"TraitDefOfItem","","",N,N],[17,"AdtDefOfItem","","",N,N],[17,"ImplTraitRef","","",N,N],[17,"ImplPolarity","","",N,N],[17,"FnSignature","","",N,N],[17,"CoerceUnsizedInfo","","",N,N],[17,"ItemVarianceConstraints","","",N,N],[17,"ItemVariances","","",N,N],[17,"IsConstFn","","",N,N],[17,"IsForeignItem","","",N,N],[17,"TypeParamPredicates","","",N,N],[17,"SizedConstraint","","",N,N],[17,"DtorckConstraint","","",N,N],[17,"AdtDestructor","","",N,N],[17,"AssociatedItemDefIds","","",N,N],[17,"InherentImpls","","",N,N],[17,"TypeckBodiesKrate","","",N,N],[17,"TypeckTables","","",N,N],[17,"UsedTraitImports","","",N,N],[17,"HasTypeckTables","","",N,N],[17,"ConstEval","","",N,N],[17,"CheckMatch","","",N,N],[17,"SymbolName","","",N,N],[17,"InstanceSymbolName","","",N,N],[17,"SpecializationGraph","","",N,N],[17,"ObjectSafety","","",N,N],[17,"FulfillObligation","","",N,N],[17,"VtableMethods","","",N,N],[17,"IsCopy","","",N,N],[17,"IsSized","","",N,N],[17,"IsFreeze","","",N,N],[17,"NeedsDrop","","",N,N],[17,"Layout","","",N,N],[17,"TraitImpls","","",N,N],[17,"AllLocalTraitImpls","","",N,N],[17,"TraitSelect","","",N,N],[17,"ParamEnv","","",N,N],[17,"DescribeDef","","",N,N],[17,"DefSpan","","",N,N],[17,"LookupStability","","",N,N],[17,"LookupDeprecationEntry","","",N,N],[17,"ConstIsRvaluePromotableToStatic","","",N,N],[17,"RvaluePromotableMap","","",N,N],[17,"ImplParent","","",N,N],[17,"TraitOfItem","","",N,N],[17,"IsReachableNonGeneric","","",N,N],[17,"IsUnreachableLocalDefinition","","",N,N],[17,"IsMirAvailable","","",N,N],[17,"ItemAttrs","","",N,N],[17,"CodegenFnAttrs","","",N,N],[17,"FnArgNames","","",N,N],[17,"RenderedConst","","",N,N],[17,"DylibDepFormats","","",N,N],[17,"IsPanicRuntime","","",N,N],[17,"IsCompilerBuiltins","","",N,N],[17,"HasGlobalAllocator","","",N,N],[17,"ExternCrate","","",N,N],[17,"LintLevels","","",N,N],[17,"Specializes","","",N,N],[17,"InScopeTraits","","",N,N],[17,"ModuleExports","","",N,N],[17,"IsSanitizerRuntime","","",N,N],[17,"IsProfilerRuntime","","",N,N],[17,"GetPanicStrategy","","",N,N],[17,"IsNoBuiltins","","",N,N],[17,"ImplDefaultness","","",N,N],[17,"CheckItemWellFormed","","",N,N],[17,"CheckTraitItemWellFormed","","",N,N],[17,"CheckImplItemWellFormed","","",N,N],[17,"ReachableNonGenerics","","",N,N],[17,"NativeLibraries","","",N,N],[17,"PluginRegistrarFn","","",N,N],[17,"DeriveRegistrarFn","","",N,N],[17,"CrateDisambiguator","","",N,N],[17,"CrateHash","","",N,N],[17,"OriginalCrateName","","",N,N],[17,"ExtraFileName","","",N,N],[17,"ImplementationsOfTrait","","",N,N],[17,"AllTraitImplementations","","",N,N],[17,"DllimportForeignItems","","",N,N],[17,"IsDllimportForeignItem","","",N,N],[17,"IsStaticallyIncludedForeignItem","","",N,N],[17,"NativeLibraryKind","","",N,N],[17,"LinkArgs","","",N,N],[17,"ResolveLifetimes","","",N,N],[17,"NamedRegion","","",N,N],[17,"IsLateBound","","",N,N],[17,"ObjectLifetimeDefaults","","",N,N],[17,"Visibility","","",N,N],[17,"DepKind","","",N,N],[17,"CrateName","","",N,N],[17,"ItemChildren","","",N,N],[17,"ExternModStmtCnum","","",N,N],[17,"GetLangItems","","",N,N],[17,"DefinedLangItems","","",N,N],[17,"MissingLangItems","","",N,N],[17,"VisibleParentMap","","",N,N],[17,"MissingExternCrateItem","","",N,N],[17,"UsedCrateSource","","",N,N],[17,"PostorderCnums","","",N,N],[17,"EraseRegionsTy","","",N,N],[17,"ConstValueToAllocation","","",N,N],[17,"Freevars","","",N,N],[17,"MaybeUnusedTraitImport","","",N,N],[17,"MaybeUnusedExternCrates","","",N,N],[17,"StabilityIndex","","",N,N],[17,"AllTraits","","",N,N],[17,"AllCrateNums","","",N,N],[17,"ExportedSymbols","","",N,N],[17,"CollectAndPartitionMonoItems","","",N,N],[17,"IsCodegenedItem","","",N,N],[17,"CodegenUnit","","",N,N],[17,"CompileCodegenUnit","","",N,N],[17,"OutputFilenames","","",N,N],[17,"NormalizeProjectionTy","","",N,N],[17,"NormalizeTyAfterErasingRegions","","",N,N],[17,"ImpliedOutlivesBounds","","",N,N],[17,"DropckOutlives","","",N,N],[17,"EvaluateObligation","","",N,N],[17,"TypeOpEq","","",N,N],[17,"TypeOpSubtype","","",N,N],[17,"TypeOpProvePredicate","","",N,N],[17,"TypeOpNormalizeTy","","",N,N],[17,"TypeOpNormalizePredicate","","",N,N],[17,"TypeOpNormalizePolyFnSig","","",N,N],[17,"TypeOpNormalizeFnSig","","",N,N],[17,"SubstituteNormalizeAndTestPredicates","","",N,N],[17,"TargetFeaturesWhitelist","","",N,N],[17,"InstanceDefSizeEstimate","","",N,N],[17,"Features","","",N,N],[17,"ProgramClausesFor","","",N,N],[17,"ProgramClausesForEnv","","",N,N],[17,"WasmImportModuleMap","","",N,N],[17,"ForeignModules","","",N,N],[17,"UpstreamMonomorphizations","","",N,N],[17,"UpstreamMonomorphizationsFor","","",N,N],[8,"DepTrackingMapConfig","rustc::dep_graph","",N,N],[16,"Key","","",27,N],[16,"Value","","",27,N],[10,"to_dep_kind","","",27,[[],["depkind"]]],[8,"DepGraphSafe","","The `DepGraphSafe` trait is used to specify what kinds of values are safe to \"leak\" into a task. The idea is that this should be only be implemented for things like the tcx as well as various id types, which will create reads in the dep-graph whenever the trait loads anything that might depend on the input program.",N,N],[0,"hir","rustc","",N,N],[3,"HirId","rustc::hir","A HirId uniquely identifies a node in the HIR of the current crate. It is composed of the `owner`, which is the DefIndex of the directly enclosing hir::Item, hir::TraitItem, or hir::ImplItem (i.e. the closest \"item-like\"), and the `local_id` which is unique within the given owner.",N,N],[12,"owner","","",33,N],[12,"local_id","","",33,N],[3,"ItemLocalId","","An `ItemLocalId` uniquely identifies something within a given \"item-like\", that is within a hir::Item, hir::TraitItem, or hir::ImplItem. There is no guarantee that the numerical value of a given `ItemLocalId` corresponds to the node's position within the owning item in any way, but there is a guarantee that the `LocalItemId`s within an owner occupy a dense range of integers starting at zero, so a mapping that maps all or most nodes within an \"item-like\" to something else can be implement by a `Vec` instead of a tree or hash map.",N,N],[12,"0","","",34,N],[3,"Label","","",N,N],[12,"ident","","",35,N],[3,"Lifetime","","",N,N],[12,"id","","",36,N],[12,"span","","",36,N],[12,"name","","Either \"'a\", referring to a named lifetime definition, or \"\" (aka keywords::Invalid), for elision placeholders.",36,N],[3,"Path","","A \"Path\" is essentially Rust's notion of a name; for instance: `std::cmp::PartialEq`. It's represented as a sequence of identifiers, along with a bunch of supporting information.",N,N],[12,"span","","",37,N],[12,"def","","The definition that the path resolved to.",37,N],[12,"segments","","The segments in the path: the things separated by `::`.",37,N],[3,"PathSegment","","A segment of a path: an identifier, an optional lifetime, and a set of types.",N,N],[12,"ident","","The identifier portion of this path segment.",38,N],[12,"args","","Type/lifetime parameters attached to this path. They come in two flavors: `Path<A,B,C>` and `Path(A,B) -> C`. Note that this is more than just simple syntactic sugar; the use of parens affects the region binding rules, so we preserve the distinction.",38,N],[12,"infer_types","","Whether to infer remaining type parameters, if any. This only applies to expression and pattern paths, and out of those only the segments with no type parameters to begin with, e.g. `Vec::new` is `<Vec<..>>::new::<..>`.",38,N],[3,"GenericArgs","","",N,N],[12,"args","","The generic arguments for this path segment.",39,N],[12,"bindings","","Bindings (equality constraints) on associated types, if present. E.g., `Foo<A=Bar>`.",39,N],[12,"parenthesized","","Were arguments written in parenthesized form `Fn(T) -> U`? This is required mostly for pretty-printing and diagnostics, but also for changing lifetime elision rules to be \"function-like\".",39,N],[3,"GenericParam","","",N,N],[12,"id","","",40,N],[12,"name","","",40,N],[12,"attrs","","",40,N],[12,"bounds","","",40,N],[12,"span","","",40,N],[12,"pure_wrt_drop","","",40,N],[12,"kind","","",40,N],[3,"GenericParamCount","","",N,N],[12,"lifetimes","","",41,N],[12,"types","","",41,N],[3,"Generics","","Represents lifetimes and type parameters attached to a declaration of a function, enum, trait, etc.",N,N],[12,"params","","",42,N],[12,"where_clause","","",42,N],[12,"span","","",42,N],[3,"WhereClause","","A `where` clause in a definition",N,N],[12,"id","","",43,N],[12,"predicates","","",43,N],[3,"WhereBoundPredicate","","A type bound, eg `for<'c> Foo: Send+Clone+'c`",N,N],[12,"span","","",44,N],[12,"bound_generic_params","","Any generics from a `for` binding",44,N],[12,"bounded_ty","","The type being bounded",44,N],[12,"bounds","","Trait and lifetime bounds (`Clone+Send+'static`)",44,N],[3,"WhereRegionPredicate","","A lifetime predicate, e.g. `'a: 'b+'c`",N,N],[12,"span","","",45,N],[12,"lifetime","","",45,N],[12,"bounds","","",45,N],[3,"WhereEqPredicate","","An equality predicate (unsupported), e.g. `T=int`",N,N],[12,"id","","",46,N],[12,"span","","",46,N],[12,"lhs_ty","","",46,N],[12,"rhs_ty","","",46,N],[3,"Crate","","The top-level data structure that stores the entire contents of the crate currently being compiled.",N,N],[12,"module","","",47,N],[12,"attrs","","",47,N],[12,"span","","",47,N],[12,"exported_macros","","",47,N],[12,"items","","",47,N],[12,"trait_items","","",47,N],[12,"impl_items","","",47,N],[12,"bodies","","",47,N],[12,"trait_impls","","",47,N],[12,"trait_auto_impl","","",47,N],[12,"body_ids","","A list of the body ids written out in the order in which they appear in the crate. If you're going to process all the bodies in the crate, you should iterate over this list rather than the keys of bodies.",47,N],[3,"MacroDef","","A macro definition, in this crate or imported from another.",N,N],[12,"name","","",48,N],[12,"vis","","",48,N],[12,"attrs","","",48,N],[12,"id","","",48,N],[12,"span","","",48,N],[12,"body","","",48,N],[12,"legacy","","",48,N],[3,"Block","","",N,N],[12,"stmts","","Statements in a block",49,N],[12,"expr","","An expression at the end of the block without a semicolon, if any",49,N],[12,"id","","",49,N],[12,"hir_id","","",49,N],[12,"rules","","Distinguishes between `unsafe { ... }` and `{ ... }`",49,N],[12,"span","","",49,N],[12,"targeted_by_break","","If true, then there may exist `break 'a` values that aim to break out of this block early. Used by `'label: {}` blocks and by `catch` statements.",49,N],[12,"recovered","","If true, don't emit return value type errors as the parser had to recover from a parse error so this block will not have an appropriate type. A parse error will have been emitted so the compilation will never succeed if this is true.",49,N],[3,"Pat","","",N,N],[12,"id","","",50,N],[12,"hir_id","","",50,N],[12,"node","","",50,N],[12,"span","","",50,N],[3,"FieldPat","","A single field in a struct pattern",N,N],[12,"id","","",51,N],[12,"ident","","The identifier for the field",51,N],[12,"pat","","The pattern the field is destructured to",51,N],[12,"is_shorthand","","",51,N],[3,"Local","","Local represents a `let` statement, e.g., `let <pat>:<ty> = <expr>;`",N,N],[12,"pat","","",52,N],[12,"ty","","",52,N],[12,"init","","Initializer expression to set the value, if any",52,N],[12,"id","","",52,N],[12,"hir_id","","",52,N],[12,"span","","",52,N],[12,"attrs","","",52,N],[12,"source","","",52,N],[3,"Arm","","represents one arm of a 'match'",N,N],[12,"attrs","","",53,N],[12,"pats","","",53,N],[12,"guard","","",53,N],[12,"body","","",53,N],[3,"Field","","",N,N],[12,"id","","",54,N],[12,"ident","","",54,N],[12,"expr","","",54,N],[12,"span","","",54,N],[12,"is_shorthand","","",54,N],[3,"BodyId","","",N,N],[12,"node_id","","",55,N],[3,"Body","","The body of a function, closure, or constant value. In the case of a function, the body contains not only the function body itself (which is an expression), but also the argument patterns, since those are something that the caller doesn't really care about.",N,N],[12,"arguments","","",56,N],[12,"value","","",56,N],[12,"is_generator","","",56,N],[3,"AnonConst","","A constant (expression) that's not an item or associated item, but needs its own `DefId` for type-checking, const-eval, etc. These are usually found nested inside types (e.g. array lengths) or expressions (e.g. repeat counts), and also used to define explicit discriminant values for enum variants.",N,N],[12,"id","","",57,N],[12,"hir_id","","",57,N],[12,"body","","",57,N],[3,"Expr","","An expression",N,N],[12,"id","","",58,N],[12,"span","","",58,N],[12,"node","","",58,N],[12,"attrs","","",58,N],[12,"hir_id","","",58,N],[3,"Destination","","",N,N],[12,"label","","",59,N],[12,"target_id","","",59,N],[3,"MutTy","","",N,N],[12,"ty","","",60,N],[12,"mutbl","","",60,N],[3,"MethodSig","","Represents a method's signature in a trait declaration or implementation.",N,N],[12,"header","","",61,N],[12,"decl","","",61,N],[3,"TraitItemId","","",N,N],[12,"node_id","","",62,N],[3,"TraitItem","","Represents an item declaration within a trait declaration, possibly including a default implementation. A trait item is either required (meaning it doesn't have an implementation, just a signature) or provided (meaning it has a default implementation).",N,N],[12,"id","","",63,N],[12,"ident","","",63,N],[12,"hir_id","","",63,N],[12,"attrs","","",63,N],[12,"generics","","",63,N],[12,"node","","",63,N],[12,"span","","",63,N],[3,"ImplItemId","","",N,N],[12,"node_id","","",64,N],[3,"ImplItem","","Represents anything within an `impl` block",N,N],[12,"id","","",65,N],[12,"ident","","",65,N],[12,"hir_id","","",65,N],[12,"vis","","",65,N],[12,"defaultness","","",65,N],[12,"attrs","","",65,N],[12,"generics","","",65,N],[12,"node","","",65,N],[12,"span","","",65,N],[3,"TypeBinding","","",N,N],[12,"id","","",66,N],[12,"ident","","",66,N],[12,"ty","","",66,N],[12,"span","","",66,N],[3,"Ty","","",N,N],[12,"id","","",67,N],[12,"node","","",67,N],[12,"span","","",67,N],[12,"hir_id","","",67,N],[3,"BareFnTy","","",N,N],[12,"unsafety","","",68,N],[12,"abi","","",68,N],[12,"generic_params","","",68,N],[12,"decl","","",68,N],[12,"arg_names","","",68,N],[3,"ExistTy","","",N,N],[12,"generics","","",69,N],[12,"bounds","","",69,N],[12,"impl_trait_fn","","",69,N],[3,"InlineAsmOutput","","",N,N],[12,"constraint","","",70,N],[12,"is_rw","","",70,N],[12,"is_indirect","","",70,N],[3,"InlineAsm","","",N,N],[12,"asm","","",71,N],[12,"asm_str_style","","",71,N],[12,"outputs","","",71,N],[12,"inputs","","",71,N],[12,"clobbers","","",71,N],[12,"volatile","","",71,N],[12,"alignstack","","",71,N],[12,"dialect","","",71,N],[12,"ctxt","","",71,N],[3,"Arg","","represents an argument in a function header",N,N],[12,"pat","","",72,N],[12,"id","","",72,N],[12,"hir_id","","",72,N],[3,"FnDecl","","Represents the header (not the body) of a function declaration",N,N],[12,"inputs","","",73,N],[12,"output","","",73,N],[12,"variadic","","",73,N],[12,"has_implicit_self","","True if this function has an `self`, `&self` or `&mut self` receiver (but not a `self: Xxx` one).",73,N],[3,"Mod","","",N,N],[12,"inner","","A span from the first token past `{` to the last token until `}`. For `mod foo;`, the inner span ranges from the first token to the last token in the external file.",74,N],[12,"item_ids","","",74,N],[3,"ForeignMod","","",N,N],[12,"abi","","",75,N],[12,"items","","",75,N],[3,"GlobalAsm","","",N,N],[12,"asm","","",76,N],[12,"ctxt","","",76,N],[3,"EnumDef","","",N,N],[12,"variants","","",77,N],[3,"VariantKind","","",N,N],[12,"name","","",78,N],[12,"attrs","","",78,N],[12,"data","","",78,N],[12,"disr_expr","","Explicit discriminant, eg `Foo = 1`",78,N],[3,"TraitRef","","TraitRef's appear in impls.",N,N],[12,"path","","",79,N],[12,"ref_id","","",79,N],[3,"PolyTraitRef","","",N,N],[12,"bound_generic_params","","The `'a` in `<'a> Foo<&'a T>`",80,N],[12,"trait_ref","","The `Foo<&'a T>` in `<'a> Foo<&'a T>`",80,N],[12,"span","","",80,N],[3,"StructField","","",N,N],[12,"span","","",81,N],[12,"ident","","",81,N],[12,"vis","","",81,N],[12,"id","","",81,N],[12,"ty","","",81,N],[12,"attrs","","",81,N],[3,"ItemId","","",N,N],[12,"id","","",82,N],[3,"Item","","An item",N,N],[12,"name","","",83,N],[12,"id","","",83,N],[12,"hir_id","","",83,N],[12,"attrs","","",83,N],[12,"node","","",83,N],[12,"vis","","",83,N],[12,"span","","",83,N],[3,"FnHeader","","",N,N],[12,"unsafety","","",84,N],[12,"constness","","",84,N],[12,"asyncness","","",84,N],[12,"abi","","",84,N],[3,"TraitItemRef","","A reference from an trait to one of its associated items. This contains the item's id, naturally, but also the item's name and some other high-level details (like whether it is an associated type or method, and whether it is public). This allows other passes to find the impl they want without loading the id (which means fewer edges in the incremental compilation graph).",N,N],[12,"id","","",85,N],[12,"ident","","",85,N],[12,"kind","","",85,N],[12,"span","","",85,N],[12,"defaultness","","",85,N],[3,"ImplItemRef","","A reference from an impl to one of its associated items. This contains the item's id, naturally, but also the item's name and some other high-level details (like whether it is an associated type or method, and whether it is public). This allows other passes to find the impl they want without loading the id (which means fewer edges in the incremental compilation graph).",N,N],[12,"id","","",86,N],[12,"ident","","",86,N],[12,"kind","","",86,N],[12,"span","","",86,N],[12,"vis","","",86,N],[12,"defaultness","","",86,N],[3,"ForeignItem","","",N,N],[12,"name","","",87,N],[12,"attrs","","",87,N],[12,"node","","",87,N],[12,"id","","",87,N],[12,"span","","",87,N],[12,"vis","","",87,N],[3,"Freevar","","A free variable referred to in a function.",N,N],[12,"def","","The variable being accessed free.",88,N],[12,"span","","",88,N],[3,"TraitCandidate","","",N,N],[12,"def_id","","",89,N],[12,"import_id","","",89,N],[3,"CodegenFnAttrs","","",N,N],[12,"flags","","",90,N],[12,"inline","","",90,N],[12,"export_name","","",90,N],[12,"target_features","","",90,N],[12,"linkage","","",90,N],[12,"link_section","","",90,N],[3,"CodegenFnAttrFlags","","",N,N],[12,"bits","","",91,N],[4,"ParamName","","",N,N],[13,"Plain","","Some user-given name like `T` or `'x`.",92,N],[13,"Fresh","","Synthetic name generated when user elided a lifetime in an impl header, e.g. the lifetimes in cases like these:",92,N],[4,"LifetimeName","","",N,N],[13,"Param","","User-given names or fresh (synthetic) names.",93,N],[13,"Implicit","","User typed nothing. e.g. the lifetime in `&u32`.",93,N],[13,"Underscore","","User typed `'_`.",93,N],[13,"Static","","User wrote `'static`",93,N],[4,"GenericArg","","",N,N],[13,"Lifetime","","",94,N],[13,"Type","","",94,N],[4,"TraitBoundModifier","","A modifier on a bound, currently this is only used for `?Sized`, where the modifier is `Maybe`. Negative bounds should also be handled here.",N,N],[13,"None","","",95,N],[13,"Maybe","","",95,N],[4,"GenericBound","","The AST represents all type param bounds as types. typeck::collect::compute_bounds matches these against the \"special\" built-in traits (see middle::lang_items) and detects Copy, Send and Sync.",N,N],[13,"Trait","","",96,N],[13,"Outlives","","",96,N],[4,"GenericParamKind","","",N,N],[13,"Lifetime","","A lifetime definition, eg `'a: 'b + 'c + 'd`.",97,N],[12,"in_band","rustc::hir::GenericParamKind","",97,N],[13,"Type","rustc::hir","",97,N],[12,"default","rustc::hir::GenericParamKind","",97,N],[12,"synthetic","","",97,N],[4,"SyntheticTyParamKind","rustc::hir","Synthetic Type Parameters are converted to an other form during lowering, this allows to track the original form they had. Useful for error messages.",N,N],[13,"ImplTrait","","",98,N],[4,"WherePredicate","","A single predicate in a `where` clause",N,N],[13,"BoundPredicate","","A type binding, eg `for<'c> Foo: Send+Clone+'c`",99,N],[13,"RegionPredicate","","A lifetime predicate, e.g. `'a: 'b+'c`",99,N],[13,"EqPredicate","","An equality predicate (unsupported)",99,N],[4,"BindingAnnotation","","Explicit binding annotations given in the HIR for a binding. Note that this is not the final binding mode that we infer after type inference.",N,N],[13,"Unannotated","","No binding annotation given: this means that the final binding mode will depend on whether we have skipped through a `&` reference when matching. For example, the `x` in `Some(x)` will have binding mode `None`; if you do `let Some(x) = &Some(22)`, it will ultimately be inferred to be by-reference.",100,N],[13,"Mutable","","Annotated with `mut x` -- could be either ref or not, similar to `None`.",100,N],[13,"Ref","","Annotated as `ref`, like `ref x`",100,N],[13,"RefMut","","Annotated as `ref mut x`.",100,N],[4,"RangeEnd","","",N,N],[13,"Included","","",101,N],[13,"Excluded","","",101,N],[4,"PatKind","","",N,N],[13,"Wild","","Represents a wildcard pattern (`_`)",102,N],[13,"Binding","","A fresh binding `ref mut binding @ OPT_SUBPATTERN`. The `NodeId` is the canonical ID for the variable being bound, e.g. in `Ok(x) | Err(x)`, both `x` use the same canonical ID, which is the pattern ID of the first `x`.",102,N],[13,"Struct","","A struct or struct variant pattern, e.g. `Variant {x, y, ..}`. The `bool` is `true` in the presence of a `..`.",102,N],[13,"TupleStruct","","A tuple struct/variant pattern `Variant(x, y, .., z)`. If the `..` pattern fragment is present, then `Option<usize>` denotes its position. 0 <= position <= subpats.len()",102,N],[13,"Path","","A path pattern for an unit struct/variant or a (maybe-associated) constant.",102,N],[13,"Tuple","","A tuple pattern `(a, b)`. If the `..` pattern fragment is present, then `Option<usize>` denotes its position. 0 <= position <= subpats.len()",102,N],[13,"Box","","A `box` pattern",102,N],[13,"Ref","","A reference pattern, e.g. `&mut (a, b)`",102,N],[13,"Lit","","A literal",102,N],[13,"Range","","A range pattern, e.g. `1...2` or `1..2`",102,N],[13,"Slice","","`[a, b, ..i, y, z]` is represented as: `PatKind::Slice(box [a, b], Some(i), box [y, z])`",102,N],[4,"Mutability","","",N,N],[13,"MutMutable","","",103,N],[13,"MutImmutable","","",103,N],[4,"BinOpKind","","",N,N],[13,"Add","","The `+` operator (addition)",104,N],[13,"Sub","","The `-` operator (subtraction)",104,N],[13,"Mul","","The `*` operator (multiplication)",104,N],[13,"Div","","The `/` operator (division)",104,N],[13,"Rem","","The `%` operator (modulus)",104,N],[13,"And","","The `&&` operator (logical and)",104,N],[13,"Or","","The `||` operator (logical or)",104,N],[13,"BitXor","","The `^` operator (bitwise xor)",104,N],[13,"BitAnd","","The `&` operator (bitwise and)",104,N],[13,"BitOr","","The `|` operator (bitwise or)",104,N],[13,"Shl","","The `<<` operator (shift left)",104,N],[13,"Shr","","The `>>` operator (shift right)",104,N],[13,"Eq","","The `==` operator (equality)",104,N],[13,"Lt","","The `<` operator (less than)",104,N],[13,"Le","","The `<=` operator (less than or equal to)",104,N],[13,"Ne","","The `!=` operator (not equal to)",104,N],[13,"Ge","","The `>=` operator (greater than or equal to)",104,N],[13,"Gt","","The `>` operator (greater than)",104,N],[4,"UnOp","","",N,N],[13,"UnDeref","","The `*` operator for dereferencing",105,N],[13,"UnNot","","The `!` operator for logical inversion",105,N],[13,"UnNeg","","The `-` operator for negation",105,N],[4,"StmtKind","","",N,N],[13,"Decl","","Could be an item or a local (let) binding:",106,N],[13,"Expr","","Expr without trailing semi-colon (must have unit type):",106,N],[13,"Semi","","Expr with trailing semi-colon (may have any type):",106,N],[4,"DeclKind","","",N,N],[13,"Local","","A local (let) binding:",107,N],[13,"Item","","An item binding:",107,N],[4,"BlockCheckMode","","",N,N],[13,"DefaultBlock","","",108,N],[13,"UnsafeBlock","","",108,N],[13,"PushUnsafeBlock","","",108,N],[13,"PopUnsafeBlock","","",108,N],[4,"UnsafeSource","","",N,N],[13,"CompilerGenerated","","",109,N],[13,"UserProvided","","",109,N],[4,"BodyOwnerKind","","",N,N],[13,"Fn","","Functions and methods.",110,N],[13,"Const","","Constants and associated constants.",110,N],[13,"Static","","Initializer of a `static` item.",110,N],[4,"ExprKind","","",N,N],[13,"Box","","A `box x` expression.",111,N],[13,"Array","","An array (`[a, b, c, d]`)",111,N],[13,"Call","","A function call",111,N],[13,"MethodCall","","A method call (`x.foo::<'static, Bar, Baz>(a, b, c, d)`)",111,N],[13,"Tup","","A tuple (`(a, b, c ,d)`)",111,N],[13,"Binary","","A binary operation (For example: `a + b`, `a * b`)",111,N],[13,"Unary","","A unary operation (For example: `!x`, `*x`)",111,N],[13,"Lit","","A literal (For example: `1`, `\"foo\"`)",111,N],[13,"Cast","","A cast (`foo as f64`)",111,N],[13,"Type","","",111,N],[13,"If","","An `if` block, with an optional else block",111,N],[13,"While","","A while loop, with an optional label",111,N],[13,"Loop","","Conditionless loop (can be exited with break, continue, or return)",111,N],[13,"Match","","A `match` block, with a source that indicates whether or not it is the result of a desugaring, and if so, which kind.",111,N],[13,"Closure","","A closure (for example, `move |a, b, c| {a + b + c}`).",111,N],[13,"Block","","A block (`'label: { ... }`)",111,N],[13,"Assign","","An assignment (`a = foo()`)",111,N],[13,"AssignOp","","An assignment with an operator",111,N],[13,"Field","","Access of a named (`obj.foo`) or unnamed (`obj.0`) struct or tuple field",111,N],[13,"Index","","An indexing operation (`foo[2]`)",111,N],[13,"Path","","Path to a definition, possibly containing lifetime or type parameters.",111,N],[13,"AddrOf","","A referencing operation (`&a` or `&mut a`)",111,N],[13,"Break","","A `break`, with an optional label to break",111,N],[13,"Continue","","A `continue`, with an optional label",111,N],[13,"Ret","","A `return`, with an optional value to be returned",111,N],[13,"InlineAsm","","Inline assembly (from `asm!`), with its outputs and inputs.",111,N],[13,"Struct","","A struct or struct-like variant literal expression.",111,N],[13,"Repeat","","An array literal constructed from one repeated element.",111,N],[13,"Yield","","A suspension point for generators. This is `yield <expr>` in Rust.",111,N],[4,"QPath","","Optionally `Self`-qualified value/type path or associated extension.",N,N],[13,"Resolved","","Path to a definition, optionally \"fully-qualified\" with a `Self` type, if the path points to an associated item in a trait.",112,N],[13,"TypeRelative","","Type-related paths, e.g. `<T>::default` or `<T>::Output`. Will be resolved by type-checking to an associated item.",112,N],[4,"LocalSource","","Hints at the original code for a let statement",N,N],[13,"Normal","","A `match _ { .. }`",113,N],[13,"ForLoopDesugar","","A desugared `for _ in _ { .. }` loop",113,N],[4,"MatchSource","","Hints at the original code for a `match _ { .. }`",N,N],[13,"Normal","","A `match _ { .. }`",114,N],[13,"IfLetDesugar","","An `if let _ = _ { .. }` (optionally with `else { .. }`)",114,N],[12,"contains_else_clause","rustc::hir::MatchSource","",114,N],[13,"WhileLetDesugar","rustc::hir","A `while let _ = _ { .. }` (which was desugared to a `loop { match _ { .. } }`)",114,N],[13,"ForLoopDesugar","","A desugared `for _ in _ { .. }` loop",114,N],[13,"TryDesugar","","A desugared `?` operator",114,N],[4,"LoopSource","","The loop type that yielded an ExprKind::Loop",N,N],[13,"Loop","","A `loop { .. }` loop",115,N],[13,"WhileLet","","A `while let _ = _ { .. }` loop",115,N],[13,"ForLoop","","A `for _ in _ { .. }` loop",115,N],[4,"LoopIdError","","",N,N],[13,"OutsideLoopScope","","",116,N],[13,"UnlabeledCfInWhileCondition","","",116,N],[13,"UnresolvedLabel","","",116,N],[4,"GeneratorMovability","","",N,N],[13,"Static","","",117,N],[13,"Movable","","",117,N],[4,"CaptureClause","","",N,N],[13,"CaptureByValue","","",118,N],[13,"CaptureByRef","","",118,N],[4,"TraitMethod","","A trait method's body (or just argument names).",N,N],[13,"Required","","No default body in the trait, just a signature.",119,N],[13,"Provided","","Both signature and body are provided in the trait.",119,N],[4,"TraitItemKind","","Represents a trait method or associated constant or type",N,N],[13,"Const","","An associated constant with an optional value (otherwise `impl`s must contain a value)",120,N],[13,"Method","","A method with an optional body",120,N],[13,"Type","","An associated type with (possibly empty) bounds and optional concrete type",120,N],[4,"ImplItemKind","","Represents different contents within `impl`s",N,N],[13,"Const","","An associated constant of the given type, set to the constant result of the expression",121,N],[13,"Method","","A method implementation with the given signature and body",121,N],[13,"Type","","An associated type",121,N],[13,"Existential","","An associated existential type",121,N],[4,"PrimTy","","Not represented directly in the AST, referred to by name through a ty_path.",N,N],[13,"TyInt","","",122,N],[13,"TyUint","","",122,N],[13,"TyFloat","","",122,N],[13,"TyStr","","",122,N],[13,"TyBool","","",122,N],[13,"TyChar","","",122,N],[4,"TyKind","","The different kinds of types recognized by the compiler",N,N],[13,"Slice","","A variable length slice (`[T]`)",123,N],[13,"Array","","A fixed length array (`[T; n]`)",123,N],[13,"Ptr","","A raw pointer (`*const T` or `*mut T`)",123,N],[13,"Rptr","","A reference (`&'a T` or `&'a mut T`)",123,N],[13,"BareFn","","A bare function (e.g. `fn(usize) -> bool`)",123,N],[13,"Never","","The never type (`!`)",123,N],[13,"Tup","","A tuple (`(A, B, C, D,...)`)",123,N],[13,"Path","","A path to a type definition (`module::module::...::Type`), or an associated type, e.g. `<Vec<T> as Trait>::Type` or `<T>::Target`.",123,N],[13,"TraitObject","","A trait object type `Bound1 + Bound2 + Bound3` where `Bound` is a trait or a lifetime.",123,N],[13,"Typeof","","Unused for now",123,N],[13,"Infer","","TyKind::Infer means the type should be inferred instead of it having been specified. This can appear anywhere in a type.",123,N],[13,"Err","","Placeholder for a type that has failed to be defined.",123,N],[4,"IsAuto","","Is the trait definition an auto trait?",N,N],[13,"Yes","","",124,N],[13,"No","","",124,N],[4,"IsAsync","","",N,N],[13,"Async","","",125,N],[13,"NotAsync","","",125,N],[4,"Unsafety","","",N,N],[13,"Unsafe","","",126,N],[13,"Normal","","",126,N],[4,"Constness","","",N,N],[13,"Const","","",127,N],[13,"NotConst","","",127,N],[4,"Defaultness","","",N,N],[13,"Default","","",128,N],[12,"has_value","rustc::hir::Defaultness","",128,N],[13,"Final","rustc::hir","",128,N],[4,"ImplPolarity","","",N,N],[13,"Positive","","`impl Trait for Type`",129,N],[13,"Negative","","`impl !Trait for Type`",129,N],[4,"FunctionRetTy","","",N,N],[13,"DefaultReturn","","Return type is not specified.",130,N],[13,"Return","","Everything else",130,N],[4,"UseKind","","",N,N],[13,"Single","","One import, e.g. `use foo::bar` or `use foo::bar as baz`. Also produced for each element of a list `use`, e.g.",131,N],[13,"Glob","","Glob import, e.g. `use foo::*`.",131,N],[13,"ListStem","","Degenerate list import, e.g. `use foo::{a, b}` produces an additional `use foo::{}` for performing checks such as unstable feature gating. May be removed in the future.",131,N],[4,"VisibilityKind","","",N,N],[13,"Public","","",132,N],[13,"Crate","","",132,N],[13,"Restricted","","",132,N],[12,"path","rustc::hir::VisibilityKind","",132,N],[12,"id","","",132,N],[13,"Inherited","rustc::hir","",132,N],[4,"VariantData","","Fields and Ids of enum variants and structs",N,N],[13,"Struct","","",133,N],[13,"Tuple","","",133,N],[13,"Unit","","",133,N],[4,"ItemKind","","",N,N],[13,"ExternCrate","","An `extern crate` item, with optional original crate name if the crate was renamed.",134,N],[13,"Use","","`use foo::bar::*;` or `use foo::bar::baz as quux;`",134,N],[13,"Static","","A `static` item",134,N],[13,"Const","","A `const` item",134,N],[13,"Fn","","A function declaration",134,N],[13,"Mod","","A module",134,N],[13,"ForeignMod","","An external module",134,N],[13,"GlobalAsm","","Module-level inline assembly (from global_asm!)",134,N],[13,"Ty","","A type alias, e.g. `type Foo = Bar<u8>`",134,N],[13,"Existential","","An existential type definition, e.g. `existential type Foo: Bar;`",134,N],[13,"Enum","","An enum definition, e.g. `enum Foo<A, B> {C<A>, D<B>}`",134,N],[13,"Struct","","A struct definition, e.g. `struct Foo<A> {x: A}`",134,N],[13,"Union","","A union definition, e.g. `union Foo<A, B> {x: A, y: B}`",134,N],[13,"Trait","","Represents a Trait Declaration",134,N],[13,"TraitAlias","","Represents a Trait Alias Declaration",134,N],[13,"Impl","","An implementation, eg `impl<A> Trait for Foo { .. }`",134,N],[4,"AssociatedItemKind","","",N,N],[13,"Const","","",135,N],[13,"Method","","",135,N],[12,"has_self","rustc::hir::AssociatedItemKind","",135,N],[13,"Type","rustc::hir","",135,N],[13,"Existential","","",135,N],[4,"ForeignItemKind","","An item within an `extern` block",N,N],[13,"Fn","","A foreign function",136,N],[13,"Static","","A foreign static item (`static ext: u8`), with optional mutability (the boolean is true when mutable)",136,N],[13,"Type","","A foreign type",136,N],[5,"provide","","",N,[[["providers"]]]],[0,"check_attr","","This module implements some validity checks for attributes. In particular it verifies that `#[inline]` and `#[repr]` attributes are attached to items that actually support them and if there are conflicts between multiple such attributes attached to the same item.",N,N],[3,"CheckAttrVisitor","rustc::hir::check_attr","",N,N],[12,"tcx","","",137,N],[4,"Target","","",N,N],[13,"Fn","","",138,N],[13,"Struct","","",138,N],[13,"Union","","",138,N],[13,"Enum","","",138,N],[13,"Const","","",138,N],[13,"ForeignMod","","",138,N],[13,"Expression","","",138,N],[13,"Statement","","",138,N],[13,"Closure","","",138,N],[13,"Static","","",138,N],[13,"Other","","",138,N],[5,"check_crate","","",N,[[["tyctxt"]]]],[5,"is_c_like_enum","","",N,[[["item"]],["bool"]]],[11,"clone","","",138,[[["self"]],["target"]]],[11,"eq","","",138,[[["self"],["target"]],["bool"]]],[11,"from_item","","",138,[[["item"]],["target"]]],[11,"check_attributes","","Check any attribute.",137,[[["self"],["item"],["target"]]]],[11,"check_inline","","Check if an `#[inline]` is applied to a function or a closure.",137,[[["self"],["attribute"],["span"],["target"]]]],[11,"check_non_exhaustive","","Check if the `#[non_exhaustive]` attribute on an `item` is valid.",137,[[["self"],["attribute"],["item"],["target"]]]],[11,"check_repr","","Check if the `#[repr]` attributes on `item` are valid.",137,[[["self"],["item"],["target"]]]],[11,"emit_repr_error","","",137,[[["self"],["span"],["span"],["str"],["str"]]]],[11,"check_stmt_attributes","","",137,[[["self"],["stmt"]]]],[11,"check_expr_attributes","","",137,[[["self"],["expr"]]]],[11,"check_used","","",137,[[["self"],["item"],["target"]]]],[11,"nested_visit_map","","",137,[[["self"]],["nestedvisitormap"]]],[11,"visit_item","","",137,[[["self"],["item"]]]],[11,"visit_stmt","","",137,[[["self"],["stmt"]]]],[11,"visit_expr","","",137,[[["self"],["expr"]]]],[0,"def","rustc::hir","",N,N],[3,"PathResolution","rustc::hir::def","The result of resolving a path before lowering to HIR. `base_def` is definition of resolved part of the path, `unresolved_segments` is the number of unresolved segments.",N,N],[12,"base_def","","",139,N],[12,"unresolved_segments","","",139,N],[3,"PerNS","","Just a helper ‒ separate structure for each namespace.",N,N],[12,"value_ns","","",140,N],[12,"type_ns","","",140,N],[12,"macro_ns","","",140,N],[3,"Export","","",N,N],[12,"ident","","The name of the target.",141,N],[12,"def","","The definition of the target.",141,N],[12,"span","","The span of the target definition.",141,N],[12,"vis","","The visibility of the export. We include non-`pub` exports for hygienic macros that get used from extern crates.",141,N],[4,"CtorKind","","",N,N],[13,"Fn","","Constructor function automatically created by a tuple struct/variant.",142,N],[13,"Const","","Constructor constant automatically created by a unit struct/variant.",142,N],[13,"Fictive","","Unusable name in value namespace created by a struct variant.",142,N],[4,"Def","","",N,N],[13,"Mod","","",143,N],[13,"Struct","","",143,N],[13,"Union","","",143,N],[13,"Enum","","",143,N],[13,"Variant","","",143,N],[13,"Trait","","",143,N],[13,"Existential","","`existential type Foo: Bar;`",143,N],[13,"TyAlias","","`type Foo = Bar;`",143,N],[13,"TyForeign","","",143,N],[13,"TraitAlias","","",143,N],[13,"AssociatedTy","","",143,N],[13,"AssociatedExistential","","`existential type Foo: Bar;`",143,N],[13,"PrimTy","","",143,N],[13,"TyParam","","",143,N],[13,"SelfTy","","",143,N],[13,"Fn","","",143,N],[13,"Const","","",143,N],[13,"Static","","",143,N],[13,"StructCtor","","",143,N],[13,"VariantCtor","","",143,N],[13,"Method","","",143,N],[13,"AssociatedConst","","",143,N],[13,"Local","","",143,N],[13,"Upvar","","",143,N],[13,"Label","","",143,N],[13,"Macro","","",143,N],[13,"GlobalAsm","","",143,N],[13,"Err","","",143,N],[4,"Namespace","","Different kinds of symbols don't influence each other.",N,N],[13,"TypeNS","","",144,N],[13,"ValueNS","","",144,N],[13,"MacroNS","","",144,N],[6,"DefMap","","Definition mapping",N,N],[6,"ExportMap","","This is the replacement export map. It maps a module to all of the exports within.",N,N],[6,"ImportMap","","Map used to track the `use` statements within a scope, matching it with all the items in every namespace.",N,N],[22,"","","",N,N],[11,"clone","","",142,[[["self"]],["ctorkind"]]],[11,"eq","","",142,[[["self"],["ctorkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",142,N],[11,"encode","","",142,[[["self"],["__s"]],["result"]]],[11,"decode","","",142,[[["__d"]],["result",["ctorkind"]]]],[11,"hash","","",142,N],[11,"fmt","","",142,[[["self"],["formatter"]],["result"]]],[11,"clone","","",143,[[["self"]],["def"]]],[11,"eq","","",143,[[["self"],["def"]],["bool"]]],[11,"ne","","",143,[[["self"],["def"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",143,N],[11,"encode","","",143,[[["self"],["__s"]],["result"]]],[11,"decode","","",143,[[["__d"]],["result",["def"]]]],[11,"hash","","",143,N],[11,"fmt","","",143,[[["self"],["formatter"]],["result"]]],[11,"clone","","",139,[[["self"]],["pathresolution"]]],[11,"fmt","","",139,[[["self"],["formatter"]],["result"]]],[11,"new","","",139,[[["def"]],["self"]]],[11,"with_unresolved_segments","","",139,[[["def"],["usize"]],["self"]]],[11,"base_def","","",139,[[["self"]],["def"]]],[11,"unresolved_segments","","",139,[[["self"]],["usize"]]],[11,"kind_name","","",139,[[["self"]],["str"]]],[11,"clone","","",144,[[["self"]],["namespace"]]],[11,"eq","","",144,[[["self"],["namespace"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",144,N],[11,"partial_cmp","","",144,[[["self"],["namespace"]],["option",["ordering"]]]],[11,"cmp","","",144,[[["self"],["namespace"]],["ordering"]]],[11,"hash","","",144,N],[11,"fmt","","",144,[[["self"],["formatter"]],["result"]]],[11,"descr","","",144,[[["self"]],["str"]]],[11,"clone","","",140,[[["self"]],["perns"]]],[11,"default","","",140,[[],["perns"]]],[11,"fmt","","",140,[[["self"],["formatter"]],["result"]]],[11,"map","","",140,[[["self"],["f"]],["perns"]]],[11,"index","","",140,[[["self"],["namespace"]],["t"]]],[11,"index_mut","","",140,[[["self"],["namespace"]],["t"]]],[11,"is_empty","","Returns whether all the items in this collection are `None`.",140,[[["self"]],["bool"]]],[11,"present_items","","Returns an iterator over the items which are `Some`.",140,[[["self"]],[""]]],[11,"clone","","",141,[[["self"]],["export"]]],[11,"fmt","","",141,[[["self"],["formatter"]],["result"]]],[11,"encode","","",141,[[["self"],["__s"]],["result"]]],[11,"decode","","",141,[[["__d"]],["result",["export"]]]],[11,"from_ast","","",142,[[["variantdata"]],["ctorkind"]]],[11,"from_hir","","",142,[[["variantdata"]],["ctorkind"]]],[11,"def_id","","",143,[[["self"]],["defid"]]],[11,"kind_name","","A human readable kind name",143,[[["self"]],["str"]]],[0,"def_id","rustc::hir","",N,N],[3,"CrateNum","rustc::hir::def_id","",N,N],[12,"0","","",145,N],[3,"DefIndex","","A DefIndex is an index into the hir-map for a crate, identifying a particular definition. It should really be considered an interned shorthand for a particular DefPath.",N,N],[12,"0","","",146,N],[3,"DefId","","A DefId identifies a particular definition, by combining a crate index and a def index.",N,N],[12,"krate","","",147,N],[12,"index","","",147,N],[3,"LocalDefId","","A LocalDefId is equivalent to a DefId with `krate == LOCAL_CRATE`. Since we encode this information in the type, we can ensure at compile time that no DefIds from upstream crates get thrown into the mix. There are quite a few cases where we know that only DefIds from the local crate are expected and a DefId from a different crate would signify a bug somewhere. This is when LocalDefId comes in handy.",N,N],[12,"0","","",148,N],[4,"DefIndexAddressSpace","","",N,N],[13,"Low","","",149,N],[13,"High","","",149,N],[17,"LOCAL_CRATE","","Item definitions in the currently-compiled crate would have the CrateNum LOCAL_CRATE in their DefId.",N,N],[17,"BUILTIN_MACROS_CRATE","","Virtual crate for builtin macros",N,N],[17,"INVALID_CRATE","","A CrateNum value that indicates that something is wrong.",N,N],[17,"RESERVED_FOR_INCR_COMP_CACHE","","A special CrateNum that we use for the tcx.rcache when decoding from the incr. comp. cache.",N,N],[17,"CRATE_DEF_INDEX","","The crate root is always assigned index 0 by the AST Map code, thanks to `NodeCollector::new`.",N,N],[11,"clone","","",145,[[["self"]],["cratenum"]]],[11,"eq","","",145,[[["self"],["cratenum"]],["bool"]]],[11,"ne","","",145,[[["self"],["cratenum"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",145,N],[11,"hash","","",145,N],[11,"partial_cmp","","",145,[[["self"],["cratenum"]],["option",["ordering"]]]],[11,"lt","","",145,[[["self"],["cratenum"]],["bool"]]],[11,"le","","",145,[[["self"],["cratenum"]],["bool"]]],[11,"gt","","",145,[[["self"],["cratenum"]],["bool"]]],[11,"ge","","",145,[[["self"],["cratenum"]],["bool"]]],[11,"cmp","","",145,[[["self"],["cratenum"]],["ordering"]]],[11,"new","","",145,[[["usize"]],["self"]]],[11,"index","","",145,[[["self"]],["usize"]]],[11,"steps_between","","",145,[[["self"],["self"]],["option",["usize"]]]],[11,"replace_one","","",145,[[["self"]],["self"]]],[11,"replace_zero","","",145,[[["self"]],["self"]]],[11,"add_one","","",145,[[["self"]],["self"]]],[11,"sub_one","","",145,[[["self"]],["self"]]],[11,"add_usize","","",145,[[["self"],["usize"]],["option"]]],[11,"fmt","","",145,[[["self"],["formatter"]],["result"]]],[11,"new","","",145,[[["usize"]],["cratenum"]]],[11,"from_u32","","",145,[[["u32"]],["cratenum"]]],[11,"as_usize","","",145,[[["self"]],["usize"]]],[11,"as_u32","","",145,[[["self"]],["u32"]]],[11,"as_def_id","","",145,[[["self"]],["defid"]]],[11,"fmt","","",145,[[["self"],["formatter"]],["result"]]],[11,"clone","","",146,[[["self"]],["defindex"]]],[11,"eq","","",146,[[["self"],["defindex"]],["bool"]]],[11,"ne","","",146,[[["self"],["defindex"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",146,N],[11,"partial_cmp","","",146,[[["self"],["defindex"]],["option",["ordering"]]]],[11,"lt","","",146,[[["self"],["defindex"]],["bool"]]],[11,"le","","",146,[[["self"],["defindex"]],["bool"]]],[11,"gt","","",146,[[["self"],["defindex"]],["bool"]]],[11,"ge","","",146,[[["self"],["defindex"]],["bool"]]],[11,"cmp","","",146,[[["self"],["defindex"]],["ordering"]]],[11,"hash","","",146,N],[11,"fmt","","",146,[[["self"],["formatter"]],["result"]]],[11,"address_space","","",146,[[["self"]],["defindexaddressspace"]]],[11,"as_array_index","","Converts this DefIndex into a zero-based array index. This index is the offset within the given DefIndexAddressSpace.",146,[[["self"]],["usize"]]],[11,"from_array_index","","",146,[[["usize"],["defindexaddressspace"]],["defindex"]]],[11,"from_proc_macro_index","","",146,[[["usize"]],["defindex"]]],[11,"to_proc_macro_index","","",146,[[["defindex"]],["usize"]]],[11,"from_raw_u32","","",146,[[["u32"]],["defindex"]]],[11,"as_raw_u32","","",146,[[["self"]],["u32"]]],[11,"clone","","",149,[[["self"]],["defindexaddressspace"]]],[11,"hash","","",149,N],[11,"index","","",149,[[["self"]],["usize"]]],[11,"clone","","",147,[[["self"]],["defid"]]],[11,"eq","","",147,[[["self"],["defid"]],["bool"]]],[11,"ne","","",147,[[["self"],["defid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",147,N],[11,"partial_cmp","","",147,[[["self"],["defid"]],["option",["ordering"]]]],[11,"lt","","",147,[[["self"],["defid"]],["bool"]]],[11,"le","","",147,[[["self"],["defid"]],["bool"]]],[11,"gt","","",147,[[["self"],["defid"]],["bool"]]],[11,"ge","","",147,[[["self"],["defid"]],["bool"]]],[11,"cmp","","",147,[[["self"],["defid"]],["ordering"]]],[11,"hash","","",147,N],[11,"fmt","","",147,[[["self"],["formatter"]],["result"]]],[11,"local","","Make a local `DefId` with the given index.",147,[[["defindex"]],["defid"]]],[11,"is_local","","",147,[[["self"]],["bool"]]],[11,"to_local","","",147,[[["self"]],["localdefid"]]],[11,"clone","","",148,[[["self"]],["localdefid"]]],[11,"eq","","",148,[[["self"],["localdefid"]],["bool"]]],[11,"ne","","",148,[[["self"],["localdefid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",148,N],[11,"hash","","",148,N],[11,"from_def_id","","",148,[[["defid"]],["localdefid"]]],[11,"to_def_id","","",148,[[["self"]],["defid"]]],[11,"fmt","","",148,[[["self"],["formatter"]],["result"]]],[0,"intravisit","rustc::hir","HIR walker for walking the contents of nodes.",N,N],[3,"IdRange","rustc::hir::intravisit","",N,N],[12,"min","","",150,N],[12,"max","","",150,N],[3,"IdRangeComputingVisitor","","",N,N],[12,"result","","",151,N],[12,"map","","",151,N],[4,"FnKind","","",N,N],[13,"ItemFn","","#[xxx] pub async/const/extern \"Abi\" fn foo()",152,N],[13,"Method","","fn foo(&self)",152,N],[13,"Closure","","|x, y| {}",152,N],[4,"NestedVisitorMap","","Specifies what nested things a visitor wants to visit. The most common choice is `OnlyBodies`, which will cause the visitor to visit fn bodies for fns that it encounters, but skip over nested item-like things.",N,N],[13,"None","","Do not visit any nested things. When you add a new \"non-nested\" thing, you will want to audit such uses to see if they remain valid.",153,N],[13,"OnlyBodies","","Do not visit nested item-like things, but visit nested things that are inside of an item-like.",153,N],[13,"All","","Visit all nested things, including item-likes.",153,N],[5,"walk_crate","","Walks the contents of a crate. See also `Crate::visit_all_items`.",N,[[["v"],["crate"]]]],[5,"walk_macro_def","","",N,[[["v"],["macrodef"]]]],[5,"walk_mod","","",N,[[["v"],["mod"],["nodeid"]]]],[5,"walk_body","","",N,[[["v"],["body"]]]],[5,"walk_local","","",N,[[["v"],["local"]]]],[5,"walk_ident","","",N,[[["v"],["ident"]]]],[5,"walk_label","","",N,[[["v"],["label"]]]],[5,"walk_lifetime","","",N,[[["v"],["lifetime"]]]],[5,"walk_poly_trait_ref","","",N,[[["v"],["polytraitref"],["traitboundmodifier"]]]],[5,"walk_trait_ref","","",N,[[["v"],["traitref"]]]],[5,"walk_item","","",N,[[["v"],["item"]]]],[5,"walk_enum_def","","",N,[[["v"],["enumdef"],["generics"],["nodeid"]]]],[5,"walk_variant","","",N,[[["v"],["variant"],["generics"],["nodeid"]]]],[5,"walk_ty","","",N,[[["v"],["ty"]]]],[5,"walk_qpath","","",N,[[["v"],["qpath"],["nodeid"],["span"]]]],[5,"walk_path","","",N,[[["v"],["path"]]]],[5,"walk_path_segment","","",N,[[["v"],["span"],["pathsegment"]]]],[5,"walk_generic_args","","",N,[[["v"],["span"],["genericargs"]]]],[5,"walk_assoc_type_binding","","",N,[[["v"],["typebinding"]]]],[5,"walk_pat","","",N,[[["v"],["pat"]]]],[5,"walk_foreign_item","","",N,[[["v"],["foreignitem"]]]],[5,"walk_param_bound","","",N,[[["v"],["genericbound"]]]],[5,"walk_generic_param","","",N,[[["v"],["genericparam"]]]],[5,"walk_generics","","",N,[[["v"],["generics"]]]],[5,"walk_where_predicate","","",N,[[["v"],["wherepredicate"]]]],[5,"walk_fn_ret_ty","","",N,[[["v"],["functionretty"]]]],[5,"walk_fn_decl","","",N,[[["v"],["fndecl"]]]],[5,"walk_fn_kind","","",N,[[["v"],["fnkind"]]]],[5,"walk_fn","","",N,[[["v"],["fnkind"],["fndecl"],["bodyid"],["span"],["nodeid"]]]],[5,"walk_trait_item","","",N,[[["v"],["traititem"]]]],[5,"walk_trait_item_ref","","",N,[[["v"],["traititemref"]]]],[5,"walk_impl_item","","",N,[[["v"],["implitem"]]]],[5,"walk_impl_item_ref","","",N,[[["v"],["implitemref"]]]],[5,"walk_struct_def","","",N,[[["v"],["variantdata"]]]],[5,"walk_struct_field","","",N,[[["v"],["structfield"]]]],[5,"walk_block","","",N,[[["v"],["block"]]]],[5,"walk_stmt","","",N,[[["v"],["stmt"]]]],[5,"walk_decl","","",N,[[["v"],["decl"]]]],[5,"walk_anon_const","","",N,[[["v"],["anonconst"]]]],[5,"walk_expr","","",N,[[["v"],["expr"]]]],[5,"walk_arm","","",N,[[["v"],["arm"]]]],[5,"walk_vis","","",N,[[["v"],["visibility"]]]],[5,"walk_associated_item_kind","","",N,[[["v"],["associateditemkind"]]]],[5,"walk_defaultness","","",N,[[["v"],["defaultness"]]]],[8,"Visitor","","Each method of the Visitor trait is a hook to be potentially overridden.  Each method's default implementation recursively visits the substructure of the input via the corresponding `walk` method; e.g. the `visit_mod` method by default calls `intravisit::walk_mod`.",N,N],[10,"nested_visit_map","","The default versions of the `visit_nested_XXX` routines invoke this method to get a map to use. By selecting an enum variant, you control which kinds of nested HIR are visited; see `NestedVisitorMap` for details. By \"nested HIR\", we are referring to bits of HIR that are not directly embedded within one another but rather indirectly, through a table in the crate. This is done to control dependencies during incremental compilation: the non-inline bits of HIR can be tracked and hashed separately.",154,[[["self"]],["nestedvisitormap"]]],[11,"visit_nested_item","","Invoked when a nested item is encountered. By default does nothing unless you override `nested_visit_map` to return `Some(_)`, in which case it will walk the item. You probably don't want to override this method -- instead, override `nested_visit_map` or use the \"shallow\" or \"deep\" visit patterns described on `itemlikevisit::ItemLikeVisitor`. The only reason to override this method is if you want a nested pattern but cannot supply a `Map`; see `nested_visit_map` for advice.",154,[[["self"],["itemid"]]]],[11,"visit_nested_trait_item","","Like `visit_nested_item()`, but for trait items. See `visit_nested_item()` for advice on when to override this method.",154,[[["self"],["traititemid"]]]],[11,"visit_nested_impl_item","","Like `visit_nested_item()`, but for impl items. See `visit_nested_item()` for advice on when to override this method.",154,[[["self"],["implitemid"]]]],[11,"visit_nested_body","","Invoked to visit the body of a function, method or closure. Like visit_nested_item, does nothing by default unless you override `nested_visit_map` to return `Some(_)`, in which case it will walk the body.",154,[[["self"],["bodyid"]]]],[11,"visit_item","","Visit the top-level item and (optionally) nested items / impl items. See `visit_nested_item` for details.",154,[[["self"],["item"]]]],[11,"visit_body","","",154,[[["self"],["body"]]]],[11,"as_deep_visitor","","When invoking `visit_all_item_likes()`, you need to supply an item-like visitor.  This method converts a \"intra-visit\" visitor into an item-like visitor that walks the entire tree. If you use this, you probably don't want to process the contents of nested item-like things, since the outer loop will visit them as well.",154,[[["self"]],["deepvisitor"]]],[11,"visit_id","","",154,[[["self"],["nodeid"]]]],[11,"visit_def_mention","","",154,[[["self"],["def"]]]],[11,"visit_name","","",154,[[["self"],["span"],["name"]]]],[11,"visit_ident","","",154,[[["self"],["ident"]]]],[11,"visit_mod","","",154,[[["self"],["mod"],["span"],["nodeid"]]]],[11,"visit_foreign_item","","",154,[[["self"],["foreignitem"]]]],[11,"visit_local","","",154,[[["self"],["local"]]]],[11,"visit_block","","",154,[[["self"],["block"]]]],[11,"visit_stmt","","",154,[[["self"],["stmt"]]]],[11,"visit_arm","","",154,[[["self"],["arm"]]]],[11,"visit_pat","","",154,[[["self"],["pat"]]]],[11,"visit_decl","","",154,[[["self"],["decl"]]]],[11,"visit_anon_const","","",154,[[["self"],["anonconst"]]]],[11,"visit_expr","","",154,[[["self"],["expr"]]]],[11,"visit_ty","","",154,[[["self"],["ty"]]]],[11,"visit_generic_param","","",154,[[["self"],["genericparam"]]]],[11,"visit_generics","","",154,[[["self"],["generics"]]]],[11,"visit_where_predicate","","",154,[[["self"],["wherepredicate"]]]],[11,"visit_fn_decl","","",154,[[["self"],["fndecl"]]]],[11,"visit_fn","","",154,[[["self"],["fnkind"],["fndecl"],["bodyid"],["span"],["nodeid"]]]],[11,"visit_trait_item","","",154,[[["self"],["traititem"]]]],[11,"visit_trait_item_ref","","",154,[[["self"],["traititemref"]]]],[11,"visit_impl_item","","",154,[[["self"],["implitem"]]]],[11,"visit_impl_item_ref","","",154,[[["self"],["implitemref"]]]],[11,"visit_trait_ref","","",154,[[["self"],["traitref"]]]],[11,"visit_param_bound","","",154,[[["self"],["genericbound"]]]],[11,"visit_poly_trait_ref","","",154,[[["self"],["polytraitref"],["traitboundmodifier"]]]],[11,"visit_variant_data","","",154,[[["self"],["variantdata"],["name"],["generics"],["nodeid"],["span"]]]],[11,"visit_struct_field","","",154,[[["self"],["structfield"]]]],[11,"visit_enum_def","","",154,[[["self"],["enumdef"],["generics"],["nodeid"],["span"]]]],[11,"visit_variant","","",154,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_label","","",154,[[["self"],["label"]]]],[11,"visit_generic_arg","","",154,[[["self"],["genericarg"]]]],[11,"visit_lifetime","","",154,[[["self"],["lifetime"]]]],[11,"visit_qpath","","",154,[[["self"],["qpath"],["nodeid"],["span"]]]],[11,"visit_path","","",154,[[["self"],["path"],["nodeid"]]]],[11,"visit_path_segment","","",154,[[["self"],["span"],["pathsegment"]]]],[11,"visit_generic_args","","",154,[[["self"],["span"],["genericargs"]]]],[11,"visit_assoc_type_binding","","",154,[[["self"],["typebinding"]]]],[11,"visit_attribute","","",154,[[["self"],["attribute"]]]],[11,"visit_macro_def","","",154,[[["self"],["macrodef"]]]],[11,"visit_vis","","",154,[[["self"],["visibility"]]]],[11,"visit_associated_item_kind","","",154,[[["self"],["associateditemkind"]]]],[11,"visit_defaultness","","",154,[[["self"],["defaultness"]]]],[11,"clone","","",152,[[["self"]],["fnkind"]]],[11,"attrs","","",152,N],[11,"intra","","Returns the map to use for an \"intra item-like\" thing (if any). e.g., function body.",153,[[["self"]],["option",["map"]]]],[11,"inter","","Returns the map to use for an \"item-like\" thing (if any). e.g., item, impl-item.",153,[[["self"]],["option",["map"]]]],[11,"clone","","",150,[[["self"]],["idrange"]]],[11,"encode","","",150,[[["self"],["__s"]],["result"]]],[11,"decode","","",150,[[["__d"]],["result",["idrange"]]]],[11,"fmt","","",150,[[["self"],["formatter"]],["result"]]],[11,"max","","",150,[[],["idrange"]]],[11,"empty","","",150,[[["self"]],["bool"]]],[11,"contains","","",150,[[["self"],["nodeid"]],["bool"]]],[11,"add","","",150,[[["self"],["nodeid"]]]],[11,"new","","",151,[[["map"]],["idrangecomputingvisitor"]]],[11,"result","","",151,[[["self"]],["idrange"]]],[11,"nested_visit_map","","",151,[[["self"]],["nestedvisitormap"]]],[11,"visit_id","","",151,[[["self"],["nodeid"]]]],[0,"itemlikevisit","rustc::hir","",N,N],[3,"DeepVisitor","rustc::hir::itemlikevisit","",N,N],[12,"visitor","","",155,N],[3,"ParDeepVisitor","","",N,N],[12,"0","","",156,N],[8,"ItemLikeVisitor","","The \"item-like visitor\" visitor defines only the top-level methods that can be invoked by `Crate::visit_all_item_likes()`. Whether this trait is the right one to implement will depend on the overall pattern you need. Here are the three available patterns, in roughly the order of desirability:",N,N],[10,"visit_item","","",157,[[["self"],["item"]]]],[10,"visit_trait_item","","",157,[[["self"],["traititem"]]]],[10,"visit_impl_item","","",157,[[["self"],["implitem"]]]],[8,"ParItemLikeVisitor","","A parallel variant of ItemLikeVisitor",N,N],[10,"visit_item","","",158,[[["self"],["item"]]]],[10,"visit_trait_item","","",158,[[["self"],["traititem"]]]],[10,"visit_impl_item","","",158,[[["self"],["implitem"]]]],[8,"IntoVisitor","","",N,N],[16,"Visitor","","",159,N],[10,"into_visitor","","",159,N],[11,"new","","",155,[[["v"]],["self"]]],[11,"visit_item","","",155,[[["self"],["item"]]]],[11,"visit_trait_item","","",155,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",155,[[["self"],["implitem"]]]],[11,"visit_item","","",156,[[["self"],["item"]]]],[11,"visit_trait_item","","",156,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",156,[[["self"],["implitem"]]]],[0,"lowering","rustc::hir","Lowers the AST to the HIR.",N,N],[3,"LoweringContext","rustc::hir::lowering","",N,N],[12,"crate_root","","",160,N],[12,"sess","","",160,N],[12,"cstore","","",160,N],[12,"resolver","","",160,N],[12,"items","","The items being lowered are collected here.",160,N],[12,"trait_items","","",160,N],[12,"impl_items","","",160,N],[12,"bodies","","",160,N],[12,"exported_macros","","",160,N],[12,"trait_impls","","",160,N],[12,"trait_auto_impl","","",160,N],[12,"is_generator","","",160,N],[12,"catch_scopes","","",160,N],[12,"loop_scopes","","",160,N],[12,"is_in_loop_condition","","",160,N],[12,"is_in_trait_impl","","",160,N],[12,"anonymous_lifetime_mode","","What to do when we encounter either an \"anonymous lifetime reference\". The term \"anonymous\" is meant to encompass both `'_` lifetimes as well as fully elided cases where nothing is written at all (e.g., `&T` or `std::cell::Ref<T>`).",160,N],[12,"lifetimes_to_define","","",160,N],[12,"is_collecting_in_band_lifetimes","","",160,N],[12,"in_scope_lifetimes","","",160,N],[12,"type_def_lifetime_params","","",160,N],[12,"current_hir_id_owner","","",160,N],[12,"item_local_id_counters","","",160,N],[12,"node_id_to_hir_id","","",160,N],[3,"LoweredNodeId","","",N,N],[12,"node_id","","",161,N],[12,"hir_id","","",161,N],[4,"ImplTraitContext","","",N,N],[13,"Universal","","Treat `impl Trait` as shorthand for a new universal generic parameter. Example: `fn foo(x: impl Debug)`, where `impl Debug` is conceptually equivalent to a fresh universal parameter like `fn foo<T: Debug>(x: T)`.",162,N],[13,"Existential","","Treat `impl Trait` as shorthand for a new universal existential parameter. Example: `fn foo() -> impl Debug`, where `impl Debug` is conceptually equivalent to a fresh existential parameter like `abstract type T; fn foo() -> T`.",162,N],[13,"Disallowed","","`impl Trait` is not accepted in this position.",162,N],[4,"ParamMode","","",N,N],[13,"Explicit","","Any path in a type context.",163,N],[13,"Optional","","The `module::Type` in `module::Type::method` in an expression.",163,N],[4,"ParenthesizedGenericArgs","","",N,N],[13,"Ok","","",164,N],[13,"Warn","","",164,N],[13,"Err","","",164,N],[4,"AnonymousLifetimeMode","","What to do when we encounter an anonymous lifetime reference. Anonymous lifetime references come in two flavors.  You have implicit, or fully elided, references to lifetimes, like the one in `&T` or `Ref<T>`, and you have `'_` lifetimes, like `&'_ T` or `Ref<'_, T>`.  These often behave the same, but not always:",N,N],[13,"CreateParameter","","For Modern cases, create a new anonymous region parameter and reference that.",165,N],[13,"PassThrough","","Pass responsibility to `resolve_lifetime` code for all cases.",165,N],[5,"lower_crate","","",N,[[["session"],["cratestore"],["depgraph"],["crate"],["resolver"]],["crate"]]],[5,"body_ids","","",N,[[["btreemap"]],["vec",["bodyid"]]]],[22,"","","",N,N],[17,"HIR_ID_COUNTER_LOCKED","","",N,N],[8,"Resolver","","",N,N],[10,"resolve_hir_path","","Resolve a hir path generated by the lowerer when expanding `for`, `if let`, etc.",166,[[["self"],["path"],["bool"]]]],[10,"get_resolution","","Obtain the resolution for a node id",166,[[["self"],["nodeid"]],["option",["pathresolution"]]]],[10,"get_import","","Obtain the possible resolutions for the given `use` statement.",166,[[["self"],["nodeid"]],["perns",["option"]]]],[10,"definitions","","We must keep the set of definitions up to date as we add nodes that weren't in the AST. This should only return `None` during testing.",166,[[["self"]],["definitions"]]],[10,"resolve_str_path","","Given suffix [\"b\",\"c\",\"d\"], creates a HIR path for `[::crate_root]::b::c::d` and resolves it based on `is_value`.",166,N],[11,"fmt","","",162,[[["self"],["formatter"]],["result"]]],[11,"reborrow","","",162,[[["self"]],["impltraitcontext"]]],[11,"clone","","",163,[[["self"]],["parammode"]]],[11,"eq","","",163,[[["self"],["parammode"]],["bool"]]],[11,"fmt","","",161,[[["self"],["formatter"]],["result"]]],[11,"clone","","",165,[[["self"]],["anonymouslifetimemode"]]],[11,"lower_crate","","",160,[[["self"],["crate"]],["crate"]]],[11,"allocate_hir_id_counter","","",160,[[["self"],["nodeid"],["t"]],["lowerednodeid"]]],[11,"lower_node_id_generic","","",160,[[["self"],["nodeid"],["f"]],["lowerednodeid"]]],[11,"with_hir_id_owner","","",160,[[["self"],["nodeid"],["f"]],["t"]]],[11,"lower_node_id","","This method allocates a new HirId for the given NodeId and stores it in the LoweringContext's NodeId => HirId map. Take care not to call this method if the resulting HirId is then not actually used in the HIR, as that would trigger an assertion in the HirIdValidator later on, which makes sure that all NodeIds got mapped properly. Calling the method twice with the same NodeId is fine though.",160,[[["self"],["nodeid"]],["lowerednodeid"]]],[11,"lower_node_id_with_owner","","",160,[[["self"],["nodeid"],["nodeid"]],["lowerednodeid"]]],[11,"record_body","","",160,[[["self"],["expr"],["option",["fndecl"]]],["bodyid"]]],[11,"next_id","","",160,[[["self"]],["lowerednodeid"]]],[11,"expect_full_def","","",160,[[["self"],["nodeid"]],["def"]]],[11,"expect_full_def_from_use","","",160,[[["self"],["nodeid"]],[""]]],[11,"diagnostic","","",160,[[["self"]],["handler"]]],[11,"str_to_ident","","",160,[[["self"],["str"]],["ident"]]],[11,"allow_internal_unstable","","",160,[[["self"],["compilerdesugaringkind"],["span"]],["span"]]],[11,"with_anonymous_lifetime_mode","","",160,N],[11,"collect_in_band_defs","","Creates a new hir::GenericParam for every new lifetime and type parameter encountered while evaluating `f`. Definitions are created with the parent provided. If no `parent_id` is provided, no definitions will be returned.",160,N],[11,"maybe_collect_in_band_lifetime","","When there is a reference to some lifetime `'a`, and in-band lifetimes are enabled, then we want to push that lifetime into the vector of names to define later. In that case, it will get added to the appropriate generics.",160,[[["self"],["ident"]]]],[11,"collect_fresh_in_band_lifetime","","When we have either an elided or `'_` lifetime in an impl header, we convert it to",160,[[["self"],["span"]],["paramname"]]],[11,"with_in_scope_lifetime_defs","","",160,N],[11,"with_parent_impl_lifetime_defs","","",160,[[["self"],["hirvec"],["f"]],["t"]]],[11,"add_in_band_defs","","Appends in-band lifetime defs and argument-position `impl Trait` defs to the existing set of generics.",160,N],[11,"with_catch_scope","","",160,[[["self"],["nodeid"],["f"]],["t"]]],[11,"make_async_expr","","",160,N],[11,"lower_body","","",160,[[["self"],["option",["fndecl"]],["f"]],["bodyid"]]],[11,"with_loop_scope","","",160,[[["self"],["nodeid"],["f"]],["t"]]],[11,"with_loop_condition_scope","","",160,[[["self"],["f"]],["t"]]],[11,"with_new_scopes","","",160,[[["self"],["f"]],["t"]]],[11,"def_key","","",160,[[["self"],["defid"]],["defkey"]]],[11,"lower_label","","",160,[[["self"],["option",["label"]]],["option",["label"]]]],[11,"lower_loop_destination","","",160,[[["self"],["option"]],["destination"]]],[11,"lower_attrs","","",160,N],[11,"lower_attr","","",160,[[["self"],["attribute"]],["attribute"]]],[11,"lower_token_stream","","",160,[[["self"],["tokenstream"]],["tokenstream"]]],[11,"lower_token_tree","","",160,[[["self"],["tokentree"]],["tokenstream"]]],[11,"lower_token","","",160,[[["self"],["token"],["span"]],["tokenstream"]]],[11,"lower_arm","","",160,[[["self"],["arm"]],["arm"]]],[11,"lower_ty_binding","","",160,[[["self"],["typebinding"],["impltraitcontext"]],["typebinding"]]],[11,"lower_generic_arg","","",160,[[["self"],["genericarg"],["impltraitcontext"]],["genericarg"]]],[11,"lower_ty","","",160,[[["self"],["ty"],["impltraitcontext"]],["p",["ty"]]]],[11,"lower_ty_direct","","",160,[[["self"],["ty"],["impltraitcontext"]],["ty"]]],[11,"lower_existential_impl_trait","","",160,N],[11,"lifetimes_from_impl_trait_bounds","","",160,N],[11,"lower_foreign_mod","","",160,[[["self"],["foreignmod"]],["foreignmod"]]],[11,"lower_global_asm","","",160,[[["self"],["globalasm"]],["p",["globalasm"]]]],[11,"lower_variant","","",160,[[["self"],["variant"]],["variant"]]],[11,"lower_qpath","","",160,[[["self"],["nodeid"],["option"],["path"],["parammode"],["impltraitcontext"]],["qpath"]]],[11,"lower_path_extra","","",160,[[["self"],["def"],["path"],["option",["ident"]],["parammode"]],["path"]]],[11,"lower_path","","",160,[[["self"],["nodeid"],["path"],["parammode"]],["path"]]],[11,"lower_path_segment","","",160,[[["self"],["span"],["pathsegment"],["parammode"],["usize"],["parenthesizedgenericargs"],["impltraitcontext"]],["pathsegment"]]],[11,"lower_angle_bracketed_parameter_data","","",160,N],[11,"lower_parenthesized_parameter_data","","",160,N],[11,"lower_local","","",160,[[["self"],["local"]],["p",["local"]]]],[11,"lower_mutability","","",160,[[["self"],["mutability"]],["mutability"]]],[11,"lower_arg","","",160,[[["self"],["arg"]],["arg"]]],[11,"lower_fn_args_to_names","","",160,[[["self"],["fndecl"]],["hirvec",["ident"]]]],[11,"lower_fn_decl","","",160,[[["self"],["fndecl"],["option"],["bool"],["option",["nodeid"]]],["p",["fndecl"]]]],[11,"lower_async_fn_ret_ty","","",160,N],[11,"lower_param_bound","","",160,[[["self"],["genericbound"],["impltraitcontext"]],["genericbound"]]],[11,"lower_lifetime","","",160,[[["self"],["lifetime"]],["lifetime"]]],[11,"new_named_lifetime","","",160,[[["self"],["nodeid"],["span"],["lifetimename"]],["lifetime"]]],[11,"lower_generic_params","","",160,N],[11,"lower_generic_param","","",160,[[["self"],["genericparam"],["nodemap"],["impltraitcontext"]],["genericparam"]]],[11,"lower_generics","","",160,[[["self"],["generics"],["impltraitcontext"]],["generics"]]],[11,"lower_where_clause","","",160,[[["self"],["whereclause"]],["whereclause"]]],[11,"lower_where_predicate","","",160,[[["self"],["wherepredicate"]],["wherepredicate"]]],[11,"lower_variant_data","","",160,[[["self"],["variantdata"]],["variantdata"]]],[11,"lower_trait_ref","","",160,[[["self"],["traitref"],["impltraitcontext"]],["traitref"]]],[11,"lower_poly_trait_ref","","",160,[[["self"],["polytraitref"],["impltraitcontext"]],["polytraitref"]]],[11,"lower_struct_field","","",160,N],[11,"lower_field","","",160,[[["self"],["field"]],["field"]]],[11,"lower_mt","","",160,[[["self"],["mutty"],["impltraitcontext"]],["mutty"]]],[11,"lower_param_bounds","","",160,N],[11,"lower_block","","",160,[[["self"],["block"],["bool"]],["p",["block"]]]],[11,"lower_async_body","","",160,[[["self"],["fndecl"],["isasync"],["block"]],["bodyid"]]],[11,"lower_item_kind","","",160,[[["self"],["nodeid"],["name"],["hirvec"],["visibility"],["itemkind"]],["itemkind"]]],[11,"lower_use_tree","","",160,[[["self"],["usetree"],["path"],["nodeid"],["visibility"],["name"],["hirvec"]],["itemkind"]]],[11,"lower_trait_item","","",160,[[["self"],["traititem"]],["traititem"]]],[11,"lower_trait_item_ref","","",160,[[["self"],["traititem"]],["traititemref"]]],[11,"lower_impl_item","","",160,[[["self"],["implitem"]],["implitem"]]],[11,"lower_impl_item_ref","","",160,[[["self"],["implitem"]],["implitemref"]]],[11,"lower_mod","","",160,[[["self"],["mod"]],["mod"]]],[11,"lower_impl_trait_ids","","Lowers `impl Trait` items and appends them to the list",160,[[["self"],["fndecl"],["fnheader"],["smallvector"]]]],[11,"lower_item_id","","",160,[[["self"],["item"]],["smallvector",["itemid"]]]],[11,"lower_item_id_use_tree","","",160,[[["self"],["usetree"],["nodeid"],["smallvector"]]]],[11,"lower_item","","",160,[[["self"],["item"]],["option",["item"]]]],[11,"lower_foreign_item","","",160,[[["self"],["foreignitem"]],["foreignitem"]]],[11,"lower_method_sig","","",160,N],[11,"lower_is_auto","","",160,[[["self"],["isauto"]],["isauto"]]],[11,"lower_fn_header","","",160,[[["self"],["fnheader"]],["fnheader"]]],[11,"lower_unsafety","","",160,[[["self"],["unsafety"]],["unsafety"]]],[11,"lower_constness","","",160,[[["self"],["spanned",["constness"]]],["constness"]]],[11,"lower_asyncness","","",160,[[["self"],["isasync"]],["isasync"]]],[11,"lower_unop","","",160,[[["self"],["unop"]],["unop"]]],[11,"lower_binop","","",160,[[["self"],["binop"]],["binop"]]],[11,"lower_pat","","",160,[[["self"],["pat"]],["p",["pat"]]]],[11,"lower_range_end","","",160,[[["self"],["rangeend"]],["rangeend"]]],[11,"lower_anon_const","","",160,[[["self"],["anonconst"]],["anonconst"]]],[11,"lower_expr","","",160,[[["self"],["expr"]],["expr"]]],[11,"lower_stmt","","",160,[[["self"],["stmt"]],["smallvector",["stmt"]]]],[11,"lower_capture_clause","","",160,[[["self"],["captureby"]],["captureclause"]]],[11,"lower_visibility","","If an `explicit_owner` is given, this method allocates the `HirId` in the address space of that item instead of the item currently being lowered. This can happen during `lower_impl_item_ref()` where we need to lower a `Visibility` value although we haven't lowered the owning `ImplItem` in question yet.",160,[[["self"],["visibility"],["option",["nodeid"]]],["visibility"]]],[11,"lower_defaultness","","",160,[[["self"],["defaultness"],["bool"]],["defaultness"]]],[11,"lower_block_check_mode","","",160,[[["self"],["blockcheckmode"]],["blockcheckmode"]]],[11,"lower_binding_mode","","",160,[[["self"],["bindingmode"]],["bindingannotation"]]],[11,"lower_unsafe_source","","",160,[[["self"],["unsafesource"]],["unsafesource"]]],[11,"lower_impl_polarity","","",160,[[["self"],["implpolarity"]],["implpolarity"]]],[11,"lower_trait_bound_modifier","","",160,[[["self"],["traitboundmodifier"]],["traitboundmodifier"]]],[11,"arm","","",160,[[["self"],["hirvec",["p"]],["p",["expr"]]],["arm"]]],[11,"field","","",160,[[["self"],["ident"],["p",["expr"]],["span"]],["field"]]],[11,"expr_break","","",160,[[["self"],["span"],["thinvec",["attribute"]]],["p",["expr"]]]],[11,"expr_call","","",160,[[["self"],["span"],["p",["expr"]],["hirvec",["expr"]]],["expr"]]],[11,"expr_ident","","",160,[[["self"],["span"],["ident"],["nodeid"]],["expr"]]],[11,"expr_ident_with_attrs","","",160,[[["self"],["span"],["ident"],["nodeid"],["thinvec",["attribute"]]],["expr"]]],[11,"expr_mut_addr_of","","",160,[[["self"],["span"],["p",["expr"]]],["expr"]]],[11,"expr_std_path","","",160,N],[11,"expr_match","","",160,[[["self"],["span"],["p",["expr"]],["hirvec",["arm"]],["matchsource"]],["expr"]]],[11,"expr_block","","",160,[[["self"],["p",["block"]],["thinvec",["attribute"]]],["expr"]]],[11,"expr_tuple","","",160,[[["self"],["span"],["hirvec",["expr"]]],["p",["expr"]]]],[11,"expr","","",160,[[["self"],["span"],["exprkind"],["thinvec",["attribute"]]],["expr"]]],[11,"stmt_let_pat","","",160,[[["self"],["span"],["option",["p"]],["p",["pat"]],["localsource"]],["stmt"]]],[11,"stmt_let","","",160,N],[11,"block_expr","","",160,[[["self"],["p",["expr"]]],["block"]]],[11,"block_all","","",160,[[["self"],["span"],["hirvec",["stmt"]],["option",["p"]]],["block"]]],[11,"pat_ok","","",160,[[["self"],["span"],["p",["pat"]]],["p",["pat"]]]],[11,"pat_err","","",160,[[["self"],["span"],["p",["pat"]]],["p",["pat"]]]],[11,"pat_some","","",160,[[["self"],["span"],["p",["pat"]]],["p",["pat"]]]],[11,"pat_none","","",160,[[["self"],["span"]],["p",["pat"]]]],[11,"pat_std_enum","","",160,N],[11,"pat_ident","","",160,[[["self"],["span"],["ident"]],["p",["pat"]]]],[11,"pat_ident_binding_mode","","",160,[[["self"],["span"],["ident"],["bindingannotation"]],["p",["pat"]]]],[11,"pat_wild","","",160,[[["self"],["span"]],["p",["pat"]]]],[11,"pat","","",160,[[["self"],["span"],["patkind"]],["p",["pat"]]]],[11,"std_path","","Given suffix [\"b\",\"c\",\"d\"], returns path `::std::b::c::d` when `fld.cx.use_std`, and `::core::b::c::d` otherwise. The path is also resolved according to `is_value`.",160,N],[11,"ty_path","","",160,[[["self"],["lowerednodeid"],["span"],["qpath"]],["ty"]]],[11,"elided_ref_lifetime","","Invoked to create the lifetime argument for a type `&T` with no explicit lifetime.",160,[[["self"],["span"]],["lifetime"]]],[11,"elided_path_lifetimes","","Invoked to create the lifetime argument(s) for a path like `std::cell::Ref<T>`; note that implicit lifetimes in these sorts of cases are deprecated. This may therefore report a warning or an error, depending on the mode.",160,[[["self"],["span"],["usize"]],["p"]]],[11,"elided_dyn_bound","","Invoked to create the lifetime argument(s) for an elided trait object bound, like the bound in `Box<dyn Debug>`. This method is not invoked when the bound is written, even if it is written with `'_` like in `Box<dyn Debug + '_>`. In those cases, `lower_lifetime` is invoked.",160,[[["self"],["span"]],["lifetime"]]],[11,"new_implicit_lifetime","","",160,[[["self"],["span"]],["lifetime"]]],[11,"maybe_lint_bare_trait","","",160,[[["self"],["span"],["nodeid"],["bool"]]]],[11,"wrap_in_try_constructor","","",160,[[["self"],["str"],["expr"],["span"]],["p",["expr"]]]],[0,"map","rustc::hir","",N,N],[3,"DefCollector","rustc::hir::map","Creates def ids for nodes in the AST.",N,N],[12,"definitions","","",167,N],[12,"parent_def","","",167,N],[12,"expansion","","",167,N],[12,"visit_macro_invoc","","",167,N],[3,"MacroInvocationData","","",N,N],[12,"mark","","",168,N],[12,"def_index","","",168,N],[3,"Forest","","Stores a crate and any number of inlined items from other crates.",N,N],[12,"krate","","",169,N],[12,"dep_graph","","",169,N],[3,"Map","","Represents a mapping from Node IDs to AST elements and their parent Node IDs",N,N],[12,"forest","","The backing storage for all the AST nodes.",170,N],[12,"dep_graph","","Same as the dep_graph in forest, just available with one fewer deref. This is a gratuitous micro-optimization.",170,N],[12,"crate_hash","","The SVH of the local crate.",170,N],[12,"map","","NodeIds are sequential integers from 0, so we can be super-compact by storing them in a vector. Not everything with a NodeId is in the map, but empirically the occupancy is about 75-80%, so there's not too much overhead (certainly less than a hashmap, since they (at the time of writing) have a maximum of 75% occupancy).",170,N],[12,"definitions","","",170,N],[12,"hir_to_node_id","","The reverse mapping of `node_to_hir_id`.",170,N],[3,"NodesMatchingSuffix","","",N,N],[12,"map","","",171,N],[12,"item_name","","",171,N],[12,"in_which","","",171,N],[12,"idx","","",171,N],[4,"Node","","",N,N],[13,"NodeItem","","",172,N],[13,"NodeForeignItem","","",172,N],[13,"NodeTraitItem","","",172,N],[13,"NodeImplItem","","",172,N],[13,"NodeVariant","","",172,N],[13,"NodeField","","",172,N],[13,"NodeAnonConst","","",172,N],[13,"NodeExpr","","",172,N],[13,"NodeStmt","","",172,N],[13,"NodeTy","","",172,N],[13,"NodeTraitRef","","",172,N],[13,"NodeBinding","","",172,N],[13,"NodePat","","",172,N],[13,"NodeBlock","","",172,N],[13,"NodeLocal","","",172,N],[13,"NodeMacroDef","","",172,N],[13,"NodeStructCtor","","NodeStructCtor represents a tuple struct.",172,N],[13,"NodeLifetime","","",172,N],[13,"NodeGenericParam","","",172,N],[13,"NodeVisibility","","",172,N],[4,"MapEntry","","Represents an entry and its parent NodeID. The odd layout is to bring down the total size.",N,N],[13,"NotPresent","","Placeholder for holes in the map.",173,N],[13,"EntryItem","","All the node types, with a parent ID.",173,N],[13,"EntryForeignItem","","",173,N],[13,"EntryTraitItem","","",173,N],[13,"EntryImplItem","","",173,N],[13,"EntryVariant","","",173,N],[13,"EntryField","","",173,N],[13,"EntryAnonConst","","",173,N],[13,"EntryExpr","","",173,N],[13,"EntryStmt","","",173,N],[13,"EntryTy","","",173,N],[13,"EntryTraitRef","","",173,N],[13,"EntryBinding","","",173,N],[13,"EntryPat","","",173,N],[13,"EntryBlock","","",173,N],[13,"EntryStructCtor","","",173,N],[13,"EntryLifetime","","",173,N],[13,"EntryGenericParam","","",173,N],[13,"EntryVisibility","","",173,N],[13,"EntryLocal","","",173,N],[13,"EntryMacroDef","","",173,N],[13,"RootCrate","","Roots for node trees. The DepNodeIndex is the dependency node of the crate's root module.",173,N],[5,"map_crate","","",N,[[["session"],["cratestore"],["forest"],["definitions"]],["map"]]],[5,"node_id_to_string","","",N,[[["map"],["nodeid"],["bool"]],["string"]]],[5,"describe_def","","",N,[[["tyctxt"],["defid"]],["option",["def"]]]],[0,"blocks","","This module provides a simplified abstraction for working with code blocks identified by their integer node-id.  In particular, it captures a common set of attributes that all \"function-like things\" (represented by `FnLike` instances) share.  For example, all `FnLike` instances have a type signature (be it explicit or inferred).  And all `FnLike` instances have a body, i.e. the code that is run when the function-like thing it represents is invoked.",N,N],[3,"FnLikeNode","rustc::hir::map::blocks","An FnLikeNode is a Node that is like a fn, in that it has a decl and a body (as well as a NodeId, a span, etc).",N,N],[12,"node","","",174,N],[3,"ItemFnParts","","These are all the components one can extract from a fn item for use when implementing FnLikeNode operations.",N,N],[12,"name","","",175,N],[12,"decl","","",175,N],[12,"header","","",175,N],[12,"vis","","",175,N],[12,"generics","","",175,N],[12,"body","","",175,N],[12,"id","","",175,N],[12,"span","","",175,N],[12,"attrs","","",175,N],[3,"ClosureParts","","These are all the components one can extract from a closure expr for use when implementing FnLikeNode operations.",N,N],[12,"decl","","",176,N],[12,"body","","",176,N],[12,"id","","",176,N],[12,"span","","",176,N],[12,"attrs","","",176,N],[4,"Code","","Carries either an FnLikeNode or a Expr, as these are the two constructs that correspond to \"code\" (as in, something from which we can construct a control-flow graph).",N,N],[13,"FnLike","","",177,N],[13,"Expr","","",177,N],[8,"MaybeFnLike","","MaybeFnLike wraps a method that indicates if an object corresponds to some FnLikeNode.",N,N],[10,"is_fn_like","","",178,[[["self"]],["bool"]]],[11,"clone","","",174,[[["self"]],["fnlikenode"]]],[11,"fmt","","",174,[[["self"],["formatter"]],["result"]]],[11,"is_fn_like","rustc::hir","",83,[[["self"]],["bool"]]],[11,"is_fn_like","","",65,[[["self"]],["bool"]]],[11,"is_fn_like","","",63,[[["self"]],["bool"]]],[11,"is_fn_like","","",58,[[["self"]],["bool"]]],[11,"clone","rustc::hir::map::blocks","",177,[[["self"]],["code"]]],[11,"id","","",177,[[["self"]],["nodeid"]]],[11,"from_node","","Attempts to construct a Code from presumed FnLike or Expr node input.",177,[[["map"],["nodeid"]],["option",["code"]]]],[11,"new","","",176,N],[11,"from_node","","Attempts to construct a FnLikeNode from presumed FnLike node input.",174,[[["node"]],["option",["fnlikenode"]]]],[11,"body","","",174,[[["self"]],["bodyid"]]],[11,"decl","","",174,[[["self"]],["fndecl"]]],[11,"span","","",174,[[["self"]],["span"]]],[11,"id","","",174,[[["self"]],["nodeid"]]],[11,"constness","","",174,[[["self"]],["constness"]]],[11,"asyncness","","",174,[[["self"]],["isasync"]]],[11,"unsafety","","",174,[[["self"]],["unsafety"]]],[11,"kind","","",174,[[["self"]],["fnkind"]]],[11,"handle","","",174,[[["self"],["i"],["m"],["c"]],["a"]]],[0,"collector","rustc::hir::map","",N,N],[3,"NodeCollector","rustc::hir::map::collector","A Visitor that walks over the HIR and collects Nodes into a HIR map",N,N],[12,"krate","","The crate",179,N],[12,"map","","The node map",179,N],[12,"parent_node","","The parent of this node",179,N],[12,"current_dep_node_owner","","",179,N],[12,"current_signature_dep_index","","",179,N],[12,"current_full_dep_index","","",179,N],[12,"currently_in_body","","",179,N],[12,"dep_graph","","",179,N],[12,"definitions","","",179,N],[12,"hcx","","",179,N],[12,"hir_body_nodes","","",179,N],[3,"HirItemLike","","",N,N],[12,"item_like","","",180,N],[12,"hash_bodies","","",180,N],[11,"root","","",179,[[["crate"],["depgraph"],["definitions"],["stablehashingcontext"]],["nodecollector"]]],[11,"finalize_and_compute_crate_hash","","",179,N],[11,"insert_entry","","",179,[[["self"],["nodeid"],["mapentry"]]]],[11,"insert","","",179,[[["self"],["nodeid"],["node"]]]],[11,"with_parent","","",179,[[["self"],["nodeid"],["f"]]]],[11,"with_dep_node_owner","","",179,[[["self"],["defindex"],["t"],["f"]]]],[11,"nested_visit_map","","Because we want to track parent items and so forth, enable deep walking so that we walk nested items in the context of their outer items.",179,[[["self"]],["nestedvisitormap"]]],[11,"visit_nested_item","","",179,[[["self"],["itemid"]]]],[11,"visit_nested_trait_item","","",179,[[["self"],["traititemid"]]]],[11,"visit_nested_impl_item","","",179,[[["self"],["implitemid"]]]],[11,"visit_nested_body","","",179,[[["self"],["bodyid"]]]],[11,"visit_item","","",179,[[["self"],["item"]]]],[11,"visit_foreign_item","","",179,[[["self"],["foreignitem"]]]],[11,"visit_generic_param","","",179,[[["self"],["genericparam"]]]],[11,"visit_trait_item","","",179,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",179,[[["self"],["implitem"]]]],[11,"visit_pat","","",179,[[["self"],["pat"]]]],[11,"visit_anon_const","","",179,[[["self"],["anonconst"]]]],[11,"visit_expr","","",179,[[["self"],["expr"]]]],[11,"visit_stmt","","",179,[[["self"],["stmt"]]]],[11,"visit_ty","","",179,[[["self"],["ty"]]]],[11,"visit_trait_ref","","",179,[[["self"],["traitref"]]]],[11,"visit_fn","","",179,[[["self"],["fnkind"],["fndecl"],["bodyid"],["span"],["nodeid"]]]],[11,"visit_block","","",179,[[["self"],["block"]]]],[11,"visit_local","","",179,[[["self"],["local"]]]],[11,"visit_lifetime","","",179,[[["self"],["lifetime"]]]],[11,"visit_vis","","",179,[[["self"],["visibility"]]]],[11,"visit_macro_def","","",179,[[["self"],["macrodef"]]]],[11,"visit_variant","","",179,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_struct_field","","",179,[[["self"],["structfield"]]]],[11,"visit_trait_item_ref","","",179,[[["self"],["traititemref"]]]],[11,"visit_impl_item_ref","","",179,[[["self"],["implitemref"]]]],[11,"hash_stable","","",180,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[0,"def_collector","rustc::hir::map","",N,N],[3,"DefCollector","rustc::hir::map::def_collector","Creates def ids for nodes in the AST.",N,N],[12,"definitions","","",167,N],[12,"parent_def","","",167,N],[12,"expansion","","",167,N],[12,"visit_macro_invoc","","",167,N],[3,"MacroInvocationData","","",N,N],[12,"mark","","",168,N],[12,"def_index","","",168,N],[11,"new","rustc::hir::map","",167,[[["definitions"],["mark"]],["self"]]],[11,"collect_root","","",167,[[["self"],["str"],["cratedisambiguator"]]]],[11,"create_def","","",167,[[["self"],["nodeid"],["defpathdata"],["defindexaddressspace"],["span"]],["defindex"]]],[11,"with_parent","","",167,[[["self"],["defindex"],["f"]]]],[11,"visit_async_fn","","",167,N],[11,"visit_macro_invoc","","",167,[[["self"],["nodeid"]]]],[11,"visit_item","","",167,[[["self"],["item"]]]],[11,"visit_use_tree","","",167,[[["self"],["usetree"],["nodeid"],["bool"]]]],[11,"visit_foreign_item","","",167,[[["self"],["foreignitem"]]]],[11,"visit_variant","","",167,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_variant_data","","",167,[[["self"],["variantdata"],["ident"],["generics"],["nodeid"],["span"]]]],[11,"visit_generic_param","","",167,[[["self"],["genericparam"]]]],[11,"visit_trait_item","","",167,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",167,[[["self"],["implitem"]]]],[11,"visit_pat","","",167,[[["self"],["pat"]]]],[11,"visit_anon_const","","",167,[[["self"],["anonconst"]]]],[11,"visit_expr","","",167,[[["self"],["expr"]]]],[11,"visit_ty","","",167,[[["self"],["ty"]]]],[11,"visit_stmt","","",167,[[["self"],["stmt"]]]],[11,"visit_token","","",167,[[["self"],["token"]]]],[0,"definitions","","For each definition, we track the following data.  A definition here is defined somewhat circularly as \"something with a def-id\", but it generally corresponds to things like structs, enums, etc. There are also some rather random cases (like const initializer expressions) that are mostly just leftovers.",N,N],[3,"DefPathTable","rustc::hir::map::definitions","The DefPathTable maps DefIndexes to DefKeys and vice versa. Internally the DefPathTable holds a tree of DefKeys, where each DefKey stores the DefIndex of its parent. There is one DefPathTable for each crate.",N,N],[12,"index_to_key","","",181,N],[12,"def_path_hashes","","",181,N],[3,"Definitions","","The definition table containing node definitions. It holds the DefPathTable for local DefIds/DefPaths and it also stores a mapping from NodeIds to local DefIds.",N,N],[12,"table","","",182,N],[12,"node_to_def_index","","",182,N],[12,"def_index_to_node","","",182,N],[12,"node_to_hir_id","","",182,N],[12,"parent_modules_of_macro_defs","","If `Mark` is an ID of some macro expansion, then `DefId` is the normal module (`mod`) in which the expanded macro was defined.",182,N],[12,"expansions_that_defined","","Item with a given `DefIndex` was defined during macro expansion with ID `Mark`.",182,N],[12,"next_disambiguator","","",182,N],[12,"def_index_to_span","","",182,N],[3,"DefKey","","A unique identifier that we can use to lookup a definition precisely. It combines the index of the definition's parent (if any) with a `DisambiguatedDefPathData`.",N,N],[12,"parent","","Parent path.",183,N],[12,"disambiguated_data","","Identifier of this node.",183,N],[3,"DisambiguatedDefPathData","","Pair of `DefPathData` and an integer disambiguator. The integer is normally 0, but in the event that there are multiple defs with the same `parent` and `data`, we use this field to disambiguate between them. This introduces some artificial ordering dependency but means that if you have (e.g.) two impls for the same type in the same module, they do get distinct def-ids.",N,N],[12,"data","","",184,N],[12,"disambiguator","","",184,N],[3,"DefPath","","",N,N],[12,"data","","the path leading from the crate root to the item",185,N],[12,"krate","","what krate root is this path relative to?",185,N],[3,"DefPathHash","","",N,N],[12,"0","","",186,N],[4,"DefPathData","","",N,N],[13,"CrateRoot","","The crate root (marker)",187,N],[13,"Misc","","",187,N],[13,"Impl","","An impl",187,N],[13,"Trait","","A trait",187,N],[13,"AssocTypeInTrait","","An associated type declaration (i.e., in a trait)",187,N],[13,"AssocTypeInImpl","","An associated type value (i.e., in an impl)",187,N],[13,"AssocExistentialInImpl","","An existential associated type value (i.e., in an impl)",187,N],[13,"TypeNs","","Something in the type NS",187,N],[13,"ValueNs","","Something in the value NS",187,N],[13,"Module","","A module declaration",187,N],[13,"MacroDef","","A macro rule",187,N],[13,"ClosureExpr","","A closure expression",187,N],[13,"TypeParam","","A type parameter (generic parameter)",187,N],[13,"LifetimeParam","","A lifetime definition",187,N],[13,"EnumVariant","","A variant of a enum",187,N],[13,"Field","","A struct field",187,N],[13,"StructCtor","","Implicit ctor for a tuple-like struct",187,N],[13,"AnonConst","","A constant expression (see {ast,hir}::AnonConst).",187,N],[13,"ImplTrait","","An `impl Trait` type node",187,N],[13,"GlobalMetaData","","GlobalMetaData identifies a piece of crate metadata that is global to a whole crate (as opposed to just one item). GlobalMetaData components are only supposed to show up right below the crate root.",187,N],[4,"GlobalMetaDataKind","","",N,N],[13,"Krate","","",188,N],[13,"CrateDeps","","",188,N],[13,"DylibDependencyFormats","","",188,N],[13,"LangItems","","",188,N],[13,"LangItemsMissing","","",188,N],[13,"NativeLibraries","","",188,N],[13,"CodeMap","","",188,N],[13,"Impls","","",188,N],[13,"ExportedSymbols","","",188,N],[17,"GLOBAL_MD_ADDRESS_SPACE","","",N,N],[11,"clone","","",181,[[["self"]],["self"]]],[11,"allocate","","",181,[[["self"],["defkey"],["defpathhash"],["defindexaddressspace"]],["defindex"]]],[11,"next_id","","",181,[[["self"],["defindexaddressspace"]],["defindex"]]],[11,"def_key","","",181,[[["self"],["defindex"]],["defkey"]]],[11,"def_path_hash","","",181,[[["self"],["defindex"]],["defpathhash"]]],[11,"add_def_path_hashes_to","","",181,[[["self"],["cratenum"],["fxhashmap"]]]],[11,"size","","",181,[[["self"]],["usize"]]],[11,"encode","","",181,[[["self"],["s"]],["result"]]],[11,"decode","","",181,[[["d"]],["result",["defpathtable"]]]],[11,"clone","","",182,[[["self"]],["definitions"]]],[11,"clone","","",183,[[["self"]],["defkey"]]],[11,"eq","","",183,[[["self"],["defkey"]],["bool"]]],[11,"ne","","",183,[[["self"],["defkey"]],["bool"]]],[11,"fmt","","",183,[[["self"],["formatter"]],["result"]]],[11,"hash","","",183,N],[11,"encode","","",183,[[["self"],["__s"]],["result"]]],[11,"decode","","",183,[[["__d"]],["result",["defkey"]]]],[11,"compute_stable_hash","","",183,[[["self"],["defpathhash"]],["defpathhash"]]],[11,"root_parent_stable_hash","","",183,[[["str"],["cratedisambiguator"]],["defpathhash"]]],[11,"clone","","",184,[[["self"]],["disambiguateddefpathdata"]]],[11,"eq","","",184,[[["self"],["disambiguateddefpathdata"]],["bool"]]],[11,"ne","","",184,[[["self"],["disambiguateddefpathdata"]],["bool"]]],[11,"fmt","","",184,[[["self"],["formatter"]],["result"]]],[11,"hash","","",184,N],[11,"encode","","",184,[[["self"],["__s"]],["result"]]],[11,"decode","","",184,[[["__d"]],["result",["disambiguateddefpathdata"]]]],[11,"clone","","",185,[[["self"]],["defpath"]]],[11,"fmt","","",185,[[["self"],["formatter"]],["result"]]],[11,"hash","","",185,N],[11,"encode","","",185,[[["self"],["__s"]],["result"]]],[11,"decode","","",185,[[["__d"]],["result",["defpath"]]]],[11,"is_local","","",185,[[["self"]],["bool"]]],[11,"make","","",185,[[["cratenum"],["defindex"],["fn"]],["defpath"]]],[11,"to_string_no_crate","","Returns a string representation of the DefPath without the crate-prefix. This method is useful if you don't have a TyCtxt available.",185,[[["self"]],["string"]]],[11,"to_filename_friendly_no_crate","","Return filename friendly string of the DefPah without the crate-prefix. This method is useful if you don't have a TyCtxt available.",185,[[["self"]],["string"]]],[11,"clone","","",187,[[["self"]],["defpathdata"]]],[11,"fmt","","",187,[[["self"],["formatter"]],["result"]]],[11,"eq","","",187,[[["self"],["defpathdata"]],["bool"]]],[11,"ne","","",187,[[["self"],["defpathdata"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",187,N],[11,"hash","","",187,N],[11,"encode","","",187,[[["self"],["__s"]],["result"]]],[11,"decode","","",187,[[["__d"]],["result",["defpathdata"]]]],[11,"clone","","",186,[[["self"]],["defpathhash"]]],[11,"hash","","",186,N],[11,"eq","","",186,[[["self"],["defpathhash"]],["bool"]]],[11,"ne","","",186,[[["self"],["defpathhash"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",186,N],[11,"partial_cmp","","",186,[[["self"],["defpathhash"]],["option",["ordering"]]]],[11,"lt","","",186,[[["self"],["defpathhash"]],["bool"]]],[11,"le","","",186,[[["self"],["defpathhash"]],["bool"]]],[11,"gt","","",186,[[["self"],["defpathhash"]],["bool"]]],[11,"ge","","",186,[[["self"],["defpathhash"]],["bool"]]],[11,"cmp","","",186,[[["self"],["defpathhash"]],["ordering"]]],[11,"fmt","","",186,[[["self"],["formatter"]],["result"]]],[11,"encode","","",186,[[["self"],["__s"]],["result"]]],[11,"decode","","",186,[[["__d"]],["result",["defpathhash"]]]],[11,"hash_stable","","",186,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"borrow","","",186,[[["self"]],["fingerprint"]]],[11,"new","","Create new empty definition map.",182,[[],["definitions"]]],[11,"def_path_table","","",182,[[["self"]],["defpathtable"]]],[11,"def_index_counts_lo_hi","","Get the number of definitions.",182,N],[11,"def_key","","",182,[[["self"],["defindex"]],["defkey"]]],[11,"def_path_hash","","",182,[[["self"],["defindex"]],["defpathhash"]]],[11,"def_path","","Returns the path from the crate root to `index`. The root nodes are not included in the path (i.e., this will be an empty vector for the crate root). For an inlined item, this will be the path of the item in the external crate (but the path will begin with the path to the external crate).",182,[[["self"],["defindex"]],["defpath"]]],[11,"opt_def_index","","",182,[[["self"],["nodeid"]],["option",["defindex"]]]],[11,"opt_local_def_id","","",182,[[["self"],["nodeid"]],["option",["defid"]]]],[11,"local_def_id","","",182,[[["self"],["nodeid"]],["defid"]]],[11,"as_local_node_id","","",182,[[["self"],["defid"]],["option",["nodeid"]]]],[11,"node_to_hir_id","","",182,[[["self"],["nodeid"]],["hirid"]]],[11,"def_index_to_hir_id","","",182,[[["self"],["defindex"]],["hirid"]]],[11,"opt_span","","Retrieve the span of the given `DefId` if `DefId` is in the local crate, the span exists and it's not DUMMY_SP",182,[[["self"],["defid"]],["option",["span"]]]],[11,"create_root_def","","Add a definition with a parent definition.",182,[[["self"],["str"],["cratedisambiguator"]],["defindex"]]],[11,"create_def_with_parent","","Add a definition with a parent definition.",182,[[["self"],["defindex"],["nodeid"],["defpathdata"],["defindexaddressspace"],["mark"],["span"]],["defindex"]]],[11,"init_node_id_to_hir_id_mapping","","Initialize the ast::NodeId to HirId mapping once it has been generated during AST to HIR lowering.",182,[[["self"],["indexvec",["nodeid","hirid"]]]]],[11,"expansion_that_defined","","",182,[[["self"],["defindex"]],["mark"]]],[11,"parent_module_of_macro_def","","",182,[[["self"],["mark"]],["defid"]]],[11,"add_parent_module_of_macro_def","","",182,[[["self"],["mark"],["defid"]]]],[11,"get_opt_name","","",187,[[["self"]],["option",["internedstring"]]]],[11,"as_interned_str","","",187,[[["self"]],["internedstring"]]],[11,"to_string","","",187,[[["self"]],["string"]]],[11,"clone","","",188,[[["self"]],["globalmetadatakind"]]],[11,"fmt","","",188,[[["self"],["formatter"]],["result"]]],[11,"hash","","",188,N],[11,"encode","","",188,[[["self"],["__s"]],["result"]]],[11,"decode","","",188,[[["__d"]],["result",["globalmetadatakind"]]]],[11,"allocate_def_indices","","",188,[[["definitions"]]]],[11,"def_index","","",188,[[["self"],["defpathtable"]],["defindex"]]],[11,"name","","",188,[[["self"]],["symbol"]]],[0,"hir_id_validator","rustc::hir::map","",N,N],[3,"HirIdValidator","rustc::hir::map::hir_id_validator","",N,N],[12,"hir_map","","",189,N],[12,"owner_def_index","","",189,N],[12,"hir_ids_seen","","",189,N],[12,"errors","","",189,N],[3,"OuterVisitor","","",N,N],[12,"hir_map","","",190,N],[12,"errors","","",190,N],[5,"check_crate","","",N,[[["map"]]]],[11,"new_inner_visitor","","",190,[[["self"],["map"]],["hiridvalidator"]]],[11,"visit_item","","",190,[[["self"],["item"]]]],[11,"visit_trait_item","","",190,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",190,[[["self"],["implitem"]]]],[11,"check","","",189,[[["self"],["nodeid"],["f"]]]],[11,"nested_visit_map","","",189,[[["self"]],["nestedvisitormap"]]],[11,"visit_id","","",189,[[["self"],["nodeid"]]]],[11,"visit_impl_item_ref","","",189,[[["self"],["implitemref"]]]],[17,"ITEM_LIKE_SPACE","rustc::hir::map","",N,N],[17,"REGULAR_SPACE","","",N,N],[8,"Named","","",N,N],[10,"name","","",191,[[["self"]],["name"]]],[11,"clone","","",172,[[["self"]],["node"]]],[11,"fmt","","",172,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",173,[[["self"],["formatter"]],["result"]]],[11,"clone","","",173,[[["self"]],["mapentry"]]],[11,"parent_node","","",173,[[["self"]],["option",["nodeid"]]]],[11,"to_node","","",173,[[["self"]],["option",["node"]]]],[11,"fn_decl","","",173,[[["self"]],["option",["fndecl"]]]],[11,"associated_body","","",173,[[["self"]],["option",["bodyid"]]]],[11,"is_body_owner","","",173,[[["self"],["nodeid"]],["bool"]]],[11,"new","","",169,[[["crate"],["depgraph"]],["forest"]]],[11,"krate","","",169,[[["self"]],["crate"]]],[11,"clone","","",170,[[["self"]],["map"]]],[11,"read","","Registers a read in the dependency graph of the AST node with the given `id`. This needs to be called each time a public function returns the HIR for a node -- in other words, when it \"reveals\" the content of a node to the caller (who might not otherwise have had access to those contents, and hence needs a read recorded). If the function just returns a DefId or NodeId, no actual content was returned, so no read is needed.",170,[[["self"],["nodeid"]]]],[11,"definitions","","",170,[[["self"]],["definitions"]]],[11,"def_key","","",170,[[["self"],["defid"]],["defkey"]]],[11,"def_path_from_id","","",170,[[["self"],["nodeid"]],["option",["defpath"]]]],[11,"def_path","","",170,[[["self"],["defid"]],["defpath"]]],[11,"local_def_id","","",170,[[["self"],["nodeid"]],["defid"]]],[11,"opt_local_def_id","","",170,[[["self"],["nodeid"]],["option",["defid"]]]],[11,"as_local_node_id","","",170,[[["self"],["defid"]],["option",["nodeid"]]]],[11,"hir_to_node_id","","",170,[[["self"],["hirid"]],["nodeid"]]],[11,"node_to_hir_id","","",170,[[["self"],["nodeid"]],["hirid"]]],[11,"def_index_to_hir_id","","",170,[[["self"],["defindex"]],["hirid"]]],[11,"def_index_to_node_id","","",170,[[["self"],["defindex"]],["nodeid"]]],[11,"local_def_id_to_hir_id","","",170,[[["self"],["localdefid"]],["hirid"]]],[11,"local_def_id_to_node_id","","",170,[[["self"],["localdefid"]],["nodeid"]]],[11,"describe_def","","",170,[[["self"],["nodeid"]],["option",["def"]]]],[11,"entry_count","","",170,[[["self"]],["usize"]]],[11,"find_entry","","",170,[[["self"],["nodeid"]],["option",["mapentry"]]]],[11,"krate","","",170,[[["self"]],["crate"]]],[11,"trait_item","","",170,[[["self"],["traititemid"]],["traititem"]]],[11,"impl_item","","",170,[[["self"],["implitemid"]],["implitem"]]],[11,"body","","",170,[[["self"],["bodyid"]],["body"]]],[11,"fn_decl","","",170,[[["self"],["nodeid"]],["option",["fndecl"]]]],[11,"body_owner","","Returns the `NodeId` that corresponds to the definition of which this is the body of, i.e. a `fn`, `const` or `static` item (possibly associated), a closure, or a `hir::AnonConst`.",170,[[["self"],["bodyid"]],["nodeid"]]],[11,"body_owner_def_id","","",170,[[["self"],["bodyid"]],["defid"]]],[11,"maybe_body_owned_by","","Given a node id, returns the `BodyId` associated with it, if the node is a body owner, otherwise returns `None`.",170,[[["self"],["nodeid"]],["option",["bodyid"]]]],[11,"body_owned_by","","Given a body owner's id, returns the `BodyId` associated with it.",170,[[["self"],["nodeid"]],["bodyid"]]],[11,"body_owner_kind","","",170,[[["self"],["nodeid"]],["bodyownerkind"]]],[11,"ty_param_owner","","",170,[[["self"],["nodeid"]],["nodeid"]]],[11,"ty_param_name","","",170,[[["self"],["nodeid"]],["name"]]],[11,"trait_impls","","",170,N],[11,"trait_auto_impl","","",170,[[["self"],["defid"]],["option",["nodeid"]]]],[11,"trait_is_auto","","",170,[[["self"],["defid"]],["bool"]]],[11,"krate_attrs","","Get the attributes on the krate. This is preferable to invoking `krate.attrs` because it registers a tighter dep-graph access.",170,N],[11,"get","","Retrieve the Node corresponding to `id`, panicking if it cannot be found.",170,[[["self"],["nodeid"]],["node"]]],[11,"get_if_local","","",170,[[["self"],["defid"]],["option",["node"]]]],[11,"get_generics","","",170,[[["self"],["defid"]],["option",["generics"]]]],[11,"get_generics_span","","",170,[[["self"],["defid"]],["option",["span"]]]],[11,"find","","Retrieve the Node corresponding to `id`, returning None if cannot be found.",170,[[["self"],["nodeid"]],["option",["node"]]]],[11,"get_parent_node","","Similar to get_parent, returns the parent node id or id if there is no parent. Note that the parent may be CRATE_NODE_ID, which is not itself present in the map -- so passing the return value of get_parent_node to get may actually panic. This function returns the immediate parent in the AST, whereas get_parent returns the enclosing item. Note that this might not be the actual parent node in the AST - some kinds of nodes are not in the map and these will never appear as the parent_node. So you can always walk the parent_nodes from a node to the root of the ast (unless you get the same id back here that can happen if the id is not in the map itself or is just weird).",170,[[["self"],["nodeid"]],["nodeid"]]],[11,"is_argument","","Check if the node is an argument. An argument is a local variable whose immediate parent is an item or a closure.",170,[[["self"],["nodeid"]],["bool"]]],[11,"walk_parent_nodes","","If there is some error when walking the parents (e.g., a node does not have a parent in the map or a node can't be found), then we return the last good node id we found. Note that reaching the crate root (id == 0), is not an error, since items in the crate module have the crate root as parent.",170,[[["self"],["nodeid"],["f"],["f2"]],["result",["nodeid","nodeid"]]]],[11,"get_return_block","","Retrieve the NodeId for `id`'s enclosing method, unless there's a `while` or `loop` before reaching it, as block tail returns are not available in them.",170,[[["self"],["nodeid"]],["option",["nodeid"]]]],[11,"get_parent","","Retrieve the NodeId for `id`'s parent item, or `id` itself if no parent item is in this map. The \"parent item\" is the closest parent node in the HIR which is recorded by the map and is an item, either an item in a module, trait, or impl.",170,[[["self"],["nodeid"]],["nodeid"]]],[11,"get_module_parent","","Returns the NodeId of `id`'s nearest module parent, or `id` itself if no module parent is in this map.",170,[[["self"],["nodeid"]],["defid"]]],[11,"get_enclosing_scope","","Returns the nearest enclosing scope. A scope is an item or block. FIXME it is not clear to me that all items qualify as scopes - statics and associated types probably shouldn't, for example. Behavior in this regard should be expected to be highly unstable.",170,[[["self"],["nodeid"]],["option",["nodeid"]]]],[11,"get_parent_did","","",170,[[["self"],["nodeid"]],["defid"]]],[11,"get_foreign_abi","","",170,[[["self"],["nodeid"]],["abi"]]],[11,"expect_item","","",170,[[["self"],["nodeid"]],["item"]]],[11,"expect_impl_item","","",170,[[["self"],["nodeid"]],["implitem"]]],[11,"expect_trait_item","","",170,[[["self"],["nodeid"]],["traititem"]]],[11,"expect_variant_data","","",170,[[["self"],["nodeid"]],["variantdata"]]],[11,"expect_variant","","",170,[[["self"],["nodeid"]],["variant"]]],[11,"expect_foreign_item","","",170,[[["self"],["nodeid"]],["foreignitem"]]],[11,"expect_expr","","",170,[[["self"],["nodeid"]],["expr"]]],[11,"name","","Returns the name associated with the given NodeId's AST.",170,[[["self"],["nodeid"]],["name"]]],[11,"attrs","","Given a node ID, get a list of attributes associated with the AST corresponding to the Node ID",170,N],[11,"nodes_matching_suffix","","Returns an iterator that yields the node id's with paths that match `parts`.  (Requires `parts` is non-empty.)",170,N],[11,"span","","",170,[[["self"],["nodeid"]],["span"]]],[11,"span_if_local","","",170,[[["self"],["defid"]],["option",["span"]]]],[11,"node_to_string","","",170,[[["self"],["nodeid"]],["string"]]],[11,"node_to_user_string","","",170,[[["self"],["nodeid"]],["string"]]],[11,"node_to_pretty_string","","",170,[[["self"],["nodeid"]],["string"]]],[11,"suffix_matches","","Returns true only if some suffix of the module path for parent matches `self.in_which`.",171,[[["self"],["nodeid"]],["bool"]]],[11,"matches_names","","",171,[[["self"],["nodeid"],["name"]],["bool"]]],[11,"next","","",171,[[["self"]],["option",["nodeid"]]]],[11,"name","rustc::hir","",83,[[["self"]],["name"]]],[11,"name","","",87,[[["self"]],["name"]]],[11,"name","","",78,[[["self"]],["name"]]],[11,"name","","",81,[[["self"]],["name"]]],[11,"name","","",63,[[["self"]],["name"]]],[11,"name","","",65,[[["self"]],["name"]]],[11,"nested","rustc::hir::map","",170,[[["self"],["state"],["nested"]],["result"]]],[0,"pat_util","rustc::hir","",N,N],[3,"EnumerateAndAdjust","rustc::hir::pat_util","",N,N],[12,"enumerate","","",192,N],[12,"gap_pos","","",192,N],[12,"gap_len","","",192,N],[8,"EnumerateAndAdjustIterator","","",N,N],[10,"enumerate_and_adjust","","",193,[[["self"],["usize"],["option",["usize"]]],["enumerateandadjust"]]],[11,"next","","",192,[[["self"]],["option"]]],[11,"size_hint","","",192,N],[11,"is_refutable","rustc::hir","",50,[[["self"]],["bool"]]],[11,"is_const","","",50,[[["self"]],["bool"]]],[11,"each_binding","","Call `f` on every \"binding\" in a pattern, e.g., on `a` in `match foo() { Some(a) => (), None => () }`",50,[[["self"],["f"]]]],[11,"contains_bindings","","Checks if the pattern contains any patterns that bind something to an ident, e.g. `foo`, or `Foo(foo)` or `foo @ Bar(..)`.",50,[[["self"]],["bool"]]],[11,"contains_bindings_or_wild","","Checks if the pattern contains any patterns that bind something to an ident or wildcard, e.g. `foo`, or `Foo(_)`, `foo @ Bar(..)`,",50,[[["self"]],["bool"]]],[11,"simple_ident","","",50,[[["self"]],["option",["ident"]]]],[11,"necessary_variants","","Return variants that are necessary to exist for the pattern to match.",50,[[["self"]],["vec",["defid"]]]],[11,"contains_explicit_ref_binding","","Checks if the pattern contains any `ref` or `ref mut` bindings, and if yes whether it contains mutable or just immutables ones.",50,[[["self"]],["option",["mutability"]]]],[11,"contains_explicit_ref_binding","","Checks if the patterns for this arm contain any `ref` or `ref mut` bindings, and if yes whether its containing mutable ones or just immutables ones.",53,[[["self"]],["option",["mutability"]]]],[0,"print","","",N,N],[3,"NoAnn","rustc::hir::print","",N,N],[3,"State","","",N,N],[12,"s","","",194,N],[12,"cm","","",194,N],[12,"comments","","",194,N],[12,"literals","","",194,N],[12,"cur_cmnt","","",194,N],[12,"boxes","","",194,N],[12,"ann","","",194,N],[4,"AnnNode","","",N,N],[13,"NodeName","","",195,N],[13,"NodeBlock","","",195,N],[13,"NodeItem","","",195,N],[13,"NodeSubItem","","",195,N],[13,"NodeExpr","","",195,N],[13,"NodePat","","",195,N],[4,"Nested","","",N,N],[13,"Item","","",196,N],[13,"TraitItem","","",196,N],[13,"ImplItem","","",196,N],[13,"Body","","",196,N],[13,"BodyArgPat","","",196,N],[5,"print_crate","","Requires you to pass an input filename and reader so that it can scan the input text for comments and literals to copy forward.",N,[[["codemap"],["parsesess"],["crate"],["filename"],["read"],["box",["write"]],["ppann"],["bool"]],["result"]]],[5,"to_string","","",N,[[["ppann"],["f"]],["string"]]],[5,"visibility_qualified","","",N,[[["visibility"],["str"]],["string"]]],[5,"expr_requires_semi_to_be_stmt","","Does this expression require a semicolon to be treated as a statement? The negation of this: 'can this expression be used as a statement without a semicolon' -- is used as an early-bail-out in the parser so that, for instance,     if true {...} else {...}      |x| 5 isn't parsed as (if true {...} else {...} | x) | 5",N,[[["expr"]],["bool"]]],[5,"stmt_ends_with_semi","","this statement requires a semicolon after it. note that in one case (stmt_semi), we've already seen the semicolon, and thus don't need another.",N,[[["stmtkind"]],["bool"]]],[5,"bin_op_to_assoc_op","","",N,[[["binopkind"]],["assocop"]]],[5,"contains_exterior_struct_lit","","Expressions that syntactically contain an \"exterior\" struct literal i.e. not surrounded by any parens or other delimiters, e.g. `X { y: 1 }`, `X { y: 1 }.method()`, `foo == X { y: 1 }` and `X { y: 1 } == foo` all do, but `(X { y: 1 }) == foo` does not.",N,[[["expr"]],["bool"]]],[17,"NO_ANN","","",N,N],[17,"indent_unit","","",N,N],[17,"default_columns","","",N,N],[8,"PpAnn","","",N,N],[11,"nested","","",197,[[["self"],["state"],["nested"]],["result"]]],[11,"pre","","",197,[[["self"],["state"],["annnode"]],["result"]]],[11,"post","","",197,[[["self"],["state"],["annnode"]],["result"]]],[11,"try_fetch_item","","",197,[[["self"],["nodeid"]],["option",["item"]]]],[11,"try_fetch_item","rustc::hir","",47,[[["self"],["nodeid"]],["option",["item"]]]],[11,"nested","","",47,[[["self"],["state"],["nested"]],["result"]]],[11,"writer","rustc::hir::print","",194,[[["self"]],["printer"]]],[11,"boxes","","",194,[[["self"]],["vec"]]],[11,"comments","","",194,[[["self"]],["option"]]],[11,"cur_cmnt","","",194,[[["self"]],["usize"]]],[11,"cur_lit","","",194,[[["self"]],["option",["literal"]]]],[11,"bump_lit","","",194,[[["self"]],["option",["literal"]]]],[11,"new_from_input","","",194,[[["codemap"],["parsesess"],["filename"],["read"],["box",["write"]],["ppann"],["bool"]],["state"]]],[11,"new","","",194,[[["codemap"],["box",["write"]],["ppann"],["option",["vec"]],["option",["vec"]]],["state"]]],[11,"cbox","","",194,[[["self"],["usize"]],["result"]]],[11,"nbsp","","",194,[[["self"]],["result"]]],[11,"word_nbsp","","",194,[[["self"],["str"]],["result"]]],[11,"head","","",194,[[["self"],["str"]],["result"]]],[11,"bopen","","",194,[[["self"]],["result"]]],[11,"bclose_","","",194,[[["self"],["span"],["usize"]],["result"]]],[11,"bclose_maybe_open","","",194,[[["self"],["span"],["usize"],["bool"]],["result"]]],[11,"bclose","","",194,[[["self"],["span"]],["result"]]],[11,"in_cbox","","",194,[[["self"]],["bool"]]],[11,"space_if_not_bol","","",194,[[["self"]],["result"]]],[11,"break_offset_if_not_bol","","",194,[[["self"],["usize"],["isize"]],["result"]]],[11,"synth_comment","","",194,[[["self"],["string"]],["result"]]],[11,"commasep_cmnt","","",194,N],[11,"commasep_exprs","","",194,N],[11,"print_mod","","",194,N],[11,"print_foreign_mod","","",194,N],[11,"print_opt_lifetime","","",194,[[["self"],["lifetime"]],["result"]]],[11,"print_type","","",194,[[["self"],["ty"]],["result"]]],[11,"print_foreign_item","","",194,[[["self"],["foreignitem"]],["result"]]],[11,"print_associated_const","","",194,[[["self"],["ident"],["ty"],["option",["bodyid"]],["visibility"]],["result"]]],[11,"print_associated_type","","",194,[[["self"],["ident"],["option",["genericbounds"]],["option",["ty"]]],["result"]]],[11,"print_item","","Pretty-print an item",194,[[["self"],["item"]],["result"]]],[11,"print_trait_ref","","",194,[[["self"],["traitref"]],["result"]]],[11,"print_formal_generic_params","","",194,N],[11,"print_poly_trait_ref","","",194,[[["self"],["polytraitref"]],["result"]]],[11,"print_enum_def","","",194,[[["self"],["enumdef"],["generics"],["name"],["span"],["visibility"]],["result"]]],[11,"print_variants","","",194,N],[11,"print_visibility","","",194,[[["self"],["visibility"]],["result"]]],[11,"print_defaultness","","",194,[[["self"],["defaultness"]],["result"]]],[11,"print_struct","","",194,[[["self"],["variantdata"],["generics"],["name"],["span"],["bool"]],["result"]]],[11,"print_variant","","",194,[[["self"],["variant"]],["result"]]],[11,"print_method_sig","","",194,N],[11,"print_trait_item","","",194,[[["self"],["traititem"]],["result"]]],[11,"print_impl_item","","",194,[[["self"],["implitem"]],["result"]]],[11,"print_stmt","","",194,[[["self"],["stmt"]],["result"]]],[11,"print_block","","",194,[[["self"],["block"]],["result"]]],[11,"print_block_unclosed","","",194,[[["self"],["block"]],["result"]]],[11,"print_block_unclosed_indent","","",194,[[["self"],["block"],["usize"]],["result"]]],[11,"print_block_with_attrs","","",194,N],[11,"print_block_maybe_unclosed","","",194,N],[11,"print_else","","",194,[[["self"],["option",["expr"]]],["result"]]],[11,"print_if","","",194,[[["self"],["expr"],["expr"],["option",["expr"]]],["result"]]],[11,"print_if_let","","",194,[[["self"],["pat"],["expr"],["block"],["option",["expr"]]],["result"]]],[11,"print_anon_const","","",194,[[["self"],["anonconst"]],["result"]]],[11,"print_call_post","","",194,N],[11,"print_expr_maybe_paren","","",194,[[["self"],["expr"],["i8"]],["result"]]],[11,"print_expr_as_cond","","Print an expr using syntax that's acceptable in a condition position, such as the `cond` in `if cond { ... }`.",194,[[["self"],["expr"]],["result"]]],[11,"print_expr_vec","","",194,N],[11,"print_expr_repeat","","",194,[[["self"],["expr"],["anonconst"]],["result"]]],[11,"print_expr_struct","","",194,N],[11,"print_expr_tup","","",194,N],[11,"print_expr_call","","",194,N],[11,"print_expr_method_call","","",194,N],[11,"print_expr_binary","","",194,[[["self"],["binop"],["expr"],["expr"]],["result"]]],[11,"print_expr_unary","","",194,[[["self"],["unop"],["expr"]],["result"]]],[11,"print_expr_addr_of","","",194,[[["self"],["mutability"],["expr"]],["result"]]],[11,"print_expr","","",194,[[["self"],["expr"]],["result"]]],[11,"print_local_decl","","",194,[[["self"],["local"]],["result"]]],[11,"print_decl","","",194,[[["self"],["decl"]],["result"]]],[11,"print_usize","","",194,[[["self"],["usize"]],["result"]]],[11,"print_ident","","",194,[[["self"],["ident"]],["result"]]],[11,"print_name","","",194,[[["self"],["name"]],["result"]]],[11,"print_for_decl","","",194,[[["self"],["local"],["expr"]],["result"]]],[11,"print_path","","",194,[[["self"],["path"],["bool"]],["result"]]],[11,"print_qpath","","",194,[[["self"],["qpath"],["bool"]],["result"]]],[11,"print_generic_args","","",194,[[["self"],["genericargs"],["bool"],["bool"]],["result"]]],[11,"print_pat","","",194,[[["self"],["pat"]],["result"]]],[11,"print_arm","","",194,[[["self"],["arm"]],["result"]]],[11,"print_fn","","",194,N],[11,"print_closure_args","","",194,[[["self"],["fndecl"],["bodyid"]],["result"]]],[11,"print_capture_clause","","",194,[[["self"],["captureclause"]],["result"]]],[11,"print_bounds","","",194,N],[11,"print_generic_params","","",194,N],[11,"print_generic_param","","",194,[[["self"],["genericparam"]],["result"]]],[11,"print_lifetime","","",194,[[["self"],["lifetime"]],["result"]]],[11,"print_where_clause","","",194,[[["self"],["whereclause"]],["result"]]],[11,"print_mutability","","",194,[[["self"],["mutability"]],["result"]]],[11,"print_mt","","",194,[[["self"],["mutty"]],["result"]]],[11,"print_fn_output","","",194,[[["self"],["fndecl"]],["result"]]],[11,"print_ty_fn","","",194,N],[11,"maybe_print_trailing_comment","","",194,[[["self"],["span"],["option",["bytepos"]]],["result"]]],[11,"print_remaining_comments","","",194,[[["self"]],["result"]]],[11,"print_opt_abi_and_extern_if_nondefault","","",194,[[["self"],["option",["abi"]]],["result"]]],[11,"print_extern_opt_abi","","",194,[[["self"],["option",["abi"]]],["result"]]],[11,"print_fn_header_info","","",194,[[["self"],["fnheader"],["visibility"]],["result"]]],[11,"print_unsafety","","",194,[[["self"],["unsafety"]],["result"]]],[11,"print_is_auto","","",194,[[["self"],["isauto"]],["result"]]],[0,"svh","rustc::hir","Calculation and management of a Strict Version Hash for crates",N,N],[3,"Svh","rustc::hir::svh","",N,N],[12,"hash","","",198,N],[11,"clone","","",198,[[["self"]],["svh"]]],[11,"eq","","",198,[[["self"],["svh"]],["bool"]]],[11,"ne","","",198,[[["self"],["svh"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",198,N],[11,"fmt","","",198,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `Svh` given the hash. If you actually want to compute the SVH from some HIR, you want the `calculate_svh` function found in `librustc_incremental`.",198,[[["u64"]],["svh"]]],[11,"as_u64","","",198,[[["self"]],["u64"]]],[11,"to_string","","",198,[[["self"]],["string"]]],[11,"hash","","",198,[[["self"],["h"]]]],[11,"fmt","","",198,[[["self"],["formatter"]],["result"]]],[11,"encode","","",198,[[["self"],["s"]],["result"]]],[11,"decode","","",198,[[["d"]],["result",["svh"]]]],[11,"hash_stable","","",198,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[6,"HirVec","rustc::hir","HIR doesn't commit to a concrete storage type and has its own alias for a vector. It can be `Vec`, `P<[T]>` or potentially `Box<[T]>`, or some other container with similar behavior. Unlike AST, HIR is mostly a static structure, so we can use an owned slice instead of `Vec` to avoid keeping extra capacity.",N,N],[6,"GenericBounds","","",N,N],[6,"CrateConfig","","",N,N],[6,"BinOp","","",N,N],[6,"Stmt","","A statement",N,N],[6,"Decl","","",N,N],[6,"Variant","","",N,N],[6,"Visibility","","",N,N],[6,"FreevarMap","","",N,N],[6,"CaptureModeMap","","",N,N],[6,"TraitMap","","",N,N],[6,"GlobMap","","",N,N],[17,"CRATE_HIR_ID","","The `HirId` corresponding to CRATE_NODE_ID and CRATE_DEF_INDEX",N,N],[17,"DUMMY_HIR_ID","","",N,N],[17,"DUMMY_ITEM_LOCAL_ID","","",N,N],[11,"clone","","",33,[[["self"]],["hirid"]]],[11,"eq","","",33,[[["self"],["hirid"]],["bool"]]],[11,"ne","","",33,[[["self"],["hirid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",33,N],[11,"hash","","",33,N],[11,"fmt","","",33,[[["self"],["formatter"]],["result"]]],[11,"owner_def_id","","",33,[[["self"]],["defid"]]],[11,"owner_local_def_id","","",33,[[["self"]],["localdefid"]]],[11,"default_encode","","",33,[[["self"],["s"]],["result"]]],[11,"default_decode","","",33,[[["d"]],["result",["hirid"]]]],[11,"clone","","",34,[[["self"]],["itemlocalid"]]],[11,"eq","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"ne","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",34,N],[11,"partial_cmp","","",34,[[["self"],["itemlocalid"]],["option",["ordering"]]]],[11,"lt","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"le","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"gt","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"ge","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"cmp","","",34,[[["self"],["itemlocalid"]],["ordering"]]],[11,"hash","","",34,N],[11,"fmt","","",34,[[["self"],["formatter"]],["result"]]],[11,"encode","","",34,[[["self"],["__s"]],["result"]]],[11,"decode","","",34,[[["__d"]],["result",["itemlocalid"]]]],[11,"as_usize","","",34,[[["self"]],["usize"]]],[11,"new","","",34,[[["usize"]],["self"]]],[11,"index","","",34,[[["self"]],["usize"]]],[11,"clone","","",35,[[["self"]],["label"]]],[11,"encode","","",35,[[["self"],["__s"]],["result"]]],[11,"decode","","",35,[[["__d"]],["result",["label"]]]],[11,"fmt","","",35,[[["self"],["formatter"]],["result"]]],[11,"clone","","",36,[[["self"]],["lifetime"]]],[11,"encode","","",36,[[["self"],["__s"]],["result"]]],[11,"decode","","",36,[[["__d"]],["result",["lifetime"]]]],[11,"fmt","","",92,[[["self"],["formatter"]],["result"]]],[11,"clone","","",92,[[["self"]],["paramname"]]],[11,"eq","","",92,[[["self"],["paramname"]],["bool"]]],[11,"ne","","",92,[[["self"],["paramname"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",92,N],[11,"encode","","",92,[[["self"],["__s"]],["result"]]],[11,"decode","","",92,[[["__d"]],["result",["paramname"]]]],[11,"hash","","",92,N],[11,"ident","","",92,[[["self"]],["ident"]]],[11,"modern","","",92,[[["self"]],["paramname"]]],[11,"fmt","","",93,[[["self"],["formatter"]],["result"]]],[11,"clone","","",93,[[["self"]],["lifetimename"]]],[11,"eq","","",93,[[["self"],["lifetimename"]],["bool"]]],[11,"ne","","",93,[[["self"],["lifetimename"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",93,N],[11,"encode","","",93,[[["self"],["__s"]],["result"]]],[11,"decode","","",93,[[["__d"]],["result",["lifetimename"]]]],[11,"hash","","",93,N],[11,"ident","","",93,[[["self"]],["ident"]]],[11,"is_elided","","",93,[[["self"]],["bool"]]],[11,"is_static","","",93,[[["self"]],["bool"]]],[11,"modern","","",93,[[["self"]],["lifetimename"]]],[11,"fmt","","",36,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",36,[[["self"],["formatter"]],["result"]]],[11,"is_elided","","",36,[[["self"]],["bool"]]],[11,"is_static","","",36,[[["self"]],["bool"]]],[11,"clone","","",37,[[["self"]],["path"]]],[11,"encode","","",37,[[["self"],["__s"]],["result"]]],[11,"decode","","",37,[[["__d"]],["result",["path"]]]],[11,"is_global","","",37,[[["self"]],["bool"]]],[11,"fmt","","",37,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",37,[[["self"],["formatter"]],["result"]]],[11,"clone","","",38,[[["self"]],["pathsegment"]]],[11,"encode","","",38,[[["self"],["__s"]],["result"]]],[11,"decode","","",38,[[["__d"]],["result",["pathsegment"]]]],[11,"fmt","","",38,[[["self"],["formatter"]],["result"]]],[11,"from_ident","","Convert an identifier to the corresponding segment.",38,[[["ident"]],["pathsegment"]]],[11,"new","","",38,[[["ident"],["genericargs"],["bool"]],["self"]]],[11,"with_generic_args","","",38,[[["self"],["f"]],["r"]]],[11,"clone","","",94,[[["self"]],["genericarg"]]],[11,"encode","","",94,[[["self"],["__s"]],["result"]]],[11,"decode","","",94,[[["__d"]],["result",["genericarg"]]]],[11,"fmt","","",94,[[["self"],["formatter"]],["result"]]],[11,"span","","",94,[[["self"]],["span"]]],[11,"clone","","",39,[[["self"]],["genericargs"]]],[11,"encode","","",39,[[["self"],["__s"]],["result"]]],[11,"decode","","",39,[[["__d"]],["result",["genericargs"]]]],[11,"fmt","","",39,[[["self"],["formatter"]],["result"]]],[11,"none","","",39,[[],["self"]]],[11,"is_empty","","",39,[[["self"]],["bool"]]],[11,"inputs","","",39,N],[11,"clone","","",95,[[["self"]],["traitboundmodifier"]]],[11,"eq","","",95,[[["self"],["traitboundmodifier"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",95,N],[11,"encode","","",95,[[["self"],["__s"]],["result"]]],[11,"decode","","",95,[[["__d"]],["result",["traitboundmodifier"]]]],[11,"hash","","",95,N],[11,"fmt","","",95,[[["self"],["formatter"]],["result"]]],[11,"clone","","",96,[[["self"]],["genericbound"]]],[11,"encode","","",96,[[["self"],["__s"]],["result"]]],[11,"decode","","",96,[[["__d"]],["result",["genericbound"]]]],[11,"fmt","","",96,[[["self"],["formatter"]],["result"]]],[11,"span","","",96,[[["self"]],["span"]]],[11,"clone","","",97,[[["self"]],["genericparamkind"]]],[11,"encode","","",97,[[["self"],["__s"]],["result"]]],[11,"decode","","",97,[[["__d"]],["result",["genericparamkind"]]]],[11,"fmt","","",97,[[["self"],["formatter"]],["result"]]],[11,"clone","","",40,[[["self"]],["genericparam"]]],[11,"encode","","",40,[[["self"],["__s"]],["result"]]],[11,"decode","","",40,[[["__d"]],["result",["genericparam"]]]],[11,"fmt","","",40,[[["self"],["formatter"]],["result"]]],[11,"clone","","",42,[[["self"]],["generics"]]],[11,"encode","","",42,[[["self"],["__s"]],["result"]]],[11,"decode","","",42,[[["__d"]],["result",["generics"]]]],[11,"fmt","","",42,[[["self"],["formatter"]],["result"]]],[11,"empty","","",42,[[],["generics"]]],[11,"own_counts","","",42,[[["self"]],["genericparamcount"]]],[11,"get_named","","",42,[[["self"],["internedstring"]],["option",["genericparam"]]]],[11,"clone","","",98,[[["self"]],["synthetictyparamkind"]]],[11,"eq","","",98,[[["self"],["synthetictyparamkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",98,N],[11,"encode","","",98,[[["self"],["__s"]],["result"]]],[11,"decode","","",98,[[["__d"]],["result",["synthetictyparamkind"]]]],[11,"hash","","",98,N],[11,"fmt","","",98,[[["self"],["formatter"]],["result"]]],[11,"clone","","",43,[[["self"]],["whereclause"]]],[11,"encode","","",43,[[["self"],["__s"]],["result"]]],[11,"decode","","",43,[[["__d"]],["result",["whereclause"]]]],[11,"fmt","","",43,[[["self"],["formatter"]],["result"]]],[11,"span","","",43,[[["self"]],["option",["span"]]]],[11,"clone","","",99,[[["self"]],["wherepredicate"]]],[11,"encode","","",99,[[["self"],["__s"]],["result"]]],[11,"decode","","",99,[[["__d"]],["result",["wherepredicate"]]]],[11,"fmt","","",99,[[["self"],["formatter"]],["result"]]],[11,"span","","",99,[[["self"]],["span"]]],[11,"clone","","",44,[[["self"]],["whereboundpredicate"]]],[11,"encode","","",44,[[["self"],["__s"]],["result"]]],[11,"decode","","",44,[[["__d"]],["result",["whereboundpredicate"]]]],[11,"fmt","","",44,[[["self"],["formatter"]],["result"]]],[11,"clone","","",45,[[["self"]],["whereregionpredicate"]]],[11,"encode","","",45,[[["self"],["__s"]],["result"]]],[11,"decode","","",45,[[["__d"]],["result",["whereregionpredicate"]]]],[11,"fmt","","",45,[[["self"],["formatter"]],["result"]]],[11,"clone","","",46,[[["self"]],["whereeqpredicate"]]],[11,"encode","","",46,[[["self"],["__s"]],["result"]]],[11,"decode","","",46,[[["__d"]],["result",["whereeqpredicate"]]]],[11,"fmt","","",46,[[["self"],["formatter"]],["result"]]],[11,"clone","","",47,[[["self"]],["crate"]]],[11,"encode","","",47,[[["self"],["__s"]],["result"]]],[11,"decode","","",47,[[["__d"]],["result",["crate"]]]],[11,"fmt","","",47,[[["self"],["formatter"]],["result"]]],[11,"item","","",47,[[["self"],["nodeid"]],["item"]]],[11,"trait_item","","",47,[[["self"],["traititemid"]],["traititem"]]],[11,"impl_item","","",47,[[["self"],["implitemid"]],["implitem"]]],[11,"visit_all_item_likes","","Visits all items in the crate in some deterministic (but unspecified) order. If you just need to process every item, but don't care about nesting, this method is the best choice.",47,[[["self"],["v"]]]],[11,"par_visit_all_item_likes","","A parallel version of visit_all_item_likes",47,[[["self"],["v"]]]],[11,"body","","",47,[[["self"],["bodyid"]],["body"]]],[11,"clone","","",48,[[["self"]],["macrodef"]]],[11,"encode","","",48,[[["self"],["__s"]],["result"]]],[11,"decode","","",48,[[["__d"]],["result",["macrodef"]]]],[11,"fmt","","",48,[[["self"],["formatter"]],["result"]]],[11,"clone","","",49,[[["self"]],["block"]]],[11,"encode","","",49,[[["self"],["__s"]],["result"]]],[11,"decode","","",49,[[["__d"]],["result",["block"]]]],[11,"fmt","","",49,[[["self"],["formatter"]],["result"]]],[11,"clone","","",50,[[["self"]],["pat"]]],[11,"encode","","",50,[[["self"],["__s"]],["result"]]],[11,"decode","","",50,[[["__d"]],["result",["pat"]]]],[11,"fmt","","",50,[[["self"],["formatter"]],["result"]]],[11,"walk_","","",50,[[["self"],["g"]],["bool"]]],[11,"walk","","",50,[[["self"],["f"]],["bool"]]],[11,"clone","","",51,[[["self"]],["fieldpat"]]],[11,"encode","","",51,[[["self"],["__s"]],["result"]]],[11,"decode","","",51,[[["__d"]],["result",["fieldpat"]]]],[11,"fmt","","",51,[[["self"],["formatter"]],["result"]]],[11,"clone","","",100,[[["self"]],["bindingannotation"]]],[11,"eq","","",100,[[["self"],["bindingannotation"]],["bool"]]],[11,"encode","","",100,[[["self"],["__s"]],["result"]]],[11,"decode","","",100,[[["__d"]],["result",["bindingannotation"]]]],[11,"fmt","","",100,[[["self"],["formatter"]],["result"]]],[11,"clone","","",101,[[["self"]],["rangeend"]]],[11,"eq","","",101,[[["self"],["rangeend"]],["bool"]]],[11,"encode","","",101,[[["self"],["__s"]],["result"]]],[11,"decode","","",101,[[["__d"]],["result",["rangeend"]]]],[11,"fmt","","",101,[[["self"],["formatter"]],["result"]]],[11,"clone","","",102,[[["self"]],["patkind"]]],[11,"encode","","",102,[[["self"],["__s"]],["result"]]],[11,"decode","","",102,[[["__d"]],["result",["patkind"]]]],[11,"fmt","","",102,[[["self"],["formatter"]],["result"]]],[11,"clone","","",103,[[["self"]],["mutability"]]],[11,"eq","","",103,[[["self"],["mutability"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",103,N],[11,"partial_cmp","","",103,[[["self"],["mutability"]],["option",["ordering"]]]],[11,"cmp","","",103,[[["self"],["mutability"]],["ordering"]]],[11,"encode","","",103,[[["self"],["__s"]],["result"]]],[11,"decode","","",103,[[["__d"]],["result",["mutability"]]]],[11,"hash","","",103,N],[11,"fmt","","",103,[[["self"],["formatter"]],["result"]]],[11,"and","","Return MutMutable only if both arguments are mutable.",103,[[["self"],["self"]],["self"]]],[11,"clone","","",104,[[["self"]],["binopkind"]]],[11,"eq","","",104,[[["self"],["binopkind"]],["bool"]]],[11,"encode","","",104,[[["self"],["__s"]],["result"]]],[11,"decode","","",104,[[["__d"]],["result",["binopkind"]]]],[11,"fmt","","",104,[[["self"],["formatter"]],["result"]]],[11,"hash","","",104,N],[11,"as_str","","",104,[[["self"]],["str"]]],[11,"is_lazy","","",104,[[["self"]],["bool"]]],[11,"is_shift","","",104,[[["self"]],["bool"]]],[11,"is_comparison","","",104,[[["self"]],["bool"]]],[11,"is_by_value","","Returns `true` if the binary operator takes its arguments by value",104,[[["self"]],["bool"]]],[11,"into","","",104,[[["self"]],["binopkind"]]],[11,"clone","","",105,[[["self"]],["unop"]]],[11,"eq","","",105,[[["self"],["unop"]],["bool"]]],[11,"encode","","",105,[[["self"],["__s"]],["result"]]],[11,"decode","","",105,[[["__d"]],["result",["unop"]]]],[11,"fmt","","",105,[[["self"],["formatter"]],["result"]]],[11,"hash","","",105,N],[11,"as_str","","",105,[[["self"]],["str"]]],[11,"is_by_value","","Returns `true` if the unary operator takes its argument by value",105,[[["self"]],["bool"]]],[11,"fmt","","",106,[[["self"],["formatter"]],["result"]]],[11,"clone","","",106,[[["self"]],["stmtkind"]]],[11,"encode","","",106,[[["self"],["__s"]],["result"]]],[11,"decode","","",106,[[["__d"]],["result",["stmtkind"]]]],[11,"attrs","","",106,N],[11,"id","","",106,[[["self"]],["nodeid"]]],[11,"clone","","",52,[[["self"]],["local"]]],[11,"encode","","",52,[[["self"],["__s"]],["result"]]],[11,"decode","","",52,[[["__d"]],["result",["local"]]]],[11,"fmt","","",52,[[["self"],["formatter"]],["result"]]],[11,"clone","","",107,[[["self"]],["declkind"]]],[11,"encode","","",107,[[["self"],["__s"]],["result"]]],[11,"decode","","",107,[[["__d"]],["result",["declkind"]]]],[11,"fmt","","",107,[[["self"],["formatter"]],["result"]]],[11,"attrs","","",107,N],[11,"is_local","","",107,[[["self"]],["bool"]]],[11,"clone","","",53,[[["self"]],["arm"]]],[11,"encode","","",53,[[["self"],["__s"]],["result"]]],[11,"decode","","",53,[[["__d"]],["result",["arm"]]]],[11,"fmt","","",53,[[["self"],["formatter"]],["result"]]],[11,"clone","","",54,[[["self"]],["field"]]],[11,"encode","","",54,[[["self"],["__s"]],["result"]]],[11,"decode","","",54,[[["__d"]],["result",["field"]]]],[11,"fmt","","",54,[[["self"],["formatter"]],["result"]]],[11,"clone","","",108,[[["self"]],["blockcheckmode"]]],[11,"eq","","",108,[[["self"],["blockcheckmode"]],["bool"]]],[11,"ne","","",108,[[["self"],["blockcheckmode"]],["bool"]]],[11,"encode","","",108,[[["self"],["__s"]],["result"]]],[11,"decode","","",108,[[["__d"]],["result",["blockcheckmode"]]]],[11,"fmt","","",108,[[["self"],["formatter"]],["result"]]],[11,"clone","","",109,[[["self"]],["unsafesource"]]],[11,"eq","","",109,[[["self"],["unsafesource"]],["bool"]]],[11,"encode","","",109,[[["self"],["__s"]],["result"]]],[11,"decode","","",109,[[["__d"]],["result",["unsafesource"]]]],[11,"fmt","","",109,[[["self"],["formatter"]],["result"]]],[11,"clone","","",55,[[["self"]],["bodyid"]]],[11,"eq","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"ne","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",55,N],[11,"partial_cmp","","",55,[[["self"],["bodyid"]],["option",["ordering"]]]],[11,"lt","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"le","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"gt","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"ge","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"cmp","","",55,[[["self"],["bodyid"]],["ordering"]]],[11,"encode","","",55,[[["self"],["__s"]],["result"]]],[11,"decode","","",55,[[["__d"]],["result",["bodyid"]]]],[11,"hash","","",55,N],[11,"fmt","","",55,[[["self"],["formatter"]],["result"]]],[11,"clone","","",56,[[["self"]],["body"]]],[11,"encode","","",56,[[["self"],["__s"]],["result"]]],[11,"decode","","",56,[[["__d"]],["result",["body"]]]],[11,"fmt","","",56,[[["self"],["formatter"]],["result"]]],[11,"id","","",56,[[["self"]],["bodyid"]]],[11,"clone","","",110,[[["self"]],["bodyownerkind"]]],[11,"fmt","","",110,[[["self"],["formatter"]],["result"]]],[11,"clone","","",57,[[["self"]],["anonconst"]]],[11,"eq","","",57,[[["self"],["anonconst"]],["bool"]]],[11,"ne","","",57,[[["self"],["anonconst"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",57,N],[11,"encode","","",57,[[["self"],["__s"]],["result"]]],[11,"decode","","",57,[[["__d"]],["result",["anonconst"]]]],[11,"fmt","","",57,[[["self"],["formatter"]],["result"]]],[11,"clone","","",58,[[["self"]],["expr"]]],[11,"encode","","",58,[[["self"],["__s"]],["result"]]],[11,"decode","","",58,[[["__d"]],["result",["expr"]]]],[11,"precedence","","",58,[[["self"]],["exprprecedence"]]],[11,"fmt","","",58,[[["self"],["formatter"]],["result"]]],[11,"clone","","",111,[[["self"]],["exprkind"]]],[11,"encode","","",111,[[["self"],["__s"]],["result"]]],[11,"decode","","",111,[[["__d"]],["result",["exprkind"]]]],[11,"fmt","","",111,[[["self"],["formatter"]],["result"]]],[11,"clone","","",112,[[["self"]],["qpath"]]],[11,"encode","","",112,[[["self"],["__s"]],["result"]]],[11,"decode","","",112,[[["__d"]],["result",["qpath"]]]],[11,"fmt","","",112,[[["self"],["formatter"]],["result"]]],[11,"clone","","",113,[[["self"]],["localsource"]]],[11,"encode","","",113,[[["self"],["__s"]],["result"]]],[11,"decode","","",113,[[["__d"]],["result",["localsource"]]]],[11,"fmt","","",113,[[["self"],["formatter"]],["result"]]],[11,"clone","","",114,[[["self"]],["matchsource"]]],[11,"eq","","",114,[[["self"],["matchsource"]],["bool"]]],[11,"ne","","",114,[[["self"],["matchsource"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",114,N],[11,"encode","","",114,[[["self"],["__s"]],["result"]]],[11,"decode","","",114,[[["__d"]],["result",["matchsource"]]]],[11,"hash","","",114,N],[11,"fmt","","",114,[[["self"],["formatter"]],["result"]]],[11,"clone","","",115,[[["self"]],["loopsource"]]],[11,"eq","","",115,[[["self"],["loopsource"]],["bool"]]],[11,"encode","","",115,[[["self"],["__s"]],["result"]]],[11,"decode","","",115,[[["__d"]],["result",["loopsource"]]]],[11,"fmt","","",115,[[["self"],["formatter"]],["result"]]],[11,"clone","","",116,[[["self"]],["loopiderror"]]],[11,"encode","","",116,[[["self"],["__s"]],["result"]]],[11,"decode","","",116,[[["__d"]],["result",["loopiderror"]]]],[11,"fmt","","",116,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",116,[[["self"],["formatter"]],["result"]]],[11,"clone","","",59,[[["self"]],["destination"]]],[11,"encode","","",59,[[["self"],["__s"]],["result"]]],[11,"decode","","",59,[[["__d"]],["result",["destination"]]]],[11,"fmt","","",59,[[["self"],["formatter"]],["result"]]],[11,"clone","","",117,[[["self"]],["generatormovability"]]],[11,"eq","","",117,[[["self"],["generatormovability"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",117,N],[11,"partial_cmp","","",117,[[["self"],["generatormovability"]],["option",["ordering"]]]],[11,"cmp","","",117,[[["self"],["generatormovability"]],["ordering"]]],[11,"encode","","",117,[[["self"],["__s"]],["result"]]],[11,"decode","","",117,[[["__d"]],["result",["generatormovability"]]]],[11,"hash","","",117,N],[11,"fmt","","",117,[[["self"],["formatter"]],["result"]]],[11,"clone","","",118,[[["self"]],["captureclause"]]],[11,"encode","","",118,[[["self"],["__s"]],["result"]]],[11,"decode","","",118,[[["__d"]],["result",["captureclause"]]]],[11,"fmt","","",118,[[["self"],["formatter"]],["result"]]],[11,"clone","","",60,[[["self"]],["mutty"]]],[11,"encode","","",60,[[["self"],["__s"]],["result"]]],[11,"decode","","",60,[[["__d"]],["result",["mutty"]]]],[11,"fmt","","",60,[[["self"],["formatter"]],["result"]]],[11,"clone","","",61,[[["self"]],["methodsig"]]],[11,"encode","","",61,[[["self"],["__s"]],["result"]]],[11,"decode","","",61,[[["__d"]],["result",["methodsig"]]]],[11,"fmt","","",61,[[["self"],["formatter"]],["result"]]],[11,"clone","","",62,[[["self"]],["traititemid"]]],[11,"eq","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"ne","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",62,N],[11,"partial_cmp","","",62,[[["self"],["traititemid"]],["option",["ordering"]]]],[11,"lt","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"le","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"gt","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"ge","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"cmp","","",62,[[["self"],["traititemid"]],["ordering"]]],[11,"encode","","",62,[[["self"],["__s"]],["result"]]],[11,"decode","","",62,[[["__d"]],["result",["traititemid"]]]],[11,"fmt","","",62,[[["self"],["formatter"]],["result"]]],[11,"clone","","",63,[[["self"]],["traititem"]]],[11,"encode","","",63,[[["self"],["__s"]],["result"]]],[11,"decode","","",63,[[["__d"]],["result",["traititem"]]]],[11,"fmt","","",63,[[["self"],["formatter"]],["result"]]],[11,"clone","","",119,[[["self"]],["traitmethod"]]],[11,"encode","","",119,[[["self"],["__s"]],["result"]]],[11,"decode","","",119,[[["__d"]],["result",["traitmethod"]]]],[11,"fmt","","",119,[[["self"],["formatter"]],["result"]]],[11,"clone","","",120,[[["self"]],["traititemkind"]]],[11,"encode","","",120,[[["self"],["__s"]],["result"]]],[11,"decode","","",120,[[["__d"]],["result",["traititemkind"]]]],[11,"fmt","","",120,[[["self"],["formatter"]],["result"]]],[11,"clone","","",64,[[["self"]],["implitemid"]]],[11,"eq","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"ne","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",64,N],[11,"partial_cmp","","",64,[[["self"],["implitemid"]],["option",["ordering"]]]],[11,"lt","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"le","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"gt","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"ge","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"cmp","","",64,[[["self"],["implitemid"]],["ordering"]]],[11,"encode","","",64,[[["self"],["__s"]],["result"]]],[11,"decode","","",64,[[["__d"]],["result",["implitemid"]]]],[11,"fmt","","",64,[[["self"],["formatter"]],["result"]]],[11,"clone","","",65,[[["self"]],["implitem"]]],[11,"encode","","",65,[[["self"],["__s"]],["result"]]],[11,"decode","","",65,[[["__d"]],["result",["implitem"]]]],[11,"fmt","","",65,[[["self"],["formatter"]],["result"]]],[11,"clone","","",121,[[["self"]],["implitemkind"]]],[11,"encode","","",121,[[["self"],["__s"]],["result"]]],[11,"decode","","",121,[[["__d"]],["result",["implitemkind"]]]],[11,"fmt","","",121,[[["self"],["formatter"]],["result"]]],[11,"clone","","",66,[[["self"]],["typebinding"]]],[11,"encode","","",66,[[["self"],["__s"]],["result"]]],[11,"decode","","",66,[[["__d"]],["result",["typebinding"]]]],[11,"fmt","","",66,[[["self"],["formatter"]],["result"]]],[11,"clone","","",67,[[["self"]],["ty"]]],[11,"encode","","",67,[[["self"],["__s"]],["result"]]],[11,"decode","","",67,[[["__d"]],["result",["ty"]]]],[11,"fmt","","",67,[[["self"],["formatter"]],["result"]]],[11,"clone","","",122,[[["self"]],["primty"]]],[11,"eq","","",122,[[["self"],["primty"]],["bool"]]],[11,"ne","","",122,[[["self"],["primty"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",122,N],[11,"encode","","",122,[[["self"],["__s"]],["result"]]],[11,"decode","","",122,[[["__d"]],["result",["primty"]]]],[11,"hash","","",122,N],[11,"fmt","","",122,[[["self"],["formatter"]],["result"]]],[11,"clone","","",68,[[["self"]],["barefnty"]]],[11,"encode","","",68,[[["self"],["__s"]],["result"]]],[11,"decode","","",68,[[["__d"]],["result",["barefnty"]]]],[11,"fmt","","",68,[[["self"],["formatter"]],["result"]]],[11,"clone","","",69,[[["self"]],["existty"]]],[11,"encode","","",69,[[["self"],["__s"]],["result"]]],[11,"decode","","",69,[[["__d"]],["result",["existty"]]]],[11,"fmt","","",69,[[["self"],["formatter"]],["result"]]],[11,"clone","","",123,[[["self"]],["tykind"]]],[11,"encode","","",123,[[["self"],["__s"]],["result"]]],[11,"decode","","",123,[[["__d"]],["result",["tykind"]]]],[11,"fmt","","",123,[[["self"],["formatter"]],["result"]]],[11,"clone","","",70,[[["self"]],["inlineasmoutput"]]],[11,"encode","","",70,[[["self"],["__s"]],["result"]]],[11,"decode","","",70,[[["__d"]],["result",["inlineasmoutput"]]]],[11,"fmt","","",70,[[["self"],["formatter"]],["result"]]],[11,"clone","","",71,[[["self"]],["inlineasm"]]],[11,"encode","","",71,[[["self"],["__s"]],["result"]]],[11,"decode","","",71,[[["__d"]],["result",["inlineasm"]]]],[11,"fmt","","",71,[[["self"],["formatter"]],["result"]]],[11,"clone","","",72,[[["self"]],["arg"]]],[11,"encode","","",72,[[["self"],["__s"]],["result"]]],[11,"decode","","",72,[[["__d"]],["result",["arg"]]]],[11,"fmt","","",72,[[["self"],["formatter"]],["result"]]],[11,"clone","","",73,[[["self"]],["fndecl"]]],[11,"encode","","",73,[[["self"],["__s"]],["result"]]],[11,"decode","","",73,[[["__d"]],["result",["fndecl"]]]],[11,"fmt","","",73,[[["self"],["formatter"]],["result"]]],[11,"clone","","",124,[[["self"]],["isauto"]]],[11,"eq","","",124,[[["self"],["isauto"]],["bool"]]],[11,"encode","","",124,[[["self"],["__s"]],["result"]]],[11,"decode","","",124,[[["__d"]],["result",["isauto"]]]],[11,"fmt","","",124,[[["self"],["formatter"]],["result"]]],[11,"clone","","",125,[[["self"]],["isasync"]]],[11,"eq","","",125,[[["self"],["isasync"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",125,N],[11,"partial_cmp","","",125,[[["self"],["isasync"]],["option",["ordering"]]]],[11,"cmp","","",125,[[["self"],["isasync"]],["ordering"]]],[11,"encode","","",125,[[["self"],["__s"]],["result"]]],[11,"decode","","",125,[[["__d"]],["result",["isasync"]]]],[11,"fmt","","",125,[[["self"],["formatter"]],["result"]]],[11,"clone","","",126,[[["self"]],["unsafety"]]],[11,"eq","","",126,[[["self"],["unsafety"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",126,N],[11,"partial_cmp","","",126,[[["self"],["unsafety"]],["option",["ordering"]]]],[11,"cmp","","",126,[[["self"],["unsafety"]],["ordering"]]],[11,"encode","","",126,[[["self"],["__s"]],["result"]]],[11,"decode","","",126,[[["__d"]],["result",["unsafety"]]]],[11,"hash","","",126,N],[11,"fmt","","",126,[[["self"],["formatter"]],["result"]]],[11,"clone","","",127,[[["self"]],["constness"]]],[11,"eq","","",127,[[["self"],["constness"]],["bool"]]],[11,"encode","","",127,[[["self"],["__s"]],["result"]]],[11,"decode","","",127,[[["__d"]],["result",["constness"]]]],[11,"fmt","","",127,[[["self"],["formatter"]],["result"]]],[11,"clone","","",128,[[["self"]],["defaultness"]]],[11,"eq","","",128,[[["self"],["defaultness"]],["bool"]]],[11,"ne","","",128,[[["self"],["defaultness"]],["bool"]]],[11,"encode","","",128,[[["self"],["__s"]],["result"]]],[11,"decode","","",128,[[["__d"]],["result",["defaultness"]]]],[11,"fmt","","",128,[[["self"],["formatter"]],["result"]]],[11,"has_value","","",128,[[["self"]],["bool"]]],[11,"is_final","","",128,[[["self"]],["bool"]]],[11,"is_default","","",128,[[["self"]],["bool"]]],[11,"fmt","","",126,[[["self"],["formatter"]],["result"]]],[11,"clone","","",129,[[["self"]],["implpolarity"]]],[11,"eq","","",129,[[["self"],["implpolarity"]],["bool"]]],[11,"encode","","",129,[[["self"],["__s"]],["result"]]],[11,"decode","","",129,[[["__d"]],["result",["implpolarity"]]]],[11,"fmt","","",129,[[["self"],["formatter"]],["result"]]],[11,"clone","","",130,[[["self"]],["functionretty"]]],[11,"encode","","",130,[[["self"],["__s"]],["result"]]],[11,"decode","","",130,[[["__d"]],["result",["functionretty"]]]],[11,"fmt","","",130,[[["self"],["formatter"]],["result"]]],[11,"span","","",130,[[["self"]],["span"]]],[11,"clone","","",74,[[["self"]],["mod"]]],[11,"encode","","",74,[[["self"],["__s"]],["result"]]],[11,"decode","","",74,[[["__d"]],["result",["mod"]]]],[11,"fmt","","",74,[[["self"],["formatter"]],["result"]]],[11,"clone","","",75,[[["self"]],["foreignmod"]]],[11,"encode","","",75,[[["self"],["__s"]],["result"]]],[11,"decode","","",75,[[["__d"]],["result",["foreignmod"]]]],[11,"fmt","","",75,[[["self"],["formatter"]],["result"]]],[11,"clone","","",76,[[["self"]],["globalasm"]]],[11,"encode","","",76,[[["self"],["__s"]],["result"]]],[11,"decode","","",76,[[["__d"]],["result",["globalasm"]]]],[11,"fmt","","",76,[[["self"],["formatter"]],["result"]]],[11,"clone","","",77,[[["self"]],["enumdef"]]],[11,"encode","","",77,[[["self"],["__s"]],["result"]]],[11,"decode","","",77,[[["__d"]],["result",["enumdef"]]]],[11,"fmt","","",77,[[["self"],["formatter"]],["result"]]],[11,"clone","","",78,[[["self"]],["variantkind"]]],[11,"encode","","",78,[[["self"],["__s"]],["result"]]],[11,"decode","","",78,[[["__d"]],["result",["variantkind"]]]],[11,"fmt","","",78,[[["self"],["formatter"]],["result"]]],[11,"clone","","",131,[[["self"]],["usekind"]]],[11,"eq","","",131,[[["self"],["usekind"]],["bool"]]],[11,"encode","","",131,[[["self"],["__s"]],["result"]]],[11,"decode","","",131,[[["__d"]],["result",["usekind"]]]],[11,"fmt","","",131,[[["self"],["formatter"]],["result"]]],[11,"clone","","",79,[[["self"]],["traitref"]]],[11,"encode","","",79,[[["self"],["__s"]],["result"]]],[11,"decode","","",79,[[["__d"]],["result",["traitref"]]]],[11,"fmt","","",79,[[["self"],["formatter"]],["result"]]],[11,"clone","","",80,[[["self"]],["polytraitref"]]],[11,"encode","","",80,[[["self"],["__s"]],["result"]]],[11,"decode","","",80,[[["__d"]],["result",["polytraitref"]]]],[11,"fmt","","",80,[[["self"],["formatter"]],["result"]]],[11,"clone","","",132,[[["self"]],["visibilitykind"]]],[11,"encode","","",132,[[["self"],["__s"]],["result"]]],[11,"decode","","",132,[[["__d"]],["result",["visibilitykind"]]]],[11,"fmt","","",132,[[["self"],["formatter"]],["result"]]],[11,"is_pub","","",132,[[["self"]],["bool"]]],[11,"is_pub_restricted","","",132,[[["self"]],["bool"]]],[11,"clone","","",81,[[["self"]],["structfield"]]],[11,"encode","","",81,[[["self"],["__s"]],["result"]]],[11,"decode","","",81,[[["__d"]],["result",["structfield"]]]],[11,"fmt","","",81,[[["self"],["formatter"]],["result"]]],[11,"is_positional","","",81,[[["self"]],["bool"]]],[11,"clone","","",133,[[["self"]],["variantdata"]]],[11,"encode","","",133,[[["self"],["__s"]],["result"]]],[11,"decode","","",133,[[["__d"]],["result",["variantdata"]]]],[11,"fmt","","",133,[[["self"],["formatter"]],["result"]]],[11,"fields","","",133,N],[11,"id","","",133,[[["self"]],["nodeid"]]],[11,"is_struct","","",133,[[["self"]],["bool"]]],[11,"is_tuple","","",133,[[["self"]],["bool"]]],[11,"is_unit","","",133,[[["self"]],["bool"]]],[11,"clone","","",82,[[["self"]],["itemid"]]],[11,"encode","","",82,[[["self"],["__s"]],["result"]]],[11,"decode","","",82,[[["__d"]],["result",["itemid"]]]],[11,"fmt","","",82,[[["self"],["formatter"]],["result"]]],[11,"clone","","",83,[[["self"]],["item"]]],[11,"encode","","",83,[[["self"],["__s"]],["result"]]],[11,"decode","","",83,[[["__d"]],["result",["item"]]]],[11,"fmt","","",83,[[["self"],["formatter"]],["result"]]],[11,"clone","","",84,[[["self"]],["fnheader"]]],[11,"encode","","",84,[[["self"],["__s"]],["result"]]],[11,"decode","","",84,[[["__d"]],["result",["fnheader"]]]],[11,"fmt","","",84,[[["self"],["formatter"]],["result"]]],[11,"clone","","",134,[[["self"]],["itemkind"]]],[11,"encode","","",134,[[["self"],["__s"]],["result"]]],[11,"decode","","",134,[[["__d"]],["result",["itemkind"]]]],[11,"fmt","","",134,[[["self"],["formatter"]],["result"]]],[11,"descriptive_variant","","",134,[[["self"]],["str"]]],[11,"adt_kind","","",134,[[["self"]],["option",["adtkind"]]]],[11,"generics","","",134,[[["self"]],["option",["generics"]]]],[11,"clone","","",85,[[["self"]],["traititemref"]]],[11,"encode","","",85,[[["self"],["__s"]],["result"]]],[11,"decode","","",85,[[["__d"]],["result",["traititemref"]]]],[11,"fmt","","",85,[[["self"],["formatter"]],["result"]]],[11,"clone","","",86,[[["self"]],["implitemref"]]],[11,"encode","","",86,[[["self"],["__s"]],["result"]]],[11,"decode","","",86,[[["__d"]],["result",["implitemref"]]]],[11,"fmt","","",86,[[["self"],["formatter"]],["result"]]],[11,"clone","","",135,[[["self"]],["associateditemkind"]]],[11,"eq","","",135,[[["self"],["associateditemkind"]],["bool"]]],[11,"ne","","",135,[[["self"],["associateditemkind"]],["bool"]]],[11,"encode","","",135,[[["self"],["__s"]],["result"]]],[11,"decode","","",135,[[["__d"]],["result",["associateditemkind"]]]],[11,"fmt","","",135,[[["self"],["formatter"]],["result"]]],[11,"clone","","",87,[[["self"]],["foreignitem"]]],[11,"encode","","",87,[[["self"],["__s"]],["result"]]],[11,"decode","","",87,[[["__d"]],["result",["foreignitem"]]]],[11,"fmt","","",87,[[["self"],["formatter"]],["result"]]],[11,"clone","","",136,[[["self"]],["foreignitemkind"]]],[11,"encode","","",136,[[["self"],["__s"]],["result"]]],[11,"decode","","",136,[[["__d"]],["result",["foreignitemkind"]]]],[11,"fmt","","",136,[[["self"],["formatter"]],["result"]]],[11,"descriptive_variant","","",136,[[["self"]],["str"]]],[11,"fmt","","",88,[[["self"],["formatter"]],["result"]]],[11,"clone","","",88,[[["self"]],["freevar"]]],[11,"encode","","",88,[[["self"],["__s"]],["result"]]],[11,"decode","","",88,[[["__d"]],["result",["freevar"]]]],[11,"var_id","","",88,[[["self"]],["nodeid"]]],[11,"clone","","",89,[[["self"]],["traitcandidate"]]],[11,"fmt","","",89,[[["self"],["formatter"]],["result"]]],[11,"clone","","",90,[[["self"]],["codegenfnattrs"]]],[11,"encode","","",90,[[["self"],["__s"]],["result"]]],[11,"decode","","",90,[[["__d"]],["result",["codegenfnattrs"]]]],[11,"eq","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"ne","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",91,N],[11,"clone","","",91,[[["self"]],["codegenfnattrflags"]]],[11,"partial_cmp","","",91,[[["self"],["codegenfnattrflags"]],["option",["ordering"]]]],[11,"lt","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"le","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"gt","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"ge","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"cmp","","",91,[[["self"],["codegenfnattrflags"]],["ordering"]]],[11,"hash","","",91,N],[11,"encode","","",91,[[["self"],["__s"]],["result"]]],[11,"decode","","",91,[[["__d"]],["result",["codegenfnattrflags"]]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[18,"COLD","","",91,N],[18,"ALLOCATOR","","",91,N],[18,"UNWIND","","",91,N],[18,"RUSTC_ALLOCATOR_NOUNWIND","","",91,N],[18,"NAKED","","",91,N],[18,"NO_MANGLE","","",91,N],[18,"RUSTC_STD_INTERNAL_SYMBOL","","",91,N],[18,"NO_DEBUG","","",91,N],[18,"THREAD_LOCAL","","",91,N],[18,"USED","","",91,N],[11,"empty","","Returns an empty set of flags.",91,[[],["codegenfnattrflags"]]],[11,"all","","Returns the set containing all flags.",91,[[],["codegenfnattrflags"]]],[11,"bits","","Returns the raw value of the flags currently stored.",91,[[["self"]],["u32"]]],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",91,[[["u32"]],["option",["codegenfnattrflags"]]]],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",91,[[["u32"]],["codegenfnattrflags"]]],[11,"is_empty","","Returns `true` if no flags are currently stored.",91,[[["self"]],["bool"]]],[11,"is_all","","Returns `true` if all flags are currently set.",91,[[["self"]],["bool"]]],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"insert","","Inserts the specified flags in-place.",91,[[["self"],["codegenfnattrflags"]]]],[11,"remove","","Removes the specified flags in-place.",91,[[["self"],["codegenfnattrflags"]]]],[11,"toggle","","Toggles the specified flags in-place.",91,[[["self"],["codegenfnattrflags"]]]],[11,"set","","Inserts or removes the specified flags depending on the passed value.",91,[[["self"],["codegenfnattrflags"],["bool"]]]],[11,"bitor","","Returns the union of the two sets of flags.",91,[[["self"],["codegenfnattrflags"]],["codegenfnattrflags"]]],[11,"bitor_assign","","Adds the set of flags.",91,[[["self"],["codegenfnattrflags"]]]],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",91,[[["self"],["codegenfnattrflags"]],["codegenfnattrflags"]]],[11,"bitxor_assign","","Toggles the set of flags.",91,[[["self"],["codegenfnattrflags"]]]],[11,"bitand","","Returns the intersection between the two sets of flags.",91,[[["self"],["codegenfnattrflags"]],["codegenfnattrflags"]]],[11,"bitand_assign","","Disables all flags disabled in the set.",91,[[["self"],["codegenfnattrflags"]]]],[11,"sub","","Returns the set difference of the two sets of flags.",91,[[["self"],["codegenfnattrflags"]],["codegenfnattrflags"]]],[11,"sub_assign","","Disables all flags enabled in the set.",91,[[["self"],["codegenfnattrflags"]]]],[11,"not","","Returns the complement of this set of flags.",91,[[["self"]],["codegenfnattrflags"]]],[11,"extend","","",91,[[["self"],["t"]]]],[11,"from_iter","","",91,[[["t"]],["codegenfnattrflags"]]],[11,"new","","",90,[[],["codegenfnattrs"]]],[11,"requests_inline","","True if `#[inline]` or `#[inline(always)]` is present.",90,[[["self"]],["bool"]]],[11,"contains_extern_indicator","","True if `#[no_mangle]` or `#[export_name(...)]` is present.",90,[[["self"]],["bool"]]],[0,"ich","rustc","ICH - Incremental Compilation Hash",N,N],[3,"Fingerprint","rustc::ich","",N,N],[12,"0","","",199,N],[12,"1","","",199,N],[3,"CachingCodemapView","","",N,N],[12,"codemap","","",200,N],[12,"line_cache","","",200,N],[12,"time_stamp","","",200,N],[3,"StableHashingContext","","This is the context state available during incr. comp. hashing. It contains enough information to transform DefIds and HirIds into stable DefPaths (i.e. a reference to the TyCtxt) and it holds a few caches for speeding up various things (e.g. each DefId/DefPath is only hashed once).",N,N],[12,"sess","","",201,N],[12,"definitions","","",201,N],[12,"cstore","","",201,N],[12,"body_resolver","","",201,N],[12,"hash_spans","","",201,N],[12,"hash_bodies","","",201,N],[12,"node_id_hashing_mode","","",201,N],[12,"raw_codemap","","",201,N],[12,"caching_codemap","","",201,N],[12,"alloc_id_recursion_tracker","","",201,N],[4,"NodeIdHashingMode","","",N,N],[13,"Ignore","","",202,N],[13,"HashDefPath","","",202,N],[5,"hash_stable_trait_impls","","",N,N],[5,"compute_ignored_attr_names","","",N,[[],["fxhashset",["symbol"]]]],[0,"fingerprint","","",N,N],[3,"Fingerprint","rustc::ich::fingerprint","",N,N],[12,"0","","",199,N],[12,"1","","",199,N],[11,"assert_receiver_is_total_eq","rustc::ich","",199,N],[11,"eq","","",199,[[["self"],["fingerprint"]],["bool"]]],[11,"ne","","",199,[[["self"],["fingerprint"]],["bool"]]],[11,"cmp","","",199,[[["self"],["fingerprint"]],["ordering"]]],[11,"partial_cmp","","",199,[[["self"],["fingerprint"]],["option",["ordering"]]]],[11,"lt","","",199,[[["self"],["fingerprint"]],["bool"]]],[11,"le","","",199,[[["self"],["fingerprint"]],["bool"]]],[11,"gt","","",199,[[["self"],["fingerprint"]],["bool"]]],[11,"ge","","",199,[[["self"],["fingerprint"]],["bool"]]],[11,"hash","","",199,N],[11,"fmt","","",199,[[["self"],["formatter"]],["result"]]],[11,"clone","","",199,[[["self"]],["fingerprint"]]],[18,"ZERO","","",199,N],[11,"from_smaller_hash","","",199,[[["u64"]],["fingerprint"]]],[11,"to_smaller_hash","","",199,[[["self"]],["u64"]]],[11,"as_value","","",199,N],[11,"combine","","",199,[[["self"],["fingerprint"]],["fingerprint"]]],[11,"combine_commutative","","",199,[[["self"],["fingerprint"]],["fingerprint"]]],[11,"to_hex","","",199,[[["self"]],["string"]]],[11,"encode_opaque","","",199,[[["self"],["encoder"]],["encoderesult"]]],[11,"decode_opaque","","",199,[[["decoder"]],["result",["fingerprint","string"]]]],[11,"fmt","","",199,[[["self"],["formatter"]],["result"]]],[11,"finish","","",199,[[["stablehasher"]],["self"]]],[11,"hash_stable","","",199,[[["self"],["ctx"],["stablehasher"]]]],[0,"caching_codemap_view","","",N,N],[3,"CacheEntry","rustc::ich::caching_codemap_view","",N,N],[12,"time_stamp","","",203,N],[12,"line_number","","",203,N],[12,"line_start","","",203,N],[12,"line_end","","",203,N],[12,"file","","",203,N],[12,"file_index","","",203,N],[3,"CachingCodemapView","","",N,N],[12,"codemap","","",200,N],[12,"line_cache","","",200,N],[12,"time_stamp","","",200,N],[11,"clone","","",203,[[["self"]],["cacheentry"]]],[11,"clone","rustc::ich","",200,[[["self"]],["cachingcodemapview"]]],[11,"new","","",200,[[["codemap"]],["cachingcodemapview"]]],[11,"byte_pos_to_line_and_col","","",200,[[["self"],["bytepos"]],["option"]]],[0,"hcx","","",N,N],[3,"StableHashingContext","rustc::ich::hcx","This is the context state available during incr. comp. hashing. It contains enough information to transform DefIds and HirIds into stable DefPaths (i.e. a reference to the TyCtxt) and it holds a few caches for speeding up various things (e.g. each DefId/DefPath is only hashed once).",N,N],[12,"sess","","",201,N],[12,"definitions","","",201,N],[12,"cstore","","",201,N],[12,"body_resolver","","",201,N],[12,"hash_spans","","",201,N],[12,"hash_bodies","","",201,N],[12,"node_id_hashing_mode","","",201,N],[12,"raw_codemap","","",201,N],[12,"caching_codemap","","",201,N],[12,"alloc_id_recursion_tracker","","",201,N],[3,"BodyResolver","","The BodyResolver allows to map a BodyId to the corresponding hir::Body. We could also just store a plain reference to the hir::Crate but we want to avoid that the crate is used to get untracked access to all of the HIR.",N,N],[12,"0","","",204,N],[4,"NodeIdHashingMode","","",N,N],[13,"Ignore","","",202,N],[13,"HashDefPath","","",202,N],[5,"compute_ignored_attr_names","","",N,[[],["fxhashset",["symbol"]]]],[5,"hash_stable_trait_impls","","",N,N],[8,"StableHashingContextProvider","","Something that can provide a stable hashing context.",N,N],[10,"get_stable_hashing_context","","",205,[[["self"]],["stablehashingcontext"]]],[11,"clone","rustc::ich","",201,[[["self"]],["stablehashingcontext"]]],[11,"eq","","",202,[[["self"],["nodeidhashingmode"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",202,N],[11,"clone","","",202,[[["self"]],["nodeidhashingmode"]]],[11,"clone","rustc::ich::hcx","",204,[[["self"]],["bodyresolver"]]],[11,"body","","",204,[[["self"],["bodyid"]],["body"]]],[11,"new","rustc::ich","",201,[[["session"],["crate"],["definitions"],["cratestore"]],["self"]]],[11,"sess","","",201,[[["self"]],["session"]]],[11,"while_hashing_hir_bodies","","",201,[[["self"],["bool"],["f"]]]],[11,"while_hashing_spans","","",201,[[["self"],["bool"],["f"]]]],[11,"with_node_id_hashing_mode","","",201,[[["self"],["nodeidhashingmode"],["f"]]]],[11,"def_path_hash","","",201,[[["self"],["defid"]],["defpathhash"]]],[11,"local_def_path_hash","","",201,[[["self"],["defindex"]],["defpathhash"]]],[11,"node_to_hir_id","","",201,[[["self"],["nodeid"]],["hirid"]]],[11,"hash_bodies","","",201,[[["self"]],["bool"]]],[11,"codemap","","",201,[[["self"]],["cachingcodemapview"]]],[11,"is_ignored_attr","","",201,[[["self"],["symbol"]],["bool"]]],[11,"hash_hir_item_like","","",201,[[["self"],["f"]]]],[11,"get_stable_hashing_context","","",201,[[["self"]],["stablehashingcontext"]]],[11,"hash_stable","rustc::hir","",55,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",33,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",33,N],[0,"impls_cstore","rustc::ich","This module contains `HashStable` implementations for various data types from rustc::middle::cstore in no particular order.",N,N],[0,"impls_hir","","This module contains `HashStable` implementations for various HIR data types in no particular order.",N,N],[11,"hash_stable","rustc::hir::def_id","",147,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",147,[[["self"],["stablehashingcontext"]],["defpathhash"]]],[11,"hash_stable","","",148,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",148,[[["self"],["stablehashingcontext"]],["defpathhash"]]],[11,"hash_stable","","",145,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",145,[[["self"],["stablehashingcontext"]],["defpathhash"]]],[11,"hash_stable","rustc::hir","",34,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",34,[[["self"],["stablehashingcontext"]],["itemlocalid"]]],[11,"hash_stable","","",82,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",62,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",64,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",92,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",93,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",35,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",36,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",37,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",38,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",94,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",39,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",96,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",95,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",40,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",97,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",42,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",98,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",43,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",99,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",44,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",45,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",46,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",60,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",61,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",66,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",84,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",67,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",122,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",68,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",69,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",123,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",73,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",130,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",79,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",80,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",112,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",48,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",49,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",50,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",51,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",100,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",101,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",102,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",104,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",105,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",52,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",107,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",53,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",54,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",108,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",109,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",57,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",58,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",111,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",113,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",115,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",114,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",117,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",118,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",59,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",116,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",63,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",119,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",120,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",65,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",121,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",132,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",128,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",129,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",74,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",75,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",77,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",78,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",131,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",81,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",133,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",83,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",134,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",85,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",86,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",135,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",87,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",136,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",106,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",72,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",56,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",55,N],[11,"hash_stable","","",70,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",76,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",71,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","rustc::hir::def","",142,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",143,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","rustc::hir","",103,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",124,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",126,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",125,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",127,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","rustc::hir::def_id","",146,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",146,[[["self"],["stablehashingcontext"]],["defpathhash"]]],[11,"hash_stable","rustc::hir::def","",141,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","rustc::hir","",89,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",89,N],[11,"hash_stable","","",90,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",91,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",88,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[0,"impls_mir","rustc::ich","This module contains `HashStable` implementations for various MIR data types in no particular order.",N,N],[0,"impls_misc","","This module contains `HashStable` implementations for various data types that don't fit into any of the other impls_xxx modules.",N,N],[0,"impls_ty","","This module contains `HashStable` implementations for various data types from rustc::ty in no particular order.",N,N],[0,"impls_syntax","","This module contains `HashStable` implementations for various data types from libsyntax in no particular order.",N,N],[5,"hash_token","rustc::ich::impls_syntax","",N,[[["token"],["stablehashingcontext"],["stablehasher"]]]],[5,"stable_byte_pos","","",N,[[["bytepos"],["bytepos"]],["u32"]]],[5,"stable_multibyte_char","","",N,N],[5,"stable_non_narrow_char","","",N,N],[17,"ATTR_DIRTY","rustc::ich","",N,N],[17,"ATTR_CLEAN","","",N,N],[17,"ATTR_IF_THIS_CHANGED","","",N,N],[17,"ATTR_THEN_THIS_WOULD_NEED","","",N,N],[17,"ATTR_PARTITION_REUSED","","",N,N],[17,"ATTR_PARTITION_CODEGENED","","",N,N],[17,"DEP_GRAPH_ASSERT_ATTRS","","",N,N],[17,"IGNORED_ATTRIBUTES","","",N,N],[8,"StableHashingContextProvider","","Something that can provide a stable hashing context.",N,N],[10,"get_stable_hashing_context","","",205,[[["self"]],["stablehashingcontext"]]],[0,"infer","rustc","See the Book for more information.",N,N],[3,"TypeFreshener","rustc::infer","",N,N],[12,"infcx","","",206,N],[12,"freshen_count","","",206,N],[12,"freshen_map","","",206,N],[3,"InferOk","","",N,N],[12,"value","","",207,N],[12,"obligations","","",207,N],[3,"InferCtxt","","",N,N],[12,"tcx","","",208,N],[12,"in_progress_tables","","During type-checking/inference of a body, `in_progress_tables` contains a reference to the tables being built up, which are used for reading closure kinds/signatures as they are inferred, and for error reporting logic to read arbitrary node types.",208,N],[12,"projection_cache","","",208,N],[12,"type_variables","","",208,N],[12,"int_unification_table","","",208,N],[12,"float_unification_table","","",208,N],[12,"region_constraints","","",208,N],[12,"lexical_region_resolutions","","",208,N],[12,"selection_cache","","Caches the results of trait selection. This cache is used for things that have to do with the parameters in scope.",208,N],[12,"evaluation_cache","","Caches the results of trait evaluation.",208,N],[12,"reported_trait_errors","","",208,N],[12,"tainted_by_errors_flag","","",208,N],[12,"err_count_on_creation","","",208,N],[12,"in_snapshot","","",208,N],[12,"region_obligations","","",208,N],[12,"universe","","What is the innermost universe we have created? Starts out as `UniverseIndex::root()` but grows from there as we enter universal quantifiers.",208,N],[3,"TypeTrace","","The trace designates the path through inference that we took to encounter an error or subtyping constraint.",N,N],[12,"cause","","",209,N],[12,"values","","",209,N],[3,"RegionObligation","","See the `region_obligations` field for more information.",N,N],[12,"sub_region","","",210,N],[12,"sup_type","","",210,N],[12,"cause","","",210,N],[3,"InferCtxtBuilder","","Helper type of a temporary returned by tcx.infer_ctxt(). Necessary because we can't write the following bound: F: for<'b, 'tcx> where 'gcx: 'tcx FnOnce(InferCtxt<'b, 'gcx, 'tcx>).",N,N],[12,"global_tcx","","",211,N],[12,"arena","","",211,N],[12,"fresh_tables","","",211,N],[3,"CombinedSnapshot","","",N,N],[12,"projection_cache_snapshot","","",212,N],[12,"type_snapshot","","",212,N],[12,"int_snapshot","","",212,N],[12,"float_snapshot","","",212,N],[12,"region_constraints_snapshot","","",212,N],[12,"region_obligations_snapshot","","",212,N],[12,"universe","","",212,N],[12,"was_in_snapshot","","",212,N],[12,"_in_progress_tables","","",212,N],[4,"ValuePairs","","See `error_reporting` module for more details",N,N],[13,"Types","","",213,N],[13,"Regions","","",213,N],[13,"TraitRefs","","",213,N],[13,"PolyTraitRefs","","",213,N],[4,"SubregionOrigin","","The origin of a `r1 <= r2` constraint.",N,N],[13,"Subtype","","",214,N],[13,"InfStackClosure","","",214,N],[13,"InvokeClosure","","",214,N],[13,"DerefPointer","","",214,N],[13,"FreeVariable","","",214,N],[13,"IndexSlice","","",214,N],[13,"RelateObjectBound","","",214,N],[13,"RelateParamBound","","",214,N],[13,"RelateRegionParamBound","","",214,N],[13,"RelateDefaultParamBound","","",214,N],[13,"Reborrow","","",214,N],[13,"ReborrowUpvar","","",214,N],[13,"DataBorrowed","","",214,N],[13,"ReferenceOutlivesReferent","","",214,N],[13,"ParameterInScope","","",214,N],[13,"ExprTypeIsNotInScope","","",214,N],[13,"BindingTypeIsNotValidAtDecl","","",214,N],[13,"CallRcvr","","",214,N],[13,"CallArg","","",214,N],[13,"CallReturn","","",214,N],[13,"Operand","","",214,N],[13,"AddrOf","","",214,N],[13,"AutoBorrow","","",214,N],[13,"SafeDestructor","","",214,N],[13,"CompareImplMethodObligation","","",214,N],[12,"span","rustc::infer::SubregionOrigin","",214,N],[12,"item_name","","",214,N],[12,"impl_item_def_id","","",214,N],[12,"trait_item_def_id","","",214,N],[4,"ParameterOrigin","rustc::infer","Places that type/region parameters can appear.",N,N],[13,"Path","","",215,N],[13,"MethodCall","","",215,N],[13,"OverloadedOperator","","",215,N],[13,"OverloadedDeref","","",215,N],[4,"LateBoundRegionConversionTime","","Times when we replace late-bound regions with variables:",N,N],[13,"FnCall","","when a fn is called",216,N],[13,"HigherRankedType","","when two higher-ranked types are compared",216,N],[13,"AssocTypeProjection","","when projecting an associated type",216,N],[4,"RegionVariableOrigin","","Reasons to create a region inference variable",N,N],[13,"MiscVariable","","",217,N],[13,"PatternRegion","","",217,N],[13,"AddrOfRegion","","",217,N],[13,"Autoref","","",217,N],[13,"Coercion","","",217,N],[13,"EarlyBoundRegion","","",217,N],[13,"LateBoundRegion","","",217,N],[13,"UpvarRegion","","",217,N],[13,"BoundRegionInCoherence","","",217,N],[13,"NLL","","",217,N],[4,"NLLRegionVariableOrigin","","",N,N],[13,"FreeRegion","","",218,N],[13,"BoundRegion","","",218,N],[13,"Existential","","",218,N],[4,"FixupError","","",N,N],[13,"UnresolvedIntTy","","",219,N],[13,"UnresolvedFloatTy","","",219,N],[13,"UnresolvedTy","","",219,N],[0,"anon_types","","",N,N],[3,"AnonTypeDecl","rustc::infer::anon_types","Information about the anonymous, abstract types whose values we are inferring in this function (these are the `impl Trait` that appear in the return type).",N,N],[12,"substs","","The substitutions that we apply to the abstract that that this `impl Trait` desugars to. e.g., if:",220,N],[12,"concrete_ty","","The type variable that represents the value of the abstract type that we require. In other words, after we compile this function, we will be created a constraint like:",220,N],[12,"has_required_region_bounds","","True if the `impl Trait` bounds include region bounds. For example, this would be true for:",220,N],[3,"ReverseMapper","","",N,N],[12,"tcx","","",221,N],[12,"tainted_by_errors","","If errors have already been reported in this fn, we suppress our own errors because they are sometimes derivative.",221,N],[12,"anon_type_def_id","","",221,N],[12,"map","","",221,N],[12,"map_missing_regions_to_empty","","",221,N],[12,"hidden_ty","","initially `Some`, set to `None` once error has been reported",221,N],[3,"Instantiator","","",N,N],[12,"infcx","","",222,N],[12,"parent_def_id","","",222,N],[12,"body_id","","",222,N],[12,"param_env","","",222,N],[12,"anon_types","","",222,N],[12,"obligations","","",222,N],[5,"may_define_existential_type","","Whether `anon_node_id` is a sibling or a child of a sibling of `def_id`",N,[[["tyctxt"],["defid"],["nodeid"]],["bool"]]],[6,"AnonTypeMap","","",N,N],[11,"clone","","",220,[[["self"]],["anontypedecl"]]],[11,"fmt","","",220,[[["self"],["formatter"]],["result"]]],[11,"instantiate_anon_types","rustc::infer","Replace all anonymized types in `value` with fresh inference variables and creates appropriate obligations. For example, given the input:",208,[[["self"],["defid"],["nodeid"],["paramenv"],["t"]],["inferok"]]],[11,"constrain_anon_types","","Given the map `anon_types` containing the existential `impl Trait` types whose underlying, hidden types are being inferred, this method adds constraints to the regions appearing in those underlying hidden types to ensure that they at least do not refer to random scopes within the current function. These constraints are not (quite) sufficient to guarantee that the regions are actually legal values; that final condition is imposed after region inference is done.",208,[[["self"],["anontypemap"],["frr"]]]],[11,"constrain_anon_type","","",208,[[["self"],["defid"],["anontypedecl"],["frr"]]]],[11,"infer_anon_definition_from_instantiation","","Given the fully resolved, instantiated type for an anonymous type, i.e., the value of an inference variable like C1 or C2 (*), computes the \"definition type\" for an abstract type definition -- that is, the inferred value of `Foo1<'x>` or `Foo2<'x>` that we would conceptually use in its definition:",208,[[["self"],["defid"],["anontypedecl"],["ty"]],["ty"]]],[11,"new","rustc::infer::anon_types","",221,[[["tyctxt"],["bool"],["defid"],["fxhashmap",["kind","kind"]],["ty"]],["self"]]],[11,"fold_kind_mapping_missing_regions_to_empty","","",221,[[["self"],["kind"]],["kind"]]],[11,"fold_kind_normally","","",221,[[["self"],["kind"]],["kind"]]],[11,"tcx","","",221,[[["self"]],["tyctxt"]]],[11,"fold_region","","",221,[[["self"],["region"]],["region"]]],[11,"fold_ty","","",221,[[["self"],["ty"]],["ty"]]],[11,"instantiate_anon_types_in_map","","",222,[[["self"],["t"]],["t"]]],[11,"fold_anon_ty","","",222,[[["self"],["ty"],["defid"],["substs"]],["ty"]]],[0,"at","rustc::infer","A nice interface for working with the infcx.  The basic idea is to do `infcx.at(cause, param_env)`, which sets the \"cause\" of the operation as well as the surrounding parameter environment.  Then you can do something like `.sub(a, b)` or `.eq(a, b)` to create a subtype or equality relationship respectively. The first argument is always the \"expected\" output from the POV of diagnostics.",N,N],[3,"At","rustc::infer::at","",N,N],[12,"infcx","","",223,N],[12,"cause","","",223,N],[12,"param_env","","",223,N],[3,"Trace","","",N,N],[12,"at","","",224,N],[12,"a_is_expected","","",224,N],[12,"trace","","",224,N],[8,"ToTrace","","",N,N],[10,"to_trace","","",225,[[["obligationcause"],["bool"],["self"],["self"]],["typetrace"]]],[11,"at","rustc::infer","",208,[[["self"],["obligationcause"],["paramenv"]],["at"]]],[11,"eq_impl_headers","rustc::infer::at","Hacky routine for equating two impl headers in coherence.",223,[[["self"],["implheader"],["implheader"]],["inferresult"]]],[11,"sub_exp","","Make `a <: b` where `a` may or may not be expected",223,[[["self"],["bool"],["t"],["t"]],["inferresult"]]],[11,"sup","","Make `actual <: expected`. For example, if type-checking a call like `foo(x)`, where `foo: fn(i32)`, you might have `sup(i32, x)`, since the \"expected\" type is the type that appears in the signature.",223,[[["self"],["t"],["t"]],["inferresult"]]],[11,"sub","","Make `expected <: actual`",223,[[["self"],["t"],["t"]],["inferresult"]]],[11,"eq_exp","","Make `expected <: actual`",223,[[["self"],["bool"],["t"],["t"]],["inferresult"]]],[11,"eq","","Make `expected <: actual`",223,[[["self"],["t"],["t"]],["inferresult"]]],[11,"lub","","Compute the least-upper-bound, or mutual supertype, of two values. The order of the arguments doesn't matter, but since this can result in an error (e.g., if asked to compute LUB of u32 and i32), it is meaningful to call one of them the \"expected type\".",223,[[["self"],["t"],["t"]],["inferresult"]]],[11,"glb","","Compute the greatest-lower-bound, or mutual subtype, of two values. As with `lub` order doesn't matter, except for error cases.",223,[[["self"],["t"],["t"]],["inferresult"]]],[11,"trace","","Sets the \"trace\" values that will be used for error-reporting, but doesn't actually perform any operation yet (this is useful when you want to set the trace using distinct values from those you wish to operate upon).",223,[[["self"],["t"],["t"]],["trace"]]],[11,"trace_exp","","Like `trace`, but the expected value is determined by the boolean argument (if true, then the first argument `a` is the \"expected\" value).",223,[[["self"],["bool"],["t"],["t"]],["trace"]]],[11,"sub","","Make `a <: b` where `a` may or may not be expected (if `a_is_expected` is true, then `a` is expected). Make `expected <: actual`",224,[[["self"],["t"],["t"]],["inferresult"]]],[11,"eq","","Make `a == b`; the expectation is set by the call to `trace()`.",224,[[["self"],["t"],["t"]],["inferresult"]]],[11,"lub","","",224,[[["self"],["t"],["t"]],["inferresult"]]],[11,"glb","","",224,[[["self"],["t"],["t"]],["inferresult"]]],[0,"canonical","rustc::infer","Canonicalization is the key to constructing a query in the middle of type inference. Ordinarily, it is not possible to store types from type inference in query keys, because they contain references to inference variables whose lifetimes are too short and so forth. Canonicalizing a value T1 using `canonicalize_query` produces two things:",N,N],[3,"Canonical","rustc::infer::canonical","A \"canonicalized\" type `V` is one where all free inference variables have been rewriten to \"canonical vars\". These are numbered starting from 0 in order of first appearance.",N,N],[12,"variables","","",226,N],[12,"value","","",226,N],[3,"CanonicalVarValues","","A set of values corresponding to the canonical variables from some `Canonical`. You can give these values to `canonical_value.substitute` to substitute them into the canonical value at the right places.",N,N],[12,"var_values","","",227,N],[3,"CanonicalVarInfo","","Information about a canonical variable that is included with the canonical value. This is sufficient information for code to create a copy of the canonical value in some other inference context, with fresh inference variables replacing the canonical values.",N,N],[12,"kind","","",228,N],[3,"QueryResult","","After we execute a query with a canonicalized key, we get back a `Canonical<QueryResult<..>>`. You can use `instantiate_query_result` to access the data in this result.",N,N],[12,"var_values","","",229,N],[12,"region_constraints","","",229,N],[12,"certainty","","",229,N],[12,"value","","",229,N],[4,"CanonicalVarKind","","Describes the \"kind\" of the canonical variable. This is a \"kind\" in the type-theory sense of the term -- i.e., a \"meta\" type system that analyzes type-like values.",N,N],[13,"Ty","","Some kind of type inference variable.",230,N],[13,"Region","","Region variable `'?R`.",230,N],[4,"CanonicalTyVarKind","","Rust actually has more than one category of type variables; notably, the type variables we create for literals (e.g., 22 or 22.) can only be instantiated with integral/float types (e.g., usize or f32). In order to faithfully reproduce a type, we need to know what set of types a given type variable can be unified with.",N,N],[13,"General","","General type variable `?T` that can be unified with arbitrary types.",231,N],[13,"Int","","Integral type variable `?I` (that can only be unified with integral types).",231,N],[13,"Float","","Floating-point type variable `?F` (that can only be unified with float types).",231,N],[4,"Certainty","","Indicates whether or not we were able to prove the query to be true.",N,N],[13,"Proven","","The query is known to be true, presuming that you apply the given `var_values` and the region-constraints are satisfied.",232,N],[13,"Ambiguous","","The query is not known to be true, but also not known to be false. The `var_values` represent either values that must hold in order for the query to be true, or helpful tips that might make it true. Currently rustc's trait solver cannot distinguish the two (e.g., due to our preference for where clauses over impls).",232,N],[0,"canonicalizer","","This module contains the \"canonicalizer\" itself.",N,N],[3,"CanonicalizeRegionMode","rustc::infer::canonical::canonicalizer","If this flag is true, then all free regions will be replaced with a canonical var. This is used to make queries as generic as possible. For example, the query `F: Foo<'static>` would be canonicalized to `F: Foo<'0>`.",N,N],[12,"static_region","","",233,N],[12,"other_free_regions","","",233,N],[3,"Canonicalizer","","",N,N],[12,"infcx","","",234,N],[12,"tcx","","",234,N],[12,"variables","","",234,N],[12,"var_values","","",234,N],[12,"indices","","",234,N],[12,"canonicalize_region_mode","","",234,N],[12,"needs_canonical_flags","","",234,N],[11,"canonicalize_query","rustc::infer","Canonicalizes a query value `V`. When we canonicalize a query, we not only canonicalize unbound inference variables, but we also replace all free regions whatsoever. So for example a query like `T: Trait<'static>` would be canonicalized to",208,[[["self"],["v"],["smallcanonicalvarvalues"]],["canonicalized"]]],[11,"canonicalize_response","","Canonicalizes a query response `V`. When we canonicalize a query response, we only canonicalize unbound inference variables, and we leave other free regions alone. So, continuing with the example from `canonicalize_query`, if there was an input query `T: Trait<'static>`, it would have been canonicalized to",208,[[["self"],["v"]],["canonicalized"]]],[11,"canonicalize_hr_query_hack","","A hacky variant of `canonicalize_query` that does not canonicalize `'static`.  Unfortunately, the existing leak check treaks `'static` differently in some cases (see also #33684), so if we are performing an operation that may need to prove \"leak-check\" related things, we leave `'static` alone.",208,[[["self"],["v"],["smallcanonicalvarvalues"]],["canonicalized"]]],[11,"any","rustc::infer::canonical::canonicalizer","",233,[[["self"]],["bool"]]],[11,"tcx","","",234,[[["self"]],["tyctxt"]]],[11,"fold_region","","",234,[[["self"],["region"]],["region"]]],[11,"fold_ty","","",234,[[["self"],["ty"]],["ty"]]],[11,"canonicalize","","The main `canonicalize` method, shared impl of `canonicalize_query` and `canonicalize_response`.",234,[[["v"],["option",["inferctxt"]],["tyctxt"],["canonicalizeregionmode"],["smallcanonicalvarvalues"]],["canonicalized"]]],[11,"canonical_var","","Creates a canonical variable replacing `kind` from the input, or returns an existing variable if `kind` has already been seen. `kind` is expected to be an unbound variable (or potentially a free region).",234,[[["self"],["canonicalvarinfo"],["kind"]],["canonicalvar"]]],[11,"canonicalize_ty_var","","Given a type variable `ty_var` of the given kind, first check if `ty_var` is bound to anything; if so, canonicalize that. Otherwise, create a new canonical variable for `ty_var`.",234,[[["self"],["canonicaltyvarkind"],["ty"]],["ty"]]],[0,"query_result","rustc::infer::canonical","This module contains the code to instantiate a \"query result\", and in particular to extract out the resulting region obligations and encode them therein.",N,N],[5,"make_query_outlives","rustc::infer::canonical::query_result","Given the region obligations and constraints scraped from the infcx, creates query region constraints.",N,[[["tyctxt"],["vec"],["regionconstraintdata"]],["vec",["queryregionconstraint"]]]],[22,"","","",N,N],[11,"enter_canonical_trait_query","rustc::infer","The \"main method\" for a canonicalized trait query. Given the canonical key `canonical_key`, this method will create a new inference context, instantiate the key, and run your operation `op`. The operation should yield up a result (of type `R`) as well as a set of trait obligations that must be fully satisfied. These obligations will be processed and the canonical result created.",211,N],[11,"make_canonicalized_query_result","","This method is meant to be invoked as the final step of a canonical query implementation. It is given:",208,[[["self"],["canonicalvarvalues"],["t"],["fulfillmentcontext"]],["fallible",["canonicalizedqueryresult"]]]],[11,"make_query_result","","Helper for `make_canonicalized_query_result` that does everything up until the final canonicalization.",208,[[["self"],["canonicalvarvalues"],["t"],["fulfillmentcontext"]],["result",["queryresult","nosolution"]]]],[11,"instantiate_query_result_and_region_obligations","","Given the (canonicalized) result to a canonical query, instantiates the result so it can be used, plugging in the values from the canonical query. (Note that the result may have been ambiguous; you should check the certainty level of the query before applying this function.)",208,[[["self"],["obligationcause"],["paramenv"],["smallcanonicalvarvalues"],["canonical"]],["inferresult"]]],[11,"instantiate_nll_query_result_and_region_obligations","","An alternative to `instantiate_query_result_and_region_obligations` that is more efficient for NLL. NLL is a bit more advanced in the \"transition to chalk\" than the rest of the compiler. During the NLL type check, all of the \"processing\" of types and things happens in queries -- the NLL checker itself is only interested in the region obligations (`'a: 'b` or `T: 'b`) that come out of these queries, which it wants to convert into MIR-based constraints and solve. Therefore, it is most convenient for the NLL Type Checker to directly consume the `QueryRegionConstraint` values that arise from doing a query. This is contrast to other parts of the compiler, which would prefer for those `QueryRegionConstraint` to be converted into the older infcx-style constraints (e.g., calls to `sub_regions` or `register_region_obligation`).",208,[[["self"],["obligationcause"],["paramenv"],["smallcanonicalvarvalues"],["canonical"],["vec"]],["inferresult"]]],[11,"query_result_substitution","","Given the original values and the (canonicalized) result from computing a query, returns a substitution that can be applied to the query result to convert the result back into the original namespace.",208,[[["self"],["obligationcause"],["paramenv"],["smallcanonicalvarvalues"],["canonical"]],["inferresult",["canonicalvarvalues"]]]],[11,"query_result_substitution_guess","","Given the original values and the (canonicalized) result from computing a query, returns a guess at a substitution that can be applied to the query result to convert the result back into the original namespace. This is called a guess because it uses a quick heuristic to find the values for each canonical variable; if that quick heuristic fails, then we will instantiate fresh inference variables for each canonical variable instead. Therefore, the result of this method must be properly unified",208,[[["self"],["obligationcause"],["smallcanonicalvarvalues"],["canonical"]],["canonicalvarvalues"]]],[11,"unify_query_result_substitution_guess","","Given a \"guess\" at the values for the canonical variables in the input, try to unify with the actual values found in the query result.  Often, but not always, this is a no-op, because we already found the mapping in the \"guessing\" step.",208,[[["self"],["obligationcause"],["paramenv"],["smallcanonicalvarvalues"],["canonicalvarvalues"],["canonical"]],["inferresult"]]],[11,"query_region_constraints_into_obligations","","Converts the region constraints resulting from a query into an iterator of obligations.",208,N],[11,"unify_canonical_vars","","Given two sets of values for the same set of canonical variables, unify them. The second set is produced lazilly by supplying indices from the first set.",208,N],[0,"substitute","rustc::infer::canonical","This module contains code to substitute new values into a `Canonical<'tcx, T>`.",N,N],[3,"CanonicalVarValuesSubst","rustc::infer::canonical::substitute","",N,N],[12,"tcx","","",235,N],[12,"var_values","","",235,N],[5,"substitute_value","","Substitute the values from `var_values` into `value`. `var_values` must be values for the set of canonical variables that appear in `value`.",N,[[["tyctxt"],["canonicalvarvalues"],["t"]],["t"]]],[11,"substitute","rustc::infer::canonical","Instantiate the wrapped value, replacing each canonical value with the value given in `var_values`.",226,[[["self"],["tyctxt"],["canonicalvarvalues"]],["v"]]],[11,"substitute_projected","","Allows one to apply a substitute to some subset of `self.value`. Invoke `projection_fn` with `self.value` to get a value V that is expressed in terms of the same canonical variables bound in `self` (usually this extracts from subset of `self`). Apply the substitution `var_values` to this value V, replacing each of the canonical variables.",226,N],[11,"tcx","rustc::infer::canonical::substitute","",235,[[["self"]],["tyctxt"]]],[11,"fold_ty","","",235,[[["self"],["ty"]],["ty"]]],[11,"fold_region","","",235,[[["self"],["region"]],["region"]]],[6,"CanonicalVarInfos","rustc::infer::canonical","",N,N],[6,"SmallCanonicalVarValues","","Like CanonicalVarValues, but for use in places where a SmallVec is appropriate.",N,N],[6,"Canonicalized","","",N,N],[6,"CanonicalizedQueryResult","","",N,N],[6,"QueryRegionConstraint","","",N,N],[11,"clone","","",226,[[["self"]],["canonical"]]],[11,"fmt","","",226,[[["self"],["formatter"]],["result"]]],[11,"eq","","",226,[[["self"],["canonical"]],["bool"]]],[11,"ne","","",226,[[["self"],["canonical"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",226,N],[11,"hash","","",226,N],[11,"decode","","",226,[[["__dv"]],["result",["canonical"]]]],[11,"encode","","",226,[[["self"],["__sv"]],["result"]]],[11,"clone","","",227,[[["self"]],["canonicalvarvalues"]]],[11,"fmt","","",227,[[["self"],["formatter"]],["result"]]],[11,"eq","","",227,[[["self"],["canonicalvarvalues"]],["bool"]]],[11,"ne","","",227,[[["self"],["canonicalvarvalues"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",227,N],[11,"hash","","",227,N],[11,"decode","","",227,[[["__d"]],["result",["canonicalvarvalues"]]]],[11,"encode","","",227,[[["self"],["__s"]],["result"]]],[11,"clone","","",228,[[["self"]],["canonicalvarinfo"]]],[11,"fmt","","",228,[[["self"],["formatter"]],["result"]]],[11,"eq","","",228,[[["self"],["canonicalvarinfo"]],["bool"]]],[11,"ne","","",228,[[["self"],["canonicalvarinfo"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",228,N],[11,"hash","","",228,N],[11,"decode","","",228,[[["__d"]],["result",["canonicalvarinfo"]]]],[11,"encode","","",228,[[["self"],["__s"]],["result"]]],[11,"clone","","",230,[[["self"]],["canonicalvarkind"]]],[11,"fmt","","",230,[[["self"],["formatter"]],["result"]]],[11,"eq","","",230,[[["self"],["canonicalvarkind"]],["bool"]]],[11,"ne","","",230,[[["self"],["canonicalvarkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",230,N],[11,"hash","","",230,N],[11,"decode","","",230,[[["__d"]],["result",["canonicalvarkind"]]]],[11,"encode","","",230,[[["self"],["__s"]],["result"]]],[11,"clone","","",231,[[["self"]],["canonicaltyvarkind"]]],[11,"fmt","","",231,[[["self"],["formatter"]],["result"]]],[11,"eq","","",231,[[["self"],["canonicaltyvarkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",231,N],[11,"hash","","",231,N],[11,"decode","","",231,[[["__d"]],["result",["canonicaltyvarkind"]]]],[11,"encode","","",231,[[["self"],["__s"]],["result"]]],[11,"clone","","",229,[[["self"]],["queryresult"]]],[11,"fmt","","",229,[[["self"],["formatter"]],["result"]]],[11,"clone","","",232,[[["self"]],["certainty"]]],[11,"fmt","","",232,[[["self"],["formatter"]],["result"]]],[11,"is_proven","","",232,[[["self"]],["bool"]]],[11,"is_ambiguous","","",232,[[["self"]],["bool"]]],[11,"is_proven","","",229,[[["self"]],["bool"]]],[11,"is_ambiguous","","",229,[[["self"]],["bool"]]],[11,"is_proven","","",226,[[["self"]],["bool"]]],[11,"is_ambiguous","","",226,[[["self"]],["bool"]]],[11,"instantiate_canonical_with_fresh_inference_vars","rustc::infer","Creates a substitution S for the canonical value with fresh inference variables and applies it to the canonical value. Returns both the instantiated result and the substitution S.",208,N],[11,"fresh_inference_vars_for_canonical_vars","","Given the \"infos\" about the canonical variables from some canonical, creates fresh inference variables with the same characteristics. You can then use `substitute` to instantiate the canonical variable with these inference variables.",208,[[["self"],["span"],["slice"]],["canonicalvarvalues"]]],[11,"fresh_inference_var_for_canonical_var","","Given the \"info\" about a canonical variable, creates a fresh inference variable with the same characteristics.",208,[[["self"],["span"],["canonicalvarinfo"]],["kind"]]],[11,"super_fold_with","rustc::infer::canonical","",232,[[["self"],["f"]],["certainty"]]],[11,"super_visit_with","","",232,[[["self"],["f"]],["bool"]]],[11,"super_fold_with","","",228,[[["self"],["f"]],["canonicalvarinfo"]]],[11,"super_visit_with","","",228,[[["self"],["f"]],["bool"]]],[11,"super_fold_with","","",230,[[["self"],["f"]],["canonicalvarkind"]]],[11,"super_visit_with","","",230,[[["self"],["f"]],["bool"]]],[11,"lift_to_tcx","","",232,[[["self"],["tyctxt"]],["option"]]],[11,"lift_to_tcx","","",228,[[["self"],["tyctxt"]],["option"]]],[11,"lift_to_tcx","","",230,[[["self"],["tyctxt"]],["option"]]],[11,"super_fold_with","","",236,[[["self"],["f"]],["canonicalvarinfos"]]],[11,"super_visit_with","","",236,[[["self"],["f"]],["bool"]]],[11,"super_fold_with","","",226,[[["self"],["v"]],["self"]]],[11,"super_visit_with","","",226,[[["self"],["v"]],["bool"]]],[11,"lift_to_tcx","","",226,[[["self"],["tyctxt"]],["option",["canonical"]]]],[11,"len","","",227,[[["self"]],["usize"]]],[11,"lift_to_tcx","","",227,[[["self"],["tyctxt"]],["option",["canonicalvarvalues"]]]],[11,"super_fold_with","","",227,[[["self"],["v"]],["self"]]],[11,"super_visit_with","","",227,[[["self"],["v"]],["bool"]]],[11,"super_fold_with","","",229,[[["self"],["v"]],["self"]]],[11,"super_visit_with","","",229,[[["self"],["v"]],["bool"]]],[11,"lift_to_tcx","","",229,[[["self"],["tyctxt"]],["option",["queryresult"]]]],[11,"index","","",227,[[["self"],["canonicalvar"]],["kind"]]],[0,"combine","rustc::infer","",N,N],[3,"CombineFields","rustc::infer::combine","",N,N],[12,"infcx","","",237,N],[12,"trace","","",237,N],[12,"cause","","",237,N],[12,"param_env","","",237,N],[12,"obligations","","",237,N],[3,"Generalizer","","",N,N],[12,"infcx","","",238,N],[12,"span","","Span, used when creating new type variables and things.",238,N],[12,"for_vid_sub_root","","The vid of the type variable that is in the process of being instantiated; if we find this within the type we are folding, that means we would have created a cyclic type.",238,N],[12,"ambient_variance","","Track the variance as we descend into the type.",238,N],[12,"needs_wf","","See the field `needs_wf` in `Generalization`.",238,N],[12,"root_ty","","The root type that we are generalizing. Used when reporting cycles.",238,N],[3,"Generalization","","Result from a generalization operation. This includes not only the generalized type, but also a bool flag indicating whether further WF checks are needed.",N,N],[12,"ty","","",239,N],[12,"needs_wf","","If true, then the generalized type may not be well-formed, even if the source type is well-formed, so we should add an additional check to enforce that it is. This arises in particular around 'bivariant' type parameters that are only constrained by a where-clause. As an example, imagine a type:",239,N],[4,"RelationDir","","",N,N],[13,"SubtypeOf","","",240,N],[13,"SupertypeOf","","",240,N],[13,"EqTo","","",240,N],[5,"int_unification_error","","",N,N],[5,"float_unification_error","","",N,N],[8,"RelateResultCompare","","",N,N],[10,"compare","","",241,[[["self"],["t"],["f"]],["relateresult"]]],[11,"clone","","",237,[[["self"]],["combinefields"]]],[11,"clone","","",240,[[["self"]],["relationdir"]]],[11,"assert_receiver_is_total_eq","","",240,N],[11,"eq","","",240,[[["self"],["relationdir"]],["bool"]]],[11,"hash","","",240,N],[11,"fmt","","",240,[[["self"],["formatter"]],["result"]]],[11,"super_combine_tys","rustc::infer","",208,[[["self"],["r"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"unify_integral_variable","","",208,[[["self"],["bool"],["intvid"],["intvarvalue"]],["relateresult",["ty"]]]],[11,"unify_float_variable","","",208,[[["self"],["bool"],["floatvid"],["floatty"]],["relateresult",["ty"]]]],[11,"tcx","rustc::infer::combine","",237,[[["self"]],["tyctxt"]]],[11,"equate","","",237,[[["self"],["bool"]],["equate"]]],[11,"sub","","",237,[[["self"],["bool"]],["sub"]]],[11,"lub","","",237,[[["self"],["bool"]],["lub"]]],[11,"glb","","",237,[[["self"],["bool"]],["glb"]]],[11,"instantiate","","Here dir is either EqTo, SubtypeOf, or SupertypeOf. The idea is that we should ensure that the type `a_ty` is equal to, a subtype of, or a supertype of (respectively) the type to which `b_vid` is bound.",237,[[["self"],["ty"],["relationdir"],["tyvid"],["bool"]],["relateresult"]]],[11,"generalize","","Attempts to generalize `ty` for the type variable `for_vid`. This checks for cycle -- that is, whether the type `ty` references `for_vid`. The `dir` is the \"direction\" for which we a performing the generalization (i.e., are we producing a type that can be used as a supertype etc).",237,[[["self"],["ty"],["tyvid"],["relationdir"]],["relateresult",["generalization"]]]],[11,"tcx","","",238,[[["self"]],["tyctxt"]]],[11,"tag","","",238,[[["self"]],["str"]]],[11,"a_is_expected","","",238,[[["self"]],["bool"]]],[11,"binders","","",238,[[["self"],["binder"],["binder"]],["relateresult",["binder"]]]],[11,"relate_item_substs","","",238,[[["self"],["defid"],["substs"],["substs"]],["relateresult",["substs"]]]],[11,"relate_with_variance","","",238,[[["self"],["variance"],["t"],["t"]],["relateresult"]]],[11,"tys","","",238,[[["self"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"regions","","",238,[[["self"],["region"],["region"]],["relateresult",["region"]]]],[0,"equate","rustc::infer","",N,N],[3,"Equate","rustc::infer::equate","Ensures `a` is made equal to `b`. Returns `a` on success.",N,N],[12,"fields","","",242,N],[12,"a_is_expected","","",242,N],[11,"new","","",242,[[["combinefields"],["bool"]],["equate"]]],[11,"tag","","",242,[[["self"]],["str"]]],[11,"tcx","","",242,[[["self"]],["tyctxt"]]],[11,"a_is_expected","","",242,[[["self"]],["bool"]]],[11,"relate_item_substs","","",242,[[["self"],["defid"],["substs"],["substs"]],["relateresult",["substs"]]]],[11,"relate_with_variance","","",242,[[["self"],["variance"],["t"],["t"]],["relateresult"]]],[11,"tys","","",242,[[["self"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"regions","","",242,[[["self"],["region"],["region"]],["relateresult",["region"]]]],[11,"binders","","",242,[[["self"],["binder"],["binder"]],["relateresult",["binder"]]]],[0,"error_reporting","rustc::infer","Error Reporting Code for the inference engine",N,N],[4,"FailureCode","rustc::infer::error_reporting","",N,N],[13,"Error0317","","",243,N],[13,"Error0580","","",243,N],[13,"Error0308","","",243,N],[13,"Error0644","","",243,N],[0,"note","","",N,N],[11,"note_region_origin","rustc::infer","",208,[[["self"],["diagnosticbuilder"],["subregionorigin"]]]],[11,"report_concrete_failure","","",208,[[["self"],["scopetree"],["subregionorigin"],["region"],["region"]],["diagnosticbuilder"]]],[0,"need_type_info","rustc::infer::error_reporting","",N,N],[3,"FindLocalByTypeVisitor","rustc::infer::error_reporting::need_type_info","",N,N],[12,"infcx","","",244,N],[12,"target_ty","","",244,N],[12,"hir_map","","",244,N],[12,"found_local_pattern","","",244,N],[12,"found_arg_pattern","","",244,N],[11,"node_matches_type","","",244,[[["self"],["hirid"]],["bool"]]],[11,"nested_visit_map","","",244,[[["self"]],["nestedvisitormap"]]],[11,"visit_local","","",244,[[["self"],["local"]]]],[11,"visit_body","","",244,[[["self"],["body"]]]],[11,"extract_type_name","rustc::infer","",208,[[["self"],["ty"]],["string"]]],[11,"need_type_info_err","","",208,[[["self"],["option",["bodyid"]],["span"],["ty"]],["diagnosticbuilder"]]],[0,"nice_region_error","rustc::infer::error_reporting","",N,N],[3,"NiceRegionError","rustc::infer::error_reporting::nice_region_error","",N,N],[12,"tcx","","",245,N],[12,"error","","",245,N],[12,"regions","","",245,N],[12,"tables","","",245,N],[0,"different_lifetimes","","Error Reporting for Anonymous Region Lifetime Errors where both the regions are anonymous.",N,N],[11,"try_report_anon_anon_conflict","","Print the error message for lifetime errors when both the concerned regions are anonymous.",245,[[["self"]],["option",["errorreported"]]]],[0,"find_anon_type","","",N,N],[3,"FindNestedTypeVisitor","rustc::infer::error_reporting::nice_region_error::find_anon_type","",N,N],[12,"tcx","","",246,N],[12,"bound_region","","",246,N],[12,"found_type","","",246,N],[12,"current_index","","",246,N],[3,"TyPathVisitor","","",N,N],[12,"tcx","","",247,N],[12,"found_it","","",247,N],[12,"bound_region","","",247,N],[12,"current_index","","",247,N],[11,"find_anon_type","rustc::infer::error_reporting::nice_region_error","This function calls the `visit_ty` method for the parameters corresponding to the anonymous regions. The `nested_visitor.found_type` contains the anonymous type.",245,[[["self"],["region"],["boundregion"]],["option"]]],[11,"find_component_for_bound_region","","",245,[[["self"],["ty"],["boundregion"]],["option",["ty"]]]],[11,"nested_visit_map","rustc::infer::error_reporting::nice_region_error::find_anon_type","",246,[[["self"]],["nestedvisitormap"]]],[11,"visit_ty","","",246,[[["self"],["ty"]]]],[11,"nested_visit_map","","",247,[[["self"]],["nestedvisitormap"]]],[11,"visit_lifetime","","",247,[[["self"],["lifetime"]]]],[11,"visit_ty","","",247,[[["self"],["ty"]]]],[0,"named_anon_conflict","rustc::infer::error_reporting::nice_region_error","Error Reporting for Anonymous Region Lifetime Errors where one region is named and the other is anonymous.",N,N],[11,"try_report_named_anon_conflict","","When given a `ConcreteFailure` for a function with arguments containing a named region and an anonymous region, emit an descriptive diagnostic error.",245,[[["self"]],["option",["errorreported"]]]],[11,"is_named_region","","",245,[[["self"],["region"]],["bool"]]],[0,"outlives_closure","","Error Reporting for Anonymous Region Lifetime Errors where both the regions are anonymous.",N,N],[11,"try_report_outlives_closure","","Print the error message for lifetime errors when binding excapes a closure.",245,[[["self"]],["option",["errorreported"]]]],[0,"static_impl_trait","","Error Reporting for static impl Traits.",N,N],[11,"try_report_static_impl_trait","","Print the error message for lifetime errors when the return type is a static impl Trait.",245,[[["self"]],["option",["errorreported"]]]],[0,"util","","Helper functions corresponding to lifetime errors due to anonymous regions.",N,N],[3,"AnonymousArgInfo","rustc::infer::error_reporting::nice_region_error::util","",N,N],[12,"arg","","",248,N],[12,"arg_ty","","",248,N],[12,"bound_region","","",248,N],[12,"is_first","","",248,N],[3,"FreeRegionInfo","","",N,N],[12,"def_id","","",249,N],[12,"boundregion","","",249,N],[12,"is_impl_item","","",249,N],[11,"fmt","","",248,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",249,[[["self"],["formatter"]],["result"]]],[11,"find_arg_with_region","rustc::infer::error_reporting::nice_region_error","",245,[[["self"],["region"],["region"]],["option",["anonymousarginfo"]]]],[11,"is_suitable_region","","",245,[[["self"],["region"]],["option",["freeregioninfo"]]]],[11,"is_return_type_anon","","",245,[[["self"],["defid"],["boundregion"],["fndecl"]],["option",["span"]]]],[11,"is_return_type_impl_trait","","",245,[[["self"],["defid"]],["bool"]]],[11,"is_self_anon","","",245,[[["self"],["bool"],["defid"]],["bool"]]],[11,"is_bound_region_in_impl_item","","",245,[[["self"],["defid"]],["bool"]]],[11,"try_report_nice_region_error","rustc::infer","",208,[[["self"],["regionresolutionerror"]],["bool"]]],[11,"new","rustc::infer::error_reporting::nice_region_error","",245,[[["tyctxt"],["regionresolutionerror"],["option",["typecktables"]]],["self"]]],[11,"new_from_span","","",245,[[["tyctxt"],["span"],["region"],["region"],["option",["typecktables"]]],["self"]]],[11,"try_report","","",245,[[["self"]],["option",["errorreported"]]]],[11,"get_regions","","",245,N],[11,"report_region_errors","rustc::infer","",208,[[["self"],["scopetree"],["vec"],["bool"]]]],[11,"process_errors","","",208,[[["self"],["vec"]],["vec",["regionresolutionerror"]]]],[11,"check_and_note_conflicting_crates","","Adds a note if the types come from similarly named crates",208,[[["self"],["diagnosticbuilder"],["typeerror"],["span"]]]],[11,"note_error_origin","","",208,[[["self"],["diagnosticbuilder"],["obligationcause"]]]],[11,"highlight_outer","","Given that `other_ty` is the same as a type argument for `name` in `sub`, populate `value` highlighting `name` and every type argument that isn't at `pos` (which is `other_ty`), and populate `other_value` with `other_ty`.",208,[[["self"],["diagnosticstyledstring"],["diagnosticstyledstring"],["string"],["substs"],["usize"],["ty"]]]],[11,"cmp_type_arg","","If `other_ty` is the same as a type argument present in `sub`, highlight `path` in `t1_out`, as that is the difference to the other type.",208,[[["self"],["diagnosticstyledstring"],["diagnosticstyledstring"],["string"],["substs"],["string"],["ty"]],["option"]]],[11,"push_comma","","Add a `,` to the type representation only if it is appropriate.",208,[[["self"],["diagnosticstyledstring"],["diagnosticstyledstring"],["usize"],["usize"]]]],[11,"strip_generic_default_params","","For generic types with parameters with defaults, remove the parameters corresponding to the defaults. This repeats a lot of the logic found in `PrintContext::parameterized`.",208,[[["self"],["defid"],["substs"]],["substs"]]],[11,"cmp","","Compare two given types, eliding parts that are the same between them and highlighting relevant differences, and return two representation of those types for highlighted printing.",208,N],[11,"note_type_err","","",208,[[["self"],["diagnosticbuilder"],["obligationcause"],["option"],["option",["valuepairs"]],["typeerror"]]]],[11,"report_and_explain_type_error","","",208,[[["self"],["typetrace"],["typeerror"]],["diagnosticbuilder"]]],[11,"values_str","","",208,[[["self"],["valuepairs"]],["option"]]],[11,"expected_found_str_ty","","",208,[[["self"],["expectedfound"]],["option"]]],[11,"expected_found_str","","Returns a string of the form \"expected `{}`, found `{}`\".",208,[[["self"],["expectedfound"]],["option"]]],[11,"report_generic_bound_failure","","",208,[[["self"],["scopetree"],["span"],["option",["subregionorigin"]],["generickind"],["region"]]]],[11,"construct_generic_bound_failure","","",208,[[["self"],["scopetree"],["span"],["option",["subregionorigin"]],["generickind"],["region"]],["diagnosticbuilder"]]],[11,"report_sub_sup_conflict","","",208,[[["self"],["scopetree"],["regionvariableorigin"],["subregionorigin"],["region"],["subregionorigin"],["region"]]]],[11,"report_inference_failure","","",208,[[["self"],["regionvariableorigin"]],["diagnosticbuilder"]]],[0,"fudge","","",N,N],[3,"RegionFudger","rustc::infer::fudge","",N,N],[12,"infcx","","",250,N],[12,"type_variables","","",250,N],[12,"region_vars","","",250,N],[12,"origin","","",250,N],[11,"fudge_regions_if_ok","rustc::infer","This rather funky routine is used while processing expected types. What happens here is that we want to propagate a coercion through the return type of a fn to its argument. Consider the type of `Option::Some`, which is basically `for<T> fn(T) -> Option<T>`. So if we have an expression `Some(&[1, 2, 3])`, and that has the expected type `Option<&[u32]>`, we would like to type check `&[1, 2, 3]` with the expectation of `&[u32]`. This will cause us to coerce from `&[u32; 3]` to `&[u32]` and make the users life more pleasant.",208,[[["self"],["regionvariableorigin"],["f"]],["result"]]],[11,"tcx","rustc::infer::fudge","",250,[[["self"]],["tyctxt"]]],[11,"fold_ty","","",250,[[["self"],["ty"]],["ty"]]],[11,"fold_region","","",250,[[["self"],["region"]],["region"]]],[0,"glb","rustc::infer","",N,N],[3,"Glb","rustc::infer::glb","\"Greatest lower bound\" (common subtype)",N,N],[12,"fields","","",251,N],[12,"a_is_expected","","",251,N],[11,"new","","",251,[[["combinefields"],["bool"]],["glb"]]],[11,"tag","","",251,[[["self"]],["str"]]],[11,"tcx","","",251,[[["self"]],["tyctxt"]]],[11,"a_is_expected","","",251,[[["self"]],["bool"]]],[11,"relate_with_variance","","",251,[[["self"],["variance"],["t"],["t"]],["relateresult"]]],[11,"tys","","",251,[[["self"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"regions","","",251,[[["self"],["region"],["region"]],["relateresult",["region"]]]],[11,"binders","","",251,[[["self"],["binder"],["binder"]],["relateresult",["binder"]]]],[11,"infcx","","",251,[[["self"]],["inferctxt"]]],[11,"cause","","",251,[[["self"]],["obligationcause"]]],[11,"relate_bound","","",251,[[["self"],["ty"],["ty"],["ty"]],["relateresult"]]],[0,"higher_ranked","rustc::infer","Helper routines for higher-ranked things. See the `doc` module at the end of the file for details.",N,N],[3,"HrMatchResult","rustc::infer::higher_ranked","",N,N],[12,"value","","",252,N],[5,"var_ids","","",N,[[["combinefields"],["btreemap"]],["vec",["regionvid"]]]],[5,"is_var_in_set","","",N,N],[5,"fold_regions_in","","",N,[[["tyctxt"],["t"],["f"]],["t"]]],[11,"higher_ranked_sub","rustc::infer::combine","",237,[[["self"],["binder"],["binder"],["bool"]],["relateresult",["binder"]]]],[11,"higher_ranked_match","","The value consists of a pair `(t, u)` where `t` is the matcher and `u` is a value. The idea is to find a substitution `S` such that `S(t) == b`, and then return `S(u)`. In other words, find values for the late-bound regions in `a` that can make `t == b` and then replace the LBR in `u` with those values.",237,[[["self"],["binder"],["t"],["bool"]],["relateresult",["hrmatchresult"]]]],[11,"higher_ranked_lub","","",237,[[["self"],["binder"],["binder"],["bool"]],["relateresult",["binder"]]]],[11,"higher_ranked_glb","","",237,[[["self"],["binder"],["binder"],["bool"]],["relateresult",["binder"]]]],[11,"tainted_regions","rustc::infer","",208,[[["self"],["combinedsnapshot"],["region"],["taintdirections"]],["fxhashset",["region"]]]],[11,"region_vars_confined_to_snapshot","","Returns the set of region variables that do not affect any types/regions which existed before `snapshot` was started. This is used in the sub/lub/glb computations. The idea here is that when we are computing lub/glb of two regions, we sometimes create intermediate region variables. Those region variables may touch some of the skolemized or other \"forbidden\" regions we created to replace bound regions, but they don't really represent an \"external\" constraint.",208,[[["self"],["combinedsnapshot"]],["vec",["regionvid"]]]],[11,"skolemize_late_bound_regions","","Replace all regions bound by `binder` with skolemized regions and return a map indicating which bound-region was replaced with what skolemized region. This is the first step of checking subtyping when higher-ranked things are involved.",208,N],[11,"leak_check","","Searches the region constraints created since `snapshot` was started and checks to determine whether any of the skolemized regions created in `skol_map` would \"escape\" -- meaning that they are related to other regions in some way. If so, the higher-ranked subtyping doesn't hold. See `README.md` for more details.",208,[[["self"],["bool"],["span"],["skolemizationmap"],["combinedsnapshot"]],["relateresult"]]],[11,"plug_leaks","","This code converts from skolemized regions back to late-bound regions. It works by replacing each region in the taint set of a skolemized region with a bound-region. The bound region will be bound by the outer-most binder in `value`; the caller must ensure that there is such a binder and it is the right place.",208,[[["self"],["skolemizationmap"],["combinedsnapshot"],["t"]],["t"]]],[11,"pop_skolemized","","Pops the skolemized regions found in `skol_map` from the region inference context. Whenever you create skolemized regions via `skolemize_late_bound_regions`, they must be popped before you commit the enclosing snapshot (if you do not commit, e.g. within a probe or as a result of an error, then this is not necessary, as popping happens as part of the rollback).",208,[[["self"],["skolemizationmap"],["combinedsnapshot"]]]],[0,"lattice","","Lattice Variables",N,N],[5,"super_lattice_tys","rustc::infer::lattice","",N,[[["l"],["ty"],["ty"]],["relateresult",["ty"]]]],[8,"LatticeDir","","",N,N],[10,"infcx","","",253,[[["self"]],["inferctxt"]]],[10,"cause","","",253,[[["self"]],["obligationcause"]]],[10,"relate_bound","","",253,[[["self"],["ty"],["ty"],["ty"]],["relateresult"]]],[0,"lub","rustc::infer","",N,N],[3,"Lub","rustc::infer::lub","\"Least upper bound\" (common supertype)",N,N],[12,"fields","","",254,N],[12,"a_is_expected","","",254,N],[11,"new","","",254,[[["combinefields"],["bool"]],["lub"]]],[11,"tag","","",254,[[["self"]],["str"]]],[11,"tcx","","",254,[[["self"]],["tyctxt"]]],[11,"a_is_expected","","",254,[[["self"]],["bool"]]],[11,"relate_with_variance","","",254,[[["self"],["variance"],["t"],["t"]],["relateresult"]]],[11,"tys","","",254,[[["self"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"regions","","",254,[[["self"],["region"],["region"]],["relateresult",["region"]]]],[11,"binders","","",254,[[["self"],["binder"],["binder"]],["relateresult",["binder"]]]],[11,"infcx","","",254,[[["self"]],["inferctxt"]]],[11,"cause","","",254,[[["self"]],["obligationcause"]]],[11,"relate_bound","","",254,[[["self"],["ty"],["ty"],["ty"]],["relateresult"]]],[0,"region_constraints","rustc::infer","See README.md",N,N],[3,"RegionConstraintCollector","rustc::infer::region_constraints","",N,N],[12,"var_infos","","For each `RegionVid`, the corresponding `RegionVariableOrigin`.",255,N],[12,"data","","",255,N],[12,"lubs","","For a given pair of regions (R1, R2), maps to a region R3 that is designated as their LUB (edges R1 <= R3 and R2 <= R3 exist). This prevents us from making many such regions.",255,N],[12,"glbs","","For a given pair of regions (R1, R2), maps to a region R3 that is designated as their GLB (edges R3 <= R1 and R3 <= R2 exist). This prevents us from making many such regions.",255,N],[12,"bound_count","","Global counter used during the GLB algorithm to create unique names for fresh bound regions",255,N],[12,"undo_log","","The undo log records actions that might later be undone.",255,N],[12,"unification_table","","When we add a R1 == R2 constriant, we currently add (a) edges R1 <= R2 and R2 <= R1 and (b) we unify the two regions in this table. You can then call `opportunistic_resolve_var` early which will map R1 and R2 to some common region (i.e., either R1 or R2). This is important when dropck and other such code is iterating to a fixed point, because otherwise we sometimes would wind up with a fresh stream of region variables that have been equated but appear distinct.",255,N],[12,"any_unifications","","a flag set to true when we perform any unifications; this is used to micro-optimize `take_and_reset_data`",255,N],[3,"RegionConstraintData","","The full set of region constraints gathered up by the collector. Describes constraints between the region variables and other regions, as well as other conditions that must be verified, or assumptions that can be made.",N,N],[12,"constraints","","Constraints of the form `A <= B`, where either `A` or `B` can be a region variable (or neither, as it happens).",256,N],[12,"verifys","","A \"verify\" is something that we need to verify after inference is done, but which does not directly affect inference in any way.",256,N],[12,"givens","","A \"given\" is a relationship that is known to hold. In particular, we often know from closure fn signatures that a particular free region must be a subregion of a region variable:",256,N],[3,"Verify","","VerifyGenericBound(T, _, R, RS): The parameter type `T` (or associated type) must outlive the region `R`. `T` is known to outlive `RS`. Therefore verify that `R <= RS[i]` for some `i`. Inference variables may be involved (but this verification step doesn't influence inference).",N,N],[12,"kind","","",257,N],[12,"origin","","",257,N],[12,"region","","",257,N],[12,"bound","","",257,N],[3,"TwoRegions","","",N,N],[12,"a","","",258,N],[12,"b","","",258,N],[3,"RegionVariableInfo","","",N,N],[12,"origin","","",259,N],[12,"universe","","",259,N],[3,"RegionSnapshot","","",N,N],[12,"length","","",260,N],[12,"region_snapshot","","",260,N],[12,"any_unifications","","",260,N],[3,"TaintDirections","","When working with skolemized regions, we often wish to find all of the regions that are either reachable from a skolemized region, or which can reach a skolemized region, or both. We call such regions tained regions.  This struct allows you to decide what set of tainted regions you want.",N,N],[12,"incoming","","",261,N],[12,"outgoing","","",261,N],[4,"Constraint","","A constraint that influences the inference process.",N,N],[13,"VarSubVar","","One region variable is subregion of another",262,N],[13,"RegSubVar","","Concrete region is subregion of region variable",262,N],[13,"VarSubReg","","Region variable is subregion of concrete region. This does not directly affect inference, but instead is checked after inference is complete.",262,N],[13,"RegSubReg","","A constraint where neither side is a variable. This does not directly affect inference, but instead is checked after inference is complete.",262,N],[4,"GenericKind","","",N,N],[13,"Param","","",263,N],[13,"Projection","","",263,N],[4,"VerifyBound","","When we introduce a verification step, we wish to test that a particular region (let's call it `'min`) meets some bound. The bound is described the by the following grammar:",N,N],[13,"AnyRegion","","B = exists {R} --> some 'r in {R} must outlive 'min",264,N],[13,"AllRegions","","B = forall {R} --> all 'r in {R} must outlive 'min",264,N],[13,"AnyBound","","B = exists {B} --> 'min must meet some bound b in {B}",264,N],[13,"AllBounds","","B = forall {B} --> 'min must meet all bounds b in {B}",264,N],[4,"UndoLogEntry","","",N,N],[13,"OpenSnapshot","","Pushed when we start a snapshot.",265,N],[13,"CommitedSnapshot","","Replaces an `OpenSnapshot` when a snapshot is committed, but that snapshot is not the root. If the root snapshot is unrolled, all nested snapshots must be committed.",265,N],[13,"AddVar","","We added `RegionVid`",265,N],[13,"AddConstraint","","We added the given `constraint`",265,N],[13,"AddVerify","","We added the given `verify`",265,N],[13,"AddGiven","","We added the given `given`",265,N],[13,"AddCombination","","We added a GLB/LUB \"combination variable\"",265,N],[13,"Purged","","During skolemization, we sometimes purge entries from the undo log in a kind of minisnapshot (unlike other snapshots, this purging actually takes place on success). In that case, we replace the corresponding entry with `Noop` so as to avoid the need to do a bunch of swapping. (We can't use `swap_remove` as the order of the vector is important.)",265,N],[4,"CombineMapType","","",N,N],[13,"Lub","","",266,N],[13,"Glb","","",266,N],[0,"taint","","",N,N],[3,"TaintSet","rustc::infer::region_constraints::taint","",N,N],[12,"directions","","",267,N],[12,"regions","","",267,N],[11,"fmt","","",267,[[["self"],["formatter"]],["result"]]],[11,"new","","",267,[[["taintdirections"],["region"]],["self"]]],[11,"fixed_point","","",267,N],[11,"into_set","","",267,[[["self"]],["fxhashset",["region"]]]],[11,"len","","",267,[[["self"]],["usize"]]],[11,"add_edge","","",267,[[["self"],["region"],["region"]]]],[6,"VarInfos","rustc::infer::region_constraints","",N,N],[6,"CombineMap","","",N,N],[11,"fmt","","",256,[[["self"],["formatter"]],["result"]]],[11,"default","","",256,[[],["regionconstraintdata"]]],[11,"clone","","",256,[[["self"]],["regionconstraintdata"]]],[11,"clone","","",262,[[["self"]],["constraint"]]],[11,"eq","","",262,[[["self"],["constraint"]],["bool"]]],[11,"ne","","",262,[[["self"],["constraint"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",262,N],[11,"hash","","",262,N],[11,"fmt","","",262,[[["self"],["formatter"]],["result"]]],[11,"partial_cmp","","",262,[[["self"],["constraint"]],["option",["ordering"]]]],[11,"lt","","",262,[[["self"],["constraint"]],["bool"]]],[11,"le","","",262,[[["self"],["constraint"]],["bool"]]],[11,"gt","","",262,[[["self"],["constraint"]],["bool"]]],[11,"ge","","",262,[[["self"],["constraint"]],["bool"]]],[11,"cmp","","",262,[[["self"],["constraint"]],["ordering"]]],[11,"fmt","","",257,[[["self"],["formatter"]],["result"]]],[11,"clone","","",257,[[["self"]],["verify"]]],[11,"clone","","",263,[[["self"]],["generickind"]]],[11,"eq","","",263,[[["self"],["generickind"]],["bool"]]],[11,"ne","","",263,[[["self"],["generickind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",263,N],[11,"fmt","","",264,[[["self"],["formatter"]],["result"]]],[11,"clone","","",264,[[["self"]],["verifybound"]]],[11,"clone","","",258,[[["self"]],["tworegions"]]],[11,"eq","","",258,[[["self"],["tworegions"]],["bool"]]],[11,"ne","","",258,[[["self"],["tworegions"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",258,N],[11,"hash","","",258,N],[11,"clone","","",265,[[["self"]],["undologentry"]]],[11,"eq","","",265,[[["self"],["undologentry"]],["bool"]]],[11,"ne","","",265,[[["self"],["undologentry"]],["bool"]]],[11,"clone","","",266,[[["self"]],["combinemaptype"]]],[11,"eq","","",266,[[["self"],["combinemaptype"]],["bool"]]],[11,"fmt","","",259,[[["self"],["formatter"]],["result"]]],[11,"clone","","",259,[[["self"]],["regionvariableinfo"]]],[11,"fmt","","",261,[[["self"],["formatter"]],["result"]]],[11,"incoming","","",261,[[],["self"]]],[11,"outgoing","","",261,[[],["self"]]],[11,"both","","",261,[[],["self"]]],[11,"new","","",255,[[],["regionconstraintcollector"]]],[11,"num_region_vars","","",255,[[["self"]],["usize"]]],[11,"region_constraint_data","","",255,[[["self"]],["regionconstraintdata"]]],[11,"into_infos_and_data","","Once all the constraints have been gathered, extract out the final data.",255,N],[11,"take_and_reset_data","","Takes (and clears) the current set of constraints. Note that the set of variables remains intact, but all relationships between them are reset.  This is used during NLL checking to grab the set of constraints that arose from a particular operation.",255,[[["self"]],["regionconstraintdata"]]],[11,"data","","",255,[[["self"]],["regionconstraintdata"]]],[11,"in_snapshot","","",255,[[["self"]],["bool"]]],[11,"start_snapshot","","",255,[[["self"]],["regionsnapshot"]]],[11,"commit","","",255,[[["self"],["regionsnapshot"]]]],[11,"rollback_to","","",255,[[["self"],["regionsnapshot"]]]],[11,"rollback_undo_entry","","",255,[[["self"],["undologentry"]]]],[11,"new_region_var","","",255,[[["self"],["universeindex"],["regionvariableorigin"]],["regionvid"]]],[11,"var_universe","","Returns the universe for the given variable.",255,[[["self"],["regionvid"]],["universeindex"]]],[11,"var_origin","","Returns the origin for the given variable.",255,[[["self"],["regionvid"]],["regionvariableorigin"]]],[11,"pop_skolemized","","Removes all the edges to/from the skolemized regions that are in `skols`. This is used after a higher-ranked operation completes to remove all trace of the skolemized regions created in that time.",255,[[["self"],["universeindex"],["fxhashset"],["regionsnapshot"]]]],[11,"new_bound","","",255,[[["self"],["tyctxt"],["debruijnindex"]],["region"]]],[11,"add_constraint","","",255,[[["self"],["constraint"],["subregionorigin"]]]],[11,"add_verify","","",255,[[["self"],["verify"]]]],[11,"add_given","","",255,[[["self"],["region"],["regionvid"]]]],[11,"make_eqregion","","",255,[[["self"],["subregionorigin"],["region"],["region"]]]],[11,"make_subregion","","",255,[[["self"],["subregionorigin"],["region"],["region"]]]],[11,"verify_generic_bound","","See `Verify::VerifyGenericBound`",255,[[["self"],["subregionorigin"],["generickind"],["region"],["verifybound"]]]],[11,"lub_regions","","",255,[[["self"],["tyctxt"],["subregionorigin"],["region"],["region"]],["region"]]],[11,"glb_regions","","",255,[[["self"],["tyctxt"],["subregionorigin"],["region"],["region"]],["region"]]],[11,"opportunistic_resolve_var","","",255,[[["self"],["tyctxt"],["regionvid"]],["region"]]],[11,"combine_map","","",255,[[["self"],["combinemaptype"]],["fxhashmap"]]],[11,"combine_vars","","",255,[[["self"],["tyctxt"],["combinemaptype"],["region"],["region"],["subregionorigin"]],["region"]]],[11,"universe","","",255,[[["self"],["region"]],["universeindex"]]],[11,"vars_created_since_snapshot","","",255,[[["self"],["regionsnapshot"]],["vec",["regionvid"]]]],[11,"tainted","","Computes all regions that have been related to `r0` since the mark `mark` was made---`r0` itself will be the first entry. The `directions` parameter controls what kind of relations are considered. For example, one can say that only \"incoming\" edges to `r0` are desired, in which case one will get the set of regions `{r|r <= r0}`. This is used when checking whether skolemized regions are being improperly related to other regions.",255,[[["self"],["tyctxt"],["regionsnapshot"],["region"],["taintdirections"]],["fxhashset",["region"]]]],[11,"fmt","","",260,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",263,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",263,[[["self"],["formatter"]],["result"]]],[11,"to_ty","","",263,[[["self"],["tyctxt"]],["ty"]]],[11,"for_each_region","","",264,[[["self"],["fnmut"]]]],[11,"must_hold","","",264,[[["self"]],["bool"]]],[11,"cannot_hold","","",264,[[["self"]],["bool"]]],[11,"or","","",264,[[["self"],["verifybound"]],["verifybound"]]],[11,"and","","",264,[[["self"],["verifybound"]],["verifybound"]]],[11,"is_empty","","True if this region constraint data contains no constraints.",256,[[["self"]],["bool"]]],[0,"lexical_region_resolve","rustc::infer","The code to do lexical region resolution.",N,N],[3,"LexicalRegionResolutions","rustc::infer::lexical_region_resolve","Contains the result of lexical region resolution. Offers methods to lookup up the final value of a region variable.",N,N],[12,"values","","",268,N],[12,"error_region","","",268,N],[3,"RegionAndOrigin","","",N,N],[12,"region","","",269,N],[12,"origin","","",269,N],[3,"LexicalResolver","","",N,N],[12,"region_rels","","",270,N],[12,"var_infos","","",270,N],[12,"data","","",270,N],[4,"VarValue","","",N,N],[13,"Value","","",271,N],[13,"ErrorValue","","",271,N],[4,"RegionResolutionError","","",N,N],[13,"ConcreteFailure","","`ConcreteFailure(o, a, b)`:",272,N],[13,"GenericBoundFailure","","`GenericBoundFailure(p, s, a)",272,N],[13,"SubSupConflict","","`SubSupConflict(v, sub_origin, sub_r, sup_origin, sup_r)`:",272,N],[5,"resolve","","This function performs lexical region resolution given a complete set of constraints and variable origins. It performs a fixed-point iteration to find region values which satisfy all constraints, assuming such values can be found. It returns the final values of all the variables as well as a set of errors that must be reported.",N,N],[0,"graphviz","","This module provides linkage between libgraphviz traits and `rustc::middle::typeck::infer::region_constraints`, generating a rendering of the graph represented by the list of `Constraint` instances (which make up the edges of the graph), as well as the origin for each constraint (which are attached to the labels on each edge).",N,N],[3,"ConstraintGraph","rustc::infer::lexical_region_resolve::graphviz","",N,N],[12,"graph_name","","",273,N],[12,"region_rels","","",273,N],[12,"map","","",273,N],[12,"node_ids","","",273,N],[4,"Node","","",N,N],[13,"RegionVid","","",274,N],[13,"Region","","",274,N],[4,"Edge","","",N,N],[13,"Constraint","","",275,N],[13,"EnclScope","","",275,N],[5,"print_help_message","","",N,[[]]],[5,"maybe_print_constraints_for","","",N,[[["regionconstraintdata"],["regionrelations"]]]],[5,"constraint_to_nodes","","",N,N],[5,"edge_to_nodes","","",N,N],[5,"dump_region_data_to","","",N,[[["regionrelations"],["btreemap"],["str"]],["result"]]],[6,"ConstraintMap","","",N,N],[11,"clone","","",274,[[["self"]],["node"]]],[11,"hash","","",274,N],[11,"eq","","",274,[[["self"],["node"]],["bool"]]],[11,"ne","","",274,[[["self"],["node"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",274,N],[11,"fmt","","",274,[[["self"],["formatter"]],["result"]]],[11,"clone","","",275,[[["self"]],["edge"]]],[11,"eq","","",275,[[["self"],["edge"]],["bool"]]],[11,"ne","","",275,[[["self"],["edge"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",275,N],[11,"fmt","","",275,[[["self"],["formatter"]],["result"]]],[11,"new","","",273,[[["string"],["regionrelations"],["btreemap"]],["constraintgraph"]]],[11,"graph_id","","",273,[[["self"]],["id"]]],[11,"node_id","","",273,[[["self"],["node"]],["id"]]],[11,"node_label","","",273,[[["self"],["node"]],["labeltext"]]],[11,"edge_label","","",273,[[["self"],["edge"]],["labeltext"]]],[11,"nodes","","",273,[[["self"]],["nodes",["node"]]]],[11,"edges","","",273,[[["self"]],["edges",["edge"]]]],[11,"source","","",273,[[["self"],["edge"]],["node"]]],[11,"target","","",273,[[["self"],["edge"]],["node"]]],[6,"RegionGraph","rustc::infer::lexical_region_resolve","",N,N],[11,"clone","","",271,[[["self"]],["varvalue"]]],[11,"fmt","","",271,[[["self"],["formatter"]],["result"]]],[11,"clone","","",272,[[["self"]],["regionresolutionerror"]]],[11,"fmt","","",272,[[["self"],["formatter"]],["result"]]],[11,"infer_variable_values","","",270,[[["self"],["vec"]],["lexicalregionresolutions"]]],[11,"num_vars","","",270,[[["self"]],["usize"]]],[11,"construct_var_data","","Initially, the value for all variables is set to `'empty`, the empty region. The `expansion` phase will grow this larger.",270,[[["self"],["tyctxt"]],["lexicalregionresolutions"]]],[11,"dump_constraints","","",270,[[["self"],["regionrelations"]]]],[11,"expand_givens","","",270,[[["self"],["graph"]]]],[11,"expansion","","",270,[[["self"],["lexicalregionresolutions"]]]],[11,"expand_node","","",270,[[["self"],["region"],["regionvid"],["varvalue"]],["bool"]]],[11,"lub_concrete_regions","","",270,[[["self"],["region"],["region"]],["region"]]],[11,"collect_errors","","After expansion is complete, go and check upper bounds (i.e., cases where the region cannot grow larger than a fixed point) and check that they are satisfied.",270,[[["self"],["lexicalregionresolutions"],["vec"]]]],[11,"collect_var_errors","","Go over the variables that were declared to be error variables and create a `RegionResolutionError` for each of them.",270,[[["self"],["lexicalregionresolutions"],["graph"],["vec"]]]],[11,"construct_graph","","",270,[[["self"]],["graph",["constraint"]]]],[11,"collect_error_for_expanding_node","","",270,N],[11,"collect_concrete_regions","","",270,N],[11,"iterate_until_fixed_point","","",270,[[["self"],["str"],["f"]]]],[11,"bound_is_met","","",270,[[["self"],["verifybound"],["lexicalregionresolutions"],["region"]],["bool"]]],[11,"fmt","","",269,[[["self"],["formatter"]],["result"]]],[11,"normalize","","",268,[[["self"],["region"]],["region"]]],[11,"value","","",268,[[["self"],["regionvid"]],["varvalue"]]],[11,"value_mut","","",268,[[["self"],["regionvid"]],["varvalue"]]],[11,"resolve_var","","",268,[[["self"],["regionvid"]],["region"]]],[0,"outlives","rustc::infer","Various code related to computing outlives relations.",N,N],[0,"env","rustc::infer::outlives","",N,N],[3,"OutlivesEnvironment","rustc::infer::outlives::env","The `OutlivesEnvironment` collects information about what outlives what in a given type-checking setting. For example, if we have a where-clause like `where T: 'a` in scope, then the `OutlivesEnvironment` would record that (in its `region_bound_pairs` field). Similarly, it contains methods for processing and adding implied bounds into the outlives environment.",N,N],[12,"param_env","","",276,N],[12,"free_region_map","","",276,N],[12,"region_bound_pairs","","",276,N],[11,"clone","","",276,[[["self"]],["outlivesenvironment"]]],[11,"new","","",276,[[["paramenv"]],["self"]]],[11,"free_region_map","","Borrows current value of the `free_region_map`.",276,[[["self"]],["freeregionmap"]]],[11,"region_bound_pairs","","Borrows current value of the `region_bound_pairs`.",276,N],[11,"into_free_region_map","","Returns ownership of the `free_region_map`.",276,[[["self"]],["freeregionmap"]]],[11,"push_snapshot_pre_closure","","This is a hack to support the old-skool regionck, which processes region constraints from the main function and the closure together. In that context, when we enter a closure, we want to be able to \"save\" the state of the surrounding a function. We can then add implied bounds and the like from the closure arguments into the environment -- these should only apply in the closure body, so once we exit, we invoke `pop_snapshot_post_closure` to remove them.",276,[[["self"]],["usize"]]],[11,"pop_snapshot_post_closure","","See `push_snapshot_pre_closure`.",276,[[["self"],["usize"]]]],[11,"add_implied_bounds","","This method adds \"implied bounds\" into the outlives environment. Implied bounds are outlives relationships that we can deduce on the basis that certain types must be well-formed -- these are either the types that appear in the function signature or else the input types to an impl. For example, if you have a function like",276,N],[11,"add_outlives_bounds","","Processes outlives bounds that are known to hold, whether from implied or other sources.",276,[[["self"],["option",["inferctxt"]],["i"]]]],[0,"free_region_map","rustc::infer::outlives","",N,N],[3,"FreeRegionMap","rustc::infer::outlives::free_region_map","",N,N],[12,"relation","","",277,N],[5,"is_free","","",N,[[["region"]],["bool"]]],[5,"is_free_or_static","","",N,[[["region"]],["bool"]]],[8,"FreeRegionRelations","","The NLL region handling code represents free region relations in a slightly different way; this trait allows functions to be abstract over which version is in use.",N,N],[10,"sub_free_regions","","Tests whether `r_a <= r_b`. Both must be free regions or `'static`.",278,[[["self"],["region"],["region"]],["bool"]]],[11,"clone","","",277,[[["self"]],["freeregionmap"]]],[11,"encode","","",277,[[["self"],["__s"]],["result"]]],[11,"decode","","",277,[[["__d"]],["result",["freeregionmap"]]]],[11,"fmt","","",277,[[["self"],["formatter"]],["result"]]],[11,"new","","",277,[[],["self"]]],[11,"is_empty","","",277,[[["self"]],["bool"]]],[11,"relate_regions","","",277,[[["self"],["region"],["region"]]]],[11,"lub_free_regions","","Compute the least-upper-bound of two free regions. In some cases, this is more conservative than necessary, in order to avoid making arbitrary choices. See `TransitiveRelation::postdom_upper_bound` for more details.",277,[[["self"],["tyctxt"],["region"],["region"]],["region"]]],[11,"sub_free_regions","","",277,[[["self"],["region"],["region"]],["bool"]]],[11,"hash_stable","","",277,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"lift_to_tcx","","",277,[[["self"],["tyctxt"]],["option",["freeregionmap"]]]],[0,"obligations","rustc::infer::outlives","Code that handles \"type-outlives\" constraints like `T: 'a`. This is based on the `outlives_components` function defined on the tcx, but it adds a bit of heuristics on top, in particular to deal with associated types and projections.",N,N],[3,"TypeOutlives","rustc::infer::outlives::obligations","The `TypeOutlives` struct has the job of \"lowering\" a `T: 'a` obligation into a series of `'a: 'b` constraints and \"verifys\", as described on the module comment. The final constraints are emitted via a \"delegate\" of type `D` -- this is usually the `infcx`, which accrues them into the `region_obligations` code, but for NLL we use something else.",N,N],[12,"delegate","","",279,N],[12,"tcx","","",279,N],[12,"region_bound_pairs","","",279,N],[12,"implicit_region_bound","","",279,N],[12,"param_env","","",279,N],[8,"TypeOutlivesDelegate","","",N,N],[10,"push_sub_region_constraint","","",280,[[["self"],["subregionorigin"],["region"],["region"]]]],[10,"push_verify","","",280,[[["self"],["subregionorigin"],["generickind"],["region"],["verifybound"]]]],[11,"register_region_obligation","rustc::infer","Registers that the given region obligation must be resolved from within the scope of `body_id`. These regions are enqueued and later processed by regionck, when full type information is available (see `region_obligations` field for more information).",208,[[["self"],["nodeid"],["regionobligation"]]]],[11,"take_registered_region_obligations","","Trait queries just want to pass back type obligations \"as is\"",208,[[["self"]],["vec"]]],[11,"process_registered_region_obligations","","Process the region obligations that must be proven (during `regionck`) for the given `body_id`, given information about the region bounds in scope and so forth. This function must be invoked for all relevant body-ids before region inference is done (or else an assert will fire).",208,N],[11,"type_must_outlive","","Processes a single ad-hoc region obligation that was not registered in advance.",208,N],[11,"new","rustc::infer::outlives::obligations","",279,N],[11,"type_must_outlive","","Adds constraints to inference such that `T: 'a` holds (or reports an error if it cannot).",279,[[["self"],["subregionorigin"],["ty"],["region"]]]],[11,"components_must_outlive","","",279,[[["self"],["subregionorigin"],["vec",["component"]],["region"]]]],[11,"param_ty_must_outlive","","",279,[[["self"],["subregionorigin"],["region"],["paramty"]]]],[11,"projection_must_outlive","","",279,[[["self"],["subregionorigin"],["region"],["projectionty"]]]],[11,"type_bound","","",279,[[["self"],["ty"]],["verifybound"]]],[11,"param_bound","","",279,[[["self"],["paramty"]],["verifybound"]]],[11,"projection_declared_bounds","","",279,[[["self"],["projectionty"]],["vec",["region"]]]],[11,"projection_bound","","",279,[[["self"],["vec",["region"]],["projectionty"]],["verifybound"]]],[11,"recursive_type_bound","","",279,[[["self"],["ty"]],["verifybound"]]],[11,"declared_generic_bounds_from_env","","",279,[[["self"],["generickind"]],["vec",["region"]]]],[11,"declared_projection_bounds_from_trait","","Given a projection like `<T as Foo<'x>>::Bar`, returns any bounds declared in the trait definition. For example, if the trait were",279,[[["self"],["projectionty"]],["vec",["region"]]]],[11,"region_bounds_declared_on_associated_item","","Given the def-id of an associated item, returns any region bounds attached to that associated item from the trait definition.",279,[[["self"],["defid"]],["vec",["region"]]]],[11,"collect_outlives_from_predicate_list","","Searches through a predicate list for a predicate `T: 'a`.",279,[[["self"],["ty"],["i"]],["vec",["region"]]]],[0,"resolve","rustc::infer","",N,N],[3,"OpportunisticTypeResolver","rustc::infer::resolve","The opportunistic type resolver can be used at any time. It simply replaces type variables that have been unified with the things they have been unified with (similar to `shallow_resolve`, but deep). This is useful for printing messages etc but also required at various points for correctness.",N,N],[12,"infcx","","",281,N],[3,"OpportunisticTypeAndRegionResolver","","The opportunistic type and region resolver is similar to the opportunistic type resolver, but also opportunistically resolves regions. It is useful for canonicalization.",N,N],[12,"infcx","","",282,N],[3,"UnresolvedTypeFinder","","The unresolved type finder walks your type and searches for type variables that don't yet have a value. They get pushed into a vector. It does not construct the fully resolved type (which might involve some hashing and so forth).",N,N],[12,"infcx","","",283,N],[3,"FullTypeResolver","","",N,N],[12,"infcx","","",284,N],[12,"err","","",284,N],[5,"fully_resolve","","Full type resolution replaces all type and region variables with their concrete results. If any variable cannot be replaced (never unified, etc) then an `Err` result is returned.",N,[[["inferctxt"],["t"]],["fixupresult"]]],[11,"new","","",281,[[["inferctxt"]],["self"]]],[11,"tcx","","",281,[[["self"]],["tyctxt"]]],[11,"fold_ty","","",281,[[["self"],["ty"]],["ty"]]],[11,"new","","",282,[[["inferctxt"]],["self"]]],[11,"tcx","","",282,[[["self"]],["tyctxt"]]],[11,"fold_ty","","",282,[[["self"],["ty"]],["ty"]]],[11,"fold_region","","",282,[[["self"],["region"]],["region"]]],[11,"new","","",283,[[["inferctxt"]],["self"]]],[11,"visit_ty","","",283,[[["self"],["ty"]],["bool"]]],[11,"tcx","","",284,[[["self"]],["tyctxt"]]],[11,"fold_ty","","",284,[[["self"],["ty"]],["ty"]]],[11,"fold_region","","",284,[[["self"],["region"]],["region"]]],[0,"freshen","rustc::infer","Freshening is the process of replacing unknown variables with fresh types. The idea is that the type, after freshening, contains no inference variables but instead contains either a value for each variable or fresh \"arbitrary\" types wherever a variable would have been.",N,N],[3,"TypeFreshener","rustc::infer::freshen","",N,N],[12,"infcx","","",206,N],[12,"freshen_count","","",206,N],[12,"freshen_map","","",206,N],[11,"new","rustc::infer","",206,[[["inferctxt"]],["typefreshener"]]],[11,"freshen","","",206,[[["self"],["option",["ty"]],["inferty"],["f"]],["ty"]]],[11,"tcx","","",206,[[["self"]],["tyctxt"]]],[11,"fold_region","","",206,[[["self"],["region"]],["region"]]],[11,"fold_ty","","",206,[[["self"],["ty"]],["ty"]]],[0,"sub","","",N,N],[3,"Sub","rustc::infer::sub","Ensures `a` is made a subtype of `b`. Returns `a` on success.",N,N],[12,"fields","","",285,N],[12,"a_is_expected","","",285,N],[11,"new","","",285,[[["combinefields"],["bool"]],["sub"]]],[11,"with_expected_switched","","",285,[[["self"],["f"]],["r"]]],[11,"tag","","",285,[[["self"]],["str"]]],[11,"tcx","","",285,[[["self"]],["tyctxt"]]],[11,"a_is_expected","","",285,[[["self"]],["bool"]]],[11,"with_cause","","",285,[[["self"],["cause"],["f"]],["r"]]],[11,"relate_with_variance","","",285,[[["self"],["variance"],["t"],["t"]],["relateresult"]]],[11,"tys","","",285,[[["self"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"regions","","",285,[[["self"],["region"],["region"]],["relateresult",["region"]]]],[11,"binders","","",285,[[["self"],["binder"],["binder"]],["relateresult",["binder"]]]],[0,"type_variable","rustc::infer","",N,N],[3,"TypeVariableTable","rustc::infer::type_variable","",N,N],[12,"values","","",286,N],[12,"eq_relations","","Two variables are unified in `eq_relations` when we have a constraint `?X == ?Y`. This table also stores, for each key, the known value.",286,N],[12,"sub_relations","","Two variables are unified in `eq_relations` when we have a constraint `?X <: ?Y` or a constraint `?Y <: ?X`. This second table exists only to help with the occurs check. In particular, we want to report constraints like these as an occurs check violation:",286,N],[3,"TypeVariableData","","",N,N],[12,"origin","","",287,N],[12,"diverging","","",287,N],[3,"Snapshot","","",N,N],[12,"snapshot","","",288,N],[12,"eq_snapshot","","",288,N],[12,"sub_snapshot","","",288,N],[3,"Instantiate","","",N,N],[12,"vid","","",289,N],[3,"Delegate","","",N,N],[3,"TyVidEqKey","","These structs (a newtyped TyVid) are used as the unification key for the `eq_relations`; they carry a `TypeVariableValue` along with them.",N,N],[12,"vid","","",290,N],[12,"phantom","","",290,N],[4,"TypeVariableOrigin","","Reasons to create a type inference variable",N,N],[13,"MiscVariable","","",291,N],[13,"NormalizeProjectionType","","",291,N],[13,"TypeInference","","",291,N],[13,"TypeParameterDefinition","","",291,N],[13,"ClosureSynthetic","","one of the upvars or closure kind parameters in a `ClosureSubsts` (before it has been determined)",291,N],[13,"SubstitutionPlaceholder","","",291,N],[13,"AutoDeref","","",291,N],[13,"AdjustmentType","","",291,N],[13,"DivergingStmt","","",291,N],[13,"DivergingBlockExpr","","",291,N],[13,"DivergingFn","","",291,N],[13,"LatticeVariable","","",291,N],[13,"Generalized","","",291,N],[4,"TypeVariableValue","","",N,N],[13,"Known","","",292,N],[12,"value","rustc::infer::type_variable::TypeVariableValue","",292,N],[13,"Unknown","rustc::infer::type_variable","",292,N],[12,"universe","rustc::infer::type_variable::TypeVariableValue","",292,N],[6,"TypeVariableMap","rustc::infer::type_variable","",N,N],[11,"clone","","",291,[[["self"]],["typevariableorigin"]]],[11,"fmt","","",291,[[["self"],["formatter"]],["result"]]],[11,"clone","","",292,[[["self"]],["typevariablevalue"]]],[11,"fmt","","",292,[[["self"],["formatter"]],["result"]]],[11,"known","","If this value is known, returns the type it is known to be. Otherwise, `None`.",292,[[["self"]],["option",["ty"]]]],[11,"is_unknown","","",292,[[["self"]],["bool"]]],[11,"new","","",286,[[],["typevariabletable"]]],[11,"var_diverges","","Returns the diverges flag given when `vid` was created.",286,[[["self"],["tyvid"]],["bool"]]],[11,"var_origin","","Returns the origin that was given when `vid` was created.",286,[[["self"],["tyvid"]],["typevariableorigin"]]],[11,"equate","","Records that `a == b`, depending on `dir`.",286,[[["self"],["tyvid"],["tyvid"]]]],[11,"sub","","Records that `a <: b`, depending on `dir`.",286,[[["self"],["tyvid"],["tyvid"]]]],[11,"instantiate","","Instantiates `vid` with the type `ty`.",286,[[["self"],["tyvid"],["ty"]]]],[11,"new_var","","Creates a new type variable.",286,[[["self"],["universeindex"],["bool"],["typevariableorigin"]],["tyvid"]]],[11,"num_vars","","Returns the number of type variables created thus far.",286,[[["self"]],["usize"]]],[11,"root_var","","Returns the \"root\" variable of `vid` in the `eq_relations` equivalence table. All type variables that have been equated will yield the same root variable (per the union-find algorithm), so `root_var(a) == root_var(b)` implies that `a == b` (transitively).",286,[[["self"],["tyvid"]],["tyvid"]]],[11,"sub_root_var","","Returns the \"root\" variable of `vid` in the `sub_relations` equivalence table. All type variables that have been are related via equality or subtyping will yield the same root variable (per the union-find algorithm), so `sub_root_var(a) == sub_root_var(b)` implies that:",286,[[["self"],["tyvid"]],["tyvid"]]],[11,"sub_unified","","True if `a` and `b` have same \"sub-root\" (i.e., exists some type X such that `forall i in {a, b}. (i <: X || X <: i)`.",286,[[["self"],["tyvid"],["tyvid"]],["bool"]]],[11,"probe","","Retrieves the type to which `vid` has been instantiated, if any.",286,[[["self"],["tyvid"]],["typevariablevalue"]]],[11,"replace_if_possible","","If `t` is a type-inference variable, and it has been instantiated, then return the with which it was instantiated. Otherwise, returns `t`.",286,[[["self"],["ty"]],["ty"]]],[11,"snapshot","","Creates a snapshot of the type variable state.  This snapshot must later be committed (`commit()`) or rolled back (`rollback_to()`).  Nested snapshots are permitted, but must be processed in a stack-like fashion.",286,[[["self"]],["snapshot"]]],[11,"rollback_to","","Undoes all changes since the snapshot was created. Any snapshots created since that point must already have been committed or rolled back.",286,[[["self"],["snapshot"]]]],[11,"commit","","Commits all changes since the snapshot was created, making them permanent (unless this snapshot was created within another snapshot). Any snapshots created since that point must already have been committed or rolled back.",286,[[["self"],["snapshot"]]]],[11,"types_created_since_snapshot","","Returns a map `{V1 -> V2}`, where the keys `{V1}` are ty-variables created during the snapshot, and the values `{V2}` are the root variables that they were unified with, along with their origin.",286,[[["self"],["snapshot"]],["typevariablemap"]]],[11,"types_escaping_snapshot","","Find the set of type variables that existed before `s` but which have only been unified since `s` started, and return the types with which they were unified. So if we had a type variable `V0`, then we started the snapshot, then we created a type variable `V1`, unifed `V0` with `T0`, and unified `V1` with `T1`, this function would return `{T0}`.",286,[[["self"],["snapshot"]],["vec",["ty"]]]],[11,"unsolved_variables","","Returns indices of all variables that are not yet instantiated.",286,[[["self"]],["vec",["tyvid"]]]],[11,"reverse","","",293,[[["vec"],["instantiate"]]]],[11,"clone","","",290,[[["self"]],["tyvideqkey"]]],[11,"fmt","","",290,[[["self"],["formatter"]],["result"]]],[11,"eq","","",290,[[["self"],["tyvideqkey"]],["bool"]]],[11,"ne","","",290,[[["self"],["tyvideqkey"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",290,N],[11,"from","","",290,[[["tyvid"]],["self"]]],[11,"index","","",290,[[["self"]],["u32"]]],[11,"from_index","","",290,[[["u32"]],["self"]]],[11,"tag","","",290,[[],["str"]]],[11,"unify_values","","",292,[[["self"],["self"]],["result",["noerror"]]]],[0,"unify_key","rustc::infer","",N,N],[3,"RegionVidKey","rustc::infer::unify_key","",N,N],[12,"min_vid","","The minimum region vid in the unification set. This is needed to have a canonical name for a type to prevent infinite recursion.",294,N],[8,"ToType","","",N,N],[10,"to_type","","",295,[[["self"],["tyctxt"]],["ty"]]],[11,"eq","","",294,[[["self"],["regionvidkey"]],["bool"]]],[11,"ne","","",294,[[["self"],["regionvidkey"]],["bool"]]],[11,"clone","","",294,[[["self"]],["regionvidkey"]]],[11,"fmt","","",294,[[["self"],["formatter"]],["result"]]],[11,"unify_values","","",294,[[["self"],["self"]],["result",["noerror"]]]],[6,"InferResult","rustc::infer","",N,N],[6,"Bound","","",N,N],[6,"UnitResult","","",N,N],[6,"FixupResult","","",N,N],[6,"SkolemizationMap","","A map returned by `skolemize_late_bound_regions()` indicating the skolemized region that each late-bound region was replaced with.",N,N],[11,"fmt","","",207,[[["self"],["formatter"]],["result"]]],[11,"clone","","",213,[[["self"]],["valuepairs"]]],[11,"fmt","","",213,[[["self"],["formatter"]],["result"]]],[11,"clone","","",209,[[["self"]],["typetrace"]]],[11,"clone","","",214,[[["self"]],["subregionorigin"]]],[11,"fmt","","",214,[[["self"],["formatter"]],["result"]]],[11,"clone","","",215,[[["self"]],["parameterorigin"]]],[11,"fmt","","",215,[[["self"],["formatter"]],["result"]]],[11,"clone","","",216,[[["self"]],["lateboundregionconversiontime"]]],[11,"fmt","","",216,[[["self"],["formatter"]],["result"]]],[11,"clone","","",217,[[["self"]],["regionvariableorigin"]]],[11,"fmt","","",217,[[["self"],["formatter"]],["result"]]],[11,"clone","","",218,[[["self"]],["nllregionvariableorigin"]]],[11,"fmt","","",218,[[["self"],["formatter"]],["result"]]],[11,"eq","","",218,[[["self"],["nllregionvariableorigin"]],["bool"]]],[11,"ne","","",218,[[["self"],["nllregionvariableorigin"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",218,N],[11,"hash","","",218,N],[11,"is_universal","","",218,[[["self"]],["bool"]]],[11,"is_existential","","",218,[[["self"]],["bool"]]],[11,"clone","","",219,[[["self"]],["fixuperror"]]],[11,"fmt","","",219,[[["self"],["formatter"]],["result"]]],[11,"clone","","",210,[[["self"]],["regionobligation"]]],[11,"fmt","","",219,[[["self"],["formatter"]],["result"]]],[11,"with_fresh_in_progress_tables","","Used only by `rustc_typeck` during body type-checking/inference, will initialize `in_progress_tables` with fresh `TypeckTables`.",211,[[["self"],["defid"]],["self"]]],[11,"enter","","",211,[[["self"],["f"]],["r"]]],[11,"unit","","",207,[[["self"]],["inferok"]]],[11,"into_value_registering_obligations","","Extract `value`, registering any obligations into `fulfill_cx`",207,N],[11,"into_obligations","","",207,[[["self"]],["predicateobligations"]]],[11,"is_in_snapshot","","",208,[[["self"]],["bool"]]],[11,"freshen","","",208,[[["self"],["t"]],["t"]]],[11,"type_var_diverges","","",208,[[["self"],["ty"]],["bool"]]],[11,"freshener","","",208,[[["self"]],["typefreshener"]]],[11,"type_is_unconstrained_numeric","","",208,[[["self"],["ty"]],["unconstrainednumeric"]]],[11,"unsolved_variables","","",208,[[["self"]],["vec",["ty"]]]],[11,"combine_fields","","",208,[[["self"],["typetrace"],["paramenv"]],["combinefields"]]],[11,"save_and_restore_in_snapshot_flag","","",208,[[["self"],["f"]],["r"]]],[11,"start_snapshot","","",208,[[["self"]],["combinedsnapshot"]]],[11,"rollback_to","","",208,[[["self"],["str"],["combinedsnapshot"]]]],[11,"commit_from","","",208,[[["self"],["combinedsnapshot"]]]],[11,"commit_unconditionally","","Execute `f` and commit the bindings",208,[[["self"],["f"]],["r"]]],[11,"commit_if_ok","","Execute `f` and commit the bindings if closure `f` returns `Ok(_)`",208,[[["self"],["f"]],["result"]]],[11,"in_snapshot","","",208,[[["self"],["f"]],["t"]]],[11,"probe","","Execute `f` then unroll any bindings it creates",208,[[["self"],["f"]],["r"]]],[11,"add_given","","",208,[[["self"],["region"],["regionvid"]]]],[11,"can_sub","","",208,[[["self"],["paramenv"],["t"],["t"]],["unitresult"]]],[11,"can_eq","","",208,[[["self"],["paramenv"],["t"],["t"]],["unitresult"]]],[11,"sub_regions","","",208,[[["self"],["subregionorigin"],["region"],["region"]]]],[11,"subtype_predicate","","",208,[[["self"],["obligationcause"],["paramenv"],["polysubtypepredicate"]],["option",["inferresult"]]]],[11,"region_outlives_predicate","","",208,[[["self"],["obligationcause"],["polyregionoutlivespredicate"]],["unitresult"]]],[11,"next_ty_var_id","","",208,[[["self"],["bool"],["typevariableorigin"]],["tyvid"]]],[11,"next_ty_var","","",208,[[["self"],["typevariableorigin"]],["ty"]]],[11,"next_diverging_ty_var","","",208,[[["self"],["typevariableorigin"]],["ty"]]],[11,"next_int_var_id","","",208,[[["self"]],["intvid"]]],[11,"next_float_var_id","","",208,[[["self"]],["floatvid"]]],[11,"next_region_var","","Create a fresh region variable with the next available index.",208,[[["self"],["regionvariableorigin"]],["region"]]],[11,"num_region_vars","","Number of region variables created so far.",208,[[["self"]],["usize"]]],[11,"next_nll_region_var","","Just a convenient wrapper of `next_region_var` for using during NLL.",208,[[["self"],["nllregionvariableorigin"]],["region"]]],[11,"var_for_def","","",208,[[["self"],["span"],["genericparamdef"]],["kind"]]],[11,"fresh_substs_for_item","","Given a set of generics defined on a type or impl, returns a substitution mapping each type/region parameter to a fresh inference variable.",208,[[["self"],["span"],["defid"]],["substs"]]],[11,"is_tainted_by_errors","","True if errors have been reported since this infcx was created.  This is sometimes used as a heuristic to skip reporting errors that often occur as a result of earlier errors, but where it's hard to be 100% sure (e.g., unresolved inference variables, regionck errors).",208,[[["self"]],["bool"]]],[11,"set_tainted_by_errors","","Set the \"tainted by errors\" flag to true. We call this when we observe an error from a prior pass.",208,[[["self"]]]],[11,"resolve_regions_and_report_errors","","Process the region constraints and report any errors that result. After this, no more unification operations should be done -- or the compiler will panic -- but it is legal to use `resolve_type_vars_if_possible` as well as `fully_resolve`.",208,[[["self"],["defid"],["scopetree"],["outlivesenvironment"]]]],[11,"resolve_regions_and_report_errors_unless_nll","","Like `resolve_regions_and_report_errors`, but skips error reporting if NLL is enabled.  This is used for fn bodies where the same error may later be reported by the NLL-based inference.",208,[[["self"],["defid"],["scopetree"],["outlivesenvironment"]]]],[11,"resolve_regions_and_report_errors_inner","","",208,[[["self"],["defid"],["scopetree"],["outlivesenvironment"],["bool"]]]],[11,"take_and_reset_region_constraints","","Obtains (and clears) the current set of region constraints. The inference context is still usable: further unifications will simply add new constraints.",208,[[["self"]],["regionconstraintdata"]]],[11,"with_region_constraints","","Gives temporary access to the region constraint data.",208,N],[11,"take_region_var_origins","","Takes ownership of the list of variable regions. This implies that all the region constriants have already been taken, and hence that `resolve_regions_and_report_errors` can never be called. This is used only during NLL processing to \"hand off\" ownership of the set of region vairables into the NLL region context.",208,[[["self"]],["varinfos"]]],[11,"ty_to_string","","",208,[[["self"],["ty"]],["string"]]],[11,"tys_to_string","","",208,N],[11,"trait_ref_to_string","","",208,[[["self"],["traitref"]],["string"]]],[11,"shallow_resolve","","",208,[[["self"],["ty"]],["ty"]]],[11,"resolve_type_vars_if_possible","","Where possible, replaces type/int/float variables in `value` with their final value. Note that region variables are unaffected. If a type variable has not been unified, it is left as is.  This is an idempotent operation that does not affect inference state in any way and so you can do it at will.",208,[[["self"],["t"]],["t"]]],[11,"any_unresolved_type_vars","","Returns true if `T` contains unresolved type variables. In the process of visiting `T`, this will resolve (where possible) type variables in `T`, but it never constructs the final, resolved type, so it's more efficient than `resolve_type_vars_if_possible()`.",208,[[["self"],["t"]],["bool"]]],[11,"resolve_type_and_region_vars_if_possible","","",208,[[["self"],["t"]],["t"]]],[11,"fully_resolve","","Attempts to resolve all type/region variables in `value`. Region inference must have been run already (e.g., by calling `resolve_regions_and_report_errors`).  If some variable was never unified, an `Err` results.",208,[[["self"],["t"]],["fixupresult"]]],[11,"type_error_struct_with_diag","","",208,[[["self"],["span"],["m"],["ty"]],["diagnosticbuilder"]]],[11,"report_mismatched_types","","",208,[[["self"],["obligationcause"],["ty"],["ty"],["typeerror"]],["diagnosticbuilder"]]],[11,"replace_late_bound_regions_with_fresh_var","","",208,N],[11,"match_poly_projection_predicate","","Given a higher-ranked projection predicate like:",208,[[["self"],["obligationcause"],["paramenv"],["polyprojectionpredicate"],["traitref"]],["inferresult",["hrmatchresult"]]]],[11,"verify_generic_bound","","See `verify_generic_bound` method in `region_constraints`",208,[[["self"],["subregionorigin"],["generickind"],["region"],["verifybound"]]]],[11,"type_moves_by_default","","",208,[[["self"],["paramenv"],["ty"],["span"]],["bool"]]],[11,"closure_kind","","Obtains the latest type of the given closure; this may be a closure in the current function, in which case its `ClosureKind` may not yet be known.",208,[[["self"],["defid"],["closuresubsts"]],["option",["closurekind"]]]],[11,"closure_sig","","Obtain the signature of a closure.  For closures, unlike `tcx.fn_sig(def_id)`, this method will work during the type-checking of the enclosing function and return the closure signature in its partially inferred state.",208,[[["self"],["defid"],["closuresubsts"]],["polyfnsig"]]],[11,"partially_normalize_associated_types_in","","Normalizes associated types in `value`, potentially returning new obligations that must further be processed.",208,[[["self"],["span"],["nodeid"],["paramenv"],["t"]],["inferok"]]],[11,"borrow_region_constraints","","",208,[[["self"]],["refmut",["regionconstraintcollector"]]]],[11,"clear_caches","","Clears the selection, evaluation, and projection cachesThis is useful when repeatedly attemping to select an Obligation while changing only its ParamEnv, since FulfillmentContext doesn't use 'probe'",208,[[["self"]]]],[11,"universe","","",208,[[["self"]],["universeindex"]]],[11,"create_subuniverse","","Create and return a new subunivese of the current universe; update `self.universe` to that new subuniverse. At present, used only in the NLL subtyping code, which uses the new universe-based scheme instead of the more limited leak-check scheme.",208,[[["self"]],["universeindex"]]],[11,"span","","",209,[[["self"]],["span"]]],[11,"types","","",209,[[["obligationcause"],["bool"],["ty"],["ty"]],["typetrace"]]],[11,"dummy","","",209,[[["tyctxt"]],["typetrace"]]],[11,"fmt","","",209,[[["self"],["formatter"]],["result"]]],[11,"span","","",214,[[["self"]],["span"]]],[11,"from_obligation_cause","","",214,[[["obligationcause"],["f"]],["self"]]],[11,"span","","",217,[[["self"]],["span"]]],[11,"super_fold_with","","",213,[[["self"],["v"]],["self"]]],[11,"super_visit_with","","",213,[[["self"],["v"]],["bool"]]],[11,"fmt","","",210,[[["self"],["formatter"]],["result"]]],[0,"lint","rustc","Lints, aka compiler warnings.",N,N],[3,"LateContext","rustc::lint","Context for lint checking after type checking.",N,N],[12,"tcx","","Type context we're checking in.",296,N],[12,"tables","","Side-tables for the body we are in.",296,N],[12,"param_env","","Parameter environment for the item we are in.",296,N],[12,"access_levels","","Items accessible from the crate being checked.",296,N],[12,"lint_sess","","The store of registered lints and the lint levels.",296,N],[12,"last_ast_node_with_lint_attrs","","",296,N],[12,"generics","","Generic type parameters in scope for the item we are in.",296,N],[3,"EarlyContext","","Context for lint checking of the AST, after expansion, before lowering to HIR.",N,N],[12,"sess","","Type context we're checking in.",297,N],[12,"krate","","The crate being checked.",297,N],[12,"builder","","",297,N],[12,"lint_sess","","The store of registered lints and the lint levels.",297,N],[12,"buffered","","",297,N],[3,"LintStore","","Information about the registered lints.",N,N],[12,"lints","","Registered lints. The bool is true if the lint was added by a plugin.",298,N],[12,"pre_expansion_passes","","Trait objects for each lint pass. This is only `None` while performing a lint pass.",298,N],[12,"early_passes","","",298,N],[12,"late_passes","","",298,N],[12,"by_name","","Lints indexed by name.",298,N],[12,"lint_groups","","Map of registered lint groups to what lints they expand to. The bool is true if the lint group was added by a plugin.",298,N],[12,"future_incompatible","","Extra info for future incompatibility lints, describing the issue or RFC that caused the incompatibility.",298,N],[3,"FutureIncompatibleInfo","","Extra information for a future incompatibility lint. See the call to `register_future_incompatible` in `librustc_lint/lib.rs` for guidelines.",N,N],[12,"id","","",299,N],[12,"reference","","e.g., a URL for an issue/PR/RFC or error code",299,N],[12,"edition","","If this is an edition fixing lint, the edition in which this lint becomes obsolete",299,N],[3,"BufferedEarlyLint","","Lints that are buffered up early on in the `Session` before the `LintLevels` is calculated",N,N],[12,"lint_id","","",300,N],[12,"ast_id","","",300,N],[12,"span","","",300,N],[12,"msg","","",300,N],[12,"diagnostic","","",300,N],[3,"Lint","","Specification of a single lint.",N,N],[12,"name","","A string identifier for the lint.",301,N],[12,"default_level","","Default level for the lint.",301,N],[12,"desc","","Description of the lint or the issue it detects.",301,N],[12,"edition_lint_opts","","Starting at the given edition, default to the given lint level. If this is `None`, then use `default_level`.",301,N],[12,"report_in_external_macro","","Whether this lint is reported even inside expansions of external macros",301,N],[3,"LintId","","Identifies a lint known to the compiler.",N,N],[12,"lint","","",302,N],[3,"LintLevelSets","","",N,N],[12,"list","","",303,N],[12,"lint_cap","","",303,N],[3,"LintLevelMap","","",N,N],[12,"sets","","",304,N],[12,"id_to_set","","",304,N],[3,"LintBuffer","","",N,N],[12,"map","","",305,N],[3,"LintLevelMapBuilder","","",N,N],[12,"levels","","",306,N],[12,"tcx","","",306,N],[4,"Level","","Setting for how to handle a lint.",N,N],[13,"Allow","","",307,N],[13,"Warn","","",307,N],[13,"Deny","","",307,N],[13,"Forbid","","",307,N],[4,"LintSource","","How a lint level was set.",N,N],[13,"Default","","Lint is at the default level as declared in rustc or a plugin.",308,N],[13,"Node","","Lint level was set by an attribute.",308,N],[13,"CommandLine","","Lint level was set by a command-line flag.",308,N],[5,"check_crate","","Perform lint checking on a crate.",N,[[["tyctxt"]]]],[5,"check_ast_crate","","",N,[[["session"],["crate"],["bool"]]]],[5,"struct_lint_level","","",N,[[["session"],["lint"],["level"],["lintsource"],["option",["multispan"]],["str"]],["diagnosticbuilder"]]],[5,"lint_levels","","",N,[[["tyctxt"],["cratenum"]],["lrc",["lintlevelmap"]]]],[5,"provide","","",N,[[["providers"]]]],[5,"in_external_macro","","Returns whether `span` originates in a foreign crate's external macro.",N,[[["session"],["span"]],["bool"]]],[0,"builtin","","Some lints that are built in to the compiler.",N,N],[3,"HardwiredLints","rustc::lint::builtin","Does nothing as a lint pass, but registers some `Lint`s which are used by other parts of the compiler.",N,N],[4,"BuiltinLintDiagnostics","","",N,N],[13,"Normal","","",309,N],[13,"BareTraitObject","","",309,N],[13,"AbsPathWithModule","","",309,N],[13,"DuplicatedMacroExports","","",309,N],[13,"ProcMacroDeriveResolutionFallback","","",309,N],[13,"ElidedLifetimesInPaths","","",309,N],[0,"parser","","Some lints that are buffered from `libsyntax`. See `syntax::early_buffered_lints`.",N,N],[7,"QUESTION_MARK_MACRO_SEP","rustc::lint::builtin::parser","",N,N],[7,"EXCEEDING_BITSHIFTS","rustc::lint::builtin","",N,N],[7,"CONST_ERR","","",N,N],[7,"UNUSED_IMPORTS","","",N,N],[7,"UNUSED_EXTERN_CRATES","","",N,N],[7,"UNUSED_QUALIFICATIONS","","",N,N],[7,"UNKNOWN_LINTS","","",N,N],[7,"UNUSED_VARIABLES","","",N,N],[7,"UNUSED_ASSIGNMENTS","","",N,N],[7,"DEAD_CODE","","",N,N],[7,"UNREACHABLE_CODE","","",N,N],[7,"UNREACHABLE_PATTERNS","","",N,N],[7,"UNUSED_MACROS","","",N,N],[7,"WARNINGS","","",N,N],[7,"UNUSED_FEATURES","","",N,N],[7,"STABLE_FEATURES","","",N,N],[7,"UNKNOWN_CRATE_TYPES","","",N,N],[7,"TRIVIAL_CASTS","","",N,N],[7,"TRIVIAL_NUMERIC_CASTS","","",N,N],[7,"PRIVATE_IN_PUBLIC","","",N,N],[7,"PUB_USE_OF_PRIVATE_EXTERN_CRATE","","",N,N],[7,"INVALID_TYPE_PARAM_DEFAULT","","",N,N],[7,"RENAMED_AND_REMOVED_LINTS","","",N,N],[7,"SAFE_EXTERN_STATICS","","",N,N],[7,"SAFE_PACKED_BORROWS","","",N,N],[7,"PATTERNS_IN_FNS_WITHOUT_BODY","","",N,N],[7,"LEGACY_DIRECTORY_OWNERSHIP","","",N,N],[7,"LEGACY_CONSTRUCTOR_VISIBILITY","","",N,N],[7,"MISSING_FRAGMENT_SPECIFIER","","",N,N],[7,"PARENTHESIZED_PARAMS_IN_TYPES_AND_MODULES","","",N,N],[7,"LATE_BOUND_LIFETIME_ARGUMENTS","","",N,N],[7,"INCOHERENT_FUNDAMENTAL_IMPLS","","",N,N],[7,"BAD_REPR","","",N,N],[7,"DEPRECATED","","",N,N],[7,"UNUSED_UNSAFE","","",N,N],[7,"UNUSED_MUT","","",N,N],[7,"SINGLE_USE_LIFETIMES","","",N,N],[7,"UNUSED_LIFETIMES","","",N,N],[7,"TYVAR_BEHIND_RAW_POINTER","","",N,N],[7,"ELIDED_LIFETIMES_IN_PATHS","","",N,N],[7,"BARE_TRAIT_OBJECTS","","",N,N],[7,"ABSOLUTE_PATHS_NOT_STARTING_WITH_CRATE","","",N,N],[7,"ILLEGAL_FLOATING_POINT_LITERAL_PATTERN","","",N,N],[7,"UNSTABLE_NAME_COLLISIONS","","",N,N],[7,"IRREFUTABLE_LET_PATTERNS","","",N,N],[7,"UNUSED_LABELS","","",N,N],[7,"DUPLICATE_ASSOCIATED_TYPE_BINDINGS","","",N,N],[7,"DUPLICATE_MACRO_EXPORTS","","",N,N],[7,"INTRA_DOC_LINK_RESOLUTION_FAILURE","","",N,N],[7,"WHERE_CLAUSES_OBJECT_SAFETY","","",N,N],[7,"PROC_MACRO_DERIVE_RESOLUTION_FALLBACK","","",N,N],[7,"MACRO_USE_EXTERN_CRATE","","",N,N],[11,"clone","","",310,[[["self"]],["hardwiredlints"]]],[11,"get_lints","","",310,[[["self"]],["lintarray"]]],[11,"eq","","",309,[[["self"],["builtinlintdiagnostics"]],["bool"]]],[11,"ne","","",309,[[["self"],["builtinlintdiagnostics"]],["bool"]]],[11,"encode","","",309,[[["self"],["__s"]],["result"]]],[11,"decode","","",309,[[["__d"]],["result",["builtinlintdiagnostics"]]]],[11,"fmt","","",309,[[["self"],["formatter"]],["result"]]],[11,"run","","",309,[[["self"],["session"],["diagnosticbuilder"]]]],[0,"context","rustc::lint","Implementation of lint checking.",N,N],[3,"LintStore","rustc::lint::context","Information about the registered lints.",N,N],[12,"lints","","Registered lints. The bool is true if the lint was added by a plugin.",298,N],[12,"pre_expansion_passes","","Trait objects for each lint pass. This is only `None` while performing a lint pass.",298,N],[12,"early_passes","","",298,N],[12,"late_passes","","",298,N],[12,"by_name","","Lints indexed by name.",298,N],[12,"lint_groups","","Map of registered lint groups to what lints they expand to. The bool is true if the lint group was added by a plugin.",298,N],[12,"future_incompatible","","Extra info for future incompatibility lints, describing the issue or RFC that caused the incompatibility.",298,N],[3,"LintSession","","",N,N],[12,"lints","","Reference to the store of registered lints.",311,N],[12,"passes","","Trait objects for each lint pass.",311,N],[3,"BufferedEarlyLint","","Lints that are buffered up early on in the `Session` before the `LintLevels` is calculated",N,N],[12,"lint_id","","",300,N],[12,"ast_id","","",300,N],[12,"span","","",300,N],[12,"msg","","",300,N],[12,"diagnostic","","",300,N],[3,"FutureIncompatibleInfo","","Extra information for a future incompatibility lint. See the call to `register_future_incompatible` in `librustc_lint/lib.rs` for guidelines.",N,N],[12,"id","","",299,N],[12,"reference","","e.g., a URL for an issue/PR/RFC or error code",299,N],[12,"edition","","If this is an edition fixing lint, the edition in which this lint becomes obsolete",299,N],[3,"LateContext","","Context for lint checking after type checking.",N,N],[12,"tcx","","Type context we're checking in.",296,N],[12,"tables","","Side-tables for the body we are in.",296,N],[12,"param_env","","Parameter environment for the item we are in.",296,N],[12,"access_levels","","Items accessible from the crate being checked.",296,N],[12,"lint_sess","","The store of registered lints and the lint levels.",296,N],[12,"last_ast_node_with_lint_attrs","","",296,N],[12,"generics","","Generic type parameters in scope for the item we are in.",296,N],[3,"EarlyContext","","Context for lint checking of the AST, after expansion, before lowering to HIR.",N,N],[12,"sess","","Type context we're checking in.",297,N],[12,"krate","","The crate being checked.",297,N],[12,"builder","","",297,N],[12,"lint_sess","","The store of registered lints and the lint levels.",297,N],[12,"buffered","","",297,N],[4,"TargetLint","","The target of the `by_name` map, which accounts for renaming/deprecation.",N,N],[13,"Id","","A direct lint target",312,N],[13,"Renamed","","Temporary renaming, used for easing migration pain; see #16545",312,N],[13,"Removed","","Lint with this name existed previously, but has been removed/deprecated. The string argument is the reason for removal.",312,N],[4,"FindLintError","","",N,N],[13,"NotFound","","",313,N],[13,"Removed","","",313,N],[4,"CheckLintNameResult","","",N,N],[13,"Ok","","",314,N],[13,"NoLint","","Lint doesn't exist",314,N],[13,"Warning","","The lint is either renamed or removed. This is the warning message, and an optional new name (`None` if removed).",314,N],[5,"check_crate","","Perform lint checking on a crate.",N,[[["tyctxt"]]]],[5,"check_ast_crate","","",N,[[["session"],["crate"],["bool"]]]],[8,"LintPassObject","","",N,N],[8,"LintContext","","",N,N],[16,"PassObject","","",315,N],[10,"sess","","",315,[[["self"]],["session"]]],[10,"lints","","",315,[[["self"]],["lintstore"]]],[10,"lint_sess","","",315,[[["self"]],["lintsession"]]],[10,"lint_sess_mut","","",315,[[["self"]],["lintsession"]]],[10,"enter_attrs","","",315,N],[10,"exit_attrs","","",315,N],[11,"lookup_and_emit","","",315,[[["self"],["lint"],["option"],["str"]]]],[11,"lookup_and_emit_with_diagnostics","","",315,[[["self"],["lint"],["option"],["str"],["builtinlintdiagnostics"]]]],[10,"lookup","","",315,[[["self"],["lint"],["option"],["str"]],["diagnosticbuilder"]]],[11,"span_lint","","Emit a lint at the appropriate level, for a particular span.",315,[[["self"],["lint"],["s"],["str"]]]],[11,"struct_span_lint","","",315,[[["self"],["lint"],["s"],["str"]],["diagnosticbuilder"]]],[11,"span_lint_note","","Emit a lint and note at the appropriate level, for a particular span.",315,[[["self"],["lint"],["span"],["str"],["span"],["str"]]]],[11,"span_lint_help","","Emit a lint and help at the appropriate level, for a particular span.",315,[[["self"],["lint"],["span"],["str"],["str"]]]],[11,"lint","","Emit a lint at the appropriate level, with no associated span.",315,[[["self"],["lint"],["str"]]]],[10,"with_lint_attrs","","Merge the lints specified by any lint attributes into the current lint context, call the provided function, then reset the lints in effect to their previous state.",315,N],[11,"eq","rustc::lint","",300,[[["self"],["bufferedearlylint"]],["bool"]]],[11,"ne","","",300,[[["self"],["bufferedearlylint"]],["bool"]]],[11,"encode","","",300,[[["self"],["__s"]],["result"]]],[11,"decode","","",300,[[["__d"]],["result",["bufferedearlylint"]]]],[11,"fmt","","",300,[[["self"],["formatter"]],["result"]]],[11,"new","","",298,[[],["lintstore"]]],[11,"get_lints","","",298,N],[11,"get_lint_groups","","",298,[[["self"]],["vec"]]],[11,"register_early_pass","","",298,[[["self"],["option",["session"]],["bool"],["earlylintpassobject"]]]],[11,"register_pre_expansion_pass","","",298,[[["self"],["option",["session"]],["earlylintpassobject"]]]],[11,"register_late_pass","","",298,[[["self"],["option",["session"]],["bool"],["latelintpassobject"]]]],[11,"push_pass","","",298,[[["self"],["option",["session"]],["bool"],["box"]]]],[11,"register_future_incompatible","","",298,[[["self"],["option",["session"]],["vec",["futureincompatibleinfo"]]]]],[11,"future_incompatible","","",298,[[["self"],["lintid"]],["option",["futureincompatibleinfo"]]]],[11,"register_group","","",298,[[["self"],["option",["session"]],["bool"],["str"],["vec",["lintid"]]]]],[11,"register_renamed","","",298,[[["self"],["str"],["str"]]]],[11,"register_removed","","",298,[[["self"],["str"],["str"]]]],[11,"find_lints","","",298,[[["self"],["str"]],["result",["vec","findlinterror"]]]],[11,"check_lint_name_cmdline","","Checks the validity of lint names derived from the command line",298,[[["self"],["session"],["str"],["level"]]]],[11,"check_lint_name","","Checks the name of a lint for its existence, and whether it was renamed or removed. Generates a DiagnosticBuilder containing a warning for renamed and removed lints. This is over both lint names from attributes and those passed on the command line. Since it emits non-fatal warnings and there are two lint passes that inspect attributes, this is only run from the late pass to avoid printing duplicate warnings.",298,[[["self"],["str"]],["checklintnameresult"]]],[11,"new","","",297,[[["session"],["crate"],["option",["vec"]],["lintbuffer"]],["earlycontext"]]],[11,"check_id","","",297,[[["self"],["nodeid"]]]],[11,"sess","","Get the overall compiler `Session` object.",296,[[["self"]],["session"]]],[11,"lints","","",296,[[["self"]],["lintstore"]]],[11,"lint_sess","","",296,[[["self"]],["lintsession"]]],[11,"lint_sess_mut","","",296,[[["self"]],["lintsession"]]],[11,"enter_attrs","","",296,N],[11,"exit_attrs","","",296,N],[11,"lookup","","",296,[[["self"],["lint"],["option"],["str"]],["diagnosticbuilder"]]],[11,"with_lint_attrs","","",296,N],[11,"sess","","Get the overall compiler `Session` object.",297,[[["self"]],["session"]]],[11,"lints","","",297,[[["self"]],["lintstore"]]],[11,"lint_sess","","",297,[[["self"]],["lintsession"]]],[11,"lint_sess_mut","","",297,[[["self"]],["lintsession"]]],[11,"enter_attrs","","",297,N],[11,"exit_attrs","","",297,N],[11,"lookup","","",297,[[["self"],["lint"],["option"],["str"]],["diagnosticbuilder"]]],[11,"with_lint_attrs","","",297,N],[11,"with_param_env","","",296,[[["self"],["nodeid"],["f"]]]],[11,"current_lint_root","","",296,[[["self"]],["nodeid"]]],[11,"nested_visit_map","","Because lints are scoped lexically, we want to walk nested items in the context of the outer item, so enable deep-walking.",296,[[["self"]],["nestedvisitormap"]]],[11,"visit_nested_body","","",296,[[["self"],["bodyid"]]]],[11,"visit_body","","",296,[[["self"],["body"]]]],[11,"visit_item","","",296,[[["self"],["item"]]]],[11,"visit_foreign_item","","",296,[[["self"],["foreignitem"]]]],[11,"visit_pat","","",296,[[["self"],["pat"]]]],[11,"visit_expr","","",296,[[["self"],["expr"]]]],[11,"visit_stmt","","",296,[[["self"],["stmt"]]]],[11,"visit_fn","","",296,[[["self"],["fnkind"],["fndecl"],["bodyid"],["span"],["nodeid"]]]],[11,"visit_variant_data","","",296,[[["self"],["variantdata"],["name"],["generics"],["nodeid"],["span"]]]],[11,"visit_struct_field","","",296,[[["self"],["structfield"]]]],[11,"visit_variant","","",296,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_ty","","",296,[[["self"],["ty"]]]],[11,"visit_name","","",296,[[["self"],["span"],["name"]]]],[11,"visit_mod","","",296,[[["self"],["mod"],["span"],["nodeid"]]]],[11,"visit_local","","",296,[[["self"],["local"]]]],[11,"visit_block","","",296,[[["self"],["block"]]]],[11,"visit_arm","","",296,[[["self"],["arm"]]]],[11,"visit_decl","","",296,[[["self"],["decl"]]]],[11,"visit_generic_param","","",296,[[["self"],["genericparam"]]]],[11,"visit_generics","","",296,[[["self"],["generics"]]]],[11,"visit_where_predicate","","",296,[[["self"],["wherepredicate"]]]],[11,"visit_poly_trait_ref","","",296,[[["self"],["polytraitref"],["traitboundmodifier"]]]],[11,"visit_trait_item","","",296,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",296,[[["self"],["implitem"]]]],[11,"visit_lifetime","","",296,[[["self"],["lifetime"]]]],[11,"visit_path","","",296,[[["self"],["path"],["nodeid"]]]],[11,"visit_attribute","","",296,[[["self"],["attribute"]]]],[11,"visit_item","","",297,[[["self"],["item"]]]],[11,"visit_foreign_item","","",297,[[["self"],["foreignitem"]]]],[11,"visit_pat","","",297,[[["self"],["pat"]]]],[11,"visit_expr","","",297,[[["self"],["expr"]]]],[11,"visit_stmt","","",297,[[["self"],["stmt"]]]],[11,"visit_fn","","",297,[[["self"],["fnkind"],["fndecl"],["span"],["nodeid"]]]],[11,"visit_variant_data","","",297,[[["self"],["variantdata"],["ident"],["generics"],["nodeid"],["span"]]]],[11,"visit_struct_field","","",297,[[["self"],["structfield"]]]],[11,"visit_variant","","",297,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_ty","","",297,[[["self"],["ty"]]]],[11,"visit_ident","","",297,[[["self"],["ident"]]]],[11,"visit_mod","","",297,N],[11,"visit_local","","",297,[[["self"],["local"]]]],[11,"visit_block","","",297,[[["self"],["block"]]]],[11,"visit_arm","","",297,[[["self"],["arm"]]]],[11,"visit_expr_post","","",297,[[["self"],["expr"]]]],[11,"visit_generic_param","","",297,[[["self"],["genericparam"]]]],[11,"visit_generics","","",297,[[["self"],["generics"]]]],[11,"visit_where_predicate","","",297,[[["self"],["wherepredicate"]]]],[11,"visit_poly_trait_ref","","",297,[[["self"],["polytraitref"],["traitboundmodifier"]]]],[11,"visit_trait_item","","",297,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",297,[[["self"],["implitem"]]]],[11,"visit_lifetime","","",297,[[["self"],["lifetime"]]]],[11,"visit_path","","",297,[[["self"],["path"],["nodeid"]]]],[11,"visit_attribute","","",297,[[["self"],["attribute"]]]],[11,"visit_mac_def","","",297,[[["self"],["macrodef"],["nodeid"]]]],[11,"visit_mac","","",297,[[["self"],["mac"]]]],[11,"encode","","",302,[[["self"],["s"]],["result"]]],[11,"decode","","",302,[[["d"]],["result",["lintid"]]]],[0,"levels","","",N,N],[3,"LintLevelSets","rustc::lint::levels","",N,N],[12,"list","","",303,N],[12,"lint_cap","","",303,N],[3,"LintLevelsBuilder","","",N,N],[12,"sess","","",316,N],[12,"sets","","",316,N],[12,"id_to_set","","",316,N],[12,"cur","","",316,N],[12,"warn_about_weird_lints","","",316,N],[3,"BuilderPush","","",N,N],[12,"prev","","",317,N],[3,"LintLevelMap","","",N,N],[12,"sets","","",304,N],[12,"id_to_set","","",304,N],[4,"LintSet","","",N,N],[13,"CommandLine","","",318,N],[12,"specs","rustc::lint::levels::LintSet","",318,N],[13,"Node","rustc::lint::levels","",318,N],[12,"specs","rustc::lint::levels::LintSet","",318,N],[12,"parent","","",318,N],[11,"new","rustc::lint","",303,[[["session"]],["lintlevelsets"]]],[11,"builder","","",303,[[["session"]],["lintlevelsbuilder"]]],[11,"process_command_line","","",303,[[["self"],["session"]]]],[11,"get_lint_level","","",303,N],[11,"get_lint_id_level","","",303,N],[11,"new","rustc::lint::levels","",316,[[["session"],["lintlevelsets"]],["lintlevelsbuilder"]]],[11,"push","","Pushes a list of AST lint attributes onto this context.",316,N],[11,"pop","","Called after `push` when the scope of a set of attributes are exited.",316,[[["self"],["builderpush"]]]],[11,"struct_lint","","Used to emit a lint-related diagnostic based on the current state of this lint context.",316,[[["self"],["lint"],["option",["multispan"]],["str"]],["diagnosticbuilder"]]],[11,"register_id","","Registers the ID provided with the current set of lints stored in this context.",316,[[["self"],["hirid"]]]],[11,"build","","",316,[[["self"]],["lintlevelsets"]]],[11,"build_map","","",316,[[["self"]],["lintlevelmap"]]],[11,"level_and_source","rustc::lint","If the `id` was previously registered with `register_id` when building this `LintLevelMap` this returns the corresponding lint level and source of the lint level for the lint provided.",304,[[["self"],["lint"],["hirid"],["session"]],["option"]]],[11,"lint_level_set","","Returns if this `id` has lint level information.",304,[[["self"],["hirid"]],["option",["u32"]]]],[11,"hash_stable","","",304,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",302,[[["self"],["hcx"],["stablehasher"]]]],[11,"to_stable_hash_key","","",302,[[["self"],["hcx"]],["str"]]],[6,"LintArray","","",N,N],[6,"EarlyLintPassObject","","A lint pass boxed up as a trait object.",N,N],[6,"LateLintPassObject","","",N,N],[6,"LevelSource","","",N,N],[8,"LintContext","","",N,N],[16,"PassObject","","",315,N],[10,"sess","","",315,[[["self"]],["session"]]],[10,"lints","","",315,[[["self"]],["lintstore"]]],[10,"lint_sess","","",315,[[["self"]],["lintsession"]]],[10,"lint_sess_mut","","",315,[[["self"]],["lintsession"]]],[10,"enter_attrs","","",315,N],[10,"exit_attrs","","",315,N],[11,"lookup_and_emit","rustc::lint::context","",315,[[["self"],["lint"],["option"],["str"]]]],[11,"lookup_and_emit_with_diagnostics","","",315,[[["self"],["lint"],["option"],["str"],["builtinlintdiagnostics"]]]],[10,"lookup","rustc::lint","",315,[[["self"],["lint"],["option"],["str"]],["diagnosticbuilder"]]],[11,"span_lint","rustc::lint::context","Emit a lint at the appropriate level, for a particular span.",315,[[["self"],["lint"],["s"],["str"]]]],[11,"struct_span_lint","","",315,[[["self"],["lint"],["s"],["str"]],["diagnosticbuilder"]]],[11,"span_lint_note","","Emit a lint and note at the appropriate level, for a particular span.",315,[[["self"],["lint"],["span"],["str"],["span"],["str"]]]],[11,"span_lint_help","","Emit a lint and help at the appropriate level, for a particular span.",315,[[["self"],["lint"],["span"],["str"],["str"]]]],[11,"lint","","Emit a lint at the appropriate level, with no associated span.",315,[[["self"],["lint"],["str"]]]],[10,"with_lint_attrs","rustc::lint","Merge the lints specified by any lint attributes into the current lint context, call the provided function, then reset the lints in effect to their previous state.",315,N],[8,"LintPass","","",N,N],[10,"get_lints","","Get descriptions of the lints this `LintPass` object can emit.",319,[[["self"]],["lintarray"]]],[8,"LateLintPass","","",N,N],[11,"check_body","","",320,[[["self"],["latecontext"],["body"]]]],[11,"check_body_post","","",320,[[["self"],["latecontext"],["body"]]]],[11,"check_name","","",320,[[["self"],["latecontext"],["span"],["name"]]]],[11,"check_crate","","",320,[[["self"],["latecontext"],["crate"]]]],[11,"check_crate_post","","",320,[[["self"],["latecontext"],["crate"]]]],[11,"check_mod","","",320,[[["self"],["latecontext"],["mod"],["span"],["nodeid"]]]],[11,"check_mod_post","","",320,[[["self"],["latecontext"],["mod"],["span"],["nodeid"]]]],[11,"check_foreign_item","","",320,[[["self"],["latecontext"],["foreignitem"]]]],[11,"check_foreign_item_post","","",320,[[["self"],["latecontext"],["foreignitem"]]]],[11,"check_item","","",320,[[["self"],["latecontext"],["item"]]]],[11,"check_item_post","","",320,[[["self"],["latecontext"],["item"]]]],[11,"check_local","","",320,[[["self"],["latecontext"],["local"]]]],[11,"check_block","","",320,[[["self"],["latecontext"],["block"]]]],[11,"check_block_post","","",320,[[["self"],["latecontext"],["block"]]]],[11,"check_stmt","","",320,[[["self"],["latecontext"],["stmt"]]]],[11,"check_arm","","",320,[[["self"],["latecontext"],["arm"]]]],[11,"check_pat","","",320,[[["self"],["latecontext"],["pat"]]]],[11,"check_decl","","",320,[[["self"],["latecontext"],["decl"]]]],[11,"check_expr","","",320,[[["self"],["latecontext"],["expr"]]]],[11,"check_expr_post","","",320,[[["self"],["latecontext"],["expr"]]]],[11,"check_ty","","",320,[[["self"],["latecontext"],["ty"]]]],[11,"check_generic_param","","",320,[[["self"],["latecontext"],["genericparam"]]]],[11,"check_generics","","",320,[[["self"],["latecontext"],["generics"]]]],[11,"check_where_predicate","","",320,[[["self"],["latecontext"],["wherepredicate"]]]],[11,"check_poly_trait_ref","","",320,[[["self"],["latecontext"],["polytraitref"],["traitboundmodifier"]]]],[11,"check_fn","","",320,[[["self"],["latecontext"],["fnkind"],["fndecl"],["body"],["span"],["nodeid"]]]],[11,"check_fn_post","","",320,[[["self"],["latecontext"],["fnkind"],["fndecl"],["body"],["span"],["nodeid"]]]],[11,"check_trait_item","","",320,[[["self"],["latecontext"],["traititem"]]]],[11,"check_trait_item_post","","",320,[[["self"],["latecontext"],["traititem"]]]],[11,"check_impl_item","","",320,[[["self"],["latecontext"],["implitem"]]]],[11,"check_impl_item_post","","",320,[[["self"],["latecontext"],["implitem"]]]],[11,"check_struct_def","","",320,[[["self"],["latecontext"],["variantdata"],["name"],["generics"],["nodeid"]]]],[11,"check_struct_def_post","","",320,[[["self"],["latecontext"],["variantdata"],["name"],["generics"],["nodeid"]]]],[11,"check_struct_field","","",320,[[["self"],["latecontext"],["structfield"]]]],[11,"check_variant","","",320,[[["self"],["latecontext"],["variant"],["generics"]]]],[11,"check_variant_post","","",320,[[["self"],["latecontext"],["variant"],["generics"]]]],[11,"check_lifetime","","",320,[[["self"],["latecontext"],["lifetime"]]]],[11,"check_path","","",320,[[["self"],["latecontext"],["path"],["nodeid"]]]],[11,"check_attribute","","",320,[[["self"],["latecontext"],["attribute"]]]],[11,"enter_lint_attrs","","",320,N],[11,"exit_lint_attrs","","",320,N],[8,"EarlyLintPass","","",N,N],[11,"check_ident","","",321,[[["self"],["earlycontext"],["ident"]]]],[11,"check_crate","","",321,[[["self"],["earlycontext"],["crate"]]]],[11,"check_crate_post","","",321,[[["self"],["earlycontext"],["crate"]]]],[11,"check_mod","","",321,[[["self"],["earlycontext"],["mod"],["span"],["nodeid"]]]],[11,"check_mod_post","","",321,[[["self"],["earlycontext"],["mod"],["span"],["nodeid"]]]],[11,"check_foreign_item","","",321,[[["self"],["earlycontext"],["foreignitem"]]]],[11,"check_foreign_item_post","","",321,[[["self"],["earlycontext"],["foreignitem"]]]],[11,"check_item","","",321,[[["self"],["earlycontext"],["item"]]]],[11,"check_item_post","","",321,[[["self"],["earlycontext"],["item"]]]],[11,"check_local","","",321,[[["self"],["earlycontext"],["local"]]]],[11,"check_block","","",321,[[["self"],["earlycontext"],["block"]]]],[11,"check_block_post","","",321,[[["self"],["earlycontext"],["block"]]]],[11,"check_stmt","","",321,[[["self"],["earlycontext"],["stmt"]]]],[11,"check_arm","","",321,[[["self"],["earlycontext"],["arm"]]]],[11,"check_pat","","",321,[[["self"],["earlycontext"],["pat"]]]],[11,"check_expr","","",321,[[["self"],["earlycontext"],["expr"]]]],[11,"check_expr_post","","",321,[[["self"],["earlycontext"],["expr"]]]],[11,"check_ty","","",321,[[["self"],["earlycontext"],["ty"]]]],[11,"check_generic_param","","",321,[[["self"],["earlycontext"],["genericparam"]]]],[11,"check_generics","","",321,[[["self"],["earlycontext"],["generics"]]]],[11,"check_where_predicate","","",321,[[["self"],["earlycontext"],["wherepredicate"]]]],[11,"check_poly_trait_ref","","",321,[[["self"],["earlycontext"],["polytraitref"],["traitboundmodifier"]]]],[11,"check_fn","","",321,[[["self"],["earlycontext"],["fnkind"],["fndecl"],["span"],["nodeid"]]]],[11,"check_fn_post","","",321,[[["self"],["earlycontext"],["fnkind"],["fndecl"],["span"],["nodeid"]]]],[11,"check_trait_item","","",321,[[["self"],["earlycontext"],["traititem"]]]],[11,"check_trait_item_post","","",321,[[["self"],["earlycontext"],["traititem"]]]],[11,"check_impl_item","","",321,[[["self"],["earlycontext"],["implitem"]]]],[11,"check_impl_item_post","","",321,[[["self"],["earlycontext"],["implitem"]]]],[11,"check_struct_def","","",321,[[["self"],["earlycontext"],["variantdata"],["ident"],["generics"],["nodeid"]]]],[11,"check_struct_def_post","","",321,[[["self"],["earlycontext"],["variantdata"],["ident"],["generics"],["nodeid"]]]],[11,"check_struct_field","","",321,[[["self"],["earlycontext"],["structfield"]]]],[11,"check_variant","","",321,[[["self"],["earlycontext"],["variant"],["generics"]]]],[11,"check_variant_post","","",321,[[["self"],["earlycontext"],["variant"],["generics"]]]],[11,"check_lifetime","","",321,[[["self"],["earlycontext"],["lifetime"]]]],[11,"check_path","","",321,[[["self"],["earlycontext"],["path"],["nodeid"]]]],[11,"check_attribute","","",321,[[["self"],["earlycontext"],["attribute"]]]],[11,"check_mac_def","","",321,[[["self"],["earlycontext"],["macrodef"],["nodeid"]]]],[11,"check_mac","","",321,[[["self"],["earlycontext"],["mac"]]]],[11,"enter_lint_attrs","","Called when entering a syntax node that can have lint attributes such as `#[allow(...)]`. Called with all the attributes of that node.",321,N],[11,"exit_lint_attrs","","Counterpart to `enter_lint_attrs`.",321,N],[11,"clone","","",301,[[["self"]],["lint"]]],[11,"fmt","","",301,[[["self"],["formatter"]],["result"]]],[11,"from_parser_lint_id","","Returns the `rust::lint::Lint` for a `syntax::early_buffered_lints::BufferedEarlyLintId`.",301,[[["bufferedearlylintid"]],["self"]]],[11,"name_lower","","Get the lint's name, with ASCII letters converted to lowercase.",301,[[["self"]],["string"]]],[11,"default_level","","",301,[[["self"],["session"]],["level"]]],[11,"clone","","",302,[[["self"]],["lintid"]]],[11,"fmt","","",302,[[["self"],["formatter"]],["result"]]],[11,"eq","","",302,[[["self"],["lintid"]],["bool"]]],[11,"hash","","",302,[[["self"],["h"]]]],[11,"of","","Get the `LintId` for a `Lint`.",302,[[["lint"]],["lintid"]]],[11,"lint_name_raw","","",302,[[["self"]],["str"]]],[11,"to_string","","Get the name of the lint.",302,[[["self"]],["string"]]],[11,"clone","","",307,[[["self"]],["level"]]],[11,"eq","","",307,[[["self"],["level"]],["bool"]]],[11,"partial_cmp","","",307,[[["self"],["level"]],["option",["ordering"]]]],[11,"assert_receiver_is_total_eq","","",307,N],[11,"cmp","","",307,[[["self"],["level"]],["ordering"]]],[11,"fmt","","",307,[[["self"],["formatter"]],["result"]]],[11,"hash","","",307,N],[11,"hash_stable","","",307,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"as_str","","Convert a level to a lower-case string.",307,[[["self"]],["str"]]],[11,"from_str","","Convert a lower-case string to a level.",307,[[["str"]],["option",["level"]]]],[11,"clone","","",308,[[["self"]],["lintsource"]]],[11,"eq","","",308,[[["self"],["lintsource"]],["bool"]]],[11,"ne","","",308,[[["self"],["lintsource"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",308,N],[11,"hash_stable","","",308,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"new","","",305,[[],["lintbuffer"]]],[11,"add_lint","","",305,[[["self"],["lint"],["nodeid"],["multispan"],["str"],["builtinlintdiagnostics"]]]],[11,"take","","",305,[[["self"],["nodeid"]],["vec",["bufferedearlylint"]]]],[11,"get_any","","",305,[[["self"]],["option"]]],[11,"with_lint_attrs","","",306,N],[11,"nested_visit_map","","",306,[[["self"]],["nestedvisitormap"]]],[11,"visit_item","","",306,[[["self"],["item"]]]],[11,"visit_foreign_item","","",306,[[["self"],["foreignitem"]]]],[11,"visit_expr","","",306,[[["self"],["expr"]]]],[11,"visit_struct_field","","",306,[[["self"],["structfield"]]]],[11,"visit_variant","","",306,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_local","","",306,[[["self"],["local"]]]],[11,"visit_trait_item","","",306,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",306,[[["self"],["implitem"]]]],[0,"middle","rustc","",N,N],[0,"allocator","rustc::middle","",N,N],[4,"AllocatorKind","rustc::middle::allocator","",N,N],[13,"Global","","",322,N],[13,"DefaultLib","","",322,N],[13,"DefaultExe","","",322,N],[11,"clone","","",322,[[["self"]],["allocatorkind"]]],[11,"fn_name","","",322,[[["self"],["str"]],["string"]]],[0,"borrowck","rustc::middle","",N,N],[3,"BorrowCheckResult","rustc::middle::borrowck","",N,N],[12,"used_mut_nodes","","",323,N],[12,"signalled_any_error","","",323,N],[4,"SignalledError","","",N,N],[13,"SawSomeError","","",324,N],[13,"NoErrorsSeen","","",324,N],[11,"clone","","",324,[[["self"]],["signallederror"]]],[11,"fmt","","",324,[[["self"],["formatter"]],["result"]]],[11,"encode","","",324,[[["self"],["__s"]],["result"]]],[11,"decode","","",324,[[["__d"]],["result",["signallederror"]]]],[11,"hash_stable","","",324,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"fmt","","",323,[[["self"],["formatter"]],["result"]]],[11,"encode","","",323,[[["self"],["__s"]],["result"]]],[11,"decode","","",323,[[["__d"]],["result",["borrowcheckresult"]]]],[11,"hash_stable","","",323,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[0,"expr_use_visitor","rustc::middle","A different sort of visitor for walking fn bodies.  Unlike the normal visitor, which just walks the entire body in one shot, the `ExprUseVisitor` determines how expressions are being used.",N,N],[3,"ExprUseVisitor","rustc::middle::expr_use_visitor","",N,N],[12,"mc","","",325,N],[12,"delegate","","",325,N],[12,"param_env","","",325,N],[4,"LoanCause","","",N,N],[13,"ClosureCapture","","",326,N],[13,"AddrOf","","",326,N],[13,"AutoRef","","",326,N],[13,"AutoUnsafe","","",326,N],[13,"RefBinding","","",326,N],[13,"OverloadedOperator","","",326,N],[13,"ClosureInvocation","","",326,N],[13,"ForLoop","","",326,N],[13,"MatchDiscriminant","","",326,N],[4,"ConsumeMode","","",N,N],[13,"Copy","","",327,N],[13,"Move","","",327,N],[4,"MoveReason","","",N,N],[13,"DirectRefMove","","",328,N],[13,"PatBindingMove","","",328,N],[13,"CaptureMove","","",328,N],[4,"MatchMode","","",N,N],[13,"NonBindingMatch","","",329,N],[13,"BorrowingMatch","","",329,N],[13,"CopyingMatch","","",329,N],[13,"MovingMatch","","",329,N],[4,"TrackMatchMode","","",N,N],[13,"Unknown","","",330,N],[13,"Definite","","",330,N],[13,"Conflicting","","",330,N],[4,"MutateMode","","",N,N],[13,"Init","","",331,N],[13,"JustWrite","","",331,N],[13,"WriteAndRead","","",331,N],[4,"OverloadedCallType","","",N,N],[13,"FnOverloadedCall","","",332,N],[13,"FnMutOverloadedCall","","",332,N],[13,"FnOnceOverloadedCall","","",332,N],[5,"copy_or_move","","",N,[[["memcategorizationcontext"],["paramenv"],["cmt_"],["movereason"]],["consumemode"]]],[8,"Delegate","","This trait defines the callbacks you can expect to receive when employing the ExprUseVisitor.",N,N],[10,"consume","","",333,[[["self"],["nodeid"],["span"],["cmt_"],["consumemode"]]]],[10,"matched_pat","","",333,[[["self"],["pat"],["cmt_"],["matchmode"]]]],[10,"consume_pat","","",333,[[["self"],["pat"],["cmt_"],["consumemode"]]]],[10,"borrow","","",333,[[["self"],["nodeid"],["span"],["cmt_"],["region"],["borrowkind"],["loancause"]]]],[10,"decl_without_init","","",333,[[["self"],["nodeid"],["span"]]]],[10,"mutate","","",333,[[["self"],["nodeid"],["span"],["cmt_"],["mutatemode"]]]],[11,"clone","","",326,[[["self"]],["loancause"]]],[11,"eq","","",326,[[["self"],["loancause"]],["bool"]]],[11,"ne","","",326,[[["self"],["loancause"]],["bool"]]],[11,"fmt","","",326,[[["self"],["formatter"]],["result"]]],[11,"clone","","",327,[[["self"]],["consumemode"]]],[11,"eq","","",327,[[["self"],["consumemode"]],["bool"]]],[11,"ne","","",327,[[["self"],["consumemode"]],["bool"]]],[11,"fmt","","",327,[[["self"],["formatter"]],["result"]]],[11,"clone","","",328,[[["self"]],["movereason"]]],[11,"eq","","",328,[[["self"],["movereason"]],["bool"]]],[11,"fmt","","",328,[[["self"],["formatter"]],["result"]]],[11,"clone","","",329,[[["self"]],["matchmode"]]],[11,"eq","","",329,[[["self"],["matchmode"]],["bool"]]],[11,"fmt","","",329,[[["self"],["formatter"]],["result"]]],[11,"clone","","",330,[[["self"]],["trackmatchmode"]]],[11,"eq","","",330,[[["self"],["trackmatchmode"]],["bool"]]],[11,"ne","","",330,[[["self"],["trackmatchmode"]],["bool"]]],[11,"fmt","","",330,[[["self"],["formatter"]],["result"]]],[11,"lub","","",330,[[["self"],["matchmode"]]]],[11,"match_mode","","",330,[[["self"]],["matchmode"]]],[11,"clone","","",331,[[["self"]],["mutatemode"]]],[11,"eq","","",331,[[["self"],["mutatemode"]],["bool"]]],[11,"fmt","","",331,[[["self"],["formatter"]],["result"]]],[11,"clone","","",332,[[["self"]],["overloadedcalltype"]]],[11,"from_trait_id","","",332,[[["tyctxt"],["defid"]],["overloadedcalltype"]]],[11,"from_method_id","","",332,[[["tyctxt"],["defid"]],["overloadedcalltype"]]],[11,"new","","Creates the ExprUseVisitor, configuring it with the various options provided:",325,[[["delegate"],["tyctxt"],["paramenv"],["scopetree"],["typecktables"],["option",["lrc"]]],["self"]]],[11,"with_infer","","",325,[[["delegate"],["inferctxt"],["paramenv"],["scopetree"],["typecktables"]],["self"]]],[11,"consume_body","","",325,[[["self"],["body"]]]],[11,"tcx","","",325,[[["self"]],["tyctxt"]]],[11,"delegate_consume","","",325,[[["self"],["nodeid"],["span"],["cmt_"]]]],[11,"consume_exprs","","",325,N],[11,"consume_expr","","",325,[[["self"],["expr"]]]],[11,"mutate_expr","","",325,[[["self"],["expr"],["expr"],["mutatemode"]]]],[11,"borrow_expr","","",325,[[["self"],["expr"],["region"],["borrowkind"],["loancause"]]]],[11,"select_from_expr","","",325,[[["self"],["expr"]]]],[11,"walk_expr","","",325,[[["self"],["expr"]]]],[11,"walk_callee","","",325,[[["self"],["expr"],["expr"]]]],[11,"walk_stmt","","",325,[[["self"],["stmt"]]]],[11,"walk_local","","",325,[[["self"],["local"]]]],[11,"walk_block","","Indicates that the value of `blk` will be consumed, meaning either copied or moved depending on its type.",325,[[["self"],["block"]]]],[11,"walk_struct_expr","","",325,N],[11,"walk_adjustment","","",325,[[["self"],["expr"]]]],[11,"walk_autoref","","Walks the autoref `autoref` applied to the autoderef'd `expr`. `cmt_base` is the mem-categorized form of `expr` after all relevant autoderefs have occurred.",325,[[["self"],["expr"],["cmt_"],["autoborrow"]]]],[11,"arm_move_mode","","",325,[[["self"],["cmt"],["arm"]],["trackmatchmode"]]],[11,"walk_arm","","",325,[[["self"],["cmt"],["arm"],["matchmode"]]]],[11,"walk_irrefutable_pat","","Walks a pat that occurs in isolation (i.e. top-level of fn arg or let binding.  Not a match arm or nested pat.)",325,[[["self"],["cmt"],["pat"]]]],[11,"determine_pat_move_mode","","Identifies any bindings within `pat` and accumulates within `mode` whether the overall pattern/match structure is a move, copy, or borrow.",325,[[["self"],["cmt"],["pat"],["trackmatchmode"]]]],[11,"walk_pat","","The core driver for walking a pattern; `match_mode` must be established up front, e.g. via `determine_pat_move_mode` (see also `walk_irrefutable_pat` for patterns that stand alone).",325,[[["self"],["cmt"],["pat"],["matchmode"]]]],[11,"walk_captures","","",325,[[["self"],["expr"],["span"]]]],[11,"cat_captured_var","","",325,[[["self"],["hirid"],["span"],["freevar"]],["mcresult",["cmt_"]]]],[0,"cstore","rustc::middle","the rustc crate store interface. This also includes types that are mostly used as a part of that interface, but these should probably get a better home if someone can find one.",N,N],[3,"LinkMeta","rustc::middle::cstore","",N,N],[12,"crate_hash","","",334,N],[3,"CrateSource","","Where a crate came from on the local filesystem. One of these three options must be non-None.",N,N],[12,"dylib","","",335,N],[12,"rlib","","",335,N],[12,"rmeta","","",335,N],[3,"NativeLibrary","","",N,N],[12,"kind","","",336,N],[12,"name","","",336,N],[12,"cfg","","",336,N],[12,"foreign_module","","",336,N],[12,"wasm_import_module","","",336,N],[3,"ForeignModule","","",N,N],[12,"foreign_items","","",337,N],[12,"def_id","","",337,N],[3,"ExternCrate","","",N,N],[12,"src","","",338,N],[12,"span","","span of the extern crate that caused this to be loaded",338,N],[12,"path_len","","Number of links to reach the extern; used to select the extern with the shortest path",338,N],[12,"direct","","If true, then this crate is the crate named by the extern crate referenced above. If false, then this crate is a dep of the crate.",338,N],[3,"EncodedMetadata","","",N,N],[12,"raw_data","","",339,N],[3,"DummyCrateStore","","A dummy crate store that does not support any non-local crates, for test purposes.",N,N],[4,"DepKind","","",N,N],[13,"UnexportedMacrosOnly","","A dependency that is only used for its macros, none of which are visible from other crates. These are included in the metadata only as placeholders and are ignored when decoding.",340,N],[13,"MacrosOnly","","A dependency that is only used for its macros.",340,N],[13,"Implicit","","A dependency that is always injected into the dependency list and so doesn't need to be linked to an rlib, e.g. the injected allocator.",340,N],[13,"Explicit","","A dependency that is required by an rlib version of this crate. Ordinary `extern crate`s result in `Explicit` dependencies.",340,N],[4,"LibSource","","",N,N],[13,"Some","","",341,N],[13,"MetadataOnly","","",341,N],[13,"None","","",341,N],[4,"LinkagePreference","","",N,N],[13,"RequireDynamic","","",342,N],[13,"RequireStatic","","",342,N],[4,"NativeLibraryKind","","",N,N],[13,"NativeStatic","","native static library (.a archive)",343,N],[13,"NativeStaticNobundle","","native static library, which doesn't get bundled into .rlibs",343,N],[13,"NativeFramework","","macOS-specific",343,N],[13,"NativeUnknown","","default way to specify a dynamic library",343,N],[4,"LoadedMacro","","",N,N],[13,"MacroDef","","",344,N],[13,"ProcMacro","","",344,N],[4,"ExternCrateSource","","",N,N],[13,"Extern","","Crate is loaded by `extern crate`.",345,N],[13,"Use","","",345,N],[13,"Path","","Crate is implicitly loaded by an absolute or an `extern::` path.",345,N],[5,"validate_crate_name","","",N,[[["option",["session"]],["str"],["option",["span"]]]]],[5,"used_crates","","",N,[[["tyctxt"],["linkagepreference"]],["vec"]]],[6,"CrateStoreDyn","","",N,N],[8,"MetadataLoader","","The backend's way to give the crate store access to the metadata in a library. Note that it returns the raw metadata bytes stored in the library file, whether it is compressed, uncompressed, some weird mix, etc. rmeta files are backend independent and not handled here.",N,N],[10,"get_rlib_metadata","","",346,[[["self"],["target"],["path"]],["result",["metadataref","string"]]]],[10,"get_dylib_metadata","","",346,[[["self"],["target"],["path"]],["result",["metadataref","string"]]]],[8,"CrateStore","","A store of Rust crates, through with their metadata can be accessed.",N,N],[10,"crate_data_as_rc_any","","",347,[[["self"],["cratenum"]],["lrc",["any"]]]],[10,"metadata_loader","","",347,[[["self"]],["metadataloader"]]],[10,"def_key","","",347,[[["self"],["defid"]],["defkey"]]],[10,"def_path","","",347,[[["self"],["defid"]],["defpath"]]],[10,"def_path_hash","","",347,[[["self"],["defid"]],["defpathhash"]]],[10,"def_path_table","","",347,[[["self"],["cratenum"]],["lrc",["defpathtable"]]]],[10,"visibility_untracked","","",347,[[["self"],["defid"]],["visibility"]]],[10,"export_macros_untracked","","",347,[[["self"],["cratenum"]]]],[10,"dep_kind_untracked","","",347,[[["self"],["cratenum"]],["depkind"]]],[10,"crate_name_untracked","","",347,[[["self"],["cratenum"]],["symbol"]]],[10,"crate_disambiguator_untracked","","",347,[[["self"],["cratenum"]],["cratedisambiguator"]]],[10,"crate_hash_untracked","","",347,[[["self"],["cratenum"]],["svh"]]],[10,"crate_edition_untracked","","",347,[[["self"],["cratenum"]],["edition"]]],[10,"struct_field_names_untracked","","",347,[[["self"],["defid"]],["vec",["name"]]]],[10,"item_children_untracked","","",347,[[["self"],["defid"],["session"]],["vec",["export"]]]],[10,"load_macro_untracked","","",347,[[["self"],["defid"],["session"]],["loadedmacro"]]],[10,"extern_mod_stmt_cnum_untracked","","",347,[[["self"],["nodeid"]],["option",["cratenum"]]]],[10,"item_generics_cloned_untracked","","",347,[[["self"],["defid"],["session"]],["generics"]]],[10,"associated_item_cloned_untracked","","",347,[[["self"],["defid"]],["associateditem"]]],[10,"postorder_cnums_untracked","","",347,[[["self"]],["vec",["cratenum"]]]],[10,"crates_untracked","","",347,[[["self"]],["vec",["cratenum"]]]],[10,"encode_metadata","","",347,[[["self"],["tyctxt"],["linkmeta"]],["encodedmetadata"]]],[10,"metadata_encoding_version","","",347,N],[8,"CrateLoader","","",N,N],[10,"process_extern_crate","","",348,[[["self"],["item"],["definitions"]],["cratenum"]]],[10,"process_path_extern","","",348,[[["self"],["symbol"],["span"]],["cratenum"]]],[10,"process_use_extern","","",348,[[["self"],["symbol"],["span"],["nodeid"],["definitions"]],["cratenum"]]],[10,"postprocess","","",348,[[["self"],["crate"]]]],[11,"clone","","",334,[[["self"]],["linkmeta"]]],[11,"fmt","","",334,[[["self"],["formatter"]],["result"]]],[11,"eq","","",335,[[["self"],["cratesource"]],["bool"]]],[11,"ne","","",335,[[["self"],["cratesource"]],["bool"]]],[11,"clone","","",335,[[["self"]],["cratesource"]]],[11,"fmt","","",335,[[["self"],["formatter"]],["result"]]],[11,"encode","","",340,[[["self"],["__s"]],["result"]]],[11,"decode","","",340,[[["__d"]],["result",["depkind"]]]],[11,"clone","","",340,[[["self"]],["depkind"]]],[11,"cmp","","",340,[[["self"],["depkind"]],["ordering"]]],[11,"partial_cmp","","",340,[[["self"],["depkind"]],["option",["ordering"]]]],[11,"assert_receiver_is_total_eq","","",340,N],[11,"eq","","",340,[[["self"],["depkind"]],["bool"]]],[11,"fmt","","",340,[[["self"],["formatter"]],["result"]]],[11,"macros_only","","",340,[[["self"]],["bool"]]],[11,"eq","","",341,[[["self"],["libsource"]],["bool"]]],[11,"ne","","",341,[[["self"],["libsource"]],["bool"]]],[11,"clone","","",341,[[["self"]],["libsource"]]],[11,"fmt","","",341,[[["self"],["formatter"]],["result"]]],[11,"is_some","","",341,[[["self"]],["bool"]]],[11,"option","","",341,[[["self"]],["option",["pathbuf"]]]],[11,"fmt","","",342,[[["self"],["formatter"]],["result"]]],[11,"eq","","",342,[[["self"],["linkagepreference"]],["bool"]]],[11,"clone","","",342,[[["self"]],["linkagepreference"]]],[11,"encode","","",342,[[["self"],["__s"]],["result"]]],[11,"decode","","",342,[[["__d"]],["result",["linkagepreference"]]]],[11,"clone","","",343,[[["self"]],["nativelibrarykind"]]],[11,"eq","","",343,[[["self"],["nativelibrarykind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",343,N],[11,"partial_cmp","","",343,[[["self"],["nativelibrarykind"]],["option",["ordering"]]]],[11,"cmp","","",343,[[["self"],["nativelibrarykind"]],["ordering"]]],[11,"hash","","",343,N],[11,"encode","","",343,[[["self"],["__s"]],["result"]]],[11,"decode","","",343,[[["__d"]],["result",["nativelibrarykind"]]]],[11,"clone","","",336,[[["self"]],["nativelibrary"]]],[11,"encode","","",336,[[["self"],["__s"]],["result"]]],[11,"decode","","",336,[[["__d"]],["result",["nativelibrary"]]]],[11,"clone","","",337,[[["self"]],["foreignmodule"]]],[11,"hash","","",337,N],[11,"encode","","",337,[[["self"],["__s"]],["result"]]],[11,"decode","","",337,[[["__d"]],["result",["foreignmodule"]]]],[11,"clone","","",338,[[["self"]],["externcrate"]]],[11,"fmt","","",338,[[["self"],["formatter"]],["result"]]],[11,"clone","","",345,[[["self"]],["externcratesource"]]],[11,"fmt","","",345,[[["self"],["formatter"]],["result"]]],[11,"new","","",339,[[],["encodedmetadata"]]],[11,"crate_data_as_rc_any","","",349,[[["self"],["cratenum"]],["lrc",["any"]]]],[11,"visibility_untracked","","",349,[[["self"],["defid"]],["visibility"]]],[11,"item_generics_cloned_untracked","","",349,[[["self"],["defid"],["session"]],["generics"]]],[11,"associated_item_cloned_untracked","","",349,[[["self"],["defid"]],["associateditem"]]],[11,"dep_kind_untracked","","",349,[[["self"],["cratenum"]],["depkind"]]],[11,"export_macros_untracked","","",349,[[["self"],["cratenum"]]]],[11,"crate_name_untracked","","",349,[[["self"],["cratenum"]],["symbol"]]],[11,"crate_disambiguator_untracked","","",349,[[["self"],["cratenum"]],["cratedisambiguator"]]],[11,"crate_hash_untracked","","",349,[[["self"],["cratenum"]],["svh"]]],[11,"crate_edition_untracked","","",349,[[["self"],["cratenum"]],["edition"]]],[11,"def_key","","",349,[[["self"],["defid"]],["defkey"]]],[11,"def_path","","",349,[[["self"],["defid"]],["defpath"]]],[11,"def_path_hash","","",349,[[["self"],["defid"]],["defpathhash"]]],[11,"def_path_table","","",349,[[["self"],["cratenum"]],["lrc",["defpathtable"]]]],[11,"struct_field_names_untracked","","",349,[[["self"],["defid"]],["vec",["name"]]]],[11,"item_children_untracked","","",349,[[["self"],["defid"],["session"]],["vec",["export"]]]],[11,"load_macro_untracked","","",349,[[["self"],["defid"],["session"]],["loadedmacro"]]],[11,"crates_untracked","","",349,[[["self"]],["vec",["cratenum"]]]],[11,"extern_mod_stmt_cnum_untracked","","",349,[[["self"],["nodeid"]],["option",["cratenum"]]]],[11,"encode_metadata","","",