initSidebarItems({"enum":[["Constructor",""],["Usefulness",""],["WitnessPreference",""]],"fn":[["all_constructors","This determines the set of all possible constructors of a pattern matching values of type `left_ty`. For vectors, this would normally be an infinite set but is instead bounded by the maximum fixed length of slice patterns in the column of patterns being analyzed."],["compute_missing_ctors",""],["constructor_arity","This computes the arity of a constructor. The arity of a constructor is how many subpattern patterns of that constructor should be expanded to."],["constructor_covered_by_range",""],["constructor_intersects_pattern","Check whether there exists any shared value in either `ctor` or `pat` by intersecting them."],["constructor_sub_pattern_tys","This computes the types of the sub patterns that a constructor should be expanded to."],["expand_pattern",""],["is_useful","Algorithm from http://moscova.inria.fr/~maranget/papers/warn/index.html The algorithm from the paper has been modified to correctly handle empty types. The changes are:   (0) We don't exit early if the pattern matrix has zero rows. We just       continue to recurse over columns.   (1) all_constructors will only return constructors that are statically       possible. eg. it will only return Ok for Result<T, !>"],["is_useful_specialized","A shorthand for the `U(S(c, P), S(c, q))` operation from the paper. I.e. `is_useful` applied to the specialised version of both the pattern matrix `P` and the new pattern `q`."],["max_slice_length",""],["pat_constructors","Determines the constructors that the given pattern can be specialized to."],["patterns_for_variant",""],["should_treat_range_exhaustively",""],["slice_pat_covered_by_constructor",""],["specialize","This is the main specialization step. It expands the first pattern in the given row into `arity` patterns based on the constructor. For most patterns, the step is trivial, for instance tuple patterns are flattened and box patterns expand into their inner pattern."],["split_grouped_constructors","For exhaustive integer matching, some constructors are grouped within other constructors (namely integer typed values are grouped within ranges). However, when specialising these constructors, we want to be specialising for the underlying constructors (the integers), not the groups (the ranges). Thus we need to split the groups up. Splitting them up naïvely would mean creating a separate constructor for every single value in the range, which is clearly impractical. However, observe that for some ranges of integers, the specialisation will be identical across all values in that range (i.e. there are equivalence classes of ranges of constructors based on their `is_useful_specialised` outcome). These classes are grouped by the patterns that apply to them (in the matrix `P`). We can split the range whenever the patterns that apply to that range (specifically: the patterns that intersect with that range) change. Our solution, therefore, is to split the range constructor into subranges at every single point the group of intersecting patterns changes (using the method described below). And voilà! We're testing precisely those ranges that we need to, without any exhaustive matching on actual integers. The nice thing about this is that the number of subranges is linear in the number of rows in the matrix (i.e. the number of cases in the `match` statement), so we don't need to be worried about matching over gargantuan ranges."]],"struct":[["IntRange","An inclusive interval, used for precise integer exhaustiveness checking. `IntRange`s always store a contiguous range. This means that values are encoded such that `0` encodes the minimum value for the integer, regardless of the signedness. For example, the pattern `-128...127i8` is encoded as `0..=255`. This makes comparisons and arithmetic on interval endpoints much more straightforward. See `signed_bias` for details."],["LiteralExpander",""],["MatchCheckCtxt",""],["Matrix",""],["PatternContext",""],["Witness","A witness of non-exhaustiveness for error reporting, represented as a list of patterns (in reverse order of construction) with wildcards inside to represent elements that can take any inhabitant of the type as a value."]]});