var N = null;var searchIndex = {};
searchIndex["arena"]={"doc":"The arena, a fast but limited type of allocator.","items":[[3,"TypedArena","arena","An arena that can hold objects of only one type.",N,N],[12,"ptr","","A pointer to the next object to be allocated.",0,N],[12,"end","","A pointer to the end of the allocated area. When this pointer is reached, a new chunk is allocated.",0,N],[12,"chunks","","A vector of arena chunks.",0,N],[12,"_own","","Marker indicating that dropping the arena causes its owned instances of `T` to be dropped.",0,N],[3,"TypedArenaChunk","","",N,N],[12,"storage","","The raw storage for the arena chunk.",1,N],[3,"DroplessArena","","",N,N],[12,"ptr","","A pointer to the next object to be allocated.",2,N],[12,"end","","A pointer to the end of the allocated area. When this pointer is reached, a new chunk is allocated.",2,N],[12,"chunks","","A vector of arena chunks.",2,N],[3,"SyncTypedArena","","",N,N],[12,"lock","","",3,N],[3,"SyncDroplessArena","","",N,N],[12,"lock","","",4,N],[17,"PAGE","","",N,N],[11,"new","","",1,[[["usize"]],["typedarenachunk"]]],[11,"destroy","","Destroys this arena chunk.",1,[[["self"],["usize"]]]],[11,"start","","",1,N],[11,"end","","",1,N],[11,"new","","Creates a new `TypedArena`.",0,[[],["typedarena"]]],[11,"alloc","","Allocates an object in the `TypedArena`, returning a reference to it.",0,[[["self"],["t"]],["t"]]],[11,"alloc_slice","","Allocates a slice of objects that are copied into the `TypedArena`, returning a mutable reference to it. Will panic if passed a zero-sized types.",0,N],[11,"grow","","Grows the arena.",0,[[["self"],["usize"]]]],[11,"clear","","Clears the arena. Deallocates all but the longest chunk which may be reused.",0,[[["self"]]]],[11,"clear_last_chunk","","",0,[[["self"],["typedarenachunk"]]]],[11,"drop","","",0,[[["self"]]]],[11,"new","","",2,[[],["droplessarena"]]],[11,"in_arena","","",2,N],[11,"align","","",2,[[["self"],["usize"]]]],[11,"grow","","",2,[[["self"],["usize"]]]],[11,"alloc_raw","","",2,N],[11,"alloc","","",2,[[["self"],["t"]],["t"]]],[11,"alloc_slice","","Allocates a slice of objects that are copied into the `DroplessArena`, returning a mutable reference to it. Will panic if passed a zero-sized type.",2,N],[11,"new","","",3,[[],["synctypedarena"]]],[11,"alloc","","",3,[[["self"],["t"]],["t"]]],[11,"alloc_slice","","",3,N],[11,"clear","","",3,[[["self"]]]],[11,"new","","",4,[[],["syncdroplessarena"]]],[11,"in_arena","","",4,N],[11,"alloc_raw","","",4,N],[11,"alloc","","",4,[[["self"],["t"]],["t"]]],[11,"alloc_slice","","",4,N],[11,"from","","",0,[[["t"]],["t"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"not_found","","",0,[[["str"],["str"]],["e"]]],[11,"from","","",1,[[["t"]],["t"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"not_found","","",1,[[["str"],["str"]],["e"]]],[11,"from","","",2,[[["t"]],["t"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"not_found","","",2,[[["str"],["str"]],["e"]]],[11,"from","","",3,[[["t"]],["t"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]],[11,"not_found","","",3,[[["str"],["str"]],["e"]]],[11,"from","","",4,[[["t"]],["t"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"not_found","","",4,[[["str"],["str"]],["e"]]]],"paths":[[3,"TypedArena"],[3,"TypedArenaChunk"],[3,"DroplessArena"],[3,"SyncTypedArena"],[3,"SyncDroplessArena"]]};
searchIndex["bitflags"]={"doc":"A typesafe bitmask flag generator useful for sets of C-style bitmask flags. It can be used for creating typesafe wrappers around C APIs.","items":[[0,"example_generated","bitflags","This module shows an example of code generated by the macro. IT MUST NOT BE USED OUTSIDE THIS CRATE.",N,N],[3,"Flags","bitflags::example_generated","This is the same `Flags` struct defined in the crate level example. Note that this struct is just for documentation purposes only, it must not be used outside this crate.",N,N],[12,"bits","","",0,N],[17,"FLAG_A","","",N,N],[17,"FLAG_B","","",N,N],[17,"FLAG_C","","",N,N],[17,"FLAG_ABC","","",N,N],[11,"eq","","",0,[[["self"],["flags"]],["bool"]]],[11,"ne","","",0,[[["self"],["flags"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",0,N],[11,"clone","","",0,[[["self"]],["flags"]]],[11,"partial_cmp","","",0,[[["self"],["flags"]],["option",["ordering"]]]],[11,"lt","","",0,[[["self"],["flags"]],["bool"]]],[11,"le","","",0,[[["self"],["flags"]],["bool"]]],[11,"gt","","",0,[[["self"],["flags"]],["bool"]]],[11,"ge","","",0,[[["self"],["flags"]],["bool"]]],[11,"cmp","","",0,[[["self"],["flags"]],["ordering"]]],[11,"hash","","",0,N],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"empty","","Returns an empty set of flags.",0,[[],["flags"]]],[11,"all","","Returns the set containing all flags.",0,[[],["flags"]]],[11,"bits","","Returns the raw value of the flags currently stored.",0,[[["self"]],["u32"]]],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",0,[[["u32"]],["option",["flags"]]]],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",0,[[["u32"]],["flags"]]],[11,"is_empty","","Returns `true` if no flags are currently stored.",0,[[["self"]],["bool"]]],[11,"is_all","","Returns `true` if all flags are currently set.",0,[[["self"]],["bool"]]],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",0,[[["self"],["flags"]],["bool"]]],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",0,[[["self"],["flags"]],["bool"]]],[11,"insert","","Inserts the specified flags in-place.",0,[[["self"],["flags"]]]],[11,"remove","","Removes the specified flags in-place.",0,[[["self"],["flags"]]]],[11,"toggle","","Toggles the specified flags in-place.",0,[[["self"],["flags"]]]],[11,"set","","Inserts or removes the specified flags depending on the passed value.",0,[[["self"],["flags"],["bool"]]]],[11,"bitor","","Returns the union of the two sets of flags.",0,[[["self"],["flags"]],["flags"]]],[11,"bitor_assign","","Adds the set of flags.",0,[[["self"],["flags"]]]],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",0,[[["self"],["flags"]],["flags"]]],[11,"bitxor_assign","","Toggles the set of flags.",0,[[["self"],["flags"]]]],[11,"bitand","","Returns the intersection between the two sets of flags.",0,[[["self"],["flags"]],["flags"]]],[11,"bitand_assign","","Disables all flags disabled in the set.",0,[[["self"],["flags"]]]],[11,"sub","","Returns the set difference of the two sets of flags.",0,[[["self"],["flags"]],["flags"]]],[11,"sub_assign","","Disables all flags enabled in the set.",0,[[["self"],["flags"]]]],[11,"not","","Returns the complement of this set of flags.",0,[[["self"]],["flags"]]],[11,"extend","","",0,[[["self"],["t"]]]],[11,"from_iter","","",0,[[["t"]],["flags"]]],[14,"bitflags","bitflags","The macro used to generate the flag structure.",N,N],[14,"__impl_bitflags","","",N,N],[11,"try_from","bitflags::example_generated","",0,[[["u"]],["result"]]],[11,"from","","",0,[[["t"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]]],"paths":[[3,"Flags"]]};
searchIndex["build_helper"]={"doc":"","items":[[3,"NativeLibBoilerplate","build_helper","",N,N],[12,"src_dir","","",0,N],[12,"out_dir","","",0,N],[5,"run","","",N,[[["command"]]]],[5,"run_silent","","",N,[[["command"]]]],[5,"try_run_silent","","",N,[[["command"]],["bool"]]],[5,"run_suppressed","","",N,[[["command"]]]],[5,"try_run_suppressed","","",N,[[["command"]],["bool"]]],[5,"gnu_target","","",N,[[["str"]],["string"]]],[5,"make","","",N,[[["str"]],["pathbuf"]]],[5,"output","","",N,[[["command"]],["string"]]],[5,"rerun_if_changed_anything_in_dir","","",N,[[["path"]]]],[5,"mtime","","Returns the last-modified time for `path`, or zero if it doesn't exist.",N,[[["path"]],["systemtime"]]],[5,"up_to_date","","Returns whether `dst` is up to date given that the file or files in `src` are used to generate it.",N,[[["path"],["path"]],["bool"]]],[5,"native_lib_boilerplate","","",N,[[["str"],["str"],["str"],["str"]],["result",["nativelibboilerplate"]]]],[5,"sanitizer_lib_boilerplate","","",N,[[["str"]],["result"]]],[5,"dir_up_to_date","","",N,[[["path"],["systemtime"]],["bool"]]],[5,"fail","","",N,N],[11,"drop","","",0,[[["self"]]]],[14,"t","","A helper macro to `unwrap` a result except also print out details like:",N,N],[11,"from","","",0,[[["t"]],["t"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]]],"paths":[[3,"NativeLibBoilerplate"]]};
searchIndex["fmt_macros"]={"doc":"Macro support for format strings","items":[[3,"Argument","fmt_macros","Representation of an argument specification.",N,N],[12,"position","","Where to find this argument",0,N],[12,"format","","How to format the argument",0,N],[3,"FormatSpec","","Specification for the formatting of an argument in the format string.",N,N],[12,"fill","","Optionally specified character to fill alignment with",1,N],[12,"align","","Optionally specified alignment",1,N],[12,"flags","","Packed version of various flags provided",1,N],[12,"precision","","The integer precision to use",1,N],[12,"width","","The string width requested for the resulting format",1,N],[12,"ty","","The descriptor string representing the name of the format desired for this argument, this can be empty or any number of characters, although it is required to be one word.",1,N],[3,"ParseError","","",N,N],[12,"description","","",2,N],[12,"note","","",2,N],[12,"label","","",2,N],[12,"start","","",2,N],[12,"end","","",2,N],[3,"Parser","","The parser structure for interpreting the input format string. This is modeled as an iterator over `Piece` structures to form a stream of tokens being output.",N,N],[12,"input","","",3,N],[12,"cur","","",3,N],[12,"errors","","Error messages accumulated during parsing",3,N],[12,"curarg","","Current position of implicit positional argument pointer",3,N],[12,"style","","`Some(raw count)` when the string is \"raw\", used to position spans correctly",3,N],[12,"seen_newlines","","How many newlines have been seen in the string so far, to adjust the error spans",3,N],[12,"arg_places","","Start and end byte offset of every successfully parsed argument",3,N],[4,"Piece","","A piece is a portion of the format string which represents the next part to emit. These are emitted as a stream by the `Parser` class.",N,N],[13,"String","","A literal string which should directly be emitted",4,N],[13,"NextArgument","","This describes that formatting should process the next argument (as specified inside) for emission.",4,N],[4,"Position","","Enum describing where an argument for a format can be located.",N,N],[13,"ArgumentImplicitlyIs","","The argument is implied to be located at an index",5,N],[13,"ArgumentIs","","The argument is located at a specific index given in the format",5,N],[13,"ArgumentNamed","","The argument has a name.",5,N],[4,"Alignment","","Enum of alignments which are supported.",N,N],[13,"AlignLeft","","The value will be aligned to the left.",6,N],[13,"AlignRight","","The value will be aligned to the right.",6,N],[13,"AlignCenter","","The value will be aligned in the center.",6,N],[13,"AlignUnknown","","The value will take on a default alignment.",6,N],[4,"Flag","","Various flags which can be applied to format strings. The meaning of these flags is defined by the formatters themselves.",N,N],[13,"FlagSignPlus","","A `+` will be used to denote positive numbers.",7,N],[13,"FlagSignMinus","","A `-` will be used to denote negative numbers. This is the default.",7,N],[13,"FlagAlternate","","An alternate form will be used for the value. In the case of numbers, this means that the number will be prefixed with the supplied string.",7,N],[13,"FlagSignAwareZeroPad","","For numbers, this means that the number will be padded with zeroes, and the sign (`+` or `-`) will precede them.",7,N],[13,"FlagDebugLowerHex","","For Debug / `?`, format integers in lower-case hexadecimal.",7,N],[13,"FlagDebugUpperHex","","For Debug / `?`, format integers in upper-case hexadecimal.",7,N],[4,"Count","","A count is used for the precision and width parameters of an integer, and can reference either an argument or a literal integer.",N,N],[13,"CountIs","","The count is specified explicitly.",8,N],[13,"CountIsName","","The count is specified by the argument with the given name.",8,N],[13,"CountIsParam","","The count is specified by the argument at the given index.",8,N],[13,"CountImplied","","The count is implied and cannot be explicitly specified.",8,N],[11,"clone","","",4,[[["self"]],["piece"]]],[11,"eq","","",4,[[["self"],["piece"]],["bool"]]],[11,"ne","","",4,[[["self"],["piece"]],["bool"]]],[11,"clone","","",0,[[["self"]],["argument"]]],[11,"eq","","",0,[[["self"],["argument"]],["bool"]]],[11,"ne","","",0,[[["self"],["argument"]],["bool"]]],[11,"clone","","",1,[[["self"]],["formatspec"]]],[11,"eq","","",1,[[["self"],["formatspec"]],["bool"]]],[11,"ne","","",1,[[["self"],["formatspec"]],["bool"]]],[11,"clone","","",5,[[["self"]],["position"]]],[11,"eq","","",5,[[["self"],["position"]],["bool"]]],[11,"ne","","",5,[[["self"],["position"]],["bool"]]],[11,"clone","","",6,[[["self"]],["alignment"]]],[11,"eq","","",6,[[["self"],["alignment"]],["bool"]]],[11,"clone","","",7,[[["self"]],["flag"]]],[11,"eq","","",7,[[["self"],["flag"]],["bool"]]],[11,"clone","","",8,[[["self"]],["count"]]],[11,"eq","","",8,[[["self"],["count"]],["bool"]]],[11,"ne","","",8,[[["self"],["count"]],["bool"]]],[11,"next","","",3,[[["self"]],["option",["piece"]]]],[11,"new","","Creates a new parser for the given format string",3,[[["str"],["option",["usize"]]],["parser"]]],[11,"err","","Notifies of an error. The message doesn't actually need to be of type String, but I think it does when this eventually uses conditions so it might as well start using it now.",3,[[["self"],["s1"],["s2"],["usize"],["usize"]]]],[11,"err_with_note","","Notifies of an error. The message doesn't actually need to be of type String, but I think it does when this eventually uses conditions so it might as well start using it now.",3,[[["self"],["s1"],["s2"],["s3"],["usize"],["usize"]]]],[11,"consume","","Optionally consumes the specified character. If the character is not at the current position, then the current iterator isn't moved and false is returned, otherwise the character is consumed and true is returned.",3,[[["self"],["char"]],["bool"]]],[11,"must_consume","","Forces consumption of the specified character. If the character is not found, an error is emitted.",3,[[["self"],["char"]],["option",["usize"]]]],[11,"ws","","Consumes all whitespace characters until the first non-whitespace character",3,[[["self"]]]],[11,"string","","Parses all of a string which is to be considered a \"raw literal\" in a format string. This is everything outside of the braces.",3,[[["self"],["usize"]],["str"]]],[11,"argument","","Parses an Argument structure, or what's contained within braces inside the format string",3,[[["self"]],["argument"]]],[11,"position","","Parses a positional argument for a format. This could either be an integer index of an argument, a named argument, or a blank string. Returns `Some(parsed_position)` if the position is not implicitly consuming a macro argument, `None` if it's the case.",3,[[["self"]],["option",["position"]]]],[11,"format","","Parses a format specifier at the current position, returning all of the relevant information in the FormatSpec struct.",3,[[["self"]],["formatspec"]]],[11,"count","","Parses a Count parameter at the current position. This does not check for 'CountIsNextParam' because that is only used in precision, not width.",3,[[["self"]],["count"]]],[11,"word","","Parses a word starting at the current position. A word is considered to be an alphabetic character followed by any number of alphanumeric characters.",3,[[["self"]],["str"]]],[11,"integer","","Optionally parses an integer at the current position. This doesn't deal with overflow at all, it's just accumulating digits.",3,[[["self"]],["option",["usize"]]]],[11,"to_owned","","",0,[[["self"]],["t"]]],[11,"clone_into","","",0,N],[11,"from","","",0,[[["t"]],["t"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"to_owned","","",1,[[["self"]],["t"]]],[11,"clone_into","","",1,N],[11,"from","","",1,[[["t"]],["t"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"from","","",2,[[["t"]],["t"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"from","","",3,[[["t"]],["t"]]],[11,"into_iter","","",3,[[["self"]],["i"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]],[11,"to_owned","","",4,[[["self"]],["t"]]],[11,"clone_into","","",4,N],[11,"from","","",4,[[["t"]],["t"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"to_owned","","",5,[[["self"]],["t"]]],[11,"clone_into","","",5,N],[11,"from","","",5,[[["t"]],["t"]]],[11,"into","","",5,[[["self"]],["u"]]],[11,"try_from","","",5,[[["u"]],["result"]]],[11,"borrow","","",5,[[["self"]],["t"]]],[11,"try_into","","",5,[[["self"]],["result"]]],[11,"borrow_mut","","",5,[[["self"]],["t"]]],[11,"get_type_id","","",5,[[["self"]],["typeid"]]],[11,"to_owned","","",6,[[["self"]],["t"]]],[11,"clone_into","","",6,N],[11,"from","","",6,[[["t"]],["t"]]],[11,"into","","",6,[[["self"]],["u"]]],[11,"try_from","","",6,[[["u"]],["result"]]],[11,"borrow","","",6,[[["self"]],["t"]]],[11,"try_into","","",6,[[["self"]],["result"]]],[11,"borrow_mut","","",6,[[["self"]],["t"]]],[11,"get_type_id","","",6,[[["self"]],["typeid"]]],[11,"to_owned","","",7,[[["self"]],["t"]]],[11,"clone_into","","",7,N],[11,"from","","",7,[[["t"]],["t"]]],[11,"into","","",7,[[["self"]],["u"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"try_into","","",7,[[["self"]],["result"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"get_type_id","","",7,[[["self"]],["typeid"]]],[11,"to_owned","","",8,[[["self"]],["t"]]],[11,"clone_into","","",8,N],[11,"from","","",8,[[["t"]],["t"]]],[11,"into","","",8,[[["self"]],["u"]]],[11,"try_from","","",8,[[["u"]],["result"]]],[11,"borrow","","",8,[[["self"]],["t"]]],[11,"try_into","","",8,[[["self"]],["result"]]],[11,"borrow_mut","","",8,[[["self"]],["t"]]],[11,"get_type_id","","",8,[[["self"]],["typeid"]]]],"paths":[[3,"Argument"],[3,"FormatSpec"],[3,"ParseError"],[3,"Parser"],[4,"Piece"],[4,"Position"],[4,"Alignment"],[4,"Flag"],[4,"Count"]]};
searchIndex["graphviz"]={"doc":"Generate files suitable for use with Graphviz","items":[[3,"Id","graphviz","`Id` is a Graphviz `ID`.",N,N],[12,"name","","",0,N],[4,"LabelText","","The text for a graphviz label on a node or edge.",N,N],[13,"LabelStr","","This kind of label preserves the text directly as is.",1,N],[13,"EscStr","","This kind of label uses the graphviz label escString type: http://www.graphviz.org/content/attrs#kescString",1,N],[13,"HtmlStr","","This uses a graphviz [HTML string label][html]. The string is printed exactly as given, but between `<` and `>`. No escaping is performed.",1,N],[4,"Style","","The style for a node or edge. See http://www.graphviz.org/doc/info/attrs.html#k:style for descriptions. Note that some of these are not valid for edges.",N,N],[13,"None","","",2,N],[13,"Solid","","",2,N],[13,"Dashed","","",2,N],[13,"Dotted","","",2,N],[13,"Bold","","",2,N],[13,"Rounded","","",2,N],[13,"Diagonals","","",2,N],[13,"Filled","","",2,N],[13,"Striped","","",2,N],[13,"Wedged","","",2,N],[4,"RenderOption","","",N,N],[13,"NoEdgeLabels","","",3,N],[13,"NoNodeLabels","","",3,N],[13,"NoEdgeStyles","","",3,N],[13,"NoNodeStyles","","",3,N],[5,"escape_html","","Escape tags in such a way that it is suitable for inclusion in a Graphviz HTML label.",N,[[["str"]],["string"]]],[5,"default_options","","Returns vec holding all the default render options.",N,[[],["vec",["renderoption"]]]],[5,"render","","Renders directed graph `g` into the writer `w` in DOT syntax. (Simple wrapper around `render_opts` that passes a default set of options.)",N,[[["g"],["w"]],["result"]]],[5,"render_opts","","Renders directed graph `g` into the writer `w` in DOT syntax. (Main entry point for the library.)",N,N],[6,"Nodes","","",N,N],[6,"Edges","","",N,N],[8,"Labeller","","Each instance of a type that implements `Label<C>` maps to a unique identifier with respect to `C`, which is used to identify it in the generated .dot file. They can also provide more elaborate (and non-unique) label text that is used in the graphviz rendered output. The graph instance is responsible for providing the DOT compatible identifiers for the nodes and (optionally) rendered labels for the nodes and edges, as well as an identifier for the graph itself.",N,N],[16,"Node","","",4,N],[16,"Edge","","",4,N],[10,"graph_id","","Must return a DOT compatible identifier naming the graph.",4,[[["self"]],["id"]]],[10,"node_id","","Maps `n` to a unique identifier with respect to `self`. The implementor is responsible for ensuring that the returned name is a valid DOT identifier.",4,N],[11,"node_shape","","Maps `n` to one of the [graphviz `shape` names][1]. If `None` is returned, no `shape` attribute is specified.",4,N],[11,"node_label","","Maps `n` to a label that will be used in the rendered output. The label need not be unique, and may be the empty string; the default is just the output from `node_id`.",4,N],[11,"edge_label","","Maps `e` to a label that will be used in the rendered output. The label need not be unique, and may be the empty string; the default is in fact the empty string.",4,N],[11,"node_style","","Maps `n` to a style that will be used in the rendered output.",4,N],[11,"edge_style","","Maps `e` to a style that will be used in the rendered output.",4,N],[8,"GraphWalk","","GraphWalk is an abstraction over a directed graph = (nodes,edges) made up of node handles `N` and edge handles `E`, where each `E` can be mapped to its source and target nodes.",N,N],[16,"Node","","",5,N],[16,"Edge","","",5,N],[10,"nodes","","Returns all the nodes in this graph.",5,[[["self"]],["nodes"]]],[10,"edges","","Returns all of the edges in this graph.",5,[[["self"]],["edges"]]],[10,"source","","The source node for `edge`.",5,N],[10,"target","","The target node for `edge`.",5,N],[8,"IntoCow","","",N,N],[10,"into_cow","","",6,[[["self"]],["cow"]]],[11,"clone","","",2,[[["self"]],["style"]]],[11,"eq","","",2,[[["self"],["style"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",2,N],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"as_slice","","",2,[[["self"]],["str"]]],[11,"new","","Creates an `Id` named `name`.",0,[[["name"]],["result",["id"]]]],[11,"as_slice","","",0,[[["self"]],["str"]]],[11,"name","","",0,[[["self"]],["cow",["str"]]]],[11,"label","","",1,[[["s"]],["labeltext"]]],[11,"escaped","","",1,[[["s"]],["labeltext"]]],[11,"html","","",1,[[["s"]],["labeltext"]]],[11,"escape_char","","",1,[[["char"],["f"]]]],[11,"escape_str","","",1,[[["str"]],["string"]]],[11,"to_dot_string","","Renders text as string suitable for a label in a .dot file. This includes quotes or suitable delimiters.",1,[[["self"]],["string"]]],[11,"pre_escaped_content","","Decomposes content into string suitable for making EscStr that yields same content as self.  The result obeys the law render(`lt`) == render(`EscStr(lt.pre_escaped_content())`) for all `lt: LabelText`.",1,[[["self"]],["cow",["str"]]]],[11,"prefix_line","","Puts `prefix` on a line above this label, with a blank line separator.",1,[[["self"],["labeltext"]],["labeltext"]]],[11,"suffix_line","","Puts `suffix` on a line below this label, with a blank line separator.",1,[[["self"],["labeltext"]],["labeltext"]]],[11,"clone","","",3,[[["self"]],["renderoption"]]],[11,"eq","","",3,[[["self"],["renderoption"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",3,N],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"from","","",0,[[["t"]],["t"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"from","","",1,[[["t"]],["t"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"to_owned","","",2,[[["self"]],["t"]]],[11,"clone_into","","",2,N],[11,"from","","",2,[[["t"]],["t"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"to_owned","","",3,[[["self"]],["t"]]],[11,"clone_into","","",3,N],[11,"from","","",3,[[["t"]],["t"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]]],"paths":[[3,"Id"],[4,"LabelText"],[4,"Style"],[4,"RenderOption"],[8,"Labeller"],[8,"GraphWalk"],[8,"IntoCow"]]};
searchIndex["libc"]={"doc":"Crate docs","items":[[3,"group","libc","",N,N],[12,"gr_name","","",0,N],[12,"gr_passwd","","",0,N],[12,"gr_gid","","",0,N],[12,"gr_mem","","",0,N],[3,"utimbuf","","",N,N],[12,"actime","","",1,N],[12,"modtime","","",1,N],[3,"timeval","","",N,N],[12,"tv_sec","","",2,N],[12,"tv_usec","","",2,N],[3,"timespec","","",N,N],[12,"tv_sec","","",3,N],[12,"tv_nsec","","",3,N],[3,"rlimit","","",N,N],[12,"rlim_cur","","",4,N],[12,"rlim_max","","",4,N],[3,"rusage","","",N,N],[12,"ru_utime","","",5,N],[12,"ru_stime","","",5,N],[12,"ru_maxrss","","",5,N],[12,"ru_ixrss","","",5,N],[12,"ru_idrss","","",5,N],[12,"ru_isrss","","",5,N],[12,"ru_minflt","","",5,N],[12,"ru_majflt","","",5,N],[12,"ru_nswap","","",5,N],[12,"ru_inblock","","",5,N],[12,"ru_oublock","","",5,N],[12,"ru_msgsnd","","",5,N],[12,"ru_msgrcv","","",5,N],[12,"ru_nsignals","","",5,N],[12,"ru_nvcsw","","",5,N],[12,"ru_nivcsw","","",5,N],[3,"in_addr","","",N,N],[12,"s_addr","","",6,N],[3,"in6_addr","","",N,N],[12,"s6_addr","","",7,N],[12,"__align","","",7,N],[3,"ip_mreq","","",N,N],[12,"imr_multiaddr","","",8,N],[12,"imr_interface","","",8,N],[3,"ipv6_mreq","","",N,N],[12,"ipv6mr_multiaddr","","",9,N],[12,"ipv6mr_interface","","",9,N],[3,"hostent","","",N,N],[12,"h_name","","",10,N],[12,"h_aliases","","",10,N],[12,"h_addrtype","","",10,N],[12,"h_length","","",10,N],[12,"h_addr_list","","",10,N],[3,"iovec","","",N,N],[12,"iov_base","","",11,N],[12,"iov_len","","",11,N],[3,"pollfd","","",N,N],[12,"fd","","",12,N],[12,"events","","",12,N],[12,"revents","","",12,N],[3,"winsize","","",N,N],[12,"ws_row","","",13,N],[12,"ws_col","","",13,N],[12,"ws_xpixel","","",13,N],[12,"ws_ypixel","","",13,N],[3,"linger","","",N,N],[12,"l_onoff","","",14,N],[12,"l_linger","","",14,N],[3,"sigval","","",N,N],[12,"sival_ptr","","",15,N],[3,"itimerval","","",N,N],[12,"it_interval","","",16,N],[12,"it_value","","",16,N],[3,"tms","","",N,N],[12,"tms_utime","","",17,N],[12,"tms_stime","","",17,N],[12,"tms_cutime","","",17,N],[12,"tms_cstime","","",17,N],[3,"servent","","",N,N],[12,"s_name","","",18,N],[12,"s_aliases","","",18,N],[12,"s_port","","",18,N],[12,"s_proto","","",18,N],[3,"protoent","","",N,N],[12,"p_name","","",19,N],[12,"p_aliases","","",19,N],[12,"p_proto","","",19,N],[3,"sockaddr","","",N,N],[12,"sa_family","","",20,N],[12,"sa_data","","",20,N],[3,"sockaddr_in","","",N,N],[12,"sin_family","","",21,N],[12,"sin_port","","",21,N],[12,"sin_addr","","",21,N],[12,"sin_zero","","",21,N],[3,"sockaddr_in6","","",N,N],[12,"sin6_family","","",22,N],[12,"sin6_port","","",22,N],[12,"sin6_flowinfo","","",22,N],[12,"sin6_addr","","",22,N],[12,"sin6_scope_id","","",22,N],[3,"sockaddr_un","","",N,N],[12,"sun_family","","",23,N],[12,"sun_path","","",23,N],[3,"sockaddr_storage","","",N,N],[12,"ss_family","","",24,N],[12,"__ss_align","","",24,N],[12,"__ss_pad2","","",24,N],[3,"addrinfo","","",N,N],[12,"ai_flags","","",25,N],[12,"ai_family","","",25,N],[12,"ai_socktype","","",25,N],[12,"ai_protocol","","",25,N],[12,"ai_addrlen","","",25,N],[12,"ai_addr","","",25,N],[12,"ai_canonname","","",25,N],[12,"ai_next","","",25,N],[3,"sockaddr_nl","","",N,N],[12,"nl_family","","",26,N],[12,"nl_pad","","",26,N],[12,"nl_pid","","",26,N],[12,"nl_groups","","",26,N],[3,"sockaddr_ll","","",N,N],[12,"sll_family","","",27,N],[12,"sll_protocol","","",27,N],[12,"sll_ifindex","","",27,N],[12,"sll_hatype","","",27,N],[12,"sll_pkttype","","",27,N],[12,"sll_halen","","",27,N],[12,"sll_addr","","",27,N],[3,"fd_set","","",N,N],[12,"fds_bits","","",28,N],[3,"tm","","",N,N],[12,"tm_sec","","",29,N],[12,"tm_min","","",29,N],[12,"tm_hour","","",29,N],[12,"tm_mday","","",29,N],[12,"tm_mon","","",29,N],[12,"tm_year","","",29,N],[12,"tm_wday","","",29,N],[12,"tm_yday","","",29,N],[12,"tm_isdst","","",29,N],[12,"tm_gmtoff","","",29,N],[12,"tm_zone","","",29,N],[3,"sched_param","","",N,N],[12,"sched_priority","","",30,N],[3,"Dl_info","","",N,N],[12,"dli_fname","","",31,N],[12,"dli_fbase","","",31,N],[12,"dli_sname","","",31,N],[12,"dli_saddr","","",31,N],[3,"epoll_event","","",N,N],[12,"events","","",32,N],[12,"u64","","",32,N],[3,"utsname","","",N,N],[12,"sysname","","",33,N],[12,"nodename","","",33,N],[12,"release","","",33,N],[12,"version","","",33,N],[12,"machine","","",33,N],[12,"domainname","","",33,N],[3,"lconv","","",N,N],[12,"decimal_point","","",34,N],[12,"thousands_sep","","",34,N],[12,"grouping","","",34,N],[12,"int_curr_symbol","","",34,N],[12,"currency_symbol","","",34,N],[12,"mon_decimal_point","","",34,N],[12,"mon_thousands_sep","","",34,N],[12,"mon_grouping","","",34,N],[12,"positive_sign","","",34,N],[12,"negative_sign","","",34,N],[12,"int_frac_digits","","",34,N],[12,"frac_digits","","",34,N],[12,"p_cs_precedes","","",34,N],[12,"p_sep_by_space","","",34,N],[12,"n_cs_precedes","","",34,N],[12,"n_sep_by_space","","",34,N],[12,"p_sign_posn","","",34,N],[12,"n_sign_posn","","",34,N],[12,"int_p_cs_precedes","","",34,N],[12,"int_p_sep_by_space","","",34,N],[12,"int_n_cs_precedes","","",34,N],[12,"int_n_sep_by_space","","",34,N],[12,"int_p_sign_posn","","",34,N],[12,"int_n_sign_posn","","",34,N],[3,"sigevent","","",N,N],[12,"sigev_value","","",35,N],[12,"sigev_signo","","",35,N],[12,"sigev_notify","","",35,N],[12,"sigev_notify_thread_id","","",35,N],[12,"__unused1","","",35,N],[3,"in_pktinfo","","",N,N],[12,"ipi_ifindex","","",36,N],[12,"ipi_spec_dst","","",36,N],[12,"ipi_addr","","",36,N],[3,"ifaddrs","","",N,N],[12,"ifa_next","","",37,N],[12,"ifa_name","","",37,N],[12,"ifa_flags","","",37,N],[12,"ifa_addr","","",37,N],[12,"ifa_netmask","","",37,N],[12,"ifa_ifu","","",37,N],[12,"ifa_data","","",37,N],[3,"in6_rtmsg","","",N,N],[12,"rtmsg_dst","","",38,N],[12,"rtmsg_src","","",38,N],[12,"rtmsg_gateway","","",38,N],[12,"rtmsg_type","","",38,N],[12,"rtmsg_dst_len","","",38,N],[12,"rtmsg_src_len","","",38,N],[12,"rtmsg_metric","","",38,N],[12,"rtmsg_info","","",38,N],[12,"rtmsg_flags","","",38,N],[12,"rtmsg_ifindex","","",38,N],[3,"arpreq","","",N,N],[12,"arp_pa","","",39,N],[12,"arp_ha","","",39,N],[12,"arp_flags","","",39,N],[12,"arp_netmask","","",39,N],[12,"arp_dev","","",39,N],[3,"arpreq_old","","",N,N],[12,"arp_pa","","",40,N],[12,"arp_ha","","",40,N],[12,"arp_flags","","",40,N],[12,"arp_netmask","","",40,N],[3,"arphdr","","",N,N],[12,"ar_hrd","","",41,N],[12,"ar_pro","","",41,N],[12,"ar_hln","","",41,N],[12,"ar_pln","","",41,N],[12,"ar_op","","",41,N],[3,"dirent","","",N,N],[12,"d_ino","","",42,N],[12,"d_off","","",42,N],[12,"d_reclen","","",42,N],[12,"d_type","","",42,N],[12,"d_name","","",42,N],[3,"dirent64","","",N,N],[12,"d_ino","","",43,N],[12,"d_off","","",43,N],[12,"d_reclen","","",43,N],[12,"d_type","","",43,N],[12,"d_name","","",43,N],[3,"rlimit64","","",N,N],[12,"rlim_cur","","",44,N],[12,"rlim_max","","",44,N],[3,"glob_t","","",N,N],[12,"gl_pathc","","",45,N],[12,"gl_pathv","","",45,N],[12,"gl_offs","","",45,N],[12,"gl_flags","","",45,N],[12,"__unused1","","",45,N],[12,"__unused2","","",45,N],[12,"__unused3","","",45,N],[12,"__unused4","","",45,N],[12,"__unused5","","",45,N],[3,"pthread_mutex_t","","",N,N],[12,"__align","","",46,N],[12,"size","","",46,N],[3,"pthread_rwlock_t","","",N,N],[12,"__align","","",47,N],[12,"size","","",47,N],[3,"pthread_mutexattr_t","","",N,N],[12,"__align","","",48,N],[12,"size","","",48,N],[3,"pthread_rwlockattr_t","","",N,N],[12,"__align","","",49,N],[12,"size","","",49,N],[3,"pthread_cond_t","","",N,N],[12,"__align","","",50,N],[12,"size","","",50,N],[3,"pthread_condattr_t","","",N,N],[12,"__align","","",51,N],[12,"size","","",51,N],[3,"passwd","","",N,N],[12,"pw_name","","",52,N],[12,"pw_passwd","","",52,N],[12,"pw_uid","","",52,N],[12,"pw_gid","","",52,N],[12,"pw_gecos","","",52,N],[12,"pw_dir","","",52,N],[12,"pw_shell","","",52,N],[3,"spwd","","",N,N],[12,"sp_namp","","",53,N],[12,"sp_pwdp","","",53,N],[12,"sp_lstchg","","",53,N],[12,"sp_min","","",53,N],[12,"sp_max","","",53,N],[12,"sp_warn","","",53,N],[12,"sp_inact","","",53,N],[12,"sp_expire","","",53,N],[12,"sp_flag","","",53,N],[3,"dqblk","","",N,N],[12,"dqb_bhardlimit","","",54,N],[12,"dqb_bsoftlimit","","",54,N],[12,"dqb_curspace","","",54,N],[12,"dqb_ihardlimit","","",54,N],[12,"dqb_isoftlimit","","",54,N],[12,"dqb_curinodes","","",54,N],[12,"dqb_btime","","",54,N],[12,"dqb_itime","","",54,N],[12,"dqb_valid","","",54,N],[3,"signalfd_siginfo","","",N,N],[12,"ssi_signo","","",55,N],[12,"ssi_errno","","",55,N],[12,"ssi_code","","",55,N],[12,"ssi_pid","","",55,N],[12,"ssi_uid","","",55,N],[12,"ssi_fd","","",55,N],[12,"ssi_tid","","",55,N],[12,"ssi_band","","",55,N],[12,"ssi_overrun","","",55,N],[12,"ssi_trapno","","",55,N],[12,"ssi_status","","",55,N],[12,"ssi_int","","",55,N],[12,"ssi_ptr","","",55,N],[12,"ssi_utime","","",55,N],[12,"ssi_stime","","",55,N],[12,"ssi_addr","","",55,N],[12,"_pad","","",55,N],[3,"itimerspec","","",N,N],[12,"it_interval","","",56,N],[12,"it_value","","",56,N],[3,"fsid_t","","",N,N],[12,"__val","","",57,N],[3,"mq_attr","","",N,N],[12,"mq_flags","","",58,N],[12,"mq_maxmsg","","",58,N],[12,"mq_msgsize","","",58,N],[12,"mq_curmsgs","","",58,N],[12,"pad","","",58,N],[3,"packet_mreq","","",N,N],[12,"mr_ifindex","","",59,N],[12,"mr_type","","",59,N],[12,"mr_alen","","",59,N],[12,"mr_address","","",59,N],[3,"cpu_set_t","","",N,N],[12,"bits","","",60,N],[3,"if_nameindex","","",N,N],[12,"if_index","","",61,N],[12,"if_name","","",61,N],[3,"msginfo","","",N,N],[12,"msgpool","","",62,N],[12,"msgmap","","",62,N],[12,"msgmax","","",62,N],[12,"msgmnb","","",62,N],[12,"msgmni","","",62,N],[12,"msgssz","","",62,N],[12,"msgtql","","",62,N],[12,"msgseg","","",62,N],[3,"mmsghdr","","",N,N],[12,"msg_hdr","","",63,N],[12,"msg_len","","",63,N],[3,"sembuf","","",N,N],[12,"sem_num","","",64,N],[12,"sem_op","","",64,N],[12,"sem_flg","","",64,N],[3,"input_event","","",N,N],[12,"time","","",65,N],[12,"type_","","",65,N],[12,"code","","",65,N],[12,"value","","",65,N],[3,"input_id","","",N,N],[12,"bustype","","",66,N],[12,"vendor","","",66,N],[12,"product","","",66,N],[12,"version","","",66,N],[3,"input_absinfo","","",N,N],[12,"value","","",67,N],[12,"minimum","","",67,N],[12,"maximum","","",67,N],[12,"fuzz","","",67,N],[12,"flat","","",67,N],[12,"resolution","","",67,N],[3,"input_keymap_entry","","",N,N],[12,"flags","","",68,N],[12,"len","","",68,N],[12,"index","","",68,N],[12,"keycode","","",68,N],[12,"scancode","","",68,N],[3,"input_mask","","",N,N],[12,"type_","","",69,N],[12,"codes_size","","",69,N],[12,"codes_ptr","","",69,N],[3,"ff_replay","","",N,N],[12,"length","","",70,N],[12,"delay","","",70,N],[3,"ff_trigger","","",N,N],[12,"button","","",71,N],[12,"interval","","",71,N],[3,"ff_envelope","","",N,N],[12,"attack_length","","",72,N],[12,"attack_level","","",72,N],[12,"fade_length","","",72,N],[12,"fade_level","","",72,N],[3,"ff_constant_effect","","",N,N],[12,"level","","",73,N],[12,"envelope","","",73,N],[3,"ff_ramp_effect","","",N,N],[12,"start_level","","",74,N],[12,"end_level","","",74,N],[12,"envelope","","",74,N],[3,"ff_condition_effect","","",N,N],[12,"right_saturation","","",75,N],[12,"left_saturation","","",75,N],[12,"right_coeff","","",75,N],[12,"left_coeff","","",75,N],[12,"deadband","","",75,N],[12,"center","","",75,N],[3,"ff_periodic_effect","","",N,N],[12,"waveform","","",76,N],[12,"period","","",76,N],[12,"magnitude","","",76,N],[12,"offset","","",76,N],[12,"phase","","",76,N],[12,"envelope","","",76,N],[12,"custom_len","","",76,N],[12,"custom_data","","",76,N],[3,"ff_rumble_effect","","",N,N],[12,"strong_magnitude","","",77,N],[12,"weak_magnitude","","",77,N],[3,"ff_effect","","",N,N],[12,"type_","","",78,N],[12,"id","","",78,N],[12,"direction","","",78,N],[12,"trigger","","",78,N],[12,"replay","","",78,N],[12,"u","","",78,N],[3,"dl_phdr_info","","",N,N],[12,"dlpi_addr","","",79,N],[12,"dlpi_name","","",79,N],[12,"dlpi_phdr","","",79,N],[12,"dlpi_phnum","","",79,N],[12,"dlpi_adds","","",79,N],[12,"dlpi_subs","","",79,N],[12,"dlpi_tls_modid","","",79,N],[12,"dlpi_tls_data","","",79,N],[3,"Elf32_Phdr","","",N,N],[12,"p_type","","",80,N],[12,"p_offset","","",80,N],[12,"p_vaddr","","",80,N],[12,"p_paddr","","",80,N],[12,"p_filesz","","",80,N],[12,"p_memsz","","",80,N],[12,"p_flags","","",80,N],[12,"p_align","","",80,N],[3,"Elf64_Phdr","","",N,N],[12,"p_type","","",81,N],[12,"p_flags","","",81,N],[12,"p_offset","","",81,N],[12,"p_vaddr","","",81,N],[12,"p_paddr","","",81,N],[12,"p_filesz","","",81,N],[12,"p_memsz","","",81,N],[12,"p_align","","",81,N],[3,"ucred","","",N,N],[12,"pid","","",82,N],[12,"uid","","",82,N],[12,"gid","","",82,N],[3,"mntent","","",N,N],[12,"mnt_fsname","","",83,N],[12,"mnt_dir","","",83,N],[12,"mnt_type","","",83,N],[12,"mnt_opts","","",83,N],[12,"mnt_freq","","",83,N],[12,"mnt_passno","","",83,N],[3,"posix_spawn_file_actions_t","","",N,N],[12,"__allocated","","",84,N],[12,"__used","","",84,N],[12,"__actions","","",84,N],[12,"__pad","","",84,N],[3,"posix_spawnattr_t","","",N,N],[12,"__flags","","",85,N],[12,"__pgrp","","",85,N],[12,"__sd","","",85,N],[12,"__ss","","",85,N],[12,"__sp","","",85,N],[12,"__policy","","",85,N],[12,"__pad","","",85,N],[3,"genlmsghdr","","",N,N],[12,"cmd","","",86,N],[12,"version","","",86,N],[12,"reserved","","",86,N],[3,"in6_pktinfo","","",N,N],[12,"ipi6_addr","","",87,N],[12,"ipi6_ifindex","","",87,N],[3,"arpd_request","","",N,N],[12,"req","","",88,N],[12,"ip","","",88,N],[12,"dev","","",88,N],[12,"stamp","","",88,N],[12,"updated","","",88,N],[12,"ha","","",88,N],[3,"aiocb","","",N,N],[12,"aio_fildes","","",89,N],[12,"aio_lio_opcode","","",89,N],[12,"aio_reqprio","","",89,N],[12,"aio_buf","","",89,N],[12,"aio_nbytes","","",89,N],[12,"aio_sigevent","","",89,N],[12,"__next_prio","","",89,N],[12,"__abs_prio","","",89,N],[12,"__policy","","",89,N],[12,"__error_code","","",89,N],[12,"__return_value","","",89,N],[12,"aio_offset","","",89,N],[12,"__glibc_reserved","","",89,N],[3,"__exit_status","","",N,N],[12,"e_termination","","",90,N],[12,"e_exit","","",90,N],[3,"__timeval","","",N,N],[12,"tv_sec","","",91,N],[12,"tv_usec","","",91,N],[3,"utmpx","","",N,N],[12,"ut_type","","",92,N],[12,"ut_pid","","",92,N],[12,"ut_line","","",92,N],[12,"ut_id","","",92,N],[12,"ut_user","","",92,N],[12,"ut_host","","",92,N],[12,"ut_exit","","",92,N],[12,"ut_session","","",92,N],[12,"ut_tv","","",92,N],[12,"ut_addr_v6","","",92,N],[12,"__glibc_reserved","","",92,N],[3,"sigaction","","",N,N],[12,"sa_sigaction","","",93,N],[12,"sa_mask","","",93,N],[12,"sa_flags","","",93,N],[12,"sa_restorer","","",93,N],[3,"stack_t","","",N,N],[12,"ss_sp","","",94,N],[12,"ss_flags","","",94,N],[12,"ss_size","","",94,N],[3,"siginfo_t","","",N,N],[12,"si_signo","","",95,N],[12,"si_errno","","",95,N],[12,"si_code","","",95,N],[12,"_pad","","",95,N],[12,"_align","","",95,N],[3,"glob64_t","","",N,N],[12,"gl_pathc","","",96,N],[12,"gl_pathv","","",96,N],[12,"gl_offs","","",96,N],[12,"gl_flags","","",96,N],[12,"__unused1","","",96,N],[12,"__unused2","","",96,N],[12,"__unused3","","",96,N],[12,"__unused4","","",96,N],[12,"__unused5","","",96,N],[3,"statfs","","",N,N],[12,"f_type","","",97,N],[12,"f_bsize","","",97,N],[12,"f_blocks","","",97,N],[12,"f_bfree","","",97,N],[12,"f_bavail","","",97,N],[12,"f_files","","",97,N],[12,"f_ffree","","",97,N],[12,"f_fsid","","",97,N],[12,"f_namelen","","",97,N],[12,"f_frsize","","",97,N],[12,"f_spare","","",97,N],[3,"msghdr","","",N,N],[12,"msg_name","","",98,N],[12,"msg_namelen","","",98,N],[12,"msg_iov","","",98,N],[12,"msg_iovlen","","",98,N],[12,"msg_control","","",98,N],[12,"msg_controllen","","",98,N],[12,"msg_flags","","",98,N],[3,"cmsghdr","","",N,N],[12,"cmsg_len","","",99,N],[12,"cmsg_level","","",99,N],[12,"cmsg_type","","",99,N],[3,"termios","","",N,N],[12,"c_iflag","","",100,N],[12,"c_oflag","","",100,N],[12,"c_cflag","","",100,N],[12,"c_lflag","","",100,N],[12,"c_line","","",100,N],[12,"c_cc","","",100,N],[12,"c_ispeed","","",100,N],[12,"c_ospeed","","",100,N],[3,"flock","","",N,N],[12,"l_type","","",101,N],[12,"l_whence","","",101,N],[12,"l_start","","",101,N],[12,"l_len","","",101,N],[12,"l_pid","","",101,N],[3,"sem_t","","",N,N],[12,"__size","","",102,N],[12,"__align","","",102,N],[3,"mallinfo","","",N,N],[12,"arena","","",103,N],[12,"ordblks","","",103,N],[12,"smblks","","",103,N],[12,"hblks","","",103,N],[12,"hblkhd","","",103,N],[12,"usmblks","","",103,N],[12,"fsmblks","","",103,N],[12,"uordblks","","",103,N],[12,"fordblks","","",103,N],[12,"keepcost","","",103,N],[3,"nlmsghdr","","",N,N],[12,"nlmsg_len","","",104,N],[12,"nlmsg_type","","",104,N],[12,"nlmsg_flags","","",104,N],[12,"nlmsg_seq","","",104,N],[12,"nlmsg_pid","","",104,N],[3,"nlmsgerr","","",N,N],[12,"error","","",105,N],[12,"msg","","",105,N],[3,"nl_pktinfo","","",N,N],[12,"group","","",106,N],[3,"nl_mmap_req","","",N,N],[12,"nm_block_size","","",107,N],[12,"nm_block_nr","","",107,N],[12,"nm_frame_size","","",107,N],[12,"nm_frame_nr","","",107,N],[3,"nl_mmap_hdr","","",N,N],[12,"nm_status","","",108,N],[12,"nm_len","","",108,N],[12,"nm_group","","",108,N],[12,"nm_pid","","",108,N],[12,"nm_uid","","",108,N],[12,"nm_gid","","",108,N],[3,"nlattr","","",N,N],[12,"nla_len","","",109,N],[12,"nla_type","","",109,N],[3,"rtentry","","",N,N],[12,"rt_pad1","","",110,N],[12,"rt_dst","","",110,N],[12,"rt_gateway","","",110,N],[12,"rt_genmask","","",110,N],[12,"rt_flags","","",110,N],[12,"rt_pad2","","",110,N],[12,"rt_pad3","","",110,N],[12,"rt_tos","","",110,N],[12,"rt_class","","",110,N],[12,"rt_pad4","","",110,N],[12,"rt_metric","","",110,N],[12,"rt_dev","","",110,N],[12,"rt_mtu","","",110,N],[12,"rt_window","","",110,N],[12,"rt_irtt","","",110,N],[3,"sigset_t","","",N,N],[12,"__val","","",111,N],[3,"sysinfo","","",N,N],[12,"uptime","","",112,N],[12,"loads","","",112,N],[12,"totalram","","",112,N],[12,"freeram","","",112,N],[12,"sharedram","","",112,N],[12,"bufferram","","",112,N],[12,"totalswap","","",112,N],[12,"freeswap","","",112,N],[12,"procs","","",112,N],[12,"pad","","",112,N],[12,"totalhigh","","",112,N],[12,"freehigh","","",112,N],[12,"mem_unit","","",112,N],[12,"_f","","",112,N],[3,"msqid_ds","","",N,N],[12,"msg_perm","","",113,N],[12,"msg_stime","","",113,N],[12,"msg_rtime","","",113,N],[12,"msg_ctime","","",113,N],[12,"__msg_cbytes","","",113,N],[12,"msg_qnum","","",113,N],[12,"msg_qbytes","","",113,N],[12,"msg_lspid","","",113,N],[12,"msg_lrpid","","",113,N],[12,"__glibc_reserved4","","",113,N],[12,"__glibc_reserved5","","",113,N],[3,"stat","","",N,N],[12,"st_dev","","",114,N],[12,"st_ino","","",114,N],[12,"st_nlink","","",114,N],[12,"st_mode","","",114,N],[12,"st_uid","","",114,N],[12,"st_gid","","",114,N],[12,"__pad0","","",114,N],[12,"st_rdev","","",114,N],[12,"st_size","","",114,N],[12,"st_blksize","","",114,N],[12,"st_blocks","","",114,N],[12,"st_atime","","",114,N],[12,"st_atime_nsec","","",114,N],[12,"st_mtime","","",114,N],[12,"st_mtime_nsec","","",114,N],[12,"st_ctime","","",114,N],[12,"st_ctime_nsec","","",114,N],[12,"__unused","","",114,N],[3,"stat64","","",N,N],[12,"st_dev","","",115,N],[12,"st_ino","","",115,N],[12,"st_nlink","","",115,N],[12,"st_mode","","",115,N],[12,"st_uid","","",115,N],[12,"st_gid","","",115,N],[12,"__pad0","","",115,N],[12,"st_rdev","","",115,N],[12,"st_size","","",115,N],[12,"st_blksize","","",115,N],[12,"st_blocks","","",115,N],[12,"st_atime","","",115,N],[12,"st_atime_nsec","","",115,N],[12,"st_mtime","","",115,N],[12,"st_mtime_nsec","","",115,N],[12,"st_ctime","","",115,N],[12,"st_ctime_nsec","","",115,N],[12,"__reserved","","",115,N],[3,"statfs64","","",N,N],[12,"f_type","","",116,N],[12,"f_bsize","","",116,N],[12,"f_blocks","","",116,N],[12,"f_bfree","","",116,N],[12,"f_bavail","","",116,N],[12,"f_files","","",116,N],[12,"f_ffree","","",116,N],[12,"f_fsid","","",116,N],[12,"f_namelen","","",116,N],[12,"f_frsize","","",116,N],[12,"f_flags","","",116,N],[12,"f_spare","","",116,N],[3,"statvfs64","","",N,N],[12,"f_bsize","","",117,N],[12,"f_frsize","","",117,N],[12,"f_blocks","","",117,N],[12,"f_bfree","","",117,N],[12,"f_bavail","","",117,N],[12,"f_files","","",117,N],[12,"f_ffree","","",117,N],[12,"f_favail","","",117,N],[12,"f_fsid","","",117,N],[12,"f_flag","","",117,N],[12,"f_namemax","","",117,N],[12,"__f_spare","","",117,N],[3,"pthread_attr_t","","",N,N],[12,"__size","","",118,N],[3,"_libc_fpxreg","","",N,N],[12,"significand","","",119,N],[12,"exponent","","",119,N],[12,"__private","","",119,N],[3,"_libc_xmmreg","","",N,N],[12,"element","","",120,N],[3,"_libc_fpstate","","",N,N],[12,"cwd","","",121,N],[12,"swd","","",121,N],[12,"ftw","","",121,N],[12,"fop","","",121,N],[12,"rip","","",121,N],[12,"rdp","","",121,N],[12,"mxcsr","","",121,N],[12,"mxcr_mask","","",121,N],[12,"_st","","",121,N],[12,"_xmm","","",121,N],[12,"__private","","",121,N],[3,"user_fpregs_struct","","",N,N],[12,"cwd","","",122,N],[12,"swd","","",122,N],[12,"ftw","","",122,N],[12,"fop","","",122,N],[12,"rip","","",122,N],[12,"rdp","","",122,N],[12,"mxcsr","","",122,N],[12,"mxcr_mask","","",122,N],[12,"st_space","","",122,N],[12,"xmm_space","","",122,N],[12,"padding","","",122,N],[3,"user_regs_struct","","",N,N],[12,"r15","","",123,N],[12,"r14","","",123,N],[12,"r13","","",123,N],[12,"r12","","",123,N],[12,"rbp","","",123,N],[12,"rbx","","",123,N],[12,"r11","","",123,N],[12,"r10","","",123,N],[12,"r9","","",123,N],[12,"r8","","",123,N],[12,"rax","","",123,N],[12,"rcx","","",123,N],[12,"rdx","","",123,N],[12,"rsi","","",123,N],[12,"rdi","","",123,N],[12,"orig_rax","","",123,N],[12,"rip","","",123,N],[12,"cs","","",123,N],[12,"eflags","","",123,N],[12,"rsp","","",123,N],[12,"ss","","",123,N],[12,"fs_base","","",123,N],[12,"gs_base","","",123,N],[12,"ds","","",123,N],[12,"es","","",123,N],[12,"fs","","",123,N],[12,"gs","","",123,N],[3,"user","","",N,N],[12,"regs","","",124,N],[12,"u_fpvalid","","",124,N],[12,"i387","","",124,N],[12,"u_tsize","","",124,N],[12,"u_dsize","","",124,N],[12,"u_ssize","","",124,N],[12,"start_code","","",124,N],[12,"start_stack","","",124,N],[12,"signal","","",124,N],[12,"__reserved","","",124,N],[12,"u_ar0","","",124,N],[12,"u_fpstate","","",124,N],[12,"magic","","",124,N],[12,"u_comm","","",124,N],[12,"u_debugreg","","",124,N],[3,"mcontext_t","","",N,N],[12,"gregs","","",125,N],[12,"fpregs","","",125,N],[12,"__private","","",125,N],[3,"ucontext_t","","",N,N],[12,"uc_flags","","",126,N],[12,"uc_link","","",126,N],[12,"uc_stack","","",126,N],[12,"uc_mcontext","","",126,N],[12,"uc_sigmask","","",126,N],[12,"__private","","",126,N],[3,"ipc_perm","","",N,N],[12,"__key","","",127,N],[12,"uid","","",127,N],[12,"gid","","",127,N],[12,"cuid","","",127,N],[12,"cgid","","",127,N],[12,"mode","","",127,N],[12,"__pad1","","",127,N],[12,"__seq","","",127,N],[12,"__pad2","","",127,N],[12,"__unused1","","",127,N],[12,"__unused2","","",127,N],[3,"shmid_ds","","",N,N],[12,"shm_perm","","",128,N],[12,"shm_segsz","","",128,N],[12,"shm_atime","","",128,N],[12,"shm_dtime","","",128,N],[12,"shm_ctime","","",128,N],[12,"shm_cpid","","",128,N],[12,"shm_lpid","","",128,N],[12,"shm_nattch","","",128,N],[12,"__unused4","","",128,N],[12,"__unused5","","",128,N],[3,"termios2","","",N,N],[12,"c_iflag","","",129,N],[12,"c_oflag","","",129,N],[12,"c_cflag","","",129,N],[12,"c_lflag","","",129,N],[12,"c_line","","",129,N],[12,"c_cc","","",129,N],[12,"c_ispeed","","",129,N],[12,"c_ospeed","","",129,N],[3,"statvfs","","",N,N],[12,"f_bsize","","",130,N],[12,"f_frsize","","",130,N],[12,"f_blocks","","",130,N],[12,"f_bfree","","",130,N],[12,"f_bavail","","",130,N],[12,"f_files","","",130,N],[12,"f_ffree","","",130,N],[12,"f_favail","","",130,N],[12,"f_fsid","","",130,N],[12,"f_flag","","",130,N],[12,"f_namemax","","",130,N],[12,"__f_spare","","",130,N],[4,"c_void","","",N,N],[13,"__variant1","","",131,N],[13,"__variant2","","",131,N],[4,"FILE","","",N,N],[4,"fpos_t","","",N,N],[4,"DIR","","",N,N],[4,"locale_t","","",N,N],[4,"timezone","","",N,N],[4,"fpos64_t","","",N,N],[5,"FD_CLR","","",N,N],[5,"FD_ISSET","","",N,N],[5,"FD_SET","","",N,N],[5,"FD_ZERO","","",N,N],[5,"WIFSTOPPED","","",N,[[["c_int"]],["bool"]]],[5,"WSTOPSIG","","",N,[[["c_int"]],["c_int"]]],[5,"WIFCONTINUED","","",N,[[["c_int"]],["bool"]]],[5,"WIFSIGNALED","","",N,[[["c_int"]],["bool"]]],[5,"WTERMSIG","","",N,[[["c_int"]],["c_int"]]],[5,"WIFEXITED","","",N,[[["c_int"]],["bool"]]],[5,"WEXITSTATUS","","",N,[[["c_int"]],["c_int"]]],[5,"WCOREDUMP","","",N,[[["c_int"]],["bool"]]],[5,"QCMD","","",N,[[["c_int"],["c_int"]],["c_int"]]],[5,"IPOPT_COPIED","","",N,[[["u8"]],["u8"]]],[5,"IPOPT_CLASS","","",N,[[["u8"]],["u8"]]],[5,"IPOPT_NUMBER","","",N,[[["u8"]],["u8"]]],[5,"CPU_ZERO","","",N,N],[5,"CPU_SET","","",N,N],[5,"CPU_CLR","","",N,N],[5,"CPU_ISSET","","",N,[[["usize"],["cpu_set_t"]],["bool"]]],[5,"CPU_EQUAL","","",N,[[["cpu_set_t"],["cpu_set_t"]],["bool"]]],[5,"major","","",N,[[["dev_t"]],["c_uint"]]],[5,"minor","","",N,[[["dev_t"]],["c_uint"]]],[5,"makedev","","",N,[[["c_uint"],["c_uint"]],["dev_t"]]],[5,"IPTOS_TOS","","",N,[[["u8"]],["u8"]]],[5,"IPTOS_PREC","","",N,[[["u8"]],["u8"]]],[5,"RT_TOS","","",N,[[["u8"]],["u8"]]],[5,"RT_ADDRCLASS","","",N,[[["u32"]],["u32"]]],[5,"RT_LOCALADDR","","",N,[[["u32"]],["bool"]]],[5,"NLA_ALIGN","","",N,[[["c_int"]],["c_int"]]],[5,"isalnum","","",N,N],[5,"isalpha","","",N,N],[5,"iscntrl","","",N,N],[5,"isdigit","","",N,N],[5,"isgraph","","",N,N],[5,"islower","","",N,N],[5,"isprint","","",N,N],[5,"ispunct","","",N,N],[5,"isspace","","",N,N],[5,"isupper","","",N,N],[5,"isxdigit","","",N,N],[5,"tolower","","",N,N],[5,"toupper","","",N,N],[5,"fopen","","",N,N],[5,"freopen","","",N,N],[5,"fflush","","",N,N],[5,"fclose","","",N,N],[5,"remove","","",N,N],[5,"rename","","",N,N],[5,"tmpfile","","",N,N],[5,"setvbuf","","",N,N],[5,"setbuf","","",N,N],[5,"getchar","","",N,N],[5,"putchar","","",N,N],[5,"fgetc","","",N,N],[5,"fgets","","",N,N],[5,"fputc","","",N,N],[5,"fputs","","",N,N],[5,"puts","","",N,N],[5,"ungetc","","",N,N],[5,"fread","","",N,N],[5,"fwrite","","",N,N],[5,"fseek","","",N,N],[5,"ftell","","",N,N],[5,"rewind","","",N,N],[5,"fgetpos","","",N,N],[5,"fsetpos","","",N,N],[5,"feof","","",N,N],[5,"ferror","","",N,N],[5,"perror","","",N,N],[5,"atoi","","",N,N],[5,"strtod","","",N,N],[5,"strtol","","",N,N],[5,"strtoul","","",N,N],[5,"calloc","","",N,N],[5,"malloc","","",N,N],[5,"realloc","","",N,N],[5,"free","","",N,N],[5,"abort","","",N,N],[5,"exit","","",N,N],[5,"_exit","","",N,N],[5,"atexit","","",N,N],[5,"system","","",N,N],[5,"getenv","","",N,N],[5,"strcpy","","",N,N],[5,"strncpy","","",N,N],[5,"strcat","","",N,N],[5,"strncat","","",N,N],[5,"strcmp","","",N,N],[5,"strncmp","","",N,N],[5,"strcoll","","",N,N],[5,"strchr","","",N,N],[5,"strrchr","","",N,N],[5,"strspn","","",N,N],[5,"strcspn","","",N,N],[5,"strdup","","",N,N],[5,"strpbrk","","",N,N],[5,"strstr","","",N,N],[5,"strlen","","",N,N],[5,"strnlen","","",N,N],[5,"strerror","","",N,N],[5,"strtok","","",N,N],[5,"strxfrm","","",N,N],[5,"wcslen","","",N,N],[5,"wcstombs","","",N,N],[5,"memchr","","",N,N],[5,"memcmp","","",N,N],[5,"memcpy","","",N,N],[5,"memmove","","",N,N],[5,"memset","","",N,N],[5,"abs","","",N,N],[5,"atof","","",N,N],[5,"labs","","",N,N],[5,"rand","","",N,N],[5,"srand","","",N,N],[5,"getpwnam","","",N,N],[5,"getpwuid","","",N,N],[5,"fprintf","","",N,N],[5,"printf","","",N,N],[5,"snprintf","","",N,N],[5,"sprintf","","",N,N],[5,"fscanf","","",N,N],[5,"scanf","","",N,N],[5,"sscanf","","",N,N],[5,"getchar_unlocked","","",N,N],[5,"putchar_unlocked","","",N,N],[5,"socket","","",N,N],[5,"connect","","",N,N],[5,"listen","","",N,N],[5,"accept","","",N,N],[5,"getpeername","","",N,N],[5,"getsockname","","",N,N],[5,"setsockopt","","",N,N],[5,"socketpair","","",N,N],[5,"sendto","","",N,N],[5,"shutdown","","",N,N],[5,"chmod","","",N,N],[5,"fchmod","","",N,N],[5,"fstat","","",N,N],[5,"mkdir","","",N,N],[5,"stat","","",N,N],[5,"pclose","","",N,N],[5,"fdopen","","",N,N],[5,"fileno","","",N,N],[5,"open","","",N,N],[5,"creat","","",N,N],[5,"fcntl","","",N,N],[5,"opendir","","",N,N],[5,"fdopendir","","",N,N],[5,"readdir","","",N,N],[5,"readdir_r","","",N,N],[5,"closedir","","",N,N],[5,"rewinddir","","",N,N],[5,"openat","","",N,N],[5,"fchmodat","","",N,N],[5,"fchown","","",N,N],[5,"fchownat","","",N,N],[5,"fstatat","","",N,N],[5,"linkat","","",N,N],[5,"mkdirat","","",N,N],[5,"readlinkat","","",N,N],[5,"renameat","","",N,N],[5,"symlinkat","","",N,N],[5,"unlinkat","","",N,N],[5,"access","","",N,N],[5,"alarm","","",N,N],[5,"chdir","","",N,N],[5,"fchdir","","",N,N],[5,"chown","","",N,N],[5,"lchown","","",N,N],[5,"close","","",N,N],[5,"dup","","",N,N],[5,"dup2","","",N,N],[5,"execl","","",N,N],[5,"execle","","",N,N],[5,"execlp","","",N,N],[5,"execv","","",N,N],[5,"execve","","",N,N],[5,"execvp","","",N,N],[5,"fork","","",N,N],[5,"fpathconf","","",N,N],[5,"getcwd","","",N,N],[5,"getegid","","",N,N],[5,"geteuid","","",N,N],[5,"getgid","","",N,N],[5,"getgroups","","",N,N],[5,"getlogin","","",N,N],[5,"getopt","","",N,N],[5,"getpgid","","",N,N],[5,"getpgrp","","",N,N],[5,"getpid","","",N,N],[5,"getppid","","",N,N],[5,"getuid","","",N,N],[5,"isatty","","",N,N],[5,"link","","",N,N],[5,"lseek","","",N,N],[5,"pathconf","","",N,N],[5,"pause","","",N,N],[5,"pipe","","",N,N],[5,"posix_memalign","","",N,N],[5,"read","","",N,N],[5,"rmdir","","",N,N],[5,"seteuid","","",N,N],[5,"setgid","","",N,N],[5,"setpgid","","",N,N],[5,"setsid","","",N,N],[5,"setuid","","",N,N],[5,"sleep","","",N,N],[5,"nanosleep","","",N,N],[5,"tcgetpgrp","","",N,N],[5,"tcsetpgrp","","",N,N],[5,"ttyname","","",N,N],[5,"unlink","","",N,N],[5,"wait","","",N,N],[5,"waitpid","","",N,N],[5,"write","","",N,N],[5,"pread","","",N,N],[5,"pwrite","","",N,N],[5,"umask","","",N,N],[5,"utime","","",N,N],[5,"kill","","",N,N],[5,"killpg","","",N,N],[5,"mlock","","",N,N],[5,"munlock","","",N,N],[5,"mlockall","","",N,N],[5,"munlockall","","",N,N],[5,"mmap","","",N,N],[5,"munmap","","",N,N],[5,"if_nametoindex","","",N,N],[5,"if_indextoname","","",N,N],[5,"lstat","","",N,N],[5,"fsync","","",N,N],[5,"setenv","","",N,N],[5,"unsetenv","","",N,N],[5,"symlink","","",N,N],[5,"ftruncate","","",N,N],[5,"signal","","",N,N],[5,"getrlimit","","",N,N],[5,"setrlimit","","",N,N],[5,"getrusage","","",N,N],[5,"realpath","","",N,N],[5,"flock","","",N,N],[5,"gettimeofday","","",N,N],[5,"times","","",N,N],[5,"pthread_self","","",N,N],[5,"pthread_join","","",N,N],[5,"pthread_exit","","",N,N],[5,"pthread_attr_init","","",N,N],[5,"pthread_attr_destroy","","",N,N],[5,"pthread_attr_setstacksize","","",N,N],[5,"pthread_attr_setdetachstate","","",N,N],[5,"pthread_detach","","",N,N],[5,"sched_yield","","",N,N],[5,"pthread_key_create","","",N,N],[5,"pthread_key_delete","","",N,N],[5,"pthread_getspecific","","",N,N],[5,"pthread_setspecific","","",N,N],[5,"pthread_mutex_init","","",N,N],[5,"pthread_mutex_destroy","","",N,N],[5,"pthread_mutex_lock","","",N,N],[5,"pthread_mutex_trylock","","",N,N],[5,"pthread_mutex_unlock","","",N,N],[5,"pthread_mutexattr_init","","",N,N],[5,"pthread_mutexattr_destroy","","",N,N],[5,"pthread_mutexattr_settype","","",N,N],[5,"pthread_cond_init","","",N,N],[5,"pthread_cond_wait","","",N,N],[5,"pthread_cond_timedwait","","",N,N],[5,"pthread_cond_signal","","",N,N],[5,"pthread_cond_broadcast","","",N,N],[5,"pthread_cond_destroy","","",N,N],[5,"pthread_condattr_init","","",N,N],[5,"pthread_condattr_destroy","","",N,N],[5,"pthread_rwlock_init","","",N,N],[5,"pthread_rwlock_destroy","","",N,N],[5,"pthread_rwlock_rdlock","","",N,N],[5,"pthread_rwlock_tryrdlock","","",N,N],[5,"pthread_rwlock_wrlock","","",N,N],[5,"pthread_rwlock_trywrlock","","",N,N],[5,"pthread_rwlock_unlock","","",N,N],[5,"pthread_rwlockattr_init","","",N,N],[5,"pthread_rwlockattr_destroy","","",N,N],[5,"strerror_r","","",N,N],[5,"getsockopt","","",N,N],[5,"raise","","",N,N],[5,"sigaction","","",N,N],[5,"utimes","","",N,N],[5,"dlopen","","",N,N],[5,"dlerror","","",N,N],[5,"dlsym","","",N,N],[5,"dlclose","","",N,N],[5,"dladdr","","",N,N],[5,"getaddrinfo","","",N,N],[5,"freeaddrinfo","","",N,N],[5,"gai_strerror","","",N,N],[5,"res_init","","",N,N],[5,"gmtime_r","","",N,N],[5,"localtime_r","","",N,N],[5,"mktime","","",N,N],[5,"time","","",N,N],[5,"gmtime","","",N,N],[5,"localtime","","",N,N],[5,"difftime","","",N,N],[5,"mknod","","",N,N],[5,"uname","","",N,N],[5,"gethostname","","",N,N],[5,"getservbyname","","",N,N],[5,"getprotobyname","","",N,N],[5,"getprotobynumber","","",N,N],[5,"chroot","","",N,N],[5,"usleep","","",N,N],[5,"send","","",N,N],[5,"recv","","",N,N],[5,"putenv","","",N,N],[5,"poll","","",N,N],[5,"select","","",N,N],[5,"setlocale","","",N,N],[5,"localeconv","","",N,N],[5,"sem_destroy","","",N,N],[5,"sem_wait","","",N,N],[5,"sem_trywait","","",N,N],[5,"sem_post","","",N,N],[5,"sem_init","","",N,N],[5,"statvfs","","",N,N],[5,"fstatvfs","","",N,N],[5,"readlink","","",N,N],[5,"sigemptyset","","",N,N],[5,"sigaddset","","",N,N],[5,"sigfillset","","",N,N],[5,"sigdelset","","",N,N],[5,"sigismember","","",N,N],[5,"sigprocmask","","",N,N],[5,"sigpending","","",N,N],[5,"timegm","","",N,N],[5,"getsid","","",N,N],[5,"sysconf","","",N,N],[5,"mkfifo","","",N,N],[5,"pselect","","",N,N],[5,"fseeko","","",N,N],[5,"ftello","","",N,N],[5,"tcdrain","","",N,N],[5,"cfgetispeed","","",N,N],[5,"cfgetospeed","","",N,N],[5,"cfmakeraw","","",N,N],[5,"cfsetispeed","","",N,N],[5,"cfsetospeed","","",N,N],[5,"cfsetspeed","","",N,N],[5,"tcgetattr","","",N,N],[5,"tcsetattr","","",N,N],[5,"tcflow","","",N,N],[5,"tcflush","","",N,N],[5,"tcgetsid","","",N,N],[5,"tcsendbreak","","",N,N],[5,"mkstemp","","",N,N],[5,"mkdtemp","","",N,N],[5,"tmpnam","","",N,N],[5,"openlog","","",N,N],[5,"closelog","","",N,N],[5,"setlogmask","","",N,N],[5,"syslog","","",N,N],[5,"nice","","",N,N],[5,"grantpt","","",N,N],[5,"posix_openpt","","",N,N],[5,"ptsname","","",N,N],[5,"unlockpt","","",N,N],[5,"fdatasync","","",N,N],[5,"mincore","","",N,N],[5,"clock_getres","","",N,N],[5,"clock_gettime","","",N,N],[5,"clock_settime","","",N,N],[5,"dirfd","","",N,N],[5,"pthread_getattr_np","","",N,N],[5,"pthread_attr_getstack","","",N,N],[5,"memalign","","",N,N],[5,"setgroups","","",N,N],[5,"pipe2","","",N,N],[5,"statfs","","",N,N],[5,"statfs64","","",N,N],[5,"fstatfs","","",N,N],[5,"fstatfs64","","",N,N],[5,"statvfs64","","",N,N],[5,"fstatvfs64","","",N,N],[5,"memrchr","","",N,N],[5,"posix_fadvise","","",N,N],[5,"futimens","","",N,N],[5,"utimensat","","",N,N],[5,"duplocale","","",N,N],[5,"freelocale","","",N,N],[5,"newlocale","","",N,N],[5,"uselocale","","",N,N],[5,"creat64","","",N,N],[5,"fstat64","","",N,N],[5,"fstatat64","","",N,N],[5,"ftruncate64","","",N,N],[5,"getrlimit64","","",N,N],[5,"lseek64","","",N,N],[5,"lstat64","","",N,N],[5,"mmap64","","",N,N],[5,"open64","","",N,N],[5,"openat64","","",N,N],[5,"pread64","","",N,N],[5,"preadv64","","",N,N],[5,"pwrite64","","",N,N],[5,"pwritev64","","",N,N],[5,"readdir64","","",N,N],[5,"readdir64_r","","",N,N],[5,"setrlimit64","","",N,N],[5,"stat64","","",N,N],[5,"truncate64","","",N,N],[5,"mknodat","","",N,N],[5,"pthread_condattr_getclock","","",N,N],[5,"pthread_condattr_setclock","","",N,N],[5,"pthread_condattr_setpshared","","",N,N],[5,"accept4","","",N,N],[5,"pthread_mutexattr_setpshared","","",N,N],[5,"pthread_rwlockattr_getpshared","","",N,N],[5,"pthread_rwlockattr_setpshared","","",N,N],[5,"ptsname_r","","",N,N],[5,"clearenv","","",N,N],[5,"waitid","","",N,N],[5,"setreuid","","",N,N],[5,"setregid","","",N,N],[5,"getresuid","","",N,N],[5,"getresgid","","",N,N],[5,"acct","","",N,N],[5,"brk","","",N,N],[5,"sbrk","","",N,N],[5,"vfork","","",N,N],[5,"setresgid","","",N,N],[5,"setresuid","","",N,N],[5,"wait4","","",N,N],[5,"openpty","","",N,N],[5,"execvpe","","",N,N],[5,"fexecve","","",N,N],[5,"getifaddrs","","",N,N],[5,"freeifaddrs","","",N,N],[5,"bind","","",N,N],[5,"writev","","",N,N],[5,"readv","","",N,N],[5,"sendmsg","","",N,N],[5,"recvmsg","","",N,N],[5,"aio_read","","",N,N],[5,"aio_write","","",N,N],[5,"aio_fsync","","",N,N],[5,"aio_error","","",N,N],[5,"aio_return","","",N,N],[5,"aio_suspend","","",N,N],[5,"aio_cancel","","",N,N],[5,"lio_listio","","",N,N],[5,"lutimes","","",N,N],[5,"setpwent","","",N,N],[5,"endpwent","","",N,N],[5,"getpwent","","",N,N],[5,"setgrent","","",N,N],[5,"endgrent","","",N,N],[5,"getgrent","","",N,N],[5,"setspent","","",N,N],[5,"endspent","","",N,N],[5,"getspent","","",N,N],[5,"getspnam","","",N,N],[5,"shm_open","","",N,N],[5,"shmget","","",N,N],[5,"shmat","","",N,N],[5,"shmdt","","",N,N],[5,"shmctl","","",N,N],[5,"ftok","","",N,N],[5,"semget","","",N,N],[5,"semop","","",N,N],[5,"semctl","","",N,N],[5,"msgctl","","",N,N],[5,"msgget","","",N,N],[5,"msgrcv","","",N,N],[5,"msgsnd","","",N,N],[5,"mprotect","","",N,N],[5,"__errno_location","","",N,N],[5,"fopen64","","",N,N],[5,"freopen64","","",N,N],[5,"tmpfile64","","",N,N],[5,"fgetpos64","","",N,N],[5,"fsetpos64","","",N,N],[5,"fseeko64","","",N,N],[5,"ftello64","","",N,N],[5,"fallocate","","",N,N],[5,"posix_fallocate","","",N,N],[5,"readahead","","",N,N],[5,"getxattr","","",N,N],[5,"lgetxattr","","",N,N],[5,"fgetxattr","","",N,N],[5,"setxattr","","",N,N],[5,"lsetxattr","","",N,N],[5,"fsetxattr","","",N,N],[5,"listxattr","","",N,N],[5,"llistxattr","","",N,N],[5,"flistxattr","","",N,N],[5,"removexattr","","",N,N],[5,"lremovexattr","","",N,N],[5,"fremovexattr","","",N,N],[5,"signalfd","","",N,N],[5,"timerfd_create","","",N,N],[5,"timerfd_gettime","","",N,N],[5,"timerfd_settime","","",N,N],[5,"pwritev","","",N,N],[5,"preadv","","",N,N],[5,"quotactl","","",N,N],[5,"mq_open","","",N,N],[5,"mq_close","","",N,N],[5,"mq_unlink","","",N,N],[5,"mq_receive","","",N,N],[5,"mq_send","","",N,N],[5,"mq_getattr","","",N,N],[5,"mq_setattr","","",N,N],[5,"epoll_pwait","","",N,N],[5,"dup3","","",N,N],[5,"mkostemp","","",N,N],[5,"mkostemps","","",N,N],[5,"sigtimedwait","","",N,N],[5,"sigwaitinfo","","",N,N],[5,"nl_langinfo_l","","",N,N],[5,"getnameinfo","","",N,N],[5,"pthread_setschedprio","","",N,N],[5,"prlimit","","",N,N],[5,"prlimit64","","",N,N],[5,"getloadavg","","",N,N],[5,"process_vm_readv","","",N,N],[5,"process_vm_writev","","",N,N],[5,"reboot","","",N,N],[5,"setfsgid","","",N,N],[5,"setfsuid","","",N,N],[5,"mkfifoat","","",N,N],[5,"if_nameindex","","",N,N],[5,"if_freenameindex","","",N,N],[5,"sync_file_range","","",N,N],[5,"mremap","","",N,N],[5,"glob","","",N,N],[5,"globfree","","",N,N],[5,"posix_madvise","","",N,N],[5,"shm_unlink","","",N,N],[5,"seekdir","","",N,N],[5,"telldir","","",N,N],[5,"madvise","","",N,N],[5,"msync","","",N,N],[5,"remap_file_pages","","",N,N],[5,"recvfrom","","",N,N],[5,"mkstemps","","",N,N],[5,"futimes","","",N,N],[5,"nl_langinfo","","",N,N],[5,"getdomainname","","",N,N],[5,"setdomainname","","",N,N],[5,"vhangup","","",N,N],[5,"sendmmsg","","",N,N],[5,"recvmmsg","","",N,N],[5,"sync","","",N,N],[5,"syscall","","",N,N],[5,"sched_getaffinity","","",N,N],[5,"sched_setaffinity","","",N,N],[5,"epoll_create","","",N,N],[5,"epoll_create1","","",N,N],[5,"epoll_wait","","",N,N],[5,"epoll_ctl","","",N,N],[5,"pthread_getschedparam","","",N,N],[5,"unshare","","",N,N],[5,"umount","","",N,N],[5,"sched_get_priority_max","","",N,N],[5,"tee","","",N,N],[5,"settimeofday","","",N,N],[5,"splice","","",N,N],[5,"eventfd","","",N,N],[5,"sched_rr_get_interval","","",N,N],[5,"sem_timedwait","","",N,N],[5,"sem_getvalue","","",N,N],[5,"sched_setparam","","",N,N],[5,"setns","","",N,N],[5,"swapoff","","",N,N],[5,"vmsplice","","",N,N],[5,"mount","","",N,N],[5,"personality","","",N,N],[5,"prctl","","",N,N],[5,"sched_getparam","","",N,N],[5,"ppoll","","",N,N],[5,"pthread_mutex_timedlock","","",N,N],[5,"clone","","",N,N],[5,"sched_getscheduler","","",N,N],[5,"clock_nanosleep","","",N,N],[5,"pthread_attr_getguardsize","","",N,N],[5,"sethostname","","",N,N],[5,"sched_get_priority_min","","",N,N],[5,"pthread_condattr_getpshared","","",N,N],[5,"sysinfo","","",N,N],[5,"umount2","","",N,N],[5,"pthread_setschedparam","","",N,N],[5,"swapon","","",N,N],[5,"sched_setscheduler","","",N,N],[5,"sendfile","","",N,N],[5,"sigsuspend","","",N,N],[5,"getgrgid_r","","",N,N],[5,"sigaltstack","","",N,N],[5,"sem_close","","",N,N],[5,"getdtablesize","","",N,N],[5,"getgrnam_r","","",N,N],[5,"initgroups","","",N,N],[5,"pthread_sigmask","","",N,N],[5,"sem_open","","",N,N],[5,"getgrnam","","",N,N],[5,"pthread_cancel","","",N,N],[5,"pthread_kill","","",N,N],[5,"sem_unlink","","",N,N],[5,"daemon","","",N,N],[5,"getpwnam_r","","",N,N],[5,"getpwuid_r","","",N,N],[5,"sigwait","","",N,N],[5,"pthread_atfork","","",N,N],[5,"getgrgid","","",N,N],[5,"getgrouplist","","",N,N],[5,"pthread_mutexattr_getpshared","","",N,N],[5,"popen","","",N,N],[5,"faccessat","","",N,N],[5,"pthread_create","","",N,N],[5,"dl_iterate_phdr","","",N,N],[5,"setmntent","","",N,N],[5,"getmntent","","",N,N],[5,"addmntent","","",N,N],[5,"endmntent","","",N,N],[5,"hasmntopt","","",N,N],[5,"posix_spawn","","",N,N],[5,"posix_spawnp","","",N,N],[5,"posix_spawnattr_init","","",N,N],[5,"posix_spawnattr_destroy","","",N,N],[5,"posix_spawnattr_getsigdefault","","",N,N],[5,"posix_spawnattr_setsigdefault","","",N,N],[5,"posix_spawnattr_getsigmask","","",N,N],[5,"posix_spawnattr_setsigmask","","",N,N],[5,"posix_spawnattr_getflags","","",N,N],[5,"posix_spawnattr_setflags","","",N,N],[5,"posix_spawnattr_getpgroup","","",N,N],[5,"posix_spawnattr_setpgroup","","",N,N],[5,"posix_spawnattr_getschedpolicy","","",N,N],[5,"posix_spawnattr_setschedpolicy","","",N,N],[5,"posix_spawnattr_getschedparam","","",N,N],[5,"posix_spawnattr_setschedparam","","",N,N],[5,"posix_spawn_file_actions_init","","",N,N],[5,"posix_spawn_file_actions_destroy","","",N,N],[5,"posix_spawn_file_actions_addopen","","",N,N],[5,"posix_spawn_file_actions_addclose","","",N,N],[5,"posix_spawn_file_actions_adddup2","","",N,N],[5,"fread_unlocked","","",N,N],[5,"utmpxname","","",N,N],[5,"getutxent","","",N,N],[5,"getutxid","","",N,N],[5,"getutxline","","",N,N],[5,"pututxline","","",N,N],[5,"setutxent","","",N,N],[5,"endutxent","","",N,N],[5,"getpt","","",N,N],[5,"ioctl","","",N,N],[5,"backtrace","","",N,N],[5,"glob64","","",N,N],[5,"globfree64","","",N,N],[5,"ptrace","","",N,N],[5,"pthread_attr_getaffinity_np","","",N,N],[5,"pthread_attr_setaffinity_np","","",N,N],[5,"getpriority","","",N,N],[5,"setpriority","","",N,N],[5,"pthread_getaffinity_np","","",N,N],[5,"pthread_setaffinity_np","","",N,N],[5,"pthread_rwlockattr_getkind_np","","",N,N],[5,"pthread_rwlockattr_setkind_np","","",N,N],[5,"sched_getcpu","","",N,N],[5,"mallinfo","","",N,N],[5,"malloc_usable_size","","",N,N],[5,"getauxval","","",N,N],[5,"getpwent_r","","",N,N],[5,"getgrent_r","","",N,N],[5,"getcontext","","",N,N],[5,"setcontext","","",N,N],[5,"makecontext","","",N,N],[5,"swapcontext","","",N,N],[5,"iopl","","",N,N],[5,"ioperm","","",N,N],[5,"sysctl","","",N,N],[0,"macros","","",N,N],[0,"dox","","",N,N],[0,"imp","libc::dox","",N,N],[4,"Option","libc::dox::imp","The `Option` type. See the module level documentation for more.",N,N],[13,"None","","No value",132,N],[13,"Some","","Some value `T`",132,N],[8,"Clone","","A common trait for the ability to explicitly duplicate an object.",N,N],[10,"clone","","Returns a copy of the value.",133,[[["self"]],["self"]]],[11,"clone_from","","Performs copy-assignment from `source`.",133,N],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",N,N],[0,"mem","","Basic functions for dealing with memory.",N,N],[5,"forget","libc::dox::imp::mem","Takes ownership and \"forgets\" about the value without running its destructor.",N,N],[5,"size_of","","Returns the size of a type in bytes.",N,[[],["usize"]]],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",N,[[["t"]],["usize"]]],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",N,[[],["usize"]]],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",N,[[["t"]],["usize"]]],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",N,[[],["usize"]]],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",N,[[["t"]],["usize"]]],[5,"needs_drop","","Returns whether dropping values of type `T` matters.",N,[[],["bool"]]],[5,"zeroed","","Creates a value whose bytes are all zero.",N,[[],["t"]]],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",N,[[],["t"]]],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",N,N],[5,"replace","","Moves `src` into the referenced `dest`, returning the previous `dest` value.",N,[[["t"],["t"]],["t"]]],[5,"drop","","Disposes of a value.",N,N],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",N,[[["t"]],["u"]]],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",N,N],[12,"0","","",134,N],[12,"1","","",134,N],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",N,[[["t"]],["discriminant"]]],[3,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling `T`’s destructor.",N,N],[12,"value","","",135,N],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",N,[[["t"]],["u"]]],[0,"unix","libc","Definitions found commonly among almost all Unix derivatives",N,N],[3,"group","libc::unix","",N,N],[12,"gr_name","","",0,N],[12,"gr_passwd","","",0,N],[12,"gr_gid","","",0,N],[12,"gr_mem","","",0,N],[3,"utimbuf","","",N,N],[12,"actime","","",1,N],[12,"modtime","","",1,N],[3,"timeval","","",N,N],[12,"tv_sec","","",2,N],[12,"tv_usec","","",2,N],[3,"timespec","","",N,N],[12,"tv_sec","","",3,N],[12,"tv_nsec","","",3,N],[3,"rlimit","","",N,N],[12,"rlim_cur","","",4,N],[12,"rlim_max","","",4,N],[3,"rusage","","",N,N],[12,"ru_utime","","",5,N],[12,"ru_stime","","",5,N],[12,"ru_maxrss","","",5,N],[12,"ru_ixrss","","",5,N],[12,"ru_idrss","","",5,N],[12,"ru_isrss","","",5,N],[12,"ru_minflt","","",5,N],[12,"ru_majflt","","",5,N],[12,"ru_nswap","","",5,N],[12,"ru_inblock","","",5,N],[12,"ru_oublock","","",5,N],[12,"ru_msgsnd","","",5,N],[12,"ru_msgrcv","","",5,N],[12,"ru_nsignals","","",5,N],[12,"ru_nvcsw","","",5,N],[12,"ru_nivcsw","","",5,N],[3,"in_addr","","",N,N],[12,"s_addr","","",6,N],[3,"in6_addr","","",N,N],[12,"s6_addr","","",7,N],[12,"__align","","",7,N],[3,"ip_mreq","","",N,N],[12,"imr_multiaddr","","",8,N],[12,"imr_interface","","",8,N],[3,"ipv6_mreq","","",N,N],[12,"ipv6mr_multiaddr","","",9,N],[12,"ipv6mr_interface","","",9,N],[3,"hostent","","",N,N],[12,"h_name","","",10,N],[12,"h_aliases","","",10,N],[12,"h_addrtype","","",10,N],[12,"h_length","","",10,N],[12,"h_addr_list","","",10,N],[3,"iovec","","",N,N],[12,"iov_base","","",11,N],[12,"iov_len","","",11,N],[3,"pollfd","","",N,N],[12,"fd","","",12,N],[12,"events","","",12,N],[12,"revents","","",12,N],[3,"winsize","","",N,N],[12,"ws_row","","",13,N],[12,"ws_col","","",13,N],[12,"ws_xpixel","","",13,N],[12,"ws_ypixel","","",13,N],[3,"linger","","",N,N],[12,"l_onoff","","",14,N],[12,"l_linger","","",14,N],[3,"sigval","","",N,N],[12,"sival_ptr","","",15,N],[3,"itimerval","","",N,N],[12,"it_interval","","",16,N],[12,"it_value","","",16,N],[3,"tms","","",N,N],[12,"tms_utime","","",17,N],[12,"tms_stime","","",17,N],[12,"tms_cutime","","",17,N],[12,"tms_cstime","","",17,N],[3,"servent","","",N,N],[12,"s_name","","",18,N],[12,"s_aliases","","",18,N],[12,"s_port","","",18,N],[12,"s_proto","","",18,N],[3,"protoent","","",N,N],[12,"p_name","","",19,N],[12,"p_aliases","","",19,N],[12,"p_proto","","",19,N],[4,"DIR","","",N,N],[4,"locale_t","","",N,N],[5,"getpwnam","","",N,N],[5,"getpwuid","","",N,N],[5,"fprintf","","",N,N],[5,"printf","","",N,N],[5,"snprintf","","",N,N],[5,"sprintf","","",N,N],[5,"fscanf","","",N,N],[5,"scanf","","",N,N],[5,"sscanf","","",N,N],[5,"getchar_unlocked","","",N,N],[5,"putchar_unlocked","","",N,N],[5,"socket","","",N,N],[5,"connect","","",N,N],[5,"listen","","",N,N],[5,"accept","","",N,N],[5,"getpeername","","",N,N],[5,"getsockname","","",N,N],[5,"setsockopt","","",N,N],[5,"socketpair","","",N,N],[5,"sendto","","",N,N],[5,"shutdown","","",N,N],[5,"chmod","","",N,N],[5,"fchmod","","",N,N],[5,"fstat","","",N,N],[5,"mkdir","","",N,N],[5,"stat","","",N,N],[5,"pclose","","",N,N],[5,"fdopen","","",N,N],[5,"fileno","","",N,N],[5,"open","","",N,N],[5,"creat","","",N,N],[5,"fcntl","","",N,N],[5,"opendir","","",N,N],[5,"fdopendir","","",N,N],[5,"readdir","","",N,N],[5,"readdir_r","","",N,N],[5,"closedir","","",N,N],[5,"rewinddir","","",N,N],[5,"openat","","",N,N],[5,"fchmodat","","",N,N],[5,"fchown","","",N,N],[5,"fchownat","","",N,N],[5,"fstatat","","",N,N],[5,"linkat","","",N,N],[5,"mkdirat","","",N,N],[5,"readlinkat","","",N,N],[5,"renameat","","",N,N],[5,"symlinkat","","",N,N],[5,"unlinkat","","",N,N],[5,"access","","",N,N],[5,"alarm","","",N,N],[5,"chdir","","",N,N],[5,"fchdir","","",N,N],[5,"chown","","",N,N],[5,"lchown","","",N,N],[5,"close","","",N,N],[5,"dup","","",N,N],[5,"dup2","","",N,N],[5,"execl","","",N,N],[5,"execle","","",N,N],[5,"execlp","","",N,N],[5,"execv","","",N,N],[5,"execve","","",N,N],[5,"execvp","","",N,N],[5,"fork","","",N,N],[5,"fpathconf","","",N,N],[5,"getcwd","","",N,N],[5,"getegid","","",N,N],[5,"geteuid","","",N,N],[5,"getgid","","",N,N],[5,"getgroups","","",N,N],[5,"getlogin","","",N,N],[5,"getopt","","",N,N],[5,"getpgid","","",N,N],[5,"getpgrp","","",N,N],[5,"getpid","","",N,N],[5,"getppid","","",N,N],[5,"getuid","","",N,N],[5,"isatty","","",N,N],[5,"link","","",N,N],[5,"lseek","","",N,N],[5,"pathconf","","",N,N],[5,"pause","","",N,N],[5,"pipe","","",N,N],[5,"posix_memalign","","",N,N],[5,"read","","",N,N],[5,"rmdir","","",N,N],[5,"seteuid","","",N,N],[5,"setgid","","",N,N],[5,"setpgid","","",N,N],[5,"setsid","","",N,N],[5,"setuid","","",N,N],[5,"sleep","","",N,N],[5,"nanosleep","","",N,N],[5,"tcgetpgrp","","",N,N],[5,"tcsetpgrp","","",N,N],[5,"ttyname","","",N,N],[5,"unlink","","",N,N],[5,"wait","","",N,N],[5,"waitpid","","",N,N],[5,"write","","",N,N],[5,"pread","","",N,N],[5,"pwrite","","",N,N],[5,"umask","","",N,N],[5,"utime","","",N,N],[5,"kill","","",N,N],[5,"killpg","","",N,N],[5,"mlock","","",N,N],[5,"munlock","","",N,N],[5,"mlockall","","",N,N],[5,"munlockall","","",N,N],[5,"mmap","","",N,N],[5,"munmap","","",N,N],[5,"if_nametoindex","","",N,N],[5,"if_indextoname","","",N,N],[5,"lstat","","",N,N],[5,"fsync","","",N,N],[5,"setenv","","",N,N],[5,"unsetenv","","",N,N],[5,"symlink","","",N,N],[5,"ftruncate","","",N,N],[5,"signal","","",N,N],[5,"getrlimit","","",N,N],[5,"setrlimit","","",N,N],[5,"getrusage","","",N,N],[5,"realpath","","",N,N],[5,"flock","","",N,N],[5,"gettimeofday","","",N,N],[5,"times","","",N,N],[5,"pthread_self","","",N,N],[5,"pthread_join","","",N,N],[5,"pthread_exit","","",N,N],[5,"pthread_attr_init","","",N,N],[5,"pthread_attr_destroy","","",N,N],[5,"pthread_attr_setstacksize","","",N,N],[5,"pthread_attr_setdetachstate","","",N,N],[5,"pthread_detach","","",N,N],[5,"sched_yield","","",N,N],[5,"pthread_key_create","","",N,N],[5,"pthread_key_delete","","",N,N],[5,"pthread_getspecific","","",N,N],[5,"pthread_setspecific","","",N,N],[5,"pthread_mutex_init","","",N,N],[5,"pthread_mutex_destroy","","",N,N],[5,"pthread_mutex_lock","","",N,N],[5,"pthread_mutex_trylock","","",N,N],[5,"pthread_mutex_unlock","","",N,N],[5,"pthread_mutexattr_init","","",N,N],[5,"pthread_mutexattr_destroy","","",N,N],[5,"pthread_mutexattr_settype","","",N,N],[5,"pthread_cond_init","","",N,N],[5,"pthread_cond_wait","","",N,N],[5,"pthread_cond_timedwait","","",N,N],[5,"pthread_cond_signal","","",N,N],[5,"pthread_cond_broadcast","","",N,N],[5,"pthread_cond_destroy","","",N,N],[5,"pthread_condattr_init","","",N,N],[5,"pthread_condattr_destroy","","",N,N],[5,"pthread_rwlock_init","","",N,N],[5,"pthread_rwlock_destroy","","",N,N],[5,"pthread_rwlock_rdlock","","",N,N],[5,"pthread_rwlock_tryrdlock","","",N,N],[5,"pthread_rwlock_wrlock","","",N,N],[5,"pthread_rwlock_trywrlock","","",N,N],[5,"pthread_rwlock_unlock","","",N,N],[5,"pthread_rwlockattr_init","","",N,N],[5,"pthread_rwlockattr_destroy","","",N,N],[5,"strerror_r","","",N,N],[5,"getsockopt","","",N,N],[5,"raise","","",N,N],[5,"sigaction","","",N,N],[5,"utimes","","",N,N],[5,"dlopen","","",N,N],[5,"dlerror","","",N,N],[5,"dlsym","","",N,N],[5,"dlclose","","",N,N],[5,"dladdr","","",N,N],[5,"getaddrinfo","","",N,N],[5,"freeaddrinfo","","",N,N],[5,"gai_strerror","","",N,N],[5,"res_init","","",N,N],[5,"gmtime_r","","",N,N],[5,"localtime_r","","",N,N],[5,"mktime","","",N,N],[5,"time","","",N,N],[5,"gmtime","","",N,N],[5,"localtime","","",N,N],[5,"difftime","","",N,N],[5,"mknod","","",N,N],[5,"uname","","",N,N],[5,"gethostname","","",N,N],[5,"getservbyname","","",N,N],[5,"getprotobyname","","",N,N],[5,"getprotobynumber","","",N,N],[5,"chroot","","",N,N],[5,"usleep","","",N,N],[5,"send","","",N,N],[5,"recv","","",N,N],[5,"putenv","","",N,N],[5,"poll","","",N,N],[5,"select","","",N,N],[5,"setlocale","","",N,N],[5,"localeconv","","",N,N],[5,"sem_destroy","","",N,N],[5,"sem_wait","","",N,N],[5,"sem_trywait","","",N,N],[5,"sem_post","","",N,N],[5,"sem_init","","",N,N],[5,"statvfs","","",N,N],[5,"fstatvfs","","",N,N],[5,"readlink","","",N,N],[5,"sigemptyset","","",N,N],[5,"sigaddset","","",N,N],[5,"sigfillset","","",N,N],[5,"sigdelset","","",N,N],[5,"sigismember","","",N,N],[5,"sigprocmask","","",N,N],[5,"sigpending","","",N,N],[5,"timegm","","",N,N],[5,"getsid","","",N,N],[5,"sysconf","","",N,N],[5,"mkfifo","","",N,N],[5,"pselect","","",N,N],[5,"fseeko","","",N,N],[5,"ftello","","",N,N],[5,"tcdrain","","",N,N],[5,"cfgetispeed","","",N,N],[5,"cfgetospeed","","",N,N],[5,"cfmakeraw","","",N,N],[5,"cfsetispeed","","",N,N],[5,"cfsetospeed","","",N,N],[5,"cfsetspeed","","",N,N],[5,"tcgetattr","","",N,N],[5,"tcsetattr","","",N,N],[5,"tcflow","","",N,N],[5,"tcflush","","",N,N],[5,"tcgetsid","","",N,N],[5,"tcsendbreak","","",N,N],[5,"mkstemp","","",N,N],[5,"mkdtemp","","",N,N],[5,"tmpnam","","",N,N],[5,"openlog","","",N,N],[5,"closelog","","",N,N],[5,"setlogmask","","",N,N],[5,"syslog","","",N,N],[5,"nice","","",N,N],[5,"grantpt","","",N,N],[5,"posix_openpt","","",N,N],[5,"ptsname","","",N,N],[5,"unlockpt","","",N,N],[0,"notbsd","","",N,N],[3,"sockaddr","libc::unix::notbsd","",N,N],[12,"sa_family","","",20,N],[12,"sa_data","","",20,N],[3,"sockaddr_in","","",N,N],[12,"sin_family","","",21,N],[12,"sin_port","","",21,N],[12,"sin_addr","","",21,N],[12,"sin_zero","","",21,N],[3,"sockaddr_in6","","",N,N],[12,"sin6_family","","",22,N],[12,"sin6_port","","",22,N],[12,"sin6_flowinfo","","",22,N],[12,"sin6_addr","","",22,N],[12,"sin6_scope_id","","",22,N],[3,"sockaddr_un","","",N,N],[12,"sun_family","","",23,N],[12,"sun_path","","",23,N],[3,"sockaddr_storage","","",N,N],[12,"ss_family","","",24,N],[12,"__ss_align","","",24,N],[12,"__ss_pad2","","",24,N],[3,"addrinfo","","",N,N],[12,"ai_flags","","",25,N],[12,"ai_family","","",25,N],[12,"ai_socktype","","",25,N],[12,"ai_protocol","","",25,N],[12,"ai_addrlen","","",25,N],[12,"ai_addr","","",25,N],[12,"ai_canonname","","",25,N],[12,"ai_next","","",25,N],[3,"sockaddr_nl","","",N,N],[12,"nl_family","","",26,N],[12,"nl_pad","","",26,N],[12,"nl_pid","","",26,N],[12,"nl_groups","","",26,N],[3,"sockaddr_ll","","",N,N],[12,"sll_family","","",27,N],[12,"sll_protocol","","",27,N],[12,"sll_ifindex","","",27,N],[12,"sll_hatype","","",27,N],[12,"sll_pkttype","","",27,N],[12,"sll_halen","","",27,N],[12,"sll_addr","","",27,N],[3,"fd_set","","",N,N],[12,"fds_bits","","",28,N],[3,"tm","","",N,N],[12,"tm_sec","","",29,N],[12,"tm_min","","",29,N],[12,"tm_hour","","",29,N],[12,"tm_mday","","",29,N],[12,"tm_mon","","",29,N],[12,"tm_year","","",29,N],[12,"tm_wday","","",29,N],[12,"tm_yday","","",29,N],[12,"tm_isdst","","",29,N],[12,"tm_gmtoff","","",29,N],[12,"tm_zone","","",29,N],[3,"sched_param","","",N,N],[12,"sched_priority","","",30,N],[3,"Dl_info","","",N,N],[12,"dli_fname","","",31,N],[12,"dli_fbase","","",31,N],[12,"dli_sname","","",31,N],[12,"dli_saddr","","",31,N],[3,"epoll_event","","",N,N],[12,"events","","",32,N],[12,"u64","","",32,N],[3,"utsname","","",N,N],[12,"sysname","","",33,N],[12,"nodename","","",33,N],[12,"release","","",33,N],[12,"version","","",33,N],[12,"machine","","",33,N],[12,"domainname","","",33,N],[3,"lconv","","",N,N],[12,"decimal_point","","",34,N],[12,"thousands_sep","","",34,N],[12,"grouping","","",34,N],[12,"int_curr_symbol","","",34,N],[12,"currency_symbol","","",34,N],[12,"mon_decimal_point","","",34,N],[12,"mon_thousands_sep","","",34,N],[12,"mon_grouping","","",34,N],[12,"positive_sign","","",34,N],[12,"negative_sign","","",34,N],[12,"int_frac_digits","","",34,N],[12,"frac_digits","","",34,N],[12,"p_cs_precedes","","",34,N],[12,"p_sep_by_space","","",34,N],[12,"n_cs_precedes","","",34,N],[12,"n_sep_by_space","","",34,N],[12,"p_sign_posn","","",34,N],[12,"n_sign_posn","","",34,N],[12,"int_p_cs_precedes","","",34,N],[12,"int_p_sep_by_space","","",34,N],[12,"int_n_cs_precedes","","",34,N],[12,"int_n_sep_by_space","","",34,N],[12,"int_p_sign_posn","","",34,N],[12,"int_n_sign_posn","","",34,N],[3,"sigevent","","",N,N],[12,"sigev_value","","",35,N],[12,"sigev_signo","","",35,N],[12,"sigev_notify","","",35,N],[12,"sigev_notify_thread_id","","",35,N],[12,"__unused1","","",35,N],[3,"in_pktinfo","","",N,N],[12,"ipi_ifindex","","",36,N],[12,"ipi_spec_dst","","",36,N],[12,"ipi_addr","","",36,N],[3,"ifaddrs","","",N,N],[12,"ifa_next","","",37,N],[12,"ifa_name","","",37,N],[12,"ifa_flags","","",37,N],[12,"ifa_addr","","",37,N],[12,"ifa_netmask","","",37,N],[12,"ifa_ifu","","",37,N],[12,"ifa_data","","",37,N],[3,"in6_rtmsg","","",N,N],[12,"rtmsg_dst","","",38,N],[12,"rtmsg_src","","",38,N],[12,"rtmsg_gateway","","",38,N],[12,"rtmsg_type","","",38,N],[12,"rtmsg_dst_len","","",38,N],[12,"rtmsg_src_len","","",38,N],[12,"rtmsg_metric","","",38,N],[12,"rtmsg_info","","",38,N],[12,"rtmsg_flags","","",38,N],[12,"rtmsg_ifindex","","",38,N],[3,"arpreq","","",N,N],[12,"arp_pa","","",39,N],[12,"arp_ha","","",39,N],[12,"arp_flags","","",39,N],[12,"arp_netmask","","",39,N],[12,"arp_dev","","",39,N],[3,"arpreq_old","","",N,N],[12,"arp_pa","","",40,N],[12,"arp_ha","","",40,N],[12,"arp_flags","","",40,N],[12,"arp_netmask","","",40,N],[3,"arphdr","","",N,N],[12,"ar_hrd","","",41,N],[12,"ar_pro","","",41,N],[12,"ar_hln","","",41,N],[12,"ar_pln","","",41,N],[12,"ar_op","","",41,N],[4,"timezone","","",N,N],[5,"FD_CLR","","",N,N],[5,"FD_ISSET","","",N,N],[5,"FD_SET","","",N,N],[5,"FD_ZERO","","",N,N],[5,"WIFSTOPPED","","",N,[[["c_int"]],["bool"]]],[5,"WSTOPSIG","","",N,[[["c_int"]],["c_int"]]],[5,"WIFCONTINUED","","",N,[[["c_int"]],["bool"]]],[5,"WIFSIGNALED","","",N,[[["c_int"]],["bool"]]],[5,"WTERMSIG","","",N,[[["c_int"]],["c_int"]]],[5,"WIFEXITED","","",N,[[["c_int"]],["bool"]]],[5,"WEXITSTATUS","","",N,[[["c_int"]],["c_int"]]],[5,"WCOREDUMP","","",N,[[["c_int"]],["bool"]]],[5,"QCMD","","",N,[[["c_int"],["c_int"]],["c_int"]]],[5,"IPOPT_COPIED","","",N,[[["u8"]],["u8"]]],[5,"IPOPT_CLASS","","",N,[[["u8"]],["u8"]]],[5,"IPOPT_NUMBER","","",N,[[["u8"]],["u8"]]],[5,"fdatasync","","",N,N],[5,"mincore","","",N,N],[5,"clock_getres","","",N,N],[5,"clock_gettime","","",N,N],[5,"clock_settime","","",N,N],[5,"dirfd","","",N,N],[5,"pthread_getattr_np","","",N,N],[5,"pthread_attr_getstack","","",N,N],[5,"memalign","","",N,N],[5,"setgroups","","",N,N],[5,"pipe2","","",N,N],[5,"statfs","","",N,N],[5,"statfs64","","",N,N],[5,"fstatfs","","",N,N],[5,"fstatfs64","","",N,N],[5,"statvfs64","","",N,N],[5,"fstatvfs64","","",N,N],[5,"memrchr","","",N,N],[5,"posix_fadvise","","",N,N],[5,"futimens","","",N,N],[5,"utimensat","","",N,N],[5,"duplocale","","",N,N],[5,"freelocale","","",N,N],[5,"newlocale","","",N,N],[5,"uselocale","","",N,N],[5,"creat64","","",N,N],[5,"fstat64","","",N,N],[5,"fstatat64","","",N,N],[5,"ftruncate64","","",N,N],[5,"getrlimit64","","",N,N],[5,"lseek64","","",N,N],[5,"lstat64","","",N,N],[5,"mmap64","","",N,N],[5,"open64","","",N,N],[5,"openat64","","",N,N],[5,"pread64","","",N,N],[5,"preadv64","","",N,N],[5,"pwrite64","","",N,N],[5,"pwritev64","","",N,N],[5,"readdir64","","",N,N],[5,"readdir64_r","","",N,N],[5,"setrlimit64","","",N,N],[5,"stat64","","",N,N],[5,"truncate64","","",N,N],[5,"mknodat","","",N,N],[5,"pthread_condattr_getclock","","",N,N],[5,"pthread_condattr_setclock","","",N,N],[5,"pthread_condattr_setpshared","","",N,N],[5,"accept4","","",N,N],[5,"pthread_mutexattr_setpshared","","",N,N],[5,"pthread_rwlockattr_getpshared","","",N,N],[5,"pthread_rwlockattr_setpshared","","",N,N],[5,"ptsname_r","","",N,N],[5,"clearenv","","",N,N],[5,"waitid","","",N,N],[5,"setreuid","","",N,N],[5,"setregid","","",N,N],[5,"getresuid","","",N,N],[5,"getresgid","","",N,N],[5,"acct","","",N,N],[5,"brk","","",N,N],[5,"sbrk","","",N,N],[5,"vfork","","",N,N],[5,"setresgid","","",N,N],[5,"setresuid","","",N,N],[5,"wait4","","",N,N],[5,"openpty","","",N,N],[5,"execvpe","","",N,N],[5,"fexecve","","",N,N],[5,"getifaddrs","","",N,N],[5,"freeifaddrs","","",N,N],[5,"bind","","",N,N],[5,"writev","","",N,N],[5,"readv","","",N,N],[5,"sendmsg","","",N,N],[5,"recvmsg","","",N,N],[0,"linux","","Linux-specific definitions for linux-like values",N,N],[3,"dirent","libc::unix::notbsd::linux","",N,N],[12,"d_ino","","",42,N],[12,"d_off","","",42,N],[12,"d_reclen","","",42,N],[12,"d_type","","",42,N],[12,"d_name","","",42,N],[3,"dirent64","","",N,N],[12,"d_ino","","",43,N],[12,"d_off","","",43,N],[12,"d_reclen","","",43,N],[12,"d_type","","",43,N],[12,"d_name","","",43,N],[3,"rlimit64","","",N,N],[12,"rlim_cur","","",44,N],[12,"rlim_max","","",44,N],[3,"glob_t","","",N,N],[12,"gl_pathc","","",45,N],[12,"gl_pathv","","",45,N],[12,"gl_offs","","",45,N],[12,"gl_flags","","",45,N],[12,"__unused1","","",45,N],[12,"__unused2","","",45,N],[12,"__unused3","","",45,N],[12,"__unused4","","",45,N],[12,"__unused5","","",45,N],[3,"pthread_mutex_t","","",N,N],[12,"__align","","",46,N],[12,"size","","",46,N],[3,"pthread_rwlock_t","","",N,N],[12,"__align","","",47,N],[12,"size","","",47,N],[3,"pthread_mutexattr_t","","",N,N],[12,"__align","","",48,N],[12,"size","","",48,N],[3,"pthread_rwlockattr_t","","",N,N],[12,"__align","","",49,N],[12,"size","","",49,N],[3,"pthread_cond_t","","",N,N],[12,"__align","","",50,N],[12,"size","","",50,N],[3,"pthread_condattr_t","","",N,N],[12,"__align","","",51,N],[12,"size","","",51,N],[3,"passwd","","",N,N],[12,"pw_name","","",52,N],[12,"pw_passwd","","",52,N],[12,"pw_uid","","",52,N],[12,"pw_gid","","",52,N],[12,"pw_gecos","","",52,N],[12,"pw_dir","","",52,N],[12,"pw_shell","","",52,N],[3,"spwd","","",N,N],[12,"sp_namp","","",53,N],[12,"sp_pwdp","","",53,N],[12,"sp_lstchg","","",53,N],[12,"sp_min","","",53,N],[12,"sp_max","","",53,N],[12,"sp_warn","","",53,N],[12,"sp_inact","","",53,N],[12,"sp_expire","","",53,N],[12,"sp_flag","","",53,N],[3,"dqblk","","",N,N],[12,"dqb_bhardlimit","","",54,N],[12,"dqb_bsoftlimit","","",54,N],[12,"dqb_curspace","","",54,N],[12,"dqb_ihardlimit","","",54,N],[12,"dqb_isoftlimit","","",54,N],[12,"dqb_curinodes","","",54,N],[12,"dqb_btime","","",54,N],[12,"dqb_itime","","",54,N],[12,"dqb_valid","","",54,N],[3,"signalfd_siginfo","","",N,N],[12,"ssi_signo","","",55,N],[12,"ssi_errno","","",55,N],[12,"ssi_code","","",55,N],[12,"ssi_pid","","",55,N],[12,"ssi_uid","","",55,N],[12,"ssi_fd","","",55,N],[12,"ssi_tid","","",55,N],[12,"ssi_band","","",55,N],[12,"ssi_overrun","","",55,N],[12,"ssi_trapno","","",55,N],[12,"ssi_status","","",55,N],[12,"ssi_int","","",55,N],[12,"ssi_ptr","","",55,N],[12,"ssi_utime","","",55,N],[12,"ssi_stime","","",55,N],[12,"ssi_addr","","",55,N],[12,"_pad","","",55,N],[3,"itimerspec","","",N,N],[12,"it_interval","","",56,N],[12,"it_value","","",56,N],[3,"fsid_t","","",N,N],[12,"__val","","",57,N],[3,"mq_attr","","",N,N],[12,"mq_flags","","",58,N],[12,"mq_maxmsg","","",58,N],[12,"mq_msgsize","","",58,N],[12,"mq_curmsgs","","",58,N],[12,"pad","","",58,N],[3,"packet_mreq","","",N,N],[12,"mr_ifindex","","",59,N],[12,"mr_type","","",59,N],[12,"mr_alen","","",59,N],[12,"mr_address","","",59,N],[3,"cpu_set_t","","",N,N],[12,"bits","","",60,N],[3,"if_nameindex","","",N,N],[12,"if_index","","",61,N],[12,"if_name","","",61,N],[3,"msginfo","","",N,N],[12,"msgpool","","",62,N],[12,"msgmap","","",62,N],[12,"msgmax","","",62,N],[12,"msgmnb","","",62,N],[12,"msgmni","","",62,N],[12,"msgssz","","",62,N],[12,"msgtql","","",62,N],[12,"msgseg","","",62,N],[3,"mmsghdr","","",N,N],[12,"msg_hdr","","",63,N],[12,"msg_len","","",63,N],[3,"sembuf","","",N,N],[12,"sem_num","","",64,N],[12,"sem_op","","",64,N],[12,"sem_flg","","",64,N],[3,"input_event","","",N,N],[12,"time","","",65,N],[12,"type_","","",65,N],[12,"code","","",65,N],[12,"value","","",65,N],[3,"input_id","","",N,N],[12,"bustype","","",66,N],[12,"vendor","","",66,N],[12,"product","","",66,N],[12,"version","","",66,N],[3,"input_absinfo","","",N,N],[12,"value","","",67,N],[12,"minimum","","",67,N],[12,"maximum","","",67,N],[12,"fuzz","","",67,N],[12,"flat","","",67,N],[12,"resolution","","",67,N],[3,"input_keymap_entry","","",N,N],[12,"flags","","",68,N],[12,"len","","",68,N],[12,"index","","",68,N],[12,"keycode","","",68,N],[12,"scancode","","",68,N],[3,"input_mask","","",N,N],[12,"type_","","",69,N],[12,"codes_size","","",69,N],[12,"codes_ptr","","",69,N],[3,"ff_replay","","",N,N],[12,"length","","",70,N],[12,"delay","","",70,N],[3,"ff_trigger","","",N,N],[12,"button","","",71,N],[12,"interval","","",71,N],[3,"ff_envelope","","",N,N],[12,"attack_length","","",72,N],[12,"attack_level","","",72,N],[12,"fade_length","","",72,N],[12,"fade_level","","",72,N],[3,"ff_constant_effect","","",N,N],[12,"level","","",73,N],[12,"envelope","","",73,N],[3,"ff_ramp_effect","","",N,N],[12,"start_level","","",74,N],[12,"end_level","","",74,N],[12,"envelope","","",74,N],[3,"ff_condition_effect","","",N,N],[12,"right_saturation","","",75,N],[12,"left_saturation","","",75,N],[12,"right_coeff","","",75,N],[12,"left_coeff","","",75,N],[12,"deadband","","",75,N],[12,"center","","",75,N],[3,"ff_periodic_effect","","",N,N],[12,"waveform","","",76,N],[12,"period","","",76,N],[12,"magnitude","","",76,N],[12,"offset","","",76,N],[12,"phase","","",76,N],[12,"envelope","","",76,N],[12,"custom_len","","",76,N],[12,"custom_data","","",76,N],[3,"ff_rumble_effect","","",N,N],[12,"strong_magnitude","","",77,N],[12,"weak_magnitude","","",77,N],[3,"ff_effect","","",N,N],[12,"type_","","",78,N],[12,"id","","",78,N],[12,"direction","","",78,N],[12,"trigger","","",78,N],[12,"replay","","",78,N],[12,"u","","",78,N],[3,"dl_phdr_info","","",N,N],[12,"dlpi_addr","","",79,N],[12,"dlpi_name","","",79,N],[12,"dlpi_phdr","","",79,N],[12,"dlpi_phnum","","",79,N],[12,"dlpi_adds","","",79,N],[12,"dlpi_subs","","",79,N],[12,"dlpi_tls_modid","","",79,N],[12,"dlpi_tls_data","","",79,N],[3,"Elf32_Phdr","","",N,N],[12,"p_type","","",80,N],[12,"p_offset","","",80,N],[12,"p_vaddr","","",80,N],[12,"p_paddr","","",80,N],[12,"p_filesz","","",80,N],[12,"p_memsz","","",80,N],[12,"p_flags","","",80,N],[12,"p_align","","",80,N],[3,"Elf64_Phdr","","",N,N],[12,"p_type","","",81,N],[12,"p_flags","","",81,N],[12,"p_offset","","",81,N],[12,"p_vaddr","","",81,N],[12,"p_paddr","","",81,N],[12,"p_filesz","","",81,N],[12,"p_memsz","","",81,N],[12,"p_align","","",81,N],[3,"ucred","","",N,N],[12,"pid","","",82,N],[12,"uid","","",82,N],[12,"gid","","",82,N],[3,"mntent","","",N,N],[12,"mnt_fsname","","",83,N],[12,"mnt_dir","","",83,N],[12,"mnt_type","","",83,N],[12,"mnt_opts","","",83,N],[12,"mnt_freq","","",83,N],[12,"mnt_passno","","",83,N],[3,"posix_spawn_file_actions_t","","",N,N],[12,"__allocated","","",84,N],[12,"__used","","",84,N],[12,"__actions","","",84,N],[12,"__pad","","",84,N],[3,"posix_spawnattr_t","","",N,N],[12,"__flags","","",85,N],[12,"__pgrp","","",85,N],[12,"__sd","","",85,N],[12,"__ss","","",85,N],[12,"__sp","","",85,N],[12,"__policy","","",85,N],[12,"__pad","","",85,N],[3,"genlmsghdr","","",N,N],[12,"cmd","","",86,N],[12,"version","","",86,N],[12,"reserved","","",86,N],[3,"in6_pktinfo","","",N,N],[12,"ipi6_addr","","",87,N],[12,"ipi6_ifindex","","",87,N],[3,"arpd_request","","",N,N],[12,"req","","",88,N],[12,"ip","","",88,N],[12,"dev","","",88,N],[12,"stamp","","",88,N],[12,"updated","","",88,N],[12,"ha","","",88,N],[4,"fpos64_t","","",N,N],[5,"CPU_ZERO","","",N,N],[5,"CPU_SET","","",N,N],[5,"CPU_CLR","","",N,N],[5,"CPU_ISSET","","",N,[[["usize"],["cpu_set_t"]],["bool"]]],[5,"CPU_EQUAL","","",N,[[["cpu_set_t"],["cpu_set_t"]],["bool"]]],[5,"major","","",N,[[["dev_t"]],["c_uint"]]],[5,"minor","","",N,[[["dev_t"]],["c_uint"]]],[5,"makedev","","",N,[[["c_uint"],["c_uint"]],["dev_t"]]],[5,"IPTOS_TOS","","",N,[[["u8"]],["u8"]]],[5,"IPTOS_PREC","","",N,[[["u8"]],["u8"]]],[5,"RT_TOS","","",N,[[["u8"]],["u8"]]],[5,"RT_ADDRCLASS","","",N,[[["u32"]],["u32"]]],[5,"RT_LOCALADDR","","",N,[[["u32"]],["bool"]]],[5,"aio_read","","",N,N],[5,"aio_write","","",N,N],[5,"aio_fsync","","",N,N],[5,"aio_error","","",N,N],[5,"aio_return","","",N,N],[5,"aio_suspend","","",N,N],[5,"aio_cancel","","",N,N],[5,"lio_listio","","",N,N],[5,"lutimes","","",N,N],[5,"setpwent","","",N,N],[5,"endpwent","","",N,N],[5,"getpwent","","",N,N],[5,"setgrent","","",N,N],[5,"endgrent","","",N,N],[5,"getgrent","","",N,N],[5,"setspent","","",N,N],[5,"endspent","","",N,N],[5,"getspent","","",N,N],[5,"getspnam","","",N,N],[5,"shm_open","","",N,N],[5,"shmget","","",N,N],[5,"shmat","","",N,N],[5,"shmdt","","",N,N],[5,"shmctl","","",N,N],[5,"ftok","","",N,N],[5,"semget","","",N,N],[5,"semop","","",N,N],[5,"semctl","","",N,N],[5,"msgctl","","",N,N],[5,"msgget","","",N,N],[5,"msgrcv","","",N,N],[5,"msgsnd","","",N,N],[5,"mprotect","","",N,N],[5,"__errno_location","","",N,N],[5,"fopen64","","",N,N],[5,"freopen64","","",N,N],[5,"tmpfile64","","",N,N],[5,"fgetpos64","","",N,N],[5,"fsetpos64","","",N,N],[5,"fseeko64","","",N,N],[5,"ftello64","","",N,N],[5,"fallocate","","",N,N],[5,"posix_fallocate","","",N,N],[5,"readahead","","",N,N],[5,"getxattr","","",N,N],[5,"lgetxattr","","",N,N],[5,"fgetxattr","","",N,N],[5,"setxattr","","",N,N],[5,"lsetxattr","","",N,N],[5,"fsetxattr","","",N,N],[5,"listxattr","","",N,N],[5,"llistxattr","","",N,N],[5,"flistxattr","","",N,N],[5,"removexattr","","",N,N],[5,"lremovexattr","","",N,N],[5,"fremovexattr","","",N,N],[5,"signalfd","","",N,N],[5,"timerfd_create","","",N,N],[5,"timerfd_gettime","","",N,N],[5,"timerfd_settime","","",N,N],[5,"pwritev","","",N,N],[5,"preadv","","",N,N],[5,"quotactl","","",N,N],[5,"mq_open","","",N,N],[5,"mq_close","","",N,N],[5,"mq_unlink","","",N,N],[5,"mq_receive","","",N,N],[5,"mq_send","","",N,N],[5,"mq_getattr","","",N,N],[5,"mq_setattr","","",N,N],[5,"epoll_pwait","","",N,N],[5,"dup3","","",N,N],[5,"mkostemp","","",N,N],[5,"mkostemps","","",N,N],[5,"sigtimedwait","","",N,N],[5,"sigwaitinfo","","",N,N],[5,"nl_langinfo_l","","",N,N],[5,"getnameinfo","","",N,N],[5,"pthread_setschedprio","","",N,N],[5,"prlimit","","",N,N],[5,"prlimit64","","",N,N],[5,"getloadavg","","",N,N],[5,"process_vm_readv","","",N,N],[5,"process_vm_writev","","",N,N],[5,"reboot","","",N,N],[5,"setfsgid","","",N,N],[5,"setfsuid","","",N,N],[5,"mkfifoat","","",N,N],[5,"if_nameindex","","",N,N],[5,"if_freenameindex","","",N,N],[5,"sync_file_range","","",N,N],[5,"mremap","","",N,N],[5,"glob","","",N,N],[5,"globfree","","",N,N],[5,"posix_madvise","","",N,N],[5,"shm_unlink","","",N,N],[5,"seekdir","","",N,N],[5,"telldir","","",N,N],[5,"madvise","","",N,N],[5,"msync","","",N,N],[5,"remap_file_pages","","",N,N],[5,"recvfrom","","",N,N],[5,"mkstemps","","",N,N],[5,"futimes","","",N,N],[5,"nl_langinfo","","",N,N],[5,"getdomainname","","",N,N],[5,"setdomainname","","",N,N],[5,"vhangup","","",N,N],[5,"sendmmsg","","",N,N],[5,"recvmmsg","","",N,N],[5,"sync","","",N,N],[5,"syscall","","",N,N],[5,"sched_getaffinity","","",N,N],[5,"sched_setaffinity","","",N,N],[5,"epoll_create","","",N,N],[5,"epoll_create1","","",N,N],[5,"epoll_wait","","",N,N],[5,"epoll_ctl","","",N,N],[5,"pthread_getschedparam","","",N,N],[5,"unshare","","",N,N],[5,"umount","","",N,N],[5,"sched_get_priority_max","","",N,N],[5,"tee","","",N,N],[5,"settimeofday","","",N,N],[5,"splice","","",N,N],[5,"eventfd","","",N,N],[5,"sched_rr_get_interval","","",N,N],[5,"sem_timedwait","","",N,N],[5,"sem_getvalue","","",N,N],[5,"sched_setparam","","",N,N],[5,"setns","","",N,N],[5,"swapoff","","",N,N],[5,"vmsplice","","",N,N],[5,"mount","","",N,N],[5,"personality","","",N,N],[5,"prctl","","",N,N],[5,"sched_getparam","","",N,N],[5,"ppoll","","",N,N],[5,"pthread_mutex_timedlock","","",N,N],[5,"clone","","",N,N],[5,"sched_getscheduler","","",N,N],[5,"clock_nanosleep","","",N,N],[5,"pthread_attr_getguardsize","","",N,N],[5,"sethostname","","",N,N],[5,"sched_get_priority_min","","",N,N],[5,"pthread_condattr_getpshared","","",N,N],[5,"sysinfo","","",N,N],[5,"umount2","","",N,N],[5,"pthread_setschedparam","","",N,N],[5,"swapon","","",N,N],[5,"sched_setscheduler","","",N,N],[5,"sendfile","","",N,N],[5,"sigsuspend","","",N,N],[5,"getgrgid_r","","",N,N],[5,"sigaltstack","","",N,N],[5,"sem_close","","",N,N],[5,"getdtablesize","","",N,N],[5,"getgrnam_r","","",N,N],[5,"initgroups","","",N,N],[5,"pthread_sigmask","","",N,N],[5,"sem_open","","",N,N],[5,"getgrnam","","",N,N],[5,"pthread_cancel","","",N,N],[5,"pthread_kill","","",N,N],[5,"sem_unlink","","",N,N],[5,"daemon","","",N,N],[5,"getpwnam_r","","",N,N],[5,"getpwuid_r","","",N,N],[5,"sigwait","","",N,N],[5,"pthread_atfork","","",N,N],[5,"getgrgid","","",N,N],[5,"getgrouplist","","",N,N],[5,"pthread_mutexattr_getpshared","","",N,N],[5,"popen","","",N,N],[5,"faccessat","","",N,N],[5,"pthread_create","","",N,N],[5,"dl_iterate_phdr","","",N,N],[5,"setmntent","","",N,N],[5,"getmntent","","",N,N],[5,"addmntent","","",N,N],[5,"endmntent","","",N,N],[5,"hasmntopt","","",N,N],[5,"posix_spawn","","",N,N],[5,"posix_spawnp","","",N,N],[5,"posix_spawnattr_init","","",N,N],[5,"posix_spawnattr_destroy","","",N,N],[5,"posix_spawnattr_getsigdefault","","",N,N],[5,"posix_spawnattr_setsigdefault","","",N,N],[5,"posix_spawnattr_getsigmask","","",N,N],[5,"posix_spawnattr_setsigmask","","",N,N],[5,"posix_spawnattr_getflags","","",N,N],[5,"posix_spawnattr_setflags","","",N,N],[5,"posix_spawnattr_getpgroup","","",N,N],[5,"posix_spawnattr_setpgroup","","",N,N],[5,"posix_spawnattr_getschedpolicy","","",N,N],[5,"posix_spawnattr_setschedpolicy","","",N,N],[5,"posix_spawnattr_getschedparam","","",N,N],[5,"posix_spawnattr_setschedparam","","",N,N],[5,"posix_spawn_file_actions_init","","",N,N],[5,"posix_spawn_file_actions_destroy","","",N,N],[5,"posix_spawn_file_actions_addopen","","",N,N],[5,"posix_spawn_file_actions_addclose","","",N,N],[5,"posix_spawn_file_actions_adddup2","","",N,N],[5,"fread_unlocked","","",N,N],[0,"other","","",N,N],[3,"aiocb","libc::unix::notbsd::linux::other","",N,N],[12,"aio_fildes","","",89,N],[12,"aio_lio_opcode","","",89,N],[12,"aio_reqprio","","",89,N],[12,"aio_buf","","",89,N],[12,"aio_nbytes","","",89,N],[12,"aio_sigevent","","",89,N],[12,"__next_prio","","",89,N],[12,"__abs_prio","","",89,N],[12,"__policy","","",89,N],[12,"__error_code","","",89,N],[12,"__return_value","","",89,N],[12,"aio_offset","","",89,N],[12,"__glibc_reserved","","",89,N],[3,"__exit_status","","",N,N],[12,"e_termination","","",90,N],[12,"e_exit","","",90,N],[3,"__timeval","","",N,N],[12,"tv_sec","","",91,N],[12,"tv_usec","","",91,N],[3,"utmpx","","",N,N],[12,"ut_type","","",92,N],[12,"ut_pid","","",92,N],[12,"ut_line","","",92,N],[12,"ut_id","","",92,N],[12,"ut_user","","",92,N],[12,"ut_host","","",92,N],[12,"ut_exit","","",92,N],[12,"ut_session","","",92,N],[12,"ut_tv","","",92,N],[12,"ut_addr_v6","","",92,N],[12,"__glibc_reserved","","",92,N],[3,"sigaction","","",N,N],[12,"sa_sigaction","","",93,N],[12,"sa_mask","","",93,N],[12,"sa_flags","","",93,N],[12,"sa_restorer","","",93,N],[3,"stack_t","","",N,N],[12,"ss_sp","","",94,N],[12,"ss_flags","","",94,N],[12,"ss_size","","",94,N],[3,"siginfo_t","","",N,N],[12,"si_signo","","",95,N],[12,"si_errno","","",95,N],[12,"si_code","","",95,N],[12,"_pad","","",95,N],[12,"_align","","",95,N],[3,"glob64_t","","",N,N],[12,"gl_pathc","","",96,N],[12,"gl_pathv","","",96,N],[12,"gl_offs","","",96,N],[12,"gl_flags","","",96,N],[12,"__unused1","","",96,N],[12,"__unused2","","",96,N],[12,"__unused3","","",96,N],[12,"__unused4","","",96,N],[12,"__unused5","","",96,N],[3,"statfs","","",N,N],[12,"f_type","","",97,N],[12,"f_bsize","","",97,N],[12,"f_blocks","","",97,N],[12,"f_bfree","","",97,N],[12,"f_bavail","","",97,N],[12,"f_files","","",97,N],[12,"f_ffree","","",97,N],[12,"f_fsid","","",97,N],[12,"f_namelen","","",97,N],[12,"f_frsize","","",97,N],[12,"f_spare","","",97,N],[3,"msghdr","","",N,N],[12,"msg_name","","",98,N],[12,"msg_namelen","","",98,N],[12,"msg_iov","","",98,N],[12,"msg_iovlen","","",98,N],[12,"msg_control","","",98,N],[12,"msg_controllen","","",98,N],[12,"msg_flags","","",98,N],[3,"cmsghdr","","",N,N],[12,"cmsg_len","","",99,N],[12,"cmsg_level","","",99,N],[12,"cmsg_type","","",99,N],[3,"termios","","",N,N],[12,"c_iflag","","",100,N],[12,"c_oflag","","",100,N],[12,"c_cflag","","",100,N],[12,"c_lflag","","",100,N],[12,"c_line","","",100,N],[12,"c_cc","","",100,N],[12,"c_ispeed","","",100,N],[12,"c_ospeed","","",100,N],[3,"flock","","",N,N],[12,"l_type","","",101,N],[12,"l_whence","","",101,N],[12,"l_start","","",101,N],[12,"l_len","","",101,N],[12,"l_pid","","",101,N],[3,"sem_t","","",N,N],[12,"__size","","",102,N],[12,"__align","","",102,N],[3,"mallinfo","","",N,N],[12,"arena","","",103,N],[12,"ordblks","","",103,N],[12,"smblks","","",103,N],[12,"hblks","","",103,N],[12,"hblkhd","","",103,N],[12,"usmblks","","",103,N],[12,"fsmblks","","",103,N],[12,"uordblks","","",103,N],[12,"fordblks","","",103,N],[12,"keepcost","","",103,N],[3,"nlmsghdr","","",N,N],[12,"nlmsg_len","","",104,N],[12,"nlmsg_type","","",104,N],[12,"nlmsg_flags","","",104,N],[12,"nlmsg_seq","","",104,N],[12,"nlmsg_pid","","",104,N],[3,"nlmsgerr","","",N,N],[12,"error","","",105,N],[12,"msg","","",105,N],[3,"nl_pktinfo","","",N,N],[12,"group","","",106,N],[3,"nl_mmap_req","","",N,N],[12,"nm_block_size","","",107,N],[12,"nm_block_nr","","",107,N],[12,"nm_frame_size","","",107,N],[12,"nm_frame_nr","","",107,N],[3,"nl_mmap_hdr","","",N,N],[12,"nm_status","","",108,N],[12,"nm_len","","",108,N],[12,"nm_group","","",108,N],[12,"nm_pid","","",108,N],[12,"nm_uid","","",108,N],[12,"nm_gid","","",108,N],[3,"nlattr","","",N,N],[12,"nla_len","","",109,N],[12,"nla_type","","",109,N],[3,"rtentry","","",N,N],[12,"rt_pad1","","",110,N],[12,"rt_dst","","",110,N],[12,"rt_gateway","","",110,N],[12,"rt_genmask","","",110,N],[12,"rt_flags","","",110,N],[12,"rt_pad2","","",110,N],[12,"rt_pad3","","",110,N],[12,"rt_tos","","",110,N],[12,"rt_class","","",110,N],[12,"rt_pad4","","",110,N],[12,"rt_metric","","",110,N],[12,"rt_dev","","",110,N],[12,"rt_mtu","","",110,N],[12,"rt_window","","",110,N],[12,"rt_irtt","","",110,N],[5,"NLA_ALIGN","","",N,[[["c_int"]],["c_int"]]],[5,"utmpxname","","",N,N],[5,"getutxent","","",N,N],[5,"getutxid","","",N,N],[5,"getutxline","","",N,N],[5,"pututxline","","",N,N],[5,"setutxent","","",N,N],[5,"endutxent","","",N,N],[5,"getpt","","",N,N],[5,"ioctl","","",N,N],[5,"backtrace","","",N,N],[5,"glob64","","",N,N],[5,"globfree64","","",N,N],[5,"ptrace","","",N,N],[5,"pthread_attr_getaffinity_np","","",N,N],[5,"pthread_attr_setaffinity_np","","",N,N],[5,"getpriority","","",N,N],[5,"setpriority","","",N,N],[5,"pthread_getaffinity_np","","",N,N],[5,"pthread_setaffinity_np","","",N,N],[5,"pthread_rwlockattr_getkind_np","","",N,N],[5,"pthread_rwlockattr_setkind_np","","",N,N],[5,"sched_getcpu","","",N,N],[5,"mallinfo","","",N,N],[5,"malloc_usable_size","","",N,N],[5,"getauxval","","",N,N],[5,"getpwent_r","","",N,N],[5,"getgrent_r","","",N,N],[0,"b64","","64-bit specific definitions for linux-like values",N,N],[3,"sigset_t","libc::unix::notbsd::linux::other::b64","",N,N],[12,"__val","","",111,N],[3,"sysinfo","","",N,N],[12,"uptime","","",112,N],[12,"loads","","",112,N],[12,"totalram","","",112,N],[12,"freeram","","",112,N],[12,"sharedram","","",112,N],[12,"bufferram","","",112,N],[12,"totalswap","","",112,N],[12,"freeswap","","",112,N],[12,"procs","","",112,N],[12,"pad","","",112,N],[12,"totalhigh","","",112,N],[12,"freehigh","","",112,N],[12,"mem_unit","","",112,N],[12,"_f","","",112,N],[3,"msqid_ds","","",N,N],[12,"msg_perm","","",113,N],[12,"msg_stime","","",113,N],[12,"msg_rtime","","",113,N],[12,"msg_ctime","","",113,N],[12,"__msg_cbytes","","",113,N],[12,"msg_qnum","","",113,N],[12,"msg_qbytes","","",113,N],[12,"msg_lspid","","",113,N],[12,"msg_lrpid","","",113,N],[12,"__glibc_reserved4","","",113,N],[12,"__glibc_reserved5","","",113,N],[0,"x86_64","","x86_64-specific definitions for 64-bit linux-like values",N,N],[3,"stat","libc::unix::notbsd::linux::other::b64::x86_64","",N,N],[12,"st_dev","","",114,N],[12,"st_ino","","",114,N],[12,"st_nlink","","",114,N],[12,"st_mode","","",114,N],[12,"st_uid","","",114,N],[12,"st_gid","","",114,N],[12,"__pad0","","",114,N],[12,"st_rdev","","",114,N],[12,"st_size","","",114,N],[12,"st_blksize","","",114,N],[12,"st_blocks","","",114,N],[12,"st_atime","","",114,N],[12,"st_atime_nsec","","",114,N],[12,"st_mtime","","",114,N],[12,"st_mtime_nsec","","",114,N],[12,"st_ctime","","",114,N],[12,"st_ctime_nsec","","",114,N],[12,"__unused","","",114,N],[3,"stat64","","",N,N],[12,"st_dev","","",115,N],[12,"st_ino","","",115,N],[12,"st_nlink","","",115,N],[12,"st_mode","","",115,N],[12,"st_uid","","",115,N],[12,"st_gid","","",115,N],[12,"__pad0","","",115,N],[12,"st_rdev","","",115,N],[12,"st_size","","",115,N],[12,"st_blksize","","",115,N],[12,"st_blocks","","",115,N],[12,"st_atime","","",115,N],[12,"st_atime_nsec","","",115,N],[12,"st_mtime","","",115,N],[12,"st_mtime_nsec","","",115,N],[12,"st_ctime","","",115,N],[12,"st_ctime_nsec","","",115,N],[12,"__reserved","","",115,N],[3,"statfs64","","",N,N],[12,"f_type","","",116,N],[12,"f_bsize","","",116,N],[12,"f_blocks","","",116,N],[12,"f_bfree","","",116,N],[12,"f_bavail","","",116,N],[12,"f_files","","",116,N],[12,"f_ffree","","",116,N],[12,"f_fsid","","",116,N],[12,"f_namelen","","",116,N],[12,"f_frsize","","",116,N],[12,"f_flags","","",116,N],[12,"f_spare","","",116,N],[3,"statvfs64","","",N,N],[12,"f_bsize","","",117,N],[12,"f_frsize","","",117,N],[12,"f_blocks","","",117,N],[12,"f_bfree","","",117,N],[12,"f_bavail","","",117,N],[12,"f_files","","",117,N],[12,"f_ffree","","",117,N],[12,"f_favail","","",117,N],[12,"f_fsid","","",117,N],[12,"f_flag","","",117,N],[12,"f_namemax","","",117,N],[12,"__f_spare","","",117,N],[3,"pthread_attr_t","","",N,N],[12,"__size","","",118,N],[3,"_libc_fpxreg","","",N,N],[12,"significand","","",119,N],[12,"exponent","","",119,N],[12,"__private","","",119,N],[3,"_libc_xmmreg","","",N,N],[12,"element","","",120,N],[3,"_libc_fpstate","","",N,N],[12,"cwd","","",121,N],[12,"swd","","",121,N],[12,"ftw","","",121,N],[12,"fop","","",121,N],[12,"rip","","",121,N],[12,"rdp","","",121,N],[12,"mxcsr","","",121,N],[12,"mxcr_mask","","",121,N],[12,"_st","","",121,N],[12,"_xmm","","",121,N],[12,"__private","","",121,N],[3,"user_fpregs_struct","","",N,N],[12,"cwd","","",122,N],[12,"swd","","",122,N],[12,"ftw","","",122,N],[12,"fop","","",122,N],[12,"rip","","",122,N],[12,"rdp","","",122,N],[12,"mxcsr","","",122,N],[12,"mxcr_mask","","",122,N],[12,"st_space","","",122,N],[12,"xmm_space","","",122,N],[12,"padding","","",122,N],[3,"user_regs_struct","","",N,N],[12,"r15","","",123,N],[12,"r14","","",123,N],[12,"r13","","",123,N],[12,"r12","","",123,N],[12,"rbp","","",123,N],[12,"rbx","","",123,N],[12,"r11","","",123,N],[12,"r10","","",123,N],[12,"r9","","",123,N],[12,"r8","","",123,N],[12,"rax","","",123,N],[12,"rcx","","",123,N],[12,"rdx","","",123,N],[12,"rsi","","",123,N],[12,"rdi","","",123,N],[12,"orig_rax","","",123,N],[12,"rip","","",123,N],[12,"cs","","",123,N],[12,"eflags","","",123,N],[12,"rsp","","",123,N],[12,"ss","","",123,N],[12,"fs_base","","",123,N],[12,"gs_base","","",123,N],[12,"ds","","",123,N],[12,"es","","",123,N],[12,"fs","","",123,N],[12,"gs","","",123,N],[3,"user","","",N,N],[12,"regs","","",124,N],[12,"u_fpvalid","","",124,N],[12,"i387","","",124,N],[12,"u_tsize","","",124,N],[12,"u_dsize","","",124,N],[12,"u_ssize","","",124,N],[12,"start_code","","",124,N],[12,"start_stack","","",124,N],[12,"signal","","",124,N],[12,"__reserved","","",124,N],[12,"u_ar0","","",124,N],[12,"u_fpstate","","",124,N],[12,"magic","","",124,N],[12,"u_comm","","",124,N],[12,"u_debugreg","","",124,N],[3,"mcontext_t","","",N,N],[12,"gregs","","",125,N],[12,"fpregs","","",125,N],[12,"__private","","",125,N],[3,"ucontext_t","","",N,N],[12,"uc_flags","","",126,N],[12,"uc_link","","",126,N],[12,"uc_stack","","",126,N],[12,"uc_mcontext","","",126,N],[12,"uc_sigmask","","",126,N],[12,"__private","","",126,N],[3,"ipc_perm","","",N,N],[12,"__key","","",127,N],[12,"uid","","",127,N],[12,"gid","","",127,N],[12,"cuid","","",127,N],[12,"cgid","","",127,N],[12,"mode","","",127,N],[12,"__pad1","","",127,N],[12,"__seq","","",127,N],[12,"__pad2","","",127,N],[12,"__unused1","","",127,N],[12,"__unused2","","",127,N],[3,"shmid_ds","","",N,N],[12,"shm_perm","","",128,N],[12,"shm_segsz","","",128,N],[12,"shm_atime","","",128,N],[12,"shm_dtime","","",128,N],[12,"shm_ctime","","",128,N],[12,"shm_cpid","","",128,N],[12,"shm_lpid","","",128,N],[12,"shm_nattch","","",128,N],[12,"__unused4","","",128,N],[12,"__unused5","","",128,N],[3,"termios2","","",N,N],[12,"c_iflag","","",129,N],[12,"c_oflag","","",129,N],[12,"c_cflag","","",129,N],[12,"c_lflag","","",129,N],[12,"c_line","","",129,N],[12,"c_cc","","",129,N],[12,"c_ispeed","","",129,N],[12,"c_ospeed","","",129,N],[5,"getcontext","","",N,N],[5,"setcontext","","",N,N],[5,"makecontext","","",N,N],[5,"swapcontext","","",N,N],[5,"iopl","","",N,N],[5,"ioperm","","",N,N],[6,"c_char","","",N,N],[6,"wchar_t","","",N,N],[6,"nlink_t","","",N,N],[6,"blksize_t","","",N,N],[6,"greg_t","","",N,N],[6,"suseconds_t","","",N,N],[6,"__u64","","",N,N],[17,"TIOCGSOFTCAR","","",N,N],[17,"TIOCSSOFTCAR","","",N,N],[17,"RLIMIT_NOFILE","","",N,N],[17,"RLIMIT_NPROC","","",N,N],[17,"O_APPEND","","",N,N],[17,"O_CREAT","","",N,N],[17,"O_EXCL","","",N,N],[17,"O_NOCTTY","","",N,N],[17,"O_NONBLOCK","","",N,N],[17,"O_SYNC","","",N,N],[17,"O_RSYNC","","",N,N],[17,"O_DSYNC","","",N,N],[17,"O_FSYNC","","",N,N],[17,"O_NOATIME","","",N,N],[17,"O_PATH","","",N,N],[17,"O_TMPFILE","","",N,N],[17,"MAP_GROWSDOWN","","",N,N],[17,"EDEADLK","","",N,N],[17,"ENAMETOOLONG","","",N,N],[17,"ENOLCK","","",N,N],[17,"ENOSYS","","",N,N],[17,"ENOTEMPTY","","",N,N],[17,"ELOOP","","",N,N],[17,"ENOMSG","","",N,N],[17,"EIDRM","","",N,N],[17,"ECHRNG","","",N,N],[17,"EL2NSYNC","","",N,N],[17,"EL3HLT","","",N,N],[17,"EL3RST","","",N,N],[17,"ELNRNG","","",N,N],[17,"EUNATCH","","",N,N],[17,"ENOCSI","","",N,N],[17,"EL2HLT","","",N,N],[17,"EBADE","","",N,N],[17,"EBADR","","",N,N],[17,"EXFULL","","",N,N],[17,"ENOANO","","",N,N],[17,"EBADRQC","","",N,N],[17,"EBADSLT","","",N,N],[17,"EMULTIHOP","","",N,N],[17,"EOVERFLOW","","",N,N],[17,"ENOTUNIQ","","",N,N],[17,"EBADFD","","",N,N],[17,"EBADMSG","","",N,N],[17,"EREMCHG","","",N,N],[17,"ELIBACC","","",N,N],[17,"ELIBBAD","","",N,N],[17,"ELIBSCN","","",N,N],[17,"ELIBMAX","","",N,N],[17,"ELIBEXEC","","",N,N],[17,"EILSEQ","","",N,N],[17,"ERESTART","","",N,N],[17,"ESTRPIPE","","",N,N],[17,"EUSERS","","",N,N],[17,"ENOTSOCK","","",N,N],[17,"EDESTADDRREQ","","",N,N],[17,"EMSGSIZE","","",N,N],[17,"EPROTOTYPE","","",N,N],[17,"ENOPROTOOPT","","",N,N],[17,"EPROTONOSUPPORT","","",N,N],[17,"ESOCKTNOSUPPORT","","",N,N],[17,"EOPNOTSUPP","","",N,N],[17,"EPFNOSUPPORT","","",N,N],[17,"EAFNOSUPPORT","","",N,N],[17,"EADDRINUSE","","",N,N],[17,"EADDRNOTAVAIL","","",N,N],[17,"ENETDOWN","","",N,N],[17,"ENETUNREACH","","",N,N],[17,"ENETRESET","","",N,N],[17,"ECONNABORTED","","",N,N],[17,"ECONNRESET","","",N,N],[17,"ENOBUFS","","",N,N],[17,"EISCONN","","",N,N],[17,"ENOTCONN","","",N,N],[17,"ESHUTDOWN","","",N,N],[17,"ETOOMANYREFS","","",N,N],[17,"ETIMEDOUT","","",N,N],[17,"ECONNREFUSED","","",N,N],[17,"EHOSTDOWN","","",N,N],[17,"EHOSTUNREACH","","",N,N],[17,"EALREADY","","",N,N],[17,"EINPROGRESS","","",N,N],[17,"ESTALE","","",N,N],[17,"EDQUOT","","",N,N],[17,"ENOMEDIUM","","",N,N],[17,"EMEDIUMTYPE","","",N,N],[17,"ECANCELED","","",N,N],[17,"ENOKEY","","",N,N],[17,"EKEYEXPIRED","","",N,N],[17,"EKEYREVOKED","","",N,N],[17,"EKEYREJECTED","","",N,N],[17,"EOWNERDEAD","","",N,N],[17,"ENOTRECOVERABLE","","",N,N],[17,"EHWPOISON","","",N,N],[17,"ERFKILL","","",N,N],[17,"SOL_SOCKET","","",N,N],[17,"SO_REUSEADDR","","",N,N],[17,"SO_TYPE","","",N,N],[17,"SO_ERROR","","",N,N],[17,"SO_DONTROUTE","","",N,N],[17,"SO_BROADCAST","","",N,N],[17,"SO_SNDBUF","","",N,N],[17,"SO_RCVBUF","","",N,N],[17,"SO_SNDBUFFORCE","","",N,N],[17,"SO_RCVBUFFORCE","","",N,N],[17,"SO_KEEPALIVE","","",N,N],[17,"SO_OOBINLINE","","",N,N],[17,"SO_NO_CHECK","","",N,N],[17,"SO_PRIORITY","","",N,N],[17,"SO_LINGER","","",N,N],[17,"SO_BSDCOMPAT","","",N,N],[17,"SO_REUSEPORT","","",N,N],[17,"SO_PASSCRED","","",N,N],[17,"SO_PEERCRED","","",N,N],[17,"SO_RCVLOWAT","","",N,N],[17,"SO_SNDLOWAT","","",N,N],[17,"SO_RCVTIMEO","","",N,N],[17,"SO_SNDTIMEO","","",N,N],[17,"SO_SECURITY_AUTHENTICATION","","",N,N],[17,"SO_SECURITY_ENCRYPTION_TRANSPORT","","",N,N],[17,"SO_SECURITY_ENCRYPTION_NETWORK","","",N,N],[17,"SO_BINDTODEVICE","","",N,N],[17,"SO_ATTACH_FILTER","","",N,N],[17,"SO_DETACH_FILTER","","",N,N],[17,"SO_GET_FILTER","","",N,N],[17,"SO_PEERNAME","","",N,N],[17,"SO_TIMESTAMP","","",N,N],[17,"SO_ACCEPTCONN","","",N,N],[17,"SO_PEERSEC","","",N,N],[17,"SO_PASSSEC","","",N,N],[17,"SO_TIMESTAMPNS","","",N,N],[17,"SCM_TIMESTAMPNS","","",N,N],[17,"SO_MARK","","",N,N],[17,"SO_TIMESTAMPING","","",N,N],[17,"SCM_TIMESTAMPING","","",N,N],[17,"SO_PROTOCOL","","",N,N],[17,"SO_DOMAIN","","",N,N],[17,"SO_RXQ_OVFL","","",N,N],[17,"SO_WIFI_STATUS","","",N,N],[17,"SCM_WIFI_STATUS","","",N,N],[17,"SO_PEEK_OFF","","",N,N],[17,"SO_NOFCS","","",N,N],[17,"SO_LOCK_FILTER","","",N,N],[17,"SO_SELECT_ERR_QUEUE","","",N,N],[17,"SO_BUSY_POLL","","",N,N],[17,"SO_MAX_PACING_RATE","","",N,N],[17,"SO_BPF_EXTENSIONS","","",N,N],[17,"SO_INCOMING_CPU","","",N,N],[17,"SO_ATTACH_BPF","","",N,N],[17,"SO_DETACH_BPF","","",N,N],[17,"SA_ONSTACK","","",N,N],[17,"SA_SIGINFO","","",N,N],[17,"SA_NOCLDWAIT","","",N,N],[17,"SIGCHLD","","",N,N],[17,"SIGBUS","","",N,N],[17,"SIGUSR1","","",N,N],[17,"SIGUSR2","","",N,N],[17,"SIGCONT","","",N,N],[17,"SIGSTOP","","",N,N],[17,"SIGTSTP","","",N,N],[17,"SIGURG","","",N,N],[17,"SIGIO","","",N,N],[17,"SIGSYS","","",N,N],[17,"SIGSTKFLT","","",N,N],[17,"SIGUNUSED","","",N,N],[17,"SIGPOLL","","",N,N],[17,"SIGPWR","","",N,N],[17,"SIG_SETMASK","","",N,N],[17,"SIG_BLOCK","","",N,N],[17,"SIG_UNBLOCK","","",N,N],[17,"POLLWRNORM","","",N,N],[17,"POLLWRBAND","","",N,N],[17,"O_ASYNC","","",N,N],[17,"O_NDELAY","","",N,N],[17,"PTRACE_DETACH","","",N,N],[17,"EFD_NONBLOCK","","",N,N],[17,"F_GETLK","","",N,N],[17,"F_GETOWN","","",N,N],[17,"F_SETOWN","","",N,N],[17,"F_SETLK","","",N,N],[17,"F_SETLKW","","",N,N],[17,"F_RDLCK","","",N,N],[17,"F_WRLCK","","",N,N],[17,"F_UNLCK","","",N,N],[17,"SFD_NONBLOCK","","",N,N],[17,"TIOCEXCL","","",N,N],[17,"TIOCNXCL","","",N,N],[17,"TIOCSCTTY","","",N,N],[17,"TIOCSTI","","",N,N],[17,"TIOCMGET","","",N,N],[17,"TIOCMBIS","","",N,N],[17,"TIOCMBIC","","",N,N],[17,"TIOCMSET","","",N,N],[17,"TIOCCONS","","",N,N],[17,"SFD_CLOEXEC","","",N,N],[17,"NCCS","","",N,N],[17,"O_TRUNC","","",N,N],[17,"O_CLOEXEC","","",N,N],[17,"EBFONT","","",N,N],[17,"ENOSTR","","",N,N],[17,"ENODATA","","",N,N],[17,"ETIME","","",N,N],[17,"ENOSR","","",N,N],[17,"ENONET","","",N,N],[17,"ENOPKG","","",N,N],[17,"EREMOTE","","",N,N],[17,"ENOLINK","","",N,N],[17,"EADV","","",N,N],[17,"ESRMNT","","",N,N],[17,"ECOMM","","",N,N],[17,"EPROTO","","",N,N],[17,"EDOTDOT","","",N,N],[17,"SA_NODEFER","","",N,N],[17,"SA_RESETHAND","","",N,N],[17,"SA_RESTART","","",N,N],[17,"SA_NOCLDSTOP","","",N,N],[17,"EPOLL_CLOEXEC","","",N,N],[17,"EFD_CLOEXEC","","",N,N],[17,"__SIZEOF_PTHREAD_CONDATTR_T","","",N,N],[17,"__SIZEOF_PTHREAD_MUTEXATTR_T","","",N,N],[17,"O_DIRECT","","",N,N],[17,"O_DIRECTORY","","",N,N],[17,"O_NOFOLLOW","","",N,N],[17,"MAP_LOCKED","","",N,N],[17,"MAP_NORESERVE","","",N,N],[17,"MAP_32BIT","","",N,N],[17,"EDEADLOCK","","",N,N],[17,"FIOCLEX","","",N,N],[17,"FIONBIO","","",N,N],[17,"PTRACE_GETFPREGS","","",N,N],[17,"PTRACE_SETFPREGS","","",N,N],[17,"PTRACE_GETFPXREGS","","",N,N],[17,"PTRACE_SETFPXREGS","","",N,N],[17,"PTRACE_GETREGS","","",N,N],[17,"PTRACE_SETREGS","","",N,N],[17,"PTRACE_PEEKSIGINFO_SHARED","","",N,N],[17,"MCL_CURRENT","","",N,N],[17,"MCL_FUTURE","","",N,N],[17,"SIGSTKSZ","","",N,N],[17,"MINSIGSTKSZ","","",N,N],[17,"CBAUD","","",N,N],[17,"TAB1","","",N,N],[17,"TAB2","","",N,N],[17,"TAB3","","",N,N],[17,"CR1","","",N,N],[17,"CR2","","",N,N],[17,"CR3","","",N,N],[17,"FF1","","",N,N],[17,"BS1","","",N,N],[17,"VT1","","",N,N],[17,"VWERASE","","",N,N],[17,"VREPRINT","","",N,N],[17,"VSUSP","","",N,N],[17,"VSTART","","",N,N],[17,"VSTOP","","",N,N],[17,"VDISCARD","","",N,N],[17,"VTIME","","",N,N],[17,"IXON","","",N,N],[17,"IXOFF","","",N,N],[17,"ONLCR","","",N,N],[17,"CSIZE","","",N,N],[17,"CS6","","",N,N],[17,"CS7","","",N,N],[17,"CS8","","",N,N],[17,"CSTOPB","","",N,N],[17,"CREAD","","",N,N],[17,"PARENB","","",N,N],[17,"PARODD","","",N,N],[17,"HUPCL","","",N,N],[17,"CLOCAL","","",N,N],[17,"ECHOKE","","",N,N],[17,"ECHOE","","",N,N],[17,"ECHOK","","",N,N],[17,"ECHONL","","",N,N],[17,"ECHOPRT","","",N,N],[17,"ECHOCTL","","",N,N],[17,"ISIG","","",N,N],[17,"ICANON","","",N,N],[17,"PENDIN","","",N,N],[17,"NOFLSH","","",N,N],[17,"CIBAUD","","",N,N],[17,"CBAUDEX","","",N,N],[17,"VSWTC","","",N,N],[17,"OLCUC","","",N,N],[17,"NLDLY","","",N,N],[17,"CRDLY","","",N,N],[17,"TABDLY","","",N,N],[17,"BSDLY","","",N,N],[17,"FFDLY","","",N,N],[17,"VTDLY","","",N,N],[17,"XTABS","","",N,N],[17,"B0","","",N,N],[17,"B50","","",N,N],[17,"B75","","",N,N],[17,"B110","","",N,N],[17,"B134","","",N,N],[17,"B150","","",N,N],[17,"B200","","",N,N],[17,"B300","","",N,N],[17,"B600","","",N,N],[17,"B1200","","",N,N],[17,"B1800","","",N,N],[17,"B2400","","",N,N],[17,"B4800","","",N,N],[17,"B9600","","",N,N],[17,"B19200","","",N,N],[17,"B38400","","",N,N],[17,"EXTA","","",N,N],[17,"EXTB","","",N,N],[17,"BOTHER","","",N,N],[17,"B57600","","",N,N],[17,"B115200","","",N,N],[17,"B230400","","",N,N],[17,"B460800","","",N,N],[17,"B500000","","",N,N],[17,"B576000","","",N,N],[17,"B921600","","",N,N],[17,"B1000000","","",N,N],[17,"B1152000","","",N,N],[17,"B1500000","","",N,N],[17,"B2000000","","",N,N],[17,"B2500000","","",N,N],[17,"B3000000","","",N,N],[17,"B3500000","","",N,N],[17,"B4000000","","",N,N],[17,"VEOL","","",N,N],[17,"VEOL2","","",N,N],[17,"VMIN","","",N,N],[17,"IEXTEN","","",N,N],[17,"TOSTOP","","",N,N],[17,"FLUSHO","","",N,N],[17,"EXTPROC","","",N,N],[17,"TCGETS","","",N,N],[17,"TCSETS","","",N,N],[17,"TCSETSW","","",N,N],[17,"TCSETSF","","",N,N],[17,"TCGETA","","",N,N],[17,"TCSETA","","",N,N],[17,"TCSETAW","","",N,N],[17,"TCSETAF","","",N,N],[17,"TCSBRK","","",N,N],[17,"TCXONC","","",N,N],[17,"TCFLSH","","",N,N],[17,"TIOCINQ","","",N,N],[17,"TIOCGPGRP","","",N,N],[17,"TIOCSPGRP","","",N,N],[17,"TIOCOUTQ","","",N,N],[17,"TIOCGWINSZ","","",N,N],[17,"TIOCSWINSZ","","",N,N],[17,"FIONREAD","","",N,N],[17,"R15","","",N,N],[17,"R14","","",N,N],[17,"R13","","",N,N],[17,"R12","","",N,N],[17,"RBP","","",N,N],[17,"RBX","","",N,N],[17,"R11","","",N,N],[17,"R10","","",N,N],[17,"R9","","",N,N],[17,"R8","","",N,N],[17,"RAX","","",N,N],[17,"RCX","","",N,N],[17,"RDX","","",N,N],[17,"RSI","","",N,N],[17,"RDI","","",N,N],[17,"ORIG_RAX","","",N,N],[17,"RIP","","",N,N],[17,"CS","","",N,N],[17,"EFLAGS","","",N,N],[17,"RSP","","",N,N],[17,"SS","","",N,N],[17,"FS_BASE","","",N,N],[17,"GS_BASE","","",N,N],[17,"DS","","",N,N],[17,"ES","","",N,N],[17,"FS","","",N,N],[17,"GS","","",N,N],[11,"clone","libc","",114,[[["self"]],["stat"]]],[11,"clone","","",115,[[["self"]],["stat64"]]],[11,"clone","","",116,[[["self"]],["statfs64"]]],[11,"clone","","",117,[[["self"]],["statvfs64"]]],[11,"clone","","",118,[[["self"]],["pthread_attr_t"]]],[11,"clone","","",119,[[["self"]],["_libc_fpxreg"]]],[11,"clone","","",120,[[["self"]],["_libc_xmmreg"]]],[11,"clone","","",121,[[["self"]],["_libc_fpstate"]]],[11,"clone","","",122,[[["self"]],["user_fpregs_struct"]]],[11,"clone","","",123,[[["self"]],["user_regs_struct"]]],[11,"clone","","",124,[[["self"]],["user"]]],[11,"clone","","",125,[[["self"]],["mcontext_t"]]],[11,"clone","","",126,[[["self"]],["ucontext_t"]]],[11,"clone","","",127,[[["self"]],["ipc_perm"]]],[11,"clone","","",128,[[["self"]],["shmid_ds"]]],[11,"clone","","",129,[[["self"]],["termios2"]]],[0,"not_x32","libc::unix::notbsd::linux::other::b64","",N,N],[3,"statvfs","libc::unix::notbsd::linux::other::b64::not_x32","",N,N],[12,"f_bsize","","",130,N],[12,"f_frsize","","",130,N],[12,"f_blocks","","",130,N],[12,"f_bfree","","",130,N],[12,"f_bavail","","",130,N],[12,"f_files","","",130,N],[12,"f_ffree","","",130,N],[12,"f_favail","","",130,N],[12,"f_fsid","","",130,N],[12,"f_flag","","",130,N],[12,"f_namemax","","",130,N],[12,"__f_spare","","",130,N],[5,"sysctl","","",N,N],[6,"c_long","","",N,N],[6,"c_ulong","","",N,N],[17,"__SIZEOF_PTHREAD_MUTEX_T","","",N,N],[17,"__SIZEOF_PTHREAD_RWLOCK_T","","",N,N],[17,"PTHREAD_RECURSIVE_MUTEX_INITIALIZER_NP","","",N,N],[17,"PTHREAD_ERRORCHECK_MUTEX_INITIALIZER_NP","","",N,N],[17,"PTHREAD_ADAPTIVE_MUTEX_INITIALIZER_NP","","",N,N],[17,"SYS_read","","",N,N],[17,"SYS_write","","",N,N],[17,"SYS_open","","",N,N],[17,"SYS_close","","",N,N],[17,"SYS_stat","","",N,N],[17,"SYS_fstat","","",N,N],[17,"SYS_lstat","","",N,N],[17,"SYS_poll","","",N,N],[17,"SYS_lseek","","",N,N],[17,"SYS_mmap","","",N,N],[17,"SYS_mprotect","","",N,N],[17,"SYS_munmap","","",N,N],[17,"SYS_brk","","",N,N],[17,"SYS_rt_sigaction","","",N,N],[17,"SYS_rt_sigprocmask","","",N,N],[17,"SYS_rt_sigreturn","","",N,N],[17,"SYS_ioctl","","",N,N],[17,"SYS_pread64","","",N,N],[17,"SYS_pwrite64","","",N,N],[17,"SYS_readv","","",N,N],[17,"SYS_writev","","",N,N],[17,"SYS_access","","",N,N],[17,"SYS_pipe","","",N,N],[17,"SYS_select","","",N,N],[17,"SYS_sched_yield","","",N,N],[17,"SYS_mremap","","",N,N],[17,"SYS_msync","","",N,N],[17,"SYS_mincore","","",N,N],[17,"SYS_madvise","","",N,N],[17,"SYS_shmget","","",N,N],[17,"SYS_shmat","","",N,N],[17,"SYS_shmctl","","",N,N],[17,"SYS_dup","","",N,N],[17,"SYS_dup2","","",N,N],[17,"SYS_pause","","",N,N],[17,"SYS_nanosleep","","",N,N],[17,"SYS_getitimer","","",N,N],[17,"SYS_alarm","","",N,N],[17,"SYS_setitimer","","",N,N],[17,"SYS_getpid","","",N,N],[17,"SYS_sendfile","","",N,N],[17,"SYS_socket","","",N,N],[17,"SYS_connect","","",N,N],[17,"SYS_accept","","",N,N],[17,"SYS_sendto","","",N,N],[17,"SYS_recvfrom","","",N,N],[17,"SYS_sendmsg","","",N,N],[17,"SYS_recvmsg","","",N,N],[17,"SYS_shutdown","","",N,N],[17,"SYS_bind","","",N,N],[17,"SYS_listen","","",N,N],[17,"SYS_getsockname","","",N,N],[17,"SYS_getpeername","","",N,N],[17,"SYS_socketpair","","",N,N],[17,"SYS_setsockopt","","",N,N],[17,"SYS_getsockopt","","",N,N],[17,"SYS_clone","","",N,N],[17,"SYS_fork","","",N,N],[17,"SYS_vfork","","",N,N],[17,"SYS_execve","","",N,N],[17,"SYS_exit","","",N,N],[17,"SYS_wait4","","",N,N],[17,"SYS_kill","","",N,N],[17,"SYS_uname","","",N,N],[17,"SYS_semget","","",N,N],[17,"SYS_semop","","",N,N],[17,"SYS_semctl","","",N,N],[17,"SYS_shmdt","","",N,N],[17,"SYS_msgget","","",N,N],[17,"SYS_msgsnd","","",N,N],[17,"SYS_msgrcv","","",N,N],[17,"SYS_msgctl","","",N,N],[17,"SYS_fcntl","","",N,N],[17,"SYS_flock","","",N,N],[17,"SYS_fsync","","",N,N],[17,"SYS_fdatasync","","",N,N],[17,"SYS_truncate","","",N,N],[17,"SYS_ftruncate","","",N,N],[17,"SYS_getdents","","",N,N],[17,"SYS_getcwd","","",N,N],[17,"SYS_chdir","","",N,N],[17,"SYS_fchdir","","",N,N],[17,"SYS_rename","","",N,N],[17,"SYS_mkdir","","",N,N],[17,"SYS_rmdir","","",N,N],[17,"SYS_creat","","",N,N],[17,"SYS_link","","",N,N],[17,"SYS_unlink","","",N,N],[17,"SYS_symlink","","",N,N],[17,"SYS_readlink","","",N,N],[17,"SYS_chmod","","",N,N],[17,"SYS_fchmod","","",N,N],[17,"SYS_chown","","",N,N],[17,"SYS_fchown","","",N,N],[17,"SYS_lchown","","",N,N],[17,"SYS_umask","","",N,N],[17,"SYS_gettimeofday","","",N,N],[17,"SYS_getrlimit","","",N,N],[17,"SYS_getrusage","","",N,N],[17,"SYS_sysinfo","","",N,N],[17,"SYS_times","","",N,N],[17,"SYS_ptrace","","",N,N],[17,"SYS_getuid","","",N,N],[17,"SYS_syslog","","",N,N],[17,"SYS_getgid","","",N,N],[17,"SYS_setuid","","",N,N],[17,"SYS_setgid","","",N,N],[17,"SYS_geteuid","","",N,N],[17,"SYS_getegid","","",N,N],[17,"SYS_setpgid","","",N,N],[17,"SYS_getppid","","",N,N],[17,"SYS_getpgrp","","",N,N],[17,"SYS_setsid","","",N,N],[17,"SYS_setreuid","","",N,N],[17,"SYS_setregid","","",N,N],[17,"SYS_getgroups","","",N,N],[17,"SYS_setgroups","","",N,N],[17,"SYS_setresuid","","",N,N],[17,"SYS_getresuid","","",N,N],[17,"SYS_setresgid","","",N,N],[17,"SYS_getresgid","","",N,N],[17,"SYS_getpgid","","",N,N],[17,"SYS_setfsuid","","",N,N],[17,"SYS_setfsgid","","",N,N],[17,"SYS_getsid","","",N,N],[17,"SYS_capget","","",N,N],[17,"SYS_capset","","",N,N],[17,"SYS_rt_sigpending","","",N,N],[17,"SYS_rt_sigtimedwait","","",N,N],[17,"SYS_rt_sigqueueinfo","","",N,N],[17,"SYS_rt_sigsuspend","","",N,N],[17,"SYS_sigaltstack","","",N,N],[17,"SYS_utime","","",N,N],[17,"SYS_mknod","","",N,N],[17,"SYS_uselib","","",N,N],[17,"SYS_personality","","",N,N],[17,"SYS_ustat","","",N,N],[17,"SYS_statfs","","",N,N],[17,"SYS_fstatfs","","",N,N],[17,"SYS_sysfs","","",N,N],[17,"SYS_getpriority","","",N,N],[17,"SYS_setpriority","","",N,N],[17,"SYS_sched_setparam","","",N,N],[17,"SYS_sched_getparam","","",N,N],[17,"SYS_sched_setscheduler","","",N,N],[17,"SYS_sched_getscheduler","","",N,N],[17,"SYS_sched_get_priority_max","","",N,N],[17,"SYS_sched_get_priority_min","","",N,N],[17,"SYS_sched_rr_get_interval","","",N,N],[17,"SYS_mlock","","",N,N],[17,"SYS_munlock","","",N,N],[17,"SYS_mlockall","","",N,N],[17,"SYS_munlockall","","",N,N],[17,"SYS_vhangup","","",N,N],[17,"SYS_modify_ldt","","",N,N],[17,"SYS_pivot_root","","",N,N],[17,"SYS__sysctl","","",N,N],[17,"SYS_prctl","","",N,N],[17,"SYS_arch_prctl","","",N,N],[17,"SYS_adjtimex","","",N,N],[17,"SYS_setrlimit","","",N,N],[17,"SYS_chroot","","",N,N],[17,"SYS_sync","","",N,N],[17,"SYS_acct","","",N,N],[17,"SYS_settimeofday","","",N,N],[17,"SYS_mount","","",N,N],[17,"SYS_umount2","","",N,N],[17,"SYS_swapon","","",N,N],[17,"SYS_swapoff","","",N,N],[17,"SYS_reboot","","",N,N],[17,"SYS_sethostname","","",N,N],[17,"SYS_setdomainname","","",N,N],[17,"SYS_iopl","","",N,N],[17,"SYS_ioperm","","",N,N],[17,"SYS_create_module","","",N,N],[17,"SYS_init_module","","",N,N],[17,"SYS_delete_module","","",N,N],[17,"SYS_get_kernel_syms","","",N,N],[17,"SYS_query_module","","",N,N],[17,"SYS_quotactl","","",N,N],[17,"SYS_nfsservctl","","",N,N],[17,"SYS_getpmsg","","",N,N],[17,"SYS_putpmsg","","",N,N],[17,"SYS_afs_syscall","","",N,N],[17,"SYS_tuxcall","","",N,N],[17,"SYS_security","","",N,N],[17,"SYS_gettid","","",N,N],[17,"SYS_readahead","","",N,N],[17,"SYS_setxattr","","",N,N],[17,"SYS_lsetxattr","","",N,N],[17,"SYS_fsetxattr","","",N,N],[17,"SYS_getxattr","","",N,N],[17,"SYS_lgetxattr","","",N,N],[17,"SYS_fgetxattr","","",N,N],[17,"SYS_listxattr","","",N,N],[17,"SYS_llistxattr","","",N,N],[17,"SYS_flistxattr","","",N,N],[17,"SYS_removexattr","","",N,N],[17,"SYS_lremovexattr","","",N,N],[17,"SYS_fremovexattr","","",N,N],[17,"SYS_tkill","","",N,N],[17,"SYS_time","","",N,N],[17,"SYS_futex","","",N,N],[17,"SYS_sched_setaffinity","","",N,N],[17,"SYS_sched_getaffinity","","",N,N],[17,"SYS_set_thread_area","","",N,N],[17,"SYS_io_setup","","",N,N],[17,"SYS_io_destroy","","",N,N],[17,"SYS_io_getevents","","",N,N],[17,"SYS_io_submit","","",N,N],[17,"SYS_io_cancel","","",N,N],[17,"SYS_get_thread_area","","",N,N],[17,"SYS_lookup_dcookie","","",N,N],[17,"SYS_epoll_create","","",N,N],[17,"SYS_epoll_ctl_old","","",N,N],[17,"SYS_epoll_wait_old","","",N,N],[17,"SYS_remap_file_pages","","",N,N],[17,"SYS_getdents64","","",N,N],[17,"SYS_set_tid_address","","",N,N],[17,"SYS_restart_syscall","","",N,N],[17,"SYS_semtimedop","","",N,N],[17,"SYS_fadvise64","","",N,N],[17,"SYS_timer_create","","",N,N],[17,"SYS_timer_settime","","",N,N],[17,"SYS_timer_gettime","","",N,N],[17,"SYS_timer_getoverrun","","",N,N],[17,"SYS_timer_delete","","",N,N],[17,"SYS_clock_settime","","",N,N],[17,"SYS_clock_gettime","","",N,N],[17,"SYS_clock_getres","","",N,N],[17,"SYS_clock_nanosleep","","",N,N],[17,"SYS_exit_group","","",N,N],[17,"SYS_epoll_wait","","",N,N],[17,"SYS_epoll_ctl","","",N,N],[17,"SYS_tgkill","","",N,N],[17,"SYS_utimes","","",N,N],[17,"SYS_vserver","","",N,N],[17,"SYS_mbind","","",N,N],[17,"SYS_set_mempolicy","","",N,N],[17,"SYS_get_mempolicy","","",N,N],[17,"SYS_mq_open","","",N,N],[17,"SYS_mq_unlink","","",N,N],[17,"SYS_mq_timedsend","","",N,N],[17,"SYS_mq_timedreceive","","",N,N],[17,"SYS_mq_notify","","",N,N],[17,"SYS_mq_getsetattr","","",N,N],[17,"SYS_kexec_load","","",N,N],[17,"SYS_waitid","","",N,N],[17,"SYS_add_key","","",N,N],[17,"SYS_request_key","","",N,N],[17,"SYS_keyctl","","",N,N],[17,"SYS_ioprio_set","","",N,N],[17,"SYS_ioprio_get","","",N,N],[17,"SYS_inotify_init","","",N,N],[17,"SYS_inotify_add_watch","","",N,N],[17,"SYS_inotify_rm_watch","","",N,N],[17,"SYS_migrate_pages","","",N,N],[17,"SYS_openat","","",N,N],[17,"SYS_mkdirat","","",N,N],[17,"SYS_mknodat","","",N,N],[17,"SYS_fchownat","","",N,N],[17,"SYS_futimesat","","",N,N],[17,"SYS_newfstatat","","",N,N],[17,"SYS_unlinkat","","",N,N],[17,"SYS_renameat","","",N,N],[17,"SYS_linkat","","",N,N],[17,"SYS_symlinkat","","",N,N],[17,"SYS_readlinkat","","",N,N],[17,"SYS_fchmodat","","",N,N],[17,"SYS_faccessat","","",N,N],[17,"SYS_pselect6","","",N,N],[17,"SYS_ppoll","","",N,N],[17,"SYS_unshare","","",N,N],[17,"SYS_set_robust_list","","",N,N],[17,"SYS_get_robust_list","","",N,N],[17,"SYS_splice","","",N,N],[17,"SYS_tee","","",N,N],[17,"SYS_sync_file_range","","",N,N],[17,"SYS_vmsplice","","",N,N],[17,"SYS_move_pages","","",N,N],[17,"SYS_utimensat","","",N,N],[17,"SYS_epoll_pwait","","",N,N],[17,"SYS_signalfd","","",N,N],[17,"SYS_timerfd_create","","",N,N],[17,"SYS_eventfd","","",N,N],[17,"SYS_fallocate","","",N,N],[17,"SYS_timerfd_settime","","",N,N],[17,"SYS_timerfd_gettime","","",N,N],[17,"SYS_accept4","","",N,N],[17,"SYS_signalfd4","","",N,N],[17,"SYS_eventfd2","","",N,N],[17,"SYS_epoll_create1","","",N,N],[17,"SYS_dup3","","",N,N],[17,"SYS_pipe2","","",N,N],[17,"SYS_inotify_init1","","",N,N],[17,"SYS_preadv","","",N,N],[17,"SYS_pwritev","","",N,N],[17,"SYS_rt_tgsigqueueinfo","","",N,N],[17,"SYS_perf_event_open","","",N,N],[17,"SYS_recvmmsg","","",N,N],[17,"SYS_fanotify_init","","",N,N],[17,"SYS_fanotify_mark","","",N,N],[17,"SYS_prlimit64","","",N,N],[17,"SYS_name_to_handle_at","","",N,N],[17,"SYS_open_by_handle_at","","",N,N],[17,"SYS_clock_adjtime","","",N,N],[17,"SYS_syncfs","","",N,N],[17,"SYS_sendmmsg","","",N,N],[17,"SYS_setns","","",N,N],[17,"SYS_getcpu","","",N,N],[17,"SYS_process_vm_readv","","",N,N],[17,"SYS_process_vm_writev","","",N,N],[17,"SYS_kcmp","","",N,N],[17,"SYS_finit_module","","",N,N],[17,"SYS_sched_setattr","","",N,N],[17,"SYS_sched_getattr","","",N,N],[17,"SYS_renameat2","","",N,N],[17,"SYS_seccomp","","",N,N],[17,"SYS_getrandom","","",N,N],[17,"SYS_memfd_create","","",N,N],[17,"SYS_kexec_file_load","","",N,N],[17,"SYS_bpf","","",N,N],[17,"SYS_execveat","","",N,N],[17,"SYS_userfaultfd","","",N,N],[17,"SYS_membarrier","","",N,N],[17,"SYS_mlock2","","",N,N],[17,"SYS_copy_file_range","","",N,N],[17,"SYS_preadv2","","",N,N],[17,"SYS_pwritev2","","",N,N],[17,"SYS_pkey_mprotect","","",N,N],[17,"SYS_pkey_alloc","","",N,N],[17,"SYS_pkey_free","","",N,N],[11,"clone","libc","",130,[[["self"]],["statvfs"]]],[6,"clock_t","libc::unix::notbsd::linux::other::b64","",N,N],[6,"time_t","","",N,N],[6,"ino_t","","",N,N],[6,"off_t","","",N,N],[6,"blkcnt_t","","",N,N],[6,"__fsword_t","","",N,N],[6,"shmatt_t","","",N,N],[6,"msgqnum_t","","",N,N],[6,"msglen_t","","",N,N],[6,"fsblkcnt_t","","",N,N],[6,"fsfilcnt_t","","",N,N],[6,"rlim_t","","",N,N],[17,"__SIZEOF_PTHREAD_RWLOCKATTR_T","","",N,N],[17,"O_LARGEFILE","","",N,N],[11,"clone","libc","",111,[[["self"]],["sigset_t"]]],[11,"clone","","",112,[[["self"]],["sysinfo"]]],[11,"clone","","",113,[[["self"]],["msqid_ds"]]],[6,"__priority_which_t","libc::unix::notbsd::linux::other","",N,N],[17,"__UT_LINESIZE","","",N,N],[17,"__UT_NAMESIZE","","",N,N],[17,"__UT_HOSTSIZE","","",N,N],[17,"EMPTY","","",N,N],[17,"RUN_LVL","","",N,N],[17,"BOOT_TIME","","",N,N],[17,"NEW_TIME","","",N,N],[17,"OLD_TIME","","",N,N],[17,"INIT_PROCESS","","",N,N],[17,"LOGIN_PROCESS","","",N,N],[17,"USER_PROCESS","","",N,N],[17,"DEAD_PROCESS","","",N,N],[17,"ACCOUNTING","","",N,N],[17,"RLIMIT_RSS","","",N,N],[17,"RLIMIT_AS","","",N,N],[17,"RLIMIT_MEMLOCK","","",N,N],[17,"RLIM_INFINITY","","",N,N],[17,"RLIMIT_RTTIME","","",N,N],[17,"RLIMIT_NLIMITS","","",N,N],[17,"SOCK_NONBLOCK","","",N,N],[17,"SOL_RXRPC","","",N,N],[17,"SOL_PPPOL2TP","","",N,N],[17,"SOL_BLUETOOTH","","",N,N],[17,"SOL_PNPIPE","","",N,N],[17,"SOL_RDS","","",N,N],[17,"SOL_IUCV","","",N,N],[17,"SOL_CAIF","","",N,N],[17,"SOL_ALG","","",N,N],[17,"SOL_NFC","","",N,N],[17,"MSG_TRYHARD","","",N,N],[17,"LC_PAPER","","",N,N],[17,"LC_NAME","","",N,N],[17,"LC_ADDRESS","","",N,N],[17,"LC_TELEPHONE","","",N,N],[17,"LC_MEASUREMENT","","",N,N],[17,"LC_IDENTIFICATION","","",N,N],[17,"LC_PAPER_MASK","","",N,N],[17,"LC_NAME_MASK","","",N,N],[17,"LC_ADDRESS_MASK","","",N,N],[17,"LC_TELEPHONE_MASK","","",N,N],[17,"LC_MEASUREMENT_MASK","","",N,N],[17,"LC_IDENTIFICATION_MASK","","",N,N],[17,"LC_ALL_MASK","","",N,N],[17,"MAP_ANON","","",N,N],[17,"MAP_ANONYMOUS","","",N,N],[17,"MAP_DENYWRITE","","",N,N],[17,"MAP_EXECUTABLE","","",N,N],[17,"MAP_POPULATE","","",N,N],[17,"MAP_NONBLOCK","","",N,N],[17,"MAP_STACK","","",N,N],[17,"ENOTSUP","","",N,N],[17,"EUCLEAN","","",N,N],[17,"ENOTNAM","","",N,N],[17,"ENAVAIL","","",N,N],[17,"EISNAM","","",N,N],[17,"EREMOTEIO","","",N,N],[17,"SOCK_STREAM","","",N,N],[17,"SOCK_DGRAM","","",N,N],[17,"SOCK_SEQPACKET","","",N,N],[17,"SOCK_DCCP","","",N,N],[17,"SOCK_PACKET","","",N,N],[17,"TCP_COOKIE_TRANSACTIONS","","",N,N],[17,"TCP_THIN_LINEAR_TIMEOUTS","","",N,N],[17,"TCP_THIN_DUPACK","","",N,N],[17,"TCP_USER_TIMEOUT","","",N,N],[17,"TCP_REPAIR","","",N,N],[17,"TCP_REPAIR_QUEUE","","",N,N],[17,"TCP_QUEUE_SEQ","","",N,N],[17,"TCP_REPAIR_OPTIONS","","",N,N],[17,"TCP_FASTOPEN","","",N,N],[17,"TCP_TIMESTAMP","","",N,N],[17,"DCCP_SOCKOPT_PACKET_SIZE","","",N,N],[17,"DCCP_SOCKOPT_SERVICE","","",N,N],[17,"DCCP_SOCKOPT_CHANGE_L","","",N,N],[17,"DCCP_SOCKOPT_CHANGE_R","","",N,N],[17,"DCCP_SOCKOPT_GET_CUR_MPS","","",N,N],[17,"DCCP_SOCKOPT_SERVER_TIMEWAIT","","",N,N],[17,"DCCP_SOCKOPT_SEND_CSCOV","","",N,N],[17,"DCCP_SOCKOPT_RECV_CSCOV","","",N,N],[17,"DCCP_SOCKOPT_AVAILABLE_CCIDS","","",N,N],[17,"DCCP_SOCKOPT_CCID","","",N,N],[17,"DCCP_SOCKOPT_TX_CCID","","",N,N],[17,"DCCP_SOCKOPT_RX_CCID","","",N,N],[17,"DCCP_SOCKOPT_QPOLICY_ID","","",N,N],[17,"DCCP_SOCKOPT_QPOLICY_TXQLEN","","",N,N],[17,"DCCP_SOCKOPT_CCID_RX_INFO","","",N,N],[17,"DCCP_SOCKOPT_CCID_TX_INFO","","",N,N],[17,"DCCP_SERVICE_LIST_MAX_LEN","","maximum number of services provided on the same listening port",N,N],[17,"SIGTTIN","","",N,N],[17,"SIGTTOU","","",N,N],[17,"SIGXCPU","","",N,N],[17,"SIGXFSZ","","",N,N],[17,"SIGVTALRM","","",N,N],[17,"SIGPROF","","",N,N],[17,"SIGWINCH","","",N,N],[17,"SIGEV_THREAD_ID","","",N,N],[17,"BUFSIZ","","",N,N],[17,"TMP_MAX","","",N,N],[17,"FOPEN_MAX","","",N,N],[17,"POSIX_FADV_DONTNEED","","",N,N],[17,"POSIX_FADV_NOREUSE","","",N,N],[17,"POSIX_MADV_DONTNEED","","",N,N],[17,"_SC_EQUIV_CLASS_MAX","","",N,N],[17,"_SC_CHARCLASS_NAME_MAX","","",N,N],[17,"_SC_PII","","",N,N],[17,"_SC_PII_XTI","","",N,N],[17,"_SC_PII_SOCKET","","",N,N],[17,"_SC_PII_INTERNET","","",N,N],[17,"_SC_PII_OSI","","",N,N],[17,"_SC_POLL","","",N,N],[17,"_SC_SELECT","","",N,N],[17,"_SC_PII_INTERNET_STREAM","","",N,N],[17,"_SC_PII_INTERNET_DGRAM","","",N,N],[17,"_SC_PII_OSI_COTS","","",N,N],[17,"_SC_PII_OSI_CLTS","","",N,N],[17,"_SC_PII_OSI_M","","",N,N],[17,"_SC_T_IOV_MAX","","",N,N],[17,"_SC_2_C_VERSION","","",N,N],[17,"_SC_CHAR_BIT","","",N,N],[17,"_SC_CHAR_MAX","","",N,N],[17,"_SC_CHAR_MIN","","",N,N],[17,"_SC_INT_MAX","","",N,N],[17,"_SC_INT_MIN","","",N,N],[17,"_SC_LONG_BIT","","",N,N],[17,"_SC_WORD_BIT","","",N,N],[17,"_SC_MB_LEN_MAX","","",N,N],[17,"_SC_SSIZE_MAX","","",N,N],[17,"_SC_SCHAR_MAX","","",N,N],[17,"_SC_SCHAR_MIN","","",N,N],[17,"_SC_SHRT_MAX","","",N,N],[17,"_SC_SHRT_MIN","","",N,N],[17,"_SC_UCHAR_MAX","","",N,N],[17,"_SC_UINT_MAX","","",N,N],[17,"_SC_ULONG_MAX","","",N,N],[17,"_SC_USHRT_MAX","","",N,N],[17,"_SC_NL_ARGMAX","","",N,N],[17,"_SC_NL_LANGMAX","","",N,N],[17,"_SC_NL_MSGMAX","","",N,N],[17,"_SC_NL_NMAX","","",N,N],[17,"_SC_NL_SETMAX","","",N,N],[17,"_SC_NL_TEXTMAX","","",N,N],[17,"_SC_BASE","","",N,N],[17,"_SC_C_LANG_SUPPORT","","",N,N],[17,"_SC_C_LANG_SUPPORT_R","","",N,N],[17,"_SC_DEVICE_IO","","",N,N],[17,"_SC_DEVICE_SPECIFIC","","",N,N],[17,"_SC_DEVICE_SPECIFIC_R","","",N,N],[17,"_SC_FD_MGMT","","",N,N],[17,"_SC_FIFO","","",N,N],[17,"_SC_PIPE","","",N,N],[17,"_SC_FILE_ATTRIBUTES","","",N,N],[17,"_SC_FILE_LOCKING","","",N,N],[17,"_SC_FILE_SYSTEM","","",N,N],[17,"_SC_MULTI_PROCESS","","",N,N],[17,"_SC_SINGLE_PROCESS","","",N,N],[17,"_SC_NETWORKING","","",N,N],[17,"_SC_REGEX_VERSION","","",N,N],[17,"_SC_SIGNALS","","",N,N],[17,"_SC_SYSTEM_DATABASE","","",N,N],[17,"_SC_SYSTEM_DATABASE_R","","",N,N],[17,"_SC_USER_GROUPS","","",N,N],[17,"_SC_USER_GROUPS_R","","",N,N],[17,"_SC_LEVEL1_ICACHE_SIZE","","",N,N],[17,"_SC_LEVEL1_ICACHE_ASSOC","","",N,N],[17,"_SC_LEVEL1_ICACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL1_DCACHE_SIZE","","",N,N],[17,"_SC_LEVEL1_DCACHE_ASSOC","","",N,N],[17,"_SC_LEVEL1_DCACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL2_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL2_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL2_CACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL3_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL3_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL3_CACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL4_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL4_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL4_CACHE_LINESIZE","","",N,N],[17,"O_ACCMODE","","",N,N],[17,"ST_RELATIME","","",N,N],[17,"NI_MAXHOST","","",N,N],[17,"ADFS_SUPER_MAGIC","","",N,N],[17,"AFFS_SUPER_MAGIC","","",N,N],[17,"CODA_SUPER_MAGIC","","",N,N],[17,"CRAMFS_MAGIC","","",N,N],[17,"EFS_SUPER_MAGIC","","",N,N],[17,"EXT2_SUPER_MAGIC","","",N,N],[17,"EXT3_SUPER_MAGIC","","",N,N],[17,"EXT4_SUPER_MAGIC","","",N,N],[17,"HPFS_SUPER_MAGIC","","",N,N],[17,"HUGETLBFS_MAGIC","","",N,N],[17,"ISOFS_SUPER_MAGIC","","",N,N],[17,"JFFS2_SUPER_MAGIC","","",N,N],[17,"MINIX_SUPER_MAGIC","","",N,N],[17,"MINIX_SUPER_MAGIC2","","",N,N],[17,"MINIX2_SUPER_MAGIC","","",N,N],[17,"MINIX2_SUPER_MAGIC2","","",N,N],[17,"MSDOS_SUPER_MAGIC","","",N,N],[17,"NCP_SUPER_MAGIC","","",N,N],[17,"NFS_SUPER_MAGIC","","",N,N],[17,"OPENPROM_SUPER_MAGIC","","",N,N],[17,"PROC_SUPER_MAGIC","","",N,N],[17,"QNX4_SUPER_MAGIC","","",N,N],[17,"REISERFS_SUPER_MAGIC","","",N,N],[17,"SMB_SUPER_MAGIC","","",N,N],[17,"TMPFS_MAGIC","","",N,N],[17,"USBDEVICE_SUPER_MAGIC","","",N,N],[17,"VEOF","","",N,N],[17,"CPU_SETSIZE","","",N,N],[17,"PTRACE_TRACEME","","",N,N],[17,"PTRACE_PEEKTEXT","","",N,N],[17,"PTRACE_PEEKDATA","","",N,N],[17,"PTRACE_PEEKUSER","","",N,N],[17,"PTRACE_POKETEXT","","",N,N],[17,"PTRACE_POKEDATA","","",N,N],[17,"PTRACE_POKEUSER","","",N,N],[17,"PTRACE_CONT","","",N,N],[17,"PTRACE_KILL","","",N,N],[17,"PTRACE_SINGLESTEP","","",N,N],[17,"PTRACE_ATTACH","","",N,N],[17,"PTRACE_SYSCALL","","",N,N],[17,"PTRACE_SETOPTIONS","","",N,N],[17,"PTRACE_GETEVENTMSG","","",N,N],[17,"PTRACE_GETSIGINFO","","",N,N],[17,"PTRACE_SETSIGINFO","","",N,N],[17,"PTRACE_GETREGSET","","",N,N],[17,"PTRACE_SETREGSET","","",N,N],[17,"PTRACE_SEIZE","","",N,N],[17,"PTRACE_INTERRUPT","","",N,N],[17,"PTRACE_LISTEN","","",N,N],[17,"PTRACE_PEEKSIGINFO","","",N,N],[17,"EPOLLWAKEUP","","",N,N],[17,"MAP_HUGETLB","","",N,N],[17,"SEEK_DATA","","",N,N],[17,"SEEK_HOLE","","",N,N],[17,"TCSANOW","","",N,N],[17,"TCSADRAIN","","",N,N],[17,"TCSAFLUSH","","",N,N],[17,"TIOCLINUX","","",N,N],[17,"TIOCGSERIAL","","",N,N],[17,"RTLD_DEEPBIND","","",N,N],[17,"RTLD_GLOBAL","","",N,N],[17,"RTLD_NOLOAD","","",N,N],[17,"LINUX_REBOOT_MAGIC1","","",N,N],[17,"LINUX_REBOOT_MAGIC2","","",N,N],[17,"LINUX_REBOOT_MAGIC2A","","",N,N],[17,"LINUX_REBOOT_MAGIC2B","","",N,N],[17,"LINUX_REBOOT_MAGIC2C","","",N,N],[17,"LINUX_REBOOT_CMD_RESTART","","",N,N],[17,"LINUX_REBOOT_CMD_HALT","","",N,N],[17,"LINUX_REBOOT_CMD_CAD_ON","","",N,N],[17,"LINUX_REBOOT_CMD_CAD_OFF","","",N,N],[17,"LINUX_REBOOT_CMD_POWER_OFF","","",N,N],[17,"LINUX_REBOOT_CMD_RESTART2","","",N,N],[17,"LINUX_REBOOT_CMD_SW_SUSPEND","","",N,N],[17,"LINUX_REBOOT_CMD_KEXEC","","",N,N],[17,"NETLINK_ROUTE","","",N,N],[17,"NETLINK_UNUSED","","",N,N],[17,"NETLINK_USERSOCK","","",N,N],[17,"NETLINK_FIREWALL","","",N,N],[17,"NETLINK_SOCK_DIAG","","",N,N],[17,"NETLINK_NFLOG","","",N,N],[17,"NETLINK_XFRM","","",N,N],[17,"NETLINK_SELINUX","","",N,N],[17,"NETLINK_ISCSI","","",N,N],[17,"NETLINK_AUDIT","","",N,N],[17,"NETLINK_FIB_LOOKUP","","",N,N],[17,"NETLINK_CONNECTOR","","",N,N],[17,"NETLINK_NETFILTER","","",N,N],[17,"NETLINK_IP6_FW","","",N,N],[17,"NETLINK_DNRTMSG","","",N,N],[17,"NETLINK_KOBJECT_UEVENT","","",N,N],[17,"NETLINK_GENERIC","","",N,N],[17,"NETLINK_SCSITRANSPORT","","",N,N],[17,"NETLINK_ECRYPTFS","","",N,N],[17,"NETLINK_RDMA","","",N,N],[17,"NETLINK_CRYPTO","","",N,N],[17,"NETLINK_INET_DIAG","","",N,N],[17,"MAX_LINKS","","",N,N],[17,"NLM_F_REQUEST","","",N,N],[17,"NLM_F_MULTI","","",N,N],[17,"NLM_F_ACK","","",N,N],[17,"NLM_F_ECHO","","",N,N],[17,"NLM_F_DUMP_INTR","","",N,N],[17,"NLM_F_DUMP_FILTERED","","",N,N],[17,"NLM_F_ROOT","","",N,N],[17,"NLM_F_MATCH","","",N,N],[17,"NLM_F_ATOMIC","","",N,N],[17,"NLM_F_DUMP","","",N,N],[17,"NLM_F_REPLACE","","",N,N],[17,"NLM_F_EXCL","","",N,N],[17,"NLM_F_CREATE","","",N,N],[17,"NLM_F_APPEND","","",N,N],[17,"NETLINK_ADD_MEMBERSHIP","","",N,N],[17,"NETLINK_DROP_MEMBERSHIP","","",N,N],[17,"NETLINK_PKTINFO","","",N,N],[17,"NETLINK_BROADCAST_ERROR","","",N,N],[17,"NETLINK_NO_ENOBUFS","","",N,N],[17,"NETLINK_RX_RING","","",N,N],[17,"NETLINK_TX_RING","","",N,N],[17,"NETLINK_LISTEN_ALL_NSID","","",N,N],[17,"NETLINK_LIST_MEMBERSHIPS","","",N,N],[17,"NETLINK_CAP_ACK","","",N,N],[17,"NLA_F_NESTED","","",N,N],[17,"NLA_F_NET_BYTEORDER","","",N,N],[17,"NLA_TYPE_MASK","","",N,N],[17,"NLA_ALIGNTO","","",N,N],[17,"GENL_UNS_ADMIN_PERM","","",N,N],[17,"GENL_ID_VFS_DQUOT","","",N,N],[17,"GENL_ID_PMCRAID","","",N,N],[17,"TIOCM_LE","","",N,N],[17,"TIOCM_DTR","","",N,N],[17,"TIOCM_RTS","","",N,N],[17,"TIOCM_ST","","",N,N],[17,"TIOCM_SR","","",N,N],[17,"TIOCM_CTS","","",N,N],[17,"TIOCM_CAR","","",N,N],[17,"TIOCM_RNG","","",N,N],[17,"TIOCM_DSR","","",N,N],[17,"TIOCM_CD","","",N,N],[17,"TIOCM_RI","","",N,N],[17,"NF_NETDEV_INGRESS","","",N,N],[17,"NF_NETDEV_NUMHOOKS","","",N,N],[17,"NFPROTO_INET","","",N,N],[17,"NFPROTO_NETDEV","","",N,N],[17,"NFT_TABLE_MAXNAMELEN","","",N,N],[17,"NFT_CHAIN_MAXNAMELEN","","",N,N],[17,"NFT_SET_MAXNAMELEN","","",N,N],[17,"NFT_OBJ_MAXNAMELEN","","",N,N],[17,"NFT_USERDATA_MAXLEN","","",N,N],[17,"NFT_REG_VERDICT","","",N,N],[17,"NFT_REG_1","","",N,N],[17,"NFT_REG_2","","",N,N],[17,"NFT_REG_3","","",N,N],[17,"NFT_REG_4","","",N,N],[17,"__NFT_REG_MAX","","",N,N],[17,"NFT_REG32_00","","",N,N],[17,"NFT_REG32_01","","",N,N],[17,"NFT_REG32_02","","",N,N],[17,"NFT_REG32_03","","",N,N],[17,"NFT_REG32_04","","",N,N],[17,"NFT_REG32_05","","",N,N],[17,"NFT_REG32_06","","",N,N],[17,"NFT_REG32_07","","",N,N],[17,"NFT_REG32_08","","",N,N],[17,"NFT_REG32_09","","",N,N],[17,"NFT_REG32_10","","",N,N],[17,"NFT_REG32_11","","",N,N],[17,"NFT_REG32_12","","",N,N],[17,"NFT_REG32_13","","",N,N],[17,"NFT_REG32_14","","",N,N],[17,"NFT_REG32_15","","",N,N],[17,"NFT_REG_SIZE","","",N,N],[17,"NFT_REG32_SIZE","","",N,N],[17,"NFT_CONTINUE","","",N,N],[17,"NFT_BREAK","","",N,N],[17,"NFT_JUMP","","",N,N],[17,"NFT_GOTO","","",N,N],[17,"NFT_RETURN","","",N,N],[17,"NFT_MSG_NEWTABLE","","",N,N],[17,"NFT_MSG_GETTABLE","","",N,N],[17,"NFT_MSG_DELTABLE","","",N,N],[17,"NFT_MSG_NEWCHAIN","","",N,N],[17,"NFT_MSG_GETCHAIN","","",N,N],[17,"NFT_MSG_DELCHAIN","","",N,N],[17,"NFT_MSG_NEWRULE","","",N,N],[17,"NFT_MSG_GETRULE","","",N,N],[17,"NFT_MSG_DELRULE","","",N,N],[17,"NFT_MSG_NEWSET","","",N,N],[17,"NFT_MSG_GETSET","","",N,N],[17,"NFT_MSG_DELSET","","",N,N],[17,"NFT_MSG_NEWSETELEM","","",N,N],[17,"NFT_MSG_GETSETELEM","","",N,N],[17,"NFT_MSG_DELSETELEM","","",N,N],[17,"NFT_MSG_NEWGEN","","",N,N],[17,"NFT_MSG_GETGEN","","",N,N],[17,"NFT_MSG_TRACE","","",N,N],[17,"NFT_MSG_NEWOBJ","","",N,N],[17,"NFT_MSG_GETOBJ","","",N,N],[17,"NFT_MSG_DELOBJ","","",N,N],[17,"NFT_MSG_GETOBJ_RESET","","",N,N],[17,"NFT_MSG_MAX","","",N,N],[17,"NFT_SET_ANONYMOUS","","",N,N],[17,"NFT_SET_CONSTANT","","",N,N],[17,"NFT_SET_INTERVAL","","",N,N],[17,"NFT_SET_MAP","","",N,N],[17,"NFT_SET_TIMEOUT","","",N,N],[17,"NFT_SET_EVAL","","",N,N],[17,"NFT_SET_POL_PERFORMANCE","","",N,N],[17,"NFT_SET_POL_MEMORY","","",N,N],[17,"NFT_SET_ELEM_INTERVAL_END","","",N,N],[17,"NFT_DATA_VALUE","","",N,N],[17,"NFT_DATA_VERDICT","","",N,N],[17,"NFT_DATA_RESERVED_MASK","","",N,N],[17,"NFT_DATA_VALUE_MAXLEN","","",N,N],[17,"NFT_BYTEORDER_NTOH","","",N,N],[17,"NFT_BYTEORDER_HTON","","",N,N],[17,"NFT_CMP_EQ","","",N,N],[17,"NFT_CMP_NEQ","","",N,N],[17,"NFT_CMP_LT","","",N,N],[17,"NFT_CMP_LTE","","",N,N],[17,"NFT_CMP_GT","","",N,N],[17,"NFT_CMP_GTE","","",N,N],[17,"NFT_RANGE_EQ","","",N,N],[17,"NFT_RANGE_NEQ","","",N,N],[17,"NFT_LOOKUP_F_INV","","",N,N],[17,"NFT_DYNSET_OP_ADD","","",N,N],[17,"NFT_DYNSET_OP_UPDATE","","",N,N],[17,"NFT_DYNSET_F_INV","","",N,N],[17,"NFT_PAYLOAD_LL_HEADER","","",N,N],[17,"NFT_PAYLOAD_NETWORK_HEADER","","",N,N],[17,"NFT_PAYLOAD_TRANSPORT_HEADER","","",N,N],[17,"NFT_PAYLOAD_CSUM_NONE","","",N,N],[17,"NFT_PAYLOAD_CSUM_INET","","",N,N],[17,"NFT_META_LEN","","",N,N],[17,"NFT_META_PROTOCOL","","",N,N],[17,"NFT_META_PRIORITY","","",N,N],[17,"NFT_META_MARK","","",N,N],[17,"NFT_META_IIF","","",N,N],[17,"NFT_META_OIF","","",N,N],[17,"NFT_META_IIFNAME","","",N,N],[17,"NFT_META_OIFNAME","","",N,N],[17,"NFT_META_IIFTYPE","","",N,N],[17,"NFT_META_OIFTYPE","","",N,N],[17,"NFT_META_SKUID","","",N,N],[17,"NFT_META_SKGID","","",N,N],[17,"NFT_META_NFTRACE","","",N,N],[17,"NFT_META_RTCLASSID","","",N,N],[17,"NFT_META_SECMARK","","",N,N],[17,"NFT_META_NFPROTO","","",N,N],[17,"NFT_META_L4PROTO","","",N,N],[17,"NFT_META_BRI_IIFNAME","","",N,N],[17,"NFT_META_BRI_OIFNAME","","",N,N],[17,"NFT_META_PKTTYPE","","",N,N],[17,"NFT_META_CPU","","",N,N],[17,"NFT_META_IIFGROUP","","",N,N],[17,"NFT_META_OIFGROUP","","",N,N],[17,"NFT_META_CGROUP","","",N,N],[17,"NFT_META_PRANDOM","","",N,N],[17,"NFT_CT_STATE","","",N,N],[17,"NFT_CT_DIRECTION","","",N,N],[17,"NFT_CT_STATUS","","",N,N],[17,"NFT_CT_MARK","","",N,N],[17,"NFT_CT_SECMARK","","",N,N],[17,"NFT_CT_EXPIRATION","","",N,N],[17,"NFT_CT_HELPER","","",N,N],[17,"NFT_CT_L3PROTOCOL","","",N,N],[17,"NFT_CT_SRC","","",N,N],[17,"NFT_CT_DST","","",N,N],[17,"NFT_CT_PROTOCOL","","",N,N],[17,"NFT_CT_PROTO_SRC","","",N,N],[17,"NFT_CT_PROTO_DST","","",N,N],[17,"NFT_CT_LABELS","","",N,N],[17,"NFT_CT_PKTS","","",N,N],[17,"NFT_CT_BYTES","","",N,N],[17,"NFT_LIMIT_PKTS","","",N,N],[17,"NFT_LIMIT_PKT_BYTES","","",N,N],[17,"NFT_LIMIT_F_INV","","",N,N],[17,"NFT_QUEUE_FLAG_BYPASS","","",N,N],[17,"NFT_QUEUE_FLAG_CPU_FANOUT","","",N,N],[17,"NFT_QUEUE_FLAG_MASK","","",N,N],[17,"NFT_QUOTA_F_INV","","",N,N],[17,"NFT_REJECT_ICMP_UNREACH","","",N,N],[17,"NFT_REJECT_TCP_RST","","",N,N],[17,"NFT_REJECT_ICMPX_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_NO_ROUTE","","",N,N],[17,"NFT_REJECT_ICMPX_PORT_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_HOST_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_ADMIN_PROHIBITED","","",N,N],[17,"NFT_NAT_SNAT","","",N,N],[17,"NFT_NAT_DNAT","","",N,N],[17,"NFT_TRACETYPE_UNSPEC","","",N,N],[17,"NFT_TRACETYPE_POLICY","","",N,N],[17,"NFT_TRACETYPE_RETURN","","",N,N],[17,"NFT_TRACETYPE_RULE","","",N,N],[17,"NFT_NG_INCREMENTAL","","",N,N],[17,"NFT_NG_RANDOM","","",N,N],[17,"AF_MAX","","",N,N],[17,"PF_MAX","","",N,N],[17,"PTHREAD_STACK_MIN","","",N,N],[17,"PTHREAD_MUTEX_ADAPTIVE_NP","","",N,N],[11,"clone","libc","",89,[[["self"]],["aiocb"]]],[11,"clone","","",90,[[["self"]],["__exit_status"]]],[11,"clone","","",91,[[["self"]],["__timeval"]]],[11,"clone","","",92,[[["self"]],["utmpx"]]],[11,"clone","","",93,[[["self"]],["sigaction"]]],[11,"clone","","",94,[[["self"]],["stack_t"]]],[11,"clone","","",95,[[["self"]],["siginfo_t"]]],[11,"clone","","",96,[[["self"]],["glob64_t"]]],[11,"clone","","",97,[[["self"]],["statfs"]]],[11,"clone","","",98,[[["self"]],["msghdr"]]],[11,"clone","","",99,[[["self"]],["cmsghdr"]]],[11,"clone","","",100,[[["self"]],["termios"]]],[11,"clone","","",101,[[["self"]],["flock"]]],[11,"clone","","",102,[[["self"]],["sem_t"]]],[11,"clone","","",103,[[["self"]],["mallinfo"]]],[11,"clone","","",104,[[["self"]],["nlmsghdr"]]],[11,"clone","","",105,[[["self"]],["nlmsgerr"]]],[11,"clone","","",106,[[["self"]],["nl_pktinfo"]]],[11,"clone","","",107,[[["self"]],["nl_mmap_req"]]],[11,"clone","","",108,[[["self"]],["nl_mmap_hdr"]]],[11,"clone","","",109,[[["self"]],["nlattr"]]],[11,"clone","","",110,[[["self"]],["rtentry"]]],[6,"useconds_t","libc::unix::notbsd::linux","",N,N],[6,"dev_t","","",N,N],[6,"socklen_t","","",N,N],[6,"pthread_t","","",N,N],[6,"mode_t","","",N,N],[6,"ino64_t","","",N,N],[6,"off64_t","","",N,N],[6,"blkcnt64_t","","",N,N],[6,"rlim64_t","","",N,N],[6,"mqd_t","","",N,N],[6,"nfds_t","","",N,N],[6,"nl_item","","",N,N],[6,"idtype_t","","",N,N],[6,"loff_t","","",N,N],[6,"__u8","","",N,N],[6,"__u16","","",N,N],[6,"__s16","","",N,N],[6,"__u32","","",N,N],[6,"__s32","","",N,N],[6,"Elf32_Half","","",N,N],[6,"Elf32_Word","","",N,N],[6,"Elf32_Off","","",N,N],[6,"Elf32_Addr","","",N,N],[6,"Elf64_Half","","",N,N],[6,"Elf64_Word","","",N,N],[6,"Elf64_Off","","",N,N],[6,"Elf64_Addr","","",N,N],[6,"Elf64_Xword","","",N,N],[17,"ABDAY_1","","",N,N],[17,"ABDAY_2","","",N,N],[17,"ABDAY_3","","",N,N],[17,"ABDAY_4","","",N,N],[17,"ABDAY_5","","",N,N],[17,"ABDAY_6","","",N,N],[17,"ABDAY_7","","",N,N],[17,"DAY_1","","",N,N],[17,"DAY_2","","",N,N],[17,"DAY_3","","",N,N],[17,"DAY_4","","",N,N],[17,"DAY_5","","",N,N],[17,"DAY_6","","",N,N],[17,"DAY_7","","",N,N],[17,"ABMON_1","","",N,N],[17,"ABMON_2","","",N,N],[17,"ABMON_3","","",N,N],[17,"ABMON_4","","",N,N],[17,"ABMON_5","","",N,N],[17,"ABMON_6","","",N,N],[17,"ABMON_7","","",N,N],[17,"ABMON_8","","",N,N],[17,"ABMON_9","","",N,N],[17,"ABMON_10","","",N,N],[17,"ABMON_11","","",N,N],[17,"ABMON_12","","",N,N],[17,"MON_1","","",N,N],[17,"MON_2","","",N,N],[17,"MON_3","","",N,N],[17,"MON_4","","",N,N],[17,"MON_5","","",N,N],[17,"MON_6","","",N,N],[17,"MON_7","","",N,N],[17,"MON_8","","",N,N],[17,"MON_9","","",N,N],[17,"MON_10","","",N,N],[17,"MON_11","","",N,N],[17,"MON_12","","",N,N],[17,"AM_STR","","",N,N],[17,"PM_STR","","",N,N],[17,"D_T_FMT","","",N,N],[17,"D_FMT","","",N,N],[17,"T_FMT","","",N,N],[17,"T_FMT_AMPM","","",N,N],[17,"ERA","","",N,N],[17,"ERA_D_FMT","","",N,N],[17,"ALT_DIGITS","","",N,N],[17,"ERA_D_T_FMT","","",N,N],[17,"ERA_T_FMT","","",N,N],[17,"CODESET","","",N,N],[17,"CRNCYSTR","","",N,N],[17,"RUSAGE_THREAD","","",N,N],[17,"RUSAGE_CHILDREN","","",N,N],[17,"RADIXCHAR","","",N,N],[17,"THOUSEP","","",N,N],[17,"YESEXPR","","",N,N],[17,"NOEXPR","","",N,N],[17,"YESSTR","","",N,N],[17,"NOSTR","","",N,N],[17,"FILENAME_MAX","","",N,N],[17,"L_tmpnam","","",N,N],[17,"_PC_LINK_MAX","","",N,N],[17,"_PC_MAX_CANON","","",N,N],[17,"_PC_MAX_INPUT","","",N,N],[17,"_PC_NAME_MAX","","",N,N],[17,"_PC_PATH_MAX","","",N,N],[17,"_PC_PIPE_BUF","","",N,N],[17,"_PC_CHOWN_RESTRICTED","","",N,N],[17,"_PC_NO_TRUNC","","",N,N],[17,"_PC_VDISABLE","","",N,N],[17,"_PC_SYNC_IO","","",N,N],[17,"_PC_ASYNC_IO","","",N,N],[17,"_PC_PRIO_IO","","",N,N],[17,"_PC_SOCK_MAXBUF","","",N,N],[17,"_PC_FILESIZEBITS","","",N,N],[17,"_PC_REC_INCR_XFER_SIZE","","",N,N],[17,"_PC_REC_MAX_XFER_SIZE","","",N,N],[17,"_PC_REC_MIN_XFER_SIZE","","",N,N],[17,"_PC_REC_XFER_ALIGN","","",N,N],[17,"_PC_ALLOC_SIZE_MIN","","",N,N],[17,"_PC_SYMLINK_MAX","","",N,N],[17,"_PC_2_SYMLINKS","","",N,N],[17,"_SC_ARG_MAX","","",N,N],[17,"_SC_CHILD_MAX","","",N,N],[17,"_SC_CLK_TCK","","",N,N],[17,"_SC_NGROUPS_MAX","","",N,N],[17,"_SC_OPEN_MAX","","",N,N],[17,"_SC_STREAM_MAX","","",N,N],[17,"_SC_TZNAME_MAX","","",N,N],[17,"_SC_JOB_CONTROL","","",N,N],[17,"_SC_SAVED_IDS","","",N,N],[17,"_SC_REALTIME_SIGNALS","","",N,N],[17,"_SC_PRIORITY_SCHEDULING","","",N,N],[17,"_SC_TIMERS","","",N,N],[17,"_SC_ASYNCHRONOUS_IO","","",N,N],[17,"_SC_PRIORITIZED_IO","","",N,N],[17,"_SC_SYNCHRONIZED_IO","","",N,N],[17,"_SC_FSYNC","","",N,N],[17,"_SC_MAPPED_FILES","","",N,N],[17,"_SC_MEMLOCK","","",N,N],[17,"_SC_MEMLOCK_RANGE","","",N,N],[17,"_SC_MEMORY_PROTECTION","","",N,N],[17,"_SC_MESSAGE_PASSING","","",N,N],[17,"_SC_SEMAPHORES","","",N,N],[17,"_SC_SHARED_MEMORY_OBJECTS","","",N,N],[17,"_SC_AIO_LISTIO_MAX","","",N,N],[17,"_SC_AIO_MAX","","",N,N],[17,"_SC_AIO_PRIO_DELTA_MAX","","",N,N],[17,"_SC_DELAYTIMER_MAX","","",N,N],[17,"_SC_MQ_OPEN_MAX","","",N,N],[17,"_SC_MQ_PRIO_MAX","","",N,N],[17,"_SC_VERSION","","",N,N],[17,"_SC_PAGESIZE","","",N,N],[17,"_SC_PAGE_SIZE","","",N,N],[17,"_SC_RTSIG_MAX","","",N,N],[17,"_SC_SEM_NSEMS_MAX","","",N,N],[17,"_SC_SEM_VALUE_MAX","","",N,N],[17,"_SC_SIGQUEUE_MAX","","",N,N],[17,"_SC_TIMER_MAX","","",N,N],[17,"_SC_BC_BASE_MAX","","",N,N],[17,"_SC_BC_DIM_MAX","","",N,N],[17,"_SC_BC_SCALE_MAX","","",N,N],[17,"_SC_BC_STRING_MAX","","",N,N],[17,"_SC_COLL_WEIGHTS_MAX","","",N,N],[17,"_SC_EXPR_NEST_MAX","","",N,N],[17,"_SC_LINE_MAX","","",N,N],[17,"_SC_RE_DUP_MAX","","",N,N],[17,"_SC_2_VERSION","","",N,N],[17,"_SC_2_C_BIND","","",N,N],[17,"_SC_2_C_DEV","","",N,N],[17,"_SC_2_FORT_DEV","","",N,N],[17,"_SC_2_FORT_RUN","","",N,N],[17,"_SC_2_SW_DEV","","",N,N],[17,"_SC_2_LOCALEDEF","","",N,N],[17,"_SC_UIO_MAXIOV","","",N,N],[17,"_SC_IOV_MAX","","",N,N],[17,"_SC_THREADS","","",N,N],[17,"_SC_THREAD_SAFE_FUNCTIONS","","",N,N],[17,"_SC_GETGR_R_SIZE_MAX","","",N,N],[17,"_SC_GETPW_R_SIZE_MAX","","",N,N],[17,"_SC_LOGIN_NAME_MAX","","",N,N],[17,"_SC_TTY_NAME_MAX","","",N,N],[17,"_SC_THREAD_DESTRUCTOR_ITERATIONS","","",N,N],[17,"_SC_THREAD_KEYS_MAX","","",N,N],[17,"_SC_THREAD_STACK_MIN","","",N,N],[17,"_SC_THREAD_THREADS_MAX","","",N,N],[17,"_SC_THREAD_ATTR_STACKADDR","","",N,N],[17,"_SC_THREAD_ATTR_STACKSIZE","","",N,N],[17,"_SC_THREAD_PRIORITY_SCHEDULING","","",N,N],[17,"_SC_THREAD_PRIO_INHERIT","","",N,N],[17,"_SC_THREAD_PRIO_PROTECT","","",N,N],[17,"_SC_THREAD_PROCESS_SHARED","","",N,N],[17,"_SC_NPROCESSORS_CONF","","",N,N],[17,"_SC_NPROCESSORS_ONLN","","",N,N],[17,"_SC_PHYS_PAGES","","",N,N],[17,"_SC_AVPHYS_PAGES","","",N,N],[17,"_SC_ATEXIT_MAX","","",N,N],[17,"_SC_PASS_MAX","","",N,N],[17,"_SC_XOPEN_VERSION","","",N,N],[17,"_SC_XOPEN_XCU_VERSION","","",N,N],[17,"_SC_XOPEN_UNIX","","",N,N],[17,"_SC_XOPEN_CRYPT","","",N,N],[17,"_SC_XOPEN_ENH_I18N","","",N,N],[17,"_SC_XOPEN_SHM","","",N,N],[17,"_SC_2_CHAR_TERM","","",N,N],[17,"_SC_2_UPE","","",N,N],[17,"_SC_XOPEN_XPG2","","",N,N],[17,"_SC_XOPEN_XPG3","","",N,N],[17,"_SC_XOPEN_XPG4","","",N,N],[17,"_SC_NZERO","","",N,N],[17,"_SC_XBS5_ILP32_OFF32","","",N,N],[17,"_SC_XBS5_ILP32_OFFBIG","","",N,N],[17,"_SC_XBS5_LP64_OFF64","","",N,N],[17,"_SC_XBS5_LPBIG_OFFBIG","","",N,N],[17,"_SC_XOPEN_LEGACY","","",N,N],[17,"_SC_XOPEN_REALTIME","","",N,N],[17,"_SC_XOPEN_REALTIME_THREADS","","",N,N],[17,"_SC_ADVISORY_INFO","","",N,N],[17,"_SC_BARRIERS","","",N,N],[17,"_SC_CLOCK_SELECTION","","",N,N],[17,"_SC_CPUTIME","","",N,N],[17,"_SC_THREAD_CPUTIME","","",N,N],[17,"_SC_MONOTONIC_CLOCK","","",N,N],[17,"_SC_READER_WRITER_LOCKS","","",N,N],[17,"_SC_SPIN_LOCKS","","",N,N],[17,"_SC_REGEXP","","",N,N],[17,"_SC_SHELL","","",N,N],[17,"_SC_SPAWN","","",N,N],[17,"_SC_SPORADIC_SERVER","","",N,N],[17,"_SC_THREAD_SPORADIC_SERVER","","",N,N],[17,"_SC_TIMEOUTS","","",N,N],[17,"_SC_TYPED_MEMORY_OBJECTS","","",N,N],[17,"_SC_2_PBS","","",N,N],[17,"_SC_2_PBS_ACCOUNTING","","",N,N],[17,"_SC_2_PBS_LOCATE","","",N,N],[17,"_SC_2_PBS_MESSAGE","","",N,N],[17,"_SC_2_PBS_TRACK","","",N,N],[17,"_SC_SYMLOOP_MAX","","",N,N],[17,"_SC_STREAMS","","",N,N],[17,"_SC_2_PBS_CHECKPOINT","","",N,N],[17,"_SC_V6_ILP32_OFF32","","",N,N],[17,"_SC_V6_ILP32_OFFBIG","","",N,N],[17,"_SC_V6_LP64_OFF64","","",N,N],[17,"_SC_V6_LPBIG_OFFBIG","","",N,N],[17,"_SC_HOST_NAME_MAX","","",N,N],[17,"_SC_TRACE","","",N,N],[17,"_SC_TRACE_EVENT_FILTER","","",N,N],[17,"_SC_TRACE_INHERIT","","",N,N],[17,"_SC_TRACE_LOG","","",N,N],[17,"_SC_IPV6","","",N,N],[17,"_SC_RAW_SOCKETS","","",N,N],[17,"_SC_V7_ILP32_OFF32","","",N,N],[17,"_SC_V7_ILP32_OFFBIG","","",N,N],[17,"_SC_V7_LP64_OFF64","","",N,N],[17,"_SC_V7_LPBIG_OFFBIG","","",N,N],[17,"_SC_SS_REPL_MAX","","",N,N],[17,"_SC_TRACE_EVENT_NAME_MAX","","",N,N],[17,"_SC_TRACE_NAME_MAX","","",N,N],[17,"_SC_TRACE_SYS_MAX","","",N,N],[17,"_SC_TRACE_USER_EVENT_MAX","","",N,N],[17,"_SC_XOPEN_STREAMS","","",N,N],[17,"_SC_THREAD_ROBUST_PRIO_INHERIT","","",N,N],[17,"_SC_THREAD_ROBUST_PRIO_PROTECT","","",N,N],[17,"RLIM_SAVED_MAX","","",N,N],[17,"RLIM_SAVED_CUR","","",N,N],[17,"GLOB_ERR","","",N,N],[17,"GLOB_MARK","","",N,N],[17,"GLOB_NOSORT","","",N,N],[17,"GLOB_DOOFFS","","",N,N],[17,"GLOB_NOCHECK","","",N,N],[17,"GLOB_APPEND","","",N,N],[17,"GLOB_NOESCAPE","","",N,N],[17,"GLOB_NOSPACE","","",N,N],[17,"GLOB_ABORTED","","",N,N],[17,"GLOB_NOMATCH","","",N,N],[17,"POSIX_MADV_NORMAL","","",N,N],[17,"POSIX_MADV_RANDOM","","",N,N],[17,"POSIX_MADV_SEQUENTIAL","","",N,N],[17,"POSIX_MADV_WILLNEED","","",N,N],[17,"S_IEXEC","","",N,N],[17,"S_IWRITE","","",N,N],[17,"S_IREAD","","",N,N],[17,"F_LOCK","","",N,N],[17,"F_TEST","","",N,N],[17,"F_TLOCK","","",N,N],[17,"F_ULOCK","","",N,N],[17,"IFF_LOWER_UP","","",N,N],[17,"IFF_DORMANT","","",N,N],[17,"IFF_ECHO","","",N,N],[17,"IFF_TUN","","",N,N],[17,"IFF_TAP","","",N,N],[17,"IFF_NO_PI","","",N,N],[17,"TUN_READQ_SIZE","","",N,N],[17,"TUN_TUN_DEV","","",N,N],[17,"TUN_TAP_DEV","","",N,N],[17,"TUN_TYPE_MASK","","",N,N],[17,"IFF_ONE_QUEUE","","",N,N],[17,"IFF_VNET_HDR","","",N,N],[17,"IFF_TUN_EXCL","","",N,N],[17,"IFF_MULTI_QUEUE","","",N,N],[17,"IFF_ATTACH_QUEUE","","",N,N],[17,"IFF_DETACH_QUEUE","","",N,N],[17,"IFF_PERSIST","","",N,N],[17,"IFF_NOFILTER","","",N,N],[17,"ST_RDONLY","","",N,N],[17,"ST_NOSUID","","",N,N],[17,"ST_NODEV","","",N,N],[17,"ST_NOEXEC","","",N,N],[17,"ST_SYNCHRONOUS","","",N,N],[17,"ST_MANDLOCK","","",N,N],[17,"ST_WRITE","","",N,N],[17,"ST_APPEND","","",N,N],[17,"ST_IMMUTABLE","","",N,N],[17,"ST_NOATIME","","",N,N],[17,"ST_NODIRATIME","","",N,N],[17,"RTLD_NEXT","","",N,N],[17,"RTLD_DEFAULT","","",N,N],[17,"RTLD_NODELETE","","",N,N],[17,"RTLD_NOW","","",N,N],[17,"TCP_MD5SIG","","",N,N],[17,"PTHREAD_MUTEX_INITIALIZER","","",N,N],[17,"PTHREAD_COND_INITIALIZER","","",N,N],[17,"PTHREAD_RWLOCK_INITIALIZER","","",N,N],[17,"PTHREAD_MUTEX_NORMAL","","",N,N],[17,"PTHREAD_MUTEX_RECURSIVE","","",N,N],[17,"PTHREAD_MUTEX_ERRORCHECK","","",N,N],[17,"PTHREAD_MUTEX_DEFAULT","","",N,N],[17,"PTHREAD_PROCESS_PRIVATE","","",N,N],[17,"PTHREAD_PROCESS_SHARED","","",N,N],[17,"__SIZEOF_PTHREAD_COND_T","","",N,N],[17,"RENAME_NOREPLACE","","",N,N],[17,"RENAME_EXCHANGE","","",N,N],[17,"RENAME_WHITEOUT","","",N,N],[17,"SCHED_OTHER","","",N,N],[17,"SCHED_FIFO","","",N,N],[17,"SCHED_RR","","",N,N],[17,"SCHED_BATCH","","",N,N],[17,"SCHED_IDLE","","",N,N],[17,"IPPROTO_HOPOPTS","","Hop-by-hop option header",N,N],[17,"IPPROTO_IGMP","","group mgmt protocol",N,N],[17,"IPPROTO_IPIP","","for compatibility",N,N],[17,"IPPROTO_EGP","","exterior gateway protocol",N,N],[17,"IPPROTO_PUP","","pup",N,N],[17,"IPPROTO_IDP","","xns idp",N,N],[17,"IPPROTO_TP","","tp-4 w/ class negotiation",N,N],[17,"IPPROTO_DCCP","","DCCP",N,N],[17,"IPPROTO_ROUTING","","IP6 routing header",N,N],[17,"IPPROTO_FRAGMENT","","IP6 fragmentation header",N,N],[17,"IPPROTO_RSVP","","resource reservation",N,N],[17,"IPPROTO_GRE","","General Routing Encap.",N,N],[17,"IPPROTO_ESP","","IP6 Encap Sec. Payload",N,N],[17,"IPPROTO_AH","","IP6 Auth Header",N,N],[17,"IPPROTO_NONE","","IP6 no next header",N,N],[17,"IPPROTO_DSTOPTS","","IP6 destination option",N,N],[17,"IPPROTO_MTP","","",N,N],[17,"IPPROTO_BEETPH","","",N,N],[17,"IPPROTO_ENCAP","","encapsulation header",N,N],[17,"IPPROTO_PIM","","Protocol indep. multicast",N,N],[17,"IPPROTO_COMP","","IP Payload Comp. Protocol",N,N],[17,"IPPROTO_SCTP","","SCTP",N,N],[17,"IPPROTO_MH","","",N,N],[17,"IPPROTO_UDPLITE","","",N,N],[17,"IPPROTO_MPLS","","",N,N],[17,"IPPROTO_RAW","","raw IP packet",N,N],[17,"IPPROTO_MAX","","",N,N],[17,"AF_IB","","",N,N],[17,"AF_MPLS","","",N,N],[17,"AF_NFC","","",N,N],[17,"AF_VSOCK","","",N,N],[17,"PF_IB","","",N,N],[17,"PF_MPLS","","",N,N],[17,"PF_NFC","","",N,N],[17,"PF_VSOCK","","",N,N],[17,"IPC_PRIVATE","","",N,N],[17,"IPC_CREAT","","",N,N],[17,"IPC_EXCL","","",N,N],[17,"IPC_NOWAIT","","",N,N],[17,"IPC_RMID","","",N,N],[17,"IPC_SET","","",N,N],[17,"IPC_STAT","","",N,N],[17,"IPC_INFO","","",N,N],[17,"MSG_STAT","","",N,N],[17,"MSG_INFO","","",N,N],[17,"MSG_NOERROR","","",N,N],[17,"MSG_EXCEPT","","",N,N],[17,"MSG_COPY","","",N,N],[17,"SHM_R","","",N,N],[17,"SHM_W","","",N,N],[17,"SHM_RDONLY","","",N,N],[17,"SHM_RND","","",N,N],[17,"SHM_REMAP","","",N,N],[17,"SHM_EXEC","","",N,N],[17,"SHM_LOCK","","",N,N],[17,"SHM_UNLOCK","","",N,N],[17,"SHM_HUGETLB","","",N,N],[17,"SHM_NORESERVE","","",N,N],[17,"EPOLLRDHUP","","",N,N],[17,"EPOLLEXCLUSIVE","","",N,N],[17,"EPOLLONESHOT","","",N,N],[17,"QFMT_VFS_OLD","","",N,N],[17,"QFMT_VFS_V0","","",N,N],[17,"QFMT_VFS_V1","","",N,N],[17,"EFD_SEMAPHORE","","",N,N],[17,"LOG_NFACILITIES","","",N,N],[17,"SEM_FAILED","","",N,N],[17,"RB_AUTOBOOT","","",N,N],[17,"RB_HALT_SYSTEM","","",N,N],[17,"RB_ENABLE_CAD","","",N,N],[17,"RB_DISABLE_CAD","","",N,N],[17,"RB_POWER_OFF","","",N,N],[17,"RB_SW_SUSPEND","","",N,N],[17,"RB_KEXEC","","",N,N],[17,"AI_PASSIVE","","",N,N],[17,"AI_CANONNAME","","",N,N],[17,"AI_NUMERICHOST","","",N,N],[17,"AI_V4MAPPED","","",N,N],[17,"AI_ALL","","",N,N],[17,"AI_ADDRCONFIG","","",N,N],[17,"AI_NUMERICSERV","","",N,N],[17,"EAI_BADFLAGS","","",N,N],[17,"EAI_NONAME","","",N,N],[17,"EAI_AGAIN","","",N,N],[17,"EAI_FAIL","","",N,N],[17,"EAI_NODATA","","",N,N],[17,"EAI_FAMILY","","",N,N],[17,"EAI_SOCKTYPE","","",N,N],[17,"EAI_SERVICE","","",N,N],[17,"EAI_MEMORY","","",N,N],[17,"EAI_SYSTEM","","",N,N],[17,"EAI_OVERFLOW","","",N,N],[17,"NI_NUMERICHOST","","",N,N],[17,"NI_NUMERICSERV","","",N,N],[17,"NI_NOFQDN","","",N,N],[17,"NI_NAMEREQD","","",N,N],[17,"NI_DGRAM","","",N,N],[17,"SYNC_FILE_RANGE_WAIT_BEFORE","","",N,N],[17,"SYNC_FILE_RANGE_WRITE","","",N,N],[17,"SYNC_FILE_RANGE_WAIT_AFTER","","",N,N],[17,"AIO_CANCELED","","",N,N],[17,"AIO_NOTCANCELED","","",N,N],[17,"AIO_ALLDONE","","",N,N],[17,"LIO_READ","","",N,N],[17,"LIO_WRITE","","",N,N],[17,"LIO_NOP","","",N,N],[17,"LIO_WAIT","","",N,N],[17,"LIO_NOWAIT","","",N,N],[17,"MREMAP_MAYMOVE","","",N,N],[17,"MREMAP_FIXED","","",N,N],[17,"PR_SET_PDEATHSIG","","",N,N],[17,"PR_GET_PDEATHSIG","","",N,N],[17,"PR_GET_DUMPABLE","","",N,N],[17,"PR_SET_DUMPABLE","","",N,N],[17,"PR_GET_UNALIGN","","",N,N],[17,"PR_SET_UNALIGN","","",N,N],[17,"PR_UNALIGN_NOPRINT","","",N,N],[17,"PR_UNALIGN_SIGBUS","","",N,N],[17,"PR_GET_KEEPCAPS","","",N,N],[17,"PR_SET_KEEPCAPS","","",N,N],[17,"PR_GET_FPEMU","","",N,N],[17,"PR_SET_FPEMU","","",N,N],[17,"PR_FPEMU_NOPRINT","","",N,N],[17,"PR_FPEMU_SIGFPE","","",N,N],[17,"PR_GET_FPEXC","","",N,N],[17,"PR_SET_FPEXC","","",N,N],[17,"PR_FP_EXC_SW_ENABLE","","",N,N],[17,"PR_FP_EXC_DIV","","",N,N],[17,"PR_FP_EXC_OVF","","",N,N],[17,"PR_FP_EXC_UND","","",N,N],[17,"PR_FP_EXC_RES","","",N,N],[17,"PR_FP_EXC_INV","","",N,N],[17,"PR_FP_EXC_DISABLED","","",N,N],[17,"PR_FP_EXC_NONRECOV","","",N,N],[17,"PR_FP_EXC_ASYNC","","",N,N],[17,"PR_FP_EXC_PRECISE","","",N,N],[17,"PR_GET_TIMING","","",N,N],[17,"PR_SET_TIMING","","",N,N],[17,"PR_TIMING_STATISTICAL","","",N,N],[17,"PR_TIMING_TIMESTAMP","","",N,N],[17,"PR_SET_NAME","","",N,N],[17,"PR_GET_NAME","","",N,N],[17,"PR_GET_ENDIAN","","",N,N],[17,"PR_SET_ENDIAN","","",N,N],[17,"PR_ENDIAN_BIG","","",N,N],[17,"PR_ENDIAN_LITTLE","","",N,N],[17,"PR_ENDIAN_PPC_LITTLE","","",N,N],[17,"PR_GET_SECCOMP","","",N,N],[17,"PR_SET_SECCOMP","","",N,N],[17,"PR_CAPBSET_READ","","",N,N],[17,"PR_CAPBSET_DROP","","",N,N],[17,"PR_GET_TSC","","",N,N],[17,"PR_SET_TSC","","",N,N],[17,"PR_TSC_ENABLE","","",N,N],[17,"PR_TSC_SIGSEGV","","",N,N],[17,"PR_GET_SECUREBITS","","",N,N],[17,"PR_SET_SECUREBITS","","",N,N],[17,"PR_SET_TIMERSLACK","","",N,N],[17,"PR_GET_TIMERSLACK","","",N,N],[17,"PR_TASK_PERF_EVENTS_DISABLE","","",N,N],[17,"PR_TASK_PERF_EVENTS_ENABLE","","",N,N],[17,"PR_MCE_KILL","","",N,N],[17,"PR_MCE_KILL_CLEAR","","",N,N],[17,"PR_MCE_KILL_SET","","",N,N],[17,"PR_MCE_KILL_LATE","","",N,N],[17,"PR_MCE_KILL_EARLY","","",N,N],[17,"PR_MCE_KILL_DEFAULT","","",N,N],[17,"PR_MCE_KILL_GET","","",N,N],[17,"PR_SET_MM","","",N,N],[17,"PR_SET_MM_START_CODE","","",N,N],[17,"PR_SET_MM_END_CODE","","",N,N],[17,"PR_SET_MM_START_DATA","","",N,N],[17,"PR_SET_MM_END_DATA","","",N,N],[17,"PR_SET_MM_START_STACK","","",N,N],[17,"PR_SET_MM_START_BRK","","",N,N],[17,"PR_SET_MM_BRK","","",N,N],[17,"PR_SET_MM_ARG_START","","",N,N],[17,"PR_SET_MM_ARG_END","","",N,N],[17,"PR_SET_MM_ENV_START","","",N,N],[17,"PR_SET_MM_ENV_END","","",N,N],[17,"PR_SET_MM_AUXV","","",N,N],[17,"PR_SET_MM_EXE_FILE","","",N,N],[17,"PR_SET_MM_MAP","","",N,N],[17,"PR_SET_MM_MAP_SIZE","","",N,N],[17,"PR_SET_PTRACER","","",N,N],[17,"PR_SET_CHILD_SUBREAPER","","",N,N],[17,"PR_GET_CHILD_SUBREAPER","","",N,N],[17,"PR_SET_NO_NEW_PRIVS","","",N,N],[17,"PR_GET_NO_NEW_PRIVS","","",N,N],[17,"PR_GET_TID_ADDRESS","","",N,N],[17,"PR_SET_THP_DISABLE","","",N,N],[17,"PR_GET_THP_DISABLE","","",N,N],[17,"PR_MPX_ENABLE_MANAGEMENT","","",N,N],[17,"PR_MPX_DISABLE_MANAGEMENT","","",N,N],[17,"PR_SET_FP_MODE","","",N,N],[17,"PR_GET_FP_MODE","","",N,N],[17,"PR_FP_MODE_FR","","",N,N],[17,"PR_FP_MODE_FRE","","",N,N],[17,"PR_CAP_AMBIENT","","",N,N],[17,"PR_CAP_AMBIENT_IS_SET","","",N,N],[17,"PR_CAP_AMBIENT_RAISE","","",N,N],[17,"PR_CAP_AMBIENT_LOWER","","",N,N],[17,"PR_CAP_AMBIENT_CLEAR_ALL","","",N,N],[17,"GRND_NONBLOCK","","",N,N],[17,"GRND_RANDOM","","",N,N],[17,"SECCOMP_MODE_DISABLED","","",N,N],[17,"SECCOMP_MODE_STRICT","","",N,N],[17,"SECCOMP_MODE_FILTER","","",N,N],[17,"ITIMER_REAL","","",N,N],[17,"ITIMER_VIRTUAL","","",N,N],[17,"ITIMER_PROF","","",N,N],[17,"TFD_CLOEXEC","","",N,N],[17,"TFD_NONBLOCK","","",N,N],[17,"TFD_TIMER_ABSTIME","","",N,N],[17,"XATTR_CREATE","","",N,N],[17,"XATTR_REPLACE","","",N,N],[17,"_POSIX_VDISABLE","","",N,N],[17,"FALLOC_FL_KEEP_SIZE","","",N,N],[17,"FALLOC_FL_PUNCH_HOLE","","",N,N],[17,"FALLOC_FL_COLLAPSE_RANGE","","",N,N],[17,"FALLOC_FL_ZERO_RANGE","","",N,N],[17,"FALLOC_FL_INSERT_RANGE","","",N,N],[17,"FALLOC_FL_UNSHARE_RANGE","","",N,N],[17,"ENOATTR","","",N,N],[17,"SO_ORIGINAL_DST","","",N,N],[17,"IUTF8","","",N,N],[17,"CMSPAR","","",N,N],[17,"MFD_CLOEXEC","","",N,N],[17,"MFD_ALLOW_SEALING","","",N,N],[17,"PT_NULL","","",N,N],[17,"PT_LOAD","","",N,N],[17,"PT_DYNAMIC","","",N,N],[17,"PT_INTERP","","",N,N],[17,"PT_NOTE","","",N,N],[17,"PT_SHLIB","","",N,N],[17,"PT_PHDR","","",N,N],[17,"PT_TLS","","",N,N],[17,"PT_NUM","","",N,N],[17,"PT_LOOS","","",N,N],[17,"PT_GNU_EH_FRAME","","",N,N],[17,"PT_GNU_STACK","","",N,N],[17,"PT_GNU_RELRO","","",N,N],[17,"ETH_ALEN","","",N,N],[17,"ETH_HLEN","","",N,N],[17,"ETH_ZLEN","","",N,N],[17,"ETH_DATA_LEN","","",N,N],[17,"ETH_FRAME_LEN","","",N,N],[17,"ETH_FCS_LEN","","",N,N],[17,"ETH_P_LOOP","","",N,N],[17,"ETH_P_PUP","","",N,N],[17,"ETH_P_PUPAT","","",N,N],[17,"ETH_P_IP","","",N,N],[17,"ETH_P_X25","","",N,N],[17,"ETH_P_ARP","","",N,N],[17,"ETH_P_BPQ","","",N,N],[17,"ETH_P_IEEEPUP","","",N,N],[17,"ETH_P_IEEEPUPAT","","",N,N],[17,"ETH_P_BATMAN","","",N,N],[17,"ETH_P_DEC","","",N,N],[17,"ETH_P_DNA_DL","","",N,N],[17,"ETH_P_DNA_RC","","",N,N],[17,"ETH_P_DNA_RT","","",N,N],[17,"ETH_P_LAT","","",N,N],[17,"ETH_P_DIAG","","",N,N],[17,"ETH_P_CUST","","",N,N],[17,"ETH_P_SCA","","",N,N],[17,"ETH_P_TEB","","",N,N],[17,"ETH_P_RARP","","",N,N],[17,"ETH_P_ATALK","","",N,N],[17,"ETH_P_AARP","","",N,N],[17,"ETH_P_8021Q","","",N,N],[17,"ETH_P_IPX","","",N,N],[17,"ETH_P_IPV6","","",N,N],[17,"ETH_P_PAUSE","","",N,N],[17,"ETH_P_SLOW","","",N,N],[17,"ETH_P_WCCP","","",N,N],[17,"ETH_P_MPLS_UC","","",N,N],[17,"ETH_P_MPLS_MC","","",N,N],[17,"ETH_P_ATMMPOA","","",N,N],[17,"ETH_P_PPP_DISC","","",N,N],[17,"ETH_P_PPP_SES","","",N,N],[17,"ETH_P_LINK_CTL","","",N,N],[17,"ETH_P_ATMFATE","","",N,N],[17,"ETH_P_PAE","","",N,N],[17,"ETH_P_AOE","","",N,N],[17,"ETH_P_8021AD","","",N,N],[17,"ETH_P_802_EX1","","",N,N],[17,"ETH_P_TIPC","","",N,N],[17,"ETH_P_MACSEC","","",N,N],[17,"ETH_P_8021AH","","",N,N],[17,"ETH_P_MVRP","","",N,N],[17,"ETH_P_1588","","",N,N],[17,"ETH_P_PRP","","",N,N],[17,"ETH_P_FCOE","","",N,N],[17,"ETH_P_TDLS","","",N,N],[17,"ETH_P_FIP","","",N,N],[17,"ETH_P_80221","","",N,N],[17,"ETH_P_LOOPBACK","","",N,N],[17,"ETH_P_QINQ1","","",N,N],[17,"ETH_P_QINQ2","","",N,N],[17,"ETH_P_QINQ3","","",N,N],[17,"ETH_P_EDSA","","",N,N],[17,"ETH_P_AF_IUCV","","",N,N],[17,"ETH_P_802_3_MIN","","",N,N],[17,"ETH_P_802_3","","",N,N],[17,"ETH_P_AX25","","",N,N],[17,"ETH_P_ALL","","",N,N],[17,"ETH_P_802_2","","",N,N],[17,"ETH_P_SNAP","","",N,N],[17,"ETH_P_DDCMP","","",N,N],[17,"ETH_P_WAN_PPP","","",N,N],[17,"ETH_P_PPP_MP","","",N,N],[17,"ETH_P_LOCALTALK","","",N,N],[17,"ETH_P_CANFD","","",N,N],[17,"ETH_P_PPPTALK","","",N,N],[17,"ETH_P_TR_802_2","","",N,N],[17,"ETH_P_MOBITEX","","",N,N],[17,"ETH_P_CONTROL","","",N,N],[17,"ETH_P_IRDA","","",N,N],[17,"ETH_P_ECONET","","",N,N],[17,"ETH_P_HDLC","","",N,N],[17,"ETH_P_ARCNET","","",N,N],[17,"ETH_P_DSA","","",N,N],[17,"ETH_P_TRAILER","","",N,N],[17,"ETH_P_PHONET","","",N,N],[17,"ETH_P_IEEE802154","","",N,N],[17,"ETH_P_CAIF","","",N,N],[17,"POSIX_SPAWN_RESETIDS","","",N,N],[17,"POSIX_SPAWN_SETPGROUP","","",N,N],[17,"POSIX_SPAWN_SETSIGDEF","","",N,N],[17,"POSIX_SPAWN_SETSIGMASK","","",N,N],[17,"POSIX_SPAWN_SETSCHEDPARAM","","",N,N],[17,"POSIX_SPAWN_SETSCHEDULER","","",N,N],[17,"NLMSG_NOOP","","",N,N],[17,"NLMSG_ERROR","","",N,N],[17,"NLMSG_DONE","","",N,N],[17,"NLMSG_OVERRUN","","",N,N],[17,"NLMSG_MIN_TYPE","","",N,N],[17,"GENL_NAMSIZ","","",N,N],[17,"GENL_MIN_ID","","",N,N],[17,"GENL_MAX_ID","","",N,N],[17,"GENL_ADMIN_PERM","","",N,N],[17,"GENL_CMD_CAP_DO","","",N,N],[17,"GENL_CMD_CAP_DUMP","","",N,N],[17,"GENL_CMD_CAP_HASPOL","","",N,N],[17,"GENL_ID_CTRL","","",N,N],[17,"CTRL_CMD_UNSPEC","","",N,N],[17,"CTRL_CMD_NEWFAMILY","","",N,N],[17,"CTRL_CMD_DELFAMILY","","",N,N],[17,"CTRL_CMD_GETFAMILY","","",N,N],[17,"CTRL_CMD_NEWOPS","","",N,N],[17,"CTRL_CMD_DELOPS","","",N,N],[17,"CTRL_CMD_GETOPS","","",N,N],[17,"CTRL_CMD_NEWMCAST_GRP","","",N,N],[17,"CTRL_CMD_DELMCAST_GRP","","",N,N],[17,"CTRL_CMD_GETMCAST_GRP","","",N,N],[17,"CTRL_ATTR_UNSPEC","","",N,N],[17,"CTRL_ATTR_FAMILY_ID","","",N,N],[17,"CTRL_ATTR_FAMILY_NAME","","",N,N],[17,"CTRL_ATTR_VERSION","","",N,N],[17,"CTRL_ATTR_HDRSIZE","","",N,N],[17,"CTRL_ATTR_MAXATTR","","",N,N],[17,"CTRL_ATTR_OPS","","",N,N],[17,"CTRL_ATTR_MCAST_GROUPS","","",N,N],[17,"CTRL_ATTR_OP_UNSPEC","","",N,N],[17,"CTRL_ATTR_OP_ID","","",N,N],[17,"CTRL_ATTR_OP_FLAGS","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_UNSPEC","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_NAME","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_ID","","",N,N],[17,"PACKET_ADD_MEMBERSHIP","","",N,N],[17,"PACKET_DROP_MEMBERSHIP","","",N,N],[17,"PACKET_MR_MULTICAST","","",N,N],[17,"PACKET_MR_PROMISC","","",N,N],[17,"PACKET_MR_ALLMULTI","","",N,N],[17,"PACKET_MR_UNICAST","","",N,N],[17,"NF_DROP","","",N,N],[17,"NF_ACCEPT","","",N,N],[17,"NF_STOLEN","","",N,N],[17,"NF_QUEUE","","",N,N],[17,"NF_REPEAT","","",N,N],[17,"NF_STOP","","",N,N],[17,"NF_MAX_VERDICT","","",N,N],[17,"NF_VERDICT_MASK","","",N,N],[17,"NF_VERDICT_FLAG_QUEUE_BYPASS","","",N,N],[17,"NF_VERDICT_QMASK","","",N,N],[17,"NF_VERDICT_QBITS","","",N,N],[17,"NF_VERDICT_BITS","","",N,N],[17,"NF_INET_PRE_ROUTING","","",N,N],[17,"NF_INET_LOCAL_IN","","",N,N],[17,"NF_INET_FORWARD","","",N,N],[17,"NF_INET_LOCAL_OUT","","",N,N],[17,"NF_INET_POST_ROUTING","","",N,N],[17,"NF_INET_NUMHOOKS","","",N,N],[17,"NFPROTO_UNSPEC","","",N,N],[17,"NFPROTO_IPV4","","",N,N],[17,"NFPROTO_ARP","","",N,N],[17,"NFPROTO_BRIDGE","","",N,N],[17,"NFPROTO_IPV6","","",N,N],[17,"NFPROTO_DECNET","","",N,N],[17,"NFPROTO_NUMPROTO","","",N,N],[17,"NF_IP_PRE_ROUTING","","",N,N],[17,"NF_IP_LOCAL_IN","","",N,N],[17,"NF_IP_FORWARD","","",N,N],[17,"NF_IP_LOCAL_OUT","","",N,N],[17,"NF_IP_POST_ROUTING","","",N,N],[17,"NF_IP_NUMHOOKS","","",N,N],[17,"NF_IP_PRI_FIRST","","",N,N],[17,"NF_IP_PRI_CONNTRACK_DEFRAG","","",N,N],[17,"NF_IP_PRI_RAW","","",N,N],[17,"NF_IP_PRI_SELINUX_FIRST","","",N,N],[17,"NF_IP_PRI_CONNTRACK","","",N,N],[17,"NF_IP_PRI_MANGLE","","",N,N],[17,"NF_IP_PRI_NAT_DST","","",N,N],[17,"NF_IP_PRI_FILTER","","",N,N],[17,"NF_IP_PRI_SECURITY","","",N,N],[17,"NF_IP_PRI_NAT_SRC","","",N,N],[17,"NF_IP_PRI_SELINUX_LAST","","",N,N],[17,"NF_IP_PRI_CONNTRACK_HELPER","","",N,N],[17,"NF_IP_PRI_CONNTRACK_CONFIRM","","",N,N],[17,"NF_IP_PRI_LAST","","",N,N],[17,"NF_IP6_PRE_ROUTING","","",N,N],[17,"NF_IP6_LOCAL_IN","","",N,N],[17,"NF_IP6_FORWARD","","",N,N],[17,"NF_IP6_LOCAL_OUT","","",N,N],[17,"NF_IP6_POST_ROUTING","","",N,N],[17,"NF_IP6_NUMHOOKS","","",N,N],[17,"NF_IP6_PRI_FIRST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK_DEFRAG","","",N,N],[17,"NF_IP6_PRI_RAW","","",N,N],[17,"NF_IP6_PRI_SELINUX_FIRST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK","","",N,N],[17,"NF_IP6_PRI_MANGLE","","",N,N],[17,"NF_IP6_PRI_NAT_DST","","",N,N],[17,"NF_IP6_PRI_FILTER","","",N,N],[17,"NF_IP6_PRI_SECURITY","","",N,N],[17,"NF_IP6_PRI_NAT_SRC","","",N,N],[17,"NF_IP6_PRI_SELINUX_LAST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK_HELPER","","",N,N],[17,"NF_IP6_PRI_LAST","","",N,N],[17,"SIOCADDRT","","",N,N],[17,"SIOCDELRT","","",N,N],[17,"SIOCGIFNAME","","",N,N],[17,"SIOCSIFLINK","","",N,N],[17,"SIOCGIFCONF","","",N,N],[17,"SIOCGIFFLAGS","","",N,N],[17,"SIOCSIFFLAGS","","",N,N],[17,"SIOCGIFADDR","","",N,N],[17,"SIOCSIFADDR","","",N,N],[17,"SIOCGIFDSTADDR","","",N,N],[17,"SIOCSIFDSTADDR","","",N,N],[17,"SIOCGIFBRDADDR","","",N,N],[17,"SIOCSIFBRDADDR","","",N,N],[17,"SIOCGIFNETMASK","","",N,N],[17,"SIOCSIFNETMASK","","",N,N],[17,"SIOCGIFMETRIC","","",N,N],[17,"SIOCSIFMETRIC","","",N,N],[17,"SIOCGIFMEM","","",N,N],[17,"SIOCSIFMEM","","",N,N],[17,"SIOCGIFMTU","","",N,N],[17,"SIOCSIFMTU","","",N,N],[17,"SIOCSIFHWADDR","","",N,N],[17,"SIOCGIFENCAP","","",N,N],[17,"SIOCSIFENCAP","","",N,N],[17,"SIOCGIFHWADDR","","",N,N],[17,"SIOCGIFSLAVE","","",N,N],[17,"SIOCSIFSLAVE","","",N,N],[17,"SIOCADDMULTI","","",N,N],[17,"SIOCDELMULTI","","",N,N],[17,"SIOCDARP","","",N,N],[17,"SIOCGARP","","",N,N],[17,"SIOCSARP","","",N,N],[17,"SIOCDRARP","","",N,N],[17,"SIOCGRARP","","",N,N],[17,"SIOCSRARP","","",N,N],[17,"SIOCGIFMAP","","",N,N],[17,"SIOCSIFMAP","","",N,N],[17,"IPTOS_TOS_MASK","","",N,N],[17,"IPTOS_PREC_MASK","","",N,N],[17,"RTF_UP","","",N,N],[17,"RTF_GATEWAY","","",N,N],[17,"RTF_HOST","","",N,N],[17,"RTF_REINSTATE","","",N,N],[17,"RTF_DYNAMIC","","",N,N],[17,"RTF_MODIFIED","","",N,N],[17,"RTF_MTU","","",N,N],[17,"RTF_MSS","","",N,N],[17,"RTF_WINDOW","","",N,N],[17,"RTF_IRTT","","",N,N],[17,"RTF_REJECT","","",N,N],[17,"RTF_STATIC","","",N,N],[17,"RTF_XRESOLVE","","",N,N],[17,"RTF_NOFORWARD","","",N,N],[17,"RTF_THROW","","",N,N],[17,"RTF_NOPMTUDISC","","",N,N],[17,"RTF_DEFAULT","","",N,N],[17,"RTF_ALLONLINK","","",N,N],[17,"RTF_ADDRCONF","","",N,N],[17,"RTF_LINKRT","","",N,N],[17,"RTF_NONEXTHOP","","",N,N],[17,"RTF_CACHE","","",N,N],[17,"RTF_FLOW","","",N,N],[17,"RTF_POLICY","","",N,N],[17,"RTCF_VALVE","","",N,N],[17,"RTCF_MASQ","","",N,N],[17,"RTCF_NAT","","",N,N],[17,"RTCF_DOREDIRECT","","",N,N],[17,"RTCF_LOG","","",N,N],[17,"RTCF_DIRECTSRC","","",N,N],[17,"RTF_LOCAL","","",N,N],[17,"RTF_INTERFACE","","",N,N],[17,"RTF_MULTICAST","","",N,N],[17,"RTF_BROADCAST","","",N,N],[17,"RTF_NAT","","",N,N],[17,"RTF_ADDRCLASSMASK","","",N,N],[17,"RT_CLASS_UNSPEC","","",N,N],[17,"RT_CLASS_DEFAULT","","",N,N],[17,"RT_CLASS_MAIN","","",N,N],[17,"RT_CLASS_LOCAL","","",N,N],[17,"RT_CLASS_MAX","","",N,N],[17,"RTMSG_OVERRUN","","",N,N],[17,"RTMSG_NEWDEVICE","","",N,N],[17,"RTMSG_DELDEVICE","","",N,N],[17,"RTMSG_NEWROUTE","","",N,N],[17,"RTMSG_DELROUTE","","",N,N],[17,"RTMSG_NEWRULE","","",N,N],[17,"RTMSG_DELRULE","","",N,N],[17,"RTMSG_CONTROL","","",N,N],[17,"RTMSG_AR_FAILED","","",N,N],[17,"MAX_ADDR_LEN","","",N,N],[17,"ARPD_UPDATE","","",N,N],[17,"ARPD_LOOKUP","","",N,N],[17,"ARPD_FLUSH","","",N,N],[17,"ATF_MAGIC","","",N,N],[17,"MODULE_INIT_IGNORE_MODVERSIONS","","",N,N],[17,"MODULE_INIT_IGNORE_VERMAGIC","","",N,N],[11,"clone","libc","",42,[[["self"]],["dirent"]]],[11,"clone","","",43,[[["self"]],["dirent64"]]],[11,"clone","","",44,[[["self"]],["rlimit64"]]],[11,"clone","","",45,[[["self"]],["glob_t"]]],[11,"clone","","",46,[[["self"]],["pthread_mutex_t"]]],[11,"clone","","",47,[[["self"]],["pthread_rwlock_t"]]],[11,"clone","","",48,[[["self"]],["pthread_mutexattr_t"]]],[11,"clone","","",49,[[["self"]],["pthread_rwlockattr_t"]]],[11,"clone","","",50,[[["self"]],["pthread_cond_t"]]],[11,"clone","","",51,[[["self"]],["pthread_condattr_t"]]],[11,"clone","","",52,[[["self"]],["passwd"]]],[11,"clone","","",53,[[["self"]],["spwd"]]],[11,"clone","","",54,[[["self"]],["dqblk"]]],[11,"clone","","",55,[[["self"]],["signalfd_siginfo"]]],[11,"clone","","",56,[[["self"]],["itimerspec"]]],[11,"clone","","",57,[[["self"]],["fsid_t"]]],[11,"clone","","",58,[[["self"]],["mq_attr"]]],[11,"clone","","",59,[[["self"]],["packet_mreq"]]],[11,"clone","","",60,[[["self"]],["cpu_set_t"]]],[11,"clone","","",61,[[["self"]],["if_nameindex"]]],[11,"clone","","",62,[[["self"]],["msginfo"]]],[11,"clone","","",63,[[["self"]],["mmsghdr"]]],[11,"clone","","",64,[[["self"]],["sembuf"]]],[11,"clone","","",65,[[["self"]],["input_event"]]],[11,"clone","","",66,[[["self"]],["input_id"]]],[11,"clone","","",67,[[["self"]],["input_absinfo"]]],[11,"clone","","",68,[[["self"]],["input_keymap_entry"]]],[11,"clone","","",69,[[["self"]],["input_mask"]]],[11,"clone","","",70,[[["self"]],["ff_replay"]]],[11,"clone","","",71,[[["self"]],["ff_trigger"]]],[11,"clone","","",72,[[["self"]],["ff_envelope"]]],[11,"clone","","",73,[[["self"]],["ff_constant_effect"]]],[11,"clone","","",74,[[["self"]],["ff_ramp_effect"]]],[11,"clone","","",75,[[["self"]],["ff_condition_effect"]]],[11,"clone","","",76,[[["self"]],["ff_periodic_effect"]]],[11,"clone","","",77,[[["self"]],["ff_rumble_effect"]]],[11,"clone","","",78,[[["self"]],["ff_effect"]]],[11,"clone","","",79,[[["self"]],["dl_phdr_info"]]],[11,"clone","","",80,[[["self"]],["elf32_phdr"]]],[11,"clone","","",81,[[["self"]],["elf64_phdr"]]],[11,"clone","","",82,[[["self"]],["ucred"]]],[11,"clone","","",83,[[["self"]],["mntent"]]],[11,"clone","","",84,[[["self"]],["posix_spawn_file_actions_t"]]],[11,"clone","","",85,[[["self"]],["posix_spawnattr_t"]]],[11,"clone","","",86,[[["self"]],["genlmsghdr"]]],[11,"clone","","",87,[[["self"]],["in6_pktinfo"]]],[11,"clone","","",88,[[["self"]],["arpd_request"]]],[6,"sa_family_t","libc::unix::notbsd","",N,N],[6,"pthread_key_t","","",N,N],[6,"speed_t","","",N,N],[6,"tcflag_t","","",N,N],[6,"clockid_t","","",N,N],[6,"key_t","","",N,N],[6,"id_t","","",N,N],[17,"ULONG_SIZE","","",N,N],[17,"EXIT_FAILURE","","",N,N],[17,"EXIT_SUCCESS","","",N,N],[17,"RAND_MAX","","",N,N],[17,"EOF","","",N,N],[17,"SEEK_SET","","",N,N],[17,"SEEK_CUR","","",N,N],[17,"SEEK_END","","",N,N],[17,"_IOFBF","","",N,N],[17,"_IONBF","","",N,N],[17,"_IOLBF","","",N,N],[17,"F_DUPFD","","",N,N],[17,"F_GETFD","","",N,N],[17,"F_SETFD","","",N,N],[17,"F_GETFL","","",N,N],[17,"F_SETFL","","",N,N],[17,"F_SETLEASE","","",N,N],[17,"F_GETLEASE","","",N,N],[17,"F_NOTIFY","","",N,N],[17,"F_CANCELLK","","",N,N],[17,"F_DUPFD_CLOEXEC","","",N,N],[17,"F_SETPIPE_SZ","","",N,N],[17,"F_GETPIPE_SZ","","",N,N],[17,"F_ADD_SEALS","","",N,N],[17,"F_GET_SEALS","","",N,N],[17,"F_SEAL_SEAL","","",N,N],[17,"F_SEAL_SHRINK","","",N,N],[17,"F_SEAL_GROW","","",N,N],[17,"F_SEAL_WRITE","","",N,N],[17,"SIGTRAP","","",N,N],[17,"PTHREAD_CREATE_JOINABLE","","",N,N],[17,"PTHREAD_CREATE_DETACHED","","",N,N],[17,"CLOCK_REALTIME","","",N,N],[17,"CLOCK_MONOTONIC","","",N,N],[17,"CLOCK_PROCESS_CPUTIME_ID","","",N,N],[17,"CLOCK_THREAD_CPUTIME_ID","","",N,N],[17,"CLOCK_MONOTONIC_RAW","","",N,N],[17,"CLOCK_REALTIME_COARSE","","",N,N],[17,"CLOCK_MONOTONIC_COARSE","","",N,N],[17,"CLOCK_BOOTTIME","","",N,N],[17,"CLOCK_REALTIME_ALARM","","",N,N],[17,"CLOCK_BOOTTIME_ALARM","","",N,N],[17,"TIMER_ABSTIME","","",N,N],[17,"RLIMIT_CPU","","",N,N],[17,"RLIMIT_FSIZE","","",N,N],[17,"RLIMIT_DATA","","",N,N],[17,"RLIMIT_STACK","","",N,N],[17,"RLIMIT_CORE","","",N,N],[17,"RLIMIT_LOCKS","","",N,N],[17,"RLIMIT_SIGPENDING","","",N,N],[17,"RLIMIT_MSGQUEUE","","",N,N],[17,"RLIMIT_NICE","","",N,N],[17,"RLIMIT_RTPRIO","","",N,N],[17,"RUSAGE_SELF","","",N,N],[17,"O_RDONLY","","",N,N],[17,"O_WRONLY","","",N,N],[17,"O_RDWR","","",N,N],[17,"SOCK_CLOEXEC","","",N,N],[17,"S_IFIFO","","",N,N],[17,"S_IFCHR","","",N,N],[17,"S_IFBLK","","",N,N],[17,"S_IFDIR","","",N,N],[17,"S_IFREG","","",N,N],[17,"S_IFLNK","","",N,N],[17,"S_IFSOCK","","",N,N],[17,"S_IFMT","","",N,N],[17,"S_IRWXU","","",N,N],[17,"S_IXUSR","","",N,N],[17,"S_IWUSR","","",N,N],[17,"S_IRUSR","","",N,N],[17,"S_IRWXG","","",N,N],[17,"S_IXGRP","","",N,N],[17,"S_IWGRP","","",N,N],[17,"S_IRGRP","","",N,N],[17,"S_IRWXO","","",N,N],[17,"S_IXOTH","","",N,N],[17,"S_IWOTH","","",N,N],[17,"S_IROTH","","",N,N],[17,"F_OK","","",N,N],[17,"R_OK","","",N,N],[17,"W_OK","","",N,N],[17,"X_OK","","",N,N],[17,"STDIN_FILENO","","",N,N],[17,"STDOUT_FILENO","","",N,N],[17,"STDERR_FILENO","","",N,N],[17,"SIGHUP","","",N,N],[17,"SIGINT","","",N,N],[17,"SIGQUIT","","",N,N],[17,"SIGILL","","",N,N],[17,"SIGABRT","","",N,N],[17,"SIGFPE","","",N,N],[17,"SIGKILL","","",N,N],[17,"SIGSEGV","","",N,N],[17,"SIGPIPE","","",N,N],[17,"SIGALRM","","",N,N],[17,"SIGTERM","","",N,N],[17,"PROT_NONE","","",N,N],[17,"PROT_READ","","",N,N],[17,"PROT_WRITE","","",N,N],[17,"PROT_EXEC","","",N,N],[17,"LC_CTYPE","","",N,N],[17,"LC_NUMERIC","","",N,N],[17,"LC_TIME","","",N,N],[17,"LC_COLLATE","","",N,N],[17,"LC_MONETARY","","",N,N],[17,"LC_MESSAGES","","",N,N],[17,"LC_ALL","","",N,N],[17,"LC_CTYPE_MASK","","",N,N],[17,"LC_NUMERIC_MASK","","",N,N],[17,"LC_TIME_MASK","","",N,N],[17,"LC_COLLATE_MASK","","",N,N],[17,"LC_MONETARY_MASK","","",N,N],[17,"LC_MESSAGES_MASK","","",N,N],[17,"MAP_FILE","","",N,N],[17,"MAP_SHARED","","",N,N],[17,"MAP_PRIVATE","","",N,N],[17,"MAP_FIXED","","",N,N],[17,"MAP_FAILED","","",N,N],[17,"MS_ASYNC","","",N,N],[17,"MS_INVALIDATE","","",N,N],[17,"MS_SYNC","","",N,N],[17,"MS_RDONLY","","",N,N],[17,"MS_NOSUID","","",N,N],[17,"MS_NODEV","","",N,N],[17,"MS_NOEXEC","","",N,N],[17,"MS_SYNCHRONOUS","","",N,N],[17,"MS_REMOUNT","","",N,N],[17,"MS_MANDLOCK","","",N,N],[17,"MS_DIRSYNC","","",N,N],[17,"MS_NOATIME","","",N,N],[17,"MS_NODIRATIME","","",N,N],[17,"MS_BIND","","",N,N],[17,"MS_MOVE","","",N,N],[17,"MS_REC","","",N,N],[17,"MS_SILENT","","",N,N],[17,"MS_POSIXACL","","",N,N],[17,"MS_UNBINDABLE","","",N,N],[17,"MS_PRIVATE","","",N,N],[17,"MS_SLAVE","","",N,N],[17,"MS_SHARED","","",N,N],[17,"MS_RELATIME","","",N,N],[17,"MS_KERNMOUNT","","",N,N],[17,"MS_I_VERSION","","",N,N],[17,"MS_STRICTATIME","","",N,N],[17,"MS_ACTIVE","","",N,N],[17,"MS_NOUSER","","",N,N],[17,"MS_MGC_VAL","","",N,N],[17,"MS_MGC_MSK","","",N,N],[17,"MS_RMT_MASK","","",N,N],[17,"EPERM","","",N,N],[17,"ENOENT","","",N,N],[17,"ESRCH","","",N,N],[17,"EINTR","","",N,N],[17,"EIO","","",N,N],[17,"ENXIO","","",N,N],[17,"E2BIG","","",N,N],[17,"ENOEXEC","","",N,N],[17,"EBADF","","",N,N],[17,"ECHILD","","",N,N],[17,"EAGAIN","","",N,N],[17,"ENOMEM","","",N,N],[17,"EACCES","","",N,N],[17,"EFAULT","","",N,N],[17,"ENOTBLK","","",N,N],[17,"EBUSY","","",N,N],[17,"EEXIST","","",N,N],[17,"EXDEV","","",N,N],[17,"ENODEV","","",N,N],[17,"ENOTDIR","","",N,N],[17,"EISDIR","","",N,N],[17,"EINVAL","","",N,N],[17,"ENFILE","","",N,N],[17,"EMFILE","","",N,N],[17,"ENOTTY","","",N,N],[17,"ETXTBSY","","",N,N],[17,"EFBIG","","",N,N],[17,"ENOSPC","","",N,N],[17,"ESPIPE","","",N,N],[17,"EROFS","","",N,N],[17,"EMLINK","","",N,N],[17,"EPIPE","","",N,N],[17,"EDOM","","",N,N],[17,"ERANGE","","",N,N],[17,"EWOULDBLOCK","","",N,N],[17,"SCM_RIGHTS","","",N,N],[17,"SCM_CREDENTIALS","","",N,N],[17,"PROT_GROWSDOWN","","",N,N],[17,"PROT_GROWSUP","","",N,N],[17,"MAP_TYPE","","",N,N],[17,"MADV_NORMAL","","",N,N],[17,"MADV_RANDOM","","",N,N],[17,"MADV_SEQUENTIAL","","",N,N],[17,"MADV_WILLNEED","","",N,N],[17,"MADV_DONTNEED","","",N,N],[17,"MADV_FREE","","",N,N],[17,"MADV_REMOVE","","",N,N],[17,"MADV_DONTFORK","","",N,N],[17,"MADV_DOFORK","","",N,N],[17,"MADV_MERGEABLE","","",N,N],[17,"MADV_UNMERGEABLE","","",N,N],[17,"MADV_HUGEPAGE","","",N,N],[17,"MADV_NOHUGEPAGE","","",N,N],[17,"MADV_DONTDUMP","","",N,N],[17,"MADV_DODUMP","","",N,N],[17,"MADV_HWPOISON","","",N,N],[17,"MADV_SOFT_OFFLINE","","",N,N],[17,"IFF_UP","","",N,N],[17,"IFF_BROADCAST","","",N,N],[17,"IFF_DEBUG","","",N,N],[17,"IFF_LOOPBACK","","",N,N],[17,"IFF_POINTOPOINT","","",N,N],[17,"IFF_NOTRAILERS","","",N,N],[17,"IFF_RUNNING","","",N,N],[17,"IFF_NOARP","","",N,N],[17,"IFF_PROMISC","","",N,N],[17,"IFF_ALLMULTI","","",N,N],[17,"IFF_MASTER","","",N,N],[17,"IFF_SLAVE","","",N,N],[17,"IFF_MULTICAST","","",N,N],[17,"IFF_PORTSEL","","",N,N],[17,"IFF_AUTOMEDIA","","",N,N],[17,"IFF_DYNAMIC","","",N,N],[17,"SOL_IP","","",N,N],[17,"SOL_TCP","","",N,N],[17,"SOL_UDP","","",N,N],[17,"SOL_IPV6","","",N,N],[17,"SOL_ICMPV6","","",N,N],[17,"SOL_RAW","","",N,N],[17,"SOL_DECNET","","",N,N],[17,"SOL_X25","","",N,N],[17,"SOL_PACKET","","",N,N],[17,"SOL_ATM","","",N,N],[17,"SOL_AAL","","",N,N],[17,"SOL_IRDA","","",N,N],[17,"SOL_NETBEUI","","",N,N],[17,"SOL_LLC","","",N,N],[17,"SOL_DCCP","","",N,N],[17,"SOL_NETLINK","","",N,N],[17,"SOL_TIPC","","",N,N],[17,"AF_UNSPEC","","",N,N],[17,"AF_UNIX","","",N,N],[17,"AF_LOCAL","","",N,N],[17,"AF_INET","","",N,N],[17,"AF_AX25","","",N,N],[17,"AF_IPX","","",N,N],[17,"AF_APPLETALK","","",N,N],[17,"AF_NETROM","","",N,N],[17,"AF_BRIDGE","","",N,N],[17,"AF_ATMPVC","","",N,N],[17,"AF_X25","","",N,N],[17,"AF_INET6","","",N,N],[17,"AF_ROSE","","",N,N],[17,"AF_DECnet","","",N,N],[17,"AF_NETBEUI","","",N,N],[17,"AF_SECURITY","","",N,N],[17,"AF_KEY","","",N,N],[17,"AF_NETLINK","","",N,N],[17,"AF_ROUTE","","",N,N],[17,"AF_PACKET","","",N,N],[17,"AF_ASH","","",N,N],[17,"AF_ECONET","","",N,N],[17,"AF_ATMSVC","","",N,N],[17,"AF_RDS","","",N,N],[17,"AF_SNA","","",N,N],[17,"AF_IRDA","","",N,N],[17,"AF_PPPOX","","",N,N],[17,"AF_WANPIPE","","",N,N],[17,"AF_LLC","","",N,N],[17,"AF_CAN","","",N,N],[17,"AF_TIPC","","",N,N],[17,"AF_BLUETOOTH","","",N,N],[17,"AF_IUCV","","",N,N],[17,"AF_RXRPC","","",N,N],[17,"AF_ISDN","","",N,N],[17,"AF_PHONET","","",N,N],[17,"AF_IEEE802154","","",N,N],[17,"AF_CAIF","","",N,N],[17,"AF_ALG","","",N,N],[17,"PF_UNSPEC","","",N,N],[17,"PF_UNIX","","",N,N],[17,"PF_LOCAL","","",N,N],[17,"PF_INET","","",N,N],[17,"PF_AX25","","",N,N],[17,"PF_IPX","","",N,N],[17,"PF_APPLETALK","","",N,N],[17,"PF_NETROM","","",N,N],[17,"PF_BRIDGE","","",N,N],[17,"PF_ATMPVC","","",N,N],[17,"PF_X25","","",N,N],[17,"PF_INET6","","",N,N],[17,"PF_ROSE","","",N,N],[17,"PF_DECnet","","",N,N],[17,"PF_NETBEUI","","",N,N],[17,"PF_SECURITY","","",N,N],[17,"PF_KEY","","",N,N],[17,"PF_NETLINK","","",N,N],[17,"PF_ROUTE","","",N,N],[17,"PF_PACKET","","",N,N],[17,"PF_ASH","","",N,N],[17,"PF_ECONET","","",N,N],[17,"PF_ATMSVC","","",N,N],[17,"PF_RDS","","",N,N],[17,"PF_SNA","","",N,N],[17,"PF_IRDA","","",N,N],[17,"PF_PPPOX","","",N,N],[17,"PF_WANPIPE","","",N,N],[17,"PF_LLC","","",N,N],[17,"PF_CAN","","",N,N],[17,"PF_TIPC","","",N,N],[17,"PF_BLUETOOTH","","",N,N],[17,"PF_IUCV","","",N,N],[17,"PF_RXRPC","","",N,N],[17,"PF_ISDN","","",N,N],[17,"PF_PHONET","","",N,N],[17,"PF_IEEE802154","","",N,N],[17,"PF_CAIF","","",N,N],[17,"PF_ALG","","",N,N],[17,"SOMAXCONN","","",N,N],[17,"MSG_OOB","","",N,N],[17,"MSG_PEEK","","",N,N],[17,"MSG_DONTROUTE","","",N,N],[17,"MSG_CTRUNC","","",N,N],[17,"MSG_TRUNC","","",N,N],[17,"MSG_DONTWAIT","","",N,N],[17,"MSG_EOR","","",N,N],[17,"MSG_WAITALL","","",N,N],[17,"MSG_FIN","","",N,N],[17,"MSG_SYN","","",N,N],[17,"MSG_CONFIRM","","",N,N],[17,"MSG_RST","","",N,N],[17,"MSG_ERRQUEUE","","",N,N],[17,"MSG_NOSIGNAL","","",N,N],[17,"MSG_MORE","","",N,N],[17,"MSG_WAITFORONE","","",N,N],[17,"MSG_FASTOPEN","","",N,N],[17,"MSG_CMSG_CLOEXEC","","",N,N],[17,"SCM_TIMESTAMP","","",N,N],[17,"SOCK_RAW","","",N,N],[17,"SOCK_RDM","","",N,N],[17,"IP_MULTICAST_IF","","",N,N],[17,"IP_MULTICAST_TTL","","",N,N],[17,"IP_MULTICAST_LOOP","","",N,N],[17,"IP_TTL","","",N,N],[17,"IP_HDRINCL","","",N,N],[17,"IP_PKTINFO","","",N,N],[17,"IP_ADD_MEMBERSHIP","","",N,N],[17,"IP_DROP_MEMBERSHIP","","",N,N],[17,"IP_TRANSPARENT","","",N,N],[17,"IPV6_UNICAST_HOPS","","",N,N],[17,"IPV6_MULTICAST_IF","","",N,N],[17,"IPV6_MULTICAST_HOPS","","",N,N],[17,"IPV6_MULTICAST_LOOP","","",N,N],[17,"IPV6_ADD_MEMBERSHIP","","",N,N],[17,"IPV6_DROP_MEMBERSHIP","","",N,N],[17,"IPV6_V6ONLY","","",N,N],[17,"IPV6_RECVPKTINFO","","",N,N],[17,"IPV6_PKTINFO","","",N,N],[17,"TCP_NODELAY","","",N,N],[17,"TCP_MAXSEG","","",N,N],[17,"TCP_CORK","","",N,N],[17,"TCP_KEEPIDLE","","",N,N],[17,"TCP_KEEPINTVL","","",N,N],[17,"TCP_KEEPCNT","","",N,N],[17,"TCP_SYNCNT","","",N,N],[17,"TCP_LINGER2","","",N,N],[17,"TCP_DEFER_ACCEPT","","",N,N],[17,"TCP_WINDOW_CLAMP","","",N,N],[17,"TCP_INFO","","",N,N],[17,"TCP_QUICKACK","","",N,N],[17,"TCP_CONGESTION","","",N,N],[17,"SO_DEBUG","","",N,N],[17,"SHUT_RD","","",N,N],[17,"SHUT_WR","","",N,N],[17,"SHUT_RDWR","","",N,N],[17,"LOCK_SH","","",N,N],[17,"LOCK_EX","","",N,N],[17,"LOCK_NB","","",N,N],[17,"LOCK_UN","","",N,N],[17,"SS_ONSTACK","","",N,N],[17,"SS_DISABLE","","",N,N],[17,"PATH_MAX","","",N,N],[17,"FD_SETSIZE","","",N,N],[17,"EPOLLIN","","",N,N],[17,"EPOLLPRI","","",N,N],[17,"EPOLLOUT","","",N,N],[17,"EPOLLRDNORM","","",N,N],[17,"EPOLLRDBAND","","",N,N],[17,"EPOLLWRNORM","","",N,N],[17,"EPOLLWRBAND","","",N,N],[17,"EPOLLMSG","","",N,N],[17,"EPOLLERR","","",N,N],[17,"EPOLLHUP","","",N,N],[17,"EPOLLET","","",N,N],[17,"EPOLL_CTL_ADD","","",N,N],[17,"EPOLL_CTL_MOD","","",N,N],[17,"EPOLL_CTL_DEL","","",N,N],[17,"MNT_DETACH","","",N,N],[17,"MNT_EXPIRE","","",N,N],[17,"Q_GETFMT","","",N,N],[17,"Q_GETINFO","","",N,N],[17,"Q_SETINFO","","",N,N],[17,"QIF_BLIMITS","","",N,N],[17,"QIF_SPACE","","",N,N],[17,"QIF_ILIMITS","","",N,N],[17,"QIF_INODES","","",N,N],[17,"QIF_BTIME","","",N,N],[17,"QIF_ITIME","","",N,N],[17,"QIF_LIMITS","","",N,N],[17,"QIF_USAGE","","",N,N],[17,"QIF_TIMES","","",N,N],[17,"QIF_ALL","","",N,N],[17,"MNT_FORCE","","",N,N],[17,"Q_SYNC","","",N,N],[17,"Q_QUOTAON","","",N,N],[17,"Q_QUOTAOFF","","",N,N],[17,"Q_GETQUOTA","","",N,N],[17,"Q_SETQUOTA","","",N,N],[17,"TCIOFF","","",N,N],[17,"TCION","","",N,N],[17,"TCOOFF","","",N,N],[17,"TCOON","","",N,N],[17,"TCIFLUSH","","",N,N],[17,"TCOFLUSH","","",N,N],[17,"TCIOFLUSH","","",N,N],[17,"NL0","","",N,N],[17,"NL1","","",N,N],[17,"TAB0","","",N,N],[17,"CR0","","",N,N],[17,"FF0","","",N,N],[17,"BS0","","",N,N],[17,"VT0","","",N,N],[17,"VERASE","","",N,N],[17,"VKILL","","",N,N],[17,"VINTR","","",N,N],[17,"VQUIT","","",N,N],[17,"VLNEXT","","",N,N],[17,"IGNBRK","","",N,N],[17,"BRKINT","","",N,N],[17,"IGNPAR","","",N,N],[17,"PARMRK","","",N,N],[17,"INPCK","","",N,N],[17,"ISTRIP","","",N,N],[17,"INLCR","","",N,N],[17,"IGNCR","","",N,N],[17,"ICRNL","","",N,N],[17,"IXANY","","",N,N],[17,"IMAXBEL","","",N,N],[17,"OPOST","","",N,N],[17,"CS5","","",N,N],[17,"CRTSCTS","","",N,N],[17,"ECHO","","",N,N],[17,"OCRNL","","",N,N],[17,"ONOCR","","",N,N],[17,"ONLRET","","",N,N],[17,"OFILL","","",N,N],[17,"OFDEL","","",N,N],[17,"CLONE_VM","","",N,N],[17,"CLONE_FS","","",N,N],[17,"CLONE_FILES","","",N,N],[17,"CLONE_SIGHAND","","",N,N],[17,"CLONE_PTRACE","","",N,N],[17,"CLONE_VFORK","","",N,N],[17,"CLONE_PARENT","","",N,N],[17,"CLONE_THREAD","","",N,N],[17,"CLONE_NEWNS","","",N,N],[17,"CLONE_SYSVSEM","","",N,N],[17,"CLONE_SETTLS","","",N,N],[17,"CLONE_PARENT_SETTID","","",N,N],[17,"CLONE_CHILD_CLEARTID","","",N,N],[17,"CLONE_DETACHED","","",N,N],[17,"CLONE_UNTRACED","","",N,N],[17,"CLONE_CHILD_SETTID","","",N,N],[17,"CLONE_NEWUTS","","",N,N],[17,"CLONE_NEWIPC","","",N,N],[17,"CLONE_NEWUSER","","",N,N],[17,"CLONE_NEWPID","","",N,N],[17,"CLONE_NEWNET","","",N,N],[17,"CLONE_IO","","",N,N],[17,"CLONE_NEWCGROUP","","",N,N],[17,"WNOHANG","","",N,N],[17,"WUNTRACED","","",N,N],[17,"WSTOPPED","","",N,N],[17,"WEXITED","","",N,N],[17,"WCONTINUED","","",N,N],[17,"WNOWAIT","","",N,N],[17,"PTRACE_O_TRACESYSGOOD","","",N,N],[17,"PTRACE_O_TRACEFORK","","",N,N],[17,"PTRACE_O_TRACEVFORK","","",N,N],[17,"PTRACE_O_TRACECLONE","","",N,N],[17,"PTRACE_O_TRACEEXEC","","",N,N],[17,"PTRACE_O_TRACEVFORKDONE","","",N,N],[17,"PTRACE_O_TRACEEXIT","","",N,N],[17,"PTRACE_O_TRACESECCOMP","","",N,N],[17,"PTRACE_O_EXITKILL","","",N,N],[17,"PTRACE_O_SUSPEND_SECCOMP","","",N,N],[17,"PTRACE_O_MASK","","",N,N],[17,"PTRACE_EVENT_FORK","","",N,N],[17,"PTRACE_EVENT_VFORK","","",N,N],[17,"PTRACE_EVENT_CLONE","","",N,N],[17,"PTRACE_EVENT_EXEC","","",N,N],[17,"PTRACE_EVENT_VFORK_DONE","","",N,N],[17,"PTRACE_EVENT_EXIT","","",N,N],[17,"PTRACE_EVENT_SECCOMP","","",N,N],[17,"__WNOTHREAD","","",N,N],[17,"__WALL","","",N,N],[17,"__WCLONE","","",N,N],[17,"SPLICE_F_MOVE","","",N,N],[17,"SPLICE_F_NONBLOCK","","",N,N],[17,"SPLICE_F_MORE","","",N,N],[17,"SPLICE_F_GIFT","","",N,N],[17,"RTLD_LOCAL","","",N,N],[17,"RTLD_LAZY","","",N,N],[17,"POSIX_FADV_NORMAL","","",N,N],[17,"POSIX_FADV_RANDOM","","",N,N],[17,"POSIX_FADV_SEQUENTIAL","","",N,N],[17,"POSIX_FADV_WILLNEED","","",N,N],[17,"AT_FDCWD","","",N,N],[17,"AT_SYMLINK_NOFOLLOW","","",N,N],[17,"AT_REMOVEDIR","","",N,N],[17,"AT_SYMLINK_FOLLOW","","",N,N],[17,"AT_NO_AUTOMOUNT","","",N,N],[17,"AT_EMPTY_PATH","","",N,N],[17,"LOG_CRON","","",N,N],[17,"LOG_AUTHPRIV","","",N,N],[17,"LOG_FTP","","",N,N],[17,"LOG_PERROR","","",N,N],[17,"PIPE_BUF","","",N,N],[17,"SI_LOAD_SHIFT","","",N,N],[17,"SIGEV_SIGNAL","","",N,N],[17,"SIGEV_NONE","","",N,N],[17,"SIGEV_THREAD","","",N,N],[17,"P_ALL","","",N,N],[17,"P_PID","","",N,N],[17,"P_PGID","","",N,N],[17,"UTIME_OMIT","","",N,N],[17,"UTIME_NOW","","",N,N],[17,"POLLIN","","",N,N],[17,"POLLPRI","","",N,N],[17,"POLLOUT","","",N,N],[17,"POLLERR","","",N,N],[17,"POLLHUP","","",N,N],[17,"POLLNVAL","","",N,N],[17,"POLLRDNORM","","",N,N],[17,"POLLRDBAND","","",N,N],[17,"IPTOS_LOWDELAY","","",N,N],[17,"IPTOS_THROUGHPUT","","",N,N],[17,"IPTOS_RELIABILITY","","",N,N],[17,"IPTOS_MINCOST","","",N,N],[17,"IPTOS_PREC_NETCONTROL","","",N,N],[17,"IPTOS_PREC_INTERNETCONTROL","","",N,N],[17,"IPTOS_PREC_CRITIC_ECP","","",N,N],[17,"IPTOS_PREC_FLASHOVERRIDE","","",N,N],[17,"IPTOS_PREC_FLASH","","",N,N],[17,"IPTOS_PREC_IMMEDIATE","","",N,N],[17,"IPTOS_PREC_PRIORITY","","",N,N],[17,"IPTOS_PREC_ROUTINE","","",N,N],[17,"IPOPT_COPY","","",N,N],[17,"IPOPT_CLASS_MASK","","",N,N],[17,"IPOPT_NUMBER_MASK","","",N,N],[17,"IPOPT_CONTROL","","",N,N],[17,"IPOPT_RESERVED1","","",N,N],[17,"IPOPT_MEASUREMENT","","",N,N],[17,"IPOPT_RESERVED2","","",N,N],[17,"IPOPT_END","","",N,N],[17,"IPOPT_NOOP","","",N,N],[17,"IPOPT_SEC","","",N,N],[17,"IPOPT_LSRR","","",N,N],[17,"IPOPT_TIMESTAMP","","",N,N],[17,"IPOPT_RR","","",N,N],[17,"IPOPT_SID","","",N,N],[17,"IPOPT_SSRR","","",N,N],[17,"IPOPT_RA","","",N,N],[17,"IPVERSION","","",N,N],[17,"MAXTTL","","",N,N],[17,"IPDEFTTL","","",N,N],[17,"IPOPT_OPTVAL","","",N,N],[17,"IPOPT_OLEN","","",N,N],[17,"IPOPT_OFFSET","","",N,N],[17,"IPOPT_MINOFF","","",N,N],[17,"MAX_IPOPTLEN","","",N,N],[17,"IPOPT_NOP","","",N,N],[17,"IPOPT_EOL","","",N,N],[17,"IPOPT_TS","","",N,N],[17,"IPOPT_TS_TSONLY","","",N,N],[17,"IPOPT_TS_TSANDADDR","","",N,N],[17,"IPOPT_TS_PRESPEC","","",N,N],[17,"ARPOP_RREQUEST","","",N,N],[17,"ARPOP_RREPLY","","",N,N],[17,"ARPOP_InREQUEST","","",N,N],[17,"ARPOP_InREPLY","","",N,N],[17,"ARPOP_NAK","","",N,N],[17,"ATF_NETMASK","","",N,N],[17,"ATF_DONTPUB","","",N,N],[17,"ARPHRD_NETROM","","",N,N],[17,"ARPHRD_ETHER","","",N,N],[17,"ARPHRD_EETHER","","",N,N],[17,"ARPHRD_AX25","","",N,N],[17,"ARPHRD_PRONET","","",N,N],[17,"ARPHRD_CHAOS","","",N,N],[17,"ARPHRD_IEEE802","","",N,N],[17,"ARPHRD_ARCNET","","",N,N],[17,"ARPHRD_APPLETLK","","",N,N],[17,"ARPHRD_DLCI","","",N,N],[17,"ARPHRD_ATM","","",N,N],[17,"ARPHRD_METRICOM","","",N,N],[17,"ARPHRD_IEEE1394","","",N,N],[17,"ARPHRD_EUI64","","",N,N],[17,"ARPHRD_INFINIBAND","","",N,N],[17,"ARPHRD_SLIP","","",N,N],[17,"ARPHRD_CSLIP","","",N,N],[17,"ARPHRD_SLIP6","","",N,N],[17,"ARPHRD_CSLIP6","","",N,N],[17,"ARPHRD_RSRVD","","",N,N],[17,"ARPHRD_ADAPT","","",N,N],[17,"ARPHRD_ROSE","","",N,N],[17,"ARPHRD_X25","","",N,N],[17,"ARPHRD_HWX25","","",N,N],[17,"ARPHRD_PPP","","",N,N],[17,"ARPHRD_CISCO","","",N,N],[17,"ARPHRD_HDLC","","",N,N],[17,"ARPHRD_LAPB","","",N,N],[17,"ARPHRD_DDCMP","","",N,N],[17,"ARPHRD_RAWHDLC","","",N,N],[17,"ARPHRD_TUNNEL","","",N,N],[17,"ARPHRD_TUNNEL6","","",N,N],[17,"ARPHRD_FRAD","","",N,N],[17,"ARPHRD_SKIP","","",N,N],[17,"ARPHRD_LOOPBACK","","",N,N],[17,"ARPHRD_LOCALTLK","","",N,N],[17,"ARPHRD_FDDI","","",N,N],[17,"ARPHRD_BIF","","",N,N],[17,"ARPHRD_SIT","","",N,N],[17,"ARPHRD_IPDDP","","",N,N],[17,"ARPHRD_IPGRE","","",N,N],[17,"ARPHRD_PIMREG","","",N,N],[17,"ARPHRD_HIPPI","","",N,N],[17,"ARPHRD_ASH","","",N,N],[17,"ARPHRD_ECONET","","",N,N],[17,"ARPHRD_IRDA","","",N,N],[17,"ARPHRD_FCPP","","",N,N],[17,"ARPHRD_FCAL","","",N,N],[17,"ARPHRD_FCPL","","",N,N],[17,"ARPHRD_FCFABRIC","","",N,N],[17,"ARPHRD_IEEE802_TR","","",N,N],[17,"ARPHRD_IEEE80211","","",N,N],[17,"ARPHRD_IEEE80211_PRISM","","",N,N],[17,"ARPHRD_IEEE80211_RADIOTAP","","",N,N],[17,"ARPHRD_IEEE802154","","",N,N],[17,"ARPHRD_VOID","","",N,N],[17,"ARPHRD_NONE","","",N,N],[11,"clone","libc","",20,[[["self"]],["sockaddr"]]],[11,"clone","","",21,[[["self"]],["sockaddr_in"]]],[11,"clone","","",22,[[["self"]],["sockaddr_in6"]]],[11,"clone","","",23,[[["self"]],["sockaddr_un"]]],[11,"clone","","",24,[[["self"]],["sockaddr_storage"]]],[11,"clone","","",25,[[["self"]],["addrinfo"]]],[11,"clone","","",26,[[["self"]],["sockaddr_nl"]]],[11,"clone","","",27,[[["self"]],["sockaddr_ll"]]],[11,"clone","","",28,[[["self"]],["fd_set"]]],[11,"clone","","",29,[[["self"]],["tm"]]],[11,"clone","","",30,[[["self"]],["sched_param"]]],[11,"clone","","",31,[[["self"]],["dl_info"]]],[11,"clone","","",32,[[["self"]],["epoll_event"]]],[11,"clone","","",33,[[["self"]],["utsname"]]],[11,"clone","","",34,[[["self"]],["lconv"]]],[11,"clone","","",35,[[["self"]],["sigevent"]]],[11,"clone","","",36,[[["self"]],["in_pktinfo"]]],[11,"clone","","",37,[[["self"]],["ifaddrs"]]],[11,"clone","","",38,[[["self"]],["in6_rtmsg"]]],[11,"clone","","",39,[[["self"]],["arpreq"]]],[11,"clone","","",40,[[["self"]],["arpreq_old"]]],[11,"clone","","",41,[[["self"]],["arphdr"]]],[6,"pid_t","libc::unix","",N,N],[6,"uid_t","","",N,N],[6,"gid_t","","",N,N],[6,"in_addr_t","","",N,N],[6,"in_port_t","","",N,N],[6,"sighandler_t","","",N,N],[6,"cc_t","","",N,N],[17,"SIG_DFL","","",N,N],[17,"SIG_IGN","","",N,N],[17,"SIG_ERR","","",N,N],[17,"DT_UNKNOWN","","",N,N],[17,"DT_FIFO","","",N,N],[17,"DT_CHR","","",N,N],[17,"DT_DIR","","",N,N],[17,"DT_BLK","","",N,N],[17,"DT_REG","","",N,N],[17,"DT_LNK","","",N,N],[17,"DT_SOCK","","",N,N],[17,"FD_CLOEXEC","","",N,N],[17,"USRQUOTA","","",N,N],[17,"GRPQUOTA","","",N,N],[17,"SIGIOT","","",N,N],[17,"S_ISUID","","",N,N],[17,"S_ISGID","","",N,N],[17,"S_ISVTX","","",N,N],[17,"IF_NAMESIZE","","",N,N],[17,"IFNAMSIZ","","",N,N],[17,"LOG_EMERG","","",N,N],[17,"LOG_ALERT","","",N,N],[17,"LOG_CRIT","","",N,N],[17,"LOG_ERR","","",N,N],[17,"LOG_WARNING","","",N,N],[17,"LOG_NOTICE","","",N,N],[17,"LOG_INFO","","",N,N],[17,"LOG_DEBUG","","",N,N],[17,"LOG_KERN","","",N,N],[17,"LOG_USER","","",N,N],[17,"LOG_MAIL","","",N,N],[17,"LOG_DAEMON","","",N,N],[17,"LOG_AUTH","","",N,N],[17,"LOG_SYSLOG","","",N,N],[17,"LOG_LPR","","",N,N],[17,"LOG_NEWS","","",N,N],[17,"LOG_UUCP","","",N,N],[17,"LOG_LOCAL0","","",N,N],[17,"LOG_LOCAL1","","",N,N],[17,"LOG_LOCAL2","","",N,N],[17,"LOG_LOCAL3","","",N,N],[17,"LOG_LOCAL4","","",N,N],[17,"LOG_LOCAL5","","",N,N],[17,"LOG_LOCAL6","","",N,N],[17,"LOG_LOCAL7","","",N,N],[17,"LOG_PID","","",N,N],[17,"LOG_CONS","","",N,N],[17,"LOG_ODELAY","","",N,N],[17,"LOG_NDELAY","","",N,N],[17,"LOG_NOWAIT","","",N,N],[17,"LOG_PRIMASK","","",N,N],[17,"LOG_FACMASK","","",N,N],[17,"PRIO_PROCESS","","",N,N],[17,"PRIO_PGRP","","",N,N],[17,"PRIO_USER","","",N,N],[17,"PRIO_MIN","","",N,N],[17,"PRIO_MAX","","",N,N],[17,"IPPROTO_ICMP","","",N,N],[17,"IPPROTO_ICMPV6","","",N,N],[17,"IPPROTO_TCP","","",N,N],[17,"IPPROTO_UDP","","",N,N],[17,"IPPROTO_IP","","",N,N],[17,"IPPROTO_IPV6","","",N,N],[17,"INADDR_LOOPBACK","","",N,N],[17,"INADDR_ANY","","",N,N],[17,"INADDR_BROADCAST","","",N,N],[17,"INADDR_NONE","","",N,N],[17,"ARPOP_REQUEST","","",N,N],[17,"ARPOP_REPLY","","",N,N],[17,"ATF_COM","","",N,N],[17,"ATF_PERM","","",N,N],[17,"ATF_PUBL","","",N,N],[17,"ATF_USETRAILERS","","",N,N],[11,"clone","libc","",0,[[["self"]],["group"]]],[11,"clone","","",1,[[["self"]],["utimbuf"]]],[11,"clone","","",2,[[["self"]],["timeval"]]],[11,"clone","","",3,[[["self"]],["timespec"]]],[11,"clone","","",4,[[["self"]],["rlimit"]]],[11,"clone","","",5,[[["self"]],["rusage"]]],[11,"clone","","",6,[[["self"]],["in_addr"]]],[11,"clone","","",7,[[["self"]],["in6_addr"]]],[11,"clone","","",8,[[["self"]],["ip_mreq"]]],[11,"clone","","",9,[[["self"]],["ipv6_mreq"]]],[11,"clone","","",10,[[["self"]],["hostent"]]],[11,"clone","","",11,[[["self"]],["iovec"]]],[11,"clone","","",12,[[["self"]],["pollfd"]]],[11,"clone","","",13,[[["self"]],["winsize"]]],[11,"clone","","",14,[[["self"]],["linger"]]],[11,"clone","","",15,[[["self"]],["sigval"]]],[11,"clone","","",16,[[["self"]],["itimerval"]]],[11,"clone","","",17,[[["self"]],["tms"]]],[11,"clone","","",18,[[["self"]],["servent"]]],[11,"clone","","",19,[[["self"]],["protoent"]]],[6,"int8_t","","",N,N],[6,"int16_t","","",N,N],[6,"int32_t","","",N,N],[6,"int64_t","","",N,N],[6,"uint8_t","","",N,N],[6,"uint16_t","","",N,N],[6,"uint32_t","","",N,N],[6,"uint64_t","","",N,N],[6,"c_schar","","",N,N],[6,"c_uchar","","",N,N],[6,"c_short","","",N,N],[6,"c_ushort","","",N,N],[6,"c_int","","",N,N],[6,"c_uint","","",N,N],[6,"c_float","","",N,N],[6,"c_double","","",N,N],[6,"c_longlong","","",N,N],[6,"c_ulonglong","","",N,N],[6,"intmax_t","","",N,N],[6,"uintmax_t","","",N,N],[6,"size_t","","",N,N],[6,"ptrdiff_t","","",N,N],[6,"intptr_t","","",N,N],[6,"uintptr_t","","",N,N],[6,"ssize_t","","",N,N],[6,"pid_t","","",N,N],[6,"uid_t","","",N,N],[6,"gid_t","","",N,N],[6,"in_addr_t","","",N,N],[6,"in_port_t","","",N,N],[6,"sighandler_t","","",N,N],[6,"cc_t","","",N,N],[6,"sa_family_t","","",N,N],[6,"pthread_key_t","","",N,N],[6,"speed_t","","",N,N],[6,"tcflag_t","","",N,N],[6,"clockid_t","","",N,N],[6,"key_t","","",N,N],[6,"id_t","","",N,N],[6,"useconds_t","","",N,N],[6,"dev_t","","",N,N],[6,"socklen_t","","",N,N],[6,"pthread_t","","",N,N],[6,"mode_t","","",N,N],[6,"ino64_t","","",N,N],[6,"off64_t","","",N,N],[6,"blkcnt64_t","","",N,N],[6,"rlim64_t","","",N,N],[6,"mqd_t","","",N,N],[6,"nfds_t","","",N,N],[6,"nl_item","","",N,N],[6,"idtype_t","","",N,N],[6,"loff_t","","",N,N],[6,"__u8","","",N,N],[6,"__u16","","",N,N],[6,"__s16","","",N,N],[6,"__u32","","",N,N],[6,"__s32","","",N,N],[6,"Elf32_Half","","",N,N],[6,"Elf32_Word","","",N,N],[6,"Elf32_Off","","",N,N],[6,"Elf32_Addr","","",N,N],[6,"Elf64_Half","","",N,N],[6,"Elf64_Word","","",N,N],[6,"Elf64_Off","","",N,N],[6,"Elf64_Addr","","",N,N],[6,"Elf64_Xword","","",N,N],[6,"__priority_which_t","","",N,N],[6,"clock_t","","",N,N],[6,"time_t","","",N,N],[6,"ino_t","","",N,N],[6,"off_t","","",N,N],[6,"blkcnt_t","","",N,N],[6,"__fsword_t","","",N,N],[6,"shmatt_t","","",N,N],[6,"msgqnum_t","","",N,N],[6,"msglen_t","","",N,N],[6,"fsblkcnt_t","","",N,N],[6,"fsfilcnt_t","","",N,N],[6,"rlim_t","","",N,N],[6,"c_char","","",N,N],[6,"wchar_t","","",N,N],[6,"nlink_t","","",N,N],[6,"blksize_t","","",N,N],[6,"greg_t","","",N,N],[6,"suseconds_t","","",N,N],[6,"__u64","","",N,N],[6,"c_long","","",N,N],[6,"c_ulong","","",N,N],[17,"INT_MIN","","",N,N],[17,"INT_MAX","","",N,N],[17,"SIG_DFL","","",N,N],[17,"SIG_IGN","","",N,N],[17,"SIG_ERR","","",N,N],[17,"DT_UNKNOWN","","",N,N],[17,"DT_FIFO","","",N,N],[17,"DT_CHR","","",N,N],[17,"DT_DIR","","",N,N],[17,"DT_BLK","","",N,N],[17,"DT_REG","","",N,N],[17,"DT_LNK","","",N,N],[17,"DT_SOCK","","",N,N],[17,"FD_CLOEXEC","","",N,N],[17,"USRQUOTA","","",N,N],[17,"GRPQUOTA","","",N,N],[17,"SIGIOT","","",N,N],[17,"S_ISUID","","",N,N],[17,"S_ISGID","","",N,N],[17,"S_ISVTX","","",N,N],[17,"IF_NAMESIZE","","",N,N],[17,"IFNAMSIZ","","",N,N],[17,"LOG_EMERG","","",N,N],[17,"LOG_ALERT","","",N,N],[17,"LOG_CRIT","","",N,N],[17,"LOG_ERR","","",N,N],[17,"LOG_WARNING","","",N,N],[17,"LOG_NOTICE","","",N,N],[17,"LOG_INFO","","",N,N],[17,"LOG_DEBUG","","",N,N],[17,"LOG_KERN","","",N,N],[17,"LOG_USER","","",N,N],[17,"LOG_MAIL","","",N,N],[17,"LOG_DAEMON","","",N,N],[17,"LOG_AUTH","","",N,N],[17,"LOG_SYSLOG","","",N,N],[17,"LOG_LPR","","",N,N],[17,"LOG_NEWS","","",N,N],[17,"LOG_UUCP","","",N,N],[17,"LOG_LOCAL0","","",N,N],[17,"LOG_LOCAL1","","",N,N],[17,"LOG_LOCAL2","","",N,N],[17,"LOG_LOCAL3","","",N,N],[17,"LOG_LOCAL4","","",N,N],[17,"LOG_LOCAL5","","",N,N],[17,"LOG_LOCAL6","","",N,N],[17,"LOG_LOCAL7","","",N,N],[17,"LOG_PID","","",N,N],[17,"LOG_CONS","","",N,N],[17,"LOG_ODELAY","","",N,N],[17,"LOG_NDELAY","","",N,N],[17,"LOG_NOWAIT","","",N,N],[17,"LOG_PRIMASK","","",N,N],[17,"LOG_FACMASK","","",N,N],[17,"PRIO_PROCESS","","",N,N],[17,"PRIO_PGRP","","",N,N],[17,"PRIO_USER","","",N,N],[17,"PRIO_MIN","","",N,N],[17,"PRIO_MAX","","",N,N],[17,"IPPROTO_ICMP","","",N,N],[17,"IPPROTO_ICMPV6","","",N,N],[17,"IPPROTO_TCP","","",N,N],[17,"IPPROTO_UDP","","",N,N],[17,"IPPROTO_IP","","",N,N],[17,"IPPROTO_IPV6","","",N,N],[17,"INADDR_LOOPBACK","","",N,N],[17,"INADDR_ANY","","",N,N],[17,"INADDR_BROADCAST","","",N,N],[17,"INADDR_NONE","","",N,N],[17,"ARPOP_REQUEST","","",N,N],[17,"ARPOP_REPLY","","",N,N],[17,"ATF_COM","","",N,N],[17,"ATF_PERM","","",N,N],[17,"ATF_PUBL","","",N,N],[17,"ATF_USETRAILERS","","",N,N],[17,"EXIT_FAILURE","","",N,N],[17,"EXIT_SUCCESS","","",N,N],[17,"RAND_MAX","","",N,N],[17,"EOF","","",N,N],[17,"SEEK_SET","","",N,N],[17,"SEEK_CUR","","",N,N],[17,"SEEK_END","","",N,N],[17,"_IOFBF","","",N,N],[17,"_IONBF","","",N,N],[17,"_IOLBF","","",N,N],[17,"F_DUPFD","","",N,N],[17,"F_GETFD","","",N,N],[17,"F_SETFD","","",N,N],[17,"F_GETFL","","",N,N],[17,"F_SETFL","","",N,N],[17,"F_SETLEASE","","",N,N],[17,"F_GETLEASE","","",N,N],[17,"F_NOTIFY","","",N,N],[17,"F_CANCELLK","","",N,N],[17,"F_DUPFD_CLOEXEC","","",N,N],[17,"F_SETPIPE_SZ","","",N,N],[17,"F_GETPIPE_SZ","","",N,N],[17,"F_ADD_SEALS","","",N,N],[17,"F_GET_SEALS","","",N,N],[17,"F_SEAL_SEAL","","",N,N],[17,"F_SEAL_SHRINK","","",N,N],[17,"F_SEAL_GROW","","",N,N],[17,"F_SEAL_WRITE","","",N,N],[17,"SIGTRAP","","",N,N],[17,"PTHREAD_CREATE_JOINABLE","","",N,N],[17,"PTHREAD_CREATE_DETACHED","","",N,N],[17,"CLOCK_REALTIME","","",N,N],[17,"CLOCK_MONOTONIC","","",N,N],[17,"CLOCK_PROCESS_CPUTIME_ID","","",N,N],[17,"CLOCK_THREAD_CPUTIME_ID","","",N,N],[17,"CLOCK_MONOTONIC_RAW","","",N,N],[17,"CLOCK_REALTIME_COARSE","","",N,N],[17,"CLOCK_MONOTONIC_COARSE","","",N,N],[17,"CLOCK_BOOTTIME","","",N,N],[17,"CLOCK_REALTIME_ALARM","","",N,N],[17,"CLOCK_BOOTTIME_ALARM","","",N,N],[17,"TIMER_ABSTIME","","",N,N],[17,"RLIMIT_CPU","","",N,N],[17,"RLIMIT_FSIZE","","",N,N],[17,"RLIMIT_DATA","","",N,N],[17,"RLIMIT_STACK","","",N,N],[17,"RLIMIT_CORE","","",N,N],[17,"RLIMIT_LOCKS","","",N,N],[17,"RLIMIT_SIGPENDING","","",N,N],[17,"RLIMIT_MSGQUEUE","","",N,N],[17,"RLIMIT_NICE","","",N,N],[17,"RLIMIT_RTPRIO","","",N,N],[17,"RUSAGE_SELF","","",N,N],[17,"O_RDONLY","","",N,N],[17,"O_WRONLY","","",N,N],[17,"O_RDWR","","",N,N],[17,"SOCK_CLOEXEC","","",N,N],[17,"S_IFIFO","","",N,N],[17,"S_IFCHR","","",N,N],[17,"S_IFBLK","","",N,N],[17,"S_IFDIR","","",N,N],[17,"S_IFREG","","",N,N],[17,"S_IFLNK","","",N,N],[17,"S_IFSOCK","","",N,N],[17,"S_IFMT","","",N,N],[17,"S_IRWXU","","",N,N],[17,"S_IXUSR","","",N,N],[17,"S_IWUSR","","",N,N],[17,"S_IRUSR","","",N,N],[17,"S_IRWXG","","",N,N],[17,"S_IXGRP","","",N,N],[17,"S_IWGRP","","",N,N],[17,"S_IRGRP","","",N,N],[17,"S_IRWXO","","",N,N],[17,"S_IXOTH","","",N,N],[17,"S_IWOTH","","",N,N],[17,"S_IROTH","","",N,N],[17,"F_OK","","",N,N],[17,"R_OK","","",N,N],[17,"W_OK","","",N,N],[17,"X_OK","","",N,N],[17,"STDIN_FILENO","","",N,N],[17,"STDOUT_FILENO","","",N,N],[17,"STDERR_FILENO","","",N,N],[17,"SIGHUP","","",N,N],[17,"SIGINT","","",N,N],[17,"SIGQUIT","","",N,N],[17,"SIGILL","","",N,N],[17,"SIGABRT","","",N,N],[17,"SIGFPE","","",N,N],[17,"SIGKILL","","",N,N],[17,"SIGSEGV","","",N,N],[17,"SIGPIPE","","",N,N],[17,"SIGALRM","","",N,N],[17,"SIGTERM","","",N,N],[17,"PROT_NONE","","",N,N],[17,"PROT_READ","","",N,N],[17,"PROT_WRITE","","",N,N],[17,"PROT_EXEC","","",N,N],[17,"LC_CTYPE","","",N,N],[17,"LC_NUMERIC","","",N,N],[17,"LC_TIME","","",N,N],[17,"LC_COLLATE","","",N,N],[17,"LC_MONETARY","","",N,N],[17,"LC_MESSAGES","","",N,N],[17,"LC_ALL","","",N,N],[17,"LC_CTYPE_MASK","","",N,N],[17,"LC_NUMERIC_MASK","","",N,N],[17,"LC_TIME_MASK","","",N,N],[17,"LC_COLLATE_MASK","","",N,N],[17,"LC_MONETARY_MASK","","",N,N],[17,"LC_MESSAGES_MASK","","",N,N],[17,"MAP_FILE","","",N,N],[17,"MAP_SHARED","","",N,N],[17,"MAP_PRIVATE","","",N,N],[17,"MAP_FIXED","","",N,N],[17,"MAP_FAILED","","",N,N],[17,"MS_ASYNC","","",N,N],[17,"MS_INVALIDATE","","",N,N],[17,"MS_SYNC","","",N,N],[17,"MS_RDONLY","","",N,N],[17,"MS_NOSUID","","",N,N],[17,"MS_NODEV","","",N,N],[17,"MS_NOEXEC","","",N,N],[17,"MS_SYNCHRONOUS","","",N,N],[17,"MS_REMOUNT","","",N,N],[17,"MS_MANDLOCK","","",N,N],[17,"MS_DIRSYNC","","",N,N],[17,"MS_NOATIME","","",N,N],[17,"MS_NODIRATIME","","",N,N],[17,"MS_BIND","","",N,N],[17,"MS_MOVE","","",N,N],[17,"MS_REC","","",N,N],[17,"MS_SILENT","","",N,N],[17,"MS_POSIXACL","","",N,N],[17,"MS_UNBINDABLE","","",N,N],[17,"MS_PRIVATE","","",N,N],[17,"MS_SLAVE","","",N,N],[17,"MS_SHARED","","",N,N],[17,"MS_RELATIME","","",N,N],[17,"MS_KERNMOUNT","","",N,N],[17,"MS_I_VERSION","","",N,N],[17,"MS_STRICTATIME","","",N,N],[17,"MS_ACTIVE","","",N,N],[17,"MS_NOUSER","","",N,N],[17,"MS_MGC_VAL","","",N,N],[17,"MS_MGC_MSK","","",N,N],[17,"MS_RMT_MASK","","",N,N],[17,"EPERM","","",N,N],[17,"ENOENT","","",N,N],[17,"ESRCH","","",N,N],[17,"EINTR","","",N,N],[17,"EIO","","",N,N],[17,"ENXIO","","",N,N],[17,"E2BIG","","",N,N],[17,"ENOEXEC","","",N,N],[17,"EBADF","","",N,N],[17,"ECHILD","","",N,N],[17,"EAGAIN","","",N,N],[17,"ENOMEM","","",N,N],[17,"EACCES","","",N,N],[17,"EFAULT","","",N,N],[17,"ENOTBLK","","",N,N],[17,"EBUSY","","",N,N],[17,"EEXIST","","",N,N],[17,"EXDEV","","",N,N],[17,"ENODEV","","",N,N],[17,"ENOTDIR","","",N,N],[17,"EISDIR","","",N,N],[17,"EINVAL","","",N,N],[17,"ENFILE","","",N,N],[17,"EMFILE","","",N,N],[17,"ENOTTY","","",N,N],[17,"ETXTBSY","","",N,N],[17,"EFBIG","","",N,N],[17,"ENOSPC","","",N,N],[17,"ESPIPE","","",N,N],[17,"EROFS","","",N,N],[17,"EMLINK","","",N,N],[17,"EPIPE","","",N,N],[17,"EDOM","","",N,N],[17,"ERANGE","","",N,N],[17,"EWOULDBLOCK","","",N,N],[17,"SCM_RIGHTS","","",N,N],[17,"SCM_CREDENTIALS","","",N,N],[17,"PROT_GROWSDOWN","","",N,N],[17,"PROT_GROWSUP","","",N,N],[17,"MAP_TYPE","","",N,N],[17,"MADV_NORMAL","","",N,N],[17,"MADV_RANDOM","","",N,N],[17,"MADV_SEQUENTIAL","","",N,N],[17,"MADV_WILLNEED","","",N,N],[17,"MADV_DONTNEED","","",N,N],[17,"MADV_FREE","","",N,N],[17,"MADV_REMOVE","","",N,N],[17,"MADV_DONTFORK","","",N,N],[17,"MADV_DOFORK","","",N,N],[17,"MADV_MERGEABLE","","",N,N],[17,"MADV_UNMERGEABLE","","",N,N],[17,"MADV_HUGEPAGE","","",N,N],[17,"MADV_NOHUGEPAGE","","",N,N],[17,"MADV_DONTDUMP","","",N,N],[17,"MADV_DODUMP","","",N,N],[17,"MADV_HWPOISON","","",N,N],[17,"MADV_SOFT_OFFLINE","","",N,N],[17,"IFF_UP","","",N,N],[17,"IFF_BROADCAST","","",N,N],[17,"IFF_DEBUG","","",N,N],[17,"IFF_LOOPBACK","","",N,N],[17,"IFF_POINTOPOINT","","",N,N],[17,"IFF_NOTRAILERS","","",N,N],[17,"IFF_RUNNING","","",N,N],[17,"IFF_NOARP","","",N,N],[17,"IFF_PROMISC","","",N,N],[17,"IFF_ALLMULTI","","",N,N],[17,"IFF_MASTER","","",N,N],[17,"IFF_SLAVE","","",N,N],[17,"IFF_MULTICAST","","",N,N],[17,"IFF_PORTSEL","","",N,N],[17,"IFF_AUTOMEDIA","","",N,N],[17,"IFF_DYNAMIC","","",N,N],[17,"SOL_IP","","",N,N],[17,"SOL_TCP","","",N,N],[17,"SOL_UDP","","",N,N],[17,"SOL_IPV6","","",N,N],[17,"SOL_ICMPV6","","",N,N],[17,"SOL_RAW","","",N,N],[17,"SOL_DECNET","","",N,N],[17,"SOL_X25","","",N,N],[17,"SOL_PACKET","","",N,N],[17,"SOL_ATM","","",N,N],[17,"SOL_AAL","","",N,N],[17,"SOL_IRDA","","",N,N],[17,"SOL_NETBEUI","","",N,N],[17,"SOL_LLC","","",N,N],[17,"SOL_DCCP","","",N,N],[17,"SOL_NETLINK","","",N,N],[17,"SOL_TIPC","","",N,N],[17,"AF_UNSPEC","","",N,N],[17,"AF_UNIX","","",N,N],[17,"AF_LOCAL","","",N,N],[17,"AF_INET","","",N,N],[17,"AF_AX25","","",N,N],[17,"AF_IPX","","",N,N],[17,"AF_APPLETALK","","",N,N],[17,"AF_NETROM","","",N,N],[17,"AF_BRIDGE","","",N,N],[17,"AF_ATMPVC","","",N,N],[17,"AF_X25","","",N,N],[17,"AF_INET6","","",N,N],[17,"AF_ROSE","","",N,N],[17,"AF_DECnet","","",N,N],[17,"AF_NETBEUI","","",N,N],[17,"AF_SECURITY","","",N,N],[17,"AF_KEY","","",N,N],[17,"AF_NETLINK","","",N,N],[17,"AF_ROUTE","","",N,N],[17,"AF_PACKET","","",N,N],[17,"AF_ASH","","",N,N],[17,"AF_ECONET","","",N,N],[17,"AF_ATMSVC","","",N,N],[17,"AF_RDS","","",N,N],[17,"AF_SNA","","",N,N],[17,"AF_IRDA","","",N,N],[17,"AF_PPPOX","","",N,N],[17,"AF_WANPIPE","","",N,N],[17,"AF_LLC","","",N,N],[17,"AF_CAN","","",N,N],[17,"AF_TIPC","","",N,N],[17,"AF_BLUETOOTH","","",N,N],[17,"AF_IUCV","","",N,N],[17,"AF_RXRPC","","",N,N],[17,"AF_ISDN","","",N,N],[17,"AF_PHONET","","",N,N],[17,"AF_IEEE802154","","",N,N],[17,"AF_CAIF","","",N,N],[17,"AF_ALG","","",N,N],[17,"PF_UNSPEC","","",N,N],[17,"PF_UNIX","","",N,N],[17,"PF_LOCAL","","",N,N],[17,"PF_INET","","",N,N],[17,"PF_AX25","","",N,N],[17,"PF_IPX","","",N,N],[17,"PF_APPLETALK","","",N,N],[17,"PF_NETROM","","",N,N],[17,"PF_BRIDGE","","",N,N],[17,"PF_ATMPVC","","",N,N],[17,"PF_X25","","",N,N],[17,"PF_INET6","","",N,N],[17,"PF_ROSE","","",N,N],[17,"PF_DECnet","","",N,N],[17,"PF_NETBEUI","","",N,N],[17,"PF_SECURITY","","",N,N],[17,"PF_KEY","","",N,N],[17,"PF_NETLINK","","",N,N],[17,"PF_ROUTE","","",N,N],[17,"PF_PACKET","","",N,N],[17,"PF_ASH","","",N,N],[17,"PF_ECONET","","",N,N],[17,"PF_ATMSVC","","",N,N],[17,"PF_RDS","","",N,N],[17,"PF_SNA","","",N,N],[17,"PF_IRDA","","",N,N],[17,"PF_PPPOX","","",N,N],[17,"PF_WANPIPE","","",N,N],[17,"PF_LLC","","",N,N],[17,"PF_CAN","","",N,N],[17,"PF_TIPC","","",N,N],[17,"PF_BLUETOOTH","","",N,N],[17,"PF_IUCV","","",N,N],[17,"PF_RXRPC","","",N,N],[17,"PF_ISDN","","",N,N],[17,"PF_PHONET","","",N,N],[17,"PF_IEEE802154","","",N,N],[17,"PF_CAIF","","",N,N],[17,"PF_ALG","","",N,N],[17,"SOMAXCONN","","",N,N],[17,"MSG_OOB","","",N,N],[17,"MSG_PEEK","","",N,N],[17,"MSG_DONTROUTE","","",N,N],[17,"MSG_CTRUNC","","",N,N],[17,"MSG_TRUNC","","",N,N],[17,"MSG_DONTWAIT","","",N,N],[17,"MSG_EOR","","",N,N],[17,"MSG_WAITALL","","",N,N],[17,"MSG_FIN","","",N,N],[17,"MSG_SYN","","",N,N],[17,"MSG_CONFIRM","","",N,N],[17,"MSG_RST","","",N,N],[17,"MSG_ERRQUEUE","","",N,N],[17,"MSG_NOSIGNAL","","",N,N],[17,"MSG_MORE","","",N,N],[17,"MSG_WAITFORONE","","",N,N],[17,"MSG_FASTOPEN","","",N,N],[17,"MSG_CMSG_CLOEXEC","","",N,N],[17,"SCM_TIMESTAMP","","",N,N],[17,"SOCK_RAW","","",N,N],[17,"SOCK_RDM","","",N,N],[17,"IP_MULTICAST_IF","","",N,N],[17,"IP_MULTICAST_TTL","","",N,N],[17,"IP_MULTICAST_LOOP","","",N,N],[17,"IP_TTL","","",N,N],[17,"IP_HDRINCL","","",N,N],[17,"IP_PKTINFO","","",N,N],[17,"IP_ADD_MEMBERSHIP","","",N,N],[17,"IP_DROP_MEMBERSHIP","","",N,N],[17,"IP_TRANSPARENT","","",N,N],[17,"IPV6_UNICAST_HOPS","","",N,N],[17,"IPV6_MULTICAST_IF","","",N,N],[17,"IPV6_MULTICAST_HOPS","","",N,N],[17,"IPV6_MULTICAST_LOOP","","",N,N],[17,"IPV6_ADD_MEMBERSHIP","","",N,N],[17,"IPV6_DROP_MEMBERSHIP","","",N,N],[17,"IPV6_V6ONLY","","",N,N],[17,"IPV6_RECVPKTINFO","","",N,N],[17,"IPV6_PKTINFO","","",N,N],[17,"TCP_NODELAY","","",N,N],[17,"TCP_MAXSEG","","",N,N],[17,"TCP_CORK","","",N,N],[17,"TCP_KEEPIDLE","","",N,N],[17,"TCP_KEEPINTVL","","",N,N],[17,"TCP_KEEPCNT","","",N,N],[17,"TCP_SYNCNT","","",N,N],[17,"TCP_LINGER2","","",N,N],[17,"TCP_DEFER_ACCEPT","","",N,N],[17,"TCP_WINDOW_CLAMP","","",N,N],[17,"TCP_INFO","","",N,N],[17,"TCP_QUICKACK","","",N,N],[17,"TCP_CONGESTION","","",N,N],[17,"SO_DEBUG","","",N,N],[17,"SHUT_RD","","",N,N],[17,"SHUT_WR","","",N,N],[17,"SHUT_RDWR","","",N,N],[17,"LOCK_SH","","",N,N],[17,"LOCK_EX","","",N,N],[17,"LOCK_NB","","",N,N],[17,"LOCK_UN","","",N,N],[17,"SS_ONSTACK","","",N,N],[17,"SS_DISABLE","","",N,N],[17,"PATH_MAX","","",N,N],[17,"FD_SETSIZE","","",N,N],[17,"EPOLLIN","","",N,N],[17,"EPOLLPRI","","",N,N],[17,"EPOLLOUT","","",N,N],[17,"EPOLLRDNORM","","",N,N],[17,"EPOLLRDBAND","","",N,N],[17,"EPOLLWRNORM","","",N,N],[17,"EPOLLWRBAND","","",N,N],[17,"EPOLLMSG","","",N,N],[17,"EPOLLERR","","",N,N],[17,"EPOLLHUP","","",N,N],[17,"EPOLLET","","",N,N],[17,"EPOLL_CTL_ADD","","",N,N],[17,"EPOLL_CTL_MOD","","",N,N],[17,"EPOLL_CTL_DEL","","",N,N],[17,"MNT_DETACH","","",N,N],[17,"MNT_EXPIRE","","",N,N],[17,"Q_GETFMT","","",N,N],[17,"Q_GETINFO","","",N,N],[17,"Q_SETINFO","","",N,N],[17,"QIF_BLIMITS","","",N,N],[17,"QIF_SPACE","","",N,N],[17,"QIF_ILIMITS","","",N,N],[17,"QIF_INODES","","",N,N],[17,"QIF_BTIME","","",N,N],[17,"QIF_ITIME","","",N,N],[17,"QIF_LIMITS","","",N,N],[17,"QIF_USAGE","","",N,N],[17,"QIF_TIMES","","",N,N],[17,"QIF_ALL","","",N,N],[17,"MNT_FORCE","","",N,N],[17,"Q_SYNC","","",N,N],[17,"Q_QUOTAON","","",N,N],[17,"Q_QUOTAOFF","","",N,N],[17,"Q_GETQUOTA","","",N,N],[17,"Q_SETQUOTA","","",N,N],[17,"TCIOFF","","",N,N],[17,"TCION","","",N,N],[17,"TCOOFF","","",N,N],[17,"TCOON","","",N,N],[17,"TCIFLUSH","","",N,N],[17,"TCOFLUSH","","",N,N],[17,"TCIOFLUSH","","",N,N],[17,"NL0","","",N,N],[17,"NL1","","",N,N],[17,"TAB0","","",N,N],[17,"CR0","","",N,N],[17,"FF0","","",N,N],[17,"BS0","","",N,N],[17,"VT0","","",N,N],[17,"VERASE","","",N,N],[17,"VKILL","","",N,N],[17,"VINTR","","",N,N],[17,"VQUIT","","",N,N],[17,"VLNEXT","","",N,N],[17,"IGNBRK","","",N,N],[17,"BRKINT","","",N,N],[17,"IGNPAR","","",N,N],[17,"PARMRK","","",N,N],[17,"INPCK","","",N,N],[17,"ISTRIP","","",N,N],[17,"INLCR","","",N,N],[17,"IGNCR","","",N,N],[17,"ICRNL","","",N,N],[17,"IXANY","","",N,N],[17,"IMAXBEL","","",N,N],[17,"OPOST","","",N,N],[17,"CS5","","",N,N],[17,"CRTSCTS","","",N,N],[17,"ECHO","","",N,N],[17,"OCRNL","","",N,N],[17,"ONOCR","","",N,N],[17,"ONLRET","","",N,N],[17,"OFILL","","",N,N],[17,"OFDEL","","",N,N],[17,"CLONE_VM","","",N,N],[17,"CLONE_FS","","",N,N],[17,"CLONE_FILES","","",N,N],[17,"CLONE_SIGHAND","","",N,N],[17,"CLONE_PTRACE","","",N,N],[17,"CLONE_VFORK","","",N,N],[17,"CLONE_PARENT","","",N,N],[17,"CLONE_THREAD","","",N,N],[17,"CLONE_NEWNS","","",N,N],[17,"CLONE_SYSVSEM","","",N,N],[17,"CLONE_SETTLS","","",N,N],[17,"CLONE_PARENT_SETTID","","",N,N],[17,"CLONE_CHILD_CLEARTID","","",N,N],[17,"CLONE_DETACHED","","",N,N],[17,"CLONE_UNTRACED","","",N,N],[17,"CLONE_CHILD_SETTID","","",N,N],[17,"CLONE_NEWUTS","","",N,N],[17,"CLONE_NEWIPC","","",N,N],[17,"CLONE_NEWUSER","","",N,N],[17,"CLONE_NEWPID","","",N,N],[17,"CLONE_NEWNET","","",N,N],[17,"CLONE_IO","","",N,N],[17,"CLONE_NEWCGROUP","","",N,N],[17,"WNOHANG","","",N,N],[17,"WUNTRACED","","",N,N],[17,"WSTOPPED","","",N,N],[17,"WEXITED","","",N,N],[17,"WCONTINUED","","",N,N],[17,"WNOWAIT","","",N,N],[17,"PTRACE_O_TRACESYSGOOD","","",N,N],[17,"PTRACE_O_TRACEFORK","","",N,N],[17,"PTRACE_O_TRACEVFORK","","",N,N],[17,"PTRACE_O_TRACECLONE","","",N,N],[17,"PTRACE_O_TRACEEXEC","","",N,N],[17,"PTRACE_O_TRACEVFORKDONE","","",N,N],[17,"PTRACE_O_TRACEEXIT","","",N,N],[17,"PTRACE_O_TRACESECCOMP","","",N,N],[17,"PTRACE_O_EXITKILL","","",N,N],[17,"PTRACE_O_SUSPEND_SECCOMP","","",N,N],[17,"PTRACE_O_MASK","","",N,N],[17,"PTRACE_EVENT_FORK","","",N,N],[17,"PTRACE_EVENT_VFORK","","",N,N],[17,"PTRACE_EVENT_CLONE","","",N,N],[17,"PTRACE_EVENT_EXEC","","",N,N],[17,"PTRACE_EVENT_VFORK_DONE","","",N,N],[17,"PTRACE_EVENT_EXIT","","",N,N],[17,"PTRACE_EVENT_SECCOMP","","",N,N],[17,"__WNOTHREAD","","",N,N],[17,"__WALL","","",N,N],[17,"__WCLONE","","",N,N],[17,"SPLICE_F_MOVE","","",N,N],[17,"SPLICE_F_NONBLOCK","","",N,N],[17,"SPLICE_F_MORE","","",N,N],[17,"SPLICE_F_GIFT","","",N,N],[17,"RTLD_LOCAL","","",N,N],[17,"RTLD_LAZY","","",N,N],[17,"POSIX_FADV_NORMAL","","",N,N],[17,"POSIX_FADV_RANDOM","","",N,N],[17,"POSIX_FADV_SEQUENTIAL","","",N,N],[17,"POSIX_FADV_WILLNEED","","",N,N],[17,"AT_FDCWD","","",N,N],[17,"AT_SYMLINK_NOFOLLOW","","",N,N],[17,"AT_REMOVEDIR","","",N,N],[17,"AT_SYMLINK_FOLLOW","","",N,N],[17,"AT_NO_AUTOMOUNT","","",N,N],[17,"AT_EMPTY_PATH","","",N,N],[17,"LOG_CRON","","",N,N],[17,"LOG_AUTHPRIV","","",N,N],[17,"LOG_FTP","","",N,N],[17,"LOG_PERROR","","",N,N],[17,"PIPE_BUF","","",N,N],[17,"SI_LOAD_SHIFT","","",N,N],[17,"SIGEV_SIGNAL","","",N,N],[17,"SIGEV_NONE","","",N,N],[17,"SIGEV_THREAD","","",N,N],[17,"P_ALL","","",N,N],[17,"P_PID","","",N,N],[17,"P_PGID","","",N,N],[17,"UTIME_OMIT","","",N,N],[17,"UTIME_NOW","","",N,N],[17,"POLLIN","","",N,N],[17,"POLLPRI","","",N,N],[17,"POLLOUT","","",N,N],[17,"POLLERR","","",N,N],[17,"POLLHUP","","",N,N],[17,"POLLNVAL","","",N,N],[17,"POLLRDNORM","","",N,N],[17,"POLLRDBAND","","",N,N],[17,"IPTOS_LOWDELAY","","",N,N],[17,"IPTOS_THROUGHPUT","","",N,N],[17,"IPTOS_RELIABILITY","","",N,N],[17,"IPTOS_MINCOST","","",N,N],[17,"IPTOS_PREC_NETCONTROL","","",N,N],[17,"IPTOS_PREC_INTERNETCONTROL","","",N,N],[17,"IPTOS_PREC_CRITIC_ECP","","",N,N],[17,"IPTOS_PREC_FLASHOVERRIDE","","",N,N],[17,"IPTOS_PREC_FLASH","","",N,N],[17,"IPTOS_PREC_IMMEDIATE","","",N,N],[17,"IPTOS_PREC_PRIORITY","","",N,N],[17,"IPTOS_PREC_ROUTINE","","",N,N],[17,"IPOPT_COPY","","",N,N],[17,"IPOPT_CLASS_MASK","","",N,N],[17,"IPOPT_NUMBER_MASK","","",N,N],[17,"IPOPT_CONTROL","","",N,N],[17,"IPOPT_RESERVED1","","",N,N],[17,"IPOPT_MEASUREMENT","","",N,N],[17,"IPOPT_RESERVED2","","",N,N],[17,"IPOPT_END","","",N,N],[17,"IPOPT_NOOP","","",N,N],[17,"IPOPT_SEC","","",N,N],[17,"IPOPT_LSRR","","",N,N],[17,"IPOPT_TIMESTAMP","","",N,N],[17,"IPOPT_RR","","",N,N],[17,"IPOPT_SID","","",N,N],[17,"IPOPT_SSRR","","",N,N],[17,"IPOPT_RA","","",N,N],[17,"IPVERSION","","",N,N],[17,"MAXTTL","","",N,N],[17,"IPDEFTTL","","",N,N],[17,"IPOPT_OPTVAL","","",N,N],[17,"IPOPT_OLEN","","",N,N],[17,"IPOPT_OFFSET","","",N,N],[17,"IPOPT_MINOFF","","",N,N],[17,"MAX_IPOPTLEN","","",N,N],[17,"IPOPT_NOP","","",N,N],[17,"IPOPT_EOL","","",N,N],[17,"IPOPT_TS","","",N,N],[17,"IPOPT_TS_TSONLY","","",N,N],[17,"IPOPT_TS_TSANDADDR","","",N,N],[17,"IPOPT_TS_PRESPEC","","",N,N],[17,"ARPOP_RREQUEST","","",N,N],[17,"ARPOP_RREPLY","","",N,N],[17,"ARPOP_InREQUEST","","",N,N],[17,"ARPOP_InREPLY","","",N,N],[17,"ARPOP_NAK","","",N,N],[17,"ATF_NETMASK","","",N,N],[17,"ATF_DONTPUB","","",N,N],[17,"ARPHRD_NETROM","","",N,N],[17,"ARPHRD_ETHER","","",N,N],[17,"ARPHRD_EETHER","","",N,N],[17,"ARPHRD_AX25","","",N,N],[17,"ARPHRD_PRONET","","",N,N],[17,"ARPHRD_CHAOS","","",N,N],[17,"ARPHRD_IEEE802","","",N,N],[17,"ARPHRD_ARCNET","","",N,N],[17,"ARPHRD_APPLETLK","","",N,N],[17,"ARPHRD_DLCI","","",N,N],[17,"ARPHRD_ATM","","",N,N],[17,"ARPHRD_METRICOM","","",N,N],[17,"ARPHRD_IEEE1394","","",N,N],[17,"ARPHRD_EUI64","","",N,N],[17,"ARPHRD_INFINIBAND","","",N,N],[17,"ARPHRD_SLIP","","",N,N],[17,"ARPHRD_CSLIP","","",N,N],[17,"ARPHRD_SLIP6","","",N,N],[17,"ARPHRD_CSLIP6","","",N,N],[17,"ARPHRD_RSRVD","","",N,N],[17,"ARPHRD_ADAPT","","",N,N],[17,"ARPHRD_ROSE","","",N,N],[17,"ARPHRD_X25","","",N,N],[17,"ARPHRD_HWX25","","",N,N],[17,"ARPHRD_PPP","","",N,N],[17,"ARPHRD_CISCO","","",N,N],[17,"ARPHRD_HDLC","","",N,N],[17,"ARPHRD_LAPB","","",N,N],[17,"ARPHRD_DDCMP","","",N,N],[17,"ARPHRD_RAWHDLC","","",N,N],[17,"ARPHRD_TUNNEL","","",N,N],[17,"ARPHRD_TUNNEL6","","",N,N],[17,"ARPHRD_FRAD","","",N,N],[17,"ARPHRD_SKIP","","",N,N],[17,"ARPHRD_LOOPBACK","","",N,N],[17,"ARPHRD_LOCALTLK","","",N,N],[17,"ARPHRD_FDDI","","",N,N],[17,"ARPHRD_BIF","","",N,N],[17,"ARPHRD_SIT","","",N,N],[17,"ARPHRD_IPDDP","","",N,N],[17,"ARPHRD_IPGRE","","",N,N],[17,"ARPHRD_PIMREG","","",N,N],[17,"ARPHRD_HIPPI","","",N,N],[17,"ARPHRD_ASH","","",N,N],[17,"ARPHRD_ECONET","","",N,N],[17,"ARPHRD_IRDA","","",N,N],[17,"ARPHRD_FCPP","","",N,N],[17,"ARPHRD_FCAL","","",N,N],[17,"ARPHRD_FCPL","","",N,N],[17,"ARPHRD_FCFABRIC","","",N,N],[17,"ARPHRD_IEEE802_TR","","",N,N],[17,"ARPHRD_IEEE80211","","",N,N],[17,"ARPHRD_IEEE80211_PRISM","","",N,N],[17,"ARPHRD_IEEE80211_RADIOTAP","","",N,N],[17,"ARPHRD_IEEE802154","","",N,N],[17,"ARPHRD_VOID","","",N,N],[17,"ARPHRD_NONE","","",N,N],[17,"ABDAY_1","","",N,N],[17,"ABDAY_2","","",N,N],[17,"ABDAY_3","","",N,N],[17,"ABDAY_4","","",N,N],[17,"ABDAY_5","","",N,N],[17,"ABDAY_6","","",N,N],[17,"ABDAY_7","","",N,N],[17,"DAY_1","","",N,N],[17,"DAY_2","","",N,N],[17,"DAY_3","","",N,N],[17,"DAY_4","","",N,N],[17,"DAY_5","","",N,N],[17,"DAY_6","","",N,N],[17,"DAY_7","","",N,N],[17,"ABMON_1","","",N,N],[17,"ABMON_2","","",N,N],[17,"ABMON_3","","",N,N],[17,"ABMON_4","","",N,N],[17,"ABMON_5","","",N,N],[17,"ABMON_6","","",N,N],[17,"ABMON_7","","",N,N],[17,"ABMON_8","","",N,N],[17,"ABMON_9","","",N,N],[17,"ABMON_10","","",N,N],[17,"ABMON_11","","",N,N],[17,"ABMON_12","","",N,N],[17,"MON_1","","",N,N],[17,"MON_2","","",N,N],[17,"MON_3","","",N,N],[17,"MON_4","","",N,N],[17,"MON_5","","",N,N],[17,"MON_6","","",N,N],[17,"MON_7","","",N,N],[17,"MON_8","","",N,N],[17,"MON_9","","",N,N],[17,"MON_10","","",N,N],[17,"MON_11","","",N,N],[17,"MON_12","","",N,N],[17,"AM_STR","","",N,N],[17,"PM_STR","","",N,N],[17,"D_T_FMT","","",N,N],[17,"D_FMT","","",N,N],[17,"T_FMT","","",N,N],[17,"T_FMT_AMPM","","",N,N],[17,"ERA","","",N,N],[17,"ERA_D_FMT","","",N,N],[17,"ALT_DIGITS","","",N,N],[17,"ERA_D_T_FMT","","",N,N],[17,"ERA_T_FMT","","",N,N],[17,"CODESET","","",N,N],[17,"CRNCYSTR","","",N,N],[17,"RUSAGE_THREAD","","",N,N],[17,"RUSAGE_CHILDREN","","",N,N],[17,"RADIXCHAR","","",N,N],[17,"THOUSEP","","",N,N],[17,"YESEXPR","","",N,N],[17,"NOEXPR","","",N,N],[17,"YESSTR","","",N,N],[17,"NOSTR","","",N,N],[17,"FILENAME_MAX","","",N,N],[17,"L_tmpnam","","",N,N],[17,"_PC_LINK_MAX","","",N,N],[17,"_PC_MAX_CANON","","",N,N],[17,"_PC_MAX_INPUT","","",N,N],[17,"_PC_NAME_MAX","","",N,N],[17,"_PC_PATH_MAX","","",N,N],[17,"_PC_PIPE_BUF","","",N,N],[17,"_PC_CHOWN_RESTRICTED","","",N,N],[17,"_PC_NO_TRUNC","","",N,N],[17,"_PC_VDISABLE","","",N,N],[17,"_PC_SYNC_IO","","",N,N],[17,"_PC_ASYNC_IO","","",N,N],[17,"_PC_PRIO_IO","","",N,N],[17,"_PC_SOCK_MAXBUF","","",N,N],[17,"_PC_FILESIZEBITS","","",N,N],[17,"_PC_REC_INCR_XFER_SIZE","","",N,N],[17,"_PC_REC_MAX_XFER_SIZE","","",N,N],[17,"_PC_REC_MIN_XFER_SIZE","","",N,N],[17,"_PC_REC_XFER_ALIGN","","",N,N],[17,"_PC_ALLOC_SIZE_MIN","","",N,N],[17,"_PC_SYMLINK_MAX","","",N,N],[17,"_PC_2_SYMLINKS","","",N,N],[17,"_SC_ARG_MAX","","",N,N],[17,"_SC_CHILD_MAX","","",N,N],[17,"_SC_CLK_TCK","","",N,N],[17,"_SC_NGROUPS_MAX","","",N,N],[17,"_SC_OPEN_MAX","","",N,N],[17,"_SC_STREAM_MAX","","",N,N],[17,"_SC_TZNAME_MAX","","",N,N],[17,"_SC_JOB_CONTROL","","",N,N],[17,"_SC_SAVED_IDS","","",N,N],[17,"_SC_REALTIME_SIGNALS","","",N,N],[17,"_SC_PRIORITY_SCHEDULING","","",N,N],[17,"_SC_TIMERS","","",N,N],[17,"_SC_ASYNCHRONOUS_IO","","",N,N],[17,"_SC_PRIORITIZED_IO","","",N,N],[17,"_SC_SYNCHRONIZED_IO","","",N,N],[17,"_SC_FSYNC","","",N,N],[17,"_SC_MAPPED_FILES","","",N,N],[17,"_SC_MEMLOCK","","",N,N],[17,"_SC_MEMLOCK_RANGE","","",N,N],[17,"_SC_MEMORY_PROTECTION","","",N,N],[17,"_SC_MESSAGE_PASSING","","",N,N],[17,"_SC_SEMAPHORES","","",N,N],[17,"_SC_SHARED_MEMORY_OBJECTS","","",N,N],[17,"_SC_AIO_LISTIO_MAX","","",N,N],[17,"_SC_AIO_MAX","","",N,N],[17,"_SC_AIO_PRIO_DELTA_MAX","","",N,N],[17,"_SC_DELAYTIMER_MAX","","",N,N],[17,"_SC_MQ_OPEN_MAX","","",N,N],[17,"_SC_MQ_PRIO_MAX","","",N,N],[17,"_SC_VERSION","","",N,N],[17,"_SC_PAGESIZE","","",N,N],[17,"_SC_PAGE_SIZE","","",N,N],[17,"_SC_RTSIG_MAX","","",N,N],[17,"_SC_SEM_NSEMS_MAX","","",N,N],[17,"_SC_SEM_VALUE_MAX","","",N,N],[17,"_SC_SIGQUEUE_MAX","","",N,N],[17,"_SC_TIMER_MAX","","",N,N],[17,"_SC_BC_BASE_MAX","","",N,N],[17,"_SC_BC_DIM_MAX","","",N,N],[17,"_SC_BC_SCALE_MAX","","",N,N],[17,"_SC_BC_STRING_MAX","","",N,N],[17,"_SC_COLL_WEIGHTS_MAX","","",N,N],[17,"_SC_EXPR_NEST_MAX","","",N,N],[17,"_SC_LINE_MAX","","",N,N],[17,"_SC_RE_DUP_MAX","","",N,N],[17,"_SC_2_VERSION","","",N,N],[17,"_SC_2_C_BIND","","",N,N],[17,"_SC_2_C_DEV","","",N,N],[17,"_SC_2_FORT_DEV","","",N,N],[17,"_SC_2_FORT_RUN","","",N,N],[17,"_SC_2_SW_DEV","","",N,N],[17,"_SC_2_LOCALEDEF","","",N,N],[17,"_SC_UIO_MAXIOV","","",N,N],[17,"_SC_IOV_MAX","","",N,N],[17,"_SC_THREADS","","",N,N],[17,"_SC_THREAD_SAFE_FUNCTIONS","","",N,N],[17,"_SC_GETGR_R_SIZE_MAX","","",N,N],[17,"_SC_GETPW_R_SIZE_MAX","","",N,N],[17,"_SC_LOGIN_NAME_MAX","","",N,N],[17,"_SC_TTY_NAME_MAX","","",N,N],[17,"_SC_THREAD_DESTRUCTOR_ITERATIONS","","",N,N],[17,"_SC_THREAD_KEYS_MAX","","",N,N],[17,"_SC_THREAD_STACK_MIN","","",N,N],[17,"_SC_THREAD_THREADS_MAX","","",N,N],[17,"_SC_THREAD_ATTR_STACKADDR","","",N,N],[17,"_SC_THREAD_ATTR_STACKSIZE","","",N,N],[17,"_SC_THREAD_PRIORITY_SCHEDULING","","",N,N],[17,"_SC_THREAD_PRIO_INHERIT","","",N,N],[17,"_SC_THREAD_PRIO_PROTECT","","",N,N],[17,"_SC_THREAD_PROCESS_SHARED","","",N,N],[17,"_SC_NPROCESSORS_CONF","","",N,N],[17,"_SC_NPROCESSORS_ONLN","","",N,N],[17,"_SC_PHYS_PAGES","","",N,N],[17,"_SC_AVPHYS_PAGES","","",N,N],[17,"_SC_ATEXIT_MAX","","",N,N],[17,"_SC_PASS_MAX","","",N,N],[17,"_SC_XOPEN_VERSION","","",N,N],[17,"_SC_XOPEN_XCU_VERSION","","",N,N],[17,"_SC_XOPEN_UNIX","","",N,N],[17,"_SC_XOPEN_CRYPT","","",N,N],[17,"_SC_XOPEN_ENH_I18N","","",N,N],[17,"_SC_XOPEN_SHM","","",N,N],[17,"_SC_2_CHAR_TERM","","",N,N],[17,"_SC_2_UPE","","",N,N],[17,"_SC_XOPEN_XPG2","","",N,N],[17,"_SC_XOPEN_XPG3","","",N,N],[17,"_SC_XOPEN_XPG4","","",N,N],[17,"_SC_NZERO","","",N,N],[17,"_SC_XBS5_ILP32_OFF32","","",N,N],[17,"_SC_XBS5_ILP32_OFFBIG","","",N,N],[17,"_SC_XBS5_LP64_OFF64","","",N,N],[17,"_SC_XBS5_LPBIG_OFFBIG","","",N,N],[17,"_SC_XOPEN_LEGACY","","",N,N],[17,"_SC_XOPEN_REALTIME","","",N,N],[17,"_SC_XOPEN_REALTIME_THREADS","","",N,N],[17,"_SC_ADVISORY_INFO","","",N,N],[17,"_SC_BARRIERS","","",N,N],[17,"_SC_CLOCK_SELECTION","","",N,N],[17,"_SC_CPUTIME","","",N,N],[17,"_SC_THREAD_CPUTIME","","",N,N],[17,"_SC_MONOTONIC_CLOCK","","",N,N],[17,"_SC_READER_WRITER_LOCKS","","",N,N],[17,"_SC_SPIN_LOCKS","","",N,N],[17,"_SC_REGEXP","","",N,N],[17,"_SC_SHELL","","",N,N],[17,"_SC_SPAWN","","",N,N],[17,"_SC_SPORADIC_SERVER","","",N,N],[17,"_SC_THREAD_SPORADIC_SERVER","","",N,N],[17,"_SC_TIMEOUTS","","",N,N],[17,"_SC_TYPED_MEMORY_OBJECTS","","",N,N],[17,"_SC_2_PBS","","",N,N],[17,"_SC_2_PBS_ACCOUNTING","","",N,N],[17,"_SC_2_PBS_LOCATE","","",N,N],[17,"_SC_2_PBS_MESSAGE","","",N,N],[17,"_SC_2_PBS_TRACK","","",N,N],[17,"_SC_SYMLOOP_MAX","","",N,N],[17,"_SC_STREAMS","","",N,N],[17,"_SC_2_PBS_CHECKPOINT","","",N,N],[17,"_SC_V6_ILP32_OFF32","","",N,N],[17,"_SC_V6_ILP32_OFFBIG","","",N,N],[17,"_SC_V6_LP64_OFF64","","",N,N],[17,"_SC_V6_LPBIG_OFFBIG","","",N,N],[17,"_SC_HOST_NAME_MAX","","",N,N],[17,"_SC_TRACE","","",N,N],[17,"_SC_TRACE_EVENT_FILTER","","",N,N],[17,"_SC_TRACE_INHERIT","","",N,N],[17,"_SC_TRACE_LOG","","",N,N],[17,"_SC_IPV6","","",N,N],[17,"_SC_RAW_SOCKETS","","",N,N],[17,"_SC_V7_ILP32_OFF32","","",N,N],[17,"_SC_V7_ILP32_OFFBIG","","",N,N],[17,"_SC_V7_LP64_OFF64","","",N,N],[17,"_SC_V7_LPBIG_OFFBIG","","",N,N],[17,"_SC_SS_REPL_MAX","","",N,N],[17,"_SC_TRACE_EVENT_NAME_MAX","","",N,N],[17,"_SC_TRACE_NAME_MAX","","",N,N],[17,"_SC_TRACE_SYS_MAX","","",N,N],[17,"_SC_TRACE_USER_EVENT_MAX","","",N,N],[17,"_SC_XOPEN_STREAMS","","",N,N],[17,"_SC_THREAD_ROBUST_PRIO_INHERIT","","",N,N],[17,"_SC_THREAD_ROBUST_PRIO_PROTECT","","",N,N],[17,"RLIM_SAVED_MAX","","",N,N],[17,"RLIM_SAVED_CUR","","",N,N],[17,"GLOB_ERR","","",N,N],[17,"GLOB_MARK","","",N,N],[17,"GLOB_NOSORT","","",N,N],[17,"GLOB_DOOFFS","","",N,N],[17,"GLOB_NOCHECK","","",N,N],[17,"GLOB_APPEND","","",N,N],[17,"GLOB_NOESCAPE","","",N,N],[17,"GLOB_NOSPACE","","",N,N],[17,"GLOB_ABORTED","","",N,N],[17,"GLOB_NOMATCH","","",N,N],[17,"POSIX_MADV_NORMAL","","",N,N],[17,"POSIX_MADV_RANDOM","","",N,N],[17,"POSIX_MADV_SEQUENTIAL","","",N,N],[17,"POSIX_MADV_WILLNEED","","",N,N],[17,"S_IEXEC","","",N,N],[17,"S_IWRITE","","",N,N],[17,"S_IREAD","","",N,N],[17,"F_LOCK","","",N,N],[17,"F_TEST","","",N,N],[17,"F_TLOCK","","",N,N],[17,"F_ULOCK","","",N,N],[17,"IFF_LOWER_UP","","",N,N],[17,"IFF_DORMANT","","",N,N],[17,"IFF_ECHO","","",N,N],[17,"IFF_TUN","","",N,N],[17,"IFF_TAP","","",N,N],[17,"IFF_NO_PI","","",N,N],[17,"TUN_READQ_SIZE","","",N,N],[17,"TUN_TUN_DEV","","",N,N],[17,"TUN_TAP_DEV","","",N,N],[17,"TUN_TYPE_MASK","","",N,N],[17,"IFF_ONE_QUEUE","","",N,N],[17,"IFF_VNET_HDR","","",N,N],[17,"IFF_TUN_EXCL","","",N,N],[17,"IFF_MULTI_QUEUE","","",N,N],[17,"IFF_ATTACH_QUEUE","","",N,N],[17,"IFF_DETACH_QUEUE","","",N,N],[17,"IFF_PERSIST","","",N,N],[17,"IFF_NOFILTER","","",N,N],[17,"ST_RDONLY","","",N,N],[17,"ST_NOSUID","","",N,N],[17,"ST_NODEV","","",N,N],[17,"ST_NOEXEC","","",N,N],[17,"ST_SYNCHRONOUS","","",N,N],[17,"ST_MANDLOCK","","",N,N],[17,"ST_WRITE","","",N,N],[17,"ST_APPEND","","",N,N],[17,"ST_IMMUTABLE","","",N,N],[17,"ST_NOATIME","","",N,N],[17,"ST_NODIRATIME","","",N,N],[17,"RTLD_NEXT","","",N,N],[17,"RTLD_DEFAULT","","",N,N],[17,"RTLD_NODELETE","","",N,N],[17,"RTLD_NOW","","",N,N],[17,"TCP_MD5SIG","","",N,N],[17,"PTHREAD_MUTEX_INITIALIZER","","",N,N],[17,"PTHREAD_COND_INITIALIZER","","",N,N],[17,"PTHREAD_RWLOCK_INITIALIZER","","",N,N],[17,"PTHREAD_MUTEX_NORMAL","","",N,N],[17,"PTHREAD_MUTEX_RECURSIVE","","",N,N],[17,"PTHREAD_MUTEX_ERRORCHECK","","",N,N],[17,"PTHREAD_MUTEX_DEFAULT","","",N,N],[17,"PTHREAD_PROCESS_PRIVATE","","",N,N],[17,"PTHREAD_PROCESS_SHARED","","",N,N],[17,"__SIZEOF_PTHREAD_COND_T","","",N,N],[17,"RENAME_NOREPLACE","","",N,N],[17,"RENAME_EXCHANGE","","",N,N],[17,"RENAME_WHITEOUT","","",N,N],[17,"SCHED_OTHER","","",N,N],[17,"SCHED_FIFO","","",N,N],[17,"SCHED_RR","","",N,N],[17,"SCHED_BATCH","","",N,N],[17,"SCHED_IDLE","","",N,N],[17,"IPPROTO_HOPOPTS","","Hop-by-hop option header",N,N],[17,"IPPROTO_IGMP","","group mgmt protocol",N,N],[17,"IPPROTO_IPIP","","for compatibility",N,N],[17,"IPPROTO_EGP","","exterior gateway protocol",N,N],[17,"IPPROTO_PUP","","pup",N,N],[17,"IPPROTO_IDP","","xns idp",N,N],[17,"IPPROTO_TP","","tp-4 w/ class negotiation",N,N],[17,"IPPROTO_DCCP","","DCCP",N,N],[17,"IPPROTO_ROUTING","","IP6 routing header",N,N],[17,"IPPROTO_FRAGMENT","","IP6 fragmentation header",N,N],[17,"IPPROTO_RSVP","","resource reservation",N,N],[17,"IPPROTO_GRE","","General Routing Encap.",N,N],[17,"IPPROTO_ESP","","IP6 Encap Sec. Payload",N,N],[17,"IPPROTO_AH","","IP6 Auth Header",N,N],[17,"IPPROTO_NONE","","IP6 no next header",N,N],[17,"IPPROTO_DSTOPTS","","IP6 destination option",N,N],[17,"IPPROTO_MTP","","",N,N],[17,"IPPROTO_BEETPH","","",N,N],[17,"IPPROTO_ENCAP","","encapsulation header",N,N],[17,"IPPROTO_PIM","","Protocol indep. multicast",N,N],[17,"IPPROTO_COMP","","IP Payload Comp. Protocol",N,N],[17,"IPPROTO_SCTP","","SCTP",N,N],[17,"IPPROTO_MH","","",N,N],[17,"IPPROTO_UDPLITE","","",N,N],[17,"IPPROTO_MPLS","","",N,N],[17,"IPPROTO_RAW","","raw IP packet",N,N],[17,"IPPROTO_MAX","","",N,N],[17,"AF_IB","","",N,N],[17,"AF_MPLS","","",N,N],[17,"AF_NFC","","",N,N],[17,"AF_VSOCK","","",N,N],[17,"PF_IB","","",N,N],[17,"PF_MPLS","","",N,N],[17,"PF_NFC","","",N,N],[17,"PF_VSOCK","","",N,N],[17,"IPC_PRIVATE","","",N,N],[17,"IPC_CREAT","","",N,N],[17,"IPC_EXCL","","",N,N],[17,"IPC_NOWAIT","","",N,N],[17,"IPC_RMID","","",N,N],[17,"IPC_SET","","",N,N],[17,"IPC_STAT","","",N,N],[17,"IPC_INFO","","",N,N],[17,"MSG_STAT","","",N,N],[17,"MSG_INFO","","",N,N],[17,"MSG_NOERROR","","",N,N],[17,"MSG_EXCEPT","","",N,N],[17,"MSG_COPY","","",N,N],[17,"SHM_R","","",N,N],[17,"SHM_W","","",N,N],[17,"SHM_RDONLY","","",N,N],[17,"SHM_RND","","",N,N],[17,"SHM_REMAP","","",N,N],[17,"SHM_EXEC","","",N,N],[17,"SHM_LOCK","","",N,N],[17,"SHM_UNLOCK","","",N,N],[17,"SHM_HUGETLB","","",N,N],[17,"SHM_NORESERVE","","",N,N],[17,"EPOLLRDHUP","","",N,N],[17,"EPOLLEXCLUSIVE","","",N,N],[17,"EPOLLONESHOT","","",N,N],[17,"QFMT_VFS_OLD","","",N,N],[17,"QFMT_VFS_V0","","",N,N],[17,"QFMT_VFS_V1","","",N,N],[17,"EFD_SEMAPHORE","","",N,N],[17,"LOG_NFACILITIES","","",N,N],[17,"SEM_FAILED","","",N,N],[17,"RB_AUTOBOOT","","",N,N],[17,"RB_HALT_SYSTEM","","",N,N],[17,"RB_ENABLE_CAD","","",N,N],[17,"RB_DISABLE_CAD","","",N,N],[17,"RB_POWER_OFF","","",N,N],[17,"RB_SW_SUSPEND","","",N,N],[17,"RB_KEXEC","","",N,N],[17,"AI_PASSIVE","","",N,N],[17,"AI_CANONNAME","","",N,N],[17,"AI_NUMERICHOST","","",N,N],[17,"AI_V4MAPPED","","",N,N],[17,"AI_ALL","","",N,N],[17,"AI_ADDRCONFIG","","",N,N],[17,"AI_NUMERICSERV","","",N,N],[17,"EAI_BADFLAGS","","",N,N],[17,"EAI_NONAME","","",N,N],[17,"EAI_AGAIN","","",N,N],[17,"EAI_FAIL","","",N,N],[17,"EAI_NODATA","","",N,N],[17,"EAI_FAMILY","","",N,N],[17,"EAI_SOCKTYPE","","",N,N],[17,"EAI_SERVICE","","",N,N],[17,"EAI_MEMORY","","",N,N],[17,"EAI_SYSTEM","","",N,N],[17,"EAI_OVERFLOW","","",N,N],[17,"NI_NUMERICHOST","","",N,N],[17,"NI_NUMERICSERV","","",N,N],[17,"NI_NOFQDN","","",N,N],[17,"NI_NAMEREQD","","",N,N],[17,"NI_DGRAM","","",N,N],[17,"SYNC_FILE_RANGE_WAIT_BEFORE","","",N,N],[17,"SYNC_FILE_RANGE_WRITE","","",N,N],[17,"SYNC_FILE_RANGE_WAIT_AFTER","","",N,N],[17,"AIO_CANCELED","","",N,N],[17,"AIO_NOTCANCELED","","",N,N],[17,"AIO_ALLDONE","","",N,N],[17,"LIO_READ","","",N,N],[17,"LIO_WRITE","","",N,N],[17,"LIO_NOP","","",N,N],[17,"LIO_WAIT","","",N,N],[17,"LIO_NOWAIT","","",N,N],[17,"MREMAP_MAYMOVE","","",N,N],[17,"MREMAP_FIXED","","",N,N],[17,"PR_SET_PDEATHSIG","","",N,N],[17,"PR_GET_PDEATHSIG","","",N,N],[17,"PR_GET_DUMPABLE","","",N,N],[17,"PR_SET_DUMPABLE","","",N,N],[17,"PR_GET_UNALIGN","","",N,N],[17,"PR_SET_UNALIGN","","",N,N],[17,"PR_UNALIGN_NOPRINT","","",N,N],[17,"PR_UNALIGN_SIGBUS","","",N,N],[17,"PR_GET_KEEPCAPS","","",N,N],[17,"PR_SET_KEEPCAPS","","",N,N],[17,"PR_GET_FPEMU","","",N,N],[17,"PR_SET_FPEMU","","",N,N],[17,"PR_FPEMU_NOPRINT","","",N,N],[17,"PR_FPEMU_SIGFPE","","",N,N],[17,"PR_GET_FPEXC","","",N,N],[17,"PR_SET_FPEXC","","",N,N],[17,"PR_FP_EXC_SW_ENABLE","","",N,N],[17,"PR_FP_EXC_DIV","","",N,N],[17,"PR_FP_EXC_OVF","","",N,N],[17,"PR_FP_EXC_UND","","",N,N],[17,"PR_FP_EXC_RES","","",N,N],[17,"PR_FP_EXC_INV","","",N,N],[17,"PR_FP_EXC_DISABLED","","",N,N],[17,"PR_FP_EXC_NONRECOV","","",N,N],[17,"PR_FP_EXC_ASYNC","","",N,N],[17,"PR_FP_EXC_PRECISE","","",N,N],[17,"PR_GET_TIMING","","",N,N],[17,"PR_SET_TIMING","","",N,N],[17,"PR_TIMING_STATISTICAL","","",N,N],[17,"PR_TIMING_TIMESTAMP","","",N,N],[17,"PR_SET_NAME","","",N,N],[17,"PR_GET_NAME","","",N,N],[17,"PR_GET_ENDIAN","","",N,N],[17,"PR_SET_ENDIAN","","",N,N],[17,"PR_ENDIAN_BIG","","",N,N],[17,"PR_ENDIAN_LITTLE","","",N,N],[17,"PR_ENDIAN_PPC_LITTLE","","",N,N],[17,"PR_GET_SECCOMP","","",N,N],[17,"PR_SET_SECCOMP","","",N,N],[17,"PR_CAPBSET_READ","","",N,N],[17,"PR_CAPBSET_DROP","","",N,N],[17,"PR_GET_TSC","","",N,N],[17,"PR_SET_TSC","","",N,N],[17,"PR_TSC_ENABLE","","",N,N],[17,"PR_TSC_SIGSEGV","","",N,N],[17,"PR_GET_SECUREBITS","","",N,N],[17,"PR_SET_SECUREBITS","","",N,N],[17,"PR_SET_TIMERSLACK","","",N,N],[17,"PR_GET_TIMERSLACK","","",N,N],[17,"PR_TASK_PERF_EVENTS_DISABLE","","",N,N],[17,"PR_TASK_PERF_EVENTS_ENABLE","","",N,N],[17,"PR_MCE_KILL","","",N,N],[17,"PR_MCE_KILL_CLEAR","","",N,N],[17,"PR_MCE_KILL_SET","","",N,N],[17,"PR_MCE_KILL_LATE","","",N,N],[17,"PR_MCE_KILL_EARLY","","",N,N],[17,"PR_MCE_KILL_DEFAULT","","",N,N],[17,"PR_MCE_KILL_GET","","",N,N],[17,"PR_SET_MM","","",N,N],[17,"PR_SET_MM_START_CODE","","",N,N],[17,"PR_SET_MM_END_CODE","","",N,N],[17,"PR_SET_MM_START_DATA","","",N,N],[17,"PR_SET_MM_END_DATA","","",N,N],[17,"PR_SET_MM_START_STACK","","",N,N],[17,"PR_SET_MM_START_BRK","","",N,N],[17,"PR_SET_MM_BRK","","",N,N],[17,"PR_SET_MM_ARG_START","","",N,N],[17,"PR_SET_MM_ARG_END","","",N,N],[17,"PR_SET_MM_ENV_START","","",N,N],[17,"PR_SET_MM_ENV_END","","",N,N],[17,"PR_SET_MM_AUXV","","",N,N],[17,"PR_SET_MM_EXE_FILE","","",N,N],[17,"PR_SET_MM_MAP","","",N,N],[17,"PR_SET_MM_MAP_SIZE","","",N,N],[17,"PR_SET_PTRACER","","",N,N],[17,"PR_SET_CHILD_SUBREAPER","","",N,N],[17,"PR_GET_CHILD_SUBREAPER","","",N,N],[17,"PR_SET_NO_NEW_PRIVS","","",N,N],[17,"PR_GET_NO_NEW_PRIVS","","",N,N],[17,"PR_GET_TID_ADDRESS","","",N,N],[17,"PR_SET_THP_DISABLE","","",N,N],[17,"PR_GET_THP_DISABLE","","",N,N],[17,"PR_MPX_ENABLE_MANAGEMENT","","",N,N],[17,"PR_MPX_DISABLE_MANAGEMENT","","",N,N],[17,"PR_SET_FP_MODE","","",N,N],[17,"PR_GET_FP_MODE","","",N,N],[17,"PR_FP_MODE_FR","","",N,N],[17,"PR_FP_MODE_FRE","","",N,N],[17,"PR_CAP_AMBIENT","","",N,N],[17,"PR_CAP_AMBIENT_IS_SET","","",N,N],[17,"PR_CAP_AMBIENT_RAISE","","",N,N],[17,"PR_CAP_AMBIENT_LOWER","","",N,N],[17,"PR_CAP_AMBIENT_CLEAR_ALL","","",N,N],[17,"GRND_NONBLOCK","","",N,N],[17,"GRND_RANDOM","","",N,N],[17,"SECCOMP_MODE_DISABLED","","",N,N],[17,"SECCOMP_MODE_STRICT","","",N,N],[17,"SECCOMP_MODE_FILTER","","",N,N],[17,"ITIMER_REAL","","",N,N],[17,"ITIMER_VIRTUAL","","",N,N],[17,"ITIMER_PROF","","",N,N],[17,"TFD_CLOEXEC","","",N,N],[17,"TFD_NONBLOCK","","",N,N],[17,"TFD_TIMER_ABSTIME","","",N,N],[17,"XATTR_CREATE","","",N,N],[17,"XATTR_REPLACE","","",N,N],[17,"_POSIX_VDISABLE","","",N,N],[17,"FALLOC_FL_KEEP_SIZE","","",N,N],[17,"FALLOC_FL_PUNCH_HOLE","","",N,N],[17,"FALLOC_FL_COLLAPSE_RANGE","","",N,N],[17,"FALLOC_FL_ZERO_RANGE","","",N,N],[17,"FALLOC_FL_INSERT_RANGE","","",N,N],[17,"FALLOC_FL_UNSHARE_RANGE","","",N,N],[17,"ENOATTR","","",N,N],[17,"SO_ORIGINAL_DST","","",N,N],[17,"IUTF8","","",N,N],[17,"CMSPAR","","",N,N],[17,"MFD_CLOEXEC","","",N,N],[17,"MFD_ALLOW_SEALING","","",N,N],[17,"PT_NULL","","",N,N],[17,"PT_LOAD","","",N,N],[17,"PT_DYNAMIC","","",N,N],[17,"PT_INTERP","","",N,N],[17,"PT_NOTE","","",N,N],[17,"PT_SHLIB","","",N,N],[17,"PT_PHDR","","",N,N],[17,"PT_TLS","","",N,N],[17,"PT_NUM","","",N,N],[17,"PT_LOOS","","",N,N],[17,"PT_GNU_EH_FRAME","","",N,N],[17,"PT_GNU_STACK","","",N,N],[17,"PT_GNU_RELRO","","",N,N],[17,"ETH_ALEN","","",N,N],[17,"ETH_HLEN","","",N,N],[17,"ETH_ZLEN","","",N,N],[17,"ETH_DATA_LEN","","",N,N],[17,"ETH_FRAME_LEN","","",N,N],[17,"ETH_FCS_LEN","","",N,N],[17,"ETH_P_LOOP","","",N,N],[17,"ETH_P_PUP","","",N,N],[17,"ETH_P_PUPAT","","",N,N],[17,"ETH_P_IP","","",N,N],[17,"ETH_P_X25","","",N,N],[17,"ETH_P_ARP","","",N,N],[17,"ETH_P_BPQ","","",N,N],[17,"ETH_P_IEEEPUP","","",N,N],[17,"ETH_P_IEEEPUPAT","","",N,N],[17,"ETH_P_BATMAN","","",N,N],[17,"ETH_P_DEC","","",N,N],[17,"ETH_P_DNA_DL","","",N,N],[17,"ETH_P_DNA_RC","","",N,N],[17,"ETH_P_DNA_RT","","",N,N],[17,"ETH_P_LAT","","",N,N],[17,"ETH_P_DIAG","","",N,N],[17,"ETH_P_CUST","","",N,N],[17,"ETH_P_SCA","","",N,N],[17,"ETH_P_TEB","","",N,N],[17,"ETH_P_RARP","","",N,N],[17,"ETH_P_ATALK","","",N,N],[17,"ETH_P_AARP","","",N,N],[17,"ETH_P_8021Q","","",N,N],[17,"ETH_P_IPX","","",N,N],[17,"ETH_P_IPV6","","",N,N],[17,"ETH_P_PAUSE","","",N,N],[17,"ETH_P_SLOW","","",N,N],[17,"ETH_P_WCCP","","",N,N],[17,"ETH_P_MPLS_UC","","",N,N],[17,"ETH_P_MPLS_MC","","",N,N],[17,"ETH_P_ATMMPOA","","",N,N],[17,"ETH_P_PPP_DISC","","",N,N],[17,"ETH_P_PPP_SES","","",N,N],[17,"ETH_P_LINK_CTL","","",N,N],[17,"ETH_P_ATMFATE","","",N,N],[17,"ETH_P_PAE","","",N,N],[17,"ETH_P_AOE","","",N,N],[17,"ETH_P_8021AD","","",N,N],[17,"ETH_P_802_EX1","","",N,N],[17,"ETH_P_TIPC","","",N,N],[17,"ETH_P_MACSEC","","",N,N],[17,"ETH_P_8021AH","","",N,N],[17,"ETH_P_MVRP","","",N,N],[17,"ETH_P_1588","","",N,N],[17,"ETH_P_PRP","","",N,N],[17,"ETH_P_FCOE","","",N,N],[17,"ETH_P_TDLS","","",N,N],[17,"ETH_P_FIP","","",N,N],[17,"ETH_P_80221","","",N,N],[17,"ETH_P_LOOPBACK","","",N,N],[17,"ETH_P_QINQ1","","",N,N],[17,"ETH_P_QINQ2","","",N,N],[17,"ETH_P_QINQ3","","",N,N],[17,"ETH_P_EDSA","","",N,N],[17,"ETH_P_AF_IUCV","","",N,N],[17,"ETH_P_802_3_MIN","","",N,N],[17,"ETH_P_802_3","","",N,N],[17,"ETH_P_AX25","","",N,N],[17,"ETH_P_ALL","","",N,N],[17,"ETH_P_802_2","","",N,N],[17,"ETH_P_SNAP","","",N,N],[17,"ETH_P_DDCMP","","",N,N],[17,"ETH_P_WAN_PPP","","",N,N],[17,"ETH_P_PPP_MP","","",N,N],[17,"ETH_P_LOCALTALK","","",N,N],[17,"ETH_P_CANFD","","",N,N],[17,"ETH_P_PPPTALK","","",N,N],[17,"ETH_P_TR_802_2","","",N,N],[17,"ETH_P_MOBITEX","","",N,N],[17,"ETH_P_CONTROL","","",N,N],[17,"ETH_P_IRDA","","",N,N],[17,"ETH_P_ECONET","","",N,N],[17,"ETH_P_HDLC","","",N,N],[17,"ETH_P_ARCNET","","",N,N],[17,"ETH_P_DSA","","",N,N],[17,"ETH_P_TRAILER","","",N,N],[17,"ETH_P_PHONET","","",N,N],[17,"ETH_P_IEEE802154","","",N,N],[17,"ETH_P_CAIF","","",N,N],[17,"POSIX_SPAWN_RESETIDS","","",N,N],[17,"POSIX_SPAWN_SETPGROUP","","",N,N],[17,"POSIX_SPAWN_SETSIGDEF","","",N,N],[17,"POSIX_SPAWN_SETSIGMASK","","",N,N],[17,"POSIX_SPAWN_SETSCHEDPARAM","","",N,N],[17,"POSIX_SPAWN_SETSCHEDULER","","",N,N],[17,"NLMSG_NOOP","","",N,N],[17,"NLMSG_ERROR","","",N,N],[17,"NLMSG_DONE","","",N,N],[17,"NLMSG_OVERRUN","","",N,N],[17,"NLMSG_MIN_TYPE","","",N,N],[17,"GENL_NAMSIZ","","",N,N],[17,"GENL_MIN_ID","","",N,N],[17,"GENL_MAX_ID","","",N,N],[17,"GENL_ADMIN_PERM","","",N,N],[17,"GENL_CMD_CAP_DO","","",N,N],[17,"GENL_CMD_CAP_DUMP","","",N,N],[17,"GENL_CMD_CAP_HASPOL","","",N,N],[17,"GENL_ID_CTRL","","",N,N],[17,"CTRL_CMD_UNSPEC","","",N,N],[17,"CTRL_CMD_NEWFAMILY","","",N,N],[17,"CTRL_CMD_DELFAMILY","","",N,N],[17,"CTRL_CMD_GETFAMILY","","",N,N],[17,"CTRL_CMD_NEWOPS","","",N,N],[17,"CTRL_CMD_DELOPS","","",N,N],[17,"CTRL_CMD_GETOPS","","",N,N],[17,"CTRL_CMD_NEWMCAST_GRP","","",N,N],[17,"CTRL_CMD_DELMCAST_GRP","","",N,N],[17,"CTRL_CMD_GETMCAST_GRP","","",N,N],[17,"CTRL_ATTR_UNSPEC","","",N,N],[17,"CTRL_ATTR_FAMILY_ID","","",N,N],[17,"CTRL_ATTR_FAMILY_NAME","","",N,N],[17,"CTRL_ATTR_VERSION","","",N,N],[17,"CTRL_ATTR_HDRSIZE","","",N,N],[17,"CTRL_ATTR_MAXATTR","","",N,N],[17,"CTRL_ATTR_OPS","","",N,N],[17,"CTRL_ATTR_MCAST_GROUPS","","",N,N],[17,"CTRL_ATTR_OP_UNSPEC","","",N,N],[17,"CTRL_ATTR_OP_ID","","",N,N],[17,"CTRL_ATTR_OP_FLAGS","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_UNSPEC","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_NAME","","",N,N],[17,"CTRL_ATTR_MCAST_GRP_ID","","",N,N],[17,"PACKET_ADD_MEMBERSHIP","","",N,N],[17,"PACKET_DROP_MEMBERSHIP","","",N,N],[17,"PACKET_MR_MULTICAST","","",N,N],[17,"PACKET_MR_PROMISC","","",N,N],[17,"PACKET_MR_ALLMULTI","","",N,N],[17,"PACKET_MR_UNICAST","","",N,N],[17,"NF_DROP","","",N,N],[17,"NF_ACCEPT","","",N,N],[17,"NF_STOLEN","","",N,N],[17,"NF_QUEUE","","",N,N],[17,"NF_REPEAT","","",N,N],[17,"NF_STOP","","",N,N],[17,"NF_MAX_VERDICT","","",N,N],[17,"NF_VERDICT_MASK","","",N,N],[17,"NF_VERDICT_FLAG_QUEUE_BYPASS","","",N,N],[17,"NF_VERDICT_QMASK","","",N,N],[17,"NF_VERDICT_QBITS","","",N,N],[17,"NF_VERDICT_BITS","","",N,N],[17,"NF_INET_PRE_ROUTING","","",N,N],[17,"NF_INET_LOCAL_IN","","",N,N],[17,"NF_INET_FORWARD","","",N,N],[17,"NF_INET_LOCAL_OUT","","",N,N],[17,"NF_INET_POST_ROUTING","","",N,N],[17,"NF_INET_NUMHOOKS","","",N,N],[17,"NFPROTO_UNSPEC","","",N,N],[17,"NFPROTO_IPV4","","",N,N],[17,"NFPROTO_ARP","","",N,N],[17,"NFPROTO_BRIDGE","","",N,N],[17,"NFPROTO_IPV6","","",N,N],[17,"NFPROTO_DECNET","","",N,N],[17,"NFPROTO_NUMPROTO","","",N,N],[17,"NF_IP_PRE_ROUTING","","",N,N],[17,"NF_IP_LOCAL_IN","","",N,N],[17,"NF_IP_FORWARD","","",N,N],[17,"NF_IP_LOCAL_OUT","","",N,N],[17,"NF_IP_POST_ROUTING","","",N,N],[17,"NF_IP_NUMHOOKS","","",N,N],[17,"NF_IP_PRI_FIRST","","",N,N],[17,"NF_IP_PRI_CONNTRACK_DEFRAG","","",N,N],[17,"NF_IP_PRI_RAW","","",N,N],[17,"NF_IP_PRI_SELINUX_FIRST","","",N,N],[17,"NF_IP_PRI_CONNTRACK","","",N,N],[17,"NF_IP_PRI_MANGLE","","",N,N],[17,"NF_IP_PRI_NAT_DST","","",N,N],[17,"NF_IP_PRI_FILTER","","",N,N],[17,"NF_IP_PRI_SECURITY","","",N,N],[17,"NF_IP_PRI_NAT_SRC","","",N,N],[17,"NF_IP_PRI_SELINUX_LAST","","",N,N],[17,"NF_IP_PRI_CONNTRACK_HELPER","","",N,N],[17,"NF_IP_PRI_CONNTRACK_CONFIRM","","",N,N],[17,"NF_IP_PRI_LAST","","",N,N],[17,"NF_IP6_PRE_ROUTING","","",N,N],[17,"NF_IP6_LOCAL_IN","","",N,N],[17,"NF_IP6_FORWARD","","",N,N],[17,"NF_IP6_LOCAL_OUT","","",N,N],[17,"NF_IP6_POST_ROUTING","","",N,N],[17,"NF_IP6_NUMHOOKS","","",N,N],[17,"NF_IP6_PRI_FIRST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK_DEFRAG","","",N,N],[17,"NF_IP6_PRI_RAW","","",N,N],[17,"NF_IP6_PRI_SELINUX_FIRST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK","","",N,N],[17,"NF_IP6_PRI_MANGLE","","",N,N],[17,"NF_IP6_PRI_NAT_DST","","",N,N],[17,"NF_IP6_PRI_FILTER","","",N,N],[17,"NF_IP6_PRI_SECURITY","","",N,N],[17,"NF_IP6_PRI_NAT_SRC","","",N,N],[17,"NF_IP6_PRI_SELINUX_LAST","","",N,N],[17,"NF_IP6_PRI_CONNTRACK_HELPER","","",N,N],[17,"NF_IP6_PRI_LAST","","",N,N],[17,"SIOCADDRT","","",N,N],[17,"SIOCDELRT","","",N,N],[17,"SIOCGIFNAME","","",N,N],[17,"SIOCSIFLINK","","",N,N],[17,"SIOCGIFCONF","","",N,N],[17,"SIOCGIFFLAGS","","",N,N],[17,"SIOCSIFFLAGS","","",N,N],[17,"SIOCGIFADDR","","",N,N],[17,"SIOCSIFADDR","","",N,N],[17,"SIOCGIFDSTADDR","","",N,N],[17,"SIOCSIFDSTADDR","","",N,N],[17,"SIOCGIFBRDADDR","","",N,N],[17,"SIOCSIFBRDADDR","","",N,N],[17,"SIOCGIFNETMASK","","",N,N],[17,"SIOCSIFNETMASK","","",N,N],[17,"SIOCGIFMETRIC","","",N,N],[17,"SIOCSIFMETRIC","","",N,N],[17,"SIOCGIFMEM","","",N,N],[17,"SIOCSIFMEM","","",N,N],[17,"SIOCGIFMTU","","",N,N],[17,"SIOCSIFMTU","","",N,N],[17,"SIOCSIFHWADDR","","",N,N],[17,"SIOCGIFENCAP","","",N,N],[17,"SIOCSIFENCAP","","",N,N],[17,"SIOCGIFHWADDR","","",N,N],[17,"SIOCGIFSLAVE","","",N,N],[17,"SIOCSIFSLAVE","","",N,N],[17,"SIOCADDMULTI","","",N,N],[17,"SIOCDELMULTI","","",N,N],[17,"SIOCDARP","","",N,N],[17,"SIOCGARP","","",N,N],[17,"SIOCSARP","","",N,N],[17,"SIOCDRARP","","",N,N],[17,"SIOCGRARP","","",N,N],[17,"SIOCSRARP","","",N,N],[17,"SIOCGIFMAP","","",N,N],[17,"SIOCSIFMAP","","",N,N],[17,"IPTOS_TOS_MASK","","",N,N],[17,"IPTOS_PREC_MASK","","",N,N],[17,"RTF_UP","","",N,N],[17,"RTF_GATEWAY","","",N,N],[17,"RTF_HOST","","",N,N],[17,"RTF_REINSTATE","","",N,N],[17,"RTF_DYNAMIC","","",N,N],[17,"RTF_MODIFIED","","",N,N],[17,"RTF_MTU","","",N,N],[17,"RTF_MSS","","",N,N],[17,"RTF_WINDOW","","",N,N],[17,"RTF_IRTT","","",N,N],[17,"RTF_REJECT","","",N,N],[17,"RTF_STATIC","","",N,N],[17,"RTF_XRESOLVE","","",N,N],[17,"RTF_NOFORWARD","","",N,N],[17,"RTF_THROW","","",N,N],[17,"RTF_NOPMTUDISC","","",N,N],[17,"RTF_DEFAULT","","",N,N],[17,"RTF_ALLONLINK","","",N,N],[17,"RTF_ADDRCONF","","",N,N],[17,"RTF_LINKRT","","",N,N],[17,"RTF_NONEXTHOP","","",N,N],[17,"RTF_CACHE","","",N,N],[17,"RTF_FLOW","","",N,N],[17,"RTF_POLICY","","",N,N],[17,"RTCF_VALVE","","",N,N],[17,"RTCF_MASQ","","",N,N],[17,"RTCF_NAT","","",N,N],[17,"RTCF_DOREDIRECT","","",N,N],[17,"RTCF_LOG","","",N,N],[17,"RTCF_DIRECTSRC","","",N,N],[17,"RTF_LOCAL","","",N,N],[17,"RTF_INTERFACE","","",N,N],[17,"RTF_MULTICAST","","",N,N],[17,"RTF_BROADCAST","","",N,N],[17,"RTF_NAT","","",N,N],[17,"RTF_ADDRCLASSMASK","","",N,N],[17,"RT_CLASS_UNSPEC","","",N,N],[17,"RT_CLASS_DEFAULT","","",N,N],[17,"RT_CLASS_MAIN","","",N,N],[17,"RT_CLASS_LOCAL","","",N,N],[17,"RT_CLASS_MAX","","",N,N],[17,"RTMSG_OVERRUN","","",N,N],[17,"RTMSG_NEWDEVICE","","",N,N],[17,"RTMSG_DELDEVICE","","",N,N],[17,"RTMSG_NEWROUTE","","",N,N],[17,"RTMSG_DELROUTE","","",N,N],[17,"RTMSG_NEWRULE","","",N,N],[17,"RTMSG_DELRULE","","",N,N],[17,"RTMSG_CONTROL","","",N,N],[17,"RTMSG_AR_FAILED","","",N,N],[17,"MAX_ADDR_LEN","","",N,N],[17,"ARPD_UPDATE","","",N,N],[17,"ARPD_LOOKUP","","",N,N],[17,"ARPD_FLUSH","","",N,N],[17,"ATF_MAGIC","","",N,N],[17,"MODULE_INIT_IGNORE_MODVERSIONS","","",N,N],[17,"MODULE_INIT_IGNORE_VERMAGIC","","",N,N],[17,"__UT_LINESIZE","","",N,N],[17,"__UT_NAMESIZE","","",N,N],[17,"__UT_HOSTSIZE","","",N,N],[17,"EMPTY","","",N,N],[17,"RUN_LVL","","",N,N],[17,"BOOT_TIME","","",N,N],[17,"NEW_TIME","","",N,N],[17,"OLD_TIME","","",N,N],[17,"INIT_PROCESS","","",N,N],[17,"LOGIN_PROCESS","","",N,N],[17,"USER_PROCESS","","",N,N],[17,"DEAD_PROCESS","","",N,N],[17,"ACCOUNTING","","",N,N],[17,"RLIMIT_RSS","","",N,N],[17,"RLIMIT_AS","","",N,N],[17,"RLIMIT_MEMLOCK","","",N,N],[17,"RLIM_INFINITY","","",N,N],[17,"RLIMIT_RTTIME","","",N,N],[17,"RLIMIT_NLIMITS","","",N,N],[17,"SOCK_NONBLOCK","","",N,N],[17,"SOL_RXRPC","","",N,N],[17,"SOL_PPPOL2TP","","",N,N],[17,"SOL_BLUETOOTH","","",N,N],[17,"SOL_PNPIPE","","",N,N],[17,"SOL_RDS","","",N,N],[17,"SOL_IUCV","","",N,N],[17,"SOL_CAIF","","",N,N],[17,"SOL_ALG","","",N,N],[17,"SOL_NFC","","",N,N],[17,"MSG_TRYHARD","","",N,N],[17,"LC_PAPER","","",N,N],[17,"LC_NAME","","",N,N],[17,"LC_ADDRESS","","",N,N],[17,"LC_TELEPHONE","","",N,N],[17,"LC_MEASUREMENT","","",N,N],[17,"LC_IDENTIFICATION","","",N,N],[17,"LC_PAPER_MASK","","",N,N],[17,"LC_NAME_MASK","","",N,N],[17,"LC_ADDRESS_MASK","","",N,N],[17,"LC_TELEPHONE_MASK","","",N,N],[17,"LC_MEASUREMENT_MASK","","",N,N],[17,"LC_IDENTIFICATION_MASK","","",N,N],[17,"LC_ALL_MASK","","",N,N],[17,"MAP_ANON","","",N,N],[17,"MAP_ANONYMOUS","","",N,N],[17,"MAP_DENYWRITE","","",N,N],[17,"MAP_EXECUTABLE","","",N,N],[17,"MAP_POPULATE","","",N,N],[17,"MAP_NONBLOCK","","",N,N],[17,"MAP_STACK","","",N,N],[17,"ENOTSUP","","",N,N],[17,"EUCLEAN","","",N,N],[17,"ENOTNAM","","",N,N],[17,"ENAVAIL","","",N,N],[17,"EISNAM","","",N,N],[17,"EREMOTEIO","","",N,N],[17,"SOCK_STREAM","","",N,N],[17,"SOCK_DGRAM","","",N,N],[17,"SOCK_SEQPACKET","","",N,N],[17,"SOCK_DCCP","","",N,N],[17,"SOCK_PACKET","","",N,N],[17,"TCP_COOKIE_TRANSACTIONS","","",N,N],[17,"TCP_THIN_LINEAR_TIMEOUTS","","",N,N],[17,"TCP_THIN_DUPACK","","",N,N],[17,"TCP_USER_TIMEOUT","","",N,N],[17,"TCP_REPAIR","","",N,N],[17,"TCP_REPAIR_QUEUE","","",N,N],[17,"TCP_QUEUE_SEQ","","",N,N],[17,"TCP_REPAIR_OPTIONS","","",N,N],[17,"TCP_FASTOPEN","","",N,N],[17,"TCP_TIMESTAMP","","",N,N],[17,"DCCP_SOCKOPT_PACKET_SIZE","","",N,N],[17,"DCCP_SOCKOPT_SERVICE","","",N,N],[17,"DCCP_SOCKOPT_CHANGE_L","","",N,N],[17,"DCCP_SOCKOPT_CHANGE_R","","",N,N],[17,"DCCP_SOCKOPT_GET_CUR_MPS","","",N,N],[17,"DCCP_SOCKOPT_SERVER_TIMEWAIT","","",N,N],[17,"DCCP_SOCKOPT_SEND_CSCOV","","",N,N],[17,"DCCP_SOCKOPT_RECV_CSCOV","","",N,N],[17,"DCCP_SOCKOPT_AVAILABLE_CCIDS","","",N,N],[17,"DCCP_SOCKOPT_CCID","","",N,N],[17,"DCCP_SOCKOPT_TX_CCID","","",N,N],[17,"DCCP_SOCKOPT_RX_CCID","","",N,N],[17,"DCCP_SOCKOPT_QPOLICY_ID","","",N,N],[17,"DCCP_SOCKOPT_QPOLICY_TXQLEN","","",N,N],[17,"DCCP_SOCKOPT_CCID_RX_INFO","","",N,N],[17,"DCCP_SOCKOPT_CCID_TX_INFO","","",N,N],[17,"DCCP_SERVICE_LIST_MAX_LEN","","maximum number of services provided on the same listening port",N,N],[17,"SIGTTIN","","",N,N],[17,"SIGTTOU","","",N,N],[17,"SIGXCPU","","",N,N],[17,"SIGXFSZ","","",N,N],[17,"SIGVTALRM","","",N,N],[17,"SIGPROF","","",N,N],[17,"SIGWINCH","","",N,N],[17,"SIGEV_THREAD_ID","","",N,N],[17,"BUFSIZ","","",N,N],[17,"TMP_MAX","","",N,N],[17,"FOPEN_MAX","","",N,N],[17,"POSIX_FADV_DONTNEED","","",N,N],[17,"POSIX_FADV_NOREUSE","","",N,N],[17,"POSIX_MADV_DONTNEED","","",N,N],[17,"_SC_EQUIV_CLASS_MAX","","",N,N],[17,"_SC_CHARCLASS_NAME_MAX","","",N,N],[17,"_SC_PII","","",N,N],[17,"_SC_PII_XTI","","",N,N],[17,"_SC_PII_SOCKET","","",N,N],[17,"_SC_PII_INTERNET","","",N,N],[17,"_SC_PII_OSI","","",N,N],[17,"_SC_POLL","","",N,N],[17,"_SC_SELECT","","",N,N],[17,"_SC_PII_INTERNET_STREAM","","",N,N],[17,"_SC_PII_INTERNET_DGRAM","","",N,N],[17,"_SC_PII_OSI_COTS","","",N,N],[17,"_SC_PII_OSI_CLTS","","",N,N],[17,"_SC_PII_OSI_M","","",N,N],[17,"_SC_T_IOV_MAX","","",N,N],[17,"_SC_2_C_VERSION","","",N,N],[17,"_SC_CHAR_BIT","","",N,N],[17,"_SC_CHAR_MAX","","",N,N],[17,"_SC_CHAR_MIN","","",N,N],[17,"_SC_INT_MAX","","",N,N],[17,"_SC_INT_MIN","","",N,N],[17,"_SC_LONG_BIT","","",N,N],[17,"_SC_WORD_BIT","","",N,N],[17,"_SC_MB_LEN_MAX","","",N,N],[17,"_SC_SSIZE_MAX","","",N,N],[17,"_SC_SCHAR_MAX","","",N,N],[17,"_SC_SCHAR_MIN","","",N,N],[17,"_SC_SHRT_MAX","","",N,N],[17,"_SC_SHRT_MIN","","",N,N],[17,"_SC_UCHAR_MAX","","",N,N],[17,"_SC_UINT_MAX","","",N,N],[17,"_SC_ULONG_MAX","","",N,N],[17,"_SC_USHRT_MAX","","",N,N],[17,"_SC_NL_ARGMAX","","",N,N],[17,"_SC_NL_LANGMAX","","",N,N],[17,"_SC_NL_MSGMAX","","",N,N],[17,"_SC_NL_NMAX","","",N,N],[17,"_SC_NL_SETMAX","","",N,N],[17,"_SC_NL_TEXTMAX","","",N,N],[17,"_SC_BASE","","",N,N],[17,"_SC_C_LANG_SUPPORT","","",N,N],[17,"_SC_C_LANG_SUPPORT_R","","",N,N],[17,"_SC_DEVICE_IO","","",N,N],[17,"_SC_DEVICE_SPECIFIC","","",N,N],[17,"_SC_DEVICE_SPECIFIC_R","","",N,N],[17,"_SC_FD_MGMT","","",N,N],[17,"_SC_FIFO","","",N,N],[17,"_SC_PIPE","","",N,N],[17,"_SC_FILE_ATTRIBUTES","","",N,N],[17,"_SC_FILE_LOCKING","","",N,N],[17,"_SC_FILE_SYSTEM","","",N,N],[17,"_SC_MULTI_PROCESS","","",N,N],[17,"_SC_SINGLE_PROCESS","","",N,N],[17,"_SC_NETWORKING","","",N,N],[17,"_SC_REGEX_VERSION","","",N,N],[17,"_SC_SIGNALS","","",N,N],[17,"_SC_SYSTEM_DATABASE","","",N,N],[17,"_SC_SYSTEM_DATABASE_R","","",N,N],[17,"_SC_USER_GROUPS","","",N,N],[17,"_SC_USER_GROUPS_R","","",N,N],[17,"_SC_LEVEL1_ICACHE_SIZE","","",N,N],[17,"_SC_LEVEL1_ICACHE_ASSOC","","",N,N],[17,"_SC_LEVEL1_ICACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL1_DCACHE_SIZE","","",N,N],[17,"_SC_LEVEL1_DCACHE_ASSOC","","",N,N],[17,"_SC_LEVEL1_DCACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL2_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL2_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL2_CACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL3_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL3_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL3_CACHE_LINESIZE","","",N,N],[17,"_SC_LEVEL4_CACHE_SIZE","","",N,N],[17,"_SC_LEVEL4_CACHE_ASSOC","","",N,N],[17,"_SC_LEVEL4_CACHE_LINESIZE","","",N,N],[17,"O_ACCMODE","","",N,N],[17,"ST_RELATIME","","",N,N],[17,"NI_MAXHOST","","",N,N],[17,"ADFS_SUPER_MAGIC","","",N,N],[17,"AFFS_SUPER_MAGIC","","",N,N],[17,"CODA_SUPER_MAGIC","","",N,N],[17,"CRAMFS_MAGIC","","",N,N],[17,"EFS_SUPER_MAGIC","","",N,N],[17,"EXT2_SUPER_MAGIC","","",N,N],[17,"EXT3_SUPER_MAGIC","","",N,N],[17,"EXT4_SUPER_MAGIC","","",N,N],[17,"HPFS_SUPER_MAGIC","","",N,N],[17,"HUGETLBFS_MAGIC","","",N,N],[17,"ISOFS_SUPER_MAGIC","","",N,N],[17,"JFFS2_SUPER_MAGIC","","",N,N],[17,"MINIX_SUPER_MAGIC","","",N,N],[17,"MINIX_SUPER_MAGIC2","","",N,N],[17,"MINIX2_SUPER_MAGIC","","",N,N],[17,"MINIX2_SUPER_MAGIC2","","",N,N],[17,"MSDOS_SUPER_MAGIC","","",N,N],[17,"NCP_SUPER_MAGIC","","",N,N],[17,"NFS_SUPER_MAGIC","","",N,N],[17,"OPENPROM_SUPER_MAGIC","","",N,N],[17,"PROC_SUPER_MAGIC","","",N,N],[17,"QNX4_SUPER_MAGIC","","",N,N],[17,"REISERFS_SUPER_MAGIC","","",N,N],[17,"SMB_SUPER_MAGIC","","",N,N],[17,"TMPFS_MAGIC","","",N,N],[17,"USBDEVICE_SUPER_MAGIC","","",N,N],[17,"VEOF","","",N,N],[17,"CPU_SETSIZE","","",N,N],[17,"PTRACE_TRACEME","","",N,N],[17,"PTRACE_PEEKTEXT","","",N,N],[17,"PTRACE_PEEKDATA","","",N,N],[17,"PTRACE_PEEKUSER","","",N,N],[17,"PTRACE_POKETEXT","","",N,N],[17,"PTRACE_POKEDATA","","",N,N],[17,"PTRACE_POKEUSER","","",N,N],[17,"PTRACE_CONT","","",N,N],[17,"PTRACE_KILL","","",N,N],[17,"PTRACE_SINGLESTEP","","",N,N],[17,"PTRACE_ATTACH","","",N,N],[17,"PTRACE_SYSCALL","","",N,N],[17,"PTRACE_SETOPTIONS","","",N,N],[17,"PTRACE_GETEVENTMSG","","",N,N],[17,"PTRACE_GETSIGINFO","","",N,N],[17,"PTRACE_SETSIGINFO","","",N,N],[17,"PTRACE_GETREGSET","","",N,N],[17,"PTRACE_SETREGSET","","",N,N],[17,"PTRACE_SEIZE","","",N,N],[17,"PTRACE_INTERRUPT","","",N,N],[17,"PTRACE_LISTEN","","",N,N],[17,"PTRACE_PEEKSIGINFO","","",N,N],[17,"EPOLLWAKEUP","","",N,N],[17,"MAP_HUGETLB","","",N,N],[17,"SEEK_DATA","","",N,N],[17,"SEEK_HOLE","","",N,N],[17,"TCSANOW","","",N,N],[17,"TCSADRAIN","","",N,N],[17,"TCSAFLUSH","","",N,N],[17,"TIOCLINUX","","",N,N],[17,"TIOCGSERIAL","","",N,N],[17,"RTLD_DEEPBIND","","",N,N],[17,"RTLD_GLOBAL","","",N,N],[17,"RTLD_NOLOAD","","",N,N],[17,"LINUX_REBOOT_MAGIC1","","",N,N],[17,"LINUX_REBOOT_MAGIC2","","",N,N],[17,"LINUX_REBOOT_MAGIC2A","","",N,N],[17,"LINUX_REBOOT_MAGIC2B","","",N,N],[17,"LINUX_REBOOT_MAGIC2C","","",N,N],[17,"LINUX_REBOOT_CMD_RESTART","","",N,N],[17,"LINUX_REBOOT_CMD_HALT","","",N,N],[17,"LINUX_REBOOT_CMD_CAD_ON","","",N,N],[17,"LINUX_REBOOT_CMD_CAD_OFF","","",N,N],[17,"LINUX_REBOOT_CMD_POWER_OFF","","",N,N],[17,"LINUX_REBOOT_CMD_RESTART2","","",N,N],[17,"LINUX_REBOOT_CMD_SW_SUSPEND","","",N,N],[17,"LINUX_REBOOT_CMD_KEXEC","","",N,N],[17,"NETLINK_ROUTE","","",N,N],[17,"NETLINK_UNUSED","","",N,N],[17,"NETLINK_USERSOCK","","",N,N],[17,"NETLINK_FIREWALL","","",N,N],[17,"NETLINK_SOCK_DIAG","","",N,N],[17,"NETLINK_NFLOG","","",N,N],[17,"NETLINK_XFRM","","",N,N],[17,"NETLINK_SELINUX","","",N,N],[17,"NETLINK_ISCSI","","",N,N],[17,"NETLINK_AUDIT","","",N,N],[17,"NETLINK_FIB_LOOKUP","","",N,N],[17,"NETLINK_CONNECTOR","","",N,N],[17,"NETLINK_NETFILTER","","",N,N],[17,"NETLINK_IP6_FW","","",N,N],[17,"NETLINK_DNRTMSG","","",N,N],[17,"NETLINK_KOBJECT_UEVENT","","",N,N],[17,"NETLINK_GENERIC","","",N,N],[17,"NETLINK_SCSITRANSPORT","","",N,N],[17,"NETLINK_ECRYPTFS","","",N,N],[17,"NETLINK_RDMA","","",N,N],[17,"NETLINK_CRYPTO","","",N,N],[17,"NETLINK_INET_DIAG","","",N,N],[17,"MAX_LINKS","","",N,N],[17,"NLM_F_REQUEST","","",N,N],[17,"NLM_F_MULTI","","",N,N],[17,"NLM_F_ACK","","",N,N],[17,"NLM_F_ECHO","","",N,N],[17,"NLM_F_DUMP_INTR","","",N,N],[17,"NLM_F_DUMP_FILTERED","","",N,N],[17,"NLM_F_ROOT","","",N,N],[17,"NLM_F_MATCH","","",N,N],[17,"NLM_F_ATOMIC","","",N,N],[17,"NLM_F_DUMP","","",N,N],[17,"NLM_F_REPLACE","","",N,N],[17,"NLM_F_EXCL","","",N,N],[17,"NLM_F_CREATE","","",N,N],[17,"NLM_F_APPEND","","",N,N],[17,"NETLINK_ADD_MEMBERSHIP","","",N,N],[17,"NETLINK_DROP_MEMBERSHIP","","",N,N],[17,"NETLINK_PKTINFO","","",N,N],[17,"NETLINK_BROADCAST_ERROR","","",N,N],[17,"NETLINK_NO_ENOBUFS","","",N,N],[17,"NETLINK_RX_RING","","",N,N],[17,"NETLINK_TX_RING","","",N,N],[17,"NETLINK_LISTEN_ALL_NSID","","",N,N],[17,"NETLINK_LIST_MEMBERSHIPS","","",N,N],[17,"NETLINK_CAP_ACK","","",N,N],[17,"NLA_F_NESTED","","",N,N],[17,"NLA_F_NET_BYTEORDER","","",N,N],[17,"NLA_TYPE_MASK","","",N,N],[17,"NLA_ALIGNTO","","",N,N],[17,"GENL_UNS_ADMIN_PERM","","",N,N],[17,"GENL_ID_VFS_DQUOT","","",N,N],[17,"GENL_ID_PMCRAID","","",N,N],[17,"TIOCM_LE","","",N,N],[17,"TIOCM_DTR","","",N,N],[17,"TIOCM_RTS","","",N,N],[17,"TIOCM_ST","","",N,N],[17,"TIOCM_SR","","",N,N],[17,"TIOCM_CTS","","",N,N],[17,"TIOCM_CAR","","",N,N],[17,"TIOCM_RNG","","",N,N],[17,"TIOCM_DSR","","",N,N],[17,"TIOCM_CD","","",N,N],[17,"TIOCM_RI","","",N,N],[17,"NF_NETDEV_INGRESS","","",N,N],[17,"NF_NETDEV_NUMHOOKS","","",N,N],[17,"NFPROTO_INET","","",N,N],[17,"NFPROTO_NETDEV","","",N,N],[17,"NFT_TABLE_MAXNAMELEN","","",N,N],[17,"NFT_CHAIN_MAXNAMELEN","","",N,N],[17,"NFT_SET_MAXNAMELEN","","",N,N],[17,"NFT_OBJ_MAXNAMELEN","","",N,N],[17,"NFT_USERDATA_MAXLEN","","",N,N],[17,"NFT_REG_VERDICT","","",N,N],[17,"NFT_REG_1","","",N,N],[17,"NFT_REG_2","","",N,N],[17,"NFT_REG_3","","",N,N],[17,"NFT_REG_4","","",N,N],[17,"__NFT_REG_MAX","","",N,N],[17,"NFT_REG32_00","","",N,N],[17,"NFT_REG32_01","","",N,N],[17,"NFT_REG32_02","","",N,N],[17,"NFT_REG32_03","","",N,N],[17,"NFT_REG32_04","","",N,N],[17,"NFT_REG32_05","","",N,N],[17,"NFT_REG32_06","","",N,N],[17,"NFT_REG32_07","","",N,N],[17,"NFT_REG32_08","","",N,N],[17,"NFT_REG32_09","","",N,N],[17,"NFT_REG32_10","","",N,N],[17,"NFT_REG32_11","","",N,N],[17,"NFT_REG32_12","","",N,N],[17,"NFT_REG32_13","","",N,N],[17,"NFT_REG32_14","","",N,N],[17,"NFT_REG32_15","","",N,N],[17,"NFT_REG_SIZE","","",N,N],[17,"NFT_REG32_SIZE","","",N,N],[17,"NFT_CONTINUE","","",N,N],[17,"NFT_BREAK","","",N,N],[17,"NFT_JUMP","","",N,N],[17,"NFT_GOTO","","",N,N],[17,"NFT_RETURN","","",N,N],[17,"NFT_MSG_NEWTABLE","","",N,N],[17,"NFT_MSG_GETTABLE","","",N,N],[17,"NFT_MSG_DELTABLE","","",N,N],[17,"NFT_MSG_NEWCHAIN","","",N,N],[17,"NFT_MSG_GETCHAIN","","",N,N],[17,"NFT_MSG_DELCHAIN","","",N,N],[17,"NFT_MSG_NEWRULE","","",N,N],[17,"NFT_MSG_GETRULE","","",N,N],[17,"NFT_MSG_DELRULE","","",N,N],[17,"NFT_MSG_NEWSET","","",N,N],[17,"NFT_MSG_GETSET","","",N,N],[17,"NFT_MSG_DELSET","","",N,N],[17,"NFT_MSG_NEWSETELEM","","",N,N],[17,"NFT_MSG_GETSETELEM","","",N,N],[17,"NFT_MSG_DELSETELEM","","",N,N],[17,"NFT_MSG_NEWGEN","","",N,N],[17,"NFT_MSG_GETGEN","","",N,N],[17,"NFT_MSG_TRACE","","",N,N],[17,"NFT_MSG_NEWOBJ","","",N,N],[17,"NFT_MSG_GETOBJ","","",N,N],[17,"NFT_MSG_DELOBJ","","",N,N],[17,"NFT_MSG_GETOBJ_RESET","","",N,N],[17,"NFT_MSG_MAX","","",N,N],[17,"NFT_SET_ANONYMOUS","","",N,N],[17,"NFT_SET_CONSTANT","","",N,N],[17,"NFT_SET_INTERVAL","","",N,N],[17,"NFT_SET_MAP","","",N,N],[17,"NFT_SET_TIMEOUT","","",N,N],[17,"NFT_SET_EVAL","","",N,N],[17,"NFT_SET_POL_PERFORMANCE","","",N,N],[17,"NFT_SET_POL_MEMORY","","",N,N],[17,"NFT_SET_ELEM_INTERVAL_END","","",N,N],[17,"NFT_DATA_VALUE","","",N,N],[17,"NFT_DATA_VERDICT","","",N,N],[17,"NFT_DATA_RESERVED_MASK","","",N,N],[17,"NFT_DATA_VALUE_MAXLEN","","",N,N],[17,"NFT_BYTEORDER_NTOH","","",N,N],[17,"NFT_BYTEORDER_HTON","","",N,N],[17,"NFT_CMP_EQ","","",N,N],[17,"NFT_CMP_NEQ","","",N,N],[17,"NFT_CMP_LT","","",N,N],[17,"NFT_CMP_LTE","","",N,N],[17,"NFT_CMP_GT","","",N,N],[17,"NFT_CMP_GTE","","",N,N],[17,"NFT_RANGE_EQ","","",N,N],[17,"NFT_RANGE_NEQ","","",N,N],[17,"NFT_LOOKUP_F_INV","","",N,N],[17,"NFT_DYNSET_OP_ADD","","",N,N],[17,"NFT_DYNSET_OP_UPDATE","","",N,N],[17,"NFT_DYNSET_F_INV","","",N,N],[17,"NFT_PAYLOAD_LL_HEADER","","",N,N],[17,"NFT_PAYLOAD_NETWORK_HEADER","","",N,N],[17,"NFT_PAYLOAD_TRANSPORT_HEADER","","",N,N],[17,"NFT_PAYLOAD_CSUM_NONE","","",N,N],[17,"NFT_PAYLOAD_CSUM_INET","","",N,N],[17,"NFT_META_LEN","","",N,N],[17,"NFT_META_PROTOCOL","","",N,N],[17,"NFT_META_PRIORITY","","",N,N],[17,"NFT_META_MARK","","",N,N],[17,"NFT_META_IIF","","",N,N],[17,"NFT_META_OIF","","",N,N],[17,"NFT_META_IIFNAME","","",N,N],[17,"NFT_META_OIFNAME","","",N,N],[17,"NFT_META_IIFTYPE","","",N,N],[17,"NFT_META_OIFTYPE","","",N,N],[17,"NFT_META_SKUID","","",N,N],[17,"NFT_META_SKGID","","",N,N],[17,"NFT_META_NFTRACE","","",N,N],[17,"NFT_META_RTCLASSID","","",N,N],[17,"NFT_META_SECMARK","","",N,N],[17,"NFT_META_NFPROTO","","",N,N],[17,"NFT_META_L4PROTO","","",N,N],[17,"NFT_META_BRI_IIFNAME","","",N,N],[17,"NFT_META_BRI_OIFNAME","","",N,N],[17,"NFT_META_PKTTYPE","","",N,N],[17,"NFT_META_CPU","","",N,N],[17,"NFT_META_IIFGROUP","","",N,N],[17,"NFT_META_OIFGROUP","","",N,N],[17,"NFT_META_CGROUP","","",N,N],[17,"NFT_META_PRANDOM","","",N,N],[17,"NFT_CT_STATE","","",N,N],[17,"NFT_CT_DIRECTION","","",N,N],[17,"NFT_CT_STATUS","","",N,N],[17,"NFT_CT_MARK","","",N,N],[17,"NFT_CT_SECMARK","","",N,N],[17,"NFT_CT_EXPIRATION","","",N,N],[17,"NFT_CT_HELPER","","",N,N],[17,"NFT_CT_L3PROTOCOL","","",N,N],[17,"NFT_CT_SRC","","",N,N],[17,"NFT_CT_DST","","",N,N],[17,"NFT_CT_PROTOCOL","","",N,N],[17,"NFT_CT_PROTO_SRC","","",N,N],[17,"NFT_CT_PROTO_DST","","",N,N],[17,"NFT_CT_LABELS","","",N,N],[17,"NFT_CT_PKTS","","",N,N],[17,"NFT_CT_BYTES","","",N,N],[17,"NFT_LIMIT_PKTS","","",N,N],[17,"NFT_LIMIT_PKT_BYTES","","",N,N],[17,"NFT_LIMIT_F_INV","","",N,N],[17,"NFT_QUEUE_FLAG_BYPASS","","",N,N],[17,"NFT_QUEUE_FLAG_CPU_FANOUT","","",N,N],[17,"NFT_QUEUE_FLAG_MASK","","",N,N],[17,"NFT_QUOTA_F_INV","","",N,N],[17,"NFT_REJECT_ICMP_UNREACH","","",N,N],[17,"NFT_REJECT_TCP_RST","","",N,N],[17,"NFT_REJECT_ICMPX_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_NO_ROUTE","","",N,N],[17,"NFT_REJECT_ICMPX_PORT_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_HOST_UNREACH","","",N,N],[17,"NFT_REJECT_ICMPX_ADMIN_PROHIBITED","","",N,N],[17,"NFT_NAT_SNAT","","",N,N],[17,"NFT_NAT_DNAT","","",N,N],[17,"NFT_TRACETYPE_UNSPEC","","",N,N],[17,"NFT_TRACETYPE_POLICY","","",N,N],[17,"NFT_TRACETYPE_RETURN","","",N,N],[17,"NFT_TRACETYPE_RULE","","",N,N],[17,"NFT_NG_INCREMENTAL","","",N,N],[17,"NFT_NG_RANDOM","","",N,N],[17,"AF_MAX","","",N,N],[17,"PF_MAX","","",N,N],[17,"PTHREAD_STACK_MIN","","",N,N],[17,"PTHREAD_MUTEX_ADAPTIVE_NP","","",N,N],[17,"__SIZEOF_PTHREAD_RWLOCKATTR_T","","",N,N],[17,"O_LARGEFILE","","",N,N],[17,"TIOCGSOFTCAR","","",N,N],[17,"TIOCSSOFTCAR","","",N,N],[17,"RLIMIT_NOFILE","","",N,N],[17,"RLIMIT_NPROC","","",N,N],[17,"O_APPEND","","",N,N],[17,"O_CREAT","","",N,N],[17,"O_EXCL","","",N,N],[17,"O_NOCTTY","","",N,N],[17,"O_NONBLOCK","","",N,N],[17,"O_SYNC","","",N,N],[17,"O_RSYNC","","",N,N],[17,"O_DSYNC","","",N,N],[17,"O_FSYNC","","",N,N],[17,"O_NOATIME","","",N,N],[17,"O_PATH","","",N,N],[17,"O_TMPFILE","","",N,N],[17,"MAP_GROWSDOWN","","",N,N],[17,"EDEADLK","","",N,N],[17,"ENAMETOOLONG","","",N,N],[17,"ENOLCK","","",N,N],[17,"ENOSYS","","",N,N],[17,"ENOTEMPTY","","",N,N],[17,"ELOOP","","",N,N],[17,"ENOMSG","","",N,N],[17,"EIDRM","","",N,N],[17,"ECHRNG","","",N,N],[17,"EL2NSYNC","","",N,N],[17,"EL3HLT","","",N,N],[17,"EL3RST","","",N,N],[17,"ELNRNG","","",N,N],[17,"EUNATCH","","",N,N],[17,"ENOCSI","","",N,N],[17,"EL2HLT","","",N,N],[17,"EBADE","","",N,N],[17,"EBADR","","",N,N],[17,"EXFULL","","",N,N],[17,"ENOANO","","",N,N],[17,"EBADRQC","","",N,N],[17,"EBADSLT","","",N,N],[17,"EMULTIHOP","","",N,N],[17,"EOVERFLOW","","",N,N],[17,"ENOTUNIQ","","",N,N],[17,"EBADFD","","",N,N],[17,"EBADMSG","","",N,N],[17,"EREMCHG","","",N,N],[17,"ELIBACC","","",N,N],[17,"ELIBBAD","","",N,N],[17,"ELIBSCN","","",N,N],[17,"ELIBMAX","","",N,N],[17,"ELIBEXEC","","",N,N],[17,"EILSEQ","","",N,N],[17,"ERESTART","","",N,N],[17,"ESTRPIPE","","",N,N],[17,"EUSERS","","",N,N],[17,"ENOTSOCK","","",N,N],[17,"EDESTADDRREQ","","",N,N],[17,"EMSGSIZE","","",N,N],[17,"EPROTOTYPE","","",N,N],[17,"ENOPROTOOPT","","",N,N],[17,"EPROTONOSUPPORT","","",N,N],[17,"ESOCKTNOSUPPORT","","",N,N],[17,"EOPNOTSUPP","","",N,N],[17,"EPFNOSUPPORT","","",N,N],[17,"EAFNOSUPPORT","","",N,N],[17,"EADDRINUSE","","",N,N],[17,"EADDRNOTAVAIL","","",N,N],[17,"ENETDOWN","","",N,N],[17,"ENETUNREACH","","",N,N],[17,"ENETRESET","","",N,N],[17,"ECONNABORTED","","",N,N],[17,"ECONNRESET","","",N,N],[17,"ENOBUFS","","",N,N],[17,"EISCONN","","",N,N],[17,"ENOTCONN","","",N,N],[17,"ESHUTDOWN","","",N,N],[17,"ETOOMANYREFS","","",N,N],[17,"ETIMEDOUT","","",N,N],[17,"ECONNREFUSED","","",N,N],[17,"EHOSTDOWN","","",N,N],[17,"EHOSTUNREACH","","",N,N],[17,"EALREADY","","",N,N],[17,"EINPROGRESS","","",N,N],[17,"ESTALE","","",N,N],[17,"EDQUOT","","",N,N],[17,"ENOMEDIUM","","",N,N],[17,"EMEDIUMTYPE","","",N,N],[17,"ECANCELED","","",N,N],[17,"ENOKEY","","",N,N],[17,"EKEYEXPIRED","","",N,N],[17,"EKEYREVOKED","","",N,N],[17,"EKEYREJECTED","","",N,N],[17,"EOWNERDEAD","","",N,N],[17,"ENOTRECOVERABLE","","",N,N],[17,"EHWPOISON","","",N,N],[17,"ERFKILL","","",N,N],[17,"SOL_SOCKET","","",N,N],[17,"SO_REUSEADDR","","",N,N],[17,"SO_TYPE","","",N,N],[17,"SO_ERROR","","",N,N],[17,"SO_DONTROUTE","","",N,N],[17,"SO_BROADCAST","","",N,N],[17,"SO_SNDBUF","","",N,N],[17,"SO_RCVBUF","","",N,N],[17,"SO_SNDBUFFORCE","","",N,N],[17,"SO_RCVBUFFORCE","","",N,N],[17,"SO_KEEPALIVE","","",N,N],[17,"SO_OOBINLINE","","",N,N],[17,"SO_NO_CHECK","","",N,N],[17,"SO_PRIORITY","","",N,N],[17,"SO_LINGER","","",N,N],[17,"SO_BSDCOMPAT","","",N,N],[17,"SO_REUSEPORT","","",N,N],[17,"SO_PASSCRED","","",N,N],[17,"SO_PEERCRED","","",N,N],[17,"SO_RCVLOWAT","","",N,N],[17,"SO_SNDLOWAT","","",N,N],[17,"SO_RCVTIMEO","","",N,N],[17,"SO_SNDTIMEO","","",N,N],[17,"SO_SECURITY_AUTHENTICATION","","",N,N],[17,"SO_SECURITY_ENCRYPTION_TRANSPORT","","",N,N],[17,"SO_SECURITY_ENCRYPTION_NETWORK","","",N,N],[17,"SO_BINDTODEVICE","","",N,N],[17,"SO_ATTACH_FILTER","","",N,N],[17,"SO_DETACH_FILTER","","",N,N],[17,"SO_GET_FILTER","","",N,N],[17,"SO_PEERNAME","","",N,N],[17,"SO_TIMESTAMP","","",N,N],[17,"SO_ACCEPTCONN","","",N,N],[17,"SO_PEERSEC","","",N,N],[17,"SO_PASSSEC","","",N,N],[17,"SO_TIMESTAMPNS","","",N,N],[17,"SCM_TIMESTAMPNS","","",N,N],[17,"SO_MARK","","",N,N],[17,"SO_TIMESTAMPING","","",N,N],[17,"SCM_TIMESTAMPING","","",N,N],[17,"SO_PROTOCOL","","",N,N],[17,"SO_DOMAIN","","",N,N],[17,"SO_RXQ_OVFL","","",N,N],[17,"SO_WIFI_STATUS","","",N,N],[17,"SCM_WIFI_STATUS","","",N,N],[17,"SO_PEEK_OFF","","",N,N],[17,"SO_NOFCS","","",N,N],[17,"SO_LOCK_FILTER","","",N,N],[17,"SO_SELECT_ERR_QUEUE","","",N,N],[17,"SO_BUSY_POLL","","",N,N],[17,"SO_MAX_PACING_RATE","","",N,N],[17,"SO_BPF_EXTENSIONS","","",N,N],[17,"SO_INCOMING_CPU","","",N,N],[17,"SO_ATTACH_BPF","","",N,N],[17,"SO_DETACH_BPF","","",N,N],[17,"SA_ONSTACK","","",N,N],[17,"SA_SIGINFO","","",N,N],[17,"SA_NOCLDWAIT","","",N,N],[17,"SIGCHLD","","",N,N],[17,"SIGBUS","","",N,N],[17,"SIGUSR1","","",N,N],[17,"SIGUSR2","","",N,N],[17,"SIGCONT","","",N,N],[17,"SIGSTOP","","",N,N],[17,"SIGTSTP","","",N,N],[17,"SIGURG","","",N,N],[17,"SIGIO","","",N,N],[17,"SIGSYS","","",N,N],[17,"SIGSTKFLT","","",N,N],[17,"SIGUNUSED","","",N,N],[17,"SIGPOLL","","",N,N],[17,"SIGPWR","","",N,N],[17,"SIG_SETMASK","","",N,N],[17,"SIG_BLOCK","","",N,N],[17,"SIG_UNBLOCK","","",N,N],[17,"POLLWRNORM","","",N,N],[17,"POLLWRBAND","","",N,N],[17,"O_ASYNC","","",N,N],[17,"O_NDELAY","","",N,N],[17,"PTRACE_DETACH","","",N,N],[17,"EFD_NONBLOCK","","",N,N],[17,"F_GETLK","","",N,N],[17,"F_GETOWN","","",N,N],[17,"F_SETOWN","","",N,N],[17,"F_SETLK","","",N,N],[17,"F_SETLKW","","",N,N],[17,"F_RDLCK","","",N,N],[17,"F_WRLCK","","",N,N],[17,"F_UNLCK","","",N,N],[17,"SFD_NONBLOCK","","",N,N],[17,"TIOCEXCL","","",N,N],[17,"TIOCNXCL","","",N,N],[17,"TIOCSCTTY","","",N,N],[17,"TIOCSTI","","",N,N],[17,"TIOCMGET","","",N,N],[17,"TIOCMBIS","","",N,N],[17,"TIOCMBIC","","",N,N],[17,"TIOCMSET","","",N,N],[17,"TIOCCONS","","",N,N],[17,"SFD_CLOEXEC","","",N,N],[17,"NCCS","","",N,N],[17,"O_TRUNC","","",N,N],[17,"O_CLOEXEC","","",N,N],[17,"EBFONT","","",N,N],[17,"ENOSTR","","",N,N],[17,"ENODATA","","",N,N],[17,"ETIME","","",N,N],[17,"ENOSR","","",N,N],[17,"ENONET","","",N,N],[17,"ENOPKG","","",N,N],[17,"EREMOTE","","",N,N],[17,"ENOLINK","","",N,N],[17,"EADV","","",N,N],[17,"ESRMNT","","",N,N],[17,"ECOMM","","",N,N],[17,"EPROTO","","",N,N],[17,"EDOTDOT","","",N,N],[17,"SA_NODEFER","","",N,N],[17,"SA_RESETHAND","","",N,N],[17,"SA_RESTART","","",N,N],[17,"SA_NOCLDSTOP","","",N,N],[17,"EPOLL_CLOEXEC","","",N,N],[17,"EFD_CLOEXEC","","",N,N],[17,"__SIZEOF_PTHREAD_CONDATTR_T","","",N,N],[17,"__SIZEOF_PTHREAD_MUTEXATTR_T","","",N,N],[17,"O_DIRECT","","",N,N],[17,"O_DIRECTORY","","",N,N],[17,"O_NOFOLLOW","","",N,N],[17,"MAP_LOCKED","","",N,N],[17,"MAP_NORESERVE","","",N,N],[17,"MAP_32BIT","","",N,N],[17,"EDEADLOCK","","",N,N],[17,"FIOCLEX","","",N,N],[17,"FIONBIO","","",N,N],[17,"PTRACE_GETFPREGS","","",N,N],[17,"PTRACE_SETFPREGS","","",N,N],[17,"PTRACE_GETFPXREGS","","",N,N],[17,"PTRACE_SETFPXREGS","","",N,N],[17,"PTRACE_GETREGS","","",N,N],[17,"PTRACE_SETREGS","","",N,N],[17,"PTRACE_PEEKSIGINFO_SHARED","","",N,N],[17,"MCL_CURRENT","","",N,N],[17,"MCL_FUTURE","","",N,N],[17,"SIGSTKSZ","","",N,N],[17,"MINSIGSTKSZ","","",N,N],[17,"CBAUD","","",N,N],[17,"TAB1","","",N,N],[17,"TAB2","","",N,N],[17,"TAB3","","",N,N],[17,"CR1","","",N,N],[17,"CR2","","",N,N],[17,"CR3","","",N,N],[17,"FF1","","",N,N],[17,"BS1","","",N,N],[17,"VT1","","",N,N],[17,"VWERASE","","",N,N],[17,"VREPRINT","","",N,N],[17,"VSUSP","","",N,N],[17,"VSTART","","",N,N],[17,"VSTOP","","",N,N],[17,"VDISCARD","","",N,N],[17,"VTIME","","",N,N],[17,"IXON","","",N,N],[17,"IXOFF","","",N,N],[17,"ONLCR","","",N,N],[17,"CSIZE","","",N,N],[17,"CS6","","",N,N],[17,"CS7","","",N,N],[17,"CS8","","",N,N],[17,"CSTOPB","","",N,N],[17,"CREAD","","",N,N],[17,"PARENB","","",N,N],[17,"PARODD","","",N,N],[17,"HUPCL","","",N,N],[17,"CLOCAL","","",N,N],[17,"ECHOKE","","",N,N],[17,"ECHOE","","",N,N],[17,"ECHOK","","",N,N],[17,"ECHONL","","",N,N],[17,"ECHOPRT","","",N,N],[17,"ECHOCTL","","",N,N],[17,"ISIG","","",N,N],[17,"ICANON","","",N,N],[17,"PENDIN","","",N,N],[17,"NOFLSH","","",N,N],[17,"CIBAUD","","",N,N],[17,"CBAUDEX","","",N,N],[17,"VSWTC","","",N,N],[17,"OLCUC","","",N,N],[17,"NLDLY","","",N,N],[17,"CRDLY","","",N,N],[17,"TABDLY","","",N,N],[17,"BSDLY","","",N,N],[17,"FFDLY","","",N,N],[17,"VTDLY","","",N,N],[17,"XTABS","","",N,N],[17,"B0","","",N,N],[17,"B50","","",N,N],[17,"B75","","",N,N],[17,"B110","","",N,N],[17,"B134","","",N,N],[17,"B150","","",N,N],[17,"B200","","",N,N],[17,"B300","","",N,N],[17,"B600","","",N,N],[17,"B1200","","",N,N],[17,"B1800","","",N,N],[17,"B2400","","",N,N],[17,"B4800","","",N,N],[17,"B9600","","",N,N],[17,"B19200","","",N,N],[17,"B38400","","",N,N],[17,"EXTA","","",N,N],[17,"EXTB","","",N,N],[17,"BOTHER","","",N,N],[17,"B57600","","",N,N],[17,"B115200","","",N,N],[17,"B230400","","",N,N],[17,"B460800","","",N,N],[17,"B500000","","",N,N],[17,"B576000","","",N,N],[17,"B921600","","",N,N],[17,"B1000000","","",N,N],[17,"B1152000","","",N,N],[17,"B1500000","","",N,N],[17,"B2000000","","",N,N],[17,"B2500000","","",N,N],[17,"B3000000","","",N,N],[17,"B3500000","","",N,N],[17,"B4000000","","",N,N],[17,"VEOL","","",N,N],[17,"VEOL2","","",N,N],[17,"VMIN","","",N,N],[17,"IEXTEN","","",N,N],[17,"TOSTOP","","",N,N],[17,"FLUSHO","","",N,N],[17,"EXTPROC","","",N,N],[17,"TCGETS","","",N,N],[17,"TCSETS","","",N,N],[17,"TCSETSW","","",N,N],[17,"TCSETSF","","",N,N],[17,"TCGETA","","",N,N],[17,"TCSETA","","",N,N],[17,"TCSETAW","","",N,N],[17,"TCSETAF","","",N,N],[17,"TCSBRK","","",N,N],[17,"TCXONC","","",N,N],[17,"TCFLSH","","",N,N],[17,"TIOCINQ","","",N,N],[17,"TIOCGPGRP","","",N,N],[17,"TIOCSPGRP","","",N,N],[17,"TIOCOUTQ","","",N,N],[17,"TIOCGWINSZ","","",N,N],[17,"TIOCSWINSZ","","",N,N],[17,"FIONREAD","","",N,N],[17,"R15","","",N,N],[17,"R14","","",N,N],[17,"R13","","",N,N],[17,"R12","","",N,N],[17,"RBP","","",N,N],[17,"RBX","","",N,N],[17,"R11","","",N,N],[17,"R10","","",N,N],[17,"R9","","",N,N],[17,"R8","","",N,N],[17,"RAX","","",N,N],[17,"RCX","","",N,N],[17,"RDX","","",N,N],[17,"RSI","","",N,N],[17,"RDI","","",N,N],[17,"ORIG_RAX","","",N,N],[17,"RIP","","",N,N],[17,"CS","","",N,N],[17,"EFLAGS","","",N,N],[17,"RSP","","",N,N],[17,"SS","","",N,N],[17,"FS_BASE","","",N,N],[17,"GS_BASE","","",N,N],[17,"DS","","",N,N],[17,"ES","","",N,N],[17,"FS","","",N,N],[17,"GS","","",N,N],[17,"__SIZEOF_PTHREAD_MUTEX_T","","",N,N],[17,"__SIZEOF_PTHREAD_RWLOCK_T","","",N,N],[17,"PTHREAD_RECURSIVE_MUTEX_INITIALIZER_NP","","",N,N],[17,"PTHREAD_ERRORCHECK_MUTEX_INITIALIZER_NP","","",N,N],[17,"PTHREAD_ADAPTIVE_MUTEX_INITIALIZER_NP","","",N,N],[17,"SYS_read","","",N,N],[17,"SYS_write","","",N,N],[17,"SYS_open","","",N,N],[17,"SYS_close","","",N,N],[17,"SYS_stat","","",N,N],[17,"SYS_fstat","","",N,N],[17,"SYS_lstat","","",N,N],[17,"SYS_poll","","",N,N],[17,"SYS_lseek","","",N,N],[17,"SYS_mmap","","",N,N],[17,"SYS_mprotect","","",N,N],[17,"SYS_munmap","","",N,N],[17,"SYS_brk","","",N,N],[17,"SYS_rt_sigaction","","",N,N],[17,"SYS_rt_sigprocmask","","",N,N],[17,"SYS_rt_sigreturn","","",N,N],[17,"SYS_ioctl","","",N,N],[17,"SYS_pread64","","",N,N],[17,"SYS_pwrite64","","",N,N],[17,"SYS_readv","","",N,N],[17,"SYS_writev","","",N,N],[17,"SYS_access","","",N,N],[17,"SYS_pipe","","",N,N],[17,"SYS_select","","",N,N],[17,"SYS_sched_yield","","",N,N],[17,"SYS_mremap","","",N,N],[17,"SYS_msync","","",N,N],[17,"SYS_mincore","","",N,N],[17,"SYS_madvise","","",N,N],[17,"SYS_shmget","","",N,N],[17,"SYS_shmat","","",N,N],[17,"SYS_shmctl","","",N,N],[17,"SYS_dup","","",N,N],[17,"SYS_dup2","","",N,N],[17,"SYS_pause","","",N,N],[17,"SYS_nanosleep","","",N,N],[17,"SYS_getitimer","","",N,N],[17,"SYS_alarm","","",N,N],[17,"SYS_setitimer","","",N,N],[17,"SYS_getpid","","",N,N],[17,"SYS_sendfile","","",N,N],[17,"SYS_socket","","",N,N],[17,"SYS_connect","","",N,N],[17,"SYS_accept","","",N,N],[17,"SYS_sendto","","",N,N],[17,"SYS_recvfrom","","",N,N],[17,"SYS_sendmsg","","",N,N],[17,"SYS_recvmsg","","",N,N],[17,"SYS_shutdown","","",N,N],[17,"SYS_bind","","",N,N],[17,"SYS_listen","","",N,N],[17,"SYS_getsockname","","",N,N],[17,"SYS_getpeername","","",N,N],[17,"SYS_socketpair","","",N,N],[17,"SYS_setsockopt","","",N,N],[17,"SYS_getsockopt","","",N,N],[17,"SYS_clone","","",N,N],[17,"SYS_fork","","",N,N],[17,"SYS_vfork","","",N,N],[17,"SYS_execve","","",N,N],[17,"SYS_exit","","",N,N],[17,"SYS_wait4","","",N,N],[17,"SYS_kill","","",N,N],[17,"SYS_uname","","",N,N],[17,"SYS_semget","","",N,N],[17,"SYS_semop","","",N,N],[17,"SYS_semctl","","",N,N],[17,"SYS_shmdt","","",N,N],[17,"SYS_msgget","","",N,N],[17,"SYS_msgsnd","","",N,N],[17,"SYS_msgrcv","","",N,N],[17,"SYS_msgctl","","",N,N],[17,"SYS_fcntl","","",N,N],[17,"SYS_flock","","",N,N],[17,"SYS_fsync","","",N,N],[17,"SYS_fdatasync","","",N,N],[17,"SYS_truncate","","",N,N],[17,"SYS_ftruncate","","",N,N],[17,"SYS_getdents","","",N,N],[17,"SYS_getcwd","","",N,N],[17,"SYS_chdir","","",N,N],[17,"SYS_fchdir","","",N,N],[17,"SYS_rename","","",N,N],[17,"SYS_mkdir","","",N,N],[17,"SYS_rmdir","","",N,N],[17,"SYS_creat","","",N,N],[17,"SYS_link","","",N,N],[17,"SYS_unlink","","",N,N],[17,"SYS_symlink","","",N,N],[17,"SYS_readlink","","",N,N],[17,"SYS_chmod","","",N,N],[17,"SYS_fchmod","","",N,N],[17,"SYS_chown","","",N,N],[17,"SYS_fchown","","",N,N],[17,"SYS_lchown","","",N,N],[17,"SYS_umask","","",N,N],[17,"SYS_gettimeofday","","",N,N],[17,"SYS_getrlimit","","",N,N],[17,"SYS_getrusage","","",N,N],[17,"SYS_sysinfo","","",N,N],[17,"SYS_times","","",N,N],[17,"SYS_ptrace","","",N,N],[17,"SYS_getuid","","",N,N],[17,"SYS_syslog","","",N,N],[17,"SYS_getgid","","",N,N],[17,"SYS_setuid","","",N,N],[17,"SYS_setgid","","",N,N],[17,"SYS_geteuid","","",N,N],[17,"SYS_getegid","","",N,N],[17,"SYS_setpgid","","",N,N],[17,"SYS_getppid","","",N,N],[17,"SYS_getpgrp","","",N,N],[17,"SYS_setsid","","",N,N],[17,"SYS_setreuid","","",N,N],[17,"SYS_setregid","","",N,N],[17,"SYS_getgroups","","",N,N],[17,"SYS_setgroups","","",N,N],[17,"SYS_setresuid","","",N,N],[17,"SYS_getresuid","","",N,N],[17,"SYS_setresgid","","",N,N],[17,"SYS_getresgid","","",N,N],[17,"SYS_getpgid","","",N,N],[17,"SYS_setfsuid","","",N,N],[17,"SYS_setfsgid","","",N,N],[17,"SYS_getsid","","",N,N],[17,"SYS_capget","","",N,N],[17,"SYS_capset","","",N,N],[17,"SYS_rt_sigpending","","",N,N],[17,"SYS_rt_sigtimedwait","","",N,N],[17,"SYS_rt_sigqueueinfo","","",N,N],[17,"SYS_rt_sigsuspend","","",N,N],[17,"SYS_sigaltstack","","",N,N],[17,"SYS_utime","","",N,N],[17,"SYS_mknod","","",N,N],[17,"SYS_uselib","","",N,N],[17,"SYS_personality","","",N,N],[17,"SYS_ustat","","",N,N],[17,"SYS_statfs","","",N,N],[17,"SYS_fstatfs","","",N,N],[17,"SYS_sysfs","","",N,N],[17,"SYS_getpriority","","",N,N],[17,"SYS_setpriority","","",N,N],[17,"SYS_sched_setparam","","",N,N],[17,"SYS_sched_getparam","","",N,N],[17,"SYS_sched_setscheduler","","",N,N],[17,"SYS_sched_getscheduler","","",N,N],[17,"SYS_sched_get_priority_max","","",N,N],[17,"SYS_sched_get_priority_min","","",N,N],[17,"SYS_sched_rr_get_interval","","",N,N],[17,"SYS_mlock","","",N,N],[17,"SYS_munlock","","",N,N],[17,"SYS_mlockall","","",N,N],[17,"SYS_munlockall","","",N,N],[17,"SYS_vhangup","","",N,N],[17,"SYS_modify_ldt","","",N,N],[17,"SYS_pivot_root","","",N,N],[17,"SYS__sysctl","","",N,N],[17,"SYS_prctl","","",N,N],[17,"SYS_arch_prctl","","",N,N],[17,"SYS_adjtimex","","",N,N],[17,"SYS_setrlimit","","",N,N],[17,"SYS_chroot","","",N,N],[17,"SYS_sync","","",N,N],[17,"SYS_acct","","",N,N],[17,"SYS_settimeofday","","",N,N],[17,"SYS_mount","","",N,N],[17,"SYS_umount2","","",N,N],[17,"SYS_swapon","","",N,N],[17,"SYS_swapoff","","",N,N],[17,"SYS_reboot","","",N,N],[17,"SYS_sethostname","","",N,N],[17,"SYS_setdomainname","","",N,N],[17,"SYS_iopl","","",N,N],[17,"SYS_ioperm","","",N,N],[17,"SYS_create_module","","",N,N],[17,"SYS_init_module","","",N,N],[17,"SYS_delete_module","","",N,N],[17,"SYS_get_kernel_syms","","",N,N],[17,"SYS_query_module","","",N,N],[17,"SYS_quotactl","","",N,N],[17,"SYS_nfsservctl","","",N,N],[17,"SYS_getpmsg","","",N,N],[17,"SYS_putpmsg","","",N,N],[17,"SYS_afs_syscall","","",N,N],[17,"SYS_tuxcall","","",N,N],[17,"SYS_security","","",N,N],[17,"SYS_gettid","","",N,N],[17,"SYS_readahead","","",N,N],[17,"SYS_setxattr","","",N,N],[17,"SYS_lsetxattr","","",N,N],[17,"SYS_fsetxattr","","",N,N],[17,"SYS_getxattr","","",N,N],[17,"SYS_lgetxattr","","",N,N],[17,"SYS_fgetxattr","","",N,N],[17,"SYS_listxattr","","",N,N],[17,"SYS_llistxattr","","",N,N],[17,"SYS_flistxattr","","",N,N],[17,"SYS_removexattr","","",N,N],[17,"SYS_lremovexattr","","",N,N],[17,"SYS_fremovexattr","","",N,N],[17,"SYS_tkill","","",N,N],[17,"SYS_time","","",N,N],[17,"SYS_futex","","",N,N],[17,"SYS_sched_setaffinity","","",N,N],[17,"SYS_sched_getaffinity","","",N,N],[17,"SYS_set_thread_area","","",N,N],[17,"SYS_io_setup","","",N,N],[17,"SYS_io_destroy","","",N,N],[17,"SYS_io_getevents","","",N,N],[17,"SYS_io_submit","","",N,N],[17,"SYS_io_cancel","","",N,N],[17,"SYS_get_thread_area","","",N,N],[17,"SYS_lookup_dcookie","","",N,N],[17,"SYS_epoll_create","","",N,N],[17,"SYS_epoll_ctl_old","","",N,N],[17,"SYS_epoll_wait_old","","",N,N],[17,"SYS_remap_file_pages","","",N,N],[17,"SYS_getdents64","","",N,N],[17,"SYS_set_tid_address","","",N,N],[17,"SYS_restart_syscall","","",N,N],[17,"SYS_semtimedop","","",N,N],[17,"SYS_fadvise64","","",N,N],[17,"SYS_timer_create","","",N,N],[17,"SYS_timer_settime","","",N,N],[17,"SYS_timer_gettime","","",N,N],[17,"SYS_timer_getoverrun","","",N,N],[17,"SYS_timer_delete","","",N,N],[17,"SYS_clock_settime","","",N,N],[17,"SYS_clock_gettime","","",N,N],[17,"SYS_clock_getres","","",N,N],[17,"SYS_clock_nanosleep","","",N,N],[17,"SYS_exit_group","","",N,N],[17,"SYS_epoll_wait","","",N,N],[17,"SYS_epoll_ctl","","",N,N],[17,"SYS_tgkill","","",N,N],[17,"SYS_utimes","","",N,N],[17,"SYS_vserver","","",N,N],[17,"SYS_mbind","","",N,N],[17,"SYS_set_mempolicy","","",N,N],[17,"SYS_get_mempolicy","","",N,N],[17,"SYS_mq_open","","",N,N],[17,"SYS_mq_unlink","","",N,N],[17,"SYS_mq_timedsend","","",N,N],[17,"SYS_mq_timedreceive","","",N,N],[17,"SYS_mq_notify","","",N,N],[17,"SYS_mq_getsetattr","","",N,N],[17,"SYS_kexec_load","","",N,N],[17,"SYS_waitid","","",N,N],[17,"SYS_add_key","","",N,N],[17,"SYS_request_key","","",N,N],[17,"SYS_keyctl","","",N,N],[17,"SYS_ioprio_set","","",N,N],[17,"SYS_ioprio_get","","",N,N],[17,"SYS_inotify_init","","",N,N],[17,"SYS_inotify_add_watch","","",N,N],[17,"SYS_inotify_rm_watch","","",N,N],[17,"SYS_migrate_pages","","",N,N],[17,"SYS_openat","","",N,N],[17,"SYS_mkdirat","","",N,N],[17,"SYS_mknodat","","",N,N],[17,"SYS_fchownat","","",N,N],[17,"SYS_futimesat","","",N,N],[17,"SYS_newfstatat","","",N,N],[17,"SYS_unlinkat","","",N,N],[17,"SYS_renameat","","",N,N],[17,"SYS_linkat","","",N,N],[17,"SYS_symlinkat","","",N,N],[17,"SYS_readlinkat","","",N,N],[17,"SYS_fchmodat","","",N,N],[17,"SYS_faccessat","","",N,N],[17,"SYS_pselect6","","",N,N],[17,"SYS_ppoll","","",N,N],[17,"SYS_unshare","","",N,N],[17,"SYS_set_robust_list","","",N,N],[17,"SYS_get_robust_list","","",N,N],[17,"SYS_splice","","",N,N],[17,"SYS_tee","","",N,N],[17,"SYS_sync_file_range","","",N,N],[17,"SYS_vmsplice","","",N,N],[17,"SYS_move_pages","","",N,N],[17,"SYS_utimensat","","",N,N],[17,"SYS_epoll_pwait","","",N,N],[17,"SYS_signalfd","","",N,N],[17,"SYS_timerfd_create","","",N,N],[17,"SYS_eventfd","","",N,N],[17,"SYS_fallocate","","",N,N],[17,"SYS_timerfd_settime","","",N,N],[17,"SYS_timerfd_gettime","","",N,N],[17,"SYS_accept4","","",N,N],[17,"SYS_signalfd4","","",N,N],[17,"SYS_eventfd2","","",N,N],[17,"SYS_epoll_create1","","",N,N],[17,"SYS_dup3","","",N,N],[17,"SYS_pipe2","","",N,N],[17,"SYS_inotify_init1","","",N,N],[17,"SYS_preadv","","",N,N],[17,"SYS_pwritev","","",N,N],[17,"SYS_rt_tgsigqueueinfo","","",N,N],[17,"SYS_perf_event_open","","",N,N],[17,"SYS_recvmmsg","","",N,N],[17,"SYS_fanotify_init","","",N,N],[17,"SYS_fanotify_mark","","",N,N],[17,"SYS_prlimit64","","",N,N],[17,"SYS_name_to_handle_at","","",N,N],[17,"SYS_open_by_handle_at","","",N,N],[17,"SYS_clock_adjtime","","",N,N],[17,"SYS_syncfs","","",N,N],[17,"SYS_sendmmsg","","",N,N],[17,"SYS_setns","","",N,N],[17,"SYS_getcpu","","",N,N],[17,"SYS_process_vm_readv","","",N,N],[17,"SYS_process_vm_writev","","",N,N],[17,"SYS_kcmp","","",N,N],[17,"SYS_finit_module","","",N,N],[17,"SYS_sched_setattr","","",N,N],[17,"SYS_sched_getattr","","",N,N],[17,"SYS_renameat2","","",N,N],[17,"SYS_seccomp","","",N,N],[17,"SYS_getrandom","","",N,N],[17,"SYS_memfd_create","","",N,N],[17,"SYS_kexec_file_load","","",N,N],[17,"SYS_bpf","","",N,N],[17,"SYS_execveat","","",N,N],[17,"SYS_userfaultfd","","",N,N],[17,"SYS_membarrier","","",N,N],[17,"SYS_mlock2","","",N,N],[17,"SYS_copy_file_range","","",N,N],[17,"SYS_preadv2","","",N,N],[17,"SYS_pwritev2","","",N,N],[17,"SYS_pkey_mprotect","","",N,N],[17,"SYS_pkey_alloc","","",N,N],[17,"SYS_pkey_free","","",N,N],[11,"to_owned","","",0,[[["self"]],["t"]]],[11,"clone_into","","",0,N],[11,"from","","",0,[[["t"]],["t"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"to_owned","","",1,[[["self"]],["t"]]],[11,"clone_into","","",1,N],[11,"from","","",1,[[["t"]],["t"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"to_owned","","",2,[[["self"]],["t"]]],[11,"clone_into","","",2,N],[11,"from","","",2,[[["t"]],["t"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"to_owned","","",3,[[["self"]],["t"]]],[11,"clone_into","","",3,N],[11,"from","","",3,[[["t"]],["t"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]],[11,"to_owned","","",4,[[["self"]],["t"]]],[11,"clone_into","","",4,N],[11,"from","","",4,[[["t"]],["t"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"to_owned","","",5,[[["self"]],["t"]]],[11,"clone_into","","",5,N],[11,"from","","",5,[[["t"]],["t"]]],[11,"into","","",5,[[["self"]],["u"]]],[11,"try_from","","",5,[[["u"]],["result"]]],[11,"borrow","","",5,[[["self"]],["t"]]],[11,"try_into","","",5,[[["self"]],["result"]]],[11,"borrow_mut","","",5,[[["self"]],["t"]]],[11,"get_type_id","","",5,[[["self"]],["typeid"]]],[11,"to_owned","","",6,[[["self"]],["t"]]],[11,"clone_into","","",6,N],[11,"from","","",6,[[["t"]],["t"]]],[11,"into","","",6,[[["self"]],["u"]]],[11,"try_from","","",6,[[["u"]],["result"]]],[11,"borrow","","",6,[[["self"]],["t"]]],[11,"try_into","","",6,[[["self"]],["result"]]],[11,"borrow_mut","","",6,[[["self"]],["t"]]],[11,"get_type_id","","",6,[[["self"]],["typeid"]]],[11,"to_owned","","",7,[[["self"]],["t"]]],[11,"clone_into","","",7,N],[11,"from","","",7,[[["t"]],["t"]]],[11,"into","","",7,[[["self"]],["u"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"try_into","","",7,[[["self"]],["result"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"get_type_id","","",7,[[["self"]],["typeid"]]],[11,"to_owned","","",8,[[["self"]],["t"]]],[11,"clone_into","","",8,N],[11,"from","","",8,[[["t"]],["t"]]],[11,"into","","",8,[[["self"]],["u"]]],[11,"try_from","","",8,[[["u"]],["result"]]],[11,"borrow","","",8,[[["self"]],["t"]]],[11,"try_into","","",8,[[["self"]],["result"]]],[11,"borrow_mut","","",8,[[["self"]],["t"]]],[11,"get_type_id","","",8,[[["self"]],["typeid"]]],[11,"to_owned","","",9,[[["self"]],["t"]]],[11,"clone_into","","",9,N],[11,"from","","",9,[[["t"]],["t"]]],[11,"into","","",9,[[["self"]],["u"]]],[11,"try_from","","",9,[[["u"]],["result"]]],[11,"borrow","","",9,[[["self"]],["t"]]],[11,"try_into","","",9,[[["self"]],["result"]]],[11,"borrow_mut","","",9,[[["self"]],["t"]]],[11,"get_type_id","","",9,[[["self"]],["typeid"]]],[11,"to_owned","","",10,[[["self"]],["t"]]],[11,"clone_into","","",10,N],[11,"from","","",10,[[["t"]],["t"]]],[11,"into","","",10,[[["self"]],["u"]]],[11,"try_from","","",10,[[["u"]],["result"]]],[11,"borrow","","",10,[[["self"]],["t"]]],[11,"try_into","","",10,[[["self"]],["result"]]],[11,"borrow_mut","","",10,[[["self"]],["t"]]],[11,"get_type_id","","",10,[[["self"]],["typeid"]]],[11,"to_owned","","",11,[[["self"]],["t"]]],[11,"clone_into","","",11,N],[11,"from","","",11,[[["t"]],["t"]]],[11,"into","","",11,[[["self"]],["u"]]],[11,"try_from","","",11,[[["u"]],["result"]]],[11,"borrow","","",11,[[["self"]],["t"]]],[11,"try_into","","",11,[[["self"]],["result"]]],[11,"borrow_mut","","",11,[[["self"]],["t"]]],[11,"get_type_id","","",11,[[["self"]],["typeid"]]],[11,"to_owned","","",12,[[["self"]],["t"]]],[11,"clone_into","","",12,N],[11,"from","","",12,[[["t"]],["t"]]],[11,"into","","",12,[[["self"]],["u"]]],[11,"try_from","","",12,[[["u"]],["result"]]],[11,"borrow","","",12,[[["self"]],["t"]]],[11,"try_into","","",12,[[["self"]],["result"]]],[11,"borrow_mut","","",12,[[["self"]],["t"]]],[11,"get_type_id","","",12,[[["self"]],["typeid"]]],[11,"to_owned","","",13,[[["self"]],["t"]]],[11,"clone_into","","",13,N],[11,"from","","",13,[[["t"]],["t"]]],[11,"into","","",13,[[["self"]],["u"]]],[11,"try_from","","",13,[[["u"]],["result"]]],[11,"borrow","","",13,[[["self"]],["t"]]],[11,"try_into","","",13,[[["self"]],["result"]]],[11,"borrow_mut","","",13,[[["self"]],["t"]]],[11,"get_type_id","","",13,[[["self"]],["typeid"]]],[11,"to_owned","","",14,[[["self"]],["t"]]],[11,"clone_into","","",14,N],[11,"from","","",14,[[["t"]],["t"]]],[11,"into","","",14,[[["self"]],["u"]]],[11,"try_from","","",14,[[["u"]],["result"]]],[11,"borrow","","",14,[[["self"]],["t"]]],[11,"try_into","","",14,[[["self"]],["result"]]],[11,"borrow_mut","","",14,[[["self"]],["t"]]],[11,"get_type_id","","",14,[[["self"]],["typeid"]]],[11,"to_owned","","",15,[[["self"]],["t"]]],[11,"clone_into","","",15,N],[11,"from","","",15,[[["t"]],["t"]]],[11,"into","","",15,[[["self"]],["u"]]],[11,"try_from","","",15,[[["u"]],["result"]]],[11,"borrow","","",15,[[["self"]],["t"]]],[11,"try_into","","",15,[[["self"]],["result"]]],[11,"borrow_mut","","",15,[[["self"]],["t"]]],[11,"get_type_id","","",15,[[["self"]],["typeid"]]],[11,"to_owned","","",16,[[["self"]],["t"]]],[11,"clone_into","","",16,N],[11,"from","","",16,[[["t"]],["t"]]],[11,"into","","",16,[[["self"]],["u"]]],[11,"try_from","","",16,[[["u"]],["result"]]],[11,"borrow","","",16,[[["self"]],["t"]]],[11,"try_into","","",16,[[["self"]],["result"]]],[11,"borrow_mut","","",16,[[["self"]],["t"]]],[11,"get_type_id","","",16,[[["self"]],["typeid"]]],[11,"to_owned","","",17,[[["self"]],["t"]]],[11,"clone_into","","",17,N],[11,"from","","",17,[[["t"]],["t"]]],[11,"into","","",17,[[["self"]],["u"]]],[11,"try_from","","",17,[[["u"]],["result"]]],[11,"borrow","","",17,[[["self"]],["t"]]],[11,"try_into","","",17,[[["self"]],["result"]]],[11,"borrow_mut","","",17,[[["self"]],["t"]]],[11,"get_type_id","","",17,[[["self"]],["typeid"]]],[11,"to_owned","","",18,[[["self"]],["t"]]],[11,"clone_into","","",18,N],[11,"from","","",18,[[["t"]],["t"]]],[11,"into","","",18,[[["self"]],["u"]]],[11,"try_from","","",18,[[["u"]],["result"]]],[11,"borrow","","",18,[[["self"]],["t"]]],[11,"try_into","","",18,[[["self"]],["result"]]],[11,"borrow_mut","","",18,[[["self"]],["t"]]],[11,"get_type_id","","",18,[[["self"]],["typeid"]]],[11,"to_owned","","",19,[[["self"]],["t"]]],[11,"clone_into","","",19,N],[11,"from","","",19,[[["t"]],["t"]]],[11,"into","","",19,[[["self"]],["u"]]],[11,"try_from","","",19,[[["u"]],["result"]]],[11,"borrow","","",19,[[["self"]],["t"]]],[11,"try_into","","",19,[[["self"]],["result"]]],[11,"borrow_mut","","",19,[[["self"]],["t"]]],[11,"get_type_id","","",19,[[["self"]],["typeid"]]],[11,"to_owned","","",20,[[["self"]],["t"]]],[11,"clone_into","","",20,N],[11,"from","","",20,[[["t"]],["t"]]],[11,"into","","",20,[[["self"]],["u"]]],[11,"try_from","","",20,[[["u"]],["result"]]],[11,"borrow","","",20,[[["self"]],["t"]]],[11,"try_into","","",20,[[["self"]],["result"]]],[11,"borrow_mut","","",20,[[["self"]],["t"]]],[11,"get_type_id","","",20,[[["self"]],["typeid"]]],[11,"to_owned","","",21,[[["self"]],["t"]]],[11,"clone_into","","",21,N],[11,"from","","",21,[[["t"]],["t"]]],[11,"into","","",21,[[["self"]],["u"]]],[11,"try_from","","",21,[[["u"]],["result"]]],[11,"borrow","","",21,[[["self"]],["t"]]],[11,"try_into","","",21,[[["self"]],["result"]]],[11,"borrow_mut","","",21,[[["self"]],["t"]]],[11,"get_type_id","","",21,[[["self"]],["typeid"]]],[11,"to_owned","","",22,[[["self"]],["t"]]],[11,"clone_into","","",22,N],[11,"from","","",22,[[["t"]],["t"]]],[11,"into","","",22,[[["self"]],["u"]]],[11,"try_from","","",22,[[["u"]],["result"]]],[11,"borrow","","",22,[[["self"]],["t"]]],[11,"try_into","","",22,[[["self"]],["result"]]],[11,"borrow_mut","","",22,[[["self"]],["t"]]],[11,"get_type_id","","",22,[[["self"]],["typeid"]]],[11,"to_owned","","",23,[[["self"]],["t"]]],[11,"clone_into","","",23,N],[11,"from","","",23,[[["t"]],["t"]]],[11,"into","","",23,[[["self"]],["u"]]],[11,"try_from","","",23,[[["u"]],["result"]]],[11,"borrow","","",23,[[["self"]],["t"]]],[11,"try_into","","",23,[[["self"]],["result"]]],[11,"borrow_mut","","",23,[[["self"]],["t"]]],[11,"get_type_id","","",23,[[["self"]],["typeid"]]],[11,"to_owned","","",24,[[["self"]],["t"]]],[11,"clone_into","","",24,N],[11,"from","","",24,[[["t"]],["t"]]],[11,"into","","",24,[[["self"]],["u"]]],[11,"try_from","","",24,[[["u"]],["result"]]],[11,"borrow","","",24,[[["self"]],["t"]]],[11,"try_into","","",24,[[["self"]],["result"]]],[11,"borrow_mut","","",24,[[["self"]],["t"]]],[11,"get_type_id","","",24,[[["self"]],["typeid"]]],[11,"to_owned","","",25,[[["self"]],["t"]]],[11,"clone_into","","",25,N],[11,"from","","",25,[[["t"]],["t"]]],[11,"into","","",25,[[["self"]],["u"]]],[11,"try_from","","",25,[[["u"]],["result"]]],[11,"borrow","","",25,[[["self"]],["t"]]],[11,"try_into","","",25,[[["self"]],["result"]]],[11,"borrow_mut","","",25,[[["self"]],["t"]]],[11,"get_type_id","","",25,[[["self"]],["typeid"]]],[11,"to_owned","","",26,[[["self"]],["t"]]],[11,"clone_into","","",26,N],[11,"from","","",26,[[["t"]],["t"]]],[11,"into","","",26,[[["self"]],["u"]]],[11,"try_from","","",26,[[["u"]],["result"]]],[11,"borrow","","",26,[[["self"]],["t"]]],[11,"try_into","","",26,[[["self"]],["result"]]],[11,"borrow_mut","","",26,[[["self"]],["t"]]],[11,"get_type_id","","",26,[[["self"]],["typeid"]]],[11,"to_owned","","",27,[[["self"]],["t"]]],[11,"clone_into","","",27,N],[11,"from","","",27,[[["t"]],["t"]]],[11,"into","","",27,[[["self"]],["u"]]],[11,"try_from","","",27,[[["u"]],["result"]]],[11,"borrow","","",27,[[["self"]],["t"]]],[11,"try_into","","",27,[[["self"]],["result"]]],[11,"borrow_mut","","",27,[[["self"]],["t"]]],[11,"get_type_id","","",27,[[["self"]],["typeid"]]],[11,"to_owned","","",28,[[["self"]],["t"]]],[11,"clone_into","","",28,N],[11,"from","","",28,[[["t"]],["t"]]],[11,"into","","",28,[[["self"]],["u"]]],[11,"try_from","","",28,[[["u"]],["result"]]],[11,"borrow","","",28,[[["self"]],["t"]]],[11,"try_into","","",28,[[["self"]],["result"]]],[11,"borrow_mut","","",28,[[["self"]],["t"]]],[11,"get_type_id","","",28,[[["self"]],["typeid"]]],[11,"to_owned","","",29,[[["self"]],["t"]]],[11,"clone_into","","",29,N],[11,"from","","",29,[[["t"]],["t"]]],[11,"into","","",29,[[["self"]],["u"]]],[11,"try_from","","",29,[[["u"]],["result"]]],[11,"borrow","","",29,[[["self"]],["t"]]],[11,"try_into","","",29,[[["self"]],["result"]]],[11,"borrow_mut","","",29,[[["self"]],["t"]]],[11,"get_type_id","","",29,[[["self"]],["typeid"]]],[11,"to_owned","","",30,[[["self"]],["t"]]],[11,"clone_into","","",30,N],[11,"from","","",30,[[["t"]],["t"]]],[11,"into","","",30,[[["self"]],["u"]]],[11,"try_from","","",30,[[["u"]],["result"]]],[11,"borrow","","",30,[[["self"]],["t"]]],[11,"try_into","","",30,[[["self"]],["result"]]],[11,"borrow_mut","","",30,[[["self"]],["t"]]],[11,"get_type_id","","",30,[[["self"]],["typeid"]]],[11,"to_owned","","",31,[[["self"]],["t"]]],[11,"clone_into","","",31,N],[11,"from","","",31,[[["t"]],["t"]]],[11,"into","","",31,[[["self"]],["u"]]],[11,"try_from","","",31,[[["u"]],["result"]]],[11,"borrow","","",31,[[["self"]],["t"]]],[11,"try_into","","",31,[[["self"]],["result"]]],[11,"borrow_mut","","",31,[[["self"]],["t"]]],[11,"get_type_id","","",31,[[["self"]],["typeid"]]],[11,"to_owned","","",32,[[["self"]],["t"]]],[11,"clone_into","","",32,N],[11,"from","","",32,[[["t"]],["t"]]],[11,"into","","",32,[[["self"]],["u"]]],[11,"try_from","","",32,[[["u"]],["result"]]],[11,"borrow","","",32,[[["self"]],["t"]]],[11,"try_into","","",32,[[["self"]],["result"]]],[11,"borrow_mut","","",32,[[["self"]],["t"]]],[11,"get_type_id","","",32,[[["self"]],["typeid"]]],[11,"to_owned","","",33,[[["self"]],["t"]]],[11,"clone_into","","",33,N],[11,"from","","",33,[[["t"]],["t"]]],[11,"into","","",33,[[["self"]],["u"]]],[11,"try_from","","",33,[[["u"]],["result"]]],[11,"borrow","","",33,[[["self"]],["t"]]],[11,"try_into","","",33,[[["self"]],["result"]]],[11,"borrow_mut","","",33,[[["self"]],["t"]]],[11,"get_type_id","","",33,[[["self"]],["typeid"]]],[11,"to_owned","","",34,[[["self"]],["t"]]],[11,"clone_into","","",34,N],[11,"from","","",34,[[["t"]],["t"]]],[11,"into","","",34,[[["self"]],["u"]]],[11,"try_from","","",34,[[["u"]],["result"]]],[11,"borrow","","",34,[[["self"]],["t"]]],[11,"try_into","","",34,[[["self"]],["result"]]],[11,"borrow_mut","","",34,[[["self"]],["t"]]],[11,"get_type_id","","",34,[[["self"]],["typeid"]]],[11,"to_owned","","",35,[[["self"]],["t"]]],[11,"clone_into","","",35,N],[11,"from","","",35,[[["t"]],["t"]]],[11,"into","","",35,[[["self"]],["u"]]],[11,"try_from","","",35,[[["u"]],["result"]]],[11,"borrow","","",35,[[["self"]],["t"]]],[11,"try_into","","",35,[[["self"]],["result"]]],[11,"borrow_mut","","",35,[[["self"]],["t"]]],[11,"get_type_id","","",35,[[["self"]],["typeid"]]],[11,"to_owned","","",36,[[["self"]],["t"]]],[11,"clone_into","","",36,N],[11,"from","","",36,[[["t"]],["t"]]],[11,"into","","",36,[[["self"]],["u"]]],[11,"try_from","","",36,[[["u"]],["result"]]],[11,"borrow","","",36,[[["self"]],["t"]]],[11,"try_into","","",36,[[["self"]],["result"]]],[11,"borrow_mut","","",36,[[["self"]],["t"]]],[11,"get_type_id","","",36,[[["self"]],["typeid"]]],[11,"to_owned","","",37,[[["self"]],["t"]]],[11,"clone_into","","",37,N],[11,"from","","",37,[[["t"]],["t"]]],[11,"into","","",37,[[["self"]],["u"]]],[11,"try_from","","",37,[[["u"]],["result"]]],[11,"borrow","","",37,[[["self"]],["t"]]],[11,"try_into","","",37,[[["self"]],["result"]]],[11,"borrow_mut","","",37,[[["self"]],["t"]]],[11,"get_type_id","","",37,[[["self"]],["typeid"]]],[11,"to_owned","","",38,[[["self"]],["t"]]],[11,"clone_into","","",38,N],[11,"from","","",38,[[["t"]],["t"]]],[11,"into","","",38,[[["self"]],["u"]]],[11,"try_from","","",38,[[["u"]],["result"]]],[11,"borrow","","",38,[[["self"]],["t"]]],[11,"try_into","","",38,[[["self"]],["result"]]],[11,"borrow_mut","","",38,[[["self"]],["t"]]],[11,"get_type_id","","",38,[[["self"]],["typeid"]]],[11,"to_owned","","",39,[[["self"]],["t"]]],[11,"clone_into","","",39,N],[11,"from","","",39,[[["t"]],["t"]]],[11,"into","","",39,[[["self"]],["u"]]],[11,"try_from","","",39,[[["u"]],["result"]]],[11,"borrow","","",39,[[["self"]],["t"]]],[11,"try_into","","",39,[[["self"]],["result"]]],[11,"borrow_mut","","",39,[[["self"]],["t"]]],[11,"get_type_id","","",39,[[["self"]],["typeid"]]],[11,"to_owned","","",40,[[["self"]],["t"]]],[11,"clone_into","","",40,N],[11,"from","","",40,[[["t"]],["t"]]],[11,"into","","",40,[[["self"]],["u"]]],[11,"try_from","","",40,[[["u"]],["result"]]],[11,"borrow","","",40,[[["self"]],["t"]]],[11,"try_into","","",40,[[["self"]],["result"]]],[11,"borrow_mut","","",40,[[["self"]],["t"]]],[11,"get_type_id","","",40,[[["self"]],["typeid"]]],[11,"to_owned","","",41,[[["self"]],["t"]]],[11,"clone_into","","",41,N],[11,"from","","",41,[[["t"]],["t"]]],[11,"into","","",41,[[["self"]],["u"]]],[11,"try_from","","",41,[[["u"]],["result"]]],[11,"borrow","","",41,[[["self"]],["t"]]],[11,"try_into","","",41,[[["self"]],["result"]]],[11,"borrow_mut","","",41,[[["self"]],["t"]]],[11,"get_type_id","","",41,[[["self"]],["typeid"]]],[11,"to_owned","","",42,[[["self"]],["t"]]],[11,"clone_into","","",42,N],[11,"from","","",42,[[["t"]],["t"]]],[11,"into","","",42,[[["self"]],["u"]]],[11,"try_from","","",42,[[["u"]],["result"]]],[11,"borrow","","",42,[[["self"]],["t"]]],[11,"try_into","","",42,[[["self"]],["result"]]],[11,"borrow_mut","","",42,[[["self"]],["t"]]],[11,"get_type_id","","",42,[[["self"]],["typeid"]]],[11,"to_owned","","",43,[[["self"]],["t"]]],[11,"clone_into","","",43,N],[11,"from","","",43,[[["t"]],["t"]]],[11,"into","","",43,[[["self"]],["u"]]],[11,"try_from","","",43,[[["u"]],["result"]]],[11,"borrow","","",43,[[["self"]],["t"]]],[11,"try_into","","",43,[[["self"]],["result"]]],[11,"borrow_mut","","",43,[[["self"]],["t"]]],[11,"get_type_id","","",43,[[["self"]],["typeid"]]],[11,"to_owned","","",44,[[["self"]],["t"]]],[11,"clone_into","","",44,N],[11,"from","","",44,[[["t"]],["t"]]],[11,"into","","",44,[[["self"]],["u"]]],[11,"try_from","","",44,[[["u"]],["result"]]],[11,"borrow","","",44,[[["self"]],["t"]]],[11,"try_into","","",44,[[["self"]],["result"]]],[11,"borrow_mut","","",44,[[["self"]],["t"]]],[11,"get_type_id","","",44,[[["self"]],["typeid"]]],[11,"to_owned","","",45,[[["self"]],["t"]]],[11,"clone_into","","",45,N],[11,"from","","",45,[[["t"]],["t"]]],[11,"into","","",45,[[["self"]],["u"]]],[11,"try_from","","",45,[[["u"]],["result"]]],[11,"borrow","","",45,[[["self"]],["t"]]],[11,"try_into","","",45,[[["self"]],["result"]]],[11,"borrow_mut","","",45,[[["self"]],["t"]]],[11,"get_type_id","","",45,[[["self"]],["typeid"]]],[11,"to_owned","","",46,[[["self"]],["t"]]],[11,"clone_into","","",46,N],[11,"from","","",46,[[["t"]],["t"]]],[11,"into","","",46,[[["self"]],["u"]]],[11,"try_from","","",46,[[["u"]],["result"]]],[11,"borrow","","",46,[[["self"]],["t"]]],[11,"try_into","","",46,[[["self"]],["result"]]],[11,"borrow_mut","","",46,[[["self"]],["t"]]],[11,"get_type_id","","",46,[[["self"]],["typeid"]]],[11,"to_owned","","",47,[[["self"]],["t"]]],[11,"clone_into","","",47,N],[11,"from","","",47,[[["t"]],["t"]]],[11,"into","","",47,[[["self"]],["u"]]],[11,"try_from","","",47,[[["u"]],["result"]]],[11,"borrow","","",47,[[["self"]],["t"]]],[11,"try_into","","",47,[[["self"]],["result"]]],[11,"borrow_mut","","",47,[[["self"]],["t"]]],[11,"get_type_id","","",47,[[["self"]],["typeid"]]],[11,"to_owned","","",48,[[["self"]],["t"]]],[11,"clone_into","","",48,N],[11,"from","","",48,[[["t"]],["t"]]],[11,"into","","",48,[[["self"]],["u"]]],[11,"try_from","","",48,[[["u"]],["result"]]],[11,"borrow","","",48,[[["self"]],["t"]]],[11,"try_into","","",48,[[["self"]],["result"]]],[11,"borrow_mut","","",48,[[["self"]],["t"]]],[11,"get_type_id","","",48,[[["self"]],["typeid"]]],[11,"to_owned","","",49,[[["self"]],["t"]]],[11,"clone_into","","",49,N],[11,"from","","",49,[[["t"]],["t"]]],[11,"into","","",49,[[["self"]],["u"]]],[11,"try_from","","",49,[[["u"]],["result"]]],[11,"borrow","","",49,[[["self"]],["t"]]],[11,"try_into","","",49,[[["self"]],["result"]]],[11,"borrow_mut","","",49,[[["self"]],["t"]]],[11,"get_type_id","","",49,[[["self"]],["typeid"]]],[11,"to_owned","","",50,[[["self"]],["t"]]],[11,"clone_into","","",50,N],[11,"from","","",50,[[["t"]],["t"]]],[11,"into","","",50,[[["self"]],["u"]]],[11,"try_from","","",50,[[["u"]],["result"]]],[11,"borrow","","",50,[[["self"]],["t"]]],[11,"try_into","","",50,[[["self"]],["result"]]],[11,"borrow_mut","","",50,[[["self"]],["t"]]],[11,"get_type_id","","",50,[[["self"]],["typeid"]]],[11,"to_owned","","",51,[[["self"]],["t"]]],[11,"clone_into","","",51,N],[11,"from","","",51,[[["t"]],["t"]]],[11,"into","","",51,[[["self"]],["u"]]],[11,"try_from","","",51,[[["u"]],["result"]]],[11,"borrow","","",51,[[["self"]],["t"]]],[11,"try_into","","",51,[[["self"]],["result"]]],[11,"borrow_mut","","",51,[[["self"]],["t"]]],[11,"get_type_id","","",51,[[["self"]],["typeid"]]],[11,"to_owned","","",52,[[["self"]],["t"]]],[11,"clone_into","","",52,N],[11,"from","","",52,[[["t"]],["t"]]],[11,"into","","",52,[[["self"]],["u"]]],[11,"try_from","","",52,[[["u"]],["result"]]],[11,"borrow","","",52,[[["self"]],["t"]]],[11,"try_into","","",52,[[["self"]],["result"]]],[11,"borrow_mut","","",52,[[["self"]],["t"]]],[11,"get_type_id","","",52,[[["self"]],["typeid"]]],[11,"to_owned","","",53,[[["self"]],["t"]]],[11,"clone_into","","",53,N],[11,"from","","",53,[[["t"]],["t"]]],[11,"into","","",53,[[["self"]],["u"]]],[11,"try_from","","",53,[[["u"]],["result"]]],[11,"borrow","","",53,[[["self"]],["t"]]],[11,"try_into","","",53,[[["self"]],["result"]]],[11,"borrow_mut","","",53,[[["self"]],["t"]]],[11,"get_type_id","","",53,[[["self"]],["typeid"]]],[11,"to_owned","","",54,[[["self"]],["t"]]],[11,"clone_into","","",54,N],[11,"from","","",54,[[["t"]],["t"]]],[11,"into","","",54,[[["self"]],["u"]]],[11,"try_from","","",54,[[["u"]],["result"]]],[11,"borrow","","",54,[[["self"]],["t"]]],[11,"try_into","","",54,[[["self"]],["result"]]],[11,"borrow_mut","","",54,[[["self"]],["t"]]],[11,"get_type_id","","",54,[[["self"]],["typeid"]]],[11,"to_owned","","",55,[[["self"]],["t"]]],[11,"clone_into","","",55,N],[11,"from","","",55,[[["t"]],["t"]]],[11,"into","","",55,[[["self"]],["u"]]],[11,"try_from","","",55,[[["u"]],["result"]]],[11,"borrow","","",55,[[["self"]],["t"]]],[11,"try_into","","",55,[[["self"]],["result"]]],[11,"borrow_mut","","",55,[[["self"]],["t"]]],[11,"get_type_id","","",55,[[["self"]],["typeid"]]],[11,"to_owned","","",56,[[["self"]],["t"]]],[11,"clone_into","","",56,N],[11,"from","","",56,[[["t"]],["t"]]],[11,"into","","",56,[[["self"]],["u"]]],[11,"try_from","","",56,[[["u"]],["result"]]],[11,"borrow","","",56,[[["self"]],["t"]]],[11,"try_into","","",56,[[["self"]],["result"]]],[11,"borrow_mut","","",56,[[["self"]],["t"]]],[11,"get_type_id","","",56,[[["self"]],["typeid"]]],[11,"to_owned","","",57,[[["self"]],["t"]]],[11,"clone_into","","",57,N],[11,"from","","",57,[[["t"]],["t"]]],[11,"into","","",57,[[["self"]],["u"]]],[11,"try_from","","",57,[[["u"]],["result"]]],[11,"borrow","","",57,[[["self"]],["t"]]],[11,"try_into","","",57,[[["self"]],["result"]]],[11,"borrow_mut","","",57,[[["self"]],["t"]]],[11,"get_type_id","","",57,[[["self"]],["typeid"]]],[11,"to_owned","","",58,[[["self"]],["t"]]],[11,"clone_into","","",58,N],[11,"from","","",58,[[["t"]],["t"]]],[11,"into","","",58,[[["self"]],["u"]]],[11,"try_from","","",58,[[["u"]],["result"]]],[11,"borrow","","",58,[[["self"]],["t"]]],[11,"try_into","","",58,[[["self"]],["result"]]],[11,"borrow_mut","","",58,[[["self"]],["t"]]],[11,"get_type_id","","",58,[[["self"]],["typeid"]]],[11,"to_owned","","",59,[[["self"]],["t"]]],[11,"clone_into","","",59,N],[11,"from","","",59,[[["t"]],["t"]]],[11,"into","","",59,[[["self"]],["u"]]],[11,"try_from","","",59,[[["u"]],["result"]]],[11,"borrow","","",59,[[["self"]],["t"]]],[11,"try_into","","",59,[[["self"]],["result"]]],[11,"borrow_mut","","",59,[[["self"]],["t"]]],[11,"get_type_id","","",59,[[["self"]],["typeid"]]],[11,"to_owned","","",60,[[["self"]],["t"]]],[11,"clone_into","","",60,N],[11,"from","","",60,[[["t"]],["t"]]],[11,"into","","",60,[[["self"]],["u"]]],[11,"try_from","","",60,[[["u"]],["result"]]],[11,"borrow","","",60,[[["self"]],["t"]]],[11,"try_into","","",60,[[["self"]],["result"]]],[11,"borrow_mut","","",60,[[["self"]],["t"]]],[11,"get_type_id","","",60,[[["self"]],["typeid"]]],[11,"to_owned","","",61,[[["self"]],["t"]]],[11,"clone_into","","",61,N],[11,"from","","",61,[[["t"]],["t"]]],[11,"into","","",61,[[["self"]],["u"]]],[11,"try_from","","",61,[[["u"]],["result"]]],[11,"borrow","","",61,[[["self"]],["t"]]],[11,"try_into","","",61,[[["self"]],["result"]]],[11,"borrow_mut","","",61,[[["self"]],["t"]]],[11,"get_type_id","","",61,[[["self"]],["typeid"]]],[11,"to_owned","","",62,[[["self"]],["t"]]],[11,"clone_into","","",62,N],[11,"from","","",62,[[["t"]],["t"]]],[11,"into","","",62,[[["self"]],["u"]]],[11,"try_from","","",62,[[["u"]],["result"]]],[11,"borrow","","",62,[[["self"]],["t"]]],[11,"try_into","","",62,[[["self"]],["result"]]],[11,"borrow_mut","","",62,[[["self"]],["t"]]],[11,"get_type_id","","",62,[[["self"]],["typeid"]]],[11,"to_owned","","",63,[[["self"]],["t"]]],[11,"clone_into","","",63,N],[11,"from","","",63,[[["t"]],["t"]]],[11,"into","","",63,[[["self"]],["u"]]],[11,"try_from","","",63,[[["u"]],["result"]]],[11,"borrow","","",63,[[["self"]],["t"]]],[11,"try_into","","",63,[[["self"]],["result"]]],[11,"borrow_mut","","",63,[[["self"]],["t"]]],[11,"get_type_id","","",63,[[["self"]],["typeid"]]],[11,"to_owned","","",64,[[["self"]],["t"]]],[11,"clone_into","","",64,N],[11,"from","","",64,[[["t"]],["t"]]],[11,"into","","",64,[[["self"]],["u"]]],[11,"try_from","","",64,[[["u"]],["result"]]],[11,"borrow","","",64,[[["self"]],["t"]]],[11,"try_into","","",64,[[["self"]],["result"]]],[11,"borrow_mut","","",64,[[["self"]],["t"]]],[11,"get_type_id","","",64,[[["self"]],["typeid"]]],[11,"to_owned","","",65,[[["self"]],["t"]]],[11,"clone_into","","",65,N],[11,"from","","",65,[[["t"]],["t"]]],[11,"into","","",65,[[["self"]],["u"]]],[11,"try_from","","",65,[[["u"]],["result"]]],[11,"borrow","","",65,[[["self"]],["t"]]],[11,"try_into","","",65,[[["self"]],["result"]]],[11,"borrow_mut","","",65,[[["self"]],["t"]]],[11,"get_type_id","","",65,[[["self"]],["typeid"]]],[11,"to_owned","","",66,[[["self"]],["t"]]],[11,"clone_into","","",66,N],[11,"from","","",66,[[["t"]],["t"]]],[11,"into","","",66,[[["self"]],["u"]]],[11,"try_from","","",66,[[["u"]],["result"]]],[11,"borrow","","",66,[[["self"]],["t"]]],[11,"try_into","","",66,[[["self"]],["result"]]],[11,"borrow_mut","","",66,[[["self"]],["t"]]],[11,"get_type_id","","",66,[[["self"]],["typeid"]]],[11,"to_owned","","",67,[[["self"]],["t"]]],[11,"clone_into","","",67,N],[11,"from","","",67,[[["t"]],["t"]]],[11,"into","","",67,[[["self"]],["u"]]],[11,"try_from","","",67,[[["u"]],["result"]]],[11,"borrow","","",67,[[["self"]],["t"]]],[11,"try_into","","",67,[[["self"]],["result"]]],[11,"borrow_mut","","",67,[[["self"]],["t"]]],[11,"get_type_id","","",67,[[["self"]],["typeid"]]],[11,"to_owned","","",68,[[["self"]],["t"]]],[11,"clone_into","","",68,N],[11,"from","","",68,[[["t"]],["t"]]],[11,"into","","",68,[[["self"]],["u"]]],[11,"try_from","","",68,[[["u"]],["result"]]],[11,"borrow","","",68,[[["self"]],["t"]]],[11,"try_into","","",68,[[["self"]],["result"]]],[11,"borrow_mut","","",68,[[["self"]],["t"]]],[11,"get_type_id","","",68,[[["self"]],["typeid"]]],[11,"to_owned","","",69,[[["self"]],["t"]]],[11,"clone_into","","",69,N],[11,"from","","",69,[[["t"]],["t"]]],[11,"into","","",69,[[["self"]],["u"]]],[11,"try_from","","",69,[[["u"]],["result"]]],[11,"borrow","","",69,[[["self"]],["t"]]],[11,"try_into","","",69,[[["self"]],["result"]]],[11,"borrow_mut","","",69,[[["self"]],["t"]]],[11,"get_type_id","","",69,[[["self"]],["typeid"]]],[11,"to_owned","","",70,[[["self"]],["t"]]],[11,"clone_into","","",70,N],[11,"from","","",70,[[["t"]],["t"]]],[11,"into","","",70,[[["self"]],["u"]]],[11,"try_from","","",70,[[["u"]],["result"]]],[11,"borrow","","",70,[[["self"]],["t"]]],[11,"try_into","","",70,[[["self"]],["result"]]],[11,"borrow_mut","","",70,[[["self"]],["t"]]],[11,"get_type_id","","",70,[[["self"]],["typeid"]]],[11,"to_owned","","",71,[[["self"]],["t"]]],[11,"clone_into","","",71,N],[11,"from","","",71,[[["t"]],["t"]]],[11,"into","","",71,[[["self"]],["u"]]],[11,"try_from","","",71,[[["u"]],["result"]]],[11,"borrow","","",71,[[["self"]],["t"]]],[11,"try_into","","",71,[[["self"]],["result"]]],[11,"borrow_mut","","",71,[[["self"]],["t"]]],[11,"get_type_id","","",71,[[["self"]],["typeid"]]],[11,"to_owned","","",72,[[["self"]],["t"]]],[11,"clone_into","","",72,N],[11,"from","","",72,[[["t"]],["t"]]],[11,"into","","",72,[[["self"]],["u"]]],[11,"try_from","","",72,[[["u"]],["result"]]],[11,"borrow","","",72,[[["self"]],["t"]]],[11,"try_into","","",72,[[["self"]],["result"]]],[11,"borrow_mut","","",72,[[["self"]],["t"]]],[11,"get_type_id","","",72,[[["self"]],["typeid"]]],[11,"to_owned","","",73,[[["self"]],["t"]]],[11,"clone_into","","",73,N],[11,"from","","",73,[[["t"]],["t"]]],[11,"into","","",73,[[["self"]],["u"]]],[11,"try_from","","",73,[[["u"]],["result"]]],[11,"borrow","","",73,[[["self"]],["t"]]],[11,"try_into","","",73,[[["self"]],["result"]]],[11,"borrow_mut","","",73,[[["self"]],["t"]]],[11,"get_type_id","","",73,[[["self"]],["typeid"]]],[11,"to_owned","","",74,[[["self"]],["t"]]],[11,"clone_into","","",74,N],[11,"from","","",74,[[["t"]],["t"]]],[11,"into","","",74,[[["self"]],["u"]]],[11,"try_from","","",74,[[["u"]],["result"]]],[11,"borrow","","",74,[[["self"]],["t"]]],[11,"try_into","","",74,[[["self"]],["result"]]],[11,"borrow_mut","","",74,[[["self"]],["t"]]],[11,"get_type_id","","",74,[[["self"]],["typeid"]]],[11,"to_owned","","",75,[[["self"]],["t"]]],[11,"clone_into","","",75,N],[11,"from","","",75,[[["t"]],["t"]]],[11,"into","","",75,[[["self"]],["u"]]],[11,"try_from","","",75,[[["u"]],["result"]]],[11,"borrow","","",75,[[["self"]],["t"]]],[11,"try_into","","",75,[[["self"]],["result"]]],[11,"borrow_mut","","",75,[[["self"]],["t"]]],[11,"get_type_id","","",75,[[["self"]],["typeid"]]],[11,"to_owned","","",76,[[["self"]],["t"]]],[11,"clone_into","","",76,N],[11,"from","","",76,[[["t"]],["t"]]],[11,"into","","",76,[[["self"]],["u"]]],[11,"try_from","","",76,[[["u"]],["result"]]],[11,"borrow","","",76,[[["self"]],["t"]]],[11,"try_into","","",76,[[["self"]],["result"]]],[11,"borrow_mut","","",76,[[["self"]],["t"]]],[11,"get_type_id","","",76,[[["self"]],["typeid"]]],[11,"to_owned","","",77,[[["self"]],["t"]]],[11,"clone_into","","",77,N],[11,"from","","",77,[[["t"]],["t"]]],[11,"into","","",77,[[["self"]],["u"]]],[11,"try_from","","",77,[[["u"]],["result"]]],[11,"borrow","","",77,[[["self"]],["t"]]],[11,"try_into","","",77,[[["self"]],["result"]]],[11,"borrow_mut","","",77,[[["self"]],["t"]]],[11,"get_type_id","","",77,[[["self"]],["typeid"]]],[11,"to_owned","","",78,[[["self"]],["t"]]],[11,"clone_into","","",78,N],[11,"from","","",78,[[["t"]],["t"]]],[11,"into","","",78,[[["self"]],["u"]]],[11,"try_from","","",78,[[["u"]],["result"]]],[11,"borrow","","",78,[[["self"]],["t"]]],[11,"try_into","","",78,[[["self"]],["result"]]],[11,"borrow_mut","","",78,[[["self"]],["t"]]],[11,"get_type_id","","",78,[[["self"]],["typeid"]]],[11,"to_owned","","",79,[[["self"]],["t"]]],[11,"clone_into","","",79,N],[11,"from","","",79,[[["t"]],["t"]]],[11,"into","","",79,[[["self"]],["u"]]],[11,"try_from","","",79,[[["u"]],["result"]]],[11,"borrow","","",79,[[["self"]],["t"]]],[11,"try_into","","",79,[[["self"]],["result"]]],[11,"borrow_mut","","",79,[[["self"]],["t"]]],[11,"get_type_id","","",79,[[["self"]],["typeid"]]],[11,"to_owned","","",80,[[["self"]],["t"]]],[11,"clone_into","","",80,N],[11,"from","","",80,[[["t"]],["t"]]],[11,"into","","",80,[[["self"]],["u"]]],[11,"try_from","","",80,[[["u"]],["result"]]],[11,"borrow","","",80,[[["self"]],["t"]]],[11,"try_into","","",80,[[["self"]],["result"]]],[11,"borrow_mut","","",80,[[["self"]],["t"]]],[11,"get_type_id","","",80,[[["self"]],["typeid"]]],[11,"to_owned","","",81,[[["self"]],["t"]]],[11,"clone_into","","",81,N],[11,"from","","",81,[[["t"]],["t"]]],[11,"into","","",81,[[["self"]],["u"]]],[11,"try_from","","",81,[[["u"]],["result"]]],[11,"borrow","","",81,[[["self"]],["t"]]],[11,"try_into","","",81,[[["self"]],["result"]]],[11,"borrow_mut","","",81,[[["self"]],["t"]]],[11,"get_type_id","","",81,[[["self"]],["typeid"]]],[11,"to_owned","","",82,[[["self"]],["t"]]],[11,"clone_into","","",82,N],[11,"from","","",82,[[["t"]],["t"]]],[11,"into","","",82,[[["self"]],["u"]]],[11,"try_from","","",82,[[["u"]],["result"]]],[11,"borrow","","",82,[[["self"]],["t"]]],[11,"try_into","","",82,[[["self"]],["result"]]],[11,"borrow_mut","","",82,[[["self"]],["t"]]],[11,"get_type_id","","",82,[[["self"]],["typeid"]]],[11,"to_owned","","",83,[[["self"]],["t"]]],[11,"clone_into","","",83,N],[11,"from","","",83,[[["t"]],["t"]]],[11,"into","","",83,[[["self"]],["u"]]],[11,"try_from","","",83,[[["u"]],["result"]]],[11,"borrow","","",83,[[["self"]],["t"]]],[11,"try_into","","",83,[[["self"]],["result"]]],[11,"borrow_mut","","",83,[[["self"]],["t"]]],[11,"get_type_id","","",83,[[["self"]],["typeid"]]],[11,"to_owned","","",84,[[["self"]],["t"]]],[11,"clone_into","","",84,N],[11,"from","","",84,[[["t"]],["t"]]],[11,"into","","",84,[[["self"]],["u"]]],[11,"try_from","","",84,[[["u"]],["result"]]],[11,"borrow","","",84,[[["self"]],["t"]]],[11,"try_into","","",84,[[["self"]],["result"]]],[11,"borrow_mut","","",84,[[["self"]],["t"]]],[11,"get_type_id","","",84,[[["self"]],["typeid"]]],[11,"to_owned","","",85,[[["self"]],["t"]]],[11,"clone_into","","",85,N],[11,"from","","",85,[[["t"]],["t"]]],[11,"into","","",85,[[["self"]],["u"]]],[11,"try_from","","",85,[[["u"]],["result"]]],[11,"borrow","","",85,[[["self"]],["t"]]],[11,"try_into","","",85,[[["self"]],["result"]]],[11,"borrow_mut","","",85,[[["self"]],["t"]]],[11,"get_type_id","","",85,[[["self"]],["typeid"]]],[11,"to_owned","","",86,[[["self"]],["t"]]],[11,"clone_into","","",86,N],[11,"from","","",86,[[["t"]],["t"]]],[11,"into","","",86,[[["self"]],["u"]]],[11,"try_from","","",86,[[["u"]],["result"]]],[11,"borrow","","",86,[[["self"]],["t"]]],[11,"try_into","","",86,[[["self"]],["result"]]],[11,"borrow_mut","","",86,[[["self"]],["t"]]],[11,"get_type_id","","",86,[[["self"]],["typeid"]]],[11,"to_owned","","",87,[[["self"]],["t"]]],[11,"clone_into","","",87,N],[11,"from","","",87,[[["t"]],["t"]]],[11,"into","","",87,[[["self"]],["u"]]],[11,"try_from","","",87,[[["u"]],["result"]]],[11,"borrow","","",87,[[["self"]],["t"]]],[11,"try_into","","",87,[[["self"]],["result"]]],[11,"borrow_mut","","",87,[[["self"]],["t"]]],[11,"get_type_id","","",87,[[["self"]],["typeid"]]],[11,"to_owned","","",88,[[["self"]],["t"]]],[11,"clone_into","","",88,N],[11,"from","","",88,[[["t"]],["t"]]],[11,"into","","",88,[[["self"]],["u"]]],[11,"try_from","","",88,[[["u"]],["result"]]],[11,"borrow","","",88,[[["self"]],["t"]]],[11,"try_into","","",88,[[["self"]],["result"]]],[11,"borrow_mut","","",88,[[["self"]],["t"]]],[11,"get_type_id","","",88,[[["self"]],["typeid"]]],[11,"to_owned","","",89,[[["self"]],["t"]]],[11,"clone_into","","",89,N],[11,"from","","",89,[[["t"]],["t"]]],[11,"into","","",89,[[["self"]],["u"]]],[11,"try_from","","",89,[[["u"]],["result"]]],[11,"borrow","","",89,[[["self"]],["t"]]],[11,"try_into","","",89,[[["self"]],["result"]]],[11,"borrow_mut","","",89,[[["self"]],["t"]]],[11,"get_type_id","","",89,[[["self"]],["typeid"]]],[11,"to_owned","","",90,[[["self"]],["t"]]],[11,"clone_into","","",90,N],[11,"from","","",90,[[["t"]],["t"]]],[11,"into","","",90,[[["self"]],["u"]]],[11,"try_from","","",90,[[["u"]],["result"]]],[11,"borrow","","",90,[[["self"]],["t"]]],[11,"try_into","","",90,[[["self"]],["result"]]],[11,"borrow_mut","","",90,[[["self"]],["t"]]],[11,"get_type_id","","",90,[[["self"]],["typeid"]]],[11,"to_owned","","",91,[[["self"]],["t"]]],[11,"clone_into","","",91,N],[11,"from","","",91,[[["t"]],["t"]]],[11,"into","","",91,[[["self"]],["u"]]],[11,"try_from","","",91,[[["u"]],["result"]]],[11,"borrow","","",91,[[["self"]],["t"]]],[11,"try_into","","",91,[[["self"]],["result"]]],[11,"borrow_mut","","",91,[[["self"]],["t"]]],[11,"get_type_id","","",91,[[["self"]],["typeid"]]],[11,"to_owned","","",92,[[["self"]],["t"]]],[11,"clone_into","","",92,N],[11,"from","","",92,[[["t"]],["t"]]],[11,"into","","",92,[[["self"]],["u"]]],[11,"try_from","","",92,[[["u"]],["result"]]],[11,"borrow","","",92,[[["self"]],["t"]]],[11,"try_into","","",92,[[["self"]],["result"]]],[11,"borrow_mut","","",92,[[["self"]],["t"]]],[11,"get_type_id","","",92,[[["self"]],["typeid"]]],[11,"to_owned","","",93,[[["self"]],["t"]]],[11,"clone_into","","",93,N],[11,"from","","",93,[[["t"]],["t"]]],[11,"into","","",93,[[["self"]],["u"]]],[11,"try_from","","",93,[[["u"]],["result"]]],[11,"borrow","","",93,[[["self"]],["t"]]],[11,"try_into","","",93,[[["self"]],["result"]]],[11,"borrow_mut","","",93,[[["self"]],["t"]]],[11,"get_type_id","","",93,[[["self"]],["typeid"]]],[11,"to_owned","","",94,[[["self"]],["t"]]],[11,"clone_into","","",94,N],[11,"from","","",94,[[["t"]],["t"]]],[11,"into","","",94,[[["self"]],["u"]]],[11,"try_from","","",94,[[["u"]],["result"]]],[11,"borrow","","",94,[[["self"]],["t"]]],[11,"try_into","","",94,[[["self"]],["result"]]],[11,"borrow_mut","","",94,[[["self"]],["t"]]],[11,"get_type_id","","",94,[[["self"]],["typeid"]]],[11,"to_owned","","",95,[[["self"]],["t"]]],[11,"clone_into","","",95,N],[11,"from","","",95,[[["t"]],["t"]]],[11,"into","","",95,[[["self"]],["u"]]],[11,"try_from","","",95,[[["u"]],["result"]]],[11,"borrow","","",95,[[["self"]],["t"]]],[11,"try_into","","",95,[[["self"]],["result"]]],[11,"borrow_mut","","",95,[[["self"]],["t"]]],[11,"get_type_id","","",95,[[["self"]],["typeid"]]],[11,"to_owned","","",96,[[["self"]],["t"]]],[11,"clone_into","","",96,N],[11,"from","","",96,[[["t"]],["t"]]],[11,"into","","",96,[[["self"]],["u"]]],[11,"try_from","","",96,[[["u"]],["result"]]],[11,"borrow","","",96,[[["self"]],["t"]]],[11,"try_into","","",96,[[["self"]],["result"]]],[11,"borrow_mut","","",96,[[["self"]],["t"]]],[11,"get_type_id","","",96,[[["self"]],["typeid"]]],[11,"to_owned","","",97,[[["self"]],["t"]]],[11,"clone_into","","",97,N],[11,"from","","",97,[[["t"]],["t"]]],[11,"into","","",97,[[["self"]],["u"]]],[11,"try_from","","",97,[[["u"]],["result"]]],[11,"borrow","","",97,[[["self"]],["t"]]],[11,"try_into","","",97,[[["self"]],["result"]]],[11,"borrow_mut","","",97,[[["self"]],["t"]]],[11,"get_type_id","","",97,[[["self"]],["typeid"]]],[11,"to_owned","","",98,[[["self"]],["t"]]],[11,"clone_into","","",98,N],[11,"from","","",98,[[["t"]],["t"]]],[11,"into","","",98,[[["self"]],["u"]]],[11,"try_from","","",98,[[["u"]],["result"]]],[11,"borrow","","",98,[[["self"]],["t"]]],[11,"try_into","","",98,[[["self"]],["result"]]],[11,"borrow_mut","","",98,[[["self"]],["t"]]],[11,"get_type_id","","",98,[[["self"]],["typeid"]]],[11,"to_owned","","",99,[[["self"]],["t"]]],[11,"clone_into","","",99,N],[11,"from","","",99,[[["t"]],["t"]]],[11,"into","","",99,[[["self"]],["u"]]],[11,"try_from","","",99,[[["u"]],["result"]]],[11,"borrow","","",99,[[["self"]],["t"]]],[11,"try_into","","",99,[[["self"]],["result"]]],[11,"borrow_mut","","",99,[[["self"]],["t"]]],[11,"get_type_id","","",99,[[["self"]],["typeid"]]],[11,"to_owned","","",100,[[["self"]],["t"]]],[11,"clone_into","","",100,N],[11,"from","","",100,[[["t"]],["t"]]],[11,"into","","",100,[[["self"]],["u"]]],[11,"try_from","","",100,[[["u"]],["result"]]],[11,"borrow","","",100,[[["self"]],["t"]]],[11,"try_into","","",100,[[["self"]],["result"]]],[11,"borrow_mut","","",100,[[["self"]],["t"]]],[11,"get_type_id","","",100,[[["self"]],["typeid"]]],[11,"to_owned","","",101,[[["self"]],["t"]]],[11,"clone_into","","",101,N],[11,"from","","",101,[[["t"]],["t"]]],[11,"into","","",101,[[["self"]],["u"]]],[11,"try_from","","",101,[[["u"]],["result"]]],[11,"borrow","","",101,[[["self"]],["t"]]],[11,"try_into","","",101,[[["self"]],["result"]]],[11,"borrow_mut","","",101,[[["self"]],["t"]]],[11,"get_type_id","","",101,[[["self"]],["typeid"]]],[11,"to_owned","","",102,[[["self"]],["t"]]],[11,"clone_into","","",102,N],[11,"from","","",102,[[["t"]],["t"]]],[11,"into","","",102,[[["self"]],["u"]]],[11,"try_from","","",102,[[["u"]],["result"]]],[11,"borrow","","",102,[[["self"]],["t"]]],[11,"try_into","","",102,[[["self"]],["result"]]],[11,"borrow_mut","","",102,[[["self"]],["t"]]],[11,"get_type_id","","",102,[[["self"]],["typeid"]]],[11,"to_owned","","",103,[[["self"]],["t"]]],[11,"clone_into","","",103,N],[11,"from","","",103,[[["t"]],["t"]]],[11,"into","","",103,[[["self"]],["u"]]],[11,"try_from","","",103,[[["u"]],["result"]]],[11,"borrow","","",103,[[["self"]],["t"]]],[11,"try_into","","",103,[[["self"]],["result"]]],[11,"borrow_mut","","",103,[[["self"]],["t"]]],[11,"get_type_id","","",103,[[["self"]],["typeid"]]],[11,"to_owned","","",104,[[["self"]],["t"]]],[11,"clone_into","","",104,N],[11,"from","","",104,[[["t"]],["t"]]],[11,"into","","",104,[[["self"]],["u"]]],[11,"try_from","","",104,[[["u"]],["result"]]],[11,"borrow","","",104,[[["self"]],["t"]]],[11,"try_into","","",104,[[["self"]],["result"]]],[11,"borrow_mut","","",104,[[["self"]],["t"]]],[11,"get_type_id","","",104,[[["self"]],["typeid"]]],[11,"to_owned","","",105,[[["self"]],["t"]]],[11,"clone_into","","",105,N],[11,"from","","",105,[[["t"]],["t"]]],[11,"into","","",105,[[["self"]],["u"]]],[11,"try_from","","",105,[[["u"]],["result"]]],[11,"borrow","","",105,[[["self"]],["t"]]],[11,"try_into","","",105,[[["self"]],["result"]]],[11,"borrow_mut","","",105,[[["self"]],["t"]]],[11,"get_type_id","","",105,[[["self"]],["typeid"]]],[11,"to_owned","","",106,[[["self"]],["t"]]],[11,"clone_into","","",106,N],[11,"from","","",106,[[["t"]],["t"]]],[11,"into","","",106,[[["self"]],["u"]]],[11,"try_from","","",106,[[["u"]],["result"]]],[11,"borrow","","",106,[[["self"]],["t"]]],[11,"try_into","","",106,[[["self"]],["result"]]],[11,"borrow_mut","","",106,[[["self"]],["t"]]],[11,"get_type_id","","",106,[[["self"]],["typeid"]]],[11,"to_owned","","",107,[[["self"]],["t"]]],[11,"clone_into","","",107,N],[11,"from","","",107,[[["t"]],["t"]]],[11,"into","","",107,[[["self"]],["u"]]],[11,"try_from","","",107,[[["u"]],["result"]]],[11,"borrow","","",107,[[["self"]],["t"]]],[11,"try_into","","",107,[[["self"]],["result"]]],[11,"borrow_mut","","",107,[[["self"]],["t"]]],[11,"get_type_id","","",107,[[["self"]],["typeid"]]],[11,"to_owned","","",108,[[["self"]],["t"]]],[11,"clone_into","","",108,N],[11,"from","","",108,[[["t"]],["t"]]],[11,"into","","",108,[[["self"]],["u"]]],[11,"try_from","","",108,[[["u"]],["result"]]],[11,"borrow","","",108,[[["self"]],["t"]]],[11,"try_into","","",108,[[["self"]],["result"]]],[11,"borrow_mut","","",108,[[["self"]],["t"]]],[11,"get_type_id","","",108,[[["self"]],["typeid"]]],[11,"to_owned","","",109,[[["self"]],["t"]]],[11,"clone_into","","",109,N],[11,"from","","",109,[[["t"]],["t"]]],[11,"into","","",109,[[["self"]],["u"]]],[11,"try_from","","",109,[[["u"]],["result"]]],[11,"borrow","","",109,[[["self"]],["t"]]],[11,"try_into","","",109,[[["self"]],["result"]]],[11,"borrow_mut","","",109,[[["self"]],["t"]]],[11,"get_type_id","","",109,[[["self"]],["typeid"]]],[11,"to_owned","","",110,[[["self"]],["t"]]],[11,"clone_into","","",110,N],[11,"from","","",110,[[["t"]],["t"]]],[11,"into","","",110,[[["self"]],["u"]]],[11,"try_from","","",110,[[["u"]],["result"]]],[11,"borrow","","",110,[[["self"]],["t"]]],[11,"try_into","","",110,[[["self"]],["result"]]],[11,"borrow_mut","","",110,[[["self"]],["t"]]],[11,"get_type_id","","",110,[[["self"]],["typeid"]]],[11,"to_owned","","",111,[[["self"]],["t"]]],[11,"clone_into","","",111,N],[11,"from","","",111,[[["t"]],["t"]]],[11,"into","","",111,[[["self"]],["u"]]],[11,"try_from","","",111,[[["u"]],["result"]]],[11,"borrow","","",111,[[["self"]],["t"]]],[11,"try_into","","",111,[[["self"]],["result"]]],[11,"borrow_mut","","",111,[[["self"]],["t"]]],[11,"get_type_id","","",111,[[["self"]],["typeid"]]],[11,"to_owned","","",112,[[["self"]],["t"]]],[11,"clone_into","","",112,N],[11,"from","","",112,[[["t"]],["t"]]],[11,"into","","",112,[[["self"]],["u"]]],[11,"try_from","","",112,[[["u"]],["result"]]],[11,"borrow","","",112,[[["self"]],["t"]]],[11,"try_into","","",112,[[["self"]],["result"]]],[11,"borrow_mut","","",112,[[["self"]],["t"]]],[11,"get_type_id","","",112,[[["self"]],["typeid"]]],[11,"to_owned","","",113,[[["self"]],["t"]]],[11,"clone_into","","",113,N],[11,"from","","",113,[[["t"]],["t"]]],[11,"into","","",113,[[["self"]],["u"]]],[11,"try_from","","",113,[[["u"]],["result"]]],[11,"borrow","","",113,[[["self"]],["t"]]],[11,"try_into","","",113,[[["self"]],["result"]]],[11,"borrow_mut","","",113,[[["self"]],["t"]]],[11,"get_type_id","","",113,[[["self"]],["typeid"]]],[11,"to_owned","","",114,[[["self"]],["t"]]],[11,"clone_into","","",114,N],[11,"from","","",114,[[["t"]],["t"]]],[11,"into","","",114,[[["self"]],["u"]]],[11,"try_from","","",114,[[["u"]],["result"]]],[11,"borrow","","",114,[[["self"]],["t"]]],[11,"try_into","","",114,[[["self"]],["result"]]],[11,"borrow_mut","","",114,[[["self"]],["t"]]],[11,"get_type_id","","",114,[[["self"]],["typeid"]]],[11,"to_owned","","",115,[[["self"]],["t"]]],[11,"clone_into","","",115,N],[11,"from","","",115,[[["t"]],["t"]]],[11,"into","","",115,[[["self"]],["u"]]],[11,"try_from","","",115,[[["u"]],["result"]]],[11,"borrow","","",115,[[["self"]],["t"]]],[11,"try_into","","",115,[[["self"]],["result"]]],[11,"borrow_mut","","",115,[[["self"]],["t"]]],[11,"get_type_id","","",115,[[["self"]],["typeid"]]],[11,"to_owned","","",116,[[["self"]],["t"]]],[11,"clone_into","","",116,N],[11,"from","","",116,[[["t"]],["t"]]],[11,"into","","",116,[[["self"]],["u"]]],[11,"try_from","","",116,[[["u"]],["result"]]],[11,"borrow","","",116,[[["self"]],["t"]]],[11,"try_into","","",116,[[["self"]],["result"]]],[11,"borrow_mut","","",116,[[["self"]],["t"]]],[11,"get_type_id","","",116,[[["self"]],["typeid"]]],[11,"to_owned","","",117,[[["self"]],["t"]]],[11,"clone_into","","",117,N],[11,"from","","",117,[[["t"]],["t"]]],[11,"into","","",117,[[["self"]],["u"]]],[11,"try_from","","",117,[[["u"]],["result"]]],[11,"borrow","","",117,[[["self"]],["t"]]],[11,"try_into","","",117,[[["self"]],["result"]]],[11,"borrow_mut","","",117,[[["self"]],["t"]]],[11,"get_type_id","","",117,[[["self"]],["typeid"]]],[11,"to_owned","","",118,[[["self"]],["t"]]],[11,"clone_into","","",118,N],[11,"from","","",118,[[["t"]],["t"]]],[11,"into","","",118,[[["self"]],["u"]]],[11,"try_from","","",118,[[["u"]],["result"]]],[11,"borrow","","",118,[[["self"]],["t"]]],[11,"try_into","","",118,[[["self"]],["result"]]],[11,"borrow_mut","","",118,[[["self"]],["t"]]],[11,"get_type_id","","",118,[[["self"]],["typeid"]]],[11,"to_owned","","",119,[[["self"]],["t"]]],[11,"clone_into","","",119,N],[11,"from","","",119,[[["t"]],["t"]]],[11,"into","","",119,[[["self"]],["u"]]],[11,"try_from","","",119,[[["u"]],["result"]]],[11,"borrow","","",119,[[["self"]],["t"]]],[11,"try_into","","",119,[[["self"]],["result"]]],[11,"borrow_mut","","",119,[[["self"]],["t"]]],[11,"get_type_id","","",119,[[["self"]],["typeid"]]],[11,"to_owned","","",120,[[["self"]],["t"]]],[11,"clone_into","","",120,N],[11,"from","","",120,[[["t"]],["t"]]],[11,"into","","",120,[[["self"]],["u"]]],[11,"try_from","","",120,[[["u"]],["result"]]],[11,"borrow","","",120,[[["self"]],["t"]]],[11,"try_into","","",120,[[["self"]],["result"]]],[11,"borrow_mut","","",120,[[["self"]],["t"]]],[11,"get_type_id","","",120,[[["self"]],["typeid"]]],[11,"to_owned","","",121,[[["self"]],["t"]]],[11,"clone_into","","",121,N],[11,"from","","",121,[[["t"]],["t"]]],[11,"into","","",121,[[["self"]],["u"]]],[11,"try_from","","",121,[[["u"]],["result"]]],[11,"borrow","","",121,[[["self"]],["t"]]],[11,"try_into","","",121,[[["self"]],["result"]]],[11,"borrow_mut","","",121,[[["self"]],["t"]]],[11,"get_type_id","","",121,[[["self"]],["typeid"]]],[11,"to_owned","","",122,[[["self"]],["t"]]],[11,"clone_into","","",122,N],[11,"from","","",122,[[["t"]],["t"]]],[11,"into","","",122,[[["self"]],["u"]]],[11,"try_from","","",122,[[["u"]],["result"]]],[11,"borrow","","",122,[[["self"]],["t"]]],[11,"try_into","","",122,[[["self"]],["result"]]],[11,"borrow_mut","","",122,[[["self"]],["t"]]],[11,"get_type_id","","",122,[[["self"]],["typeid"]]],[11,"to_owned","","",123,[[["self"]],["t"]]],[11,"clone_into","","",123,N],[11,"from","","",123,[[["t"]],["t"]]],[11,"into","","",123,[[["self"]],["u"]]],[11,"try_from","","",123,[[["u"]],["result"]]],[11,"borrow","","",123,[[["self"]],["t"]]],[11,"try_into","","",123,[[["self"]],["result"]]],[11,"borrow_mut","","",123,[[["self"]],["t"]]],[11,"get_type_id","","",123,[[["self"]],["typeid"]]],[11,"to_owned","","",124,[[["self"]],["t"]]],[11,"clone_into","","",124,N],[11,"from","","",124,[[["t"]],["t"]]],[11,"into","","",124,[[["self"]],["u"]]],[11,"try_from","","",124,[[["u"]],["result"]]],[11,"borrow","","",124,[[["self"]],["t"]]],[11,"try_into","","",124,[[["self"]],["result"]]],[11,"borrow_mut","","",124,[[["self"]],["t"]]],[11,"get_type_id","","",124,[[["self"]],["typeid"]]],[11,"to_owned","","",125,[[["self"]],["t"]]],[11,"clone_into","","",125,N],[11,"from","","",125,[[["t"]],["t"]]],[11,"into","","",125,[[["self"]],["u"]]],[11,"try_from","","",125,[[["u"]],["result"]]],[11,"borrow","","",125,[[["self"]],["t"]]],[11,"try_into","","",125,[[["self"]],["result"]]],[11,"borrow_mut","","",125,[[["self"]],["t"]]],[11,"get_type_id","","",125,[[["self"]],["typeid"]]],[11,"to_owned","","",126,[[["self"]],["t"]]],[11,"clone_into","","",126,N],[11,"from","","",126,[[["t"]],["t"]]],[11,"into","","",126,[[["self"]],["u"]]],[11,"try_from","","",126,[[["u"]],["result"]]],[11,"borrow","","",126,[[["self"]],["t"]]],[11,"try_into","","",126,[[["self"]],["result"]]],[11,"borrow_mut","","",126,[[["self"]],["t"]]],[11,"get_type_id","","",126,[[["self"]],["typeid"]]],[11,"to_owned","","",127,[[["self"]],["t"]]],[11,"clone_into","","",127,N],[11,"from","","",127,[[["t"]],["t"]]],[11,"into","","",127,[[["self"]],["u"]]],[11,"try_from","","",127,[[["u"]],["result"]]],[11,"borrow","","",127,[[["self"]],["t"]]],[11,"try_into","","",127,[[["self"]],["result"]]],[11,"borrow_mut","","",127,[[["self"]],["t"]]],[11,"get_type_id","","",127,[[["self"]],["typeid"]]],[11,"to_owned","","",128,[[["self"]],["t"]]],[11,"clone_into","","",128,N],[11,"from","","",128,[[["t"]],["t"]]],[11,"into","","",128,[[["self"]],["u"]]],[11,"try_from","","",128,[[["u"]],["result"]]],[11,"borrow","","",128,[[["self"]],["t"]]],[11,"try_into","","",128,[[["self"]],["result"]]],[11,"borrow_mut","","",128,[[["self"]],["t"]]],[11,"get_type_id","","",128,[[["self"]],["typeid"]]],[11,"to_owned","","",129,[[["self"]],["t"]]],[11,"clone_into","","",129,N],[11,"from","","",129,[[["t"]],["t"]]],[11,"into","","",129,[[["self"]],["u"]]],[11,"try_from","","",129,[[["u"]],["result"]]],[11,"borrow","","",129,[[["self"]],["t"]]],[11,"try_into","","",129,[[["self"]],["result"]]],[11,"borrow_mut","","",129,[[["self"]],["t"]]],[11,"get_type_id","","",129,[[["self"]],["typeid"]]],[11,"to_owned","","",130,[[["self"]],["t"]]],[11,"clone_into","","",130,N],[11,"from","","",130,[[["t"]],["t"]]],[11,"into","","",130,[[["self"]],["u"]]],[11,"try_from","","",130,[[["u"]],["result"]]],[11,"borrow","","",130,[[["self"]],["t"]]],[11,"try_into","","",130,[[["self"]],["result"]]],[11,"borrow_mut","","",130,[[["self"]],["t"]]],[11,"get_type_id","","",130,[[["self"]],["typeid"]]],[11,"from","","",131,[[["t"]],["t"]]],[11,"into","","",131,[[["self"]],["u"]]],[11,"try_from","","",131,[[["u"]],["result"]]],[11,"borrow","","",131,[[["self"]],["t"]]],[11,"try_into","","",131,[[["self"]],["result"]]],[11,"borrow_mut","","",131,[[["self"]],["t"]]],[11,"get_type_id","","",131,[[["self"]],["typeid"]]],[11,"from","","",136,[[["t"]],["t"]]],[11,"into","","",136,[[["self"]],["u"]]],[11,"try_from","","",136,[[["u"]],["result"]]],[11,"borrow","","",136,[[["self"]],["t"]]],[11,"try_into","","",136,[[["self"]],["result"]]],[11,"borrow_mut","","",136,[[["self"]],["t"]]],[11,"get_type_id","","",136,[[["self"]],["typeid"]]],[11,"from","","",137,[[["t"]],["t"]]],[11,"into","","",137,[[["self"]],["u"]]],[11,"try_from","","",137,[[["u"]],["result"]]],[11,"borrow","","",137,[[["self"]],["t"]]],[11,"try_into","","",137,[[["self"]],["result"]]],[11,"borrow_mut","","",137,[[["self"]],["t"]]],[11,"get_type_id","","",137,[[["self"]],["typeid"]]],[11,"from","","",138,[[["t"]],["t"]]],[11,"into","","",138,[[["self"]],["u"]]],[11,"try_from","","",138,[[["u"]],["result"]]],[11,"borrow","","",138,[[["self"]],["t"]]],[11,"try_into","","",138,[[["self"]],["result"]]],[11,"borrow_mut","","",138,[[["self"]],["t"]]],[11,"get_type_id","","",138,[[["self"]],["typeid"]]],[11,"from","","",139,[[["t"]],["t"]]],[11,"into","","",139,[[["self"]],["u"]]],[11,"try_from","","",139,[[["u"]],["result"]]],[11,"borrow","","",139,[[["self"]],["t"]]],[11,"try_into","","",139,[[["self"]],["result"]]],[11,"borrow_mut","","",139,[[["self"]],["t"]]],[11,"get_type_id","","",139,[[["self"]],["typeid"]]],[11,"from","","",140,[[["t"]],["t"]]],[11,"into","","",140,[[["self"]],["u"]]],[11,"try_from","","",140,[[["u"]],["result"]]],[11,"borrow","","",140,[[["self"]],["t"]]],[11,"try_into","","",140,[[["self"]],["result"]]],[11,"borrow_mut","","",140,[[["self"]],["t"]]],[11,"get_type_id","","",140,[[["self"]],["typeid"]]],[11,"from","","",141,[[["t"]],["t"]]],[11,"into","","",141,[[["self"]],["u"]]],[11,"try_from","","",141,[[["u"]],["result"]]],[11,"borrow","","",141,[[["self"]],["t"]]],[11,"try_into","","",141,[[["self"]],["result"]]],[11,"borrow_mut","","",141,[[["self"]],["t"]]],[11,"get_type_id","","",141,[[["self"]],["typeid"]]],[11,"is_some","libc::dox::imp","Returns `true` if the option is a [`Some`] value.",132,[[["self"]],["bool"]]],[11,"is_none","","Returns `true` if the option is a [`None`] value.",132,[[["self"]],["bool"]]],[11,"as_ref","","Converts from `Option<T>` to `Option<&T>`.",132,[[["self"]],["option"]]],[11,"as_mut","","Converts from `Option<T>` to `Option<&mut T>`.",132,[[["self"]],["option"]]],[11,"as_pin_mut","","Converts from `Option<T>` to `Option<PinMut<'_, T>>`",132,[[["pinmut",["option"]]],["option",["pinmut"]]]],[11,"expect","","Unwraps an option, yielding the content of a [`Some`].",132,[[["self"],["str"]],["t"]]],[11,"unwrap","","Moves the value `v` out of the `Option<T>` if it is [`Some(v)`].",132,[[["self"]],["t"]]],[11,"unwrap_or","","Returns the contained value or a default.",132,[[["self"],["t"]],["t"]]],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",132,[[["self"],["f"]],["t"]]],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function to a contained value.",132,[[["self"],["f"]],["option"]]],[11,"map_or","","Applies a function to the contained value (if any), or returns the provided default (if not).",132,[[["self"],["u"],["f"]],["u"]]],[11,"map_or_else","","Applies a function to the contained value (if any), or computes a default (if not).",132,[[["self"],["d"],["f"]],["u"]]],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err)`].",132,[[["self"],["e"]],["result"]]],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err())`].",132,[[["self"],["f"]],["result"]]],[11,"iter","","Returns an iterator over the possibly contained value.",132,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",132,[[["self"]],["itermut"]]],[11,"and","","Returns [`None`] if the option is [`None`], otherwise returns `optb`.",132,[[["self"],["option"]],["option"]]],[11,"and_then","","Returns [`None`] if the option is [`None`], otherwise calls `f` with the wrapped value and returns the result.",132,[[["self"],["f"]],["option"]]],[11,"filter","","Returns `None` if the option is `None`, otherwise calls `predicate` with the wrapped value and returns:",132,[[["self"],["p"]],["option"]]],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",132,[[["self"],["option"]],["option"]]],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and returns the result.",132,[[["self"],["f"]],["option"]]],[11,"xor","","Returns [`Some`] if exactly one of `self`, `optb` is [`Some`], otherwise returns `None`.",132,[[["self"],["option"]],["option"]]],[11,"get_or_insert","","Inserts `v` into the option if it is [`None`], then returns a mutable reference to the contained value.",132,[[["self"],["t"]],["t"]]],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is [`None`], then returns a mutable reference to the contained value.",132,[[["self"],["f"]],["t"]]],[11,"take","","Takes the value out of the option, leaving a [`None`] in its place.",132,[[["self"]],["option"]]],[11,"replace","","Replaces the actual value in the option by the value given in parameter, returning the old value if present, leaving a [`Some`] in its place without deinitializing either one.",132,[[["self"],["t"]],["option"]]],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the contents of the option.",132,[[["self"]],["option"]]],[11,"cloned","","Maps an `Option<&mut T>` to an `Option<T>` by cloning the contents of the option.",132,[[["self"]],["option"]]],[11,"unwrap_or_default","","Returns the contained value or a default",132,[[["self"]],["t"]]],[11,"deref","","Converts from `&Option<T>` to `Option<&T::Target>`.",132,[[["self"]],["option"]]],[11,"transpose","","Transposes an `Option` of a `Result` into a `Result` of an `Option`.",132,[[["self"]],["result",["option"]]]],[11,"to_owned","","",132,[[["self"]],["t"]]],[11,"clone_into","","",132,N],[11,"from","","",132,[[["t"]],["t"]]],[11,"into_iter","","",132,[[["self"]],["i"]]],[11,"into","","",132,[[["self"]],["u"]]],[11,"try_from","","",132,[[["u"]],["result"]]],[11,"borrow","","",132,[[["self"]],["t"]]],[11,"try_into","","",132,[[["self"]],["result"]]],[11,"borrow_mut","","",132,[[["self"]],["t"]]],[11,"get_type_id","","",132,[[["self"]],["typeid"]]],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",132,[[["self"]],["intoiter"]]],[11,"hash","libc::dox::imp::mem","",134,N],[11,"hash","libc::dox::imp","",132,N],[11,"hash","libc::dox::imp::mem","",135,N],[11,"clone","libc::dox::imp","",132,[[["self"]],["option"]]],[11,"clone","libc::dox::imp::mem","",135,[[["self"]],["manuallydrop"]]],[11,"clone","","",134,[[["self"]],["discriminant"]]],[11,"partial_cmp","","",135,[[["self"],["manuallydrop"]],["option",["ordering"]]]],[11,"lt","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"le","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"gt","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"ge","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"partial_cmp","libc::dox::imp","",132,[[["self"],["option"]],["option",["ordering"]]]],[11,"lt","","",132,[[["self"],["option"]],["bool"]]],[11,"le","","",132,[[["self"],["option"]],["bool"]]],[11,"gt","","",132,[[["self"],["option"]],["bool"]]],[11,"ge","","",132,[[["self"],["option"]],["bool"]]],[11,"cmp","","",132,[[["self"],["option"]],["ordering"]]],[11,"cmp","libc::dox::imp::mem","",135,[[["self"],["manuallydrop"]],["ordering"]]],[11,"fmt","","",135,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","libc::dox::imp","",132,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","libc::dox::imp::mem","",134,[[["self"],["formatter"]],["result",["error"]]]],[11,"assert_receiver_is_total_eq","libc::dox::imp","",132,N],[11,"assert_receiver_is_total_eq","libc::dox::imp::mem","",135,N],[11,"eq","","",134,[[["self"],["discriminant"]],["bool"]]],[11,"eq","libc::dox::imp","",132,[[["self"],["option"]],["bool"]]],[11,"ne","","",132,[[["self"],["option"]],["bool"]]],[11,"eq","libc::dox::imp::mem","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"ne","","",135,[[["self"],["manuallydrop"]],["bool"]]],[11,"from","libc::dox::imp","",132,[[["option"]],["option"]]],[11,"from","","",132,[[["t"]],["option"]]],[11,"from","","",132,[[["option"]],["option"]]],[11,"from_iter","","Takes each element in the [`Iterator`]: if it is [`None`][Option::None], no further elements are taken, and the [`None`][Option::None] is returned. Should no [`None`][Option::None] occur, a container with the values of each [`Option`] is returned.",132,[[["i"]],["option"]]],[11,"into_result","","",132,[[["self"]],["result",["noneerror"]]]],[11,"from_ok","","",132,[[["t"]],["option"]]],[11,"from_error","","",132,[[["noneerror"]],["option"]]],[11,"deref_mut","libc::dox::imp::mem","",135,N],[11,"default","","",135,[[],["manuallydrop"]]],[11,"default","libc::dox::imp","Returns [`None`][Option::None].",132,[[],["option"]]],[11,"deref","libc::dox::imp::mem","",135,N],[11,"to_owned","","",134,[[["self"]],["t"]]],[11,"clone_into","","",134,N],[11,"from","","",134,[[["t"]],["t"]]],[11,"into","","",134,[[["self"]],["u"]]],[11,"try_from","","",134,[[["u"]],["result"]]],[11,"borrow","","",134,[[["self"]],["t"]]],[11,"try_into","","",134,[[["self"]],["result"]]],[11,"borrow_mut","","",134,[[["self"]],["t"]]],[11,"get_type_id","","",134,[[["self"]],["typeid"]]],[11,"new","","Wrap a value to be manually dropped.",135,[[["t"]],["manuallydrop"]]],[11,"into_inner","","Extract the value from the `ManuallyDrop` container.",135,[[["manuallydrop"]],["t"]]],[11,"drop","","Manually drops the contained value.",135,N],[11,"to_owned","","",135,[[["self"]],["t"]]],[11,"clone_into","","",135,N],[11,"from","","",135,[[["t"]],["t"]]],[11,"into","","",135,[[["self"]],["u"]]],[11,"try_from","","",135,[[["u"]],["result"]]],[11,"borrow","","",135,[[["self"]],["t"]]],[11,"try_into","","",135,[[["self"]],["result"]]],[11,"borrow_mut","","",135,[[["self"]],["t"]]],[11,"get_type_id","","",135,[[["self"]],["typeid"]]]],"paths":[[3,"group"],[3,"utimbuf"],[3,"timeval"],[3,"timespec"],[3,"rlimit"],[3,"rusage"],[3,"in_addr"],[3,"in6_addr"],[3,"ip_mreq"],[3,"ipv6_mreq"],[3,"hostent"],[3,"iovec"],[3,"pollfd"],[3,"winsize"],[3,"linger"],[3,"sigval"],[3,"itimerval"],[3,"tms"],[3,"servent"],[3,"protoent"],[3,"sockaddr"],[3,"sockaddr_in"],[3,"sockaddr_in6"],[3,"sockaddr_un"],[3,"sockaddr_storage"],[3,"addrinfo"],[3,"sockaddr_nl"],[3,"sockaddr_ll"],[3,"fd_set"],[3,"tm"],[3,"sched_param"],[3,"Dl_info"],[3,"epoll_event"],[3,"utsname"],[3,"lconv"],[3,"sigevent"],[3,"in_pktinfo"],[3,"ifaddrs"],[3,"in6_rtmsg"],[3,"arpreq"],[3,"arpreq_old"],[3,"arphdr"],[3,"dirent"],[3,"dirent64"],[3,"rlimit64"],[3,"glob_t"],[3,"pthread_mutex_t"],[3,"pthread_rwlock_t"],[3,"pthread_mutexattr_t"],[3,"pthread_rwlockattr_t"],[3,"pthread_cond_t"],[3,"pthread_condattr_t"],[3,"passwd"],[3,"spwd"],[3,"dqblk"],[3,"signalfd_siginfo"],[3,"itimerspec"],[3,"fsid_t"],[3,"mq_attr"],[3,"packet_mreq"],[3,"cpu_set_t"],[3,"if_nameindex"],[3,"msginfo"],[3,"mmsghdr"],[3,"sembuf"],[3,"input_event"],[3,"input_id"],[3,"input_absinfo"],[3,"input_keymap_entry"],[3,"input_mask"],[3,"ff_replay"],[3,"ff_trigger"],[3,"ff_envelope"],[3,"ff_constant_effect"],[3,"ff_ramp_effect"],[3,"ff_condition_effect"],[3,"ff_periodic_effect"],[3,"ff_rumble_effect"],[3,"ff_effect"],[3,"dl_phdr_info"],[3,"Elf32_Phdr"],[3,"Elf64_Phdr"],[3,"ucred"],[3,"mntent"],[3,"posix_spawn_file_actions_t"],[3,"posix_spawnattr_t"],[3,"genlmsghdr"],[3,"in6_pktinfo"],[3,"arpd_request"],[3,"aiocb"],[3,"__exit_status"],[3,"__timeval"],[3,"utmpx"],[3,"sigaction"],[3,"stack_t"],[3,"siginfo_t"],[3,"glob64_t"],[3,"statfs"],[3,"msghdr"],[3,"cmsghdr"],[3,"termios"],[3,"flock"],[3,"sem_t"],[3,"mallinfo"],[3,"nlmsghdr"],[3,"nlmsgerr"],[3,"nl_pktinfo"],[3,"nl_mmap_req"],[3,"nl_mmap_hdr"],[3,"nlattr"],[3,"rtentry"],[3,"sigset_t"],[3,"sysinfo"],[3,"msqid_ds"],[3,"stat"],[3,"stat64"],[3,"statfs64"],[3,"statvfs64"],[3,"pthread_attr_t"],[3,"_libc_fpxreg"],[3,"_libc_xmmreg"],[3,"_libc_fpstate"],[3,"user_fpregs_struct"],[3,"user_regs_struct"],[3,"user"],[3,"mcontext_t"],[3,"ucontext_t"],[3,"ipc_perm"],[3,"shmid_ds"],[3,"termios2"],[3,"statvfs"],[4,"c_void"],[4,"Option"],[8,"Clone"],[3,"Discriminant"],[3,"ManuallyDrop"],[4,"FILE"],[4,"fpos_t"],[4,"DIR"],[4,"locale_t"],[4,"timezone"],[4,"fpos64_t"]]};
searchIndex["macro_utils"]={"doc":"Some useful and funny macros.","items":[[0,"if_match","macro_utils","",N,N],[0,"tern_c","","",N,N],[0,"tern_haskell","","",N,N],[0,"tern_python","","",N,N],[14,"if_match","","A macro to make big else if conditions easier to read:",N,N],[14,"tern_c","","You miss C-like ternary conditions? Why not having them in Rust then?",N,N],[14,"tern_haskell","","You miss Haskell-like ternary conditions? Why not having them in Rust then?",N,N],[14,"tern_python","","You miss Python-like ternary conditions? Why not having them in Rust then?",N,N],[14,"tern_py","","The same as [`tern_python`] macro but shorter:",N,N]],"paths":[]};
searchIndex["minifier"]={"doc":"","items":[[0,"css","minifier","",N,N],[5,"minify","minifier::css","Minifies a given CSS source code.",N,[[["str"]],["result",["string","str"]]]],[0,"token","","",N,N],[3,"Tokens","minifier::css::token","",N,N],[12,"0","","",0,N],[4,"ReservedChar","","",N,N],[13,"Comma","","",1,N],[13,"SuperiorThan","","",1,N],[13,"OpenParenthese","","",1,N],[13,"CloseParenthese","","",1,N],[13,"OpenCurlyBrace","","",1,N],[13,"CloseCurlyBrace","","",1,N],[13,"OpenBracket","","",1,N],[13,"CloseBracket","","",1,N],[13,"Colon","","",1,N],[13,"SemiColon","","",1,N],[13,"Slash","","",1,N],[13,"Plus","","",1,N],[13,"EqualSign","","",1,N],[13,"Space","","",1,N],[13,"Tab","","",1,N],[13,"Backline","","",1,N],[13,"Star","","",1,N],[13,"Quote","","",1,N],[13,"DoubleQuote","","",1,N],[13,"Pipe","","",1,N],[13,"Tilde","","",1,N],[13,"Dollar","","",1,N],[13,"Circumflex","","",1,N],[4,"SelectorElement","","",N,N],[13,"PseudoClass","","",2,N],[13,"Class","","",2,N],[13,"Id","","",2,N],[13,"Tag","","",2,N],[13,"Media","","",2,N],[4,"SelectorOperator","","",N,N],[13,"OneAttributeEquals","","`~=`",3,N],[13,"EqualsOrStartsWithFollowedByDash","","`|=`",3,N],[13,"EndsWith","","`$=`",3,N],[13,"FirstStartsWith","","`^=`",3,N],[13,"Contains","","`*=`",3,N],[4,"Token","","",N,N],[13,"Comment","","Comment.",4,N],[13,"License","","Comment starting with `/**`.",4,N],[13,"Char","","",4,N],[13,"Other","","",4,N],[13,"SelectorElement","","",4,N],[13,"String","","",4,N],[13,"SelectorOperator","","",4,N],[5,"get_line_comment","","",N,[[["str"],["peekable"],["usize"]],["option",["token"]]]],[5,"get_comment","","",N,[[["str"],["peekable"],["usize"]],["option",["token"]]]],[5,"get_string","","",N,[[["str"],["peekable"],["usize"],["reservedchar"]],["option",["token"]]]],[5,"fill_other","","",N,[[["str"],["vec"],["usize"],["usize"],["isize"],["bool"],["bool"]]]],[5,"tokenize","","",N,[[["str"]],["result",["tokens","str"]]]],[5,"clean_tokens","","",N,[[["vec",["token"]]],["vec",["token"]]]],[8,"MyTryFrom","","",N,N],[16,"Error","","",5,N],[10,"try_from","","",5,[[["t"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"eq","","",1,[[["self"],["reservedchar"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",1,N],[11,"clone","","",1,[[["self"]],["reservedchar"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",1,[[["char"]],["result",["reservedchar"]]]],[11,"is_useless","","",1,[[["self"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",2,N],[11,"eq","","",2,[[["self"],["selectorelement"]],["bool"]]],[11,"ne","","",2,[[["self"],["selectorelement"]],["bool"]]],[11,"clone","","",2,[[["self"]],["selectorelement"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",2,[[["str"]],["result",["selectorelement"]]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",3,N],[11,"eq","","",3,[[["self"],["selectoroperator"]],["bool"]]],[11,"clone","","",3,[[["self"]],["selectoroperator"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",4,N],[11,"eq","","",4,[[["self"],["token"]],["bool"]]],[11,"ne","","",4,[[["self"],["token"]],["bool"]]],[11,"clone","","",4,[[["self"]],["token"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"is_comment","","",4,[[["self"]],["bool"]]],[11,"is_char","","",4,[[["self"]],["bool"]]],[11,"get_char","","",4,[[["self"]],["option",["reservedchar"]]]],[11,"is_useless","","",4,[[["self"]],["bool"]]],[11,"is_media","","",4,[[["self"],["str"]],["bool"]]],[11,"is_a_media","","",4,[[["self"]],["bool"]]],[11,"is_a_license","","",4,[[["self"]],["bool"]]],[11,"eq","","",4,[[["self"],["reservedchar"]],["bool"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"eq","","",0,[[["self"],["tokens"]],["bool"]]],[11,"ne","","",0,[[["self"],["tokens"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",0,N],[11,"clone","","",0,[[["self"]],["tokens"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[0,"css","minifier::css","",N,N],[5,"minify","minifier::css::css","Minifies a given CSS source code.",N,[[["str"]],["result",["string","str"]]]],[0,"js","minifier","",N,N],[4,"Keyword","minifier::js","",N,N],[13,"Break","","",6,N],[13,"Case","","",6,N],[13,"Catch","","",6,N],[13,"Const","","",6,N],[13,"Continue","","",6,N],[13,"Default","","",6,N],[13,"Do","","",6,N],[13,"Else","","",6,N],[13,"False","","",6,N],[13,"Finally","","",6,N],[13,"Function","","",6,N],[13,"For","","",6,N],[13,"If","","",6,N],[13,"In","","",6,N],[13,"InstanceOf","","",6,N],[13,"New","","",6,N],[13,"Null","","",6,N],[13,"Private","","",6,N],[13,"Protected","","",6,N],[13,"Public","","",6,N],[13,"Return","","",6,N],[13,"Switch","","",6,N],[13,"This","","",6,N],[13,"Throw","","",6,N],[13,"True","","",6,N],[13,"Try","","",6,N],[13,"Typeof","","",6,N],[13,"Static","","",6,N],[13,"Var","","",6,N],[13,"While","","",6,N],[5,"minify","","Minifies a given JS source code.",N,[[["str"]],["string"]]],[5,"minify_and_replace_keywords","","Minifies a given JS source code and to replace keywords.",N,N],[0,"token","","",N,N],[3,"Tokens","minifier::js::token","",N,N],[12,"0","","",7,N],[4,"ReservedChar","","",N,N],[13,"Comma","","",8,N],[13,"OpenParenthese","","",8,N],[13,"CloseParenthese","","",8,N],[13,"OpenCurlyBrace","","",8,N],[13,"CloseCurlyBrace","","",8,N],[13,"OpenBracket","","",8,N],[13,"CloseBracket","","",8,N],[13,"Colon","","",8,N],[13,"SemiColon","","",8,N],[13,"Dot","","",8,N],[13,"Quote","","",8,N],[13,"DoubleQuote","","",8,N],[13,"ExclamationMark","","",8,N],[13,"QuestionMark","","",8,N],[13,"Slash","","",8,N],[13,"Modulo","","",8,N],[13,"Star","","",8,N],[13,"Minus","","",8,N],[13,"Plus","","",8,N],[13,"EqualSign","","",8,N],[13,"Backslash","","",8,N],[13,"Space","","",8,N],[13,"Tab","","",8,N],[13,"Backline","","",8,N],[13,"LessThan","","",8,N],[13,"SuperiorThan","","",8,N],[13,"Pipe","","",8,N],[13,"Ampersand","","",8,N],[4,"Keyword","","",N,N],[13,"Break","","",6,N],[13,"Case","","",6,N],[13,"Catch","","",6,N],[13,"Const","","",6,N],[13,"Continue","","",6,N],[13,"Default","","",6,N],[13,"Do","","",6,N],[13,"Else","","",6,N],[13,"False","","",6,N],[13,"Finally","","",6,N],[13,"Function","","",6,N],[13,"For","","",6,N],[13,"If","","",6,N],[13,"In","","",6,N],[13,"InstanceOf","","",6,N],[13,"New","","",6,N],[13,"Null","","",6,N],[13,"Private","","",6,N],[13,"Protected","","",6,N],[13,"Public","","",6,N],[13,"Return","","",6,N],[13,"Switch","","",6,N],[13,"This","","",6,N],[13,"Throw","","",6,N],[13,"True","","",6,N],[13,"Try","","",6,N],[13,"Typeof","","",6,N],[13,"Static","","",6,N],[13,"Var","","",6,N],[13,"While","","",6,N],[4,"Condition","","",N,N],[13,"And","","",9,N],[13,"Or","","",9,N],[13,"DifferentThan","","",9,N],[13,"SuperDifferentThan","","",9,N],[13,"EqualTo","","",9,N],[13,"SuperEqualTo","","",9,N],[13,"SuperiorThan","","",9,N],[13,"SuperiorOrEqualTo","","",9,N],[13,"InferiorThan","","",9,N],[13,"InferiorOrEqualTo","","",9,N],[4,"Operation","","",N,N],[13,"Addition","","",10,N],[13,"AdditionEqual","","",10,N],[13,"Subtract","","",10,N],[13,"SubtractEqual","","",10,N],[13,"Multiply","","",10,N],[13,"MultiplyEqual","","",10,N],[13,"Divide","","",10,N],[13,"DivideEqual","","",10,N],[13,"Modulo","","",10,N],[13,"ModuloEqual","","",10,N],[13,"Equal","","",10,N],[4,"Token","","",N,N],[13,"Keyword","","",11,N],[13,"Char","","",11,N],[13,"String","","",11,N],[13,"Comment","","",11,N],[13,"License","","",11,N],[13,"Other","","",11,N],[13,"Regex","","",11,N],[12,"regex","minifier::js::token::Token","",11,N],[12,"is_global","","",11,N],[12,"is_interactive","","",11,N],[13,"Condition","minifier::js::token","",11,N],[13,"Operation","","",11,N],[5,"get_required","","",N,[[["token"]],["option",["char"]]]],[5,"get_line_comment","","",N,[[["str"],["peekable"],["usize"]],["option",["token"]]]],[5,"get_regex","","",N,[[["str"],["peekable"],["usize"]],["option",["token"]]]],[5,"get_comment","","",N,[[["str"],["peekable"],["usize"]],["option",["token"]]]],[5,"get_string","","",N,[[["str"],["peekable"],["usize"],["reservedchar"]],["option",["token"]]]],[5,"first_useful","","",N,N],[5,"fill_other","","",N,[[["str"],["vec"],["usize"],["usize"]]]],[5,"handle_equal_sign","","",N,[[["vec"],["reservedchar"]],["bool"]]],[5,"tokenize","","",N,[[["str"]],["tokens"]]],[5,"clean_tokens","","",N,[[["tokens"]]]],[8,"MyTryFrom","","",N,N],[16,"Error","","",12,N],[10,"try_from","","",12,[[["t"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"eq","","",8,[[["self"],["reservedchar"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",8,N],[11,"clone","","",8,[[["self"]],["reservedchar"]]],[11,"is_useless","","",8,[[["self"]],["bool"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",8,[[["char"]],["result",["reservedchar"]]]],[11,"fmt","minifier::js","",6,[[["self"],["formatter"]],["result"]]],[11,"eq","","",6,[[["self"],["keyword"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",6,N],[11,"clone","","",6,[[["self"]],["keyword"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",6,[[["str"]],["result",["keyword"]]]],[11,"fmt","minifier::js::token","",9,[[["self"],["formatter"]],["result"]]],[11,"eq","","",9,[[["self"],["condition"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",9,N],[11,"clone","","",9,[[["self"]],["condition"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",9,[[["reservedchar"]],["result",["condition"]]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"eq","","",10,[[["self"],["operation"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",10,N],[11,"clone","","",10,[[["self"]],["operation"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"try_from","","",10,[[["reservedchar"]],["result",["operation"]]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"eq","","",11,[[["self"],["token"]],["bool"]]],[11,"ne","","",11,[[["self"],["token"]],["bool"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"is_comment","","",11,[[["self"]],["bool"]]],[11,"get_char","","",11,[[["self"]],["option",["reservedchar"]]]],[11,"is_char","","",11,[[["self"],["reservedchar"]],["bool"]]],[11,"is_operation","","",11,[[["self"],["operation"]],["bool"]]],[11,"is_condition","","",11,[[["self"],["condition"]],["bool"]]],[11,"is_other","","",11,[[["self"]],["bool"]]],[11,"is_white_character","","",11,[[["self"]],["bool"]]],[11,"get_keyword","","",11,[[["self"]],["option",["keyword"]]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"eq","","",7,[[["self"],["tokens"]],["bool"]]],[11,"ne","","",7,[[["self"],["tokens"]],["bool"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[0,"js","minifier::js","",N,N],[5,"minify","minifier::js::js","Minifies a given JS source code.",N,[[["str"]],["string"]]],[5,"minify_and_replace_keywords","","Minifies a given JS source code and to replace keywords.",N,N],[0,"json","minifier","",N,N],[5,"minify","minifier::json","Minifies a given String by JSON minification rules",N,[[["str"]],["string"]]],[5,"minify_from_read","","Minifies a given Read by JSON minification rules",N,[[["r"]],["jsonread"]]],[0,"read","","",N,N],[0,"byte_to_char","minifier::json::read","",N,N],[3,"ByteToChar","minifier::json::read::byte_to_char","",N,N],[12,"iter","","",13,N],[4,"CharsError","","An enumeration of possible errors that can be generated from the `Chars` adapter.",N,N],[13,"NotUtf8","","Variant representing that the underlying stream was read successfully but it did not contain valid utf8 data.",14,N],[13,"Other","","Variant representing that an I/O error occurred.",14,N],[5,"utf8_char_width","","",N,[[["u8"]],["usize"]]],[7,"UTF8_CHAR_WIDTH","","",N,N],[11,"new","","",13,[[["r"],["usize"]],["result",["error"]]]],[11,"get_next","","",13,[[["self"]],["result",["option","charserror"]]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"next","","",13,[[["self"]],["option",["result"]]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"description","","",14,[[["self"]],["str"]]],[11,"cause","","",14,[[["self"]],["option",["error"]]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[0,"internal_buffer","minifier::json::read","",N,N],[3,"Buffer","minifier::json::read::internal_buffer","",N,N],[12,"buffer","","",15,N],[12,"read_pos","","",15,N],[12,"buffer_size","","",15,N],[12,"data_size","","",15,N],[17,"ARRAY_DEFAULT","","",N,N],[11,"fmt","","",15,[[["self"],["formatter"]],["result"]]],[11,"new","","",15,[[["usize"]],["buffer"]]],[11,"as_mut","","",15,N],[11,"update_metadata","","",15,[[["self"],["usize"]]]],[11,"next","","",15,[[["self"]],["option",["u8"]]]],[11,"cont","","",15,[[["self"]],["bool"]]],[0,"internal_reader","minifier::json::read","",N,N],[3,"InternalReader","minifier::json::read::internal_reader","",N,N],[12,"read","","",16,N],[12,"buffer_size","","",16,N],[12,"buffer","","",16,N],[11,"new","","",16,[[["r"],["usize"]],["result",["error"]]]],[11,"read_data","","",16,[[["r"],["buffer"]],["result",["error"]]]],[11,"fmt","","",16,[[["self"],["formatter"]],["result"]]],[11,"next","","",16,[[["self"]],["option",["result"]]]],[0,"json_read","minifier::json::read","",N,N],[3,"JsonRead","minifier::json::read::json_read","",N,N],[12,"minifier","","",17,N],[12,"read","","",17,N],[12,"iter","","",17,N],[12,"predicate","","",17,N],[12,"initialized","","",17,N],[12,"item_iter","","",17,N],[12,"item1","","",17,N],[11,"new","","",17,[[["r"],["p"]],["self"]]],[11,"get_next","","",17,[[["self"]],["result",["option","charserror"]]]],[11,"add_char_to_buffer","","",17,N],[11,"fmt","","",17,[[["self"],["formatter"]],["result"]]],[11,"read","","",17,N],[0,"json_minifier","minifier::json","",N,N],[3,"JsonMinifier","minifier::json::json_minifier","",N,N],[12,"is_string","","",18,N],[12,"escaped_quotation","","",18,N],[5,"keep_element","","",N,[[["jsonminifier"],["char"],["option",["char"]]],["bool"]]],[5,"is_whitespace_outside_string","","",N,[[["jsonminifier"],["char"],["option",["char"]]],["bool"]]],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"default","","",18,[[],["self"]]],[11,"new","","",18,[[],["self"]]],[0,"string","minifier::json","",N,N],[3,"JsonMultiFilter","minifier::json::string","",N,N],[12,"minifier","","",19,N],[12,"iter","","",19,N],[12,"predicate","","",19,N],[12,"initialized","","",19,N],[12,"item1","","",19,N],[11,"new","","",19,[[["i"],["p"]],["self"]]],[11,"fmt","","",19,[[["self"],["formatter"]],["result"]]],[11,"next","","",19,[[["self"]],["option"]]],[6,"JsonMethod","minifier::json","",N,N],[11,"to_owned","minifier::css::token","",0,[[["self"]],["t"]]],[11,"clone_into","","",0,N],[11,"from","","",0,[[["t"]],["t"]]],[11,"to_string","","",0,[[["self"]],["string"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"to_owned","","",1,[[["self"]],["t"]]],[11,"clone_into","","",1,N],[11,"from","","",1,[[["t"]],["t"]]],[11,"to_string","","",1,[[["self"]],["string"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"to_owned","","",2,[[["self"]],["t"]]],[11,"clone_into","","",2,N],[11,"from","","",2,[[["t"]],["t"]]],[11,"to_string","","",2,[[["self"]],["string"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"to_owned","","",3,[[["self"]],["t"]]],[11,"clone_into","","",3,N],[11,"from","","",3,[[["t"]],["t"]]],[11,"to_string","","",3,[[["self"]],["string"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]],[11,"to_owned","","",4,[[["self"]],["t"]]],[11,"clone_into","","",4,N],[11,"from","","",4,[[["t"]],["t"]]],[11,"to_string","","",4,[[["self"]],["string"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"to_owned","minifier::js","",6,[[["self"]],["t"]]],[11,"clone_into","","",6,N],[11,"from","","",6,[[["t"]],["t"]]],[11,"to_string","","",6,[[["self"]],["string"]]],[11,"into","","",6,[[["self"]],["u"]]],[11,"try_from","","",6,[[["u"]],["result"]]],[11,"borrow","","",6,[[["self"]],["t"]]],[11,"try_into","","",6,[[["self"]],["result"]]],[11,"borrow_mut","","",6,[[["self"]],["t"]]],[11,"get_type_id","","",6,[[["self"]],["typeid"]]],[11,"from","minifier::js::token","",7,[[["t"]],["t"]]],[11,"to_string","","",7,[[["self"]],["string"]]],[11,"into","","",7,[[["self"]],["u"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"try_into","","",7,[[["self"]],["result"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"get_type_id","","",7,[[["self"]],["typeid"]]],[11,"to_owned","","",8,[[["self"]],["t"]]],[11,"clone_into","","",8,N],[11,"from","","",8,[[["t"]],["t"]]],[11,"to_string","","",8,[[["self"]],["string"]]],[11,"into","","",8,[[["self"]],["u"]]],[11,"try_from","","",8,[[["u"]],["result"]]],[11,"borrow","","",8,[[["self"]],["t"]]],[11,"try_into","","",8,[[["self"]],["result"]]],[11,"borrow_mut","","",8,[[["self"]],["t"]]],[11,"get_type_id","","",8,[[["self"]],["typeid"]]],[11,"to_owned","","",9,[[["self"]],["t"]]],[11,"clone_into","","",9,N],[11,"from","","",9,[[["t"]],["t"]]],[11,"to_string","","",9,[[["self"]],["string"]]],[11,"into","","",9,[[["self"]],["u"]]],[11,"try_from","","",9,[[["u"]],["result"]]],[11,"borrow","","",9,[[["self"]],["t"]]],[11,"try_into","","",9,[[["self"]],["result"]]],[11,"borrow_mut","","",9,[[["self"]],["t"]]],[11,"get_type_id","","",9,[[["self"]],["typeid"]]],[11,"to_owned","","",10,[[["self"]],["t"]]],[11,"clone_into","","",10,N],[11,"from","","",10,[[["t"]],["t"]]],[11,"to_string","","",10,[[["self"]],["string"]]],[11,"into","","",10,[[["self"]],["u"]]],[11,"try_from","","",10,[[["u"]],["result"]]],[11,"borrow","","",10,[[["self"]],["t"]]],[11,"try_into","","",10,[[["self"]],["result"]]],[11,"borrow_mut","","",10,[[["self"]],["t"]]],[11,"get_type_id","","",10,[[["self"]],["typeid"]]],[11,"from","","",11,[[["t"]],["t"]]],[11,"to_string","","",11,[[["self"]],["string"]]],[11,"into","","",11,[[["self"]],["u"]]],[11,"try_from","","",11,[[["u"]],["result"]]],[11,"borrow","","",11,[[["self"]],["t"]]],[11,"try_into","","",11,[[["self"]],["result"]]],[11,"borrow_mut","","",11,[[["self"]],["t"]]],[11,"get_type_id","","",11,[[["self"]],["typeid"]]],[11,"from","minifier::json::read::byte_to_char","",13,[[["t"]],["t"]]],[11,"into_iter","","",13,[[["self"]],["i"]]],[11,"into","","",13,[[["self"]],["u"]]],[11,"try_from","","",13,[[["u"]],["result"]]],[11,"borrow","","",13,[[["self"]],["t"]]],[11,"try_into","","",13,[[["self"]],["result"]]],[11,"borrow_mut","","",13,[[["self"]],["t"]]],[11,"get_type_id","","",13,[[["self"]],["typeid"]]],[11,"from","","",14,[[["t"]],["t"]]],[11,"to_string","","",14,[[["self"]],["string"]]],[11,"into","","",14,[[["self"]],["u"]]],[11,"try_from","","",14,[[["u"]],["result"]]],[11,"borrow","","",14,[[["self"]],["t"]]],[11,"try_into","","",14,[[["self"]],["result"]]],[11,"borrow_mut","","",14,[[["self"]],["t"]]],[11,"get_type_id","","",14,[[["self"]],["typeid"]]],[11,"from","minifier::json::read::internal_buffer","",15,[[["t"]],["t"]]],[11,"into","","",15,[[["self"]],["u"]]],[11,"try_from","","",15,[[["u"]],["result"]]],[11,"borrow","","",15,[[["self"]],["t"]]],[11,"try_into","","",15,[[["self"]],["result"]]],[11,"borrow_mut","","",15,[[["self"]],["t"]]],[11,"get_type_id","","",15,[[["self"]],["typeid"]]],[11,"from","minifier::json::read::internal_reader","",16,[[["t"]],["t"]]],[11,"into_iter","","",16,[[["self"]],["i"]]],[11,"into","","",16,[[["self"]],["u"]]],[11,"try_from","","",16,[[["u"]],["result"]]],[11,"borrow","","",16,[[["self"]],["t"]]],[11,"try_into","","",16,[[["self"]],["result"]]],[11,"borrow_mut","","",16,[[["self"]],["t"]]],[11,"get_type_id","","",16,[[["self"]],["typeid"]]],[11,"from","minifier::json::read::json_read","",17,[[["t"]],["t"]]],[11,"into","","",17,[[["self"]],["u"]]],[11,"try_from","","",17,[[["u"]],["result"]]],[11,"borrow","","",17,[[["self"]],["t"]]],[11,"try_into","","",17,[[["self"]],["result"]]],[11,"borrow_mut","","",17,[[["self"]],["t"]]],[11,"get_type_id","","",17,[[["self"]],["typeid"]]],[11,"from","minifier::json::json_minifier","",18,[[["t"]],["t"]]],[11,"into","","",18,[[["self"]],["u"]]],[11,"try_from","","",18,[[["u"]],["result"]]],[11,"borrow","","",18,[[["self"]],["t"]]],[11,"try_into","","",18,[[["self"]],["result"]]],[11,"borrow_mut","","",18,[[["self"]],["t"]]],[11,"get_type_id","","",18,[[["self"]],["typeid"]]],[11,"from","minifier::json::string","",19,[[["t"]],["t"]]],[11,"into_iter","","",19,[[["self"]],["i"]]],[11,"into","","",19,[[["self"]],["u"]]],[11,"try_from","","",19,[[["u"]],["result"]]],[11,"borrow","","",19,[[["self"]],["t"]]],[11,"try_into","","",19,[[["self"]],["result"]]],[11,"borrow_mut","","",19,[[["self"]],["t"]]],[11,"get_type_id","","",19,[[["self"]],["typeid"]]]],"paths":[[3,"Tokens"],[4,"ReservedChar"],[4,"SelectorElement"],[4,"SelectorOperator"],[4,"Token"],[8,"MyTryFrom"],[4,"Keyword"],[3,"Tokens"],[4,"ReservedChar"],[4,"Condition"],[4,"Operation"],[4,"Token"],[8,"MyTryFrom"],[3,"ByteToChar"],[4,"CharsError"],[3,"Buffer"],[3,"InternalReader"],[3,"JsonRead"],[3,"JsonMinifier"],[3,"JsonMultiFilter"]]};
searchIndex["proc_macro"]={"doc":"A support library for macro authors when defining new macros.","items":[[3,"Diagnostic","proc_macro","A structure representing a diagnostic message and associated children messages.",N,N],[12,"level","","",0,N],[12,"message","","",0,N],[12,"spans","","",0,N],[12,"children","","",0,N],[3,"TokenStream","","The main type provided by this crate, representing an abstract stream of tokens, or, more specifically, a sequence of token trees. The type provide interfaces for iterating over those token trees and, conversely, collecting a number of token trees into one stream.",N,N],[12,"0","","",1,N],[3,"LexError","","Error returned from `TokenStream::from_str`.",N,N],[12,"_inner","","",2,N],[3,"Span","","A region of source code, along with macro expansion information.",N,N],[12,"0","","",3,N],[3,"LineColumn","","A line-column pair representing the start or end of a `Span`.",N,N],[12,"line","","The 1-indexed line in the source file on which the span starts or ends (inclusive).",4,N],[12,"column","","The 0-indexed column (in UTF-8 characters) in the source file on which the span starts or ends (inclusive).",4,N],[3,"SourceFile","","The source file of a given `Span`.",N,N],[12,"source_file","","",5,N],[3,"Group","","A delimited token stream.",N,N],[12,"delimiter","","",6,N],[12,"stream","","",6,N],[12,"span","","",6,N],[3,"Punct","","An `Punct` is an single punctuation character like `+`, `-` or `#`.",N,N],[12,"ch","","",7,N],[12,"spacing","","",7,N],[12,"span","","",7,N],[3,"Ident","","An identifier (`ident`).",N,N],[12,"sym","","",8,N],[12,"span","","",8,N],[12,"is_raw","","",8,N],[3,"Literal","","A literal string (`\"hello\"`), byte string (`b\"hello\"`), character (`'a'`), byte character (`b'a'`), an integer or floating point number with or without a suffix (`1`, `1u8`, `2.3`, `2.3f32`). Boolean literals like `true` and `false` do not belong here, they are `Ident`s.",N,N],[12,"lit","","",9,N],[12,"suffix","","",9,N],[12,"span","","",9,N],[4,"Level","","An enum representing a diagnostic level.",N,N],[13,"Error","","An error.",10,N],[13,"Warning","","A warning.",10,N],[13,"Note","","A note.",10,N],[13,"Help","","A help message.",10,N],[4,"TokenTree","","A single token or a delimited sequence of token trees (e.g. `[1, (), ..]`).",N,N],[13,"Group","","A token stream surrounded by bracket delimiters.",11,N],[13,"Ident","","An identifier.",11,N],[13,"Punct","","A single punctuation character (`+`, `,`, `$`, etc.).",11,N],[13,"Literal","","A literal character (`'a'`), string (`\"hello\"`), number (`2.3`), etc.",11,N],[4,"Delimiter","","Describes how a sequence of token trees is delimited.",N,N],[13,"Parenthesis","","`( ... )`",12,N],[13,"Brace","","`{ ... }`",12,N],[13,"Bracket","","`[ ... ]`",12,N],[13,"None","","`Ø ... Ø` An implicit delimiter, that may, for example, appear around tokens coming from a \"macro variable\" `$var`. It is important to preserve operator priorities in cases like `$var * 3` where `$var` is `1 + 2`. Implicit delimiters may not survive roundtrip of a token stream through a string.",12,N],[4,"Spacing","","Whether an `Punct` is followed immediately by another `Punct` or followed by another token or whitespace.",N,N],[13,"Alone","","E.g. `+` is `Alone` in `+ =`, `+ident` or `+()`.",13,N],[13,"Joint","","E.g. `+` is `Joint` in `+=` or `'#`. Additionally, single quote `'` can join with identifiers to form lifetimes `'ident`.",13,N],[5,"quote","","Quote a `TokenStream` into a `TokenStream`. This is the actual `quote!()` proc macro.",N,[[["tokenstream"]],["tokenstream"]]],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to implement a custom quoter.",N,[[["span"]],["tokenstream"]]],[5,"parse_to_lex_err","","",N,[[["diagnosticbuilder"]],["lexerror"]]],[0,"rustc","","",N,N],[11,"new_maybe_raw","","",8,[[["str"],["span"],["bool"]],["ident"]]],[11,"from_internal","","",12,[[["delimtoken"]],["delimiter"]]],[11,"to_internal","","",12,[[["self"]],["delimtoken"]]],[11,"from_internal","","",11,[[["tokenstream"],["vec"]],["tokentree"]]],[11,"to_internal","","",11,[[["self"]],["tokenstream"]]],[11,"to_internal","","",10,[[["self"]],["level"]]],[0,"diagnostic","","",N,N],[3,"Diagnostic","proc_macro::diagnostic","A structure representing a diagnostic message and associated children messages.",N,N],[12,"level","","",0,N],[12,"message","","",0,N],[12,"spans","","",0,N],[12,"children","","",0,N],[3,"Children","","Iterator over the children diagnostics of a `Diagnostic`.",N,N],[12,"0","","",14,N],[4,"Level","","An enum representing a diagnostic level.",N,N],[13,"Error","","An error.",10,N],[13,"Warning","","A warning.",10,N],[13,"Note","","A note.",10,N],[13,"Help","","A help message.",10,N],[8,"MultiSpan","","Trait implemented by types that can be converted into a set of `Span`s.",N,N],[10,"into_spans","","Converts `self` into a `Vec<Span>`.",15,[[["self"]],["vec",["span"]]]],[11,"clone","proc_macro","",10,[[["self"]],["level"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"into_spans","","",3,[[["self"]],["vec",["span"]]]],[11,"clone","","",0,[[["self"]],["diagnostic"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","proc_macro::diagnostic","",14,[[["self"],["formatter"]],["result"]]],[11,"clone","","",14,[[["self"]],["children"]]],[11,"next","","",14,[[["self"]],["option"]]],[11,"new","proc_macro","Create a new diagnostic with the given `level` and `message`.",0,[[["level"],["t"]],["diagnostic"]]],[11,"spanned","","Create a new diagnostic with the given `level` and `message` pointing to the given set of `spans`.",0,[[["s"],["level"],["t"]],["diagnostic"]]],[11,"span_error","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `spans` and `message`.",0,[[["self"],["s"],["t"]],["diagnostic"]]],[11,"error","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,[[["self"],["t"]],["diagnostic"]]],[11,"span_warning","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `spans` and `message`.",0,[[["self"],["s"],["t"]],["diagnostic"]]],[11,"warning","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,[[["self"],["t"]],["diagnostic"]]],[11,"span_note","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `spans` and `message`.",0,[[["self"],["s"],["t"]],["diagnostic"]]],[11,"note","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,[[["self"],["t"]],["diagnostic"]]],[11,"span_help","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `spans` and `message`.",0,[[["self"],["s"],["t"]],["diagnostic"]]],[11,"help","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,[[["self"],["t"]],["diagnostic"]]],[11,"level","","Returns the diagnostic `level` for `self`.",0,[[["self"]],["level"]]],[11,"set_level","","Sets the level in `self` to `level`.",0,[[["self"],["level"]]]],[11,"message","","Returns the message in `self`.",0,[[["self"]],["str"]]],[11,"set_message","","Sets the message in `self` to `message`.",0,[[["self"],["t"]]]],[11,"spans","","Returns the `Span`s in `self`.",0,N],[11,"set_spans","","Sets the `Span`s in `self` to `spans`.",0,[[["self"],["s"]]]],[11,"children","","Returns an iterator over the children diagnostics of `self`.",0,[[["self"]],["children"]]],[11,"emit","","Emit the diagnostic.",0,[[["self"]]]],[0,"token_stream","","Public implementation details for the `TokenStream` type, such as iterators.",N,N],[3,"IntoIter","proc_macro::token_stream","An iterator over `TokenStream`'s `TokenTree`s. The iteration is \"shallow\", e.g. the iterator doesn't recurse into delimited groups, and returns whole groups as token trees.",N,N],[12,"cursor","","",16,N],[12,"stack","","",16,N],[11,"clone","","",16,[[["self"]],["intoiter"]]],[11,"next","","",16,[[["self"]],["option",["tokentree"]]]],[11,"into_iter","proc_macro","",1,[[["self"]],["intoiter"]]],[0,"quote","","Quasiquoter This file contains the implementation internals of the quasiquoter provided by `quote!`. This quasiquoter uses macros 2.0 hygiene to reliably access items from `proc_macro`, to build a `proc_macro::TokenStream`.",N,N],[5,"quote","proc_macro::quote","Quote a `TokenStream` into a `TokenStream`. This is the actual `quote!()` proc macro.",N,[[["tokenstream"]],["tokenstream"]]],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to implement a custom quoter.",N,[[["span"]],["tokenstream"]]],[0,"__internal","proc_macro","Permanently unstable internal implementation details of this crate. This should not be used.",N,N],[3,"ProcMacroData","proc_macro::__internal","",N,N],[12,"def_site","","",17,N],[12,"call_site","","",17,N],[3,"ProcMacroSess","","",N,N],[12,"parse_sess","","",18,N],[12,"data","","",18,N],[5,"lookup_char_pos","","",N,[[["bytepos"]],["loc"]]],[5,"new_token_stream","","",N,[[["p",["item"]]],["tokenstream"]]],[5,"token_stream_wrap","","",N,[[["tokenstream"]],["tokenstream"]]],[5,"token_stream_parse_items","","",N,[[["tokenstream"]],["result",["vec","lexerror"]]]],[5,"token_stream_inner","","",N,[[["tokenstream"]],["tokenstream"]]],[5,"set_sess","","",N,[[["extctxt"],["f"]],["r"]]],[5,"in_sess","","",N,[[],["bool"]]],[5,"with_sess","","",N,[[["f"]],["r"]]],[17,"CURRENT_SESS","","",N,N],[8,"Registry","","",N,N],[10,"register_custom_derive","","",19,N],[10,"register_attr_proc_macro","","",19,N],[10,"register_bang_proc_macro","","",19,N],[11,"clone","","",17,[[["self"]],["procmacrodata"]]],[11,"clone","","",18,[[["self"]],["procmacrosess"]]],[11,"clone","proc_macro","",1,[[["self"]],["tokenstream"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"new","","Returns an empty `TokenStream` containing no token trees.",1,[[],["tokenstream"]]],[11,"is_empty","","Checks if this `TokenStream` is empty.",1,[[["self"]],["bool"]]],[11,"from_str","","",1,[[["str"]],["result",["tokenstream","lexerror"]]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"from","","",1,[[["tokentree"]],["tokenstream"]]],[11,"from_iter","","",1,[[["i"]],["self"]]],[11,"from_iter","","",1,[[["i"]],["self"]]],[11,"extend","","",1,[[["self"],["i"]]]],[11,"extend","","",1,[[["self"],["i"]]]],[11,"clone","","",3,[[["self"]],["span"]]],[11,"def_site","","A span that resolves at the macro definition site.",3,[[],["span"]]],[11,"call_site","","The span of the invocation of the current procedural macro. Identifiers created with this span will be resolved as if they were written directly at the macro call location (call-site hygiene) and other code at the macro call site will be able to refer to them as well.",3,[[],["span"]]],[11,"source_file","","The original source file into which this span points.",3,[[["self"]],["sourcefile"]]],[11,"parent","","The `Span` for the tokens in the previous macro expansion from which `self` was generated from, if any.",3,[[["self"]],["option",["span"]]]],[11,"source","","The span for the origin source code that `self` was generated from. If this `Span` wasn't generated from other macro expansions then the return value is the same as `*self`.",3,[[["self"]],["span"]]],[11,"start","","Get the starting line/column in the source file for this span.",3,[[["self"]],["linecolumn"]]],[11,"end","","Get the ending line/column in the source file for this span.",3,[[["self"]],["linecolumn"]]],[11,"join","","Create a new span encompassing `self` and `other`.",3,[[["self"],["span"]],["option",["span"]]]],[11,"resolved_at","","Creates a new span with the same line/column information as `self` but that resolves symbols as though it were at `other`.",3,[[["self"],["span"]],["span"]]],[11,"located_at","","Creates a new span with the same name resolution behavior as `self` but with the line/column information of `other`.",3,[[["self"],["span"]],["span"]]],[11,"eq","","Compares to spans to see if they're equal.",3,[[["self"],["span"]],["bool"]]],[11,"error","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,[[["self"],["t"]],["diagnostic"]]],[11,"warning","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,[[["self"],["t"]],["diagnostic"]]],[11,"note","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,[[["self"],["t"]],["diagnostic"]]],[11,"help","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,[[["self"],["t"]],["diagnostic"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"clone","","",4,[[["self"]],["linecolumn"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"eq","","",4,[[["self"],["linecolumn"]],["bool"]]],[11,"ne","","",4,[[["self"],["linecolumn"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",4,N],[11,"clone","","",5,[[["self"]],["sourcefile"]]],[11,"path","","Get the path to this source file.",5,[[["self"]],["pathbuf"]]],[11,"is_real","","Returns `true` if this source file is a real source file, and not generated by an external macro's expansion.",5,[[["self"]],["bool"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"eq","","",5,[[["self"],["self"]],["bool"]]],[11,"clone","","",11,[[["self"]],["tokentree"]]],[11,"span","","Returns the span of this tree, delegating to the `span` method of the contained token or a delimited stream.",11,[[["self"]],["span"]]],[11,"set_span","","Configures the span for only this token.",11,[[["self"],["span"]]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"from","","",11,[[["group"]],["tokentree"]]],[11,"from","","",11,[[["ident"]],["tokentree"]]],[11,"from","","",11,[[["punct"]],["tokentree"]]],[11,"from","","",11,[[["literal"]],["tokentree"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"clone","","",6,[[["self"]],["group"]]],[11,"clone","","",12,[[["self"]],["delimiter"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"eq","","",12,[[["self"],["delimiter"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",12,N],[11,"new","","Creates a new `Group` with the given delimiter and token stream.",6,[[["delimiter"],["tokenstream"]],["group"]]],[11,"delimiter","","Returns the delimiter of this `Group`",6,[[["self"]],["delimiter"]]],[11,"stream","","Returns the `TokenStream` of tokens that are delimited in this `Group`.",6,[[["self"]],["tokenstream"]]],[11,"span","","Returns the span for the delimiters of this token stream, spanning the entire `Group`.",6,[[["self"]],["span"]]],[11,"span_open","","Returns the span pointing to the opening delimiter of this group.",6,[[["self"]],["span"]]],[11,"span_close","","Returns the span pointing to the closing delimiter of this group.",6,[[["self"]],["span"]]],[11,"set_span","","Configures the span for this `Group`'s delimiters, but not its internal tokens.",6,[[["self"],["span"]]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"clone","","",7,[[["self"]],["punct"]]],[11,"clone","","",13,[[["self"]],["spacing"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"eq","","",13,[[["self"],["spacing"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",13,N],[11,"new","","Creates a new `Punct` from the given character and spacing. The `ch` argument must be a valid punctuation character permitted by the language, otherwise the function will panic.",7,[[["char"],["spacing"]],["punct"]]],[11,"as_char","","Returns the value of this punctuation character as `char`.",7,[[["self"]],["char"]]],[11,"spacing","","Returns the spacing of this punctuation character, indicating whether it's immediately followed by another `Punct` in the token stream, so they can potentially be combined into a multicharacter operator (`Joint`), or it's followed by some other token or whitespace (`Alone`) so the operator has certainly ended.",7,[[["self"]],["spacing"]]],[11,"span","","Returns the span for this punctuation character.",7,[[["self"]],["span"]]],[11,"set_span","","Configure the span for this punctuation character.",7,[[["self"],["span"]]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"clone","","",8,[[["self"]],["ident"]]],[11,"is_valid","","",8,[[["str"]],["bool"]]],[11,"new","","Creates a new `Ident` with the given `string` as well as the specified `span`. The `string` argument must be a valid identifier permitted by the language, otherwise the function will panic.",8,[[["str"],["span"]],["ident"]]],[11,"new_raw","","Same as `Ident::new`, but creates a raw identifier (`r#ident`).",8,[[["str"],["span"]],["ident"]]],[11,"span","","Returns the span of this `Ident`, encompassing the entire string returned by `as_str`.",8,[[["self"]],["span"]]],[11,"set_span","","Configures the span of this `Ident`, possibly changing its hygiene context.",8,[[["self"],["span"]]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"clone","","",9,[[["self"]],["literal"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"u8_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["u8"]],["literal"]]],[11,"u16_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["u16"]],["literal"]]],[11,"u32_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["u32"]],["literal"]]],[11,"u64_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["u64"]],["literal"]]],[11,"u128_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["u128"]],["literal"]]],[11,"usize_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["usize"]],["literal"]]],[11,"i8_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["i8"]],["literal"]]],[11,"i16_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["i16"]],["literal"]]],[11,"i32_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["i32"]],["literal"]]],[11,"i64_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["i64"]],["literal"]]],[11,"i128_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["i128"]],["literal"]]],[11,"isize_suffixed","","Creates a new suffixed integer literal with the specified value.",9,[[["isize"]],["literal"]]],[11,"u8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["u8"]],["literal"]]],[11,"u16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["u16"]],["literal"]]],[11,"u32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["u32"]],["literal"]]],[11,"u64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["u64"]],["literal"]]],[11,"u128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["u128"]],["literal"]]],[11,"usize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["usize"]],["literal"]]],[11,"i8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["i8"]],["literal"]]],[11,"i16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["i16"]],["literal"]]],[11,"i32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["i32"]],["literal"]]],[11,"i64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["i64"]],["literal"]]],[11,"i128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["i128"]],["literal"]]],[11,"isize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,[[["isize"]],["literal"]]],[11,"f32_unsuffixed","","Creates a new unsuffixed floating-point literal.",9,[[["f32"]],["literal"]]],[11,"f32_suffixed","","Creates a new suffixed floating-point literal.",9,[[["f32"]],["literal"]]],[11,"f64_unsuffixed","","Creates a new unsuffixed floating-point literal.",9,[[["f64"]],["literal"]]],[11,"f64_suffixed","","Creates a new suffixed floating-point literal.",9,[[["f64"]],["literal"]]],[11,"string","","String literal.",9,[[["str"]],["literal"]]],[11,"character","","Character literal.",9,[[["char"]],["literal"]]],[11,"byte_string","","Byte string literal.",9,N],[11,"span","","Returns the span encompassing this literal.",9,[[["self"]],["span"]]],[11,"set_span","","Configures the span associated for this literal.",9,[[["self"],["span"]]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[14,"quote","","`quote!(..)` accepts arbitrary tokens and expands into a `TokenStream` describing the input. For example, `quote!(a + b)` will produce a expression, that, when evaluated, constructs the `TokenStream` `[Ident(\"a\"), Punct('+', Alone), Ident(\"b\")]`.",N,N],[11,"to_owned","","",0,[[["self"]],["t"]]],[11,"clone_into","","",0,N],[11,"from","","",0,[[["t"]],["t"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"not_found","","",0,[[["str"],["str"]],["e"]]],[11,"to_owned","","",1,[[["self"]],["t"]]],[11,"clone_into","","",1,N],[11,"from","","",1,[[["t"]],["t"]]],[11,"to_string","","",1,[[["self"]],["string"]]],[11,"into_iter","","",1,[[["self"]],["i"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"not_found","","",1,[[["str"],["str"]],["e"]]],[11,"from","","",2,[[["t"]],["t"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"not_found","","",2,[[["str"],["str"]],["e"]]],[11,"to_owned","","",3,[[["self"]],["t"]]],[11,"clone_into","","",3,N],[11,"from","","",3,[[["t"]],["t"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]],[11,"not_found","","",3,[[["str"],["str"]],["e"]]],[11,"to_owned","","",4,[[["self"]],["t"]]],[11,"clone_into","","",4,N],[11,"from","","",4,[[["t"]],["t"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"not_found","","",4,[[["str"],["str"]],["e"]]],[11,"to_owned","","",5,[[["self"]],["t"]]],[11,"clone_into","","",5,N],[11,"from","","",5,[[["t"]],["t"]]],[11,"into","","",5,[[["self"]],["u"]]],[11,"try_from","","",5,[[["u"]],["result"]]],[11,"borrow","","",5,[[["self"]],["t"]]],[11,"try_into","","",5,[[["self"]],["result"]]],[11,"borrow_mut","","",5,[[["self"]],["t"]]],[11,"get_type_id","","",5,[[["self"]],["typeid"]]],[11,"not_found","","",5,[[["str"],["str"]],["e"]]],[11,"to_owned","","",6,[[["self"]],["t"]]],[11,"clone_into","","",6,N],[11,"from","","",6,[[["t"]],["t"]]],[11,"to_string","","",6,[[["self"]],["string"]]],[11,"into","","",6,[[["self"]],["u"]]],[11,"try_from","","",6,[[["u"]],["result"]]],[11,"borrow","","",6,[[["self"]],["t"]]],[11,"try_into","","",6,[[["self"]],["result"]]],[11,"borrow_mut","","",6,[[["self"]],["t"]]],[11,"get_type_id","","",6,[[["self"]],["typeid"]]],[11,"not_found","","",6,[[["str"],["str"]],["e"]]],[11,"to_owned","","",7,[[["self"]],["t"]]],[11,"clone_into","","",7,N],[11,"from","","",7,[[["t"]],["t"]]],[11,"to_string","","",7,[[["self"]],["string"]]],[11,"into","","",7,[[["self"]],["u"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"try_into","","",7,[[["self"]],["result"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"get_type_id","","",7,[[["self"]],["typeid"]]],[11,"not_found","","",7,[[["str"],["str"]],["e"]]],[11,"to_owned","","",8,[[["self"]],["t"]]],[11,"clone_into","","",8,N],[11,"from","","",8,[[["t"]],["t"]]],[11,"to_string","","",8,[[["self"]],["string"]]],[11,"into","","",8,[[["self"]],["u"]]],[11,"try_from","","",8,[[["u"]],["result"]]],[11,"borrow","","",8,[[["self"]],["t"]]],[11,"try_into","","",8,[[["self"]],["result"]]],[11,"borrow_mut","","",8,[[["self"]],["t"]]],[11,"get_type_id","","",8,[[["self"]],["typeid"]]],[11,"not_found","","",8,[[["str"],["str"]],["e"]]],[11,"to_owned","","",9,[[["self"]],["t"]]],[11,"clone_into","","",9,N],[11,"from","","",9,[[["t"]],["t"]]],[11,"to_string","","",9,[[["self"]],["string"]]],[11,"into","","",9,[[["self"]],["u"]]],[11,"try_from","","",9,[[["u"]],["result"]]],[11,"borrow","","",9,[[["self"]],["t"]]],[11,"try_into","","",9,[[["self"]],["result"]]],[11,"borrow_mut","","",9,[[["self"]],["t"]]],[11,"get_type_id","","",9,[[["self"]],["typeid"]]],[11,"not_found","","",9,[[["str"],["str"]],["e"]]],[11,"to_owned","","",10,[[["self"]],["t"]]],[11,"clone_into","","",10,N],[11,"from","","",10,[[["t"]],["t"]]],[11,"into","","",10,[[["self"]],["u"]]],[11,"try_from","","",10,[[["u"]],["result"]]],[11,"borrow","","",10,[[["self"]],["t"]]],[11,"try_into","","",10,[[["self"]],["result"]]],[11,"borrow_mut","","",10,[[["self"]],["t"]]],[11,"get_type_id","","",10,[[["self"]],["typeid"]]],[11,"not_found","","",10,[[["str"],["str"]],["e"]]],[11,"to_owned","","",11,[[["self"]],["t"]]],[11,"clone_into","","",11,N],[11,"from","","",11,[[["t"]],["t"]]],[11,"to_string","","",11,[[["self"]],["string"]]],[11,"into","","",11,[[["self"]],["u"]]],[11,"try_from","","",11,[[["u"]],["result"]]],[11,"borrow","","",11,[[["self"]],["t"]]],[11,"try_into","","",11,[[["self"]],["result"]]],[11,"borrow_mut","","",11,[[["self"]],["t"]]],[11,"get_type_id","","",11,[[["self"]],["typeid"]]],[11,"not_found","","",11,[[["str"],["str"]],["e"]]],[11,"to_owned","","",12,[[["self"]],["t"]]],[11,"clone_into","","",12,N],[11,"from","","",12,[[["t"]],["t"]]],[11,"into","","",12,[[["self"]],["u"]]],[11,"try_from","","",12,[[["u"]],["result"]]],[11,"borrow","","",12,[[["self"]],["t"]]],[11,"try_into","","",12,[[["self"]],["result"]]],[11,"borrow_mut","","",12,[[["self"]],["t"]]],[11,"get_type_id","","",12,[[["self"]],["typeid"]]],[11,"not_found","","",12,[[["str"],["str"]],["e"]]],[11,"to_owned","","",13,[[["self"]],["t"]]],[11,"clone_into","","",13,N],[11,"from","","",13,[[["t"]],["t"]]],[11,"into","","",13,[[["self"]],["u"]]],[11,"try_from","","",13,[[["u"]],["result"]]],[11,"borrow","","",13,[[["self"]],["t"]]],[11,"try_into","","",13,[[["self"]],["result"]]],[11,"borrow_mut","","",13,[[["self"]],["t"]]],[11,"get_type_id","","",13,[[["self"]],["typeid"]]],[11,"not_found","","",13,[[["str"],["str"]],["e"]]],[11,"to_owned","proc_macro::diagnostic","",14,[[["self"]],["t"]]],[11,"clone_into","","",14,N],[11,"from","","",14,[[["t"]],["t"]]],[11,"into_iter","","",14,[[["self"]],["i"]]],[11,"into","","",14,[[["self"]],["u"]]],[11,"try_from","","",14,[[["u"]],["result"]]],[11,"borrow","","",14,[[["self"]],["t"]]],[11,"try_into","","",14,[[["self"]],["result"]]],[11,"borrow_mut","","",14,[[["self"]],["t"]]],[11,"get_type_id","","",14,[[["self"]],["typeid"]]],[11,"not_found","","",14,[[["str"],["str"]],["e"]]],[11,"to_owned","proc_macro::token_stream","",16,[[["self"]],["t"]]],[11,"clone_into","","",16,N],[11,"from","","",16,[[["t"]],["t"]]],[11,"into_iter","","",16,[[["self"]],["i"]]],[11,"into","","",16,[[["self"]],["u"]]],[11,"try_from","","",16,[[["u"]],["result"]]],[11,"borrow","","",16,[[["self"]],["t"]]],[11,"try_into","","",16,[[["self"]],["result"]]],[11,"borrow_mut","","",16,[[["self"]],["t"]]],[11,"get_type_id","","",16,[[["self"]],["typeid"]]],[11,"not_found","","",16,[[["str"],["str"]],["e"]]],[11,"to_owned","proc_macro::__internal","",17,[[["self"]],["t"]]],[11,"clone_into","","",17,N],[11,"from","","",17,[[["t"]],["t"]]],[11,"into","","",17,[[["self"]],["u"]]],[11,"try_from","","",17,[[["u"]],["result"]]],[11,"borrow","","",17,[[["self"]],["t"]]],[11,"try_into","","",17,[[["self"]],["result"]]],[11,"borrow_mut","","",17,[[["self"]],["t"]]],[11,"get_type_id","","",17,[[["self"]],["typeid"]]],[11,"not_found","","",17,[[["str"],["str"]],["e"]]],[11,"to_owned","","",18,[[["self"]],["t"]]],[11,"clone_into","","",18,N],[11,"from","","",18,[[["t"]],["t"]]],[11,"into","","",18,[[["self"]],["u"]]],[11,"try_from","","",18,[[["u"]],["result"]]],[11,"borrow","","",18,[[["self"]],["t"]]],[11,"try_into","","",18,[[["self"]],["result"]]],[11,"borrow_mut","","",18,[[["self"]],["t"]]],[11,"get_type_id","","",18,[[["self"]],["typeid"]]],[11,"not_found","","",18,[[["str"],["str"]],["e"]]]],"paths":[[3,"Diagnostic"],[3,"TokenStream"],[3,"LexError"],[3,"Span"],[3,"LineColumn"],[3,"SourceFile"],[3,"Group"],[3,"Punct"],[3,"Ident"],[3,"Literal"],[4,"Level"],[4,"TokenTree"],[4,"Delimiter"],[4,"Spacing"],[3,"Children"],[8,"MultiSpan"],[3,"IntoIter"],[3,"ProcMacroData"],[3,"ProcMacroSess"],[8,"Registry"]]};
searchIndex["pulldown_cmark"]={"doc":"Pull parser for commonmark.","items":[[3,"Parser","pulldown_cmark","",N,N],[12,"inner","","",0,N],[12,"loose_lists","","",0,N],[12,"loose_stack","","",0,N],[3,"Options","","",N,N],[12,"bits","","",1,N],[4,"Alignment","","",N,N],[13,"None","","",2,N],[13,"Left","","",2,N],[13,"Center","","",2,N],[13,"Right","","",2,N],[4,"Event","","",N,N],[13,"Start","","",3,N],[13,"End","","",3,N],[13,"Text","","",3,N],[13,"Html","","",3,N],[13,"InlineHtml","","",3,N],[13,"FootnoteReference","","",3,N],[13,"SoftBreak","","",3,N],[13,"HardBreak","","",3,N],[4,"Tag","","",N,N],[13,"Paragraph","","",4,N],[13,"Rule","","",4,N],[13,"Header","","A heading. The field indicates the level of the heading.",4,N],[13,"BlockQuote","","",4,N],[13,"CodeBlock","","",4,N],[13,"List","","A list. If the list is ordered the field indicates the number of the first item.",4,N],[13,"Item","","",4,N],[13,"FootnoteDefinition","","",4,N],[13,"Table","","",4,N],[13,"TableHead","","",4,N],[13,"TableRow","","",4,N],[13,"TableCell","","",4,N],[13,"Emphasis","","",4,N],[13,"Strong","","",4,N],[13,"Code","","",4,N],[13,"Link","","A link. The first field is the destination URL, the second is a title",4,N],[13,"Image","","An image. The first field is the destination URL, the second is a title",4,N],[0,"html","","HTML renderer that takes an iterator of events as input.",N,N],[3,"Ctx","pulldown_cmark::html","",N,N],[12,"iter","","",5,N],[12,"buf","","",5,N],[12,"table_state","","",5,N],[12,"table_alignments","","",5,N],[12,"table_cell_index","","",5,N],[4,"TableState","","",N,N],[13,"Head","","",6,N],[13,"Body","","",6,N],[5,"push_html","","Iterate over an `Iterator` of `Event`s, generate HTML for each `Event`, and push it to a `String`.",N,[[["string"],["i"]]]],[11,"fresh_line","","",5,[[["self"]]]],[11,"run","","",5,[[["self"]]]],[11,"start_tag","","",5,[[["self"],["tag"],["hashmap"]]]],[11,"end_tag","","",5,[[["self"],["tag"]]]],[11,"raw_text","","",5,[[["self"],["hashmap"]]]],[0,"passes","pulldown_cmark","Main public pull parse interface, running two passes over input.",N,N],[3,"Parser","pulldown_cmark::passes","",N,N],[12,"inner","","",0,N],[12,"loose_lists","","",0,N],[12,"loose_stack","","",0,N],[11,"new","pulldown_cmark","",0,[[["str"]],["parser"]]],[11,"new_ext","","",0,[[["str"],["options"]],["parser"]]],[11,"new_with_broken_link_callback","","In case the parser encounters any potential links that have a broken reference (e.g `[foo]` when there is no `[foo]:` entry at the bottom) the provided callback will be called with the reference name, and the returned pair will be used as the link name and title if not None.",0,[[["str"],["options"],["option",["fn"]]],["parser"]]],[11,"get_offset","","",0,[[["self"]],["usize"]]],[11,"next","","",0,[[["self"]],["option",["event"]]]],[0,"parse","","Raw parser, for doing a single pass over input.",N,N],[3,"RawParser","pulldown_cmark::parse","",N,N],[12,"text","","",7,N],[12,"off","","",7,N],[12,"opts","","",7,N],[12,"active_tab","","",7,N],[12,"state","","",7,N],[12,"stack","","",7,N],[12,"leading_space","","",7,N],[12,"containers","","",7,N],[12,"last_line_was_empty","","",7,N],[12,"broken_link_callback","","In case we have a broken link/image reference, we can call this callback with the reference name (both normalized and not normalized) and use the link/title pair returned instead",7,N],[12,"fence_char","","",7,N],[12,"fence_count","","",7,N],[12,"fence_indent","","",7,N],[12,"loose_lists","","",7,N],[12,"links","","",7,N],[3,"ParseInfo","","",N,N],[12,"loose_lists","","",8,N],[12,"links","","",8,N],[3,"Options","","",N,N],[12,"bits","","",1,N],[4,"State","","",N,N],[13,"StartBlock","","",9,N],[13,"InContainers","","",9,N],[13,"Inline","","",9,N],[13,"TableHead","","",9,N],[13,"TableBody","","",9,N],[13,"TableRow","","",9,N],[13,"CodeLineStart","","",9,N],[13,"Code","","",9,N],[13,"InlineCode","","",9,N],[13,"Literal","","",9,N],[4,"Container","","",N,N],[13,"BlockQuote","","",10,N],[13,"List","","",10,N],[13,"ListItem","","",10,N],[13,"FootnoteDefinition","","",10,N],[4,"Tag","","",N,N],[13,"Paragraph","","",4,N],[13,"Rule","","",4,N],[13,"Header","","A heading. The field indicates the level of the heading.",4,N],[13,"BlockQuote","","",4,N],[13,"CodeBlock","","",4,N],[13,"List","","A list. If the list is ordered the field indicates the number of the first item.",4,N],[13,"Item","","",4,N],[13,"FootnoteDefinition","","",4,N],[13,"Table","","",4,N],[13,"TableHead","","",4,N],[13,"TableRow","","",4,N],[13,"TableCell","","",4,N],[13,"Emphasis","","",4,N],[13,"Strong","","",4,N],[13,"Code","","",4,N],[13,"Link","","A link. The first field is the destination URL, the second is a title",4,N],[13,"Image","","An image. The first field is the destination URL, the second is a title",4,N],[4,"Event","","",N,N],[13,"Start","","",3,N],[13,"End","","",3,N],[13,"Text","","",3,N],[13,"Html","","",3,N],[13,"InlineHtml","","",3,N],[13,"FootnoteReference","","",3,N],[13,"SoftBreak","","",3,N],[13,"HardBreak","","",3,N],[4,"Alignment","","",N,N],[13,"None","","",2,N],[13,"Left","","",2,N],[13,"Center","","",2,N],[13,"Right","","",2,N],[17,"OPTION_FIRST_PASS","","",N,N],[17,"OPTION_ENABLE_TABLES","","",N,N],[17,"OPTION_ENABLE_FOOTNOTES","","",N,N],[17,"MAX_LINK_NEST","","",N,N],[11,"eq","","",9,[[["self"],["state"]],["bool"]]],[11,"ne","","",9,[[["self"],["state"]],["bool"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"clone","","",10,[[["self"]],["container"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"eq","","",10,[[["self"],["container"]],["bool"]]],[11,"ne","","",10,[[["self"],["container"]],["bool"]]],[11,"clone","pulldown_cmark","",4,[[["self"]],["tag"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"eq","","",4,[[["self"],["tag"]],["bool"]]],[11,"ne","","",4,[[["self"],["tag"]],["bool"]]],[11,"clone","","",3,[[["self"]],["event"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"eq","","",3,[[["self"],["event"]],["bool"]]],[11,"ne","","",3,[[["self"],["event"]],["bool"]]],[11,"clone","","",2,[[["self"]],["alignment"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"eq","","",2,[[["self"],["alignment"]],["bool"]]],[11,"eq","","",1,[[["self"],["options"]],["bool"]]],[11,"ne","","",1,[[["self"],["options"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",1,N],[11,"clone","","",1,[[["self"]],["options"]]],[11,"partial_cmp","","",1,[[["self"],["options"]],["option",["ordering"]]]],[11,"lt","","",1,[[["self"],["options"]],["bool"]]],[11,"le","","",1,[[["self"],["options"]],["bool"]]],[11,"gt","","",1,[[["self"],["options"]],["bool"]]],[11,"ge","","",1,[[["self"],["options"]],["bool"]]],[11,"cmp","","",1,[[["self"],["options"]],["ordering"]]],[11,"hash","","",1,N],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"empty","","Returns an empty set of flags.",1,[[],["options"]]],[11,"all","","Returns the set containing all flags.",1,[[],["options"]]],[11,"bits","","Returns the raw value of the flags currently stored.",1,[[["self"]],["u32"]]],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",1,[[["u32"]],["option",["options"]]]],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",1,[[["u32"]],["options"]]],[11,"is_empty","","Returns `true` if no flags are currently stored.",1,[[["self"]],["bool"]]],[11,"is_all","","Returns `true` if all flags are currently set.",1,[[["self"]],["bool"]]],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",1,[[["self"],["options"]],["bool"]]],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",1,[[["self"],["options"]],["bool"]]],[11,"insert","","Inserts the specified flags in-place.",1,[[["self"],["options"]]]],[11,"remove","","Removes the specified flags in-place.",1,[[["self"],["options"]]]],[11,"toggle","","Toggles the specified flags in-place.",1,[[["self"],["options"]]]],[11,"set","","Inserts or removes the specified flags depending on the passed value.",1,[[["self"],["options"],["bool"]]]],[11,"bitor","","Returns the union of the two sets of flags.",1,[[["self"],["options"]],["options"]]],[11,"bitor_assign","","Adds the set of flags.",1,[[["self"],["options"]]]],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",1,[[["self"],["options"]],["options"]]],[11,"bitxor_assign","","Toggles the set of flags.",1,[[["self"],["options"]]]],[11,"bitand","","Returns the intersection between the two sets of flags.",1,[[["self"],["options"]],["options"]]],[11,"bitand_assign","","Disables all flags disabled in the set.",1,[[["self"],["options"]]]],[11,"sub","","Returns the set difference of the two sets of flags.",1,[[["self"],["options"]],["options"]]],[11,"sub_assign","","Disables all flags enabled in the set.",1,[[["self"],["options"]]]],[11,"not","","Returns the complement of this set of flags.",1,[[["self"]],["options"]]],[11,"extend","","",1,[[["self"],["t"]]]],[11,"from_iter","","",1,[[["t"]],["options"]]],[11,"new_with_links_and_callback","pulldown_cmark::parse","",7,[[["str"],["options"],["hashmap",["string"]],["option",["fn"]]],["rawparser"]]],[11,"new_with_links","","",7,[[["str"],["options"],["hashmap",["string"]]],["rawparser"]]],[11,"new","","",7,[[["str"],["options"]],["rawparser"]]],[11,"get_offset","","",7,[[["self"]],["usize"]]],[11,"get_info","","",7,[[["self"]],["parseinfo"]]],[11,"init_active","","",7,[[["self"]]]],[11,"limit","","",7,[[["self"]],["usize"]]],[11,"start","","",7,[[["self"],["tag"],["usize"],["usize"]],["event"]]],[11,"end","","",7,[[["self"]],["event"]]],[11,"skip_leading_whitespace","","",7,[[["self"]]]],[11,"skip_blank_lines","","",7,[[["self"]]]],[11,"scan_containers","","",7,N],[11,"scan_empty_lines","","",7,N],[11,"scan_whitespace_inline","","",7,[[["self"],["str"]],["usize"]]],[11,"at_list","","",7,[[["self"],["usize"]],["option",["usize"]]]],[11,"start_block","","",7,[[["self"]],["option",["event"]]]],[11,"start_paragraph","","",7,[[["self"]],["event"]]],[11,"start_table_head","","",7,[[["self"]],["event"]]],[11,"start_table_body","","",7,[[["self"]],["event"]]],[11,"start_hrule","","",7,[[["self"]],["event"]]],[11,"start_atx_header","","",7,[[["self"],["i32"]],["event"]]],[11,"start_indented_code","","",7,[[["self"]],["event"]]],[11,"start_listitem","","",7,[[["self"],["usize"],["u8"],["usize"],["usize"]],["event"]]],[11,"start_code_fence","","",7,[[["self"],["usize"],["u8"],["usize"]],["event"]]],[11,"next_code_line_start","","",7,[[["self"]],["event"]]],[11,"next_code","","",7,[[["self"]],["event"]]],[11,"is_code_block_end","","",7,[[["self"],["usize"],["usize"]],["bool"]]],[11,"scan_html_block_tag","","",7,N],[11,"is_html_block","","",7,[[["self"],["str"]],["bool"]]],[11,"get_html_tag","","",7,[[["self"]],["option",["str"]]]],[11,"do_html_block","","",7,[[["self"]],["event"]]],[11,"try_link_reference_definition","","",7,[[["self"],["str"]],["bool"]]],[11,"normalize_link_ref","","",7,[[["self"],["str"]],["string"]]],[11,"is_inline_block_end","","",7,[[["self"],["str"],["usize"]],["bool"]]],[11,"next_table_cell","","",7,[[["self"]],["event"]]],[11,"next_inline","","",7,[[["self"]],["event"]]],[11,"active_char","","",7,[[["self"],["u8"]],["option",["event"]]]],[11,"char_null","","",7,[[["self"]],["event"]]],[11,"char_tab","","",7,[[["self"]],["event"]]],[11,"char_backslash","","",7,[[["self"]],["option",["event"]]]],[11,"char_entity","","",7,[[["self"]],["option",["event"]]]],[11,"char_emphasis","","",7,[[["self"]],["option",["event"]]]],[11,"scan_link_label","","",7,N],[11,"scan_link_title","","",7,N],[11,"char_link","","",7,[[["self"]],["option",["event"]]]],[11,"parse_link","","",7,[[["self"],["str"],["bool"]],["option"]]],[11,"contains_link","","",7,[[["self"],["str"]],["bool"]]],[11,"parse_footnote_definition","","",7,[[["self"],["str"]],["option"]]],[11,"char_link_footnote","","",7,[[["self"]],["option",["event"]]]],[11,"parse_footnote","","",7,[[["self"],["str"]],["option"]]],[11,"scan_footnote_label","","",7,N],[11,"char_lt","","",7,[[["self"]],["option",["event"]]]],[11,"scan_autolink_or_html","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_inline_html","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_html_tag","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_attribute_value","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_html_comment","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_processing_instruction","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_declaration","","",7,[[["self"],["str"]],["usize"]]],[11,"scan_cdata","","",7,[[["self"],["str"]],["usize"]]],[11,"inline_html_event","","",7,[[["self"],["usize"]],["event"]]],[11,"next_literal","","",7,[[["self"]],["event"]]],[11,"scan_inline_code","","",7,N],[11,"char_backtick","","",7,[[["self"]],["option",["event"]]]],[11,"next_inline_code","","",7,[[["self"]],["event"]]],[11,"next","","",7,[[["self"]],["option",["event"]]]],[0,"scanners","pulldown_cmark","Scanners for fragments of CommonMark syntax",N,N],[5,"is_ascii_whitespace","pulldown_cmark::scanners","",N,[[["u8"]],["bool"]]],[5,"is_ascii_whitespace_no_nl","","",N,[[["u8"]],["bool"]]],[5,"is_ascii_alpha","","",N,[[["u8"]],["bool"]]],[5,"is_ascii_upper","","",N,[[["u8"]],["bool"]]],[5,"is_ascii_alphanumeric","","",N,[[["u8"]],["bool"]]],[5,"is_hexdigit","","",N,[[["u8"]],["bool"]]],[5,"is_digit","","",N,[[["u8"]],["bool"]]],[5,"scan_ch","","",N,[[["str"],["u8"]],["usize"]]],[5,"scan_while","","",N,[[["str"],["f"]],["usize"]]],[5,"scan_ch_repeat","","",N,[[["str"],["u8"]],["usize"]]],[5,"scan_whitespace_no_nl","","",N,[[["str"]],["usize"]]],[5,"scan_eol","","",N,N],[5,"scan_trailing_whitespace","","",N,[[["str"]],["usize"]]],[5,"scan_codepoint","","",N,[[["str"]],["option",["char"]]]],[5,"scan_trailing_codepoint","","",N,[[["str"]],["option",["char"]]]],[5,"scan_blank_line","","",N,[[["str"]],["usize"]]],[5,"scan_nextline","","",N,[[["str"]],["usize"]]],[5,"count_tab","","",N,N],[5,"scan_leading_space","","",N,N],[5,"calc_indent","","",N,N],[5,"scan_hrule","","",N,[[["str"]],["usize"]]],[5,"scan_atx_header","","",N,N],[5,"scan_setext_header","","",N,N],[5,"scan_table_head","","",N,N],[5,"scan_code_fence","","",N,N],[5,"scan_backticks","","",N,[[["str"]],["usize"]]],[5,"scan_blockquote_start","","",N,[[["str"]],["usize"]]],[5,"scan_listitem","","",N,N],[5,"compute_open_close","","",N,N],[5,"cow_from_codepoint_str","","",N,[[["str"],["u32"]],["cow",["str"]]]],[5,"scan_entity","","",N,N],[5,"scan_link_dest","","",N,[[["str"]],["option"]]],[5,"scan_autolink","","",N,[[["str"]],["option"]]],[5,"scan_uri","","",N,[[["str"]],["usize"]]],[5,"scan_email","","",N,[[["str"]],["usize"]]],[5,"scan_attribute_name","","",N,[[["str"]],["usize"]]],[5,"is_escaped","","",N,[[["str"],["usize"]],["bool"]]],[5,"unescape","","",N,[[["str"]],["cow",["str"]]]],[5,"is_html_tag","","",N,[[["str"]],["bool"]]],[5,"spaces","","",N,[[["usize"]],["cow",["str"]]]],[17,"HTML_TAGS","","",N,N],[17,"URI_SCHEMES","","",N,N],[0,"entities","pulldown_cmark","Expansions of HTML5 entities",N,N],[5,"get_entity","pulldown_cmark::entities","",N,[[["str"]],["option",["str"]]]],[17,"ENTITIES","","",N,N],[17,"ENTITY_VALUES","","",N,N],[0,"escape","pulldown_cmark","Utility functions for HTML escaping",N,N],[5,"escape_href","pulldown_cmark::escape","",N,[[["string"],["str"]]]],[5,"escape_html","","",N,[[["string"],["str"],["bool"]]]],[7,"HREF_SAFE","","",N,N],[7,"HEX_CHARS","","",N,N],[7,"HTML_ESCAPE_TABLE","","",N,N],[7,"HTML_ESCAPES","","",N,N],[0,"puncttable","pulldown_cmark","CommonMark punctuation set based on spec and Unicode properties.",N,N],[5,"is_ascii_punctuation","pulldown_cmark::puncttable","",N,[[["u8"]],["bool"]]],[5,"is_punctuation","","",N,[[["char"]],["bool"]]],[17,"PUNCT_MASKS_ASCII","","",N,N],[17,"PUNCT_TAB","","",N,N],[17,"PUNCT_MASKS","","",N,N],[0,"utils","pulldown_cmark","Utilities for manipulating strings.",N,N],[5,"ascii_tolower","pulldown_cmark::utils","",N,[[["u8"]],["u8"]]],[5,"strcasecmp","","",N,[[["str"],["str"]],["ordering"]]],[5,"cow_append","","",N,[[["cow",["str"]],["cow",["str"]]],["cow",["str"]]]],[17,"OPTION_ENABLE_TABLES","pulldown_cmark","",N,N],[17,"OPTION_ENABLE_FOOTNOTES","","",N,N],[11,"from","","",0,[[["t"]],["t"]]],[11,"into_iter","","",0,[[["self"]],["i"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"to_owned","","",1,[[["self"]],["t"]]],[11,"clone_into","","",1,N],[11,"from","","",1,[[["t"]],["t"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"to_owned","","",2,[[["self"]],["t"]]],[11,"clone_into","","",2,N],[11,"from","","",2,[[["t"]],["t"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"to_owned","","",3,[[["self"]],["t"]]],[11,"clone_into","","",3,N],[11,"from","","",3,[[["t"]],["t"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]],[11,"to_owned","","",4,[[["self"]],["t"]]],[11,"clone_into","","",4,N],[11,"from","","",4,[[["t"]],["t"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"from","pulldown_cmark::html","",5,[[["t"]],["t"]]],[11,"into","","",5,[[["self"]],["u"]]],[11,"try_from","","",5,[[["u"]],["result"]]],[11,"borrow","","",5,[[["self"]],["t"]]],[11,"try_into","","",5,[[["self"]],["result"]]],[11,"borrow_mut","","",5,[[["self"]],["t"]]],[11,"get_type_id","","",5,[[["self"]],["typeid"]]],[11,"from","","",6,[[["t"]],["t"]]],[11,"into","","",6,[[["self"]],["u"]]],[11,"try_from","","",6,[[["u"]],["result"]]],[11,"borrow","","",6,[[["self"]],["t"]]],[11,"try_into","","",6,[[["self"]],["result"]]],[11,"borrow_mut","","",6,[[["self"]],["t"]]],[11,"get_type_id","","",6,[[["self"]],["typeid"]]],[11,"from","pulldown_cmark::parse","",7,[[["t"]],["t"]]],[11,"into_iter","","",7,[[["self"]],["i"]]],[11,"into","","",7,[[["self"]],["u"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"try_into","","",7,[[["self"]],["result"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"get_type_id","","",7,[[["self"]],["typeid"]]],[11,"from","","",8,[[["t"]],["t"]]],[11,"into","","",8,[[["self"]],["u"]]],[11,"try_from","","",8,[[["u"]],["result"]]],[11,"borrow","","",8,[[["self"]],["t"]]],[11,"try_into","","",8,[[["self"]],["result"]]],[11,"borrow_mut","","",8,[[["self"]],["t"]]],[11,"get_type_id","","",8,[[["self"]],["typeid"]]],[11,"from","","",9,[[["t"]],["t"]]],[11,"into","","",9,[[["self"]],["u"]]],[11,"try_from","","",9,[[["u"]],["result"]]],[11,"borrow","","",9,[[["self"]],["t"]]],[11,"try_into","","",9,[[["self"]],["result"]]],[11,"borrow_mut","","",9,[[["self"]],["t"]]],[11,"get_type_id","","",9,[[["self"]],["typeid"]]],[11,"to_owned","","",10,[[["self"]],["t"]]],[11,"clone_into","","",10,N],[11,"from","","",10,[[["t"]],["t"]]],[11,"into","","",10,[[["self"]],["u"]]],[11,"try_from","","",10,[[["u"]],["result"]]],[11,"borrow","","",10,[[["self"]],["t"]]],[11,"try_into","","",10,[[["self"]],["result"]]],[11,"borrow_mut","","",10,[[["self"]],["t"]]],[11,"get_type_id","","",10,[[["self"]],["typeid"]]]],"paths":[[3,"Parser"],[3,"Options"],[4,"Alignment"],[4,"Event"],[4,"Tag"],[3,"Ctx"],[4,"TableState"],[3,"RawParser"],[3,"ParseInfo"],[4,"State"],[4,"Container"]]};
searchIndex["rand"]={"doc":"Utilities for random number generation","items":[[8,"RngCore","rand","The core of a random number generator.",N,N],[10,"next_u32","","Return the next random `u32`.",0,[[["self"]],["u32"]]],[10,"next_u64","","Return the next random `u64`.",0,[[["self"]],["u64"]]],[10,"fill_bytes","","Fill `dest` with random data.",0,N],[10,"try_fill_bytes","","Fill `dest` entirely with random data.",0,N],[8,"CryptoRng","","A marker trait used to indicate that an [`RngCore`] or [`BlockRngCore`] implementation is supposed to be cryptographically secure.",N,N],[8,"SeedableRng","","A random number generator that can be explicitly seeded.",N,N],[16,"Seed","","Seed type, which is restricted to types mutably-dereferencable as `u8` arrays (we recommend `[u8; N]` for some `N`).",1,N],[10,"from_seed","","Create a new PRNG using the given seed.",1,N],[11,"from_rng","","Create a new PRNG seeded from another `Rng`.",1,[[["r"]],["result",["error"]]]],[4,"ErrorKind","","Error kind which can be matched over.",N,N],[13,"Unavailable","","Feature is not available; not recoverable.",2,N],[13,"Unexpected","","General failure; there may be a chance of recovery on retry.",2,N],[13,"Transient","","A transient failure which likely can be resolved or worked around.",2,N],[13,"NotReady","","Not ready yet: recommended to try again a little later.",2,N],[13,"__Nonexhaustive","","",2,N],[3,"Error","","Error type of random number generators",N,N],[12,"kind","","The error kind",3,N],[12,"msg","","The error message",3,N],[12,"cause","","",3,N],[3,"Generator","","Iterator which will generate a stream of random items.",N,N],[12,"rng","","",4,N],[12,"_marker","","",4,N],[3,"AsciiGenerator","","Iterator which will continuously generate random ascii characters.",N,N],[12,"rng","","",5,N],[5,"thread_rng","","Retrieve the lazily-initialized thread-local random number generator, seeded by the system. Intended to be used in method chaining style, e.g. `thread_rng().gen::<i32>()`, or cached locally, e.g. `let mut rng = thread_rng();`.",N,[[],["threadrng"]]],[5,"weak_rng","","DEPRECATED: use [`SmallRng`] instead.",N,[[],["xorshiftrng"]]],[5,"random","","Generates a random value using the thread-local random number generator.",N,[[],["t"]]],[5,"sample","","DEPRECATED: use `seq::sample_iter` instead.",N,[[["r"],["i"],["usize"]],["vec"]]],[0,"distributions","","Generating random samples from probability distributions.",N,N],[3,"Alphanumeric","rand::distributions","Sample a `char`, uniformly distributed over ASCII letters and numbers: a-z, A-Z and 0-9.",N,N],[3,"Uniform","","Sample values uniformly between two bounds.",N,N],[12,"inner","","",6,N],[3,"OpenClosed01","","A distribution to sample floating point numbers uniformly in the half-open interval `(0, 1]`, i.e. including 1 but not 0.",N,N],[3,"Open01","","A distribution to sample floating point numbers uniformly in the open interval `(0, 1)`, i.e. not including either endpoint.",N,N],[3,"Gamma","","The Gamma distribution `Gamma(shape, scale)` distribution.",N,N],[12,"repr","","",7,N],[3,"ChiSquared","","The chi-squared distribution `χ²(k)`, where `k` is the degrees of freedom.",N,N],[12,"repr","","",8,N],[3,"FisherF","","The Fisher F distribution `F(m, n)`.",N,N],[12,"numer","","",9,N],[12,"denom","","",9,N],[12,"dof_ratio","","",9,N],[3,"StudentT","","The Student t distribution, `t(nu)`, where `nu` is the degrees of freedom.",N,N],[12,"chi","","",10,N],[12,"dof","","",10,N],[3,"Normal","","The normal distribution `N(mean, std_dev**2)`.",N,N],[12,"mean","","",11,N],[12,"std_dev","","",11,N],[3,"LogNormal","","The log-normal distribution `ln N(mean, std_dev**2)`.",N,N],[12,"norm","","",12,N],[3,"StandardNormal","","Samples floating-point numbers according to the normal distribution `N(0, 1)` (a.k.a. a standard normal, or Gaussian). This is equivalent to `Normal::new(0.0, 1.0)` but faster.",N,N],[3,"Exp","","The exponential distribution `Exp(lambda)`.",N,N],[12,"lambda_inverse","","`lambda` stored as `1/lambda`, since this is what we scale by.",13,N],[3,"Exp1","","Samples floating-point numbers according to the exponential distribution, with rate parameter `λ = 1`. This is equivalent to `Exp::new(1.0)` or sampling with `-rng.gen::<f64>().ln()`, but faster.",N,N],[3,"Pareto","","Samples floating-point numbers according to the Pareto distribution",N,N],[12,"scale","","",14,N],[12,"inv_neg_shape","","",14,N],[3,"Poisson","","The Poisson distribution `Poisson(lambda)`.",N,N],[12,"lambda","","",15,N],[12,"exp_lambda","","",15,N],[12,"log_lambda","","",15,N],[12,"sqrt_2lambda","","",15,N],[12,"magic_val","","",15,N],[3,"Binomial","","The binomial distribution `Binomial(n, p)`.",N,N],[12,"n","","Number of trials.",16,N],[12,"p","","Probability of success.",16,N],[3,"Bernoulli","","The Bernoulli distribution.",N,N],[12,"p_int","","Probability of success, relative to the maximal integer.",17,N],[3,"Cauchy","","The Cauchy distribution `Cauchy(median, scale)`.",N,N],[12,"median","","",18,N],[12,"scale","","",18,N],[3,"DistIter","","An iterator that generates random values of `T` with distribution `D`, using `R` as the source of randomness.",N,N],[12,"distr","","",19,N],[12,"rng","","",19,N],[12,"phantom","","",19,N],[3,"Standard","","A generic random value distribution, implemented for many primitive types. Usually generates values with a numerically uniform distribution, and with a range appropriate to the type.",N,N],[3,"Weighted","","A value with a particular weight for use with `WeightedChoice`.",N,N],[12,"weight","","The numerical weight of this item",20,N],[12,"item","","The actual item which is being weighted",20,N],[3,"WeightedChoice","","A distribution that selects from a finite collection of weighted items.",N,N],[12,"items","","",21,N],[12,"weight_range","","",21,N],[5,"ziggurat","","Sample a random number using the Ziggurat method (specifically the ZIGNOR variant from Doornik 2005). Most of the arguments are directly from the paper:",N,N],[0,"uniform","","A distribution uniformly sampling numbers within a given range.",N,N],[3,"Uniform","rand::distributions::uniform","Sample values uniformly between two bounds.",N,N],[12,"inner","","",6,N],[3,"UniformInt","","The back-end implementing [`UniformSampler`] for integer types.",N,N],[12,"low","","",22,N],[12,"range","","",22,N],[12,"zone","","",22,N],[3,"UniformFloat","","The back-end implementing [`UniformSampler`] for floating-point types.",N,N],[12,"scale","","",23,N],[12,"offset","","",23,N],[3,"UniformDuration","","The back-end implementing [`UniformSampler`] for `Duration`.",N,N],[12,"offset","","",24,N],[12,"mode","","",24,N],[4,"UniformDurationMode","","",N,N],[13,"Small","","",25,N],[12,"nanos","rand::distributions::uniform::UniformDurationMode","",25,N],[13,"Large","rand::distributions::uniform","",25,N],[12,"size","rand::distributions::uniform::UniformDurationMode","",25,N],[12,"secs","","",25,N],[8,"SampleUniform","rand::distributions::uniform","Helper trait for creating objects using the correct implementation of [`UniformSampler`] for the sampling type.",N,N],[16,"Sampler","","The `UniformSampler` implementation supporting type `X`.",26,N],[8,"UniformSampler","","Helper trait handling actual uniform sampling.",N,N],[16,"X","","The type sampled by this implementation.",27,N],[10,"new","","Construct self, with inclusive lower bound and exclusive upper bound `[low, high)`.",27,N],[10,"new_inclusive","","Construct self, with inclusive bounds `[low, high]`.",27,N],[10,"sample","","Sample a value.",27,N],[11,"sample_single","","Sample a single value uniformly from a range with inclusive lower bound and exclusive upper bound `[low, high)`.",27,N],[8,"WideningMultiply","","",N,N],[16,"Output","","",28,N],[10,"wmul","","",28,N],[11,"clone","","",6,[[["self"]],["uniform"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `Uniform` instance which samples uniformly from the half open range `[low, high)` (excluding `high`). Panics if `low >= high`.",6,[[["x"],["x"]],["uniform"]]],[11,"new_inclusive","","Create a new `Uniform` instance which samples uniformly from the closed range `[low, high]` (inclusive). Panics if `low > high`.",6,[[["x"],["x"]],["uniform"]]],[11,"sample","","",6,[[["self"],["r"]],["x"]]],[11,"from","","",6,[[["range"]],["uniform"]]],[11,"clone","","",22,[[["self"]],["uniformint"]]],[11,"fmt","","",22,[[["self"],["formatter"]],["result"]]],[11,"new","","",22,N],[11,"new_inclusive","","",22,N],[11,"sample","","",22,N],[11,"sample_single","","",22,N],[11,"new","","",22,N],[11,"new_inclusive","","",22,N],[11,"sample","","",22,N],[11,"sample_single","","",22,N],[11,"new","","",22,N],[11,"new_inclusive","","",22,N],[11,"sample","","",22,N],[11,"sample_single","","",22,N],[11,"new","","",22,N],[11,"new_inclusive","","",22,N],[11,"sample","","",22,N],[11,"sample_single","","",22,N],[11,"new","","",22,N],[11,"new_inclusive","","",22,N],[11,"sample","","",22,N],[11,"sample_single","","",22,N],[11,"new","","",22,N],[11,"new_inclusive","","",22,N],[11,"sample","","",22,N],[11,"sample_single","","",22,N],[11,"new","","",22,N],[11,"new_inclusive","","",22,N],[11,"sample","","",22,N],[11,"sample_single","","",22,N],[11,"new","","",22,N],[11,"new_inclusive","","",22,N],[11,"sample","","",22,N],[11,"sample_single","","",22,N],[11,"new","","",22,N],[11,"new_inclusive","","",22,N],[11,"sample","","",22,N],[11,"sample_single","","",22,N],[11,"new","","",22,N],[11,"new_inclusive","","",22,N],[11,"sample","","",22,N],[11,"sample_single","","",22,N],[11,"clone","","",23,[[["self"]],["uniformfloat"]]],[11,"fmt","","",23,[[["self"],["formatter"]],["result"]]],[11,"new","","",23,N],[11,"new_inclusive","","",23,N],[11,"sample","","",23,N],[11,"sample_single","","",23,N],[11,"new","","",23,N],[11,"new_inclusive","","",23,N],[11,"sample","","",23,N],[11,"sample_single","","",23,N],[11,"clone","","",24,[[["self"]],["uniformduration"]]],[11,"fmt","","",24,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",25,[[["self"],["formatter"]],["result"]]],[11,"clone","","",25,[[["self"]],["uniformdurationmode"]]],[11,"new","","",24,[[["duration"],["duration"]],["uniformduration"]]],[11,"new_inclusive","","",24,[[["duration"],["duration"]],["uniformduration"]]],[11,"sample","","",24,[[["self"],["r"]],["duration"]]],[0,"gamma","rand::distributions","The Gamma and derived distributions.",N,N],[3,"Gamma","rand::distributions::gamma","The Gamma distribution `Gamma(shape, scale)` distribution.",N,N],[12,"repr","","",7,N],[3,"GammaSmallShape","","Gamma distribution where the shape parameter is less than 1.",N,N],[12,"inv_shape","","",29,N],[12,"large_shape","","",29,N],[3,"GammaLargeShape","","Gamma distribution where the shape parameter is larger than 1.",N,N],[12,"scale","","",30,N],[12,"c","","",30,N],[12,"d","","",30,N],[3,"ChiSquared","","The chi-squared distribution `χ²(k)`, where `k` is the degrees of freedom.",N,N],[12,"repr","","",8,N],[3,"FisherF","","The Fisher F distribution `F(m, n)`.",N,N],[12,"numer","","",9,N],[12,"denom","","",9,N],[12,"dof_ratio","","",9,N],[3,"StudentT","","The Student t distribution, `t(nu)`, where `nu` is the degrees of freedom.",N,N],[12,"chi","","",10,N],[12,"dof","","",10,N],[4,"GammaRepr","","",N,N],[13,"Large","","",31,N],[13,"One","","",31,N],[13,"Small","","",31,N],[4,"ChiSquaredRepr","","",N,N],[13,"DoFExactlyOne","","",32,N],[13,"DoFAnythingElse","","",32,N],[11,"clone","","",7,[[["self"]],["gamma"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"clone","","",31,[[["self"]],["gammarepr"]]],[11,"fmt","","",31,[[["self"],["formatter"]],["result"]]],[11,"clone","","",29,[[["self"]],["gammasmallshape"]]],[11,"fmt","","",29,[[["self"],["formatter"]],["result"]]],[11,"clone","","",30,[[["self"]],["gammalargeshape"]]],[11,"fmt","","",30,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct an object representing the `Gamma(shape, scale)` distribution.",7,[[["f64"],["f64"]],["gamma"]]],[11,"new_raw","","",29,[[["f64"],["f64"]],["gammasmallshape"]]],[11,"new_raw","","",30,[[["f64"],["f64"]],["gammalargeshape"]]],[11,"sample","","",7,[[["self"],["r"]],["f64"]]],[11,"sample","","",29,[[["self"],["r"]],["f64"]]],[11,"sample","","",30,[[["self"],["r"]],["f64"]]],[11,"clone","","",8,[[["self"]],["chisquared"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"clone","","",32,[[["self"]],["chisquaredrepr"]]],[11,"fmt","","",32,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new chi-squared distribution with degrees-of-freedom `k`. Panics if `k < 0`.",8,[[["f64"]],["chisquared"]]],[11,"sample","","",8,[[["self"],["r"]],["f64"]]],[11,"clone","","",9,[[["self"]],["fisherf"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `FisherF` distribution, with the given parameter. Panics if either `m` or `n` are not positive.",9,[[["f64"],["f64"]],["fisherf"]]],[11,"sample","","",9,[[["self"],["r"]],["f64"]]],[11,"clone","","",10,[[["self"]],["studentt"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new Student t distribution with `n` degrees of freedom. Panics if `n <= 0`.",10,[[["f64"]],["studentt"]]],[11,"sample","","",10,[[["self"],["r"]],["f64"]]],[0,"normal","rand::distributions","The normal and derived distributions.",N,N],[3,"StandardNormal","rand::distributions::normal","Samples floating-point numbers according to the normal distribution `N(0, 1)` (a.k.a. a standard normal, or Gaussian). This is equivalent to `Normal::new(0.0, 1.0)` but faster.",N,N],[3,"Normal","","The normal distribution `N(mean, std_dev**2)`.",N,N],[12,"mean","","",11,N],[12,"std_dev","","",11,N],[3,"LogNormal","","The log-normal distribution `ln N(mean, std_dev**2)`.",N,N],[12,"norm","","",12,N],[11,"clone","","",33,[[["self"]],["standardnormal"]]],[11,"fmt","","",33,[[["self"],["formatter"]],["result"]]],[11,"sample","","",33,[[["self"],["r"]],["f64"]]],[11,"clone","","",11,[[["self"]],["normal"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new `Normal` distribution with the given mean and standard deviation.",11,[[["f64"],["f64"]],["normal"]]],[11,"sample","","",11,[[["self"],["r"]],["f64"]]],[11,"clone","","",12,[[["self"]],["lognormal"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new `LogNormal` distribution with the given mean and standard deviation.",12,[[["f64"],["f64"]],["lognormal"]]],[11,"sample","","",12,[[["self"],["r"]],["f64"]]],[0,"exponential","rand::distributions","The exponential distribution.",N,N],[3,"Exp1","rand::distributions::exponential","Samples floating-point numbers according to the exponential distribution, with rate parameter `λ = 1`. This is equivalent to `Exp::new(1.0)` or sampling with `-rng.gen::<f64>().ln()`, but faster.",N,N],[3,"Exp","","The exponential distribution `Exp(lambda)`.",N,N],[12,"lambda_inverse","","`lambda` stored as `1/lambda`, since this is what we scale by.",13,N],[11,"clone","","",34,[[["self"]],["exp1"]]],[11,"fmt","","",34,[[["self"],["formatter"]],["result"]]],[11,"sample","","",34,[[["self"],["r"]],["f64"]]],[11,"clone","","",13,[[["self"]],["exp"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new `Exp` with the given shape parameter `lambda`. Panics if `lambda <= 0`.",13,[[["f64"]],["exp"]]],[11,"sample","","",13,[[["self"],["r"]],["f64"]]],[0,"pareto","rand::distributions","The Pareto distribution.",N,N],[3,"Pareto","rand::distributions::pareto","Samples floating-point numbers according to the Pareto distribution",N,N],[12,"scale","","",14,N],[12,"inv_neg_shape","","",14,N],[11,"clone","","",14,[[["self"]],["pareto"]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new Pareto distribution with given `scale` and `shape`.",14,[[["f64"],["f64"]],["pareto"]]],[11,"sample","","",14,[[["self"],["r"]],["f64"]]],[0,"poisson","rand::distributions","The Poisson distribution.",N,N],[3,"Poisson","rand::distributions::poisson","The Poisson distribution `Poisson(lambda)`.",N,N],[12,"lambda","","",15,N],[12,"exp_lambda","","",15,N],[12,"log_lambda","","",15,N],[12,"sqrt_2lambda","","",15,N],[12,"magic_val","","",15,N],[11,"clone","","",15,[[["self"]],["poisson"]]],[11,"fmt","","",15,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new `Poisson` with the given shape parameter `lambda`. Panics if `lambda <= 0`.",15,[[["f64"]],["poisson"]]],[11,"sample","","",15,[[["self"],["r"]],["u64"]]],[0,"binomial","rand::distributions","The binomial distribution.",N,N],[3,"Binomial","rand::distributions::binomial","The binomial distribution `Binomial(n, p)`.",N,N],[12,"n","","Number of trials.",16,N],[12,"p","","Probability of success.",16,N],[11,"clone","","",16,[[["self"]],["binomial"]]],[11,"fmt","","",16,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new `Binomial` with the given shape parameters `n` (number of trials) and `p` (probability of success).",16,[[["u64"],["f64"]],["binomial"]]],[11,"sample","","",16,[[["self"],["r"]],["u64"]]],[0,"bernoulli","rand::distributions","The Bernoulli distribution.",N,N],[3,"Bernoulli","rand::distributions::bernoulli","The Bernoulli distribution.",N,N],[12,"p_int","","Probability of success, relative to the maximal integer.",17,N],[11,"clone","","",17,[[["self"]],["bernoulli"]]],[11,"fmt","","",17,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new `Bernoulli` with the given probability of success `p`.",17,[[["f64"]],["bernoulli"]]],[11,"sample","","",17,[[["self"],["r"]],["bool"]]],[0,"cauchy","rand::distributions","The Cauchy distribution.",N,N],[3,"Cauchy","rand::distributions::cauchy","The Cauchy distribution `Cauchy(median, scale)`.",N,N],[12,"median","","",18,N],[12,"scale","","",18,N],[11,"clone","","",18,[[["self"]],["cauchy"]]],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"new","","Construct a new `Cauchy` with the given shape parameters `median` the peak location and `scale` the scale factor. Panics if `scale <= 0`.",18,[[["f64"],["f64"]],["cauchy"]]],[11,"sample","","",18,[[["self"],["r"]],["f64"]]],[0,"float","rand::distributions","Basic floating-point number distributions",N,N],[3,"OpenClosed01","rand::distributions::float","A distribution to sample floating point numbers uniformly in the half-open interval `(0, 1]`, i.e. including 1 but not 0.",N,N],[3,"Open01","","A distribution to sample floating point numbers uniformly in the open interval `(0, 1)`, i.e. not including either endpoint.",N,N],[8,"IntoFloat","","",N,N],[16,"F","","",35,N],[10,"into_float_with_exponent","","Helper method to combine the fraction and a contant exponent into a float.",35,N],[11,"clone","rand::distributions","",36,[[["self"]],["openclosed01"]]],[11,"fmt","","",36,[[["self"],["formatter"]],["result"]]],[11,"clone","","",37,[[["self"]],["open01"]]],[11,"fmt","","",37,[[["self"],["formatter"]],["result"]]],[11,"sample","","",38,[[["self"],["r"]],["f32"]]],[11,"sample","","",36,[[["self"],["r"]],["f32"]]],[11,"sample","","",37,[[["self"],["r"]],["f32"]]],[11,"sample","","",38,[[["self"],["r"]],["f64"]]],[11,"sample","","",36,[[["self"],["r"]],["f64"]]],[11,"sample","","",37,[[["self"],["r"]],["f64"]]],[0,"integer","","The implementations of the `Standard` distribution for integer types.",N,N],[11,"sample","","",38,[[["self"],["r"]],["u8"]]],[11,"sample","","",38,[[["self"],["r"]],["u16"]]],[11,"sample","","",38,[[["self"],["r"]],["u32"]]],[11,"sample","","",38,[[["self"],["r"]],["u64"]]],[11,"sample","","",38,[[["self"],["r"]],["usize"]]],[11,"sample","","",38,[[["self"],["r"]],["i8"]]],[11,"sample","","",38,[[["self"],["r"]],["i16"]]],[11,"sample","","",38,[[["self"],["r"]],["i32"]]],[11,"sample","","",38,[[["self"],["r"]],["i64"]]],[11,"sample","","",38,[[["self"],["r"]],["isize"]]],[0,"log_gamma","","",N,N],[5,"log_gamma","rand::distributions::log_gamma","Calculates ln(gamma(x)) (natural logarithm of the gamma function) using the Lanczos approximation.",N,[[["f64"]],["f64"]]],[0,"other","rand::distributions","The implementations of the `Standard` distribution for other built-in types.",N,N],[3,"Alphanumeric","rand::distributions::other","Sample a `char`, uniformly distributed over ASCII letters and numbers: a-z, A-Z and 0-9.",N,N],[11,"fmt","rand::distributions","",39,[[["self"],["formatter"]],["result"]]],[11,"sample","","",38,[[["self"],["r"]],["char"]]],[11,"sample","","",39,[[["self"],["r"]],["char"]]],[11,"sample","","",38,[[["self"],["r"]],["bool"]]],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,N],[11,"sample","","",38,[[["self"],["r"]],["option"]]],[11,"sample","","",38,[[["self"],["r"]],["wrapping"]]],[0,"ziggurat_tables","","",N,N],[6,"ZigTable","rand::distributions::ziggurat_tables","",N,N],[7,"ZIG_NORM_X","","",N,N],[7,"ZIG_NORM_F","","",N,N],[7,"ZIG_EXP_X","","",N,N],[7,"ZIG_EXP_F","","",N,N],[17,"ZIG_NORM_R","","",N,N],[17,"ZIG_EXP_R","","",N,N],[0,"range","rand::distributions","DEPRECATED: Use `distributions::uniform` instead.",N,N],[0,"impls","","",N,N],[11,"sample","","",21,[[["self"],["r"]],["t"]]],[11,"ind_sample","","",21,[[["self"],["r"]],["t"]]],[11,"sample","rand::distributions::uniform","",6,[[["self"],["r"]],["t"]]],[11,"ind_sample","","",6,[[["self"],["r"]],["t"]]],[11,"sample","rand::distributions::exponential","",13,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",13,[[["self"],["r"]],["f64"]]],[11,"sample","rand::distributions::gamma","",7,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",7,[[["self"],["r"]],["f64"]]],[11,"sample","","",8,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",8,[[["self"],["r"]],["f64"]]],[11,"sample","","",9,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",9,[[["self"],["r"]],["f64"]]],[11,"sample","","",10,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",10,[[["self"],["r"]],["f64"]]],[11,"sample","rand::distributions::normal","",11,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",11,[[["self"],["r"]],["f64"]]],[11,"sample","","",12,[[["self"],["r"]],["f64"]]],[11,"ind_sample","","",12,[[["self"],["r"]],["f64"]]],[8,"Sample","rand::distributions","Types that can be used to create a random instance of `Support`.",N,N],[10,"sample","","Generate a random value of `Support`, using `rng` as the source of randomness.",40,[[["self"],["r"]],["support"]]],[8,"IndependentSample","","`Sample`s that do not require keeping track of state.",N,N],[10,"ind_sample","","Generate a random value.",41,[[["self"],["r"]],["support"]]],[8,"Distribution","","Types (distributions) that can be used to create a random instance of `T`.",N,N],[10,"sample","","Generate a random value of `T`, using `rng` as the source of randomness.",42,[[["self"],["r"]],["t"]]],[11,"sample_iter","","Create an iterator that generates random values of `T`, using `rng` as the source of randomness.",42,[[["self"],["r"]],["distiter"]]],[11,"fmt","","",19,[[["self"],["formatter"]],["result"]]],[11,"next","","",19,[[["self"]],["option"]]],[11,"size_hint","","",19,N],[11,"clone","","",38,[[["self"]],["standard"]]],[11,"fmt","","",38,[[["self"],["formatter"]],["result"]]],[11,"clone","","",20,[[["self"]],["weighted"]]],[11,"fmt","","",20,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",21,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `WeightedChoice`.",21,N],[11,"sample","","",21,[[["self"],["r"]],["t"]]],[0,"prelude","rand","Convenience re-export of common members",N,N],[0,"prng","","Pseudo-random number generators.",N,N],[3,"XorShiftRng","rand::prng","An Xorshift random number generator.",N,N],[12,"x","","",43,N],[12,"y","","",43,N],[12,"z","","",43,N],[12,"w","","",43,N],[0,"chacha","","The ChaCha random number generator.",N,N],[3,"ChaChaRng","rand::prng::chacha","A cryptographically secure random number generator that uses the ChaCha algorithm.",N,N],[12,"0","","",44,N],[3,"ChaChaCore","","The core of `ChaChaRng`, used with `BlockRng`.",N,N],[12,"state","","",45,N],[17,"SEED_WORDS","","",N,N],[17,"STATE_WORDS","","",N,N],[11,"clone","","",44,[[["self"]],["chacharng"]]],[11,"fmt","","",44,[[["self"],["formatter"]],["result"]]],[11,"next_u32","","",44,[[["self"]],["u32"]]],[11,"next_u64","","",44,[[["self"]],["u64"]]],[11,"fill_bytes","","",44,N],[11,"try_fill_bytes","","",44,N],[11,"from_seed","","",44,N],[11,"from_rng","","",44,[[["r"]],["result",["error"]]]],[11,"new_unseeded","","Create an ChaCha random number generator using the default fixed key of 8 zero words.",44,[[],["chacharng"]]],[11,"set_stream","","Set the stream number.",44,[[["self"],["u64"]]]],[11,"clone","","",45,[[["self"]],["chachacore"]]],[11,"fmt","","",45,[[["self"],["formatter"]],["result"]]],[11,"generate","","",45,N],[11,"from_seed","","",45,N],[11,"from","","",44,[[["chachacore"]],["self"]]],[0,"hc128","rand::prng","The HC-128 random number generator.",N,N],[3,"Hc128Rng","rand::prng::hc128","A cryptographically secure random number generator that uses the HC-128 algorithm.",N,N],[12,"0","","",46,N],[3,"Hc128Core","","The core of `Hc128Rng`, used with `BlockRng`.",N,N],[12,"t","","",47,N],[12,"counter1024","","",47,N],[17,"SEED_WORDS","","",N,N],[11,"clone","","",46,[[["self"]],["hc128rng"]]],[11,"fmt","","",46,[[["self"],["formatter"]],["result"]]],[11,"next_u32","","",46,[[["self"]],["u32"]]],[11,"next_u64","","",46,[[["self"]],["u64"]]],[11,"fill_bytes","","",46,N],[11,"try_fill_bytes","","",46,N],[11,"from_seed","","",46,N],[11,"from_rng","","",46,[[["r"]],["result",["error"]]]],[11,"clone","","",47,[[["self"]],["hc128core"]]],[11,"fmt","","",47,[[["self"],["formatter"]],["result"]]],[11,"generate","","",47,N],[11,"step_p","","",47,[[["self"],["usize"],["usize"],["usize"],["usize"],["usize"]],["u32"]]],[11,"step_q","","",47,[[["self"],["usize"],["usize"],["usize"],["usize"],["usize"]],["u32"]]],[11,"sixteen_steps","","",47,[[["self"]]]],[11,"init","","",47,N],[11,"from_seed","","Create an HC-128 random number generator with a seed. The seed has to be 256 bits in length, matching the 128 bit `key` followed by 128 bit `iv` when HC-128 where to be used as a stream cipher.",47,N],[0,"isaac","rand::prng","The ISAAC random number generator.",N,N],[3,"IsaacRng","rand::prng::isaac","A random number generator that uses the ISAAC algorithm.",N,N],[12,"0","","",48,N],[3,"IsaacCore","","The core of `IsaacRng`, used with `BlockRng`.",N,N],[12,"mem","","",49,N],[12,"a","","",49,N],[12,"b","","",49,N],[12,"c","","",49,N],[6,"w32","","",N,N],[17,"RAND_SIZE_LEN","","",N,N],[17,"RAND_SIZE","","",N,N],[11,"clone","","",48,[[["self"]],["isaacrng"]]],[11,"fmt","","",48,[[["self"],["formatter"]],["result"]]],[11,"next_u32","","",48,[[["self"]],["u32"]]],[11,"next_u64","","",48,[[["self"]],["u64"]]],[11,"fill_bytes","","",48,N],[11,"try_fill_bytes","","",48,N],[11,"from_seed","","",48,N],[11,"from_rng","","",48,[[["s"]],["result",["error"]]]],[11,"new_unseeded","","Create an ISAAC random number generator using the default fixed seed.",48,[[],["self"]]],[11,"new_from_u64","","Create an ISAAC random number generator using an `u64` as seed. If `seed == 0` this will produce the same stream of random numbers as the reference implementation when used unseeded.",48,[[["u64"]],["self"]]],[11,"clone","","",49,[[["self"]],["isaaccore"]]],[11,"fmt","","",49,[[["self"],["formatter"]],["result"]]],[11,"generate","","Refills the output buffer, `results`. See also the pseudocode desciption of the algorithm in the [`IsaacRng`] documentation.",49,[[["self"],["isaacarray"]]]],[11,"init","","Create a new ISAAC random number generator.",49,N],[11,"new_from_u64","","Create an ISAAC random number generator using an `u64` as seed. If `seed == 0` this will produce the same stream of random numbers as the reference implementation when used unseeded.",49,[[["u64"]],["self"]]],[11,"from_seed","","",49,N],[11,"from_rng","","",49,[[["r"]],["result",["error"]]]],[0,"isaac64","rand::prng","The ISAAC-64 random number generator.",N,N],[3,"Isaac64Rng","rand::prng::isaac64","A random number generator that uses ISAAC-64, the 64-bit variant of the ISAAC algorithm.",N,N],[12,"0","","",50,N],[3,"Isaac64Core","","The core of `Isaac64Rng`, used with `BlockRng`.",N,N],[12,"mem","","",51,N],[12,"a","","",51,N],[12,"b","","",51,N],[12,"c","","",51,N],[6,"w64","","",N,N],[17,"RAND_SIZE_LEN","","",N,N],[17,"RAND_SIZE","","",N,N],[11,"clone","","",50,[[["self"]],["isaac64rng"]]],[11,"fmt","","",50,[[["self"],["formatter"]],["result"]]],[11,"next_u32","","",50,[[["self"]],["u32"]]],[11,"next_u64","","",50,[[["self"]],["u64"]]],[11,"fill_bytes","","",50,N],[11,"try_fill_bytes","","",50,N],[11,"from_seed","","",50,N],[11,"from_rng","","",50,[[["s"]],["result",["error"]]]],[11,"new_unseeded","","Create a 64-bit ISAAC random number generator using the default fixed seed.",50,[[],["self"]]],[11,"new_from_u64","","Create an ISAAC-64 random number generator using an `u64` as seed. If `seed == 0` this will produce the same stream of random numbers as the reference implementation when used unseeded.",50,[[["u64"]],["self"]]],[11,"clone","","",51,[[["self"]],["isaac64core"]]],[11,"fmt","","",51,[[["self"],["formatter"]],["result"]]],[11,"generate","","Refills the output buffer, `results`. See also the pseudocode desciption of the algorithm in the [`Isaac64Rng`] documentation.",51,[[["self"],["isaacarray"]]]],[11,"init","","Create a new ISAAC-64 random number generator.",51,N],[11,"new_from_u64","","Create an ISAAC-64 random number generator using an `u64` as seed. If `seed == 0` this will produce the same stream of random numbers as the reference implementation when used unseeded.",51,[[["u64"]],["self"]]],[11,"from_seed","","",51,N],[11,"from_rng","","",51,[[["r"]],["result",["error"]]]],[0,"xorshift","rand::prng","Xorshift generators",N,N],[3,"XorShiftRng","rand::prng::xorshift","An Xorshift random number generator.",N,N],[12,"x","","",43,N],[12,"y","","",43,N],[12,"z","","",43,N],[12,"w","","",43,N],[11,"clone","rand::prng","",43,[[["self"]],["xorshiftrng"]]],[11,"fmt","","",43,[[["self"],["formatter"]],["result"]]],[11,"new_unseeded","","Creates a new XorShiftRng instance which is not seeded.",43,[[],["xorshiftrng"]]],[11,"next_u32","","",43,[[["self"]],["u32"]]],[11,"next_u64","","",43,[[["self"]],["u64"]]],[11,"fill_bytes","","",43,N],[11,"try_fill_bytes","","",43,N],[11,"from_seed","","",43,N],[11,"from_rng","","",43,[[["r"]],["result",["error"]]]],[0,"isaac_array","","ISAAC helper functions for 256-element arrays.",N,N],[3,"IsaacArray","rand::prng::isaac_array","",N,N],[12,"inner","","",52,N],[17,"RAND_SIZE_LEN","","",N,N],[17,"RAND_SIZE","","",N,N],[11,"clone","","",52,[[["self"]],["isaacarray"]]],[11,"as_ref","","",52,N],[11,"as_mut","","",52,N],[11,"deref","","",52,N],[11,"deref_mut","","",52,N],[11,"default","","",52,[[],["isaacarray"]]],[0,"rngs","rand","Random number generators and adapters for common usage:",N,N],[3,"JitterRng","rand::rngs","A true random number generator based on jitter in the CPU execution time, and jitter in memory access time.",N,N],[12,"data","","",53,N],[12,"rounds","","",53,N],[12,"timer","","",53,N],[12,"mem_prev_index","","",53,N],[12,"data_half_used","","",53,N],[3,"EntropyRng","","An interface returning random data from external source(s), provided specifically for securely seeding algorithmic generators (PRNGs).",N,N],[12,"source","","",54,N],[3,"SmallRng","","An RNG recommended when small state, cheap initialization and good performance are required. The PRNG algorithm in `SmallRng` is chosen to be efficient on the current platform, without consideration for cryptography or security. The size of its state is much smaller than for [`StdRng`].",N,N],[12,"0","","",55,N],[3,"StdRng","","The standard RNG. The PRNG algorithm in `StdRng` is chosen to be efficient on the current platform, to be statistically strong and unpredictable (meaning a cryptographically secure PRNG).",N,N],[12,"0","","",56,N],[3,"ThreadRng","","The type returned by [`thread_rng`], essentially just a reference to the PRNG in thread-local memory.",N,N],[12,"rng","","",57,N],[3,"OsRng","","A random number generator that retrieves randomness straight from the operating system.",N,N],[12,"0","","",58,N],[4,"TimerError","","An error that can occur when [`JitterRng::test_timer`] fails.",N,N],[13,"NoTimer","","No timer available.",59,N],[13,"CoarseTimer","","Timer too coarse to use as an entropy source.",59,N],[13,"NotMonotonic","","Timer is not monotonically increasing.",59,N],[13,"TinyVariantions","","Variations of deltas of time too small.",59,N],[13,"TooManyStuck","","Too many stuck results (indicating no added entropy).",59,N],[13,"__Nonexhaustive","","",59,N],[0,"adapter","","Wrappers / adapters forming RNGs",N,N],[3,"ReadRng","rand::rngs::adapter","An RNG that reads random bytes straight from any type supporting `std::io::Read`, for example files.",N,N],[12,"reader","","",60,N],[3,"ReseedingRng","","A wrapper around any PRNG which reseeds the underlying PRNG after it has generated a certain number of random bytes.",N,N],[12,"0","","",61,N],[0,"read","","A wrapper around any Read to treat it as an RNG.",N,N],[3,"ReadRng","rand::rngs::adapter::read","An RNG that reads random bytes straight from any type supporting `std::io::Read`, for example files.",N,N],[12,"reader","","",60,N],[11,"fmt","","",60,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `ReadRng` from a `Read`.",60,[[["r"]],["readrng"]]],[11,"next_u32","","",60,[[["self"]],["u32"]]],[11,"next_u64","","",60,[[["self"]],["u64"]]],[11,"fill_bytes","","",60,N],[11,"try_fill_bytes","","",60,N],[0,"reseeding","rand::rngs::adapter","A wrapper around another PRNG that reseeds it after it generates a certain number of random bytes.",N,N],[3,"ReseedingRng","rand::rngs::adapter::reseeding","A wrapper around any PRNG which reseeds the underlying PRNG after it has generated a certain number of random bytes.",N,N],[12,"0","","",61,N],[3,"ReseedingCore","","",N,N],[12,"inner","","",62,N],[12,"reseeder","","",62,N],[12,"threshold","","",62,N],[12,"bytes_until_reseed","","",62,N],[11,"fmt","rand::rngs::adapter","",61,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `ReseedingRng` with the given parameters.",61,[[["r"],["u64"],["rsdr"]],["self"]]],[11,"reseed","","Reseed the internal PRNG.",61,[[["self"]],["result",["error"]]]],[11,"next_u32","","",61,[[["self"]],["u32"]]],[11,"next_u64","","",61,[[["self"]],["u64"]]],[11,"fill_bytes","","",61,N],[11,"try_fill_bytes","","",61,N],[11,"clone","","",61,[[["self"]],["reseedingrng"]]],[11,"fmt","rand::rngs::adapter::reseeding","",62,[[["self"],["formatter"]],["result"]]],[11,"generate","","",62,N],[11,"new","","Create a new `ReseedingCore` with the given parameters.",62,[[["r"],["u64"],["rsdr"]],["self"]]],[11,"reseed","","Reseed the internal PRNG.",62,[[["self"]],["result",["error"]]]],[11,"reseed_and_generate","","",62,N],[11,"clone","","",62,[[["self"]],["reseedingcore"]]],[0,"entropy","rand::rngs","Entropy generator, or wrapper around external generators",N,N],[3,"EntropyRng","rand::rngs::entropy","An interface returning random data from external source(s), provided specifically for securely seeding algorithmic generators (PRNGs).",N,N],[12,"source","","",54,N],[3,"NoSource","","",N,N],[3,"Os","","",N,N],[12,"0","","",63,N],[3,"Jitter","","",N,N],[12,"0","","",64,N],[4,"Source","","",N,N],[13,"Os","","",65,N],[13,"Custom","","",65,N],[13,"Jitter","","",65,N],[13,"None","","",65,N],[6,"Custom","","",N,N],[8,"EntropySource","","",N,N],[10,"new_and_fill","","",66,N],[10,"fill","","",66,N],[11,"is_supported","","",66,[[],["bool"]]],[11,"fmt","rand::rngs","",54,[[["self"],["formatter"]],["result"]]],[11,"fmt","rand::rngs::entropy","",65,[[["self"],["formatter"]],["result"]]],[11,"new","rand::rngs","Create a new `EntropyRng`.",54,[[],["self"]]],[11,"default","","",54,[[],["self"]]],[11,"next_u32","","",54,[[["self"]],["u32"]]],[11,"next_u64","","",54,[[["self"]],["u64"]]],[11,"fill_bytes","","",54,N],[11,"try_fill_bytes","","",54,N],[11,"clone","rand::rngs::entropy","",67,[[["self"]],["nosource"]]],[11,"fmt","","",67,[[["self"],["formatter"]],["result"]]],[11,"new_and_fill","","",67,N],[11,"fill","","",67,N],[11,"is_supported","","",67,[[],["bool"]]],[11,"clone","","",63,[[["self"]],["os"]]],[11,"fmt","","",63,[[["self"],["formatter"]],["result"]]],[11,"new_and_fill","","",63,N],[11,"fill","","",63,N],[11,"clone","","",64,[[["self"]],["jitter"]]],[11,"fmt","","",64,[[["self"],["formatter"]],["result"]]],[11,"new_and_fill","","",64,N],[11,"fill","","",64,N],[0,"jitter","rand::rngs","Non-physical true random number generator based on timing jitter.",N,N],[3,"JitterRng","rand::rngs::jitter","A true random number generator based on jitter in the CPU execution time, and jitter in memory access time.",N,N],[12,"data","","",53,N],[12,"rounds","","",53,N],[12,"timer","","",53,N],[12,"mem_prev_index","","",53,N],[12,"data_half_used","","",53,N],[3,"EcState","","",N,N],[12,"prev_time","","",68,N],[12,"last_delta","","",68,N],[12,"last_delta2","","",68,N],[12,"mem","","",68,N],[4,"TimerError","","An error that can occur when [`JitterRng::test_timer`] fails.",N,N],[13,"NoTimer","","No timer available.",59,N],[13,"CoarseTimer","","Timer too coarse to use as an entropy source.",59,N],[13,"NotMonotonic","","Timer is not monotonically increasing.",59,N],[13,"TinyVariantions","","Variations of deltas of time too small.",59,N],[13,"TooManyStuck","","Too many stuck results (indicating no added entropy).",59,N],[13,"__Nonexhaustive","","",59,N],[5,"black_box","","",N,[[["t"]],["t"]]],[0,"platform","","",N,N],[5,"get_nstime","rand::rngs::jitter::platform","",N,[[],["u64"]]],[7,"JITTER_ROUNDS","rand::rngs::jitter","",N,N],[17,"MEMORY_BLOCKS","","",N,N],[17,"MEMORY_BLOCKSIZE","","",N,N],[17,"MEMORY_SIZE","","",N,N],[11,"stuck","","",68,[[["self"],["i32"]],["bool"]]],[11,"fmt","","",53,[[["self"],["formatter"]],["result"]]],[11,"clone","","",53,[[["self"]],["jitterrng"]]],[11,"fmt","","",59,[[["self"],["formatter"]],["result"]]],[11,"clone","","",59,[[["self"]],["timererror"]]],[11,"eq","","",59,[[["self"],["timererror"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",59,N],[11,"description","","",59,[[["self"]],["str"]]],[11,"fmt","","",59,[[["self"],["formatter"]],["result"]]],[11,"description","","",59,[[["self"]],["str"]]],[11,"from","rand","",3,[[["timererror"]],["error"]]],[11,"new","rand::rngs::jitter","Create a new `JitterRng`. Makes use of `std::time` for a timer, or a platform-specific function with higher accuracy if necessary and available.",53,[[],["result",["jitterrng","timererror"]]]],[11,"new_with_timer","","Create a new `JitterRng`. A custom timer can be supplied, making it possible to use `JitterRng` in `no_std` environments.",53,N],[11,"set_rounds","","Configures how many rounds are used to generate each 64-bit value. This must be greater than zero, and has a big impact on performance and output quality.",53,[[["self"],["u8"]]]],[11,"random_loop_cnt","","",53,[[["self"],["u32"]],["u32"]]],[11,"lfsr_time","","",53,[[["self"],["u64"],["bool"]]]],[11,"memaccess","","",53,N],[11,"measure_jitter","","",53,[[["self"],["ecstate"]],["option"]]],[11,"stir_pool","","",53,[[["self"]]]],[11,"gen_entropy","","",53,[[["self"]],["u64"]]],[11,"test_timer","","Basic quality tests on the timer, by measuring CPU timing jitter a few hundred times.",53,[[["self"]],["result",["u8","timererror"]]]],[11,"timer_stats","","Statistical test: return the timer delta of one normal run of the `JitterRng` entropy collector.",53,[[["self"],["bool"]],["i64"]]],[11,"next_u32","","",53,[[["self"]],["u32"]]],[11,"next_u64","","",53,[[["self"]],["u64"]]],[11,"fill_bytes","","",53,N],[11,"try_fill_bytes","","",53,N],[0,"mock","rand::rngs","Mock random number generator",N,N],[3,"StepRng","rand::rngs::mock","A simple implementation of `RngCore` for testing purposes.",N,N],[12,"v","","",69,N],[12,"a","","",69,N],[11,"fmt","","",69,[[["self"],["formatter"]],["result"]]],[11,"clone","","",69,[[["self"]],["steprng"]]],[11,"new","","Create a `StepRng`, yielding an arithmetic sequence starting with `initial` and incremented by `increment` each time.",69,[[["u64"],["u64"]],["self"]]],[11,"next_u32","","",69,[[["self"]],["u32"]]],[11,"next_u64","","",69,[[["self"]],["u64"]]],[11,"fill_bytes","","",69,N],[11,"try_fill_bytes","","",69,N],[0,"small","rand::rngs","A small fast RNG",N,N],[3,"SmallRng","rand::rngs::small","An RNG recommended when small state, cheap initialization and good performance are required. The PRNG algorithm in `SmallRng` is chosen to be efficient on the current platform, without consideration for cryptography or security. The size of its state is much smaller than for [`StdRng`].",N,N],[12,"0","","",55,N],[11,"clone","rand::rngs","",55,[[["self"]],["smallrng"]]],[11,"fmt","","",55,[[["self"],["formatter"]],["result"]]],[11,"next_u32","","",55,[[["self"]],["u32"]]],[11,"next_u64","","",55,[[["self"]],["u64"]]],[11,"fill_bytes","","",55,N],[11,"try_fill_bytes","","",55,N],[11,"from_seed","","",55,N],[11,"from_rng","","",55,[[["r"]],["result",["error"]]]],[0,"std","","The standard RNG",N,N],[3,"StdRng","rand::rngs::std","The standard RNG. The PRNG algorithm in `StdRng` is chosen to be efficient on the current platform, to be statistically strong and unpredictable (meaning a cryptographically secure PRNG).",N,N],[12,"0","","",56,N],[11,"clone","rand::rngs","",56,[[["self"]],["stdrng"]]],[11,"fmt","","",56,[[["self"],["formatter"]],["result"]]],[11,"next_u32","","",56,[[["self"]],["u32"]]],[11,"next_u64","","",56,[[["self"]],["u64"]]],[11,"fill_bytes","","",56,N],[11,"try_fill_bytes","","",56,N],[11,"from_seed","","",56,N],[11,"from_rng","","",56,[[["r"]],["result",["error"]]]],[0,"thread","","Thread-local random number generator",N,N],[3,"ThreadRng","rand::rngs::thread","The type returned by [`thread_rng`], essentially just a reference to the PRNG in thread-local memory.",N,N],[12,"rng","","",57,N],[5,"thread_rng","","Retrieve the lazily-initialized thread-local random number generator, seeded by the system. Intended to be used in method chaining style, e.g. `thread_rng().gen::<i32>()`, or cached locally, e.g. `let mut rng = thread_rng();`.",N,[[],["threadrng"]]],[17,"THREAD_RNG_RESEED_THRESHOLD","","",N,N],[17,"THREAD_RNG_KEY","","",N,N],[11,"clone","rand::rngs","",57,[[["self"]],["threadrng"]]],[11,"fmt","","",57,[[["self"],["formatter"]],["result"]]],[11,"next_u32","","",57,[[["self"]],["u32"]]],[11,"next_u64","","",57,[[["self"]],["u64"]]],[11,"fill_bytes","","",57,N],[11,"try_fill_bytes","","",57,N],[0,"os","","Interface to the random number generator of the operating system.",N,N],[3,"OsRng","rand::rngs::os","A random number generator that retrieves randomness straight from the operating system.",N,N],[12,"0","","",58,N],[0,"random_device","","",N,N],[5,"open","rand::rngs::os::random_device","",N,[[["str"],["f"]],["result",["error"]]]],[5,"read","","",N,N],[5,"map_err","","",N,[[["error"]],["error"]]],[7,"READ_RNG_FILE","","",N,N],[7,"READ_RNG_ONCE","","",N,N],[0,"imp","rand::rngs::os","",N,N],[3,"OsRng","rand::rngs::os::imp","",N,N],[12,"method","","",70,N],[12,"initialized","","",70,N],[4,"OsRngMethod","","",N,N],[13,"GetRandom","","",71,N],[13,"RandomDevice","","",71,N],[5,"getrandom","","",N,N],[5,"getrandom_try_fill","","",N,N],[5,"is_getrandom_available","","",N,[[],["bool"]]],[17,"NR_GETRANDOM","","",N,N],[11,"clone","","",70,[[["self"]],["osrng"]]],[11,"fmt","","",70,[[["self"],["formatter"]],["result"]]],[11,"clone","","",71,[[["self"]],["osrngmethod"]]],[11,"fmt","","",71,[[["self"],["formatter"]],["result"]]],[11,"new","","",70,[[],["result",["osrng","error"]]]],[11,"fill_chunk","","",70,N],[11,"test_initialized","","",70,N],[11,"method_str","","",70,[[["self"]],["str"]]],[8,"OsRngImpl","rand::rngs::os","",N,N],[10,"new","","",72,[[],["result",["error"]]]],[10,"fill_chunk","","",72,N],[11,"test_initialized","","",72,N],[11,"max_chunk_size","","",72,[[["self"]],["usize"]]],[10,"method_str","","",72,[[["self"]],["str"]]],[11,"clone","rand::rngs","",58,[[["self"]],["osrng"]]],[11,"fmt","","",58,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `OsRng`.",58,[[],["result",["osrng","error"]]]],[11,"next_u32","","",58,[[["self"]],["u32"]]],[11,"next_u64","","",58,[[["self"]],["u64"]]],[11,"fill_bytes","","",58,N],[11,"try_fill_bytes","","",58,N],[0,"seq","rand","Functions for randomly accessing and sampling sequences.",N,N],[5,"sample_iter","rand::seq","Randomly sample `amount` elements from a finite iterator.",N,[[["r"],["i"],["usize"]],["result",["vec","vec"]]]],[5,"sample_slice","","Randomly sample exactly `amount` values from `slice`.",N,N],[5,"sample_slice_ref","","Randomly sample exactly `amount` references from `slice`.",N,N],[5,"sample_indices","","Randomly sample exactly `amount` indices from `0..length`.",N,[[["r"],["usize"],["usize"]],["vec",["usize"]]]],[5,"sample_indices_inplace","","Sample an amount of indices using an inplace partial fisher yates method.",N,[[["r"],["usize"],["usize"]],["vec",["usize"]]]],[5,"sample_indices_cache","","This method performs a partial fisher-yates on a range of indices using a `HashMap` as a cache to record potential collisions.",N,[[["r"],["usize"],["usize"]],["vec",["usize"]]]],[0,"jitter","rand","",N,N],[3,"JitterRng","rand::jitter","A true random number generator based on jitter in the CPU execution time, and jitter in memory access time.",N,N],[12,"data","","",53,N],[12,"rounds","","",53,N],[12,"timer","","",53,N],[12,"mem_prev_index","","",53,N],[12,"data_half_used","","",53,N],[4,"TimerError","","An error that can occur when [`JitterRng::test_timer`] fails.",N,N],[13,"NoTimer","","No timer available.",59,N],[13,"CoarseTimer","","Timer too coarse to use as an entropy source.",59,N],[13,"NotMonotonic","","Timer is not monotonically increasing.",59,N],[13,"TinyVariantions","","Variations of deltas of time too small.",59,N],[13,"TooManyStuck","","Too many stuck results (indicating no added entropy).",59,N],[13,"__Nonexhaustive","","",59,N],[0,"os","rand","",N,N],[3,"OsRng","rand::os","A random number generator that retrieves randomness straight from the operating system.",N,N],[12,"0","","",58,N],[0,"chacha","rand","The ChaCha random number generator.",N,N],[0,"isaac","","The ISAAC random number generator.",N,N],[8,"Rand","","A type that can be randomly generated using an [`Rng`].",N,N],[10,"rand","","Generates a random instance of this type using the specified source of randomness.",73,[[["r"]],["self"]]],[8,"Rng","","An automatically-implemented extension trait on [`RngCore`] providing high-level generic methods for sampling values and other convenience methods.",N,N],[11,"gen","","Return a random value supporting the [`Standard`] distribution.",74,[[["self"]],["t"]]],[11,"gen_range","","Generate a random value in the range [`low`, `high`), i.e. inclusive of `low` and exclusive of `high`.",74,[[["self"],["t"],["t"]],["t"]]],[11,"sample","","Sample a new value, using the given distribution.",74,[[["self"],["d"]],["t"]]],[11,"sample_iter","","Create an iterator that generates values using the given distribution.",74,[[["self"],["d"]],["distiter"]]],[11,"fill","","Fill `dest` entirely with random bytes (uniform value distribution), where `dest` is any type supporting [`AsByteSliceMut`], namely slices and arrays over primitive integer types (`i8`, `i16`, `u32`, etc.).",74,[[["self"],["t"]]]],[11,"try_fill","","Fill `dest` entirely with random bytes (uniform value distribution), where `dest` is any type supporting [`AsByteSliceMut`], namely slices and arrays over primitive integer types (`i8`, `i16`, `u32`, etc.).",74,[[["self"],["t"]],["result",["error"]]]],[11,"gen_bool","","Return a bool with a probability `p` of being true.",74,[[["self"],["f64"]],["bool"]]],[11,"choose","","Return a random element from `values`.",74,N],[11,"choose_mut","","Return a mutable pointer to a random element from `values`.",74,N],[11,"shuffle","","Shuffle a mutable slice in place.",74,N],[11,"gen_iter","","Return an iterator that will yield an infinite number of randomly generated items.",74,[[["self"]],["generator"]]],[11,"gen_weighted_bool","","Return a bool with a 1 in n chance of true",74,[[["self"],["u32"]],["bool"]]],[11,"gen_ascii_chars","","Return an iterator of random characters from the set A-Z,a-z,0-9.",74,[[["self"]],["asciigenerator"]]],[8,"AsByteSliceMut","","Trait for casting types to byte slices",N,N],[10,"as_byte_slice_mut","","Return a mutable reference to self as a byte slice",75,N],[10,"to_le","","Call `to_le` on each element (i.e. byte-swap on Big Endian platforms).",75,[[["self"]]]],[8,"FromEntropy","","A convenience extension to [`SeedableRng`] allowing construction from fresh entropy. This trait is automatically implemented for any PRNG implementing [`SeedableRng`] and is not intended to be implemented by users.",N,N],[10,"from_entropy","","Creates a new instance, automatically seeded with fresh entropy.",76,[[],["self"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"next","","",4,[[["self"]],["option"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"next","","",5,[[["self"]],["option",["char"]]]],[11,"assert_receiver_is_total_eq","","",2,N],[11,"eq","","",2,[[["self"],["errorkind"]],["bool"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result",["error"]]]],[11,"description","","",3,[[["self"]],["str"]]],[11,"cause","","",3,[[["self"]],["option",["error"]]]],[11,"read","","",0,N],[11,"fmt","","",3,[[["self"],["formatter"]],["result",["error"]]]],[11,"clone","","",2,[[["self"]],["errorkind"]]],[11,"should_retry","","True if this kind of error may resolve itself on retry.",2,[[["self"]],["bool"]]],[11,"should_wait","","True if we should retry but wait before retrying",2,[[["self"]],["bool"]]],[11,"description","","A description of this error kind",2,[[["self"]],["str"]]],[11,"to_owned","","",2,[[["self"]],["t"]]],[11,"clone_into","","",2,N],[11,"from","","",2,[[["t"]],["t"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"new","","Create a new instance, with specified kind and a message.",3,[[["errorkind"],["str"]],["error"]]],[11,"with_cause","","Create a new instance, with specified kind, message, and a chained cause.",3,[[["errorkind"],["str"],["e"]],["error"]]],[11,"take_cause","","Take the cause, if any. This allows the embedded cause to be extracted. This uses `Option::take`, leaving `self` with no cause.",3,[[["self"]],["option",["box"]]]],[11,"from","","",3,[[["t"]],["t"]]],[11,"to_string","","",3,[[["self"]],["string"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]],[11,"from","","",4,[[["t"]],["t"]]],[11,"into_iter","","",4,[[["self"]],["i"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"from","","",5,[[["t"]],["t"]]],[11,"into_iter","","",5,[[["self"]],["i"]]],[11,"into","","",5,[[["self"]],["u"]]],[11,"try_from","","",5,[[["u"]],["result"]]],[11,"borrow","","",5,[[["self"]],["t"]]],[11,"try_into","","",5,[[["self"]],["result"]]],[11,"borrow_mut","","",5,[[["self"]],["t"]]],[11,"get_type_id","","",5,[[["self"]],["typeid"]]],[11,"from","rand::distributions","",39,[[["t"]],["t"]]],[11,"into","","",39,[[["self"]],["u"]]],[11,"try_from","","",39,[[["u"]],["result"]]],[11,"borrow","","",39,[[["self"]],["t"]]],[11,"try_into","","",39,[[["self"]],["result"]]],[11,"borrow_mut","","",39,[[["self"]],["t"]]],[11,"get_type_id","","",39,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::uniform","",6,[[["self"]],["t"]]],[11,"clone_into","","",6,N],[11,"from","","",6,[[["t"]],["t"]]],[11,"into","","",6,[[["self"]],["u"]]],[11,"try_from","","",6,[[["u"]],["result"]]],[11,"borrow","","",6,[[["self"]],["t"]]],[11,"try_into","","",6,[[["self"]],["result"]]],[11,"borrow_mut","","",6,[[["self"]],["t"]]],[11,"get_type_id","","",6,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions","",36,[[["self"]],["t"]]],[11,"clone_into","","",36,N],[11,"from","","",36,[[["t"]],["t"]]],[11,"into","","",36,[[["self"]],["u"]]],[11,"try_from","","",36,[[["u"]],["result"]]],[11,"borrow","","",36,[[["self"]],["t"]]],[11,"try_into","","",36,[[["self"]],["result"]]],[11,"borrow_mut","","",36,[[["self"]],["t"]]],[11,"get_type_id","","",36,[[["self"]],["typeid"]]],[11,"to_owned","","",37,[[["self"]],["t"]]],[11,"clone_into","","",37,N],[11,"from","","",37,[[["t"]],["t"]]],[11,"into","","",37,[[["self"]],["u"]]],[11,"try_from","","",37,[[["u"]],["result"]]],[11,"borrow","","",37,[[["self"]],["t"]]],[11,"try_into","","",37,[[["self"]],["result"]]],[11,"borrow_mut","","",37,[[["self"]],["t"]]],[11,"get_type_id","","",37,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::gamma","",7,[[["self"]],["t"]]],[11,"clone_into","","",7,N],[11,"from","","",7,[[["t"]],["t"]]],[11,"into","","",7,[[["self"]],["u"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"try_into","","",7,[[["self"]],["result"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"get_type_id","","",7,[[["self"]],["typeid"]]],[11,"to_owned","","",8,[[["self"]],["t"]]],[11,"clone_into","","",8,N],[11,"from","","",8,[[["t"]],["t"]]],[11,"into","","",8,[[["self"]],["u"]]],[11,"try_from","","",8,[[["u"]],["result"]]],[11,"borrow","","",8,[[["self"]],["t"]]],[11,"try_into","","",8,[[["self"]],["result"]]],[11,"borrow_mut","","",8,[[["self"]],["t"]]],[11,"get_type_id","","",8,[[["self"]],["typeid"]]],[11,"to_owned","","",9,[[["self"]],["t"]]],[11,"clone_into","","",9,N],[11,"from","","",9,[[["t"]],["t"]]],[11,"into","","",9,[[["self"]],["u"]]],[11,"try_from","","",9,[[["u"]],["result"]]],[11,"borrow","","",9,[[["self"]],["t"]]],[11,"try_into","","",9,[[["self"]],["result"]]],[11,"borrow_mut","","",9,[[["self"]],["t"]]],[11,"get_type_id","","",9,[[["self"]],["typeid"]]],[11,"to_owned","","",10,[[["self"]],["t"]]],[11,"clone_into","","",10,N],[11,"from","","",10,[[["t"]],["t"]]],[11,"into","","",10,[[["self"]],["u"]]],[11,"try_from","","",10,[[["u"]],["result"]]],[11,"borrow","","",10,[[["self"]],["t"]]],[11,"try_into","","",10,[[["self"]],["result"]]],[11,"borrow_mut","","",10,[[["self"]],["t"]]],[11,"get_type_id","","",10,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::normal","",11,[[["self"]],["t"]]],[11,"clone_into","","",11,N],[11,"from","","",11,[[["t"]],["t"]]],[11,"into","","",11,[[["self"]],["u"]]],[11,"try_from","","",11,[[["u"]],["result"]]],[11,"borrow","","",11,[[["self"]],["t"]]],[11,"try_into","","",11,[[["self"]],["result"]]],[11,"borrow_mut","","",11,[[["self"]],["t"]]],[11,"get_type_id","","",11,[[["self"]],["typeid"]]],[11,"to_owned","","",12,[[["self"]],["t"]]],[11,"clone_into","","",12,N],[11,"from","","",12,[[["t"]],["t"]]],[11,"into","","",12,[[["self"]],["u"]]],[11,"try_from","","",12,[[["u"]],["result"]]],[11,"borrow","","",12,[[["self"]],["t"]]],[11,"try_into","","",12,[[["self"]],["result"]]],[11,"borrow_mut","","",12,[[["self"]],["t"]]],[11,"get_type_id","","",12,[[["self"]],["typeid"]]],[11,"to_owned","","",33,[[["self"]],["t"]]],[11,"clone_into","","",33,N],[11,"from","","",33,[[["t"]],["t"]]],[11,"into","","",33,[[["self"]],["u"]]],[11,"try_from","","",33,[[["u"]],["result"]]],[11,"borrow","","",33,[[["self"]],["t"]]],[11,"try_into","","",33,[[["self"]],["result"]]],[11,"borrow_mut","","",33,[[["self"]],["t"]]],[11,"get_type_id","","",33,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::exponential","",13,[[["self"]],["t"]]],[11,"clone_into","","",13,N],[11,"from","","",13,[[["t"]],["t"]]],[11,"into","","",13,[[["self"]],["u"]]],[11,"try_from","","",13,[[["u"]],["result"]]],[11,"borrow","","",13,[[["self"]],["t"]]],[11,"try_into","","",13,[[["self"]],["result"]]],[11,"borrow_mut","","",13,[[["self"]],["t"]]],[11,"get_type_id","","",13,[[["self"]],["typeid"]]],[11,"to_owned","","",34,[[["self"]],["t"]]],[11,"clone_into","","",34,N],[11,"from","","",34,[[["t"]],["t"]]],[11,"into","","",34,[[["self"]],["u"]]],[11,"try_from","","",34,[[["u"]],["result"]]],[11,"borrow","","",34,[[["self"]],["t"]]],[11,"try_into","","",34,[[["self"]],["result"]]],[11,"borrow_mut","","",34,[[["self"]],["t"]]],[11,"get_type_id","","",34,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::pareto","",14,[[["self"]],["t"]]],[11,"clone_into","","",14,N],[11,"from","","",14,[[["t"]],["t"]]],[11,"into","","",14,[[["self"]],["u"]]],[11,"try_from","","",14,[[["u"]],["result"]]],[11,"borrow","","",14,[[["self"]],["t"]]],[11,"try_into","","",14,[[["self"]],["result"]]],[11,"borrow_mut","","",14,[[["self"]],["t"]]],[11,"get_type_id","","",14,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::poisson","",15,[[["self"]],["t"]]],[11,"clone_into","","",15,N],[11,"from","","",15,[[["t"]],["t"]]],[11,"into","","",15,[[["self"]],["u"]]],[11,"try_from","","",15,[[["u"]],["result"]]],[11,"borrow","","",15,[[["self"]],["t"]]],[11,"try_into","","",15,[[["self"]],["result"]]],[11,"borrow_mut","","",15,[[["self"]],["t"]]],[11,"get_type_id","","",15,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::binomial","",16,[[["self"]],["t"]]],[11,"clone_into","","",16,N],[11,"from","","",16,[[["t"]],["t"]]],[11,"into","","",16,[[["self"]],["u"]]],[11,"try_from","","",16,[[["u"]],["result"]]],[11,"borrow","","",16,[[["self"]],["t"]]],[11,"try_into","","",16,[[["self"]],["result"]]],[11,"borrow_mut","","",16,[[["self"]],["t"]]],[11,"get_type_id","","",16,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::bernoulli","",17,[[["self"]],["t"]]],[11,"clone_into","","",17,N],[11,"from","","",17,[[["t"]],["t"]]],[11,"into","","",17,[[["self"]],["u"]]],[11,"try_from","","",17,[[["u"]],["result"]]],[11,"borrow","","",17,[[["self"]],["t"]]],[11,"try_into","","",17,[[["self"]],["result"]]],[11,"borrow_mut","","",17,[[["self"]],["t"]]],[11,"get_type_id","","",17,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::cauchy","",18,[[["self"]],["t"]]],[11,"clone_into","","",18,N],[11,"from","","",18,[[["t"]],["t"]]],[11,"into","","",18,[[["self"]],["u"]]],[11,"try_from","","",18,[[["u"]],["result"]]],[11,"borrow","","",18,[[["self"]],["t"]]],[11,"try_into","","",18,[[["self"]],["result"]]],[11,"borrow_mut","","",18,[[["self"]],["t"]]],[11,"get_type_id","","",18,[[["self"]],["typeid"]]],[11,"from","rand::distributions","",19,[[["t"]],["t"]]],[11,"into_iter","","",19,[[["self"]],["i"]]],[11,"into","","",19,[[["self"]],["u"]]],[11,"try_from","","",19,[[["u"]],["result"]]],[11,"borrow","","",19,[[["self"]],["t"]]],[11,"try_into","","",19,[[["self"]],["result"]]],[11,"borrow_mut","","",19,[[["self"]],["t"]]],[11,"get_type_id","","",19,[[["self"]],["typeid"]]],[11,"to_owned","","",38,[[["self"]],["t"]]],[11,"clone_into","","",38,N],[11,"from","","",38,[[["t"]],["t"]]],[11,"into","","",38,[[["self"]],["u"]]],[11,"try_from","","",38,[[["u"]],["result"]]],[11,"borrow","","",38,[[["self"]],["t"]]],[11,"try_into","","",38,[[["self"]],["result"]]],[11,"borrow_mut","","",38,[[["self"]],["t"]]],[11,"get_type_id","","",38,[[["self"]],["typeid"]]],[11,"to_owned","","",20,[[["self"]],["t"]]],[11,"clone_into","","",20,N],[11,"from","","",20,[[["t"]],["t"]]],[11,"into","","",20,[[["self"]],["u"]]],[11,"try_from","","",20,[[["u"]],["result"]]],[11,"borrow","","",20,[[["self"]],["t"]]],[11,"try_into","","",20,[[["self"]],["result"]]],[11,"borrow_mut","","",20,[[["self"]],["t"]]],[11,"get_type_id","","",20,[[["self"]],["typeid"]]],[11,"from","","",21,[[["t"]],["t"]]],[11,"into","","",21,[[["self"]],["u"]]],[11,"try_from","","",21,[[["u"]],["result"]]],[11,"borrow","","",21,[[["self"]],["t"]]],[11,"try_into","","",21,[[["self"]],["result"]]],[11,"borrow_mut","","",21,[[["self"]],["t"]]],[11,"get_type_id","","",21,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::uniform","",22,[[["self"]],["t"]]],[11,"clone_into","","",22,N],[11,"from","","",22,[[["t"]],["t"]]],[11,"into","","",22,[[["self"]],["u"]]],[11,"try_from","","",22,[[["u"]],["result"]]],[11,"borrow","","",22,[[["self"]],["t"]]],[11,"try_into","","",22,[[["self"]],["result"]]],[11,"borrow_mut","","",22,[[["self"]],["t"]]],[11,"get_type_id","","",22,[[["self"]],["typeid"]]],[11,"to_owned","","",23,[[["self"]],["t"]]],[11,"clone_into","","",23,N],[11,"from","","",23,[[["t"]],["t"]]],[11,"into","","",23,[[["self"]],["u"]]],[11,"try_from","","",23,[[["u"]],["result"]]],[11,"borrow","","",23,[[["self"]],["t"]]],[11,"try_into","","",23,[[["self"]],["result"]]],[11,"borrow_mut","","",23,[[["self"]],["t"]]],[11,"get_type_id","","",23,[[["self"]],["typeid"]]],[11,"to_owned","","",24,[[["self"]],["t"]]],[11,"clone_into","","",24,N],[11,"from","","",24,[[["t"]],["t"]]],[11,"into","","",24,[[["self"]],["u"]]],[11,"try_from","","",24,[[["u"]],["result"]]],[11,"borrow","","",24,[[["self"]],["t"]]],[11,"try_into","","",24,[[["self"]],["result"]]],[11,"borrow_mut","","",24,[[["self"]],["t"]]],[11,"get_type_id","","",24,[[["self"]],["typeid"]]],[11,"to_owned","","",25,[[["self"]],["t"]]],[11,"clone_into","","",25,N],[11,"from","","",25,[[["t"]],["t"]]],[11,"into","","",25,[[["self"]],["u"]]],[11,"try_from","","",25,[[["u"]],["result"]]],[11,"borrow","","",25,[[["self"]],["t"]]],[11,"try_into","","",25,[[["self"]],["result"]]],[11,"borrow_mut","","",25,[[["self"]],["t"]]],[11,"get_type_id","","",25,[[["self"]],["typeid"]]],[11,"to_owned","rand::distributions::gamma","",29,[[["self"]],["t"]]],[11,"clone_into","","",29,N],[11,"from","","",29,[[["t"]],["t"]]],[11,"into","","",29,[[["self"]],["u"]]],[11,"try_from","","",29,[[["u"]],["result"]]],[11,"borrow","","",29,[[["self"]],["t"]]],[11,"try_into","","",29,[[["self"]],["result"]]],[11,"borrow_mut","","",29,[[["self"]],["t"]]],[11,"get_type_id","","",29,[[["self"]],["typeid"]]],[11,"to_owned","","",30,[[["self"]],["t"]]],[11,"clone_into","","",30,N],[11,"from","","",30,[[["t"]],["t"]]],[11,"into","","",30,[[["self"]],["u"]]],[11,"try_from","","",30,[[["u"]],["result"]]],[11,"borrow","","",30,[[["self"]],["t"]]],[11,"try_into","","",30,[[["self"]],["result"]]],[11,"borrow_mut","","",30,[[["self"]],["t"]]],[11,"get_type_id","","",30,[[["self"]],["typeid"]]],[11,"to_owned","","",31,[[["self"]],["t"]]],[11,"clone_into","","",31,N],[11,"from","","",31,[[["t"]],["t"]]],[11,"into","","",31,[[["self"]],["u"]]],[11,"try_from","","",31,[[["u"]],["result"]]],[11,"borrow","","",31,[[["self"]],["t"]]],[11,"try_into","","",31,[[["self"]],["result"]]],[11,"borrow_mut","","",31,[[["self"]],["t"]]],[11,"get_type_id","","",31,[[["self"]],["typeid"]]],[11,"to_owned","","",32,[[["self"]],["t"]]],[11,"clone_into","","",32,N],[11,"from","","",32,[[["t"]],["t"]]],[11,"into","","",32,[[["self"]],["u"]]],[11,"try_from","","",32,[[["u"]],["result"]]],[11,"borrow","","",32,[[["self"]],["t"]]],[11,"try_into","","",32,[[["self"]],["result"]]],[11,"borrow_mut","","",32,[[["self"]],["t"]]],[11,"get_type_id","","",32,[[["self"]],["typeid"]]],[11,"from_entropy","rand::prng","",43,[[],["r"]]],[11,"to_owned","","",43,[[["self"]],["t"]]],[11,"clone_into","","",43,N],[11,"from","","",43,[[["t"]],["t"]]],[11,"into","","",43,[[["self"]],["u"]]],[11,"try_from","","",43,[[["u"]],["result"]]],[11,"borrow","","",43,[[["self"]],["t"]]],[11,"try_into","","",43,[[["self"]],["result"]]],[11,"borrow_mut","","",43,[[["self"]],["t"]]],[11,"get_type_id","","",43,[[["self"]],["typeid"]]],[11,"from_entropy","rand::prng::chacha","",44,[[],["r"]]],[11,"to_owned","","",44,[[["self"]],["t"]]],[11,"clone_into","","",44,N],[11,"from","","",44,[[["t"]],["t"]]],[11,"into","","",44,[[["self"]],["u"]]],[11,"try_from","","",44,[[["u"]],["result"]]],[11,"borrow","","",44,[[["self"]],["t"]]],[11,"try_into","","",44,[[["self"]],["result"]]],[11,"borrow_mut","","",44,[[["self"]],["t"]]],[11,"get_type_id","","",44,[[["self"]],["typeid"]]],[11,"from_entropy","","",45,[[],["r"]]],[11,"to_owned","","",45,[[["self"]],["t"]]],[11,"clone_into","","",45,N],[11,"from","","",45,[[["t"]],["t"]]],[11,"into","","",45,[[["self"]],["u"]]],[11,"try_from","","",45,[[["u"]],["result"]]],[11,"borrow","","",45,[[["self"]],["t"]]],[11,"try_into","","",45,[[["self"]],["result"]]],[11,"borrow_mut","","",45,[[["self"]],["t"]]],[11,"get_type_id","","",45,[[["self"]],["typeid"]]],[11,"from_entropy","rand::prng::hc128","",46,[[],["r"]]],[11,"to_owned","","",46,[[["self"]],["t"]]],[11,"clone_into","","",46,N],[11,"from","","",46,[[["t"]],["t"]]],[11,"into","","",46,[[["self"]],["u"]]],[11,"try_from","","",46,[[["u"]],["result"]]],[11,"borrow","","",46,[[["self"]],["t"]]],[11,"try_into","","",46,[[["self"]],["result"]]],[11,"borrow_mut","","",46,[[["self"]],["t"]]],[11,"get_type_id","","",46,[[["self"]],["typeid"]]],[11,"from_entropy","","",47,[[],["r"]]],[11,"to_owned","","",47,[[["self"]],["t"]]],[11,"clone_into","","",47,N],[11,"from","","",47,[[["t"]],["t"]]],[11,"into","","",47,[[["self"]],["u"]]],[11,"try_from","","",47,[[["u"]],["result"]]],[11,"borrow","","",47,[[["self"]],["t"]]],[11,"try_into","","",47,[[["self"]],["result"]]],[11,"borrow_mut","","",47,[[["self"]],["t"]]],[11,"get_type_id","","",47,[[["self"]],["typeid"]]],[11,"from_entropy","rand::prng::isaac","",48,[[],["r"]]],[11,"to_owned","","",48,[[["self"]],["t"]]],[11,"clone_into","","",48,N],[11,"from","","",48,[[["t"]],["t"]]],[11,"into","","",48,[[["self"]],["u"]]],[11,"try_from","","",48,[[["u"]],["result"]]],[11,"borrow","","",48,[[["self"]],["t"]]],[11,"try_into","","",48,[[["self"]],["result"]]],[11,"borrow_mut","","",48,[[["self"]],["t"]]],[11,"get_type_id","","",48,[[["self"]],["typeid"]]],[11,"from_entropy","","",49,[[],["r"]]],[11,"to_owned","","",49,[[["self"]],["t"]]],[11,"clone_into","","",49,N],[11,"from","","",49,[[["t"]],["t"]]],[11,"into","","",49,[[["self"]],["u"]]],[11,"try_from","","",49,[[["u"]],["result"]]],[11,"borrow","","",49,[[["self"]],["t"]]],[11,"try_into","","",49,[[["self"]],["result"]]],[11,"borrow_mut","","",49,[[["self"]],["t"]]],[11,"get_type_id","","",49,[[["self"]],["typeid"]]],[11,"from_entropy","rand::prng::isaac64","",50,[[],["r"]]],[11,"to_owned","","",50,[[["self"]],["t"]]],[11,"clone_into","","",50,N],[11,"from","","",50,[[["t"]],["t"]]],[11,"into","","",50,[[["self"]],["u"]]],[11,"try_from","","",50,[[["u"]],["result"]]],[11,"borrow","","",50,[[["self"]],["t"]]],[11,"try_into","","",50,[[["self"]],["result"]]],[11,"borrow_mut","","",50,[[["self"]],["t"]]],[11,"get_type_id","","",50,[[["self"]],["typeid"]]],[11,"from_entropy","","",51,[[],["r"]]],[11,"to_owned","","",51,[[["self"]],["t"]]],[11,"clone_into","","",51,N],[11,"from","","",51,[[["t"]],["t"]]],[11,"into","","",51,[[["self"]],["u"]]],[11,"try_from","","",51,[[["u"]],["result"]]],[11,"borrow","","",51,[[["self"]],["t"]]],[11,"try_into","","",51,[[["self"]],["result"]]],[11,"borrow_mut","","",51,[[["self"]],["t"]]],[11,"get_type_id","","",51,[[["self"]],["typeid"]]],[11,"to_owned","rand::prng::isaac_array","",52,[[["self"]],["t"]]],[11,"clone_into","","",52,N],[11,"from","","",52,[[["t"]],["t"]]],[11,"into","","",52,[[["self"]],["u"]]],[11,"try_from","","",52,[[["u"]],["result"]]],[11,"borrow","","",52,[[["self"]],["t"]]],[11,"try_into","","",52,[[["self"]],["result"]]],[11,"borrow_mut","","",52,[[["self"]],["t"]]],[11,"get_type_id","","",52,[[["self"]],["typeid"]]],[11,"to_owned","rand::jitter","",53,[[["self"]],["t"]]],[11,"clone_into","","",53,N],[11,"from","","",53,[[["t"]],["t"]]],[11,"into","","",53,[[["self"]],["u"]]],[11,"try_from","","",53,[[["u"]],["result"]]],[11,"borrow","","",53,[[["self"]],["t"]]],[11,"try_into","","",53,[[["self"]],["result"]]],[11,"borrow_mut","","",53,[[["self"]],["t"]]],[11,"get_type_id","","",53,[[["self"]],["typeid"]]],[11,"from","rand::rngs","",54,[[["t"]],["t"]]],[11,"into","","",54,[[["self"]],["u"]]],[11,"try_from","","",54,[[["u"]],["result"]]],[11,"borrow","","",54,[[["self"]],["t"]]],[11,"try_into","","",54,[[["self"]],["result"]]],[11,"borrow_mut","","",54,[[["self"]],["t"]]],[11,"get_type_id","","",54,[[["self"]],["typeid"]]],[11,"from_entropy","","",55,[[],["r"]]],[11,"to_owned","","",55,[[["self"]],["t"]]],[11,"clone_into","","",55,N],[11,"from","","",55,[[["t"]],["t"]]],[11,"into","","",55,[[["self"]],["u"]]],[11,"try_from","","",55,[[["u"]],["result"]]],[11,"borrow","","",55,[[["self"]],["t"]]],[11,"try_into","","",55,[[["self"]],["result"]]],[11,"borrow_mut","","",55,[[["self"]],["t"]]],[11,"get_type_id","","",55,[[["self"]],["typeid"]]],[11,"from_entropy","","",56,[[],["r"]]],[11,"to_owned","","",56,[[["self"]],["t"]]],[11,"clone_into","","",56,N],[11,"from","","",56,[[["t"]],["t"]]],[11,"into","","",56,[[["self"]],["u"]]],[11,"try_from","","",56,[[["u"]],["result"]]],[11,"borrow","","",56,[[["self"]],["t"]]],[11,"try_into","","",56,[[["self"]],["result"]]],[11,"borrow_mut","","",56,[[["self"]],["t"]]],[11,"get_type_id","","",56,[[["self"]],["typeid"]]],[11,"to_owned","","",57,[[["self"]],["t"]]],[11,"clone_into","","",57,N],[11,"from","","",57,[[["t"]],["t"]]],[11,"into","","",57,[[["self"]],["u"]]],[11,"try_from","","",57,[[["u"]],["result"]]],[11,"borrow","","",57,[[["self"]],["t"]]],[11,"try_into","","",57,[[["self"]],["result"]]],[11,"borrow_mut","","",57,[[["self"]],["t"]]],[11,"get_type_id","","",57,[[["self"]],["typeid"]]],[11,"to_owned","","",58,[[["self"]],["t"]]],[11,"clone_into","","",58,N],[11,"from","","",58,[[["t"]],["t"]]],[11,"into","","",58,[[["self"]],["u"]]],[11,"try_from","","",58,[[["u"]],["result"]]],[11,"borrow","","",58,[[["self"]],["t"]]],[11,"try_into","","",58,[[["self"]],["result"]]],[11,"borrow_mut","","",58,[[["self"]],["t"]]],[11,"get_type_id","","",58,[[["self"]],["typeid"]]],[11,"to_owned","rand::jitter","",59,[[["self"]],["t"]]],[11,"clone_into","","",59,N],[11,"from","","",59,[[["t"]],["t"]]],[11,"to_string","","",59,[[["self"]],["string"]]],[11,"into","","",59,[[["self"]],["u"]]],[11,"try_from","","",59,[[["u"]],["result"]]],[11,"borrow","","",59,[[["self"]],["t"]]],[11,"try_into","","",59,[[["self"]],["result"]]],[11,"borrow_mut","","",59,[[["self"]],["t"]]],[11,"get_type_id","","",59,[[["self"]],["typeid"]]],[11,"from","rand::rngs::adapter::read","",60,[[["t"]],["t"]]],[11,"into","","",60,[[["self"]],["u"]]],[11,"try_from","","",60,[[["u"]],["result"]]],[11,"borrow","","",60,[[["self"]],["t"]]],[11,"try_into","","",60,[[["self"]],["result"]]],[11,"borrow_mut","","",60,[[["self"]],["t"]]],[11,"get_type_id","","",60,[[["self"]],["typeid"]]],[11,"to_owned","rand::rngs::adapter","",61,[[["self"]],["t"]]],[11,"clone_into","","",61,N],[11,"from","","",61,[[["t"]],["t"]]],[11,"into","","",61,[[["self"]],["u"]]],[11,"try_from","","",61,[[["u"]],["result"]]],[11,"borrow","","",61,[[["self"]],["t"]]],[11,"try_into","","",61,[[["self"]],["result"]]],[11,"borrow_mut","","",61,[[["self"]],["t"]]],[11,"get_type_id","","",61,[[["self"]],["typeid"]]],[11,"to_owned","rand::rngs::adapter::reseeding","",62,[[["self"]],["t"]]],[11,"clone_into","","",62,N],[11,"from","","",62,[[["t"]],["t"]]],[11,"into","","",62,[[["self"]],["u"]]],[11,"try_from","","",62,[[["u"]],["result"]]],[11,"borrow","","",62,[[["self"]],["t"]]],[11,"try_into","","",62,[[["self"]],["result"]]],[11,"borrow_mut","","",62,[[["self"]],["t"]]],[11,"get_type_id","","",62,[[["self"]],["typeid"]]],[11,"to_owned","rand::rngs::entropy","",67,[[["self"]],["t"]]],[11,"clone_into","","",67,N],[11,"from","","",67,[[["t"]],["t"]]],[11,"into","","",67,[[["self"]],["u"]]],[11,"try_from","","",67,[[["u"]],["result"]]],[11,"borrow","","",67,[[["self"]],["t"]]],[11,"try_into","","",67,[[["self"]],["result"]]],[11,"borrow_mut","","",67,[[["self"]],["t"]]],[11,"get_type_id","","",67,[[["self"]],["typeid"]]],[11,"to_owned","","",63,[[["self"]],["t"]]],[11,"clone_into","","",63,N],[11,"from","","",63,[[["t"]],["t"]]],[11,"into","","",63,[[["self"]],["u"]]],[11,"try_from","","",63,[[["u"]],["result"]]],[11,"borrow","","",63,[[["self"]],["t"]]],[11,"try_into","","",63,[[["self"]],["result"]]],[11,"borrow_mut","","",63,[[["self"]],["t"]]],[11,"get_type_id","","",63,[[["self"]],["typeid"]]],[11,"to_owned","","",64,[[["self"]],["t"]]],[11,"clone_into","","",64,N],[11,"from","","",64,[[["t"]],["t"]]],[11,"into","","",64,[[["self"]],["u"]]],[11,"try_from","","",64,[[["u"]],["result"]]],[11,"borrow","","",64,[[["self"]],["t"]]],[11,"try_into","","",64,[[["self"]],["result"]]],[11,"borrow_mut","","",64,[[["self"]],["t"]]],[11,"get_type_id","","",64,[[["self"]],["typeid"]]],[11,"from","","",65,[[["t"]],["t"]]],[11,"into","","",65,[[["self"]],["u"]]],[11,"try_from","","",65,[[["u"]],["result"]]],[11,"borrow","","",65,[[["self"]],["t"]]],[11,"try_into","","",65,[[["self"]],["result"]]],[11,"borrow_mut","","",65,[[["self"]],["t"]]],[11,"get_type_id","","",65,[[["self"]],["typeid"]]],[11,"from","rand::rngs::jitter","",68,[[["t"]],["t"]]],[11,"into","","",68,[[["self"]],["u"]]],[11,"try_from","","",68,[[["u"]],["result"]]],[11,"borrow","","",68,[[["self"]],["t"]]],[11,"try_into","","",68,[[["self"]],["result"]]],[11,"borrow_mut","","",68,[[["self"]],["t"]]],[11,"get_type_id","","",68,[[["self"]],["typeid"]]],[11,"to_owned","rand::rngs::mock","",69,[[["self"]],["t"]]],[11,"clone_into","","",69,N],[11,"from","","",69,[[["t"]],["t"]]],[11,"into","","",69,[[["self"]],["u"]]],[11,"try_from","","",69,[[["u"]],["result"]]],[11,"borrow","","",69,[[["self"]],["t"]]],[11,"try_into","","",69,[[["self"]],["result"]]],[11,"borrow_mut","","",69,[[["self"]],["t"]]],[11,"get_type_id","","",69,[[["self"]],["typeid"]]],[11,"to_owned","rand::rngs::os::imp","",70,[[["self"]],["t"]]],[11,"clone_into","","",70,N],[11,"from","","",70,[[["t"]],["t"]]],[11,"into","","",70,[[["self"]],["u"]]],[11,"try_from","","",70,[[["u"]],["result"]]],[11,"borrow","","",70,[[["self"]],["t"]]],[11,"try_into","","",70,[[["self"]],["result"]]],[11,"borrow_mut","","",70,[[["self"]],["t"]]],[11,"get_type_id","","",70,[[["self"]],["typeid"]]],[11,"to_owned","","",71,[[["self"]],["t"]]],[11,"clone_into","","",71,N],[11,"from","","",71,[[["t"]],["t"]]],[11,"into","","",71,[[["self"]],["u"]]],[11,"try_from","","",71,[[["u"]],["result"]]],[11,"borrow","","",71,[[["self"]],["t"]]],[11,"try_into","","",71,[[["self"]],["result"]]],[11,"borrow_mut","","",71,[[["self"]],["t"]]],[11,"get_type_id","","",71,[[["self"]],["typeid"]]]],"paths":[[8,"RngCore"],[8,"SeedableRng"],[4,"ErrorKind"],[3,"Error"],[3,"Generator"],[3,"AsciiGenerator"],[3,"Uniform"],[3,"Gamma"],[3,"ChiSquared"],[3,"FisherF"],[3,"StudentT"],[3,"Normal"],[3,"LogNormal"],[3,"Exp"],[3,"Pareto"],[3,"Poisson"],[3,"Binomial"],[3,"Bernoulli"],[3,"Cauchy"],[3,"DistIter"],[3,"Weighted"],[3,"WeightedChoice"],[3,"UniformInt"],[3,"UniformFloat"],[3,"UniformDuration"],[4,"UniformDurationMode"],[8,"SampleUniform"],[8,"UniformSampler"],[8,"WideningMultiply"],[3,"GammaSmallShape"],[3,"GammaLargeShape"],[4,"GammaRepr"],[4,"ChiSquaredRepr"],[3,"StandardNormal"],[3,"Exp1"],[8,"IntoFloat"],[3,"OpenClosed01"],[3,"Open01"],[3,"Standard"],[3,"Alphanumeric"],[8,"Sample"],[8,"IndependentSample"],[8,"Distribution"],[3,"XorShiftRng"],[3,"ChaChaRng"],[3,"ChaChaCore"],[3,"Hc128Rng"],[3,"Hc128Core"],[3,"IsaacRng"],[3,"IsaacCore"],[3,"Isaac64Rng"],[3,"Isaac64Core"],[3,"IsaacArray"],[3,"JitterRng"],[3,"EntropyRng"],[3,"SmallRng"],[3,"StdRng"],[3,"ThreadRng"],[3,"OsRng"],[4,"TimerError"],[3,"ReadRng"],[3,"ReseedingRng"],[3,"ReseedingCore"],[3,"Os"],[3,"Jitter"],[4,"Source"],[8,"EntropySource"],[3,"NoSource"],[3,"EcState"],[3,"StepRng"],[3,"OsRng"],[4,"OsRngMethod"],[8,"OsRngImpl"],[8,"Rand"],[8,"Rng"],[8,"AsByteSliceMut"],[8,"FromEntropy"]]};
searchIndex["rand_core"]={"doc":"Random number generation traits","items":[[3,"Error","rand_core","Error type of random number generators",N,N],[12,"kind","","The error kind",0,N],[12,"msg","","The error message",0,N],[12,"cause","","",0,N],[4,"ErrorKind","","Error kind which can be matched over.",N,N],[13,"Unavailable","","Feature is not available; not recoverable.",1,N],[13,"Unexpected","","General failure; there may be a chance of recovery on retry.",1,N],[13,"Transient","","A transient failure which likely can be resolved or worked around.",1,N],[13,"NotReady","","Not ready yet: recommended to try again a little later.",1,N],[13,"__Nonexhaustive","","",1,N],[0,"error","","Error types",N,N],[3,"Error","rand_core::error","Error type of random number generators",N,N],[12,"kind","","The error kind",0,N],[12,"msg","","The error message",0,N],[12,"cause","","",0,N],[4,"ErrorKind","","Error kind which can be matched over.",N,N],[13,"Unavailable","","Feature is not available; not recoverable.",1,N],[13,"Unexpected","","General failure; there may be a chance of recovery on retry.",1,N],[13,"Transient","","A transient failure which likely can be resolved or worked around.",1,N],[13,"NotReady","","Not ready yet: recommended to try again a little later.",1,N],[13,"__Nonexhaustive","","",1,N],[11,"eq","rand_core","",1,[[["self"],["errorkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",1,N],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"clone","","",1,[[["self"]],["errorkind"]]],[11,"should_retry","","True if this kind of error may resolve itself on retry.",1,[[["self"]],["bool"]]],[11,"should_wait","","True if we should retry but wait before retrying",1,[[["self"]],["bool"]]],[11,"description","","A description of this error kind",1,[[["self"]],["str"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new instance, with specified kind and a message.",0,[[["errorkind"],["str"]],["self"]]],[11,"with_cause","","Create a new instance, with specified kind, message, and a chained cause.",0,[[["errorkind"],["str"],["e"]],["self"]]],[11,"take_cause","","Take the cause, if any. This allows the embedded cause to be extracted. This uses `Option::take`, leaving `self` with no cause.",0,[[["self"]],["option",["box"]]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"description","","",0,[[["self"]],["str"]]],[11,"cause","","",0,[[["self"]],["option",["stderror"]]]],[0,"block","","The `BlockRngCore` trait and implementation helpers",N,N],[3,"BlockRng","rand_core::block","A wrapper type implementing [`RngCore`] for some type implementing [`BlockRngCore`] with `u32` array buffer; i.e. this can be used to implement a full RNG from just a `generate` function.",N,N],[12,"results","","",2,N],[12,"index","","",2,N],[12,"core","","The core part of the RNG, implementing the `generate` function.",2,N],[3,"BlockRng64","","A wrapper type implementing [`RngCore`] for some type implementing [`BlockRngCore`] with `u64` array buffer; i.e. this can be used to implement a full RNG from just a `generate` function.",N,N],[12,"results","","",3,N],[12,"index","","",3,N],[12,"half_used","","",3,N],[12,"core","","The core part of the RNG, implementing the `generate` function.",3,N],[8,"BlockRngCore","","A trait for RNGs which do not generate random numbers individually, but in blocks (typically `[u32; N]`). This technique is commonly used by cryptographic RNGs to improve performance.",N,N],[16,"Item","","Results element type, e.g. `u32`.",4,N],[16,"Results","","Results type. This is the 'block' an RNG implementing `BlockRngCore` generates, which will usually be an array like `[u32; 16]`.",4,N],[10,"generate","","Generate a new block of results.",4,N],[11,"clone","","",2,[[["self"]],["blockrng"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `BlockRng` from an existing RNG implementing `BlockRngCore`. Results will be generated on first use.",2,[[["r"]],["blockrng"]]],[11,"index","","Get the index into the result buffer.",2,[[["self"]],["usize"]]],[11,"reset","","Reset the number of available results. This will force a new set of results to be generated on next use.",2,[[["self"]]]],[11,"generate_and_set","","Generate a new set of results immediately, setting the index to the given value.",2,[[["self"],["usize"]]]],[11,"next_u32","","",2,[[["self"]],["u32"]]],[11,"next_u64","","",2,[[["self"]],["u64"]]],[11,"fill_bytes","","",2,N],[11,"try_fill_bytes","","",2,N],[11,"from_seed","","",2,N],[11,"from_rng","","",2,[[["s"]],["result",["error"]]]],[11,"clone","","",3,[[["self"]],["blockrng64"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new `BlockRng` from an existing RNG implementing `BlockRngCore`. Results will be generated on first use.",3,[[["r"]],["blockrng64"]]],[11,"index","","Get the index into the result buffer.",3,[[["self"]],["usize"]]],[11,"reset","","Reset the number of available results. This will force a new set of results to be generated on next use.",3,[[["self"]]]],[11,"generate_and_set","","Generate a new set of results immediately, setting the index to the given value.",3,[[["self"],["usize"]]]],[11,"next_u32","","",3,[[["self"]],["u32"]]],[11,"next_u64","","",3,[[["self"]],["u64"]]],[11,"fill_bytes","","",3,N],[11,"try_fill_bytes","","",3,N],[11,"from_seed","","",3,N],[11,"from_rng","","",3,[[["s"]],["result",["error"]]]],[0,"impls","rand_core","Helper functions for implementing `RngCore` functions.",N,N],[5,"next_u64_via_u32","rand_core::impls","Implement `next_u64` via `next_u32`, little-endian order.",N,[[["r"]],["u64"]]],[5,"fill_bytes_via_next","","Implement `fill_bytes` via `next_u64` and `next_u32`, little-endian order.",N,N],[5,"fill_via_u32_chunks","","Implement `fill_bytes` by reading chunks from the output buffer of a block based RNG.",N,N],[5,"fill_via_u64_chunks","","Implement `fill_bytes` by reading chunks from the output buffer of a block based RNG.",N,N],[5,"next_u32_via_fill","","Implement `next_u32` via `fill_bytes`, little-endian order.",N,[[["r"]],["u32"]]],[5,"next_u64_via_fill","","Implement `next_u64` via `fill_bytes`, little-endian order.",N,[[["r"]],["u64"]]],[0,"le","rand_core","Little-Endian utilities",N,N],[5,"read_u32_into","rand_core::le","Reads unsigned 32 bit integers from `src` into `dst`. Borrowed from the `byteorder` crate.",N,N],[5,"read_u64_into","","Reads unsigned 64 bit integers from `src` into `dst`. Borrowed from the `byteorder` crate.",N,N],[8,"RngCore","rand_core","The core of a random number generator.",N,N],[10,"next_u32","","Return the next random `u32`.",5,[[["self"]],["u32"]]],[10,"next_u64","","Return the next random `u64`.",5,[[["self"]],["u64"]]],[10,"fill_bytes","","Fill `dest` with random data.",5,N],[10,"try_fill_bytes","","Fill `dest` entirely with random data.",5,N],[8,"CryptoRng","","A marker trait used to indicate that an [`RngCore`] or [`BlockRngCore`] implementation is supposed to be cryptographically secure.",N,N],[8,"SeedableRng","","A random number generator that can be explicitly seeded.",N,N],[16,"Seed","","Seed type, which is restricted to types mutably-dereferencable as `u8` arrays (we recommend `[u8; N]` for some `N`).",6,N],[10,"from_seed","","Create a new PRNG using the given seed.",6,N],[11,"from_rng","","Create a new PRNG seeded from another `Rng`.",6,[[["r"]],["result",["error"]]]],[11,"read","","",5,N],[11,"from","","",0,[[["t"]],["t"]]],[11,"to_string","","",0,[[["self"]],["string"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"to_owned","","",1,[[["self"]],["t"]]],[11,"clone_into","","",1,N],[11,"from","","",1,[[["t"]],["t"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"to_owned","rand_core::block","",2,[[["self"]],["t"]]],[11,"clone_into","","",2,N],[11,"from","","",2,[[["t"]],["t"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"to_owned","","",3,[[["self"]],["t"]]],[11,"clone_into","","",3,N],[11,"from","","",3,[[["t"]],["t"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]]],"paths":[[3,"Error"],[4,"ErrorKind"],[3,"BlockRng"],[3,"BlockRng64"],[8,"BlockRngCore"],[8,"RngCore"],[8,"SeedableRng"]]};
searchIndex["remove_dir_all"]={"doc":"","items":[[5,"remove_dir_all","remove_dir_all","Removes a directory at this path, after removing all its contents. Use carefully!",N,[[["p"]],["result",["error"]]]]],"paths":[]};
searchIndex["rustc"]={"doc":"The \"main crate\" of the Rust compiler. This crate contains common type definitions that are used by the other crates in the rustc \"family\". Some prominent examples (note that each of these modules has their own README with further details).","items":[[0,"macros","rustc","",N,N],[0,"diagnostics","","",N,N],[0,"__register_diagnostic_E0038","rustc::diagnostics","",N,N],[0,"__register_diagnostic_E0072","","",N,N],[0,"__register_diagnostic_E0080","","",N,N],[0,"__register_diagnostic_E0106","","",N,N],[0,"__register_diagnostic_E0119","","",N,N],[0,"__register_diagnostic_E0136","","",N,N],[0,"__register_diagnostic_E0137","","",N,N],[0,"__register_diagnostic_E0138","","",N,N],[0,"__register_diagnostic_E0139","","",N,N],[0,"__register_diagnostic_E0152","","",N,N],[0,"__register_diagnostic_E0214","","",N,N],[0,"__register_diagnostic_E0230","","",N,N],[0,"__register_diagnostic_E0231","","",N,N],[0,"__register_diagnostic_E0232","","",N,N],[0,"__register_diagnostic_E0261","","",N,N],[0,"__register_diagnostic_E0262","","",N,N],[0,"__register_diagnostic_E0263","","",N,N],[0,"__register_diagnostic_E0264","","",N,N],[0,"__register_diagnostic_E0271","","",N,N],[0,"__register_diagnostic_E0275","","",N,N],[0,"__register_diagnostic_E0276","","",N,N],[0,"__register_diagnostic_E0277","","",N,N],[0,"__register_diagnostic_E0281","","",N,N],[0,"__register_diagnostic_E0282","","",N,N],[0,"__register_diagnostic_E0283","","",N,N],[0,"__register_diagnostic_E0296","","",N,N],[0,"__register_diagnostic_E0308","","",N,N],[0,"__register_diagnostic_E0309","","",N,N],[0,"__register_diagnostic_E0310","","",N,N],[0,"__register_diagnostic_E0317","","",N,N],[0,"__register_diagnostic_E0391","","",N,N],[0,"__register_diagnostic_E0398","","",N,N],[0,"__register_diagnostic_E0452","","",N,N],[0,"__register_diagnostic_E0453","","",N,N],[0,"__register_diagnostic_E0478","","",N,N],[0,"__register_diagnostic_E0491","","",N,N],[0,"__register_diagnostic_E0496","","",N,N],[0,"__register_diagnostic_E0497","","",N,N],[0,"__register_diagnostic_E0512","","",N,N],[0,"__register_diagnostic_E0517","","",N,N],[0,"__register_diagnostic_E0518","","",N,N],[0,"__register_diagnostic_E0522","","",N,N],[0,"__register_diagnostic_E0525","","",N,N],[0,"__register_diagnostic_E0580","","",N,N],[0,"__register_diagnostic_E0562","","",N,N],[0,"__register_diagnostic_E0591","","",N,N],[0,"__register_diagnostic_E0593","","",N,N],[0,"__register_diagnostic_E0601","","",N,N],[0,"__register_diagnostic_E0602","","",N,N],[0,"__register_diagnostic_E0621","","",N,N],[0,"__register_diagnostic_E0635","","",N,N],[0,"__register_diagnostic_E0636","","",N,N],[0,"__register_diagnostic_E0644","","",N,N],[0,"__register_diagnostic_E0692","","",N,N],[0,"__register_diagnostic_E0700","","",N,N],[0,"__register_diagnostic_E0701","","",N,N],[0,"__register_diagnostic_E0702","","",N,N],[0,"__register_diagnostic_E0278","","",N,N],[0,"__register_diagnostic_E0279","","",N,N],[0,"__register_diagnostic_E0280","","",N,N],[0,"__register_diagnostic_E0284","","",N,N],[0,"__register_diagnostic_E0311","","",N,N],[0,"__register_diagnostic_E0312","","",N,N],[0,"__register_diagnostic_E0313","","",N,N],[0,"__register_diagnostic_E0314","","",N,N],[0,"__register_diagnostic_E0315","","",N,N],[0,"__register_diagnostic_E0316","","",N,N],[0,"__register_diagnostic_E0320","","",N,N],[0,"__register_diagnostic_E0473","","",N,N],[0,"__register_diagnostic_E0474","","",N,N],[0,"__register_diagnostic_E0475","","",N,N],[0,"__register_diagnostic_E0476","","",N,N],[0,"__register_diagnostic_E0477","","",N,N],[0,"__register_diagnostic_E0479","","",N,N],[0,"__register_diagnostic_E0480","","",N,N],[0,"__register_diagnostic_E0481","","",N,N],[0,"__register_diagnostic_E0482","","",N,N],[0,"__register_diagnostic_E0483","","",N,N],[0,"__register_diagnostic_E0484","","",N,N],[0,"__register_diagnostic_E0485","","",N,N],[0,"__register_diagnostic_E0486","","",N,N],[0,"__register_diagnostic_E0487","","",N,N],[0,"__register_diagnostic_E0488","","",N,N],[0,"__register_diagnostic_E0489","","",N,N],[0,"__register_diagnostic_E0490","","",N,N],[0,"__register_diagnostic_E0495","","",N,N],[0,"__register_diagnostic_E0566","","",N,N],[0,"__register_diagnostic_E0623","","",N,N],[0,"__register_diagnostic_E0628","","",N,N],[0,"__register_diagnostic_E0631","","",N,N],[0,"__register_diagnostic_E0637","","",N,N],[0,"__register_diagnostic_E0657","","",N,N],[0,"__register_diagnostic_E0687","","",N,N],[0,"__register_diagnostic_E0688","","",N,N],[0,"__register_diagnostic_E0697","","",N,N],[0,"__register_diagnostic_E0707","","",N,N],[0,"__register_diagnostic_E0708","","",N,N],[0,"__register_diagnostic_E0709","","",N,N],[0,"__register_diagnostic_E0710","","",N,N],[0,"__register_diagnostic_E0711","","",N,N],[0,"cfg","rustc","Module that constructs a control-flow graph representing an item. Uses `Graph` as the underlying representation.",N,N],[3,"CFG","rustc::cfg","",N,N],[12,"owner_def_id","","",0,N],[12,"graph","","",0,N],[12,"entry","","",0,N],[12,"exit","","",0,N],[3,"CFGEdgeData","","",N,N],[12,"exiting_scopes","","",1,N],[4,"CFGNodeData","","",N,N],[13,"AST","","",2,N],[13,"Entry","","",2,N],[13,"Exit","","",2,N],[13,"Dummy","","",2,N],[13,"Unreachable","","",2,N],[0,"construct","","",N,N],[3,"CFGBuilder","rustc::cfg::construct","",N,N],[12,"tcx","","",3,N],[12,"owner_def_id","","",3,N],[12,"tables","","",3,N],[12,"graph","","",3,N],[12,"fn_exit","","",3,N],[12,"loop_scopes","","",3,N],[12,"breakable_block_scopes","","",3,N],[3,"BlockScope","","",N,N],[12,"block_expr_id","","",4,N],[12,"break_index","","",4,N],[3,"LoopScope","","",N,N],[12,"loop_id","","",5,N],[12,"continue_index","","",5,N],[12,"break_index","","",5,N],[4,"ScopeCfKind","","",N,N],[13,"Break","","",6,N],[13,"Continue","","",6,N],[5,"construct","","",N,[[["tyctxt"],["body"]],["cfg"]]],[11,"clone","","",4,[[["self"]],["blockscope"]]],[11,"clone","","",5,[[["self"]],["loopscope"]]],[11,"block","","",3,[[["self"],["block"],["cfgindex"]],["cfgindex"]]],[11,"stmt","","",3,[[["self"],["stmt"],["cfgindex"]],["cfgindex"]]],[11,"decl","","",3,[[["self"],["decl"],["cfgindex"]],["cfgindex"]]],[11,"pat","","",3,[[["self"],["pat"],["cfgindex"]],["cfgindex"]]],[11,"pats_all","","Handles case where all of the patterns must match.",3,[[["self"],["i"],["cfgindex"]],["cfgindex"]]],[11,"expr","","",3,[[["self"],["expr"],["cfgindex"]],["cfgindex"]]],[11,"call","","",3,[[["self"],["expr"],["cfgindex"],["expr"],["i"]],["cfgindex"]]],[11,"exprs","","Constructs graph for `exprs` evaluated in order",3,[[["self"],["i"],["cfgindex"]],["cfgindex"]]],[11,"opt_expr","","Constructs graph for `opt_expr` evaluated, if Some",3,[[["self"],["option"],["cfgindex"]],["cfgindex"]]],[11,"straightline","","Handles case of an expression that evaluates `subexprs` in order",3,[[["self"],["expr"],["cfgindex"],["i"]],["cfgindex"]]],[11,"match_","","",3,N],[11,"add_dummy_node","","",3,N],[11,"add_ast_node","","",3,N],[11,"add_unreachable_node","","",3,[[["self"]],["cfgindex"]]],[11,"add_node","","",3,N],[11,"add_contained_edge","","",3,[[["self"],["cfgindex"],["cfgindex"]]]],[11,"add_exiting_edge","","",3,[[["self"],["expr"],["cfgindex"],["scope"],["cfgindex"]]]],[11,"add_returning_edge","","",3,[[["self"],["expr"],["cfgindex"]]]],[11,"find_scope_edge","","",3,N],[11,"clone","","",6,[[["self"]],["scopecfkind"]]],[11,"assert_receiver_is_total_eq","","",6,N],[11,"eq","","",6,[[["self"],["scopecfkind"]],["bool"]]],[0,"graphviz","rustc::cfg","",N,N],[3,"LabelledCFG","rustc::cfg::graphviz","",N,N],[12,"tcx","","",7,N],[12,"cfg","","",7,N],[12,"name","","",7,N],[12,"labelled_edges","","`labelled_edges` controls whether we emit labels on the edges",7,N],[6,"Node","","",N,N],[6,"Edge","","",N,N],[11,"local_id_to_string","","",7,[[["self"],["itemlocalid"]],["string"]]],[11,"graph_id","","",7,[[["self"]],["id"]]],[11,"node_id","","",7,[[["self"],["node"]],["id"]]],[11,"node_label","","",7,[[["self"],["node"]],["labeltext"]]],[11,"edge_label","","",7,[[["self"],["edge"]],["labeltext"]]],[11,"nodes","","",7,[[["self"]],["nodes",["node"]]]],[11,"edges","","",7,[[["self"]],["edges",["edge"]]]],[11,"source","","",7,[[["self"],["edge"]],["node"]]],[11,"target","","",7,[[["self"],["edge"]],["node"]]],[6,"CFGIndex","rustc::cfg","",N,N],[6,"CFGGraph","","",N,N],[6,"CFGNode","","",N,N],[6,"CFGEdge","","",N,N],[11,"clone","","",2,[[["self"]],["cfgnodedata"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"eq","","",2,[[["self"],["cfgnodedata"]],["bool"]]],[11,"ne","","",2,[[["self"],["cfgnodedata"]],["bool"]]],[11,"id","","",2,[[["self"]],["itemlocalid"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"new","","",0,[[["tyctxt"],["body"]],["cfg"]]],[11,"node_is_reachable","","",0,[[["self"],["itemlocalid"]],["bool"]]],[0,"dep_graph","rustc","",N,N],[3,"DepTrackingMap","rustc::dep_graph","A DepTrackingMap offers a subset of the `Map` API and ensures that we make calls to `read` and `write` as appropriate. We key the maps with a unique type for brevity.",N,N],[12,"phantom","","",8,N],[12,"graph","","",8,N],[12,"map","","",8,N],[3,"DepNode","","",N,N],[12,"kind","","",9,N],[12,"hash","","",9,N],[3,"WorkProductId","","A \"work product\" corresponds to a `.o` (or other) file that we save in between runs. These ids do not have a DefId but rather some independent path or string that persists between runs without the need to be mapped or unmapped. (This ensures we can serialize them even in the absence of a tcx.)",N,N],[12,"hash","","",10,N],[3,"DepGraph","","",N,N],[12,"data","","",11,N],[12,"fingerprints","","",11,N],[3,"WorkProduct","","A \"work product\" is an intermediate result that we save into the incremental directory for later re-use. The primary example are the object files that we save for each partition at code generation time.",N,N],[12,"cgu_name","","",12,N],[12,"saved_files","","Saved files associated with this CGU",12,N],[3,"DepNodeIndex","","",N,N],[12,"private","","",13,N],[3,"PreviousDepGraph","","",N,N],[12,"data","","",14,N],[12,"index","","",14,N],[3,"DepGraphQuery","","",N,N],[12,"graph","","",15,N],[12,"indices","","",15,N],[3,"AssertDepGraphSafe","","A convenient override that lets you pass arbitrary state into a task. Every use should be accompanied by a comment explaining why it makes sense (or how it could be refactored away in the future).",N,N],[12,"0","","",16,N],[3,"SerializedDepGraph","","Data for use when recompiling the current crate.",N,N],[12,"nodes","","The set of all DepNodes in the graph",17,N],[12,"fingerprints","","The set of all Fingerprints in the graph. Each Fingerprint corresponds to the DepNode at the same index in the nodes vector.",17,N],[12,"edge_list_indices","","For each DepNode, stores the list of edges originating from that DepNode. Encoded as a [start, end) pair indexing into edge_list_data, which holds the actual DepNodeIndices of the target nodes.",17,N],[12,"edge_list_data","","A flattened list of all edge targets in the graph. Edge sources are implicit in edge_list_indices.",17,N],[3,"SerializedDepNodeIndex","","",N,N],[12,"private","","",18,N],[4,"DepKind","","",N,N],[13,"Null","","",19,N],[13,"Krate","","",19,N],[13,"HirBody","","",19,N],[13,"Hir","","",19,N],[13,"CrateMetadata","","",19,N],[13,"RegionScopeTree","","",19,N],[13,"Coherence","","",19,N],[13,"CoherenceInherentImplOverlapCheck","","",19,N],[13,"CoherenceCheckTrait","","",19,N],[13,"PrivacyAccessLevels","","",19,N],[13,"MirConstQualif","","",19,N],[13,"MirBuilt","","",19,N],[13,"MirConst","","",19,N],[13,"MirValidated","","",19,N],[13,"MirOptimized","","",19,N],[13,"MirShim","","",19,N],[13,"BorrowCheckKrate","","",19,N],[13,"BorrowCheck","","",19,N],[13,"MirBorrowCheck","","",19,N],[13,"UnsafetyCheckResult","","",19,N],[13,"UnsafeDeriveOnReprPacked","","",19,N],[13,"Reachability","","",19,N],[13,"MirKeys","","",19,N],[13,"CrateVariances","","",19,N],[13,"AssociatedItems","","",19,N],[13,"TypeOfItem","","",19,N],[13,"GenericsOfItem","","",19,N],[13,"PredicatesOfItem","","",19,N],[13,"ExplicitPredicatesOfItem","","",19,N],[13,"PredicatesDefinedOnItem","","",19,N],[13,"InferredOutlivesOf","","",19,N],[13,"InferredOutlivesCrate","","",19,N],[13,"SuperPredicatesOfItem","","",19,N],[13,"TraitDefOfItem","","",19,N],[13,"AdtDefOfItem","","",19,N],[13,"ImplTraitRef","","",19,N],[13,"ImplPolarity","","",19,N],[13,"FnSignature","","",19,N],[13,"CoerceUnsizedInfo","","",19,N],[13,"ItemVarianceConstraints","","",19,N],[13,"ItemVariances","","",19,N],[13,"IsConstFn","","",19,N],[13,"IsForeignItem","","",19,N],[13,"TypeParamPredicates","","",19,N],[13,"SizedConstraint","","",19,N],[13,"DtorckConstraint","","",19,N],[13,"AdtDestructor","","",19,N],[13,"AssociatedItemDefIds","","",19,N],[13,"InherentImpls","","",19,N],[13,"TypeckBodiesKrate","","",19,N],[13,"TypeckTables","","",19,N],[13,"UsedTraitImports","","",19,N],[13,"HasTypeckTables","","",19,N],[13,"ConstEval","","",19,N],[13,"CheckMatch","","",19,N],[13,"SymbolName","","",19,N],[13,"InstanceSymbolName","","",19,N],[13,"SpecializationGraph","","",19,N],[13,"ObjectSafety","","",19,N],[13,"FulfillObligation","","",19,N],[13,"VtableMethods","","",19,N],[13,"IsCopy","","",19,N],[13,"IsSized","","",19,N],[13,"IsFreeze","","",19,N],[13,"NeedsDrop","","",19,N],[13,"Layout","","",19,N],[13,"TraitImpls","","",19,N],[13,"AllLocalTraitImpls","","",19,N],[13,"TraitSelect","","",19,N],[13,"ParamEnv","","",19,N],[13,"DescribeDef","","",19,N],[13,"DefSpan","","",19,N],[13,"LookupStability","","",19,N],[13,"LookupDeprecationEntry","","",19,N],[13,"ConstIsRvaluePromotableToStatic","","",19,N],[13,"RvaluePromotableMap","","",19,N],[13,"ImplParent","","",19,N],[13,"TraitOfItem","","",19,N],[13,"IsReachableNonGeneric","","",19,N],[13,"IsUnreachableLocalDefinition","","",19,N],[13,"IsMirAvailable","","",19,N],[13,"ItemAttrs","","",19,N],[13,"CodegenFnAttrs","","",19,N],[13,"FnArgNames","","",19,N],[13,"RenderedConst","","",19,N],[13,"DylibDepFormats","","",19,N],[13,"IsPanicRuntime","","",19,N],[13,"IsCompilerBuiltins","","",19,N],[13,"HasGlobalAllocator","","",19,N],[13,"HasPanicHandler","","",19,N],[13,"ExternCrate","","",19,N],[13,"LintLevels","","",19,N],[13,"Specializes","","",19,N],[13,"InScopeTraits","","",19,N],[13,"ModuleExports","","",19,N],[13,"IsSanitizerRuntime","","",19,N],[13,"IsProfilerRuntime","","",19,N],[13,"GetPanicStrategy","","",19,N],[13,"IsNoBuiltins","","",19,N],[13,"ImplDefaultness","","",19,N],[13,"CheckItemWellFormed","","",19,N],[13,"CheckTraitItemWellFormed","","",19,N],[13,"CheckImplItemWellFormed","","",19,N],[13,"ReachableNonGenerics","","",19,N],[13,"NativeLibraries","","",19,N],[13,"PluginRegistrarFn","","",19,N],[13,"DeriveRegistrarFn","","",19,N],[13,"CrateDisambiguator","","",19,N],[13,"CrateHash","","",19,N],[13,"OriginalCrateName","","",19,N],[13,"ExtraFileName","","",19,N],[13,"ImplementationsOfTrait","","",19,N],[13,"AllTraitImplementations","","",19,N],[13,"DllimportForeignItems","","",19,N],[13,"IsDllimportForeignItem","","",19,N],[13,"IsStaticallyIncludedForeignItem","","",19,N],[13,"NativeLibraryKind","","",19,N],[13,"LinkArgs","","",19,N],[13,"ResolveLifetimes","","",19,N],[13,"NamedRegion","","",19,N],[13,"IsLateBound","","",19,N],[13,"ObjectLifetimeDefaults","","",19,N],[13,"Visibility","","",19,N],[13,"DepKind","","",19,N],[13,"CrateName","","",19,N],[13,"ItemChildren","","",19,N],[13,"ExternModStmtCnum","","",19,N],[13,"GetLibFeatures","","",19,N],[13,"DefinedLibFeatures","","",19,N],[13,"GetLangItems","","",19,N],[13,"DefinedLangItems","","",19,N],[13,"MissingLangItems","","",19,N],[13,"VisibleParentMap","","",19,N],[13,"MissingExternCrateItem","","",19,N],[13,"UsedCrateSource","","",19,N],[13,"PostorderCnums","","",19,N],[13,"EraseRegionsTy","","",19,N],[13,"Freevars","","",19,N],[13,"MaybeUnusedTraitImport","","",19,N],[13,"MaybeUnusedExternCrates","","",19,N],[13,"StabilityIndex","","",19,N],[13,"AllTraits","","",19,N],[13,"AllCrateNums","","",19,N],[13,"ExportedSymbols","","",19,N],[13,"CollectAndPartitionMonoItems","","",19,N],[13,"IsCodegenedItem","","",19,N],[13,"CodegenUnit","","",19,N],[13,"CompileCodegenUnit","","",19,N],[13,"OutputFilenames","","",19,N],[13,"NormalizeProjectionTy","","",19,N],[13,"NormalizeTyAfterErasingRegions","","",19,N],[13,"ImpliedOutlivesBounds","","",19,N],[13,"DropckOutlives","","",19,N],[13,"EvaluateObligation","","",19,N],[13,"TypeOpEq","","",19,N],[13,"TypeOpSubtype","","",19,N],[13,"TypeOpProvePredicate","","",19,N],[13,"TypeOpNormalizeTy","","",19,N],[13,"TypeOpNormalizePredicate","","",19,N],[13,"TypeOpNormalizePolyFnSig","","",19,N],[13,"TypeOpNormalizeFnSig","","",19,N],[13,"SubstituteNormalizeAndTestPredicates","","",19,N],[13,"TargetFeaturesWhitelist","","",19,N],[13,"InstanceDefSizeEstimate","","",19,N],[13,"Features","","",19,N],[13,"ProgramClausesFor","","",19,N],[13,"ProgramClausesForEnv","","",19,N],[13,"WasmImportModuleMap","","",19,N],[13,"ForeignModules","","",19,N],[13,"UpstreamMonomorphizations","","",19,N],[13,"UpstreamMonomorphizationsFor","","",19,N],[4,"DepConstructor","","",N,N],[13,"Null","","",20,N],[13,"Krate","","",20,N],[13,"HirBody","","",20,N],[13,"Hir","","",20,N],[13,"CrateMetadata","","",20,N],[13,"RegionScopeTree","","",20,N],[13,"Coherence","","",20,N],[13,"CoherenceInherentImplOverlapCheck","","",20,N],[13,"CoherenceCheckTrait","","",20,N],[13,"PrivacyAccessLevels","","",20,N],[13,"MirConstQualif","","",20,N],[13,"MirBuilt","","",20,N],[13,"MirConst","","",20,N],[13,"MirValidated","","",20,N],[13,"MirOptimized","","",20,N],[13,"MirShim","","",20,N],[12,"instance_def","rustc::dep_graph::DepConstructor","",20,N],[13,"BorrowCheckKrate","rustc::dep_graph","",20,N],[13,"BorrowCheck","","",20,N],[13,"MirBorrowCheck","","",20,N],[13,"UnsafetyCheckResult","","",20,N],[13,"UnsafeDeriveOnReprPacked","","",20,N],[13,"Reachability","","",20,N],[13,"MirKeys","","",20,N],[13,"CrateVariances","","",20,N],[13,"AssociatedItems","","",20,N],[13,"TypeOfItem","","",20,N],[13,"GenericsOfItem","","",20,N],[13,"PredicatesOfItem","","",20,N],[13,"ExplicitPredicatesOfItem","","",20,N],[13,"PredicatesDefinedOnItem","","",20,N],[13,"InferredOutlivesOf","","",20,N],[13,"InferredOutlivesCrate","","",20,N],[13,"SuperPredicatesOfItem","","",20,N],[13,"TraitDefOfItem","","",20,N],[13,"AdtDefOfItem","","",20,N],[13,"ImplTraitRef","","",20,N],[13,"ImplPolarity","","",20,N],[13,"FnSignature","","",20,N],[13,"CoerceUnsizedInfo","","",20,N],[13,"ItemVarianceConstraints","","",20,N],[13,"ItemVariances","","",20,N],[13,"IsConstFn","","",20,N],[13,"IsForeignItem","","",20,N],[13,"TypeParamPredicates","","",20,N],[12,"item_id","rustc::dep_graph::DepConstructor","",20,N],[12,"param_id","","",20,N],[13,"SizedConstraint","rustc::dep_graph","",20,N],[13,"DtorckConstraint","","",20,N],[13,"AdtDestructor","","",20,N],[13,"AssociatedItemDefIds","","",20,N],[13,"InherentImpls","","",20,N],[13,"TypeckBodiesKrate","","",20,N],[13,"TypeckTables","","",20,N],[13,"UsedTraitImports","","",20,N],[13,"HasTypeckTables","","",20,N],[13,"ConstEval","","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"CheckMatch","rustc::dep_graph","",20,N],[13,"SymbolName","","",20,N],[13,"InstanceSymbolName","","",20,N],[12,"instance","rustc::dep_graph::DepConstructor","",20,N],[13,"SpecializationGraph","rustc::dep_graph","",20,N],[13,"ObjectSafety","","",20,N],[13,"FulfillObligation","","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[12,"trait_ref","","",20,N],[13,"VtableMethods","rustc::dep_graph","",20,N],[12,"trait_ref","rustc::dep_graph::DepConstructor","",20,N],[13,"IsCopy","rustc::dep_graph","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"IsSized","rustc::dep_graph","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"IsFreeze","rustc::dep_graph","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"NeedsDrop","rustc::dep_graph","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"Layout","rustc::dep_graph","",20,N],[12,"param_env","rustc::dep_graph::DepConstructor","",20,N],[13,"TraitImpls","rustc::dep_graph","",20,N],[13,"AllLocalTraitImpls","","",20,N],[13,"TraitSelect","","",20,N],[13,"ParamEnv","","",20,N],[13,"DescribeDef","","",20,N],[13,"DefSpan","","",20,N],[13,"LookupStability","","",20,N],[13,"LookupDeprecationEntry","","",20,N],[13,"ConstIsRvaluePromotableToStatic","","",20,N],[13,"RvaluePromotableMap","","",20,N],[13,"ImplParent","","",20,N],[13,"TraitOfItem","","",20,N],[13,"IsReachableNonGeneric","","",20,N],[13,"IsUnreachableLocalDefinition","","",20,N],[13,"IsMirAvailable","","",20,N],[13,"ItemAttrs","","",20,N],[13,"CodegenFnAttrs","","",20,N],[13,"FnArgNames","","",20,N],[13,"RenderedConst","","",20,N],[13,"DylibDepFormats","","",20,N],[13,"IsPanicRuntime","","",20,N],[13,"IsCompilerBuiltins","","",20,N],[13,"HasGlobalAllocator","","",20,N],[13,"HasPanicHandler","","",20,N],[13,"ExternCrate","","",20,N],[13,"LintLevels","","",20,N],[13,"Specializes","","",20,N],[12,"impl1","rustc::dep_graph::DepConstructor","",20,N],[12,"impl2","","",20,N],[13,"InScopeTraits","rustc::dep_graph","",20,N],[13,"ModuleExports","","",20,N],[13,"IsSanitizerRuntime","","",20,N],[13,"IsProfilerRuntime","","",20,N],[13,"GetPanicStrategy","","",20,N],[13,"IsNoBuiltins","","",20,N],[13,"ImplDefaultness","","",20,N],[13,"CheckItemWellFormed","","",20,N],[13,"CheckTraitItemWellFormed","","",20,N],[13,"CheckImplItemWellFormed","","",20,N],[13,"ReachableNonGenerics","","",20,N],[13,"NativeLibraries","","",20,N],[13,"PluginRegistrarFn","","",20,N],[13,"DeriveRegistrarFn","","",20,N],[13,"CrateDisambiguator","","",20,N],[13,"CrateHash","","",20,N],[13,"OriginalCrateName","","",20,N],[13,"ExtraFileName","","",20,N],[13,"ImplementationsOfTrait","","",20,N],[12,"krate","rustc::dep_graph::DepConstructor","",20,N],[12,"trait_id","","",20,N],[13,"AllTraitImplementations","rustc::dep_graph","",20,N],[13,"DllimportForeignItems","","",20,N],[13,"IsDllimportForeignItem","","",20,N],[13,"IsStaticallyIncludedForeignItem","","",20,N],[13,"NativeLibraryKind","","",20,N],[13,"LinkArgs","","",20,N],[13,"ResolveLifetimes","","",20,N],[13,"NamedRegion","","",20,N],[13,"IsLateBound","","",20,N],[13,"ObjectLifetimeDefaults","","",20,N],[13,"Visibility","","",20,N],[13,"DepKind","","",20,N],[13,"CrateName","","",20,N],[13,"ItemChildren","","",20,N],[13,"ExternModStmtCnum","","",20,N],[13,"GetLibFeatures","","",20,N],[13,"DefinedLibFeatures","","",20,N],[13,"GetLangItems","","",20,N],[13,"DefinedLangItems","","",20,N],[13,"MissingLangItems","","",20,N],[13,"VisibleParentMap","","",20,N],[13,"MissingExternCrateItem","","",20,N],[13,"UsedCrateSource","","",20,N],[13,"PostorderCnums","","",20,N],[13,"EraseRegionsTy","","",20,N],[12,"ty","rustc::dep_graph::DepConstructor","",20,N],[13,"Freevars","rustc::dep_graph","",20,N],[13,"MaybeUnusedTraitImport","","",20,N],[13,"MaybeUnusedExternCrates","","",20,N],[13,"StabilityIndex","","",20,N],[13,"AllTraits","","",20,N],[13,"AllCrateNums","","",20,N],[13,"ExportedSymbols","","",20,N],[13,"CollectAndPartitionMonoItems","","",20,N],[13,"IsCodegenedItem","","",20,N],[13,"CodegenUnit","","",20,N],[13,"CompileCodegenUnit","","",20,N],[13,"OutputFilenames","","",20,N],[13,"NormalizeProjectionTy","","",20,N],[13,"NormalizeTyAfterErasingRegions","","",20,N],[13,"ImpliedOutlivesBounds","","",20,N],[13,"DropckOutlives","","",20,N],[13,"EvaluateObligation","","",20,N],[13,"TypeOpEq","","",20,N],[13,"TypeOpSubtype","","",20,N],[13,"TypeOpProvePredicate","","",20,N],[13,"TypeOpNormalizeTy","","",20,N],[13,"TypeOpNormalizePredicate","","",20,N],[13,"TypeOpNormalizePolyFnSig","","",20,N],[13,"TypeOpNormalizeFnSig","","",20,N],[13,"SubstituteNormalizeAndTestPredicates","","",20,N],[12,"key","rustc::dep_graph::DepConstructor","",20,N],[13,"TargetFeaturesWhitelist","rustc::dep_graph","",20,N],[13,"InstanceDefSizeEstimate","","",20,N],[12,"instance_def","rustc::dep_graph::DepConstructor","",20,N],[13,"Features","rustc::dep_graph","",20,N],[13,"ProgramClausesFor","","",20,N],[13,"ProgramClausesForEnv","","",20,N],[13,"WasmImportModuleMap","","",20,N],[13,"ForeignModules","","",20,N],[13,"UpstreamMonomorphizations","","",20,N],[13,"UpstreamMonomorphizationsFor","","",20,N],[4,"DepNodeColor","","",N,N],[13,"Red","","",21,N],[13,"Green","","",21,N],[4,"OpenTask","","",N,N],[13,"Regular","","",22,N],[13,"Anon","","",22,N],[13,"Ignore","","",22,N],[13,"EvalAlways","","",22,N],[12,"node","rustc::dep_graph::OpenTask","",22,N],[4,"WorkProductFileKind","rustc::dep_graph","",N,N],[13,"Object","","",23,N],[13,"Bytecode","","",23,N],[13,"BytecodeCompressed","","",23,N],[0,"debug","","Code for debugging the dep-graph.",N,N],[3,"DepNodeFilter","rustc::dep_graph::debug","A dep-node filter goes from a user-defined string to a query over nodes. Right now the format is like this:",N,N],[12,"text","","",24,N],[3,"EdgeFilter","","A filter like `F -> G` where `F` and `G` are valid dep-node filters. This can be used to test the source/target independently.",N,N],[12,"source","","",25,N],[12,"target","","",25,N],[11,"fmt","","",24,[[["self"],["formatter"]],["result"]]],[11,"new","","",24,[[["str"]],["self"]]],[11,"accepts_all","","True if all nodes always pass the filter.",24,[[["self"]],["bool"]]],[11,"test","","Tests whether `node` meets the filter, returning true if so.",24,[[["self"],["depnode"]],["bool"]]],[11,"new","","",25,[[["str"]],["result",["edgefilter","box"]]]],[11,"test","","",25,[[["self"],["depnode"],["depnode"]],["bool"]]],[0,"dep_node","rustc::dep_graph","This module defines the `DepNode` type which the compiler uses to represent nodes in the dependency graph. A `DepNode` consists of a `DepKind` (which specifies the kind of thing it represents, like a piece of HIR, MIR, etc) and a `Fingerprint`, a 128 bit hash value the exact meaning of which depends on the node's `DepKind`. Together, the kind and the fingerprint fully identify a dependency node, even across multiple compilation sessions. In other words, the value of the fingerprint does not depend on anything that is specific to a given compilation session, like an unpredictable interning key (e.g. NodeId, DefId, Symbol) or the numeric value of a pointer. The concept behind this could be compared to how git commit hashes uniquely identify a given commit and has a few advantages:",N,N],[3,"DepNode","rustc::dep_graph::dep_node","",N,N],[12,"kind","","",9,N],[12,"hash","","",9,N],[3,"WorkProductId","","A \"work product\" corresponds to a `.o` (or other) file that we save in between runs. These ids do not have a DefId but rather some independent path or string that persists between runs without the need to be mapped or unmapped. (This ensures we can serialize them even in the absence of a tcx.)",N,N],[12,"hash","","",10,N],[4,"DepKind","","",N,N],[13,"Null","","",19,N],[13,"Krate","","",19,N],[13,"HirBody","","",19,N],[13,"Hir","","",19,N],[13,"CrateMetadata","","",19,N],[13,"RegionScopeTree","","",19,N],[13,"Coherence","","",19,N],[13,"CoherenceInherentImplOverlapCheck","","",19,N],[13,"CoherenceCheckTrait","","",19,N],[13,"PrivacyAccessLevels","","",19,N],[13,"MirConstQualif","","",19,N],[13,"MirBuilt","","",19,N],[13,"MirConst","","",19,N],[13,"MirValidated","","",19,N],[13,"MirOptimized","","",19,N],[13,"MirShim","","",19,N],[13,"BorrowCheckKrate","","",19,N],[13,"BorrowCheck","","",19,N],[13,"MirBorrowCheck","","",19,N],[13,"UnsafetyCheckResult","","",19,N],[13,"UnsafeDeriveOnReprPacked","","",19,N],[13,"Reachability","","",19,N],[13,"MirKeys","","",19,N],[13,"CrateVariances","","",19,N],[13,"AssociatedItems","","",19,N],[13,"TypeOfItem","","",19,N],[13,"GenericsOfItem","","",19,N],[13,"PredicatesOfItem","","",19,N],[13,"ExplicitPredicatesOfItem","","",19,N],[13,"PredicatesDefinedOnItem","","",19,N],[13,"InferredOutlivesOf","","",19,N],[13,"InferredOutlivesCrate","","",19,N],[13,"SuperPredicatesOfItem","","",19,N],[13,"TraitDefOfItem","","",19,N],[13,"AdtDefOfItem","","",19,N],[13,"ImplTraitRef","","",19,N],[13,"ImplPolarity","","",19,N],[13,"FnSignature","","",19,N],[13,"CoerceUnsizedInfo","","",19,N],[13,"ItemVarianceConstraints","","",19,N],[13,"ItemVariances","","",19,N],[13,"IsConstFn","","",19,N],[13,"IsForeignItem","","",19,N],[13,"TypeParamPredicates","","",19,N],[13,"SizedConstraint","","",19,N],[13,"DtorckConstraint","","",19,N],[13,"AdtDestructor","","",19,N],[13,"AssociatedItemDefIds","","",19,N],[13,"InherentImpls","","",19,N],[13,"TypeckBodiesKrate","","",19,N],[13,"TypeckTables","","",19,N],[13,"UsedTraitImports","","",19,N],[13,"HasTypeckTables","","",19,N],[13,"ConstEval","","",19,N],[13,"CheckMatch","","",19,N],[13,"SymbolName","","",19,N],[13,"InstanceSymbolName","","",19,N],[13,"SpecializationGraph","","",19,N],[13,"ObjectSafety","","",19,N],[13,"FulfillObligation","","",19,N],[13,"VtableMethods","","",19,N],[13,"IsCopy","","",19,N],[13,"IsSized","","",19,N],[13,"IsFreeze","","",19,N],[13,"NeedsDrop","","",19,N],[13,"Layout","","",19,N],[13,"TraitImpls","","",19,N],[13,"AllLocalTraitImpls","","",19,N],[13,"TraitSelect","","",19,N],[13,"ParamEnv","","",19,N],[13,"DescribeDef","","",19,N],[13,"DefSpan","","",19,N],[13,"LookupStability","","",19,N],[13,"LookupDeprecationEntry","","",19,N],[13,"ConstIsRvaluePromotableToStatic","","",19,N],[13,"RvaluePromotableMap","","",19,N],[13,"ImplParent","","",19,N],[13,"TraitOfItem","","",19,N],[13,"IsReachableNonGeneric","","",19,N],[13,"IsUnreachableLocalDefinition","","",19,N],[13,"IsMirAvailable","","",19,N],[13,"ItemAttrs","","",19,N],[13,"CodegenFnAttrs","","",19,N],[13,"FnArgNames","","",19,N],[13,"RenderedConst","","",19,N],[13,"DylibDepFormats","","",19,N],[13,"IsPanicRuntime","","",19,N],[13,"IsCompilerBuiltins","","",19,N],[13,"HasGlobalAllocator","","",19,N],[13,"HasPanicHandler","","",19,N],[13,"ExternCrate","","",19,N],[13,"LintLevels","","",19,N],[13,"Specializes","","",19,N],[13,"InScopeTraits","","",19,N],[13,"ModuleExports","","",19,N],[13,"IsSanitizerRuntime","","",19,N],[13,"IsProfilerRuntime","","",19,N],[13,"GetPanicStrategy","","",19,N],[13,"IsNoBuiltins","","",19,N],[13,"ImplDefaultness","","",19,N],[13,"CheckItemWellFormed","","",19,N],[13,"CheckTraitItemWellFormed","","",19,N],[13,"CheckImplItemWellFormed","","",19,N],[13,"ReachableNonGenerics","","",19,N],[13,"NativeLibraries","","",19,N],[13,"PluginRegistrarFn","","",19,N],[13,"DeriveRegistrarFn","","",19,N],[13,"CrateDisambiguator","","",19,N],[13,"CrateHash","","",19,N],[13,"OriginalCrateName","","",19,N],[13,"ExtraFileName","","",19,N],[13,"ImplementationsOfTrait","","",19,N],[13,"AllTraitImplementations","","",19,N],[13,"DllimportForeignItems","","",19,N],[13,"IsDllimportForeignItem","","",19,N],[13,"IsStaticallyIncludedForeignItem","","",19,N],[13,"NativeLibraryKind","","",19,N],[13,"LinkArgs","","",19,N],[13,"ResolveLifetimes","","",19,N],[13,"NamedRegion","","",19,N],[13,"IsLateBound","","",19,N],[13,"ObjectLifetimeDefaults","","",19,N],[13,"Visibility","","",19,N],[13,"DepKind","","",19,N],[13,"CrateName","","",19,N],[13,"ItemChildren","","",19,N],[13,"ExternModStmtCnum","","",19,N],[13,"GetLibFeatures","","",19,N],[13,"DefinedLibFeatures","","",19,N],[13,"GetLangItems","","",19,N],[13,"DefinedLangItems","","",19,N],[13,"MissingLangItems","","",19,N],[13,"VisibleParentMap","","",19,N],[13,"MissingExternCrateItem","","",19,N],[13,"UsedCrateSource","","",19,N],[13,"PostorderCnums","","",19,N],[13,"EraseRegionsTy","","",19,N],[13,"Freevars","","",19,N],[13,"MaybeUnusedTraitImport","","",19,N],[13,"MaybeUnusedExternCrates","","",19,N],[13,"StabilityIndex","","",19,N],[13,"AllTraits","","",19,N],[13,"AllCrateNums","","",19,N],[13,"ExportedSymbols","","",19,N],[13,"CollectAndPartitionMonoItems","","",19,N],[13,"IsCodegenedItem","","",19,N],[13,"CodegenUnit","","",19,N],[13,"CompileCodegenUnit","","",19,N],[13,"OutputFilenames","","",19,N],[13,"NormalizeProjectionTy","","",19,N],[13,"NormalizeTyAfterErasingRegions","","",19,N],[13,"ImpliedOutlivesBounds","","",19,N],[13,"DropckOutlives","","",19,N],[13,"EvaluateObligation","","",19,N],[13,"TypeOpEq","","",19,N],[13,"TypeOpSubtype","","",19,N],[13,"TypeOpProvePredicate","","",19,N],[13,"TypeOpNormalizeTy","","",19,N],[13,"TypeOpNormalizePredicate","","",19,N],[13,"TypeOpNormalizePolyFnSig","","",19,N],[13,"TypeOpNormalizeFnSig","","",19,N],[13,"SubstituteNormalizeAndTestPredicates","","",19,N],[13,"TargetFeaturesWhitelist","","",19,N],[13,"InstanceDefSizeEstimate","","",19,N],[13,"Features","","",19,N],[13,"ProgramClausesFor","","",19,N],[13,"ProgramClausesForEnv","","",19,N],[13,"WasmImportModuleMap","","",19,N],[13,"ForeignModules","","",19,N],[13,"UpstreamMonomorphizations","","",19,N],[13,"UpstreamMonomorphizationsFor","","",19,N],[4,"DepConstructor","","",N,N],[13,"Null","","",20,N],[13,"Krate","","",20,N],[13,"HirBody","","",20,N],[13,"Hir","","",20,N],[13,"CrateMetadata","","",20,N],[13,"RegionScopeTree","","",20,N],[13,"Coherence","","",20,N],[13,"CoherenceInherentImplOverlapCheck","","",20,N],[13,"CoherenceCheckTrait","","",20,N],[13,"PrivacyAccessLevels","","",20,N],[13,"MirConstQualif","","",20,N],[13,"MirBuilt","","",20,N],[13,"MirConst","","",20,N],[13,"MirValidated","","",20,N],[13,"MirOptimized","","",20,N],[13,"MirShim","","",20,N],[12,"instance_def","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"BorrowCheckKrate","rustc::dep_graph::dep_node","",20,N],[13,"BorrowCheck","","",20,N],[13,"MirBorrowCheck","","",20,N],[13,"UnsafetyCheckResult","","",20,N],[13,"UnsafeDeriveOnReprPacked","","",20,N],[13,"Reachability","","",20,N],[13,"MirKeys","","",20,N],[13,"CrateVariances","","",20,N],[13,"AssociatedItems","","",20,N],[13,"TypeOfItem","","",20,N],[13,"GenericsOfItem","","",20,N],[13,"PredicatesOfItem","","",20,N],[13,"ExplicitPredicatesOfItem","","",20,N],[13,"PredicatesDefinedOnItem","","",20,N],[13,"InferredOutlivesOf","","",20,N],[13,"InferredOutlivesCrate","","",20,N],[13,"SuperPredicatesOfItem","","",20,N],[13,"TraitDefOfItem","","",20,N],[13,"AdtDefOfItem","","",20,N],[13,"ImplTraitRef","","",20,N],[13,"ImplPolarity","","",20,N],[13,"FnSignature","","",20,N],[13,"CoerceUnsizedInfo","","",20,N],[13,"ItemVarianceConstraints","","",20,N],[13,"ItemVariances","","",20,N],[13,"IsConstFn","","",20,N],[13,"IsForeignItem","","",20,N],[13,"TypeParamPredicates","","",20,N],[12,"item_id","rustc::dep_graph::dep_node::DepConstructor","",20,N],[12,"param_id","","",20,N],[13,"SizedConstraint","rustc::dep_graph::dep_node","",20,N],[13,"DtorckConstraint","","",20,N],[13,"AdtDestructor","","",20,N],[13,"AssociatedItemDefIds","","",20,N],[13,"InherentImpls","","",20,N],[13,"TypeckBodiesKrate","","",20,N],[13,"TypeckTables","","",20,N],[13,"UsedTraitImports","","",20,N],[13,"HasTypeckTables","","",20,N],[13,"ConstEval","","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"CheckMatch","rustc::dep_graph::dep_node","",20,N],[13,"SymbolName","","",20,N],[13,"InstanceSymbolName","","",20,N],[12,"instance","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"SpecializationGraph","rustc::dep_graph::dep_node","",20,N],[13,"ObjectSafety","","",20,N],[13,"FulfillObligation","","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[12,"trait_ref","","",20,N],[13,"VtableMethods","rustc::dep_graph::dep_node","",20,N],[12,"trait_ref","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"IsCopy","rustc::dep_graph::dep_node","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"IsSized","rustc::dep_graph::dep_node","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"IsFreeze","rustc::dep_graph::dep_node","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"NeedsDrop","rustc::dep_graph::dep_node","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"Layout","rustc::dep_graph::dep_node","",20,N],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"TraitImpls","rustc::dep_graph::dep_node","",20,N],[13,"AllLocalTraitImpls","","",20,N],[13,"TraitSelect","","",20,N],[13,"ParamEnv","","",20,N],[13,"DescribeDef","","",20,N],[13,"DefSpan","","",20,N],[13,"LookupStability","","",20,N],[13,"LookupDeprecationEntry","","",20,N],[13,"ConstIsRvaluePromotableToStatic","","",20,N],[13,"RvaluePromotableMap","","",20,N],[13,"ImplParent","","",20,N],[13,"TraitOfItem","","",20,N],[13,"IsReachableNonGeneric","","",20,N],[13,"IsUnreachableLocalDefinition","","",20,N],[13,"IsMirAvailable","","",20,N],[13,"ItemAttrs","","",20,N],[13,"CodegenFnAttrs","","",20,N],[13,"FnArgNames","","",20,N],[13,"RenderedConst","","",20,N],[13,"DylibDepFormats","","",20,N],[13,"IsPanicRuntime","","",20,N],[13,"IsCompilerBuiltins","","",20,N],[13,"HasGlobalAllocator","","",20,N],[13,"HasPanicHandler","","",20,N],[13,"ExternCrate","","",20,N],[13,"LintLevels","","",20,N],[13,"Specializes","","",20,N],[12,"impl1","rustc::dep_graph::dep_node::DepConstructor","",20,N],[12,"impl2","","",20,N],[13,"InScopeTraits","rustc::dep_graph::dep_node","",20,N],[13,"ModuleExports","","",20,N],[13,"IsSanitizerRuntime","","",20,N],[13,"IsProfilerRuntime","","",20,N],[13,"GetPanicStrategy","","",20,N],[13,"IsNoBuiltins","","",20,N],[13,"ImplDefaultness","","",20,N],[13,"CheckItemWellFormed","","",20,N],[13,"CheckTraitItemWellFormed","","",20,N],[13,"CheckImplItemWellFormed","","",20,N],[13,"ReachableNonGenerics","","",20,N],[13,"NativeLibraries","","",20,N],[13,"PluginRegistrarFn","","",20,N],[13,"DeriveRegistrarFn","","",20,N],[13,"CrateDisambiguator","","",20,N],[13,"CrateHash","","",20,N],[13,"OriginalCrateName","","",20,N],[13,"ExtraFileName","","",20,N],[13,"ImplementationsOfTrait","","",20,N],[12,"krate","rustc::dep_graph::dep_node::DepConstructor","",20,N],[12,"trait_id","","",20,N],[13,"AllTraitImplementations","rustc::dep_graph::dep_node","",20,N],[13,"DllimportForeignItems","","",20,N],[13,"IsDllimportForeignItem","","",20,N],[13,"IsStaticallyIncludedForeignItem","","",20,N],[13,"NativeLibraryKind","","",20,N],[13,"LinkArgs","","",20,N],[13,"ResolveLifetimes","","",20,N],[13,"NamedRegion","","",20,N],[13,"IsLateBound","","",20,N],[13,"ObjectLifetimeDefaults","","",20,N],[13,"Visibility","","",20,N],[13,"DepKind","","",20,N],[13,"CrateName","","",20,N],[13,"ItemChildren","","",20,N],[13,"ExternModStmtCnum","","",20,N],[13,"GetLibFeatures","","",20,N],[13,"DefinedLibFeatures","","",20,N],[13,"GetLangItems","","",20,N],[13,"DefinedLangItems","","",20,N],[13,"MissingLangItems","","",20,N],[13,"VisibleParentMap","","",20,N],[13,"MissingExternCrateItem","","",20,N],[13,"UsedCrateSource","","",20,N],[13,"PostorderCnums","","",20,N],[13,"EraseRegionsTy","","",20,N],[12,"ty","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"Freevars","rustc::dep_graph::dep_node","",20,N],[13,"MaybeUnusedTraitImport","","",20,N],[13,"MaybeUnusedExternCrates","","",20,N],[13,"StabilityIndex","","",20,N],[13,"AllTraits","","",20,N],[13,"AllCrateNums","","",20,N],[13,"ExportedSymbols","","",20,N],[13,"CollectAndPartitionMonoItems","","",20,N],[13,"IsCodegenedItem","","",20,N],[13,"CodegenUnit","","",20,N],[13,"CompileCodegenUnit","","",20,N],[13,"OutputFilenames","","",20,N],[13,"NormalizeProjectionTy","","",20,N],[13,"NormalizeTyAfterErasingRegions","","",20,N],[13,"ImpliedOutlivesBounds","","",20,N],[13,"DropckOutlives","","",20,N],[13,"EvaluateObligation","","",20,N],[13,"TypeOpEq","","",20,N],[13,"TypeOpSubtype","","",20,N],[13,"TypeOpProvePredicate","","",20,N],[13,"TypeOpNormalizeTy","","",20,N],[13,"TypeOpNormalizePredicate","","",20,N],[13,"TypeOpNormalizePolyFnSig","","",20,N],[13,"TypeOpNormalizeFnSig","","",20,N],[13,"SubstituteNormalizeAndTestPredicates","","",20,N],[12,"key","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"TargetFeaturesWhitelist","rustc::dep_graph::dep_node","",20,N],[13,"InstanceDefSizeEstimate","","",20,N],[12,"instance_def","rustc::dep_graph::dep_node::DepConstructor","",20,N],[13,"Features","rustc::dep_graph::dep_node","",20,N],[13,"ProgramClausesFor","","",20,N],[13,"ProgramClausesForEnv","","",20,N],[13,"WasmImportModuleMap","","",20,N],[13,"ForeignModules","","",20,N],[13,"UpstreamMonomorphizations","","",20,N],[13,"UpstreamMonomorphizationsFor","","",20,N],[0,"label_strs","","Contains variant => str representations for constructing DepNode groups for tests.",N,N],[17,"Null","rustc::dep_graph::dep_node::label_strs","",N,N],[17,"Krate","","",N,N],[17,"HirBody","","",N,N],[17,"Hir","","",N,N],[17,"CrateMetadata","","",N,N],[17,"RegionScopeTree","","",N,N],[17,"Coherence","","",N,N],[17,"CoherenceInherentImplOverlapCheck","","",N,N],[17,"CoherenceCheckTrait","","",N,N],[17,"PrivacyAccessLevels","","",N,N],[17,"MirConstQualif","","",N,N],[17,"MirBuilt","","",N,N],[17,"MirConst","","",N,N],[17,"MirValidated","","",N,N],[17,"MirOptimized","","",N,N],[17,"MirShim","","",N,N],[17,"BorrowCheckKrate","","",N,N],[17,"BorrowCheck","","",N,N],[17,"MirBorrowCheck","","",N,N],[17,"UnsafetyCheckResult","","",N,N],[17,"UnsafeDeriveOnReprPacked","","",N,N],[17,"Reachability","","",N,N],[17,"MirKeys","","",N,N],[17,"CrateVariances","","",N,N],[17,"AssociatedItems","","",N,N],[17,"TypeOfItem","","",N,N],[17,"GenericsOfItem","","",N,N],[17,"PredicatesOfItem","","",N,N],[17,"ExplicitPredicatesOfItem","","",N,N],[17,"PredicatesDefinedOnItem","","",N,N],[17,"InferredOutlivesOf","","",N,N],[17,"InferredOutlivesCrate","","",N,N],[17,"SuperPredicatesOfItem","","",N,N],[17,"TraitDefOfItem","","",N,N],[17,"AdtDefOfItem","","",N,N],[17,"ImplTraitRef","","",N,N],[17,"ImplPolarity","","",N,N],[17,"FnSignature","","",N,N],[17,"CoerceUnsizedInfo","","",N,N],[17,"ItemVarianceConstraints","","",N,N],[17,"ItemVariances","","",N,N],[17,"IsConstFn","","",N,N],[17,"IsForeignItem","","",N,N],[17,"TypeParamPredicates","","",N,N],[17,"SizedConstraint","","",N,N],[17,"DtorckConstraint","","",N,N],[17,"AdtDestructor","","",N,N],[17,"AssociatedItemDefIds","","",N,N],[17,"InherentImpls","","",N,N],[17,"TypeckBodiesKrate","","",N,N],[17,"TypeckTables","","",N,N],[17,"UsedTraitImports","","",N,N],[17,"HasTypeckTables","","",N,N],[17,"ConstEval","","",N,N],[17,"CheckMatch","","",N,N],[17,"SymbolName","","",N,N],[17,"InstanceSymbolName","","",N,N],[17,"SpecializationGraph","","",N,N],[17,"ObjectSafety","","",N,N],[17,"FulfillObligation","","",N,N],[17,"VtableMethods","","",N,N],[17,"IsCopy","","",N,N],[17,"IsSized","","",N,N],[17,"IsFreeze","","",N,N],[17,"NeedsDrop","","",N,N],[17,"Layout","","",N,N],[17,"TraitImpls","","",N,N],[17,"AllLocalTraitImpls","","",N,N],[17,"TraitSelect","","",N,N],[17,"ParamEnv","","",N,N],[17,"DescribeDef","","",N,N],[17,"DefSpan","","",N,N],[17,"LookupStability","","",N,N],[17,"LookupDeprecationEntry","","",N,N],[17,"ConstIsRvaluePromotableToStatic","","",N,N],[17,"RvaluePromotableMap","","",N,N],[17,"ImplParent","","",N,N],[17,"TraitOfItem","","",N,N],[17,"IsReachableNonGeneric","","",N,N],[17,"IsUnreachableLocalDefinition","","",N,N],[17,"IsMirAvailable","","",N,N],[17,"ItemAttrs","","",N,N],[17,"CodegenFnAttrs","","",N,N],[17,"FnArgNames","","",N,N],[17,"RenderedConst","","",N,N],[17,"DylibDepFormats","","",N,N],[17,"IsPanicRuntime","","",N,N],[17,"IsCompilerBuiltins","","",N,N],[17,"HasGlobalAllocator","","",N,N],[17,"HasPanicHandler","","",N,N],[17,"ExternCrate","","",N,N],[17,"LintLevels","","",N,N],[17,"Specializes","","",N,N],[17,"InScopeTraits","","",N,N],[17,"ModuleExports","","",N,N],[17,"IsSanitizerRuntime","","",N,N],[17,"IsProfilerRuntime","","",N,N],[17,"GetPanicStrategy","","",N,N],[17,"IsNoBuiltins","","",N,N],[17,"ImplDefaultness","","",N,N],[17,"CheckItemWellFormed","","",N,N],[17,"CheckTraitItemWellFormed","","",N,N],[17,"CheckImplItemWellFormed","","",N,N],[17,"ReachableNonGenerics","","",N,N],[17,"NativeLibraries","","",N,N],[17,"PluginRegistrarFn","","",N,N],[17,"DeriveRegistrarFn","","",N,N],[17,"CrateDisambiguator","","",N,N],[17,"CrateHash","","",N,N],[17,"OriginalCrateName","","",N,N],[17,"ExtraFileName","","",N,N],[17,"ImplementationsOfTrait","","",N,N],[17,"AllTraitImplementations","","",N,N],[17,"DllimportForeignItems","","",N,N],[17,"IsDllimportForeignItem","","",N,N],[17,"IsStaticallyIncludedForeignItem","","",N,N],[17,"NativeLibraryKind","","",N,N],[17,"LinkArgs","","",N,N],[17,"ResolveLifetimes","","",N,N],[17,"NamedRegion","","",N,N],[17,"IsLateBound","","",N,N],[17,"ObjectLifetimeDefaults","","",N,N],[17,"Visibility","","",N,N],[17,"DepKind","","",N,N],[17,"CrateName","","",N,N],[17,"ItemChildren","","",N,N],[17,"ExternModStmtCnum","","",N,N],[17,"GetLibFeatures","","",N,N],[17,"DefinedLibFeatures","","",N,N],[17,"GetLangItems","","",N,N],[17,"DefinedLangItems","","",N,N],[17,"MissingLangItems","","",N,N],[17,"VisibleParentMap","","",N,N],[17,"MissingExternCrateItem","","",N,N],[17,"UsedCrateSource","","",N,N],[17,"PostorderCnums","","",N,N],[17,"EraseRegionsTy","","",N,N],[17,"Freevars","","",N,N],[17,"MaybeUnusedTraitImport","","",N,N],[17,"MaybeUnusedExternCrates","","",N,N],[17,"StabilityIndex","","",N,N],[17,"AllTraits","","",N,N],[17,"AllCrateNums","","",N,N],[17,"ExportedSymbols","","",N,N],[17,"CollectAndPartitionMonoItems","","",N,N],[17,"IsCodegenedItem","","",N,N],[17,"CodegenUnit","","",N,N],[17,"CompileCodegenUnit","","",N,N],[17,"OutputFilenames","","",N,N],[17,"NormalizeProjectionTy","","",N,N],[17,"NormalizeTyAfterErasingRegions","","",N,N],[17,"ImpliedOutlivesBounds","","",N,N],[17,"DropckOutlives","","",N,N],[17,"EvaluateObligation","","",N,N],[17,"TypeOpEq","","",N,N],[17,"TypeOpSubtype","","",N,N],[17,"TypeOpProvePredicate","","",N,N],[17,"TypeOpNormalizeTy","","",N,N],[17,"TypeOpNormalizePredicate","","",N,N],[17,"TypeOpNormalizePolyFnSig","","",N,N],[17,"TypeOpNormalizeFnSig","","",N,N],[17,"SubstituteNormalizeAndTestPredicates","","",N,N],[17,"TargetFeaturesWhitelist","","",N,N],[17,"InstanceDefSizeEstimate","","",N,N],[17,"Features","","",N,N],[17,"ProgramClausesFor","","",N,N],[17,"ProgramClausesForEnv","","",N,N],[17,"WasmImportModuleMap","","",N,N],[17,"ForeignModules","","",N,N],[17,"UpstreamMonomorphizations","","",N,N],[17,"UpstreamMonomorphizationsFor","","",N,N],[8,"DepNodeParams","rustc::dep_graph::dep_node","",N,N],[18,"CAN_RECONSTRUCT_QUERY_KEY","","",26,N],[11,"to_fingerprint","","This method turns the parameters of a DepNodeConstructor into an opaque Fingerprint to be used in DepNode. Not all DepNodeParams support being turned into a Fingerprint (they don't need to if the corresponding DepNode is anonymous).",26,[[["self"],["tyctxt"]],["fingerprint"]]],[11,"to_debug_str","","",26,[[["self"],["tyctxt"]],["string"]]],[11,"fmt","rustc::dep_graph","",9,[[["self"],["formatter"]],["result"]]],[11,"fingerprint_needed_for_crate_hash","","",19,[[["self"]],["bool"]]],[11,"clone","","",19,[[["self"]],["depkind"]]],[11,"fmt","","",19,[[["self"],["formatter"]],["result"]]],[11,"eq","","",19,[[["self"],["depkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",19,N],[11,"partial_cmp","","",19,[[["self"],["depkind"]],["option",["ordering"]]]],[11,"cmp","","",19,[[["self"],["depkind"]],["ordering"]]],[11,"hash","","",19,N],[11,"encode","","",19,[[["self"],["__s"]],["result"]]],[11,"decode","","",19,[[["__d"]],["result",["depkind"]]]],[11,"can_reconstruct_query_key","","",19,[[["self"]],["bool"]]],[11,"is_anon","","",19,[[["self"]],["bool"]]],[11,"is_input","","",19,[[["self"]],["bool"]]],[11,"is_eval_always","","",19,[[["self"]],["bool"]]],[11,"has_params","","",19,[[["self"]],["bool"]]],[11,"clone","","",9,[[["self"]],["depnode"]]],[11,"eq","","",9,[[["self"],["depnode"]],["bool"]]],[11,"ne","","",9,[[["self"],["depnode"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",9,N],[11,"partial_cmp","","",9,[[["self"],["depnode"]],["option",["ordering"]]]],[11,"lt","","",9,[[["self"],["depnode"]],["bool"]]],[11,"le","","",9,[[["self"],["depnode"]],["bool"]]],[11,"gt","","",9,[[["self"],["depnode"]],["bool"]]],[11,"ge","","",9,[[["self"],["depnode"]],["bool"]]],[11,"cmp","","",9,[[["self"],["depnode"]],["ordering"]]],[11,"hash","","",9,N],[11,"encode","","",9,[[["self"],["__s"]],["result"]]],[11,"decode","","",9,[[["__d"]],["result",["depnode"]]]],[11,"new","","",9,[[["tyctxt"],["depconstructor"]],["depnode"]]],[11,"from_def_path_hash","","Construct a DepNode from the given DepKind and DefPathHash. This method will assert that the given DepKind actually requires a single DefId/DefPathHash parameter.",9,[[["depkind"],["defpathhash"]],["depnode"]]],[11,"new_no_params","","Create a new, parameterless DepNode. This method will assert that the DepNode corresponding to the given DepKind actually does not require any parameters.",9,[[["depkind"]],["depnode"]]],[11,"extract_def_id","","Extract the DefId corresponding to this DepNode. This will work if two conditions are met:",9,[[["self"],["tyctxt"]],["option",["defid"]]]],[11,"from_label_string","","Used in testing",9,[[["str"],["defpathhash"]],["result",["depnode"]]]],[11,"has_label_string","","Used in testing",9,[[["str"]],["bool"]]],[11,"clone","","",10,[[["self"]],["workproductid"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"eq","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"ne","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",10,N],[11,"partial_cmp","","",10,[[["self"],["workproductid"]],["option",["ordering"]]]],[11,"lt","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"le","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"gt","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"ge","","",10,[[["self"],["workproductid"]],["bool"]]],[11,"cmp","","",10,[[["self"],["workproductid"]],["ordering"]]],[11,"hash","","",10,N],[11,"encode","","",10,[[["self"],["__s"]],["result"]]],[11,"decode","","",10,[[["__d"]],["result",["workproductid"]]]],[11,"from_cgu_name","","",10,[[["str"]],["workproductid"]]],[11,"from_fingerprint","","",10,[[["fingerprint"]],["workproductid"]]],[11,"hash_stable","","",10,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[0,"dep_tracking_map","","",N,N],[3,"DepTrackingMap","rustc::dep_graph::dep_tracking_map","A DepTrackingMap offers a subset of the `Map` API and ensures that we make calls to `read` and `write` as appropriate. We key the maps with a unique type for brevity.",N,N],[12,"phantom","","",8,N],[12,"graph","","",8,N],[12,"map","","",8,N],[8,"DepTrackingMapConfig","","",N,N],[16,"Key","","",27,N],[16,"Value","","",27,N],[10,"to_dep_kind","","",27,[[],["depkind"]]],[11,"new","rustc::dep_graph","",8,[[["depgraph"]],["deptrackingmap"]]],[0,"graph","","",N,N],[3,"DepGraph","rustc::dep_graph::graph","",N,N],[12,"data","","",11,N],[12,"fingerprints","","",11,N],[3,"DepNodeIndex","","",N,N],[12,"private","","",13,N],[3,"DepGraphData","","",N,N],[12,"current","","The new encoding of the dependency graph, optimized for red/green tracking. The `current` field is the dependency graph of only the current compilation session: We don't merge the previous dep-graph into current one anymore.",28,N],[12,"previous","","The dep-graph from the previous compilation session. It contains all nodes and edges as well as all fingerprints of nodes that have them.",28,N],[12,"colors","","",28,N],[12,"previous_work_products","","When we load, there may be `.o` files, cached mir, or other such things available to us. If we find that they are not dirty, we load the path to the file storing those work-products here into this map. We can later look for and extract that data.",28,N],[12,"dep_node_debug","","",28,N],[12,"loaded_from_cache","","",28,N],[3,"WorkProduct","","A \"work product\" is an intermediate result that we save into the incremental directory for later re-use. The primary example are the object files that we save for each partition at code generation time.",N,N],[12,"cgu_name","","",12,N],[12,"saved_files","","Saved files associated with this CGU",12,N],[3,"CurrentDepGraph","","",N,N],[12,"nodes","","",29,N],[12,"edges","","",29,N],[12,"node_to_node_index","","",29,N],[12,"forbidden_edge","","",29,N],[12,"anon_id_seed","","",29,N],[12,"total_read_count","","",29,N],[12,"total_duplicate_read_count","","",29,N],[3,"RegularOpenTask","","",N,N],[12,"node","","",30,N],[12,"reads","","",30,N],[12,"read_set","","",30,N],[3,"AnonOpenTask","","",N,N],[12,"reads","","",31,N],[12,"read_set","","",31,N],[3,"DepNodeColorMap","","",N,N],[12,"values","","",32,N],[4,"DepNodeColor","","",N,N],[13,"Red","","",21,N],[13,"Green","","",21,N],[4,"WorkProductFileKind","","",N,N],[13,"Object","","",23,N],[13,"Bytecode","","",23,N],[13,"BytecodeCompressed","","",23,N],[4,"OpenTask","","",N,N],[13,"Regular","","",22,N],[13,"Anon","","",22,N],[13,"Ignore","","",22,N],[13,"EvalAlways","","",22,N],[12,"node","rustc::dep_graph::graph::OpenTask","",22,N],[17,"COMPRESSED_NONE","rustc::dep_graph::graph","",N,N],[17,"COMPRESSED_RED","","",N,N],[17,"COMPRESSED_FIRST_GREEN","","",N,N],[11,"clone","rustc::dep_graph","",11,[[["self"]],["depgraph"]]],[11,"clone","","",13,[[["self"]],["depnodeindex"]]],[11,"eq","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"ne","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",13,N],[11,"hash","","",13,N],[11,"partial_cmp","","",13,[[["self"],["depnodeindex"]],["option",["ordering"]]]],[11,"lt","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"le","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"gt","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"ge","","",13,[[["self"],["depnodeindex"]],["bool"]]],[11,"cmp","","",13,[[["self"],["depnodeindex"]],["ordering"]]],[11,"decode","","",13,[[["__d"]],["result",["depnodeindex"]]]],[11,"encode","","",13,[[["self"],["__s"]],["result"]]],[18,"MAX_AS_U32","","",13,N],[18,"MAX","","",13,N],[11,"from_usize","","",13,[[["usize"]],["self"]]],[11,"from_u32","","",13,[[["u32"]],["self"]]],[11,"from_u32_const","","Hacky variant of `from_u32` for use in constants. This version checks the \"max\" constraint by using an invalid array dereference.",13,[[["u32"]],["self"]]],[11,"from_u32_unchecked","","",13,[[["u32"]],["self"]]],[11,"index","","Extract value of this index as an integer.",13,[[["self"]],["usize"]]],[11,"as_u32","","Extract value of this index as a usize.",13,[[["self"]],["u32"]]],[11,"as_usize","","Extract value of this index as a u32.",13,[[["self"]],["usize"]]],[11,"new","","",13,[[["usize"]],["self"]]],[11,"index","","",13,[[["self"]],["usize"]]],[11,"steps_between","","",13,[[["self"],["self"]],["option",["usize"]]]],[11,"replace_one","","",13,[[["self"]],["self"]]],[11,"replace_zero","","",13,[[["self"]],["self"]]],[11,"add_one","","",13,[[["self"]],["self"]]],[11,"sub_one","","",13,[[["self"]],["self"]]],[11,"add_usize","","",13,[[["self"],["usize"]],["option"]]],[11,"from","","",13,[[["usize"]],["self"]]],[11,"from","","",13,[[["u32"]],["self"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[18,"INVALID","","",13,N],[11,"clone","","",21,[[["self"]],["depnodecolor"]]],[11,"fmt","","",21,[[["self"],["formatter"]],["result"]]],[11,"eq","","",21,[[["self"],["depnodecolor"]],["bool"]]],[11,"ne","","",21,[[["self"],["depnodecolor"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",21,N],[11,"hash","","",21,N],[11,"is_green","","",21,[[["self"]],["bool"]]],[11,"new","","",11,[[["previousdepgraph"],["fxhashmap",["workproductid","workproduct"]]],["depgraph"]]],[11,"new_disabled","","",11,[[],["depgraph"]]],[11,"is_fully_enabled","","True if we are actually building the full dep-graph.",11,[[["self"]],["bool"]]],[11,"query","","",11,[[["self"]],["depgraphquery"]]],[11,"assert_ignored","","",11,[[["self"]]]],[11,"with_ignore","","",11,[[["self"],["op"]],["r"]]],[11,"with_task","","Starts a new dep-graph task. Dep-graph tasks are specified using a free function (`task`) and not a closure -- this is intentional because we want to exercise tight control over what state they have access to. In particular, we want to prevent implicit 'leaks' of tracked state into the task (which could then be read without generating correct edges in the dep-graph -- see the [rustc guide] for more details on the dep-graph). To this end, the task function gets exactly two pieces of state: the context `cx` and an argument `arg`. Both of these bits of state must be of some type that implements `DepGraphSafe` and hence does not leak.",11,N],[11,"input_task","","Creates a new dep-graph input with value `input`",11,N],[11,"with_task_impl","","",11,N],[11,"with_anon_task","","Execute something within an \"anonymous\" task, that is, a task the DepNode of which is determined by the list of inputs it read from.",11,N],[11,"with_eval_always_task","","Execute something within an \"eval-always\" task which is a task",11,N],[11,"read","","",11,[[["self"],["depnode"]]]],[11,"read_index","","",11,[[["self"],["depnodeindex"]]]],[11,"dep_node_index_of","","",11,[[["self"],["depnode"]],["depnodeindex"]]],[11,"dep_node_exists","","",11,[[["self"],["depnode"]],["bool"]]],[11,"fingerprint_of","","",11,[[["self"],["depnodeindex"]],["fingerprint"]]],[11,"prev_fingerprint_of","","",11,[[["self"],["depnode"]],["option",["fingerprint"]]]],[11,"prev_dep_node_index_of","","",11,[[["self"],["depnode"]],["serializeddepnodeindex"]]],[11,"previous_work_product","","Check whether a previous work product exists for `v` and, if so, return the path that leads to it. Used to skip doing work.",11,[[["self"],["workproductid"]],["option",["workproduct"]]]],[11,"previous_work_products","","Access the map of work-products created during the cached run. Only used during saving of the dep-graph.",11,[[["self"]],["fxhashmap"]]],[11,"register_dep_node_debug_str","","",11,[[["self"],["depnode"],["f"]]]],[11,"dep_node_debug_str","","",11,[[["self"],["depnode"]],["option",["string"]]]],[11,"edge_deduplication_data","","",11,N],[11,"serialize","","",11,[[["self"]],["serializeddepgraph"]]],[11,"node_color","","",11,[[["self"],["depnode"]],["option",["depnodecolor"]]]],[11,"try_mark_green","","",11,[[["self"],["tyctxt"],["depnode"]],["option",["depnodeindex"]]]],[11,"is_green","","",11,[[["self"],["depnode"]],["bool"]]],[11,"exec_cache_promotions","","",11,[[["self"],["tyctxt"]]]],[11,"mark_loaded_from_cache","","",11,[[["self"],["depnodeindex"],["bool"]]]],[11,"was_loaded_from_cache","","",11,[[["self"],["depnode"]],["option",["bool"]]]],[11,"clone","","",12,[[["self"]],["workproduct"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"encode","","",12,[[["self"],["__s"]],["result"]]],[11,"decode","","",12,[[["__d"]],["result",["workproduct"]]]],[11,"clone","","",23,[[["self"]],["workproductfilekind"]]],[11,"fmt","","",23,[[["self"],["formatter"]],["result"]]],[11,"encode","","",23,[[["self"],["__s"]],["result"]]],[11,"decode","","",23,[[["__d"]],["result",["workproductfilekind"]]]],[11,"eq","","",23,[[["self"],["workproductfilekind"]],["bool"]]],[11,"new","rustc::dep_graph::graph","",29,[[],["currentdepgraph"]]],[11,"complete_task","","",29,[[["self"],["depnode"],["opentask"]],["depnodeindex"]]],[11,"pop_anon_task","","",29,[[["self"],["depkind"],["opentask"]],["depnodeindex"]]],[11,"complete_eval_always_task","","",29,[[["self"],["depnode"],["opentask"]],["depnodeindex"]]],[11,"read_index","","",29,[[["self"],["depnodeindex"]]]],[11,"alloc_node","","",29,[[["self"],["depnode"],["smallvec"]],["depnodeindex"]]],[11,"new","","",32,[[["usize"]],["depnodecolormap"]]],[11,"get","","",32,[[["self"],["serializeddepnodeindex"]],["option",["depnodecolor"]]]],[11,"insert","","",32,[[["self"],["serializeddepnodeindex"],["depnodecolor"]]]],[0,"prev","rustc::dep_graph","",N,N],[3,"PreviousDepGraph","rustc::dep_graph::prev","",N,N],[12,"data","","",14,N],[12,"index","","",14,N],[11,"fmt","rustc::dep_graph","",14,[[["self"],["formatter"]],["result"]]],[11,"encode","","",14,[[["self"],["__s"]],["result"]]],[11,"decode","","",14,[[["__d"]],["result",["previousdepgraph"]]]],[11,"new","","",14,[[["serializeddepgraph"]],["previousdepgraph"]]],[11,"edges_from","","",14,[[["self"],["depnode"]],["option"]]],[11,"index_to_node","","",14,[[["self"],["serializeddepnodeindex"]],["depnode"]]],[11,"node_to_index","","",14,[[["self"],["depnode"]],["serializeddepnodeindex"]]],[11,"node_to_index_opt","","",14,[[["self"],["depnode"]],["option",["serializeddepnodeindex"]]]],[11,"fingerprint_of","","",14,[[["self"],["depnode"]],["option",["fingerprint"]]]],[11,"fingerprint_by_index","","",14,[[["self"],["serializeddepnodeindex"]],["fingerprint"]]],[11,"node_count","","",14,[[["self"]],["usize"]]],[0,"query","","",N,N],[3,"DepGraphQuery","rustc::dep_graph::query","",N,N],[12,"graph","","",15,N],[12,"indices","","",15,N],[11,"new","rustc::dep_graph","",15,N],[11,"contains_node","","",15,[[["self"],["depnode"]],["bool"]]],[11,"nodes","","",15,[[["self"]],["vec",["depnode"]]]],[11,"edges","","",15,[[["self"]],["vec"]]],[11,"reachable_nodes","","",15,[[["self"],["depnode"],["direction"]],["vec",["depnode"]]]],[11,"transitive_successors","","All nodes reachable from `node`. In other words, things that will have to be recomputed if `node` changes.",15,[[["self"],["depnode"]],["vec",["depnode"]]]],[11,"transitive_predecessors","","All nodes that can reach `node`.",15,[[["self"],["depnode"]],["vec",["depnode"]]]],[11,"immediate_successors","","Just the outgoing edges from `node`.",15,[[["self"],["depnode"]],["vec",["depnode"]]]],[0,"safe","","The `DepGraphSafe` trait",N,N],[3,"AssertDepGraphSafe","rustc::dep_graph::safe","A convenient override that lets you pass arbitrary state into a task. Every use should be accompanied by a comment explaining why it makes sense (or how it could be refactored away in the future).",N,N],[12,"0","","",16,N],[8,"DepGraphSafe","","The `DepGraphSafe` trait is used to specify what kinds of values are safe to \"leak\" into a task. The idea is that this should be only be implemented for things like the tcx as well as various id types, which will create reads in the dep-graph whenever the trait loads anything that might depend on the input program.",N,N],[0,"serialized","rustc::dep_graph","The data that we will serialize and deserialize.",N,N],[3,"SerializedDepNodeIndex","rustc::dep_graph::serialized","",N,N],[12,"private","","",18,N],[3,"SerializedDepGraph","","Data for use when recompiling the current crate.",N,N],[12,"nodes","","The set of all DepNodes in the graph",17,N],[12,"fingerprints","","The set of all Fingerprints in the graph. Each Fingerprint corresponds to the DepNode at the same index in the nodes vector.",17,N],[12,"edge_list_indices","","For each DepNode, stores the list of edges originating from that DepNode. Encoded as a [start, end) pair indexing into edge_list_data, which holds the actual DepNodeIndices of the target nodes.",17,N],[12,"edge_list_data","","A flattened list of all edge targets in the graph. Edge sources are implicit in edge_list_indices.",17,N],[11,"clone","rustc::dep_graph","",18,[[["self"]],["serializeddepnodeindex"]]],[11,"eq","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"ne","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",18,N],[11,"hash","","",18,N],[11,"partial_cmp","","",18,[[["self"],["serializeddepnodeindex"]],["option",["ordering"]]]],[11,"lt","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"le","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"gt","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"ge","","",18,[[["self"],["serializeddepnodeindex"]],["bool"]]],[11,"cmp","","",18,[[["self"],["serializeddepnodeindex"]],["ordering"]]],[11,"decode","","",18,[[["__d"]],["result",["serializeddepnodeindex"]]]],[11,"encode","","",18,[[["self"],["__s"]],["result"]]],[18,"MAX_AS_U32","","",18,N],[18,"MAX","","",18,N],[11,"from_usize","","",18,[[["usize"]],["self"]]],[11,"from_u32","","",18,[[["u32"]],["self"]]],[11,"from_u32_const","","Hacky variant of `from_u32` for use in constants. This version checks the \"max\" constraint by using an invalid array dereference.",18,[[["u32"]],["self"]]],[11,"from_u32_unchecked","","",18,[[["u32"]],["self"]]],[11,"index","","Extract value of this index as an integer.",18,[[["self"]],["usize"]]],[11,"as_u32","","Extract value of this index as a usize.",18,[[["self"]],["u32"]]],[11,"as_usize","","Extract value of this index as a u32.",18,[[["self"]],["usize"]]],[11,"new","","",18,[[["usize"]],["self"]]],[11,"index","","",18,[[["self"]],["usize"]]],[11,"steps_between","","",18,[[["self"],["self"]],["option",["usize"]]]],[11,"replace_one","","",18,[[["self"]],["self"]]],[11,"replace_zero","","",18,[[["self"]],["self"]]],[11,"add_one","","",18,[[["self"]],["self"]]],[11,"sub_one","","",18,[[["self"]],["self"]]],[11,"add_usize","","",18,[[["self"],["usize"]],["option"]]],[11,"from","","",18,[[["usize"]],["self"]]],[11,"from","","",18,[[["u32"]],["self"]]],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",17,[[["self"],["formatter"]],["result"]]],[11,"encode","","",17,[[["self"],["__s"]],["result"]]],[11,"decode","","",17,[[["__d"]],["result",["serializeddepgraph"]]]],[11,"new","","",17,[[],["serializeddepgraph"]]],[11,"edge_targets_from","","",17,N],[0,"label_strs","","Contains variant => str representations for constructing DepNode groups for tests.",N,N],[17,"Null","rustc::dep_graph::label_strs","",N,N],[17,"Krate","","",N,N],[17,"HirBody","","",N,N],[17,"Hir","","",N,N],[17,"CrateMetadata","","",N,N],[17,"RegionScopeTree","","",N,N],[17,"Coherence","","",N,N],[17,"CoherenceInherentImplOverlapCheck","","",N,N],[17,"CoherenceCheckTrait","","",N,N],[17,"PrivacyAccessLevels","","",N,N],[17,"MirConstQualif","","",N,N],[17,"MirBuilt","","",N,N],[17,"MirConst","","",N,N],[17,"MirValidated","","",N,N],[17,"MirOptimized","","",N,N],[17,"MirShim","","",N,N],[17,"BorrowCheckKrate","","",N,N],[17,"BorrowCheck","","",N,N],[17,"MirBorrowCheck","","",N,N],[17,"UnsafetyCheckResult","","",N,N],[17,"UnsafeDeriveOnReprPacked","","",N,N],[17,"Reachability","","",N,N],[17,"MirKeys","","",N,N],[17,"CrateVariances","","",N,N],[17,"AssociatedItems","","",N,N],[17,"TypeOfItem","","",N,N],[17,"GenericsOfItem","","",N,N],[17,"PredicatesOfItem","","",N,N],[17,"ExplicitPredicatesOfItem","","",N,N],[17,"PredicatesDefinedOnItem","","",N,N],[17,"InferredOutlivesOf","","",N,N],[17,"InferredOutlivesCrate","","",N,N],[17,"SuperPredicatesOfItem","","",N,N],[17,"TraitDefOfItem","","",N,N],[17,"AdtDefOfItem","","",N,N],[17,"ImplTraitRef","","",N,N],[17,"ImplPolarity","","",N,N],[17,"FnSignature","","",N,N],[17,"CoerceUnsizedInfo","","",N,N],[17,"ItemVarianceConstraints","","",N,N],[17,"ItemVariances","","",N,N],[17,"IsConstFn","","",N,N],[17,"IsForeignItem","","",N,N],[17,"TypeParamPredicates","","",N,N],[17,"SizedConstraint","","",N,N],[17,"DtorckConstraint","","",N,N],[17,"AdtDestructor","","",N,N],[17,"AssociatedItemDefIds","","",N,N],[17,"InherentImpls","","",N,N],[17,"TypeckBodiesKrate","","",N,N],[17,"TypeckTables","","",N,N],[17,"UsedTraitImports","","",N,N],[17,"HasTypeckTables","","",N,N],[17,"ConstEval","","",N,N],[17,"CheckMatch","","",N,N],[17,"SymbolName","","",N,N],[17,"InstanceSymbolName","","",N,N],[17,"SpecializationGraph","","",N,N],[17,"ObjectSafety","","",N,N],[17,"FulfillObligation","","",N,N],[17,"VtableMethods","","",N,N],[17,"IsCopy","","",N,N],[17,"IsSized","","",N,N],[17,"IsFreeze","","",N,N],[17,"NeedsDrop","","",N,N],[17,"Layout","","",N,N],[17,"TraitImpls","","",N,N],[17,"AllLocalTraitImpls","","",N,N],[17,"TraitSelect","","",N,N],[17,"ParamEnv","","",N,N],[17,"DescribeDef","","",N,N],[17,"DefSpan","","",N,N],[17,"LookupStability","","",N,N],[17,"LookupDeprecationEntry","","",N,N],[17,"ConstIsRvaluePromotableToStatic","","",N,N],[17,"RvaluePromotableMap","","",N,N],[17,"ImplParent","","",N,N],[17,"TraitOfItem","","",N,N],[17,"IsReachableNonGeneric","","",N,N],[17,"IsUnreachableLocalDefinition","","",N,N],[17,"IsMirAvailable","","",N,N],[17,"ItemAttrs","","",N,N],[17,"CodegenFnAttrs","","",N,N],[17,"FnArgNames","","",N,N],[17,"RenderedConst","","",N,N],[17,"DylibDepFormats","","",N,N],[17,"IsPanicRuntime","","",N,N],[17,"IsCompilerBuiltins","","",N,N],[17,"HasGlobalAllocator","","",N,N],[17,"HasPanicHandler","","",N,N],[17,"ExternCrate","","",N,N],[17,"LintLevels","","",N,N],[17,"Specializes","","",N,N],[17,"InScopeTraits","","",N,N],[17,"ModuleExports","","",N,N],[17,"IsSanitizerRuntime","","",N,N],[17,"IsProfilerRuntime","","",N,N],[17,"GetPanicStrategy","","",N,N],[17,"IsNoBuiltins","","",N,N],[17,"ImplDefaultness","","",N,N],[17,"CheckItemWellFormed","","",N,N],[17,"CheckTraitItemWellFormed","","",N,N],[17,"CheckImplItemWellFormed","","",N,N],[17,"ReachableNonGenerics","","",N,N],[17,"NativeLibraries","","",N,N],[17,"PluginRegistrarFn","","",N,N],[17,"DeriveRegistrarFn","","",N,N],[17,"CrateDisambiguator","","",N,N],[17,"CrateHash","","",N,N],[17,"OriginalCrateName","","",N,N],[17,"ExtraFileName","","",N,N],[17,"ImplementationsOfTrait","","",N,N],[17,"AllTraitImplementations","","",N,N],[17,"DllimportForeignItems","","",N,N],[17,"IsDllimportForeignItem","","",N,N],[17,"IsStaticallyIncludedForeignItem","","",N,N],[17,"NativeLibraryKind","","",N,N],[17,"LinkArgs","","",N,N],[17,"ResolveLifetimes","","",N,N],[17,"NamedRegion","","",N,N],[17,"IsLateBound","","",N,N],[17,"ObjectLifetimeDefaults","","",N,N],[17,"Visibility","","",N,N],[17,"DepKind","","",N,N],[17,"CrateName","","",N,N],[17,"ItemChildren","","",N,N],[17,"ExternModStmtCnum","","",N,N],[17,"GetLibFeatures","","",N,N],[17,"DefinedLibFeatures","","",N,N],[17,"GetLangItems","","",N,N],[17,"DefinedLangItems","","",N,N],[17,"MissingLangItems","","",N,N],[17,"VisibleParentMap","","",N,N],[17,"MissingExternCrateItem","","",N,N],[17,"UsedCrateSource","","",N,N],[17,"PostorderCnums","","",N,N],[17,"EraseRegionsTy","","",N,N],[17,"Freevars","","",N,N],[17,"MaybeUnusedTraitImport","","",N,N],[17,"MaybeUnusedExternCrates","","",N,N],[17,"StabilityIndex","","",N,N],[17,"AllTraits","","",N,N],[17,"AllCrateNums","","",N,N],[17,"ExportedSymbols","","",N,N],[17,"CollectAndPartitionMonoItems","","",N,N],[17,"IsCodegenedItem","","",N,N],[17,"CodegenUnit","","",N,N],[17,"CompileCodegenUnit","","",N,N],[17,"OutputFilenames","","",N,N],[17,"NormalizeProjectionTy","","",N,N],[17,"NormalizeTyAfterErasingRegions","","",N,N],[17,"ImpliedOutlivesBounds","","",N,N],[17,"DropckOutlives","","",N,N],[17,"EvaluateObligation","","",N,N],[17,"TypeOpEq","","",N,N],[17,"TypeOpSubtype","","",N,N],[17,"TypeOpProvePredicate","","",N,N],[17,"TypeOpNormalizeTy","","",N,N],[17,"TypeOpNormalizePredicate","","",N,N],[17,"TypeOpNormalizePolyFnSig","","",N,N],[17,"TypeOpNormalizeFnSig","","",N,N],[17,"SubstituteNormalizeAndTestPredicates","","",N,N],[17,"TargetFeaturesWhitelist","","",N,N],[17,"InstanceDefSizeEstimate","","",N,N],[17,"Features","","",N,N],[17,"ProgramClausesFor","","",N,N],[17,"ProgramClausesForEnv","","",N,N],[17,"WasmImportModuleMap","","",N,N],[17,"ForeignModules","","",N,N],[17,"UpstreamMonomorphizations","","",N,N],[17,"UpstreamMonomorphizationsFor","","",N,N],[8,"DepTrackingMapConfig","rustc::dep_graph","",N,N],[16,"Key","","",27,N],[16,"Value","","",27,N],[10,"to_dep_kind","","",27,[[],["depkind"]]],[8,"DepGraphSafe","","The `DepGraphSafe` trait is used to specify what kinds of values are safe to \"leak\" into a task. The idea is that this should be only be implemented for things like the tcx as well as various id types, which will create reads in the dep-graph whenever the trait loads anything that might depend on the input program.",N,N],[0,"hir","rustc","",N,N],[3,"HirId","rustc::hir","A HirId uniquely identifies a node in the HIR of the current crate. It is composed of the `owner`, which is the DefIndex of the directly enclosing hir::Item, hir::TraitItem, or hir::ImplItem (i.e. the closest \"item-like\"), and the `local_id` which is unique within the given owner.",N,N],[12,"owner","","",33,N],[12,"local_id","","",33,N],[3,"ItemLocalId","","An `ItemLocalId` uniquely identifies something within a given \"item-like\", that is within a hir::Item, hir::TraitItem, or hir::ImplItem. There is no guarantee that the numerical value of a given `ItemLocalId` corresponds to the node's position within the owning item in any way, but there is a guarantee that the `LocalItemId`s within an owner occupy a dense range of integers starting at zero, so a mapping that maps all or most nodes within an \"item-like\" to something else can be implement by a `Vec` instead of a tree or hash map.",N,N],[12,"0","","",34,N],[3,"Label","","",N,N],[12,"ident","","",35,N],[3,"Lifetime","","",N,N],[12,"id","","",36,N],[12,"span","","",36,N],[12,"name","","Either \"'a\", referring to a named lifetime definition, or \"\" (aka keywords::Invalid), for elision placeholders.",36,N],[3,"Path","","A \"Path\" is essentially Rust's notion of a name; for instance: `std::cmp::PartialEq`. It's represented as a sequence of identifiers, along with a bunch of supporting information.",N,N],[12,"span","","",37,N],[12,"def","","The definition that the path resolved to.",37,N],[12,"segments","","The segments in the path: the things separated by `::`.",37,N],[3,"PathSegment","","A segment of a path: an identifier, an optional lifetime, and a set of types.",N,N],[12,"ident","","The identifier portion of this path segment.",38,N],[12,"args","","Type/lifetime parameters attached to this path. They come in two flavors: `Path<A,B,C>` and `Path(A,B) -> C`. Note that this is more than just simple syntactic sugar; the use of parens affects the region binding rules, so we preserve the distinction.",38,N],[12,"infer_types","","Whether to infer remaining type parameters, if any. This only applies to expression and pattern paths, and out of those only the segments with no type parameters to begin with, e.g. `Vec::new` is `<Vec<..>>::new::<..>`.",38,N],[3,"GenericArgs","","",N,N],[12,"args","","The generic arguments for this path segment.",39,N],[12,"bindings","","Bindings (equality constraints) on associated types, if present. E.g., `Foo<A=Bar>`.",39,N],[12,"parenthesized","","Were arguments written in parenthesized form `Fn(T) -> U`? This is required mostly for pretty-printing and diagnostics, but also for changing lifetime elision rules to be \"function-like\".",39,N],[3,"GenericParam","","",N,N],[12,"id","","",40,N],[12,"name","","",40,N],[12,"attrs","","",40,N],[12,"bounds","","",40,N],[12,"span","","",40,N],[12,"pure_wrt_drop","","",40,N],[12,"kind","","",40,N],[3,"GenericParamCount","","",N,N],[12,"lifetimes","","",41,N],[12,"types","","",41,N],[3,"Generics","","Represents lifetimes and type parameters attached to a declaration of a function, enum, trait, etc.",N,N],[12,"params","","",42,N],[12,"where_clause","","",42,N],[12,"span","","",42,N],[3,"WhereClause","","A `where` clause in a definition",N,N],[12,"id","","",43,N],[12,"predicates","","",43,N],[3,"WhereBoundPredicate","","A type bound, eg `for<'c> Foo: Send+Clone+'c`",N,N],[12,"span","","",44,N],[12,"bound_generic_params","","Any generics from a `for` binding",44,N],[12,"bounded_ty","","The type being bounded",44,N],[12,"bounds","","Trait and lifetime bounds (`Clone+Send+'static`)",44,N],[3,"WhereRegionPredicate","","A lifetime predicate, e.g. `'a: 'b+'c`",N,N],[12,"span","","",45,N],[12,"lifetime","","",45,N],[12,"bounds","","",45,N],[3,"WhereEqPredicate","","An equality predicate (unsupported), e.g. `T=int`",N,N],[12,"id","","",46,N],[12,"span","","",46,N],[12,"lhs_ty","","",46,N],[12,"rhs_ty","","",46,N],[3,"Crate","","The top-level data structure that stores the entire contents of the crate currently being compiled.",N,N],[12,"module","","",47,N],[12,"attrs","","",47,N],[12,"span","","",47,N],[12,"exported_macros","","",47,N],[12,"items","","",47,N],[12,"trait_items","","",47,N],[12,"impl_items","","",47,N],[12,"bodies","","",47,N],[12,"trait_impls","","",47,N],[12,"trait_auto_impl","","",47,N],[12,"body_ids","","A list of the body ids written out in the order in which they appear in the crate. If you're going to process all the bodies in the crate, you should iterate over this list rather than the keys of bodies.",47,N],[3,"MacroDef","","A macro definition, in this crate or imported from another.",N,N],[12,"name","","",48,N],[12,"vis","","",48,N],[12,"attrs","","",48,N],[12,"id","","",48,N],[12,"span","","",48,N],[12,"body","","",48,N],[12,"legacy","","",48,N],[3,"Block","","",N,N],[12,"stmts","","Statements in a block",49,N],[12,"expr","","An expression at the end of the block without a semicolon, if any",49,N],[12,"id","","",49,N],[12,"hir_id","","",49,N],[12,"rules","","Distinguishes between `unsafe { ... }` and `{ ... }`",49,N],[12,"span","","",49,N],[12,"targeted_by_break","","If true, then there may exist `break 'a` values that aim to break out of this block early. Used by `'label: {}` blocks and by `catch` statements.",49,N],[12,"recovered","","If true, don't emit return value type errors as the parser had to recover from a parse error so this block will not have an appropriate type. A parse error will have been emitted so the compilation will never succeed if this is true.",49,N],[3,"Pat","","",N,N],[12,"id","","",50,N],[12,"hir_id","","",50,N],[12,"node","","",50,N],[12,"span","","",50,N],[3,"FieldPat","","A single field in a struct pattern",N,N],[12,"id","","",51,N],[12,"ident","","The identifier for the field",51,N],[12,"pat","","The pattern the field is destructured to",51,N],[12,"is_shorthand","","",51,N],[3,"Local","","Local represents a `let` statement, e.g., `let <pat>:<ty> = <expr>;`",N,N],[12,"pat","","",52,N],[12,"ty","","",52,N],[12,"init","","Initializer expression to set the value, if any",52,N],[12,"id","","",52,N],[12,"hir_id","","",52,N],[12,"span","","",52,N],[12,"attrs","","",52,N],[12,"source","","",52,N],[3,"Arm","","represents one arm of a 'match'",N,N],[12,"attrs","","",53,N],[12,"pats","","",53,N],[12,"guard","","",53,N],[12,"body","","",53,N],[3,"Field","","",N,N],[12,"id","","",54,N],[12,"ident","","",54,N],[12,"expr","","",54,N],[12,"span","","",54,N],[12,"is_shorthand","","",54,N],[3,"BodyId","","",N,N],[12,"node_id","","",55,N],[3,"Body","","The body of a function, closure, or constant value. In the case of a function, the body contains not only the function body itself (which is an expression), but also the argument patterns, since those are something that the caller doesn't really care about.",N,N],[12,"arguments","","",56,N],[12,"value","","",56,N],[12,"is_generator","","",56,N],[3,"AnonConst","","A constant (expression) that's not an item or associated item, but needs its own `DefId` for type-checking, const-eval, etc. These are usually found nested inside types (e.g. array lengths) or expressions (e.g. repeat counts), and also used to define explicit discriminant values for enum variants.",N,N],[12,"id","","",57,N],[12,"hir_id","","",57,N],[12,"body","","",57,N],[3,"Expr","","An expression",N,N],[12,"id","","",58,N],[12,"span","","",58,N],[12,"node","","",58,N],[12,"attrs","","",58,N],[12,"hir_id","","",58,N],[3,"Destination","","",N,N],[12,"label","","",59,N],[12,"target_id","","",59,N],[3,"MutTy","","",N,N],[12,"ty","","",60,N],[12,"mutbl","","",60,N],[3,"MethodSig","","Represents a method's signature in a trait declaration or implementation.",N,N],[12,"header","","",61,N],[12,"decl","","",61,N],[3,"TraitItemId","","",N,N],[12,"node_id","","",62,N],[3,"TraitItem","","Represents an item declaration within a trait declaration, possibly including a default implementation. A trait item is either required (meaning it doesn't have an implementation, just a signature) or provided (meaning it has a default implementation).",N,N],[12,"id","","",63,N],[12,"ident","","",63,N],[12,"hir_id","","",63,N],[12,"attrs","","",63,N],[12,"generics","","",63,N],[12,"node","","",63,N],[12,"span","","",63,N],[3,"ImplItemId","","",N,N],[12,"node_id","","",64,N],[3,"ImplItem","","Represents anything within an `impl` block",N,N],[12,"id","","",65,N],[12,"ident","","",65,N],[12,"hir_id","","",65,N],[12,"vis","","",65,N],[12,"defaultness","","",65,N],[12,"attrs","","",65,N],[12,"generics","","",65,N],[12,"node","","",65,N],[12,"span","","",65,N],[3,"TypeBinding","","",N,N],[12,"id","","",66,N],[12,"ident","","",66,N],[12,"ty","","",66,N],[12,"span","","",66,N],[3,"Ty","","",N,N],[12,"id","","",67,N],[12,"node","","",67,N],[12,"span","","",67,N],[12,"hir_id","","",67,N],[3,"BareFnTy","","",N,N],[12,"unsafety","","",68,N],[12,"abi","","",68,N],[12,"generic_params","","",68,N],[12,"decl","","",68,N],[12,"arg_names","","",68,N],[3,"ExistTy","","",N,N],[12,"generics","","",69,N],[12,"bounds","","",69,N],[12,"impl_trait_fn","","",69,N],[3,"InlineAsmOutput","","",N,N],[12,"constraint","","",70,N],[12,"is_rw","","",70,N],[12,"is_indirect","","",70,N],[3,"InlineAsm","","",N,N],[12,"asm","","",71,N],[12,"asm_str_style","","",71,N],[12,"outputs","","",71,N],[12,"inputs","","",71,N],[12,"clobbers","","",71,N],[12,"volatile","","",71,N],[12,"alignstack","","",71,N],[12,"dialect","","",71,N],[12,"ctxt","","",71,N],[3,"Arg","","represents an argument in a function header",N,N],[12,"pat","","",72,N],[12,"id","","",72,N],[12,"hir_id","","",72,N],[3,"FnDecl","","Represents the header (not the body) of a function declaration",N,N],[12,"inputs","","",73,N],[12,"output","","",73,N],[12,"variadic","","",73,N],[12,"has_implicit_self","","True if this function has an `self`, `&self` or `&mut self` receiver (but not a `self: Xxx` one).",73,N],[3,"Mod","","",N,N],[12,"inner","","A span from the first token past `{` to the last token until `}`. For `mod foo;`, the inner span ranges from the first token to the last token in the external file.",74,N],[12,"item_ids","","",74,N],[3,"ForeignMod","","",N,N],[12,"abi","","",75,N],[12,"items","","",75,N],[3,"GlobalAsm","","",N,N],[12,"asm","","",76,N],[12,"ctxt","","",76,N],[3,"EnumDef","","",N,N],[12,"variants","","",77,N],[3,"VariantKind","","",N,N],[12,"name","","",78,N],[12,"attrs","","",78,N],[12,"data","","",78,N],[12,"disr_expr","","Explicit discriminant, eg `Foo = 1`",78,N],[3,"TraitRef","","TraitRef's appear in impls.",N,N],[12,"path","","",79,N],[12,"ref_id","","",79,N],[12,"hir_ref_id","","",79,N],[3,"PolyTraitRef","","",N,N],[12,"bound_generic_params","","The `'a` in `<'a> Foo<&'a T>`",80,N],[12,"trait_ref","","The `Foo<&'a T>` in `<'a> Foo<&'a T>`",80,N],[12,"span","","",80,N],[3,"StructField","","",N,N],[12,"span","","",81,N],[12,"ident","","",81,N],[12,"vis","","",81,N],[12,"id","","",81,N],[12,"ty","","",81,N],[12,"attrs","","",81,N],[3,"ItemId","","",N,N],[12,"id","","",82,N],[3,"Item","","An item",N,N],[12,"name","","",83,N],[12,"id","","",83,N],[12,"hir_id","","",83,N],[12,"attrs","","",83,N],[12,"node","","",83,N],[12,"vis","","",83,N],[12,"span","","",83,N],[3,"FnHeader","","",N,N],[12,"unsafety","","",84,N],[12,"constness","","",84,N],[12,"asyncness","","",84,N],[12,"abi","","",84,N],[3,"TraitItemRef","","A reference from an trait to one of its associated items. This contains the item's id, naturally, but also the item's name and some other high-level details (like whether it is an associated type or method, and whether it is public). This allows other passes to find the impl they want without loading the id (which means fewer edges in the incremental compilation graph).",N,N],[12,"id","","",85,N],[12,"ident","","",85,N],[12,"kind","","",85,N],[12,"span","","",85,N],[12,"defaultness","","",85,N],[3,"ImplItemRef","","A reference from an impl to one of its associated items. This contains the item's id, naturally, but also the item's name and some other high-level details (like whether it is an associated type or method, and whether it is public). This allows other passes to find the impl they want without loading the id (which means fewer edges in the incremental compilation graph).",N,N],[12,"id","","",86,N],[12,"ident","","",86,N],[12,"kind","","",86,N],[12,"span","","",86,N],[12,"vis","","",86,N],[12,"defaultness","","",86,N],[3,"ForeignItem","","",N,N],[12,"name","","",87,N],[12,"attrs","","",87,N],[12,"node","","",87,N],[12,"id","","",87,N],[12,"span","","",87,N],[12,"vis","","",87,N],[3,"Freevar","","A free variable referred to in a function.",N,N],[12,"def","","The variable being accessed free.",88,N],[12,"span","","",88,N],[3,"TraitCandidate","","",N,N],[12,"def_id","","",89,N],[12,"import_id","","",89,N],[3,"CodegenFnAttrs","","",N,N],[12,"flags","","",90,N],[12,"inline","","Parsed representation of the `#[inline]` attribute",90,N],[12,"export_name","","The `#[export_name = \"...\"]` attribute, indicating a custom symbol a function should be exported under",90,N],[12,"link_name","","The `#[link_name = \"...\"]` attribute, indicating a custom symbol an imported function should be imported as. Note that `export_name` probably isn't set when this is set, this is for foreign items while `#[export_name]` is for Rust-defined functions.",90,N],[12,"target_features","","The `#[target_feature(enable = \"...\")]` attribute and the enabled features (only enabled features are supported right now).",90,N],[12,"linkage","","The `#[linkage = \"...\"]` attribute and the value we found.",90,N],[12,"link_section","","The `#[link_section = \"...\"]` attribute, or what executable section this should be placed in.",90,N],[3,"CodegenFnAttrFlags","","",N,N],[12,"bits","","",91,N],[4,"ParamName","","",N,N],[13,"Plain","","Some user-given name like `T` or `'x`.",92,N],[13,"Fresh","","Synthetic name generated when user elided a lifetime in an impl header, e.g. the lifetimes in cases like these:",92,N],[4,"LifetimeName","","",N,N],[13,"Param","","User-given names or fresh (synthetic) names.",93,N],[13,"Implicit","","User typed nothing. e.g. the lifetime in `&u32`.",93,N],[13,"Underscore","","User typed `'_`.",93,N],[13,"Static","","User wrote `'static`",93,N],[4,"GenericArg","","",N,N],[13,"Lifetime","","",94,N],[13,"Type","","",94,N],[4,"TraitBoundModifier","","A modifier on a bound, currently this is only used for `?Sized`, where the modifier is `Maybe`. Negative bounds should also be handled here.",N,N],[13,"None","","",95,N],[13,"Maybe","","",95,N],[4,"GenericBound","","The AST represents all type param bounds as types. typeck::collect::compute_bounds matches these against the \"special\" built-in traits (see middle::lang_items) and detects Copy, Send and Sync.",N,N],[13,"Trait","","",96,N],[13,"Outlives","","",96,N],[4,"GenericParamKind","","",N,N],[13,"Lifetime","","A lifetime definition, eg `'a: 'b + 'c + 'd`.",97,N],[12,"in_band","rustc::hir::GenericParamKind","",97,N],[13,"Type","rustc::hir","",97,N],[12,"default","rustc::hir::GenericParamKind","",97,N],[12,"synthetic","","",97,N],[4,"SyntheticTyParamKind","rustc::hir","Synthetic Type Parameters are converted to an other form during lowering, this allows to track the original form they had. Useful for error messages.",N,N],[13,"ImplTrait","","",98,N],[4,"WherePredicate","","A single predicate in a `where` clause",N,N],[13,"BoundPredicate","","A type binding, eg `for<'c> Foo: Send+Clone+'c`",99,N],[13,"RegionPredicate","","A lifetime predicate, e.g. `'a: 'b+'c`",99,N],[13,"EqPredicate","","An equality predicate (unsupported)",99,N],[4,"BindingAnnotation","","Explicit binding annotations given in the HIR for a binding. Note that this is not the final binding mode that we infer after type inference.",N,N],[13,"Unannotated","","No binding annotation given: this means that the final binding mode will depend on whether we have skipped through a `&` reference when matching. For example, the `x` in `Some(x)` will have binding mode `None`; if you do `let Some(x) = &Some(22)`, it will ultimately be inferred to be by-reference.",100,N],[13,"Mutable","","Annotated with `mut x` -- could be either ref or not, similar to `None`.",100,N],[13,"Ref","","Annotated as `ref`, like `ref x`",100,N],[13,"RefMut","","Annotated as `ref mut x`.",100,N],[4,"RangeEnd","","",N,N],[13,"Included","","",101,N],[13,"Excluded","","",101,N],[4,"PatKind","","",N,N],[13,"Wild","","Represents a wildcard pattern (`_`)",102,N],[13,"Binding","","A fresh binding `ref mut binding @ OPT_SUBPATTERN`. The `NodeId` is the canonical ID for the variable being bound, e.g. in `Ok(x) | Err(x)`, both `x` use the same canonical ID, which is the pattern ID of the first `x`.",102,N],[13,"Struct","","A struct or struct variant pattern, e.g. `Variant {x, y, ..}`. The `bool` is `true` in the presence of a `..`.",102,N],[13,"TupleStruct","","A tuple struct/variant pattern `Variant(x, y, .., z)`. If the `..` pattern fragment is present, then `Option<usize>` denotes its position. 0 <= position <= subpats.len()",102,N],[13,"Path","","A path pattern for an unit struct/variant or a (maybe-associated) constant.",102,N],[13,"Tuple","","A tuple pattern `(a, b)`. If the `..` pattern fragment is present, then `Option<usize>` denotes its position. 0 <= position <= subpats.len()",102,N],[13,"Box","","A `box` pattern",102,N],[13,"Ref","","A reference pattern, e.g. `&mut (a, b)`",102,N],[13,"Lit","","A literal",102,N],[13,"Range","","A range pattern, e.g. `1...2` or `1..2`",102,N],[13,"Slice","","`[a, b, ..i, y, z]` is represented as: `PatKind::Slice(box [a, b], Some(i), box [y, z])`",102,N],[4,"Mutability","","",N,N],[13,"MutMutable","","",103,N],[13,"MutImmutable","","",103,N],[4,"BinOpKind","","",N,N],[13,"Add","","The `+` operator (addition)",104,N],[13,"Sub","","The `-` operator (subtraction)",104,N],[13,"Mul","","The `*` operator (multiplication)",104,N],[13,"Div","","The `/` operator (division)",104,N],[13,"Rem","","The `%` operator (modulus)",104,N],[13,"And","","The `&&` operator (logical and)",104,N],[13,"Or","","The `||` operator (logical or)",104,N],[13,"BitXor","","The `^` operator (bitwise xor)",104,N],[13,"BitAnd","","The `&` operator (bitwise and)",104,N],[13,"BitOr","","The `|` operator (bitwise or)",104,N],[13,"Shl","","The `<<` operator (shift left)",104,N],[13,"Shr","","The `>>` operator (shift right)",104,N],[13,"Eq","","The `==` operator (equality)",104,N],[13,"Lt","","The `<` operator (less than)",104,N],[13,"Le","","The `<=` operator (less than or equal to)",104,N],[13,"Ne","","The `!=` operator (not equal to)",104,N],[13,"Ge","","The `>=` operator (greater than or equal to)",104,N],[13,"Gt","","The `>` operator (greater than)",104,N],[4,"UnOp","","",N,N],[13,"UnDeref","","The `*` operator for dereferencing",105,N],[13,"UnNot","","The `!` operator for logical inversion",105,N],[13,"UnNeg","","The `-` operator for negation",105,N],[4,"StmtKind","","",N,N],[13,"Decl","","Could be an item or a local (let) binding:",106,N],[13,"Expr","","Expr without trailing semi-colon (must have unit type):",106,N],[13,"Semi","","Expr with trailing semi-colon (may have any type):",106,N],[4,"DeclKind","","",N,N],[13,"Local","","A local (let) binding:",107,N],[13,"Item","","An item binding:",107,N],[4,"Guard","","",N,N],[13,"If","","",108,N],[4,"BlockCheckMode","","",N,N],[13,"DefaultBlock","","",109,N],[13,"UnsafeBlock","","",109,N],[13,"PushUnsafeBlock","","",109,N],[13,"PopUnsafeBlock","","",109,N],[4,"UnsafeSource","","",N,N],[13,"CompilerGenerated","","",110,N],[13,"UserProvided","","",110,N],[4,"BodyOwnerKind","","",N,N],[13,"Fn","","Functions and methods.",111,N],[13,"Const","","Constants and associated constants.",111,N],[13,"Static","","Initializer of a `static` item.",111,N],[4,"ExprKind","","",N,N],[13,"Box","","A `box x` expression.",112,N],[13,"Array","","An array (`[a, b, c, d]`)",112,N],[13,"Call","","A function call",112,N],[13,"MethodCall","","A method call (`x.foo::<'static, Bar, Baz>(a, b, c, d)`)",112,N],[13,"Tup","","A tuple (`(a, b, c ,d)`)",112,N],[13,"Binary","","A binary operation (For example: `a + b`, `a * b`)",112,N],[13,"Unary","","A unary operation (For example: `!x`, `*x`)",112,N],[13,"Lit","","A literal (For example: `1`, `\"foo\"`)",112,N],[13,"Cast","","A cast (`foo as f64`)",112,N],[13,"Type","","",112,N],[13,"If","","An `if` block, with an optional else block",112,N],[13,"While","","A while loop, with an optional label",112,N],[13,"Loop","","Conditionless loop (can be exited with break, continue, or return)",112,N],[13,"Match","","A `match` block, with a source that indicates whether or not it is the result of a desugaring, and if so, which kind.",112,N],[13,"Closure","","A closure (for example, `move |a, b, c| {a + b + c}`).",112,N],[13,"Block","","A block (`'label: { ... }`)",112,N],[13,"Assign","","An assignment (`a = foo()`)",112,N],[13,"AssignOp","","An assignment with an operator",112,N],[13,"Field","","Access of a named (`obj.foo`) or unnamed (`obj.0`) struct or tuple field",112,N],[13,"Index","","An indexing operation (`foo[2]`)",112,N],[13,"Path","","Path to a definition, possibly containing lifetime or type parameters.",112,N],[13,"AddrOf","","A referencing operation (`&a` or `&mut a`)",112,N],[13,"Break","","A `break`, with an optional label to break",112,N],[13,"Continue","","A `continue`, with an optional label",112,N],[13,"Ret","","A `return`, with an optional value to be returned",112,N],[13,"InlineAsm","","Inline assembly (from `asm!`), with its outputs and inputs.",112,N],[13,"Struct","","A struct or struct-like variant literal expression.",112,N],[13,"Repeat","","An array literal constructed from one repeated element.",112,N],[13,"Yield","","A suspension point for generators. This is `yield <expr>` in Rust.",112,N],[4,"QPath","","Optionally `Self`-qualified value/type path or associated extension.",N,N],[13,"Resolved","","Path to a definition, optionally \"fully-qualified\" with a `Self` type, if the path points to an associated item in a trait.",113,N],[13,"TypeRelative","","Type-related paths, e.g. `<T>::default` or `<T>::Output`. Will be resolved by type-checking to an associated item.",113,N],[4,"LocalSource","","Hints at the original code for a let statement",N,N],[13,"Normal","","A `match _ { .. }`",114,N],[13,"ForLoopDesugar","","A desugared `for _ in _ { .. }` loop",114,N],[4,"MatchSource","","Hints at the original code for a `match _ { .. }`",N,N],[13,"Normal","","A `match _ { .. }`",115,N],[13,"IfLetDesugar","","An `if let _ = _ { .. }` (optionally with `else { .. }`)",115,N],[12,"contains_else_clause","rustc::hir::MatchSource","",115,N],[13,"WhileLetDesugar","rustc::hir","A `while let _ = _ { .. }` (which was desugared to a `loop { match _ { .. } }`)",115,N],[13,"ForLoopDesugar","","A desugared `for _ in _ { .. }` loop",115,N],[13,"TryDesugar","","A desugared `?` operator",115,N],[4,"LoopSource","","The loop type that yielded an ExprKind::Loop",N,N],[13,"Loop","","A `loop { .. }` loop",116,N],[13,"WhileLet","","A `while let _ = _ { .. }` loop",116,N],[13,"ForLoop","","A `for _ in _ { .. }` loop",116,N],[4,"LoopIdError","","",N,N],[13,"OutsideLoopScope","","",117,N],[13,"UnlabeledCfInWhileCondition","","",117,N],[13,"UnresolvedLabel","","",117,N],[4,"GeneratorMovability","","",N,N],[13,"Static","","",118,N],[13,"Movable","","",118,N],[4,"CaptureClause","","",N,N],[13,"CaptureByValue","","",119,N],[13,"CaptureByRef","","",119,N],[4,"TraitMethod","","A trait method's body (or just argument names).",N,N],[13,"Required","","No default body in the trait, just a signature.",120,N],[13,"Provided","","Both signature and body are provided in the trait.",120,N],[4,"TraitItemKind","","Represents a trait method or associated constant or type",N,N],[13,"Const","","An associated constant with an optional value (otherwise `impl`s must contain a value)",121,N],[13,"Method","","A method with an optional body",121,N],[13,"Type","","An associated type with (possibly empty) bounds and optional concrete type",121,N],[4,"ImplItemKind","","Represents different contents within `impl`s",N,N],[13,"Const","","An associated constant of the given type, set to the constant result of the expression",122,N],[13,"Method","","A method implementation with the given signature and body",122,N],[13,"Type","","An associated type",122,N],[13,"Existential","","An associated existential type",122,N],[4,"PrimTy","","Not represented directly in the AST, referred to by name through a ty_path.",N,N],[13,"Int","","",123,N],[13,"Uint","","",123,N],[13,"Float","","",123,N],[13,"Str","","",123,N],[13,"Bool","","",123,N],[13,"Char","","",123,N],[4,"TyKind","","The different kinds of types recognized by the compiler",N,N],[13,"Slice","","A variable length slice (`[T]`)",124,N],[13,"Array","","A fixed length array (`[T; n]`)",124,N],[13,"Ptr","","A raw pointer (`*const T` or `*mut T`)",124,N],[13,"Rptr","","A reference (`&'a T` or `&'a mut T`)",124,N],[13,"BareFn","","A bare function (e.g. `fn(usize) -> bool`)",124,N],[13,"Never","","The never type (`!`)",124,N],[13,"Tup","","A tuple (`(A, B, C, D,...)`)",124,N],[13,"Path","","A path to a type definition (`module::module::...::Type`), or an associated type, e.g. `<Vec<T> as Trait>::Type` or `<T>::Target`.",124,N],[13,"TraitObject","","A trait object type `Bound1 + Bound2 + Bound3` where `Bound` is a trait or a lifetime.",124,N],[13,"Typeof","","Unused for now",124,N],[13,"Infer","","TyKind::Infer means the type should be inferred instead of it having been specified. This can appear anywhere in a type.",124,N],[13,"Err","","Placeholder for a type that has failed to be defined.",124,N],[4,"IsAuto","","Is the trait definition an auto trait?",N,N],[13,"Yes","","",125,N],[13,"No","","",125,N],[4,"IsAsync","","",N,N],[13,"Async","","",126,N],[13,"NotAsync","","",126,N],[4,"Unsafety","","",N,N],[13,"Unsafe","","",127,N],[13,"Normal","","",127,N],[4,"Constness","","",N,N],[13,"Const","","",128,N],[13,"NotConst","","",128,N],[4,"Defaultness","","",N,N],[13,"Default","","",129,N],[12,"has_value","rustc::hir::Defaultness","",129,N],[13,"Final","rustc::hir","",129,N],[4,"ImplPolarity","","",N,N],[13,"Positive","","`impl Trait for Type`",130,N],[13,"Negative","","`impl !Trait for Type`",130,N],[4,"FunctionRetTy","","",N,N],[13,"DefaultReturn","","Return type is not specified.",131,N],[13,"Return","","Everything else",131,N],[4,"UseKind","","",N,N],[13,"Single","","One import, e.g. `use foo::bar` or `use foo::bar as baz`. Also produced for each element of a list `use`, e.g.",132,N],[13,"Glob","","Glob import, e.g. `use foo::*`.",132,N],[13,"ListStem","","Degenerate list import, e.g. `use foo::{a, b}` produces an additional `use foo::{}` for performing checks such as unstable feature gating. May be removed in the future.",132,N],[4,"VisibilityKind","","",N,N],[13,"Public","","",133,N],[13,"Crate","","",133,N],[13,"Restricted","","",133,N],[12,"path","rustc::hir::VisibilityKind","",133,N],[12,"id","","",133,N],[12,"hir_id","","",133,N],[13,"Inherited","rustc::hir","",133,N],[4,"VariantData","","Fields and Ids of enum variants and structs",N,N],[13,"Struct","","",134,N],[13,"Tuple","","",134,N],[13,"Unit","","",134,N],[4,"ItemKind","","",N,N],[13,"ExternCrate","","An `extern crate` item, with optional original crate name if the crate was renamed.",135,N],[13,"Use","","`use foo::bar::*;` or `use foo::bar::baz as quux;`",135,N],[13,"Static","","A `static` item",135,N],[13,"Const","","A `const` item",135,N],[13,"Fn","","A function declaration",135,N],[13,"Mod","","A module",135,N],[13,"ForeignMod","","An external module",135,N],[13,"GlobalAsm","","Module-level inline assembly (from global_asm!)",135,N],[13,"Ty","","A type alias, e.g. `type Foo = Bar<u8>`",135,N],[13,"Existential","","An existential type definition, e.g. `existential type Foo: Bar;`",135,N],[13,"Enum","","An enum definition, e.g. `enum Foo<A, B> {C<A>, D<B>}`",135,N],[13,"Struct","","A struct definition, e.g. `struct Foo<A> {x: A}`",135,N],[13,"Union","","A union definition, e.g. `union Foo<A, B> {x: A, y: B}`",135,N],[13,"Trait","","Represents a Trait Declaration",135,N],[13,"TraitAlias","","Represents a Trait Alias Declaration",135,N],[13,"Impl","","An implementation, eg `impl<A> Trait for Foo { .. }`",135,N],[4,"AssociatedItemKind","","",N,N],[13,"Const","","",136,N],[13,"Method","","",136,N],[12,"has_self","rustc::hir::AssociatedItemKind","",136,N],[13,"Type","rustc::hir","",136,N],[13,"Existential","","",136,N],[4,"ForeignItemKind","","An item within an `extern` block",N,N],[13,"Fn","","A foreign function",137,N],[13,"Static","","A foreign static item (`static ext: u8`), with optional mutability (the boolean is true when mutable)",137,N],[13,"Type","","A foreign type",137,N],[4,"Node","","",N,N],[13,"Item","","",138,N],[13,"ForeignItem","","",138,N],[13,"TraitItem","","",138,N],[13,"ImplItem","","",138,N],[13,"Variant","","",138,N],[13,"Field","","",138,N],[13,"AnonConst","","",138,N],[13,"Expr","","",138,N],[13,"Stmt","","",138,N],[13,"Ty","","",138,N],[13,"TraitRef","","",138,N],[13,"Binding","","",138,N],[13,"Pat","","",138,N],[13,"Block","","",138,N],[13,"Local","","",138,N],[13,"MacroDef","","",138,N],[13,"StructCtor","","StructCtor represents a tuple struct.",138,N],[13,"Lifetime","","",138,N],[13,"GenericParam","","",138,N],[13,"Visibility","","",138,N],[13,"Crate","","",138,N],[5,"provide","","",N,[[["providers"]]]],[0,"check_attr","","This module implements some validity checks for attributes. In particular it verifies that `#[inline]` and `#[repr]` attributes are attached to items that actually support them and if there are conflicts between multiple such attributes attached to the same item.",N,N],[3,"CheckAttrVisitor","rustc::hir::check_attr","",N,N],[12,"tcx","","",139,N],[4,"Target","","",N,N],[13,"Fn","","",140,N],[13,"Struct","","",140,N],[13,"Union","","",140,N],[13,"Enum","","",140,N],[13,"Const","","",140,N],[13,"ForeignMod","","",140,N],[13,"Expression","","",140,N],[13,"Statement","","",140,N],[13,"Closure","","",140,N],[13,"Static","","",140,N],[13,"Other","","",140,N],[5,"check_crate","","",N,[[["tyctxt"]]]],[5,"is_c_like_enum","","",N,[[["item"]],["bool"]]],[11,"clone","","",140,[[["self"]],["target"]]],[11,"eq","","",140,[[["self"],["target"]],["bool"]]],[11,"from_item","","",140,[[["item"]],["target"]]],[11,"check_attributes","","Check any attribute.",139,[[["self"],["item"],["target"]]]],[11,"check_inline","","Check if an `#[inline]` is applied to a function or a closure.",139,[[["self"],["attribute"],["span"],["target"]]]],[11,"check_non_exhaustive","","Check if the `#[non_exhaustive]` attribute on an `item` is valid.",139,[[["self"],["attribute"],["item"],["target"]]]],[11,"check_repr","","Check if the `#[repr]` attributes on `item` are valid.",139,[[["self"],["item"],["target"]]]],[11,"emit_repr_error","","",139,[[["self"],["span"],["span"],["str"],["str"]]]],[11,"check_stmt_attributes","","",139,[[["self"],["stmt"]]]],[11,"check_expr_attributes","","",139,[[["self"],["expr"]]]],[11,"check_used","","",139,[[["self"],["item"],["target"]]]],[11,"nested_visit_map","","",139,[[["self"]],["nestedvisitormap"]]],[11,"visit_item","","",139,[[["self"],["item"]]]],[11,"visit_stmt","","",139,[[["self"],["stmt"]]]],[11,"visit_expr","","",139,[[["self"],["expr"]]]],[0,"def","rustc::hir","",N,N],[3,"PathResolution","rustc::hir::def","The result of resolving a path before lowering to HIR. `base_def` is definition of resolved part of the path, `unresolved_segments` is the number of unresolved segments.",N,N],[12,"base_def","","",141,N],[12,"unresolved_segments","","",141,N],[3,"PerNS","","Just a helper ‒ separate structure for each namespace.",N,N],[12,"value_ns","","",142,N],[12,"type_ns","","",142,N],[12,"macro_ns","","",142,N],[3,"Export","","",N,N],[12,"ident","","The name of the target.",143,N],[12,"def","","The definition of the target.",143,N],[12,"span","","The span of the target definition.",143,N],[12,"vis","","The visibility of the export. We include non-`pub` exports for hygienic macros that get used from extern crates.",143,N],[4,"CtorKind","","",N,N],[13,"Fn","","Constructor function automatically created by a tuple struct/variant.",144,N],[13,"Const","","Constructor constant automatically created by a unit struct/variant.",144,N],[13,"Fictive","","Unusable name in value namespace created by a struct variant.",144,N],[4,"NonMacroAttrKind","","",N,N],[13,"Builtin","","Single-segment attribute defined by the language (`#[inline]`)",145,N],[13,"Tool","","Multi-segment custom attribute living in a \"tool module\" (`#[rustfmt::skip]`).",145,N],[13,"DeriveHelper","","Single-segment custom attribute registered by a derive macro (`#[serde(default)]`).",145,N],[13,"Custom","","Single-segment custom attribute not registered in any way (`#[my_attr]`).",145,N],[4,"Def","","",N,N],[13,"Mod","","",146,N],[13,"Struct","","",146,N],[13,"Union","","",146,N],[13,"Enum","","",146,N],[13,"Variant","","",146,N],[13,"Trait","","",146,N],[13,"Existential","","`existential type Foo: Bar;`",146,N],[13,"TyAlias","","`type Foo = Bar;`",146,N],[13,"ForeignTy","","",146,N],[13,"TraitAlias","","",146,N],[13,"AssociatedTy","","",146,N],[13,"AssociatedExistential","","`existential type Foo: Bar;`",146,N],[13,"PrimTy","","",146,N],[13,"TyParam","","",146,N],[13,"SelfTy","","",146,N],[13,"ToolMod","","",146,N],[13,"Fn","","",146,N],[13,"Const","","",146,N],[13,"Static","","",146,N],[13,"StructCtor","","",146,N],[13,"VariantCtor","","",146,N],[13,"SelfCtor","","",146,N],[13,"Method","","",146,N],[13,"AssociatedConst","","",146,N],[13,"Local","","",146,N],[13,"Upvar","","",146,N],[13,"Label","","",146,N],[13,"Macro","","",146,N],[13,"NonMacroAttr","","",146,N],[13,"Err","","",146,N],[4,"Namespace","","Different kinds of symbols don't influence each other.",N,N],[13,"TypeNS","","",147,N],[13,"ValueNS","","",147,N],[13,"MacroNS","","",147,N],[6,"DefMap","","Definition mapping",N,N],[6,"ExportMap","","This is the replacement export map. It maps a module to all of the exports within.",N,N],[6,"ImportMap","","Map used to track the `use` statements within a scope, matching it with all the items in every namespace.",N,N],[22,"","","",N,N],[11,"clone","","",144,[[["self"]],["ctorkind"]]],[11,"eq","","",144,[[["self"],["ctorkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",144,N],[11,"encode","","",144,[[["self"],["__s"]],["result"]]],[11,"decode","","",144,[[["__d"]],["result",["ctorkind"]]]],[11,"hash","","",144,N],[11,"fmt","","",144,[[["self"],["formatter"]],["result"]]],[11,"clone","","",145,[[["self"]],["nonmacroattrkind"]]],[11,"eq","","",145,[[["self"],["nonmacroattrkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",145,N],[11,"encode","","",145,[[["self"],["__s"]],["result"]]],[11,"decode","","",145,[[["__d"]],["result",["nonmacroattrkind"]]]],[11,"hash","","",145,N],[11,"fmt","","",145,[[["self"],["formatter"]],["result"]]],[11,"clone","","",146,[[["self"]],["def"]]],[11,"eq","","",146,[[["self"],["def"]],["bool"]]],[11,"ne","","",146,[[["self"],["def"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",146,N],[11,"encode","","",146,[[["self"],["__s"]],["result"]]],[11,"decode","","",146,[[["__d"]],["result",["def"]]]],[11,"hash","","",146,N],[11,"fmt","","",146,[[["self"],["formatter"]],["result"]]],[11,"clone","","",141,[[["self"]],["pathresolution"]]],[11,"fmt","","",141,[[["self"],["formatter"]],["result"]]],[11,"new","","",141,[[["def"]],["self"]]],[11,"with_unresolved_segments","","",141,[[["def"],["usize"]],["self"]]],[11,"base_def","","",141,[[["self"]],["def"]]],[11,"unresolved_segments","","",141,[[["self"]],["usize"]]],[11,"kind_name","","",141,[[["self"]],["str"]]],[11,"clone","","",147,[[["self"]],["namespace"]]],[11,"eq","","",147,[[["self"],["namespace"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",147,N],[11,"partial_cmp","","",147,[[["self"],["namespace"]],["option",["ordering"]]]],[11,"cmp","","",147,[[["self"],["namespace"]],["ordering"]]],[11,"hash","","",147,N],[11,"fmt","","",147,[[["self"],["formatter"]],["result"]]],[11,"descr","","",147,[[["self"]],["str"]]],[11,"clone","","",142,[[["self"]],["perns"]]],[11,"default","","",142,[[],["perns"]]],[11,"fmt","","",142,[[["self"],["formatter"]],["result"]]],[11,"map","","",142,[[["self"],["f"]],["perns"]]],[11,"index","","",142,[[["self"],["namespace"]],["t"]]],[11,"index_mut","","",142,[[["self"],["namespace"]],["t"]]],[11,"is_empty","","Returns whether all the items in this collection are `None`.",142,[[["self"]],["bool"]]],[11,"present_items","","Returns an iterator over the items which are `Some`.",142,N],[11,"clone","","",143,[[["self"]],["export"]]],[11,"fmt","","",143,[[["self"],["formatter"]],["result"]]],[11,"encode","","",143,[[["self"],["__s"]],["result"]]],[11,"decode","","",143,[[["__d"]],["result",["export"]]]],[11,"from_ast","","",144,[[["variantdata"]],["ctorkind"]]],[11,"from_hir","","",144,[[["variantdata"]],["ctorkind"]]],[11,"descr","","",145,[[["self"]],["str"]]],[11,"def_id","","",146,[[["self"]],["defid"]]],[11,"kind_name","","A human readable kind name",146,[[["self"]],["str"]]],[0,"def_id","rustc::hir","",N,N],[3,"CrateId","rustc::hir::def_id","",N,N],[12,"private","","",148,N],[3,"DefIndex","","A DefIndex is an index into the hir-map for a crate, identifying a particular definition. It should really be considered an interned shorthand for a particular DefPath.",N,N],[12,"0","","",149,N],[3,"DefId","","A DefId identifies a particular definition, by combining a crate index and a def index.",N,N],[12,"krate","","",150,N],[12,"index","","",150,N],[3,"LocalDefId","","A LocalDefId is equivalent to a DefId with `krate == LOCAL_CRATE`. Since we encode this information in the type, we can ensure at compile time that no DefIds from upstream crates get thrown into the mix. There are quite a few cases where we know that only DefIds from the local crate are expected and a DefId from a different crate would signify a bug somewhere. This is when LocalDefId comes in handy.",N,N],[12,"0","","",151,N],[4,"CrateNum","","",N,N],[13,"BuiltinMacros","","Virtual crate for builtin macros",152,N],[13,"Invalid","","A CrateNum value that indicates that something is wrong.",152,N],[13,"ReservedForIncrCompCache","","A special CrateNum that we use for the tcx.rcache when decoding from the incr. comp. cache.",152,N],[13,"Index","","",152,N],[4,"DefIndexAddressSpace","","",N,N],[13,"Low","","",153,N],[13,"High","","",153,N],[17,"LOCAL_CRATE","","Item definitions in the currently-compiled crate would have the CrateNum LOCAL_CRATE in their DefId.",N,N],[17,"CRATE_DEF_INDEX","","The crate root is always assigned index 0 by the AST Map code, thanks to `NodeCollector::new`.",N,N],[11,"clone","","",148,[[["self"]],["crateid"]]],[11,"eq","","",148,[[["self"],["crateid"]],["bool"]]],[11,"ne","","",148,[[["self"],["crateid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",148,N],[11,"hash","","",148,N],[11,"partial_cmp","","",148,[[["self"],["crateid"]],["option",["ordering"]]]],[11,"lt","","",148,[[["self"],["crateid"]],["bool"]]],[11,"le","","",148,[[["self"],["crateid"]],["bool"]]],[11,"gt","","",148,[[["self"],["crateid"]],["bool"]]],[11,"ge","","",148,[[["self"],["crateid"]],["bool"]]],[11,"cmp","","",148,[[["self"],["crateid"]],["ordering"]]],[18,"MAX_AS_U32","","",148,N],[18,"MAX","","",148,N],[11,"from_usize","","",148,[[["usize"]],["self"]]],[11,"from_u32","","",148,[[["u32"]],["self"]]],[11,"from_u32_const","","Hacky variant of `from_u32` for use in constants. This version checks the \"max\" constraint by using an invalid array dereference.",148,[[["u32"]],["self"]]],[11,"from_u32_unchecked","","",148,[[["u32"]],["self"]]],[11,"index","","Extract value of this index as an integer.",148,[[["self"]],["usize"]]],[11,"as_u32","","Extract value of this index as a usize.",148,[[["self"]],["u32"]]],[11,"as_usize","","Extract value of this index as a u32.",148,[[["self"]],["usize"]]],[11,"new","","",148,[[["usize"]],["self"]]],[11,"index","","",148,[[["self"]],["usize"]]],[11,"steps_between","","",148,[[["self"],["self"]],["option",["usize"]]]],[11,"replace_one","","",148,[[["self"]],["self"]]],[11,"replace_zero","","",148,[[["self"]],["self"]]],[11,"add_one","","",148,[[["self"]],["self"]]],[11,"sub_one","","",148,[[["self"]],["self"]]],[11,"add_usize","","",148,[[["self"],["usize"]],["option"]]],[11,"from","","",148,[[["usize"]],["self"]]],[11,"from","","",148,[[["u32"]],["self"]]],[11,"fmt","","",148,[[["self"],["formatter"]],["result"]]],[11,"clone","","",152,[[["self"]],["cratenum"]]],[11,"eq","","",152,[[["self"],["cratenum"]],["bool"]]],[11,"ne","","",152,[[["self"],["cratenum"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",152,N],[11,"partial_cmp","","",152,[[["self"],["cratenum"]],["option",["ordering"]]]],[11,"lt","","",152,[[["self"],["cratenum"]],["bool"]]],[11,"le","","",152,[[["self"],["cratenum"]],["bool"]]],[11,"gt","","",152,[[["self"],["cratenum"]],["bool"]]],[11,"ge","","",152,[[["self"],["cratenum"]],["bool"]]],[11,"cmp","","",152,[[["self"],["cratenum"]],["ordering"]]],[11,"hash","","",152,N],[11,"fmt","","",152,[[["self"],["formatter"]],["result"]]],[11,"new","","",152,[[["usize"]],["self"]]],[11,"index","","",152,[[["self"]],["usize"]]],[11,"new","","",152,[[["usize"]],["cratenum"]]],[11,"from_usize","","",152,[[["usize"]],["cratenum"]]],[11,"from_u32","","",152,[[["u32"]],["cratenum"]]],[11,"as_usize","","",152,[[["self"]],["usize"]]],[11,"as_u32","","",152,[[["self"]],["u32"]]],[11,"as_def_id","","",152,[[["self"]],["defid"]]],[11,"fmt","","",152,[[["self"],["formatter"]],["result"]]],[11,"clone","","",149,[[["self"]],["defindex"]]],[11,"eq","","",149,[[["self"],["defindex"]],["bool"]]],[11,"ne","","",149,[[["self"],["defindex"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",149,N],[11,"partial_cmp","","",149,[[["self"],["defindex"]],["option",["ordering"]]]],[11,"lt","","",149,[[["self"],["defindex"]],["bool"]]],[11,"le","","",149,[[["self"],["defindex"]],["bool"]]],[11,"gt","","",149,[[["self"],["defindex"]],["bool"]]],[11,"ge","","",149,[[["self"],["defindex"]],["bool"]]],[11,"cmp","","",149,[[["self"],["defindex"]],["ordering"]]],[11,"hash","","",149,N],[11,"fmt","","",149,[[["self"],["formatter"]],["result"]]],[11,"address_space","","",149,[[["self"]],["defindexaddressspace"]]],[11,"as_array_index","","Converts this DefIndex into a zero-based array index. This index is the offset within the given DefIndexAddressSpace.",149,[[["self"]],["usize"]]],[11,"from_array_index","","",149,[[["usize"],["defindexaddressspace"]],["defindex"]]],[11,"from_proc_macro_index","","",149,[[["usize"]],["defindex"]]],[11,"to_proc_macro_index","","",149,[[["defindex"]],["usize"]]],[11,"from_raw_u32","","",149,[[["u32"]],["defindex"]]],[11,"as_raw_u32","","",149,[[["self"]],["u32"]]],[11,"clone","","",153,[[["self"]],["defindexaddressspace"]]],[11,"fmt","","",153,[[["self"],["formatter"]],["result"]]],[11,"eq","","",153,[[["self"],["defindexaddressspace"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",153,N],[11,"hash","","",153,N],[11,"index","","",153,[[["self"]],["usize"]]],[11,"clone","","",150,[[["self"]],["defid"]]],[11,"eq","","",150,[[["self"],["defid"]],["bool"]]],[11,"ne","","",150,[[["self"],["defid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",150,N],[11,"partial_cmp","","",150,[[["self"],["defid"]],["option",["ordering"]]]],[11,"lt","","",150,[[["self"],["defid"]],["bool"]]],[11,"le","","",150,[[["self"],["defid"]],["bool"]]],[11,"gt","","",150,[[["self"],["defid"]],["bool"]]],[11,"ge","","",150,[[["self"],["defid"]],["bool"]]],[11,"cmp","","",150,[[["self"],["defid"]],["ordering"]]],[11,"hash","","",150,N],[11,"fmt","","",150,[[["self"],["formatter"]],["result"]]],[11,"local","","Make a local `DefId` with the given index.",150,[[["defindex"]],["defid"]]],[11,"is_local","","",150,[[["self"]],["bool"]]],[11,"to_local","","",150,[[["self"]],["localdefid"]]],[11,"clone","","",151,[[["self"]],["localdefid"]]],[11,"eq","","",151,[[["self"],["localdefid"]],["bool"]]],[11,"ne","","",151,[[["self"],["localdefid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",151,N],[11,"hash","","",151,N],[11,"from_def_id","","",151,[[["defid"]],["localdefid"]]],[11,"to_def_id","","",151,[[["self"]],["defid"]]],[11,"fmt","","",151,[[["self"],["formatter"]],["result"]]],[0,"intravisit","rustc::hir","HIR walker for walking the contents of nodes.",N,N],[3,"IdRange","rustc::hir::intravisit","",N,N],[12,"min","","",154,N],[12,"max","","",154,N],[3,"IdRangeComputingVisitor","","",N,N],[12,"result","","",155,N],[12,"map","","",155,N],[4,"FnKind","","",N,N],[13,"ItemFn","","#[xxx] pub async/const/extern \"Abi\" fn foo()",156,N],[13,"Method","","fn foo(&self)",156,N],[13,"Closure","","|x, y| {}",156,N],[4,"NestedVisitorMap","","Specifies what nested things a visitor wants to visit. The most common choice is `OnlyBodies`, which will cause the visitor to visit fn bodies for fns that it encounters, but skip over nested item-like things.",N,N],[13,"None","","Do not visit any nested things. When you add a new \"non-nested\" thing, you will want to audit such uses to see if they remain valid.",157,N],[13,"OnlyBodies","","Do not visit nested item-like things, but visit nested things that are inside of an item-like.",157,N],[13,"All","","Visit all nested things, including item-likes.",157,N],[5,"walk_crate","","Walks the contents of a crate. See also `Crate::visit_all_items`.",N,[[["v"],["crate"]]]],[5,"walk_macro_def","","",N,[[["v"],["macrodef"]]]],[5,"walk_mod","","",N,[[["v"],["mod"],["nodeid"]]]],[5,"walk_body","","",N,[[["v"],["body"]]]],[5,"walk_local","","",N,[[["v"],["local"]]]],[5,"walk_ident","","",N,[[["v"],["ident"]]]],[5,"walk_label","","",N,[[["v"],["label"]]]],[5,"walk_lifetime","","",N,[[["v"],["lifetime"]]]],[5,"walk_poly_trait_ref","","",N,[[["v"],["polytraitref"],["traitboundmodifier"]]]],[5,"walk_trait_ref","","",N,[[["v"],["traitref"]]]],[5,"walk_item","","",N,[[["v"],["item"]]]],[5,"walk_enum_def","","",N,[[["v"],["enumdef"],["generics"],["nodeid"]]]],[5,"walk_variant","","",N,[[["v"],["variant"],["generics"],["nodeid"]]]],[5,"walk_ty","","",N,[[["v"],["ty"]]]],[5,"walk_qpath","","",N,[[["v"],["qpath"],["hirid"],["span"]]]],[5,"walk_path","","",N,[[["v"],["path"]]]],[5,"walk_path_segment","","",N,[[["v"],["span"],["pathsegment"]]]],[5,"walk_generic_args","","",N,[[["v"],["span"],["genericargs"]]]],[5,"walk_assoc_type_binding","","",N,[[["v"],["typebinding"]]]],[5,"walk_pat","","",N,[[["v"],["pat"]]]],[5,"walk_foreign_item","","",N,[[["v"],["foreignitem"]]]],[5,"walk_param_bound","","",N,[[["v"],["genericbound"]]]],[5,"walk_generic_param","","",N,[[["v"],["genericparam"]]]],[5,"walk_generics","","",N,[[["v"],["generics"]]]],[5,"walk_where_predicate","","",N,[[["v"],["wherepredicate"]]]],[5,"walk_fn_ret_ty","","",N,[[["v"],["functionretty"]]]],[5,"walk_fn_decl","","",N,[[["v"],["fndecl"]]]],[5,"walk_fn_kind","","",N,[[["v"],["fnkind"]]]],[5,"walk_fn","","",N,[[["v"],["fnkind"],["fndecl"],["bodyid"],["span"],["nodeid"]]]],[5,"walk_trait_item","","",N,[[["v"],["traititem"]]]],[5,"walk_trait_item_ref","","",N,[[["v"],["traititemref"]]]],[5,"walk_impl_item","","",N,[[["v"],["implitem"]]]],[5,"walk_impl_item_ref","","",N,[[["v"],["implitemref"]]]],[5,"walk_struct_def","","",N,[[["v"],["variantdata"]]]],[5,"walk_struct_field","","",N,[[["v"],["structfield"]]]],[5,"walk_block","","",N,[[["v"],["block"]]]],[5,"walk_stmt","","",N,[[["v"],["stmt"]]]],[5,"walk_decl","","",N,[[["v"],["decl"]]]],[5,"walk_anon_const","","",N,[[["v"],["anonconst"]]]],[5,"walk_expr","","",N,[[["v"],["expr"]]]],[5,"walk_arm","","",N,[[["v"],["arm"]]]],[5,"walk_vis","","",N,[[["v"],["visibility"]]]],[5,"walk_associated_item_kind","","",N,[[["v"],["associateditemkind"]]]],[5,"walk_defaultness","","",N,[[["v"],["defaultness"]]]],[8,"Visitor","","Each method of the Visitor trait is a hook to be potentially overridden.  Each method's default implementation recursively visits the substructure of the input via the corresponding `walk` method; e.g. the `visit_mod` method by default calls `intravisit::walk_mod`.",N,N],[10,"nested_visit_map","","The default versions of the `visit_nested_XXX` routines invoke this method to get a map to use. By selecting an enum variant, you control which kinds of nested HIR are visited; see `NestedVisitorMap` for details. By \"nested HIR\", we are referring to bits of HIR that are not directly embedded within one another but rather indirectly, through a table in the crate. This is done to control dependencies during incremental compilation: the non-inline bits of HIR can be tracked and hashed separately.",158,[[["self"]],["nestedvisitormap"]]],[11,"visit_nested_item","","Invoked when a nested item is encountered. By default does nothing unless you override `nested_visit_map` to return `Some(_)`, in which case it will walk the item. You probably don't want to override this method -- instead, override `nested_visit_map` or use the \"shallow\" or \"deep\" visit patterns described on `itemlikevisit::ItemLikeVisitor`. The only reason to override this method is if you want a nested pattern but cannot supply a `Map`; see `nested_visit_map` for advice.",158,[[["self"],["itemid"]]]],[11,"visit_nested_trait_item","","Like `visit_nested_item()`, but for trait items. See `visit_nested_item()` for advice on when to override this method.",158,[[["self"],["traititemid"]]]],[11,"visit_nested_impl_item","","Like `visit_nested_item()`, but for impl items. See `visit_nested_item()` for advice on when to override this method.",158,[[["self"],["implitemid"]]]],[11,"visit_nested_body","","Invoked to visit the body of a function, method or closure. Like visit_nested_item, does nothing by default unless you override `nested_visit_map` to return `Some(_)`, in which case it will walk the body.",158,[[["self"],["bodyid"]]]],[11,"visit_item","","Visit the top-level item and (optionally) nested items / impl items. See `visit_nested_item` for details.",158,[[["self"],["item"]]]],[11,"visit_body","","",158,[[["self"],["body"]]]],[11,"as_deep_visitor","","When invoking `visit_all_item_likes()`, you need to supply an item-like visitor.  This method converts a \"intra-visit\" visitor into an item-like visitor that walks the entire tree. If you use this, you probably don't want to process the contents of nested item-like things, since the outer loop will visit them as well.",158,[[["self"]],["deepvisitor"]]],[11,"visit_id","","",158,[[["self"],["nodeid"]]]],[11,"visit_def_mention","","",158,[[["self"],["def"]]]],[11,"visit_name","","",158,[[["self"],["span"],["name"]]]],[11,"visit_ident","","",158,[[["self"],["ident"]]]],[11,"visit_mod","","",158,[[["self"],["mod"],["span"],["nodeid"]]]],[11,"visit_foreign_item","","",158,[[["self"],["foreignitem"]]]],[11,"visit_local","","",158,[[["self"],["local"]]]],[11,"visit_block","","",158,[[["self"],["block"]]]],[11,"visit_stmt","","",158,[[["self"],["stmt"]]]],[11,"visit_arm","","",158,[[["self"],["arm"]]]],[11,"visit_pat","","",158,[[["self"],["pat"]]]],[11,"visit_decl","","",158,[[["self"],["decl"]]]],[11,"visit_anon_const","","",158,[[["self"],["anonconst"]]]],[11,"visit_expr","","",158,[[["self"],["expr"]]]],[11,"visit_ty","","",158,[[["self"],["ty"]]]],[11,"visit_generic_param","","",158,[[["self"],["genericparam"]]]],[11,"visit_generics","","",158,[[["self"],["generics"]]]],[11,"visit_where_predicate","","",158,[[["self"],["wherepredicate"]]]],[11,"visit_fn_decl","","",158,[[["self"],["fndecl"]]]],[11,"visit_fn","","",158,[[["self"],["fnkind"],["fndecl"],["bodyid"],["span"],["nodeid"]]]],[11,"visit_trait_item","","",158,[[["self"],["traititem"]]]],[11,"visit_trait_item_ref","","",158,[[["self"],["traititemref"]]]],[11,"visit_impl_item","","",158,[[["self"],["implitem"]]]],[11,"visit_impl_item_ref","","",158,[[["self"],["implitemref"]]]],[11,"visit_trait_ref","","",158,[[["self"],["traitref"]]]],[11,"visit_param_bound","","",158,[[["self"],["genericbound"]]]],[11,"visit_poly_trait_ref","","",158,[[["self"],["polytraitref"],["traitboundmodifier"]]]],[11,"visit_variant_data","","",158,[[["self"],["variantdata"],["name"],["generics"],["nodeid"],["span"]]]],[11,"visit_struct_field","","",158,[[["self"],["structfield"]]]],[11,"visit_enum_def","","",158,[[["self"],["enumdef"],["generics"],["nodeid"],["span"]]]],[11,"visit_variant","","",158,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_label","","",158,[[["self"],["label"]]]],[11,"visit_generic_arg","","",158,[[["self"],["genericarg"]]]],[11,"visit_lifetime","","",158,[[["self"],["lifetime"]]]],[11,"visit_qpath","","",158,[[["self"],["qpath"],["hirid"],["span"]]]],[11,"visit_path","","",158,[[["self"],["path"],["hirid"]]]],[11,"visit_path_segment","","",158,[[["self"],["span"],["pathsegment"]]]],[11,"visit_generic_args","","",158,[[["self"],["span"],["genericargs"]]]],[11,"visit_assoc_type_binding","","",158,[[["self"],["typebinding"]]]],[11,"visit_attribute","","",158,[[["self"],["attribute"]]]],[11,"visit_macro_def","","",158,[[["self"],["macrodef"]]]],[11,"visit_vis","","",158,[[["self"],["visibility"]]]],[11,"visit_associated_item_kind","","",158,[[["self"],["associateditemkind"]]]],[11,"visit_defaultness","","",158,[[["self"],["defaultness"]]]],[11,"clone","","",156,[[["self"]],["fnkind"]]],[11,"attrs","","",156,N],[11,"intra","","Returns the map to use for an \"intra item-like\" thing (if any). e.g., function body.",157,[[["self"]],["option",["map"]]]],[11,"inter","","Returns the map to use for an \"item-like\" thing (if any). e.g., item, impl-item.",157,[[["self"]],["option",["map"]]]],[11,"clone","","",154,[[["self"]],["idrange"]]],[11,"encode","","",154,[[["self"],["__s"]],["result"]]],[11,"decode","","",154,[[["__d"]],["result",["idrange"]]]],[11,"fmt","","",154,[[["self"],["formatter"]],["result"]]],[11,"max","","",154,[[],["idrange"]]],[11,"empty","","",154,[[["self"]],["bool"]]],[11,"contains","","",154,[[["self"],["nodeid"]],["bool"]]],[11,"add","","",154,[[["self"],["nodeid"]]]],[11,"new","","",155,[[["map"]],["idrangecomputingvisitor"]]],[11,"result","","",155,[[["self"]],["idrange"]]],[11,"nested_visit_map","","",155,[[["self"]],["nestedvisitormap"]]],[11,"visit_id","","",155,[[["self"],["nodeid"]]]],[0,"itemlikevisit","rustc::hir","",N,N],[3,"DeepVisitor","rustc::hir::itemlikevisit","",N,N],[12,"visitor","","",159,N],[3,"ParDeepVisitor","","",N,N],[12,"0","","",160,N],[8,"ItemLikeVisitor","","The \"item-like visitor\" visitor defines only the top-level methods that can be invoked by `Crate::visit_all_item_likes()`. Whether this trait is the right one to implement will depend on the overall pattern you need. Here are the three available patterns, in roughly the order of desirability:",N,N],[10,"visit_item","","",161,[[["self"],["item"]]]],[10,"visit_trait_item","","",161,[[["self"],["traititem"]]]],[10,"visit_impl_item","","",161,[[["self"],["implitem"]]]],[8,"ParItemLikeVisitor","","A parallel variant of ItemLikeVisitor",N,N],[10,"visit_item","","",162,[[["self"],["item"]]]],[10,"visit_trait_item","","",162,[[["self"],["traititem"]]]],[10,"visit_impl_item","","",162,[[["self"],["implitem"]]]],[8,"IntoVisitor","","",N,N],[16,"Visitor","","",163,N],[10,"into_visitor","","",163,N],[11,"new","","",159,[[["v"]],["self"]]],[11,"visit_item","","",159,[[["self"],["item"]]]],[11,"visit_trait_item","","",159,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",159,[[["self"],["implitem"]]]],[11,"visit_item","","",160,[[["self"],["item"]]]],[11,"visit_trait_item","","",160,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",160,[[["self"],["implitem"]]]],[0,"lowering","rustc::hir","Lowers the AST to the HIR.",N,N],[3,"LoweringContext","rustc::hir::lowering","",N,N],[12,"crate_root","","",164,N],[12,"sess","","",164,N],[12,"cstore","","",164,N],[12,"resolver","","",164,N],[12,"items","","The items being lowered are collected here.",164,N],[12,"trait_items","","",164,N],[12,"impl_items","","",164,N],[12,"bodies","","",164,N],[12,"exported_macros","","",164,N],[12,"trait_impls","","",164,N],[12,"trait_auto_impl","","",164,N],[12,"is_generator","","",164,N],[12,"catch_scopes","","",164,N],[12,"loop_scopes","","",164,N],[12,"is_in_loop_condition","","",164,N],[12,"is_in_trait_impl","","",164,N],[12,"anonymous_lifetime_mode","","What to do when we encounter either an \"anonymous lifetime reference\". The term \"anonymous\" is meant to encompass both `'_` lifetimes as well as fully elided cases where nothing is written at all (e.g., `&T` or `std::cell::Ref<T>`).",164,N],[12,"lifetimes_to_define","","",164,N],[12,"is_collecting_in_band_lifetimes","","",164,N],[12,"in_scope_lifetimes","","",164,N],[12,"type_def_lifetime_params","","",164,N],[12,"current_hir_id_owner","","",164,N],[12,"item_local_id_counters","","",164,N],[12,"node_id_to_hir_id","","",164,N],[3,"LoweredNodeId","","",N,N],[12,"node_id","","",165,N],[12,"hir_id","","",165,N],[4,"ImplTraitContext","","",N,N],[13,"Universal","","Treat `impl Trait` as shorthand for a new universal generic parameter. Example: `fn foo(x: impl Debug)`, where `impl Debug` is conceptually equivalent to a fresh universal parameter like `fn foo<T: Debug>(x: T)`.",166,N],[13,"Existential","","Treat `impl Trait` as shorthand for a new universal existential parameter. Example: `fn foo() -> impl Debug`, where `impl Debug` is conceptually equivalent to a fresh existential parameter like `abstract type T; fn foo() -> T`.",166,N],[13,"Disallowed","","`impl Trait` is not accepted in this position.",166,N],[4,"ParamMode","","",N,N],[13,"Explicit","","Any path in a type context.",167,N],[13,"Optional","","The `module::Type` in `module::Type::method` in an expression.",167,N],[4,"ParenthesizedGenericArgs","","",N,N],[13,"Ok","","",168,N],[13,"Warn","","",168,N],[13,"Err","","",168,N],[4,"AnonymousLifetimeMode","","What to do when we encounter an anonymous lifetime reference. Anonymous lifetime references come in two flavors.  You have implicit, or fully elided, references to lifetimes, like the one in `&T` or `Ref<T>`, and you have `'_` lifetimes, like `&'_ T` or `Ref<'_, T>`.  These often behave the same, but not always:",N,N],[13,"CreateParameter","","For Modern cases, create a new anonymous region parameter and reference that.",169,N],[13,"PassThrough","","Pass responsibility to `resolve_lifetime` code for all cases.",169,N],[5,"lower_crate","","",N,[[["session"],["cratestore"],["depgraph"],["crate"],["resolver"]],["crate"]]],[5,"body_ids","","",N,[[["btreemap"]],["vec",["bodyid"]]]],[22,"","","",N,N],[17,"HIR_ID_COUNTER_LOCKED","","",N,N],[8,"Resolver","","",N,N],[10,"resolve_hir_path","","Resolve a hir path generated by the lowerer when expanding `for`, `if let`, etc.",170,[[["self"],["path"],["bool"]]]],[10,"get_resolution","","Obtain the resolution for a node id",170,[[["self"],["nodeid"]],["option",["pathresolution"]]]],[10,"get_import","","Obtain the possible resolutions for the given `use` statement.",170,[[["self"],["nodeid"]],["perns",["option"]]]],[10,"definitions","","We must keep the set of definitions up to date as we add nodes that weren't in the AST. This should only return `None` during testing.",170,[[["self"]],["definitions"]]],[10,"resolve_str_path","","Given suffix [\"b\",\"c\",\"d\"], creates a HIR path for `[::crate_root]::b::c::d` and resolves it based on `is_value`.",170,N],[11,"fmt","","",166,[[["self"],["formatter"]],["result"]]],[11,"reborrow","","",166,[[["self"]],["impltraitcontext"]]],[11,"clone","","",167,[[["self"]],["parammode"]]],[11,"eq","","",167,[[["self"],["parammode"]],["bool"]]],[11,"fmt","","",165,[[["self"],["formatter"]],["result"]]],[11,"clone","","",169,[[["self"]],["anonymouslifetimemode"]]],[11,"lower_crate","","",164,[[["self"],["crate"]],["crate"]]],[11,"allocate_hir_id_counter","","",164,[[["self"],["nodeid"],["t"]],["lowerednodeid"]]],[11,"lower_node_id_generic","","",164,[[["self"],["nodeid"],["f"]],["lowerednodeid"]]],[11,"with_hir_id_owner","","",164,[[["self"],["nodeid"],["f"]],["t"]]],[11,"lower_node_id","","This method allocates a new HirId for the given NodeId and stores it in the LoweringContext's NodeId => HirId map. Take care not to call this method if the resulting HirId is then not actually used in the HIR, as that would trigger an assertion in the HirIdValidator later on, which makes sure that all NodeIds got mapped properly. Calling the method twice with the same NodeId is fine though.",164,[[["self"],["nodeid"]],["lowerednodeid"]]],[11,"lower_node_id_with_owner","","",164,[[["self"],["nodeid"],["nodeid"]],["lowerednodeid"]]],[11,"record_body","","",164,[[["self"],["expr"],["option",["fndecl"]]],["bodyid"]]],[11,"next_id","","",164,[[["self"]],["lowerednodeid"]]],[11,"expect_full_def","","",164,[[["self"],["nodeid"]],["def"]]],[11,"expect_full_def_from_use","","",164,N],[11,"diagnostic","","",164,[[["self"]],["handler"]]],[11,"str_to_ident","","",164,[[["self"],["str"]],["ident"]]],[11,"allow_internal_unstable","","",164,[[["self"],["compilerdesugaringkind"],["span"]],["span"]]],[11,"with_anonymous_lifetime_mode","","",164,N],[11,"collect_in_band_defs","","Creates a new hir::GenericParam for every new lifetime and type parameter encountered while evaluating `f`. Definitions are created with the parent provided. If no `parent_id` is provided, no definitions will be returned.",164,N],[11,"maybe_collect_in_band_lifetime","","When there is a reference to some lifetime `'a`, and in-band lifetimes are enabled, then we want to push that lifetime into the vector of names to define later. In that case, it will get added to the appropriate generics.",164,[[["self"],["ident"]]]],[11,"collect_fresh_in_band_lifetime","","When we have either an elided or `'_` lifetime in an impl header, we convert it to",164,[[["self"],["span"]],["paramname"]]],[11,"with_in_scope_lifetime_defs","","",164,N],[11,"with_parent_impl_lifetime_defs","","",164,[[["self"],["hirvec"],["f"]],["t"]]],[11,"add_in_band_defs","","Appends in-band lifetime defs and argument-position `impl Trait` defs to the existing set of generics.",164,N],[11,"with_catch_scope","","",164,[[["self"],["nodeid"],["f"]],["t"]]],[11,"make_async_expr","","",164,N],[11,"lower_body","","",164,[[["self"],["option",["fndecl"]],["f"]],["bodyid"]]],[11,"with_loop_scope","","",164,[[["self"],["nodeid"],["f"]],["t"]]],[11,"with_loop_condition_scope","","",164,[[["self"],["f"]],["t"]]],[11,"with_new_scopes","","",164,[[["self"],["f"]],["t"]]],[11,"def_key","","",164,[[["self"],["defid"]],["defkey"]]],[11,"lower_label","","",164,[[["self"],["option",["label"]]],["option",["label"]]]],[11,"lower_loop_destination","","",164,[[["self"],["option"]],["destination"]]],[11,"lower_attrs","","",164,N],[11,"lower_attr","","",164,[[["self"],["attribute"]],["attribute"]]],[11,"lower_token_stream","","",164,[[["self"],["tokenstream"]],["tokenstream"]]],[11,"lower_token_tree","","",164,[[["self"],["tokentree"]],["tokenstream"]]],[11,"lower_token","","",164,[[["self"],["token"],["span"]],["tokenstream"]]],[11,"lower_arm","","",164,[[["self"],["arm"]],["arm"]]],[11,"lower_ty_binding","","",164,[[["self"],["typebinding"],["impltraitcontext"]],["typebinding"]]],[11,"lower_generic_arg","","",164,[[["self"],["genericarg"],["impltraitcontext"]],["genericarg"]]],[11,"lower_ty","","",164,[[["self"],["ty"],["impltraitcontext"]],["p",["ty"]]]],[11,"lower_ty_direct","","",164,[[["self"],["ty"],["impltraitcontext"]],["ty"]]],[11,"lower_existential_impl_trait","","",164,N],[11,"lifetimes_from_impl_trait_bounds","","",164,N],[11,"lower_foreign_mod","","",164,[[["self"],["foreignmod"]],["foreignmod"]]],[11,"lower_global_asm","","",164,[[["self"],["globalasm"]],["p",["globalasm"]]]],[11,"lower_variant","","",164,[[["self"],["variant"]],["variant"]]],[11,"lower_qpath","","",164,[[["self"],["nodeid"],["option"],["path"],["parammode"],["impltraitcontext"]],["qpath"]]],[11,"lower_path_extra","","",164,[[["self"],["def"],["path"],["option",["ident"]],["parammode"]],["path"]]],[11,"lower_path","","",164,[[["self"],["nodeid"],["path"],["parammode"]],["path"]]],[11,"lower_path_segment","","",164,[[["self"],["span"],["pathsegment"],["parammode"],["usize"],["parenthesizedgenericargs"],["impltraitcontext"]],["pathsegment"]]],[11,"lower_angle_bracketed_parameter_data","","",164,N],[11,"lower_parenthesized_parameter_data","","",164,N],[11,"lower_local","","",164,[[["self"],["local"]],["p",["local"]]]],[11,"lower_mutability","","",164,[[["self"],["mutability"]],["mutability"]]],[11,"lower_arg","","",164,[[["self"],["arg"]],["arg"]]],[11,"lower_fn_args_to_names","","",164,[[["self"],["fndecl"]],["hirvec",["ident"]]]],[11,"lower_fn_decl","","",164,[[["self"],["fndecl"],["option"],["bool"],["option",["nodeid"]]],["p",["fndecl"]]]],[11,"lower_async_fn_ret_ty","","",164,N],[11,"lower_param_bound","","",164,[[["self"],["genericbound"],["impltraitcontext"]],["genericbound"]]],[11,"lower_lifetime","","",164,[[["self"],["lifetime"]],["lifetime"]]],[11,"new_named_lifetime","","",164,[[["self"],["nodeid"],["span"],["lifetimename"]],["lifetime"]]],[11,"lower_generic_params","","",164,N],[11,"lower_generic_param","","",164,[[["self"],["genericparam"],["nodemap"],["impltraitcontext"]],["genericparam"]]],[11,"lower_generics","","",164,[[["self"],["generics"],["impltraitcontext"]],["generics"]]],[11,"lower_where_clause","","",164,[[["self"],["whereclause"]],["whereclause"]]],[11,"lower_where_predicate","","",164,[[["self"],["wherepredicate"]],["wherepredicate"]]],[11,"lower_variant_data","","",164,[[["self"],["variantdata"]],["variantdata"]]],[11,"lower_trait_ref","","",164,[[["self"],["traitref"],["impltraitcontext"]],["traitref"]]],[11,"lower_poly_trait_ref","","",164,[[["self"],["polytraitref"],["impltraitcontext"]],["polytraitref"]]],[11,"lower_struct_field","","",164,N],[11,"lower_field","","",164,[[["self"],["field"]],["field"]]],[11,"lower_mt","","",164,[[["self"],["mutty"],["impltraitcontext"]],["mutty"]]],[11,"lower_param_bounds","","",164,N],[11,"lower_block","","",164,[[["self"],["block"],["bool"]],["p",["block"]]]],[11,"lower_async_body","","",164,[[["self"],["fndecl"],["isasync"],["block"]],["bodyid"]]],[11,"lower_item_kind","","",164,[[["self"],["nodeid"],["name"],["hirvec"],["visibility"],["itemkind"]],["itemkind"]]],[11,"lower_use_tree","","",164,[[["self"],["usetree"],["path"],["nodeid"],["visibility"],["name"],["hirvec"]],["itemkind"]]],[11,"lower_trait_item","","",164,[[["self"],["traititem"]],["traititem"]]],[11,"lower_trait_item_ref","","",164,[[["self"],["traititem"]],["traititemref"]]],[11,"lower_impl_item","","",164,[[["self"],["implitem"]],["implitem"]]],[11,"lower_impl_item_ref","","",164,[[["self"],["implitem"]],["implitemref"]]],[11,"lower_mod","","",164,[[["self"],["mod"]],["mod"]]],[11,"lower_impl_trait_ids","","Lowers `impl Trait` items and appends them to the list",164,[[["self"],["fndecl"],["fnheader"],["onevector"]]]],[11,"lower_item_id","","",164,[[["self"],["item"]],["onevector",["itemid"]]]],[11,"lower_item_id_use_tree","","",164,[[["self"],["usetree"],["nodeid"],["onevector"]]]],[11,"lower_item","","",164,[[["self"],["item"]],["option",["item"]]]],[11,"lower_foreign_item","","",164,[[["self"],["foreignitem"]],["foreignitem"]]],[11,"lower_method_sig","","",164,N],[11,"lower_is_auto","","",164,[[["self"],["isauto"]],["isauto"]]],[11,"lower_fn_header","","",164,[[["self"],["fnheader"]],["fnheader"]]],[11,"lower_unsafety","","",164,[[["self"],["unsafety"]],["unsafety"]]],[11,"lower_constness","","",164,[[["self"],["spanned",["constness"]]],["constness"]]],[11,"lower_asyncness","","",164,[[["self"],["isasync"]],["isasync"]]],[11,"lower_unop","","",164,[[["self"],["unop"]],["unop"]]],[11,"lower_binop","","",164,[[["self"],["binop"]],["binop"]]],[11,"lower_pat","","",164,[[["self"],["pat"]],["p",["pat"]]]],[11,"lower_range_end","","",164,[[["self"],["rangeend"]],["rangeend"]]],[11,"lower_anon_const","","",164,[[["self"],["anonconst"]],["anonconst"]]],[11,"lower_expr","","",164,[[["self"],["expr"]],["expr"]]],[11,"lower_stmt","","",164,[[["self"],["stmt"]],["onevector",["stmt"]]]],[11,"lower_capture_clause","","",164,[[["self"],["captureby"]],["captureclause"]]],[11,"lower_visibility","","If an `explicit_owner` is given, this method allocates the `HirId` in the address space of that item instead of the item currently being lowered. This can happen during `lower_impl_item_ref()` where we need to lower a `Visibility` value although we haven't lowered the owning `ImplItem` in question yet.",164,[[["self"],["visibility"],["option",["nodeid"]]],["visibility"]]],[11,"lower_defaultness","","",164,[[["self"],["defaultness"],["bool"]],["defaultness"]]],[11,"lower_block_check_mode","","",164,[[["self"],["blockcheckmode"]],["blockcheckmode"]]],[11,"lower_binding_mode","","",164,[[["self"],["bindingmode"]],["bindingannotation"]]],[11,"lower_unsafe_source","","",164,[[["self"],["unsafesource"]],["unsafesource"]]],[11,"lower_impl_polarity","","",164,[[["self"],["implpolarity"]],["implpolarity"]]],[11,"lower_trait_bound_modifier","","",164,[[["self"],["traitboundmodifier"]],["traitboundmodifier"]]],[11,"arm","","",164,[[["self"],["hirvec",["p"]],["p",["expr"]]],["arm"]]],[11,"field","","",164,[[["self"],["ident"],["p",["expr"]],["span"]],["field"]]],[11,"expr_break","","",164,[[["self"],["span"],["thinvec",["attribute"]]],["p",["expr"]]]],[11,"expr_call","","",164,[[["self"],["span"],["p",["expr"]],["hirvec",["expr"]]],["expr"]]],[11,"expr_ident","","",164,[[["self"],["span"],["ident"],["nodeid"]],["expr"]]],[11,"expr_ident_with_attrs","","",164,[[["self"],["span"],["ident"],["nodeid"],["thinvec",["attribute"]]],["expr"]]],[11,"expr_mut_addr_of","","",164,[[["self"],["span"],["p",["expr"]]],["expr"]]],[11,"expr_std_path","","",164,N],[11,"expr_match","","",164,[[["self"],["span"],["p",["expr"]],["hirvec",["arm"]],["matchsource"]],["expr"]]],[11,"expr_block","","",164,[[["self"],["p",["block"]],["thinvec",["attribute"]]],["expr"]]],[11,"expr_tuple","","",164,[[["self"],["span"],["hirvec",["expr"]]],["p",["expr"]]]],[11,"expr","","",164,[[["self"],["span"],["exprkind"],["thinvec",["attribute"]]],["expr"]]],[11,"stmt_let_pat","","",164,[[["self"],["span"],["option",["p"]],["p",["pat"]],["localsource"]],["stmt"]]],[11,"stmt_let","","",164,N],[11,"block_expr","","",164,[[["self"],["p",["expr"]]],["block"]]],[11,"block_all","","",164,[[["self"],["span"],["hirvec",["stmt"]],["option",["p"]]],["block"]]],[11,"pat_ok","","",164,[[["self"],["span"],["p",["pat"]]],["p",["pat"]]]],[11,"pat_err","","",164,[[["self"],["span"],["p",["pat"]]],["p",["pat"]]]],[11,"pat_some","","",164,[[["self"],["span"],["p",["pat"]]],["p",["pat"]]]],[11,"pat_none","","",164,[[["self"],["span"]],["p",["pat"]]]],[11,"pat_std_enum","","",164,N],[11,"pat_ident","","",164,[[["self"],["span"],["ident"]],["p",["pat"]]]],[11,"pat_ident_binding_mode","","",164,[[["self"],["span"],["ident"],["bindingannotation"]],["p",["pat"]]]],[11,"pat_wild","","",164,[[["self"],["span"]],["p",["pat"]]]],[11,"pat","","",164,[[["self"],["span"],["patkind"]],["p",["pat"]]]],[11,"std_path","","Given suffix [\"b\",\"c\",\"d\"], returns path `::std::b::c::d` when `fld.cx.use_std`, and `::core::b::c::d` otherwise. The path is also resolved according to `is_value`.",164,N],[11,"ty_path","","",164,[[["self"],["lowerednodeid"],["span"],["qpath"]],["ty"]]],[11,"elided_ref_lifetime","","Invoked to create the lifetime argument for a type `&T` with no explicit lifetime.",164,[[["self"],["span"]],["lifetime"]]],[11,"elided_path_lifetimes","","Invoked to create the lifetime argument(s) for a path like `std::cell::Ref<T>`; note that implicit lifetimes in these sorts of cases are deprecated. This may therefore report a warning or an error, depending on the mode.",164,[[["self"],["span"],["usize"]],["p"]]],[11,"elided_dyn_bound","","Invoked to create the lifetime argument(s) for an elided trait object bound, like the bound in `Box<dyn Debug>`. This method is not invoked when the bound is written, even if it is written with `'_` like in `Box<dyn Debug + '_>`. In those cases, `lower_lifetime` is invoked.",164,[[["self"],["span"]],["lifetime"]]],[11,"new_implicit_lifetime","","",164,[[["self"],["span"]],["lifetime"]]],[11,"maybe_lint_bare_trait","","",164,[[["self"],["span"],["nodeid"],["bool"]]]],[11,"wrap_in_try_constructor","","",164,[[["self"],["str"],["expr"],["span"]],["p",["expr"]]]],[11,"check_self_struct_ctor_feature","","",164,[[["self"],["qpath"]]]],[0,"map","rustc::hir","",N,N],[3,"DefCollector","rustc::hir::map","Creates def ids for nodes in the AST.",N,N],[12,"definitions","","",171,N],[12,"parent_def","","",171,N],[12,"expansion","","",171,N],[12,"visit_macro_invoc","","",171,N],[3,"MacroInvocationData","","",N,N],[12,"mark","","",172,N],[12,"def_index","","",172,N],[3,"Entry","","Represents an entry and its parent NodeId.",N,N],[12,"parent","","",173,N],[12,"dep_node","","",173,N],[12,"node","","",173,N],[3,"Forest","","Stores a crate and any number of inlined items from other crates.",N,N],[12,"krate","","",174,N],[12,"dep_graph","","",174,N],[3,"Map","","Represents a mapping from Node IDs to AST elements and their parent Node IDs",N,N],[12,"forest","","The backing storage for all the AST nodes.",175,N],[12,"dep_graph","","Same as the dep_graph in forest, just available with one fewer deref. This is a gratuitous micro-optimization.",175,N],[12,"crate_hash","","The SVH of the local crate.",175,N],[12,"map","","`NodeId`s are sequential integers from 0, so we can be super-compact by storing them in a vector. Not everything with a `NodeId` is in the map, but empirically the occupancy is about 75-80%, so there's not too much overhead (certainly less than a hashmap, since they (at the time of writing) have a maximum of 75% occupancy).",175,N],[12,"definitions","","",175,N],[12,"hir_to_node_id","","The reverse mapping of `node_to_hir_id`.",175,N],[3,"NodesMatchingSuffix","","",N,N],[12,"map","","",176,N],[12,"item_name","","",176,N],[12,"in_which","","",176,N],[12,"idx","","",176,N],[5,"map_crate","","",N,[[["session"],["cratestore"],["forest"],["definitions"]],["map"]]],[5,"node_id_to_string","","",N,[[["map"],["nodeid"],["bool"]],["string"]]],[5,"describe_def","","",N,[[["tyctxt"],["defid"]],["option",["def"]]]],[0,"blocks","","This module provides a simplified abstraction for working with code blocks identified by their integer node-id.  In particular, it captures a common set of attributes that all \"function-like things\" (represented by `FnLike` instances) share.  For example, all `FnLike` instances have a type signature (be it explicit or inferred).  And all `FnLike` instances have a body, i.e. the code that is run when the function-like thing it represents is invoked.",N,N],[3,"FnLikeNode","rustc::hir::map::blocks","An FnLikeNode is a Node that is like a fn, in that it has a decl and a body (as well as a NodeId, a span, etc).",N,N],[12,"node","","",177,N],[3,"ItemFnParts","","These are all the components one can extract from a fn item for use when implementing FnLikeNode operations.",N,N],[12,"name","","",178,N],[12,"decl","","",178,N],[12,"header","","",178,N],[12,"vis","","",178,N],[12,"generics","","",178,N],[12,"body","","",178,N],[12,"id","","",178,N],[12,"span","","",178,N],[12,"attrs","","",178,N],[3,"ClosureParts","","These are all the components one can extract from a closure expr for use when implementing FnLikeNode operations.",N,N],[12,"decl","","",179,N],[12,"body","","",179,N],[12,"id","","",179,N],[12,"span","","",179,N],[12,"attrs","","",179,N],[4,"Code","","Carries either an FnLikeNode or a Expr, as these are the two constructs that correspond to \"code\" (as in, something from which we can construct a control-flow graph).",N,N],[13,"FnLike","","",180,N],[13,"Expr","","",180,N],[8,"MaybeFnLike","","MaybeFnLike wraps a method that indicates if an object corresponds to some FnLikeNode.",N,N],[10,"is_fn_like","","",181,[[["self"]],["bool"]]],[11,"clone","","",177,[[["self"]],["fnlikenode"]]],[11,"fmt","","",177,[[["self"],["formatter"]],["result"]]],[11,"is_fn_like","rustc::hir","",83,[[["self"]],["bool"]]],[11,"is_fn_like","","",65,[[["self"]],["bool"]]],[11,"is_fn_like","","",63,[[["self"]],["bool"]]],[11,"is_fn_like","","",58,[[["self"]],["bool"]]],[11,"clone","rustc::hir::map::blocks","",180,[[["self"]],["code"]]],[11,"id","","",180,[[["self"]],["nodeid"]]],[11,"from_node","","Attempts to construct a Code from presumed FnLike or Expr node input.",180,[[["map"],["nodeid"]],["option",["code"]]]],[11,"new","","",179,N],[11,"from_node","","Attempts to construct a FnLikeNode from presumed FnLike node input.",177,[[["node"]],["option",["fnlikenode"]]]],[11,"body","","",177,[[["self"]],["bodyid"]]],[11,"decl","","",177,[[["self"]],["fndecl"]]],[11,"span","","",177,[[["self"]],["span"]]],[11,"id","","",177,[[["self"]],["nodeid"]]],[11,"constness","","",177,[[["self"]],["constness"]]],[11,"asyncness","","",177,[[["self"]],["isasync"]]],[11,"unsafety","","",177,[[["self"]],["unsafety"]]],[11,"kind","","",177,[[["self"]],["fnkind"]]],[11,"handle","","",177,[[["self"],["i"],["m"],["c"]],["a"]]],[0,"collector","rustc::hir::map","",N,N],[3,"NodeCollector","rustc::hir::map::collector","A Visitor that walks over the HIR and collects Nodes into a HIR map",N,N],[12,"krate","","The crate",182,N],[12,"map","","The node map",182,N],[12,"parent_node","","The parent of this node",182,N],[12,"current_dep_node_owner","","",182,N],[12,"current_signature_dep_index","","",182,N],[12,"current_full_dep_index","","",182,N],[12,"currently_in_body","","",182,N],[12,"dep_graph","","",182,N],[12,"definitions","","",182,N],[12,"hcx","","",182,N],[12,"hir_body_nodes","","",182,N],[3,"HirItemLike","","",N,N],[12,"item_like","","",183,N],[12,"hash_bodies","","",183,N],[11,"root","","",182,[[["crate"],["depgraph"],["definitions"],["stablehashingcontext"]],["nodecollector"]]],[11,"finalize_and_compute_crate_hash","","",182,N],[11,"insert_entry","","",182,[[["self"],["nodeid"],["entry"]]]],[11,"insert","","",182,[[["self"],["nodeid"],["node"]]]],[11,"with_parent","","",182,[[["self"],["nodeid"],["f"]]]],[11,"with_dep_node_owner","","",182,[[["self"],["defindex"],["t"],["f"]]]],[11,"nested_visit_map","","Because we want to track parent items and so forth, enable deep walking so that we walk nested items in the context of their outer items.",182,[[["self"]],["nestedvisitormap"]]],[11,"visit_nested_item","","",182,[[["self"],["itemid"]]]],[11,"visit_nested_trait_item","","",182,[[["self"],["traititemid"]]]],[11,"visit_nested_impl_item","","",182,[[["self"],["implitemid"]]]],[11,"visit_nested_body","","",182,[[["self"],["bodyid"]]]],[11,"visit_item","","",182,[[["self"],["item"]]]],[11,"visit_foreign_item","","",182,[[["self"],["foreignitem"]]]],[11,"visit_generic_param","","",182,[[["self"],["genericparam"]]]],[11,"visit_trait_item","","",182,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",182,[[["self"],["implitem"]]]],[11,"visit_pat","","",182,[[["self"],["pat"]]]],[11,"visit_anon_const","","",182,[[["self"],["anonconst"]]]],[11,"visit_expr","","",182,[[["self"],["expr"]]]],[11,"visit_stmt","","",182,[[["self"],["stmt"]]]],[11,"visit_ty","","",182,[[["self"],["ty"]]]],[11,"visit_trait_ref","","",182,[[["self"],["traitref"]]]],[11,"visit_fn","","",182,[[["self"],["fnkind"],["fndecl"],["bodyid"],["span"],["nodeid"]]]],[11,"visit_block","","",182,[[["self"],["block"]]]],[11,"visit_local","","",182,[[["self"],["local"]]]],[11,"visit_lifetime","","",182,[[["self"],["lifetime"]]]],[11,"visit_vis","","",182,[[["self"],["visibility"]]]],[11,"visit_macro_def","","",182,[[["self"],["macrodef"]]]],[11,"visit_variant","","",182,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_struct_field","","",182,[[["self"],["structfield"]]]],[11,"visit_trait_item_ref","","",182,[[["self"],["traititemref"]]]],[11,"visit_impl_item_ref","","",182,[[["self"],["implitemref"]]]],[11,"hash_stable","","",183,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[0,"def_collector","rustc::hir::map","",N,N],[3,"DefCollector","rustc::hir::map::def_collector","Creates def ids for nodes in the AST.",N,N],[12,"definitions","","",171,N],[12,"parent_def","","",171,N],[12,"expansion","","",171,N],[12,"visit_macro_invoc","","",171,N],[3,"MacroInvocationData","","",N,N],[12,"mark","","",172,N],[12,"def_index","","",172,N],[11,"new","rustc::hir::map","",171,[[["definitions"],["mark"]],["self"]]],[11,"collect_root","","",171,[[["self"],["str"],["cratedisambiguator"]]]],[11,"create_def","","",171,[[["self"],["nodeid"],["defpathdata"],["defindexaddressspace"],["span"]],["defindex"]]],[11,"with_parent","","",171,[[["self"],["defindex"],["f"]]]],[11,"visit_async_fn","","",171,[[["self"],["nodeid"],["name"],["span"],["fnheader"],["generics"],["fndecl"],["block"]]]],[11,"visit_macro_invoc","","",171,[[["self"],["nodeid"]]]],[11,"visit_item","","",171,[[["self"],["item"]]]],[11,"visit_use_tree","","",171,[[["self"],["usetree"],["nodeid"],["bool"]]]],[11,"visit_foreign_item","","",171,[[["self"],["foreignitem"]]]],[11,"visit_variant","","",171,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_variant_data","","",171,[[["self"],["variantdata"],["ident"],["generics"],["nodeid"],["span"]]]],[11,"visit_generic_param","","",171,[[["self"],["genericparam"]]]],[11,"visit_trait_item","","",171,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",171,[[["self"],["implitem"]]]],[11,"visit_pat","","",171,[[["self"],["pat"]]]],[11,"visit_anon_const","","",171,[[["self"],["anonconst"]]]],[11,"visit_expr","","",171,[[["self"],["expr"]]]],[11,"visit_ty","","",171,[[["self"],["ty"]]]],[11,"visit_stmt","","",171,[[["self"],["stmt"]]]],[11,"visit_token","","",171,[[["self"],["token"]]]],[0,"definitions","","For each definition, we track the following data.  A definition here is defined somewhat circularly as \"something with a def-id\", but it generally corresponds to things like structs, enums, etc. There are also some rather random cases (like const initializer expressions) that are mostly just leftovers.",N,N],[3,"DefPathTable","rustc::hir::map::definitions","The DefPathTable maps DefIndexes to DefKeys and vice versa. Internally the DefPathTable holds a tree of DefKeys, where each DefKey stores the DefIndex of its parent. There is one DefPathTable for each crate.",N,N],[12,"index_to_key","","",184,N],[12,"def_path_hashes","","",184,N],[3,"Definitions","","The definition table containing node definitions. It holds the DefPathTable for local DefIds/DefPaths and it also stores a mapping from NodeIds to local DefIds.",N,N],[12,"table","","",185,N],[12,"node_to_def_index","","",185,N],[12,"def_index_to_node","","",185,N],[12,"node_to_hir_id","","",185,N],[12,"parent_modules_of_macro_defs","","If `Mark` is an ID of some macro expansion, then `DefId` is the normal module (`mod`) in which the expanded macro was defined.",185,N],[12,"expansions_that_defined","","Item with a given `DefIndex` was defined during macro expansion with ID `Mark`.",185,N],[12,"next_disambiguator","","",185,N],[12,"def_index_to_span","","",185,N],[3,"DefKey","","A unique identifier that we can use to lookup a definition precisely. It combines the index of the definition's parent (if any) with a `DisambiguatedDefPathData`.",N,N],[12,"parent","","Parent path.",186,N],[12,"disambiguated_data","","Identifier of this node.",186,N],[3,"DisambiguatedDefPathData","","Pair of `DefPathData` and an integer disambiguator. The integer is normally 0, but in the event that there are multiple defs with the same `parent` and `data`, we use this field to disambiguate between them. This introduces some artificial ordering dependency but means that if you have (e.g.) two impls for the same type in the same module, they do get distinct def-ids.",N,N],[12,"data","","",187,N],[12,"disambiguator","","",187,N],[3,"DefPath","","",N,N],[12,"data","","the path leading from the crate root to the item",188,N],[12,"krate","","what krate root is this path relative to?",188,N],[3,"DefPathHash","","",N,N],[12,"0","","",189,N],[4,"DefPathData","","",N,N],[13,"CrateRoot","","The crate root (marker)",190,N],[13,"Misc","","",190,N],[13,"Impl","","An impl",190,N],[13,"Trait","","A trait",190,N],[13,"AssocTypeInTrait","","An associated type declaration (i.e., in a trait)",190,N],[13,"AssocTypeInImpl","","An associated type value (i.e., in an impl)",190,N],[13,"AssocExistentialInImpl","","An existential associated type value (i.e., in an impl)",190,N],[13,"TypeNs","","Something in the type NS",190,N],[13,"ValueNs","","Something in the value NS",190,N],[13,"Module","","A module declaration",190,N],[13,"MacroDef","","A macro rule",190,N],[13,"ClosureExpr","","A closure expression",190,N],[13,"TypeParam","","A type parameter (generic parameter)",190,N],[13,"LifetimeParam","","A lifetime definition",190,N],[13,"EnumVariant","","A variant of a enum",190,N],[13,"Field","","A struct field",190,N],[13,"StructCtor","","Implicit ctor for a tuple-like struct",190,N],[13,"AnonConst","","A constant expression (see {ast,hir}::AnonConst).",190,N],[13,"ImplTrait","","An `impl Trait` type node",190,N],[13,"GlobalMetaData","","GlobalMetaData identifies a piece of crate metadata that is global to a whole crate (as opposed to just one item). GlobalMetaData components are only supposed to show up right below the crate root.",190,N],[4,"GlobalMetaDataKind","","",N,N],[13,"Krate","","",191,N],[13,"CrateDeps","","",191,N],[13,"DylibDependencyFormats","","",191,N],[13,"LangItems","","",191,N],[13,"LangItemsMissing","","",191,N],[13,"NativeLibraries","","",191,N],[13,"SourceMap","","",191,N],[13,"Impls","","",191,N],[13,"ExportedSymbols","","",191,N],[17,"GLOBAL_MD_ADDRESS_SPACE","","",N,N],[17,"FIRST_FREE_HIGH_DEF_INDEX","","",N,N],[11,"clone","","",184,[[["self"]],["self"]]],[11,"allocate","","",184,[[["self"],["defkey"],["defpathhash"],["defindexaddressspace"]],["defindex"]]],[11,"next_id","","",184,[[["self"],["defindexaddressspace"]],["defindex"]]],[11,"def_key","","",184,[[["self"],["defindex"]],["defkey"]]],[11,"def_path_hash","","",184,[[["self"],["defindex"]],["defpathhash"]]],[11,"add_def_path_hashes_to","","",184,[[["self"],["cratenum"],["fxhashmap"]]]],[11,"size","","",184,[[["self"]],["usize"]]],[11,"encode","","",184,[[["self"],["s"]],["result"]]],[11,"decode","","",184,[[["d"]],["result",["defpathtable"]]]],[11,"clone","","",185,[[["self"]],["definitions"]]],[11,"clone","","",186,[[["self"]],["defkey"]]],[11,"eq","","",186,[[["self"],["defkey"]],["bool"]]],[11,"ne","","",186,[[["self"],["defkey"]],["bool"]]],[11,"fmt","","",186,[[["self"],["formatter"]],["result"]]],[11,"hash","","",186,N],[11,"encode","","",186,[[["self"],["__s"]],["result"]]],[11,"decode","","",186,[[["__d"]],["result",["defkey"]]]],[11,"compute_stable_hash","","",186,[[["self"],["defpathhash"]],["defpathhash"]]],[11,"root_parent_stable_hash","","",186,[[["str"],["cratedisambiguator"]],["defpathhash"]]],[11,"clone","","",187,[[["self"]],["disambiguateddefpathdata"]]],[11,"eq","","",187,[[["self"],["disambiguateddefpathdata"]],["bool"]]],[11,"ne","","",187,[[["self"],["disambiguateddefpathdata"]],["bool"]]],[11,"fmt","","",187,[[["self"],["formatter"]],["result"]]],[11,"hash","","",187,N],[11,"encode","","",187,[[["self"],["__s"]],["result"]]],[11,"decode","","",187,[[["__d"]],["result",["disambiguateddefpathdata"]]]],[11,"clone","","",188,[[["self"]],["defpath"]]],[11,"fmt","","",188,[[["self"],["formatter"]],["result"]]],[11,"hash","","",188,N],[11,"encode","","",188,[[["self"],["__s"]],["result"]]],[11,"decode","","",188,[[["__d"]],["result",["defpath"]]]],[11,"is_local","","",188,[[["self"]],["bool"]]],[11,"make","","",188,[[["cratenum"],["defindex"],["fn"]],["defpath"]]],[11,"to_string_no_crate","","Returns a string representation of the DefPath without the crate-prefix. This method is useful if you don't have a TyCtxt available.",188,[[["self"]],["string"]]],[11,"to_string_friendly","","Return filename friendly string of the DefPah with the crate-prefix.",188,[[["self"],["f"]],["string"]]],[11,"to_filename_friendly_no_crate","","Return filename friendly string of the DefPah without the crate-prefix. This method is useful if you don't have a TyCtxt available.",188,[[["self"]],["string"]]],[11,"clone","","",190,[[["self"]],["defpathdata"]]],[11,"fmt","","",190,[[["self"],["formatter"]],["result"]]],[11,"eq","","",190,[[["self"],["defpathdata"]],["bool"]]],[11,"ne","","",190,[[["self"],["defpathdata"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",190,N],[11,"hash","","",190,N],[11,"encode","","",190,[[["self"],["__s"]],["result"]]],[11,"decode","","",190,[[["__d"]],["result",["defpathdata"]]]],[11,"clone","","",189,[[["self"]],["defpathhash"]]],[11,"hash","","",189,N],[11,"eq","","",189,[[["self"],["defpathhash"]],["bool"]]],[11,"ne","","",189,[[["self"],["defpathhash"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",189,N],[11,"partial_cmp","","",189,[[["self"],["defpathhash"]],["option",["ordering"]]]],[11,"lt","","",189,[[["self"],["defpathhash"]],["bool"]]],[11,"le","","",189,[[["self"],["defpathhash"]],["bool"]]],[11,"gt","","",189,[[["self"],["defpathhash"]],["bool"]]],[11,"ge","","",189,[[["self"],["defpathhash"]],["bool"]]],[11,"cmp","","",189,[[["self"],["defpathhash"]],["ordering"]]],[11,"fmt","","",189,[[["self"],["formatter"]],["result"]]],[11,"encode","","",189,[[["self"],["__s"]],["result"]]],[11,"decode","","",189,[[["__d"]],["result",["defpathhash"]]]],[11,"hash_stable","","",189,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"borrow","","",189,[[["self"]],["fingerprint"]]],[11,"new","","Create new empty definition map.",185,[[],["definitions"]]],[11,"def_path_table","","",185,[[["self"]],["defpathtable"]]],[11,"def_index_counts_lo_hi","","Get the number of definitions.",185,N],[11,"def_key","","",185,[[["self"],["defindex"]],["defkey"]]],[11,"def_path_hash","","",185,[[["self"],["defindex"]],["defpathhash"]]],[11,"def_path","","Returns the path from the crate root to `index`. The root nodes are not included in the path (i.e., this will be an empty vector for the crate root). For an inlined item, this will be the path of the item in the external crate (but the path will begin with the path to the external crate).",185,[[["self"],["defindex"]],["defpath"]]],[11,"opt_def_index","","",185,[[["self"],["nodeid"]],["option",["defindex"]]]],[11,"opt_local_def_id","","",185,[[["self"],["nodeid"]],["option",["defid"]]]],[11,"local_def_id","","",185,[[["self"],["nodeid"]],["defid"]]],[11,"as_local_node_id","","",185,[[["self"],["defid"]],["option",["nodeid"]]]],[11,"node_to_hir_id","","",185,[[["self"],["nodeid"]],["hirid"]]],[11,"def_index_to_hir_id","","",185,[[["self"],["defindex"]],["hirid"]]],[11,"opt_span","","Retrieve the span of the given `DefId` if `DefId` is in the local crate, the span exists and it's not DUMMY_SP",185,[[["self"],["defid"]],["option",["span"]]]],[11,"create_root_def","","Add a definition with a parent definition.",185,[[["self"],["str"],["cratedisambiguator"]],["defindex"]]],[11,"create_def_with_parent","","Add a definition with a parent definition.",185,[[["self"],["defindex"],["nodeid"],["defpathdata"],["defindexaddressspace"],["mark"],["span"]],["defindex"]]],[11,"init_node_id_to_hir_id_mapping","","Initialize the ast::NodeId to HirId mapping once it has been generated during AST to HIR lowering.",185,[[["self"],["indexvec",["nodeid","hirid"]]]]],[11,"expansion_that_defined","","",185,[[["self"],["defindex"]],["mark"]]],[11,"parent_module_of_macro_def","","",185,[[["self"],["mark"]],["defid"]]],[11,"add_parent_module_of_macro_def","","",185,[[["self"],["mark"],["defid"]]]],[11,"get_opt_name","","",190,[[["self"]],["option",["internedstring"]]]],[11,"as_interned_str","","",190,[[["self"]],["internedstring"]]],[11,"to_string","","",190,[[["self"]],["string"]]],[11,"clone","","",191,[[["self"]],["globalmetadatakind"]]],[11,"fmt","","",191,[[["self"],["formatter"]],["result"]]],[11,"hash","","",191,N],[11,"encode","","",191,[[["self"],["__s"]],["result"]]],[11,"decode","","",191,[[["__d"]],["result",["globalmetadatakind"]]]],[11,"allocate_def_indices","","",191,[[["definitions"]]]],[11,"def_index","","",191,[[["self"],["defpathtable"]],["defindex"]]],[11,"name","","",191,[[["self"]],["symbol"]]],[0,"hir_id_validator","rustc::hir::map","",N,N],[3,"HirIdValidator","rustc::hir::map::hir_id_validator","",N,N],[12,"hir_map","","",192,N],[12,"owner_def_index","","",192,N],[12,"hir_ids_seen","","",192,N],[12,"errors","","",192,N],[3,"OuterVisitor","","",N,N],[12,"hir_map","","",193,N],[12,"errors","","",193,N],[5,"check_crate","","",N,[[["map"]]]],[11,"new_inner_visitor","","",193,[[["self"],["map"]],["hiridvalidator"]]],[11,"visit_item","","",193,[[["self"],["item"]]]],[11,"visit_trait_item","","",193,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",193,[[["self"],["implitem"]]]],[11,"check","","",192,[[["self"],["nodeid"],["f"]]]],[11,"nested_visit_map","","",192,[[["self"]],["nestedvisitormap"]]],[11,"visit_id","","",192,[[["self"],["nodeid"]]]],[11,"visit_impl_item_ref","","",192,[[["self"],["implitemref"]]]],[17,"ITEM_LIKE_SPACE","rustc::hir::map","",N,N],[17,"REGULAR_SPACE","","",N,N],[8,"Named","","",N,N],[10,"name","","",194,[[["self"]],["name"]]],[11,"clone","","",173,[[["self"]],["entry"]]],[11,"fmt","","",173,[[["self"],["formatter"]],["result"]]],[11,"parent_node","","",173,[[["self"]],["option",["nodeid"]]]],[11,"fn_decl","","",173,[[["self"]],["option",["fndecl"]]]],[11,"associated_body","","",173,[[["self"]],["option",["bodyid"]]]],[11,"is_body_owner","","",173,[[["self"],["nodeid"]],["bool"]]],[11,"new","","",174,[[["crate"],["depgraph"]],["forest"]]],[11,"krate","","",174,[[["self"]],["crate"]]],[11,"clone","","",175,[[["self"]],["map"]]],[11,"read","","Registers a read in the dependency graph of the AST node with the given `id`. This needs to be called each time a public function returns the HIR for a node -- in other words, when it \"reveals\" the content of a node to the caller (who might not otherwise have had access to those contents, and hence needs a read recorded). If the function just returns a DefId or NodeId, no actual content was returned, so no read is needed.",175,[[["self"],["nodeid"]]]],[11,"definitions","","",175,[[["self"]],["definitions"]]],[11,"def_key","","",175,[[["self"],["defid"]],["defkey"]]],[11,"def_path_from_id","","",175,[[["self"],["nodeid"]],["option",["defpath"]]]],[11,"def_path","","",175,[[["self"],["defid"]],["defpath"]]],[11,"local_def_id","","",175,[[["self"],["nodeid"]],["defid"]]],[11,"opt_local_def_id","","",175,[[["self"],["nodeid"]],["option",["defid"]]]],[11,"as_local_node_id","","",175,[[["self"],["defid"]],["option",["nodeid"]]]],[11,"hir_to_node_id","","",175,[[["self"],["hirid"]],["nodeid"]]],[11,"node_to_hir_id","","",175,[[["self"],["nodeid"]],["hirid"]]],[11,"def_index_to_hir_id","","",175,[[["self"],["defindex"]],["hirid"]]],[11,"def_index_to_node_id","","",175,[[["self"],["defindex"]],["nodeid"]]],[11,"local_def_id_to_hir_id","","",175,[[["self"],["localdefid"]],["hirid"]]],[11,"local_def_id_to_node_id","","",175,[[["self"],["localdefid"]],["nodeid"]]],[11,"describe_def","","",175,[[["self"],["nodeid"]],["option",["def"]]]],[11,"entry_count","","",175,[[["self"]],["usize"]]],[11,"find_entry","","",175,[[["self"],["nodeid"]],["option",["entry"]]]],[11,"krate","","",175,[[["self"]],["crate"]]],[11,"trait_item","","",175,[[["self"],["traititemid"]],["traititem"]]],[11,"impl_item","","",175,[[["self"],["implitemid"]],["implitem"]]],[11,"body","","",175,[[["self"],["bodyid"]],["body"]]],[11,"fn_decl","","",175,[[["self"],["nodeid"]],["option",["fndecl"]]]],[11,"body_owner","","Returns the `NodeId` that corresponds to the definition of which this is the body of, i.e. a `fn`, `const` or `static` item (possibly associated), a closure, or a `hir::AnonConst`.",175,[[["self"],["bodyid"]],["nodeid"]]],[11,"body_owner_def_id","","",175,[[["self"],["bodyid"]],["defid"]]],[11,"maybe_body_owned_by","","Given a node id, returns the `BodyId` associated with it, if the node is a body owner, otherwise returns `None`.",175,[[["self"],["nodeid"]],["option",["bodyid"]]]],[11,"body_owned_by","","Given a body owner's id, returns the `BodyId` associated with it.",175,[[["self"],["nodeid"]],["bodyid"]]],[11,"body_owner_kind","","",175,[[["self"],["nodeid"]],["bodyownerkind"]]],[11,"ty_param_owner","","",175,[[["self"],["nodeid"]],["nodeid"]]],[11,"ty_param_name","","",175,[[["self"],["nodeid"]],["name"]]],[11,"trait_impls","","",175,N],[11,"trait_auto_impl","","",175,[[["self"],["defid"]],["option",["nodeid"]]]],[11,"trait_is_auto","","",175,[[["self"],["defid"]],["bool"]]],[11,"krate_attrs","","Get the attributes on the krate. This is preferable to invoking `krate.attrs` because it registers a tighter dep-graph access.",175,N],[11,"get","","Retrieve the Node corresponding to `id`, panicking if it cannot be found.",175,[[["self"],["nodeid"]],["node"]]],[11,"get_if_local","","",175,[[["self"],["defid"]],["option",["node"]]]],[11,"get_generics","","",175,[[["self"],["defid"]],["option",["generics"]]]],[11,"get_generics_span","","",175,[[["self"],["defid"]],["option",["span"]]]],[11,"find","","Retrieve the Node corresponding to `id`, returning None if cannot be found.",175,[[["self"],["nodeid"]],["option",["node"]]]],[11,"get_parent_node","","Similar to get_parent, returns the parent node id or id if there is no parent. Note that the parent may be CRATE_NODE_ID, which is not itself present in the map -- so passing the return value of get_parent_node to get may actually panic. This function returns the immediate parent in the AST, whereas get_parent returns the enclosing item. Note that this might not be the actual parent node in the AST - some kinds of nodes are not in the map and these will never appear as the parent_node. So you can always walk the parent_nodes from a node to the root of the ast (unless you get the same id back here that can happen if the id is not in the map itself or is just weird).",175,[[["self"],["nodeid"]],["nodeid"]]],[11,"is_argument","","Check if the node is an argument. An argument is a local variable whose immediate parent is an item or a closure.",175,[[["self"],["nodeid"]],["bool"]]],[11,"walk_parent_nodes","","If there is some error when walking the parents (e.g., a node does not have a parent in the map or a node can't be found), then we return the last good node id we found. Note that reaching the crate root (id == 0), is not an error, since items in the crate module have the crate root as parent.",175,[[["self"],["nodeid"],["f"],["f2"]],["result",["nodeid","nodeid"]]]],[11,"get_return_block","","Retrieve the NodeId for `id`'s enclosing method, unless there's a `while` or `loop` before reaching it, as block tail returns are not available in them.",175,[[["self"],["nodeid"]],["option",["nodeid"]]]],[11,"get_parent","","Retrieve the NodeId for `id`'s parent item, or `id` itself if no parent item is in this map. The \"parent item\" is the closest parent node in the HIR which is recorded by the map and is an item, either an item in a module, trait, or impl.",175,[[["self"],["nodeid"]],["nodeid"]]],[11,"get_module_parent","","Returns the NodeId of `id`'s nearest module parent, or `id` itself if no module parent is in this map.",175,[[["self"],["nodeid"]],["defid"]]],[11,"get_enclosing_scope","","Returns the nearest enclosing scope. A scope is an item or block. FIXME it is not clear to me that all items qualify as scopes - statics and associated types probably shouldn't, for example. Behavior in this regard should be expected to be highly unstable.",175,[[["self"],["nodeid"]],["option",["nodeid"]]]],[11,"get_parent_did","","",175,[[["self"],["nodeid"]],["defid"]]],[11,"get_foreign_abi","","",175,[[["self"],["nodeid"]],["abi"]]],[11,"expect_item","","",175,[[["self"],["nodeid"]],["item"]]],[11,"expect_impl_item","","",175,[[["self"],["nodeid"]],["implitem"]]],[11,"expect_trait_item","","",175,[[["self"],["nodeid"]],["traititem"]]],[11,"expect_variant_data","","",175,[[["self"],["nodeid"]],["variantdata"]]],[11,"expect_variant","","",175,[[["self"],["nodeid"]],["variant"]]],[11,"expect_foreign_item","","",175,[[["self"],["nodeid"]],["foreignitem"]]],[11,"expect_expr","","",175,[[["self"],["nodeid"]],["expr"]]],[11,"name","","Returns the name associated with the given NodeId's AST.",175,[[["self"],["nodeid"]],["name"]]],[11,"attrs","","Given a node ID, get a list of attributes associated with the AST corresponding to the Node ID",175,N],[11,"nodes_matching_suffix","","Returns an iterator that yields the node id's with paths that match `parts`.  (Requires `parts` is non-empty.)",175,N],[11,"span","","",175,[[["self"],["nodeid"]],["span"]]],[11,"span_if_local","","",175,[[["self"],["defid"]],["option",["span"]]]],[11,"node_to_string","","",175,[[["self"],["nodeid"]],["string"]]],[11,"node_to_user_string","","",175,[[["self"],["nodeid"]],["string"]]],[11,"node_to_pretty_string","","",175,[[["self"],["nodeid"]],["string"]]],[11,"suffix_matches","","Returns true only if some suffix of the module path for parent matches `self.in_which`.",176,[[["self"],["nodeid"]],["bool"]]],[11,"matches_names","","",176,[[["self"],["nodeid"],["name"]],["bool"]]],[11,"next","","",176,[[["self"]],["option",["nodeid"]]]],[11,"name","rustc::hir","",83,[[["self"]],["name"]]],[11,"name","","",87,[[["self"]],["name"]]],[11,"name","","",78,[[["self"]],["name"]]],[11,"name","","",81,[[["self"]],["name"]]],[11,"name","","",63,[[["self"]],["name"]]],[11,"name","","",65,[[["self"]],["name"]]],[11,"nested","rustc::hir::map","",175,[[["self"],["state"],["nested"]],["result"]]],[0,"pat_util","rustc::hir","",N,N],[3,"EnumerateAndAdjust","rustc::hir::pat_util","",N,N],[12,"enumerate","","",195,N],[12,"gap_pos","","",195,N],[12,"gap_len","","",195,N],[8,"EnumerateAndAdjustIterator","","",N,N],[10,"enumerate_and_adjust","","",196,[[["self"],["usize"],["option",["usize"]]],["enumerateandadjust"]]],[11,"next","","",195,[[["self"]],["option"]]],[11,"size_hint","","",195,N],[11,"is_refutable","rustc::hir","",50,[[["self"]],["bool"]]],[11,"is_const","","",50,[[["self"]],["bool"]]],[11,"each_binding","","Call `f` on every \"binding\" in a pattern, e.g., on `a` in `match foo() { Some(a) => (), None => () }`",50,[[["self"],["f"]]]],[11,"contains_bindings","","Checks if the pattern contains any patterns that bind something to an ident, e.g. `foo`, or `Foo(foo)` or `foo @ Bar(..)`.",50,[[["self"]],["bool"]]],[11,"contains_bindings_or_wild","","Checks if the pattern contains any patterns that bind something to an ident or wildcard, e.g. `foo`, or `Foo(_)`, `foo @ Bar(..)`,",50,[[["self"]],["bool"]]],[11,"simple_ident","","",50,[[["self"]],["option",["ident"]]]],[11,"necessary_variants","","Return variants that are necessary to exist for the pattern to match.",50,[[["self"]],["vec",["defid"]]]],[11,"contains_explicit_ref_binding","","Checks if the pattern contains any `ref` or `ref mut` bindings, and if yes whether it contains mutable or just immutables ones.",50,[[["self"]],["option",["mutability"]]]],[11,"contains_explicit_ref_binding","","Checks if the patterns for this arm contain any `ref` or `ref mut` bindings, and if yes whether its containing mutable ones or just immutables ones.",53,[[["self"]],["option",["mutability"]]]],[0,"print","","",N,N],[3,"NoAnn","rustc::hir::print","",N,N],[3,"State","","",N,N],[12,"s","","",197,N],[12,"cm","","",197,N],[12,"comments","","",197,N],[12,"literals","","",197,N],[12,"cur_cmnt","","",197,N],[12,"boxes","","",197,N],[12,"ann","","",197,N],[4,"AnnNode","","",N,N],[13,"Name","","",198,N],[13,"Block","","",198,N],[13,"Item","","",198,N],[13,"SubItem","","",198,N],[13,"Expr","","",198,N],[13,"Pat","","",198,N],[4,"Nested","","",N,N],[13,"Item","","",199,N],[13,"TraitItem","","",199,N],[13,"ImplItem","","",199,N],[13,"Body","","",199,N],[13,"BodyArgPat","","",199,N],[5,"print_crate","","Requires you to pass an input filename and reader so that it can scan the input text for comments and literals to copy forward.",N,[[["sourcemap"],["parsesess"],["crate"],["filename"],["read"],["box",["write"]],["ppann"],["bool"]],["result"]]],[5,"to_string","","",N,[[["ppann"],["f"]],["string"]]],[5,"visibility_qualified","","",N,[[["visibility"],["str"]],["string"]]],[5,"expr_requires_semi_to_be_stmt","","Does this expression require a semicolon to be treated as a statement? The negation of this: 'can this expression be used as a statement without a semicolon' -- is used as an early-bail-out in the parser so that, for instance,     if true {...} else {...}      |x| 5 isn't parsed as (if true {...} else {...} | x) | 5",N,[[["expr"]],["bool"]]],[5,"stmt_ends_with_semi","","this statement requires a semicolon after it. note that in one case (stmt_semi), we've already seen the semicolon, and thus don't need another.",N,[[["stmtkind"]],["bool"]]],[5,"bin_op_to_assoc_op","","",N,[[["binopkind"]],["assocop"]]],[5,"contains_exterior_struct_lit","","Expressions that syntactically contain an \"exterior\" struct literal i.e. not surrounded by any parens or other delimiters, e.g. `X { y: 1 }`, `X { y: 1 }.method()`, `foo == X { y: 1 }` and `X { y: 1 } == foo` all do, but `(X { y: 1 }) == foo` does not.",N,[[["expr"]],["bool"]]],[17,"NO_ANN","","",N,N],[17,"indent_unit","","",N,N],[17,"default_columns","","",N,N],[8,"PpAnn","","",N,N],[11,"nested","","",200,[[["self"],["state"],["nested"]],["result"]]],[11,"pre","","",200,[[["self"],["state"],["annnode"]],["result"]]],[11,"post","","",200,[[["self"],["state"],["annnode"]],["result"]]],[11,"try_fetch_item","","",200,[[["self"],["nodeid"]],["option",["item"]]]],[11,"try_fetch_item","rustc::hir","",47,[[["self"],["nodeid"]],["option",["item"]]]],[11,"nested","","",47,[[["self"],["state"],["nested"]],["result"]]],[11,"writer","rustc::hir::print","",197,[[["self"]],["printer"]]],[11,"boxes","","",197,[[["self"]],["vec"]]],[11,"comments","","",197,[[["self"]],["option"]]],[11,"cur_cmnt","","",197,[[["self"]],["usize"]]],[11,"cur_lit","","",197,[[["self"]],["option",["literal"]]]],[11,"bump_lit","","",197,[[["self"]],["option",["literal"]]]],[11,"new_from_input","","",197,[[["sourcemap"],["parsesess"],["filename"],["read"],["box",["write"]],["ppann"],["bool"]],["state"]]],[11,"new","","",197,[[["sourcemap"],["box",["write"]],["ppann"],["option",["vec"]],["option",["vec"]]],["state"]]],[11,"cbox","","",197,[[["self"],["usize"]],["result"]]],[11,"nbsp","","",197,[[["self"]],["result"]]],[11,"word_nbsp","","",197,[[["self"],["str"]],["result"]]],[11,"head","","",197,[[["self"],["str"]],["result"]]],[11,"bopen","","",197,[[["self"]],["result"]]],[11,"bclose_","","",197,[[["self"],["span"],["usize"]],["result"]]],[11,"bclose_maybe_open","","",197,[[["self"],["span"],["usize"],["bool"]],["result"]]],[11,"bclose","","",197,[[["self"],["span"]],["result"]]],[11,"in_cbox","","",197,[[["self"]],["bool"]]],[11,"space_if_not_bol","","",197,[[["self"]],["result"]]],[11,"break_offset_if_not_bol","","",197,[[["self"],["usize"],["isize"]],["result"]]],[11,"synth_comment","","",197,[[["self"],["string"]],["result"]]],[11,"commasep_cmnt","","",197,N],[11,"commasep_exprs","","",197,N],[11,"print_mod","","",197,N],[11,"print_foreign_mod","","",197,N],[11,"print_opt_lifetime","","",197,[[["self"],["lifetime"]],["result"]]],[11,"print_type","","",197,[[["self"],["ty"]],["result"]]],[11,"print_foreign_item","","",197,[[["self"],["foreignitem"]],["result"]]],[11,"print_associated_const","","",197,[[["self"],["ident"],["ty"],["option",["bodyid"]],["visibility"]],["result"]]],[11,"print_associated_type","","",197,[[["self"],["ident"],["option",["genericbounds"]],["option",["ty"]]],["result"]]],[11,"print_item","","Pretty-print an item",197,[[["self"],["item"]],["result"]]],[11,"print_trait_ref","","",197,[[["self"],["traitref"]],["result"]]],[11,"print_formal_generic_params","","",197,N],[11,"print_poly_trait_ref","","",197,[[["self"],["polytraitref"]],["result"]]],[11,"print_enum_def","","",197,[[["self"],["enumdef"],["generics"],["name"],["span"],["visibility"]],["result"]]],[11,"print_variants","","",197,N],[11,"print_visibility","","",197,[[["self"],["visibility"]],["result"]]],[11,"print_defaultness","","",197,[[["self"],["defaultness"]],["result"]]],[11,"print_struct","","",197,[[["self"],["variantdata"],["generics"],["name"],["span"],["bool"]],["result"]]],[11,"print_variant","","",197,[[["self"],["variant"]],["result"]]],[11,"print_method_sig","","",197,N],[11,"print_trait_item","","",197,[[["self"],["traititem"]],["result"]]],[11,"print_impl_item","","",197,[[["self"],["implitem"]],["result"]]],[11,"print_stmt","","",197,[[["self"],["stmt"]],["result"]]],[11,"print_block","","",197,[[["self"],["block"]],["result"]]],[11,"print_block_unclosed","","",197,[[["self"],["block"]],["result"]]],[11,"print_block_unclosed_indent","","",197,[[["self"],["block"],["usize"]],["result"]]],[11,"print_block_with_attrs","","",197,N],[11,"print_block_maybe_unclosed","","",197,N],[11,"print_else","","",197,[[["self"],["option",["expr"]]],["result"]]],[11,"print_if","","",197,[[["self"],["expr"],["expr"],["option",["expr"]]],["result"]]],[11,"print_if_let","","",197,[[["self"],["pat"],["expr"],["block"],["option",["expr"]]],["result"]]],[11,"print_anon_const","","",197,[[["self"],["anonconst"]],["result"]]],[11,"print_call_post","","",197,N],[11,"print_expr_maybe_paren","","",197,[[["self"],["expr"],["i8"]],["result"]]],[11,"print_expr_as_cond","","Print an expr using syntax that's acceptable in a condition position, such as the `cond` in `if cond { ... }`.",197,[[["self"],["expr"]],["result"]]],[11,"print_expr_vec","","",197,N],[11,"print_expr_repeat","","",197,[[["self"],["expr"],["anonconst"]],["result"]]],[11,"print_expr_struct","","",197,N],[11,"print_expr_tup","","",197,N],[11,"print_expr_call","","",197,N],[11,"print_expr_method_call","","",197,N],[11,"print_expr_binary","","",197,[[["self"],["binop"],["expr"],["expr"]],["result"]]],[11,"print_expr_unary","","",197,[[["self"],["unop"],["expr"]],["result"]]],[11,"print_expr_addr_of","","",197,[[["self"],["mutability"],["expr"]],["result"]]],[11,"print_expr","","",197,[[["self"],["expr"]],["result"]]],[11,"print_local_decl","","",197,[[["self"],["local"]],["result"]]],[11,"print_decl","","",197,[[["self"],["decl"]],["result"]]],[11,"print_usize","","",197,[[["self"],["usize"]],["result"]]],[11,"print_ident","","",197,[[["self"],["ident"]],["result"]]],[11,"print_name","","",197,[[["self"],["name"]],["result"]]],[11,"print_for_decl","","",197,[[["self"],["local"],["expr"]],["result"]]],[11,"print_path","","",197,[[["self"],["path"],["bool"]],["result"]]],[11,"print_qpath","","",197,[[["self"],["qpath"],["bool"]],["result"]]],[11,"print_generic_args","","",197,[[["self"],["genericargs"],["bool"],["bool"]],["result"]]],[11,"print_pat","","",197,[[["self"],["pat"]],["result"]]],[11,"print_arm","","",197,[[["self"],["arm"]],["result"]]],[11,"print_fn","","",197,N],[11,"print_closure_args","","",197,[[["self"],["fndecl"],["bodyid"]],["result"]]],[11,"print_capture_clause","","",197,[[["self"],["captureclause"]],["result"]]],[11,"print_bounds","","",197,N],[11,"print_generic_params","","",197,N],[11,"print_generic_param","","",197,[[["self"],["genericparam"]],["result"]]],[11,"print_lifetime","","",197,[[["self"],["lifetime"]],["result"]]],[11,"print_where_clause","","",197,[[["self"],["whereclause"]],["result"]]],[11,"print_mutability","","",197,[[["self"],["mutability"]],["result"]]],[11,"print_mt","","",197,[[["self"],["mutty"]],["result"]]],[11,"print_fn_output","","",197,[[["self"],["fndecl"]],["result"]]],[11,"print_ty_fn","","",197,N],[11,"maybe_print_trailing_comment","","",197,[[["self"],["span"],["option",["bytepos"]]],["result"]]],[11,"print_remaining_comments","","",197,[[["self"]],["result"]]],[11,"print_opt_abi_and_extern_if_nondefault","","",197,[[["self"],["option",["abi"]]],["result"]]],[11,"print_extern_opt_abi","","",197,[[["self"],["option",["abi"]]],["result"]]],[11,"print_fn_header_info","","",197,[[["self"],["fnheader"],["visibility"]],["result"]]],[11,"print_unsafety","","",197,[[["self"],["unsafety"]],["result"]]],[11,"print_is_auto","","",197,[[["self"],["isauto"]],["result"]]],[6,"HirVec","rustc::hir","HIR doesn't commit to a concrete storage type and has its own alias for a vector. It can be `Vec`, `P<[T]>` or potentially `Box<[T]>`, or some other container with similar behavior. Unlike AST, HIR is mostly a static structure, so we can use an owned slice instead of `Vec` to avoid keeping extra capacity.",N,N],[6,"GenericBounds","","",N,N],[6,"CrateConfig","","",N,N],[6,"BinOp","","",N,N],[6,"Stmt","","A statement",N,N],[6,"Decl","","",N,N],[6,"Variant","","",N,N],[6,"Visibility","","",N,N],[6,"FreevarMap","","",N,N],[6,"CaptureModeMap","","",N,N],[6,"TraitMap","","",N,N],[6,"GlobMap","","",N,N],[17,"CRATE_HIR_ID","","The `HirId` corresponding to CRATE_NODE_ID and CRATE_DEF_INDEX",N,N],[17,"DUMMY_HIR_ID","","",N,N],[17,"DUMMY_ITEM_LOCAL_ID","","",N,N],[11,"clone","","",33,[[["self"]],["hirid"]]],[11,"eq","","",33,[[["self"],["hirid"]],["bool"]]],[11,"ne","","",33,[[["self"],["hirid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",33,N],[11,"hash","","",33,N],[11,"fmt","","",33,[[["self"],["formatter"]],["result"]]],[11,"owner_def_id","","",33,[[["self"]],["defid"]]],[11,"owner_local_def_id","","",33,[[["self"]],["localdefid"]]],[11,"default_encode","","",33,[[["self"],["s"]],["result"]]],[11,"default_decode","","",33,[[["d"]],["result",["hirid"]]]],[11,"clone","","",34,[[["self"]],["itemlocalid"]]],[11,"eq","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"ne","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",34,N],[11,"partial_cmp","","",34,[[["self"],["itemlocalid"]],["option",["ordering"]]]],[11,"lt","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"le","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"gt","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"ge","","",34,[[["self"],["itemlocalid"]],["bool"]]],[11,"cmp","","",34,[[["self"],["itemlocalid"]],["ordering"]]],[11,"hash","","",34,N],[11,"fmt","","",34,[[["self"],["formatter"]],["result"]]],[11,"encode","","",34,[[["self"],["__s"]],["result"]]],[11,"decode","","",34,[[["__d"]],["result",["itemlocalid"]]]],[11,"as_usize","","",34,[[["self"]],["usize"]]],[11,"new","","",34,[[["usize"]],["self"]]],[11,"index","","",34,[[["self"]],["usize"]]],[11,"clone","","",35,[[["self"]],["label"]]],[11,"encode","","",35,[[["self"],["__s"]],["result"]]],[11,"decode","","",35,[[["__d"]],["result",["label"]]]],[11,"fmt","","",35,[[["self"],["formatter"]],["result"]]],[11,"clone","","",36,[[["self"]],["lifetime"]]],[11,"encode","","",36,[[["self"],["__s"]],["result"]]],[11,"decode","","",36,[[["__d"]],["result",["lifetime"]]]],[11,"fmt","","",92,[[["self"],["formatter"]],["result"]]],[11,"clone","","",92,[[["self"]],["paramname"]]],[11,"eq","","",92,[[["self"],["paramname"]],["bool"]]],[11,"ne","","",92,[[["self"],["paramname"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",92,N],[11,"encode","","",92,[[["self"],["__s"]],["result"]]],[11,"decode","","",92,[[["__d"]],["result",["paramname"]]]],[11,"hash","","",92,N],[11,"ident","","",92,[[["self"]],["ident"]]],[11,"modern","","",92,[[["self"]],["paramname"]]],[11,"fmt","","",93,[[["self"],["formatter"]],["result"]]],[11,"clone","","",93,[[["self"]],["lifetimename"]]],[11,"eq","","",93,[[["self"],["lifetimename"]],["bool"]]],[11,"ne","","",93,[[["self"],["lifetimename"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",93,N],[11,"encode","","",93,[[["self"],["__s"]],["result"]]],[11,"decode","","",93,[[["__d"]],["result",["lifetimename"]]]],[11,"hash","","",93,N],[11,"ident","","",93,[[["self"]],["ident"]]],[11,"is_elided","","",93,[[["self"]],["bool"]]],[11,"is_static","","",93,[[["self"]],["bool"]]],[11,"modern","","",93,[[["self"]],["lifetimename"]]],[11,"fmt","","",36,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",36,[[["self"],["formatter"]],["result"]]],[11,"is_elided","","",36,[[["self"]],["bool"]]],[11,"is_static","","",36,[[["self"]],["bool"]]],[11,"clone","","",37,[[["self"]],["path"]]],[11,"encode","","",37,[[["self"],["__s"]],["result"]]],[11,"decode","","",37,[[["__d"]],["result",["path"]]]],[11,"is_global","","",37,[[["self"]],["bool"]]],[11,"fmt","","",37,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",37,[[["self"],["formatter"]],["result"]]],[11,"clone","","",38,[[["self"]],["pathsegment"]]],[11,"encode","","",38,[[["self"],["__s"]],["result"]]],[11,"decode","","",38,[[["__d"]],["result",["pathsegment"]]]],[11,"fmt","","",38,[[["self"],["formatter"]],["result"]]],[11,"from_ident","","Convert an identifier to the corresponding segment.",38,[[["ident"]],["pathsegment"]]],[11,"new","","",38,[[["ident"],["genericargs"],["bool"]],["self"]]],[11,"with_generic_args","","",38,[[["self"],["f"]],["r"]]],[11,"clone","","",94,[[["self"]],["genericarg"]]],[11,"encode","","",94,[[["self"],["__s"]],["result"]]],[11,"decode","","",94,[[["__d"]],["result",["genericarg"]]]],[11,"fmt","","",94,[[["self"],["formatter"]],["result"]]],[11,"span","","",94,[[["self"]],["span"]]],[11,"id","","",94,[[["self"]],["nodeid"]]],[11,"clone","","",39,[[["self"]],["genericargs"]]],[11,"encode","","",39,[[["self"],["__s"]],["result"]]],[11,"decode","","",39,[[["__d"]],["result",["genericargs"]]]],[11,"fmt","","",39,[[["self"],["formatter"]],["result"]]],[11,"none","","",39,[[],["self"]]],[11,"is_empty","","",39,[[["self"]],["bool"]]],[11,"inputs","","",39,N],[11,"own_counts","","",39,[[["self"]],["genericparamcount"]]],[11,"clone","","",95,[[["self"]],["traitboundmodifier"]]],[11,"eq","","",95,[[["self"],["traitboundmodifier"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",95,N],[11,"encode","","",95,[[["self"],["__s"]],["result"]]],[11,"decode","","",95,[[["__d"]],["result",["traitboundmodifier"]]]],[11,"hash","","",95,N],[11,"fmt","","",95,[[["self"],["formatter"]],["result"]]],[11,"clone","","",96,[[["self"]],["genericbound"]]],[11,"encode","","",96,[[["self"],["__s"]],["result"]]],[11,"decode","","",96,[[["__d"]],["result",["genericbound"]]]],[11,"fmt","","",96,[[["self"],["formatter"]],["result"]]],[11,"span","","",96,[[["self"]],["span"]]],[11,"clone","","",97,[[["self"]],["genericparamkind"]]],[11,"encode","","",97,[[["self"],["__s"]],["result"]]],[11,"decode","","",97,[[["__d"]],["result",["genericparamkind"]]]],[11,"fmt","","",97,[[["self"],["formatter"]],["result"]]],[11,"clone","","",40,[[["self"]],["genericparam"]]],[11,"encode","","",40,[[["self"],["__s"]],["result"]]],[11,"decode","","",40,[[["__d"]],["result",["genericparam"]]]],[11,"fmt","","",40,[[["self"],["formatter"]],["result"]]],[11,"default","","",41,[[],["genericparamcount"]]],[11,"clone","","",42,[[["self"]],["generics"]]],[11,"encode","","",42,[[["self"],["__s"]],["result"]]],[11,"decode","","",42,[[["__d"]],["result",["generics"]]]],[11,"fmt","","",42,[[["self"],["formatter"]],["result"]]],[11,"empty","","",42,[[],["generics"]]],[11,"own_counts","","",42,[[["self"]],["genericparamcount"]]],[11,"get_named","","",42,[[["self"],["internedstring"]],["option",["genericparam"]]]],[11,"clone","","",98,[[["self"]],["synthetictyparamkind"]]],[11,"eq","","",98,[[["self"],["synthetictyparamkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",98,N],[11,"encode","","",98,[[["self"],["__s"]],["result"]]],[11,"decode","","",98,[[["__d"]],["result",["synthetictyparamkind"]]]],[11,"hash","","",98,N],[11,"fmt","","",98,[[["self"],["formatter"]],["result"]]],[11,"clone","","",43,[[["self"]],["whereclause"]]],[11,"encode","","",43,[[["self"],["__s"]],["result"]]],[11,"decode","","",43,[[["__d"]],["result",["whereclause"]]]],[11,"fmt","","",43,[[["self"],["formatter"]],["result"]]],[11,"span","","",43,[[["self"]],["option",["span"]]]],[11,"clone","","",99,[[["self"]],["wherepredicate"]]],[11,"encode","","",99,[[["self"],["__s"]],["result"]]],[11,"decode","","",99,[[["__d"]],["result",["wherepredicate"]]]],[11,"fmt","","",99,[[["self"],["formatter"]],["result"]]],[11,"span","","",99,[[["self"]],["span"]]],[11,"clone","","",44,[[["self"]],["whereboundpredicate"]]],[11,"encode","","",44,[[["self"],["__s"]],["result"]]],[11,"decode","","",44,[[["__d"]],["result",["whereboundpredicate"]]]],[11,"fmt","","",44,[[["self"],["formatter"]],["result"]]],[11,"clone","","",45,[[["self"]],["whereregionpredicate"]]],[11,"encode","","",45,[[["self"],["__s"]],["result"]]],[11,"decode","","",45,[[["__d"]],["result",["whereregionpredicate"]]]],[11,"fmt","","",45,[[["self"],["formatter"]],["result"]]],[11,"clone","","",46,[[["self"]],["whereeqpredicate"]]],[11,"encode","","",46,[[["self"],["__s"]],["result"]]],[11,"decode","","",46,[[["__d"]],["result",["whereeqpredicate"]]]],[11,"fmt","","",46,[[["self"],["formatter"]],["result"]]],[11,"clone","","",47,[[["self"]],["crate"]]],[11,"encode","","",47,[[["self"],["__s"]],["result"]]],[11,"decode","","",47,[[["__d"]],["result",["crate"]]]],[11,"fmt","","",47,[[["self"],["formatter"]],["result"]]],[11,"item","","",47,[[["self"],["nodeid"]],["item"]]],[11,"trait_item","","",47,[[["self"],["traititemid"]],["traititem"]]],[11,"impl_item","","",47,[[["self"],["implitemid"]],["implitem"]]],[11,"visit_all_item_likes","","Visits all items in the crate in some deterministic (but unspecified) order. If you just need to process every item, but don't care about nesting, this method is the best choice.",47,[[["self"],["v"]]]],[11,"par_visit_all_item_likes","","A parallel version of visit_all_item_likes",47,[[["self"],["v"]]]],[11,"body","","",47,[[["self"],["bodyid"]],["body"]]],[11,"clone","","",48,[[["self"]],["macrodef"]]],[11,"encode","","",48,[[["self"],["__s"]],["result"]]],[11,"decode","","",48,[[["__d"]],["result",["macrodef"]]]],[11,"fmt","","",48,[[["self"],["formatter"]],["result"]]],[11,"clone","","",49,[[["self"]],["block"]]],[11,"encode","","",49,[[["self"],["__s"]],["result"]]],[11,"decode","","",49,[[["__d"]],["result",["block"]]]],[11,"fmt","","",49,[[["self"],["formatter"]],["result"]]],[11,"clone","","",50,[[["self"]],["pat"]]],[11,"encode","","",50,[[["self"],["__s"]],["result"]]],[11,"decode","","",50,[[["__d"]],["result",["pat"]]]],[11,"fmt","","",50,[[["self"],["formatter"]],["result"]]],[11,"walk_","","",50,[[["self"],["g"]],["bool"]]],[11,"walk","","",50,[[["self"],["f"]],["bool"]]],[11,"clone","","",51,[[["self"]],["fieldpat"]]],[11,"encode","","",51,[[["self"],["__s"]],["result"]]],[11,"decode","","",51,[[["__d"]],["result",["fieldpat"]]]],[11,"fmt","","",51,[[["self"],["formatter"]],["result"]]],[11,"clone","","",100,[[["self"]],["bindingannotation"]]],[11,"eq","","",100,[[["self"],["bindingannotation"]],["bool"]]],[11,"encode","","",100,[[["self"],["__s"]],["result"]]],[11,"decode","","",100,[[["__d"]],["result",["bindingannotation"]]]],[11,"fmt","","",100,[[["self"],["formatter"]],["result"]]],[11,"clone","","",101,[[["self"]],["rangeend"]]],[11,"eq","","",101,[[["self"],["rangeend"]],["bool"]]],[11,"encode","","",101,[[["self"],["__s"]],["result"]]],[11,"decode","","",101,[[["__d"]],["result",["rangeend"]]]],[11,"fmt","","",101,[[["self"],["formatter"]],["result"]]],[11,"clone","","",102,[[["self"]],["patkind"]]],[11,"encode","","",102,[[["self"],["__s"]],["result"]]],[11,"decode","","",102,[[["__d"]],["result",["patkind"]]]],[11,"fmt","","",102,[[["self"],["formatter"]],["result"]]],[11,"clone","","",103,[[["self"]],["mutability"]]],[11,"eq","","",103,[[["self"],["mutability"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",103,N],[11,"partial_cmp","","",103,[[["self"],["mutability"]],["option",["ordering"]]]],[11,"cmp","","",103,[[["self"],["mutability"]],["ordering"]]],[11,"encode","","",103,[[["self"],["__s"]],["result"]]],[11,"decode","","",103,[[["__d"]],["result",["mutability"]]]],[11,"hash","","",103,N],[11,"fmt","","",103,[[["self"],["formatter"]],["result"]]],[11,"and","","Return MutMutable only if both arguments are mutable.",103,[[["self"],["self"]],["self"]]],[11,"clone","","",104,[[["self"]],["binopkind"]]],[11,"eq","","",104,[[["self"],["binopkind"]],["bool"]]],[11,"encode","","",104,[[["self"],["__s"]],["result"]]],[11,"decode","","",104,[[["__d"]],["result",["binopkind"]]]],[11,"fmt","","",104,[[["self"],["formatter"]],["result"]]],[11,"hash","","",104,N],[11,"as_str","","",104,[[["self"]],["str"]]],[11,"is_lazy","","",104,[[["self"]],["bool"]]],[11,"is_shift","","",104,[[["self"]],["bool"]]],[11,"is_comparison","","",104,[[["self"]],["bool"]]],[11,"is_by_value","","Returns `true` if the binary operator takes its arguments by value",104,[[["self"]],["bool"]]],[11,"into","","",104,[[["self"]],["binopkind"]]],[11,"clone","","",105,[[["self"]],["unop"]]],[11,"eq","","",105,[[["self"],["unop"]],["bool"]]],[11,"encode","","",105,[[["self"],["__s"]],["result"]]],[11,"decode","","",105,[[["__d"]],["result",["unop"]]]],[11,"fmt","","",105,[[["self"],["formatter"]],["result"]]],[11,"hash","","",105,N],[11,"as_str","","",105,[[["self"]],["str"]]],[11,"is_by_value","","Returns `true` if the unary operator takes its argument by value",105,[[["self"]],["bool"]]],[11,"fmt","","",106,[[["self"],["formatter"]],["result"]]],[11,"clone","","",106,[[["self"]],["stmtkind"]]],[11,"encode","","",106,[[["self"],["__s"]],["result"]]],[11,"decode","","",106,[[["__d"]],["result",["stmtkind"]]]],[11,"attrs","","",106,N],[11,"id","","",106,[[["self"]],["nodeid"]]],[11,"clone","","",52,[[["self"]],["local"]]],[11,"encode","","",52,[[["self"],["__s"]],["result"]]],[11,"decode","","",52,[[["__d"]],["result",["local"]]]],[11,"fmt","","",52,[[["self"],["formatter"]],["result"]]],[11,"clone","","",107,[[["self"]],["declkind"]]],[11,"encode","","",107,[[["self"],["__s"]],["result"]]],[11,"decode","","",107,[[["__d"]],["result",["declkind"]]]],[11,"fmt","","",107,[[["self"],["formatter"]],["result"]]],[11,"attrs","","",107,N],[11,"is_local","","",107,[[["self"]],["bool"]]],[11,"clone","","",53,[[["self"]],["arm"]]],[11,"encode","","",53,[[["self"],["__s"]],["result"]]],[11,"decode","","",53,[[["__d"]],["result",["arm"]]]],[11,"fmt","","",53,[[["self"],["formatter"]],["result"]]],[11,"clone","","",108,[[["self"]],["guard"]]],[11,"encode","","",108,[[["self"],["__s"]],["result"]]],[11,"decode","","",108,[[["__d"]],["result",["guard"]]]],[11,"fmt","","",108,[[["self"],["formatter"]],["result"]]],[11,"clone","","",54,[[["self"]],["field"]]],[11,"encode","","",54,[[["self"],["__s"]],["result"]]],[11,"decode","","",54,[[["__d"]],["result",["field"]]]],[11,"fmt","","",54,[[["self"],["formatter"]],["result"]]],[11,"clone","","",109,[[["self"]],["blockcheckmode"]]],[11,"eq","","",109,[[["self"],["blockcheckmode"]],["bool"]]],[11,"ne","","",109,[[["self"],["blockcheckmode"]],["bool"]]],[11,"encode","","",109,[[["self"],["__s"]],["result"]]],[11,"decode","","",109,[[["__d"]],["result",["blockcheckmode"]]]],[11,"fmt","","",109,[[["self"],["formatter"]],["result"]]],[11,"clone","","",110,[[["self"]],["unsafesource"]]],[11,"eq","","",110,[[["self"],["unsafesource"]],["bool"]]],[11,"encode","","",110,[[["self"],["__s"]],["result"]]],[11,"decode","","",110,[[["__d"]],["result",["unsafesource"]]]],[11,"fmt","","",110,[[["self"],["formatter"]],["result"]]],[11,"clone","","",55,[[["self"]],["bodyid"]]],[11,"eq","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"ne","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",55,N],[11,"partial_cmp","","",55,[[["self"],["bodyid"]],["option",["ordering"]]]],[11,"lt","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"le","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"gt","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"ge","","",55,[[["self"],["bodyid"]],["bool"]]],[11,"cmp","","",55,[[["self"],["bodyid"]],["ordering"]]],[11,"encode","","",55,[[["self"],["__s"]],["result"]]],[11,"decode","","",55,[[["__d"]],["result",["bodyid"]]]],[11,"hash","","",55,N],[11,"fmt","","",55,[[["self"],["formatter"]],["result"]]],[11,"clone","","",56,[[["self"]],["body"]]],[11,"encode","","",56,[[["self"],["__s"]],["result"]]],[11,"decode","","",56,[[["__d"]],["result",["body"]]]],[11,"fmt","","",56,[[["self"],["formatter"]],["result"]]],[11,"id","","",56,[[["self"]],["bodyid"]]],[11,"clone","","",111,[[["self"]],["bodyownerkind"]]],[11,"fmt","","",111,[[["self"],["formatter"]],["result"]]],[11,"clone","","",57,[[["self"]],["anonconst"]]],[11,"eq","","",57,[[["self"],["anonconst"]],["bool"]]],[11,"ne","","",57,[[["self"],["anonconst"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",57,N],[11,"encode","","",57,[[["self"],["__s"]],["result"]]],[11,"decode","","",57,[[["__d"]],["result",["anonconst"]]]],[11,"fmt","","",57,[[["self"],["formatter"]],["result"]]],[11,"clone","","",58,[[["self"]],["expr"]]],[11,"encode","","",58,[[["self"],["__s"]],["result"]]],[11,"decode","","",58,[[["__d"]],["result",["expr"]]]],[11,"precedence","","",58,[[["self"]],["exprprecedence"]]],[11,"fmt","","",58,[[["self"],["formatter"]],["result"]]],[11,"clone","","",112,[[["self"]],["exprkind"]]],[11,"encode","","",112,[[["self"],["__s"]],["result"]]],[11,"decode","","",112,[[["__d"]],["result",["exprkind"]]]],[11,"fmt","","",112,[[["self"],["formatter"]],["result"]]],[11,"clone","","",113,[[["self"]],["qpath"]]],[11,"encode","","",113,[[["self"],["__s"]],["result"]]],[11,"decode","","",113,[[["__d"]],["result",["qpath"]]]],[11,"fmt","","",113,[[["self"],["formatter"]],["result"]]],[11,"clone","","",114,[[["self"]],["localsource"]]],[11,"encode","","",114,[[["self"],["__s"]],["result"]]],[11,"decode","","",114,[[["__d"]],["result",["localsource"]]]],[11,"fmt","","",114,[[["self"],["formatter"]],["result"]]],[11,"clone","","",115,[[["self"]],["matchsource"]]],[11,"eq","","",115,[[["self"],["matchsource"]],["bool"]]],[11,"ne","","",115,[[["self"],["matchsource"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",115,N],[11,"encode","","",115,[[["self"],["__s"]],["result"]]],[11,"decode","","",115,[[["__d"]],["result",["matchsource"]]]],[11,"hash","","",115,N],[11,"fmt","","",115,[[["self"],["formatter"]],["result"]]],[11,"clone","","",116,[[["self"]],["loopsource"]]],[11,"eq","","",116,[[["self"],["loopsource"]],["bool"]]],[11,"encode","","",116,[[["self"],["__s"]],["result"]]],[11,"decode","","",116,[[["__d"]],["result",["loopsource"]]]],[11,"fmt","","",116,[[["self"],["formatter"]],["result"]]],[11,"clone","","",117,[[["self"]],["loopiderror"]]],[11,"encode","","",117,[[["self"],["__s"]],["result"]]],[11,"decode","","",117,[[["__d"]],["result",["loopiderror"]]]],[11,"fmt","","",117,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",117,[[["self"],["formatter"]],["result"]]],[11,"clone","","",59,[[["self"]],["destination"]]],[11,"encode","","",59,[[["self"],["__s"]],["result"]]],[11,"decode","","",59,[[["__d"]],["result",["destination"]]]],[11,"fmt","","",59,[[["self"],["formatter"]],["result"]]],[11,"clone","","",118,[[["self"]],["generatormovability"]]],[11,"eq","","",118,[[["self"],["generatormovability"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",118,N],[11,"partial_cmp","","",118,[[["self"],["generatormovability"]],["option",["ordering"]]]],[11,"cmp","","",118,[[["self"],["generatormovability"]],["ordering"]]],[11,"encode","","",118,[[["self"],["__s"]],["result"]]],[11,"decode","","",118,[[["__d"]],["result",["generatormovability"]]]],[11,"hash","","",118,N],[11,"fmt","","",118,[[["self"],["formatter"]],["result"]]],[11,"clone","","",119,[[["self"]],["captureclause"]]],[11,"encode","","",119,[[["self"],["__s"]],["result"]]],[11,"decode","","",119,[[["__d"]],["result",["captureclause"]]]],[11,"fmt","","",119,[[["self"],["formatter"]],["result"]]],[11,"clone","","",60,[[["self"]],["mutty"]]],[11,"encode","","",60,[[["self"],["__s"]],["result"]]],[11,"decode","","",60,[[["__d"]],["result",["mutty"]]]],[11,"fmt","","",60,[[["self"],["formatter"]],["result"]]],[11,"clone","","",61,[[["self"]],["methodsig"]]],[11,"encode","","",61,[[["self"],["__s"]],["result"]]],[11,"decode","","",61,[[["__d"]],["result",["methodsig"]]]],[11,"fmt","","",61,[[["self"],["formatter"]],["result"]]],[11,"clone","","",62,[[["self"]],["traititemid"]]],[11,"eq","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"ne","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",62,N],[11,"partial_cmp","","",62,[[["self"],["traititemid"]],["option",["ordering"]]]],[11,"lt","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"le","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"gt","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"ge","","",62,[[["self"],["traititemid"]],["bool"]]],[11,"cmp","","",62,[[["self"],["traititemid"]],["ordering"]]],[11,"encode","","",62,[[["self"],["__s"]],["result"]]],[11,"decode","","",62,[[["__d"]],["result",["traititemid"]]]],[11,"fmt","","",62,[[["self"],["formatter"]],["result"]]],[11,"clone","","",63,[[["self"]],["traititem"]]],[11,"encode","","",63,[[["self"],["__s"]],["result"]]],[11,"decode","","",63,[[["__d"]],["result",["traititem"]]]],[11,"fmt","","",63,[[["self"],["formatter"]],["result"]]],[11,"clone","","",120,[[["self"]],["traitmethod"]]],[11,"encode","","",120,[[["self"],["__s"]],["result"]]],[11,"decode","","",120,[[["__d"]],["result",["traitmethod"]]]],[11,"fmt","","",120,[[["self"],["formatter"]],["result"]]],[11,"clone","","",121,[[["self"]],["traititemkind"]]],[11,"encode","","",121,[[["self"],["__s"]],["result"]]],[11,"decode","","",121,[[["__d"]],["result",["traititemkind"]]]],[11,"fmt","","",121,[[["self"],["formatter"]],["result"]]],[11,"clone","","",64,[[["self"]],["implitemid"]]],[11,"eq","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"ne","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",64,N],[11,"partial_cmp","","",64,[[["self"],["implitemid"]],["option",["ordering"]]]],[11,"lt","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"le","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"gt","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"ge","","",64,[[["self"],["implitemid"]],["bool"]]],[11,"cmp","","",64,[[["self"],["implitemid"]],["ordering"]]],[11,"encode","","",64,[[["self"],["__s"]],["result"]]],[11,"decode","","",64,[[["__d"]],["result",["implitemid"]]]],[11,"fmt","","",64,[[["self"],["formatter"]],["result"]]],[11,"clone","","",65,[[["self"]],["implitem"]]],[11,"encode","","",65,[[["self"],["__s"]],["result"]]],[11,"decode","","",65,[[["__d"]],["result",["implitem"]]]],[11,"fmt","","",65,[[["self"],["formatter"]],["result"]]],[11,"clone","","",122,[[["self"]],["implitemkind"]]],[11,"encode","","",122,[[["self"],["__s"]],["result"]]],[11,"decode","","",122,[[["__d"]],["result",["implitemkind"]]]],[11,"fmt","","",122,[[["self"],["formatter"]],["result"]]],[11,"clone","","",66,[[["self"]],["typebinding"]]],[11,"encode","","",66,[[["self"],["__s"]],["result"]]],[11,"decode","","",66,[[["__d"]],["result",["typebinding"]]]],[11,"fmt","","",66,[[["self"],["formatter"]],["result"]]],[11,"clone","","",67,[[["self"]],["ty"]]],[11,"encode","","",67,[[["self"],["__s"]],["result"]]],[11,"decode","","",67,[[["__d"]],["result",["ty"]]]],[11,"fmt","","",67,[[["self"],["formatter"]],["result"]]],[11,"clone","","",123,[[["self"]],["primty"]]],[11,"eq","","",123,[[["self"],["primty"]],["bool"]]],[11,"ne","","",123,[[["self"],["primty"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",123,N],[11,"encode","","",123,[[["self"],["__s"]],["result"]]],[11,"decode","","",123,[[["__d"]],["result",["primty"]]]],[11,"hash","","",123,N],[11,"fmt","","",123,[[["self"],["formatter"]],["result"]]],[11,"clone","","",68,[[["self"]],["barefnty"]]],[11,"encode","","",68,[[["self"],["__s"]],["result"]]],[11,"decode","","",68,[[["__d"]],["result",["barefnty"]]]],[11,"fmt","","",68,[[["self"],["formatter"]],["result"]]],[11,"clone","","",69,[[["self"]],["existty"]]],[11,"encode","","",69,[[["self"],["__s"]],["result"]]],[11,"decode","","",69,[[["__d"]],["result",["existty"]]]],[11,"fmt","","",69,[[["self"],["formatter"]],["result"]]],[11,"clone","","",124,[[["self"]],["tykind"]]],[11,"encode","","",124,[[["self"],["__s"]],["result"]]],[11,"decode","","",124,[[["__d"]],["result",["tykind"]]]],[11,"fmt","","",124,[[["self"],["formatter"]],["result"]]],[11,"clone","","",70,[[["self"]],["inlineasmoutput"]]],[11,"encode","","",70,[[["self"],["__s"]],["result"]]],[11,"decode","","",70,[[["__d"]],["result",["inlineasmoutput"]]]],[11,"fmt","","",70,[[["self"],["formatter"]],["result"]]],[11,"clone","","",71,[[["self"]],["inlineasm"]]],[11,"encode","","",71,[[["self"],["__s"]],["result"]]],[11,"decode","","",71,[[["__d"]],["result",["inlineasm"]]]],[11,"fmt","","",71,[[["self"],["formatter"]],["result"]]],[11,"clone","","",72,[[["self"]],["arg"]]],[11,"encode","","",72,[[["self"],["__s"]],["result"]]],[11,"decode","","",72,[[["__d"]],["result",["arg"]]]],[11,"fmt","","",72,[[["self"],["formatter"]],["result"]]],[11,"clone","","",73,[[["self"]],["fndecl"]]],[11,"encode","","",73,[[["self"],["__s"]],["result"]]],[11,"decode","","",73,[[["__d"]],["result",["fndecl"]]]],[11,"fmt","","",73,[[["self"],["formatter"]],["result"]]],[11,"clone","","",125,[[["self"]],["isauto"]]],[11,"eq","","",125,[[["self"],["isauto"]],["bool"]]],[11,"encode","","",125,[[["self"],["__s"]],["result"]]],[11,"decode","","",125,[[["__d"]],["result",["isauto"]]]],[11,"fmt","","",125,[[["self"],["formatter"]],["result"]]],[11,"clone","","",126,[[["self"]],["isasync"]]],[11,"eq","","",126,[[["self"],["isasync"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",126,N],[11,"partial_cmp","","",126,[[["self"],["isasync"]],["option",["ordering"]]]],[11,"cmp","","",126,[[["self"],["isasync"]],["ordering"]]],[11,"encode","","",126,[[["self"],["__s"]],["result"]]],[11,"decode","","",126,[[["__d"]],["result",["isasync"]]]],[11,"fmt","","",126,[[["self"],["formatter"]],["result"]]],[11,"clone","","",127,[[["self"]],["unsafety"]]],[11,"eq","","",127,[[["self"],["unsafety"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",127,N],[11,"partial_cmp","","",127,[[["self"],["unsafety"]],["option",["ordering"]]]],[11,"cmp","","",127,[[["self"],["unsafety"]],["ordering"]]],[11,"encode","","",127,[[["self"],["__s"]],["result"]]],[11,"decode","","",127,[[["__d"]],["result",["unsafety"]]]],[11,"hash","","",127,N],[11,"fmt","","",127,[[["self"],["formatter"]],["result"]]],[11,"clone","","",128,[[["self"]],["constness"]]],[11,"eq","","",128,[[["self"],["constness"]],["bool"]]],[11,"encode","","",128,[[["self"],["__s"]],["result"]]],[11,"decode","","",128,[[["__d"]],["result",["constness"]]]],[11,"fmt","","",128,[[["self"],["formatter"]],["result"]]],[11,"clone","","",129,[[["self"]],["defaultness"]]],[11,"eq","","",129,[[["self"],["defaultness"]],["bool"]]],[11,"ne","","",129,[[["self"],["defaultness"]],["bool"]]],[11,"encode","","",129,[[["self"],["__s"]],["result"]]],[11,"decode","","",129,[[["__d"]],["result",["defaultness"]]]],[11,"fmt","","",129,[[["self"],["formatter"]],["result"]]],[11,"has_value","","",129,[[["self"]],["bool"]]],[11,"is_final","","",129,[[["self"]],["bool"]]],[11,"is_default","","",129,[[["self"]],["bool"]]],[11,"fmt","","",127,[[["self"],["formatter"]],["result"]]],[11,"clone","","",130,[[["self"]],["implpolarity"]]],[11,"eq","","",130,[[["self"],["implpolarity"]],["bool"]]],[11,"encode","","",130,[[["self"],["__s"]],["result"]]],[11,"decode","","",130,[[["__d"]],["result",["implpolarity"]]]],[11,"fmt","","",130,[[["self"],["formatter"]],["result"]]],[11,"clone","","",131,[[["self"]],["functionretty"]]],[11,"encode","","",131,[[["self"],["__s"]],["result"]]],[11,"decode","","",131,[[["__d"]],["result",["functionretty"]]]],[11,"fmt","","",131,[[["self"],["formatter"]],["result"]]],[11,"span","","",131,[[["self"]],["span"]]],[11,"clone","","",74,[[["self"]],["mod"]]],[11,"encode","","",74,[[["self"],["__s"]],["result"]]],[11,"decode","","",74,[[["__d"]],["result",["mod"]]]],[11,"fmt","","",74,[[["self"],["formatter"]],["result"]]],[11,"clone","","",75,[[["self"]],["foreignmod"]]],[11,"encode","","",75,[[["self"],["__s"]],["result"]]],[11,"decode","","",75,[[["__d"]],["result",["foreignmod"]]]],[11,"fmt","","",75,[[["self"],["formatter"]],["result"]]],[11,"clone","","",76,[[["self"]],["globalasm"]]],[11,"encode","","",76,[[["self"],["__s"]],["result"]]],[11,"decode","","",76,[[["__d"]],["result",["globalasm"]]]],[11,"fmt","","",76,[[["self"],["formatter"]],["result"]]],[11,"clone","","",77,[[["self"]],["enumdef"]]],[11,"encode","","",77,[[["self"],["__s"]],["result"]]],[11,"decode","","",77,[[["__d"]],["result",["enumdef"]]]],[11,"fmt","","",77,[[["self"],["formatter"]],["result"]]],[11,"clone","","",78,[[["self"]],["variantkind"]]],[11,"encode","","",78,[[["self"],["__s"]],["result"]]],[11,"decode","","",78,[[["__d"]],["result",["variantkind"]]]],[11,"fmt","","",78,[[["self"],["formatter"]],["result"]]],[11,"clone","","",132,[[["self"]],["usekind"]]],[11,"eq","","",132,[[["self"],["usekind"]],["bool"]]],[11,"encode","","",132,[[["self"],["__s"]],["result"]]],[11,"decode","","",132,[[["__d"]],["result",["usekind"]]]],[11,"fmt","","",132,[[["self"],["formatter"]],["result"]]],[11,"clone","","",79,[[["self"]],["traitref"]]],[11,"encode","","",79,[[["self"],["__s"]],["result"]]],[11,"decode","","",79,[[["__d"]],["result",["traitref"]]]],[11,"fmt","","",79,[[["self"],["formatter"]],["result"]]],[11,"clone","","",80,[[["self"]],["polytraitref"]]],[11,"encode","","",80,[[["self"],["__s"]],["result"]]],[11,"decode","","",80,[[["__d"]],["result",["polytraitref"]]]],[11,"fmt","","",80,[[["self"],["formatter"]],["result"]]],[11,"clone","","",133,[[["self"]],["visibilitykind"]]],[11,"encode","","",133,[[["self"],["__s"]],["result"]]],[11,"decode","","",133,[[["__d"]],["result",["visibilitykind"]]]],[11,"fmt","","",133,[[["self"],["formatter"]],["result"]]],[11,"is_pub","","",133,[[["self"]],["bool"]]],[11,"is_pub_restricted","","",133,[[["self"]],["bool"]]],[11,"clone","","",81,[[["self"]],["structfield"]]],[11,"encode","","",81,[[["self"],["__s"]],["result"]]],[11,"decode","","",81,[[["__d"]],["result",["structfield"]]]],[11,"fmt","","",81,[[["self"],["formatter"]],["result"]]],[11,"is_positional","","",81,[[["self"]],["bool"]]],[11,"clone","","",134,[[["self"]],["variantdata"]]],[11,"encode","","",134,[[["self"],["__s"]],["result"]]],[11,"decode","","",134,[[["__d"]],["result",["variantdata"]]]],[11,"fmt","","",134,[[["self"],["formatter"]],["result"]]],[11,"fields","","",134,N],[11,"id","","",134,[[["self"]],["nodeid"]]],[11,"is_struct","","",134,[[["self"]],["bool"]]],[11,"is_tuple","","",134,[[["self"]],["bool"]]],[11,"is_unit","","",134,[[["self"]],["bool"]]],[11,"clone","","",82,[[["self"]],["itemid"]]],[11,"encode","","",82,[[["self"],["__s"]],["result"]]],[11,"decode","","",82,[[["__d"]],["result",["itemid"]]]],[11,"fmt","","",82,[[["self"],["formatter"]],["result"]]],[11,"clone","","",83,[[["self"]],["item"]]],[11,"encode","","",83,[[["self"],["__s"]],["result"]]],[11,"decode","","",83,[[["__d"]],["result",["item"]]]],[11,"fmt","","",83,[[["self"],["formatter"]],["result"]]],[11,"clone","","",84,[[["self"]],["fnheader"]]],[11,"encode","","",84,[[["self"],["__s"]],["result"]]],[11,"decode","","",84,[[["__d"]],["result",["fnheader"]]]],[11,"fmt","","",84,[[["self"],["formatter"]],["result"]]],[11,"clone","","",135,[[["self"]],["itemkind"]]],[11,"encode","","",135,[[["self"],["__s"]],["result"]]],[11,"decode","","",135,[[["__d"]],["result",["itemkind"]]]],[11,"fmt","","",135,[[["self"],["formatter"]],["result"]]],[11,"descriptive_variant","","",135,[[["self"]],["str"]]],[11,"adt_kind","","",135,[[["self"]],["option",["adtkind"]]]],[11,"generics","","",135,[[["self"]],["option",["generics"]]]],[11,"clone","","",85,[[["self"]],["traititemref"]]],[11,"encode","","",85,[[["self"],["__s"]],["result"]]],[11,"decode","","",85,[[["__d"]],["result",["traititemref"]]]],[11,"fmt","","",85,[[["self"],["formatter"]],["result"]]],[11,"clone","","",86,[[["self"]],["implitemref"]]],[11,"encode","","",86,[[["self"],["__s"]],["result"]]],[11,"decode","","",86,[[["__d"]],["result",["implitemref"]]]],[11,"fmt","","",86,[[["self"],["formatter"]],["result"]]],[11,"clone","","",136,[[["self"]],["associateditemkind"]]],[11,"eq","","",136,[[["self"],["associateditemkind"]],["bool"]]],[11,"ne","","",136,[[["self"],["associateditemkind"]],["bool"]]],[11,"encode","","",136,[[["self"],["__s"]],["result"]]],[11,"decode","","",136,[[["__d"]],["result",["associateditemkind"]]]],[11,"fmt","","",136,[[["self"],["formatter"]],["result"]]],[11,"clone","","",87,[[["self"]],["foreignitem"]]],[11,"encode","","",87,[[["self"],["__s"]],["result"]]],[11,"decode","","",87,[[["__d"]],["result",["foreignitem"]]]],[11,"fmt","","",87,[[["self"],["formatter"]],["result"]]],[11,"clone","","",137,[[["self"]],["foreignitemkind"]]],[11,"encode","","",137,[[["self"],["__s"]],["result"]]],[11,"decode","","",137,[[["__d"]],["result",["foreignitemkind"]]]],[11,"fmt","","",137,[[["self"],["formatter"]],["result"]]],[11,"descriptive_variant","","",137,[[["self"]],["str"]]],[11,"fmt","","",88,[[["self"],["formatter"]],["result"]]],[11,"clone","","",88,[[["self"]],["freevar"]]],[11,"encode","","",88,[[["self"],["__s"]],["result"]]],[11,"decode","","",88,[[["__d"]],["result",["freevar"]]]],[11,"var_id","","",88,[[["self"]],["nodeid"]]],[11,"clone","","",89,[[["self"]],["traitcandidate"]]],[11,"fmt","","",89,[[["self"],["formatter"]],["result"]]],[11,"clone","","",90,[[["self"]],["codegenfnattrs"]]],[11,"encode","","",90,[[["self"],["__s"]],["result"]]],[11,"decode","","",90,[[["__d"]],["result",["codegenfnattrs"]]]],[11,"eq","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"ne","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",91,N],[11,"clone","","",91,[[["self"]],["codegenfnattrflags"]]],[11,"partial_cmp","","",91,[[["self"],["codegenfnattrflags"]],["option",["ordering"]]]],[11,"lt","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"le","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"gt","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"ge","","",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"cmp","","",91,[[["self"],["codegenfnattrflags"]],["ordering"]]],[11,"hash","","",91,N],[11,"encode","","",91,[[["self"],["__s"]],["result"]]],[11,"decode","","",91,[[["__d"]],["result",["codegenfnattrflags"]]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result"]]],[18,"COLD","","#[cold], a hint to LLVM that this function, when called, is never on the hot path",91,N],[18,"ALLOCATOR","","#[allocator], a hint to LLVM that the pointer returned from this function is never null",91,N],[18,"UNWIND","","#[unwind], an indicator that this function may unwind despite what its ABI signature may otherwise imply",91,N],[18,"RUSTC_ALLOCATOR_NOUNWIND","","#[rust_allocator_nounwind], an indicator that an imported FFI function will never unwind. Probably obsolete by recent changes with #[unwind], but hasn't been removed/migrated yet",91,N],[18,"NAKED","","#[naked], indicates to LLVM that no function prologue/epilogue should be generated",91,N],[18,"NO_MANGLE","","#[no_mangle], the function's name should be the same as its symbol",91,N],[18,"RUSTC_STD_INTERNAL_SYMBOL","","#[rustc_std_internal_symbol], and indicator that this symbol is a \"weird symbol\" for the standard library in that it has slightly different linkage, visibility, and reachability rules.",91,N],[18,"NO_DEBUG","","#[no_debug], indicates that no debugging information should be generated for this function by LLVM",91,N],[18,"THREAD_LOCAL","","#[thread_local], indicates a static is actually a thread local piece of memory",91,N],[18,"USED","","#[used], indicates that LLVM can't eliminate this function (but the linker can!)",91,N],[11,"empty","","Returns an empty set of flags.",91,[[],["codegenfnattrflags"]]],[11,"all","","Returns the set containing all flags.",91,[[],["codegenfnattrflags"]]],[11,"bits","","Returns the raw value of the flags currently stored.",91,[[["self"]],["u32"]]],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",91,[[["u32"]],["option",["codegenfnattrflags"]]]],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",91,[[["u32"]],["codegenfnattrflags"]]],[11,"is_empty","","Returns `true` if no flags are currently stored.",91,[[["self"]],["bool"]]],[11,"is_all","","Returns `true` if all flags are currently set.",91,[[["self"]],["bool"]]],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",91,[[["self"],["codegenfnattrflags"]],["bool"]]],[11,"insert","","Inserts the specified flags in-place.",91,[[["self"],["codegenfnattrflags"]]]],[11,"remove","","Removes the specified flags in-place.",91,[[["self"],["codegenfnattrflags"]]]],[11,"toggle","","Toggles the specified flags in-place.",91,[[["self"],["codegenfnattrflags"]]]],[11,"set","","Inserts or removes the specified flags depending on the passed value.",91,[[["self"],["codegenfnattrflags"],["bool"]]]],[11,"bitor","","Returns the union of the two sets of flags.",91,[[["self"],["codegenfnattrflags"]],["codegenfnattrflags"]]],[11,"bitor_assign","","Adds the set of flags.",91,[[["self"],["codegenfnattrflags"]]]],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",91,[[["self"],["codegenfnattrflags"]],["codegenfnattrflags"]]],[11,"bitxor_assign","","Toggles the set of flags.",91,[[["self"],["codegenfnattrflags"]]]],[11,"bitand","","Returns the intersection between the two sets of flags.",91,[[["self"],["codegenfnattrflags"]],["codegenfnattrflags"]]],[11,"bitand_assign","","Disables all flags disabled in the set.",91,[[["self"],["codegenfnattrflags"]]]],[11,"sub","","Returns the set difference of the two sets of flags.",91,[[["self"],["codegenfnattrflags"]],["codegenfnattrflags"]]],[11,"sub_assign","","Disables all flags enabled in the set.",91,[[["self"],["codegenfnattrflags"]]]],[11,"not","","Returns the complement of this set of flags.",91,[[["self"]],["codegenfnattrflags"]]],[11,"extend","","",91,[[["self"],["t"]]]],[11,"from_iter","","",91,[[["t"]],["codegenfnattrflags"]]],[11,"new","","",90,[[],["codegenfnattrs"]]],[11,"requests_inline","","True if `#[inline]` or `#[inline(always)]` is present.",90,[[["self"]],["bool"]]],[11,"contains_extern_indicator","","True if `#[no_mangle]` or `#[export_name(...)]` is present.",90,[[["self"]],["bool"]]],[11,"clone","","",138,[[["self"]],["node"]]],[11,"fmt","","",138,[[["self"],["formatter"]],["result"]]],[0,"ich","rustc","ICH - Incremental Compilation Hash",N,N],[3,"CachingSourceMapView","rustc::ich","",N,N],[12,"source_map","","",201,N],[12,"line_cache","","",201,N],[12,"time_stamp","","",201,N],[3,"StableHashingContext","","This is the context state available during incr. comp. hashing. It contains enough information to transform DefIds and HirIds into stable DefPaths (i.e. a reference to the TyCtxt) and it holds a few caches for speeding up various things (e.g. each DefId/DefPath is only hashed once).",N,N],[12,"sess","","",202,N],[12,"definitions","","",202,N],[12,"cstore","","",202,N],[12,"body_resolver","","",202,N],[12,"hash_spans","","",202,N],[12,"hash_bodies","","",202,N],[12,"node_id_hashing_mode","","",202,N],[12,"raw_source_map","","",202,N],[12,"caching_source_map","","",202,N],[4,"NodeIdHashingMode","","",N,N],[13,"Ignore","","",203,N],[13,"HashDefPath","","",203,N],[5,"hash_stable_trait_impls","","",N,N],[0,"caching_codemap_view","","",N,N],[3,"CacheEntry","rustc::ich::caching_codemap_view","",N,N],[12,"time_stamp","","",204,N],[12,"line_number","","",204,N],[12,"line_start","","",204,N],[12,"line_end","","",204,N],[12,"file","","",204,N],[12,"file_index","","",204,N],[3,"CachingSourceMapView","","",N,N],[12,"source_map","","",201,N],[12,"line_cache","","",201,N],[12,"time_stamp","","",201,N],[11,"clone","","",204,[[["self"]],["cacheentry"]]],[11,"clone","rustc::ich","",201,[[["self"]],["cachingsourcemapview"]]],[11,"new","","",201,[[["sourcemap"]],["cachingsourcemapview"]]],[11,"byte_pos_to_line_and_col","","",201,[[["self"],["bytepos"]],["option"]]],[0,"hcx","","",N,N],[3,"StableHashingContext","rustc::ich::hcx","This is the context state available during incr. comp. hashing. It contains enough information to transform DefIds and HirIds into stable DefPaths (i.e. a reference to the TyCtxt) and it holds a few caches for speeding up various things (e.g. each DefId/DefPath is only hashed once).",N,N],[12,"sess","","",202,N],[12,"definitions","","",202,N],[12,"cstore","","",202,N],[12,"body_resolver","","",202,N],[12,"hash_spans","","",202,N],[12,"hash_bodies","","",202,N],[12,"node_id_hashing_mode","","",202,N],[12,"raw_source_map","","",202,N],[12,"caching_source_map","","",202,N],[3,"BodyResolver","","The BodyResolver allows to map a BodyId to the corresponding hir::Body. We could also just store a plain reference to the hir::Crate but we want to avoid that the crate is used to get untracked access to all of the HIR.",N,N],[12,"0","","",205,N],[4,"NodeIdHashingMode","","",N,N],[13,"Ignore","","",203,N],[13,"HashDefPath","","",203,N],[5,"compute_ignored_attr_names","","",N,[[],["fxhashset",["symbol"]]]],[5,"hash_stable_trait_impls","","",N,N],[8,"StableHashingContextProvider","","Something that can provide a stable hashing context.",N,N],[10,"get_stable_hashing_context","","",206,[[["self"]],["stablehashingcontext"]]],[11,"clone","rustc::ich","",202,[[["self"]],["stablehashingcontext"]]],[11,"eq","","",203,[[["self"],["nodeidhashingmode"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",203,N],[11,"clone","","",203,[[["self"]],["nodeidhashingmode"]]],[11,"clone","rustc::ich::hcx","",205,[[["self"]],["bodyresolver"]]],[11,"body","","",205,[[["self"],["bodyid"]],["body"]]],[11,"new","rustc::ich","",202,[[["session"],["crate"],["definitions"],["cratestore"]],["self"]]],[11,"sess","","",202,[[["self"]],["session"]]],[11,"while_hashing_hir_bodies","","",202,[[["self"],["bool"],["f"]]]],[11,"while_hashing_spans","","",202,[[["self"],["bool"],["f"]]]],[11,"with_node_id_hashing_mode","","",202,[[["self"],["nodeidhashingmode"],["f"]]]],[11,"def_path_hash","","",202,[[["self"],["defid"]],["defpathhash"]]],[11,"local_def_path_hash","","",202,[[["self"],["defindex"]],["defpathhash"]]],[11,"node_to_hir_id","","",202,[[["self"],["nodeid"]],["hirid"]]],[11,"hash_bodies","","",202,[[["self"]],["bool"]]],[11,"source_map","","",202,[[["self"]],["cachingsourcemapview"]]],[11,"is_ignored_attr","","",202,[[["self"],["symbol"]],["bool"]]],[11,"hash_hir_item_like","","",202,[[["self"],["f"]]]],[11,"get_stable_hashing_context","","",202,[[["self"]],["stablehashingcontext"]]],[11,"hash_stable","rustc::hir","",55,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",33,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",33,N],[0,"impls_cstore","rustc::ich","This module contains `HashStable` implementations for various data types from rustc::middle::cstore in no particular order.",N,N],[0,"impls_hir","","This module contains `HashStable` implementations for various HIR data types in no particular order.",N,N],[11,"hash_stable","rustc::hir::def_id","",150,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",150,[[["self"],["stablehashingcontext"]],["defpathhash"]]],[11,"hash_stable","","",151,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",151,[[["self"],["stablehashingcontext"]],["defpathhash"]]],[11,"hash_stable","","",152,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",152,[[["self"],["stablehashingcontext"]],["defpathhash"]]],[11,"hash_stable","rustc::hir","",34,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",34,[[["self"],["stablehashingcontext"]],["itemlocalid"]]],[11,"hash_stable","","",82,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",62,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",64,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",92,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",93,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",35,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",36,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",37,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",38,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",94,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",39,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",96,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",95,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",40,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",97,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",42,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",98,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",43,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",99,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",44,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",45,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",46,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",60,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",61,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",66,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",84,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",67,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",123,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",68,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",69,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",124,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",73,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",131,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",79,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",80,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",113,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",48,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",49,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",50,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",51,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",100,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",101,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",102,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",104,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",105,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",52,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",107,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",53,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",108,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",54,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",109,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",110,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",57,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",58,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",112,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",114,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",116,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",115,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",118,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",119,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",59,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",117,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",63,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",120,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",121,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",65,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",122,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",133,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",129,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",130,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",74,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",75,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",77,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",78,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",132,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",81,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",134,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",83,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",135,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",85,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",86,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",136,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",87,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",137,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",106,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",72,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",56,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",55,N],[11,"hash_stable","","",70,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",76,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",71,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","rustc::hir::def","",144,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",145,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",146,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","rustc::hir","",103,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",125,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",127,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",126,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",128,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","rustc::hir::def_id","",149,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",149,[[["self"],["stablehashingcontext"]],["defpathhash"]]],[11,"hash_stable","rustc::hir::def","",143,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","rustc::hir","",89,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"to_stable_hash_key","","",89,N],[11,"hash_stable","","",90,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",91,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",88,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[0,"impls_mir","rustc::ich","This module contains `HashStable` implementations for various MIR data types in no particular order.",N,N],[0,"impls_misc","","This module contains `HashStable` implementations for various data types that don't fit into any of the other impls_xxx modules.",N,N],[0,"impls_ty","","This module contains `HashStable` implementations for various data types from rustc::ty in no particular order.",N,N],[0,"impls_syntax","","This module contains `HashStable` implementations for various data types from libsyntax in no particular order.",N,N],[5,"hash_token","rustc::ich::impls_syntax","",N,[[["token"],["stablehashingcontext"],["stablehasher"]]]],[5,"stable_byte_pos","","",N,[[["bytepos"],["bytepos"]],["u32"]]],[5,"stable_multibyte_char","","",N,N],[5,"stable_non_narrow_char","","",N,N],[17,"ATTR_DIRTY","rustc::ich","",N,N],[17,"ATTR_CLEAN","","",N,N],[17,"ATTR_IF_THIS_CHANGED","","",N,N],[17,"ATTR_THEN_THIS_WOULD_NEED","","",N,N],[17,"ATTR_PARTITION_REUSED","","",N,N],[17,"ATTR_PARTITION_CODEGENED","","",N,N],[17,"DEP_GRAPH_ASSERT_ATTRS","","",N,N],[17,"IGNORED_ATTRIBUTES","","",N,N],[8,"StableHashingContextProvider","","Something that can provide a stable hashing context.",N,N],[10,"get_stable_hashing_context","","",206,[[["self"]],["stablehashingcontext"]]],[0,"infer","rustc","See the Book for more information.",N,N],[3,"TypeFreshener","rustc::infer","",N,N],[12,"infcx","","",207,N],[12,"freshen_count","","",207,N],[12,"freshen_map","","",207,N],[3,"InferOk","","",N,N],[12,"value","","",208,N],[12,"obligations","","",208,N],[3,"InferCtxt","","",N,N],[12,"tcx","","",209,N],[12,"in_progress_tables","","During type-checking/inference of a body, `in_progress_tables` contains a reference to the tables being built up, which are used for reading closure kinds/signatures as they are inferred, and for error reporting logic to read arbitrary node types.",209,N],[12,"projection_cache","","",209,N],[12,"type_variables","","",209,N],[12,"int_unification_table","","",209,N],[12,"float_unification_table","","",209,N],[12,"region_constraints","","",209,N],[12,"lexical_region_resolutions","","",209,N],[12,"selection_cache","","Caches the results of trait selection. This cache is used for things that have to do with the parameters in scope.",209,N],[12,"evaluation_cache","","Caches the results of trait evaluation.",209,N],[12,"reported_trait_errors","","",209,N],[12,"tainted_by_errors_flag","","",209,N],[12,"err_count_on_creation","","",209,N],[12,"in_snapshot","","",209,N],[12,"region_obligations","","",209,N],[12,"universe","","What is the innermost universe we have created? Starts out as `UniverseIndex::root()` but grows from there as we enter universal quantifiers.",209,N],[3,"TypeTrace","","The trace designates the path through inference that we took to encounter an error or subtyping constraint.",N,N],[12,"cause","","",210,N],[12,"values","","",210,N],[3,"RegionObligation","","See the `region_obligations` field for more information.",N,N],[12,"sub_region","","",211,N],[12,"sup_type","","",211,N],[12,"cause","","",211,N],[3,"InferCtxtBuilder","","Helper type of a temporary returned by tcx.infer_ctxt(). Necessary because we can't write the following bound: F: for<'b, 'tcx> where 'gcx: 'tcx FnOnce(InferCtxt<'b, 'gcx, 'tcx>).",N,N],[12,"global_tcx","","",212,N],[12,"arena","","",212,N],[12,"fresh_tables","","",212,N],[3,"CombinedSnapshot","","",N,N],[12,"projection_cache_snapshot","","",213,N],[12,"type_snapshot","","",213,N],[12,"int_snapshot","","",213,N],[12,"float_snapshot","","",213,N],[12,"region_constraints_snapshot","","",213,N],[12,"region_obligations_snapshot","","",213,N],[12,"universe","","",213,N],[12,"was_in_snapshot","","",213,N],[12,"_in_progress_tables","","",213,N],[4,"ValuePairs","","See `error_reporting` module for more details",N,N],[13,"Types","","",214,N],[13,"Regions","","",214,N],[13,"TraitRefs","","",214,N],[13,"PolyTraitRefs","","",214,N],[4,"SubregionOrigin","","The origin of a `r1 <= r2` constraint.",N,N],[13,"Subtype","","",215,N],[13,"InfStackClosure","","",215,N],[13,"InvokeClosure","","",215,N],[13,"DerefPointer","","",215,N],[13,"FreeVariable","","",215,N],[13,"IndexSlice","","",215,N],[13,"RelateObjectBound","","",215,N],[13,"RelateParamBound","","",215,N],[13,"RelateRegionParamBound","","",215,N],[13,"RelateDefaultParamBound","","",215,N],[13,"Reborrow","","",215,N],[13,"ReborrowUpvar","","",215,N],[13,"DataBorrowed","","",215,N],[13,"ReferenceOutlivesReferent","","",215,N],[13,"ParameterInScope","","",215,N],[13,"ExprTypeIsNotInScope","","",215,N],[13,"BindingTypeIsNotValidAtDecl","","",215,N],[13,"CallRcvr","","",215,N],[13,"CallArg","","",215,N],[13,"CallReturn","","",215,N],[13,"Operand","","",215,N],[13,"AddrOf","","",215,N],[13,"AutoBorrow","","",215,N],[13,"SafeDestructor","","",215,N],[13,"CompareImplMethodObligation","","",215,N],[12,"span","rustc::infer::SubregionOrigin","",215,N],[12,"item_name","","",215,N],[12,"impl_item_def_id","","",215,N],[12,"trait_item_def_id","","",215,N],[4,"ParameterOrigin","rustc::infer","Places that type/region parameters can appear.",N,N],[13,"Path","","",216,N],[13,"MethodCall","","",216,N],[13,"OverloadedOperator","","",216,N],[13,"OverloadedDeref","","",216,N],[4,"LateBoundRegionConversionTime","","Times when we replace late-bound regions with variables:",N,N],[13,"FnCall","","when a fn is called",217,N],[13,"HigherRankedType","","when two higher-ranked types are compared",217,N],[13,"AssocTypeProjection","","when projecting an associated type",217,N],[4,"RegionVariableOrigin","","Reasons to create a region inference variable",N,N],[13,"MiscVariable","","",218,N],[13,"PatternRegion","","",218,N],[13,"AddrOfRegion","","",218,N],[13,"Autoref","","",218,N],[13,"Coercion","","",218,N],[13,"EarlyBoundRegion","","",218,N],[13,"LateBoundRegion","","",218,N],[13,"UpvarRegion","","",218,N],[13,"BoundRegionInCoherence","","",218,N],[13,"NLL","","",218,N],[4,"NLLRegionVariableOrigin","","",N,N],[13,"FreeRegion","","",219,N],[13,"BoundRegion","","",219,N],[13,"Existential","","",219,N],[4,"FixupError","","",N,N],[13,"UnresolvedIntTy","","",220,N],[13,"UnresolvedFloatTy","","",220,N],[13,"UnresolvedTy","","",220,N],[0,"opaque_types","","",N,N],[3,"OpaqueTypeDecl","rustc::infer::opaque_types","Information about the opaque, abstract types whose values we are inferring in this function (these are the `impl Trait` that appear in the return type).",N,N],[12,"substs","","The substitutions that we apply to the abstract that that this `impl Trait` desugars to. e.g., if:",221,N],[12,"concrete_ty","","The type variable that represents the value of the abstract type that we require. In other words, after we compile this function, we will be created a constraint like:",221,N],[12,"has_required_region_bounds","","True if the `impl Trait` bounds include region bounds. For example, this would be true for:",221,N],[3,"ReverseMapper","","",N,N],[12,"tcx","","",222,N],[12,"tainted_by_errors","","If errors have already been reported in this fn, we suppress our own errors because they are sometimes derivative.",222,N],[12,"opaque_type_def_id","","",222,N],[12,"map","","",222,N],[12,"map_missing_regions_to_empty","","",222,N],[12,"hidden_ty","","initially `Some`, set to `None` once error has been reported",222,N],[3,"Instantiator","","",N,N],[12,"infcx","","",223,N],[12,"parent_def_id","","",223,N],[12,"body_id","","",223,N],[12,"param_env","","",223,N],[12,"opaque_types","","",223,N],[12,"obligations","","",223,N],[5,"may_define_existential_type","","Whether `opaque_node_id` is a sibling or a child of a sibling of `def_id`",N,[[["tyctxt"],["defid"],["nodeid"]],["bool"]]],[6,"OpaqueTypeMap","","",N,N],[11,"clone","","",221,[[["self"]],["opaquetypedecl"]]],[11,"fmt","","",221,[[["self"],["formatter"]],["result"]]],[11,"instantiate_opaque_types","rustc::infer","Replace all opaque types in `value` with fresh inference variables and creates appropriate obligations. For example, given the input:",209,[[["self"],["defid"],["nodeid"],["paramenv"],["t"]],["inferok"]]],[11,"constrain_opaque_types","","Given the map `opaque_types` containing the existential `impl Trait` types whose underlying, hidden types are being inferred, this method adds constraints to the regions appearing in those underlying hidden types to ensure that they at least do not refer to random scopes within the current function. These constraints are not (quite) sufficient to guarantee that the regions are actually legal values; that final condition is imposed after region inference is done.",209,[[["self"],["opaquetypemap"],["frr"]]]],[11,"constrain_opaque_type","","",209,[[["self"],["defid"],["opaquetypedecl"],["frr"]]]],[11,"infer_opaque_definition_from_instantiation","","Given the fully resolved, instantiated type for an opaque type, i.e., the value of an inference variable like C1 or C2 (*), computes the \"definition type\" for an abstract type definition -- that is, the inferred value of `Foo1<'x>` or `Foo2<'x>` that we would conceptually use in its definition:",209,[[["self"],["defid"],["opaquetypedecl"],["ty"]],["ty"]]],[11,"new","rustc::infer::opaque_types","",222,[[["tyctxt"],["bool"],["defid"],["fxhashmap",["kind","kind"]],["ty"]],["self"]]],[11,"fold_kind_mapping_missing_regions_to_empty","","",222,[[["self"],["kind"]],["kind"]]],[11,"fold_kind_normally","","",222,[[["self"],["kind"]],["kind"]]],[11,"tcx","","",222,[[["self"]],["tyctxt"]]],[11,"fold_region","","",222,[[["self"],["region"]],["region"]]],[11,"fold_ty","","",222,[[["self"],["ty"]],["ty"]]],[11,"instantiate_opaque_types_in_map","","",223,[[["self"],["t"]],["t"]]],[11,"fold_opaque_ty","","",223,[[["self"],["ty"],["defid"],["substs"]],["ty"]]],[0,"at","rustc::infer","A nice interface for working with the infcx.  The basic idea is to do `infcx.at(cause, param_env)`, which sets the \"cause\" of the operation as well as the surrounding parameter environment.  Then you can do something like `.sub(a, b)` or `.eq(a, b)` to create a subtype or equality relationship respectively. The first argument is always the \"expected\" output from the POV of diagnostics.",N,N],[3,"At","rustc::infer::at","",N,N],[12,"infcx","","",224,N],[12,"cause","","",224,N],[12,"param_env","","",224,N],[3,"Trace","","",N,N],[12,"at","","",225,N],[12,"a_is_expected","","",225,N],[12,"trace","","",225,N],[8,"ToTrace","","",N,N],[10,"to_trace","","",226,[[["obligationcause"],["bool"],["self"],["self"]],["typetrace"]]],[11,"at","rustc::infer","",209,[[["self"],["obligationcause"],["paramenv"]],["at"]]],[11,"eq_impl_headers","rustc::infer::at","Hacky routine for equating two impl headers in coherence.",224,[[["self"],["implheader"],["implheader"]],["inferresult"]]],[11,"sub_exp","","Make `a <: b` where `a` may or may not be expected",224,[[["self"],["bool"],["t"],["t"]],["inferresult"]]],[11,"sup","","Make `actual <: expected`. For example, if type-checking a call like `foo(x)`, where `foo: fn(i32)`, you might have `sup(i32, x)`, since the \"expected\" type is the type that appears in the signature.",224,[[["self"],["t"],["t"]],["inferresult"]]],[11,"sub","","Make `expected <: actual`",224,[[["self"],["t"],["t"]],["inferresult"]]],[11,"eq_exp","","Make `expected <: actual`",224,[[["self"],["bool"],["t"],["t"]],["inferresult"]]],[11,"eq","","Make `expected <: actual`",224,[[["self"],["t"],["t"]],["inferresult"]]],[11,"lub","","Compute the least-upper-bound, or mutual supertype, of two values. The order of the arguments doesn't matter, but since this can result in an error (e.g., if asked to compute LUB of u32 and i32), it is meaningful to call one of them the \"expected type\".",224,[[["self"],["t"],["t"]],["inferresult"]]],[11,"glb","","Compute the greatest-lower-bound, or mutual subtype, of two values. As with `lub` order doesn't matter, except for error cases.",224,[[["self"],["t"],["t"]],["inferresult"]]],[11,"trace","","Sets the \"trace\" values that will be used for error-reporting, but doesn't actually perform any operation yet (this is useful when you want to set the trace using distinct values from those you wish to operate upon).",224,[[["self"],["t"],["t"]],["trace"]]],[11,"trace_exp","","Like `trace`, but the expected value is determined by the boolean argument (if true, then the first argument `a` is the \"expected\" value).",224,[[["self"],["bool"],["t"],["t"]],["trace"]]],[11,"sub","","Make `a <: b` where `a` may or may not be expected (if `a_is_expected` is true, then `a` is expected). Make `expected <: actual`",225,[[["self"],["t"],["t"]],["inferresult"]]],[11,"eq","","Make `a == b`; the expectation is set by the call to `trace()`.",225,[[["self"],["t"],["t"]],["inferresult"]]],[11,"lub","","",225,[[["self"],["t"],["t"]],["inferresult"]]],[11,"glb","","",225,[[["self"],["t"],["t"]],["inferresult"]]],[0,"canonical","rustc::infer","Canonicalization is the key to constructing a query in the middle of type inference. Ordinarily, it is not possible to store types from type inference in query keys, because they contain references to inference variables whose lifetimes are too short and so forth. Canonicalizing a value T1 using `canonicalize_query` produces two things:",N,N],[3,"Canonical","rustc::infer::canonical","A \"canonicalized\" type `V` is one where all free inference variables have been rewritten to \"canonical vars\". These are numbered starting from 0 in order of first appearance.",N,N],[12,"variables","","",227,N],[12,"value","","",227,N],[3,"CanonicalVarValues","","A set of values corresponding to the canonical variables from some `Canonical`. You can give these values to `canonical_value.substitute` to substitute them into the canonical value at the right places.",N,N],[12,"var_values","","",228,N],[3,"CanonicalVarInfo","","Information about a canonical variable that is included with the canonical value. This is sufficient information for code to create a copy of the canonical value in some other inference context, with fresh inference variables replacing the canonical values.",N,N],[12,"kind","","",229,N],[3,"QueryResult","","After we execute a query with a canonicalized key, we get back a `Canonical<QueryResult<..>>`. You can use `instantiate_query_result` to access the data in this result.",N,N],[12,"var_values","","",230,N],[12,"region_constraints","","",230,N],[12,"certainty","","",230,N],[12,"value","","",230,N],[4,"CanonicalVarKind","","Describes the \"kind\" of the canonical variable. This is a \"kind\" in the type-theory sense of the term -- i.e., a \"meta\" type system that analyzes type-like values.",N,N],[13,"Ty","","Some kind of type inference variable.",231,N],[13,"Region","","Region variable `'?R`.",231,N],[4,"CanonicalTyVarKind","","Rust actually has more than one category of type variables; notably, the type variables we create for literals (e.g., 22 or 22.) can only be instantiated with integral/float types (e.g., usize or f32). In order to faithfully reproduce a type, we need to know what set of types a given type variable can be unified with.",N,N],[13,"General","","General type variable `?T` that can be unified with arbitrary types.",232,N],[13,"Int","","Integral type variable `?I` (that can only be unified with integral types).",232,N],[13,"Float","","Floating-point type variable `?F` (that can only be unified with float types).",232,N],[4,"Certainty","","Indicates whether or not we were able to prove the query to be true.",N,N],[13,"Proven","","The query is known to be true, presuming that you apply the given `var_values` and the region-constraints are satisfied.",233,N],[13,"Ambiguous","","The query is not known to be true, but also not known to be false. The `var_values` represent either values that must hold in order for the query to be true, or helpful tips that might make it true. Currently rustc's trait solver cannot distinguish the two (e.g., due to our preference for where clauses over impls).",233,N],[0,"canonicalizer","","This module contains the \"canonicalizer\" itself.",N,N],[3,"CanonicalizeRegionMode","rustc::infer::canonical::canonicalizer","If this flag is true, then all free regions will be replaced with a canonical var. This is used to make queries as generic as possible. For example, the query `F: Foo<'static>` would be canonicalized to `F: Foo<'0>`.",N,N],[12,"static_region","","",234,N],[12,"other_free_regions","","",234,N],[3,"Canonicalizer","","",N,N],[12,"infcx","","",235,N],[12,"tcx","","",235,N],[12,"variables","","",235,N],[12,"var_values","","",235,N],[12,"indices","","",235,N],[12,"canonicalize_region_mode","","",235,N],[12,"needs_canonical_flags","","",235,N],[11,"canonicalize_query","rustc::infer","Canonicalizes a query value `V`. When we canonicalize a query, we not only canonicalize unbound inference variables, but we also replace all free regions whatsoever. So for example a query like `T: Trait<'static>` would be canonicalized to",209,[[["self"],["v"],["smallcanonicalvarvalues"]],["canonicalized"]]],[11,"canonicalize_response","","Canonicalizes a query response `V`. When we canonicalize a query response, we only canonicalize unbound inference variables, and we leave other free regions alone. So, continuing with the example from `canonicalize_query`, if there was an input query `T: Trait<'static>`, it would have been canonicalized to",209,[[["self"],["v"]],["canonicalized"]]],[11,"canonicalize_hr_query_hack","","A hacky variant of `canonicalize_query` that does not canonicalize `'static`.  Unfortunately, the existing leak check treaks `'static` differently in some cases (see also #33684), so if we are performing an operation that may need to prove \"leak-check\" related things, we leave `'static` alone.",209,[[["self"],["v"],["smallcanonicalvarvalues"]],["canonicalized"]]],[11,"any","rustc::infer::canonical::canonicalizer","",234,[[["self"]],["bool"]]],[11,"tcx","","",235,[[["self"]],["tyctxt"]]],[11,"fold_region","","",235,[[["self"],["region"]],["region"]]],[11,"fold_ty","","",235,[[["self"],["ty"]],["ty"]]],[11,"canonicalize","","The main `canonicalize` method, shared impl of `canonicalize_query` and `canonicalize_response`.",235,[[["v"],["option",["inferctxt"]],["tyctxt"],["canonicalizeregionmode"],["smallcanonicalvarvalues"]],["canonicalized"]]],[11,"canonical_var","","Creates a canonical variable replacing `kind` from the input, or returns an existing variable if `kind` has already been seen. `kind` is expected to be an unbound variable (or potentially a free region).",235,[[["self"],["canonicalvarinfo"],["kind"]],["canonicalvar"]]],[11,"canonicalize_ty_var","","Given a type variable `ty_var` of the given kind, first check if `ty_var` is bound to anything; if so, canonicalize that. Otherwise, create a new canonical variable for `ty_var`.",235,[[["self"],["canonicaltyvarkind"],["ty"]],["ty"]]],[0,"query_result","rustc::infer::canonical","This module contains the code to instantiate a \"query result\", and in particular to extract out the resulting region obligations and encode them therein.",N,N],[5,"make_query_outlives","rustc::infer::canonical::query_result","Given the region obligations and constraints scraped from the infcx, creates query region constraints.",N,N],[22,"","","",N,N],[11,"enter_canonical_trait_query","rustc::infer","The \"main method\" for a canonicalized trait query. Given the canonical key `canonical_key`, this method will create a new inference context, instantiate the key, and run your operation `op`. The operation should yield up a result (of type `R`) as well as a set of trait obligations that must be fully satisfied. These obligations will be processed and the canonical result created.",212,N],[11,"make_canonicalized_query_result","","This method is meant to be invoked as the final step of a canonical query implementation. It is given:",209,[[["self"],["canonicalvarvalues"],["t"],["fulfillmentcontext"]],["fallible",["canonicalizedqueryresult"]]]],[11,"make_query_result","","Helper for `make_canonicalized_query_result` that does everything up until the final canonicalization.",209,[[["self"],["canonicalvarvalues"],["t"],["fulfillmentcontext"]],["result",["queryresult","nosolution"]]]],[11,"instantiate_query_result_and_region_obligations","","Given the (canonicalized) result to a canonical query, instantiates the result so it can be used, plugging in the values from the canonical query. (Note that the result may have been ambiguous; you should check the certainty level of the query before applying this function.)",209,[[["self"],["obligationcause"],["paramenv"],["smallcanonicalvarvalues"],["canonical"]],["inferresult"]]],[11,"instantiate_nll_query_result_and_region_obligations","","An alternative to `instantiate_query_result_and_region_obligations` that is more efficient for NLL. NLL is a bit more advanced in the \"transition to chalk\" than the rest of the compiler. During the NLL type check, all of the \"processing\" of types and things happens in queries -- the NLL checker itself is only interested in the region obligations (`'a: 'b` or `T: 'b`) that come out of these queries, which it wants to convert into MIR-based constraints and solve. Therefore, it is most convenient for the NLL Type Checker to directly consume the `QueryRegionConstraint` values that arise from doing a query. This is contrast to other parts of the compiler, which would prefer for those `QueryRegionConstraint` to be converted into the older infcx-style constraints (e.g., calls to `sub_regions` or `register_region_obligation`).",209,[[["self"],["obligationcause"],["paramenv"],["smallcanonicalvarvalues"],["canonical"],["vec"]],["inferresult"]]],[11,"query_result_substitution","","Given the original values and the (canonicalized) result from computing a query, returns a substitution that can be applied to the query result to convert the result back into the original namespace.",209,[[["self"],["obligationcause"],["paramenv"],["smallcanonicalvarvalues"],["canonical"]],["inferresult",["canonicalvarvalues"]]]],[11,"query_result_substitution_guess","","Given the original values and the (canonicalized) result from computing a query, returns a guess at a substitution that can be applied to the query result to convert the result back into the original namespace. This is called a guess because it uses a quick heuristic to find the values for each canonical variable; if that quick heuristic fails, then we will instantiate fresh inference variables for each canonical variable instead. Therefore, the result of this method must be properly unified",209,[[["self"],["obligationcause"],["smallcanonicalvarvalues"],["canonical"]],["canonicalvarvalues"]]],[11,"unify_query_result_substitution_guess","","Given a \"guess\" at the values for the canonical variables in the input, try to unify with the actual values found in the query result.  Often, but not always, this is a no-op, because we already found the mapping in the \"guessing\" step.",209,[[["self"],["obligationcause"],["paramenv"],["smallcanonicalvarvalues"],["canonicalvarvalues"],["canonical"]],["inferresult"]]],[11,"query_region_constraints_into_obligations","","Converts the region constraints resulting from a query into an iterator of obligations.",209,N],[11,"unify_canonical_vars","","Given two sets of values for the same set of canonical variables, unify them. The second set is produced lazilly by supplying indices from the first set.",209,N],[0,"substitute","rustc::infer::canonical","This module contains code to substitute new values into a `Canonical<'tcx, T>`.",N,N],[3,"CanonicalVarValuesSubst","rustc::infer::canonical::substitute","",N,N],[12,"tcx","","",236,N],[12,"var_values","","",236,N],[5,"substitute_value","","Substitute the values from `var_values` into `value`. `var_values` must be values for the set of canonical variables that appear in `value`.",N,[[["tyctxt"],["canonicalvarvalues"],["t"]],["t"]]],[11,"substitute","rustc::infer::canonical","Instantiate the wrapped value, replacing each canonical value with the value given in `var_values`.",227,[[["self"],["tyctxt"],["canonicalvarvalues"]],["v"]]],[11,"substitute_projected","","Allows one to apply a substitute to some subset of `self.value`. Invoke `projection_fn` with `self.value` to get a value V that is expressed in terms of the same canonical variables bound in `self` (usually this extracts from subset of `self`). Apply the substitution `var_values` to this value V, replacing each of the canonical variables.",227,N],[11,"tcx","rustc::infer::canonical::substitute","",236,[[["self"]],["tyctxt"]]],[11,"fold_ty","","",236,[[["self"],["ty"]],["ty"]]],[11,"fold_region","","",236,[[["self"],["region"]],["region"]]],[6,"CanonicalVarInfos","rustc::infer::canonical","",N,N],[6,"SmallCanonicalVarValues","","Like CanonicalVarValues, but for use in places where a SmallVec is appropriate.",N,N],[6,"Canonicalized","","",N,N],[6,"CanonicalizedQueryResult","","",N,N],[6,"QueryRegionConstraint","","",N,N],[11,"clone","","",227,[[["self"]],["canonical"]]],[11,"fmt","","",227,[[["self"],["formatter"]],["result"]]],[11,"eq","","",227,[[["self"],["canonical"]],["bool"]]],[11,"ne","","",227,[[["self"],["canonical"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",227,N],[11,"hash","","",227,N],[11,"decode","","",227,[[["__dv"]],["result",["canonical"]]]],[11,"encode","","",227,[[["self"],["__sv"]],["result"]]],[11,"clone","","",228,[[["self"]],["canonicalvarvalues"]]],[11,"fmt","","",228,[[["self"],["formatter"]],["result"]]],[11,"eq","","",228,[[["self"],["canonicalvarvalues"]],["bool"]]],[11,"ne","","",228,[[["self"],["canonicalvarvalues"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",228,N],[11,"hash","","",228,N],[11,"decode","","",228,[[["__d"]],["result",["canonicalvarvalues"]]]],[11,"encode","","",228,[[["self"],["__s"]],["result"]]],[11,"clone","","",229,[[["self"]],["canonicalvarinfo"]]],[11,"fmt","","",229,[[["self"],["formatter"]],["result"]]],[11,"eq","","",229,[[["self"],["canonicalvarinfo"]],["bool"]]],[11,"ne","","",229,[[["self"],["canonicalvarinfo"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",229,N],[11,"hash","","",229,N],[11,"decode","","",229,[[["__d"]],["result",["canonicalvarinfo"]]]],[11,"encode","","",229,[[["self"],["__s"]],["result"]]],[11,"clone","","",231,[[["self"]],["canonicalvarkind"]]],[11,"fmt","","",231,[[["self"],["formatter"]],["result"]]],[11,"eq","","",231,[[["self"],["canonicalvarkind"]],["bool"]]],[11,"ne","","",231,[[["self"],["canonicalvarkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",231,N],[11,"hash","","",231,N],[11,"decode","","",231,[[["__d"]],["result",["canonicalvarkind"]]]],[11,"encode","","",231,[[["self"],["__s"]],["result"]]],[11,"clone","","",232,[[["self"]],["canonicaltyvarkind"]]],[11,"fmt","","",232,[[["self"],["formatter"]],["result"]]],[11,"eq","","",232,[[["self"],["canonicaltyvarkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",232,N],[11,"hash","","",232,N],[11,"decode","","",232,[[["__d"]],["result",["canonicaltyvarkind"]]]],[11,"encode","","",232,[[["self"],["__s"]],["result"]]],[11,"clone","","",230,[[["self"]],["queryresult"]]],[11,"fmt","","",230,[[["self"],["formatter"]],["result"]]],[11,"clone","","",233,[[["self"]],["certainty"]]],[11,"fmt","","",233,[[["self"],["formatter"]],["result"]]],[11,"is_proven","","",233,[[["self"]],["bool"]]],[11,"is_ambiguous","","",233,[[["self"]],["bool"]]],[11,"is_proven","","",230,[[["self"]],["bool"]]],[11,"is_ambiguous","","",230,[[["self"]],["bool"]]],[11,"is_proven","","",227,[[["self"]],["bool"]]],[11,"is_ambiguous","","",227,[[["self"]],["bool"]]],[11,"unchecked_map","","Allows you to map the `value` of a canonical while keeping the same set of bound variables.",227,N],[11,"instantiate_canonical_with_fresh_inference_vars","rustc::infer","Creates a substitution S for the canonical value with fresh inference variables and applies it to the canonical value. Returns both the instantiated result and the substitution S.",209,N],[11,"fresh_inference_vars_for_canonical_vars","","Given the \"infos\" about the canonical variables from some canonical, creates fresh inference variables with the same characteristics. You can then use `substitute` to instantiate the canonical variable with these inference variables.",209,[[["self"],["span"],["list"]],["canonicalvarvalues"]]],[11,"fresh_inference_var_for_canonical_var","","Given the \"info\" about a canonical variable, creates a fresh inference variable with the same characteristics.",209,[[["self"],["span"],["canonicalvarinfo"]],["kind"]]],[11,"super_fold_with","rustc::infer::canonical","",233,[[["self"],["f"]],["certainty"]]],[11,"super_visit_with","","",233,[[["self"],["f"]],["bool"]]],[11,"super_fold_with","","",229,[[["self"],["f"]],["canonicalvarinfo"]]],[11,"super_visit_with","","",229,[[["self"],["f"]],["bool"]]],[11,"super_fold_with","","",231,[[["self"],["f"]],["canonicalvarkind"]]],[11,"super_visit_with","","",231,[[["self"],["f"]],["bool"]]],[11,"lift_to_tcx","","",233,[[["self"],["tyctxt"]],["option"]]],[11,"lift_to_tcx","","",229,[[["self"],["tyctxt"]],["option"]]],[11,"lift_to_tcx","","",231,[[["self"],["tyctxt"]],["option"]]],[11,"super_fold_with","","",237,[[["self"],["f"]],["canonicalvarinfos"]]],[11,"super_visit_with","","",237,[[["self"],["f"]],["bool"]]],[11,"super_fold_with","","",227,[[["self"],["v"]],["self"]]],[11,"super_visit_with","","",227,[[["self"],["v"]],["bool"]]],[11,"lift_to_tcx","","",227,[[["self"],["tyctxt"]],["option",["canonical"]]]],[11,"len","","",228,[[["self"]],["usize"]]],[11,"lift_to_tcx","","",228,[[["self"],["tyctxt"]],["option",["canonicalvarvalues"]]]],[11,"super_fold_with","","",228,[[["self"],["v"]],["self"]]],[11,"super_visit_with","","",228,[[["self"],["v"]],["bool"]]],[11,"super_fold_with","","",230,[[["self"],["v"]],["self"]]],[11,"super_visit_with","","",230,[[["self"],["v"]],["bool"]]],[11,"lift_to_tcx","","",230,[[["self"],["tyctxt"]],["option",["queryresult"]]]],[11,"index","","",228,[[["self"],["canonicalvar"]],["kind"]]],[0,"combine","rustc::infer","",N,N],[3,"CombineFields","rustc::infer::combine","",N,N],[12,"infcx","","",238,N],[12,"trace","","",238,N],[12,"cause","","",238,N],[12,"param_env","","",238,N],[12,"obligations","","",238,N],[3,"Generalizer","","",N,N],[12,"infcx","","",239,N],[12,"span","","Span, used when creating new type variables and things.",239,N],[12,"for_vid_sub_root","","The vid of the type variable that is in the process of being instantiated; if we find this within the type we are folding, that means we would have created a cyclic type.",239,N],[12,"ambient_variance","","Track the variance as we descend into the type.",239,N],[12,"needs_wf","","See the field `needs_wf` in `Generalization`.",239,N],[12,"root_ty","","The root type that we are generalizing. Used when reporting cycles.",239,N],[3,"Generalization","","Result from a generalization operation. This includes not only the generalized type, but also a bool flag indicating whether further WF checks are needed.",N,N],[12,"ty","","",240,N],[12,"needs_wf","","If true, then the generalized type may not be well-formed, even if the source type is well-formed, so we should add an additional check to enforce that it is. This arises in particular around 'bivariant' type parameters that are only constrained by a where-clause. As an example, imagine a type:",240,N],[4,"RelationDir","","",N,N],[13,"SubtypeOf","","",241,N],[13,"SupertypeOf","","",241,N],[13,"EqTo","","",241,N],[5,"int_unification_error","","",N,N],[5,"float_unification_error","","",N,N],[8,"RelateResultCompare","","",N,N],[10,"compare","","",242,[[["self"],["t"],["f"]],["relateresult"]]],[11,"clone","","",238,[[["self"]],["combinefields"]]],[11,"clone","","",241,[[["self"]],["relationdir"]]],[11,"assert_receiver_is_total_eq","","",241,N],[11,"eq","","",241,[[["self"],["relationdir"]],["bool"]]],[11,"hash","","",241,N],[11,"fmt","","",241,[[["self"],["formatter"]],["result"]]],[11,"super_combine_tys","rustc::infer","",209,[[["self"],["r"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"unify_integral_variable","","",209,[[["self"],["bool"],["intvid"],["intvarvalue"]],["relateresult",["ty"]]]],[11,"unify_float_variable","","",209,[[["self"],["bool"],["floatvid"],["floatty"]],["relateresult",["ty"]]]],[11,"tcx","rustc::infer::combine","",238,[[["self"]],["tyctxt"]]],[11,"equate","","",238,[[["self"],["bool"]],["equate"]]],[11,"sub","","",238,[[["self"],["bool"]],["sub"]]],[11,"lub","","",238,[[["self"],["bool"]],["lub"]]],[11,"glb","","",238,[[["self"],["bool"]],["glb"]]],[11,"instantiate","","Here dir is either EqTo, SubtypeOf, or SupertypeOf. The idea is that we should ensure that the type `a_ty` is equal to, a subtype of, or a supertype of (respectively) the type to which `b_vid` is bound.",238,[[["self"],["ty"],["relationdir"],["tyvid"],["bool"]],["relateresult"]]],[11,"generalize","","Attempts to generalize `ty` for the type variable `for_vid`. This checks for cycle -- that is, whether the type `ty` references `for_vid`. The `dir` is the \"direction\" for which we a performing the generalization (i.e., are we producing a type that can be used as a supertype etc).",238,[[["self"],["ty"],["tyvid"],["relationdir"]],["relateresult",["generalization"]]]],[11,"tcx","","",239,[[["self"]],["tyctxt"]]],[11,"tag","","",239,[[["self"]],["str"]]],[11,"a_is_expected","","",239,[[["self"]],["bool"]]],[11,"binders","","",239,[[["self"],["binder"],["binder"]],["relateresult",["binder"]]]],[11,"relate_item_substs","","",239,[[["self"],["defid"],["substs"],["substs"]],["relateresult",["substs"]]]],[11,"relate_with_variance","","",239,[[["self"],["variance"],["t"],["t"]],["relateresult"]]],[11,"tys","","",239,[[["self"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"regions","","",239,[[["self"],["region"],["region"]],["relateresult",["region"]]]],[0,"equate","rustc::infer","",N,N],[3,"Equate","rustc::infer::equate","Ensures `a` is made equal to `b`. Returns `a` on success.",N,N],[12,"fields","","",243,N],[12,"a_is_expected","","",243,N],[11,"new","","",243,[[["combinefields"],["bool"]],["equate"]]],[11,"tag","","",243,[[["self"]],["str"]]],[11,"tcx","","",243,[[["self"]],["tyctxt"]]],[11,"a_is_expected","","",243,[[["self"]],["bool"]]],[11,"relate_item_substs","","",243,[[["self"],["defid"],["substs"],["substs"]],["relateresult",["substs"]]]],[11,"relate_with_variance","","",243,[[["self"],["variance"],["t"],["t"]],["relateresult"]]],[11,"tys","","",243,[[["self"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"regions","","",243,[[["self"],["region"],["region"]],["relateresult",["region"]]]],[11,"binders","","",243,[[["self"],["binder"],["binder"]],["relateresult",["binder"]]]],[0,"error_reporting","rustc::infer","Error Reporting Code for the inference engine",N,N],[4,"FailureCode","rustc::infer::error_reporting","",N,N],[13,"Error0317","","",244,N],[13,"Error0580","","",244,N],[13,"Error0308","","",244,N],[13,"Error0644","","",244,N],[0,"note","","",N,N],[11,"note_region_origin","rustc::infer","",209,[[["self"],["diagnosticbuilder"],["subregionorigin"]]]],[11,"report_concrete_failure","","",209,[[["self"],["scopetree"],["subregionorigin"],["region"],["region"]],["diagnosticbuilder"]]],[0,"need_type_info","rustc::infer::error_reporting","",N,N],[3,"FindLocalByTypeVisitor","rustc::infer::error_reporting::need_type_info","",N,N],[12,"infcx","","",245,N],[12,"target_ty","","",245,N],[12,"hir_map","","",245,N],[12,"found_local_pattern","","",245,N],[12,"found_arg_pattern","","",245,N],[11,"node_matches_type","","",245,[[["self"],["hirid"]],["bool"]]],[11,"nested_visit_map","","",245,[[["self"]],["nestedvisitormap"]]],[11,"visit_local","","",245,[[["self"],["local"]]]],[11,"visit_body","","",245,[[["self"],["body"]]]],[11,"extract_type_name","rustc::infer","",209,[[["self"],["ty"]],["string"]]],[11,"need_type_info_err","","",209,[[["self"],["option",["bodyid"]],["span"],["ty"]],["diagnosticbuilder"]]],[0,"nice_region_error","rustc::infer::error_reporting","",N,N],[3,"NiceRegionError","rustc::infer::error_reporting::nice_region_error","",N,N],[12,"tcx","","",246,N],[12,"error","","",246,N],[12,"regions","","",246,N],[12,"tables","","",246,N],[0,"different_lifetimes","","Error Reporting for Anonymous Region Lifetime Errors where both the regions are anonymous.",N,N],[11,"try_report_anon_anon_conflict","","Print the error message for lifetime errors when both the concerned regions are anonymous.",246,[[["self"]],["option",["errorreported"]]]],[0,"find_anon_type","","",N,N],[3,"FindNestedTypeVisitor","rustc::infer::error_reporting::nice_region_error::find_anon_type","",N,N],[12,"tcx","","",247,N],[12,"bound_region","","",247,N],[12,"found_type","","",247,N],[12,"current_index","","",247,N],[3,"TyPathVisitor","","",N,N],[12,"tcx","","",248,N],[12,"found_it","","",248,N],[12,"bound_region","","",248,N],[12,"current_index","","",248,N],[11,"find_anon_type","rustc::infer::error_reporting::nice_region_error","This function calls the `visit_ty` method for the parameters corresponding to the anonymous regions. The `nested_visitor.found_type` contains the anonymous type.",246,[[["self"],["region"],["boundregion"]],["option"]]],[11,"find_component_for_bound_region","","",246,[[["self"],["ty"],["boundregion"]],["option",["ty"]]]],[11,"nested_visit_map","rustc::infer::error_reporting::nice_region_error::find_anon_type","",247,[[["self"]],["nestedvisitormap"]]],[11,"visit_ty","","",247,[[["self"],["ty"]]]],[11,"nested_visit_map","","",248,[[["self"]],["nestedvisitormap"]]],[11,"visit_lifetime","","",248,[[["self"],["lifetime"]]]],[11,"visit_ty","","",248,[[["self"],["ty"]]]],[0,"named_anon_conflict","rustc::infer::error_reporting::nice_region_error","Error Reporting for Anonymous Region Lifetime Errors where one region is named and the other is anonymous.",N,N],[11,"try_report_named_anon_conflict","","When given a `ConcreteFailure` for a function with arguments containing a named region and an anonymous region, emit an descriptive diagnostic error.",246,[[["self"]],["option",["errorreported"]]]],[11,"is_named_region","","",246,[[["self"],["region"]],["bool"]]],[0,"outlives_closure","","Error Reporting for Anonymous Region Lifetime Errors where both the regions are anonymous.",N,N],[11,"try_report_outlives_closure","","Print the error message for lifetime errors when binding excapes a closure.",246,[[["self"]],["option",["errorreported"]]]],[0,"static_impl_trait","","Error Reporting for static impl Traits.",N,N],[11,"try_report_static_impl_trait","","Print the error message for lifetime errors when the return type is a static impl Trait.",246,[[["self"]],["option",["errorreported"]]]],[0,"util","","Helper functions corresponding to lifetime errors due to anonymous regions.",N,N],[3,"AnonymousArgInfo","rustc::infer::error_reporting::nice_region_error::util","",N,N],[12,"arg","","",249,N],[12,"arg_ty","","",249,N],[12,"bound_region","","",249,N],[12,"arg_ty_span","","",249,N],[12,"is_first","","",249,N],[3,"FreeRegionInfo","","",N,N],[12,"def_id","","",250,N],[12,"boundregion","","",250,N],[12,"is_impl_item","","",250,N],[11,"fmt","","",249,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",250,[[["self"],["formatter"]],["result"]]],[11,"find_arg_with_region","rustc::infer::error_reporting::nice_region_error","",246,[[["self"],["region"],["region"]],["option",["anonymousarginfo"]]]],[11,"is_suitable_region","","",246,[[["self"],["region"]],["option",["freeregioninfo"]]]],[11,"is_return_type_anon","","",246,[[["self"],["defid"],["boundregion"],["fndecl"]],["option",["span"]]]],[11,"is_return_type_impl_trait","","",246,[[["self"],["defid"]],["bool"]]],[11,"is_self_anon","","",246,[[["self"],["bool"],["defid"]],["bool"]]],[11,"is_bound_region_in_impl_item","","",246,[[["self"],["defid"]],["bool"]]],[11,"try_report_nice_region_error","rustc::infer","",209,[[["self"],["regionresolutionerror"]],["bool"]]],[11,"new","rustc::infer::error_reporting::nice_region_error","",246,[[["tyctxt"],["regionresolutionerror"],["option",["typecktables"]]],["self"]]],[11,"new_from_span","","",246,[[["tyctxt"],["span"],["region"],["region"],["option",["typecktables"]]],["self"]]],[11,"try_report_from_nll","","",246,[[["self"]],["option",["errorreported"]]]],[11,"try_report","","",246,[[["self"]],["option",["errorreported"]]]],[11,"get_regions","","",246,N],[11,"report_region_errors","rustc::infer","",209,[[["self"],["scopetree"],["vec"],["bool"]]]],[11,"process_errors","","",209,[[["self"],["vec"]],["vec",["regionresolutionerror"]]]],[11,"check_and_note_conflicting_crates","","Adds a note if the types come from similarly named crates",209,[[["self"],["diagnosticbuilder"],["typeerror"],["span"]]]],[11,"note_error_origin","","",209,[[["self"],["diagnosticbuilder"],["obligationcause"]]]],[11,"highlight_outer","","Given that `other_ty` is the same as a type argument for `name` in `sub`, populate `value` highlighting `name` and every type argument that isn't at `pos` (which is `other_ty`), and populate `other_value` with `other_ty`.",209,[[["self"],["diagnosticstyledstring"],["diagnosticstyledstring"],["string"],["substs"],["usize"],["ty"]]]],[11,"cmp_type_arg","","If `other_ty` is the same as a type argument present in `sub`, highlight `path` in `t1_out`, as that is the difference to the other type.",209,[[["self"],["diagnosticstyledstring"],["diagnosticstyledstring"],["string"],["substs"],["string"],["ty"]],["option"]]],[11,"push_comma","","Add a `,` to the type representation only if it is appropriate.",209,[[["self"],["diagnosticstyledstring"],["diagnosticstyledstring"],["usize"],["usize"]]]],[11,"strip_generic_default_params","","For generic types with parameters with defaults, remove the parameters corresponding to the defaults. This repeats a lot of the logic found in `PrintContext::parameterized`.",209,[[["self"],["defid"],["substs"]],["substs"]]],[11,"cmp","","Compare two given types, eliding parts that are the same between them and highlighting relevant differences, and return two representation of those types for highlighted printing.",209,N],[11,"note_type_err","","",209,[[["self"],["diagnosticbuilder"],["obligationcause"],["option"],["option",["valuepairs"]],["typeerror"]]]],[11,"report_and_explain_type_error","","",209,[[["self"],["typetrace"],["typeerror"]],["diagnosticbuilder"]]],[11,"values_str","","",209,[[["self"],["valuepairs"]],["option"]]],[11,"expected_found_str_ty","","",209,[[["self"],["expectedfound"]],["option"]]],[11,"expected_found_str","","Returns a string of the form \"expected `{}`, found `{}`\".",209,[[["self"],["expectedfound"]],["option"]]],[11,"report_generic_bound_failure","","",209,[[["self"],["scopetree"],["span"],["option",["subregionorigin"]],["generickind"],["region"]]]],[11,"construct_generic_bound_failure","","",209,[[["self"],["scopetree"],["span"],["option",["subregionorigin"]],["generickind"],["region"]],["diagnosticbuilder"]]],[11,"report_sub_sup_conflict","","",209,[[["self"],["scopetree"],["regionvariableorigin"],["subregionorigin"],["region"],["subregionorigin"],["region"]]]],[11,"report_inference_failure","","",209,[[["self"],["regionvariableorigin"]],["diagnosticbuilder"]]],[0,"freshen","","Freshening is the process of replacing unknown variables with fresh types. The idea is that the type, after freshening, contains no inference variables but instead contains either a value for each variable or fresh \"arbitrary\" types wherever a variable would have been.",N,N],[3,"TypeFreshener","rustc::infer::freshen","",N,N],[12,"infcx","","",207,N],[12,"freshen_count","","",207,N],[12,"freshen_map","","",207,N],[11,"new","rustc::infer","",207,[[["inferctxt"]],["typefreshener"]]],[11,"freshen","","",207,[[["self"],["option",["ty"]],["inferty"],["f"]],["ty"]]],[11,"tcx","","",207,[[["self"]],["tyctxt"]]],[11,"fold_region","","",207,[[["self"],["region"]],["region"]]],[11,"fold_ty","","",207,[[["self"],["ty"]],["ty"]]],[0,"fudge","","",N,N],[3,"RegionFudger","rustc::infer::fudge","",N,N],[12,"infcx","","",251,N],[12,"type_variables","","",251,N],[12,"region_vars","","",251,N],[12,"origin","","",251,N],[11,"fudge_regions_if_ok","rustc::infer","This rather funky routine is used while processing expected types. What happens here is that we want to propagate a coercion through the return type of a fn to its argument. Consider the type of `Option::Some`, which is basically `for<T> fn(T) -> Option<T>`. So if we have an expression `Some(&[1, 2, 3])`, and that has the expected type `Option<&[u32]>`, we would like to type check `&[1, 2, 3]` with the expectation of `&[u32]`. This will cause us to coerce from `&[u32; 3]` to `&[u32]` and make the users life more pleasant.",209,[[["self"],["regionvariableorigin"],["f"]],["result"]]],[11,"tcx","rustc::infer::fudge","",251,[[["self"]],["tyctxt"]]],[11,"fold_ty","","",251,[[["self"],["ty"]],["ty"]]],[11,"fold_region","","",251,[[["self"],["region"]],["region"]]],[0,"glb","rustc::infer","",N,N],[3,"Glb","rustc::infer::glb","\"Greatest lower bound\" (common subtype)",N,N],[12,"fields","","",252,N],[12,"a_is_expected","","",252,N],[11,"new","","",252,[[["combinefields"],["bool"]],["glb"]]],[11,"tag","","",252,[[["self"]],["str"]]],[11,"tcx","","",252,[[["self"]],["tyctxt"]]],[11,"a_is_expected","","",252,[[["self"]],["bool"]]],[11,"relate_with_variance","","",252,[[["self"],["variance"],["t"],["t"]],["relateresult"]]],[11,"tys","","",252,[[["self"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"regions","","",252,[[["self"],["region"],["region"]],["relateresult",["region"]]]],[11,"binders","","",252,[[["self"],["binder"],["binder"]],["relateresult",["binder"]]]],[11,"infcx","","",252,[[["self"]],["inferctxt"]]],[11,"cause","","",252,[[["self"]],["obligationcause"]]],[11,"relate_bound","","",252,[[["self"],["ty"],["ty"],["ty"]],["relateresult"]]],[0,"higher_ranked","rustc::infer","Helper routines for higher-ranked things. See the `doc` module at the end of the file for details.",N,N],[3,"HrMatchResult","rustc::infer::higher_ranked","",N,N],[12,"value","","",253,N],[5,"var_ids","","",N,[[["combinefields"],["btreemap"]],["vec",["regionvid"]]]],[5,"is_var_in_set","","",N,N],[5,"fold_regions_in","","",N,[[["tyctxt"],["t"],["f"]],["t"]]],[11,"higher_ranked_sub","rustc::infer::combine","",238,[[["self"],["binder"],["binder"],["bool"]],["relateresult",["binder"]]]],[11,"higher_ranked_match","","The value consists of a pair `(t, u)` where `t` is the matcher and `u` is a value. The idea is to find a substitution `S` such that `S(t) == b`, and then return `S(u)`. In other words, find values for the late-bound regions in `a` that can make `t == b` and then replace the LBR in `u` with those values.",238,[[["self"],["binder"],["t"],["bool"]],["relateresult",["hrmatchresult"]]]],[11,"higher_ranked_lub","","",238,[[["self"],["binder"],["binder"],["bool"]],["relateresult",["binder"]]]],[11,"higher_ranked_glb","","",238,[[["self"],["binder"],["binder"],["bool"]],["relateresult",["binder"]]]],[11,"tainted_regions","rustc::infer","",209,[[["self"],["combinedsnapshot"],["region"],["taintdirections"]],["fxhashset",["region"]]]],[11,"region_vars_confined_to_snapshot","","Returns the set of region variables that do not affect any types/regions which existed before `snapshot` was started. This is used in the sub/lub/glb computations. The idea here is that when we are computing lub/glb of two regions, we sometimes create intermediate region variables. Those region variables may touch some of the skolemized or other \"forbidden\" regions we created to replace bound regions, but they don't really represent an \"external\" constraint.",209,[[["self"],["combinedsnapshot"]],["vec",["regionvid"]]]],[11,"skolemize_late_bound_regions","","Replace all regions bound by `binder` with skolemized regions and return a map indicating which bound-region was replaced with what skolemized region. This is the first step of checking subtyping when higher-ranked things are involved.",209,N],[11,"leak_check","","Searches the region constraints created since `snapshot` was started and checks to determine whether any of the skolemized regions created in `skol_map` would \"escape\" -- meaning that they are related to other regions in some way. If so, the higher-ranked subtyping doesn't hold. See `README.md` for more details.",209,[[["self"],["bool"],["span"],["skolemizationmap"],["combinedsnapshot"]],["relateresult"]]],[11,"plug_leaks","","This code converts from skolemized regions back to late-bound regions. It works by replacing each region in the taint set of a skolemized region with a bound-region. The bound region will be bound by the outer-most binder in `value`; the caller must ensure that there is such a binder and it is the right place.",209,[[["self"],["skolemizationmap"],["combinedsnapshot"],["t"]],["t"]]],[11,"pop_skolemized","","Pops the skolemized regions found in `skol_map` from the region inference context. Whenever you create skolemized regions via `skolemize_late_bound_regions`, they must be popped before you commit the enclosing snapshot (if you do not commit, e.g. within a probe or as a result of an error, then this is not necessary, as popping happens as part of the rollback).",209,[[["self"],["skolemizationmap"],["combinedsnapshot"]]]],[0,"lattice","","Lattice Variables",N,N],[5,"super_lattice_tys","rustc::infer::lattice","",N,[[["l"],["ty"],["ty"]],["relateresult",["ty"]]]],[8,"LatticeDir","","",N,N],[10,"infcx","","",254,[[["self"]],["inferctxt"]]],[10,"cause","","",254,[[["self"]],["obligationcause"]]],[10,"relate_bound","","",254,[[["self"],["ty"],["ty"],["ty"]],["relateresult"]]],[0,"lexical_region_resolve","rustc::infer","The code to do lexical region resolution.",N,N],[3,"LexicalRegionResolutions","rustc::infer::lexical_region_resolve","Contains the result of lexical region resolution. Offers methods to lookup up the final value of a region variable.",N,N],[12,"values","","",255,N],[12,"error_region","","",255,N],[3,"RegionAndOrigin","","",N,N],[12,"region","","",256,N],[12,"origin","","",256,N],[3,"LexicalResolver","","",N,N],[12,"region_rels","","",257,N],[12,"var_infos","","",257,N],[12,"data","","",257,N],[4,"VarValue","","",N,N],[13,"Value","","",258,N],[13,"ErrorValue","","",258,N],[4,"RegionResolutionError","","",N,N],[13,"ConcreteFailure","","`ConcreteFailure(o, a, b)`:",259,N],[13,"GenericBoundFailure","","`GenericBoundFailure(p, s, a)",259,N],[13,"SubSupConflict","","`SubSupConflict(v, sub_origin, sub_r, sup_origin, sup_r)`:",259,N],[5,"resolve","","This function performs lexical region resolution given a complete set of constraints and variable origins. It performs a fixed-point iteration to find region values which satisfy all constraints, assuming such values can be found. It returns the final values of all the variables as well as a set of errors that must be reported.",N,N],[0,"graphviz","","This module provides linkage between libgraphviz traits and `rustc::middle::typeck::infer::region_constraints`, generating a rendering of the graph represented by the list of `Constraint` instances (which make up the edges of the graph), as well as the origin for each constraint (which are attached to the labels on each edge).",N,N],[3,"ConstraintGraph","rustc::infer::lexical_region_resolve::graphviz","",N,N],[12,"graph_name","","",260,N],[12,"region_rels","","",260,N],[12,"map","","",260,N],[12,"node_ids","","",260,N],[4,"Node","","",N,N],[13,"RegionVid","","",261,N],[13,"Region","","",261,N],[4,"Edge","","",N,N],[13,"Constraint","","",262,N],[13,"EnclScope","","",262,N],[5,"print_help_message","","",N,[[]]],[5,"maybe_print_constraints_for","","",N,[[["regionconstraintdata"],["regionrelations"]]]],[5,"constraint_to_nodes","","",N,N],[5,"edge_to_nodes","","",N,N],[5,"dump_region_data_to","","",N,[[["regionrelations"],["btreemap"],["str"]],["result"]]],[6,"ConstraintMap","","",N,N],[11,"clone","","",261,[[["self"]],["node"]]],[11,"hash","","",261,N],[11,"eq","","",261,[[["self"],["node"]],["bool"]]],[11,"ne","","",261,[[["self"],["node"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",261,N],[11,"fmt","","",261,[[["self"],["formatter"]],["result"]]],[11,"clone","","",262,[[["self"]],["edge"]]],[11,"eq","","",262,[[["self"],["edge"]],["bool"]]],[11,"ne","","",262,[[["self"],["edge"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",262,N],[11,"fmt","","",262,[[["self"],["formatter"]],["result"]]],[11,"new","","",260,[[["string"],["regionrelations"],["btreemap"]],["constraintgraph"]]],[11,"graph_id","","",260,[[["self"]],["id"]]],[11,"node_id","","",260,[[["self"],["node"]],["id"]]],[11,"node_label","","",260,[[["self"],["node"]],["labeltext"]]],[11,"edge_label","","",260,[[["self"],["edge"]],["labeltext"]]],[11,"nodes","","",260,[[["self"]],["nodes",["node"]]]],[11,"edges","","",260,[[["self"]],["edges",["edge"]]]],[11,"source","","",260,[[["self"],["edge"]],["node"]]],[11,"target","","",260,[[["self"],["edge"]],["node"]]],[6,"RegionGraph","rustc::infer::lexical_region_resolve","",N,N],[11,"clone","","",258,[[["self"]],["varvalue"]]],[11,"fmt","","",258,[[["self"],["formatter"]],["result"]]],[11,"clone","","",259,[[["self"]],["regionresolutionerror"]]],[11,"fmt","","",259,[[["self"],["formatter"]],["result"]]],[11,"infer_variable_values","","",257,[[["self"],["vec"]],["lexicalregionresolutions"]]],[11,"num_vars","","",257,[[["self"]],["usize"]]],[11,"construct_var_data","","Initially, the value for all variables is set to `'empty`, the empty region. The `expansion` phase will grow this larger.",257,[[["self"],["tyctxt"]],["lexicalregionresolutions"]]],[11,"dump_constraints","","",257,[[["self"],["regionrelations"]]]],[11,"expand_givens","","",257,[[["self"],["graph"]]]],[11,"expansion","","",257,[[["self"],["lexicalregionresolutions"]]]],[11,"expand_node","","",257,[[["self"],["region"],["regionvid"],["varvalue"]],["bool"]]],[11,"lub_concrete_regions","","",257,[[["self"],["region"],["region"]],["region"]]],[11,"collect_errors","","After expansion is complete, go and check upper bounds (i.e., cases where the region cannot grow larger than a fixed point) and check that they are satisfied.",257,[[["self"],["lexicalregionresolutions"],["vec"]]]],[11,"collect_var_errors","","Go over the variables that were declared to be error variables and create a `RegionResolutionError` for each of them.",257,[[["self"],["lexicalregionresolutions"],["graph"],["vec"]]]],[11,"construct_graph","","",257,[[["self"]],["graph",["constraint"]]]],[11,"collect_error_for_expanding_node","","",257,N],[11,"collect_concrete_regions","","",257,N],[11,"iterate_until_fixed_point","","",257,[[["self"],["str"],["f"]]]],[11,"bound_is_met","","",257,[[["self"],["verifybound"],["lexicalregionresolutions"],["region"]],["bool"]]],[11,"fmt","","",256,[[["self"],["formatter"]],["result"]]],[11,"normalize","","",255,[[["self"],["region"]],["region"]]],[11,"value","","",255,[[["self"],["regionvid"]],["varvalue"]]],[11,"value_mut","","",255,[[["self"],["regionvid"]],["varvalue"]]],[11,"resolve_var","","",255,[[["self"],["regionvid"]],["region"]]],[0,"lub","rustc::infer","",N,N],[3,"Lub","rustc::infer::lub","\"Least upper bound\" (common supertype)",N,N],[12,"fields","","",263,N],[12,"a_is_expected","","",263,N],[11,"new","","",263,[[["combinefields"],["bool"]],["lub"]]],[11,"tag","","",263,[[["self"]],["str"]]],[11,"tcx","","",263,[[["self"]],["tyctxt"]]],[11,"a_is_expected","","",263,[[["self"]],["bool"]]],[11,"relate_with_variance","","",263,[[["self"],["variance"],["t"],["t"]],["relateresult"]]],[11,"tys","","",263,[[["self"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"regions","","",263,[[["self"],["region"],["region"]],["relateresult",["region"]]]],[11,"binders","","",263,[[["self"],["binder"],["binder"]],["relateresult",["binder"]]]],[11,"infcx","","",263,[[["self"]],["inferctxt"]]],[11,"cause","","",263,[[["self"]],["obligationcause"]]],[11,"relate_bound","","",263,[[["self"],["ty"],["ty"],["ty"]],["relateresult"]]],[0,"outlives","rustc::infer","Various code related to computing outlives relations.",N,N],[0,"env","rustc::infer::outlives","",N,N],[3,"OutlivesEnvironment","rustc::infer::outlives::env","The `OutlivesEnvironment` collects information about what outlives what in a given type-checking setting. For example, if we have a where-clause like `where T: 'a` in scope, then the `OutlivesEnvironment` would record that (in its `region_bound_pairs` field). Similarly, it contains methods for processing and adding implied bounds into the outlives environment.",N,N],[12,"param_env","","",264,N],[12,"free_region_map","","",264,N],[12,"region_bound_pairs","","",264,N],[11,"clone","","",264,[[["self"]],["outlivesenvironment"]]],[11,"new","","",264,[[["paramenv"]],["self"]]],[11,"free_region_map","","Borrows current value of the `free_region_map`.",264,[[["self"]],["freeregionmap"]]],[11,"region_bound_pairs","","Borrows current value of the `region_bound_pairs`.",264,N],[11,"into_free_region_map","","Returns ownership of the `free_region_map`.",264,[[["self"]],["freeregionmap"]]],[11,"push_snapshot_pre_closure","","This is a hack to support the old-skool regionck, which processes region constraints from the main function and the closure together. In that context, when we enter a closure, we want to be able to \"save\" the state of the surrounding a function. We can then add implied bounds and the like from the closure arguments into the environment -- these should only apply in the closure body, so once we exit, we invoke `pop_snapshot_post_closure` to remove them.",264,[[["self"]],["usize"]]],[11,"pop_snapshot_post_closure","","See `push_snapshot_pre_closure`.",264,[[["self"],["usize"]]]],[11,"add_implied_bounds","","This method adds \"implied bounds\" into the outlives environment. Implied bounds are outlives relationships that we can deduce on the basis that certain types must be well-formed -- these are either the types that appear in the function signature or else the input types to an impl. For example, if you have a function like",264,N],[11,"add_outlives_bounds","","Processes outlives bounds that are known to hold, whether from implied or other sources.",264,[[["self"],["option",["inferctxt"]],["i"]]]],[0,"free_region_map","rustc::infer::outlives","",N,N],[3,"FreeRegionMap","rustc::infer::outlives::free_region_map","",N,N],[12,"relation","","",265,N],[5,"is_free","","",N,[[["region"]],["bool"]]],[5,"is_free_or_static","","",N,[[["region"]],["bool"]]],[8,"FreeRegionRelations","","The NLL region handling code represents free region relations in a slightly different way; this trait allows functions to be abstract over which version is in use.",N,N],[10,"sub_free_regions","","Tests whether `r_a <= r_b`. Both must be free regions or `'static`.",266,[[["self"],["region"],["region"]],["bool"]]],[11,"clone","","",265,[[["self"]],["freeregionmap"]]],[11,"encode","","",265,[[["self"],["__s"]],["result"]]],[11,"decode","","",265,[[["__d"]],["result",["freeregionmap"]]]],[11,"fmt","","",265,[[["self"],["formatter"]],["result"]]],[11,"new","","",265,[[],["self"]]],[11,"is_empty","","",265,[[["self"]],["bool"]]],[11,"relate_regions","","",265,[[["self"],["region"],["region"]]]],[11,"lub_free_regions","","Compute the least-upper-bound of two free regions. In some cases, this is more conservative than necessary, in order to avoid making arbitrary choices. See `TransitiveRelation::postdom_upper_bound` for more details.",265,[[["self"],["tyctxt"],["region"],["region"]],["region"]]],[11,"sub_free_regions","","",265,[[["self"],["region"],["region"]],["bool"]]],[11,"hash_stable","","",265,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"lift_to_tcx","","",265,[[["self"],["tyctxt"]],["option",["freeregionmap"]]]],[0,"obligations","rustc::infer::outlives","Code that handles \"type-outlives\" constraints like `T: 'a`. This is based on the `outlives_components` function defined on the tcx, but it adds a bit of heuristics on top, in particular to deal with associated types and projections.",N,N],[3,"TypeOutlives","rustc::infer::outlives::obligations","The `TypeOutlives` struct has the job of \"lowering\" a `T: 'a` obligation into a series of `'a: 'b` constraints and \"verifys\", as described on the module comment. The final constraints are emitted via a \"delegate\" of type `D` -- this is usually the `infcx`, which accrues them into the `region_obligations` code, but for NLL we use something else.",N,N],[12,"delegate","","",267,N],[12,"tcx","","",267,N],[12,"region_bound_pairs","","",267,N],[12,"implicit_region_bound","","",267,N],[12,"param_env","","",267,N],[8,"TypeOutlivesDelegate","","",N,N],[10,"push_sub_region_constraint","","",268,[[["self"],["subregionorigin"],["region"],["region"]]]],[10,"push_verify","","",268,[[["self"],["subregionorigin"],["generickind"],["region"],["verifybound"]]]],[11,"register_region_obligation","rustc::infer","Registers that the given region obligation must be resolved from within the scope of `body_id`. These regions are enqueued and later processed by regionck, when full type information is available (see `region_obligations` field for more information).",209,[[["self"],["nodeid"],["regionobligation"]]]],[11,"take_registered_region_obligations","","Trait queries just want to pass back type obligations \"as is\"",209,[[["self"]],["vec"]]],[11,"process_registered_region_obligations","","Process the region obligations that must be proven (during `regionck`) for the given `body_id`, given information about the region bounds in scope and so forth. This function must be invoked for all relevant body-ids before region inference is done (or else an assert will fire).",209,N],[11,"type_must_outlive","","Processes a single ad-hoc region obligation that was not registered in advance.",209,N],[11,"new","rustc::infer::outlives::obligations","",267,N],[11,"type_must_outlive","","Adds constraints to inference such that `T: 'a` holds (or reports an error if it cannot).",267,[[["self"],["subregionorigin"],["ty"],["region"]]]],[11,"components_must_outlive","","",267,[[["self"],["subregionorigin"],["vec",["component"]],["region"]]]],[11,"param_ty_must_outlive","","",267,[[["self"],["subregionorigin"],["region"],["paramty"]]]],[11,"projection_must_outlive","","",267,[[["self"],["subregionorigin"],["region"],["projectionty"]]]],[11,"type_bound","","",267,[[["self"],["ty"]],["verifybound"]]],[11,"param_bound","","",267,[[["self"],["paramty"]],["verifybound"]]],[11,"projection_declared_bounds","","",267,[[["self"],["projectionty"]],["vec",["region"]]]],[11,"projection_bound","","",267,[[["self"],["vec",["region"]],["projectionty"]],["verifybound"]]],[11,"recursive_type_bound","","",267,[[["self"],["ty"]],["verifybound"]]],[11,"declared_generic_bounds_from_env","","",267,[[["self"],["generickind"]],["vec",["region"]]]],[11,"declared_projection_bounds_from_trait","","Given a projection like `<T as Foo<'x>>::Bar`, returns any bounds declared in the trait definition. For example, if the trait were",267,[[["self"],["projectionty"]],["vec",["region"]]]],[11,"region_bounds_declared_on_associated_item","","Given the def-id of an associated item, returns any region bounds attached to that associated item from the trait definition.",267,[[["self"],["defid"]],["vec",["region"]]]],[11,"collect_outlives_from_predicate_list","","Searches through a predicate list for a predicate `T: 'a`.",267,[[["self"],["ty"],["i"]],["vec",["region"]]]],[0,"region_constraints","rustc::infer","See README.md",N,N],[3,"RegionConstraintCollector","rustc::infer::region_constraints","",N,N],[12,"var_infos","","For each `RegionVid`, the corresponding `RegionVariableOrigin`.",269,N],[12,"data","","",269,N],[12,"lubs","","For a given pair of regions (R1, R2), maps to a region R3 that is designated as their LUB (edges R1 <= R3 and R2 <= R3 exist). This prevents us from making many such regions.",269,N],[12,"glbs","","For a given pair of regions (R1, R2), maps to a region R3 that is designated as their GLB (edges R3 <= R1 and R3 <= R2 exist). This prevents us from making many such regions.",269,N],[12,"bound_count","","Global counter used during the GLB algorithm to create unique names for fresh bound regions",269,N],[12,"undo_log","","The undo log records actions that might later be undone.",269,N],[12,"unification_table","","When we add a R1 == R2 constriant, we currently add (a) edges R1 <= R2 and R2 <= R1 and (b) we unify the two regions in this table. You can then call `opportunistic_resolve_var` early which will map R1 and R2 to some common region (i.e., either R1 or R2). This is important when dropck and other such code is iterating to a fixed point, because otherwise we sometimes would wind up with a fresh stream of region variables that have been equated but appear distinct.",269,N],[12,"any_unifications","","a flag set to true when we perform any unifications; this is used to micro-optimize `take_and_reset_data`",269,N],[3,"RegionConstraintData","","The full set of region constraints gathered up by the collector. Describes constraints between the region variables and other regions, as well as other conditions that must be verified, or assumptions that can be made.",N,N],[12,"constraints","","Constraints of the form `A <= B`, where either `A` or `B` can be a region variable (or neither, as it happens).",270,N],[12,"verifys","","A \"verify\" is something that we need to verify after inference is done, but which does not directly affect inference in any way.",270,N],[12,"givens","","A \"given\" is a relationship that is known to hold. In particular, we often know from closure fn signatures that a particular free region must be a subregion of a region variable:",270,N],[3,"Verify","","VerifyGenericBound(T, _, R, RS): The parameter type `T` (or associated type) must outlive the region `R`. `T` is known to outlive `RS`. Therefore verify that `R <= RS[i]` for some `i`. Inference variables may be involved (but this verification step doesn't influence inference).",N,N],[12,"kind","","",271,N],[12,"origin","","",271,N],[12,"region","","",271,N],[12,"bound","","",271,N],[3,"TwoRegions","","",N,N],[12,"a","","",272,N],[12,"b","","",272,N],[3,"RegionVariableInfo","","",N,N],[12,"origin","","",273,N],[12,"universe","","",273,N],[3,"RegionSnapshot","","",N,N],[12,"length","","",274,N],[12,"region_snapshot","","",274,N],[12,"any_unifications","","",274,N],[3,"TaintDirections","","When working with skolemized regions, we often wish to find all of the regions that are either reachable from a skolemized region, or which can reach a skolemized region, or both. We call such regions tained regions.  This struct allows you to decide what set of tainted regions you want.",N,N],[12,"incoming","","",275,N],[12,"outgoing","","",275,N],[4,"Constraint","","A constraint that influences the inference process.",N,N],[13,"VarSubVar","","One region variable is subregion of another",276,N],[13,"RegSubVar","","Concrete region is subregion of region variable",276,N],[13,"VarSubReg","","Region variable is subregion of concrete region. This does not directly affect inference, but instead is checked after inference is complete.",276,N],[13,"RegSubReg","","A constraint where neither side is a variable. This does not directly affect inference, but instead is checked after inference is complete.",276,N],[4,"GenericKind","","",N,N],[13,"Param","","",277,N],[13,"Projection","","",277,N],[4,"VerifyBound","","When we introduce a verification step, we wish to test that a particular region (let's call it `'min`) meets some bound. The bound is described the by the following grammar:",N,N],[13,"AnyRegion","","B = exists {R} --> some 'r in {R} must outlive 'min",278,N],[13,"AllRegions","","B = forall {R} --> all 'r in {R} must outlive 'min",278,N],[13,"AnyBound","","B = exists {B} --> 'min must meet some bound b in {B}",278,N],[13,"AllBounds","","B = forall {B} --> 'min must meet all bounds b in {B}",278,N],[4,"UndoLogEntry","","",N,N],[13,"OpenSnapshot","","Pushed when we start a snapshot.",279,N],[13,"CommitedSnapshot","","Replaces an `OpenSnapshot` when a snapshot is committed, but that snapshot is not the root. If the root snapshot is unrolled, all nested snapshots must be committed.",279,N],[13,"AddVar","","We added `RegionVid`",279,N],[13,"AddConstraint","","We added the given `constraint`",279,N],[13,"AddVerify","","We added the given `verify`",279,N],[13,"AddGiven","","We added the given `given`",279,N],[13,"AddCombination","","We added a GLB/LUB \"combination variable\"",279,N],[13,"Purged","","During skolemization, we sometimes purge entries from the undo log in a kind of minisnapshot (unlike other snapshots, this purging actually takes place on success). In that case, we replace the corresponding entry with `Noop` so as to avoid the need to do a bunch of swapping. (We can't use `swap_remove` as the order of the vector is important.)",279,N],[4,"CombineMapType","","",N,N],[13,"Lub","","",280,N],[13,"Glb","","",280,N],[0,"taint","","",N,N],[3,"TaintSet","rustc::infer::region_constraints::taint","",N,N],[12,"directions","","",281,N],[12,"regions","","",281,N],[11,"fmt","","",281,[[["self"],["formatter"]],["result"]]],[11,"new","","",281,[[["taintdirections"],["region"]],["self"]]],[11,"fixed_point","","",281,N],[11,"into_set","","",281,[[["self"]],["fxhashset",["region"]]]],[11,"len","","",281,[[["self"]],["usize"]]],[11,"add_edge","","",281,[[["self"],["region"],["region"]]]],[6,"VarInfos","rustc::infer::region_constraints","",N,N],[6,"CombineMap","","",N,N],[11,"fmt","","",270,[[["self"],["formatter"]],["result"]]],[11,"default","","",270,[[],["regionconstraintdata"]]],[11,"clone","","",270,[[["self"]],["regionconstraintdata"]]],[11,"clone","","",276,[[["self"]],["constraint"]]],[11,"eq","","",276,[[["self"],["constraint"]],["bool"]]],[11,"ne","","",276,[[["self"],["constraint"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",276,N],[11,"hash","","",276,N],[11,"fmt","","",276,[[["self"],["formatter"]],["result"]]],[11,"partial_cmp","","",276,[[["self"],["constraint"]],["option",["ordering"]]]],[11,"lt","","",276,[[["self"],["constraint"]],["bool"]]],[11,"le","","",276,[[["self"],["constraint"]],["bool"]]],[11,"gt","","",276,[[["self"],["constraint"]],["bool"]]],[11,"ge","","",276,[[["self"],["constraint"]],["bool"]]],[11,"cmp","","",276,[[["self"],["constraint"]],["ordering"]]],[11,"fmt","","",271,[[["self"],["formatter"]],["result"]]],[11,"clone","","",271,[[["self"]],["verify"]]],[11,"clone","","",277,[[["self"]],["generickind"]]],[11,"eq","","",277,[[["self"],["generickind"]],["bool"]]],[11,"ne","","",277,[[["self"],["generickind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",277,N],[11,"fmt","","",278,[[["self"],["formatter"]],["result"]]],[11,"clone","","",278,[[["self"]],["verifybound"]]],[11,"clone","","",272,[[["self"]],["tworegions"]]],[11,"eq","","",272,[[["self"],["tworegions"]],["bool"]]],[11,"ne","","",272,[[["self"],["tworegions"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",272,N],[11,"hash","","",272,N],[11,"clone","","",279,[[["self"]],["undologentry"]]],[11,"eq","","",279,[[["self"],["undologentry"]],["bool"]]],[11,"ne","","",279,[[["self"],["undologentry"]],["bool"]]],[11,"clone","","",280,[[["self"]],["combinemaptype"]]],[11,"eq","","",280,[[["self"],["combinemaptype"]],["bool"]]],[11,"fmt","","",273,[[["self"],["formatter"]],["result"]]],[11,"clone","","",273,[[["self"]],["regionvariableinfo"]]],[11,"fmt","","",275,[[["self"],["formatter"]],["result"]]],[11,"incoming","","",275,[[],["self"]]],[11,"outgoing","","",275,[[],["self"]]],[11,"both","","",275,[[],["self"]]],[11,"new","","",269,[[],["regionconstraintcollector"]]],[11,"num_region_vars","","",269,[[["self"]],["usize"]]],[11,"region_constraint_data","","",269,[[["self"]],["regionconstraintdata"]]],[11,"into_infos_and_data","","Once all the constraints have been gathered, extract out the final data.",269,N],[11,"take_and_reset_data","","Takes (and clears) the current set of constraints. Note that the set of variables remains intact, but all relationships between them are reset.  This is used during NLL checking to grab the set of constraints that arose from a particular operation.",269,[[["self"]],["regionconstraintdata"]]],[11,"data","","",269,[[["self"]],["regionconstraintdata"]]],[11,"in_snapshot","","",269,[[["self"]],["bool"]]],[11,"start_snapshot","","",269,[[["self"]],["regionsnapshot"]]],[11,"commit","","",269,[[["self"],["regionsnapshot"]]]],[11,"rollback_to","","",269,[[["self"],["regionsnapshot"]]]],[11,"rollback_undo_entry","","",269,[[["self"],["undologentry"]]]],[11,"new_region_var","","",269,[[["self"],["universeindex"],["regionvariableorigin"]],["regionvid"]]],[11,"var_universe","","Returns the universe for the given variable.",269,[[["self"],["regionvid"]],["universeindex"]]],[11,"var_origin","","Returns the origin for the given variable.",269,[[["self"],["regionvid"]],["regionvariableorigin"]]],[11,"pop_skolemized","","Removes all the edges to/from the skolemized regions that are in `skols`. This is used after a higher-ranked operation completes to remove all trace of the skolemized regions created in that time.",269,[[["self"],["universeindex"],["fxhashset"],["regionsnapshot"]]]],[11,"new_bound","","",269,[[["self"],["tyctxt"],["debruijnindex"]],["region"]]],[11,"add_constraint","","",269,[[["self"],["constraint"],["subregionorigin"]]]],[11,"add_verify","","",269,[[["self"],["verify"]]]],[11,"add_given","","",269,[[["self"],["region"],["regionvid"]]]],[11,"make_eqregion","","",269,[[["self"],["subregionorigin"],["region"],["region"]]]],[11,"make_subregion","","",269,[[["self"],["subregionorigin"],["region"],["region"]]]],[11,"verify_generic_bound","","See `Verify::VerifyGenericBound`",269,[[["self"],["subregionorigin"],["generickind"],["region"],["verifybound"]]]],[11,"lub_regions","","",269,[[["self"],["tyctxt"],["subregionorigin"],["region"],["region"]],["region"]]],[11,"glb_regions","","",269,[[["self"],["tyctxt"],["subregionorigin"],["region"],["region"]],["region"]]],[11,"opportunistic_resolve_var","","",269,[[["self"],["tyctxt"],["regionvid"]],["region"]]],[11,"combine_map","","",269,[[["self"],["combinemaptype"]],["fxhashmap"]]],[11,"combine_vars","","",269,[[["self"],["tyctxt"],["combinemaptype"],["region"],["region"],["subregionorigin"]],["region"]]],[11,"universe","","",269,[[["self"],["region"]],["universeindex"]]],[11,"vars_created_since_snapshot","","",269,[[["self"],["regionsnapshot"]],["vec",["regionvid"]]]],[11,"tainted","","Computes all regions that have been related to `r0` since the mark `mark` was made---`r0` itself will be the first entry. The `directions` parameter controls what kind of relations are considered. For example, one can say that only \"incoming\" edges to `r0` are desired, in which case one will get the set of regions `{r|r <= r0}`. This is used when checking whether skolemized regions are being improperly related to other regions.",269,[[["self"],["tyctxt"],["regionsnapshot"],["region"],["taintdirections"]],["fxhashset",["region"]]]],[11,"fmt","","",274,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",277,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",277,[[["self"],["formatter"]],["result"]]],[11,"to_ty","","",277,[[["self"],["tyctxt"]],["ty"]]],[11,"for_each_region","","",278,[[["self"],["fnmut"]]]],[11,"must_hold","","",278,[[["self"]],["bool"]]],[11,"cannot_hold","","",278,[[["self"]],["bool"]]],[11,"or","","",278,[[["self"],["verifybound"]],["verifybound"]]],[11,"and","","",278,[[["self"],["verifybound"]],["verifybound"]]],[11,"is_empty","","True if this region constraint data contains no constraints.",270,[[["self"]],["bool"]]],[0,"resolve","rustc::infer","",N,N],[3,"OpportunisticTypeResolver","rustc::infer::resolve","The opportunistic type resolver can be used at any time. It simply replaces type variables that have been unified with the things they have been unified with (similar to `shallow_resolve`, but deep). This is useful for printing messages etc but also required at various points for correctness.",N,N],[12,"infcx","","",282,N],[3,"OpportunisticTypeAndRegionResolver","","The opportunistic type and region resolver is similar to the opportunistic type resolver, but also opportunistically resolves regions. It is useful for canonicalization.",N,N],[12,"infcx","","",283,N],[3,"UnresolvedTypeFinder","","The unresolved type finder walks your type and searches for type variables that don't yet have a value. They get pushed into a vector. It does not construct the fully resolved type (which might involve some hashing and so forth).",N,N],[12,"infcx","","",284,N],[3,"FullTypeResolver","","",N,N],[12,"infcx","","",285,N],[12,"err","","",285,N],[5,"fully_resolve","","Full type resolution replaces all type and region variables with their concrete results. If any variable cannot be replaced (never unified, etc) then an `Err` result is returned.",N,[[["inferctxt"],["t"]],["fixupresult"]]],[11,"new","","",282,[[["inferctxt"]],["self"]]],[11,"tcx","","",282,[[["self"]],["tyctxt"]]],[11,"fold_ty","","",282,[[["self"],["ty"]],["ty"]]],[11,"new","","",283,[[["inferctxt"]],["self"]]],[11,"tcx","","",283,[[["self"]],["tyctxt"]]],[11,"fold_ty","","",283,[[["self"],["ty"]],["ty"]]],[11,"fold_region","","",283,[[["self"],["region"]],["region"]]],[11,"new","","",284,[[["inferctxt"]],["self"]]],[11,"visit_ty","","",284,[[["self"],["ty"]],["bool"]]],[11,"tcx","","",285,[[["self"]],["tyctxt"]]],[11,"fold_ty","","",285,[[["self"],["ty"]],["ty"]]],[11,"fold_region","","",285,[[["self"],["region"]],["region"]]],[0,"sub","rustc::infer","",N,N],[3,"Sub","rustc::infer::sub","Ensures `a` is made a subtype of `b`. Returns `a` on success.",N,N],[12,"fields","","",286,N],[12,"a_is_expected","","",286,N],[11,"new","","",286,[[["combinefields"],["bool"]],["sub"]]],[11,"with_expected_switched","","",286,[[["self"],["f"]],["r"]]],[11,"tag","","",286,[[["self"]],["str"]]],[11,"tcx","","",286,[[["self"]],["tyctxt"]]],[11,"a_is_expected","","",286,[[["self"]],["bool"]]],[11,"with_cause","","",286,[[["self"],["cause"],["f"]],["r"]]],[11,"relate_with_variance","","",286,[[["self"],["variance"],["t"],["t"]],["relateresult"]]],[11,"tys","","",286,[[["self"],["ty"],["ty"]],["relateresult",["ty"]]]],[11,"regions","","",286,[[["self"],["region"],["region"]],["relateresult",["region"]]]],[11,"binders","","",286,[[["self"],["binder"],["binder"]],["relateresult",["binder"]]]],[0,"type_variable","rustc::infer","",N,N],[3,"TypeVariableTable","rustc::infer::type_variable","",N,N],[12,"values","","",287,N],[12,"eq_relations","","Two variables are unified in `eq_relations` when we have a constraint `?X == ?Y`. This table also stores, for each key, the known value.",287,N],[12,"sub_relations","","Two variables are unified in `eq_relations` when we have a constraint `?X <: ?Y` or a constraint `?Y <: ?X`. This second table exists only to help with the occurs check. In particular, we want to report constraints like these as an occurs check violation:",287,N],[3,"TypeVariableData","","",N,N],[12,"origin","","",288,N],[12,"diverging","","",288,N],[3,"Snapshot","","",N,N],[12,"snapshot","","",289,N],[12,"eq_snapshot","","",289,N],[12,"sub_snapshot","","",289,N],[3,"Instantiate","","",N,N],[12,"vid","","",290,N],[3,"Delegate","","",N,N],[3,"TyVidEqKey","","These structs (a newtyped TyVid) are used as the unification key for the `eq_relations`; they carry a `TypeVariableValue` along with them.",N,N],[12,"vid","","",291,N],[12,"phantom","","",291,N],[4,"TypeVariableOrigin","","Reasons to create a type inference variable",N,N],[13,"MiscVariable","","",292,N],[13,"NormalizeProjectionType","","",292,N],[13,"TypeInference","","",292,N],[13,"TypeParameterDefinition","","",292,N],[13,"ClosureSynthetic","","one of the upvars or closure kind parameters in a `ClosureSubsts` (before it has been determined)",292,N],[13,"SubstitutionPlaceholder","","",292,N],[13,"AutoDeref","","",292,N],[13,"AdjustmentType","","",292,N],[13,"DivergingStmt","","",292,N],[13,"DivergingBlockExpr","","",292,N],[13,"DivergingFn","","",292,N],[13,"LatticeVariable","","",292,N],[13,"Generalized","","",292,N],[4,"TypeVariableValue","","",N,N],[13,"Known","","",293,N],[12,"value","rustc::infer::type_variable::TypeVariableValue","",293,N],[13,"Unknown","rustc::infer::type_variable","",293,N],[12,"universe","rustc::infer::type_variable::TypeVariableValue","",293,N],[6,"TypeVariableMap","rustc::infer::type_variable","",N,N],[11,"clone","","",292,[[["self"]],["typevariableorigin"]]],[11,"fmt","","",292,[[["self"],["formatter"]],["result"]]],[11,"clone","","",293,[[["self"]],["typevariablevalue"]]],[11,"fmt","","",293,[[["self"],["formatter"]],["result"]]],[11,"known","","If this value is known, returns the type it is known to be. Otherwise, `None`.",293,[[["self"]],["option",["ty"]]]],[11,"is_unknown","","",293,[[["self"]],["bool"]]],[11,"new","","",287,[[],["typevariabletable"]]],[11,"var_diverges","","Returns the diverges flag given when `vid` was created.",287,[[["self"],["tyvid"]],["bool"]]],[11,"var_origin","","Returns the origin that was given when `vid` was created.",287,[[["self"],["tyvid"]],["typevariableorigin"]]],[11,"equate","","Records that `a == b`, depending on `dir`.",287,[[["self"],["tyvid"],["tyvid"]]]],[11,"sub","","Records that `a <: b`, depending on `dir`.",287,[[["self"],["tyvid"],["tyvid"]]]],[11,"instantiate","","Instantiates `vid` with the type `ty`.",287,[[["self"],["tyvid"],["ty"]]]],[11,"new_var","","Creates a new type variable.",287,[[["self"],["universeindex"],["bool"],["typevariableorigin"]],["tyvid"]]],[11,"num_vars","","Returns the number of type variables created thus far.",287,[[["self"]],["usize"]]],[11,"root_var","","Returns the \"root\" variable of `vid` in the `eq_relations` equivalence table. All type variables that have been equated will yield the same root variable (per the union-find algorithm), so `root_var(a) == root_var(b)` implies that `a == b` (transitively).",287,[[["self"],["tyvid"]],["tyvid"]]],[11,"sub_root_var","","Returns the \"root\" variable of `vid` in the `sub_relations` equivalence table. All type variables that have been are related via equality or subtyping will yield the same root variable (per the union-find algorithm), so `sub_root_var(a) == sub_root_var(b)` implies that:",287,[[["self"],["tyvid"]],["tyvid"]]],[11,"sub_unified","","True if `a` and `b` have same \"sub-root\" (i.e., exists some type X such that `forall i in {a, b}. (i <: X || X <: i)`.",287,[[["self"],["tyvid"],["tyvid"]],["bool"]]],[11,"probe","","Retrieves the type to which `vid` has been instantiated, if any.",287,[[["self"],["tyvid"]],["typevariablevalue"]]],[11,"replace_if_possible","","If `t` is a type-inference variable, and it has been instantiated, then return the with which it was instantiated. Otherwise, returns `t`.",287,[[["self"],["ty"]],["ty"]]],[11,"snapshot","","Creates a snapshot of the type variable state.  This snapshot must later be committed (`commit()`) or rolled back (`rollback_to()`).  Nested snapshots are permitted, but must be processed in a stack-like fashion.",287,[[["self"]],["snapshot"]]],[11,"rollback_to","","Undoes all changes since the snapshot was created. Any snapshots created since that point must already have been committed or rolled back.",287,[[["self"],["snapshot"]]]],[11,"commit","","Commits all changes since the snapshot was created, making them permanent (unless this snapshot was created within another snapshot). Any snapshots created since that point must already have been committed or rolled back.",287,[[["self"],["snapshot"]]]],[11,"types_created_since_snapshot","","Returns a map `{V1 -> V2}`, where the keys `{V1}` are ty-variables created during the snapshot, and the values `{V2}` are the root variables that they were unified with, along with their origin.",287,[[["self"],["snapshot"]],["typevariablemap"]]],[11,"types_escaping_snapshot","","Find the set of type variables that existed before `s` but which have only been unified since `s` started, and return the types with which they were unified. So if we had a type variable `V0`, then we started the snapshot, then we created a type variable `V1`, unifed `V0` with `T0`, and unified `V1` with `T1`, this function would return `{T0}`.",287,[[["self"],["snapshot"]],["vec",["ty"]]]],[11,"unsolved_variables","","Returns indices of all variables that are not yet instantiated.",287,[[["self"]],["vec",["tyvid"]]]],[11,"reverse","","",294,[[["vec"],["instantiate"]]]],[11,"clone","","",291,[[["self"]],["tyvideqkey"]]],[11,"fmt","","",291,[[["self"],["formatter"]],["result"]]],[11,"eq","","",291,[[["self"],["tyvideqkey"]],["bool"]]],[11,"ne","","",291,[[["self"],["tyvideqkey"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",291,N],[11,"from","","",291,[[["tyvid"]],["self"]]],[11,"index","","",291,[[["self"]],["u32"]]],[11,"from_index","","",291,[[["u32"]],["self"]]],[11,"tag","","",291,[[],["str"]]],[11,"unify_values","","",293,[[["self"],["self"]],["result",["noerror"]]]],[0,"unify_key","rustc::infer","",N,N],[3,"RegionVidKey","rustc::infer::unify_key","",N,N],[12,"min_vid","","The minimum region vid in the unification set. This is needed to have a canonical name for a type to prevent infinite recursion.",295,N],[8,"ToType","","",N,N],[10,"to_type","","",296,[[["self"],["tyctxt"]],["ty"]]],[11,"eq","","",295,[[["self"],["regionvidkey"]],["bool"]]],[11,"ne","","",295,[[["self"],["regionvidkey"]],["bool"]]],[11,"clone","","",295,[[["self"]],["regionvidkey"]]],[11,"fmt","","",295,[[["self"],["formatter"]],["result"]]],[11,"unify_values","","",295,[[["self"],["self"]],["result",["noerror"]]]],[6,"InferResult","rustc::infer","",N,N],[6,"Bound","","",N,N],[6,"UnitResult","","",N,N],[6,"FixupResult","","",N,N],[6,"SkolemizationMap","","A map returned by `skolemize_late_bound_regions()` indicating the skolemized region that each late-bound region was replaced with.",N,N],[11,"fmt","","",208,[[["self"],["formatter"]],["result"]]],[11,"clone","","",214,[[["self"]],["valuepairs"]]],[11,"fmt","","",214,[[["self"],["formatter"]],["result"]]],[11,"clone","","",210,[[["self"]],["typetrace"]]],[11,"clone","","",215,[[["self"]],["subregionorigin"]]],[11,"fmt","","",215,[[["self"],["formatter"]],["result"]]],[11,"clone","","",216,[[["self"]],["parameterorigin"]]],[11,"fmt","","",216,[[["self"],["formatter"]],["result"]]],[11,"clone","","",217,[[["self"]],["lateboundregionconversiontime"]]],[11,"fmt","","",217,[[["self"],["formatter"]],["result"]]],[11,"clone","","",218,[[["self"]],["regionvariableorigin"]]],[11,"fmt","","",218,[[["self"],["formatter"]],["result"]]],[11,"clone","","",219,[[["self"]],["nllregionvariableorigin"]]],[11,"fmt","","",219,[[["self"],["formatter"]],["result"]]],[11,"eq","","",219,[[["self"],["nllregionvariableorigin"]],["bool"]]],[11,"ne","","",219,[[["self"],["nllregionvariableorigin"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",219,N],[11,"hash","","",219,N],[11,"is_universal","","",219,[[["self"]],["bool"]]],[11,"is_existential","","",219,[[["self"]],["bool"]]],[11,"clone","","",220,[[["self"]],["fixuperror"]]],[11,"fmt","","",220,[[["self"],["formatter"]],["result"]]],[11,"clone","","",211,[[["self"]],["regionobligation"]]],[11,"fmt","","",220,[[["self"],["formatter"]],["result"]]],[11,"with_fresh_in_progress_tables","","Used only by `rustc_typeck` during body type-checking/inference, will initialize `in_progress_tables` with fresh `TypeckTables`.",212,[[["self"],["defid"]],["self"]]],[11,"enter","","",212,[[["self"],["f"]],["r"]]],[11,"unit","","",208,[[["self"]],["inferok"]]],[11,"into_value_registering_obligations","","Extract `value`, registering any obligations into `fulfill_cx`",208,N],[11,"into_obligations","","",208,[[["self"]],["predicateobligations"]]],[11,"is_in_snapshot","","",209,[[["self"]],["bool"]]],[11,"freshen","","",209,[[["self"],["t"]],["t"]]],[11,"type_var_diverges","","",209,[[["self"],["ty"]],["bool"]]],[11,"freshener","","",209,[[["self"]],["typefreshener"]]],[11,"type_is_unconstrained_numeric","","",209,[[["self"],["ty"]],["unconstrainednumeric"]]],[11,"unsolved_variables","","",209,[[["self"]],["vec",["ty"]]]],[11,"combine_fields","","",209,[[["self"],["typetrace"],["paramenv"]],["combinefields"]]],[11,"save_and_restore_in_snapshot_flag","","",209,[[["self"],["f"]],["r"]]],[11,"start_snapshot","","",209,[[["self"]],["combinedsnapshot"]]],[11,"rollback_to","","",209,[[["self"],["str"],["combinedsnapshot"]]]],[11,"commit_from","","",209,[[["self"],["combinedsnapshot"]]]],[11,"commit_unconditionally","","Execute `f` and commit the bindings",209,[[["self"],["f"]],["r"]]],[11,"commit_if_ok","","Execute `f` and commit the bindings if closure `f` returns `Ok(_)`",209,[[["self"],["f"]],["result"]]],[11,"in_snapshot","","",209,[[["self"],["f"]],["t"]]],[11,"probe","","Execute `f` then unroll any bindings it creates",209,[[["self"],["f"]],["r"]]],[11,"add_given","","",209,[[["self"],["region"],["regionvid"]]]],[11,"can_sub","","",209,[[["self"],["paramenv"],["t"],["t"]],["unitresult"]]],[11,"can_eq","","",209,[[["self"],["paramenv"],["t"],["t"]],["unitresult"]]],[11,"sub_regions","","",209,[[["self"],["subregionorigin"],["region"],["region"]]]],[11,"subtype_predicate","","",209,[[["self"],["obligationcause"],["paramenv"],["polysubtypepredicate"]],["option",["inferresult"]]]],[11,"region_outlives_predicate","","",209,[[["self"],["obligationcause"],["polyregionoutlivespredicate"]],["unitresult"]]],[11,"next_ty_var_id","","",209,[[["self"],["bool"],["typevariableorigin"]],["tyvid"]]],[11,"next_ty_var","","",209,[[["self"],["typevariableorigin"]],["ty"]]],[11,"next_diverging_ty_var","","",209,[[["self"],["typevariableorigin"]],["ty"]]],[11,"next_int_var_id","","",209,[[["self"]],["intvid"]]],[11,"next_float_var_id","","",209,[[["self"]],["floatvid"]]],[11,"next_region_var","","Create a fresh region variable with the next available index. The variable will be created in the maximum universe created thus far, allowing it to name any region created thus far.",209,[[["self"],["regionvariableorigin"]],["region"]]],[11,"next_region_var_in_universe","","Create a fresh region variable with the next available index in the given universe; typically, you can use `next_region_var` and just use the maximal universe.",209,[[["self"],["regionvariableorigin"],["universeindex"]],["region"]]],[11,"num_region_vars","","Number of region variables created so far.",209,[[["self"]],["usize"]]],[11,"next_nll_region_var","","Just a convenient wrapper of `next_region_var` for using during NLL.",209,[[["self"],["nllregionvariableorigin"]],["region"]]],[11,"next_nll_region_var_in_universe","","Just a convenient wrapper of `next_region_var` for using during NLL.",209,[[["self"],["nllregionvariableorigin"],["universeindex"]],["region"]]],[11,"var_for_def","","",209,[[["self"],["span"],["genericparamdef"]],["kind"]]],[11,"fresh_substs_for_item","","Given a set of generics defined on a type or impl, returns a substitution mapping each type/region parameter to a fresh inference variable.",209,[[["self"],["span"],["defid"]],["substs"]]],[11,"is_tainted_by_errors","","True if errors have been reported since this infcx was created.  This is sometimes used as a heuristic to skip reporting errors that often occur as a result of earlier errors, but where it's hard to be 100% sure (e.g., unresolved inference variables, regionck errors).",209,[[["self"]],["bool"]]],[11,"set_tainted_by_errors","","Set the \"tainted by errors\" flag to true. We call this when we observe an error from a prior pass.",209,[[["self"]]]],[11,"resolve_regions_and_report_errors","","Process the region constraints and report any errors that result. After this, no more unification operations should be done -- or the compiler will panic -- but it is legal to use `resolve_type_vars_if_possible` as well as `fully_resolve`.",209,[[["self"],["defid"],["scopetree"],["outlivesenvironment"]]]],[11,"resolve_regions_and_report_errors_unless_nll","","Like `resolve_regions_and_report_errors`, but skips error reporting if NLL is enabled.  This is used for fn bodies where the same error may later be reported by the NLL-based inference.",209,[[["self"],["defid"],["scopetree"],["outlivesenvironment"]]]],[11,"resolve_regions_and_report_errors_inner","","",209,[[["self"],["defid"],["scopetree"],["outlivesenvironment"],["bool"]]]],[11,"take_and_reset_region_constraints","","Obtains (and clears) the current set of region constraints. The inference context is still usable: further unifications will simply add new constraints.",209,[[["self"]],["regionconstraintdata"]]],[11,"with_region_constraints","","Gives temporary access to the region constraint data.",209,N],[11,"take_region_var_origins","","Takes ownership of the list of variable regions. This implies that all the region constriants have already been taken, and hence that `resolve_regions_and_report_errors` can never be called. This is used only during NLL processing to \"hand off\" ownership of the set of region vairables into the NLL region context.",209,[[["self"]],["varinfos"]]],[11,"ty_to_string","","",209,[[["self"],["ty"]],["string"]]],[11,"tys_to_string","","",209,N],[11,"trait_ref_to_string","","",209,[[["self"],["traitref"]],["string"]]],[11,"inlined_shallow_resolve","","",209,[[["self"],["ty"]],["ty"]]],[11,"shallow_resolve","","",209,[[["self"],["ty"]],["ty"]]],[11,"resolve_type_vars_if_possible","","Where possible, replaces type/int/float variables in `value` with their final value. Note that region variables are unaffected. If a type variable has not been unified, it is left as is.  This is an idempotent operation that does not affect inference state in any way and so you can do it at will.",209,[[["self"],["t"]],["t"]]],[11,"any_unresolved_type_vars","","Returns true if `T` contains unresolved type variables. In the process of visiting `T`, this will resolve (where possible) type variables in `T`, but it never constructs the final, resolved type, so it's more efficient than `resolve_type_vars_if_possible()`.",209,[[["self"],["t"]],["bool"]]],[11,"resolve_type_and_region_vars_if_possible","","",209,[[["self"],["t"]],["t"]]],[11,"fully_resolve","","Attempts to resolve all type/region variables in `value`. Region inference must have been run already (e.g., by calling `resolve_regions_and_report_errors`).  If some variable was never unified, an `Err` results.",209,[[["self"],["t"]],["fixupresult"]]],[11,"type_error_struct_with_diag","","",209,[[["self"],["span"],["m"],["ty"]],["diagnosticbuilder"]]],[11,"report_mismatched_types","","",209,[[["self"],["obligationcause"],["ty"],["ty"],["typeerror"]],["diagnosticbuilder"]]],[11,"replace_late_bound_regions_with_fresh_var","","",209,N],[11,"match_poly_projection_predicate","","Given a higher-ranked projection predicate like:",209,[[["self"],["obligationcause"],["paramenv"],["polyprojectionpredicate"],["traitref"]],["inferresult",["hrmatchresult"]]]],[11,"verify_generic_bound","","See `verify_generic_bound` method in `region_constraints`",209,[[["self"],["subregionorigin"],["generickind"],["region"],["verifybound"]]]],[11,"type_moves_by_default","","",209,[[["self"],["paramenv"],["ty"],["span"]],["bool"]]],[11,"closure_kind","","Obtains the latest type of the given closure; this may be a closure in the current function, in which case its `ClosureKind` may not yet be known.",209,[[["self"],["defid"],["closuresubsts"]],["option",["closurekind"]]]],[11,"closure_sig","","Obtain the signature of a closure.  For closures, unlike `tcx.fn_sig(def_id)`, this method will work during the type-checking of the enclosing function and return the closure signature in its partially inferred state.",209,[[["self"],["defid"],["closuresubsts"]],["polyfnsig"]]],[11,"partially_normalize_associated_types_in","","Normalizes associated types in `value`, potentially returning new obligations that must further be processed.",209,[[["self"],["span"],["nodeid"],["paramenv"],["t"]],["inferok"]]],[11,"borrow_region_constraints","","",209,[[["self"]],["refmut",["regionconstraintcollector"]]]],[11,"clear_caches","","Clears the selection, evaluation, and projection cachesThis is useful when repeatedly attemping to select an Obligation while changing only its ParamEnv, since FulfillmentContext doesn't use 'probe'",209,[[["self"]]]],[11,"universe","","",209,[[["self"]],["universeindex"]]],[11,"create_subuniverse","","Create and return a new subunivese of the current universe; update `self.universe` to that new subuniverse. At present, used only in the NLL subtyping code, which uses the new universe-based scheme instead of the more limited leak-check scheme.",209,[[["self"]],["universeindex"]]],[11,"span","","",210,[[["self"]],["span"]]],[11,"types","","",210,[[["obligationcause"],["bool"],["ty"],["ty"]],["typetrace"]]],[11,"dummy","","",210,[[["tyctxt"]],["typetrace"]]],[11,"fmt","","",210,[[["self"],["formatter"]],["result"]]],[11,"span","","",215,[[["self"]],["span"]]],[11,"from_obligation_cause","","",215,[[["obligationcause"],["f"]],["self"]]],[11,"span","","",218,[[["self"]],["span"]]],[11,"super_fold_with","","",214,[[["self"],["v"]],["self"]]],[11,"super_visit_with","","",214,[[["self"],["v"]],["bool"]]],[11,"fmt","","",211,[[["self"],["formatter"]],["result"]]],[0,"lint","rustc","Lints, aka compiler warnings.",N,N],[3,"LateContext","rustc::lint","Context for lint checking after type checking.",N,N],[12,"tcx","","Type context we're checking in.",297,N],[12,"tables","","Side-tables for the body we are in.",297,N],[12,"param_env","","Parameter environment for the item we are in.",297,N],[12,"access_levels","","Items accessible from the crate being checked.",297,N],[12,"lint_sess","","The store of registered lints and the lint levels.",297,N],[12,"last_ast_node_with_lint_attrs","","",297,N],[12,"generics","","Generic type parameters in scope for the item we are in.",297,N],[3,"EarlyContext","","Context for lint checking of the AST, after expansion, before lowering to HIR.",N,N],[12,"sess","","Type context we're checking in.",298,N],[12,"krate","","The crate being checked.",298,N],[12,"builder","","",298,N],[12,"lint_sess","","The store of registered lints and the lint levels.",298,N],[12,"buffered","","",298,N],[3,"LintStore","","Information about the registered lints.",N,N],[12,"lints","","Registered lints. The bool is true if the lint was added by a plugin.",299,N],[12,"pre_expansion_passes","","Trait objects for each lint pass. This is only `None` while performing a lint pass.",299,N],[12,"early_passes","","",299,N],[12,"late_passes","","",299,N],[12,"by_name","","Lints indexed by name.",299,N],[12,"lint_groups","","Map of registered lint groups to what lints they expand to. The first bool is true if the lint group was added by a plugin. The optional string is used to store the new names of deprecated lint group names.",299,N],[12,"future_incompatible","","Extra info for future incompatibility lints, describing the issue or RFC that caused the incompatibility.",299,N],[3,"FutureIncompatibleInfo","","Extra information for a future incompatibility lint. See the call to `register_future_incompatible` in `librustc_lint/lib.rs` for guidelines.",N,N],[12,"id","","",300,N],[12,"reference","","e.g., a URL for an issue/PR/RFC or error code",300,N],[12,"edition","","If this is an edition fixing lint, the edition in which this lint becomes obsolete",300,N],[3,"BufferedEarlyLint","","Lints that are buffered up early on in the `Session` before the `LintLevels` is calculated",N,N],[12,"lint_id","","",301,N],[12,"ast_id","","",301,N],[12,"span","","",301,N],[12,"msg","","",301,N],[12,"diagnostic","","",301,N],[3,"Lint","","Specification of a single lint.",N,N],[12,"name","","A string identifier for the lint.",302,N],[12,"default_level","","Default level for the lint.",302,N],[12,"desc","","Description of the lint or the issue it detects.",302,N],[12,"edition_lint_opts","","Starting at the given edition, default to the given lint level. If this is `None`, then use `default_level`.",302,N],[12,"report_in_external_macro","","Whether this lint is reported even inside expansions of external macros",302,N],[3,"LintId","","Identifies a lint known to the compiler.",N,N],[12,"lint","","",303,N],[3,"LintLevelSets","","",N,N],[12,"list","","",304,N],[12,"lint_cap","","",304,N],[3,"LintLevelMap","","",N,N],[12,"sets","","",305,N],[12,"id_to_set","","",305,N],[3,"LintBuffer","","",N,N],[12,"map","","",306,N],[3,"LintLevelMapBuilder","","",N,N],[12,"levels","","",307,N],[12,"tcx","","",307,N],[4,"CheckLintNameResult","","",N,N],[13,"Ok","","",308,N],[13,"NoLint","","Lint doesn't exist",308,N],[13,"Warning","","The lint is either renamed or removed. This is the warning message, and an optional new name (`None` if removed).",308,N],[13,"Tool","","The lint is from a tool. If the Option is None, then either the lint does not exist in the tool or the code was not compiled with the tool and therefore the lint was never added to the `LintStore`. Otherwise the `LintId` will be returned as if it where a rustc lint.",308,N],[4,"Level","","Setting for how to handle a lint.",N,N],[13,"Allow","","",309,N],[13,"Warn","","",309,N],[13,"Deny","","",309,N],[13,"Forbid","","",309,N],[4,"LintSource","","How a lint level was set.",N,N],[13,"Default","","Lint is at the default level as declared in rustc or a plugin.",310,N],[13,"Node","","Lint level was set by an attribute.",310,N],[13,"CommandLine","","Lint level was set by a command-line flag.",310,N],[5,"check_crate","","Perform lint checking on a crate.",N,[[["tyctxt"]]]],[5,"check_ast_crate","","",N,[[["session"],["crate"],["bool"]]]],[5,"struct_lint_level","","",N,[[["session"],["lint"],["level"],["lintsource"],["option",["multispan"]],["str"]],["diagnosticbuilder"]]],[5,"lint_levels","","",N,[[["tyctxt"],["cratenum"]],["lrc",["lintlevelmap"]]]],[5,"provide","","",N,[[["providers"]]]],[5,"in_external_macro","","Returns whether `span` originates in a foreign crate's external macro.",N,[[["session"],["span"]],["bool"]]],[0,"builtin","","Some lints that are built in to the compiler.",N,N],[3,"HardwiredLints","rustc::lint::builtin","Does nothing as a lint pass, but registers some `Lint`s which are used by other parts of the compiler.",N,N],[4,"BuiltinLintDiagnostics","","",N,N],[13,"Normal","","",311,N],[13,"BareTraitObject","","",311,N],[13,"AbsPathWithModule","","",311,N],[13,"DuplicatedMacroExports","","",311,N],[13,"ProcMacroDeriveResolutionFallback","","",311,N],[13,"MacroExpandedMacroExportsAccessedByAbsolutePaths","","",311,N],[13,"ElidedLifetimesInPaths","","",311,N],[13,"UnknownCrateTypes","","",311,N],[0,"parser","","Some lints that are buffered from `libsyntax`. See `syntax::early_buffered_lints`.",N,N],[7,"QUESTION_MARK_MACRO_SEP","rustc::lint::builtin::parser","",N,N],[7,"EXCEEDING_BITSHIFTS","rustc::lint::builtin","",N,N],[7,"CONST_ERR","","",N,N],[7,"UNUSED_IMPORTS","","",N,N],[7,"UNUSED_EXTERN_CRATES","","",N,N],[7,"UNUSED_QUALIFICATIONS","","",N,N],[7,"UNKNOWN_LINTS","","",N,N],[7,"UNUSED_VARIABLES","","",N,N],[7,"UNUSED_ASSIGNMENTS","","",N,N],[7,"DEAD_CODE","","",N,N],[7,"UNREACHABLE_CODE","","",N,N],[7,"UNREACHABLE_PATTERNS","","",N,N],[7,"UNUSED_MACROS","","",N,N],[7,"WARNINGS","","",N,N],[7,"UNUSED_FEATURES","","",N,N],[7,"STABLE_FEATURES","","",N,N],[7,"UNKNOWN_CRATE_TYPES","","",N,N],[7,"TRIVIAL_CASTS","","",N,N],[7,"TRIVIAL_NUMERIC_CASTS","","",N,N],[7,"PRIVATE_IN_PUBLIC","","",N,N],[7,"PUB_USE_OF_PRIVATE_EXTERN_CRATE","","",N,N],[7,"INVALID_TYPE_PARAM_DEFAULT","","",N,N],[7,"RENAMED_AND_REMOVED_LINTS","","",N,N],[7,"SAFE_EXTERN_STATICS","","",N,N],[7,"SAFE_PACKED_BORROWS","","",N,N],[7,"PATTERNS_IN_FNS_WITHOUT_BODY","","",N,N],[7,"LEGACY_DIRECTORY_OWNERSHIP","","",N,N],[7,"LEGACY_CONSTRUCTOR_VISIBILITY","","",N,N],[7,"MISSING_FRAGMENT_SPECIFIER","","",N,N],[7,"PARENTHESIZED_PARAMS_IN_TYPES_AND_MODULES","","",N,N],[7,"LATE_BOUND_LIFETIME_ARGUMENTS","","",N,N],[7,"INCOHERENT_FUNDAMENTAL_IMPLS","","",N,N],[7,"BAD_REPR","","",N,N],[7,"DEPRECATED","","",N,N],[7,"UNUSED_UNSAFE","","",N,N],[7,"UNUSED_MUT","","",N,N],[7,"SINGLE_USE_LIFETIMES","","",N,N],[7,"UNUSED_LIFETIMES","","",N,N],[7,"TYVAR_BEHIND_RAW_POINTER","","",N,N],[7,"ELIDED_LIFETIMES_IN_PATHS","","",N,N],[7,"BARE_TRAIT_OBJECTS","","",N,N],[7,"ABSOLUTE_PATHS_NOT_STARTING_WITH_CRATE","","",N,N],[7,"ILLEGAL_FLOATING_POINT_LITERAL_PATTERN","","",N,N],[7,"UNSTABLE_NAME_COLLISIONS","","",N,N],[7,"IRREFUTABLE_LET_PATTERNS","","",N,N],[7,"UNUSED_LABELS","","",N,N],[7,"DUPLICATE_ASSOCIATED_TYPE_BINDINGS","","",N,N],[7,"DUPLICATE_MACRO_EXPORTS","","",N,N],[7,"INTRA_DOC_LINK_RESOLUTION_FAILURE","","",N,N],[7,"WHERE_CLAUSES_OBJECT_SAFETY","","",N,N],[7,"PROC_MACRO_DERIVE_RESOLUTION_FALLBACK","","",N,N],[7,"MACRO_USE_EXTERN_CRATE","","",N,N],[7,"MACRO_EXPANDED_MACRO_EXPORTS_ACCESSED_BY_ABSOLUTE_PATHS","","",N,N],[11,"clone","","",312,[[["self"]],["hardwiredlints"]]],[11,"get_lints","","",312,[[["self"]],["lintarray"]]],[11,"eq","","",311,[[["self"],["builtinlintdiagnostics"]],["bool"]]],[11,"ne","","",311,[[["self"],["builtinlintdiagnostics"]],["bool"]]],[11,"encode","","",311,[[["self"],["__s"]],["result"]]],[11,"decode","","",311,[[["__d"]],["result",["builtinlintdiagnostics"]]]],[11,"fmt","","",311,[[["self"],["formatter"]],["result"]]],[11,"run","","",311,[[["self"],["session"],["diagnosticbuilder"]]]],[0,"context","rustc::lint","Implementation of lint checking.",N,N],[3,"LintStore","rustc::lint::context","Information about the registered lints.",N,N],[12,"lints","","Registered lints. The bool is true if the lint was added by a plugin.",299,N],[12,"pre_expansion_passes","","Trait objects for each lint pass. This is only `None` while performing a lint pass.",299,N],[12,"early_passes","","",299,N],[12,"late_passes","","",299,N],[12,"by_name","","Lints indexed by name.",299,N],[12,"lint_groups","","Map of registered lint groups to what lints they expand to. The first bool is true if the lint group was added by a plugin. The optional string is used to store the new names of deprecated lint group names.",299,N],[12,"future_incompatible","","Extra info for future incompatibility lints, describing the issue or RFC that caused the incompatibility.",299,N],[3,"LintSession","","",N,N],[12,"lints","","Reference to the store of registered lints.",313,N],[12,"passes","","Trait objects for each lint pass.",313,N],[3,"BufferedEarlyLint","","Lints that are buffered up early on in the `Session` before the `LintLevels` is calculated",N,N],[12,"lint_id","","",301,N],[12,"ast_id","","",301,N],[12,"span","","",301,N],[12,"msg","","",301,N],[12,"diagnostic","","",301,N],[3,"FutureIncompatibleInfo","","Extra information for a future incompatibility lint. See the call to `register_future_incompatible` in `librustc_lint/lib.rs` for guidelines.",N,N],[12,"id","","",300,N],[12,"reference","","e.g., a URL for an issue/PR/RFC or error code",300,N],[12,"edition","","If this is an edition fixing lint, the edition in which this lint becomes obsolete",300,N],[3,"LateContext","","Context for lint checking after type checking.",N,N],[12,"tcx","","Type context we're checking in.",297,N],[12,"tables","","Side-tables for the body we are in.",297,N],[12,"param_env","","Parameter environment for the item we are in.",297,N],[12,"access_levels","","Items accessible from the crate being checked.",297,N],[12,"lint_sess","","The store of registered lints and the lint levels.",297,N],[12,"last_ast_node_with_lint_attrs","","",297,N],[12,"generics","","Generic type parameters in scope for the item we are in.",297,N],[3,"EarlyContext","","Context for lint checking of the AST, after expansion, before lowering to HIR.",N,N],[12,"sess","","Type context we're checking in.",298,N],[12,"krate","","The crate being checked.",298,N],[12,"builder","","",298,N],[12,"lint_sess","","The store of registered lints and the lint levels.",298,N],[12,"buffered","","",298,N],[4,"TargetLint","","The target of the `by_name` map, which accounts for renaming/deprecation.",N,N],[13,"Id","","A direct lint target",314,N],[13,"Renamed","","Temporary renaming, used for easing migration pain; see #16545",314,N],[13,"Removed","","Lint with this name existed previously, but has been removed/deprecated. The string argument is the reason for removal.",314,N],[4,"FindLintError","","",N,N],[13,"NotFound","","",315,N],[13,"Removed","","",315,N],[4,"CheckLintNameResult","","",N,N],[13,"Ok","","",308,N],[13,"NoLint","","Lint doesn't exist",308,N],[13,"Warning","","The lint is either renamed or removed. This is the warning message, and an optional new name (`None` if removed).",308,N],[13,"Tool","","The lint is from a tool. If the Option is None, then either the lint does not exist in the tool or the code was not compiled with the tool and therefore the lint was never added to the `LintStore`. Otherwise the `LintId` will be returned as if it where a rustc lint.",308,N],[5,"check_crate","","Perform lint checking on a crate.",N,[[["tyctxt"]]]],[5,"check_ast_crate","","",N,[[["session"],["crate"],["bool"]]]],[8,"LintPassObject","","",N,N],[8,"LintContext","","",N,N],[16,"PassObject","","",316,N],[10,"sess","","",316,[[["self"]],["session"]]],[10,"lints","","",316,[[["self"]],["lintstore"]]],[10,"lint_sess","","",316,[[["self"]],["lintsession"]]],[10,"lint_sess_mut","","",316,[[["self"]],["lintsession"]]],[10,"enter_attrs","","",316,N],[10,"exit_attrs","","",316,N],[11,"lookup_and_emit","","",316,[[["self"],["lint"],["option"],["str"]]]],[11,"lookup_and_emit_with_diagnostics","","",316,[[["self"],["lint"],["option"],["str"],["builtinlintdiagnostics"]]]],[10,"lookup","","",316,[[["self"],["lint"],["option"],["str"]],["diagnosticbuilder"]]],[11,"span_lint","","Emit a lint at the appropriate level, for a particular span.",316,[[["self"],["lint"],["s"],["str"]]]],[11,"struct_span_lint","","",316,[[["self"],["lint"],["s"],["str"]],["diagnosticbuilder"]]],[11,"span_lint_note","","Emit a lint and note at the appropriate level, for a particular span.",316,[[["self"],["lint"],["span"],["str"],["span"],["str"]]]],[11,"span_lint_help","","Emit a lint and help at the appropriate level, for a particular span.",316,[[["self"],["lint"],["span"],["str"],["str"]]]],[11,"lint","","Emit a lint at the appropriate level, with no associated span.",316,[[["self"],["lint"],["str"]]]],[10,"with_lint_attrs","","Merge the lints specified by any lint attributes into the current lint context, call the provided function, then reset the lints in effect to their previous state.",316,N],[11,"eq","rustc::lint","",301,[[["self"],["bufferedearlylint"]],["bool"]]],[11,"ne","","",301,[[["self"],["bufferedearlylint"]],["bool"]]],[11,"encode","","",301,[[["self"],["__s"]],["result"]]],[11,"decode","","",301,[[["__d"]],["result",["bufferedearlylint"]]]],[11,"fmt","","",301,[[["self"],["formatter"]],["result"]]],[11,"new","","",299,[[],["lintstore"]]],[11,"get_lints","","",299,N],[11,"get_lint_groups","","",299,[[["self"]],["vec"]]],[11,"register_early_pass","","",299,[[["self"],["option",["session"]],["bool"],["earlylintpassobject"]]]],[11,"register_pre_expansion_pass","","",299,[[["self"],["option",["session"]],["earlylintpassobject"]]]],[11,"register_late_pass","","",299,[[["self"],["option",["session"]],["bool"],["latelintpassobject"]]]],[11,"push_pass","","",299,[[["self"],["option",["session"]],["bool"],["box"]]]],[11,"register_future_incompatible","","",299,[[["self"],["option",["session"]],["vec",["futureincompatibleinfo"]]]]],[11,"future_incompatible","","",299,[[["self"],["lintid"]],["option",["futureincompatibleinfo"]]]],[11,"register_group","","",299,[[["self"],["option",["session"]],["bool"],["str"],["option",["str"]],["vec",["lintid"]]]]],[11,"register_renamed","","",299,[[["self"],["str"],["str"]]]],[11,"register_removed","","",299,[[["self"],["str"],["str"]]]],[11,"find_lints","","",299,[[["self"],["str"]],["result",["vec","findlinterror"]]]],[11,"check_lint_name_cmdline","","Checks the validity of lint names derived from the command line",299,[[["self"],["session"],["str"],["level"]]]],[11,"check_lint_name","","Checks the name of a lint for its existence, and whether it was renamed or removed. Generates a DiagnosticBuilder containing a warning for renamed and removed lints. This is over both lint names from attributes and those passed on the command line. Since it emits non-fatal warnings and there are two lint passes that inspect attributes, this is only run from the late pass to avoid printing duplicate warnings.",299,[[["self"],["str"],["option",["localinternedstring"]]],["checklintnameresult"]]],[11,"check_tool_name_for_backwards_compat","","",299,[[["self"],["str"],["str"]],["checklintnameresult"]]],[11,"new","","",298,[[["session"],["crate"],["option",["vec"]],["lintbuffer"]],["earlycontext"]]],[11,"check_id","","",298,[[["self"],["nodeid"]]]],[11,"sess","","Get the overall compiler `Session` object.",297,[[["self"]],["session"]]],[11,"lints","","",297,[[["self"]],["lintstore"]]],[11,"lint_sess","","",297,[[["self"]],["lintsession"]]],[11,"lint_sess_mut","","",297,[[["self"]],["lintsession"]]],[11,"enter_attrs","","",297,N],[11,"exit_attrs","","",297,N],[11,"lookup","","",297,[[["self"],["lint"],["option"],["str"]],["diagnosticbuilder"]]],[11,"with_lint_attrs","","",297,N],[11,"sess","","Get the overall compiler `Session` object.",298,[[["self"]],["session"]]],[11,"lints","","",298,[[["self"]],["lintstore"]]],[11,"lint_sess","","",298,[[["self"]],["lintsession"]]],[11,"lint_sess_mut","","",298,[[["self"]],["lintsession"]]],[11,"enter_attrs","","",298,N],[11,"exit_attrs","","",298,N],[11,"lookup","","",298,[[["self"],["lint"],["option"],["str"]],["diagnosticbuilder"]]],[11,"with_lint_attrs","","",298,N],[11,"with_param_env","","",297,[[["self"],["nodeid"],["f"]]]],[11,"current_lint_root","","",297,[[["self"]],["nodeid"]]],[11,"nested_visit_map","","Because lints are scoped lexically, we want to walk nested items in the context of the outer item, so enable deep-walking.",297,[[["self"]],["nestedvisitormap"]]],[11,"visit_nested_body","","",297,[[["self"],["bodyid"]]]],[11,"visit_body","","",297,[[["self"],["body"]]]],[11,"visit_item","","",297,[[["self"],["item"]]]],[11,"visit_foreign_item","","",297,[[["self"],["foreignitem"]]]],[11,"visit_pat","","",297,[[["self"],["pat"]]]],[11,"visit_expr","","",297,[[["self"],["expr"]]]],[11,"visit_stmt","","",297,[[["self"],["stmt"]]]],[11,"visit_fn","","",297,[[["self"],["fnkind"],["fndecl"],["bodyid"],["span"],["nodeid"]]]],[11,"visit_variant_data","","",297,[[["self"],["variantdata"],["name"],["generics"],["nodeid"],["span"]]]],[11,"visit_struct_field","","",297,[[["self"],["structfield"]]]],[11,"visit_variant","","",297,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_ty","","",297,[[["self"],["ty"]]]],[11,"visit_name","","",297,[[["self"],["span"],["name"]]]],[11,"visit_mod","","",297,[[["self"],["mod"],["span"],["nodeid"]]]],[11,"visit_local","","",297,[[["self"],["local"]]]],[11,"visit_block","","",297,[[["self"],["block"]]]],[11,"visit_arm","","",297,[[["self"],["arm"]]]],[11,"visit_decl","","",297,[[["self"],["decl"]]]],[11,"visit_generic_param","","",297,[[["self"],["genericparam"]]]],[11,"visit_generics","","",297,[[["self"],["generics"]]]],[11,"visit_where_predicate","","",297,[[["self"],["wherepredicate"]]]],[11,"visit_poly_trait_ref","","",297,[[["self"],["polytraitref"],["traitboundmodifier"]]]],[11,"visit_trait_item","","",297,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",297,[[["self"],["implitem"]]]],[11,"visit_lifetime","","",297,[[["self"],["lifetime"]]]],[11,"visit_path","","",297,[[["self"],["path"],["hirid"]]]],[11,"visit_attribute","","",297,[[["self"],["attribute"]]]],[11,"visit_item","","",298,[[["self"],["item"]]]],[11,"visit_foreign_item","","",298,[[["self"],["foreignitem"]]]],[11,"visit_pat","","",298,[[["self"],["pat"]]]],[11,"visit_expr","","",298,[[["self"],["expr"]]]],[11,"visit_stmt","","",298,[[["self"],["stmt"]]]],[11,"visit_fn","","",298,[[["self"],["fnkind"],["fndecl"],["span"],["nodeid"]]]],[11,"visit_variant_data","","",298,[[["self"],["variantdata"],["ident"],["generics"],["nodeid"],["span"]]]],[11,"visit_struct_field","","",298,[[["self"],["structfield"]]]],[11,"visit_variant","","",298,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_ty","","",298,[[["self"],["ty"]]]],[11,"visit_ident","","",298,[[["self"],["ident"]]]],[11,"visit_mod","","",298,N],[11,"visit_local","","",298,[[["self"],["local"]]]],[11,"visit_block","","",298,[[["self"],["block"]]]],[11,"visit_arm","","",298,[[["self"],["arm"]]]],[11,"visit_expr_post","","",298,[[["self"],["expr"]]]],[11,"visit_generic_param","","",298,[[["self"],["genericparam"]]]],[11,"visit_generics","","",298,[[["self"],["generics"]]]],[11,"visit_where_predicate","","",298,[[["self"],["wherepredicate"]]]],[11,"visit_poly_trait_ref","","",298,[[["self"],["polytraitref"],["traitboundmodifier"]]]],[11,"visit_trait_item","","",298,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",298,[[["self"],["implitem"]]]],[11,"visit_lifetime","","",298,[[["self"],["lifetime"]]]],[11,"visit_path","","",298,[[["self"],["path"],["nodeid"]]]],[11,"visit_attribute","","",298,[[["self"],["attribute"]]]],[11,"visit_mac_def","","",298,[[["self"],["macrodef"],["nodeid"]]]],[11,"visit_mac","","",298,[[["self"],["mac"]]]],[11,"encode","","",303,[[["self"],["s"]],["result"]]],[11,"decode","","",303,[[["d"]],["result",["lintid"]]]],[0,"levels","","",N,N],[3,"LintLevelSets","rustc::lint::levels","",N,N],[12,"list","","",304,N],[12,"lint_cap","","",304,N],[3,"LintLevelsBuilder","","",N,N],[12,"sess","","",317,N],[12,"sets","","",317,N],[12,"id_to_set","","",317,N],[12,"cur","","",317,N],[12,"warn_about_weird_lints","","",317,N],[3,"BuilderPush","","",N,N],[12,"prev","","",318,N],[3,"LintLevelMap","","",N,N],[12,"sets","","",305,N],[12,"id_to_set","","",305,N],[4,"LintSet","","",N,N],[13,"CommandLine","","",319,N],[12,"specs","rustc::lint::levels::LintSet","",319,N],[13,"Node","rustc::lint::levels","",319,N],[12,"specs","rustc::lint::levels::LintSet","",319,N],[12,"parent","","",319,N],[11,"new","rustc::lint","",304,[[["session"]],["lintlevelsets"]]],[11,"builder","","",304,[[["session"]],["lintlevelsbuilder"]]],[11,"process_command_line","","",304,[[["self"],["session"]]]],[11,"get_lint_level","","",304,N],[11,"get_lint_id_level","","",304,N],[11,"new","rustc::lint::levels","",317,[[["session"],["lintlevelsets"]],["lintlevelsbuilder"]]],[11,"push","","Pushes a list of AST lint attributes onto this context.",317,N],[11,"pop","","Called after `push` when the scope of a set of attributes are exited.",317,[[["self"],["builderpush"]]]],[11,"struct_lint","","Used to emit a lint-related diagnostic based on the current state of this lint context.",317,[[["self"],["lint"],["option",["multispan"]],["str"]],["diagnosticbuilder"]]],[11,"register_id","","Registers the ID provided with the current set of lints stored in this context.",317,[[["self"],["hirid"]]]],[11,"build","","",317,[[["self"]],["lintlevelsets"]]],[11,"build_map","","",317,[[["self"]],["lintlevelmap"]]],[11,"level_and_source","rustc::lint","If the `id` was previously registered with `register_id` when building this `LintLevelMap` this returns the corresponding lint level and source of the lint level for the lint provided.",305,[[["self"],["lint"],["hirid"],["session"]],["option"]]],[11,"lint_level_set","","Returns if this `id` has lint level information.",305,[[["self"],["hirid"]],["option",["u32"]]]],[11,"hash_stable","","",305,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"hash_stable","","",303,[[["self"],["hcx"],["stablehasher"]]]],[11,"to_stable_hash_key","","",303,[[["self"],["hcx"]],["str"]]],[6,"LintArray","","",N,N],[6,"EarlyLintPassObject","","A lint pass boxed up as a trait object.",N,N],[6,"LateLintPassObject","","",N,N],[6,"LevelSource","","",N,N],[8,"LintContext","","",N,N],[16,"PassObject","","",316,N],[10,"sess","","",316,[[["self"]],["session"]]],[10,"lints","","",316,[[["self"]],["lintstore"]]],[10,"lint_sess","","",316,[[["self"]],["lintsession"]]],[10,"lint_sess_mut","","",316,[[["self"]],["lintsession"]]],[10,"enter_attrs","","",316,N],[10,"exit_attrs","","",316,N],[11,"lookup_and_emit","rustc::lint::context","",316,[[["self"],["lint"],["option"],["str"]]]],[11,"lookup_and_emit_with_diagnostics","","",316,[[["self"],["lint"],["option"],["str"],["builtinlintdiagnostics"]]]],[10,"lookup","rustc::lint","",316,[[["self"],["lint"],["option"],["str"]],["diagnosticbuilder"]]],[11,"span_lint","rustc::lint::context","Emit a lint at the appropriate level, for a particular span.",316,[[["self"],["lint"],["s"],["str"]]]],[11,"struct_span_lint","","",316,[[["self"],["lint"],["s"],["str"]],["diagnosticbuilder"]]],[11,"span_lint_note","","Emit a lint and note at the appropriate level, for a particular span.",316,[[["self"],["lint"],["span"],["str"],["span"],["str"]]]],[11,"span_lint_help","","Emit a lint and help at the appropriate level, for a particular span.",316,[[["self"],["lint"],["span"],["str"],["str"]]]],[11,"lint","","Emit a lint at the appropriate level, with no associated span.",316,[[["self"],["lint"],["str"]]]],[10,"with_lint_attrs","rustc::lint","Merge the lints specified by any lint attributes into the current lint context, call the provided function, then reset the lints in effect to their previous state.",316,N],[8,"LintPass","","",N,N],[10,"get_lints","","Get descriptions of the lints this `LintPass` object can emit.",320,[[["self"]],["lintarray"]]],[8,"LateLintPass","","",N,N],[11,"check_body","","",321,[[["self"],["latecontext"],["body"]]]],[11,"check_body_post","","",321,[[["self"],["latecontext"],["body"]]]],[11,"check_name","","",321,[[["self"],["latecontext"],["span"],["name"]]]],[11,"check_crate","","",321,[[["self"],["latecontext"],["crate"]]]],[11,"check_crate_post","","",321,[[["self"],["latecontext"],["crate"]]]],[11,"check_mod","","",321,[[["self"],["latecontext"],["mod"],["span"],["nodeid"]]]],[11,"check_mod_post","","",321,[[["self"],["latecontext"],["mod"],["span"],["nodeid"]]]],[11,"check_foreign_item","","",321,[[["self"],["latecontext"],["foreignitem"]]]],[11,"check_foreign_item_post","","",321,[[["self"],["latecontext"],["foreignitem"]]]],[11,"check_item","","",321,[[["self"],["latecontext"],["item"]]]],[11,"check_item_post","","",321,[[["self"],["latecontext"],["item"]]]],[11,"check_local","","",321,[[["self"],["latecontext"],["local"]]]],[11,"check_block","","",321,[[["self"],["latecontext"],["block"]]]],[11,"check_block_post","","",321,[[["self"],["latecontext"],["block"]]]],[11,"check_stmt","","",321,[[["self"],["latecontext"],["stmt"]]]],[11,"check_arm","","",321,[[["self"],["latecontext"],["arm"]]]],[11,"check_pat","","",321,[[["self"],["latecontext"],["pat"]]]],[11,"check_decl","","",321,[[["self"],["latecontext"],["decl"]]]],[11,"check_expr","","",321,[[["self"],["latecontext"],["expr"]]]],[11,"check_expr_post","","",321,[[["self"],["latecontext"],["expr"]]]],[11,"check_ty","","",321,[[["self"],["latecontext"],["ty"]]]],[11,"check_generic_param","","",321,[[["self"],["latecontext"],["genericparam"]]]],[11,"check_generics","","",321,[[["self"],["latecontext"],["generics"]]]],[11,"check_where_predicate","","",321,[[["self"],["latecontext"],["wherepredicate"]]]],[11,"check_poly_trait_ref","","",321,[[["self"],["latecontext"],["polytraitref"],["traitboundmodifier"]]]],[11,"check_fn","","",321,[[["self"],["latecontext"],["fnkind"],["fndecl"],["body"],["span"],["nodeid"]]]],[11,"check_fn_post","","",321,[[["self"],["latecontext"],["fnkind"],["fndecl"],["body"],["span"],["nodeid"]]]],[11,"check_trait_item","","",321,[[["self"],["latecontext"],["traititem"]]]],[11,"check_trait_item_post","","",321,[[["self"],["latecontext"],["traititem"]]]],[11,"check_impl_item","","",321,[[["self"],["latecontext"],["implitem"]]]],[11,"check_impl_item_post","","",321,[[["self"],["latecontext"],["implitem"]]]],[11,"check_struct_def","","",321,[[["self"],["latecontext"],["variantdata"],["name"],["generics"],["nodeid"]]]],[11,"check_struct_def_post","","",321,[[["self"],["latecontext"],["variantdata"],["name"],["generics"],["nodeid"]]]],[11,"check_struct_field","","",321,[[["self"],["latecontext"],["structfield"]]]],[11,"check_variant","","",321,[[["self"],["latecontext"],["variant"],["generics"]]]],[11,"check_variant_post","","",321,[[["self"],["latecontext"],["variant"],["generics"]]]],[11,"check_lifetime","","",321,[[["self"],["latecontext"],["lifetime"]]]],[11,"check_path","","",321,[[["self"],["latecontext"],["path"],["hirid"]]]],[11,"check_attribute","","",321,[[["self"],["latecontext"],["attribute"]]]],[11,"enter_lint_attrs","","",321,N],[11,"exit_lint_attrs","","",321,N],[8,"EarlyLintPass","","",N,N],[11,"check_ident","","",322,[[["self"],["earlycontext"],["ident"]]]],[11,"check_crate","","",322,[[["self"],["earlycontext"],["crate"]]]],[11,"check_crate_post","","",322,[[["self"],["earlycontext"],["crate"]]]],[11,"check_mod","","",322,[[["self"],["earlycontext"],["mod"],["span"],["nodeid"]]]],[11,"check_mod_post","","",322,[[["self"],["earlycontext"],["mod"],["span"],["nodeid"]]]],[11,"check_foreign_item","","",322,[[["self"],["earlycontext"],["foreignitem"]]]],[11,"check_foreign_item_post","","",322,[[["self"],["earlycontext"],["foreignitem"]]]],[11,"check_item","","",322,[[["self"],["earlycontext"],["item"]]]],[11,"check_item_post","","",322,[[["self"],["earlycontext"],["item"]]]],[11,"check_local","","",322,[[["self"],["earlycontext"],["local"]]]],[11,"check_block","","",322,[[["self"],["earlycontext"],["block"]]]],[11,"check_block_post","","",322,[[["self"],["earlycontext"],["block"]]]],[11,"check_stmt","","",322,[[["self"],["earlycontext"],["stmt"]]]],[11,"check_arm","","",322,[[["self"],["earlycontext"],["arm"]]]],[11,"check_pat","","",322,[[["self"],["earlycontext"],["pat"]]]],[11,"check_expr","","",322,[[["self"],["earlycontext"],["expr"]]]],[11,"check_expr_post","","",322,[[["self"],["earlycontext"],["expr"]]]],[11,"check_ty","","",322,[[["self"],["earlycontext"],["ty"]]]],[11,"check_generic_param","","",322,[[["self"],["earlycontext"],["genericparam"]]]],[11,"check_generics","","",322,[[["self"],["earlycontext"],["generics"]]]],[11,"check_where_predicate","","",322,[[["self"],["earlycontext"],["wherepredicate"]]]],[11,"check_poly_trait_ref","","",322,[[["self"],["earlycontext"],["polytraitref"],["traitboundmodifier"]]]],[11,"check_fn","","",322,[[["self"],["earlycontext"],["fnkind"],["fndecl"],["span"],["nodeid"]]]],[11,"check_fn_post","","",322,[[["self"],["earlycontext"],["fnkind"],["fndecl"],["span"],["nodeid"]]]],[11,"check_trait_item","","",322,[[["self"],["earlycontext"],["traititem"]]]],[11,"check_trait_item_post","","",322,[[["self"],["earlycontext"],["traititem"]]]],[11,"check_impl_item","","",322,[[["self"],["earlycontext"],["implitem"]]]],[11,"check_impl_item_post","","",322,[[["self"],["earlycontext"],["implitem"]]]],[11,"check_struct_def","","",322,[[["self"],["earlycontext"],["variantdata"],["ident"],["generics"],["nodeid"]]]],[11,"check_struct_def_post","","",322,[[["self"],["earlycontext"],["variantdata"],["ident"],["generics"],["nodeid"]]]],[11,"check_struct_field","","",322,[[["self"],["earlycontext"],["structfield"]]]],[11,"check_variant","","",322,[[["self"],["earlycontext"],["variant"],["generics"]]]],[11,"check_variant_post","","",322,[[["self"],["earlycontext"],["variant"],["generics"]]]],[11,"check_lifetime","","",322,[[["self"],["earlycontext"],["lifetime"]]]],[11,"check_path","","",322,[[["self"],["earlycontext"],["path"],["nodeid"]]]],[11,"check_attribute","","",322,[[["self"],["earlycontext"],["attribute"]]]],[11,"check_mac_def","","",322,[[["self"],["earlycontext"],["macrodef"],["nodeid"]]]],[11,"check_mac","","",322,[[["self"],["earlycontext"],["mac"]]]],[11,"enter_lint_attrs","","Called when entering a syntax node that can have lint attributes such as `#[allow(...)]`. Called with all the attributes of that node.",322,N],[11,"exit_lint_attrs","","Counterpart to `enter_lint_attrs`.",322,N],[11,"clone","","",302,[[["self"]],["lint"]]],[11,"fmt","","",302,[[["self"],["formatter"]],["result"]]],[11,"from_parser_lint_id","","Returns the `rust::lint::Lint` for a `syntax::early_buffered_lints::BufferedEarlyLintId`.",302,[[["bufferedearlylintid"]],["self"]]],[11,"name_lower","","Get the lint's name, with ASCII letters converted to lowercase.",302,[[["self"]],["string"]]],[11,"default_level","","",302,[[["self"],["session"]],["level"]]],[11,"clone","","",303,[[["self"]],["lintid"]]],[11,"fmt","","",303,[[["self"],["formatter"]],["result"]]],[11,"eq","","",303,[[["self"],["lintid"]],["bool"]]],[11,"hash","","",303,[[["self"],["h"]]]],[11,"of","","Get the `LintId` for a `Lint`.",303,[[["lint"]],["lintid"]]],[11,"lint_name_raw","","",303,[[["self"]],["str"]]],[11,"to_string","","Get the name of the lint.",303,[[["self"]],["string"]]],[11,"clone","","",309,[[["self"]],["level"]]],[11,"eq","","",309,[[["self"],["level"]],["bool"]]],[11,"partial_cmp","","",309,[[["self"],["level"]],["option",["ordering"]]]],[11,"assert_receiver_is_total_eq","","",309,N],[11,"cmp","","",309,[[["self"],["level"]],["ordering"]]],[11,"fmt","","",309,[[["self"],["formatter"]],["result"]]],[11,"hash","","",309,N],[11,"hash_stable","","",309,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"as_str","","Convert a level to a lower-case string.",309,[[["self"]],["str"]]],[11,"from_str","","Convert a lower-case string to a level.",309,[[["str"]],["option",["level"]]]],[11,"clone","","",310,[[["self"]],["lintsource"]]],[11,"eq","","",310,[[["self"],["lintsource"]],["bool"]]],[11,"ne","","",310,[[["self"],["lintsource"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",310,N],[11,"hash_stable","","",310,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"new","","",306,[[],["lintbuffer"]]],[11,"add_lint","","",306,[[["self"],["lint"],["nodeid"],["multispan"],["str"],["builtinlintdiagnostics"]]]],[11,"take","","",306,[[["self"],["nodeid"]],["vec",["bufferedearlylint"]]]],[11,"get_any","","",306,[[["self"]],["option"]]],[11,"with_lint_attrs","","",307,N],[11,"nested_visit_map","","",307,[[["self"]],["nestedvisitormap"]]],[11,"visit_item","","",307,[[["self"],["item"]]]],[11,"visit_foreign_item","","",307,[[["self"],["foreignitem"]]]],[11,"visit_expr","","",307,[[["self"],["expr"]]]],[11,"visit_struct_field","","",307,[[["self"],["structfield"]]]],[11,"visit_variant","","",307,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_local","","",307,[[["self"],["local"]]]],[11,"visit_trait_item","","",307,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",307,[[["self"],["implitem"]]]],[0,"middle","rustc","",N,N],[0,"allocator","rustc::middle","",N,N],[4,"AllocatorKind","rustc::middle::allocator","",N,N],[13,"Global","","",323,N],[13,"DefaultLib","","",323,N],[13,"DefaultExe","","",323,N],[11,"clone","","",323,[[["self"]],["allocatorkind"]]],[11,"fn_name","","",323,[[["self"],["str"]],["string"]]],[0,"borrowck","rustc::middle","",N,N],[3,"BorrowCheckResult","rustc::middle::borrowck","",N,N],[12,"used_mut_nodes","","",324,N],[12,"signalled_any_error","","",324,N],[4,"SignalledError","","",N,N],[13,"SawSomeError","","",325,N],[13,"NoErrorsSeen","","",325,N],[11,"clone","","",325,[[["self"]],["signallederror"]]],[11,"fmt","","",325,[[["self"],["formatter"]],["result"]]],[11,"encode","","",325,[[["self"],["__s"]],["result"]]],[11,"decode","","",325,[[["__d"]],["result",["signallederror"]]]],[11,"hash_stable","","",325,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"fmt","","",324,[[["self"],["formatter"]],["result"]]],[11,"encode","","",324,[[["self"],["__s"]],["result"]]],[11,"decode","","",324,[[["__d"]],["result",["borrowcheckresult"]]]],[11,"hash_stable","","",324,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[0,"expr_use_visitor","rustc::middle","A different sort of visitor for walking fn bodies.  Unlike the normal visitor, which just walks the entire body in one shot, the `ExprUseVisitor` determines how expressions are being used.",N,N],[3,"ExprUseVisitor","rustc::middle::expr_use_visitor","",N,N],[12,"mc","","",326,N],[12,"delegate","","",326,N],[12,"param_env","","",326,N],[4,"LoanCause","","",N,N],[13,"ClosureCapture","","",327,N],[13,"AddrOf","","",327,N],[13,"AutoRef","","",327,N],[13,"AutoUnsafe","","",327,N],[13,"RefBinding","","",327,N],[13,"OverloadedOperator","","",327,N],[13,"ClosureInvocation","","",327,N],[13,"ForLoop","","",327,N],[13,"MatchDiscriminant","","",327,N],[4,"ConsumeMode","","",N,N],[13,"Copy","","",328,N],[13,"Move","","",328,N],[4,"MoveReason","","",N,N],[13,"DirectRefMove","","",329,N],[13,"PatBindingMove","","",329,N],[13,"CaptureMove","","",329,N],[4,"MatchMode","","",N,N],[13,"NonBindingMatch","","",330,N],[13,"BorrowingMatch","","",330,N],[13,"CopyingMatch","","",330,N],[13,"MovingMatch","","",330,N],[4,"TrackMatchMode","","",N,N],[13,"Unknown","","",331,N],[13,"Definite","","",331,N],[13,"Conflicting","","",331,N],[4,"MutateMode","","",N,N],[13,"Init","","",332,N],[13,"JustWrite","","",332,N],[13,"WriteAndRead","","",332,N],[4,"OverloadedCallType","","",N,N],[13,"FnOverloadedCall","","",333,N],[13,"FnMutOverloadedCall","","",333,N],[13,"FnOnceOverloadedCall","","",333,N],[5,"copy_or_move","","",N,[[["memcategorizationcontext"],["paramenv"],["cmt_"],["movereason"]],["consumemode"]]],[8,"Delegate","","This trait defines the callbacks you can expect to receive when employing the ExprUseVisitor.",N,N],[10,"consume","","",334,[[["self"],["nodeid"],["span"],["cmt_"],["consumemode"]]]],[10,"matched_pat","","",334,[[["self"],["pat"],["cmt_"],["matchmode"]]]],[10,"consume_pat","","",334,[[["self"],["pat"],["cmt_"],["consumemode"]]]],[10,"borrow","","",334,[[["self"],["nodeid"],["span"],["cmt_"],["region"],["borrowkind"],["loancause"]]]],[10,"decl_without_init","","",334,[[["self"],["nodeid"],["span"]]]],[10,"mutate","","",334,[[["self"],["nodeid"],["span"],["cmt_"],["mutatemode"]]]],[11,"clone","","",327,[[["self"]],["loancause"]]],[11,"eq","","",327,[[["self"],["loancause"]],["bool"]]],[11,"ne","","",327,[[["self"],["loancause"]],["bool"]]],[11,"fmt","","",327,[[["self"],["formatter"]],["result"]]],[11,"clone","","",328,[[["self"]],["consumemode"]]],[11,"eq","","",328,[[["self"],["consumemode"]],["bool"]]],[11,"ne","","",328,[[["self"],["consumemode"]],["bool"]]],[11,"fmt","","",328,[[["self"],["formatter"]],["result"]]],[11,"clone","","",329,[[["self"]],["movereason"]]],[11,"eq","","",329,[[["self"],["movereason"]],["bool"]]],[11,"fmt","","",329,[[["self"],["formatter"]],["result"]]],[11,"clone","","",330,[[["self"]],["matchmode"]]],[11,"eq","","",330,[[["self"],["matchmode"]],["bool"]]],[11,"fmt","","",330,[[["self"],["formatter"]],["result"]]],[11,"clone","","",331,[[["self"]],["trackmatchmode"]]],[11,"eq","","",331,[[["self"],["trackmatchmode"]],["bool"]]],[11,"ne","","",331,[[["self"],["trackmatchmode"]],["bool"]]],[11,"fmt","","",331,[[["self"],["formatter"]],["result"]]],[11,"lub","","",331,[[["self"],["matchmode"]]]],[11,"match_mode","","",331,[[["self"]],["matchmode"]]],[11,"clone","","",332,[[["self"]],["mutatemode"]]],[11,"eq","","",332,[[["self"],["mutatemode"]],["bool"]]],[11,"fmt","","",332,[[["self"],["formatter"]],["result"]]],[11,"clone","","",333,[[["self"]],["overloadedcalltype"]]],[11,"from_trait_id","","",333,[[["tyctxt"],["defid"]],["overloadedcalltype"]]],[11,"from_method_id","","",333,[[["tyctxt"],["defid"]],["overloadedcalltype"]]],[11,"new","","Creates the ExprUseVisitor, configuring it with the various options provided:",326,[[["delegate"],["tyctxt"],["paramenv"],["scopetree"],["typecktables"],["option",["lrc"]]],["self"]]],[11,"with_infer","","",326,[[["delegate"],["inferctxt"],["paramenv"],["scopetree"],["typecktables"]],["self"]]],[11,"consume_body","","",326,[[["self"],["body"]]]],[11,"tcx","","",326,[[["self"]],["tyctxt"]]],[11,"delegate_consume","","",326,[[["self"],["nodeid"],["span"],["cmt_"]]]],[11,"consume_exprs","","",326,N],[11,"consume_expr","","",326,[[["self"],["expr"]]]],[11,"mutate_expr","","",326,[[["self"],["expr"],["expr"],["mutatemode"]]]],[11,"borrow_expr","","",326,[[["self"],["expr"],["region"],["borrowkind"],["loancause"]]]],[11,"select_from_expr","","",326,[[["self"],["expr"]]]],[11,"walk_expr","","",326,[[["self"],["expr"]]]],[11,"walk_callee","","",326,[[["self"],["expr"],["expr"]]]],[11,"walk_stmt","","",326,[[["self"],["stmt"]]]],[11,"walk_local","","",326,[[["self"],["local"]]]],[11,"walk_block","","Indicates that the value of `blk` will be consumed, meaning either copied or moved depending on its type.",326,[[["self"],["block"]]]],[11,"walk_struct_expr","","",326,N],[11,"walk_adjustment","","",326,[[["self"],["expr"]]]],[11,"walk_autoref","","Walks the autoref `autoref` applied to the autoderef'd `expr`. `cmt_base` is the mem-categorized form of `expr` after all relevant autoderefs have occurred.",326,[[["self"],["expr"],["cmt_"],["autoborrow"]]]],[11,"arm_move_mode","","",326,[[["self"],["cmt"],["arm"]],["trackmatchmode"]]],[11,"walk_arm","","",326,[[["self"],["cmt"],["arm"],["matchmode"]]]],[11,"walk_irrefutable_pat","","Walks a pat that occurs in isolation (i.e. top-level of fn arg or let binding.  Not a match arm or nested pat.)",326,[[["self"],["cmt"],["pat"]]]],[11,"determine_pat_move_mode","","Identifies any bindings within `pat` and accumulates within `mode` whether the overall pattern/match structure is a move, copy, or borrow.",326,[[["self"],["cmt"],["pat"],["trackmatchmode"]]]],[11,"walk_pat","","The core driver for walking a pattern; `match_mode` must be established up front, e.g. via `determine_pat_move_mode` (see also `walk_irrefutable_pat` for patterns that stand alone).",326,[[["self"],["cmt"],["pat"],["matchmode"]]]],[11,"walk_captures","","",326,[[["self"],["expr"],["span"]]]],[11,"cat_captured_var","","",326,[[["self"],["hirid"],["span"],["freevar"]],["mcresult",["cmt_"]]]],[0,"cstore","rustc::middle","the rustc crate store interface. This also includes types that are mostly used as a part of that interface, but these should probably get a better home if someone can find one.",N,N],[3,"CrateSource","rustc::middle::cstore","Where a crate came from on the local filesystem. One of these three options must be non-None.",N,N],[12,"dylib","","",335,N],[12,"rlib","","",335,N],[12,"rmeta","","",335,N],[3,"NativeLibrary","","",N,N],[12,"kind","","",336,N],[12,"name","","",336,N],[12,"cfg","","",336,N],[12,"foreign_module","","",336,N],[12,"wasm_import_module","","",336,N],[3,"ForeignModule","","",N,N],[12,"foreign_items","","",337,N],[12,"def_id","","",337,N],[3,"ExternCrate","","",N,N],[12,"src","","",338,N],[12,"span","","span of the extern crate that caused this to be loaded",338,N],[12,"path_len","","Number of links to reach the extern; used to select the extern with the shortest path",338,N],[12,"direct","","If true, then this crate is the crate named by the extern crate referenced above. If false, then this crate is a dep of the crate.",338,N],[3,"EncodedMetadata","","",N,N],[12,"raw_data","","",339,N],[4,"DepKind","","",N,N],[13,"UnexportedMacrosOnly","","A dependency that is only used for its macros, none of which are visible from other crates. These are included in the metadata only as placeholders and are ignored when decoding.",340,N],[13,"MacrosOnly","","A dependency that is only used for its macros.",340,N],[13,"Implicit","","A dependency that is always injected into the dependency list and so doesn't need to be linked to an rlib, e.g. the injected allocator.",340,N],[13,"Explicit","","A dependency that is required by an rlib version of this crate. Ordinary `extern crate`s result in `Explicit` dependencies.",340,N],[4,"LibSource","","",N,N],[13,"Some","","",341,N],[13,"MetadataOnly","","",341,N],[13,"None","","",341,N],[4,"LinkagePreference","","",N,N],[13,"RequireDynamic","","",342,N],[13,"RequireStatic","","",342,N],[4,"NativeLibraryKind","","",N,N],[13,"NativeStatic","","native static library (.a archive)",343,N],[13,"NativeStaticNobundle","","native static library, which doesn't get bundled into .rlibs",343,N],[13,"NativeFramework","","macOS-specific",343,N],[13,"NativeUnknown","","default way to specify a dynamic library",343,N],[4,"ExternCrateSource","","",N,N],[13,"Extern","","Crate is loaded by `extern crate`.",344,N],[13,"Use","","",344,N],[13,"Path","","Crate is implicitly loaded by an absolute or an `extern::` path.",344,N],[5,"used_crates","","",N,[[["tyctxt"],["linkagepreference"]],["vec"]]],[6,"CrateStoreDyn","","",N,N],[8,"MetadataLoader","","The backend's way to give the crate store access to the metadata in a library. Note that it returns the raw metadata bytes stored in the library file, whether it is compressed, uncompressed, some weird mix, etc. rmeta files are backend independent and not handled here.",N,N],[10,"get_rlib_metadata","","",345,[[["self"],["target"],["path"]],["result",["metadataref","string"]]]],[10,"get_dylib_metadata","","",345,[[["self"],["target"],["path"]],["result",["metadataref","string"]]]],[8,"CrateStore","","A store of Rust crates, through with their metadata can be accessed.",N,N],[10,"crate_data_as_rc_any","","",346,[[["self"],["cratenum"]],["lrc",["any"]]]],[10,"def_key","","",346,[[["self"],["defid"]],["defkey"]]],[10,"def_path","","",346,[[["self"],["defid"]],["defpath"]]],[10,"def_path_hash","","",346,[[["self"],["defid"]],["defpathhash"]]],[10,"def_path_table","","",346,[[["self"],["cratenum"]],["lrc",["defpathtable"]]]],[10,"crate_name_untracked","","",346,[[["self"],["cratenum"]],["symbol"]]],[10,"crate_disambiguator_untracked","","",346,[[["self"],["cratenum"]],["cratedisambiguator"]]],[10,"crate_hash_untracked","","",346,[[["self"],["cratenum"]],["svh"]]],[10,"extern_mod_stmt_cnum_untracked","","",346,[[["self"],["nodeid"]],["option",["cratenum"]]]],[10,"item_generics_cloned_untracked","","",346,[[["self"],["defid"],["session"]],["generics"]]],[10,"postorder_cnums_untracked","","",346,[[["self"]],["vec",["cratenum"]]]],[10,"crates_untracked","","",346,[[["self"]],["vec",["cratenum"]]]],[10,"encode_metadata","","",346,[[["self"],["tyctxt"]],["encodedmetadata"]]],[10,"metadata_encoding_version","","",346,N],[11,"eq","","",335,[[["self"],["cratesource"]],["bool"]]],[11,"ne","","",335,[[["self"],["cratesource"]],["bool"]]],[11,"clone","","",335,[[["self"]],["cratesource"]]],[11,"fmt","","",335,[[["self"],["formatter"]],["result"]]],[11,"encode","","",340,[[["self"],["__s"]],["result"]]],[11,"decode","","",340,[[["__d"]],["result",["depkind"]]]],[11,"clone","","",340,[[["self"]],["depkind"]]],[11,"cmp","","",340,[[["self"],["depkind"]],["ordering"]]],[11,"partial_cmp","","",340,[[["self"],["depkind"]],["option",["ordering"]]]],[11,"assert_receiver_is_total_eq","","",340,N],[11,"eq","","",340,[[["self"],["depkind"]],["bool"]]],[11,"fmt","","",340,[[["self"],["formatter"]],["result"]]],[11,"macros_only","","",340,[[["self"]],["bool"]]],[11,"eq","","",341,[[["self"],["libsource"]],["bool"]]],[11,"ne","","",341,[[["self"],["libsource"]],["bool"]]],[11,"clone","","",341,[[["self"]],["libsource"]]],[11,"fmt","","",341,[[["self"],["formatter"]],["result"]]],[11,"is_some","","",341,[[["self"]],["bool"]]],[11,"option","","",341,[[["self"]],["option",["pathbuf"]]]],[11,"fmt","","",342,[[["self"],["formatter"]],["result"]]],[11,"eq","","",342,[[["self"],["linkagepreference"]],["bool"]]],[11,"clone","","",342,[[["self"]],["linkagepreference"]]],[11,"encode","","",342,[[["self"],["__s"]],["result"]]],[11,"decode","","",342,[[["__d"]],["result",["linkagepreference"]]]],[11,"clone","","",343,[[["self"]],["nativelibrarykind"]]],[11,"eq","","",343,[[["self"],["nativelibrarykind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",343,N],[11,"partial_cmp","","",343,[[["self"],["nativelibrarykind"]],["option",["ordering"]]]],[11,"cmp","","",343,[[["self"],["nativelibrarykind"]],["ordering"]]],[11,"hash","","",343,N],[11,"encode","","",343,[[["self"],["__s"]],["result"]]],[11,"decode","","",343,[[["__d"]],["result",["nativelibrarykind"]]]],[11,"clone","","",336,[[["self"]],["nativelibrary"]]],[11,"encode","","",336,[[["self"],["__s"]],["result"]]],[11,"decode","","",336,[[["__d"]],["result",["nativelibrary"]]]],[11,"clone","","",337,[[["self"]],["foreignmodule"]]],[11,"hash","","",337,N],[11,"encode","","",337,[[["self"],["__s"]],["result"]]],[11,"decode","","",337,[[["__d"]],["result",["foreignmodule"]]]],[11,"clone","","",338,[[["self"]],["externcrate"]]],[11,"fmt","","",338,[[["self"],["formatter"]],["result"]]],[11,"clone","","",344,[[["self"]],["externcratesource"]]],[11,"fmt","","",344,[[["self"],["formatter"]],["result"]]],[11,"new","","",339,[[],["encodedmetadata"]]],[0,"dead","rustc::middle","",N,N],[3,"MarkSymbolVisitor","rustc::middle::dead","",N,N],[12,"worklist","","",347,N],[12,"tcx","","",347,N],[12,"tables","","",347,N],[12,"live_symbols","","",347,N],[12,"repr_has_repr_c","","",347,N],[12,"in_pat","","",347,N],[12,"inherited_pub_visibility","","",347,N],[12,"ignore_variant_stack","","",347,N],[3,"LifeSeeder","","",N,N],[12,"worklist","","",348,N],[12,"krate","","",348,N],[12,"tcx","","",348,N],[3,"DeadVisitor","","",N,N],[12,"tcx","","",349,N],[12,"live_symbols","","",349,N],[5,"should_explore","","",N,[[["tyctxt"],["nodeid"]],["bool"]]],[5,"has_allow_dead_code_or_lang_attr","","",N,N],[5,"create_and_seed_worklist","","",N,[[["tyctxt"],["accesslevels"],["crate"]],["vec",["nodeid"]]]],[5,"find_live","","",N,[[["tyctxt"],["accesslevels"],["crate"]],["box",["fxhashset"]]]],[5,"get_struct_ctor_id","","",N,[[["item"]],["option",["nodeid"]]]],[5,"check_crate","","",N,[[["tyctxt"]]]],[11,"check_def_id","","",347,[[["self"],["defid"]]]],[11,"insert_def_id","","",347,[[["self"],["defid"]]]],[11,"handle_definition","","",347,[[["self"],["def"]]]],[11,"lookup_and_handle_method","","",347,[[["self"],["hirid"]]]],[11,"handle_field_access","","",347,[[["self"],["expr"],["nodeid"]]]],[11,"handle_field_pattern_match","","",347,N],[11,"mark_live_symbols","","",347,[[["self"]]]],[11,"visit_node","","",347,[[["self"],["node"]]]],[11,"mark_as_used_if_union","","",347,[[["self"],["adtdef"],["hirvec"]]]],[11,"nested_visit_map","","",347,[[["self"]],["nestedvisitormap"]]],[11,"visit_nested_body","","",347,[[["self"],["bodyid"]]]],[11,"visit_variant_data","","",347,[[["self"],["variantdata"],["name"],["generics"],["nodeid"],["span"]]]],[11,"visit_expr","","",347,[[["self"],["expr"]]]],[11,"visit_arm","","",347,[[["self"],["arm"]]]],[11,"visit_pat","","",347,[[["self"],["pat"]]]],[11,"visit_path","","",347,[[["self"],["path"],["hirid"]]]],[11,"visit_item","","",348,[[["self"],["item"]]]],[11,"visit_trait_item","","",348,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",348,[[["self"],["implitem"]]]],[11,"should_warn_about_item","","",349,[[["self"],["item"]],["bool"]]],[11,"should_warn_about_field","","",349,[[["self"],["structfield"]],["bool"]]],[11,"should_warn_about_variant","","",349,[[["self"],["variantkind"]],["bool"]]],[11,"should_warn_about_foreign_item","","",349,[[["self"],["foreignitem"]],["bool"]]],[11,"symbol_is_live","","",349,[[["self"],["nodeid"],["option",["nodeid"]]],["bool"]]],[11,"warn_dead_code","","",349,[[["self"],["nodeid"],["span"],["name"],["str"],["str"]]]],[11,"nested_visit_map","","Walk nested items in place so that we don't report dead-code on inner functions when the outer function is already getting an error. We could do this also by checking the parents, but this is how the code is setup and it seems harmless enough.",349,[[["self"]],["nestedvisitormap"]]],[11,"visit_item","","",349,[[["self"],["item"]]]],[11,"visit_variant","","",349,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_foreign_item","","",349,[[["self"],["foreignitem"]]]],[11,"visit_struct_field","","",349,[[["self"],["structfield"]]]],[11,"visit_impl_item","","",349,[[["self"],["implitem"]]]],[11,"visit_trait_item","","",349,[[["self"],["traititem"]]]],[0,"dependency_format","rustc::middle","Resolution of mixing rlibs and dylibs",N,N],[4,"Linkage","rustc::middle::dependency_format","",N,N],[13,"NotLinked","","",350,N],[13,"IncludedFromDylib","","",350,N],[13,"Static","","",350,N],[13,"Dynamic","","",350,N],[5,"calculate","","",N,[[["tyctxt"]]]],[5,"calculate_type","","",N,[[["tyctxt"],["cratetype"]],["dependencylist"]]],[5,"add_library","","",N,[[["tyctxt"],["cratenum"],["linkagepreference"],["fxhashmap"]]]],[5,"attempt_static","","",N,[[["tyctxt"]],["option",["dependencylist"]]]],[5,"activate_injected_dep","","",N,[[["option",["cratenum"]],["dependencylist"],["fn"]]]],[5,"activate_injected_allocator","","",N,[[["session"],["dependencylist"]]]],[5,"verify_ok","","",N,N],[6,"DependencyList","","A list of dependencies for a certain crate type.",N,N],[6,"Dependencies","","A mapping of all required dependencies for a particular flavor of output.",N,N],[11,"clone","","",350,[[["self"]],["linkage"]]],[11,"eq","","",350,[[["self"],["linkage"]],["bool"]]],[11,"fmt","","",350,[[["self"],["formatter"]],["result"]]],[0,"entry","rustc::middle","",N,N],[3,"EntryContext","rustc::middle::entry","",N,N],[12,"session","","",351,N],[12,"map","","",351,N],[12,"main_fn","","",351,N],[12,"attr_main_fn","","",351,N],[12,"start_fn","","",351,N],[12,"non_main_fns","","",351,N],[5,"find_entry_point","","",N,[[["session"],["map"],["str"]]]],[5,"entry_point_type","","",N,[[["item"],["bool"]],["entrypointtype"]]],[5,"find_item","","",N,[[["item"],["entrycontext"],["bool"]]]],[5,"configure_main","","",N,[[["entrycontext"],["str"]]]],[11,"visit_item","","",351,[[["self"],["item"]]]],[11,"visit_trait_item","","",351,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",351,[[["self"],["implitem"]]]],[0,"exported_symbols","rustc::middle","",N,N],[4,"SymbolExportLevel","rustc::middle::exported_symbols","The SymbolExportLevel of a symbols specifies from which kinds of crates the symbol will be exported. `C` symbols will be exported from any kind of crate, including cdylibs which export very few things. `Rust` will only be exported if the crate produced is a Rust dylib.",N,N],[13,"C","","",352,N],[13,"Rust","","",352,N],[4,"ExportedSymbol","","",N,N],[13,"NonGeneric","","",353,N],[13,"Generic","","",353,N],[13,"NoDefId","","",353,N],[5,"metadata_symbol_name","","",N,[[["tyctxt"]],["string"]]],[11,"assert_receiver_is_total_eq","","",352,N],[11,"eq","","",352,[[["self"],["symbolexportlevel"]],["bool"]]],[11,"fmt","","",352,[[["self"],["formatter"]],["result"]]],[11,"clone","","",352,[[["self"]],["symbolexportlevel"]]],[11,"encode","","",352,[[["self"],["__s"]],["result"]]],[11,"decode","","",352,[[["__d"]],["result",["symbolexportlevel"]]]],[11,"hash_stable","","",352,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"is_below_threshold","","",352,[[["self"],["symbolexportlevel"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",353,N],[11,"eq","","",353,[[["self"],["exportedsymbol"]],["bool"]]],[11,"ne","","",353,[[["self"],["exportedsymbol"]],["bool"]]],[11,"fmt","","",353,[[["self"],["formatter"]],["result"]]],[11,"clone","","",353,[[["self"]],["exportedsymbol"]]],[11,"encode","","",353,[[["self"],["__s"]],["result"]]],[11,"decode","","",353,[[["__d"]],["result",["exportedsymbol"]]]],[11,"symbol_name","","",353,[[["self"],["tyctxt"]],["symbolname"]]],[11,"compare_stable","","",353,[[["self"],["tyctxt"],["exportedsymbol"]],["ordering"]]],[11,"hash_stable","","",353,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[0,"free_region","rustc::middle","This file handles the relationships between free regions -- meaning lifetime parameters. Ordinarily, free regions are unrelated to one another, but they can be related via implied or explicit bounds.  In that case, we track the bounds using the `TransitiveRelation` type and use that to decide when one free region outlives another and so forth.",N,N],[3,"RegionRelations","rustc::middle::free_region","Combines a `region::ScopeTree` (which governs relationships between scopes) and a `FreeRegionMap` (which governs relationships between free regions) to yield a complete relation between concrete regions.",N,N],[12,"tcx","","",354,N],[12,"context","","context used to fetch the region maps",354,N],[12,"region_scope_tree","","region maps for the given context",354,N],[12,"free_regions","","free-region relationships",354,N],[11,"new","","",354,[[["tyctxt"],["defid"],["scopetree"],["freeregionmap"]],["self"]]],[11,"is_subregion_of","","Determines whether one region is a subregion of another.  This is intended to run after inference and sadly the logic is somewhat duplicated with the code in infer.rs.",354,[[["self"],["region"],["region"]],["bool"]]],[11,"is_static","","Determines whether this free-region is required to be 'static",354,[[["self"],["region"]],["bool"]]],[11,"lub_free_regions","","",354,[[["self"],["region"],["region"]],["region"]]],[0,"intrinsicck","rustc::middle","",N,N],[3,"ItemVisitor","rustc::middle::intrinsicck","",N,N],[12,"tcx","","",355,N],[3,"ExprVisitor","","",N,N],[12,"tcx","","",356,N],[12,"tables","","",356,N],[12,"param_env","","",356,N],[5,"check_crate","","",N,[[["tyctxt"]]]],[5,"unpack_option_like","","If the type is `Option<T>`, it will return `T`, otherwise the type itself. Works on most `Option`-like types.",N,[[["tyctxt"],["ty"]],["ty"]]],[11,"def_id_is_transmute","","",356,[[["self"],["defid"]],["bool"]]],[11,"check_transmute","","",356,[[["self"],["span"],["ty"],["ty"]]]],[11,"nested_visit_map","","",355,[[["self"]],["nestedvisitormap"]]],[11,"visit_nested_body","","",355,[[["self"],["bodyid"]]]],[11,"nested_visit_map","","",356,[[["self"]],["nestedvisitormap"]]],[11,"visit_expr","","",356,[[["self"],["expr"]]]],[0,"lib_features","rustc::middle","",N,N],[3,"LibFeatures","rustc::middle::lib_features","",N,N],[12,"stable","","",357,N],[12,"unstable","","",357,N],[3,"LibFeatureCollector","","",N,N],[12,"tcx","","",358,N],[12,"lib_features","","",358,N],[5,"collect","","",N,[[["tyctxt"]],["libfeatures"]]],[11,"new","","",357,[[],["libfeatures"]]],[11,"to_vec","","",357,[[["self"]],["vec"]]],[11,"new","","",358,[[["tyctxt"]],["libfeaturecollector"]]],[11,"extract","","",358,[[["self"],["attribute"]],["option"]]],[11,"collect_feature","","",358,[[["self"],["symbol"],["option",["symbol"]],["span"]]]],[11,"nested_visit_map","","",358,[[["self"]],["nestedvisitormap"]]],[11,"visit_attribute","","",358,[[["self"],["attribute"]]]],[0,"lang_items","rustc::middle","",N,N],[3,"LanguageItems","rustc::middle::lang_items","",N,N],[12,"items","","",359,N],[12,"missing","","",359,N],[3,"LanguageItemCollector","","",N,N],[12,"items","","",360,N],[12,"tcx","","",360,N],[12,"item_refs","","",360,N],[4,"LangItem","","",N,N],[13,"CharImplItem","","",361,N],[13,"StrImplItem","","",361,N],[13,"SliceImplItem","","",361,N],[13,"SliceU8ImplItem","","",361,N],[13,"StrAllocImplItem","","",361,N],[13,"SliceAllocImplItem","","",361,N],[13,"SliceU8AllocImplItem","","",361,N],[13,"ConstPtrImplItem","","",361,N],[13,"MutPtrImplItem","","",361,N],[13,"I8ImplItem","","",361,N],[13,"I16ImplItem","","",361,N],[13,"I32ImplItem","","",361,N],[13,"I64ImplItem","","",361,N],[13,"I128ImplItem","","",361,N],[13,"IsizeImplItem","","",361,N],[13,"U8ImplItem","","",361,N],[13,"U16ImplItem","","",361,N],[13,"U32ImplItem","","",361,N],[13,"U64ImplItem","","",361,N],[13,"U128ImplItem","","",361,N],[13,"UsizeImplItem","","",361,N],[13,"F32ImplItem","","",361,N],[13,"F64ImplItem","","",361,N],[13,"F32RuntimeImplItem","","",361,N],[13,"F64RuntimeImplItem","","",361,N],[13,"SizedTraitLangItem","","",361,N],[13,"UnsizeTraitLangItem","","",361,N],[13,"CopyTraitLangItem","","",361,N],[13,"CloneTraitLangItem","","",361,N],[13,"SyncTraitLangItem","","",361,N],[13,"FreezeTraitLangItem","","",361,N],[13,"DropTraitLangItem","","",361,N],[13,"CoerceUnsizedTraitLangItem","","",361,N],[13,"AddTraitLangItem","","",361,N],[13,"SubTraitLangItem","","",361,N],[13,"MulTraitLangItem","","",361,N],[13,"DivTraitLangItem","","",361,N],[13,"RemTraitLangItem","","",361,N],[13,"NegTraitLangItem","","",361,N],[13,"NotTraitLangItem","","",361,N],[13,"BitXorTraitLangItem","","",361,N],[13,"BitAndTraitLangItem","","",361,N],[13,"BitOrTraitLangItem","","",361,N],[13,"ShlTraitLangItem","","",361,N],[13,"ShrTraitLangItem","","",361,N],[13,"AddAssignTraitLangItem","","",361,N],[13,"SubAssignTraitLangItem","","",361,N],[13,"MulAssignTraitLangItem","","",361,N],[13,"DivAssignTraitLangItem","","",361,N],[13,"RemAssignTraitLangItem","","",361,N],[13,"BitXorAssignTraitLangItem","","",361,N],[13,"BitAndAssignTraitLangItem","","",361,N],[13,"BitOrAssignTraitLangItem","","",361,N],[13,"ShlAssignTraitLangItem","","",361,N],[13,"ShrAssignTraitLangItem","","",361,N],[13,"IndexTraitLangItem","","",361,N],[13,"IndexMutTraitLangItem","","",361,N],[13,"UnsafeCellTypeLangItem","","",361,N],[13,"DerefTraitLangItem","","",361,N],[13,"DerefMutTraitLangItem","","",361,N],[13,"FnTraitLangItem","","",361,N],[13,"FnMutTraitLangItem","","",361,N],[13,"FnOnceTraitLangItem","","",361,N],[13,"GeneratorStateLangItem","","",361,N],[13,"GeneratorTraitLangItem","","",361,N],[13,"EqTraitLangItem","","",361,N],[13,"PartialOrdTraitLangItem","","",361,N],[13,"OrdTraitLangItem","","",361,N],[13,"PanicFnLangItem","","",361,N],[13,"PanicBoundsCheckFnLangItem","","",361,N],[13,"PanicInfoLangItem","","",361,N],[13,"PanicImplLangItem","","",361,N],[13,"BeginPanicFnLangItem","","",361,N],[13,"ExchangeMallocFnLangItem","","",361,N],[13,"BoxFreeFnLangItem","","",361,N],[13,"DropInPlaceFnLangItem","","",361,N],[13,"OomLangItem","","",361,N],[13,"AllocLayoutLangItem","","",361,N],[13,"StartFnLangItem","","",361,N],[13,"EhPersonalityLangItem","","",361,N],[13,"EhUnwindResumeLangItem","","",361,N],[13,"MSVCTryFilterLangItem","","",361,N],[13,"OwnedBoxLangItem","","",361,N],[13,"PhantomDataItem","","",361,N],[13,"ManuallyDropItem","","",361,N],[13,"DebugTraitLangItem","","",361,N],[13,"I128AddFnLangItem","","",361,N],[13,"U128AddFnLangItem","","",361,N],[13,"I128SubFnLangItem","","",361,N],[13,"U128SubFnLangItem","","",361,N],[13,"I128MulFnLangItem","","",361,N],[13,"U128MulFnLangItem","","",361,N],[13,"I128DivFnLangItem","","",361,N],[13,"U128DivFnLangItem","","",361,N],[13,"I128RemFnLangItem","","",361,N],[13,"U128RemFnLangItem","","",361,N],[13,"I128ShlFnLangItem","","",361,N],[13,"U128ShlFnLangItem","","",361,N],[13,"I128ShrFnLangItem","","",361,N],[13,"U128ShrFnLangItem","","",361,N],[13,"I128AddoFnLangItem","","",361,N],[13,"U128AddoFnLangItem","","",361,N],[13,"I128SuboFnLangItem","","",361,N],[13,"U128SuboFnLangItem","","",361,N],[13,"I128MuloFnLangItem","","",361,N],[13,"U128MuloFnLangItem","","",361,N],[13,"I128ShloFnLangItem","","",361,N],[13,"U128ShloFnLangItem","","",361,N],[13,"I128ShroFnLangItem","","",361,N],[13,"U128ShroFnLangItem","","",361,N],[13,"AlignOffsetLangItem","","",361,N],[13,"TerminationTraitLangItem","","",361,N],[5,"extract","","",N,N],[5,"collect","","",N,[[["tyctxt"]],["languageitems"]]],[11,"fmt","","",361,[[["self"],["formatter"]],["result"]]],[11,"clone","","",361,[[["self"]],["langitem"]]],[11,"eq","","",361,[[["self"],["langitem"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",361,N],[11,"hash","","",361,N],[11,"encode","","",361,[[["self"],["__s"]],["result"]]],[11,"decode","","",361,[[["__d"]],["result",["langitem"]]]],[11,"from_u32","","",361,[[["u32"]],["option",["langitem"]]]],[11,"name","","",361,[[["self"]],["str"]]],[11,"new","","",359,[[],["languageitems"]]],[11,"items","","",359,N],[11,"require","","",359,[[["self"],["langitem"]],["result",["defid","string"]]]],[11,"fn_trait_kind","","",359,[[["self"],["defid"]],["option",["closurekind"]]]],[11,"char_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"str_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"slice_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"slice_u8_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"str_alloc_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"slice_alloc_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"slice_u8_alloc_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"const_ptr_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"mut_ptr_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"i8_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"i16_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"i32_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"i64_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"isize_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"u8_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"u16_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"u32_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"u64_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"usize_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"f32_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"f64_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"f32_runtime_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"f64_runtime_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"sized_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"unsize_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"copy_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"clone_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"sync_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"freeze_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"drop_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"coerce_unsized_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"add_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"sub_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"mul_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"div_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"rem_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"neg_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"not_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"bitxor_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"bitand_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"bitor_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"shl_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"shr_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"add_assign_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"sub_assign_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"mul_assign_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"div_assign_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"rem_assign_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"bitxor_assign_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"bitand_assign_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"bitor_assign_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"shl_assign_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"shr_assign_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"index_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"index_mut_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"unsafe_cell_type","","",359,[[["self"]],["option",["defid"]]]],[11,"deref_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"deref_mut_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"fn_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"fn_mut_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"fn_once_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"gen_state","","",359,[[["self"]],["option",["defid"]]]],[11,"gen_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"eq_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"partial_ord_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"ord_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"panic_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"panic_bounds_check_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"panic_info","","",359,[[["self"]],["option",["defid"]]]],[11,"panic_impl","","",359,[[["self"]],["option",["defid"]]]],[11,"begin_panic_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"exchange_malloc_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"box_free_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"drop_in_place_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"oom","","",359,[[["self"]],["option",["defid"]]]],[11,"alloc_layout","","",359,[[["self"]],["option",["defid"]]]],[11,"start_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"eh_personality","","",359,[[["self"]],["option",["defid"]]]],[11,"eh_unwind_resume","","",359,[[["self"]],["option",["defid"]]]],[11,"msvc_try_filter","","",359,[[["self"]],["option",["defid"]]]],[11,"owned_box","","",359,[[["self"]],["option",["defid"]]]],[11,"phantom_data","","",359,[[["self"]],["option",["defid"]]]],[11,"manually_drop","","",359,[[["self"]],["option",["defid"]]]],[11,"debug_trait","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_add_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_add_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_sub_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_sub_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_mul_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_mul_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_div_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_div_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_rem_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_rem_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_shl_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_shl_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_shr_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_shr_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_addo_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_addo_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_subo_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_subo_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_mulo_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_mulo_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_shlo_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_shlo_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"i128_shro_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"u128_shro_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"align_offset_fn","","",359,[[["self"]],["option",["defid"]]]],[11,"termination","","",359,[[["self"]],["option",["defid"]]]],[11,"visit_item","","",360,[[["self"],["item"]]]],[11,"visit_trait_item","","",360,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",360,[[["self"],["implitem"]]]],[11,"new","","",360,[[["tyctxt"]],["languageitemcollector"]]],[11,"collect_item","","",360,[[["self"],["usize"],["defid"]]]],[0,"liveness","rustc::middle","A classic liveness analysis based on dataflow over the AST.  Computes, for each local variable in a function, whether that variable is live at a given point.  Program execution points are identified by their id.",N,N],[3,"Variable","rustc::middle::liveness","",N,N],[12,"0","","",362,N],[3,"LiveNode","","",N,N],[12,"0","","",363,N],[3,"CaptureInfo","","",N,N],[12,"ln","","",364,N],[12,"var_hid","","",364,N],[3,"LocalInfo","","",N,N],[12,"id","","",365,N],[12,"name","","",365,N],[12,"is_shorthand","","",365,N],[3,"IrMaps","","",N,N],[12,"tcx","","",366,N],[12,"num_live_nodes","","",366,N],[12,"num_vars","","",366,N],[12,"live_node_map","","",366,N],[12,"variable_map","","",366,N],[12,"capture_info_map","","",366,N],[12,"var_kinds","","",366,N],[12,"lnks","","",366,N],[3,"Users","","",N,N],[12,"reader","","",367,N],[12,"writer","","",367,N],[12,"used","","",367,N],[3,"Specials","","",N,N],[12,"exit_ln","","",368,N],[12,"fallthrough_ln","","",368,N],[12,"clean_exit_var","","",368,N],[3,"Liveness","","",N,N],[12,"ir","","",369,N],[12,"tables","","",369,N],[12,"s","","",369,N],[12,"successors","","",369,N],[12,"users","","",369,N],[12,"break_ln","","",369,N],[12,"cont_ln","","",369,N],[4,"LoopKind","","For use with `propagate_through_loop`.",N,N],[13,"LoopLoop","","An endless `loop` loop.",370,N],[13,"WhileLoop","","A `while` loop, with the given expression as condition.",370,N],[4,"LiveNodeKind","","",N,N],[13,"FreeVarNode","","",371,N],[13,"ExprNode","","",371,N],[13,"VarDefNode","","",371,N],[13,"ExitNode","","",371,N],[4,"VarKind","","",N,N],[13,"Arg","","",372,N],[13,"Local","","",372,N],[13,"CleanExit","","",372,N],[5,"live_node_kind_to_string","","",N,[[["livenodekind"],["tyctxt"]],["string"]]],[5,"check_crate","","",N,[[["tyctxt"]]]],[5,"invalid_node","","",N,[[],["livenode"]]],[5,"visit_fn","","",N,[[["irmaps"],["fnkind"],["fndecl"],["bodyid"],["span"],["nodeid"]]]],[5,"add_from_pat","","",N,[[["irmaps"],["p"]]]],[5,"visit_local","","",N,[[["irmaps"],["local"]]]],[5,"visit_arm","","",N,[[["irmaps"],["arm"]]]],[5,"visit_expr","","",N,[[["irmaps"],["expr"]]]],[5,"invalid_users","","",N,[[],["users"]]],[5,"check_local","","",N,[[["liveness"],["local"]]]],[5,"check_arm","","",N,[[["liveness"],["arm"]]]],[5,"check_expr","","",N,[[["liveness"],["expr"]]]],[17,"ACC_READ","","",N,N],[17,"ACC_WRITE","","",N,N],[17,"ACC_USE","","",N,N],[11,"clone","","",362,[[["self"]],["variable"]]],[11,"eq","","",362,[[["self"],["variable"]],["bool"]]],[11,"ne","","",362,[[["self"],["variable"]],["bool"]]],[11,"clone","","",363,[[["self"]],["livenode"]]],[11,"eq","","",363,[[["self"],["livenode"]],["bool"]]],[11,"ne","","",363,[[["self"],["livenode"]],["bool"]]],[11,"get","","",362,[[["self"]],["usize"]]],[11,"get","","",363,[[["self"]],["usize"]]],[11,"clone","","",371,[[["self"]],["livenodekind"]]],[11,"eq","","",371,[[["self"],["livenodekind"]],["bool"]]],[11,"ne","","",371,[[["self"],["livenodekind"]],["bool"]]],[11,"fmt","","",371,[[["self"],["formatter"]],["result"]]],[11,"nested_visit_map","","",366,[[["self"]],["nestedvisitormap"]]],[11,"visit_fn","","",366,[[["self"],["fnkind"],["fndecl"],["bodyid"],["span"],["nodeid"]]]],[11,"visit_local","","",366,[[["self"],["local"]]]],[11,"visit_expr","","",366,[[["self"],["expr"]]]],[11,"visit_arm","","",366,[[["self"],["arm"]]]],[11,"fmt","","",363,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",362,[[["self"],["formatter"]],["result"]]],[11,"is_valid","","",363,[[["self"]],["bool"]]],[11,"clone","","",365,[[["self"]],["localinfo"]]],[11,"fmt","","",365,[[["self"],["formatter"]],["result"]]],[11,"clone","","",372,[[["self"]],["varkind"]]],[11,"fmt","","",372,[[["self"],["formatter"]],["result"]]],[11,"new","","",366,[[["tyctxt"]],["irmaps"]]],[11,"add_live_node","","",366,[[["self"],["livenodekind"]],["livenode"]]],[11,"add_live_node_for_node","","",366,[[["self"],["hirid"],["livenodekind"]]]],[11,"add_variable","","",366,[[["self"],["varkind"]],["variable"]]],[11,"variable","","",366,[[["self"],["hirid"],["span"]],["variable"]]],[11,"variable_name","","",366,[[["self"],["variable"]],["string"]]],[11,"variable_is_shorthand","","",366,[[["self"],["variable"]],["bool"]]],[11,"set_captures","","",366,[[["self"],["nodeid"],["vec",["captureinfo"]]]]],[11,"lnk","","",366,[[["self"],["livenode"]],["livenodekind"]]],[11,"clone","","",367,[[["self"]],["users"]]],[11,"clone","","",368,[[["self"]],["specials"]]],[11,"new","","",369,[[["irmaps"],["bodyid"]],["liveness"]]],[11,"live_node","","",369,[[["self"],["hirid"],["span"]],["livenode"]]],[11,"variable","","",369,[[["self"],["hirid"],["span"]],["variable"]]],[11,"pat_bindings","","",369,[[["self"],["pat"],["f"]]]],[11,"arm_pats_bindings","","",369,[[["self"],["option",["pat"]],["f"]]]],[11,"define_bindings_in_pat","","",369,[[["self"],["pat"],["livenode"]],["livenode"]]],[11,"define_bindings_in_arm_pats","","",369,[[["self"],["option",["pat"]],["livenode"]],["livenode"]]],[11,"idx","","",369,[[["self"],["livenode"],["variable"]],["usize"]]],[11,"live_on_entry","","",369,[[["self"],["livenode"],["variable"]],["option",["livenodekind"]]]],[11,"live_on_exit","","",369,[[["self"],["livenode"],["variable"]],["option",["livenodekind"]]]],[11,"used_on_entry","","",369,[[["self"],["livenode"],["variable"]],["bool"]]],[11,"assigned_on_entry","","",369,[[["self"],["livenode"],["variable"]],["option",["livenodekind"]]]],[11,"assigned_on_exit","","",369,[[["self"],["livenode"],["variable"]],["option",["livenodekind"]]]],[11,"indices2","","",369,[[["self"],["livenode"],["livenode"],["f"]]]],[11,"write_vars","","",369,[[["self"],["write"],["livenode"],["f"]],["result"]]],[11,"ln_str","","",369,[[["self"],["livenode"]],["string"]]],[11,"init_empty","","",369,[[["self"],["livenode"],["livenode"]]]],[11,"init_from_succ","","",369,[[["self"],["livenode"],["livenode"]]]],[11,"merge_from_succ","","",369,[[["self"],["livenode"],["livenode"],["bool"]],["bool"]]],[11,"define","","",369,[[["self"],["livenode"],["variable"]]]],[11,"acc","","",369,[[["self"],["livenode"],["variable"],["u32"]]]],[11,"compute","","",369,[[["self"],["expr"]],["livenode"]]],[11,"propagate_through_block","","",369,[[["self"],["block"],["livenode"]],["livenode"]]],[11,"propagate_through_stmt","","",369,[[["self"],["stmt"],["livenode"]],["livenode"]]],[11,"propagate_through_decl","","",369,[[["self"],["decl"],["livenode"]],["livenode"]]],[11,"propagate_through_local","","",369,[[["self"],["local"],["livenode"]],["livenode"]]],[11,"propagate_through_exprs","","",369,N],[11,"propagate_through_opt_expr","","",369,[[["self"],["option",["expr"]],["livenode"]],["livenode"]]],[11,"propagate_through_expr","","",369,[[["self"],["expr"],["livenode"]],["livenode"]]],[11,"propagate_through_place_components","","",369,[[["self"],["expr"],["livenode"]],["livenode"]]],[11,"write_place","","",369,[[["self"],["expr"],["livenode"],["u32"]],["livenode"]]],[11,"access_var","","",369,[[["self"],["hirid"],["nodeid"],["livenode"],["u32"],["span"]],["livenode"]]],[11,"access_path","","",369,[[["self"],["hirid"],["path"],["livenode"],["u32"]],["livenode"]]],[11,"propagate_through_loop","","",369,[[["self"],["expr"],["loopkind"],["block"],["livenode"]],["livenode"]]],[11,"nested_visit_map","","",369,[[["self"]],["nestedvisitormap"]]],[11,"visit_local","","",369,[[["self"],["local"]]]],[11,"visit_expr","","",369,[[["self"],["expr"]]]],[11,"visit_arm","","",369,[[["self"],["arm"]]]],[11,"check_place","","",369,[[["self"],["expr"]]]],[11,"should_warn","","",369,[[["self"],["variable"]],["option",["string"]]]],[11,"warn_about_unused_args","","",369,[[["self"],["body"],["livenode"]]]],[11,"warn_about_unused_or_dead_vars_in_pat","","",369,[[["self"],["pat"]]]],[11,"warn_about_unused","","",369,[[["self"],["span"],["hirid"],["livenode"],["variable"]],["bool"]]],[11,"warn_about_dead_assign","","",369,[[["self"],["span"],["hirid"],["livenode"],["variable"]]]],[11,"report_dead_assign","","",369,[[["self"],["hirid"],["span"],["variable"],["bool"]]]],[0,"mem_categorization","rustc::middle","Categorization",N,N],[3,"Upvar","rustc::middle::mem_categorization","",N,N],[12,"id","","",373,N],[12,"kind","","",373,N],[3,"FieldIndex","","",N,N],[12,"0","","",374,N],[12,"1","","",374,N],[3,"cmt_","","",N,N],[12,"hir_id","","",375,N],[12,"span","","",375,N],[12,"cat","","",375,N],[12,"mutbl","","",375,N],[12,"ty","","",375,N],[12,"note","","",375,N],[3,"MemCategorizationContext","","",N,N],[12,"tcx","","",376,N],[12,"region_scope_tree","","",376,N],[12,"tables","","",376,N],[12,"rvalue_promotable_map","","",376,N],[12,"infcx","","",376,N],[4,"Categorization","","",N,N],[13,"Rvalue","","",377,N],[13,"StaticItem","","",377,N],[13,"Upvar","","",377,N],[13,"Local","","",377,N],[13,"Deref","","",377,N],[13,"Interior","","",377,N],[13,"Downcast","","",377,N],[4,"PointerKind","","",N,N],[13,"Unique","","`Box<T>`",378,N],[13,"BorrowedPtr","","`&T`",378,N],[13,"UnsafePtr","","`*T`",378,N],[4,"InteriorKind","","",N,N],[13,"InteriorField","","",379,N],[13,"InteriorElement","","",379,N],[4,"InteriorOffsetKind","","",N,N],[13,"Index","","",380,N],[13,"Pattern","","",380,N],[4,"MutabilityCategory","","",N,N],[13,"McImmutable","","",381,N],[13,"McDeclared","","",381,N],[13,"McInherited","","",381,N],[4,"Note","","",N,N],[13,"NoteClosureEnv","","",382,N],[13,"NoteUpvarRef","","",382,N],[13,"NoteIndex","","",382,N],[13,"NoteNone","","",382,N],[4,"ImmutabilityBlame","","",N,N],[13,"ImmLocal","","",383,N],[13,"ClosureEnv","","",383,N],[13,"LocalDeref","","",383,N],[13,"AdtFieldDeref","","",383,N],[4,"Aliasability","","",N,N],[13,"FreelyAliasable","","",384,N],[13,"NonAliasable","","",384,N],[13,"ImmutableUnique","","",384,N],[4,"AliasableReason","","",N,N],[13,"AliasableBorrowed","","",385,N],[13,"AliasableStatic","","",385,N],[13,"AliasableStaticMut","","",385,N],[5,"ptr_sigil","","",N,[[["pointerkind"]],["str"]]],[6,"cmt","","",N,N],[6,"McResult","","",N,N],[8,"HirNode","","",N,N],[10,"hir_id","","",386,[[["self"]],["hirid"]]],[10,"span","","",386,[[["self"]],["span"]]],[11,"clone","","",377,[[["self"]],["categorization"]]],[11,"fmt","","",377,[[["self"],["formatter"]],["result"]]],[11,"eq","","",377,[[["self"],["categorization"]],["bool"]]],[11,"ne","","",377,[[["self"],["categorization"]],["bool"]]],[11,"clone","","",373,[[["self"]],["upvar"]]],[11,"eq","","",373,[[["self"],["upvar"]],["bool"]]],[11,"ne","","",373,[[["self"],["upvar"]],["bool"]]],[11,"clone","","",378,[[["self"]],["pointerkind"]]],[11,"fmt","","",378,[[["self"],["formatter"]],["result"]]],[11,"eq","","",378,[[["self"],["pointerkind"]],["bool"]]],[11,"ne","","",378,[[["self"],["pointerkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",378,N],[11,"hash","","",378,N],[11,"clone","","",379,[[["self"]],["interiorkind"]]],[11,"eq","","",379,[[["self"],["interiorkind"]],["bool"]]],[11,"ne","","",379,[[["self"],["interiorkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",379,N],[11,"hash","","",379,N],[11,"clone","","",374,[[["self"]],["fieldindex"]]],[11,"assert_receiver_is_total_eq","","",374,N],[11,"eq","","",374,[[["self"],["self"]],["bool"]]],[11,"hash","","",374,[[["self"],["h"]]]],[11,"clone","","",380,[[["self"]],["interioroffsetkind"]]],[11,"eq","","",380,[[["self"],["interioroffsetkind"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",380,N],[11,"hash","","",380,N],[11,"fmt","","",380,[[["self"],["formatter"]],["result"]]],[11,"clone","","",381,[[["self"]],["mutabilitycategory"]]],[11,"eq","","",381,[[["self"],["mutabilitycategory"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",381,N],[11,"hash","","",381,N],[11,"fmt","","",381,[[["self"],["formatter"]],["result"]]],[11,"clone","","",382,[[["self"]],["note"]]],[11,"eq","","",382,[[["self"],["note"]],["bool"]]],[11,"ne","","",382,[[["self"],["note"]],["bool"]]],[11,"fmt","","",382,[[["self"],["formatter"]],["result"]]],[11,"clone","","",375,[[["self"]],["cmt_"]]],[11,"fmt","","",375,[[["self"],["formatter"]],["result"]]],[11,"eq","","",375,[[["self"],["cmt_"]],["bool"]]],[11,"ne","","",375,[[["self"],["cmt_"]],["bool"]]],[11,"resolve_field","","",375,[[["self"],["usize"]],["option"]]],[11,"immutability_blame","","",375,[[["self"]],["option",["immutabilityblame"]]]],[11,"hir_id","rustc::hir","",58,[[["self"]],["hirid"]]],[11,"span","","",58,[[["self"]],["span"]]],[11,"hir_id","","",50,[[["self"]],["hirid"]]],[11,"span","","",50,[[["self"]],["span"]]],[11,"clone","rustc::middle::mem_categorization","",376,[[["self"]],["memcategorizationcontext"]]],[11,"from_mutbl","","",381,[[["mutability"]],["mutabilitycategory"]]],[11,"from_borrow_kind","","",381,[[["borrowkind"]],["mutabilitycategory"]]],[11,"from_pointer_kind","","",381,[[["mutabilitycategory"],["pointerkind"]],["mutabilitycategory"]]],[11,"from_local","","",381,[[["tyctxt"],["typecktables"],["nodeid"]],["mutabilitycategory"]]],[11,"inherit","","",381,[[["self"]],["mutabilitycategory"]]],[11,"is_mutable","","",381,[[["self"]],["bool"]]],[11,"is_immutable","","",381,[[["self"]],["bool"]]],[11,"to_user_str","","",381,[[["self"]],["str"]]],[11,"new","","",376,[[["tyctxt"],["scopetree"],["typecktables"],["option",["lrc"]]],["memcategorizationcontext"]]],[11,"with_infer","","Creates a `MemCategorizationContext` during type inference. This is used during upvar analysis and a few other places. Because the typeck tables are not yet complete, the results from the analysis must be used with caution:",376,[[["inferctxt"],["scopetree"],["typecktables"]],["memcategorizationcontext"]]],[11,"type_moves_by_default","","",376,[[["self"],["paramenv"],["ty"],["span"]],["bool"]]],[11,"resolve_type_vars_if_possible","","",376,[[["self"],["t"]],["t"]]],[11,"is_tainted_by_errors","","",376,[[["self"]],["bool"]]],[11,"resolve_type_vars_or_error","","",376,[[["self"],["hirid"],["option",["ty"]]],["mcresult",["ty"]]]],[11,"node_ty","","",376,[[["self"],["hirid"]],["mcresult",["ty"]]]],[11,"expr_ty","","",376,[[["self"],["expr"]],["mcresult",["ty"]]]],[11,"expr_ty_adjusted","","",376,[[["self"],["expr"]],["mcresult",["ty"]]]],[11,"pat_ty_adjusted","","Returns the type of value that this pattern matches against. Some non-obvious cases:",376,[[["self"],["pat"]],["mcresult",["ty"]]]],[11,"pat_ty_unadjusted","","Like `pat_ty`, but ignores implicit `&` patterns.",376,[[["self"],["pat"]],["mcresult",["ty"]]]],[11,"cat_expr","","",376,[[["self"],["expr"]],["mcresult",["cmt_"]]]],[11,"cat_expr_adjusted","","",376,[[["self"],["expr"],["cmt_"],["adjustment"]],["mcresult",["cmt_"]]]],[11,"cat_expr_adjusted_with","","",376,[[["self"],["expr"],["f"],["adjustment"]],["mcresult",["cmt_"]]]],[11,"cat_expr_unadjusted","","",376,[[["self"],["expr"]],["mcresult",["cmt_"]]]],[11,"cat_def","","",376,[[["self"],["hirid"],["span"],["ty"],["def"]],["mcresult",["cmt_"]]]],[11,"cat_upvar","","",376,[[["self"],["hirid"],["span"],["nodeid"],["nodeid"]],["mcresult",["cmt_"]]]],[11,"env_deref","","",376,[[["self"],["hirid"],["span"],["upvarid"],["mutabilitycategory"],["borrowkind"],["cmt_"]],["cmt_"]]],[11,"temporary_scope","","Returns the lifetime of a temporary created by expr with id `id`. This could be `'static` if `id` is part of a constant expression.",376,[[["self"],["itemlocalid"]],["region"]]],[11,"cat_rvalue_node","","",376,[[["self"],["hirid"],["span"],["ty"]],["cmt_"]]],[11,"cat_rvalue","","",376,[[["self"],["hirid"],["span"],["region"],["ty"]],["cmt_"]]],[11,"cat_field","","",376,[[["self"],["n"],["cmt"],["usize"],["ident"],["ty"]],["cmt_"]]],[11,"cat_overloaded_place","","",376,[[["self"],["expr"],["expr"],["note"]],["mcresult",["cmt_"]]]],[11,"cat_deref","","",376,N],[11,"cat_index","","Creates a cmt for an indexing operation (`[]`).",376,[[["self"],["n"],["cmt"],["ty"],["interioroffsetkind"]],["mcresult",["cmt_"]]]],[11,"cat_imm_interior","","",376,[[["self"],["n"],["cmt"],["ty"],["interiorkind"]],["cmt_"]]],[11,"cat_downcast_if_needed","","",376,[[["self"],["n"],["cmt"],["defid"]],["cmt"]]],[11,"cat_pattern","","",376,[[["self"],["cmt"],["pat"],["f"]],["mcresult"]]],[11,"cat_pattern_","","",376,[[["self"],["cmt"],["pat"],["f"]],["mcresult"]]],[11,"clone","","",384,[[["self"]],["aliasability"]]],[11,"fmt","","",384,[[["self"],["formatter"]],["result"]]],[11,"clone","","",385,[[["self"]],["aliasablereason"]]],[11,"fmt","","",385,[[["self"],["formatter"]],["result"]]],[11,"guarantor","","Returns `self` after stripping away any derefs or interior content. The return value is basically the `cmt` which determines how long the value in `self` remains live.",375,[[["self"]],["cmt_"]]],[11,"freely_aliasable","","Returns `FreelyAliasable(_)` if this place represents a freely aliasable pointer type.",375,[[["self"]],["aliasability"]]],[11,"upvar_cat","","",375,[[["self"]],["option",["categorization"]]]],[11,"descriptive_string","","",375,[[["self"],["tyctxt"]],["string"]]],[11,"fmt","","",379,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",373,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",373,[[["self"],["formatter"]],["result"]]],[0,"privacy","rustc::middle","A pass that checks to make sure private fields and methods aren't used outside their scopes. This pass will also generate a set of exported items which are available for use externally when compiled as a library.",N,N],[3,"AccessLevels","rustc::middle::privacy","",N,N],[12,"map","","",387,N],[4,"AccessLevel","","",N,N],[13,"ReachableFromImplTrait","","",388,N],[13,"Reachable","","",388,N],[13,"Exported","","",388,N],[13,"Public","","",388,N],[6,"ExternalExports","","A set containing all exported definitions from external crates. The set does not contain any entries from local crates.",N,N],[11,"clone","","",388,[[["self"]],["accesslevel"]]],[11,"fmt","","",388,[[["self"],["formatter"]],["result"]]],[11,"eq","","",388,[[["self"],["accesslevel"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",388,N],[11,"partial_cmp","","",388,[[["self"],["accesslevel"]],["option",["ordering"]]]],[11,"cmp","","",388,[[["self"],["accesslevel"]],["ordering"]]],[11,"clone","","",387,[[["self"]],["accesslevels"]]],[11,"is_reachable","","",387,[[["self"],["id"]],["bool"]]],[11,"is_exported","","",387,[[["self"],["id"]],["bool"]]],[11,"is_public","","",387,[[["self"],["id"]],["bool"]]],[11,"default","","",387,[[],["self"]]],[11,"fmt","","",387,[[["self"],["formatter"]],["result"]]],[0,"reachable","rustc::middle","",N,N],[3,"ReachableContext","rustc::middle::reachable","",N,N],[12,"tcx","","",389,N],[12,"tables","","",389,N],[12,"reachable_symbols","","",389,N],[12,"worklist","","",389,N],[12,"any_library","","",389,N],[3,"CollectPrivateImplItemsVisitor","","",N,N],[12,"tcx","","",390,N],[12,"access_levels","","",390,N],[12,"worklist","","",390,N],[3,"ReachableSet","","",N,N],[12,"0","","",391,N],[5,"item_might_be_inlined","","",N,[[["tyctxt"],["item"],["codegenfnattrs"]],["bool"]]],[5,"method_might_be_inlined","","",N,[[["tyctxt"],["implitem"],["defid"]],["bool"]]],[5,"reachable_set","","",N,[[["tyctxt"],["cratenum"]],["reachableset"]]],[5,"provide","","",N,[[["providers"]]]],[11,"nested_visit_map","","",389,[[["self"]],["nestedvisitormap"]]],[11,"visit_nested_body","","",389,[[["self"],["bodyid"]]]],[11,"visit_expr","","",389,[[["self"],["expr"]]]],[11,"def_id_represents_local_inlined_item","","",389,[[["self"],["defid"]],["bool"]]],[11,"propagate","","",389,[[["self"]]]],[11,"propagate_node","","",389,[[["self"],["node"],["nodeid"]]]],[11,"visit_item","","",390,[[["self"],["item"]]]],[11,"visit_trait_item","","",390,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",390,[[["self"],["implitem"]]]],[11,"clone","","",391,[[["self"]],["reachableset"]]],[0,"region","rustc::middle","This file builds up the `ScopeTree`, which describes the parent links in the region hierarchy.",N,N],[3,"Scope","rustc::middle::region","Scope represents a statically-describable scope that can be used to bound the lifetime/region for values.",N,N],[12,"id","","",392,N],[12,"data","","",392,N],[3,"FirstStatementIndex","","",N,N],[12,"private","","",393,N],[3,"ScopeTree","","The region scope tree encodes information about region relationships.",N,N],[12,"root_body","","If not empty, this body is the root of this region hierarchy.",394,N],[12,"root_parent","","The parent of the root body owner, if the latter is an an associated const or method, as impls/traits can also have lifetime parameters free in this body.",394,N],[12,"parent_map","","`parent_map` maps from a scope id to the enclosing scope id; this is usually corresponding to the lexical nesting, though in the case of closures the parent scope is the innermost conditional expression or repeating block. (Note that the enclosing scope id for the block associated with a closure is the closure itself.)",394,N],[12,"var_map","","`var_map` maps from a variable or binding id to the block in which that variable is declared.",394,N],[12,"destruction_scopes","","maps from a node-id to the associated destruction scope (if any)",394,N],[12,"rvalue_scopes","","`rvalue_scopes` includes entries for those expressions whose cleanup scope is larger than the default. The map goes from the expression id to the cleanup scope id. For rvalues not present in this table, the appropriate cleanup scope is the innermost enclosing statement, conditional expression, or repeating block (see `terminating_scopes`). In constants, None is used to indicate that certain expressions escape into 'static and should have no local cleanup scope.",394,N],[12,"closure_tree","","Encodes the hierarchy of fn bodies. Every fn body (including closures) forms its own distinct region hierarchy, rooted in the block that is the fn body. This map points from the id of that root block to the id of the root block for the enclosing fn, if any. Thus the map structures the fn bodies into a hierarchy based on their lexical mapping. This is used to handle the relationships between regions in a fn and in a closure defined by that fn. See the \"Modeling closures\" section of the README in infer::region_constraints for more details.",394,N],[12,"yield_in_scope","","If there are any `yield` nested within a scope, this map stores the `Span` of the last one and its index in the postorder of the Visitor traversal on the HIR.",394,N],[12,"body_expr_count","","The number of visit_expr and visit_pat calls done in the body. Used to sanity check visit_expr/visit_pat call count when calculating generator interiors.",394,N],[3,"Context","","",N,N],[12,"root_id","","the root of the current region tree. This is typically the id of the innermost fn body. Each fn forms its own disjoint tree in the region hierarchy. These fn bodies are themselves arranged into a tree. See the \"Modeling closures\" section of the README in infer::region_constraints for more details.",395,N],[12,"var_parent","","The scope that contains any new variables declared, plus its depth in the scope tree.",395,N],[12,"parent","","Region parent of expressions, etc., plus its depth in the scope tree.",395,N],[3,"RegionResolutionVisitor","","",N,N],[12,"tcx","","",396,N],[12,"expr_and_pat_count","","",396,N],[12,"scope_tree","","",396,N],[12,"cx","","",396,N],[12,"terminating_scopes","","`terminating_scopes` is a set containing the ids of each statement, or conditional/repeating expression. These scopes are calling \"terminating scopes\" because, when attempting to find the scope of a temporary, by default we search up the enclosing scopes until we encounter the terminating scope. A conditional/repeating expression is one which is not guaranteed to execute exactly once upon entering the parent scope. This could be because the expression only executes conditionally, such as the expression `b` in `a && b`, or because the expression may execute many times, such as a loop body. The reason that we distinguish such expressions is that, upon exiting the parent scope, we cannot statically know how many times the expression executed, and thus if the expression creates temporaries we cannot know statically how many such temporaries we would have to cleanup. Therefore we ensure that the temporaries never outlast the conditional/repeating expression, preventing the need for dynamic checks and/or arbitrary amounts of stack space. Terminating scopes end up being contained in a DestructionScope that contains the destructor's execution.",396,N],[3,"ExprLocatorVisitor","","",N,N],[12,"hir_id","","",397,N],[12,"result","","",397,N],[12,"expr_and_pat_count","","",397,N],[4,"ScopeData","","",N,N],[13,"Node","","",398,N],[13,"CallSite","","",398,N],[13,"Arguments","","",398,N],[13,"Destruction","","",398,N],[13,"Remainder","","",398,N],[5,"record_var_lifetime","","Records the lifetime of a local variable as `cx.var_parent`",N,[[["regionresolutionvisitor"],["itemlocalid"],["span"]]]],[5,"resolve_block","","",N,[[["regionresolutionvisitor"],["block"]]]],[5,"resolve_arm","","",N,[[["regionresolutionvisitor"],["arm"]]]],[5,"resolve_pat","","",N,[[["regionresolutionvisitor"],["pat"]]]],[5,"resolve_stmt","","",N,[[["regionresolutionvisitor"],["stmt"]]]],[5,"resolve_expr","","",N,[[["regionresolutionvisitor"],["expr"]]]],[5,"resolve_local","","",N,[[["regionresolutionvisitor"],["option",["pat"]],["option",["expr"]]]]],[5,"region_scope_tree","","",N,[[["tyctxt"],["defid"]],["lrc",["scopetree"]]]],[5,"provide","","",N,[[["providers"]]]],[6,"ScopeDepth","","",N,N],[7,"ASSERT","","",N,N],[11,"clone","","",392,[[["self"]],["scope"]]],[11,"eq","","",392,[[["self"],["scope"]],["bool"]]],[11,"ne","","",392,[[["self"],["scope"]],["bool"]]],[11,"partial_cmp","","",392,[[["self"],["scope"]],["option",["ordering"]]]],[11,"lt","","",392,[[["self"],["scope"]],["bool"]]],[11,"le","","",392,[[["self"],["scope"]],["bool"]]],[11,"gt","","",392,[[["self"],["scope"]],["bool"]]],[11,"ge","","",392,[[["self"],["scope"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",392,N],[11,"cmp","","",392,[[["self"],["scope"]],["ordering"]]],[11,"hash","","",392,N],[11,"encode","","",392,[[["self"],["__s"]],["result"]]],[11,"decode","","",392,[[["__d"]],["result",["scope"]]]],[11,"fmt","","",392,[[["self"],["formatter"]],["result"]]],[11,"clone","","",398,[[["self"]],["scopedata"]]],[11,"eq","","",398,[[["self"],["scopedata"]],["bool"]]],[11,"ne","","",398,[[["self"],["scopedata"]],["bool"]]],[11,"partial_cmp","","",398,[[["self"],["scopedata"]],["option",["ordering"]]]],[11,"lt","","",398,[[["self"],["scopedata"]],["bool"]]],[11,"le","","",398,[[["self"],["scopedata"]],["bool"]]],[11,"gt","","",398,[[["self"],["scopedata"]],["bool"]]],[11,"ge","","",398,[[["self"],["scopedata"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",398,N],[11,"cmp","","",398,[[["self"],["scopedata"]],["ordering"]]],[11,"hash","","",398,N],[11,"fmt","","",398,[[["self"],["formatter"]],["result"]]],[11,"encode","","",398,[[["self"],["__s"]],["result"]]],[11,"decode","","",398,[[["__d"]],["result",["scopedata"]]]],[11,"clone","","",393,[[["self"]],["firststatementindex"]]],[11,"eq","","",393,[[["self"],["firststatementindex"]],["bool"]]],[11,"ne","","",393,[[["self"],["firststatementindex"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",393,N],[11,"hash","","",393,N],[11,"partial_cmp","","",393,[[["self"],["firststatementindex"]],["option",["ordering"]]]],[11,"lt","","",393,[[["self"],["firststatementindex"]],["bool"]]],[11,"le","","",393,[[["self"],["firststatementindex"]],["bool"]]],[11,"gt","","",393,[[["self"],["firststatementindex"]],["bool"]]],[11,"ge","","",393,[[["self"],["firststatementindex"]],["bool"]]],[11,"cmp","","",393,[[["self"],["firststatementindex"]],["ordering"]]],[11,"decode","","",393,[[["__d"]],["result",["firststatementindex"]]]],[11,"encode","","",393,[[["self"],["__s"]],["result"]]],[18,"MAX_AS_U32","","",393,N],[18,"MAX","","",393,N],[11,"from_usize","","",393,[[["usize"]],["self"]]],[11,"from_u32","","",393,[[["u32"]],["self"]]],[11,"from_u32_const","","Hacky variant of `from_u32` for use in constants. This version checks the \"max\" constraint by using an invalid array dereference.",393,[[["u32"]],["self"]]],[11,"from_u32_unchecked","","",393,[[["u32"]],["self"]]],[11,"index","","Extract value of this index as an integer.",393,[[["self"]],["usize"]]],[11,"as_u32","","Extract value of this index as a usize.",393,[[["self"]],["u32"]]],[11,"as_usize","","Extract value of this index as a u32.",393,[[["self"]],["usize"]]],[11,"new","","",393,[[["usize"]],["self"]]],[11,"index","","",393,[[["self"]],["usize"]]],[11,"steps_between","","",393,[[["self"],["self"]],["option",["usize"]]]],[11,"replace_one","","",393,[[["self"]],["self"]]],[11,"replace_zero","","",393,[[["self"]],["self"]]],[11,"add_one","","",393,[[["self"]],["self"]]],[11,"sub_one","","",393,[[["self"]],["self"]]],[11,"add_usize","","",393,[[["self"],["usize"]],["option"]]],[11,"from","","",393,[[["usize"]],["self"]]],[11,"from","","",393,[[["u32"]],["self"]]],[11,"fmt","","",393,[[["self"],["formatter"]],["result"]]],[11,"hash_stable","","",393,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"item_local_id","","Returns a item-local id associated with this scope.",392,[[["self"]],["itemlocalid"]]],[11,"node_id","","",392,[[["self"],["tyctxt"],["scopetree"]],["nodeid"]]],[11,"span","","Returns the span of this Scope.  Note that in general the returned span may not correspond to the span of any node id in the AST.",392,[[["self"],["tyctxt"],["scopetree"]],["span"]]],[11,"default","","",394,[[],["scopetree"]]],[11,"fmt","","",394,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",395,[[["self"],["formatter"]],["result"]]],[11,"clone","","",395,[[["self"]],["context"]]],[11,"nested_visit_map","","",397,[[["self"]],["nestedvisitormap"]]],[11,"visit_pat","","",397,[[["self"],["pat"]]]],[11,"visit_expr","","",397,[[["self"],["expr"]]]],[11,"record_scope_parent","","",394,[[["self"],["scope"],["option"]]]],[11,"each_encl_scope","","",394,[[["self"],["e"]]]],[11,"each_var_scope","","",394,[[["self"],["e"]]]],[11,"opt_destruction_scope","","",394,[[["self"],["itemlocalid"]],["option",["scope"]]]],[11,"record_closure_parent","","Records that `sub_closure` is defined within `sup_closure`. These ids should be the id of the block that is the fn body, which is also the root of the region hierarchy for that fn.",394,[[["self"],["itemlocalid"],["itemlocalid"]]]],[11,"record_var_scope","","",394,[[["self"],["itemlocalid"],["scope"]]]],[11,"record_rvalue_scope","","",394,[[["self"],["itemlocalid"],["option",["scope"]]]]],[11,"opt_encl_scope","","Returns the narrowest scope that encloses `id`, if any.",394,[[["self"],["scope"]],["option",["scope"]]]],[11,"encl_scope","","Returns the narrowest scope that encloses `id`, if any.",394,[[["self"],["scope"]],["scope"]]],[11,"var_scope","","Returns the lifetime of the local variable `var_id`",394,[[["self"],["itemlocalid"]],["scope"]]],[11,"temporary_scope","","Returns the scope when temp created by expr_id will be cleaned up",394,[[["self"],["itemlocalid"]],["option",["scope"]]]],[11,"var_region","","Returns the lifetime of the variable `id`.",394,[[["self"],["itemlocalid"]],["regionkind"]]],[11,"scopes_intersect","","",394,[[["self"],["scope"],["scope"]],["bool"]]],[11,"is_subscope_of","","Returns true if `subscope` is equal to or is lexically nested inside `superscope` and false otherwise.",394,[[["self"],["scope"],["scope"]],["bool"]]],[11,"containing_body","","Returns the id of the innermost containing body",394,[[["self"],["scope"]],["option",["itemlocalid"]]]],[11,"nearest_common_ancestor","","Finds the nearest common ancestor of two scopes.  That is, finds the smallest scope which is greater than or equal to both `scope_a` and `scope_b`.",394,[[["self"],["scope"],["scope"]],["scope"]]],[11,"early_free_scope","","Assuming that the provided region was defined within this `ScopeTree`, returns the outermost `Scope` that the region outlives.",394,[[["self"],["tyctxt"],["earlyboundregion"]],["scope"]]],[11,"free_scope","","Assuming that the provided region was defined within this `ScopeTree`, returns the outermost `Scope` that the region outlives.",394,[[["self"],["tyctxt"],["freeregion"]],["scope"]]],[11,"yield_in_scope","","Checks whether the given scope contains a `yield`. If so, returns `Some((span, expr_count))` with the span of a yield we found and the number of expressions and patterns appearing before the `yield` in the body + 1. If there a are multiple yields in a scope, the one with the highest number is returned.",394,[[["self"],["scope"]],["option"]]],[11,"yield_in_scope_for_expr","","Checks whether the given scope contains a `yield` and if that yield could execute after `expr`. If so, it returns the span of that `yield`. `scope` must be inside the body.",394,[[["self"],["scope"],["hirid"],["body"]],["option",["span"]]]],[11,"body_expr_count","","Gives the number of expressions visited in a body. Used to sanity check visit_expr call count when calculating generator interiors.",394,[[["self"],["bodyid"]],["option",["usize"]]]],[11,"record_child_scope","","Records the current parent (if any) as the parent of `child_scope`. Returns the depth of `child_scope`.",396,[[["self"],["scope"]],["scopedepth"]]],[11,"enter_scope","","Records the current parent (if any) as the parent of `child_scope`, and sets `child_scope` as the new current parent.",396,[[["self"],["scope"]]]],[11,"enter_node_scope_with_dtor","","",396,[[["self"],["itemlocalid"]]]],[11,"nested_visit_map","","",396,[[["self"]],["nestedvisitormap"]]],[11,"visit_block","","",396,[[["self"],["block"]]]],[11,"visit_body","","",396,[[["self"],["body"]]]],[11,"visit_arm","","",396,[[["self"],["arm"]]]],[11,"visit_pat","","",396,[[["self"],["pat"]]]],[11,"visit_stmt","","",396,[[["self"],["stmt"]]]],[11,"visit_expr","","",396,[[["self"],["expr"]]]],[11,"visit_local","","",396,[[["self"],["local"]]]],[11,"hash_stable","","",394,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[0,"recursion_limit","rustc::middle","",N,N],[5,"update_limits","rustc::middle::recursion_limit","",N,[[["session"],["crate"]]]],[5,"update_limit","","",N,[[["session"],["crate"],["once"],["str"],["str"],["usize"]]]],[0,"resolve_lifetime","rustc::middle","Name resolution for lifetimes.",N,N],[3,"NamedRegionMap","rustc::middle::resolve_lifetime","Maps the id of each lifetime reference to the lifetime decl that it corresponds to.",N,N],[12,"defs","","",399,N],[12,"late_bound","","",399,N],[12,"object_lifetime_defaults","","",399,N],[3,"ResolveLifetimes","","See `NamedRegionMap`.",N,N],[12,"defs","","",400,N],[12,"late_bound","","",400,N],[12,"object_lifetime_defaults","","",400,N],[3,"LifetimeContext","","",N,N],[12,"tcx","","",401,N],[12,"map","","",401,N],[12,"scope","","",401,N],[12,"trait_ref_hack","","Deep breath. Our representation for poly trait refs contains a single binder and thus we only allow a single level of quantification. However, the syntax of Rust permits quantification in two places, e.g., `T: for <'a> Foo<'a>` and `for <'a, 'b> &'b T: Foo<'a>`. In order to get the de Bruijn indices correct when representing these constraints, we should only introduce one scope. However, we want to support both locations for the quantifier and during lifetime resolution we want precise information (so we can't desugar in an earlier phase).",401,N],[12,"is_in_fn_syntax","","Used to disallow the use of in-band lifetimes in `fn` or `Fn` syntax.",401,N],[12,"labels_in_fn","","List of labels in the function/method currently under analysis.",401,N],[12,"xcrate_object_lifetime_defaults","","Cache for cross-crate per-definition object lifetime defaults.",401,N],[12,"lifetime_uses","","",401,N],[3,"ElisionFailureInfo","","",N,N],[12,"parent","","Where we can find the argument pattern.",402,N],[12,"index","","The index of the argument in the original definition.",402,N],[12,"lifetime_count","","",402,N],[12,"have_bound_regions","","",402,N],[3,"Original","","",N,N],[12,"kind","","",403,N],[12,"span","","",403,N],[3,"Shadower","","",N,N],[12,"kind","","",404,N],[12,"span","","",404,N],[4,"LifetimeDefOrigin","","The origin of a named lifetime definition.",N,N],[13,"Explicit","","",405,N],[13,"InBand","","",405,N],[4,"LifetimeUseSet","","",N,N],[13,"One","","",406,N],[13,"Many","","",406,N],[4,"Region","","",N,N],[13,"Static","","",407,N],[13,"EarlyBound","","",407,N],[13,"LateBound","","",407,N],[13,"LateBoundAnon","","",407,N],[13,"Free","","",407,N],[4,"Set1","","A set containing, at most, one known element. If two distinct values are inserted into a set, then it becomes `Many`, which can be used to detect ambiguities.",N,N],[13,"Empty","","",408,N],[13,"One","","",408,N],[13,"Many","","",408,N],[4,"Scope","","",N,N],[13,"Binder","","Declares lifetimes, and each can be early-bound or late-bound. The `DebruijnIndex` of late-bound lifetimes starts at `1` and it should be shifted by the number of `Binder`s in between the declaration `Binder` and the location it's referenced from.",409,N],[12,"lifetimes","rustc::middle::resolve_lifetime::Scope","",409,N],[12,"next_early_index","","if we extend this scope with another scope, what is the next index we should use for an early-bound region?",409,N],[12,"track_lifetime_uses","","Flag is set to true if, in this binder, `'_` would be equivalent to a \"single-use region\". This is true on impls, but not other kinds of items.",409,N],[12,"abstract_type_parent","","Whether or not this binder would serve as the parent binder for abstract types introduced within. For example:",409,N],[12,"s","","",409,N],[13,"Body","rustc::middle::resolve_lifetime","Lifetimes introduced by a fn are scoped to the call-site for that fn, if this is a fn body, otherwise the original definitions are used. Unspecified lifetimes are inferred, unless an elision scope is nested, e.g. `(&T, fn(&T) -> &T);` becomes `(&'_ T, for<'a> fn(&'a T) -> &'a T)`.",409,N],[12,"id","rustc::middle::resolve_lifetime::Scope","",409,N],[12,"s","","",409,N],[13,"Elision","rustc::middle::resolve_lifetime","A scope which either determines unspecified lifetimes or errors on them (e.g. due to ambiguity). For more details, see `Elide`.",409,N],[12,"elide","rustc::middle::resolve_lifetime::Scope","",409,N],[12,"s","","",409,N],[13,"ObjectLifetimeDefault","rustc::middle::resolve_lifetime","Use a specific lifetime (if `Some`) or leave it unset (to be inferred in a function body or potentially error outside one), for the default choice of lifetime in a trait object type.",409,N],[12,"lifetime","rustc::middle::resolve_lifetime::Scope","",409,N],[12,"s","","",409,N],[13,"Root","rustc::middle::resolve_lifetime","",409,N],[4,"Elide","","",N,N],[13,"FreshLateAnon","","Use a fresh anonymous late-bound lifetime each time, by incrementing the counter to generate sequential indices.",410,N],[13,"Exact","","Always use this one lifetime.",410,N],[13,"Error","","Less or more than one lifetime were found, error on unspecified.",410,N],[4,"ShadowKind","","",N,N],[13,"Label","","",411,N],[13,"Lifetime","","",411,N],[5,"provide","","",N,[[["providers"]]]],[5,"resolve_lifetimes","","Computes the `ResolveLifetimes` map that contains data for the entire crate. You should not read the result of this query directly, but rather use `named_region_map`, `is_late_bound_map`, etc.",N,[[["tyctxt"],["cratenum"]],["lrc",["resolvelifetimes"]]]],[5,"krate","","",N,[[["tyctxt"]],["namedregionmap"]]],[5,"original_label","","",N,[[["span"]],["original"]]],[5,"shadower_label","","",N,[[["span"]],["shadower"]]],[5,"original_lifetime","","",N,[[["span"]],["original"]]],[5,"shadower_lifetime","","",N,[[["genericparam"]],["shadower"]]],[5,"check_mixed_explicit_and_in_band_defs","","",N,[[["tyctxt"],["p"]]]],[5,"signal_shadowing_problem","","",N,[[["tyctxt"],["name"],["original"],["shadower"]]]],[5,"extract_labels","","",N,[[["lifetimecontext"],["body"]]]],[5,"compute_object_lifetime_defaults","","",N,[[["tyctxt"]],["nodemap",["vec"]]]],[5,"object_lifetime_defaults_for_item","","Scan the bounds and where-clauses on parameters to extract bounds of the form `T:'a` so as to determine the `ObjectLifetimeDefault` for each type parameter.",N,[[["tyctxt"],["generics"]],["vec",["objectlifetimedefault"]]]],[5,"insert_late_bound_lifetimes","","Detects late-bound lifetimes and inserts them into `map.late_bound`.",N,[[["namedregionmap"],["fndecl"],["generics"]]]],[5,"report_missing_lifetime_specifiers","","",N,[[["session"],["span"],["usize"]],["diagnosticbuilder"]]],[6,"ObjectLifetimeDefault","","",N,N],[6,"ScopeRef","","",N,N],[17,"ROOT_SCOPE","","",N,N],[11,"clone","","",405,[[["self"]],["lifetimedeforigin"]]],[11,"eq","","",405,[[["self"],["lifetimedeforigin"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",405,N],[11,"hash","","",405,N],[11,"encode","","",405,[[["self"],["__s"]],["result"]]],[11,"decode","","",405,[[["__d"]],["result",["lifetimedeforigin"]]]],[11,"fmt","","",405,[[["self"],["formatter"]],["result"]]],[11,"from_param","","",405,[[["genericparam"]],["self"]]],[11,"clone","","",406,[[["self"]],["lifetimeuseset"]]],[11,"fmt","","",406,[[["self"],["formatter"]],["result"]]],[11,"clone","","",407,[[["self"]],["region"]]],[11,"eq","","",407,[[["self"],["region"]],["bool"]]],[11,"ne","","",407,[[["self"],["region"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",407,N],[11,"hash","","",407,N],[11,"encode","","",407,[[["self"],["__s"]],["result"]]],[11,"decode","","",407,[[["__d"]],["result",["region"]]]],[11,"fmt","","",407,[[["self"],["formatter"]],["result"]]],[11,"early","","",407,N],[11,"late","","",407,N],[11,"late_anon","","",407,[[["cell"]],["region"]]],[11,"id","","",407,[[["self"]],["option",["defid"]]]],[11,"shifted","","",407,[[["self"],["u32"]],["region"]]],[11,"shifted_out_to_binder","","",407,[[["self"],["debruijnindex"]],["region"]]],[11,"subst","","",407,[[["self"],["l"],["namedregionmap"]],["option",["region"]]]],[11,"clone","","",408,[[["self"]],["set1"]]],[11,"eq","","",408,[[["self"],["set1"]],["bool"]]],[11,"ne","","",408,[[["self"],["set1"]],["bool"]]],[11,"assert_receiver_is_total_eq","","",408,N],[11,"encode","","",408,[[["self"],["__st"]],["result"]]],[11,"decode","","",408,[[["__dt"]],["result",["set1"]]]],[11,"fmt","","",408,[[["self"],["formatter"]],["result"]]],[11,"insert","","",408,[[["self"],["t"]]]],[11,"default","","",399,[[],["namedregionmap"]]],[11,"hash_stable","","",400,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"fmt","","",409,[[["self"],["formatter"]],["result"]]],[11,"clone","","",410,[[["self"]],["elide"]]],[11,"fmt","","",410,[[["self"],["formatter"]],["result"]]],[11,"clone","","",402,[[["self"]],["elisionfailureinfo"]]],[11,"fmt","","",402,[[["self"],["formatter"]],["result"]]],[11,"nested_visit_map","","",401,[[["self"]],["nestedvisitormap"]]],[11,"visit_nested_item","","",401,[[["self"],["itemid"]]]],[11,"visit_nested_body","","",401,[[["self"],["bodyid"]]]],[11,"visit_item","","",401,[[["self"],["item"]]]],[11,"visit_foreign_item","","",401,[[["self"],["foreignitem"]]]],[11,"visit_ty","","",401,[[["self"],["ty"]]]],[11,"visit_trait_item","","",401,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",401,[[["self"],["implitem"]]]],[11,"visit_lifetime","","",401,[[["self"],["lifetime"]]]],[11,"visit_path","","",401,[[["self"],["path"],["hirid"]]]],[11,"visit_fn_decl","","",401,[[["self"],["fndecl"]]]],[11,"visit_generics","","",401,[[["self"],["generics"]]]],[11,"visit_poly_trait_ref","","",401,[[["self"],["polytraitref"],["traitboundmodifier"]]]],[11,"clone","","",411,[[["self"]],["shadowkind"]]],[11,"eq","","",411,[[["self"],["shadowkind"]],["bool"]]],[11,"desc","","",411,[[["self"]],["str"]]],[11,"hack","","",401,[[["self"],["f"]]]],[11,"with","","",401,[[["self"],["scope"],["f"]]]],[11,"check_uses_for_lifetimes_defined_by_scope","","",401,[[["self"]]]],[11,"visit_early_late","","Visits self by adding a scope and handling recursive walk over the contents with `walk`.",401,[[["self"],["option",["nodeid"]],["fndecl"],["generics"],["f"]]]],[11,"next_early_index_helper","","",401,[[["self"],["bool"]],["u32"]]],[11,"next_early_index","","Returns the next index one would use for an early-bound-region if extending the current scope.",401,[[["self"]],["u32"]]],[11,"next_early_index_for_abstract_type","","Returns the next index one would use for an `impl Trait` that is being converted into an `abstract type`. This will be the next early index from the enclosing item, for the most part. See the `abstract_type_parent` field for more info.",401,[[["self"]],["u32"]]],[11,"resolve_lifetime_ref","","",401,[[["self"],["lifetime"]]]],[11,"visit_segment_args","","",401,[[["self"],["def"],["usize"],["genericargs"]]]],[11,"visit_fn_like_elision","","",401,N],[11,"resolve_elided_lifetimes","","",401,[[["self"],["vec",["lifetime"]]]]],[11,"report_elision_failure","","",401,N],[11,"resolve_object_lifetime_default","","",401,[[["self"],["lifetime"]]]],[11,"check_lifetime_params","","",401,N],[11,"check_lifetime_param_for_shadowing","","",401,[[["self"],["scope"],["genericparam"]]]],[11,"track_lifetime_uses","","Returns true if, in the current scope, replacing `'_` would be equivalent to a single-use lifetime.",401,[[["self"]],["bool"]]],[11,"insert_lifetime","","",401,[[["self"],["lifetime"],["region"]]]],[11,"uninsert_lifetime_on_error","","Sometimes we resolve a lifetime, but later find that it is an error (esp. around impl trait). In that case, we remove the entry into `map.defs` so as not to confuse later code.",401,[[["self"],["lifetime"],["region"]]]],[0,"stability","rustc::middle","A pass that annotates every item and method with its stability level, propagating default levels lexically from parent to children ast nodes.",N,N],[3,"DeprecationEntry","rustc::middle::stability","An entry in the `depr_map`.",N,N],[12,"attr","","The metadata of the attribute associated with this entry.",412,N],[12,"origin","","The def id where the attr was originally attached. `None` for non-local `DefId`'s.",412,N],[3,"Index","","A stability index, giving the stability level for items and methods.",N,N],[12,"stab_map","","This is mostly a cache, except the stabilities of local items are filled by the annotator.",413,N],[12,"depr_map","","",413,N],[12,"staged_api","","Maps for each crate whether it is part of the staged API.",413,N],[12,"active_features","","Features enabled for this crate.",413,N],[3,"Annotator","","",N,N],[12,"tcx","","",414,N],[12,"index","","",414,N],[12,"parent_stab","","",414,N],[12,"parent_depr","","",414,N],[12,"in_trait_impl","","",414,N],[3,"MissingStabilityAnnotations","","",N,N],[12,"tcx","","",415,N],[12,"access_levels","","",415,N],[3,"Checker","","",N,N],[12,"tcx","","",416,N],[4,"StabilityLevel","","",N,N],[13,"Unstable","","",417,N],[13,"Stable","","",417,N],[4,"AnnotationKind","","",N,N],[13,"Required","","",418,N],[13,"Prohibited","","",418,N],[13,"Container","","",418,N],[4,"EvalResult","","Result of `TyCtxt::eval_stability`.",N,N],[13,"Allow","","We can use the item because it is stable or we provided the corresponding feature gate.",419,N],[13,"Deny","","We cannot use the item because it is unstable and we did not provide the corresponding feature gate.",419,N],[12,"feature","rustc::middle::stability::EvalResult","",419,N],[12,"reason","","",419,N],[12,"issue","","",419,N],[13,"Unmarked","rustc::middle::stability","The item does not have the `#[stable]` or `#[unstable]` marker assigned.",419,N],[5,"check_unstable_api_usage","","Cross-references the feature names of unstable APIs with enabled features and possibly prints errors.",N,[[["tyctxt"]]]],[5,"deprecation_in_effect","","Check whether an item marked with `deprecated(since=\"X\")` is currently deprecated (i.e. whether X is not greater than the current rustc version).",N,[[["str"]],["bool"]]],[5,"check_unused_or_stable_features","","Given the list of enabled features that were not language features (i.e. that were expected to be library features), and the list of features used from libraries, identify activated features that don't exist and error about them.",N,[[["tyctxt"]]]],[5,"unnecessary_stable_feature_lint","","",N,[[["tyctxt"],["span"],["symbol"],["symbol"]]]],[5,"duplicate_feature_err","","",N,[[["session"],["span"],["symbol"]]]],[11,"encode","","",417,[[["self"],["__s"]],["result"]]],[11,"decode","","",417,[[["__d"]],["result",["stabilitylevel"]]]],[11,"eq","","",417,[[["self"],["stabilitylevel"]],["bool"]]],[11,"partial_cmp","","",417,[[["self"],["stabilitylevel"]],["option",["ordering"]]]],[11,"clone","","",417,[[["self"]],["stabilitylevel"]]],[11,"fmt","","",417,[[["self"],["formatter"]],["result"]]],[11,"assert_receiver_is_total_eq","","",417,N],[11,"hash","","",417,N],[11,"from_attr_level","","",417,[[["stabilitylevel"]],["self"]]],[11,"eq","","",418,[[["self"],["annotationkind"]],["bool"]]],[11,"clone","","",412,[[["self"]],["deprecationentry"]]],[11,"hash_stable","","",412,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"local","","",412,[[["deprecation"],["hirid"]],["deprecationentry"]]],[11,"external","","",412,[[["deprecation"]],["deprecationentry"]]],[11,"same_origin","","",412,[[["self"],["deprecationentry"]],["bool"]]],[11,"hash_stable","","",413,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"annotate","","",414,N],[11,"nested_visit_map","","Because stability levels are scoped lexically, we want to walk nested items in the context of the outer item, so enable deep-walking.",414,[[["self"]],["nestedvisitormap"]]],[11,"visit_item","","",414,[[["self"],["item"]]]],[11,"visit_trait_item","","",414,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",414,[[["self"],["implitem"]]]],[11,"visit_variant","","",414,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_struct_field","","",414,[[["self"],["structfield"]]]],[11,"visit_foreign_item","","",414,[[["self"],["foreignitem"]]]],[11,"visit_macro_def","","",414,[[["self"],["macrodef"]]]],[11,"check_missing_stability","","",415,[[["self"],["nodeid"],["span"]]]],[11,"nested_visit_map","","",415,[[["self"]],["nestedvisitormap"]]],[11,"visit_item","","",415,[[["self"],["item"]]]],[11,"visit_trait_item","","",415,[[["self"],["traititem"]]]],[11,"visit_impl_item","","",415,[[["self"],["implitem"]]]],[11,"visit_variant","","",415,[[["self"],["variant"],["generics"],["nodeid"]]]],[11,"visit_struct_field","","",415,[[["self"],["structfield"]]]],[11,"visit_foreign_item","","",415,[[["self"],["foreignitem"]]]],[11,"visit_macro_def","","",415,[[["self"],["macrodef"]]]],[11,"new","","",413,[[["tyctxt"]],["index"]]],[11,"local_stability","","",413,[[["self"],["hirid"]],["option",["stability"]]]],[11,"local_deprecation_entry","","",413,[[["self"],["hirid"]],["option",["deprecationentry"]]]],[11,"nested_visit_map","","Because stability levels are scoped lexically, we want to walk nested items in the context of the outer item, so enable deep-walking.",416,[[["self"]],["nestedvisitormap"]]],[11,"visit_item","","",416,[[["self"],["item"]]]],[11,"visit_path","","",416,[[["self"],["path"],["hirid"]]]],[0,"weak_lang_items","rustc::middle","Validity checking for weak lang items",N,N],[3,"Context","rustc::middle::weak_lang_items","",N,N],[12,"tcx","","",420,N],[12,"items","","",420,N],[5,"check_crate","","Checks the crate for usage of weak lang items, returning a vector of all the language items required by this crate, but not defined yet.",N,[[["tyctxt"],["languageitems"]]]],[5,"link_name","","",N,N],[5,"whitelisted","","Returns whether the specified `lang_item` doesn't actually need to be present for this compilation.",N,[[["tyctxt"],["langitem"]],["bool"]]],[5,"verify","","",N,[[["tyctxt"],["languageitems"]]]],[11,"register","","",420,[[["self"],["str"],["span"]]]],[11,"nested_visit_map","","",420,[[["self"]],["nestedvisitormap"]]],[11,"visit_foreign_item","","",420,[[["self"],["foreignitem"]]]],[0,"mir","rustc","MIR datatypes and passes. See the [rustc guide] for more info.",N,N],[3,"Mir","rustc::mir","Lowered representation of a single function.",N,N],[12,"basic_blocks","","List of basic blocks. References to basic block use a newtyped index type `BasicBlock` that indexes into this vector.",421,N],[12,"source_scopes","","List of source scopes; these are referenced by statements and used for debuginfo. Indexed by a `SourceScope`.",421,N],[12,"source_scope_local_data","","Crate-local information for each source scope, that can't (and needn't) be tracked across crates.",421,N],[12,"promoted","","Rvalues promoted from this function, such as borrows of constants. Each of them is the Mir of a constant with the fn's type parameters in scope, but a separate set of locals.",421,N],[12,"yield_ty","","Yield type of the function, if it is a generator.",421,N],[12,"generator_drop","","Generator drop glue",421,N],[12,"generator_layout","","The layout of a generator. Produced by the state transformation.",421,N],[12,"local_decls","","Declarations of locals.",421,N],[12,"arg_count","","Number of arguments this function takes.",421,N],[12,"upvar_decls","","Names and capture modes of all the closure upvars, assuming the first argument is either the closure or a reference to it.",421,N],[12,"spread_arg","","Mark an argument local (which must be a tuple) as getting passed as its individual components at the LLVM level.",421,N],[12,"span","","A span representing this MIR, for error reporting",421,N],[12,"cache","","A cache for various calculations",421,N],[3,"SourceInfo","","Grouped information about the source code origin of a MIR entity. Intended to be inspected by diagnostics and debuginfo. Most passes can work with it as a whole, within a single function.",N,N],[12,"span","","Source span for the AST pertaining to this MIR entity.",422,N],[12,"scope","","The source scope, keeping track of which bindings can be seen by debuginfo, active lint levels, `unsafe {...}`, etc.",422,N],[3,"Local","","",N,N],[12,"private","","",423,N],[3,"VarBindingForm","","",N,N],[12,"binding_mode","","Is variable bound via `x`, `mut x`, `ref x`, or `ref mut x`?",424,N],[12,"opt_ty_info","","If an explicit type was provided for this variable binding, this holds the source Span of that type.",424,N],[12,"opt_match_place","","Place of the RHS of the =, or the subject of the `match` where this variable is initialized. None in the case of `let PATTERN;`. Some((None, ..)) in the case of and `let [mut] x = ...` because (a) the right-hand side isn't evaluated as a place expression. (b) it gives a way to separate this case from the remaining cases     for diagnostics.",424,N],[12,"pat_span","","Span of the pattern in which this variable was bound.",424,N],[3,"LocalDecl","","A MIR local.",N,N],[12,"mutability","","`let mut x` vs `let x`.",425,N],[12,"is_user_variable","","Some(binding_mode) if this corresponds to a user-declared local variable.",425,N],[12,"internal","","True if this is an internal local",425,N],[12,"ty","","Type of this local.",425,N],[12,"user_ty","","If the user manually ascribed a type to this variable, e.g. via `let x: T`, then we carry that type here. The MIR borrow checker needs this information since it can affect region inference.",425,N],[12,"name","","Name of the local, used in debuginfo and pretty-printing.",425,N],[12,"source_info","","The syntactic (i.e. not visibility) source scope the local is defined in. If the local was defined in a let-statement, this is within the let-statement, rather than outside of it.",425,N],[12,"visibility_scope","","Source scope within which the local is visible (for debuginfo) (see `source_info` for more details).",425,N],[3,"UpvarDecl","","A closure capture, with its name and mode.",N,N],[12,"debug_name","","",426,N],[12,"var_hir_id","","`HirId` of the captured variable",426,N],[12,"by_ref","","If true, the capture is behind a reference.",426,N],[12,"mutability","","",426,N],[3,"BasicBlock","","",N,N],[12,"private","","",427,N],[3,"BasicBlockData","","",N,N],[12,"statements","","List of statements in this block.",428,N],[12,"terminator","","Terminator for this block.",428,N],[12,"is_cleanup","","If true, this block lies on an unwind path. This is used during codegen where distinct kinds of basic blocks may be generated (particularly for MSVC cleanup). Unwind blocks must only branch to other unwind blocks.",428,N],[3,"Terminator","","",N,N],[12,"source_info","","",429,N],[12,"kind","","",429,N],[3,"Statement","","",N,N],[12,"source_info","","",430,N],[12,"kind","","",430,N],[3,"ValidationOperand","","",N,N],[12,"place","","",431,N],[12,"ty","","",431,N],[12,"re","","",431,N],[12,"mutbl","","",431,N],[3,"Static","","The def-id of a static, along with its normalized type (which is stored to avoid requiring normalization when reading MIR).",N,N],[12,"def_id","","",432,N],[12,"ty","","",432,N],[3,"Projection","","The `Projection` data structure defines things of the form `B.x` or `*B` or `B[index]`. Note that it is parameterized because it is shared between `Constant` and `Place`. See the aliases `PlaceProjection` etc below.",N,N],[12,"base","","",433,N],[12,"elem","","",433,N],[3,"Field","","",N,N],[12,"private","","",434,N],[3,"SourceScope","","",N,N],[12,"private","","",435,N],[3,"SourceScopeData","","",N,N],[12,"span","","",436,N],[12,"parent_scope","","",436,N],[3,"SourceScopeLocalData","","",N,N],[12,"lint_root","","A NodeId with lint levels equivalent to this scope's lint levels.",437,N],[12,"safety","","The unsafe block that contains this node.",437,N],[3,"Constant","","Constants",N,N],[12,"span","","",438,N],[12,"ty","","",438,N],[12,"user_ty","","Optional user-given type: for something like `collect::<Vec<_>>`, this would be present and would indicate that `Vec<_>` was explicitly specified.",438,N],[12,"literal","","",438,N],[3,"Promoted","","",N,N],[12,"private","","",439,N],[3,"Location","","",N,N],[12,"block","","the location is within this block",440,N],[12,"statement_index","","the location is the start of the statement; or, if `statement_index` == num-statements, then the start of the terminator.",440,N],[3,"UnsafetyViolation","","",N,N],[12,"source_info","","",441,N],[12,"description","","",441,N],[12,"details","","",441,N],[12,"kind","","",441,N],[3,"UnsafetyCheckResult","","",N,N],[12,"violations","","Violations that are propagated upwards from this function",442,N],[12,"unsafe_blocks","","unsafe blocks in this function, along with whether they are used. This is used for the \"unused_unsafe\" lint.",442,N],[3,"GeneratorLayout","","The layout of generator state",N,N],[12,"fields","","",443,N],[3,"BorrowCheckResult","","",N,N],[12,"closure_requirements","","",444,N],[12,"used_mut_upvars","","",444,N],[3,"ClosureRegionRequirements","","After we borrow check a closure, we are left with various requirements that we have inferred between the free regions that appear in the closure's signature or on its field types.  These requirements are then verified and proved by the closure's creating function. This struct encodes those requirements.",N,N],[12,"num_external_vids","","The number of external regions defined on the closure.  In our example above, it would be 3 -- one for `'static`, then `'1` and `'2`. This is just used for a sanity check later on, to make sure that the number of regions we see at the callsite matches.",445,N],[12,"outlives_requirements","","Requirements between the various free regions defined in indices.",445,N],[3,"ClosureOutlivesRequirement","","Indicates an outlives constraint between a type or between two free-regions declared on the closure.",N,N],[12,"subject","","",446,N],[12,"outlived_free_region","","",446,N],[12,"blame_span","","",446,N],[4,"Safety","","",N,N],[13,"Safe","","",447,N],[13,"BuiltinUnsafe","","Unsafe because of a PushUnsafeBlock",447,N],[13,"FnUnsafe","","Unsafe because of an unsafe fn",447,N],[13,"ExplicitUnsafe","","Unsafe because of an `unsafe` block",447,N],[4,"ClearCrossCrate","","",N,N],[13,"Clear","","",448,N],[13,"Set","","",448,N],[4,"Mutability","","",N,N],[13,"Mut","","",449,N],[13,"Not","","",449,N],[4,"BorrowKind","","",N,N],[13,"Shared","","Data must be immutable and is aliasable.",450,N],[13,"Unique","","Data must be immutable but not aliasable.  This kind of borrow cannot currently be expressed by the user and is used only in implicit closure bindings. It is needed when the closure is borrowing or mutating a mutable referent, e.g.:",450,N],[13,"Mut","","Data is mutable and not aliasable.",450,N],[12,"allow_two_phase_borrow","rustc::mir::BorrowKind","True if this borrow arose from method-call auto-ref (i.e. `adjustment::Adjust::Borrow`)",450,N],[4,"LocalKind","rustc::mir","Classifies locals into categories. See `Mir::local_kind`.",N,N],[13,"Var","","User-declared variable binding",451,N],[13,"Temp","","Compiler-introduced temporary",451,N],[13,"Arg","","Function argument",451,N],[13,"ReturnPointer","","Location of function's return value",451,N],[4,"BindingForm","","",N,N],[13,"Var","","This is a binding for a non-`self` binding, or a `self` that has an explicit type.",452,N],[13,"ImplicitSelf","","Binding for a `self`/`&self`/`&mut self` binding where the type is implicit.",452,N],[13,"RefForGuard","","Reference used in a guard expression to ensure immutability.",452,N],[4,"TerminatorKind","","",N,N],[13,"Goto","","block should have one successor in the graph; we jump there",453,N],[12,"target","rustc::mir::TerminatorKind","",453,N],[13,"SwitchInt","rustc::mir","operand evaluates to an integer; jump depending on its value to one of the targets, and otherwise fallback to `otherwise`",453,N],[12,"discr","rustc::mir::TerminatorKind","discriminant value being tested",453,N],[12,"switch_ty","","type of value being tested",453,N],[12,"values","","Possible values. The locations to branch to in each case are found in the corresponding indices from the `targets` vector.",453,N],[12,"targets","","Possible branch sites. The last element of this vector is used for the otherwise branch, so targets.len() == values.len() + 1 should hold.",453,N],[13,"Resume","rustc::mir","Indicates that the landing pad is finished and unwinding should continue. Emitted by build::scope::diverge_cleanup.",453,N],[13,"Abort","","Indicates that the landing pad is finished and that the process should abort. Used to prevent unwinding for foreign items.",453,N],[13,"Return","","Indicates a normal return. The return place should have been filled in by now. This should occur at most once.",453,N],[13,"Unreachable","","Indicates a terminator that can never be reached.",453,N],[13,"Drop","","Drop the Place",453,N],[12,"location","rustc::mir::TerminatorKind","",453,N],[12,"target","","",453,N],[12,"unwind","","",453,N],[13,"DropAndReplace","rustc::mir","Drop the Place and assign the new value over it. This ensures that the assignment to `P` occurs even if the destructor for place unwinds. Its semantics are best explained by the elaboration:",453,N],[12,"location","rustc::mir::TerminatorKind","",453,N],[12,"value","","",453,N],[12,"target","","",453,N],[12,"unwind","","",453,N],[13,"Call","rustc::mir","Block ends with a call of a converging function",453,N],[12,"func","rustc::mir::TerminatorKind","The function that’s being called",453,N],[12,"args","","Arguments the function is called with. These are owned by the callee, which is free to modify them. This allows the memory occupied by \"by-value\" arguments to be reused across function calls without duplicating the contents.",453,N],[12,"destination","","Destination for the return value. If some, the call is converging.",453,N],[12,"cleanup","","Cleanups to be done if the call unwinds.",453,N],[13,"Assert","rustc::mir","Jump to the target if the condition has the expected value, otherwise panic with a message and a cleanup target.",453,N],[12,"cond","rustc::mir::TerminatorKind","",453,N],[12,"expected","","",453,N],[12,"msg","","",453,N],[12,"target","","",453,N],[12,"cleanup","","",453,N],[13,"Yield","rustc::mir","A suspend point",453,N],[12,"value","rustc::mir::TerminatorKind","The value to return",453,N],[12,"resume","","Where to resume to",453,N],[12,"drop","","Cleanup to be done if the generator is dropped at this suspend point",453,N],[13,"GeneratorDrop","rustc::mir","Indicates the end of the dropping of a generator",453,N],[13,"FalseEdges","","A block where control flow only ever takes one real path, but borrowck needs to be more conservative.",453,N],[12,"real_target","rustc::mir::TerminatorKind","The target normal control flow will take",453,N],[12,"imaginary_targets","","The list of blocks control flow could conceptually take, but won't in practice",453,N],[13,"FalseUnwind","rustc::mir","A terminator for blocks that only take one path in reality, but where we reserve the right to unwind in borrowck, even if it won't happen in practice. This can arise in infinite loops with no function calls for example.",453,N],[12,"real_target","rustc::mir::TerminatorKind","The target normal control flow will take",453,N],[12,"unwind","","The imaginary cleanup block link. This particular path will never be taken in practice, but in order to avoid fragility we want to always consider it in borrowck. We don't want to accept programs which pass borrowck only when panic=abort or some assertions are disabled due to release vs. debug mode builds. This needs to be an Option because of the remove_noop_landing_pads and no_landing_pads passes",453,N],[4,"StatementKind","rustc::mir","",N,N],[13,"Assign","","Write the RHS Rvalue to the LHS Place.",454,N],[13,"ReadForMatch","","This represents all the reading that a pattern match may do (e.g. inspecting constants and discriminant values).",454,N],[13,"SetDiscriminant","","Write the discriminant for a variant to the enum Place.",454,N],[12,"place","rustc::mir::StatementKind","",454,N],[12,"variant_index","","",454,N],[13,"StorageLive","rustc::mir","Start a live range for the storage of the local.",454,N],[13,"StorageDead","","End the current live range for the storage of the local.",454,N],[13,"InlineAsm","","Execute a piece of inline Assembly.",454,N],[12,"asm","rustc::mir::StatementKind","",454,N],[12,"outputs","","",454,N],[12,"inputs","","",454,N],[13,"Validate","rustc::mir","Assert the given places to be valid inhabitants of their type.  These statements are currently only interpreted by miri and only generated when \"-Z mir-emit-validate\" is passed. See https://internals.rust-lang.org/t/types-as-contracts/5562/73 for more details.",454,N],[13,"EndRegion","","Mark one terminating point of a region scope (i.e. static region). (The starting point(s) arise implicitly from borrows.)",454,N],[13,"AscribeUserType","","Encodes a user's type ascription. These need to be preserved intact so that NLL can respect them. For example:",454,N],[13,"Nop","","No-op. Useful for deleting instructions without affecting statement indices.",454,N],[4,"ValidationOp","","The `ValidationOp` describes what happens with each of the operands of a `Validate` statement.",N,N],[13,"Acquire","","Recursively traverse the place following the type and validate that all type invariants are maintained.  Furthermore, acquire exclusive/read-only access to the memory reachable from the place.",455,N],[13,"Release","","Recursive traverse the mutable part of the type and relinquish all exclusive access.",455,N],[13,"Suspend","","Recursive traverse the mutable part of the type and relinquish all exclusive access until the given region ends.  Then, access will be recovered.",455,N],[4,"Place","","A path to a value; something that can be evaluated without changing or disturbing program state.",N,N],[13,"Local","","local variable",456,N],[13,"Static","","static or static mut variable",456,N],[13,"Promoted","","Constant code promoted to an injected static",456,N],[13,"Projection","","projection out of a place (access a field, deref a pointer, etc)",456,N],[4,"ProjectionElem","","",N,N],[13,"Deref","","",457,N],[13,"Field","","",457,N],[13,"Index","","",457,N],[13,"ConstantIndex","","These indices are generated by slice patterns. Easiest to explain by example:",457,N],[12,"offset","rustc::mir::ProjectionElem","index or -index (in Python terms), depending on from_end",457,N],[12,"min_length","","thing being indexed must be at least this long",457,N],[12,"from_end","","counting backwards from end?",457,N],[13,"Subslice","rustc::mir","These indices are generated by slice patterns.",457,N],[12,"from","rustc::mir::ProjectionElem","",457,N],[12,"to","","",457,N],[13,"Downcast","rustc::mir","\"Downcast\" to a variant of an ADT. Currently, we only introduce this for ADTs with more than one variant. It may be better to just introduce it always, or always for enums.",457,N],[4,"Operand","","These are values that can appear inside an rvalue (or an index place). They are intentionally limited to prevent rvalues from being nested in one another.",N,N],[13,"Copy","","Copy: The value must be available for use afterwards.",458,N],[13,"Move","","Move: The value (including old borrows of it) will not be used again.",458,N],[13,"Constant","","Synthesizes a constant value.",458,N],[4,"Rvalue","","Rvalues",N,N],[13,"Use","","x (either a move or copy, depending on type of x)",459,N],[13,"Repeat","","[x; 32]",459,N],[13,"Ref","","&x or &mut x",459,N],[13,"Len","","length of a [X] or [X;n] value",459,N],[13,"Cast","","",459,N],[13,"BinaryOp","","",459,N],[13,"CheckedBinaryOp","","",459,N],[13,"NullaryOp","","",459,N],[13,"UnaryOp","","",459,N],[13,"Discriminant","","Read the discriminant of an ADT.",459,N],[13,"Aggregate","","Create an aggregate value, like a tuple or struct.  This is only needed because we want to distinguish `dest = Foo { x: ..., y: ... }` from `dest.x = ...; dest.y = ...;` in the case that `Foo` has a destructor. These rvalues can be optimized away after type-checking and before lowering.",459,N],[4,"CastKind","","",N,N],[13,"Misc","","",460,N],[13,"ReifyFnPointer","","Convert unique, zero-sized type for a fn to fn()",460,N],[13,"ClosureFnPointer","","Convert non capturing closure to fn()",460,N],[13,"UnsafeFnPointer","","Convert safe fn() to unsafe fn()",460,N],[13,"Unsize","","\"Unsize\" -- convert a thin-or-fat pointer to a fat pointer. codegen must figure out the details once full monomorphization is known. For example, this could be used to cast from a `&[i32;N]` to a `&[i32]`, or a `Box<T>` to a `Box<Trait>` (presuming `T: Trait`).",460,N],[4,"AggregateKind","","",N,N],[13,"Array","","The type is of the element",461,N],[13,"Tuple","","",461,N],[13,"Adt","","The second field is the variant index. It's equal to 0 for struct and union expressions. The fourth field is active field number and is present only for union expressions -- e.g. for a union expression `SomeUnion { c: .. }`, the active field index would identity the field `c`",461,N],[13,"Closure","","",461,N],[13,"Generator","","",461,N],[4,"BinOp","","",N,N],[13,"Add","","The `+` operator (addition)",462,N],[13,"Sub","","The `-` operator (subtraction)",462,N],[13,"Mul","","The `*` operator (multiplication)",462,N],[13,"Div","","The `/` operator (division)",462,N],[13,"Rem","","The `%` operator (modulus)",462,N],[13,"BitXor","","The `^` operator (bitwise xor)",462,N],[13,"BitAnd","","The `&` operator (bitwise and)",462,N],[13,"BitOr","","The `|` operator (bitwise or)",462,N],[13,"Shl","","The `<<` operator (shift left)",462,N],[13,"Shr","","The `>>` operator (shift right)",462,N],[13,"Eq","","The `==` operator (equality)",462,N],[13,"Lt","","The `<` operator (less than)",462,N],[13,"Le","","The `<=` operator (less than or equal to)",462,N],[13,"Ne","","The `!=` operator (not equal to)",462,N],[13,"Ge","","The `>=` operator (greater than or equal to)",462,N],[13,"Gt","","The `>` operator (greater than)",462,N],[13,"Offset","","The `ptr.offset` operator",462,N],[4,"NullOp","","",N,N],[13,"SizeOf","","Return the size of a value of that type",463,N],[13,"Box","","Create a new uninitialized box for a value of that type",463,N],[4,"UnOp","","",N,N],[13,"Not","","The `!` operator for logical inversion",464,N],[13,"Neg","","The `-` operator for negation",464,N],[4,"UnsafetyViolationKind","","",N,N],[13,"General","","",465,N],[13,"MinConstFn","","unsafety is not allowed at all in min const fn",465,N],[13,"ExternStatic","","",465,N],[13,"BorrowPacked","","",465,N],[4,"ClosureOutlivesSubject","","The subject of a ClosureOutlivesRequirement -- that is, the thing that must outlive some region.",N,N],[13,"Ty","","Subject is a type, typically a type parameter, but could also be a projection. Indicates a requirement like `T: 'a` being passed to the caller, where the type here is `T`.",466,N],[13,"Region","","Subject is a free region from the closure. Indicates a requirement like `'a: 'b` being passed to the caller; the region here is `'a`.",466,N],[5,"fmt_const_val","","Write a `ConstValue` in a way closer to the original source code than the `Debug` output.",N,N],[5,"item_path_str","","",N,[[["defid"]],["string"]]],[0,"cache","","",N,N],[3,"Cache","rustc::mir::cache","",N,N],[12,"predecessors","","",467,N],[5,"calculate_predecessors","","",N,[[["mir"]],["indexvec",["basicblock","vec"]]]],[11,"clone","","",467,[[["self"]],["cache"]]],[11,"fmt","","",467,[[["self"],["formatter"]],["result"]]],[11,"encode","","",467,[[["self"],["s"]],["result"]]],[11,"decode","","",467,[[["d"]],["result"]]],[11,"hash_stable","","",467,[[["self"],["stablehashingcontext"],["stablehasher"]]]],[11,"new","","",467,[[],["self"]]],[11,"invalidate","","",467,[[["self"]]]],[11,"predecessors","","",467,[[["self"],["mir"]],["mappedreadguard",["indexvec"]]]],[11,"super_fold_with","","",467,[[["self"],["f"]],["cache"]]],[11,"super_visit_with","","",467,[[["self"],["f"]],["bool"]]],[11,"lift_to_tcx","","",467,[[["self"],["tyctxt"]],["option"]]],[0,"interpret","rustc::mir","An interpreter for MIR used in CTFE and by miri",N,N],[3,"EvalError","rustc::mir::interpret","",N,N],[12,"kind","","",468,N],[3,"ConstEvalErr","","",N,N],[12,"span","","",469,N],[12,"error","","",469,N],[12,"stacktrace","","",469,N],[3,"FrameInfo","","",N,N],[12,"span","","",470,N],[12,"location","","",470,N],[12,"lint_root","","",470,N],[3,"DynamicLifetime","","",N,N],[12,"frame","","",471,N],[12,"region","","",471,N],[3,"GlobalId","","Uniquely identifies a specific constant or static.",N,N],[12,"instance","","For a constant or static, the `Instance` of the item itself. For a promoted global, the `Instance` of the function they belong to.",472,N],[12,"promoted","","The index for promoted globals within their function's `Mir`.",472,N],[3,"Pointer","","Pointer is generic over the type that represents a reference to Allocations, thus making it possible for the most convenient representation to be used in each context.",N,N],[12,"alloc_id","","",473,N],[12,"offset","","",473,N],[3,"AllocId","","",N,N],[12,"0","","",474,N],[3,"AllocDecodingState","","",N,N],[12,"decoding_state","","",475,N],[12,"data_offsets","","",475,N],[3,"AllocDecodingSession","","",N,N],[12,"state","","",476,N],[12,"session_id","","",476,N],[3,"AllocMap","","",N,N],[12,"id_to_type","","Lets you know what an AllocId refers to",477,N],[12,"type_interner","","Used to ensure that functions and statics only get one associated AllocId",477,N],[12,"next_id","","The AllocId to assign to the next requested id. Always incremented, never gets smaller.",477,N],[3,"Allocation","","",N,N],[12,"bytes","","The actual bytes of the allocation. Note that the bytes of a pointer represent the offset of the pointer",478,N],[12,"relocations","","Maps from byte addresses to allocations. Only the first byte of a pointer is inserted into the map; i.e., every entry in this map applies to `pointer_size` consecutive bytes starting at the given offset.",478,N],[12,"undef_mask","","Denotes undefined memory. Reading from undefined memory is forbidden in miri",478,N],[12,"align","","The alignment of the allocation to detect unaligned reads.",478,N],[12,"mutability","","Whether the allocation is mutable. Also used by codegen to determine if a static should be put into mutable memory, which happens for `static mut` and `static` with interior mutability.",478,N],[3,"Relocations","","",N,N],[12,"0","","",479,N],[3,"UndefMask","","",N,N],[12,"blocks","","",480,N],[12,"len","","",480,N],[4,"EvalErrorKind","","",N,N],[13,"MachineError","","This variant is used by machines to signal their own errors that do not match an existing variant",481,N],[13,"FunctionAbiMismatch","","",481,N],[13,"FunctionArgMismatch","","",481,N],[13,"FunctionArgCountMismatch","","",481,N],[13,"NoMirFor","","",481,N],[13,"UnterminatedCString","","",481,N],[13,"DanglingPointerDeref","","",481,N],[13,"DoubleFree","","",481,N],[13,"InvalidMemoryAccess","","",481,N],[13,"InvalidFunctionPointer","","",481,N],[13,"InvalidBool","","",481,N],[13,"InvalidDiscriminant","","",481,N],[13,"PointerOutOfBounds","","",481,N],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",481,N],[12,"access","","",481,N],[12,"allocation_size","","",481,N],[13,"InvalidNullPointerUsage","rustc::mir::interpret","",481,N],[13,"ReadPointerAsBytes","","",481,N],[13,"ReadBytesAsPointer","","",481,N],[13,"ReadForeignStatic","","",481,N],[13,"InvalidPointerMath","","",481,N],[13,"ReadUndefBytes","","",481,N],[13,"DeadLocal","","",481,N],[13,"InvalidBoolOp","","",481,N],[13,"Unimplemented","","",481,N],[13,"DerefFunctionPointer","","",481,N],[13,"ExecuteMemory","","",481,N],[13,"BoundsCheck","","",481,N],[12,"len","rustc::mir::interpret::EvalErrorKind","",481,N],[12,"index","","",481,N],[13,"Overflow","rustc::mir::interpret","",481,N],[13,"OverflowNeg","","",481,N],[13,"DivisionByZero","","",481,N],[13,"RemainderByZero","","",481,N],[13,"Intrinsic","","",481,N],[13,"InvalidChar","","",481,N],[13,"StackFrameLimitReached","","",481,N],[13,"OutOfTls","","",481,N],[13,"TlsOutOfBounds","","",481,N],[13,"AbiViolation","","",481,N],[13,"AlignmentCheckFailed","","",481,N],[12,"required","rustc::mir::interpret::EvalErrorKind","",481,N],[12,"has","","",481,N],[13,"MemoryLockViolation","rustc::mir::interpret","",481,N],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",481,N],[12,"len","","",481,N],[12,"frame","","",481,N],[12,"access","","",481,N],[12,"lock","","",481,N],[13,"MemoryAcquireConflict","rustc::mir::interpret","",481,N],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",481,N],[12,"len","","",481,N],[12,"kind","","",481,N],[12,"lock","","",481,N],[13,"InvalidMemoryLockRelease","rustc::mir::interpret","",481,N],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",481,N],[12,"len","","",481,N],[12,"frame","","",481,N],[12,"lock","","",481,N],[13,"DeallocatedLockedMemory","rustc::mir::interpret","",481,N],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",481,N],[12,"lock","","",481,N],[13,"ValidationFailure","rustc::mir::interpret","",481,N],[13,"CalledClosureAsFunction","","",481,N],[13,"VtableForArgumentlessMethod","","",481,N],[13,"ModifiedConstantMemory","","",481,N],[13,"AssumptionNotHeld","","",481,N],[13,"InlineAsm","","",481,N],[13,"TypeNotPrimitive","","",481,N],[13,"ReallocatedWrongMemoryKind","","",481,N],[13,"DeallocatedWrongMemoryKind","","",481,N],[13,"ReallocateNonBasePtr","","",481,N],[13,"DeallocateNonBasePtr","","",481,N],[13,"IncorrectAllocationInformation","","",481,N],[13,"Layout","","",481,N],[13,"HeapAllocZeroBytes","","",481,N],[13,"HeapAllocNonPowerOfTwoAlignment","","",481,N],[13,"Unreachable","","",481,N],[13,"Panic","","",481,N],[12,"msg","rustc::mir::interpret::EvalErrorKind","",481,N],[12,"line","","",481,N],[12,"col","","",481,N],[12,"file","","",481,N],[13,"ReadFromReturnPointer","rustc::mir::interpret","",481,N],[13,"PathNotFound","","",481,N],[13,"UnimplementedTraitSelection","","",481,N],[13,"TypeckError","","Abort in case type errors are reached",481,N],[13,"TooGeneric","","Resolution can fail if we are in a too generic context",481,N],[13,"CheckMatchError","","",481,N],[13,"ReferencedConstant","","Cannot compute this constant because it depends on another one which already produced an error",481,N],[13,"GeneratorResumedAfterReturn","","",481,N],[13,"GeneratorResumedAfterPanic","","",481,N],[13,"InfiniteLoop","","",481,N],[4,"Scalar","","A `Scalar` represents an immediate, primitive value existing outside of a `memory::Allocation`. It is in many ways like a small chunk of a `Allocation`, up to 8 bytes in size. Like a range of bytes in an `Allocation`, a `Scalar` can either represent the raw bytes of a simple value or a pointer into another `Allocation`",N,N],[13,"Bits","","The raw bytes of a simple value.",482,N],[12,"size","rustc::mir::interpret::Scalar","The first `size` bytes are the value. Do not try to read less or more bytes that that. The remaining bytes must be 0.",482,N],[12,"bits","","",482,N],[13,"Ptr","rustc::mir::interpret","A pointer into an `Allocation`. An `Allocation` in the `memory` module has a list of relocations, but a `Scalar` is only large enough to contain one, so we just represent the relocation and its associated offset together as a `Pointer` here.",482,N],[4,"ConstValue","","Represents a constant value in Rust. Scalar and ScalarPair are optimizations which matches the LocalValue optimizations for easy conversions between Value and ConstValue.",N,N],[13,"Unevaluated","","Never returned from the `const_eval` query, but the HIR contains these frequently in order to allow HIR creation to happen for everything before needing to be able to run constant evaluation",483,N],[13,"Scalar","","Used only for types with layout::abi::Scalar ABI and ZSTs",483,N],[13,"ScalarPair","","Used only for types with layout::abi::ScalarPair",483,N],[13,"ByRef","","Used only for the remaining cases. An allocation + offset into the allocation. Invariant: The AllocId matches the allocation.",483,N],[4,"ScalarMaybeUndef","","",N,N],[13,"Scalar","","",484,N],[13,"Undef","","",484,N],[4,"Lock","","",N,N],[13,"NoLock","","",485,N],[13,"WriteLock","","",485,N],[13,"ReadLock","","This should never be empty -- that would be a read